<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'de', version '4.3'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['actionsmenu'] = 'Aktionenmenü';
$string['add'] = 'Eintrag hinzufügen';
$string['addcomment'] = 'Kommentar hinzufügen';
$string['addedby'] = 'Hinzugefügt von';
$string['addentries'] = 'Einträge hinzufügen';
$string['addtemplate'] = 'Vorlage für Einträge hinzufügen';
$string['advancedsearch'] = 'Erweiterte Suche';
$string['allowcomments'] = 'Kommentare';
$string['alttext'] = 'Alternativer Text';
$string['approvalstatus'] = 'Prüfstatus';
$string['approve'] = 'Zulassen';
$string['approved'] = 'Bestätigt';
$string['areacontent'] = 'Felder';
$string['ascending'] = 'Aufsteigend';
$string['asearchtemplate'] = 'Vorlage zur erweiterten Suche';
$string['atmaxentry'] = 'Sie haben die Höchstzahl zulässiger Einträge erreicht!';
$string['authorfirstname'] = 'Vorname';
$string['authorlastname'] = 'Nachname';
$string['autogenallforms'] = 'Alle Basisvorlagen anlegen';
$string['autolinkurl'] = 'URL automatisch verlinken';
$string['availablefromdate'] = 'Verfügbar ab';
$string['availabletags'] = 'Verfügbare Elemente';
$string['availabletags_help'] = 'Die Elemente sind Platzhalter in einer Vorlage, die durch Daten oder Icons (z.B. das Icon zum Bearbeiten) ersetzt werden, sobald Einträge in der Datenbank aufgelistet werden.

Nutzerdefinierte Felder haben das Format [[feldname]]. Alle anderen Elemente haben das Format ##tag##.

Nur die Elemente, die unter \'Verfügbare Elemente\' aufgeführt sind, können in der Vorlage verwendet werden.';
$string['availabletodate'] = 'Verfügbar bis';
$string['availabletodatevalidation'] = 'Das Datum \'Verfügbar bis\' kann nicht vor dem Datum \'Verfügbar ab\' liegen.';
$string['blank'] = 'Leer';
$string['buttons'] = 'Aktionen';
$string['bynameondate'] = 'von {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} endet';
$string['calendarstart'] = '{$a} beginnt';
$string['cancel'] = 'Abbrechen';
$string['cannotaccesspresentsother'] = 'Sie können nicht auf die Vorlagen anderer Nutzer/innen zugreifen.';
$string['cannotadd'] = 'Einträge können nicht hinzugefügt werden!';
$string['cannotapplypreset'] = 'Fehler beim Anwenden der Vorlage';
$string['cannotdeletepreset'] = 'Fehler beim Löschen der Vorlage';
$string['cannotoverwritepreset'] = 'Fehler beim Überschreiben der Vorlage';
$string['cannotunziptopreset'] = 'Fehler beim Entpacken im Vorlagenverzeichnis';
$string['checkbox'] = 'Checkboxen';
$string['chooseexportfields'] = 'Felder für Export auswählen';
$string['chooseexportformat'] = 'Exportformat auswählen';
$string['chooseorupload'] = 'Datei wählen';
$string['choosepreset'] = 'Vorlagendatei';
$string['closebeforeopen'] = 'Das Enddatum kann nicht vor dem Startdatum liegen.';
$string['columns'] = 'Spalten';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentar gelöscht';
$string['commentempty'] = 'Kommentar war leer';
$string['comments'] = 'Kommentare';
$string['commentsaved'] = 'Kommentare gespeichert';
$string['commentsn'] = '{$a} Kommentare';
$string['commentsoff'] = 'Kommentare sind nicht aktiviert';
$string['completiondetail:entries'] = 'Einträge hinzufügen: {$a}';
$string['completionentries'] = 'Einträge notwendig';
$string['completionentriescount'] = 'Einträge hinzufügen';
$string['completionentriesdesc'] = 'Minimale Anzahl von erforderlichen Einträgen: {$a}';
$string['configenablerssfeeds'] = 'Mit dieser Funktion aktivieren Sie RSS-Feeds für alle Datenbanken. Nach der Aktivierung an dieser Stelle ist zusätzlich die Aktivierung in jeder einzelnen Datenbank innerhalb der Kursräume erforderlich.';
$string['confirmdeletefield'] = 'Möchten Sie dieses Feld in der Datenbank wirklich löschen?';
$string['confirmdeleterecord'] = 'Möchten Sie diesen Datensatz in der Datenbank wirklich löschen?';
$string['confirmdeleterecords'] = 'Möchten Sie diese Einträge wirklich löschen?';
$string['createactivity'] = 'Erstellen Sie Ihre eigenen Felder, um Daten zu sammeln. Sie können auch einen Vorlagensatz verwenden, die bereits Felder enthält.';
$string['createfields'] = 'Erstellen Sie Ihre eigenen Felder, um verschiedene Datentypen zu sammeln.';
$string['createtemplates'] = 'Vorlagen definieren die Schnittstelle Ihrer Aktivität. Sobald Sie Felder erstellen, werden die Vorlagen automatisch erstellt. Alternativ können Sie auch einen Vorlagensatz verwenden, der bereits Felder und Vorlagen enthält.';
$string['csstemplate'] = 'Nutzerdefiniertes CSS';
$string['csvfailed'] = 'Aus der CSV-Datei konnten keine Daten gelesen werden';
$string['csvfile'] = 'CSV oder ZIP, das eine CSV-Datei enthält';
$string['csvimport'] = 'CSV-Dateiimport';
$string['csvimport_help'] = 'Daten können über eine CSV-Datei importiert werden, wobei die erste Zeile eine Liste von Feldnamen enthalten muss, gefolgt von den Daten mit jeweils einem Datensatz pro Zeile.';
$string['csvwithselecteddelimiter'] = '<abbr title="Kommagetrennte Werte">CSV</abbr>';
$string['data:addinstance'] = 'Neue Datenbank hinzufügen';
$string['data:approve'] = 'Einträge freigeben oder sperren';
$string['data:comment'] = 'Kommentare schreiben';
$string['data:exportallentries'] = 'Alle Datenbankeinträge exportieren';
$string['data:exportentry'] = 'Datenbankeintrag exportieren';
$string['data:exportownentry'] = 'Eigenen Datenbankeintrag exportieren';
$string['data:exportuserinfo'] = 'Nutzerinformationen exportieren';
$string['data:managecomments'] = 'Kommentare verwalten';
$string['data:manageentries'] = 'Einträge verwalten';
$string['data:managetemplates'] = 'Vorlagen verwalten';
$string['data:manageuserpresets'] = 'Vorlagensätze verwalten';
$string['data:rate'] = 'Einträge bewerten';
$string['data:readentry'] = 'Einträge lesen';
$string['data:view'] = 'Datenbankaktivität anzeigen';
$string['data:viewallratings'] = 'Alle Einzelwertungen anzeigen';
$string['data:viewalluserpresets'] = 'Alle Vorlagensätze anzeigen';
$string['data:viewanyrating'] = 'Alle Gesamtwertungen anzeigen';
$string['data:viewentry'] = 'Einträge anzeigen';
$string['data:viewrating'] = 'Eigene Gesamtwertung anzeigen';
$string['data:writeentry'] = 'Einträge schreiben';
$string['date'] = 'Datum';
$string['dateentered'] = 'Datum eingetragen';
$string['datemodified'] = 'Zuletzt bearbeitet';
$string['defaultfielddelimiter'] = '(Vorgabe: Komma)';
$string['defaultfieldenclosure'] = '(Vorgabe: kein Zeichen)';
$string['defaultsortfield'] = 'Standard-Sortierfeld';
$string['delcheck'] = 'Checkbox zum Löschen (Bulk)';
$string['delete'] = 'Löschen';
$string['deleteallentries'] = 'Alle Einträge löschen';
$string['deletecomment'] = 'Möchten Sie diesen Kommentar wirklich löschen?';
$string['deleteconfirm'] = 'Vorlagensatz {$a} löschen?';
$string['deleted'] = 'gelöscht';
$string['deleteentry'] = 'Eintrag löschen';
$string['deletefield'] = 'Feld löschen';
$string['deletenotenrolled'] = 'Einträge von abgemeldeten Nutzer/innen löschen';
$string['deletewarning'] = 'Das Löschen des Vorlagensatzes entfernt diesen aus der Liste der verfügbaren Vorlagensätze in allen Kursen';
$string['descending'] = 'Absteigend';
$string['directorynotapreset'] = '{$a->directory} ist kein Vorlagensatz. Fehlende Dateien: {$a->missing_files}';
$string['disapprove'] = 'Eintrag nicht freigegeben';
$string['download'] = 'Herunterladen';
$string['edit'] = 'Bearbeiten';
$string['editcomment'] = 'Kommentar bearbeiten';
$string['editentry'] = 'Eintrag bearbeiten';
$string['editfield'] = 'Feld bearbeiten';
$string['editordisable'] = 'Editor ausschalten';
$string['editorenable'] = 'Code-Editor einschalten';
$string['editpreset'] = 'Vorlagensatz bearbeiten';
$string['emptyadd'] = 'Eine Vorlage für das Eintragen neuer Daten ist noch nicht vorhanden. Es wird ein Basisformular erstellt...';
$string['emptyaddform'] = 'Sie haben keine Einträge vorgenommen!';
$string['emptypresetname'] = 'Vorlagenname oder -datei kann nicht leer sein';
$string['enabletemplateeditorcheck'] = 'Möchten Sie den Bearbeitungsmodus wirklich aktivieren? Dies könnte dazu führen, dass Inhalte beim Speichern der Vorlage verändert werden.';
$string['entries'] = 'Einträge';
$string['entrieslefttoadd'] = 'Sie müssen {$a->entriesleft} weitere Einträge vornehmen, um diese Aktivität abzuschließen.';
$string['entrieslefttoaddtoview'] = 'Sie müssen {$a->entrieslefttoview} weitere Einträge vornehmen, bevor Sie Beiträge von anderen Teilnehmer/innen sehen können.';
$string['entry'] = 'Eintrag';
$string['entrysaved'] = 'Ihr Eintrag wurde gespeichert';
$string['errordatafilenotfound'] = 'Die Datei konnte nicht importiert werden. Akzeptierte Dateitypen sind CSV oder ZIP, das eine CSV-Datei in dem Format enthält, das zum Exportieren von Einträgen verwendet wird.';
$string['errormustbeteacher'] = 'Diese Seite können nur Trainer/innen verwenden!';
$string['errormustsupplyvalue'] = 'Sie müssen hier einen Wert eintragen.';
$string['errorpresetexists'] = 'Es gibt bereits einen Vorlagensatz mit diesem Namen.';
$string['errorpresetexistsbutnotoverwrite'] = 'Es gibt bereits einen Vorlagensatz mit diesem Namen. Wählen Sie einen anderen Namen.';
$string['errorpresetnotfound'] = 'Vorlagensatz mit Namen {$a} nicht gefunden';
$string['eventfieldcreated'] = 'Feld angelegt';
$string['eventfielddeleted'] = 'Feld gelöscht';
$string['eventfieldupdated'] = 'Feld aktualisiert';
$string['eventrecordcreated'] = 'Datensatz angelegt';
$string['eventrecorddeleted'] = 'Datensatz gelöscht';
$string['eventrecordupdated'] = 'Datensatz aktualisiert';
$string['eventtemplateupdated'] = 'Vorlage aktualisiert';
$string['eventtemplateviewed'] = 'Vorlagen angezeigt';
$string['example'] = 'Datenbankbeispiel';
$string['excel'] = 'Excel';
$string['expired'] = 'Die Aktivität wurde am {$a} abgeschlossen und ist nicht mehr verfügbar.';
$string['export'] = 'Export';
$string['exportaszip'] = 'Export als ZIP-Datei';
$string['exportaszip_help'] = 'Mit dem Export als ZIP-Datei können Sie einen Vorlagensatz herunterladen, der Felder und Vorlagen enthält. Die ZIP-Datei kann in einem anderen Kurs wieder importiert werden.';
$string['exportedtozip'] = 'In eine temporäre ZIP-Datei exportiert...';
$string['exportentries'] = 'Einträge exportieren';
$string['exportformat'] = 'Exportformat';
$string['exportoptions'] = 'Exportoptionen';
$string['exportownentries'] = 'Nur eigene Einträge exportieren? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Vorlagensatz exportieren';
$string['failedpresetdelete'] = 'Fehler beim Löschen des Vorlagensatzes';
$string['fieldadded'] = 'Feld hinzugefügt';
$string['fieldallowautolink'] = 'Autolink erlauben';
$string['fielddeleted'] = 'Feld gelöscht';
$string['fielddelimiter'] = 'Feldtrennzeichen';
$string['fielddescription'] = 'Feldbeschreibung';
$string['fieldenclosure'] = 'Feldbegrenzung';
$string['fieldheight'] = 'Höhe';
$string['fieldheightlistview'] = 'Höhe in Listenansicht (in Pixel)';
$string['fieldheightsingleview'] = 'Höhe in Einzelansicht (in Pixel)';
$string['fieldids'] = 'Feldnummern';
$string['fieldmappings'] = 'Feldzuordnungen';
$string['fieldmappings_help'] = 'Dieses Menü erlaubt Ihnen, die Daten einer bestehenden Datenbank zu erhalten. Um die Daten in einem Feld zu behalten, müssen Sie das alte Feld einem neuen Feld zuordnen ("mappen"), in dem die Daten dann erscheinen. Felder können dabei auch leer gelassen werden.  Jedes alte Feld, das keinem neuen Feld zugeordnet ist, geht verloren und die enthaltenen Daten werden gelöscht.
Sie können nur Felder gleichen Typs einander zuordnen, sodass jedes Dropdown-Menü unterschiedlich aussieht. Versuchen Sie bitte auch nicht, ein altes Feld mehr als einem neuen Feld zuzuordnen.';
$string['fieldname'] = 'Feldname';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Die folgenden Felder in Ihrer Datei sind in der Datenbank nicht bekannt: {$a}';
$string['fieldoptions'] = 'Optionen (eine pro Zeile)';
$string['fields'] = 'Felder';
$string['fieldshelp'] = 'Erstellen Sie Felder, um verschiedene Arten von Daten zu sammeln. Felder definieren die Struktur der Einträge in Ihrer Datenbank.';
$string['fieldsinformationtags'] = 'Feldinformation';
$string['fieldsnavigation'] = 'Felder Tertiärnavigation';
$string['fieldtagdescription'] = '{$a} Beschreibung';
$string['fieldtagid'] = '{$a} ID';
$string['fieldtagname'] = '{$a} Name';
$string['fieldupdated'] = 'Feld wurde aktualisiert';
$string['fieldwidth'] = 'Breite';
$string['fieldwidthlistview'] = 'Breite in Listenansicht (in Pixel)';
$string['fieldwidthsingleview'] = 'Breite in Einzelansicht (in Pixel)';
$string['file'] = 'Datei';
$string['fileencoding'] = 'Encoding';
$string['filesnotgenerated'] = 'Es wurden nicht alle Dateien erzeugt: {$a}';
$string['filtername'] = 'Autoverlinkung zur Datenbank';
$string['footer'] = 'Fußzeile';
$string['forcelinkname'] = 'Vorgegebener Anzeigename für den Link';
$string['foundnorecords'] = 'Keine Einträge gefunden. <a href="{$a->reseturl}">Filter zurücksetzen</a>';
$string['foundrecords'] = 'Einträge gefunden: {$a->num} von {$a->max}. <a href="{$a->reseturl}">Filter zurücksetzen</a>';
$string['fromfile'] = 'Import aus ZIP-Datei';
$string['fromfile_help'] = 'Mit dem Import aus einer ZIP-Datei können Sie einen Vorlagensatz hochladen, der Felder Vorlagen enthält.';
$string['generateerror'] = 'Mehrere Dateien wurden nicht angelegt!';
$string['header'] = 'Kopfzeile';
$string['headeraddtemplate'] = 'Formular zum Anlegen oder Bearbeiten von Einträge erstellen';
$string['headerasearchtemplate'] = 'Formular zur erweiterten Suche erstellen';
$string['headercsstemplate'] = 'Nutzerdefiniertes CSS zu den Vorlagen hinzufügen';
$string['headerjstemplate'] = 'Nutzerdefiniertes JavaScript für Vorlagen hinzufügen';
$string['headerlisttemplate'] = 'Darstellung der Listenansicht definieren';
$string['headerrsstemplate'] = 'Darstellung der Einträge in RSS Feeds definieren';
$string['headersingletemplate'] = 'Darstellung der Einzelansicht definieren';
$string['id'] = 'Eintrags-ID';
$string['importandapply'] = 'Vorlagensatz importieren und anwenden';
$string['importapreset'] = 'Vorlagensatz importieren';
$string['importentries'] = 'Einträge importieren';
$string['importpreset'] = 'Vorlagensatz importieren';
$string['importpreset_desc'] = 'Der Vorlagensatz wird für diese Aktivität angewendet, wodurch Felder und Vorlagen erstellt werden. Das wird nicht in der Liste der Vorlagensätze angezeigt.';
$string['importpresetmissingcapability'] = 'Sie haben nicht das Recht, einen Vorlagensatz zu importieren.';
$string['importsuccess'] = 'Vorlagensatz wurde  übernommen.';
$string['includeapproval'] = 'Bestätigungsstatus einfügen';
$string['includefiles'] = 'Dateien in den Export einbeziehen';
$string['includetags'] = 'Tags einbeziehen';
$string['includetime'] = 'Zeitpunkt hinzugefügt/geändert einfügen';
$string['includeuserdetails'] = 'Nutzerdetails einfügen';
$string['indicator:cognitivedepth'] = 'Datenbank kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die eine Person in einer Datenbankaktivität erreicht hat.';
$string['indicator:cognitivedepthdef'] = 'Datenbank kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Die Person hat diesen Prozentsatz des kognitiven Engagements erreicht, das die Datenbankaktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Ansicht, Ansicht, Beiträge).';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Datenbank sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die eine Person in einer Datenbankaktivität erreicht hat.';
$string['indicator:socialbreadthdef'] = 'Datenbank sozial';
$string['indicator:socialbreadthdef_help'] = 'Die Person hat diesen Prozentsatz des soziale Engagements erreicht, das die Datenbankaktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Teilnahme, Teilnahme allein).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'Weitere Einträge sind erforderlich, um die Datenbank einzusehen.';
$string['intro'] = 'Beschreibung';
$string['invalidaccess'] = 'Seite wurde nicht richtig aufgerufen';
$string['invalidfieldid'] = 'Feld-ID ist falsch';
$string['invalidfieldname'] = 'Wählen Sie bitte einen anderen Namen für dieses Feld.';
$string['invalidfieldtype'] = 'Ungültiger Feldtyp
';
$string['invalidid'] = 'Falsche Daten-ID';
$string['invalidpreset'] = '{$a} ist kein Vorlagensatz.';
$string['invalidrecord'] = 'Falscher Eintrag';
$string['invalidurl'] = 'Die eingegebene URL ist nicht gültig.';
$string['jstemplate'] = 'Nutzerdefiniertes JavaScript';
$string['latitude'] = 'Breitengrad';
$string['latlong'] = 'Koordinaten';
$string['latlongboth'] = 'Längen- und Breitengrad müssen eingetragen werden.';
$string['latlongdownloadallhint'] = 'Download aller Einträge als KML';
$string['latlongkmllabelling'] = 'Wie sollen Ziele in KML-Dateien bezeichnet werden? (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Links zum Anzeigen geografischer Daten';
$string['latlongotherfields'] = 'Weitere Felder';
$string['list'] = 'Listenansicht';
$string['listtemplate'] = 'Vorlage für Listenansicht';
$string['listview'] = 'Listenansicht';
$string['longitude'] = 'Längengrad';
$string['manageapproved'] = 'Änderung von freigegebenen Einträgen erlauben';
$string['manageapproved_help'] = 'Diese Option legt fest, dass bereits freigegebene Einträge weiter bearbeitet oder gelöscht werden dürfen. Bearbeitete Einträge müssen erneut freigegeben werden.';
$string['managefields'] = 'Felder verwalten';
$string['mapexistingfield'] = 'Verknüpfen mit {$a}';
$string['mapnewfield'] = 'Neues Feld anlegen';
$string['mapping:applypresets'] = 'Vorlagensatz übernehmen';
$string['mapping:dialogtitle:usepreset'] = 'Vorlagensatz {$a} übernehmen?';
$string['mapping:fieldstocreate'] = 'Felder, die angelegt werden: {$a}';
$string['mapping:fieldstodelete'] = 'Existierende Felder, die gelöscht werden: {$a}';
$string['mapping:mapfields'] = 'Felder zuordnen';
$string['mapping:warningmessagedelete'] = 'Wenn zu löschende Felder vom gleichen Typ sind wie neue Felder im Vorlagensatz, können Sie möglicherweise Felder neu zuordnen.';
$string['mapping:warningmessagedeleteandcreate'] = 'Wenn zu löschende Felder vom gleichen Typ sind wie neu zu erstellende Felder, können Sie möglicherweise Felder neu zuordnen.';
$string['mappingwarning'] = 'Alle alten Felder, die keinem neuen Feld zugeordnet wurden, werden zusammen mit allen Daten aus diesen Feldern gelöscht.';
$string['maxentries'] = 'Maximal mögliche Einträge';
$string['maxentries_help'] = 'Die maximale Zahl der Einträge begrenzt die Einträge, die ein/e Teilnehmer/in bei dieser Aktivität vornehmen darf.';
$string['maxsize'] = 'Größe (max)';
$string['menu'] = 'Menü';
$string['menuchoose'] = 'Auswählen ...';
$string['missingdata'] = 'Daten-ID oder Datenobjekt müssen zur Feldklasse passen';
$string['missingfield'] = 'Programmierfehler: Sie müssen Feld und Daten angeben, wenn Sie eine Feldklasse definieren.';
$string['missingfieldtype'] = 'Feldtyp für {$a->name} nicht gefunden';
$string['missingfieldtypeimport'] = 'Die folgenden Felder wurden nicht importiert, da die zugehörigen Feldtypen nicht installiert sind:';
$string['missingfieldtypes'] = 'Für folgende Felder sind die zugehörigen Feldtypen nicht installiert. Die Felder werden nicht in das Formular "Eintrag hinzufügen" einbezogen. Sie müssen die Vorlage "Eintrag hinzufügen" prüfen und einige Feldnamen entfernen.';
$string['modulename'] = 'Datenbank';
$string['modulename_help'] = 'Die Datenbank ermöglicht es den Teilnehmer/innen, gemeinsam eine Sammlung von Einträgen zu erstellen, zu pflegen und zu durchsuchen.

Die Struktur der Einträge wird über unterschiedliche Feldtypen wie kurze Texte , Dropdown-Menü, Textbereich, URL, Bild oder Datei definiert. In Vorlagen wird festgelegt, wie die Listenansicht (Übersicht) und die Detailansicht angezeigt werden soll.

Als Trainer/in können Sie Einträge kommentieren und bewerten. Sie können den Teilnehmer/innen auch erlauben, ihrerseits Einträge zu bewerten und zu kommentieren (Peer-Evaluation). Bewertungen können zu einer Gesamtnote zusammengefasst werden, die dann festgehalten wird.

Wenn der Filter für automatische Datenbankverknüpfung aktiviert ist, werden alle Einträge der Datenbank automatisch dort verknüpft, wo Wörter oder Sätze im Kurs erscheinen.

Sie können die Datenbank verwenden,

* um eine gemeinsame Sammlung von Links, Büchern, Buchbesprechungen, Zeitschriftenreferenzen usw. zu erstellen
* um von Teilnehmer/innen erstellte Fotos, Poster, Websites oder Gedichte zu sammeln und mit Peer-Kommentare und -Rezensionen zu versehen.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Datenbanken';
$string['more'] = 'Einzelansicht';
$string['moreurl'] = 'Weitere URL';
$string['movezipfailed'] = 'Kann ZIP nicht bewegen';
$string['multientry'] = 'Wiederholter Eintrag';
$string['multimenu'] = 'Menü (Mehrfachauswahl)';
$string['multipletags'] = 'Elemente mehrfach gefunden! Keine Vorlage gespeichert.';
$string['newentry'] = 'Neuer Eintrag';
$string['newfield'] = 'Neues Feld erstellen';
$string['newfield_help'] = 'Ein Feld ermöglicht die Eingabe von Daten. Jeder Eintrag in einer Datenbankaktivität kann mehrere Felder verschiedener Typen enthalten, z.B. ein Datumsfeld zur Angabe von Tag, Monat und Jahr, ein Bildfeld zum Hochladen einer Bilddatei oder ein Kontrollkästchen zur Auswahl einer oder mehrerer Optionen.

Jedes Feld muss einen eindeutigen Feldnamen haben. Die Feldbeschreibung ist optional.';
$string['noaccess'] = 'Sie haben keinen Zugriff auf diese Seite.';
$string['nodefinedfields'] = 'Neuer Vorlagensatz besitzt keine definierten Felder!';
$string['nofieldcontent'] = 'Feldinhalt nicht gefunden';
$string['nofieldindatabase'] = 'In dieser Datenbank sind noch keine Felder definiert.';
$string['nofields'] = 'Keine Felder';
$string['nolisttemplate'] = 'Die Listenansicht wurde noch nicht definiert.';
$string['nomatch'] = 'Keine passenden Einträge gefunden';
$string['nomaximum'] = 'Keine Höchstzahl';
$string['nopreviewavailable'] = 'Für {$a} ist keine Vorschau verfügbar';
$string['norecords'] = 'Bisher keine Einträge';
$string['nosingletemplate'] = 'Die Einzelansicht wurde noch nicht definiert.';
$string['notapproved'] = 'Freigabe ausstehend';
$string['notapprovederror'] = 'Der Eintrag ist noch nicht freigegeben.';
$string['notemplates'] = 'Keine Vorlagen';
$string['notinjectivemap'] = 'Keine injektive Abbildung';
$string['notopenyet'] = 'Die Aktivität ist nicht verfügbar bis {$a}.';
$string['number'] = 'Zahl';
$string['numberrssarticles'] = 'RSS Beiträge';
$string['numnotapproved'] = 'Wartend';
$string['numrecords'] = '{$a} Datensätze';
$string['ods'] = '<abbr title="OpenDocument Tabelle">ODS</abbr>&nbsp;(OpenDocument)';
$string['openafterclose'] = 'Das Enddatum kann nicht vor dem Startdatum liegen.';
$string['optionaldescription'] = 'Beschreibung (optional)';
$string['optionalfilename'] = 'Dateiname (optional)';
$string['other'] = 'Andere';
$string['otherfields'] = 'Alle weiteren Felder';
$string['overrwritedesc'] = 'Existierende Vorlage mit diesem Namen ersetzen und alle Inhalte überschreiben';
$string['overwrite'] = 'Überschreiben';
$string['overwritesettings'] = 'Bisherige Einträge überschreiben, z.B. Bewertungen, Kommentare';
$string['page-mod-data-x'] = 'Jede Datenbankseite';
$string['pagesize'] = 'Einträge pro Seite';
$string['participants'] = 'Teilnehmer/innen';
$string['picture'] = 'Bild';
$string['pleaseaddsome'] = 'Bitte erzeugen Sie ein Feld oder <a href="{$a}">wählen Sie einen Vorlagensatz</a>, um zu beginnen.';
$string['pluginadministration'] = 'Datenbank-Administration';
$string['pluginname'] = 'Datenbank';
$string['portfolionotfile'] = 'In ein Portfolio und nicht als Datei exportieren (nur csv und leap2a)';
$string['presetdeleted'] = 'Vorlagensatz gelöscht';
$string['presetinfo'] = 'Durch das Sichern als Vorlagensatz wird Ihre Datenbank-Gestaltung für die gesamte Moodle-Installation veröffentlicht. Andere Nutzer/innen können dann diesen Vorlagensatz für ihre Datenbank nutzen.';
$string['presetnotselected'] = 'Es ist keine Vorlagensatz ausgewählt.';
$string['presets'] = 'Vorlagensätze';
$string['presetshelp'] = 'Wählen Sie einen Vorlagensatz, der als Ausgangspunkt verwendet werden soll.';
$string['preview'] = 'Vorschau von {$a}';
$string['previewaction'] = 'Vorschau';
$string['privacy:metadata:commentpurpose'] = 'Kommentar zum Datenbankeintrag';
$string['privacy:metadata:data_content'] = 'Inhalt in einem Feld';
$string['privacy:metadata:data_content:content'] = 'Inhalt';
$string['privacy:metadata:data_content:content1'] = 'Zusätzlicher Inhalt 1';
$string['privacy:metadata:data_content:content2'] = 'Zusätzlicher Inhalt 2';
$string['privacy:metadata:data_content:content3'] = 'Zusätzlicher Inhalt 3';
$string['privacy:metadata:data_content:content4'] = 'Zusätzlicher Inhalt 4';
$string['privacy:metadata:data_content:fieldid'] = 'Felddefinitons-ID';
$string['privacy:metadata:data_records'] = 'Datensatz in der Datenbank';
$string['privacy:metadata:data_records:approved'] = 'Bestätigungsstatus';
$string['privacy:metadata:data_records:groupid'] = 'Gruppe';
$string['privacy:metadata:data_records:timecreated'] = 'Zeitpunkt, an dem Eintrag erstellt wurde';
$string['privacy:metadata:data_records:timemodified'] = 'Zeitpunkt, zu dem Eintrag verändert wurde';
$string['privacy:metadata:data_records:userid'] = 'Person, die den Eintrag erstellt hat';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Felder der Datenbankaktivität';
$string['privacy:metadata:filepurpose'] = 'Datei, die Datenbankeintrag zugeordnet wurde';
$string['privacy:metadata:ratingpurpose'] = 'Bewertung für Datenbankeintrag';
$string['privacy:metadata:tagpurpose'] = 'Tags für Datenbankeintrag';
$string['radiobutton'] = 'Einfachauswahl';
$string['recordapproved'] = 'Datensatz wurde angenommen';
$string['recorddeleted'] = 'Datensatz gelöscht';
$string['recorddisapproved'] = 'Eintrag nicht freigegeben';
$string['recordsnotsaved'] = 'Kein Eintrag wurde gespeichert. Prüfen Sie bitte das Format der hochgeladenen Datei.';
$string['recordssaved'] = 'Einträge gespeichert';
$string['removealldatatags'] = 'Alle Datenbank-Tags entfernen';
$string['requireapproval'] = 'Freigabe erforderlich';
$string['requireapproval_help'] = 'Einträge müssen von Trainer/innen erst freigegeben werden, bevor sie für alle angezeigt werden.';
$string['required'] = 'Notwendig';
$string['requiredentries'] = 'Erforderliche Einträge für den Abschluss (alt)';
$string['requiredentries_help'] = 'Bei Aktivierung wird eine Nachricht angezeigt, welche die erforderliche Anzahl von Beiträgen angibt, die zum Abschluss notwendig sind. Beachten Sie, dass dies nicht mit Akivitätsabschluss verbunden ist.

Für erforderliche Beiträge zum Akivitätabschluss sollte die neue Einstellung "Beiträge erforderlich" in den Einstellungen für Aktivitätsabschlüsse verwendet werden. Um diese Einstellung vollständig zu entfernen setzten Sie sie auf "Keine" und klicken auf "Änderungen speichern".
Bitte wählen Sie stattdessen "Beiträge erforderlich" in den Einstellungen für Akivitätsabschlüsse aus.';
$string['requiredentriestoview'] = 'Erforderliche Einträge vor der Ansicht aller Daten';
$string['requiredentriestoview_help'] = 'Der Wert legt die Anzahl der Einträge fest, die Teilnehmer/innen hinzufügen müssen, bevor sie Einträge anderer Teilnehmer/innen anzeigen können.

Dies ist nicht mit der Autoverlinkung für die Datenbank kompatibel.';
$string['requiredentrieswarning'] = 'Diese Einstellung wurde durch die Abschlussbedingung \'Einträge erforderlich\' ersetzt.';
$string['requiredfield'] = 'Pflichtfeld';
$string['resetalltemplates'] = 'Alle Vorlagen zurücksetzen';
$string['resetalltemplatesconfirm'] = 'Sie sind dabei, alle Vorlagen aus den aktuellen Vorlagensatz zu entfernen. Wenn Sie die Vorlagen später wiederherstellen möchten, müssen Sie den Vorlagensatz erneut auswählen.';
$string['resetalltemplatesconfirmtitle'] = 'Alle Vorlagen zurücksetzen?';
$string['resetsettings'] = 'Filter zurücksetzen';
$string['resettemplate'] = 'Momentane Vorlage zurücksetzen';
$string['resettemplateconfirm'] = '{$a} wird dauerhaft für Ihr aktuelles Preset entfernt.';
$string['resettemplateconfirmtitle'] = 'Vorlage zurücksetzen?';
$string['resizingimages'] = 'Vorschaubilder anpassen...';
$string['rows'] = 'Zeilen';
$string['rssglobaldisabled'] = 'Deaktiviert. Beachten Sie die Einstellungsseite für die Variablen.';
$string['rsstemplate'] = 'Vorlage für RSS-Feed';
$string['rsstitletemplate'] = 'Vorlage für RSS-Titelzeile';
$string['rsstype'] = 'RSS Feed für diese Aktivität';
$string['save'] = 'Speichern';
$string['saveandadd'] = 'Speichern und weitere hinzufügen';
$string['saveandview'] = 'Speichern und anzeigen';
$string['saveaspreset'] = 'Vorlagensatz für diese Website bereitstellen';
$string['saveaspreset_help'] = 'Die Option \'Als Vorlagensatz speichern\' veröffentlicht die Vorlagen und Felder als Vorlagensatz in einer Liste. Andere auf der Website können Ihren Vorlagensatz benutzen, wobei Sie jederzeit den Vorlagensatz wieder entfernen dürfen.';
$string['saveaspresetmissingcapability'] = 'Nutzer/in hat nicht die kein Recht, die Datenbank als Vorlagensatz zu speichern.';
$string['savedataaspreset'] = 'Alle Felder und Vorlagen speichern und als Vorlagensatz  auf der Website bereitstellen';
$string['savesettings'] = 'Einstellungen speichern';
$string['savesuccess'] = 'Vorlagensatz gespeichert. <a href="{$a->url}">Vorschau des Vorlagensatzes</a>';
$string['savetemplate'] = 'Vorlage speichern';
$string['search'] = 'Suche';
$string['search:activity'] = 'Datenbank - Aktivitätsinfo';
$string['search:entry'] = 'Datenbank - Einträge';
$string['searchresults'] = 'Einträge, die "{$a}" enthalten';
$string['selectedrequired'] = 'Gesamte Auswahl ist erforderlich';
$string['selectexportoptions'] = 'Exportoptionen auswählen';
$string['selectfields'] = 'Felder auswählen';
$string['showall'] = 'Alle Einträge anzeigen';
$string['showmore'] = 'Mehr anzeigen';
$string['single'] = 'Einzelansicht';
$string['singletemplate'] = 'Vorlage für Einzelansicht';
$string['singleview'] = 'Einzelansicht';
$string['startbuilding'] = 'Beginnen Sie, Ihre Aktivität zu erstellen';
$string['subplugintype_datafield'] = 'Datenbank-Feldtyp';
$string['subplugintype_datafield_plural'] = 'Datenbank-Feldtypen';
$string['subplugintype_datapreset'] = 'Vorlagensatz';
$string['subplugintype_datapreset_plural'] = 'Vorlagensätze';
$string['tagarea_data_records'] = 'Datensätze';
$string['tags'] = 'Tags';
$string['tagsdeleted'] = 'Datenbank-Tags wurden entfernt';
$string['teachersandstudents'] = '{$a->teachers} und {$a->students}';
$string['templatereset'] = 'Vorlagenrücksetzung';
$string['templateresetall'] = 'Zurücksetzen aller Vorlagen';
$string['templates'] = 'Vorlagen';
$string['templatesaved'] = 'Vorlage wurde gespeichert';
$string['templatesnavigation'] = 'Vorlagen Tertiärnavigation';
$string['text'] = 'Text';
$string['textarea'] = 'Textbereich';
$string['timeadded'] = 'Zeit erstellt';
$string['timemodified'] = 'Zuletzt geändert';
$string['todatabase'] = 'in diese Datenbank';
$string['type'] = 'Feld-Typ';
$string['undefinedprocessactionmethod'] = 'Im Vorlagensatz wurde keine Verarbeitungsmethode definiert für: "{$a}".';
$string['unknown'] = 'Unbekanntes Feld';
$string['unsupportedfields'] = 'Nichtunterstützte Felder';
$string['unsupportedfieldslist'] = 'Folgenden Felder können nicht exportiert werden:';
$string['updatefield'] = 'Bestehendes Feld aktualisieren';
$string['uploadfile'] = 'Datei hochladen';
$string['uploadrecords'] = 'Datensätze importieren';
$string['uploadrecords_help'] = 'Importieren Sie Einträge, die Sie aus einer anderen Datenbank exportiert haben, entweder über eine CSV-Datei oder eine ZIP-Datei mit einer CSV-Datei (sofern Dateien im Export enthalten sind).

Alternativ können Sie zum Erstellen einer CSV-Datei zum Importieren einen Eintrag zur Datenbank hinzufügen und ihn dann exportieren. Bearbeiten Sie die CSV-Datei, um weitere Einträge hinzuzufügen.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'In Suche einbeziehen';
$string['usepredefinedset'] = 'Vordefinierten Satz verwenden';
$string['usepreset'] = 'Vorlagensatz verwenden';
$string['usestandard'] = 'Vorlagensatz benutzen';
$string['usestandard_help'] = 'Um einen auf der gesamten Website verfügbaren Vorlagensatz zu benutzen, wählen Sie ihn aus der Liste aus. Wenn Sie selbst einen Vorlagensatz zur Liste hinzugefügt haben, können Sie ihn hier auch wieder löschen.';
$string['viewfromdate'] = 'Bearbeiten sperren ab';
$string['viewnavigation'] = 'Modus Tertiärnavigation anzeigen';
$string['viewtemplates'] = 'Vorlagen anzeigen';
$string['viewtodate'] = 'Bearbeiten sperren bis';
$string['viewtodatevalidation'] = 'Das Datum \'Bearbeiten sperren bis\' kann nicht vor dem Datum \'Bearbeiten sperren ab\' liegen.';
$string['wrongdataid'] = 'Falsche Daten-ID bereitgestellt';
