<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'zh_cn', version '4.3'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = '评估结束：';
$string['activitydate:assessmentsclosed'] = '评估结束：';
$string['activitydate:assessmentsopen'] = '公开评估：';
$string['activitydate:assessmentsopened'] = '公开评估：';
$string['activitydate:submissionsclose'] = '截止报名日期：';
$string['activitydate:submissionsclosed'] = '截止的意见书：';
$string['activitydate:submissionsopen'] = '公开意见书：';
$string['activitydate:submissionsopened'] = '公开的意见书：';
$string['aggregategrades'] = '重新计算成绩';
$string['aggregation'] = '成绩汇总';
$string['allocate'] = '分配提交';
$string['allocatedetails'] = '预计：{$a->expected}<br />已提交：{$a->submitted}<br />待分配：{$a->allocate}';
$string['allocation'] = '提交分配';
$string['allocationconfigured'] = '配置分配';
$string['allocationdone'] = '分配完成';
$string['allocationerror'] = '分配错误';
$string['allowedfiletypesforoverallfeedback'] = '反馈附件允许的文件类型';
$string['allowedfiletypesforoverallfeedback_help'] = '可以通过提供允许的文件类型列表来限制反馈附件文件类型。如果字段为空，则允许所有文件类型。';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = '提交附件允许的文件类型';
$string['allowedfiletypesforsubmission_help'] = '可以通过提供允许的文件类型列表来限制提交附件文件类型。如果字段为空，则允许所有文件类型。';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = '所有提交({$a})';
$string['alreadygraded'] = '已评分';
$string['areaconclusion'] = '总结文本';
$string['areainstructauthors'] = '提交说明';
$string['areainstructreviewers'] = '评价说明';
$string['areaoverallfeedbackattachment'] = '综合反馈附件';
$string['areaoverallfeedbackcontent'] = '综合反馈文本';
$string['areasubmissionattachment'] = '提交附件';
$string['areasubmissioncontent'] = '提交文本';
$string['assess'] = '评价';
$string['assessedexample'] = '已评价的示例提交';
$string['assessedsubmission'] = '已评价提交';
$string['assessingexample'] = '评价示例提交';
$string['assessingsubmission'] = '评价提交';
$string['assessment'] = '评价';
$string['assessmentby'] = '由<a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = '{$a} 的评价';
$string['assessmentbyyourself'] = '您的评价';
$string['assessmentdeleted'] = '已解除分配的评价';
$string['assessmentend'] = '评价截止日期';
$string['assessmentendbeforestart'] = '评价截止日期不能指定在评价开放日期之前';
$string['assessmentenddatetime'] = '评价截止日期：{$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a}（评价截止日期）';
$string['assessmentform'] = '评价表单';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">评价</a> of <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = '参考评价';
$string['assessmentreferenceconflict'] = '无法对您提供参考评价的示例提交进行评价。';
$string['assessmentreferenceneeded'] = '您必须评价这个示例提交，以提供参考评价。点击“继续”按钮来评价该提交。';
$string['assessments'] = '评价';
$string['assessmentsettings'] = '评价设置';
$string['assessmentstart'] = '评价开放日期';
$string['assessmentstartdatetime'] = '评价开放日期 {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a}（开放评价）';
$string['assessmentweight'] = '评价权重';
$string['assignedassessments'] = '要评价的提交';
$string['assignedassessmentsnone'] = '您没有分配要评价的提交';
$string['backtoeditform'] = '返回到编辑表单';
$string['byfullname'] = '由<a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = '由 {$a}';
$string['calculategradinggrades'] = '计算评价成绩';
$string['calculategradinggradesdetails'] = '预计：{$a->expected}<br />已计算：{$a->calculated}';
$string['calculatesubmissiongrades'] = '计算提交成绩';
$string['calculatesubmissiongradesdetails'] = '预计：{$a->expected}<br />已计算：{$a->calculated}';
$string['chooseuser'] = '选择用户…';
$string['clearaggregatedgrades'] = '清除所有汇总成绩';
$string['clearaggregatedgrades_help'] = '提交的汇总成绩及评价成绩将会被重置。您可以在成绩核定阶段再次从头开始重新计算这些成绩。';
$string['clearaggregatedgradesconfirm'] = '您确定要清除已计算的提交成绩和评价成绩？';
$string['clearassessments'] = '清除评价';
$string['clearassessments_help'] = '已计算的提交成绩和评价成绩将被重置。评价表单已填写的信息仍然保留，但是所有评价人必须再次打开评价表单并重新保存，以再次计算给定的成绩。';
$string['clearassessmentsconfirm'] = '您确定要清除所有评价成绩？清除后，您将不能独立恢复这些信息，评价人必须重新评价分配的提交。';
$string['conclusion'] = '总结';
$string['conclusion_help'] = '总结文本将在活动结束时显示给参与者。';
$string['configexamplesmode'] = '互动评价中范例评价的默认模式';
$string['configgrade'] = '互动评价默认的作业最高分';
$string['configgradedecimals'] = '显示成绩时小数点后默认显示的位数。';
$string['configgradinggrade'] = '互动评价评价默认的最高分';
$string['configmaxbytes'] = '网站所有互动评价默认的最大上传文件大小（受限于课程限制和其它本地设置）';
$string['configstrategy'] = '互动评价的默认评分策略';
$string['createsubmission'] = '添加提交';
$string['crontask'] = '后台处理互动评价模块';
$string['daysago'] = '{$a} 天以前';
$string['daysleft'] = '剩余 {$a} 天';
$string['daystoday'] = '今天';
$string['daystomorrow'] = '明天';
$string['daysyesterday'] = '昨天';
$string['deadlinesignored'] = '您不受时间限制';
$string['deletesubmission'] = '删除提交';
$string['editassessmentform'] = '编辑评价表单';
$string['editassessmentformstrategy'] = '编辑评价表单({$a})';
$string['editingassessmentform'] = '正在编辑评价表单';
$string['editingsubmission'] = '正在编辑提交';
$string['editsubmission'] = '编辑提交';
$string['err_multiplesubmissions'] = '在编辑此表单时，已保存了提交的另一个版本。不允许每个用户提交多个内容。';
$string['err_removegrademappings'] = '无法删除未使用的成绩映射';
$string['evaluategradeswait'] = '请耐心等待，正在核定评价、计算成绩。';
$string['evaluation'] = '成绩核定';
$string['evaluationmethod'] = '成绩核定方法';
$string['evaluationmethod_help'] = '成绩核定方法决定了如何计算评价成绩。如果您对结果不满意，您可以使用不同的设置反复重新计算成绩。';
$string['evaluationsettings'] = '成绩核定设置';
$string['eventassessableuploaded'] = '一个提交已经上传。';
$string['eventassessmentevaluated'] = '核定评价';
$string['eventassessmentevaluationsreset'] = '重置评价核定';
$string['eventassessmentreevaluated'] = '重新核定评价';
$string['eventphaseautomaticallyswitched'] = '阶段自动切换';
$string['eventphaseswitched'] = '切换阶段';
$string['eventsubmissionassessed'] = '评价提交';
$string['eventsubmissionassessmentsreset'] = '清除提交评价';
$string['eventsubmissioncreated'] = '创建提交';
$string['eventsubmissiondeleted'] = '删除提交';
$string['eventsubmissionreassessed'] = '重新评价提交';
$string['eventsubmissionupdated'] = '更新提交';
$string['eventsubmissionviewed'] = '查看提交';
$string['example'] = '范例提交';
$string['exampleadd'] = '添加范例提交';
$string['exampleassess'] = '评价范例提交';
$string['exampleassessments'] = '要评价的范例提交';
$string['exampleassesstask'] = '评价范例';
$string['exampleassesstaskdetails'] = '预计：{$a->expected}<br />已评价：{$a->assessed}';
$string['examplecomparing'] = '正在比较范例提交的评价';
$string['exampledelete'] = '删除范例';
$string['exampledeleteconfirm'] = '您确定要删除下面的范例提交吗?点击“继续”按钮删除该提交。';
$string['exampleedit'] = '编辑范例';
$string['exampleediting'] = '正在编辑范例';
$string['exampleneedassessed'] = '您必须首先评价所有范例提交';
$string['exampleneedsubmission'] = '您必须先提交您的作品并评价所有范例提交';
$string['examplesbeforeassessment'] = '范例在自己的提交之后可用，并且必须在同学间互评之前进行评价';
$string['examplesbeforesubmission'] = '范例必须在自己的提交之前被评价。';
$string['examplesmode'] = '范例评价模式';
$string['examplesubmissions'] = '范例提交';
$string['examplesvoluntary'] = '自愿评价范例提交';
$string['exportsubmission'] = '导出该页面';
$string['feedbackauthor'] = '给作者反馈';
$string['feedbackauthorattachment'] = '附件';
$string['feedbackby'] = '{$a}的反馈';
$string['feedbackreviewer'] = '给评价人反馈';
$string['feedbacksettings'] = '反馈';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = '给出的分数';
$string['grade_grading_name'] = '评价';
$string['grade_submission_name'] = '提交';
$string['gradecalculated'] = '已计算的提交成绩';
$string['gradedecimals'] = '成绩的小数位数';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = '成绩：{$a->received}/{$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (评价)';
$string['gradeitemsubmission'] = '{$a->workshopname} (提交)';
$string['gradeover'] = '覆盖提交成绩';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = '互动评价成绩报表';
$string['gradetopassgrading'] = '通过所需的评价成绩';
$string['gradetopasssubmission'] = '通过所需的提交成绩';
$string['gradinggrade'] = '评价成绩';
$string['gradinggrade_help'] = '此设置指定提交评价可获得的最高分。';
$string['gradinggradecalculated'] = '计算评价成绩';
$string['gradinggradeof'] = '评价({$a})的成绩';
$string['gradinggradeover'] = '覆盖评价成绩';
$string['gradingsettings'] = '评分设置';
$string['groupnoallowed'] = '您未被允许访问该互动评价中的任何组';
$string['iamsure'] = '是的，我确定';
$string['indicator:cognitivedepth'] = '互动评价活动认知深度';
$string['indicator:cognitivedepth_help'] = '这个指标是基于学生在 互动评价活动中所达到的认知深度。';
$string['indicator:cognitivedepthdef'] = '互动评价活动认知深度';
$string['indicator:cognitivedepthdef_help'] = '在此分析间隔内，参与者已达到互动评价活动提供的认知参与百分比(级别=未查看、查看、提交、查看反馈、评论反馈、查看反馈后重新提交)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = '互动评价活动认社会广度';
$string['indicator:socialbreadth_help'] = '这个指标是基于学生在 互动评价活动中所达到的社会广度。';
$string['indicator:socialbreadthdef'] = '互动评价活动认社会广度';
$string['indicator:socialbreadthdef_help'] = '在此分析间隔内，参与者达到了互动评价活动所提供的社会参与百分比(级别=没有参与，单独参与，和其他人一起参与)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = '信息';
$string['instructauthors'] = '提交说明';
$string['instructreviewers'] = '评价说明';
$string['introduction'] = '描述';
$string['latesubmissions'] = '迟的提交';
$string['latesubmissions_desc'] = '允许在截止日期后提交';
$string['latesubmissions_help'] = '如果启用，作者可以在提交截止日期之后或在评价阶段提交他们的作品。但迟交的作品不能编辑。';
$string['latesubmissionsallowed'] = '允许迟交';
$string['maxbytes'] = '最大提交附件大小';
$string['modulename'] = '互动评价';
$string['modulename_help'] = '互动评价活动模块可以收集、评价和对学生的工作进行同学间互评。学生可以提交任何数字内容(文件)，如文字处理文档或电子表格，还可以使用文本编辑器直接在字段中输入文本。提交的作品将使用教师定义的多标准评价表单进行评价。同学间互评和理解评价表单的过程，可由教师提供范例，连同参考评价一起预先练习。学生们有机会评价他们的一个或多个同学的提交。如果需要，提交和评价人可以是匿名的。学生在一次互动评价活动中获得两个成绩——提交的成绩和对同学提交评价的成绩。两个成绩都记录在成绩单上。';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = '互动评价';
$string['myassessments'] = '我的评价';
$string['mysubmission'] = '我的提交';
$string['nattachments'] = '提交附件的最大数量';
$string['noexamples'] = '此互动评价还没有范例';
$string['noexamplesformready'] = '在提供范例提交之前，您必须定义评价表单';
$string['nogradeyet'] = '还没有成绩';
$string['nosubmissionfound'] = '没找到此用户的提交';
$string['nosubmissions'] = '此互动评价还没有提交';
$string['nosubmissiontype'] = '必须至少有一种提交类型可用';
$string['notassessed'] = '还没有评价';
$string['nothingfound'] = '没有可显示的';
$string['nothingtoreview'] = '没有可评价的';
$string['notoverridden'] = '不覆盖';
$string['noworkshops'] = '该课程中没有互动评价活动';
$string['noyoursubmission'] = '您还没有提交您的作品';
$string['nullgrade'] = '-';
$string['overallfeedback'] = '总体反馈';
$string['overallfeedbackfiles'] = '最大的总体反馈附件数量';
$string['overallfeedbackmaxbytes'] = '最大的总体反馈附件大小';
$string['overallfeedbackmode'] = '总体反馈模式';
$string['overallfeedbackmode_0'] = '禁用';
$string['overallfeedbackmode_1'] = '启用和可选';
$string['overallfeedbackmode_2'] = '启用和必需';
$string['overallfeedbackmode_help'] = '如果启用，评价表单的底部会显示一个文本框。评价人可以在此输入该提交的综合评价，或者输入评价的附加说明。';
$string['page-mod-workshop-x'] = '任意互动评价模块页面';
$string['participant'] = '参与者';
$string['participantrevierof'] = '参与者是谁的评价人';
$string['participantreviewedby'] = '参与者的评价人是谁';
$string['phaseassessment'] = '评价阶段';
$string['phaseclosed'] = '关闭';
$string['phaseevaluation'] = '成绩核定阶段';
$string['phasesetup'] = '设置阶段';
$string['phasesoverlap'] = '提交阶段和评价阶段不能重叠';
$string['phasesubmission'] = '提交阶段';
$string['pluginadministration'] = '互动评价管理';
$string['pluginname'] = '互动评价';
$string['prepareexamples'] = '准备范例提交';
$string['previewassessmentform'] = '预览';
$string['privacy:metadata:aggregatedgradinggrade'] = '用户在给定的互动评价活动中所做的所有评价的汇总成绩';
$string['privacy:metadata:assessmentgrade'] = '本评估建议提交的汇总成绩';
$string['privacy:metadata:assessmentgradinggrade'] = '提供此评价的成绩';
$string['privacy:metadata:assessmentgradinggradeover'] = '手动覆盖提供此评价的成绩的值';
$string['privacy:metadata:assessmentid'] = '此评价的ID';
$string['privacy:metadata:authorid'] = '该提交作者的ID';
$string['privacy:metadata:dimensiongrade'] = '在给定的评价维度中的成绩';
$string['privacy:metadata:dimensionid'] = '该评价维度的ID';
$string['privacy:metadata:example'] = '该记录是否表示一个范例提交';
$string['privacy:metadata:feedbackauthor'] = '对作者的反馈';
$string['privacy:metadata:feedbackauthorformat'] = '对作者的反馈的文本格式';
$string['privacy:metadata:feedbackreviewer'] = '对提供评价的用户的反馈';
$string['privacy:metadata:feedbackreviewerformat'] = '对提供评价的用户的反馈的文本格式';
$string['privacy:metadata:late'] = '提交是否在截止日期后提交';
$string['privacy:metadata:peercomment'] = '由提供评价的用户对给定的成绩进行的评论';
$string['privacy:metadata:peercommentformat'] = '对给定成绩的评论的文本格式';
$string['privacy:metadata:preference:perpage'] = '用户希望在一个页面上看到的提交数量';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = '"示例提交"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = '"互动评价提交报表"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = '"评价表单"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = '"分配提交以评价"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = '"互动评价工具箱"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = '"总结"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = '"示例提交以评价"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = '"示例提交以评价"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = '"互动评价成绩报表"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = '"提交说明"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = '"评价说明"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = '"简介"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = '"总体反馈"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = '"提交"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = '"已发布提交"视图的折叠/展开状态。';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = '"您的成绩"视图的折叠/展开状态。';
$string['privacy:metadata:published'] = '互动评价关闭后，是否向所有参加者公布所有提交';
$string['privacy:metadata:reviewerid'] = '提供评价的用户的ID';
$string['privacy:metadata:strategy'] = '解释记录值的评分策略子插件的名称';
$string['privacy:metadata:submissioncontent'] = '提交内容';
$string['privacy:metadata:submissioncontentformat'] = '提交内容的文本格式';
$string['privacy:metadata:submissiongrade'] = '从区间0..100开始以十进制数书写的提交的汇总成绩';
$string['privacy:metadata:submissiongradeover'] = '手动覆盖汇总成绩的值';
$string['privacy:metadata:submissionid'] = '提交的ID';
$string['privacy:metadata:submissiontitle'] = '提交标题';
$string['privacy:metadata:subsystem:corefiles'] = '互动评价模块存储嵌入/附加到提交文本中的文件';
$string['privacy:metadata:subsystem:coreplagiarism'] = '互动评价模块内置了防抄袭系统';
$string['privacy:metadata:timeaggregated'] = '最后一次计算汇总成绩的时间';
$string['privacy:metadata:timecreated'] = '该记录在数据库中创建的时间';
$string['privacy:metadata:timemodified'] = '该记录最后一次在数据库中修改的时间';
$string['privacy:metadata:userid'] = '计算汇总成绩的用户的ID';
$string['privacy:metadata:weight'] = '评价的权重';
$string['privacy:metadata:workshopaggregations'] = '保存评价汇总成绩';
$string['privacy:metadata:workshopassessments'] = '保存关于互动评价模块提交的分配评价的信息';
$string['privacy:metadata:workshopgrades'] = '保存有关评价表单如何填写分数和评论的信息';
$string['privacy:metadata:workshopid'] = '互动评价活动的ID';
$string['privacy:metadata:workshopsubmissions'] = '保存关于互动评价模块提交的信息';
$string['privacy:request:delete:content'] = '内容已被删除(用户请求或过期)';
$string['privacy:request:delete:title'] = '[已删除]';
$string['publishedsubmissions'] = '发布的提交';
$string['publishsubmission'] = '发布提交';
$string['publishsubmission_help'] = '互动评价关闭后，其他人仍可以看到发布的提交。';
$string['reassess'] = '重新评价';
$string['receivedgrades'] = '获得的成绩';
$string['recentassessments'] = '互动评价评价：';
$string['recentsubmissions'] = '互动评价提交：';
$string['resetassessments'] = '删除所有评价';
$string['resetassessments_help'] = '您可以选择只删除分配的评价而不影响提交。如果要删除提交，它们的评价将被隐式删除，并且这个选项将被忽略。注意，这还包括对范例提交的评价。';
$string['resetphase'] = '切换到设置阶段';
$string['resetphase_help'] = '如果启用，所有互动评价将进入初始设置阶段。';
$string['resetsubmissions'] = '删除所有提交';
$string['resetsubmissions_help'] = '所有提交及其评价将被删除。这不影响范例提交。';
$string['saveandclose'] = '保存并关闭';
$string['saveandcontinue'] = '保存并继续编辑';
$string['saveandpreview'] = '保存并预览';
$string['saveandshownext'] = '保存并显示下一个';
$string['search:activity'] = '互动评价 - 活动信息';
$string['selfassessmentdisabled'] = '禁用自我评价';
$string['showingperpage'] = '每页显示{$a}项';
$string['showingperpagechange'] = '更改......';
$string['someuserswosubmission'] = '至少还有一个作者没有提交他们的作品';
$string['sortasc'] = '升序排序';
$string['sortdesc'] = '降序排序';
$string['strategy'] = '评分策略';
$string['strategy_help'] = '评分策略确定使用的评价表单和评价提交的方法。有4个选项:*累计评分-对于指定的方面给出评论和评分*评论-就特定方面提供意见，但不提供评分*错误数量-对指定的断言给出评论和对/错评价*红批-就指定的标准作出级别评估';
$string['strategyhaschanged'] = '自表单打开以进行编辑以来，互动评价评分策略已经发生了变化。';
$string['submission'] = '提交';
$string['submissionattachment'] = '附件';
$string['submissionby'] = '{$a}的提交';
$string['submissioncontent'] = '提交内容';
$string['submissiondeleteconfirm'] = '您确定要删除下面的提交吗?';
$string['submissiondeleteconfirmassess'] = '您确定要删除以下提交吗?注意，这也将删除与此提交相关的{$a->count}评价，这可能会影响评价人的成绩。';
$string['submissionend'] = '提交截止日期';
$string['submissionendbeforestart'] = '提交截止日期不能在提交打开日期之前';
$string['submissionenddatetime'] = '提交截止日期: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} 提交截止日期';
$string['submissionendswitch'] = '在提交截止日期后切换到下一阶段';
$string['submissionendswitch_help'] = '如果指定了提交截止日期并且勾选了此框，互动评价将在提交截止日期之后自动切换到评价阶段。如果启用此功能，还建议设置计划分配方法。如果提交没有被分配，则即使互动评价处于评价阶段也不能进行评价。';
$string['submissiongrade'] = '提交的成绩';
$string['submissiongrade_help'] = '此设置指定提交的作品可能获得的最高分数。';
$string['submissiongradeof'] = '提交({$a})的成绩';
$string['submissionlastmodified'] = '最后修改';
$string['submissionrequiredcontent'] = '您需要输入一些文字或添加一个文件。';
$string['submissionrequiredfile'] = '您需要添加一个文件或输入一些文本。';
$string['submissionsallocation'] = '提交资料分配';
$string['submissionsettings'] = '提交设置';
$string['submissionsreport'] = '互动评价提交报表';
$string['submissionstart'] = '提交打开从';
$string['submissionstartdatetime'] = '提交打开从{$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} 打开提交';
$string['submissiontitle'] = '标题';
$string['submissiontypedisabled'] = '此互动评价禁用此提交类型';
$string['submissiontypefileavailable'] = '文件附件<span class="accesshide"> 可用</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">文件附件</span>是必需的';
$string['submissiontypes'] = '提交类型';
$string['submissiontypetextavailable'] = '在线文本<span class="accesshide">可用</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">在线文本 </span>是必需的';
$string['submittednotsubmitted'] = '已提交({$a->submitted}) / 没有提交({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = '提交分配方法';
$string['subplugintype_workshopallocation_plural'] = '提交分配方法';
$string['subplugintype_workshopeval'] = '成绩核定方法';
$string['subplugintype_workshopeval_plural'] = '成绩核定方法';
$string['subplugintype_workshopform'] = '评分策略';
$string['subplugintype_workshopform_plural'] = '评分策略';
$string['switchingphase'] = '正在切换阶段';
$string['switchphase'] = '切换阶段';
$string['switchphase10'] = '切换到设置阶段';
$string['switchphase10info'] = '您将切换此互动评价到<strong>设置阶段</strong>。在此阶段，用户不能修改他们的提交或评价。教师可以利用这一阶段来更改互动评价设置、修改评分策略或调整评价表单。';
$string['switchphase20'] = '切换到提交阶段';
$string['switchphase20info'] = '您将切换此互动评价到<strong>提交阶段</strong>。在此阶段学生可以提交他们的作品（在提交访问控制日期内，如果设置了的话）。教师可以分配提交给同学间互评。';
$string['switchphase30'] = '切换到评价阶段';
$string['switchphase30auto'] = '在 {$a->daydatetime} ({$a->distanceday}) 之后，互动评价会自动切换到评价阶段';
$string['switchphase30info'] = '您将切换该互动评价到<strong>评价阶段</strong>。在这个阶段，评价人可以评价已分配给他们的提交（在评价访问控制日期内，如果已经设置）。';
$string['switchphase40'] = '切换到核定阶段';
$string['switchphase40info'] = '您将切换该互动评价到<strong>成绩核定阶段</strong>。 在这个阶段，用户无法修改他们的提交和评价。教师可以使用成绩核定工具计算最终成绩，并给评价人反馈。';
$string['switchphase50'] = '关闭互动评价';
$string['switchphase50info'] = '您将要关闭此互动评价。已计算的成绩将会显示在成绩单上。学生们可以查看他们的提交和提交评价。';
$string['switchphaseauto'] = '切换已经计划好了';
$string['switchphasenext'] = '切换到下一阶段';
$string['taskassesspeers'] = '评价同学';
$string['taskassesspeersdetails'] = '总数：{$a->total}<br />待评：{$a->todo}';
$string['taskassessself'] = '自我评价';
$string['taskconclusion'] = '提供本活动的总结';
$string['taskdone'] = '任务完成';
$string['taskfail'] = '任务失败';
$string['taskinfo'] = '任务信息';
$string['taskinstructauthors'] = '提供提交说明';
$string['taskinstructreviewers'] = '提供评价说明';
$string['taskintro'] = '设置此互动评价的描述';
$string['tasksubmit'] = '提交您的作品';
$string['tasktodo'] = '要做的任务';
$string['toolbox'] = '互动评价工具箱';
$string['undersetup'] = '互动评价目前正在建立中。请等待，直到活动切换到下一阶段。';
$string['useexamples'] = '使用范例';
$string['useexamples_desc'] = '提供范例提交，用来练习评价';
$string['useexamples_help'] = '如果启用，用户可以尝试评价一个或多个范例提交，并将他们的评价与参考评价进行比较。该成绩不计入评价成绩。';
$string['usepeerassessment'] = '使用同学间互评';
$string['usepeerassessment_desc'] = '学生可以评价其他同学的作品';
$string['usepeerassessment_help'] = '如果启用，可以分配其他用户的提交给任意用户评价。并且，用户除了自己的提交成绩外，还会获得一个评价成绩。';
$string['userdatecreated'] = '提交于<span>{$a}</span>';
$string['userdatemodified'] = '修改于<span>{$a}</span>';
$string['userplan'] = '互动评价计划表';
$string['userplan_help'] = '互动评价计划表显示活动的所有阶段，并列出每个阶段的任务。当前阶段被突出显示，任务进度被标记出来。';
$string['userplanaccessibilityskip'] = '跳转到当前任务';
$string['userplanaccessibilitytitle'] = '互动评价{$a}阶段时间轴';
$string['userplancurrentphase'] = '当前阶段';
$string['useselfassessment'] = '使用自我评价';
$string['useselfassessment_desc'] = '学生可以评价他们自己的作品';
$string['useselfassessment_help'] = '如果启用，用户自己的提交可能会被分配给自己评价。并且，用户除了自己的提交成绩外，还会获得一个评价成绩。';
$string['viewworkshopsummary'] = '查看互动评价总结';
$string['weightinfo'] = '权重：{$a}';
$string['withoutsubmission'] = '没有自己提交的评价人';
$string['workshop:addinstance'] = '添加一个新的互动评价';
$string['workshop:allocate'] = '分配提交用于评价';
$string['workshop:deletesubmissions'] = '删除提交';
$string['workshop:editdimensions'] = '编辑评价表单';
$string['workshop:exportsubmissions'] = '导出提交';
$string['workshop:ignoredeadlines'] = '忽略时间限制';
$string['workshop:manageexamples'] = '管理范例提交';
$string['workshop:overridegrades'] = '覆盖已计算的成绩';
$string['workshop:peerassess'] = '同学间互评';
$string['workshop:publishsubmissions'] = '发布提交';
$string['workshop:submit'] = '提交';
$string['workshop:switchphase'] = '切换阶段';
$string['workshop:view'] = '查看互动评价';
$string['workshop:viewallassessments'] = '查看所有评价';
$string['workshop:viewallsubmissions'] = '查看所有提交';
$string['workshop:viewauthornames'] = '查看作者姓名';
$string['workshop:viewauthorpublished'] = '查看已发布提交的作者';
$string['workshop:viewpublishedsubmissions'] = '查看已发布提交';
$string['workshop:viewreviewernames'] = '查看评价人姓名';
$string['workshopname'] = '互动评价名称';
$string['yourassessmentfor'] = '您对{$a}的评价';
$string['yourgrades'] = '您的成绩';
$string['yoursubmission'] = '您的提交';
$string['yoursubmissionwithassessments'] = '你提交的评估报告';
