<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'calendar', language 'zh_cn', version '4.3'.
 *
 * @package     calendar
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityevent'] = '活动事件';
$string['addevent'] = '添加事件';
$string['advancedoptions'] = '高级选项';
$string['allday'] = '整天';
$string['annually'] = '每年';
$string['calendar'] = '日程管理';
$string['calendarexporturl'] = '日历网址';
$string['calendarheading'] = '{$a} 日历';
$string['calendarpreferences'] = '日历偏好';
$string['calendartypes'] = '日历类型';
$string['calendarurl'] = '日历网址： {$a}';
$string['calendarurlcopiedtoclipboard'] = '日历网址已复制到剪贴板';
$string['category'] = '类别';
$string['categoryevent'] = '类别事件';
$string['categoryevents'] = '类别事件';
$string['clickhide'] = '点击隐藏';
$string['clickshow'] = '点击显示';
$string['colactions'] = '操作';
$string['colcalendar'] = '日程管理';
$string['collastupdated'] = '上次更新';
$string['colpoll'] = '刷新间隔';
$string['commontasks'] = '选项';
$string['confirmeventdelete'] = '您确定要删除"{$a}"事件吗?';
$string['confirmeventseriesdelete'] = '“{$a->name}”事件是系列的一部分。您只删除此事件，还是要删除此系列中的所有{$a->count}个事件?';
$string['confirmsubscriptiondelete'] = '您确定要删除“{$a}”日历订阅吗？';
$string['copycalendarurl'] = '复制日历网址';
$string['copyurl'] = '复制网址';
$string['course'] = '课程';
$string['coursecalendar'] = '{$a}日历';
$string['courseevent'] = '课程事件';
$string['courseevents'] = '课程事件';
$string['courses'] = '课程';
$string['customexport'] = '自定义范围({$a->timestart} - {$a->timeend})';
$string['daily'] = '每天';
$string['day'] = '天';
$string['dayeventsmany'] = '{$a->num} 个活动，{$a->day}';
$string['dayeventsnone'] = '没有活动，{$a}';
$string['dayeventsone'] = '1个活动，{$a}';
$string['daynext'] = '下一天';
$string['dayprev'] = '上一天';
$string['dayviewfor'] = '日视图：';
$string['dayviewtitle'] = '日视图：{$a}';
$string['daywithnoevents'] = '今天没有事件。';
$string['default'] = '默认';
$string['deleteallevents'] = '删除所有事件';
$string['deleteevent'] = '删除事件';
$string['deleteevents'] = '删除事件';
$string['deleteoneevent'] = '删除此事件';
$string['detailedmonthviewfor'] = '月视图详情：';
$string['detailedmonthviewtitle'] = '月视图详情：{$a}';
$string['durationminutes'] = '持续时间（分钟）';
$string['durationnone'] = '不持续';
$string['durationuntil'] = '持续到';
$string['editevent'] = '编辑事件';
$string['erroraddingevent'] = '添加事件失败';
$string['errorbadsubscription'] = '未发现日历订阅。';
$string['errorbeforecoursestart'] = '不能在课程开始日期前设置事件';
$string['errorcannotimport'] = '您此时无法设置日历订阅。';
$string['errorhasuntilandcount'] = '重复规则中可以出现“直到”或“总计”，但是“直到”和“总计”不能出现在同一规则中。';
$string['errorinvalidbydayprefix'] = '“每天”规则之前的整数值只可以出现在“每月”或“每年”重复规则中。';
$string['errorinvalidbydaysuffix'] = '"每天"规则中星期几部分的有效值为周一、周二、周三、周四、周五、周六、周日';
$string['errorinvalidbyhour'] = '"小时"规则的有效值为0到23。';
$string['errorinvalidbyminute'] = '"分钟"规则的有效值为0到59。';
$string['errorinvalidbymonth'] = '"每月"规则的有效值为1到12。';
$string['errorinvalidbymonthday'] = '"日期"规则的有效值为1到31或-31到-1。';
$string['errorinvalidbysecond'] = '"秒"规则的有效值为0到59。';
$string['errorinvalidbysetpos'] = '"位置"规则的有效值为1到366或-366到-1。';
$string['errorinvalidbyweekno'] = '"周数"规则的有效值为1到53或-53到-1。';
$string['errorinvalidbyyearday'] = '"每年"规则的有效值为1到366或-366到-1。';
$string['errorinvaliddate'] = '无效日期';
$string['errorinvalidicalurl'] = '指定的 iCal 网址无效。';
$string['errorinvalidinterval'] = '"间隔"规则的有效值应为正整数。';
$string['errorinvalidminutes'] = '持续时间的分钟数应为 1 至 999 之间的整数。';
$string['errorinvalidrepeats'] = '事件的数量应为 1 至 99 之间的整数。';
$string['errormustbeusedwithotherbyrule'] = '"位置"规则必须仅与另一个BYxxx规则联合使用。';
$string['errornodescription'] = '描述为必填项';
$string['errornoeventname'] = '名称为必填项';
$string['errornonyearlyfreqwithbyweekno'] = '周数规则仅对每年规则有效。';
$string['errorrequiredurlorfile'] = '导入日历的时候，需要一个网址或者文件';
$string['errorrrule'] = '已过去的重复规则似乎不正确。';
$string['errorrruleday'] = '重复规则的天参数无效。';
$string['errorrrulefreq'] = '重复规则的频率参数无效。';
$string['eventcalendareventcreated'] = '日历事件已创建';
$string['eventcalendareventdeleted'] = '日历事件已删除';
$string['eventcalendareventupdated'] = '日历事件已更新';
$string['eventdate'] = '日期';
$string['eventdescription'] = '描述';
$string['eventduration'] = '持续时间';
$string['eventendtime'] = '结束时间';
$string['eventendtimewrapped'] = '{$a} (结束时间)';
$string['eventinstanttime'] = '时间';
$string['eventkind'] = '事件类型';
$string['eventname'] = '事件标题';
$string['eventnameandcategory'] = '{$a->category}: {$a->name}';
$string['eventnameandcourse'] = '{$a->course}: {$a->name}';
$string['eventnamelocation'] = '{$a->名称}位置：{$a->位置}';
$string['eventnone'] = '没有事件';
$string['eventrepeat'] = '重复';
$string['events'] = '事件';
$string['eventsall'] = '所有事件';
$string['eventsdeleted'] = '{$a} 事件已删除';
$string['eventsfor'] = '{$a} 事件';
$string['eventsimported'] = '已导入事件：{$a}';
$string['eventskey'] = '事件关键词';
$string['eventsource'] = '事件源';
$string['eventspersonal'] = '我的个人事件';
$string['eventsrelatedtocategories'] = '与类别相关的事件';
$string['eventsrelatedtocourses'] = '与课程相关的事件';
$string['eventsrelatedtogroups'] = '与小组相关的事件';
$string['eventsskipped'] = '已跳过事件： {$a}';
$string['eventstarttime'] = '开始时间';
$string['eventstoexport'] = '要导出的事件';
$string['eventsubscriptioncreated'] = '日历订阅已创建';
$string['eventsubscriptiondeleted'] = '日历订阅已删除';
$string['eventsubscriptioneditwarning'] = '此日历事件是订阅的一部分。如果订阅被删除，您对此事件做的任何更改将丢失';
$string['eventsubscriptionupdated'] = '日历订阅已更新';
$string['eventsupdated'] = '已更新事件：{$a}';
$string['eventtime'] = '时间';
$string['eventtype'] = '事件类型';
$string['eventtypecategory'] = '类别';
$string['eventtypecourse'] = '课程';
$string['eventtypegroup'] = '小组';
$string['eventtypemodule'] = '模块';
$string['eventtypeother'] = '其他';
$string['eventtypesite'] = '站点';
$string['eventtypeuser'] = '用户';
$string['eventview'] = '事件详情';
$string['expired'] = '已过期';
$string['explain_site_timeformat'] = '您可以选择全站以 12 还是 24 小时格式显示时间。如果选择“默认”，系统将按照站点使用的语言自动选择。可以通过用户偏好覆盖此设置。';
$string['export'] = '导出';
$string['exportbutton'] = '导出';
$string['exportcalendar'] = '导出日历';
$string['exporthelp'] = '<p>日历URL提供了将事件导入其他日历的动态链接。 源日历中的任何新的、改变的或已删除的事件<strong>将会</strong>反映在其他日历中。</p>
<p>日历导出允许您创建事件的备份副本，该副本可以导入到其他日历中。 源日历中的更新<strong>将不会</strong> 反映在其他日历中。</p>';
$string['forcecalendartype'] = '强制日历';
$string['fri'] = '周五';
$string['friday'] = '星期五';
$string['fullcalendar'] = '完整日历';
$string['generateurlbutton'] = '获取日历网址';
$string['gotoactivity'] = '转到活动';
$string['gotocalendar'] = '转到日历';
$string['group'] = '小组';
$string['groupevent'] = '小组事件';
$string['groupevents'] = '小组事件';
$string['hideeventtype'] = '隐藏 {$a} 事件';
$string['hourly'] = '每小时';
$string['importcalendar'] = '导入日历';
$string['importcalendarexternal'] = '导入外部日历？';
$string['importcalendarfrom'] = '导入自';
$string['importcalendarheading'] = '导入日历…';
$string['importfromfile'] = '日历文件（.ics）';
$string['importfrominstructions'] = '请提供一个远程日历网址，或者上传一个文件';
$string['importfromurl'] = '日历网址';
$string['invalideventtype'] = '您选择的事件类型无效。';
$string['invalidtimedurationminutes'] = '您输入的持续时间无效。 请以分钟为单位输入大于0的持续时间，或选择不持续。';
$string['invalidtimedurationuntil'] = '您选择的“持续到”时间和日期早于此事件的开始时间。请先更正此问题再继续。';
$string['iwanttoexport'] = '导出';
$string['less'] = '更少';
$string['managesubscriptions'] = '导入或导出日历';
$string['manyevents'] = '{$a} 个事件';
$string['mon'] = '周一';
$string['monday'] = '星期一';
$string['monthly'] = '每月';
$string['monthlyview'] = '月视图';
$string['monthnext'] = '下月';
$string['monthprev'] = '上月';
$string['monththis'] = '本月';
$string['more'] = '更多';
$string['moreevents'] = '{$a} 更多';
$string['namewithsource'] = '{$a->name} ({$a->source})';
$string['never'] = '从未';
$string['newevent'] = '新事件';
$string['nocalendarsubscriptions'] = '您没有日历订阅。';
$string['notitle'] = '无标题';
$string['noupcomingevents'] = '没有即将到来的事件';
$string['oneevent'] = '1个事件';
$string['pollinterval'] = '更新间隔';
$string['pollinterval_help'] = '您希望日历多久更新一次新事件。';
$string['pref_lookahead'] = '预见即将到来的事件';
$string['pref_lookahead_help'] = '这里设置未来多少天内将开始的事件被显示为即将到来的事件。此天数以后开始的事件不会被显示为即将到来。请注意，<strong>并不保证</strong>在此时间窗口内开始的所有事件都会被显示；如果太多（超过“即将到来的事件数的最大值”偏好），那么最远的事件不会被显示。';
$string['pref_maxevents'] = '即将到来的事件数的最大值';
$string['pref_maxevents_help'] = '这里设置可以显示的即将到来的事件的最大数量。如果您选了一个较大的数字，那么可能显示出的事件将占据您屏幕很大的空间。';
$string['pref_persistflt'] = '记住过滤器设置';
$string['pref_persistflt_help'] = '如果启用，Moodle 会记住您上次的事件过滤器设置，并在您每次登录时自动恢复。';
$string['pref_startwday'] = '一周的第一天';
$string['pref_startwday_help'] = '日历里的一周将从您选择的那天开始。';
$string['pref_timeformat'] = '时间显示格式';
$string['pref_timeformat_help'] = '您可以选择使用12小时或24小时格式。如果您选择“默认”，系统将根据您所使用的语言自动为您选择时间格式。';
$string['preferences'] = '偏好';
$string['preferences_available'] = '您的个人偏好';
$string['preferredcalendar'] = '日历偏好';
$string['privacy:metadata:calendar:event'] = '日历组件可以在核心子系统中存储用户日历事件的详细信息。';
$string['privacy:metadata:calendar:event:description'] = '日历事件的描述。';
$string['privacy:metadata:calendar:event:eventtype'] = '日历事件的事件类型。';
$string['privacy:metadata:calendar:event:name'] = '日历事件的名称。';
$string['privacy:metadata:calendar:event:timeduration'] = '日历事件的持续时间。';
$string['privacy:metadata:calendar:event:timestart'] = '日历事件的开始时间。';
$string['privacy:metadata:calendar:event_subscriptions'] = '日历组件可以在核心子系统中存储用户日历订阅的详细信息。';
$string['privacy:metadata:calendar:event_subscriptions:eventtype'] = '日历订阅的事件类型。';
$string['privacy:metadata:calendar:event_subscriptions:name'] = '日历订阅的名称。';
$string['privacy:metadata:calendar:event_subscriptions:url'] = '日历订阅的网址。';
$string['privacy:metadata:calendar:preferences:calendar_savedflt'] = '已配置的日历事件类型显示用户偏好。';
$string['recentupcoming'] = '最近和接下来的60天';
$string['repeatedevents'] = '重复事件';
$string['repeateditall'] = '也应用更改到此重复系列的其它{$a}个事件';
$string['repeateditthis'] = '仅应用更改到此事件';
$string['repeatevent'] = '重复此事件';
$string['repeatnone'] = '不重复';
$string['repeatweeksl'] = '每周重复';
$string['repeatweeksr'] = '事件';
$string['requiresaction'] = '{$a} 需要采取行动';
$string['sat'] = '周六';
$string['saturday'] = '星期六';
$string['showeventtype'] = '显示 {$a} 个事件';
$string['shown'] = '显示';
$string['site'] = '站点';
$string['siteevent'] = '站点事件';
$string['siteevents'] = '站点事件';
$string['spanningevents'] = '正在进行的事件';
$string['subscriptionname'] = '日历名称';
$string['subscriptionremoved'] = '移除的日历订阅{$a}';
$string['subscriptions'] = '订阅';
$string['subscriptionsource'] = '事件源: {$a}';
$string['subscriptionupdated'] = '更新的日历订阅{$a}';
$string['sun'] = '周日';
$string['sunday'] = '星期日';
$string['thu'] = '周四';
$string['thursday'] = '星期四';
$string['timeformat_12'] = '12 小时(上午/下午)';
$string['timeformat_24'] = '24 小时';
$string['timeperiod'] = '时间周期';
$string['today'] = '今天';
$string['todayplustitle'] = '今天 {$a}';
$string['tomorrow'] = '明天';
$string['tt_deleteevent'] = '删除事件';
$string['tt_editevent'] = '编辑事件';
$string['tue'] = '周二';
$string['tuesday'] = '星期二';
$string['typecategory'] = '类别事件';
$string['typeclose'] = '关闭事件';
$string['typecourse'] = '课程事件';
$string['typedue'] = '到期事件';
$string['typegradingdue'] = '评分到期事件';
$string['typegroup'] = '小组事件';
$string['typeopen'] = '开启事件';
$string['typesite'] = '站点事件';
$string['typeuser'] = '用户事件';
$string['upcomingevents'] = '即将到来的事件';
$string['upcomingeventsfor'] = '即将到来的事件：';
$string['urlforical'] = 'iCalendar 导出的网址，用于订阅日历';
$string['user'] = '用户';
$string['userevent'] = '用户事件';
$string['userevents'] = '用户事件';
$string['viewupcomingactivitiesdue'] = '查看即将举行的活动‎';
$string['wed'] = '周三';
$string['wednesday'] = '星期三';
$string['weekly'] = '每周';
$string['weeknext'] = '下周';
$string['weekthis'] = '本周';
$string['when'] = '时间';
$string['whendate'] = '时间：{$a}';
$string['yesterday'] = '昨天';
$string['youcandeleteallrepeats'] = '此事件是重复事件系列的一部分。 您可以只删除此事件，也可以一次删除此系列中的所有 {$a} 个事件。';
$string['yoursubscriptions'] = '导入的日历';
