<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'sr_cr', version '4.3'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Процене се затварају:';
$string['activitydate:assessmentsclosed'] = 'Процене затворене:';
$string['activitydate:assessmentsopen'] = 'Процене се отварају:';
$string['activitydate:assessmentsopened'] = 'Процене отворене:';
$string['activitydate:submissionsclose'] = 'Предаја радова се затавра:';
$string['activitydate:submissionsclosed'] = 'Предаја радова затворена:';
$string['activitydate:submissionsopen'] = 'Предаја радова се отвара:';
$string['activitydate:submissionsopened'] = 'Предаја радова отварена:';
$string['aggregategrades'] = 'Поново израчунај оцене';
$string['aggregation'] = 'Сумирање оцена';
$string['allocate'] = 'Расподели предате радове';
$string['allocatedetails'] = 'очекивано: {$a->expected}<br />предато: {$a->submitted}<br />за расподелу: {$a->allocate}';
$string['allocation'] = 'Расподела предатих радова';
$string['allocationconfigured'] = 'Расподела радова је конфигурисана';
$string['allocationdone'] = 'Расподела радова је завршена';
$string['allocationerror'] = 'Грешка у расподели радова';
$string['allowedfiletypesforoverallfeedback'] = 'Дозвољени типови датотека за прилог повратној информацији';
$string['allowedfiletypesforoverallfeedback_help'] = 'Типови датотека, који се прилажу уз повратне информацији, могу бити ограничени навођењем списка дозвољених типова датотека. Ако је ово поље остављено празно дозвољени су сви типови датотека.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Дозвољени типови датотека за прилог раду за предају';
$string['allowedfiletypesforsubmission_help'] = 'Типови датотека, који се прилажу уз рад за предају, могу бити ограничени навођењем списка дозвољених типова датотека. Ако је ово поље остављено празно дозвољени су сви типови датотека.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Сви предати радови ({$a})';
$string['alreadygraded'] = 'Већ оцењено';
$string['areaconclusion'] = 'Текст закључка';
$string['areainstructauthors'] = 'Упутства за предају радова';
$string['areainstructreviewers'] = 'Упутства за процену';
$string['areaoverallfeedbackattachment'] = 'Прилози уз свеобухватне повратне информације';
$string['areaoverallfeedbackcontent'] = 'Текстови свеобухватних повратних информација';
$string['areasubmissionattachment'] = 'Прилози предатих радова';
$string['areasubmissioncontent'] = 'Текстови предатих радова';
$string['assess'] = 'Процени';
$string['assessedexample'] = 'Процењен пример предатог рада';
$string['assessedsubmission'] = 'Процењен предати рад';
$string['assessingexample'] = 'Процењивање примера предатог рада';
$string['assessingsubmission'] = 'Процењивање предатог рада';
$string['assessment'] = 'Процена';
$string['assessmentby'] = 'од стране <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Проценио/ла {$a}.';
$string['assessmentbyyourself'] = 'Ваша процена';
$string['assessmentdeleted'] = 'Процена је прерасподељена';
$string['assessmentend'] = 'Крајњи рок за процену';
$string['assessmentendbeforestart'] = 'Крајњи рок за процену не може да буде пре датума када процена почиње';
$string['assessmentenddatetime'] = 'Крајњи рок за процену: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} рок за предају процене';
$string['assessmentform'] = 'Образац за процену';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Процена</a> of <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Референтна процена';
$string['assessmentreferenceconflict'] = 'Није могуће проценити пример предатог рада за који сте дали референтну процену.';
$string['assessmentreferenceneeded'] = 'Морате да процените овај примера рада како бисте обезбедили референтну процену. Кликните на \'Настави\' да бисте проценили рад.';
$string['assessments'] = 'Процене';
$string['assessmentsettings'] = 'Подешавања процене';
$string['assessmentstart'] = 'Отворено за процењивање од';
$string['assessmentstartdatetime'] = 'Радови се могу процењивати од  {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} отвара се за процену';
$string['assessmentweight'] = 'Пондер процене';
$string['assignedassessments'] = 'Радови додељени за процену';
$string['assignedassessmentsnone'] = 'Није вам додељен ниједан рад за процену';
$string['backtoeditform'] = 'Повратак на образац за уређивање';
$string['byfullname'] = '<a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'од стране {$a}';
$string['calculategradinggrades'] = 'Израчунај оцене за евалуацијe (процене)';
$string['calculategradinggradesdetails'] = 'очекивано: {$a->expected}<br />израчунато: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Израчунај оцене за предате радове';
$string['calculatesubmissiongradesdetails'] = 'очекивано: {$a->expected}<br />израчунато: {$a->calculated}';
$string['chooseuser'] = 'Изабери корисника';
$string['clearaggregatedgrades'] = 'Обриши све збирне оцене';
$string['clearaggregatedgrades_help'] = 'Збирне оцене за предате радове и оцене за обављене процене биће ресетоване. Ове оцене можете поново да израчунате у току Фазе оцењивања евалуације (процене).';
$string['clearaggregatedgradesconfirm'] = 'Да ли сте сигурни да ли желите да обришете све израчунате оцене за предате радове као и оцене за урађене евалуације (процене)';
$string['clearassessments'] = 'Обриши процене';
$string['clearassessments_help'] = 'Израчунате оцене за предате радове и оцене за обављене процене биће ресетоване. Попуњени обрасци за процену су и даље сачувани, али ће корисници (рецензенти) морати поново да их отворе и сачувају како би оцене изнова биле израчунате.';
$string['clearassessmentsconfirm'] = 'Да ли сте сигурни да желите да обришете све оцене за обављене процене? Обрисане податке нећете моћи да повратите, већ ће корисници (рецензенти) морати поново да процене додељене им радове.';
$string['conclusion'] = 'Закључак';
$string['conclusion_help'] = 'Текст закључка се приказује полазницима на крају активности.';
$string['configexamplesmode'] = 'Подразумевани начин процене примера у радионицама';
$string['configgrade'] = 'Подразумевана максимална оцена за предати рад у радионицама';
$string['configgradedecimals'] = 'Подразумевани број цифара иза децималне тачке које треба да се виде приликом приказивања оцена.';
$string['configgradinggrade'] = 'Подразумевана максимална оцена за  обављену процену у радионицама';
$string['configmaxbytes'] = 'Подразумевана максималнa величина датотеке предатог рада за све радионице на сајту (зависи од ограничења курса о осталих локалних подешавања)';
$string['configstrategy'] = 'Подразумевана стратегија оцењивања за радионице';
$string['createsubmission'] = 'Додај рад';
$string['crontask'] = 'Позадинска обрада за модул \'Радионица\'';
$string['daysago'] = 'пре {$a} дана';
$string['daysleft'] = 'остало је {$a} дана';
$string['daystoday'] = 'данас';
$string['daystomorrow'] = 'сутра';
$string['daysyesterday'] = 'јуче';
$string['deadlinesignored'] = 'Временско ограничење се не односи на вас';
$string['deletesubmission'] = 'Обриши предати рад';
$string['editassessmentform'] = 'Уреди образац за процену';
$string['editassessmentformstrategy'] = 'Уреди образац за процену ({$a})';
$string['editingassessmentform'] = 'Уређивање обрасца за процену';
$string['editingsubmission'] = 'Уређивање предатог рада';
$string['editsubmission'] = 'Уреди предати рад';
$string['err_multiplesubmissions'] = 'У току уређивања овог обрасца, сачувана је друга верзија предатог рада. Предаја више од једног рада по кориснику није дозвољена.';
$string['err_removegrademappings'] = 'Није могуће уклонити некоришћена мапирања оцена';
$string['evaluategradeswait'] = 'Молимо сачекајте док процене не буду вредноване, а оцене израчунате.';
$string['evaluation'] = 'Оцењивање евалуација (процена)';
$string['evaluationmethod'] = 'Метод евалуације оцењивања';
$string['evaluationmethod_help'] = 'Метод оцењивања евалуације (процене) одређује како ће оцена за обављену процену бити израчуната. Можете да дозволите поновно израчунавања оцене, у више наврата са различитим подешавањима, уколико нисте задовољни резултатом.';
$string['evaluationsettings'] = 'Подешавања за оцењивање евалуације';
$string['eventassessableuploaded'] = 'Рад је постављен.';
$string['eventassessmentevaluated'] = 'Процена евалуирана';
$string['eventassessmentevaluationsreset'] = 'Евалуације процена ресетоване';
$string['eventassessmentreevaluated'] = 'Процена поново евалуирана';
$string['eventphaseautomaticallyswitched'] = 'Фаза се аутоматски мења';
$string['eventphaseswitched'] = 'Фаза радионице промењена';
$string['eventsubmissionassessed'] = 'Предати рад процењен';
$string['eventsubmissionassessmentsreset'] = 'Процене радова обрисане';
$string['eventsubmissioncreated'] = 'Предати рад креиран';
$string['eventsubmissiondeleted'] = 'Предати рад обрисан';
$string['eventsubmissionreassessed'] = 'Предати рад поново процењен';
$string['eventsubmissionupdated'] = 'Предати рад ажуриран';
$string['eventsubmissionviewed'] = 'Предати рад приказан';
$string['example'] = 'Пример предатог рада';
$string['exampleadd'] = 'Додај пример предатог рада';
$string['exampleassess'] = 'Процени пример предатог рада';
$string['exampleassessments'] = 'Примери радова за процену';
$string['exampleassesstask'] = 'Процени примере';
$string['exampleassesstaskdetails'] = 'очекивано: {$a->expected}<br />assessed: {$a->assessed}';
$string['examplecomparing'] = 'Поређење процена примера предатог рада';
$string['exampledelete'] = 'Обриши пример';
$string['exampledeleteconfirm'] = 'Да ли сте сигурни да желите да обришете следећи пример предатог рада? Кликните на \'Настави\' како бисте обрисали предати рад.';
$string['exampleedit'] = 'Уреди пример';
$string['exampleediting'] = 'Уређивање примера';
$string['exampleneedassessed'] = 'Прво морате да процените све примере предатих радова';
$string['exampleneedsubmission'] = 'Прво морате да предате свој рад и процените све примере предатих радова';
$string['examplesbeforeassessment'] = 'Примери рада су доступни након предаје сопственог рада и морају бити процењени пре него што започне процена од стране других полазника.';
$string['examplesbeforesubmission'] = 'Примери рада морају бити процењени пре предаје сопственог рада';
$string['examplesmode'] = 'Начин процене примера рада';
$string['examplesubmissions'] = 'Примери радова';
$string['examplesvoluntary'] = 'Процена примера предатог рада није обавезна';
$string['exportsubmission'] = 'Извези ову страницу';
$string['feedbackauthor'] = 'Повратне информације за аутора';
$string['feedbackauthorattachment'] = 'Прилог';
$string['feedbackby'] = 'Повратне информације које је дао/ла {$a}';
$string['feedbackreviewer'] = 'Повратне информације за рецензента';
$string['feedbacksettings'] = 'Повратне информације';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Дате оцене';
$string['grade_grading_name'] = 'Процена';
$string['grade_submission_name'] = 'Предати рад';
$string['gradecalculated'] = 'Израчуната оцена за предати рад';
$string['gradedecimals'] = 'Број децималних места у оценама';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Оцена: {$a->received} од {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (assessment)';
$string['gradeitemsubmission'] = '{$a->workshopname} (submission)';
$string['gradeover'] = 'Промени претходну оцену за предати рад';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Извештај о оценама у оквиру радионице';
$string['gradetopassgrading'] = 'Оцена за процену рада за пролаз';
$string['gradetopasssubmission'] = 'Оцена за предати рад за пролаз';
$string['gradinggrade'] = 'Оцена за обављену процену';
$string['gradinggrade_help'] = 'Ово подешавање одређује максималну оцену која се може добити за процену предатог рада.';
$string['gradinggradecalculated'] = 'Израчуната оцена за обављену процену';
$string['gradinggradeof'] = 'Оцена за обављену процену (од {$a})';
$string['gradinggradeover'] = 'Измени оцену за обављену процену';
$string['gradingsettings'] = 'Подешавања за оцењивање';
$string['groupnoallowed'] = 'Није вам дозвољено да приступите било којој групи у овој радионици';
$string['iamsure'] = 'Да, сигуран/сигурна сам';
$string['indicator:cognitivedepth'] = 'Радионица - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'Радионица\'.';
$string['indicator:cognitivedepthdef'] = 'Радионица - когнитивни аспект';
$string['indicator:cognitivedepthdef_help'] = 'Учесник је постигао овај проценат когнитивног ангажмана који нуде активности Радионица током овог интервала анализе (Нивои = Без прегледа, Преглед, Предаја рада, Преглед повратних информација, Коментар на повратне информације, Поновна предаја рада након прегледа повратних информација)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Радионица - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'Радионица\'.';
$string['indicator:socialbreadthdef'] = 'Радионица - социјални аспект';
$string['indicator:socialbreadthdef_help'] = 'Учесник је постигао овај проценат социјалног ангажмана који нуде активности Радионица током овог интервала анализе (Нивои = Без учешћа, Учесник сâм, Учесник са другима)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Информације';
$string['instructauthors'] = 'Упутства за предају радова';
$string['instructreviewers'] = 'Упутства за процену';
$string['introduction'] = 'Опис';
$string['latesubmissions'] = 'Предаја рада након истека рока';
$string['latesubmissions_desc'] = 'Дозволи предају радова након истека рока';
$string['latesubmissions_help'] = 'Ако је ово подешавање омогућено, аутор може да преда свој рад након истека рока или током фазе процене. Ипак, касно предати радови се не могу накнадно уређивати.';
$string['latesubmissionsallowed'] = 'Предаја рада након истека рока је дозвољена';
$string['maxbytes'] = 'Максимална величина прилога за предају';
$string['modulename'] = 'Радионица';
$string['modulename_help'] = 'Модул активности \'Радионица\' омогућава прикупљање радова полазника, оцењивање предатих радова од стране предавача, као и процену тих радова од стране других колега полазника (вршњачка процена).

Полазници, као свој рад, могу да предају различите дигиталне садржаје (датотеке), као што су нпр. текстуални документи или прорачунске табеле, а такође, могу директно да уписују текст користећи едитор текста.

Предати радови се процењују коришћењем обрасца за процену на основу скупа критеријума које је дефинисао предавач. Процес (вршањачке) процене радова других колега, као и разумевање обрасца за процену, могу претходно да се вежбају са примерима радова који су добијени од предавача, заједно са референтним проценама. Полазници имају могућност да процене један или више радова својих колега, при чему и радови који се процењују и  рецензенти (полазници) могу да буде анонимне, ако је то потребно.

У оквиру радионице полазници добијају две оцене - једну за свој рад, а другу за своје процене радова других колега. Обе оцене се бележе у књигу оцена.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Радионице';
$string['myassessments'] = 'Моје процене';
$string['mysubmission'] = 'Мој рад';
$string['nattachments'] = 'Максималан број дозвољених прилога по раду';
$string['noexamples'] = 'У овој радионици још нема примера радова';
$string['noexamplesformready'] = 'Морате да дефинишете образац за процену пре него што поставите пример рада';
$string['nogradeyet'] = 'Још нема оцена';
$string['nosubmissionfound'] = 'Овај корисник нема предатих радова';
$string['nosubmissions'] = 'У овој радионици још нема предатих радова';
$string['nosubmissiontype'] = 'Најмање један тип предатог рада мора бити доступан';
$string['notassessed'] = 'Рад још није процењен';
$string['nothingfound'] = 'Нема ништа за приказ';
$string['nothingtoreview'] = 'Нема радова за преглед';
$string['notoverridden'] = 'Није измењено';
$string['noworkshops'] = 'Нема радионица на овом курсу';
$string['noyoursubmission'] = 'Још нисте предали свој рад';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Свеобухватне повратне информација';
$string['overallfeedbackfiles'] = 'Максималан број прилога уз свеобухватне повратне информације';
$string['overallfeedbackmaxbytes'] = 'Максимална величина прилога опште повратне информације';
$string['overallfeedbackmode'] = 'Режим свеобухватних повратних информација';
$string['overallfeedbackmode_0'] = 'Онемогућено';
$string['overallfeedbackmode_1'] = 'Омогућено и опционо';
$string['overallfeedbackmode_2'] = 'Омогућено и неопходно';
$string['overallfeedbackmode_help'] = 'Ако је ово омогућено, текстуално поље се приказује на дну обрасца за оцењивање  . Рецензенти у то поље могу да унесу свеобухватну оцену предатих радова, или да дају додатно објашњење својих оцена.';
$string['page-mod-workshop-x'] = 'Било која страница модула \'Радионица\'';
$string['participant'] = 'Учесник';
$string['participantrevierof'] = 'Учесник процењује';
$string['participantreviewedby'] = 'Учесника процењује';
$string['phaseassessment'] = 'Фаза процене радова';
$string['phaseclosed'] = 'Затворено';
$string['phaseevaluation'] = 'Фаза оцењивања евалуације (процене)';
$string['phasesetup'] = 'Фаза подешавања радионице';
$string['phasesoverlap'] = 'Фаза предаје и фаза процена не могу да се преклапају';
$string['phasesubmission'] = 'Фаза предаје радова';
$string['pluginadministration'] = 'Администрација радионице';
$string['pluginname'] = 'Радионица';
$string['prepareexamples'] = 'Припреми примере радова';
$string['previewassessmentform'] = 'Преглед';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Сумарна оцена за све процене које је направио корисник у оквиру дате радионице';
$string['privacy:metadata:assessmentgrade'] = 'Сумарна оцена за предати рад предложена овом проценом';
$string['privacy:metadata:assessmentgradinggrade'] = 'Оцена за давање процене';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Ручно измењена вредност оцене за давање ове процене';
$string['privacy:metadata:assessmentid'] = 'ID ознака процене';
$string['privacy:metadata:authorid'] = 'ID ознака аутора предатог рада';
$string['privacy:metadata:dimensiongrade'] = 'Оцена у датој димензији процене';
$string['privacy:metadata:dimensionid'] = 'ID ознака димензије процене';
$string['privacy:metadata:example'] = 'Да ли овај запис представља пример предатог рада';
$string['privacy:metadata:feedbackauthor'] = 'Повратне информације за аутора';
$string['privacy:metadata:feedbackauthorformat'] = 'Формат текста повратних информација за аутора';
$string['privacy:metadata:feedbackreviewer'] = 'Повратне информације за корисника који ради процену';
$string['privacy:metadata:feedbackreviewerformat'] = 'Текстуални формат повратне информације за корисника који даје процену';
$string['privacy:metadata:late'] = 'Да ли је рад предат након истека рока';
$string['privacy:metadata:peercomment'] = 'Коментари на добијену оцену од корисника који даје процену';
$string['privacy:metadata:peercommentformat'] = 'Формат текста коментара на дату оцену';
$string['privacy:metadata:preference:perpage'] = 'Број предатих радова који корисник преферира да види на једној страници';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Статус скупљено/проширено за прегледник \'Примери радова\'.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Статус скупљено/проширено за прегледник \'Извештај о предатим радовима\'.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Статус скупљено/проширено за прегледник \'Образац за процену\'.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Статус скупљено/проширено за прегледник \'Радови додељени за процену\'.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Статус скупљено/проширено за прегледник \'Кутија са алаткама за радионицу\'.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Статус скупљено/проширено за прегледник \'Закључак\'.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Статус скупљено/проширено за прегледник \'Примери радова за процену\'.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Статус скупљено/проширено за прегледник \'Примери радова за процену\'.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Статус скупљено/проширено за прегледник \'Извештај о оценама у оквиру радионице\'.';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Статус скупљено/проширено за прегледник \'Упутства за предају рада\'.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Статус скупљено/проширено за прегледник \'Упутства за процену\'.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Статус скупљено/проширено за прегледник \'Увод\'.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Статус скупљено/проширено за прегледник \'Свеукупне повратне информације\'.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Статус скупљено/проширено за прегледник \'Ваше радови\'.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Статус скупљено/проширено за прегледник \'Објављени радови\'.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Статус скупљено/проширено за прегледник \'Ваше оцене\'.';
$string['privacy:metadata:published'] = 'Да ли предати рад треба да буде објављен свим учесницима кад се радионица заврши';
$string['privacy:metadata:reviewerid'] = 'ID ознака корисника који врши процену';
$string['privacy:metadata:strategy'] = 'Назив поддодатка за стратегије оцењивања који врши интерпретацију вредности записа';
$string['privacy:metadata:submissioncontent'] = 'Садржај предатог рада';
$string['privacy:metadata:submissioncontentformat'] = 'Текстуални формат садржаја предатог рада';
$string['privacy:metadata:submissiongrade'] = 'Збирна оцена за предати рад записана као децимални број из интервала 0..100';
$string['privacy:metadata:submissiongradeover'] = 'Ручно измењена вредност збирне оцене';
$string['privacy:metadata:submissionid'] = 'ID ознака предатог рада';
$string['privacy:metadata:submissiontitle'] = 'Наслов предатог рада';
$string['privacy:metadata:subsystem:corefiles'] = 'Модул Радионица чува датотеке уграђене у / приложене уз предати текст';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Модул Радионица има уграђену подршку за системе за превенцију плагијаризма';
$string['privacy:metadata:timeaggregated'] = 'Кад је збирна оцена последњи пут срачуната';
$string['privacy:metadata:timecreated'] = 'Кад је овај запис креиран у бази';
$string['privacy:metadata:timemodified'] = 'Кад је овај запис последњи пут измењен у бази';
$string['privacy:metadata:userid'] = 'ID ознака корисника за кога се израчунава збирна оцена';
$string['privacy:metadata:weight'] = 'Тежина процене';
$string['privacy:metadata:workshopaggregations'] = 'Садржи збирне оцене за процену знања';
$string['privacy:metadata:workshopassessments'] = 'Садржи информације о алоцираним проценама за предате радове у оквиру модула Радионица';
$string['privacy:metadata:workshopgrades'] = 'Садржи информације о томе како су обрасци за процену попуњени оценама и коментарима';
$string['privacy:metadata:workshopid'] = 'ID ознака радионице';
$string['privacy:metadata:workshopsubmissions'] = 'Садржи информације о предатим радовима у оквиру модула Радионица';
$string['privacy:request:delete:content'] = 'Садржај је избрисан (на захтев корисника или је истекао)';
$string['privacy:request:delete:title'] = '[Обрисано]';
$string['publishedsubmissions'] = 'Објављени радови';
$string['publishsubmission'] = 'Објави рад';
$string['publishsubmission_help'] = 'Објављени радови су доступни другим корисницима након затварања радионице';
$string['reassess'] = 'Процените поново';
$string['receivedgrades'] = 'Добијене оцене';
$string['recentassessments'] = 'Процене у оквиру радионице';
$string['recentsubmissions'] = 'Предати радови у оквиру радионице:';
$string['resetassessments'] = 'Обриши све процене';
$string['resetassessments_help'] = 'Можете одабрати брисање само додељених процена квалитета без утицаја на предате радове. Ако предати радови буду требали да се обришу процене њиховог квалитета ће бити имплицитно уклоњене уз игнорисање овог подешавања. Водите рачуна да ово укључује и процене квалитета радова који су постављени као илустративни примери.';
$string['resetphase'] = 'Пребаци у фазу подешавања';
$string['resetphase_help'] = 'Ако је ова опција омогућена све радионице ће бити стављене у иницијалну фазу подешавања.';
$string['resetsubmissions'] = 'Обриши све предате радове';
$string['resetsubmissions_help'] = 'Сви предати радови и процене њиховог квалитета ће бити обрисани. Ово се не односи на радове постављене у својству илустративних примера.';
$string['saveandclose'] = 'Сачувај и затвори';
$string['saveandcontinue'] = 'Сачувај и настави са уређивањем';
$string['saveandpreview'] = 'Сачувај и прегледај';
$string['saveandshownext'] = 'Сачувај и прикажи следећи';
$string['search:activity'] = 'Радионица - информације о активности';
$string['selfassessmentdisabled'] = 'Самопроцена је онемогућена';
$string['showingperpage'] = 'Приказ {$a} ставки по страници';
$string['showingperpagechange'] = 'Промени ...';
$string['someuserswosubmission'] = 'Постоји најмање један аутор који није предао свој рад';
$string['sortasc'] = 'Сортирај растуће';
$string['sortdesc'] = 'Сортирај опадајуће';
$string['strategy'] = 'Стратегија оцењивања';
$string['strategy_help'] = 'Стратегија оцењивања одређује образац који ће се користити, као и начин оцењивања предатих радова. Постоје 4 могућности:

* Кумулативно оцењивање - Коментари и оцене се дају у вези са наведеним аспектима
* Коментари - Коментари се дају у вези са наведеним аспектима, али се не могу дати оцене
* Број грешака - Коментари и да/не процене се дају у вези са наведеним тврдњама
* Рубрике - процена се даје према наведеним критеријумима';
$string['strategyhaschanged'] = 'Стратегија оцењивања је измењена, након што је образац отворен за уређивање';
$string['submission'] = 'Предати рад';
$string['submissionattachment'] = 'Прилог';
$string['submissionby'] = 'Рад који је предао/ла {$a}';
$string['submissioncontent'] = 'Садржај предатог рада';
$string['submissiondeleteconfirm'] = 'Да ли сте сигурни да желите да обришете следећи предати рад?';
$string['submissiondeleteconfirmassess'] = 'Да ли сте сигурни да желите да обришете следећи предати рад? Обратите пажњу на то да ће бити обрисане и евалуације (број унетих до сада је {$a->count}) везане за тај рад, што може да утиче и на оцене оних који рад прегледају.';
$string['submissionend'] = 'Крајњи рок за предају радова';
$string['submissionendbeforestart'] = 'Крајњи рок за предају не може да буде пре датума када предаја почиње';
$string['submissionenddatetime'] = 'Крајњи рок за предају радова: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} рок за предају рада';
$string['submissionendswitch'] = 'Пребаците на следећу фазу након крајњег рока за предају';
$string['submissionendswitch_help'] = 'Ако је наведен крајњи рок за предају и ово поље потврђено, радионица ће аутоматски бити пребачена у фазу процене након крајњег рока за предају.

Ако омогућите ову функцију, препоручује се да, такође, подесите планирани метод доделе. Ако предати радови нису додељени, ни процена не може да буде започета, чак и ако је радионица сама, у фази процене.';
$string['submissiongrade'] = 'Оцена предатог рада';
$string['submissiongrade_help'] = 'Ово подешање одређује максималну оцену која се може добити за предати рад.';
$string['submissiongradeof'] = 'Оцена за предати рад (од {$a})';
$string['submissionlastmodified'] = 'Последња измена';
$string['submissionrequiredcontent'] = 'Морате унети текст или додати датотеку.';
$string['submissionrequiredfile'] = 'Морате додати датотеку или унети текст.';
$string['submissionsallocation'] = 'Расподела предатих радова';
$string['submissionsettings'] = 'Подешавања за предају рада';
$string['submissionsreport'] = 'Извештај о предатим радовима';
$string['submissionstart'] = 'Отворено за предају радова од';
$string['submissionstartdatetime'] = 'Почетак рока за предају радова {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} отвара се за предају рада';
$string['submissiontitle'] = 'Наслов';
$string['submissiontypedisabled'] = 'Овај тип предатог рада је онемогућен за ову радионицу';
$string['submissiontypefileavailable'] = 'Приложена датотека<span class="accesshide"> доступна</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Приложена датотека </span>Обавезна';
$string['submissiontypes'] = 'Типови предатих радова';
$string['submissiontypetextavailable'] = 'Онлајн текст<span class="accesshide"> доступан</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Онлајн текст </span>Обавезан';
$string['submittednotsubmitted'] = 'Предао/ла ({$a->submitted}) / није предао/ла ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Начин расподеле радова';
$string['subplugintype_workshopallocation_plural'] = 'Начини расподеле радова';
$string['subplugintype_workshopeval'] = 'Начин оцењивања евалуације';
$string['subplugintype_workshopeval_plural'] = 'Начини оцењивања евалуације';
$string['subplugintype_workshopform'] = 'Стратегија оцењивања';
$string['subplugintype_workshopform_plural'] = 'Стратегије оцењивања';
$string['switchingphase'] = 'Промена фазе';
$string['switchphase'] = 'Промени фазу';
$string['switchphase10'] = 'Пребаци на фазу подешавања';
$string['switchphase10info'] = 'Намеравате да пребаците радионицу у <strong>Фазу подешавања радионице</strong>. У овој фази, корисници не могу да мењају своје предате радове или своје процене других радова. Предавачи могу да користи ову фазу како би променили подешавања радионице, модификовали стратегију оцењивања или фино подесили обрасце за процену.';
$string['switchphase20'] = 'Пребаци на фазу предаје рада';
$string['switchphase20info'] = 'Намеравате да пребаците радионицу у <strong>Фазу предаје радова</strong>. У току ове фазе, полазници могу да предају своје радове (унутар задатог рока, ако је он постављен). Предавачи могу да врше расподелу предатих радова другим полазницима за процењивање.';
$string['switchphase30'] = 'Пребаци на фазу процене';
$string['switchphase30auto'] = 'Радионица ће се аутоматски пребацити у фазу процене након {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Намеравате да пребаците радионицу у <strong>Фазу процене радова</strong>. У овој фази, полазници (рецензенти) могу да процењују радове који су им додељени (унутар задатог рока, ако је он постављен).';
$string['switchphase40'] = 'Пребаци на фазу евалуације';
$string['switchphase40info'] = 'Намеравате да пребаците радионицу у <strong>Фазу оцењивања евалуација</strong>. У овој фази корисници не могу да мењају своје предате радове или своје процене радова других колега. Предавачи могу да користе алате за оцењивање евалуација (процена) како би израчунали коначну оцену и дали повратне информације рецензентима.';
$string['switchphase50'] = 'Затвори радионицу';
$string['switchphase50info'] = 'Намеравате да затворите радионицу. Због тога ће се израчунате оцене појавити у књизи оцена. Полазници могу да виде своје предате радове, као и своје процене других радова.';
$string['switchphaseauto'] = 'Пребацивање је заказано';
$string['switchphasenext'] = 'Пребаците се на следећу фазу';
$string['taskassesspeers'] = 'Процените радове колега';
$string['taskassesspeersdetails'] = 'укупно: {$a->total}<br />преостало: {$a->todo}';
$string['taskassessself'] = 'Процени свој рад';
$string['taskconclusion'] = 'Напишите закључак о активности';
$string['taskdone'] = 'Зaдатак урађен';
$string['taskfail'] = 'Задатак није успео';
$string['taskinfo'] = 'Информације о задатку';
$string['taskinstructauthors'] = 'Напишите упутства за предају радова';
$string['taskinstructreviewers'] = 'Напишите упутства за процену';
$string['taskintro'] = 'Поставите опис радионице';
$string['tasksubmit'] = 'Предај свој рад';
$string['tasktodo'] = 'Задатак који треба урадити';
$string['toolbox'] = 'Кутија са алаткама за радионицу';
$string['undersetup'] = 'Радионица се тренутно подешава. Молимо, сачекајте док не буде пребачена у наредну фазу.';
$string['useexamples'] = 'Користите примере';
$string['useexamples_desc'] = 'Примери радова служе да корисници вежбају процењивање';
$string['useexamples_help'] = 'Ако је ово подешавање омугућено, корисници могу да процењују један или више примера радова и да упореде своје са референтном проценом.';
$string['usepeerassessment'] = 'Користите полазничке процене';
$string['usepeerassessment_desc'] = 'Полазници могу да процењују радове других';
$string['usepeerassessment_help'] = 'Ако је ово подешавање омогућено, кориснику могу бити додељени на процену радови других колега. Поред оцене за свој рад корисник ће добити оцену и за своју процену других радова.';
$string['userdatecreated'] = 'предато <span>{$a}</span>';
$string['userdatemodified'] = 'измењено <span>{$a}</span>';
$string['userplan'] = 'Планер радионице';
$string['userplan_help'] = 'Планер радионице приказује све фазе активности и даје списак задатака за сваку фазу. Текућа фаза је истакнута а завршени задаци обележени.';
$string['userplanaccessibilityskip'] = 'Иди на текуће задатке';
$string['userplanaccessibilitytitle'] = 'Хронологија радионице са {$a} фазе/а';
$string['userplancurrentphase'] = 'Тренутна фаза';
$string['useselfassessment'] = 'Користите самопроцену';
$string['useselfassessment_desc'] = 'Полазници могу да процењују сопствени рад';
$string['useselfassessment_help'] = 'Ако је ово подешавање омогућено. кориснику може бити додељен на процену његов рад. Поред оцене за свој рад корисник ће добити оцену и за процену свог рада.';
$string['viewworkshopsummary'] = 'Прикажи резиме радионице';
$string['weightinfo'] = 'Пондер: {$a}';
$string['withoutsubmission'] = 'Рецензент без сопственог рада';
$string['workshop:addinstance'] = 'Додај нову радионицу';
$string['workshop:allocate'] = 'Расподели предате радове на рецензију';
$string['workshop:deletesubmissions'] = 'Брисање предатих радова';
$string['workshop:editdimensions'] = 'Уреди образац за процену';
$string['workshop:exportsubmissions'] = 'Извоз предатих радова';
$string['workshop:ignoredeadlines'] = 'Игнорисати временска ограничења';
$string['workshop:manageexamples'] = 'Управљање примерима радова';
$string['workshop:overridegrades'] = 'Поништи израчунате оцене';
$string['workshop:peerassess'] = 'Студент процењује';
$string['workshop:publishsubmissions'] = 'Објава предатих радова';
$string['workshop:submit'] = 'Предај рад';
$string['workshop:switchphase'] = 'Промени фазу';
$string['workshop:view'] = 'Погледај радионицу';
$string['workshop:viewallassessments'] = 'Погледај све процене';
$string['workshop:viewallsubmissions'] = 'Приказ свих предатих радова';
$string['workshop:viewauthornames'] = 'Погледај имена аутора';
$string['workshop:viewauthorpublished'] = 'Погледај ауторе објављених радова';
$string['workshop:viewpublishedsubmissions'] = 'Приказ објављених радова';
$string['workshop:viewreviewernames'] = 'Погледај имена рецензената';
$string['workshopname'] = 'Назив радионице';
$string['yourassessmentfor'] = 'Ваша процена за {$a}';
$string['yourgrades'] = 'Ваше оцене';
$string['yoursubmission'] = 'Ваш рад';
$string['yoursubmissionwithassessments'] = 'Ваш предати рада са проценама';
