<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'sr_cr', version '4.3'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Додељивање улоге \'{$a->role_shortname}\' кориснику \'{$a->user_username}\' на курсу \'{$a->course_shortname}\' (id {$a->course_id})';
$string['assignrolefailed'] = 'Није успело додељивање улоге \'{$a->role_shortname}\' кориснику \'{$a->user_username}\' на курсу \'{$a->course_shortname}\' (id {$a->course_id})';
$string['autocreate'] = '<p>Курсеви се могу креирати аутоматски ако постоје уписи на курс који још увек не постоји на Moodleu</p><p>Уколико користите аутоматско креирање курсева, препоручује се да одговарајућим улогама уклоните следеће могућности: moodle/course:changeidnumber, moodle/course:changeshortname, moodle/course:changefullname и moodle/course:changesummary, како бисте спречили промене горе наведених поља курса (број, скраћени назив, пун назив and резиме курса).</p>';
$string['autocreate_key'] = 'Аутоматско креирање';
$string['autocreation_settings'] = 'Подешавања аутоматског креирања курса';
$string['autoupdate_settings'] = 'Подешавање за аутоматско ажурирање курса';
$string['autoupdate_settings_desc'] = '<p>Изаберите поља која ће бити ажурирана у току заказаног процеса \'Синхронизуј LDAP уписе\'.</p><p>Када је изабрано најмање једно поље доћи ће до ажурирања.</p>';
$string['bind_dn'] = 'Ако желите да користите везног корисника за претрагу корисника, наведите то овде. Нешто као \'cn=ldapuser,ou=public,o=org\'';
$string['bind_dn_key'] = 'Јединствено препознатљиво име везног корисника';
$string['bind_pw'] = 'Лозинка за везног корисника.';
$string['bind_pw_key'] = 'Лозинка';
$string['bind_settings'] = 'Подешавања везивања';
$string['cannotcreatecourse'] = 'Није могуће креирање курса: недостају неопходни подаци у LDAP запису!';
$string['cannotupdatecourse'] = 'Није могуће ажурирати курс: недостају неопходни подаци из LDAP записа! ID број курса: \'{$a->idnumber}\'';
$string['cannotupdatecourse_duplicateshortname'] = 'Није могуће ажурирати курс: дупликат скраћеног назива. Прескаче се курс са id бројем \'{$a->idnumber}\'...';
$string['category'] = 'Категорија за аутоматски креиране курсеве.';
$string['category_key'] = 'Категорија';
$string['contexts'] = 'LDAP контексти';
$string['couldnotfinduser'] = 'Није било могуће пронаћи корисника \'{$a}\', прескаче се';
$string['course_fullname'] = 'Опционо: LDAP атрибут из ког ће се преузети пуни назив курса';
$string['course_fullname_key'] = 'Пуно име';
$string['course_fullname_updateonsync'] = 'Ажурирај пун назив током синхронизације';
$string['course_fullname_updateonsync_key'] = 'Ажурирај пун назив';
$string['course_idnumber'] = 'LDAP атрибут из кога се преузима ID број курса. Обично \'cn\' или \'uid\'.';
$string['course_idnumber_key'] = 'ID број';
$string['course_search_sub'] = 'Тражи чланство у групама у потконтекстима';
$string['course_search_sub_key'] = 'Претражи потконтексте';
$string['course_settings'] = 'Подешавања уписа курса';
$string['course_shortname'] = 'Опционо: LDAP атрибут из ког ће се преузети скраћени назив курса';
$string['course_shortname_key'] = 'Скраћени назив';
$string['course_shortname_updateonsync'] = 'Ажурирај скраћен назив током синхронизације';
$string['course_shortname_updateonsync_key'] = 'Ажурирај скраћен назив';
$string['course_summary'] = 'Опционо: LDAP атрибут из ког се ће се преузети резиме курса';
$string['course_summary_key'] = 'Резиме';
$string['course_summary_updateonsync'] = 'Ажурирај резиме током синхронизације';
$string['course_summary_updateonsync_key'] = 'Ажурирај резиме';
$string['coursenotexistskip'] = 'Курс \'{$a}\' не постоји, а аутоматско креирање курсева је онемогућено, прескаче се';
$string['courseupdated'] = 'Курс са id бројем \'{$a->idnumber}\' успешно је ажуриран.';
$string['courseupdateskipped'] = 'Курс са id бројем \'{$a->idnumber}\' не захтева ажурирање. Прескаче се...';
$string['createcourseextid'] = 'КРЕИРАЈ корисника уписаног на непостојећи курс \'{$a->courseextid}\'';
$string['createnotcourseextid'] = 'Корисник је уписан на непостојећи курс \'{$a->courseextid}\'';
$string['creatingcourse'] = 'Креирање курса \'{$a}\'...';
$string['duplicateshortname'] = 'Креирање курса није успело. Нађен је дупликат скраћеног назива. Прескаче се курс са идентификационим бројем \'{$a->idnumber}\'...';
$string['editlock'] = 'Закључајте вредности';
$string['emptyenrolment'] = 'Празан упис за улогу \'{$a->role_shortname}\' на курсу \'{$a->course_shortname}\'';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = 'Упиши корисника \'{$a->user_username}\' на курс \'{$a->course_shortname}\' (id {$a->course_id})';
$string['enroluserenable'] = 'Омогућен је упис за корисника \'{$a->user_username}\' на курсу \'{$a->course_shortname}\' (id {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() не подржава изабрани тип корисника: {$a}';
$string['extcourseidinvalid'] = 'Екстерни идентификатор курса је неисправан!';
$string['extremovedsuspend'] = 'Онемогућен је упис за корисника \'{$a->user_username}\' на курсу \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'Онемогућен је упис и уклоњена улога за корисника \'{$a->user_username}\' на курсу \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedunenrol'] = 'Испиши корисника \'{$a->user_username}\' са курса \'{$a->course_shortname}\' (id {$a->course_id})';
$string['failed'] = 'Неуспешно!';
$string['general_options'] = 'Општа подешавања';
$string['group_memberofattribute'] = 'Назив атрибута који одређује којим групама припада дати корисник или група (нпр. memberOf, groupMembership итд.)';
$string['group_memberofattribute_key'] = 'Атрибут \'Члан групе\'';
$string['host_url'] = 'Наведите главни LDAP у URL-облику као. \'ldap://ldap.domen.rs/\' или \'ldaps://ldap.domen.rs/\'';
$string['host_url_key'] = 'URL сервера';
$string['idnumber_attribute'] = 'Ако чланство у групи садржи јединствена препознатљива име (DN) наведите исте атрибуте које сте користили за мапирање корисничког \'ID броја\' у подешавањима LDAP провере идентитета.';
$string['idnumber_attribute_key'] = 'ID број атрибут';
$string['ldap:manage'] = 'Управљање LDAP инстанцама уписа';
$string['ldap_encoding'] = 'Наведите кодни распоред који користи LDAP сервер. Највероватније utf-8, док MS AD v2 обично користи cp1252, cp1250 итд.';
$string['ldap_encoding_key'] = 'LDAP кодни распоред';
$string['memberattribute'] = 'Атрибут LDAP члан';
$string['memberattribute_isdn'] = 'Ако чланство у групи садржи јединствена препознатљива имена (DN) морате овде да их наведете. Такође, морате да конфигуришете и преостала подешавања у овој секцији.';
$string['memberattribute_isdn_key'] = 'Атрибут члана користи dn';
$string['nested_groups'] = 'Да ли желите да за упис користите угнежђене групе (групе унутар група)?';
$string['nested_groups_key'] = 'Угнежђене групе';
$string['nested_groups_settings'] = 'Подешавања угнежђених група';
$string['nosuchrole'] = 'Нема такве улоге: \'{$a}\'';
$string['objectclass'] = 'objectClass која се користи за тражење курса. Обично \'group\' или \'posixGroуp\'.';
$string['objectclass_key'] = 'Класа објекта';
$string['ok'] = 'У реду!';
$string['opt_deref'] = 'Ако чланство у групи садржи јединствена препознатљива имена (DN) наведите како ће се у току претраживања руковати алијасима. Изаберите једну од следећих вредности: Не\' (LDAP_DEREF_NEVER) или \'Да\' (LDAP_DEREF_ALWAYS).';
$string['opt_deref_key'] = 'Дереференцирај алијасе (погледај својства примарних објеката)';
$string['phpldap_noextension'] = 'PHP LDAP модул изгледа није присутан. Молимо проверите да ли је инсталиран и омогућен, уколико желите да користите овај додатак за упис.';
$string['pluginname'] = 'LDAP уписи';
$string['pluginname_desc'] = '<p>Можете користити LDAP сервер за контролу ваших уписа. Подразумева се да стабло вашег LDAP-а садржи групе које се пресликавају на курсеве, као и да ће свака од тих група/курсева имати записе о чланству пресликане на полазнике.</p>
<p>Претпоставља се да су курсеви дефинисани као групе у LDAP-у, где свака група има вишеструка поља за чланство (<em>member</em> или <em>memberUid</em>) која садрже јединствену идентификацију (uniqueidentification) корисника.</p>
<p>Да бисте користили LDAP упис, ваши корисници <strong>морају</strong> имати исправно idnumber поље. LDAP групе морају имати тај idnumber у пољима чланова како би корисник био уписан на курс. Ово ће обично радити ако већ користите LDAP проверу идентитета.</p>
<p>Уписи ће бити ажурирани када се корисник пријави на систем. Можете покренути и скрипт за синхронизацију уписа. Погледајте на <em>enrol/ldap/enrol_ldap_sync.php</em>.</p>
<p>Овај додатак, такође, може бити подешен тако да аутоматски креира нове курсеве када се нове групе појаве у LDAP-у.</p>';
$string['pluginnotenabled'] = 'Додатак није омогућен!';
$string['privacy:metadata'] = 'Додатак за уписе из LDAP-а не чува никакве личне податке.';
$string['role_mapping'] = '<p>За сваку улогу морате да наведете све LDAP контексте у којима се налазе групе које представљају курсеве. Раздвојите различите контексте са знаком тачка-зарез (;).</p><p>Такође морате да наведете атрибут који Ваш LDAP користи за чување чланова групе. То је Обично \'member\' или \'memberUid\'</p>';
$string['role_mapping_attribute'] = 'LDAP атрибут корисника за {$a}';
$string['role_mapping_context'] = 'LDAP контексти за {$a}';
$string['role_mapping_key'] = 'Мапирај улоге из LDAP-а';
$string['roles'] = 'Мапирање улога';
$string['server_settings'] = 'Подешавања LDAP сервера';
$string['synccourserole'] = '== Синхронизација курса \'{$a->idnumber}\' за улогу \'{$a->role_shortname}\'';
$string['syncenrolmentstask'] = 'Синхронизација LDAP уписа';
$string['template'] = 'Опционо: аутоматски креирани курсеви могу да копирају своја подешавања из шаблона за курсеве.';
$string['template_key'] = 'Шаблон';
$string['unassignrole'] = 'Уклањање улоге \'{$a->role_shortname}\' кориснику \'{$a->user_username}\' са курса \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignrolefailed'] = 'Није успело уклањање улоге \'{$a->role_shortname}\' кориснику \'{$a->user_username}\' са курса \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignroleid'] = 'Уклањање id улоге \'{$a->role_id}\' кориснику чији је id \'{$a->user_id}\'';
$string['updatelocal'] = 'Ажурирај локалне податке';
$string['user_attribute'] = 'Ако чланство у групи садржи јединствена препознатљива имена (DN) наведите атрибут који се користи за именовање/претраживање корисника. Ако користите LDAP проверу идентитета, ова вредност треба да се поклапа са атрибутом наведеним у мапирању \'ID број\' у LDAP додатку за проверу идентитета.';
$string['user_attribute_key'] = 'ID број атрибут';
$string['user_contexts'] = 'Ако чланство у групи садржи јединствена препознатљива имена (DN) наведите списак контекста у којима се налазе корисници. Раздвојите различите контексте са \';\'. На пример: \'ou=users,o=org; ou=others,o=org\'.';
$string['user_contexts_key'] = 'Контекст';
$string['user_search_sub'] = 'Ако чланство у групи садржи јединствена препознатљива имена (DN) одредите да ли ће се корисници тражити и у потконтекстима.';
$string['user_search_sub_key'] = 'Претражи потконтексте';
$string['user_settings'] = 'Подешавања претраге корисника';
$string['user_type'] = 'Ако атрибут чланства у групи садржи јединствена препознатљива имена, наведите како су корисници смештени у LDAP-у.';
$string['user_type_key'] = 'Тип корисника';
$string['version'] = 'Верзија LDAP протокола коју користи Ваш сервер.';
$string['version_key'] = 'Верзија';
