<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'sr_cr', version '4.3'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Прилози активности Задатак';
$string['activitydate:submissionsdue'] = 'Рок:';
$string['activitydate:submissionsopen'] = 'Отвара се:';
$string['activitydate:submissionsopened'] = 'Отворено:';
$string['activityeditor'] = 'Упутства за задатак';
$string['activityeditor_help'] = 'Поступци које желите да полазник уради за овај задатак. Ово је приказано само на страници за предају рада, на којој полазник уређује и предаје свој задатак.';
$string['activityoverview'] = 'Имате задатке на које треба обратити пажњу';
$string['addattempt'] = 'Дозволи други покушај';
$string['addnewattempt'] = 'Додај нови покушај';
$string['addnewattempt_help'] = 'Ово ће креирати нови празан рад како бисте могли да радите на њему';
$string['addnewattemptfromprevious'] = 'Додај нови покушај на основу претходно предатог рада';
$string['addnewattemptfromprevious_help'] = 'Ово ће копирати садржај вашег претходног рада у нови како бисте могли да радите на њему.';
$string['addnewgroupoverride'] = 'Додај измену подешавања за групу';
$string['addnewuseroverride'] = 'Додај измену подешавања за корисника';
$string['addsubmission'] = 'Додај рад';
$string['addsubmission_help'] = 'Још увек нисте предали свој рад.';
$string['allocatedmarker'] = 'Додељени оцењивач';
$string['allocatedmarker_help'] = 'Оцењивач који је додељен за овај рад.';
$string['allowsubmissions'] = 'Дозволи кориснику да настави  предају радова на овај задатак';
$string['allowsubmissionsfromdate'] = 'Дозволи предају од';
$string['allowsubmissionsfromdate_help'] = 'Ако је ова опција омогућена полазницинеће моћи да предају рад пре овог датума. Ако је онемогућена, полазници ће одмах моћи да предају рад.';
$string['allowsubmissionsshort'] = 'Дозволи промене предатог рада';
$string['alwaysshowdescription'] = 'Увек прикажи опис';
$string['alwaysshowdescription_help'] = 'Ако је ова опција онемогућена, \'Опис задатка\' ће постати видљив полазницима тек од датума наведеног за подешавање "Дозволи предају од".';
$string['applytoteam'] = 'Примените оцене и повратне информације на целу групу';
$string['assign:addinstance'] = 'Додавање новог задатка';
$string['assign:editothersubmission'] = 'Уреди други рад полазника';
$string['assign:exportownsubmission'] = 'Извоз сопственог рада';
$string['assign:grade'] = 'Оцењивање задатка';
$string['assign:grantextension'] = 'Одобри продужетак';
$string['assign:manageallocations'] = 'Управљање оцењивачима додељеним предатим радовима';
$string['assign:managegrades'] = 'Прегледај и објави оцене';
$string['assign:manageoverrides'] = 'Управљање изменама подешавања задатка';
$string['assign:receivegradernotifications'] = 'Примај обавештења о додељеним оценама';
$string['assign:releasegrades'] = 'Објави оцене';
$string['assign:revealidentities'] = 'Откриј идентитет полазника';
$string['assign:reviewgrades'] = 'Прегледај оцене';
$string['assign:showhiddengrader'] = 'Погледајте идентитет скривеног оцењивача';
$string['assign:submit'] = 'Предај рад';
$string['assign:view'] = 'Приказ задатка';
$string['assign:viewblinddetails'] = 'Приказ идентитета полазника када је анонимно оцењивање омогућено';
$string['assign:viewgrades'] = 'Приказ оцена';
$string['assign:viewownsubmissionsummary'] = 'Приказ сажетка сопственог предатог рада';
$string['assignfeedback'] = 'Додатак за повратне информације';
$string['assignfeedbackpluginname'] = 'Додатак за повратне информације';
$string['assignmentisdue'] = 'Крајњи рок за предају је истекао';
$string['assignmentmail'] = '{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\'

Повратне информације су придружене вашем раду и можете их погледати  на:

{$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'<i>{$a->assignment}</i>\'.</p>
<p>Повратне информације можете погледати придружене вашем <a href="{$a->url}">раду</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\' . Повратне информације можете погледати придружене вашем раду.';
$string['assignmentname'] = 'Назив задатка';
$string['assignmentplugins'] = 'Додаци за задатак';
$string['assignmentsperpage'] = 'Задаци по страници';
$string['assignsubmission'] = 'Додатак за предају рада';
$string['assignsubmissionpluginname'] = 'Додатак за предају рада';
$string['assigntimeleft'] = 'Преостало време';
$string['attemptheading'] = 'Покушај {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Претходни покушаји';
$string['attemptnumber'] = 'Број покушаја';
$string['attemptreopenmethod'] = 'Додатни покушаји';
$string['attemptreopenmethod_help'] = 'Ово подешавање одређује да ли полазник може додатно да покуша да пошаље свој рад. За сваки покушај чувају се оцена и повратне информације, а предавач и полазник их могу прегледати. Доступне су следеће опције:

* Никад - могућ је само један покушај.
* Ручно - предавач може дозволити додатне покушаје.
* Аутоматски док не добије прелазну оцену - додатни покушаји за предају рада су аутоматски дозвољени све док полазник, за овај задатак, не постигне прелазну оцену која је подешена у књизи оцена.';
$string['attemptreopenmethod_manual'] = 'Ручно';
$string['attemptreopenmethod_none'] = 'Никад';
$string['attemptreopenmethod_untilpass'] = 'Аутоматски док не добије прелазну оцену';
$string['attemptsettings'] = 'Подешавања покушаја';
$string['availability'] = 'Доступност';
$string['back'] = 'Назад';
$string['backtoassignment'] = 'Повратак на задатак';
$string['batchoperationconfirmaddattempt'] = 'Дозволите још један покушај за изабране радове?';
$string['batchoperationconfirmdownloadselected'] = 'Желите да  преузмете изабране радове?';
$string['batchoperationconfirmgrantextension'] = 'Одобрити продужење рока свим изабраним радовима?';
$string['batchoperationconfirmlock'] = 'Закључајте све изабране предате радове?';
$string['batchoperationconfirmremovesubmission'] = 'Да ли желите да уклоните изабране предате радове?';
$string['batchoperationconfirmreverttodraft'] = 'Вратите изабране радове у статус нацрта?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Желите ли да подесите доделу оцењивача за све изабране предате радове?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Подесити статус тока оцењивања за све изабране радове?';
$string['batchoperationconfirmunlock'] = 'Одкључајте све изабране предате радове?';
$string['batchoperationlock'] = 'закључај предате радове';
$string['batchoperationreverttodraft'] = 'вратите предате радове у статус нацрта';
$string['batchoperationsdescription'] = 'Са изабранима...';
$string['batchoperationunlock'] = 'откључај предате радове';
$string['batchsetallocatedmarker'] = 'Додели оцењивача за следећи број изабраних корисника: {$a} .';
$string['batchsetmarkingworkflowstateforusers'] = 'Подеси статус тока оцењивања за следећи број изабраних корисника: {$a}.';
$string['beginassignment'] = 'Започните задатак';
$string['blindmarking'] = 'Анонимна предаја радова';
$string['blindmarking_help'] = 'Опција \'Анонимна предаја радова\' скрива од оцењивача идентитет полазника. Подешавања за анонимно предати рад биће закључана оног тренутка када рад буде предат или када буде оцењен.';
$string['blindmarkingenabledwarning'] = 'Анонимна предаја радова је омогућена за ову активности. Оцене се неће бити додата у књигу оцена све док се не открије идентитет ученика преко менија за оцењивање.';
$string['cachedef_overrides'] = 'Информације о изменама подешавања за корисника и групу';
$string['calendardue'] = 'Истиче крајњи рок за предају {$a}';
$string['calendargradingdue'] = '{$a} треба да буде оцењен';
$string['caneditsubmission'] = 'Можете да уредите свој рад и предате га након истека временског рока, али ће то бити означено као предаја задатка са закашњењем.';
$string['changefilters'] = 'Промени филтере';
$string['changeuser'] = 'Промени корисника';
$string['choosegradingaction'] = 'Акција оцењивања';
$string['choosemarker'] = 'Изабери...';
$string['chooseoperation'] = 'Изаберите операцију';
$string['clickexpandreviewpanel'] = 'Кликни за проширење панела за преглед';
$string['collapsegradepanel'] = 'Скупи панел за оцењивање';
$string['collapsereviewpanel'] = 'Скупи панел за преглед';
$string['comment'] = 'Коментар';
$string['completiondetail:submit'] = 'Предати рад';
$string['completionsubmit'] = 'Предати рад';
$string['configshowrecentsubmissions'] = 'Сви могу да виде обавештење о предатим радовима у извештају о скорашњим активностима.';
$string['confirmbatchgradingoperation'] = 'Да ли сте сигурни да желите да {$a->operation}  за {$a->count} полазника?';
$string['confirmstart'] = 'За завршетак овог задатка имате {$a} . Када почнете, тајмер ће почети да одбројава и не може се паузирати.';
$string['confirmsubmission'] = 'Да ли сте сигурни да желите да  предате свој рад на оцењивање? Више нећете моћи да га мењате.';
$string['confirmsubmissionheading'] = 'Потврди предају';
$string['conversionexception'] = 'Није могуће конвертовати рад. Изузетак је гласио: {$a}.';
$string['couldnotconvertgrade'] = 'Није могуће конвертовати оцену задатка за корисника {$a}.';
$string['couldnotconvertsubmission'] = 'Није могуће конвертовати предати рад за корисника {$a}.';
$string['couldnotcreatecoursemodule'] = 'Није могуће креирати модул курса';
$string['couldnotcreatenewassignmentinstance'] = 'Није могуће креирати нову инстанцу задатка';
$string['couldnotfindassignmenttoupgrade'] = 'Није могуће наћи стару инстанцу задатка за надоградњу';
$string['crontask'] = 'Позадинска обрада за модул \'Задатак\'';
$string['currentassigngrade'] = 'Тренутна оцена за задатак';
$string['currentattempt'] = 'Ово је покушај {$a}.';
$string['currentattemptof'] = 'Ово је покушај {$a->attemptnumber} ( {$a->maxattempts} дозвољена/их покушаја ).';
$string['currentgrade'] = 'Тренутна оцена у књизи оцена';
$string['cutoffdate'] = 'Дефинитивни рок';
$string['cutoffdate_help'] = 'Ако је подешен овај датум, након њега неће бити могуће предати рад без продужетка рока за предају.';
$string['cutoffdatecolon'] = 'Дефинитивни рок: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Дефинитивни рок за предају не може бити пре датума од ког је дозвољена предаја рада.';
$string['cutoffdatevalidation'] = 'Дефинитивни рок не може бити пре крајњег рока за предају рада.';
$string['defaultlayout'] = 'Рестаурирај подразумевани распоред';
$string['defaultsettings'] = 'Подразумевана подешавања задатка';
$string['defaultsettings_help'] = 'Ова подешавања дефинишу подразмеване вредности за све нове задатке';
$string['defaultteam'] = 'Подразумевана група';
$string['deleteallsubmissions'] = 'Обриши све предате радове';
$string['description'] = 'Опис';
$string['disabled'] = 'Онемогућено';
$string['downloadall'] = 'Преузми све предате радове';
$string['downloadasfolders'] = 'Преузми радове као директоријуме';
$string['downloadasfolders_help'] = 'Предати радови се могу преузети у директоријумима. Сваки предати рад се смешта у засебан директоријум, са очувавањем структуре директоријума са евентуалним поддиректоријумима, а датотекама се не мењају називи.';
$string['downloadselectedsubmissions'] = 'Преузми изабране радове';
$string['duedate'] = 'Крајњи рок';
$string['duedate_help'] = 'Овај датум представља крајњи рок за предају задатка. Предаја након овог датума ће и даље бити дозвољена, али ће сви радови предати након овог датума бити обележени као закаснели. Да бисте спречили предају радова након одређеног датума подесите дефинитивни рок за предају рада.';
$string['duedateaftersubmissionvalidation'] = 'Крајњи рок мора бити након датума од ког је дозвољена предаја рада.';
$string['duedatecolon'] = 'Крајњи рок: {$a}';
$string['duedatereached'] = 'Крајњи рок за овај задатак је сада истекао';
$string['duedatevalidation'] = 'Крајњи рок за предају не може бити пре датума од којег је дозвољена предаја.';
$string['duplicateoverride'] = 'Креирај копију измене';
$string['editaction'] = 'Акције...';
$string['editattemptfeedback'] = 'Уреди оцену и повратне информације за покушај број {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Уређујете повратне информације за претходни покушај. Ово је покушај {$a->attemptnumber} од укупно {$a->totalattempts}.';
$string['editingstatus'] = 'Статус уређивања';
$string['editonline'] = 'Уреди онлајн';
$string['editoverride'] = 'Уреди измену';
$string['editsubmission'] = 'Уреди рад';
$string['editsubmission_help'] = 'Још увек можете да направите промене у свом раду.';
$string['editsubmissionother'] = 'Уреди рад за {$a}';
$string['enabled'] = 'Омогућено';
$string['enabletimelimit'] = 'Омогући временски ограничене задатке';
$string['enabletimelimit_help'] = 'Ако је ова опција омогућена, можете подесити временско ограничење на страници за подешавања задатка.';
$string['errornosubmissions'] = 'Нема предатих радова за преузимање';
$string['errorquickgradingvsadvancedgrading'] = 'Оцене нису сачуване зато што овај задатак тренутно користи напредно оцењивање';
$string['errorrecordmodified'] = 'Оцене нису сачуване зато што је неко изменио један или више записа након што сте учитали страницу';
$string['eventallsubmissionsdownloaded'] = 'Сви предати радови се преузимају.';
$string['eventassessablesubmitted'] = 'Рад је предат.';
$string['eventbatchsetmarkerallocationviewed'] = 'Групна додела оцењивача приказана';
$string['eventbatchsetworkflowstateviewed'] = 'Групно подешавање статуса тока оцењивања приказано';
$string['eventextensiongranted'] = 'Продужетак је одобрен.';
$string['eventfeedbackupdated'] = 'Повратне информације ажуриране';
$string['eventfeedbackviewed'] = 'Повратне информације приказане';
$string['eventgradingformviewed'] = 'Образац за оцењивање приказан';
$string['eventgradingtableviewed'] = 'Табела за оцењивања приказана';
$string['eventidentitiesrevealed'] = 'Идентитети су откривени.';
$string['eventmarkerupdated'] = 'Додељени оцењивач је ажуриран.';
$string['eventoverridecreated'] = 'Измена подешавања задатка креирана';
$string['eventoverridedeleted'] = 'Измена подешавања задатка обрисана';
$string['eventoverrideupdated'] = 'Измена подешавања задатка ажурирана';
$string['eventremovesubmissionformviewed'] = 'Потврда за уклањање послатог рада приказана.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Страница за потврду откривања идентитета приказана';
$string['eventstatementaccepted'] = 'Корисник је прихватио изјаву о предаjи рада.';
$string['eventsubmissionconfirmationformviewed'] = 'Образац за потврду о предаји рада приказан.';
$string['eventsubmissioncreated'] = 'Предати рад креиран';
$string['eventsubmissionduplicated'] = 'Корисник је предао дупликат свог рада.';
$string['eventsubmissionformviewed'] = 'Образац за предају рада приказан';
$string['eventsubmissiongraded'] = 'Предати рад је оцењен.';
$string['eventsubmissionlocked'] = 'Предати радови су закључани за корисника.';
$string['eventsubmissionremoved'] = 'Предати рад је уклоњен.';
$string['eventsubmissionstatusupdated'] = 'Статус предатог рада је ажуриран.';
$string['eventsubmissionstatusviewed'] = 'Статус предатог рада је приказан.';
$string['eventsubmissionunlocked'] = 'Предати радови су откључани за корисника.';
$string['eventsubmissionupdated'] = 'Предати рад ажуриран';
$string['eventsubmissionviewed'] = 'Предати рад приказан';
$string['eventworkflowstateupdated'] = 'Статус тока оцењивања је ажурирано.';
$string['expandreviewpanel'] = 'Рашири панел за преглед';
$string['extensionduedate'] = 'Продужени рок';
$string['extensionnotafterduedate'] = 'Продужени рок мора бити након крајњег рока за предају рада.';
$string['extensionnotafterfromdate'] = 'Продужени рок мора бити након датумa од ког је дозвољена предаја решења.';
$string['feedback'] = 'Повратне информације';
$string['feedbackavailableanonhtml'] = 'Имате нове повратне на
рад који сте предали за задатак \'<i>{$a->assignment}</i>\'<br /><br />
Повратне информације можете погледати придружене вашем <a href="{$a->url}">раду</a>.';
$string['feedbackavailableanonsmall'] = 'Нове повратне информације за задатак  {$a->assignment}';
$string['feedbackavailableanontext'] = 'Имате нове повратне на
рад који сте предали за задатак \'{$a->assignment}\'

Повратне информације су придружене вашем раду и можете их погледати на:

{$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} је послао/ла повратне информације на рад који сте предали за задатак  \'<i>{$a->assignment}</i>\'<br /><br /> Повратне информације можете погледати придружене вашем <a href="{$a->url}">предатом раду</a>.';
$string['feedbackavailablesmall'] = '{$a->username} је дао/ла повратне информације за задатак {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\'

Повратне информације су придружене вашем раду и можете их погледати  на:

{$a->url}';
$string['feedbackplugin'] = 'Додатак за повратне информације';
$string['feedbackpluginforgradebook'] = 'Додатак за повратне информације који ће пребацивати коментаре у књигу оцена';
$string['feedbackpluginforgradebook_help'] = 'Само један додатак за повратне информације задатка може да пребаци повратне информације у књигу оцена.';
$string['feedbackplugins'] = 'Додаци за повратне информације';
$string['feedbacksettings'] = 'Подешавања повратних информација';
$string['feedbacktypes'] = 'Врсте повратних информација';
$string['filesubmissions'] = 'Предаја датотека';
$string['filter'] = 'Филтер';
$string['filterdraft'] = 'Радна верзија';
$string['filtergrantedextension'] = 'Одобрен продужетак';
$string['filternone'] = 'Нема филтера';
$string['filternotsubmitted'] = 'Није предато';
$string['filterrequiregrading'] = 'Захтева оцењивање';
$string['filtersubmitted'] = 'Предато';
$string['fixrescalednullgrades'] = 'Овај задатак садржи неке погрешне оцене. Можете <a href="{$a->link}">аутоматски поправити ове оцене</a>. Ово може утицати на укупну оцену.';
$string['fixrescalednullgradesconfirm'] = 'Да ли сте сигурни да желите поправити погрешне оцене? Све погрешне оцене ће бити уклоњене. Ово може утицати на укупну оцену.';
$string['fixrescalednullgradesdone'] = 'Оцене поправљене.';
$string['gradeabovemaximum'] = 'Оцена мора да буде мања од или једнака {$a}';
$string['gradebelowzero'] = 'Оцена мора бити већа од или једнака нули';
$string['gradebreakdown'] = 'Разврставање оцена';
$string['gradecanbechanged'] = 'Оцена може бити промењена';
$string['gradechangessaveddetail'] = 'Промене оцена и повратних информација су сачуване';
$string['graded'] = 'Оцењено';
$string['gradedby'] = 'Оценио/ла';
$string['gradedfollowupsubmit'] = 'Оцењено - поново предат рад';
$string['gradedon'] = 'Оцењено';
$string['gradeitem:submissions'] = 'Предати радови';
$string['gradelocked'] = 'Ова оцена је закључана или измењена у књизи оцена.';
$string['gradeoutof'] = 'Оцена од {$a}';
$string['gradeoutofhelp'] = 'Оцена';
$string['gradeoutofhelp_help'] = 'Овде унесите оцену за рад полазника. Можете укључити децимале.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} је ажурирао/ла своје решење задатка <i>\'{$a->assignment}\' у  {$a->timeupdated}</i><br /><br />
Решење је <a href="{$a->url}">доступно на веб сајту</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} је ажурирао/ла свој рад за задатак за задатак {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} је ажурирао/ла свој рад за задатак \'{$a->assignment}\' у  {$a->timeupdated}

Рад је доступно на следећој адреси:

{$a->url}';
$string['gradestudent'] = 'Оцени полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['gradeuser'] = 'Оцена {$a}';
$string['grading'] = 'Оцењивање';
$string['gradingchangessaved'] = 'Промене оцена су сачуване';
$string['gradingduedate'] = 'Подсети ме да оценим до';
$string['gradingduedate_help'] = 'Датум до ког треба да буде завршено оцењивање предатих радова. Овај датум се користи како би се одредио приоритет обавештења која се појављују на контролном панелу предавача.';
$string['gradingdueduedatevalidation'] = 'Датум до када радови треба да буду оцењени не може бити пре датума када истиче крајњи рок за њихову предају.';
$string['gradingduefromdatevalidation'] = 'Датум до када радови треба да буду оцењени не може бити пре датума од ког је дозвољена њихова предаја.';
$string['gradingmethodpreview'] = 'Критеријуми оцењивања';
$string['gradingoptions'] = 'Опције';
$string['gradingstatus'] = 'Статус оцењивања';
$string['gradingstudent'] = 'Оцењивање полазника';
$string['gradingsummary'] = 'Резиме оцењивања';
$string['grantextension'] = 'Одобри продужетак';
$string['grantextensionforusers'] = 'Одобри продужетак за {$a} полазника';
$string['groupoverrides'] = 'Измене подешавања за групе';
$string['groupoverridesdeleted'] = 'Измене подешавања за групе обрисане';
$string['groupsnone'] = 'Не постоје групе којима можете приступити.';
$string['groupsubmissionsettings'] = 'Подешавања за групну предају рада';
$string['hiddenuser'] = 'Учесник';
$string['hidegrader'] = 'Сакријте идентитет оцењивача од полазника';
$string['hidegrader_help'] = 'Ако је омогућена ова опција, идентитет било ког корисника који оцењује предате радове се не приказује, тако да студенти не могу да виде ко је оценио њихов рад.

Имајте у виду да ово подешавање нема утицаја на поље за коментаре на страници за оцењивање.';
$string['hideshow'] = 'Сакриј/Прикажи';
$string['inactiveoverridehelp'] = '* Ова измена је неактивна, јер је приступ корисника активности ограничен. То може бити због групе или улоге који су кориснима додељени, због  других ограничења приступа или због тога што је активност скривена.';
$string['indicator:cognitivedepth'] = 'Задатак - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'Задатак\'.';
$string['indicator:cognitivedepthdef'] = 'Задатак - когнитивни аспект';
$string['indicator:cognitivedepthdef_help'] = 'Учесник је постигао овај проценат когнитивног ангажмана који нуде активности Задатак током овог интервала анализе (Нивои = Без прегледа, Преглед, Предаја рада, Преглед повратних информација, Коментар на повратне информације, Поновна предаја рада након прегледа повратних информација)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Задатак - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'Задатак\'.';
$string['indicator:socialbreadthdef'] = 'Задатак - социјални аспект';
$string['indicator:socialbreadthdef_help'] = 'Учесник је постигао овај проценат социјалног ангажмана који нуде активности Задатак током овог интервала анализе (Нивои = Без учешћа, Учесник сâм, Учесник са другима)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Датотеке са инструкцијама';
$string['introattachments'] = 'Додатне датотеке';
$string['introattachments_help'] = 'Додатне датотеке у задатку, као што су шаблони одговора, могу да се додају.';
$string['invalidfloatforgrade'] = 'Није могуће разумети оцену која је дата: {$a}';
$string['invalidgradeforscale'] = 'Оцена која је дата није исправна за текућу скалу';
$string['invalidoverrideid'] = 'Неисправна ID ознака измене';
$string['lastmodifiedgrade'] = 'Последње измене (оцена)';
$string['lastmodifiedsubmission'] = 'Последње измене (предати рад)';
$string['latesubmissions'] = 'Касно предати радови';
$string['latesubmissionsaccepted'] = 'Дозвољено до {$a}';
$string['loading'] = 'Учитавање...';
$string['locksubmissionforstudent'] = 'Спречи даљу предају радова за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['locksubmissions'] = 'Закључај предате радове';
$string['manageassignfeedbackplugins'] = 'Управљање додацима за повратне информације';
$string['manageassignsubmissionplugins'] = 'Управљање додацима за предају радова';
$string['marker'] = 'Оцењивач';
$string['markerfilter'] = 'Филтер оцењивача';
$string['markerfilternomarker'] = 'Нема оцењивача';
$string['markingallocation'] = 'Користи доделу оцењивача';
$string['markingallocation_help'] = 'Ако је ово подешавање омогућено, заједно са током оцењивања, оцењивачи могу бити додељени одређеним полазницима.';
$string['markingworkflow'] = 'Користи ток оцењивања';
$string['markingworkflow_help'] = 'Ако је ово подешавање омогућено, оцене ће проћи кроз низ фаза у процесу оцењивања пре него што буду објављене полазницима. Ово омогућава више кругова оцењивања, као и да оцене буду објављене полазницима истовремено.';
$string['markingworkflowstate'] = 'Статус тока оцењивања';
$string['markingworkflowstate_help'] = 'Могућа стања тока оцењивања могу да укључе (зависно од ваших овлашћења):

* Неоцењено - оцењивач још није започео оцењивање
* Оцењује се - оцењивач је започео оцењивање али га још није завршио
* Оцењивање завршено . оцењивач је завршио оцењивање,  али је можда потребно да се врати због провере/исправки
* На прегледу - оцењивање је сада код надлежног наставника одговорног за проверу квалитета
* Спремно за објављивање - надлежни наставник је задовољан са оцењивањем али може да сачека пре него што полазницима дозволи приступ оценама
* Објављено - полазници могу да приступе оценама/повратним информацијама';
$string['markingworkflowstateinmarking'] = 'Оцењује се';
$string['markingworkflowstateinreview'] = 'На прегледу';
$string['markingworkflowstatenotmarked'] = 'Није оцењено';
$string['markingworkflowstatereadyforrelease'] = 'Спремно за објаву';
$string['markingworkflowstatereadyforreview'] = 'Оцењивање завршено';
$string['markingworkflowstatereleased'] = 'Објављено';
$string['maxattempts'] = 'Максималан број покушаја';
$string['maxattempts_help'] = 'Максималан број дозвољених покушаја предаје рада од стране полазника. Након овог броја покушаја рад полазника више не може бити поново отворен.';
$string['maxgrade'] = 'Максимална оцена';
$string['maxperpage'] = 'Максимална број задатака по страници';
$string['maxperpage_help'] = 'Максималан број задатака који оцењивач може да прикаже на страници за оцењивање. Ово подешавање је корисно како би се спречила временска ограничења на курсевима са великим бројем уписаних полазника.';
$string['messageprovider:assign_notification'] = 'Обавештење о задатку';
$string['modulename'] = 'Задатак';
$string['modulename_help'] = 'Модул активности "Задатак"  пружа могућност наставнику да полазницима  задаје задатке, прикупља њихове радове, оцењује их, као и да им  шаље повратне информације.

Полазници, као свој рад, могу да предају различите дигиталне садржаје (датотеке), као што су текстуални документи, прорачунске табеле, слике, презентације или аудио и видео клипови. Алтернативно, или као додатак претходном, задатак може да тражи од полазника да текст унесу директно у текст едитор. Задатак, такође, може да се користи као подсетник полазницима за „стварни“ задатак који морају да ураде „офлајн“, ван сајта, попут  рецимо неког уметничког рада, цртежа итд, а да се при томе од њих не захтева слање било каквог дигиталног садржаја. Полазници могу да предају рад индивидуално или као чланови групе.

Приликом прегледања задатака, наставници могу да остављају коментаре, повратне информације и постављају датотеке, као што су прегледани и  обележени радови полазника са коментарима, засебни докуменати са коментарима или повратне информације у говорном тј. аудио формату. Задаци се оцењује бројчаном,  или наменски прилагођеном, скалом за оцењивање, или, коришћењем напредних метода оцењивања као што су рубрике. Завршне оцене се записују у књигу оцена.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Задаци';
$string['moreusers'] = 'још {$a}...';
$string['multipleteams'] = 'Члан више од једне групе';
$string['multipleteams_desc'] = 'Овај задатак тражи групну предају рада. Члан сте више од једне групе. Да бисте могли да предате рад морате да будете члан само једне групе. Контактирајте свог предавача како би променио ваше чланство у групи.';
$string['multipleteamsgrader'] = 'Члан више од једне групе, тако да не може да преда рад.';
$string['newsubmissions'] = 'Задаци су предати';
$string['nextuser'] = 'Следећи корисник';
$string['noattempt'] = 'Нема покушаја';
$string['noclose'] = 'Нема датума затварања задатка';
$string['nofiles'] = 'Нема датотека';
$string['nofilters'] = 'Нема филтера';
$string['nograde'] = 'Нема оцене';
$string['nogroupoverrides'] = 'Тренутно нема измена подешавања за групе.';
$string['nomoresubmissionsaccepted'] = 'Дозвољено само полазницима којима је одобрен продужетак';
$string['none'] = 'Ниједна';
$string['noonlinesubmissions'] = 'Овај задатак не тражи од вас да било штa предате  онлајн';
$string['noopen'] = 'Нема датума отварања задатка';
$string['nooverridedata'] = 'Морате да измените барем једно од подешавања задатка.';
$string['nosavebutnext'] = 'Следећи';
$string['nosubmission'] = 'За овај задатак још ништа није предато';
$string['nosubmissionyet'] = 'Није предат још ниједан рад';
$string['noteam'] = 'Није члан ниједне групе.';
$string['noteam_desc'] = 'Овај задатак тражи групну предају рада. Нисте члан ниједне групе, тако да не можете да предате рад. Контактирајте свог предавача како би вас додао у групу.';
$string['noteamgrader'] = 'Није члан ниједне групе, тако да не може да преда рад.';
$string['notgraded'] = 'Није оцењено';
$string['notgradedyet'] = 'Још није оцењено';
$string['notifications'] = 'Обавештења';
$string['nouseroverrides'] = 'Тренутно нема измена подешавања за кориснике.';
$string['nousers'] = 'Нема корисника';
$string['nousersselected'] = 'Није изабран ниједан полазник';
$string['numberofdraftsubmissions'] = 'Радне верзије';
$string['numberofparticipants'] = 'Учесници';
$string['numberofsubmissionsneedgrading'] = 'Тражи оцењивање';
$string['numberofsubmissionsneedgradinglabel'] = 'Потребно је оцењивање: {$a}';
$string['numberofsubmittedassignments'] = 'Предато';
$string['numberofteams'] = 'Групе';
$string['offline'] = 'Не тражи се онлајн предаја рада';
$string['open'] = 'Отворено';
$string['opensubmissionexists'] = 'Отворена предаја рада већ постоји';
$string['outlinegrade'] = 'Оцена: {$a}';
$string['outof'] = '{$a->current} од {$a->total}';
$string['overdue'] = 'Крајњи рок за предају рада је истекао пре: {$a}';
$string['override'] = 'Измена';
$string['overridedeletegroupsure'] = 'Да ли сте сигурни да желите да избришете измену подешавања за групу {$a}?';
$string['overridedeleteusersure'] = 'Да ли сте сигурни да желите да избришете измену подешавања за корисника {$a}?';
$string['overridegroup'] = 'Измени подешавања за групу';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Измене';
$string['overrideuser'] = 'Измени подешавања за корисника';
$string['overrideusereventname'] = '{$a->assign} - Измена';
$string['page-mod-assign-view'] = 'Главна страница модула \'Задатак\' и страница за предају рада';
$string['page-mod-assign-x'] = 'Било која страница модула \'Задатак\'';
$string['paramtimeremaining'] = 'Преостало време: {$a}';
$string['participant'] = 'Учесник';
$string['pluginadministration'] = 'Администрација задатака';
$string['pluginname'] = 'Задатак';
$string['preventsubmissionnotingroup'] = 'Неопходна је група за предају рада';
$string['preventsubmissionnotingroup_help'] = 'Ако је ова опција омогућена, корисници који нису чланови групе неће моћи да предају радове.';
$string['preventsubmissions'] = 'Спречи корисника да више не предаје своје радове за овај задатак.';
$string['preventsubmissionsshort'] = 'Спречи измене предатих радова';
$string['previous'] = 'Претходни';
$string['previoususer'] = 'Претходни корисник';
$string['privacy:attemptpath'] = 'покушај {$a}';
$string['privacy:blindmarkingidentifier'] = 'Идентификатор који се користи за анонимно предате радове';
$string['privacy:gradepath'] = 'оцена';
$string['privacy:metadata:assigndownloadasfolders'] = 'Корисничка преференција везана за то да ли да се више предатих докумената преузме у директоријуме';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Повратне информације за задатак.';
$string['privacy:metadata:assignfilter'] = 'Опције за филтрирање као што су \'Предато\', \'Није предато\', \'Захтева оцењивање\', and \'Одобрен продужетак\'';
$string['privacy:metadata:assigngrades'] = 'Чува корисничке оцене за задатак';
$string['privacy:metadata:assignmarkerfilter'] = 'Филтрирај сажетак задатка према додељеном оцењивачу';
$string['privacy:metadata:assignmentid'] = 'Идентификатор задатка';
$string['privacy:metadata:assignmessageexplanation'] = 'Поруке се полазницима шаљу кроз интерни систем за слање порука.';
$string['privacy:metadata:assignoverrides'] = 'Чува информације о измењеним подешавањима везаним за задатак';
$string['privacy:metadata:assignperpage'] = 'Број задатака који се приказују по страници.';
$string['privacy:metadata:assignquickgrading'] = 'Преференција везана за то да ли се користи брзо оцењивање или не.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Чува податке о предатим радовима корисника';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Подаци о предатим задацима.';
$string['privacy:metadata:assignuserflags'] = 'Чува мета податке корисника као што су датуми продужетака';
$string['privacy:metadata:assignusermapping'] = 'Мапирање за анонимно предате радова';
$string['privacy:metadata:assignworkflowfilter'] = 'Филтрирај према различитим стадијумима тока рада.';
$string['privacy:metadata:grade'] = 'Нумеричка оцена за предати рад. Може се одредити на основу подешавања скала, напредних форми за оцењивање и сл. али ће увек бити конвертована у реални број.';
$string['privacy:metadata:grader'] = 'Идентификатор корисника који оцењује.';
$string['privacy:metadata:groupid'] = 'Идентификатор групе чији је корисник члан.';
$string['privacy:metadata:latest'] = 'Прилично поједностављује упите везане за добијање информација само о најфришкијем покушају.';
$string['privacy:metadata:mailed'] = 'Да ли је овом кориснику већ послата електронска порука?';
$string['privacy:metadata:timecreated'] = 'Време креирања';
$string['privacy:metadata:timestarted'] = 'Започето';
$string['privacy:metadata:userid'] = 'ID ознака корисника';
$string['privacy:studentpath'] = 'радови полазника';
$string['privacy:submissionpath'] = 'рад';
$string['quickgrading'] = 'Брзо оцењивања';
$string['quickgrading_help'] = 'Брзо оцењивање вам дозвољава да доделите оцене (и исходе) директно у табели предатих задатака. Брзо оцењивање није компатибилно са напредним оцењивањем и не препоручује се када постоји више оцењивача.';
$string['quickgradingchangessaved'] = 'Промене оцена су сачуване';
$string['quickgradingresult'] = 'Брзо оцењивање';
$string['recordid'] = 'Индетификатор';
$string['relativedatessubmissiontimeleft'] = 'Израчунато за сваког студента';
$string['removeallgroupoverrides'] = 'Обриши све измене за групе';
$string['removealluseroverrides'] = 'Обриши све измене за кориснике';
$string['removesubmission'] = 'Уклони предати рад';
$string['removesubmissionconfirm'] = 'Да ли сте сигурни да желите да уклоните свој предати рад?';
$string['removesubmissionconfirmforstudent'] = 'Да ли сте сигурни да желите да уклоните предати рад за полазника {$a}?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Да ли стварно желите да уклоните предати рад за {$а}? Имајте на уму да овим нећете ресетовати временско ограничење у подешавањима. Можете дати више времена тако што ћете изменити подешавање за кориснике које се односи на временско ограничење.';
$string['removesubmissionconfirmwithtimelimit'] = 'Да ли сте сигурни да желите да уклоните свој предати рад? Имајте на уму да ово неће ресетовати ваше временско ограничење.';
$string['removesubmissionforstudent'] = 'Уклоните предати рад за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Држите отвореним све док је опције за прелазну оцену некомпатибилна са анонимном предајом радова, пошто се оцене не шаљу у дневник оцена све док се не открије идентитет полазника.';
$string['requireallteammemberssubmit'] = 'Неопходна је предаја рада од стране свих чланова групе';
$string['requireallteammemberssubmit_help'] = 'Ово подешавање се мора користити заједно са подешавањем \'Захтевај да полазници кликну на дугме за предају рада\' у подешавањима за предају рада.

Ако је ова опција омогућена сви чланови групе ће морати да кликну на дугме за предају рада, да би он могао да се сматра предатим. Ако је опција онемогућена, било који члан групе може да кликне на дугме за предају рада.';
$string['requiresubmissionstatement'] = 'Захтевај да полазници прихвате изјаву о предаји рада';
$string['requiresubmissionstatement_help'] = 'Захтевај да полазници прихвате изјаву о предаји рада за све предате радове за овај задатак.';
$string['revealidentities'] = 'Откриј идентитет полазника';
$string['revealidentitiesconfirm'] = 'Да ли сте сигурни да желите да откријете идентитет полазника за овај задатак? Ова операција не може бити поништена, Једном када се идентитет полазника открије оцене ће бити објављене у књизи оцена.';
$string['reverttodefaults'] = 'Врати задатак на стандардна подешавања';
$string['reverttodraft'] = 'Врати предати рад у статус нацрта';
$string['reverttodraftforgroup'] = 'Врати предати рад у статус нацрта за групу {$a}.';
$string['reverttodraftforstudent'] = 'Врати рад у статус нацрта за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['reverttodraftshort'] = 'Врати предати рад у статус нацрта';
$string['reviewed'] = 'Прегледано';
$string['save'] = 'Сачувај';
$string['saveallquickgradingchanges'] = 'Сачувај све промене брзог оцењивања';
$string['saveandcontinue'] = 'Сачувај и настави';
$string['savechanges'] = 'Сачувај промене';
$string['savegradingresult'] = 'Оцена';
$string['savenext'] = 'Сачувај и прикажи следећи';
$string['saveoverrideandstay'] = 'Сачувај и унеси другу измену';
$string['savingchanges'] = 'Чување промена...';
$string['scale'] = 'Скала';
$string['search:activity'] = 'Задатак - информације о активности';
$string['selectedusers'] = 'Одабрани корисници';
$string['selectlink'] = 'Изабери...';
$string['selectuser'] = 'Изабери {$a}';
$string['sendlatenotifications'] = 'Обавести оцењиваче о радовима који су предати са закашњењем';
$string['sendlatenotifications_help'] = 'Ако је ова опција омогућена, оцењивачи (обично предавачи) ће добити поруку кад год полазник рад преда са закашњењем. Начин слања поруке се може подесити.';
$string['sendnotifications'] = 'Обавести оцењиваче о предатим радовима';
$string['sendnotifications_help'] = 'Ако је ова опција омогућена, оцењивачи (обично предавачи) ће добити поруку кад год полазник рад преда раније, на време и са закашњењем. Начин слања поруке се може подесити.';
$string['sendstudentnotifications'] = 'Обавести полазника';
$string['sendstudentnotifications_help'] = 'Означите ово поље како бисте послали обавештење о ажурираној оцени или повратним информацијама. Ако је у овом задатку омогућено праћење тока оцењивања или су оцене сакривене у извештају оцењивача, онда обавештење неће бити послато све док се оцена не објави.';
$string['sendstudentnotificationsdefault'] = 'Подразумевано подешавање за \'Обавести полазника\'';
$string['sendstudentnotificationsdefault_help'] = 'Приликом оцењивања сваког полазника, треба ли стандардно  означити опцију \'Обавести полазника\'?';
$string['sendsubmissionreceipts'] = 'Пошаљи полазницима потврду о предатом раду';
$string['sendsubmissionreceipts_help'] = 'Ово омогућава слање потврду о предатом раду. Полазници ће примити обавештење сваки пут када успешно предају рад.';
$string['setmarkerallocationforlog'] = 'Подеси доделу оцењивања : (id={$a->id}, име и презиме={$a->fullname}, оцењивач={$a->marker}).';
$string['setmarkingallocation'] = 'Подеси додељеног оцењивача';
$string['setmarkingworkflowstate'] = 'Подеси статус тока оцењивања';
$string['setmarkingworkflowstateforlog'] = 'Подеси статус тока оцењивања : (id={$a->id}, име и презиме={$a->fullname}, статус={$a->state}).';
$string['settings'] = 'Подешавања задатка';
$string['showrecentsubmissions'] = 'Прикажи недавно предате радове';
$string['status'] = 'Статус';
$string['studentnotificationworkflowstateerror'] = 'Ток оцењивања мора бити у статусу "Објављено" да би се полазници курса обавестили о оценама.';
$string['submission'] = 'Предати рад';
$string['submissionattachments'] = 'Прикажи датотеке само током слања';
$string['submissionattachments_help'] = 'Означите поље како би на страници за предају рада били приказане само датотека. У супротном, датотеке ће бити приказане и на страници задатка и на страници за предају рада.';
$string['submissioncopiedhtml'] = '<p>Направили сте копију свог претходног рада за задатак \'<i>{$a->assignment}</i>\'.</p>
<p>Можете видети статус свог <a href="{$a->url}">предатог рада</a>.</p>';
$string['submissioncopiedsmall'] = 'Копирали сте свој претходни рад за задатак {$a->assignment}';
$string['submissioncopiedtext'] = 'Направили сте копију свог претходног рада за задатак \'{$a->assignment}\'

Можете видети статус свог предатог рада:

    {$a->url}';
$string['submissiondrafts'] = 'Захтевај да полазници кликну на дугме за предају рада';
$string['submissiondrafts_help'] = 'Ако је ова опција омогућена, полазници ће морати да кликну на дугме \'Предај\' како би свој рад прогласили коначним. Ово омогућава полазницима да унутар система чувају верзију нацрта свог рада. Ако се ово подешавање са "Не" промени на "Да" након што су полазници предали своје радове те верзије њихових радове ће бити сматране коначним.';
$string['submissioneditable'] = 'Полазници могу да уређују овај задатак';
$string['submissionempty'] = 'Ништа није предато';
$string['submissionlog'] = 'Полазник: {$a->fullname}, Статус: {$a->status}';
$string['submissionmodified'] = 'Већ имате предате радове. Молим вас, напустите ову страницу и покушајте поново.';
$string['submissionmodifiedgroup'] = 'Неко други је изменио предати рад. Молим вас, напустите ову страницу и покушајте поново.';
$string['submissionnotcopiedinvalidstatus'] = 'Рад није копиран зато што је промењен од момента када је поново отворен.';
$string['submissionnoteditable'] = 'Полазници не могу да уређују овај задатак';
$string['submissionnotopen'] = 'Овај задатак није отворен за предају радова';
$string['submissionnotready'] = 'Овај задатак није спреман за предају радова:';
$string['submissionplugins'] = 'Додаци за предају радова';
$string['submissionreceipthtml'] = '<p>Предали сте свој рад за задатак \'<i>{$a->assignment}</i>\' </p>
<p>Можете видети статус свог <a href="{$a->url}">предатог рада</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Ваш рад за задатак
\'<i>{$a->assignment}</i>\' је предат.<br /><br />
Можете да видите статус вашег <a href="{$a->url}">предатог рада</a>.';
$string['submissionreceiptothersmall'] = 'Ваш рад за задатак {$a->assignment} је предат.';
$string['submissionreceiptothertext'] = 'Ваш рад за задатак
\'<i>{$a->assignment}</i>\' је предат.

Можете да видите статус вашег предатог рада:

   {$a->url}';
$string['submissionreceipts'] = 'Пошаљи потврду о предатом раду';
$string['submissionreceiptsmall'] = 'Предали сте свој рад за задатак {$a->assignment}';
$string['submissionreceipttext'] = 'Предали сте свој рад за задатак \'{$a->assignment}</i>\'

Можете видети статус свог рада на следећој адреси:

   {$a->url}';
$string['submissionsclosed'] = 'Предаја радова је затворена';
$string['submissionsettings'] = 'Подешавања за предају рада';
$string['submissionslocked'] = 'Овај задатак не прихвата предају радова';
$string['submissionslockedshort'] = 'Промене предатих радова нису дозвољене';
$string['submissionstatement'] = 'Изјава о предаји рада';
$string['submissionstatement_help'] = 'Изјава коју сваки полазник мора да прихвати како би предао свој рад.';
$string['submissionstatementacceptedlog'] = 'Корисник {$a} је прихватио/ла изјаву о предаји рада';
$string['submissionstatementdefault'] = 'Овај рад је мој, осим тамо где сам признао/ла да су коришћена дела других људи.';
$string['submissionstatementrequired'] = 'Од вас се тражи да се сложите са овом изјавом пре него што будете могли да предате свој рад.';
$string['submissionstatementteamsubmission'] = 'Изјава о предаји групног рада';
$string['submissionstatementteamsubmission_help'] = 'Изјава коју сваки полазник мора да прихвати како би предао рад своје групе.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Изјава о предаји групног рад где сви чланови групе предају рад';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Изјава коју сваки полазник мора да прихвати како би предао свој рад као члан групе';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Овај рад је мој, као члана група, осим тамо где сам признао/ла да су коришћена дела других људи.';
$string['submissionstatementteamsubmissiondefault'] = 'Ово је рад моје групе, осим тамо где смо признали да су коришћена дела других људи.';
$string['submissionstatus'] = 'Статус предатог рада';
$string['submissionstatus_'] = 'Нема предатих радова';
$string['submissionstatus_draft'] = 'Радна верзија (није предата)';
$string['submissionstatus_marked'] = 'Оцењено';
$string['submissionstatus_new'] = 'Нема предатих радова';
$string['submissionstatus_reopened'] = 'Поново отворено';
$string['submissionstatus_submitted'] = 'Предато за оцењивање';
$string['submissionstatusheading'] = 'Статус предатог рада';
$string['submissionsummary'] = '{$a->status}. Последњи пут промењено {$a->timemodified}';
$string['submissionteam'] = 'Група';
$string['submissiontypes'] = 'Врста предатог рада';
$string['submitaction'] = 'Предај';
$string['submitassignment'] = 'Предај рад';
$string['submitassignment_help'] = 'Када се овај рад преда, више нећете моћи да га мењате.';
$string['submitforgrading'] = 'Предај на оцењивање';
$string['submitted'] = 'Предато';
$string['submittedearly'] = 'Задатак је предат {$a} раније';
$string['submittedlate'] = 'Задатак је предат {$a} касније';
$string['submittedlateshort'] = '{$a} касније';
$string['submittedovertime'] = 'Рад је предат {$a} након истека временског ограничења';
$string['submittedundertime'] = 'Рад је предат {$a} пре истека временског ограничења';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Додатак за повратне информације';
$string['subplugintype_assignfeedback_plural'] = 'Додаци за повратне информација';
$string['subplugintype_assignsubmission'] = 'Додатак за предају рада';
$string['subplugintype_assignsubmission_plural'] = 'Додаци за предају рада';
$string['teamname'] = 'Тим: {$a}';
$string['teamsubmission'] = 'Полазници предају радове у групама';
$string['teamsubmission_help'] = 'Ако је ова опција омогућена, полазници ће бити подељени у групе на основу подразумеваног скупа група или наменски прилагођеног груписања. Групни рад ће бити дељен између чланова групе и сви чланови групе ће видети промене у раду које буду унели други чланови групе.';
$string['teamsubmissiongroupingid'] = 'Груписање за групе полазника';
$string['teamsubmissiongroupingid_help'] = 'Ово је груписање које ће Задатак користити како би пронашао групе за групе полазника. Уколико није подешено користиће се подразумевана подешавања за групе.';
$string['textinstructions'] = 'Упутства за задатак';
$string['timelimit'] = 'Временско ограничење';
$string['timelimit_help'] = 'Ако је ова опција омогућена, временско ограничење је наведено на страници задатка и тајмер је приказан током задатка.';
$string['timelimitnotenabled'] = 'Временско ограничење није омогућено за задатак.';
$string['timelimitpassed'] = 'Рок је истекао';
$string['timemodified'] = 'Последње измене';
$string['timeremaining'] = 'Преостало време';
$string['timeremainingcolon'] = 'Преостало време: {$a}';
$string['togglezoom'] = 'Увећај/умањи регион';
$string['ungroupedusers'] = 'Подешавање \'Неопходна је група за предају рада\' је омогућено, али неки корисници нису чланови ниједне групе, или су чланови више од једне групе, тако да не могу да предају рад.';
$string['ungroupedusersoptional'] = 'Подешавање "Полазници предају у групама" је омогућено а неки корисници или нису чланови ниједне групе или су чланови више група. Молимо узмите у обзир да ће ти полазници предати решење задатка као чланови "Подразумеване групе".';
$string['unlimitedattempts'] = 'Неограничено';
$string['unlimitedattemptsallowed'] = 'Неограничен број покушаја';
$string['unlimitedpages'] = 'Неограничено';
$string['unlocksubmissionforstudent'] = 'Дозволи предају радова за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['unlocksubmissions'] = 'Откључај предате радове';
$string['unsavedchanges'] = 'Несачуване промене';
$string['unsavedchangesquestion'] = 'Постоје промене оцена или повратних информација које нису сачуване. Да ли желите да сачувате промене и наставите даље?';
$string['updategrade'] = 'Ажурирај оцену';
$string['updatetable'] = 'Сачувај и ажурирај табелу';
$string['upgradenotimplemented'] = 'Надоградња није имплементирана у додатку ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Подразумевана подешавања корисничког задатка';
$string['userextensiondate'] = 'Продужетак је одобрен до: {$a}';
$string['usergrade'] = 'Водич за кориснике';
$string['useridlistnotcached'] = 'Измене оцена НИСУ сачуване јер систем није могао да утврди на који предати рад су се односиле.';
$string['useroverrides'] = 'Измене подешавања за кориснике';
$string['useroverridesdeleted'] = 'Измене подешавања за кориснике обрисане';
$string['usersnone'] = 'Ниједан полазник нема приступ овом задатку';
$string['usersubmissioncannotberemoved'] = 'Рад који је предао/ла {$a} не може бити уклоњен.';
$string['userswhoneedtosubmit'] = 'Корисници који треба да предају решење: {$a}';
$string['validmarkingworkflowstates'] = 'Исправна стања тока оцењивања';
$string['viewadifferentattempt'] = 'Погледај други покушај';
$string['viewbatchmarkingallocation'] = 'Погледај страницу за групну доделу оцењивача.';
$string['viewbatchsetmarkingworkflowstate'] = 'Погледај страницу за групно подешавање тока оцењивања.';
$string['viewfeedback'] = 'Погледајте повратне информације';
$string['viewfeedbackforuser'] = 'Погледајте повратне информације за корисника {$a}';
$string['viewfull'] = 'Прикажи све';
$string['viewfullgradingpage'] = 'Отворите страницу за оцењивање у пуном формату како бисте дали повратне информације';
$string['viewgradebook'] = 'Погледај књигу оцена';
$string['viewgrading'] = 'Погледај све предате радове';
$string['viewgradingformforstudent'] = 'Погледајте страницу за оцењивање за  полазника: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Погледајте страницу за предају сопственог рада';
$string['viewownsubmissionstatus'] = 'Погледајте страницу статуса сопственог рада';
$string['viewrevealidentitiesconfirm'] = 'Погледајте страницу са потврдом за откривање идентитета полазника';
$string['viewsubmission'] = 'Погледај предати рад';
$string['viewsubmissionforuser'] = 'Погледај предати рад за корисника: {$a}';
$string['viewsubmissiongradingtable'] = 'Погледај табелу за оцењивање предатих радова';
$string['viewsummary'] = 'Прикажи сажетак';
$string['workflowfilter'] = 'Филтер тока оцењивања';
$string['xofy'] = '{$a->x} од {$a->y}';
