<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_db', language 'sk', version '4.3'.
 *
 * @package     auth_db
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_dbcannotconnect'] = 'Nie je možné pripojiť sa k externej databáze.';
$string['auth_dbcannotreadtable'] = 'Nie je možné načítať externú tabuľku.';
$string['auth_dbcantconnect'] = 'Nedá sa pripojiť k zvolenej overovacej databáze.';
$string['auth_dbchangepasswordurl_key'] = 'Heslo - zmena URL';
$string['auth_dbcolumnlist'] = 'Externá tabuľka obsahuje nasledujúce stĺpce:<br />{$a}';
$string['auth_dbdebugauthdb'] = 'Debugovať ADOdb';
$string['auth_dbdebugauthdbhelp'] = 'Debugovať ADOdb spojenie do externej databázy - použiť pri vrátení prázdnej stránky pri prihlasovaní. Nie je vhodné na produkčných systémoch!';
$string['auth_dbdeleteuser'] = 'Vymazaný používateľ {$a->name} id {$a->id}';
$string['auth_dbdeleteusererror'] = 'Chyba pri vymazaní používateľa {$a}';
$string['auth_dbdescription'] = 'Táto metóda využíva tabuľku v externej databáze na kontrolu platnosti daného používateľského mena a hesla. Ak je to nové konto, môžu byť do prostredia Moodle skopírované informácie aj z iných políčok.';
$string['auth_dbextencoding'] = 'Kódovanie externej databázy';
$string['auth_dbextencodinghelp'] = 'Kódovanie použité v externej databáze';
$string['auth_dbextrafields'] = 'Tieto políčka sú nepovinné. Je tu možnosť, aby niektoré používateľské políčka v prostredí Moodle uvádzali informácie z <b>políčok externých databáz</b>, ktoré tu zadáte.<br />
Ak toto políčko necháte prázdne, bude tu uvádzané pôvodné nastavenie.<br /><p>
V obidvoch prípadoch, bude môcť používateľ po prihlásení upravovať všetky tieto políčka.</p>';
$string['auth_dbfieldpass'] = 'Názov políčka obsahujúceho heslá';
$string['auth_dbfieldpass_key'] = 'Pole pre heslo';
$string['auth_dbfielduser'] = 'Názov poľa obsahujúceho používateľské mená. Toto pole musí byť dátového typu varchar.';
$string['auth_dbfielduser_key'] = 'Pole pre používateľské meno';
$string['auth_dbhost'] = 'Počítač hosťujúci databázový server. Použite vstupný systém DSN ak používate ODBC. Ak používate PDO, zvoľte voľbu PDO DSN.';
$string['auth_dbhost_key'] = 'Hostiteľ';
$string['auth_dbinsertuser'] = 'Vložený používateľ {$a->name} id {$a->id}';
$string['auth_dbinsertuserduplicate'] = 'Chyba pri vkladaní používateľa {$a->username} - používateľ s týmto používateľským menom bol už vytvorený pomocou doplnku \'{$a->auth}\' .';
$string['auth_dbinsertusererror'] = 'Chyba pri vkladaní používateľa {$a}';
$string['auth_dbname'] = 'Názov samotnej databázy. Nechajte prázdne, ak používate ODBC DSN. Nechajte prázdne, ak váš PDO DSN už obsahuje názov databázy.';
$string['auth_dbname_key'] = 'Názov databázy';
$string['auth_dbnoexttable'] = 'Externá tabuľka nie je špecifikovaná';
$string['auth_dbnouserfield'] = 'Nie je zadané externé používateľské pole.';
$string['auth_dbpass'] = 'Heslo pre uvedeného používateľa';
$string['auth_dbpass_key'] = 'Heslo';
$string['auth_dbpasstype'] = '<p>Uveďte formát, ktorý používa pole hesla.</p> <p>Ak chcete, aby externá databáza spravovala používateľské mená a e-mailové adresy, použite Moodle na správu hesiel. Ak používate \'interné\', musíte zadať vyplnené pole e-mailovej adresy v externej databáze a musíte povoliť naplánovanú úlohu \\auth_db\\task\\sync_users. Moodle odošle e-mail novým používateľom s dočasným heslom.</p>';
$string['auth_dbpasstype_key'] = 'Formát hesla';
$string['auth_dbreviveduser'] = 'Obnovený používateľ {$a->name} id {$a->id}';
$string['auth_dbrevivedusererror'] = 'Chyba pri obnovení používateľa {$a}';
$string['auth_dbsaltedcrypt'] = 'Kódovanie jednosmerným hash reťazcom';
$string['auth_dbsetupsql'] = 'SQL príkaz pre nastavenie';
$string['auth_dbsetupsqlhelp'] = 'SQL príkaz pre špeciálne nastavenie databázy, často používaný pre nastavenie kódovania pri komunikácii. Príklad pre MySQL a PostgreSQL: <em>SET NAMES \'utf8\'</em>';
$string['auth_dbsuspenduser'] = 'Pozastaviť používateľa {$a->name} id {$a->id}';
$string['auth_dbsuspendusererror'] = 'Chyba pri pozastavení používateľa {$a}';
$string['auth_dbsybasequoting'] = 'Použiť uvodzovky sybase';
$string['auth_dbsybasequotinghelp'] = 'Preskakovanie jednej úvodzovky v štýle Sybase - potrebné pre Oracle, MS SQL a niektoré ďalšie databázy. Nepoužívať pre MySQL!';
$string['auth_dbsyncuserstask'] = 'Synchronizovať úlohy používateľov';
$string['auth_dbtable'] = 'Názov tabuľky v databáze';
$string['auth_dbtable_key'] = 'Tabuľka';
$string['auth_dbtableempty'] = 'Externé tabuľka je prázdna.';
$string['auth_dbtype'] = 'Databázový typ (bližšie viď <a href="http://phplens.com/adodb/supported.databases.html" target="_blank">ADOdb dokumentácia</a>)';
$string['auth_dbtype_key'] = 'Databáza';
$string['auth_dbupdateerror'] = 'Chyba pri aktualizácii externej databázy.';
$string['auth_dbupdateusers'] = 'Aktualizovať používateľov';
$string['auth_dbupdateusers_description'] = 'Rovnako ako vkladanie nových používateľov, aktualizácia existujúcich používateľov.';
$string['auth_dbupdatinguser'] = 'Aktualizovanie používateľa {$a->name} id {$a->id}';
$string['auth_dbuser'] = 'Používateľské meno s prístupom do databázy len na čítanie.';
$string['auth_dbuser_key'] = 'DB používateľ';
$string['auth_dbuserstoadd'] = 'Používateľské položky na pridanie:{$a}';
$string['auth_dbuserstoremove'] = 'Používateľské položky na zmazanie:{$a}';
$string['pluginname'] = 'Použiť externú databázu';
$string['privacy:metadata'] = 'Zásuvný modul autentifikácia Externá databáza neukladá žiadne osobné údaje.';
