<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_program', language 'pt_br', version '4.3'.
 *
 * @package     tool_program
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutthefile'] = 'Sobre o arquivo';
$string['action'] = 'Ação';
$string['actions'] = 'Ações';
$string['active'] = 'Ativo';
$string['activeprograms'] = 'Programas ativos';
$string['activeprogramslink'] = '<a href="{$a->href}">{$a->count} programas ativos</a>';
$string['addcourses'] = 'Adicionar cursos';
$string['addcourseslist'] = 'Selecionar cursos';
$string['addcourseslist_help'] = 'Um ou mais cursos podem ser selecionados.';
$string['addset'] = 'Adicionar conjunto';
$string['addsetorcourse'] = 'Adicionar um conjunto ou um curso';
$string['afterallocationwindowstarts'] = 'Após a alocação iniciar';
$string['afterallocationwindowstartswithrelativedate'] = '{$a} após a alocação iniciar';
$string['afterduedate'] = 'Após a data limite';
$string['afterduedatewithrelativedate'] = '{$a} após a data limite';
$string['afterstartdate'] = 'Após a data de início';
$string['afterstartdatewithrelativedate'] = '{$a} após a data de início';
$string['afteruserallocationdate'] = 'Após a data da alocação do usuário';
$string['afteruserallocationdatewithrelativedate'] = '{$a} após a data da alocação do usuário';
$string['allinanyorder'] = 'Todos em qualquer ordem';
$string['allinorder'] = 'Todos em ordem';
$string['allocatetoprogram'] = 'Alocar ao programa';
$string['allocateusers'] = 'Alocar usuários';
$string['allocationdate'] = 'Data de alocação';
$string['allocationdateonorafter'] = 'Data de alocação em ou após';
$string['allocationenddate'] = 'Data do fim da alocação';
$string['allocationenddate_help'] = 'Data final para alocar usuários neste programa';
$string['allocationfor'] = 'Alocação para \'{$a}\'';
$string['allocationsource'] = 'Fonte da alocação';
$string['allocationstartdate'] = 'Data de início da alocação';
$string['allocationstartdate_help'] = 'Data para começar a alocar usuários no programa';
$string['allocationwindow'] = 'Janela de alocação';
$string['allocationwindowendedon'] = 'A janela de alocação para esse programa terminou em {$a}.';
$string['allocationwindowstartson'] = 'A janela de alocação para esse programa começa em {$a}.';
$string['allowdirectallocation'] = 'Permitir alocação direta';
$string['allowdirectallocation_help'] = 'Permite a alocação direta de usuários no programa';
$string['archive'] = 'Arquivar';
$string['archived'] = 'Arquivado';
$string['archivedconfirmation'] = 'Você tem certeza que quer arquivar o programa \'{$a}\'? O programa arquivado não estará mais disponível para gestores ou estudantes e será visto somente em relatórios históricos.';
$string['archivedon'] = 'Arquivado em';
$string['archivedprograms'] = 'Programas arquivados';
$string['assfirstchildof'] = 'Como primeiro filho de "{$a}"';
$string['associatedcertification'] = 'Certificação associada';
$string['associatedcertifications'] = 'Certificações associadas';
$string['atleast'] = 'Ao menos';
$string['autocreategroups'] = 'Adicionar aos grupos do curso';
$string['autocreategroups_help'] = 'Quando usuário são inscritos nos cursos do programa eles podem ser automaticamente adicionados ao mesmo grupo. Um grupo com o mesmo nome do programa será criado automaticamente em cada curso. Para cursos que são compartilhados entre tenants o nome do tenant também será adicionado ao nome do grupo.';
$string['autocreategroupsnone'] = 'Não';
$string['autocreategroupsprogram'] = 'Criar grupos para este programa';
$string['availability'] = 'Disponibilidade';
$string['available'] = 'Disponível';
$string['baseset'] = 'Conjunto base';
$string['beforeenddate'] = 'Antes da data de término';
$string['beforeenddatewithrelativedate'] = '{$a} antes da data de término';
$string['calendar'] = 'Agenda';
$string['calendarduedate'] = 'Data limite para o programa {$a}';
$string['calendarenddate'] = 'Data de término para o programa {$a}';
$string['certification'] = 'Certificação';
$string['certificationduedate'] = 'Data limite para certificação';
$string['certificationmsgactive'] = 'A certificação <strong>"{$a->fullname}"</strong> deve ser concluída até <strong>{$a->date}</strong>';
$string['certificationmsgcompleted'] = 'A certificação <strong>"{$a->fullname}"</strong> está concluída.';
$string['certificationmsgcompletedexpired'] = 'A certificação <strong>"{$a->fullname}"</strong> está concluída. Ela vai expirar em <strong>{$a->date}</strong>';
$string['certificationmsgduedatenotset'] = 'A certificação <strong>"{$a->fullname}"</strong> não tem uma data de entrega definida';
$string['certificationmsgexpired'] = 'A certificação <strong>"{$a->fullname}"</strong> expirou em <strong>{$a->date}</strong>';
$string['certificationmsgoverdue'] = 'A certificação <strong>"{$a->fullname}"</strong> atrasou em <strong>{$a->date}</strong>';
$string['certifications'] = 'Certificações';
$string['close'] = 'Fechar';
$string['completeallinanyorder'] = 'Concluir todos em qualquer ordem';
$string['completeallinorder'] = 'Concluir todos em ordem';
$string['completeatleast'] = 'Concluir ao menos';
$string['completed'] = 'Concluído';
$string['completedprogramslink'] = '<a href="{$a->href}">{$a->count} programas concluídos</a>';
$string['completion'] = 'Conclusão';
$string['completion_help'] = 'Tipo de conclusão a ser aplicada no conjunto:

* <strong> Tudo em ordem: </strong> o usuário deve concluir todos os cursos na ordem especificada
* <strong> Tudo em qualquer ordem: </strong> o usuário deve concluir todos os cursos em qualquer ordem
* <strong> Pelo menos X: </strong> o usuário deve concluir pelo menos o número especificado de cursos em qualquer ordem';
$string['completionatleast'] = 'Concluir ao menos';
$string['completioncriteria'] = 'Critério de conclusão';
$string['completioncriteriagroup'] = 'Conclusão';
$string['completioncriteriagroup_help'] = 'Por favor, seleciona um critério de conclusão para esse conjunto específico';
$string['completiondate'] = 'Data de conclusão';
$string['completiondateonorafter'] = 'Data de conclusão em ou após';
$string['conditionprogramcompleted'] = 'Programa concluído';
$string['conditionprogramcompleteddescription'] = 'Usuários que têm o estado \'Concluído\' no programa \'{$a}\'';
$string['conditionprogramcompleteddescriptionwithdate'] = 'Usuários que tem o estado \'Concluído\' no programa \'{$a->programname}\'<br/>Data de conclusão é a partir de \'{$a->conditiondate}\'';
$string['conditionprogramnotcompleted'] = 'Programa não concluído';
$string['conditionprogramnotcompleteddescription'] = 'Usuários que não têm o estado \'Concluído\' no programa \'{$a}\'';
$string['conditionprogramoverdue'] = 'Programa atrasado';
$string['conditionprogramoverduedescription'] = 'Usuários que têm o estado \'Atrasado\' no programa \'{$a}\'';
$string['conditionprogramoverduedescriptionwithdate'] = 'Usuários que tem o estado \'Atrasado\' no programa \'{$a->programname}\'<br/>
A data de entrega é a partir de \'{$a->conditiondate}\'';
$string['conditionprogramsuspended'] = 'Programa suspenso';
$string['conditionprogramsuspendeddescription'] = 'Usuários que têm o estado \'Suspenso\' no programa \'{$a}\'';
$string['conditionprogramsuspendeddescriptionwithdate'] = 'Usuários que tem o estado \'Suspenso\' no programa \'{$a->programname}\'<br/>
A data da suspensão é a partir de \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Usuários alocados ao programa';
$string['conditionuserallocateddescription'] = 'Usuários alocados no programa \'{$a}\'';
$string['conditionuserallocateddescriptionwithdate'] = 'Usuários alocados ao programa \'{$a->programname}\'<br/>
Data de alocação é a partir de \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Usuários não alocados ao programa';
$string['conditionusernotallocateddescription'] = 'Usuários não alocados no programa \'{$a}\'';
$string['confirmdeallocateusers'] = 'Esta ação excluirá completamente a alocação e os dados associados para todos os usuários selecionados. Essa ação não pode ser desfeita.';
$string['confirmdeallocateusersheader'] = 'Desalocar usuários';
$string['confirmdeletecourse'] = 'Você tem certeza que quer remover o curso \'{$a}\' do programa?';
$string['confirmdeleteprogram'] = 'Você tem certeza que quer excluir o programa \'{$a}\' e todos os dados associados? Esta ação não pode ser desfeita.';
$string['confirmdeleteset'] = 'Você tem certeza que quer excluir o conjunto \'{$a}\' e remover os cursos dele?';
$string['confirmdeleteuserallocation'] = 'Você tem certeza que quer excluir completamente a alocação do usuário \'{$a}\' e os dados associados? Esta ação não pode ser desfeita.';
$string['confirmduplicate'] = 'Uma cópia será feita incluindo o conteúdo do programa e sua agenda mas sem os usuários. O ID number do programa será removido.';
$string['confirmresetprogress'] = 'Você tem certeza que quer redefinir o progresso de \'{$a}\'? Se fizer isto, todos os dados de conclusão serão perdidos. Esta ação pode demorar alguns minutos para ser concluída e não pode ser desfeita.';
$string['confirmresetusersprogramusers'] = 'Esta ação redefinirá o programa para todos os usuários selecionados. Ao fazer isso, todos os dados de conclusão serão perdidos. Esta ação pode levar alguns minutos para ser concluída e não pode ser desfeita.';
$string['containscourse'] = 'Contém curso';
$string['content'] = 'Conteúdo';
$string['copy'] = 'Caopiar';
$string['course'] = 'Curso';
$string['coursealreadyinset'] = 'O curso já está neste conjunto';
$string['coursecompletiondisabled'] = 'O acompanhamento de conclusão para esse curso não está habilitado. Ele vai aparecer no painel dos usuários como não concluído e, como resultado, pode se tornar impossível para eles concluírem o programa.';
$string['courseinformation'] = 'Informação do curso';
$string['coursenotavailable'] = 'Curso não disponível';
$string['coursesinset'] = 'Cursos no conjunto (separados por vírgula)';
$string['coursesinsetlines'] = 'Cursos no conjunto (um por linha)';
$string['coursesinsetlineslinks'] = 'Cursos no conjunto com links (um por linha)';
$string['coursesinsetlinks'] = 'Cursos no conjunto com links (separados por vírgula)';
$string['criteriaall'] = 'Todos os programas selecionados foram concluídos';
$string['criteriaany'] = 'Ao menos um dos programas selecionados está concluído';
$string['dateoverriden'] = 'Data sobreposta';
$string['datetypeabsolute'] = 'Selecionar data';
$string['datetypenone'] = 'Não definido';
$string['dayssinceallocation'] = 'Dias desde a alocação';
$string['daystakingprogram'] = 'Dias fazendo o programa';
$string['deallocateusers'] = 'Desalocar usuários';
$string['default'] = 'Padrão';
$string['deleteallocation'] = 'Excluir alocação';
$string['deleteuserallocation'] = 'Excluir alocação do usuário';
$string['description'] = 'Descrição';
$string['directallocationdisabled'] = 'A alocação direta nesse programa está desabilitada';
$string['displaycompletedcourses'] = 'Cursos concluídos no programa';
$string['displaycompletiondate'] = 'Data de conclusão do programa';
$string['displayprogramduedate'] = 'Data de entrega do programa';
$string['displayprogramid'] = 'ID interno do programa utilizado nas URLs';
$string['displayprogramname'] = 'Nome do programa';
$string['dontchange'] = 'Não mude';
$string['duedate'] = 'Data de entrega';
$string['duedate_help'] = 'Data de entrega para este programa';
$string['duedateonorafter'] = 'Data de entrega a partir de';
$string['duplicate'] = 'Duplicar';
$string['dynamic'] = 'Dinâmico';
$string['dynamicrules'] = 'Regras Dinâmicas';
$string['dynamicrulesplugincheck'] = 'Ver a lista de regras dinâmicas é impossível sem o plugin tool_dynamicrule';
$string['dynamicrulewarningdeallocation'] = 'Usuários só podem ser desalocados se foram alocados por outra regra dinâmica. Alocações manuais não serão afetadas.';
$string['editallocation'] = 'Editar alocação';
$string['editprogramname'] = 'Editar nome do programa';
$string['editsetname'] = 'Editar nome do conjunto';
$string['editstatusanddates'] = 'Editar status e datas';
$string['editstatusanddatesbulk'] = 'Editar status e datas para múltiplos usuários';
$string['enddate'] = 'Data de término';
$string['enddate_help'] = 'Data de término para este programa';
$string['enrol'] = 'Inscrever';
$string['enrolled'] = 'Inscrito';
$string['entityprogram'] = 'Programa';
$string['entityprogramcompletion'] = 'Conclusão do usuário';
$string['entityprogramcontent'] = 'Conteúdo do programa';
$string['entityprogramitem'] = 'Item do programa';
$string['entityprogramusers'] = 'Alocação de usuário';
$string['errorallocationenddatenostartdate'] = 'A data de término da alocação não pode ser uma data relativa se a data de início não estiver definida';
$string['errorallocationenddatepreviousstartdate'] = 'A data de término da alocação não pode ser antes da data de início da alocação';
$string['errorbasesetnotfound'] = 'Conjunto base não encontrado';
$string['errorcannotallocate'] = 'Não foi possível alocar o usuário a um programa (a alocação já existe ou não é permitida)';
$string['errorcannotresetprogram'] = 'Não foi possível redefinir o programa';
$string['errorcantallocateusers'] = 'Não foi possível alocar usuários';
$string['errorcantcreateset'] = 'Não foi possível criar o conjunto';
$string['errorcantdeletenotarchivedprogram'] = 'Não é possível excluir um programa que não esteja arquivado';
$string['errorcantselfenrol'] = 'Não foi possível fazer a auto inscrição';
$string['errorcertificationnotfound'] = 'Certificação não encontrada';
$string['errorcouldnotallocate'] = 'Não foi possível alocar usuário \'{$a->originaluserfullname}\' ao programa \'{$a->program}\'';
$string['errorduedatepreviousstartdate'] = 'Data de entrega não pode ser antes da data de início';
$string['errorenddatepreviousduedate'] = 'Data de término não pode ser antes da data de entrega';
$string['errorenddatepreviousstartdate'] = 'A data de término não pode ser antes da data de início';
$string['errorhelperactionnotallowed'] = 'Ação de ajuda não permitida';
$string['erroridnumberuniquetenant'] = 'Este ID number já está sendo usado por outro programa';
$string['errorinvaliddate'] = 'Data inválida';
$string['errorinvalidprogram'] = 'Programa inválido';
$string['errorinvalidprogramitemmove'] = 'Movimentação inválida de item de programa';
$string['errorloadingprogram_mobile'] = 'Erro ao carregar o programa';
$string['errormissingenrolprogramplugin'] = 'O plugin de inscrição por programa está faltando';
$string['errornopermissionallocateusers'] = 'Sem permissão para alocar usuários ao programa';
$string['errornopermissionmanageprograms'] = 'Sem permissão para gerenciar programas';
$string['errornopermissionmanageusers'] = 'Sem permissão para gerenciar usuários';
$string['errornopermissionviewallocatedusers'] = 'Sem permissão para ver usuários alocados a este programa';
$string['errornopermissionviewprograms'] = 'Sem permissão para ver programas';
$string['errornopermissionviewreports'] = 'Sem permissão para ver relatórios';
$string['errornostudentsrolefound'] = 'Nenhum papel de estudante foi encontrado';
$string['errornothingtoexportforprograms'] = 'Nada a exportar para programas compartilhados: {$a}';
$string['errorprogramnotfound'] = 'Programa não encontrado';
$string['errorreporttypedoesnotexist'] = 'Tipo de relatório não existe';
$string['errorsameidnumber'] = 'Um programa com o mesmo ID number já existe';
$string['errorsomeprogramsdontexist'] = 'Alguns programas não existem';
$string['errorusercantbeallocated'] = 'Usuários não podem ser alocados';
$string['eventcourseadded'] = 'Curso adicionado';
$string['eventcourseremoved'] = 'Curso removido';
$string['eventcourseupdated'] = 'Curso atualizado';
$string['eventprogramcompleted'] = 'Programa concluído';
$string['eventprogramcreated'] = 'Programa criado';
$string['eventprogramdeleted'] = 'Programa excluído';
$string['eventprogramupdated'] = 'Programa atualizado';
$string['eventsetcompleted'] = 'Conjunto concluído';
$string['eventsetcreated'] = 'Conjunto criado';
$string['eventsetdeleted'] = 'Conjunto excluído';
$string['eventsetupdated'] = 'Conjunto atualizado';
$string['eventuserallocated'] = 'Usuário alocado';
$string['eventuserdeallocated'] = 'Usuário desalocado';
$string['eventuserupdated'] = 'Alocação do usuário atualizada';
$string['export_content'] = 'Configurações';
$string['export_content_help'] = 'Programas, nomes, descrições, datas, marcadores, etc.';
$string['export_dynamic_rules'] = 'Regras Dinâmicas';
$string['export_dynamic_rules_help'] = 'Todas as configurações de regras dinâmicas para esses programas.';
$string['export_user_allocations'] = 'Alocações de usuários a programas';
$string['export_user_allocations_help'] = 'Incluir alocações de usuários a esses programas. Um cópia dos usuários em si não será incluída.';
$string['exportonlyallocationspostfix'] = '(apenas alocações de usuários)';
$string['exportprogramsdescription'] = 'Programas com seus cursos, alocações de usuários e componente de regras dinâmicas';
$string['fullprogramreport'] = 'Relatório completo do programa';
$string['futureallocation'] = 'Alocação futura';
$string['gotoprogram'] = 'Ir ao programa';
$string['hidden'] = 'Oculto';
$string['hiddenfromlearners'] = 'Oculto para estudantes';
$string['idnumber'] = 'ID number';
$string['import_content'] = 'Configurações';
$string['import_content_help'] = 'Programas, nomes, descrições, datas, marcadores, etc.';
$string['import_dynamic_rules'] = 'Regras dinâmicas';
$string['import_dynamic_rules_help'] = 'Todas as configurações de regras dinâmicas para esses programas.';
$string['import_user_allocations'] = 'Alocações de usuários a programas';
$string['import_user_allocations_help'] = 'Incluir a alocações do usuário a esses programas.';
$string['importcannotallocate'] = 'Não foi possível alocar o usuário \'{$a->originaluserfullname}\' ao program \'{$a->program}\': a alocação já existe ou não é permitida';
$string['importlogfailed'] = 'Não foi possível importar o programa \'{$a->fullname}\'';
$string['importlogidnumberexists'] = 'Programa com ID number \'{$a->originalidnumber}\' já existe';
$string['importlogsuccess'] = 'Criado novo programa \'<a href="{$a->url}">{$a->fullname}</a>\' com {$a->setscount} conjuntos, {$a->coursescount} cursos';
$string['importlogsuccessuserallocations'] = 'Usuário \'{$a->userfullname}\' alocado no programa \'{$a->program}\'';
$string['include_shared_entities'] = 'Incluir entidades compartilhadas';
$string['include_shared_entities_help'] = 'Ao habilitar essa opção, o arquivo exportado também conterá:

* Todos os programas compartilhados disponíveis no tenant atual
* Todos cursos de programas fora da categoria de curso do tenant atual';
$string['inprogress'] = 'Em progresso';
$string['keepprogramdefaults'] = 'Manter os padrões do programa';
$string['lessthanaday'] = 'Menos de um dia';
$string['locked'] = 'Travado';
$string['lockedreasonparent'] = 'Disponível somente se: cojunto {$a} estiver disponível.';
$string['lockedreasonpreviouscourse'] = 'Disponível somente se: curso anterior {$a} estiver marcado como concluído.';
$string['lockedreasonpreviousset'] = 'Disponível somente se: conjunto anterior {$a} estiver marcado como concluído.';
$string['maincompletion'] = 'Conclusão principal';
$string['managedusersoverdue'] = 'Algums membros do time têm programas atrasados.';
$string['manual'] = 'Manual';
$string['mappingerrorprogramnotfound'] = 'Programa {$a} não foi encontrado';
$string['mappingnoticenoidnumber'] = 'O programa foi localizado pelo nome por que o ID number estava vazio. É recomendado atribuir ID numbers aos programas.';
$string['messageprovider:programcompleted'] = 'Programa concluído';
$string['messageprovider:programuserallocated'] = 'Usuário alocado no programa';
$string['messageprovider:programuserdeallocated'] = 'Usuário desalocado do programa';
$string['missingcompletion'] = 'Está faltando o critério de conclusão';
$string['missingcourse'] = 'Está faltando o curso';
$string['missingfullname'] = 'Está faltando o nome do programa.';
$string['missingprogram'] = 'Está faltando o programa';
$string['missingsetname'] = 'Está faltando o nome do conjunto';
$string['name'] = 'Nome';
$string['never'] = 'Nunca';
$string['newnameforset'] = 'Novo nome para \'{$a}\'';
$string['newprogram'] = 'Novo programa';
$string['notarchived'] = 'Não arquivado';
$string['notavailable'] = 'Não disponível';
$string['notcompleted'] = 'Não concluído';
$string['notenrolledprograms_mobile'] = 'Você não está inscrito em nenhum programa';
$string['notificationduedate'] = 'Este programa vence em {$a}<br /><br />';
$string['notificationprogramcompleted'] = 'Olá {$a->userfullname},<br /><br />
Parabéns por completar o programa \'{$a->programname}\'!<br /><br />
Você pode revisitar seus cursos com o programa em qualquer momento. O programa completo pode ser encontrado no seu Painel em Programas Concluídos.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationprogramuserallocated'] = 'Olá {$a->userfullname},<br /><br />
Bem-vindo ao programa \'{$a->programname}\', que você pode encontrar no seu painel.<br /><br />
{$a->duedatemsg}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationprogramuserdeallocated'] = 'Olá {$a->userfullname},<br /><br />
O programa \'{$a->programname}\' foi fechado e não pode mais ser acessado.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationsubjectprogramcompleted'] = 'Parabéns! - \'{$a}\' concluído';
$string['notificationsubjectprogramuserallocated'] = 'Bem vindo a \'{$a}\'';
$string['notificationsubjectprogramuserdeallocated'] = '\'{$a}\' fechado';
$string['notset'] = 'Não definido';
$string['notsuspended'] = 'Não suspenso';
$string['notvisible'] = 'Não visível';
$string['nousersselected'] = 'Você precisa selecionar ao menos um usuário';
$string['numbercoursesinprogramunique'] = 'Número de cursos (único)';
$string['numbercoursesinset'] = 'Número de cursos no conjunto';
$string['numbercurrentallocatedusers'] = 'Número de usuários alocados atualmente';
$string['open'] = 'Aberto';
$string['outcomeallocation'] = 'Alocar usuários aos programas';
$string['outcomeallocationdescstartdate'] = 'Data de início do programa: \'{$a->startdate}\'';
$string['outcomeallocationsuspendedusers'] = 'Com usuários suspensos';
$string['outcomedeallocate'] = 'Desalocar usuário do programa';
$string['outcomedeallocation'] = 'Desalocar usuários dos programas';
$string['outcomedeallocationdescription'] = 'Desalocar usuários do programa \'{$a}\'';
$string['overdue'] = 'Atrasado';
$string['overdueprograms'] = 'Programas vencidos';
$string['overdueprogramslink'] = '<a href="{$a->href}">Programas vencidos: {$a->count}</a>';
$string['parentname'] = 'Nome do pai';
$string['pending'] = 'Pendente';
$string['pendingreasonhiddencourse'] = 'Alguns cursos que são necessários para destravar este curso não estão disponíveis. Por favor, contate o administrador do site.';
$string['pendingreasonparent'] = 'Será automaticamente marcado como concluído quando: conjunto {$a} estiver disponível.';
$string['pendingreasonpreviouscourse'] = 'Será marcado como concluído automaticamente quando: curso anterior {$a} for marcado como concluído.';
$string['pendingreasonpreviousset'] = 'Será marcado como concluído automaticamente quando: conjunto anterior {$a} for marcado como concluído.';
$string['pluginname'] = 'Programa';
$string['previewprogramname'] = 'Pré-visualização do nome do programa';
$string['privacy:metadata:core_tag'] = 'Marcadores adicionados a programas';
$string['privacy:metadata:program_set_completion'] = 'Informação sobre a conclusão de um conjunto de um programa.';
$string['privacy:metadata:program_set_completion:completeddate'] = 'A data na qual o usuário concluíu o conjunto.';
$string['privacy:metadata:program_set_completion:setid'] = 'O conjunto concluído.';
$string['privacy:metadata:program_set_completion:timemodified'] = 'O momento de modificação da conclusão do conjunto.';
$string['privacy:metadata:program_set_completion:userid'] = 'O usuário que concluíu o conjunto.';
$string['privacy:metadata:program_users'] = 'Informação sobre a alocação do usuário ao programa.';
$string['privacy:metadata:program_users:allocationtype'] = 'A fonte a partir da qual o usuário foi alocado.';
$string['privacy:metadata:program_users:certificationid'] = 'À qual certificação foi alocado (se aplicável).';
$string['privacy:metadata:program_users:duedate'] = 'A data de entrega do programa.';
$string['privacy:metadata:program_users:duedatelocked'] = 'Se a data de entrega padrão do programa foi sobreposta.';
$string['privacy:metadata:program_users:enddate'] = 'Data de término do programa para este usuário.';
$string['privacy:metadata:program_users:enddatelocked'] = 'Se a data de término padrão do programa foi sobreposta.';
$string['privacy:metadata:program_users:programid'] = 'O programa ao qual foi alocado.';
$string['privacy:metadata:program_users:startdate'] = 'Data de início do programa para este usuário.';
$string['privacy:metadata:program_users:startdatelocked'] = 'Se a data de início padrão do programa foi sobreposta.';
$string['privacy:metadata:program_users:status'] = 'Se o usuário foi suspenso do programa.';
$string['privacy:metadata:program_users:timemodified'] = 'O momento de modificação da alocação do usuário.';
$string['privacy:metadata:program_users:userid'] = 'O ID do usuário alocado ao programa.';
$string['program:allocateuser'] = 'Alocar usuários a programas';
$string['program:configurecustomfields'] = 'Configurar campos personalizados de programas';
$string['program:coursereset'] = 'Redefinir os cursos do programa';
$string['program:edit'] = 'Editar programas';
$string['programdescription'] = 'Descrição do programa';
$string['programdescription_help'] = 'A descrição do programa é apresentada no Painel.';
$string['programduedate'] = 'Data de entrega do programa';
$string['programfullname'] = 'Nome do programa';
$string['programfullname_help'] = 'O nome do programa é apresentado no Painel e na lista de programas.';
$string['programidnumber'] = 'ID number do programa';
$string['programidnumber_help'] = 'O ID number de um programa é usado apenas quando "casando" o programa com sistemas externos e não é apresentado em nenhum lugar do site. Se o programa tem um código ou nome oficial, você deve preenchê-lo aqui, caso contrário, deixe em branco.';
$string['programimage'] = 'Imagem do programa';
$string['programimage_help'] = 'A imagem do propgrama é apresentada no Painel.';
$string['programinformation'] = 'Informações do programa';
$string['programname'] = 'Nome do programa';
$string['programnamewitheditlink'] = 'Nome do programa com link para editar';
$string['programnamewithimage'] = 'Nome do programa com imagem';
$string['programnamewithimageandeditlink'] = 'Nome do programa com imagem e link para editar';
$string['programnamewithimageandviewlink'] = 'Nome do programa com imagem e link para ver';
$string['programnamewithviewlink'] = 'Nome do programa com link para ver';
$string['programparentsetname'] = 'Nome do conjunto pai';
$string['programprogress'] = 'Progresso do programa';
$string['programprogressexport'] = '{$a} progresso do programa';
$string['programprogresswithreportlinks'] = 'Progresso do programa com links para relatório';
$string['programreset'] = 'Redefinição do programa';
$string['programrules'] = 'Regras do programa';
$string['programs'] = 'Programas';
$string['programscustomfield'] = 'Campos personalizados de programas';
$string['programsetname'] = 'Nome do conjunto';
$string['programsoverview_mobile'] = 'Visão geral dos programas';
$string['programstatus'] = 'Estado do programa';
$string['programtags'] = 'Marcados do programa';
$string['programtags_help'] = 'Marcadores deste programa';
$string['programtenant'] = 'Tenant do programa';
$string['programuserallocations'] = 'Alocações de usuários ao programa';
$string['programvisibility'] = 'Visibilidade do programa';
$string['programvisibility_help'] = 'Esta configuração determina se o programa é apresentado no Painel dos usuários e se eles podem acessá-lo.';
$string['progress'] = '{$a} concluído';
$string['progressoverview'] = 'Visão geral do progresso';
$string['progresspercent'] = 'Progresso';
$string['progressreport'] = 'Relatório de progresso';
$string['recalculateprogramcompletion'] = 'Recalcular a conclusão do programa';
$string['reg_wpprograms'] = 'Número de programas ({$a})';
$string['reportprogramsallocationcompletion'] = 'Alocações e conclusões de usuários ao programa';
$string['reset'] = 'Reiniciar';
$string['resetprogress'] = 'Redefinir programa';
$string['resetusersprogram'] = 'Reiniciar programa de usuários';
$string['restore'] = 'Restaurar';
$string['review'] = 'Revisar';
$string['rolemanager'] = 'Gestor do programa';
$string['rolemanagerdescription'] = 'Permite criar e gerenciar programas em seu tenant atual e alocar usuários aos programas';
$string['scheduleupdatesuccess'] = 'Agendamento atualizado com sucesso';
$string['seecontent_mobile'] = 'Ver conteúdo';
$string['selectactiveandarchivedprograms'] = 'Selecionar todos os programas ativos e arquivados';
$string['selectallactiveprograms'] = 'Selecionar todos os programas ativos';
$string['selectallprogramsinthisfile'] = 'Selecionar todos os programas neste arquivo';
$string['selectatleastoneprogram'] = 'Selecione ao menos um programa';
$string['selectcourses'] = 'Selecionar cursos';
$string['selectmanually'] = 'Selecionar manualmente...';
$string['selectprogramcondition'] = 'Programa';
$string['selectprogramcondition_help'] = 'Selecione um programa para ser associado a esta condição';
$string['selectprogramoutcome'] = 'Programa';
$string['selectprogramoutcome_help'] = 'Selecione um programa para ser associado a esta ação';
$string['selectprogramstoallocate'] = 'Programas';
$string['selectprogramstoallocate_help'] = 'Selecione os programas onde os usuários serão alocados';
$string['separatetenantsingroupswarning'] = 'Em cursos compartilhados entre tenants, usuários de cada tenant serão adicionados a grupos separados.';
$string['set'] = 'Conjunto';
$string['setname'] = 'Nome';
$string['setname_help'] = 'Por favor, escolha um nome para este conjunto';
$string['setofcourses'] = 'Conjunto de cursos';
$string['setsandcoursesnotfound_mobile'] = 'Nenhum conjunto ou curso encontrado';
$string['startdate'] = 'Data de início';
$string['startdate_help'] = 'Data de início para este programa';
$string['status'] = 'Estado';
$string['status_help'] = 'O estado suspenso irá esconder este programa do usuário.';
$string['suspended'] = 'Suspenso';
$string['suspendeddateonorafter'] = 'Data de suspensão a partir de';
$string['tagarea_tool_program'] = 'Programas';
$string['tags'] = 'Marcadores';
$string['timecreated'] = 'Criado em';
$string['timemodified'] = 'Última alteração em';
$string['timesuspended'] = 'Suspenso em';
$string['toomanyprogramstoshow'] = 'Muitos programas para mostrar';
$string['type'] = 'Tipo';
$string['userduedate'] = 'Data de entrega';
$string['userduedate_help'] = 'Selecione a data de entrega do programa para este usuário.';
$string['userenddate'] = 'Data de término';
$string['userenddate_help'] = 'Selecione a data na qual este programa não será visível para este usuário.';
$string['userlist'] = 'Selecionar usuários';
$string['userlist_help'] = 'Seleciona usuários para alocar a este programa';
$string['users'] = 'Usuários';
$string['usersallocatedsuccess'] = '{$a} alocações de usuários foram criadas com sucesso';
$string['usersallocationnotavailable'] = 'A alocação de usuários não está disponível';
$string['usersdeallocatedsuccess'] = '{$a} usuário(s) foram desalocado(s) com sucesso';
$string['userseditedsuccess'] = '{$a} usuário(s) foram modificado(s) com sucesso';
$string['usersresetprogramsuccess'] = 'O programa foi redefinido para {$a} usuário(s)';
$string['usersskipped'] = '{$a} usuário(s) ignorado(s) porque esta opção não está disponível para ele(s)';
$string['userstartdate'] = 'Data de início';
$string['userstartdate_help'] = 'Selecione a data na qual este usuário poderá iniciar o programa. Esta data será aplicada somente a este usuário.';
$string['visible'] = 'Visível';
$string['warningcourseinvisible'] = 'Aviso: este curso está invisível para os estudantes.';
