<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'da', version '4.3'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Mærke for hjælpeteknologier';
$string['acceptTerms'] = 'Jeg accepterer <a href=":url" target="_blank">vilkårene for brug</a>';
$string['accountDetailsLinkText'] = 'her';
$string['actions'] = 'Handlinger';
$string['add'] = 'Tilføj';
$string['addedandupdatedpp'] = 'Tilføjede {$a->%new} nye H5P-biblioteker og opdaterede {$a->%old} gamle.';
$string['addedandupdatedps'] = 'Tilføjede {$a->%new} nye H5P-biblioteker og opdaterede {$a->%old} gammelt.';
$string['addedandupdatedsp'] = 'Tilføjede {$a->%new} nyt H5P-bibliotek og opdaterede {$a->%old} gamle.';
$string['addedandupdatedss'] = 'Tilføjede {$a->%new} nyt H5P-bibliotek og opdaterede {$a->%old} gammelt.';
$string['addednewlibraries'] = 'Tilføjede {$a->%new} nye H5P-biblioteker.';
$string['addednewlibrary'] = 'Tilføjede {$a->%new} nyt H5P-bibliotek.';
$string['additionallicenseinfo'] = 'Eventuel yderligere information om licensen';
$string['address'] = 'Adresse';
$string['age'] = 'Typiske alder';
$string['ageDescription'] = 'Målgruppen for dette indhold. Mulige inputformater adskilt af kommaer: "1,34-45,-50,59-".';
$string['altText'] = 'Alt tekst';
$string['atto_h5p'] = 'Indsæt H5P-knap';
$string['atto_h5p_description'] = 'Men en H5P-knap i Atto-editoren kan brugerne indsætte H5P-indhold ved enten at skrive en URL eller indlejret kode, eller ved upload af en H5P-fil.';
$string['author'] = 'Forfatter';
$string['authorcomments'] = 'Forfatterkommentarer';
$string['authorcommentsdescription'] = 'Kommentarer til indholdets redaktør. (Denne tekst vil ikke blive offentliggjort som en del af copyright-info.)';
$string['authorname'] = 'Forfatters navn';
$string['authorrole'] = 'Forfatters rolle';
$string['back'] = 'Tilbage';
$string['by'] = 'af';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Nej';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Ja';
$string['cancelPublishConfirmationDialogDescription'] = 'Er du sikker på du vil annullere delingsprocessen';
$string['cancelPublishConfirmationDialogTitle'] = 'Annuller deling';
$string['cancellabel'] = 'Annuller';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-NonCommercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['changedby'] = 'Ændret af';
$string['changedescription'] = 'Beskrivelse af ændringen';
$string['changelog'] = 'Ændringslog';
$string['changeplaceholder'] = 'Foto beskåret, tekst ændret osv.';
$string['city'] = 'By';
$string['close'] = 'Luk';
$string['confirmdialogbody'] = 'Bekræft at du vil fortsætte. Beslutningen kan ikke fortrydes.';
$string['confirmdialogheader'] = 'Bekræft handling';
$string['confirmlabel'] = 'Bekræft';
$string['connectionLost'] = 'Forbindelse mistet. Resultaterne vil blive gemt og sendt når der er forbindelse igen.';
$string['connectionReestablished'] = 'Forbindelse genetableret.';
$string['contactPerson'] = 'Kontaktperson';
$string['contentCopied'] = 'Indhold er kopieret til udklipsholderen';
$string['contentLicenseTitle'] = 'Oplysninger om indholdslicens';
$string['contentchanged'] = 'Indholdet er ændret siden sidst du brugte det.';
$string['contentinuse'] = 'Dette indhold kan være i brug andre steder';
$string['contenttype'] = 'Indholdstype';
$string['copyright'] = 'Brugsrettigheder';
$string['copyrightinfo'] = 'Copyright-information';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Vis copyright-information om dette indhold';
$string['couldNotParseJSONFromZip'] = 'Kunne ikke parse JSON fra pakken: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Kunne ikke læse filen fra pakken: {$a->%fileName}';
$string['country'] = 'Land';
$string['creativecommons'] = 'Creative Commons';
$string['currentStep'] = 'Trin :step af :total';
$string['date'] = 'Dato';
$string['deletelibraryconfirm'] = '<p>Er du sikker på at du vil slette version <em>"{$a->version}"</em> fra biblioteket <em>"{$a->name}"</em>? Det vil fjerne biblioteket og alle dets brugere.</p><p>Handlingen kan ikke fortrydes.</p>';
$string['deletelibraryversion'] = 'Slet version';
$string['deleting'] = 'Sletter et bibliotek';
$string['description'] = 'Beskrivelse';
$string['disablefullscreen'] = 'Deaktiver fuld skærm';
$string['discipline:dropdownButton'] = 'Rullemenu';
$string['discipline:in'] = 'i';
$string['discipline:searchPlaceholder'] = 'Indtast for at søge efter discipliner';
$string['disciplineDescription'] = 'Du kan vælge flere discipliner';
$string['disciplineLabel'] = 'Disipliner';
$string['disciplineLimitReachedMessage'] = 'Du kan vælge op til :numDisciplines discipliner';
$string['disciplines'] = 'Discipliner';
$string['download'] = 'Download';
$string['downloadtitle'] = 'Download dette indhold som en H5P-fil.';
$string['editInfoTitle'] = 'Rediger info <strong>:title</strong>';
$string['editcontent'] = 'Rediger H5P-indhold';
$string['editingFailed'] = 'Redigering fejlet.';
$string['editor'] = 'Editor';
$string['emailAddress'] = 'E-mailadresse';
$string['embed'] = 'Indlejr';
$string['embedtitle'] = 'Vis den indlejrede kode til dette indhold.';
$string['error:emptycontentid'] = 'Den angivne URL er forkert, eller du kan ikke redigere denne fil.';
$string['eventh5pdeleted'] = 'H5P slettet';
$string['eventh5pviewed'] = 'H5P-indhold set';
$string['feature'] = 'Funktion';
$string['fetchtypesfailure'] = 'Der kunne ikke hentes information om tilgængelige H5P-indholdstyper. Fejl i forbindelsen til H5P-arkivet';
$string['fileExceedsMaxSize'] = 'En af filerne i pakken overskrider den tilladte maksimumstørrelse. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Vis H5P-filter';
$string['filter_displayh5p_description'] = '"Vis H5P-filter" konverterer URL\'er til indlejret H5P-indhold.';
$string['fullscreen'] = 'Fuld skærm';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'H5P-editor';
$string['h5pfilenotfound'] = 'H5P-fil blev ikke fundet';
$string['h5pinvalidurl'] = 'Ugyldig URL til H5P-indhold';
$string['h5plibraryhandler'] = 'H5P-rammehåndtering';
$string['h5plibraryhandler_help'] = 'H5P-rammen som bruges til at vise H5P-indhold. Seneste version anbefales.';
$string['h5pmanage'] = 'Administrer H5P-indholdstyper';
$string['h5poverview'] = 'H5P-oversigt';
$string['h5ppackage'] = 'H5P-indholdstype';
$string['h5ppackage_help'] = 'En H5P-indholdstype er en H5P- eller ZIP-fil med alle nødvendige biblioteker til visning af indholdet.';
$string['h5pprivatefile'] = 'Dette H5P-indhold kan ikke vises idet du ikke har adgang til H5P-filen.';
$string['h5psettings'] = 'H5P-indstillinger';
$string['h5ptitle'] = 'Besøg h5p.org og tjek mere indhold ud.';
$string['height'] = 'højde';
$string['helpChoosingLicense'] = 'Hjælp mig med at vælge en licens';
$string['hideadvanced'] = 'Skjul avanceret';
$string['icon'] = 'Ikon';
$string['iconDescription'] = '640x480px. Hvis det ikke er valgt, vil indholdet bruge kategoriikonet';
$string['installedcontentlibraries'] = 'Installerede H5P-biblioteker';
$string['installedcontenttypes'] = 'Installerede H5P-indholdstyper';
$string['installedh5p'] = 'Installeret H5P';
$string['invalidAge'] = 'Ugyldigt inputformat for typisk alder. Mulige inputformater adskilt af kommaer: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'H5P-fil blev ikke fundet (ugyldig id på kontekst)';
$string['invalidfile'] = 'Filen "{$a->%filename}" er ikke tilladt. Kun filer med disse filendelser må bruges: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Ugyldig sprogfil {$a->%file} i biblioteket {$a->%library}';
$string['invalidlanguagefile2'] = 'Ugyldig sprogfil  {$a->%languageFile} er kommet med i biblioteket {$a->%name}';
$string['invalidlibrarydata'] = 'Ugyldig data givet til {$a->%property} i {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Ugyldig data givet til {$a->%property} i {$a->%library}. Boolsk værdi var ventet.';
$string['invalidlibraryname'] = 'Ugyldigt navn på bibliotek: {$a->%name}';
$string['invalidlibrarynamed'] = 'H5P-biblioteket {$a->%library} brugt til indholdet er ikke gyldigt';
$string['invalidlibraryoption'] = 'Ugyldig indstilling {$a->%option} i {$a->%library}';
$string['invalidlibraryproperty'] = 'Kan ikke læse egenskaben {$a->%property} i {$a->%library}';
$string['invalidmainjson'] = 'Der mangler en gyldig h5p.json-fil';
$string['invalidmultiselectoption'] = 'Ugyldig valgt indstilling i multi-valg';
$string['invalidpackage'] = 'Ugyldig H5P-indholdstype';
$string['invalidselectoption'] = 'Ugyldig valgt indstilling i valg';
$string['invalidsemanticsjson'] = 'Ugyldig semantics.json-fil i biblioteket {$a->%name}';
$string['invalidsemanticstype'] = 'Intern H5P-fejl: ukendt indholdstype "{$a->@type}". Fjerner indholdet!';
$string['invalidstring'] = 'Den angivne streng er ikke gyldig i henhold til regexp i semantics. (værdi: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['keywordExists'] = 'Nøgleordet eksisterer allerede!';
$string['keywords'] = 'Nøgleord';
$string['keywordsDescription'] = 'Du kan tilføje flere nøgleord adskilt af kommaer. Tryk på "Enter" eller "Tilføj" for at bekræfte nøgleordene';
$string['keywordsExits'] = 'Nøgleord eksisterer allerede!';
$string['keywordsPlaceholder'] = 'Tilføj nøgleord';
$string['language'] = 'Sporg';
$string['level'] = 'Niveau';
$string['librariesmanagerdescription'] = '<p>Med H5P kan brugere oprette interaktivt indhold i forskellige indholdstyper.</p>
<p>For at sikre at kun pålidelige H5P-indholdstyper bruges på din installation, skal du <i>enten</i></p><ul><li>Uploade H5P-indholdstyper fra h5p.org <i>eller</i></li><li>Aktivere den planlagte opgave "Hent tilgængelige H5P-indholdstyper fra h5p.org"</li></ul>
<p>Bemærk at brugere kun vil kunne bruge H5P-indholdstyper som er installeret på dit site.</p>';
$string['librarydirectoryerror'] = 'Bibliotekets mappenavn skal matche machineName eller majorVersion.minorVersion (fra library.json). (Mappe: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licens';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseDescription'] = 'Vælg en licens der passer til dit indhold';
$string['licenseDetails'] = 'Licensdetaljer';
$string['licenseDialogDescription'] = 'Klik på en specifik licens for at få informationer om hvordan den bruges';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licenseVersionDescription'] = 'Vælg en licensversion';
$string['licensee'] = 'Licensindehaver';
$string['licenseextras'] = 'Yderligere licens';
$string['licenseversion'] = 'Licensversion';
$string['lockh5pdeploy'] = 'Dette H5P-indhold er ikke tilgængeligt lige nu,  det er ved at blive rullet ud. Prøv igen senere.';
$string['logoUploadText'] = 'Organisationslogo eller avatar';
$string['longDescription'] = 'Lang beskrivelse';
$string['longDescriptionPlaceholder'] = 'Lang beskrivelse af dit indhold';
$string['mainTitle'] = 'Del <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Denne fil kan ikke vises, fordi dens indholdstype er deaktiveret. Kontakt din administrator for at bede om at få indholdstypen aktiveret.';
$string['maxLength'] = ':length er max. antal af tegn.';
$string['missingcontentfolder'] = 'Der mangler en gyldig indholdsmappe';
$string['missingcoreversion'] = 'Systemet kunne ikke installere komponenten {$a->%component} fra pakken da den kræver en nyere version af H5P-plugin\'et. Dette site kører version {$a->%current}, mens den krævede version er {$a->%required} eller højere. Upgrader og prøv igen.';
$string['missingdependency'] = 'Mangler afhængighed {$a->@dep} krævet af {$a->@lib}.';
$string['missinglibrary'] = 'Mangler nødvendigt bibliotek {$a->@library}';
$string['missinglibraryfile'] = 'Filen "{$a->%file}" mangler i biblioteket: "{$a->%name}"';
$string['missinglibraryjson'] = 'Kunne ikke finde library.json-fil i gyldigt json-format til biblioteket {$a->%name}';
$string['missinglibraryproperty'] = 'Den krævede egenskab {$a->%property} mangler i {$a->%library}';
$string['missingmbstring'] = 'PHP-udvidelsen mbstring er ikke indlæst. Den kræves for at H5P kan køre ordentligt.';
$string['missinguploadpermissions'] = 'Bemærk at bibliotekerne kan være i den fil du uploadede, men du har ikke tilladelse til at uploade nye biblioteker. Kontakt administrator.';
$string['next'] = 'Næste';
$string['nocopyright'] = 'Der er ingen tilgængelig information om copyright for dette indhold.';
$string['noextension'] = 'Den fil du uploadede, er ikke en gydig HTML5-pakke, den har ikke filendelsen "h5p").';
$string['noh5plibhandlerdefined'] = 'Der er ikke installeret håndtering af H5P-ramme, så H5P-indhold kan ikke vises.';
$string['nojson'] = 'Den primære h5p.json-fil er ugyldig';
$string['nopermissiontodeploy'] = 'Denne fil kan ikke vises, den er uploadet af en bruger uden den krævede beføjelse til at udrulle H5P-indhold';
$string['nopermissiontoedit'] = 'Du har ikke tilladelse til at redigere H5P-indhold.';
$string['notrustablefile'] = 'Denne fil kan ikke vises, den er uploadet af en bruger uden den krævede beføjelse til at udrulle H5P-indholdstyper. Kontakt din administrator og bed om at få indholdstypen installeret.';
$string['nounzip'] = 'Den fil du uploadede, er ikke en gyldig HTML5-pakke (den kan ikke pakkes ud).';
$string['offlineDialogBody'] = 'Vi kunne ikke sende information om din gennemførelse af denne opgave. Tjek din internetforbindelse.';
$string['offlineDialogHeader'] = 'Din forbindelse til serveren forsvandt.';
$string['offlineDialogRetryButtonLabel'] = 'Prøv igen nu';
$string['offlineDialogRetryMessage'] = 'Prøver igen om :num....';
$string['offlineSuccessfulSubmit'] = 'Resultater afleveret.';
$string['optionalInfo'] = 'Valgfri information';
$string['originator'] = 'Forfatter';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark (PDM)';
$string['phone'] = 'Telefon';
$string['pleaseWait'] = 'Vent venligst...';
$string['pluginname'] = 'H5P-pakke';
$string['privacy:metadata'] = 'H5P subsystem gemmer ingen personlige data.';
$string['publisherDescription'] = 'Udgiv beskrivelse';
$string['publisherDescriptionText'] = 'Dette vil blive vist under "Udgiver informationer" ved delt indhold';
$string['publisherFieldDescription'] = 'Dette vil blive vist som "Udgiverens navn" på delt indhold';
$string['publisherFieldTitle'] = 'Udgiver';
$string['remove'] = 'Fjern';
$string['removeChip'] = 'Fjern :chip fra listen';
$string['removeImage'] = 'Fjern Billede';
$string['requiredInfo'] = 'Påkrævet information';
$string['resizescript'] = 'Inkluder dette script på din websidt hvis du vil have dynamisk skalering af det indlejrede indhold:';
$string['resubmitScores'] = 'Forsøger at aflevere gemte resultater.';
$string['reuse'] = 'Genbrug';
$string['reuseContent'] = 'Genbrug indhold';
$string['reuseDescription'] = 'Genbrug dette indhold';
$string['reviewAndSave'] = 'Gennemse & gem';
$string['reviewAndShare'] = 'Gennemse & del';
$string['reviewInfo'] = 'Gennemse information';
$string['reviewMessage'] = 'Gennemgå oplysningerne nedenfor inden du deler';
$string['saveChanges'] = 'Gem ændringer';
$string['screenshots'] = 'Skærmbilleder';
$string['screenshotsDescription'] = 'Tilføj op til fem skærmbilleder af dit indhold';
$string['share'] = 'Del';
$string['shareFailed'] = 'Deling fejlet.';
$string['shareTryAgain'] = 'Noget gik galt, prøv at dele igen.';
$string['shared'] = 'Delt';
$string['sharingNote'] = 'Alle indholdsdetaljer kan redigeres efter deling';
$string['shortDescription'] = 'Kort beskrivelse';
$string['shortDescriptionPlaceholder'] = 'Kort beskrivelse af dit indhold';
$string['showadvanced'] = 'Vis avanceret';
$string['showless'] = 'Vis mindre';
$string['showmore'] = 'Vis mere';
$string['size'] = 'Størrelse';
$string['someKeywordsExits'] = 'Nogle af nøgleordene eksisterer allerede';
$string['source'] = 'Kilde';
$string['startingover'] = 'Du starter forfra.';
$string['status'] = 'Status';
$string['subContentWarning'] = 'Underindhold (billeder, spørgsmål osv.) vil blive delt under :license medmindre andet er angivet i forfatterværktøjet';
$string['sublevel'] = 'Underniveau';
$string['submitted'] = 'Afleveret!';
$string['task_h5p'] = 'Planlagt H5P-opgave';
$string['task_h5p_description'] = 'Den planlagte H5P-opgave downloader tilgængelige H5P-indholdstyper fra h5p.org.';
$string['thumbnail'] = 'Miniature';
$string['title'] = 'Titel';
$string['undisclosed'] = 'Ikke oplyst';
$string['unpackedFilesExceedsMaxSize'] = 'Den samlede størrelse på de udpakkede filer overstiger den tilladte maksimumstørrelse. ({$a->%used} > {$a->%max})';
$string['updatedlibraries'] = 'Opdaterede {$a->%old} H5P-biblioteker.';
$string['updatedlibrary'] = 'Opdaterede {$a->%old} H5P-bibliotek.';
$string['uploadlibraries'] = 'Upload H5P-indholdstyper.';
$string['uploadsuccess'] = 'H5P-indholdstyper er uploadet';
$string['width'] = 'Bredde';
$string['wrongversion'] = 'Den version af H5P-biblioteket {$a->%machineName} der bruges i dette indhold, er ikke gyldig. Indholdet indeholder {$a->%contentLibrary}, men det skal være {$a->%semanticsLibrary}.';
$string['year'] = 'År';
$string['years'] = 'År';
$string['yearsfrom'] = 'År (fra)';
$string['yearsto'] = 'År (til)';
$string['zip'] = 'Zip';
