<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'chat', language 'da', version '4.3'.
 *
 * @package     chat
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har forestående chatsessioner.';
$string['ajax'] = 'Version med anvendelse af AJAX';
$string['autoscroll'] = 'Auto-scroll';
$string['beep'] = 'Bip';
$string['bubble'] = 'Boble';
$string['cantlogin'] = 'Kunne ikke logge ind på chatten!';
$string['chat:addinstance'] = 'Tilføj en ny chat';
$string['chat:chat'] = 'Gå ind i et chatrum';
$string['chat:deletelog'] = 'Slet chatlogs';
$string['chat:exportparticipatedsession'] = 'Eksporter den chat-session du deltog i';
$string['chat:exportsession'] = 'Eksporter alle chatsessioner';
$string['chat:readlog'] = 'Vis chatlogs';
$string['chat:talk'] = 'Tal i en chat';
$string['chat:view'] = 'Vis chatten';
$string['chatintro'] = 'Beskrivelse';
$string['chatname'] = 'Navn på dette chatrum';
$string['chatreport'] = 'Chatsessioner';
$string['chattime'] = 'Næste planlagte chattid';
$string['compact'] = 'Kompakt';
$string['composemessage'] = 'Skriv en besked';
$string['configmethod'] = 'AJAX chat-metoden giver et AJAX-baseret chat-interface, der kontakter server regelmæssigt for opdatering. Den normale chatmetode virker ved at brugerne jævnligt kontakter serveren for at få opdateringer. Det kræver ingen konfiguration og kan bruges overalt, men kan give en stor belastning på serveren med mange chattere. En server-daemon kræver shell-adgang til Unix, men resulterer i et hurtigt opdateret chatmiljø.';
$string['confignormalupdatemode'] = 'Opdatering af chatrummet sker normalt effektivt med <em>Keep-Alive</em>-funktionen i http 1.1, men det er ret tungt for serveren. En mere avanceret metode er at bruge <em>Stream</em> til at levere opdateringer til brugerne. <em>Stream</em> kører bedre (a la metoden chatd), men er måske ikke understøttet af din server.';
$string['configoldping'] = 'Hvad er den maksimale tid der må gå, før vi opdager at en bruger har forladt chatten (i sekunder)? Dette er blot en øvre grænse, almindeligvis opdages det meget hurtigt. Lavere værdier vil være mere krævende for din server. Hvis du bruger den normale metode, sæt <strong>aldrig</strong> værdien lavere end 2 * chat_refresh_room.';
$string['configrefreshroom'] = 'Hvor ofte (i sekunder) skal chat-rummet opdateres? Lavere værdi får det til at virke hurtigere, men vil belaste webserveren mere, når mange brugere chatter samtidig. Bruger du <em>Stream</em> til opdatering kan du vælge højere frekvens - prøv med 2.';
$string['configrefreshuserlist'] = 'Hvor tit skal brugerlisten opdateres? (i sekunder)';
$string['configserverhost'] = 'Værtsnavnet på den computer hvor serverservices er';
$string['configserverip'] = 'Den numeriske IP-adresse på værten med serverservices.';
$string['configservermax'] = 'Maksimalt antal klienter tilladt';
$string['configserverport'] = 'Porten som serverservicen lytter på';
$string['coursetheme'] = 'Kursuslayout';
$string['crontask'] = 'Baggrundsbehandling af chat-modulet';
$string['currentchats'] = 'Aktive chatsessioner';
$string['currentusers'] = 'Er i chatten nu:';
$string['deletesession'] = 'Slet denne session';
$string['deletesessionsure'] = 'Er du sikker på at du vil slette denne session?';
$string['donotusechattime'] = 'Vis ikke chattider';
$string['enterchat'] = 'Gå ind i chatten.';
$string['entermessage'] = 'Skriv din besked';
$string['errornousers'] = 'Kunne ikke finde nogen brugere!';
$string['eventmessagesent'] = 'Besked sendt';
$string['eventsessionsviewed'] = 'Sessioner set';
$string['explaingeneralconfig'] = 'Disse indstillinger er <strong>altid</strong> i brug';
$string['explainmethoddaemon'] = 'Disse indstillinger har kun betydning hvis du har valgt "Chatserverservice" som chatmetode.';
$string['explainmethodnormal'] = 'Disse indstillinger har kun betydning hvis du har valgt "Normal metode" som chatmetode.';
$string['generalconfig'] = 'Generel konfiguration';
$string['idle'] = 'Venter';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inputarea'] = 'Input-område';
$string['invalidid'] = 'Fandt ikke chatten!';
$string['list_all_sessions'] = 'Vis alle sessioner.';
$string['list_complete_sessions'] = 'Oplist kun afsluttede sessioner.';
$string['listing_all_sessions'] = 'Viser alle sessioner.';
$string['messagebeepseveryone'] = '{$a} bipper alle!';
$string['messagebeepsyou'] = '{$a} har lige bippet dig!';
$string['messageenter'] = '{$a} er lige kommet til';
$string['messageexit'] = '{$a} har forladt chatten';
$string['messages'] = 'Beskeder';
$string['messageyoubeep'] = 'Du bippede {$a}';
$string['method'] = 'Chatmetode';
$string['methodajax'] = 'AJAX-metode';
$string['methoddaemon'] = 'Chatserverservice';
$string['methodnormal'] = 'Normal';
$string['modulename'] = 'Chat';
$string['modulename_help'] = 'Chatmodulet giver deltagerne mulighed for synkron skriftlig samtale i realtid.

Chatten kan være en engangsbegivenhed eller den kan gentages på samme tid hver dag eller hver uge. Chatsessioner gemmes og kan gøres tilgængelige for alle, eller begrænses til brugere med beføjelse til at se chatsessionslogs.

Chats er især gode når gruppen ikke kan mødes ansigt til ansigt, såsom

* Regelmæssige møder for studerende på onlinekurser for at give dem mulighed for at dele erfaringer med hinanden på det samme kursus, men fra forskellige steder
* Når en studerende midlertidigt er forhindret i at deltage i chat med læreren for at følge med i arbejdet
* Studerende i praktik kan dele deres erfaringer med hinanden og læreren
* Yngre børn der chatter hjemme om aftenen som en kontrolleret (overvåget) introduktion til en verden med sociale netværk
* En spørgsmål og svar-session med en inviteret taler på en anden lokalitet
* Sessioner til at hjælpe studerende med testforberedelse, hvor læreren eller andre studerende kan dele eksempler på spørgsmål';
$string['modulename_link'] = 'mod/chat/view';
$string['modulenameplural'] = 'Chat';
$string['neverdeletemessages'] = 'Slet aldrig beskeder';
$string['nextchattime'] = 'Næste chattid:';
$string['nextsession'] = 'Næste planlagte chat';
$string['no_complete_sessions_found'] = 'Der blev ikke fundet nogen afsluttede sessioner.';
$string['nochat'] = 'Ingen chat fundet';
$string['noguests'] = 'Denne chat er ikke åben for gæster';
$string['nomessages'] = 'Ingen beskeder endnu';
$string['nopermissiontoseethechatlog'] = 'Du har ikke tilladelse til at se chatloggen';
$string['normalkeepalive'] = 'Hold i gang';
$string['normalstream'] = 'Strøm';
$string['noscheduledsession'] = 'Ingen planlagte chatsessioner';
$string['notallowenter'] = 'Du har ikke adgangstilladelse til chatten.';
$string['notlogged'] = 'Du er ikke logget ind!';
$string['oldping'] = 'Timeout til afbrydelse af session';
$string['page-mod-chat-x'] = 'Alle chatsider';
$string['pastchats'] = 'Seneste chatsessioner';
$string['pastsessions'] = 'Tidligere sessioner';
$string['pluginadministration'] = 'Chatadministration';
$string['pluginname'] = 'Chat';
$string['privacy:metadata:chat_messages_current'] = 'Aktuel chat-session. Disse data er midlertidige og slettes når sessionen er slettet.';
$string['privacy:metadata:chat_users'] = 'Holder øje med hvilke brugere der er i hvilke chat-rum.';
$string['privacy:metadata:chat_users:firstping'] = 'Tidspunkt for første adgang til chatten.';
$string['privacy:metadata:chat_users:ip'] = 'Brugers IP';
$string['privacy:metadata:chat_users:lang'] = 'Brugers sprog';
$string['privacy:metadata:chat_users:lastmessageping'] = 'Tidspunkt for sidste besked i chat-rummet';
$string['privacy:metadata:chat_users:lastping'] = 'Tidspunkt for sidste adgang til chatten';
$string['privacy:metadata:chat_users:userid'] = 'Bruger-id';
$string['privacy:metadata:chat_users:version'] = 'Hvordan brugeren fik adgang til chatten (sockets/basic/ajax/header_js)';
$string['privacy:metadata:messages'] = 'En post med beskeder sendt under chat-sessionen';
$string['privacy:metadata:messages:issystem'] = 'Hvorvidt beskeden er systemgenereret';
$string['privacy:metadata:messages:message'] = 'Beskeden';
$string['privacy:metadata:messages:timestamp'] = 'Hvornår beskeden blev sendt.';
$string['privacy:metadata:messages:userid'] = 'Id på afsender af beskeden';
$string['refreshroom'] = 'Genindlæs';
$string['refreshuserlist'] = 'Genindlæs brugerliste';
$string['removemessages'] = 'Slet alle beskeder';
$string['repeatdaily'] = 'Samme tid hver dag';
$string['repeatnone'] = 'Ingen gentagelser - brug den kun angivne tid';
$string['repeattimes'] = 'Gentag/publicer sessioner';
$string['repeatweekly'] = 'Samme tid hver uge';
$string['saidto'] = 'sagt til';
$string['savemessages'] = 'Gem forrige sessioner';
$string['search:activity'] = 'Chat - aktivitetsinformation';
$string['seesession'] = 'Se denne session';
$string['send'] = 'Send';
$string['sending'] = 'Sender';
$string['serverhost'] = 'Servernavn';
$string['serverip'] = 'Server-IP';
$string['servermax'] = 'Max. antal brugere';
$string['serverport'] = 'Serverport';
$string['sessions'] = 'Chatsessioner';
$string['sessionstartsin'] = 'Den næste chatsession starter {$a} fra nu.';
$string['strftimemessage'] = '%H:%M';
$string['studentseereports'] = 'Alle kan se tidligere sessioner';
$string['studentseereports_help'] = 'Hvis den er sat til "Nej", kan kun brugere med beføjelsen "mod/chat:readlog" se en chatlog';
$string['talk'] = 'Tal';
$string['updatemethod'] = 'Opdateringsmetode';
$string['updaterate'] = 'Opdater bedømmelse:';
$string['userlist'] = 'Brugerliste';
$string['usingchat'] = 'Brug af chat';
$string['usingchat_help'] = 'Chatmodulet indeholder nogle funktioner, der gør chatten lidt rarere.

* Smilies - Enhver smiley (humørikon), som du kan bruge andre steder i Moodle kan også skrives her, for eksempel :-)
* Links - Webadresser vil automatisk blive forvandlet til links
* Mit humør - Du kan starte en linje med "/me" eller ":" til emote (regibemærkning), hvis for eksempel dit navn er Kim og du skriver ": griner!" eller "/me griner!" så vil alle se "Kim griner!"
* Bip - Du kan sende en lyd til andre deltagere ved at klikke på "bip"-linket ved siden af deres navn. En hurtig genvej til at bippe alle deltagere i chatten på en gang, er at skrive "beep all".
* HTML - Hvis du kender til HTML-kode, kan du bruge den i din tekst til f.eks. at indsætte billeder, afspille lyde eller oprette tekst i forskellig farve.';
$string['viewreport'] = 'Tidligere sessioner';
