<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'da', version '4.3'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'Logo til godkendelsesmetode';
$string['auth_shib_auth_logo_description'] = 'Sørg for et logo til godkendelsesmetoden Shibboleth, som dine brugere kan genkende. Det kan være din Shibboleth-sammenslutnings logo, f.eks.<tt>SWITCHaai Login</tt>, <tt>InCommon Login</tt> eller lignende.';
$string['auth_shib_auth_method'] = 'Navn på godkendelsesmetode';
$string['auth_shib_auth_method_description'] = 'Giv godkendelsesmetoden Shibboleth et navn dine brugere kan genkende. Det kunne være navnet på din Shibboleth-sammenslutning, f.eks. <tt>SWITCHaai Login</tt>, <tt>InCommon Login</tt> eller lignende.';
$string['auth_shib_changepasswordurl'] = 'URL til ændring af adgangskode';
$string['auth_shib_contact_administrator'] = 'I tilfælde af at du ikke har tilknytning til de givne organisationer og har brug for adgang til et kursus på denne server, bedes du kontakte <a href="mailto:{$a}">Moodles Administrator</a>.';
$string['auth_shib_convert_data'] = 'Datamanipulerings-API';
$string['auth_shib_convert_data_description'] = 'Du kan benytte dette API til yderligere at ændre data fra Shibboleth. Læs mere på siden <a href="../auth/shibboleth/README.txt" target="_blank">README</a>.';
$string['auth_shib_convert_data_filepath_warning'] = 'Du kan ikke bruge en fil, der er placeret i den aktuelle datamappe på webstedet ($CFG->dataroot) som dataændrings-API.';
$string['auth_shib_convert_data_warning'] = 'Filen eksisterer ikke eller kan ikke læses under webserverens behandling!';
$string['auth_shib_idp_list'] = 'Identitetsleverandører';
$string['auth_shib_idp_list_description'] = 'Vis en liste med identitetsleverandørers entityIDs som brugeren kan vælge fra på loginsiden.<br />
På hver linje skal der være en kommasepareret post til identitetsleverandørens entityID (se Shibboleths metadatafil) og navn som det skal vises i rullemenuen.<br />
Som en frivillig tredje parameter kan du tilføje lokationen på Shibboleths sessionsindikator som skal bruges hvis din Moodle er en del af et setup af flere sammenslutninger.';
$string['auth_shib_instructions'] = 'Benyt <a href="{$a}">Shibboleth login</a> til at få adgang via Shibboleth, hvis din institution understøtter det.<br />Ellers kan den normale loginmetode, der er vist her, benyttes.';
$string['auth_shib_instructions_help'] = 'Her bør du forklare brugerne hvad Shibboleth er. Forklaringen vises på loginsiden i instruktionssektionen. Instruksen skal indeholde et link til "<b>{$a}</b>" som brugere skal klikke på når de vil logge ind.';
$string['auth_shib_instructions_key'] = 'Logininstruktioner';
$string['auth_shib_integrated_wayf'] = 'Moodle WAYF-service';
$string['auth_shib_integrated_wayf_description'] = 'Hvis du aktiverer dette, vil Moodle bruge sin egen WAYF-service i stedet for den der er sat op til Shibboleth. Moodle vil vise en rullemenu på den alternative loginside, hvor brugeren han vælge sin identitetsleverandør.';
$string['auth_shib_logout_return_url'] = 'Alternativ retur-URL efter logud';
$string['auth_shib_logout_return_url_description'] = 'Angiv en URL Shibboleth-brugere skal omdirigeres til efter logud.<br />Efterlades feltet tomt, vil brugere blive omdirigeret til samme sted som Moodle omdirigerer brugere til.';
$string['auth_shib_logout_url'] = 'URL til Shibboleth-leverandørens logouthåndtering';
$string['auth_shib_logout_url_description'] = 'Indtast URL\'en til Shibboleth-leverandørens logouthåndtering. Det er typisk <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Hvis du vil bruge en integreret WAYF-service, skal du oprette en kommasepareret liste med identitetsleverandør-id\'er, deres navne og eventuelt en sessions-initiator.';
$string['auth_shib_only'] = 'Kun Shibboleth';
$string['auth_shib_only_description'] = 'Benyt denne mulighed hvis Shibboleth-godkendelse skal gennemtvinges.';
$string['auth_shib_username_description'] = 'Navnet på Shibboleth webserverens environment variabel der skal benyttes som Moodles brugernavn.';
$string['auth_shibboleth_errormsg'] = 'Vælg den organisation du er medlem af!';
$string['auth_shibboleth_login'] = 'Shibboleth login';
$string['auth_shibboleth_login_long'] = 'Log ind på Moodle via Shibboleth';
$string['auth_shibboleth_manual_login'] = 'Manuelt login';
$string['auth_shibboleth_select_member'] = 'Jeg er medlem af...';
$string['auth_shibboleth_select_organization'] = 'Til godkendelse via Shibboleth skal du vælge din organisation fra rullemenuen:';
$string['auth_shibbolethdescription'] = 'Ved brug af denne metode oprettes og godkendes brugere gennem Shibboleth. Se oplysninger om opsætning på siden <a href="{$a}">Shibboleth README</a>.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'Godkendelsesplugin\'et Shibboleth gemmer ingen personlige data.';
$string['shib_invalid_account_error'] = 'Du ser ud til at være Shibboleth-godkendt, men Moodle har ikke en gyldig konto med dit brugernavn. Din konto eksisterer måske ikke eller er blevet suspenderet.';
$string['shib_no_attributes_error'] = 'Du er blevet godkendt af Shibboleth men Moodle har ikke modtaget nogen brugeroplysninger. Kontroller at din identitetsleverandør frigiver de nødvendige attributter ({$a}) til den serviceleverandør Moodle kører hos, eller fortæl det til administratoren af webserveren.';
$string['shib_not_all_attributes_error'] = 'Moodle kræver bestemte Shibboleth-oplysninger som ikke er tilgængelige i dit tilfælde. Oplysningerne er: {$a}<br />Kontakt Moodles administrator eller identitetsleverandørens administrator.';
$string['shib_not_set_up_error'] = 'Shibboleth-godkendelsen lader ikke til at være sat korrekt op da ingen af Shibboleths miljø-variable forekommer for denne side. Se <a href="{$a}">README</a> for yderlige instruktioner om hvordan Shibboleth-godkendelse konfigureres, eller kontakt webmaster.';
