<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'sr_lt', version '4.3'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'Logo metoda provere identiteta';
$string['auth_shib_auth_logo_description'] = 'Navedite logo za Shibboleth metodu provere identiteta koji je poznat vašim korisnicima. To može biti logo vaše Shibboleth federacije, npr. <tt>SWITCHaai Login</tt> ili <tt>InCommon Login</tt> ili slično.';
$string['auth_shib_auth_method'] = 'Naziv metoda za proveru identiteta';
$string['auth_shib_auth_method_description'] = 'Navedite naziv za Shibboleth metodu provere identiteta koji je poznat vašim korisnicima. To može biti naziv vaše Shibboleth federacije, npr. <tt>SWITCHaai Login</tt> ili <tt>InCommon Login</tt> ili slično.';
$string['auth_shib_changepasswordurl'] = 'URL za promenu lozinke';
$string['auth_shib_contact_administrator'] = 'U slučaju da niste povezani sa navedenim organizacijama a treba da pristupite kursu na ovom serveru, molimo kontaktirajte <a href="mailto:{$a}">Moodle administratora</a>.';
$string['auth_shib_convert_data'] = 'API za modifikacije podataka';
$string['auth_shib_convert_data_description'] = 'Možete da koristite ovaj API za dalju modifikaciju podataka dobijenih od Shibboletha. Pročitajte <a href="{$a}">README</a> za dodatna uputstva.';
$string['auth_shib_convert_data_filepath_warning'] = 'Ne možete koristiti datoteku koja se nalazi u tekućem direktorijumu podataka sajta ($CFG->dataroot) kao API za modifikaciju podataka.';
$string['auth_shib_convert_data_warning'] = 'Datoteka ne postoji ili proces Web servera ne može da je pročita';
$string['auth_shib_idp_list'] = 'Davaoci identiteta';
$string['auth_shib_idp_list_description'] = 'Obezbedite spisak entityID oznaka provajdera identiteta (Identity Provider – IdP) kako biste omogućili korisnicima da izaberu na stranici za prijavu.<br />U svakom redu mora da bude po jedan dublet podataka, koji se sastoji od ID oznake i naziva IdP (pogledajte Shibboleth metadata datoteku), onako kao što će to biti prikazano u padajućoj listi.<br /> Kao treći opcioni parametar možete da dodate lokaciju inicijatora Shibboleth sesije koja će se koristiti u slučaju da je Vaša instalacija Moodlea deo više-federacijskog podešavanja.';
$string['auth_shib_instructions'] = 'Koristite <a href="{$a}">Shibboleth pristup sistemu</a> da biste pristupili preko Shibboletha, ako ga vaša institucija podržava. U suprotnom, koristite standardan obrazac za prijavu prikazan ovde.';
$string['auth_shib_instructions_help'] = 'Ovde treba da unesete uputstvo za Vaše korisnike kako biste im objasnili Shibboleth. Ono će biti prikazano na stranici za prijavljivanje. Uputstvo mora da sadrži link ka "<b>{$a}</b>" na koji će  korisnici kliknuti kada budu hteli da se prijave na sistem.';
$string['auth_shib_instructions_key'] = 'Uputstvo za prijavu na sistem';
$string['auth_shib_integrated_wayf'] = 'Moodle WAYF servis';
$string['auth_shib_integrated_wayf_description'] = 'Ako omogućite ovu opciju, Moodle će koristiti svoj WAYF servis umesto onog koji je konfigurisan za Shibboleth. Moodle će prikazati padajuću listu na ovoj alternativnoj stranici za prijavu na sistem gde će korisnik moći da izabere svog davaoca identiteta.';
$string['auth_shib_logout_return_url'] = 'Alternativni URL nakon odjave';
$string['auth_shib_logout_return_url_description'] = 'Obezbedite URL na koji će Shibboleth korisnici biti preusmereni nakon odjave sa sistema<br />Ako je ostavljeno prazno, korisnici će biti preusmereni na lokaciju na koju se inače preusmeravaju Moodle korisnici';
$string['auth_shib_logout_url'] = 'URL nakon odjave (Shibboleth SP)';
$string['auth_shib_logout_url_description'] = 'Obezbedite URL nakon odjave sa Shibboleth Service Providera. Ovo je obično <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Ukoliko želite da koristite integrisani WAYF servis, morate da date listu Provajdera identiteta (Identity Provider entityIDs) razdvojenu zarezom, njihova imena i opciono pokretača sesije.';
$string['auth_shib_only'] = 'Samo Shibboleth';
$string['auth_shib_only_description'] = 'Potvrdite ovu opciju ukoliko želite da provera identiteta pomoću Shibboletha bude nametnuta.';
$string['auth_shib_username_description'] = 'Naziv Web servera promenljive Shibboleth okruženja koja će se koristiti kao Moodle korisničko ime';
$string['auth_shibboleth_errormsg'] = 'Izaberite organizaciju čiji ste član?';
$string['auth_shibboleth_login'] = 'Shibboleth prijava na sistem';
$string['auth_shibboleth_login_long'] = 'Prijava na Moodle preko Shibboletha';
$string['auth_shibboleth_manual_login'] = 'Ručna prijava na sistem';
$string['auth_shibboleth_select_member'] = 'Ja sam član...';
$string['auth_shibboleth_select_organization'] = 'Za proveru identiteta putem Shibboletha molimo vas da izaberete svoju organizaciju iz padajućeg menija:';
$string['auth_shibbolethdescription'] = 'Pomoću ovog metoda korisnici se kreiraju i njihov identitet proverava koristeći Shibboleth. Za više informacija o podešavanju pogledajte <a href="{$a}">Shibboleth README</a>.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'Dodatak za proveru identiteta Shibboleth ne čuva nikakve lične podatke.';
$string['shib_invalid_account_error'] = 'Čini se da vas je Shibboleth autorizovao ali Moodle nema važeći nalog za vaše korisničko ime. Vaš nalog možda ne postoji ili postoji mogućnost da je suspenodavan.';
$string['shib_no_attributes_error'] = 'Izgleda da je Shibboleth potvrdio Vaš identitet ali Moodle nije dobio korisničke atribute. Proverite da li je Vaš Davalac identiteta izdao potrebne atribute ({$a})  ili obavestite administratora ovog servera.';
$string['shib_not_all_attributes_error'] = 'Moodle traži određene Shibboleth atribute koji u Vašem slučaju nisu prisutni. Traženi su sledeći atributi: {$a}<br />Molimo Bas da kontaktirate Webmastera ovog servera ili Davaoca identiteta.';
$string['shib_not_set_up_error'] = 'Izgleda da Shibboleth provera identiteta nije ispravno podešena zato što nisu prisutne varijable Shibboleth okruženja za ovu stranicu. Molimo vas da pročitate <a href="{$a}">README</a> za da dalja uputstva o podešavanju Shibboleth provere identiteta ili se obratite administratoru ove Moodle instalacije.';
