<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'pulse', language 'de', version '4.0'.
 *
 * @package     pulse
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Aktionen';
$string['apply_customize'] = 'Übernehmen und anpassen';
$string['apply_save'] = 'Übernehmen und speichern';
$string['approve'] = 'Freigeben';
$string['approved'] = 'Freigegeben';
$string['approvedby'] = 'Freigegeben durch';
$string['approvedeclined'] = 'Freigabe verweigert';
$string['approvedon'] = 'Freigegeben am {$a->date} durch {$a->user}';
$string['approvedsuccess'] = 'Erfolgreich freigegeben';
$string['approveduser'] = 'Freigegeben durch {$a->user}';
$string['approveuser'] = 'Nutzer/innen freigeben - {$a->course}';
$string['approveuserbtn'] = 'Nutzer/innen freigeben';
$string['box'] = 'Box';
$string['boxicon'] = 'Box Symbol';
$string['boxtype'] = 'Box Typ';
$string['completereaction'] = 'Reaktion abschließen';
$string['completewhenavaialble'] = 'Abgeschlossen, wenn verfügbar';
$string['completewhenavaialble_help'] = 'Die Aktivität ist abgeschlossen, sobald sie für Nutzer/innen verfügbar ist (d.h. wenn keine Voraussetzungen konfiguriert sind, oder sie erfüllt sind)';
$string['completion:approval'] = 'Freigabe erforderlich';
$string['completion:available'] = 'Abschlusskriterien müssen erfüllt werden';
$string['completion:self'] = 'Bestätigen';
$string['completionapproverules'] = 'Freigabe Regeln';
$string['completioncriteria'] = 'Abschlusskriterien';
$string['completionfor'] = 'Abschluss für';
$string['completionrequireapproval'] = 'Freigabe durch eine der gewählten Rollen erforderlich';
$string['completionrequireapproval_help'] = 'Die Aktivität ist abgeschlossen, sobald eine Person mit der erforderlichen Rolle sie freigegeben hat.';
$string['completionself'] = 'Selbst bestätigen';
$string['completionself_help'] = 'Die Aktivität ist abgeschlossen, sobald Teilnehmer/innen selbst bestätigen, dass die Aktivität abgeschlossen ist — im Gegensatz zum manuellen Aktivitätsabschluss ist dies nicht mehr änderbar.';
$string['configparams'] = 'Konfigurationsparameter';
$string['configrableparams'] = 'Konfigurationsparameter';
$string['confirmdeletetemplate'] = 'Möchten Sie die Vorlage wirklich löschen?';
$string['content'] = 'Inhalt';
$string['content_help'] = 'Der Inhalt wird auf der Kurshauptseite gezeigt und als Text für die Einladung verwendet.';
$string['courserole'] = 'Kursrolle';
$string['createpreset'] = 'Vorlage erstellen';
$string['creditesgroup'] = 'Credits';
$string['credits'] = 'Credits';
$string['creditsfield'] = 'Profilfeld für Credits';
$string['creditsfielddesc'] = 'Wählen Sie das Profilfeld, das Sie für Credits nutzen. Sie sollten das Feld verstecken oder für Nutzer sperren.';
$string['cssclass'] = 'CSS Klasse';
$string['danger'] = 'Warnung';
$string['dark'] = 'Dunkel';
$string['decline'] = 'Ablehnen';
$string['declined'] = 'Abgelehnt';
$string['deletepreset'] = 'Pulse Pro Vorlage löschen';
$string['description'] = 'Beschreibung';
$string['diffnotification'] = 'Nachrichtentext statt Inhalt verwenden';
$string['diffnotification_help'] = 'Die Einladung versendet standardmäßig den Inhalt aus dem Abschnitt "Allgemein";  alternativ kann der Nachrichtentext verwendet werden.';
$string['disabled'] = 'Inaktiv';
$string['dislike'] = 'Gefällt mir nicht';
$string['displaymode'] = 'Darstellungsmodus';
$string['displaytype:contentonly'] = 'Nur auf der Kursseite zeigen';
$string['displaytype:notificationcontent'] = 'Auf Kursseite und in Nachricht zeigen';
$string['displaytype:notificationonly'] = 'Nur in der Nachricht zeigen';
$string['enable:disable'] = 'Aktivieren / Deaktivieren';
$string['enabled'] = 'Aktiv';
$string['enablereminder:first'] = 'Erste Erinnerung aktivieren';
$string['enablereminder:first_help'] = 'Wenn aktiviert, wird die erste Erinnerung versendet';
$string['enablereminder:invitation'] = 'Einladung aktivieren';
$string['enablereminder:recurring'] = 'Wiederkehrende Erinnerung aktivieren';
$string['enablereminder:recurring_help'] = 'Wenn aktiviert, werden wiederkehrende Erinnerungen versendet, solange die Personeingeschrieben und nicht gesperrt ist.';
$string['enablereminder:second'] = 'Zweite Erinnerung aktivieren';
$string['enablereminder:second_help'] = 'Wenn aktiviert, wird die zweite Erinnerung versendet';
$string['generatereport'] = 'Report erstellen';
$string['head:firstreminder'] = 'Erste Erinnerung';
$string['head:recurringreminder'] = 'Wiederkehrende Erinnerung';
$string['head:secondreminder'] = 'Zweite Erinnerung';
$string['instancename'] = 'Pulse';
$string['instruction'] = 'Anweisung';
$string['invitation'] = 'Einladung';
$string['invitation_help'] = 'Einladung an alle Nutzer/innen der ausgewählten Rollen senden';
$string['invitationsubject'] = 'Betreff';
$string['invitationsubject_help'] = 'Text für den Betreff der Einladung';
$string['learnmore'] = 'Mehr erfahren';
$string['light'] = 'Hell';
$string['like'] = 'Gefällt mir';
$string['logintoreact'] = 'Zum Reagieren anmelden';
$string['managepresets'] = 'Vorlagen verwalten';
$string['markcomplete'] = 'Bestätigen';
$string['messageprovider:mod_pulse'] = 'Jetzt senden';
$string['modulename'] = 'Pulse';
$string['modulename_help'] = 'Die Aktivität Pulse bietet dem Trainer/Lehrer Tools, um das Engagement und die Compliance von Mitarbeitern/Schülern zu verbessern.<br>
<br>
<b>(1) Nachrichten</b><br>
Die Aktivität Pulse verschickt Nachrichten nur, wenn die Aktivität für den Nutzer verfügbar ist. Die Verfügbarkeit wird über Voraussetzungen gesteuert und ist dadurch sehr flexibel. Nachrichten können durch Platzhalter personalisiert werden und an Kursrollen (Teilnehmer, Trainer, Manager etc.) sowie an Nutzerrollen (Vorgesetzter, Eltern etc.) versendet werden.

<b>(2) (Erweiterte) Kurs Workflows</b><br>
Pulse stellt drei Abschlussbedingungen zur Verfügung:
<ol>
<li><b>Verfügbarkeit</b><br>Abgeschlossen, sobald verfügbar</li>
<li><b>Bestätigung</b><br>Abgeschlossen, sobald Teilnehmer selbst bestätigt</li>
<li><b>Freigabe</b><br>Abgeschlossen, sobald ein Nutzer mit einer bestimmten Rolle freigibt</li>
</ol>';
$string['modulenameplural'] = 'Pulse';
$string['noreaction'] = 'Keine Reaktion';
$string['normal'] = 'Normal';
$string['notassignedgroup'] = 'Nutzer muss Teil einer Gruppe sein, um filtern zu können';
$string['notificationfooter'] = 'Fußzeile';
$string['notificationfooterdesc'] = '{$a->placeholders}';
$string['notificationheader'] = 'Kopfzeile';
$string['notificationheaderdesc'] = '{$a->placeholders}';
$string['notifyusers'] = 'Nutzer benachrichtigen';
$string['notsameuser'] = 'Sie sind nicht die richtige Person.';
$string['pluginadministration'] = 'Pulse Einstellungen';
$string['pluginname'] = 'Pulse';
$string['preset_template'] = 'Vorlagedatei';
$string['preset_template_help'] = 'Laden Sie die Sicherungsdatei der Pulse Aktivität hoch';
$string['presetcreated'] = 'Pulse Vorlage erfolgreich erstellt';
$string['presetdeleted'] = 'Pulse Vorlage erfolgreich gelöscht';
$string['preseticon'] = 'Vorlage Symbol';
$string['presetlist'] = 'Liste der Vorlagen';
$string['presetmodaltitle'] = 'Vorlage {$a->title} verwenden';
$string['presetorder'] = 'Vorlage Reihenfolge';
$string['presets'] = 'Pulse Vorlagen';
$string['presetstatus'] = 'Diese Vorlage in der Liste zeigen';
$string['presetupdated'] = 'Pulse Vorlage erfolgreich aktualisiert';
$string['previousreminders'] = 'Vorherige Erinnerungen';
$string['primary'] = 'Primär';
$string['privacy:completion'] = 'Abschluss';
$string['privacy:invitation'] = 'Einladung';
$string['privacy:metadata'] = 'Das Plugin speichert keine personenbezogenen Daten.';
$string['privacy:metadata:completion:approvalstatus'] = 'Status der Nutzerfreigabe';
$string['privacy:metadata:completion:approvaltime'] = 'Freigabezeitpunkt';
$string['privacy:metadata:completion:approveduser'] = 'ID der Person, die freigegeben hat';
$string['privacy:metadata:completion:selfcompletion'] = 'Status der eigenen Abschlussbestätigung';
$string['privacy:metadata:completion:selfcompletiontime'] = 'Zeitpunkt der eigenen Abschlussbestätigung';
$string['privacy:metadata:completion:timemodified'] = 'Abschlusszeitpunkt verändert';
$string['privacy:metadata:completion:userid'] = 'Nutzer-ID der Person';
$string['privacy:metadata:pulsecompletion'] = 'Pulse Nutzer Aktivitätsabschlüsse';
$string['privacy:metadata:pulsemessageexplanation'] = 'Einladungen werden an die Nutzer/innen über das Mitteilungssystem gesendet';
$string['privacy:metadata:pulseusers'] = 'Liste der versandten Einladungen';
$string['privacy:metadata:users:status'] = 'Status der Einladungen (vorherige und aktuelle)';
$string['privacy:metadata:users:timecreated'] = 'Zeitpunkt des Einladungsversands';
$string['privacy:metadata:users:userid'] = 'Nutzer-ID der benachrichtigen Person';
$string['promotionaltext'] = 'Pulse Pro bietet Erinnerungen, Reaktionen direkt in e-Mails und die Erstellung von eigenen Vorlagen';
$string['pulse:addinstance'] = 'Neues Pulse hinzufügen';
$string['pulse:notifyuser'] = 'Nachricht senden';
$string['pulse:view'] = 'Pulse anzeigen';
$string['pulse_subject'] = 'Pulse von {Course_FullName} ({Site_FullName})';
$string['pulsenotavailable'] = 'Pulse Instanz wurde nicht zum Kurs hinzugefügt';
$string['pulsenotification'] = 'Pulse Benachrichtigung';
$string['pulsepro:viewreports'] = 'Pulse Pro Berichte ansehen';
$string['rate'] = 'Bewerten';
$string['reaction'] = 'Reaktion';
$string['reaction:approve'] = '<a href="{$a->reactionurl}" style="color: #fff;background: #0f6fc5;padding:.375rem .75rem;text-decoration-line: none;" > Freigeben </a>';
$string['reaction:markcomplete'] = '<a href="{$a->reactionurl}" style="color: #fff;background: #0f6fc5;padding: .375rem .75rem;text-decoration-line: none;" > Bestätigen </a>';
$string['reaction:rate'] = '';
$string['reactiondisplaytype'] = 'Ort';
$string['reactiondisplaytype_help'] = 'Bitte wählen, wo die Reaktion gezeigt werden soll.';
$string['reactions'] = 'Reaktionen';
$string['reactionthankmsg'] = 'Vielen Dank! Ihre Antwort ist gespeichert.<br><br> <span>Sie können das Fenster nun schließen</span>';
$string['reactiontype'] = 'Typ';
$string['reactiontype_help'] = 'Liste der Reaktionsarten';
$string['recipients'] = 'Empfänger der Nachricht';
$string['recipients_help'] = 'Bitte wählen Sie die Rollen, an die Sie die Nachricht schicken wollen. Nur eingeschriebene Nutzer/innen mit der gewählten Rolle halten Nachrichten. Dies gilt nicht für Nutzer/innen mit einer Rolle, die im Nutzerkontext zugewiesen wurde (z.B. Eltern)';
$string['remindercontent'] = 'Nachrichtentext';
$string['remindercontent_help'] = 'Wird an Empfänger gesendet.';
$string['reminders:availabletime'] = 'Zeitpunkt der Verfügbarkeit';
$string['reminders:first'] = 'Erste Erinnerung';
$string['reminders:recurring'] = 'Wiederkehrende Erinnerung';
$string['reminders:second'] = 'Zweite Erinnerung';
$string['reminderschedule'] = 'Zeitplan';
$string['reminderschedule_help'] = 'Definiert, wann die Erinnerung versendet werden soll. Erinnerungen können entweder an einem bestimmten Datum oder nach einem Zeitraum versendet werden. In letzterem Fall gilt der Zeitpunkt, wann die Aktivität verfügbar wird/wurde für den Nutzer als Startpunkt. Generell werden Erinnerungen nur versendet, wenn die Aktivität verfügbar ist für den Nutzer.';
$string['remindersubject'] = 'Betreff';
$string['remindersubject_help'] = 'Bitte den Betreff der Erinnerung eingeben';
$string['reports'] = 'Pulse Berichte';
$string['reportsfilename'] = 'Pulse Berichte - {$a->name}';
$string['resendnotification'] = 'Erneut senden';
$string['resendnotification_help'] = 'Hiermit können Sie eine Nachricht erneut senden, auch wenn diese bereits versendet wurde.';
$string['resendnotificationdesc'] = 'Erneuter Versand der Nachricht eingeplant.';
$string['restrictionmet'] = 'Bedingungen erfüllt';
$string['schedule:fixeddate'] = 'Festes Datum';
$string['schedule:relativedate'] = 'Zeitraum';
$string['search:activity'] = 'Pulse';
$string['secondary'] = 'Sekundär';
$string['selectpulse'] = 'Pulse Instanz auswählen';
$string['self'] = 'Selbst';
$string['selfmarked'] = 'Selbst bestätigt am {$a->date}';
$string['sendnotificaton'] = 'Einladung senden';
$string['sendnotificaton_help'] = 'Wenn aktivitiert, wird die Einladung versendet';
$string['setup'] = 'Profilfeld konfigurieren';
$string['setupcredit'] = 'Um diese Funktion zu nutzen, müssen Sie zunächst das Profilfeld für Credits erstellen. Fragen Sie ggf. Ihren lokalen Administrator um Hilfe.';
$string['statuslabel'] = 'Aktivieren / Deaktivieren';
$string['success'] = 'Erfolgreich';
$string['teacher'] = 'Trainer/in';
$string['title'] = 'Titel';
$string['title_help'] = 'Der Titel wird als Name der Aktivität verwendet und als Betreff für die Einladung.';
$string['tokenexpired'] = 'Token abgelaufen — Reaktion kann nicht gespeichert werden';
$string['update_preset'] = 'Vorlage aktualisiert';
$string['updatecompletion'] = 'Pulse Aktivitätsabschluss aktualisieren';
$string['updateusercredits'] = 'Credits des Nutzers aktualisieren';
$string['usepreset'] = 'Vorlage anwenden';
$string['userrole'] = 'Nutzerrolle';
$string['viewreport'] = 'Bericht ansehen';
$string['warning'] = 'Warnung';
