<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'sk', version '4.0'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Aktivácia';
$string['activityloading'] = 'Budete automaticky presmerovaní do aktivity za';
$string['activityoverview'] = 'Máte SCORM balíky, ktoré si vyžadujú vašu pozornosť';
$string['activitypleasewait'] = 'Aktivita je nahrávaná, čakajte prosím ...';
$string['adminsettings'] = 'Administrátorské nastavenia';
$string['advanced'] = 'Parametre';
$string['aicchacpkeepsessiondata'] = 'Dáta AICC HACP relácie';
$string['aicchacpkeepsessiondata_desc'] = 'Dĺžka času v dňoch na uchovanie dát externej AICC HACP relácie (nastavenie s vysokým číslom vyplní tabuľku starými dátami, ale môže to byť užitočné pri odstraňovaní chýb)';
$string['aicchacptimeout'] = 'Časový limit na AICC HACP';
$string['aicchacptimeout_desc'] = 'Dĺžka času v minútach, počas ktorého externá AICC HACP relácia môže zostať otvorená';
$string['aiccuserid'] = 'Používateľské ID - číselné heslo pre AICC';
$string['aiccuserid_desc'] = 'AICC štandard pre používateľské mená je veľmi obmedzujúci v porovnaní s Moodle. Povoľuje len alfanumerické znaky, pomlčku (-) a podčiarnik (_). Bodky, medzery a symbol @ nie sú povolené. Ak je táto možnosť aktivovaná, do AICC balíka sú odovzdávané ID čísla používateľov namiesto používateľských mien.';
$string['aliasonly'] = 'Keď si vyberiete súbor imsmanifest.xml z úložiska, musíte pre tento súbor použiť alias/skratku.';
$string['allowapidebug'] = 'Aktivovať API odstraňovanie chýb a sledovanie (nastavte masku zachytenia pomocou API masky odstraňovania chýb apidebugmask)';
$string['allowtypeaicchacp'] = 'Aktivovať externé AICC HACP';
$string['allowtypeaicchacp_desc'] = 'Ak je táto možnosť aktivovaná, umožní sa AICC HACP externá komunikácia bez používania používateľského loginu pre následné požiadavky z externého AICC balíka.';
$string['allowtypeexternal'] = 'Povoliť externý typ balenia';
$string['allowtypeexternalaicc'] = 'Aktivovať priamu AICC URL adresu';
$string['allowtypeexternalaicc_desc'] = 'Ak je táto možnosť aktivovaná, umožní sa priame volanie cez URL na jednoduchý AICC balík';
$string['allowtypelocalsync'] = 'Povoliť prevzatý typ súboru';
$string['apidebugmask'] = 'API maska zachytenia chýb - použite jednoduchý regex na <username>:<activityname> napr. admin:.* ukáže oznámenia odstraňovanie chýb len pre používateľa - administrátora';
$string['areacontent'] = 'Súbor obsahu';
$string['areapackage'] = 'Súboru balíka';
$string['asset'] = 'Objekt';
$string['assetlaunched'] = 'Objekt - Prezrené';
$string['attempt'] = 'Pokus';
$string['attempt1'] = '1 pokus';
$string['attempts'] = 'Pokusy';
$string['attemptsmanagement'] = 'Správa pokusov';
$string['attemptstatusall'] = 'Nástenka a vstupná stránka';
$string['attemptstatusentry'] = 'Iba vstupná stránka';
$string['attemptstatusmy'] = 'Iba Nástenka';
$string['attemptsx'] = '{$a} pokusov';
$string['attr_error'] = 'Nesprávna hodnota atribútu ({$a->attr}) v tagu {$a->tag}.';
$string['autocommit'] = 'Automatické ukladanie';
$string['autocommit_help'] = 'Ak je táto možnosť aktivovaná, SCORM dáta sa automaticky uložia do databázy. Nastavenie je  užitočné pre SCORM objekty, ktoré svoje dáta neukladajú pravidelne.';
$string['autocommitdesc'] = 'Automaticky ukladať SCORM dáta, ak ich SCORM balíček neukladá sám.';
$string['autocontinue'] = 'Automatické pokračovanie';
$string['autocontinue_help'] = '<p>Ak je táto voľba nastavená, spustí sa automaticky ďalší dostupný
vzdelávací objekt, keď aktuálny vzdelávací objekt vyvolá metódu &quot;ukončiť
komunikáciu&quot;.</p>

<p>Ak je Automatické pokračovanie vypnuté, musí používateľ pre
pokračovanie použiť tlačidlo &quot;Pokračovať&quot;.</p>';
$string['autocontinuedesc'] = 'Ak je povolené, nasledovné vzdelávacie objekty sú spustené automaticky, inak je nutné použiť tlačidlo Pokračovať.';
$string['averageattempt'] = 'Priemer zo všetkých pokusov';
$string['badarchive'] = 'Musíte zadať platný ZIP súbor';
$string['badimsmanifestlocation'] = 'Bol nájdený súbor imsmanifest.xml, ale nebol v koreňovom adresári vášho ZIP súboru, prosím, skontrolujte a prípadne znovu zbaľte váš SCORM balík';
$string['badmanifest'] = 'Chyby v manifeste: viď záznamy o chybách';
$string['browse'] = 'Prechádzať';
$string['browsed'] = 'Prechádzané';
$string['browsemode'] = 'Režim prehliadania';
$string['browserepository'] = 'Prehliadať úložisko';
$string['calculatedweight'] = 'Vypočítaná váha';
$string['calendarend'] = '{$a} - zatvára';
$string['calendarstart'] = '{$a} - otvára';
$string['cannotaccess'] = 'Nemôžete volať tento skript týmto spôsobom';
$string['cannotfindsco'] = 'Nepodarilo sa nájť SCO';
$string['chooseapacket'] = 'Vybrať alebo aktualizovať balík SCORM';
$string['closebeforeopen'] = 'Zadali ste dátum uzatvorenia pred dátumom otvorenia';
$string['collapsetocwinsize'] = 'Zbaľte obsah, ak je veľkosť okna malá';
$string['collapsetocwinsizedesc'] = 'Toto nastavenie vám umožní špecifikovať veľkosť okna dolu, pričom sa obsah automaticky zbalí, ak je veľkosť okna menšia, ako vložená hodnota.';
$string['compatibilitysettings'] = 'Nastavenia kompatibility';
$string['completed'] = 'Dokončené';
$string['completiondetail:allscos'] = 'Vykonajte všetky časti tejto aktivity';
$string['completiondetail:completionscore'] = 'Získať skóre {$a} alebo viac';
$string['completiondetail:completionstatuscompleted'] = 'Dokončiť aktivitu';
$string['completiondetail:completionstatuscompletedorpassed'] = 'Dokončiť a prejsť aktivitu';
$string['completiondetail:completionstatuspassed'] = 'Prejsť aktivitu';
$string['completionscorerequired'] = 'Požadovať minimálny počet bodov';
$string['completionscorerequired_help'] = 'Aktivovanie tohto nastavenia bude požadovať, aby používateľ mal zadaný minimálny počet bodov, aby táto SCORM aktivita mohla byť označená za dokončenú; to platí aj pre akékoľvek ostatné požiadavky na dokončenie aktivity.';
$string['completionscorerequireddesc'] = 'Pre splnenie aktivity je požadovaná minimálna známka {$a}';
$string['completionstatus_completed'] = 'Dokončený';
$string['completionstatus_passed'] = 'Absolvovaný';
$string['completionstatusallscos'] = 'Požadovať všetky "scos"  k návratu so stavom dokončenia';
$string['completionstatusallscos_help'] = 'Niektoré SCORM balíčky obsahujú viac komponentov alebo "scos" - ak je to povolené, všetky scos vnútri balíčka musia vrátiť príslušnú lesson_status pre túto aktivitu, ktoré majú byť označené ako splnené.';
$string['completionstatusrequired'] = 'Požadovať stav';
$string['completionstatusrequired_help'] = 'Voľba jedného alebo viacerých stavov bude požadovať, aby študent dosiahol minimálne jeden z označených stavov na to, aby mohla byť táto jeho SCORM aktivita označená za dokončenú; to platí aj pre akékoľvek ostatné požiadavky na dokončenie aktivity.';
$string['completionstatusrequireddesc'] = 'Študent musí dosiahnuť aspoň jeden z nasledujúcich stavov: {$a}';
$string['confirmloosetracks'] = 'Upozornenie: Balík sa zdá byť zmenený. Ak sa zmenila štruktúra balíka, je možné, že sledovanie používateľov môže byť stratené počas procesu nahrávania.';
$string['contents'] = 'Obsah';
$string['coursepacket'] = 'Balík kurzu';
$string['coursestruct'] = 'Štruktúra kurzu';
$string['crontask'] = 'Spracovanie SCORM na pozadí';
$string['currentwindow'] = 'Aktuálne okno';
$string['datadir'] = 'Chyba v systéme súborov: Nedá sa vytvoriť adresár s údajmi kurzu';
$string['defaultdisplaysettings'] = 'Nastavenia štandardného zobrazenia';
$string['defaultgradesettings'] = 'Nastavenia štandardného ohodnotenia';
$string['defaultothersettings'] = 'Ostatné štandardné nastavenia';
$string['deleteallattempts'] = 'Vymazať všetky SCORM pokusy';
$string['deleteattemptcheck'] = 'Ste si absolútne istí, že chcete kompletne odstrániť tieto pokusy?';
$string['deleteselected'] = 'Vymazať vybrané pokusy';
$string['deleteuserattemptcheck'] = 'Naozaj chcete úplne odstrániť všetky vaše pokusy?';
$string['details'] = 'Detaily prechodu';
$string['directories'] = 'Ukazovať lištu s odkazmi';
$string['disabled'] = 'Deaktivované';
$string['display'] = 'Zobraziť';
$string['displayactivityname'] = 'Zobraziť názov aktivity';
$string['displayactivityname_help'] = 'Či má byť názov aktivity zobrazený nad SCORM prehrávačom alebo nie';
$string['displayattemptstatus'] = 'Zobraziť stav pokusu';
$string['displayattemptstatus_help'] = 'Ak je povolené, skóre a hodnotenie pokusov sa zobrazia v prehľade na Nástenke a/alebo na vstupnej SCORM stránke.';
$string['displayattemptstatusdesc'] = 'Či má byť zhrnutie pokusov používateľa ukázané v bloku prehľadu kurzov na stránke Nástenka a/alebo na vstupnej stránke SCORM.';
$string['displaycoursestructure'] = 'Zobrazenie štruktúry kurzu na vstupnej stránke';
$string['displaycoursestructure_help'] = 'Ak je povolené, obsah sa zobrazí na SCORM stránke.';
$string['displaycoursestructuredesc'] = 'Ak je táto možnosť aktivovaná, obsah sa zobrazí na vstupnej stránke SCORM.';
$string['displaydesc'] = 'Či sa má zobraziť SCORM balíček v novom okne.';
$string['displaysettings'] = 'Zobraziť nastavenia';
$string['dnduploadscorm'] = 'Pridať SCORM  obsahový balík';
$string['domxml'] = 'Externá knižnica DOMXML';
$string['element'] = 'Prvok';
$string['enter'] = 'Vstúpiť';
$string['entercourse'] = 'Vstúpiť do kurzu';
$string['errorlogs'] = 'Záznamy o chybách';
$string['eventattemptdeleted'] = 'Pokus odstránený';
$string['eventinteractionsviewed'] = 'Interakcie prezerané';
$string['eventreportviewed'] = 'Správa prezeraná';
$string['eventscolaunched'] = 'SCO spustené';
$string['eventscorerawsubmitted'] = 'Odoslané prvotné skóre SCORM';
$string['eventstatussubmitted'] = 'Odoslaný stav SCORM';
$string['eventtracksviewed'] = 'Stopy prezerané';
$string['eventuserreportviewed'] = 'Štatistika používateľov prezeraná';
$string['everyday'] = 'Každý deň';
$string['everytime'] = 'Vždy pri použití';
$string['exceededmaxattempts'] = 'Dosiahli ste maximálny počet pokusov.';
$string['exit'] = 'Opustiť kurz';
$string['exitactivity'] = 'Ukončiť aktivitu';
$string['expired'] = 'Ospravedlňujeme sa, táto činnosť bola uzavretá {$a} a už nie je k dispozícii';
$string['external'] = 'Aktualizovať časovanie externých balíčkov';
$string['failed'] = 'Zlyhalo';
$string['finishscorm'] = 'Ak ste dokončili prehliadanie tohto zdroja, {$a}';
$string['finishscormlinkname'] = 'kliknite sem pre návrat do hlavnej stránky kurzu';
$string['firstaccess'] = 'Prvý prístup';
$string['firstattempt'] = 'Prvý pokus';
$string['floating'] = 'Obtekanie';
$string['forceattemptalways'] = 'Vždy';
$string['forceattemptoncomplete'] = 'Keď bol predchádzajúci pokus dokončený, splnený alebo nesplnený';
$string['forcecompleted'] = 'Vynútiť dokončenie';
$string['forcecompleted_help'] = 'Ak je táto možnosť aktivovaná, stav aktuálneho pokusu sa nútene zmení na "dokončený". (Použiteľné iba u balíkov SCORM 1.2.)';
$string['forcecompleteddesc'] = 'Táto preferencie nastaví predvolené hodnoty pre vynútenie dokončenia nastavení';
$string['forcejavascript'] = 'Vnútiť používateľom povoliť JavaScript';
$string['forcejavascript_desc'] = 'Ak je táto možnosť aktivovaná (odporúča sa), zabráni sa prístupu k SCORM objektom v prípade, že JavaScript nie je podporovaný/ povolený v prehliadači používateľov. Ak je táto možnosť deaktivovaná, používateľ si môže SCORM balík prezerať, ale API komunikácia bude neúspešná a žiadne informácie o hodnotení sa neuložia.';
$string['forcejavascriptmessage'] = 'Na prezeranie tohto objektu je požadovaný JavaScript. Prosím, povoľte JavaScript vo svojom prehliadači a skúste to znovu.';
$string['forcenewattempts'] = 'Vynútiť nový pokus';
$string['forcenewattempts_help'] = 'Sú 3 možnosti:

* Nie - Ak bol predchádzajúci pokus dokončený, úspešne alebo neúspešne, bude študentovi poskytnutá možnosť vstúpiť do režimu náhľadu alebo zahájiť nový pokus.
* Keď bol predchádzajúci pokus dokončený, úspešne alebo neúspešne - to vychádza z balíčku SCORM, ktorý nastavuje stav "dokončené", "splnil" alebo "nesplnil".
* Vždy - každý opakovaný vstup do aktivity SCORM vygeneruje nový pokus a študent nebude pokračovať na rovnakom mieste, v ktorom skončil pri svojom predchádzajúcom pokuse.';
$string['found'] = 'Manifest bol nájdený';
$string['frameheight'] = 'Táto hodnota nastaví východziu hodnotu výšky rámca alebo okna';
$string['framewidth'] = 'Táto hodnota nastaví východziu hodnotu šírky rámca alebo okna';
$string['fromleft'] = 'Zľava';
$string['fromtop'] = 'Zhora';
$string['fullscreen'] = '‌Zobraziť na celú obrazovku';
$string['general'] = 'Všeobecné údaje';
$string['gradeaverage'] = 'Priemerný počet bodov';
$string['gradeforattempt'] = 'Známka pre pokus';
$string['gradehighest'] = 'Najvyšší počet bodov';
$string['grademethod'] = 'Metóda hodnotenia';
$string['grademethod_help'] = '<p>Výsledky činnosti v rámci balíku SCORM/AICC, zahrnuté do známok kurzu
možno klasifikovať v niekoľkých módoch:</p>

<ul>
  <li><b>Vzdelávacie objekty</b><br />
  Tento režim udáva počet dokončených/úspešne ukončených učebných objektov.
  Maximálna hodnota je daná počtom učebných objektov v balíku.</li>

  <li><b>Najvyšší počet bodov</b><br />
  Pre výpočet známky sa za každý úspešne dokončený učebný objekt použije
  najvyšší dosiahnutý počet bodov.</li>

  <li><b>Priemerný počet bodov</b><br />
  Ak vyberiete tento režim, Moodle vypočíta zo všetkých získaných bodov
  ich priemer.</li>

  <li><b>Celkový počet bodov</b><br />
  V tomto režime sa všetky body sčítajú.</li>
</ul>';
$string['grademethoddesc'] = 'Metóda známkovania určuje, ako sa známkujú jednotlivé pokusy.';
$string['gradereported'] = 'Správa hodnotenia';
$string['gradescoes'] = 'Vzdelávacie objekty';
$string['gradesettings'] = 'Nastavenia hodnotenia';
$string['gradesum'] = 'Súčet bodov';
$string['height'] = 'Výška';
$string['hidden'] = 'Skryť';
$string['hidebrowse'] = 'Zakázať režim náhľadu';
$string['hidebrowse_help'] = '<p>Ak nastavíte túto voľbu, neobjaví sa tlačidlo Náhľad na stránke SCORM/AICC aktivity.</p>

<p>V normálnom móde si študent môže zvoliť, či si chce aktivitu prehliadnuť alebo vypracovať.</p>

<p>Keď je vzdelávací objekt prejdený v prehliadacom móde, je označený ikonou <img src="<?php echo $CFG->wwwroot.\'/mod/scorm/pix/browsed.gif\' ?>" alt="<?php print_string(\'browsed\',\'scorm\') ?>" title="<?php print_string(\'browsed\',\'scorm\') ?>" />.</p>';
$string['hidebrowsedesc'] = 'Režim náhľadu umožňuje študentovi prezrieť si aktivitu predtým, než sa pokúsi o jej zvládnutie.';
$string['hideexit'] = 'Skryť odkaz na opustenie';
$string['hidereview'] = 'Skryť tlačidlo prehliadnuť';
$string['hidetoc'] = 'Zobraziť navigačnú štruktúru kurzu';
$string['hidetoc_help'] = 'Toto nastavenie určuje, ako je SCORM obsah zobrazí v prehrávači';
$string['hidetocdesc'] = 'Táto predvoľba určuje, ako sa má tabuľka obsahu zobraziť v SCORM prehrávači.';
$string['highestattempt'] = 'Najlepší pokus';
$string['identifier'] = 'Identifikátor otázky';
$string['incomplete'] = 'Nedokončené';
$string['indicator:cognitivedepth'] = 'Kognitívny SCORM';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na študentom získanej kognitívnej hĺbke v aktivite SCORM.';
$string['indicator:cognitivedepthdef'] = 'Kognitívny SCORM';
$string['indicator:cognitivedepthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento kognitívnej angažovanosti ponúkanej aktivitami SCORM (Úrovne = Bez zobrazenia, Zobrazenie, Príspevok, Zobrazenie spätnej väzby)';
$string['indicator:socialbreadth'] = 'Sociálny SCORM';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založený na študentom získanej sociálnej šírke v aktivite SCORM.';
$string['indicator:socialbreadthdef'] = 'Sociálny SCORM';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento sociálnej angažovanosti ponúkanej aktivitami SCORM (Úrovne = Bez účasti, Účastník sám)';
$string['info'] = 'info';
$string['interactions'] = 'Interakcie';
$string['invalidactivity'] = 'Aktivita SCORM nie je správna';
$string['invalidhacpsession'] = 'Neplatná HACP relácia';
$string['invalidmanifestname'] = 'Môžu sa zvoliť iba súbory imsmanifest.xml alebo .zip';
$string['invalidmanifestresource'] = 'UPOZORNENIE: Vo vašom súbore manifest bolo odkazované na nasledujúce súbory, ktoré ale neboli nájdené:';
$string['invalidstatus'] = 'Neplatný stav';
$string['invalidurl'] = 'Špecifikovaná neplatná URL adresa';
$string['invalidurlhttpcheck'] = 'Špecifikovaná neplatná URL adresa. Správa ladiaceho programu:<pre>{$a->cmsg}</pre>';
$string['last'] = 'Posledný prístup dňa';
$string['lastaccess'] = 'Posledný prístup';
$string['lastattempt'] = 'Posledný pokus';
$string['lastattemptlock'] = 'Uzamknúť po poslednom pokuse';
$string['lastattemptlock_help'] = 'Ak je zapnuté, študent nemôže otvoriť SCORM balík po maximálnom počte pokusov.';
$string['lastattemptlockdesc'] = 'Ak je táto možnosť aktivovaná, študentovi sa zabráni používať SCORM prehrávač potom, čo vyčerpal všetky pridelené pokusy.';
$string['location'] = 'Ukazovať adresný riadok';
$string['masteryoverride'] = 'Celkové skóre prepíše status';
$string['masteryoverride_help'] = 'Ak je povolené a je poskytované celkové skóre, keď je volané LMSFinish a bolo nastavené hrubé skóre, stav sa prepočíta z hrubého skóre. Celkové skóre a akýkoľvek stav poskytnutý SCORMom (včítane "nesplnené") budú prepísané..';
$string['masteryoverridedesc'] = 'Táto predvoľba nastaví východziu hodnotu pre zmenu stavu podľa celkového skóre';
$string['max'] = 'Max. bod. zisk';
$string['maximumattempts'] = 'Počet pokusov';
$string['maximumattempts_help'] = '<p>Táto funkcia definuje počet pokusov povolených používateľom.
<br />Používa sa iba pre balíky štandardov SCORM1.2 a AICC.
SCORM2004 má vlastnú definíciu maximálneho počtu pokusov.</p>';
$string['maximumattemptsdesc'] = 'Táto predvoľba je pre východzie nastavenie maximálneho počtu pokusov pre aktivitu.';
$string['maximumgradedesc'] = 'Táto predvoľba je pre východzie nastavenie maximálnej známky pre aktivitu';
$string['menubar'] = 'Ukazovať lištu s hlavnou ponukou';
$string['min'] = 'Minimálne skóre';
$string['missing_attribute'] = 'Chýba atribút {$a->attr} v tagu {$a->tag}';
$string['missing_tag'] = 'Chýba tag {$a->tag}';
$string['missingparam'] = 'Požadovaný údaj chýba alebo je nesprávny';
$string['mode'] = 'Režim';
$string['modulename'] = 'SCORM balíček';
$string['modulename_help'] = 'Balík SCORM je zbierka súborov, ktoré sú zbalené podľa dohodnutého štandardu pre vzdelávacie objekty. Modul aktivity SCORM umožňuje, aby boli balíky SCORM alebo AICC nahrávané ako ZIP súbory a pridávané do kurzu.

Obsah je zvyčajne zobrazený na niekoľkých stránkach, s navigáciou medzi nimi. Sú rôzne možnosti zobrazovania obsahu vo vyskakovacom okne, s tabuľkou obsahu, s navigačnými tlačidlami, atď. SCORM aktivity obyčajne obsahujú úlohy, s hodnoteniami zaznamenávanými v hodnotiacom zázname.

SCORM aktivity môžu byť použité:

* na prezentáciu multimediálneho obsahu a animácií
* ako nástroj hodnotenia';
$string['modulenameplural'] = 'SCORM balíčky';
$string['myaiccsessions'] = 'Moje relácie AICC';
$string['myattempts'] = 'Moje pokusy';
$string['nav'] = 'Zobraziť navigáciu';
$string['nav_help'] = 'Toto nastavenie určuje, či chcete zobraziť alebo skryť tlačidlá navigácie a ich umiestnenie.

Sú tri možnosti:
* Nie - tlačidlá navigácie nie sú zobrazené
* Za obsahom - tlačidlá navigácie sú zobrazené pod obsahom SCORM balíka
* Plávajúce - tlačidlá navigácie sú plávajúce, s polohou zhora a zľava určenou zobrazením balíka.';
$string['navdesc'] = 'Toto nastavenie určuje, či chcete zobraziť alebo skryť tlačidlá navigácie a ich umiestnenie.';
$string['navigation'] = 'Navigácia';
$string['navpositionleft'] = 'Poloha navigačných tlačidiel zľava v pixeloch.';
$string['navpositiontop'] = 'Poloha navigačných tlačidiel zhora v pixeloch.';
$string['networkdropped'] = 'Prehrávač SCORM zistil, že vaše internetové spojenie je nespoľahlivé alebo bolo prerušené. Ak budete pokračovať v tejto SCORM aktivite, váš postup sa nemusí uložiť. <br /> Mali by ste teraz odísť z aktivity a vrátiť sa vtedy, keď budete mať spoľahlivé internetové spojenie.';
$string['newattempt'] = 'Začať nový pokus';
$string['next'] = 'Pokračovať';
$string['no_attributes'] = 'Tag {$a->tag} musí mať atribúty';
$string['no_children'] = 'Tag {$a->tag} musí mať potomkov';
$string['noactivity'] = 'Nič k zobrazeniu';
$string['noattemptsallowed'] = 'Počet povolených pokusov';
$string['noattemptsmade'] = 'Počet pokusov, ktoré ste vykonali';
$string['nolimit'] = 'Neobmedzený počet pokusov';
$string['nomanifest'] = 'Chybný balíček súborov - chýba imsmanifest.xml alebo AICC štruktúra';
$string['noprerequisites'] = 'Žiaľ, zatiaľ nespĺňate požadované predpoklady pre prístup k tejto aktivite.';
$string['noreports'] = 'Žiadna správa na zobrazenie';
$string['normal'] = 'Normálny';
$string['noscriptnoscorm'] = 'Váš prehliadač nepodporuje javascript, alebo bola podpora javascriptu vo vašom prehliadači zakázaná. Tento SCORM balík nemusí správne prehrávať alebo ukladať informácie.';
$string['not_corr_type'] = 'Nesúlad typov v tagu {$a->tag}';
$string['notattempted'] = 'Bez pokusov';
$string['notopenyet'] = 'Prepáčte, táto aktivita nie je dostupná do {$a}';
$string['objectives'] = 'Ciele';
$string['openafterclose'] = 'Zadali ste dátum otvorenia po dátume uzavretia';
$string['optallstudents'] = 'Všetci užívatelia';
$string['optattemptsonly'] = 'Používatelia len s možnosťou pokusov';
$string['options'] = 'Voľby (v niektorých prehliadačoch nepodporované)';
$string['optionsadv'] = 'Voľby (Pokročilé)';
$string['optionsadv_desc'] = 'Ak je zaškrtnuté, šírka a výška budú považované za pokročilé nastavenia.';
$string['optnoattemptsonly'] = 'Používatelia len bez možnosti pokusov';
$string['organization'] = 'Organizácia';
$string['organizations'] = 'Organizácie';
$string['othersettings'] = 'Ďalšie nastavenia';
$string['package'] = 'Súbor s balíkom';
$string['package_help'] = '<p>Balík SCORM/AICC je súbor s príponou <b>zip</b> (alebo pif), ktorý obsahuje
platné súbory AICC alebo SCORM.</p>

<p>Balík <b>SCORM</b> musí v hlavnom adresári zip súboru obsahovať súbor s
názvom <b>imsmanifest.xml</b>, ktorý definuje štruktúru kurzu SCORM, umiestnenie
študijných materiálov a mnoho ďalších vlastností.</p>

<p>Balík <b>AICC</b> je definovaný viacerými súbormi (štyrmi až siedmimi) s určenými
príponami. Význam jednotlivých prípon:</p>

<ul>
  <li>CRS &ndash; Course Description file (Súbor opisu kurzu &ndash; povinný)</li>

  <li>AU &ndash; Assignable Unit file (Súbor s opisom jednotiek kurzu &ndash;
  povinný)</li>

  <li>DES &ndash; Descriptor file (Súbor s opisom blokov kurzu &ndash; povinný)</li>

  <li>CST &ndash; Course Structure file (Súbor so štruktúrovanými údajmi kurzu &ndash;
  povinný)</li>

  <li>ORE &ndash; Objective Relationship file (Súbor s opisom cieľov jednotiek a blokov
  &ndash; voliteľný)</li>

  <li>PRE &ndash; Prerequisites file (Súbor s opisom predpokladov &ndash; voliteľný)</li>

  <li>CMP &ndash; Completition Requirements file (Súbor podmienok ukončenia kurzu &ndash;
  voliteľný)</li>
</ul>';
$string['packagedir'] = 'Chyba v systéme súborov: Nedá sa vytvoriť adresár s balíčku';
$string['packagefile'] = 'Nebol určený súbor s balíkom SCORM/AICC.';
$string['packagehdr'] = 'Balík';
$string['packageurl'] = 'URL adresa';
$string['packageurl_help'] = 'Toto nastavenie umožňuje, aby bola špecifikovaná URL adresa pre SCORM balík, skôr než výber balíka cez vyberač súborov.';
$string['page-mod-scorm-x'] = 'Akákoľvek stránka modulu SCORM';
$string['pagesize'] = 'Veľkosť stránky';
$string['passed'] = 'Splnený';
$string['php5'] = 'PHP 5 (DOMXML natívna knižnica)';
$string['pluginadministration'] = 'Správa balíčka SCORM';
$string['pluginname'] = 'SCORM balík';
$string['popup'] = 'Nové okno';
$string['popuplaunched'] = 'Tento SCORM balík bol spustený vo vyskakovacom okne. Ak ste dokončili prezeranie tohto zdroja, kliknite sem, aby ste sa vrátili na stránku kurzu';
$string['popupmenu'] = 'V rozbaľovacej ponuke';
$string['popupopen'] = 'Otvoriť balík v novom okne';
$string['popupsblocked'] = 'Vyzerá to tak, že vyskakovacie okná sú vo vašom prehliadači zakázané - je zastavené prehrávanie SCORM modulu. Skontrolujte nastavenia prehliadača predtým, ako sa pokúsite  znova.';
$string['position_error'] = 'Tag {$a->tag} nemôže byť potomkom tagu {$a->parent}';
$string['preferencespage'] = 'Preferencie len pre túto stránku';
$string['preferencesuser'] = 'Preferencie pre túto správu';
$string['prev'] = 'Predchádzajúci';
$string['privacy:metadata:aicc:data'] = 'Osobné údaje prešli z podsystému AICC/SCORM.';
$string['privacy:metadata:aicc:externalpurpose'] = 'Tento modul odosiela údaje externe pomocou AICC HACP.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'Stav lekcie, ktorú chcete sledovať';
$string['privacy:metadata:aicc_session:scormmode'] = 'Režim sledovaného prvku';
$string['privacy:metadata:aicc_session:scormstatus'] = 'Stav sledovaného prvku';
$string['privacy:metadata:aicc_session:sessiontime'] = 'Čas sedenia, ktorý chcete sledovať';
$string['privacy:metadata:aicc_session:timecreated'] = 'Čas, kedy bol vytvorený sledovaný prvok';
$string['privacy:metadata:attempt'] = 'Číslo pokusu';
$string['privacy:metadata:scoes_track:element'] = 'Názov sledovaného prvku';
$string['privacy:metadata:scoes_track:value'] = 'Hodnota daného prvku';
$string['privacy:metadata:scorm_aicc_session'] = 'Informácia o sedení HACP AICC';
$string['privacy:metadata:scorm_scoes_track'] = 'Sledované údaje SCO patriace do aktivity';
$string['privacy:metadata:timemodified'] = 'Čas, kedy bol sledovaný prvok naposledy zmenený';
$string['privacy:metadata:userid'] = 'ID používateľa, ktorý pristupuje k aktivite SCORM';
$string['protectpackagedownloads'] = 'Zamedziť sťahovanie balíčkov';
$string['protectpackagedownloads_desc'] = 'Ak je povolené, SCORM balíčky môžu byť stiahnuté iba v prípade, že používateľ má oprávnenie course:manageactivities. Ak je zakázané, SCORM balíčky je možné vždy stiahnuť (prostredníctvom mobilu alebo iným spôsobom).';
$string['raw'] = 'Hrubé skóre';
$string['regular'] = 'Správny manifest';
$string['report'] = 'Správa';
$string['reportcountallattempts'] = '{$a->nbattempts} pokusov pre {$a->nbusers} užívateľov, zo {$a->nbresults} výsledkov';
$string['reportcountattempts'] = '{$a->nbresults} výsledkov ({$a->nbusers} užívateľov)';
$string['reports'] = 'Štatistiky';
$string['repositorynotsupported'] = 'Podporované sú iba také úložiská súborových systémov, ktoré odkazujú priamo na súbor imsmanifest.xml';
$string['response'] = 'Odpoveď';
$string['result'] = 'Výsledok';
$string['results'] = 'Výsledky';
$string['review'] = 'Opakovaný náhľad';
$string['reviewmode'] = 'Režim opakovaného náhľadu';
$string['rightanswer'] = 'Správna odpoveď';
$string['scoes'] = 'Vzdelávacie objekty';
$string['score'] = 'Skóre';
$string['scorm:addinstance'] = 'Pridať nový SCORM obsahový balík';
$string['scorm:deleteownresponses'] = 'Odstrániť vlastné pokusy';
$string['scorm:deleteresponses'] = 'Vymazať pokusy SCORM';
$string['scorm:savetrack'] = 'Uložiť postup činnosti';
$string['scorm:skipview'] = 'Preskočiť prehľad';
$string['scorm:viewreport'] = 'Prezerať výsledky';
$string['scorm:viewscores'] = 'Prezerať hodnotenie';
$string['scormclose'] = 'Dostupné do';
$string['scormcourse'] = 'Kurz SCORM';
$string['scormloggingoff'] = 'Logovacie API je vypnuté';
$string['scormloggingon'] = 'Logovacie API je zapnuté';
$string['scormopen'] = 'Otvorené od';
$string['scormresponsedeleted'] = 'Vymazané používateľské pokusy';
$string['scormstandard'] = 'Režim SCORM štandardov';
$string['scormstandarddesc'] = 'Ak nie je povolené, umožňuje Moodle balíčkom SCORM 1.2 ukladať viac, než to dovoľuje špecifikácia, a pri predávaní používateľského mena do balíčku SCORM používa nastavenie formátu celého mena v Moodle.';
$string['scormtype'] = 'Typ';
$string['scormtype_help'] = 'Toto nastavenie určuje, ako sa balík začlení do kurzu. Sú maximálne 4 možnosti:

* Nahratý balík - Umožňuje, aby sa SCORM balík zvolil cez vyberač súborov.
* Externý SCORM manifest - umožňuje určenie URL adresy smerujúcej k súboru imsmanifest.xml. Poznámka: Ak má URL adresa inú doménu ako váš portál, potom je lepšia možnosť "Stiahnuť balík", v opačnom prípade sa hodnotenia neuložia.
* Stiahnutý balík - umožňuje určenie URL adresy. Balík bude rozbalený a uložený lokálne, prípadne aktualizovaný v prípade, že je aktualizovaný externý SCORM balík.
* Externá AICC URL adresa - táto URL adresa je spúšťacia URL adresa pre jednu  AICC aktivitu. Okolo nej sa vytvorí "pseudo" balík.';
$string['scrollbars'] = 'Povoliť zvislý posuvník';
$string['search:activity'] = 'SCORM balíček - informácia';
$string['selectall'] = 'Vybrať všetko';
$string['selectnone'] = 'Zrušiť výber všetkých';
$string['show'] = 'Zobraziť';
$string['sided'] = 'Na strane';
$string['skipview'] = 'Študenti preskočia stránku s obsahom';
$string['skipview_help'] = '<p>Ak sa jedná o balík s jediným vzdelávacím objektom, môžete zvoliť preskočenie stránky s obsahom v prípade, keď účastníci kliknú na SCORM aktivitu v hlavnej stránke kurzu.</p>

<p>Môžete si zvoliť:</p>

   <ul>
       <li><strong>Nikdy</strong> nepreskočiť úvodnú stránku</li>
       <li><strong>Prvý prístup</strong> preskočiť úvodnú stránku iba prvý raz</li>
       <li><strong>Vždy</strong> preskočiť úvodnú stránku</li>
   </ul>';
$string['skipviewdesc'] = 'Táto predvoľba je pre východzie nastavenie času, kedy treba preskočiť obsah stránky';
$string['slashargs'] = 'UPOZORNENIE: slash (lomítkové) argumenty nie sú na tomto portáli povolené a objekty nemusia fungovať tak, ako očakávate.';
$string['stagesize'] = 'Veľkosť okna/rámca';
$string['stagesize_help'] = '<p>Tieto dve nastavenia definujú výšku a šírku okna/rámca vzdelávacieho objektu.</p>';
$string['started'] = 'Začaté dňa';
$string['status'] = 'Stav';
$string['statusbar'] = 'Ukazovať stavový riadok';
$string['student_response'] = 'Odpoveď';
$string['subplugintype_scormreport'] = 'Štatistika';
$string['subplugintype_scormreport_plural'] = 'Štatistiky';
$string['suspended'] = 'Pozastavené';
$string['syntax'] = 'Chyba v syntaxi';
$string['tag_error'] = 'Neznámy tag ({$a->tag}) v tomto obsahu: {$a->value}';
$string['time'] = 'Čas';
$string['title'] = 'Názov';
$string['toc'] = 'TOC';
$string['too_many_attributes'] = 'Tag {$a->tag} má príliš mnoho atribútov';
$string['too_many_children'] = 'Tag {$a->tag} má príliš mnoho potomkov';
$string['toolbar'] = 'Ukazovať lištu s ovládacími tlačidlami';
$string['totaltime'] = 'Čas';
$string['trackcorrectcount'] = 'Opraviť súčet';
$string['trackcorrectcount_help'] = 'Počet správnych odpovedí na túto otázku';
$string['trackid'] = 'ID';
$string['trackid_help'] = 'Toto je identifikátor nastavený vaším SCORM balíkom pre túto úlohu, špecifikácia SCORM nepovoľuje poskytnutie plného textu otázky.';
$string['trackingloose'] = 'UPOZORNENIE: Údaje o priechode týmto SCORM balíkom budú stratené!';
$string['tracklatency'] = 'Oneskorenie';
$string['tracklatency_help'] = 'Čas, ktorý uplynie od času, keď je úloha sprístupnená študujúcemu na odpoveď, do času prvej odpovede.';
$string['trackpattern'] = 'Vzor';
$string['trackpattern_help'] = 'Takáto by mala byť správna odpoveď na túto otázku. Nezobrazuje odpoveď študujúcich.';
$string['trackresponse'] = 'Odpoveď';
$string['trackresponse_help'] = 'Toto je odpoveď, ktorú dal študujúci na túto otázku';
$string['trackresult'] = 'Výsledok';
$string['trackresult_help'] = 'Zobrazuje se študentovi pri správnej odpovedi.';
$string['trackscoremax'] = 'Maximálny počet bodov';
$string['trackscoremax_help'] = 'Maximálna hodnota, ktorú je možné priradiť za hrubé skóre';
$string['trackscoremin'] = 'Minimálny počet bodov';
$string['trackscoremin_help'] = 'Minimálna hodnota, ktorú je možné priradiť za hrubé skóre';
$string['trackscoreraw'] = 'Hrubé skóre';
$string['trackscoreraw_help'] = 'Hodnota, ktorá odráža výkon študujúceho vzhľadom k rozsahu vymedzenému minimálnou a maximálnou hodnotou';
$string['tracksuspenddata'] = 'Pozastaviť dáta';
$string['tracksuspenddata_help'] = 'Poskytuje priestor na ukladanie a opätovné načítanie dát medzi reláciami študujúcich';
$string['tracktime'] = 'Čas';
$string['tracktime_help'] = 'Čas, kedy pokus začal';
$string['tracktype'] = 'Typ';
$string['tracktype_help'] = 'Typ otázky, napr. "voľba" alebo "krátka odpoveď"';
$string['trackweight'] = 'Váha';
$string['trackweight_help'] = 'Váha priradená k otázke pri výpočte skóre.';
$string['type'] = 'Typ';
$string['typeaiccurl'] = 'Externá AICC URL adresa';
$string['typeexternal'] = 'Externý SCORM manifest';
$string['typelocal'] = 'Vložený balíček';
$string['typelocalsync'] = 'Stiahnutý balíček';
$string['undercontent'] = 'Za obsah';
$string['unziperror'] = 'Počas rozbaľovania balíka sa vyskytla chyba';
$string['updatefreq'] = 'Frekvencia auto-obnovovania';
$string['updatefreq_error'] = 'Frekvenciu automatickej aktualizácie je možné nastaviť iba vtedy, ak je súbor s balíkom hostovaný externe.';
$string['updatefreq_help'] = 'Toto umožní, aby sa externý balík automaticky stiahol a aktualizoval';
$string['updatefreqdesc'] = 'Táto predvoľba je pre východzie nastavenie automatickej aktualizácie aktivity';
$string['validateascorm'] = 'Overiť SCORM balík';
$string['validation'] = 'Výsledok overovania';
$string['validationtype'] = 'Táto vlastnosť nastavuje knižnicu DOMXML, ktorá bude použitá pri overovaní manifestu SCORM. Ak neviete, čo zvoliť, nechajte tu vybratú voľbu.';
$string['value'] = 'Hodnota';
$string['versionwarning'] = 'Verzia manifestu je staršia ako 1.3, upozornenie na tagu {$a->tag}';
$string['viewallreports'] = 'Zobraziť správy pre {$a} pokusov';
$string['viewalluserreports'] = 'Prezerať správy pre {$a} používateľov';
$string['whatgrade'] = 'Známkovanie pokusov';
$string['whatgrade_help'] = '<p>Ak povolíte účastníkom viacero pokusov, môžete si vybrať, ako sa použijú ich výsledky v hodnotení.</p>';
$string['whatgradedesc'] = 'Ak je povolené viac pokusov, ktorá hodnota bude zapísaná do známkového výkazu; buď najvyššia, priemer, prvý alebo posledný dokončený pokus.';
$string['width'] = 'Šírka';
$string['window'] = 'Okno';
$string['youmustselectastatus'] = 'Musíte vybrať požadovaný stav';
