<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'sk', version '4.0'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Akceptovať';
$string['accept_grades'] = 'Akceptovať známky z nástroja';
$string['accept_grades_admin'] = 'Akceptovať známky z nástroja';
$string['accept_grades_admin_help'] = 'Špecifikujte, či poskytovateľ nástroja môže pridávať, aktualizovať, čítať a odstraňovať hodnotenia spojené s inštanciami tohto typu nástroja.


Niektorí poskytovatelia nástrojov podporujú spätné hlásenie hodnotení Moodle založené na akciách vykonaných v rámci nástroja, čím sa javí ešte lepšie integrovaný.';
$string['accept_grades_help'] = 'Určte, či poskytovateľ nástroja môže pridávať, aktualizovať, čítať a odstraňovať hodnotenia spojené iba s inštanciou tohto externého nástroja.

Niektorí poskytovatelia nástrojov podporujú spätné hlásenie hodnotení Moodle založené na akciách vykonaných v rámci nástroja, čím sa javí ešte lepšie integrovaný.

Poznámka: Toto nastavenie je možné v konfigurácii nástroja ignorovať.';
$string['accepted'] = 'Akceptované';
$string['action'] = 'Akcia';
$string['activate'] = 'Aktivovať';
$string['activatetoadddescription'] = 'Pred pridaním opisu budete musieť tento nástroj aktivovať.';
$string['active'] = 'Aktívny';
$string['activity'] = 'Aktivita';
$string['add_ltiadv'] = 'Pridať LTI Advantage';
$string['add_ltilegacy'] = 'Pridať Legacy LTI';
$string['addnewapp'] = 'Povoliť externú aplikáciu';
$string['addserver'] = 'Pridať nový dôveryhodný server';
$string['addtype'] = 'Pridať predkonfigurovaný nástroj';
$string['allow'] = 'Povoliť';
$string['allowsetting'] = 'Povoliť nástroju ukladať 8K nastavení v Moodle';
$string['always'] = 'Vždy';
$string['autoaddtype'] = 'Pridať nástroj';
$string['automatic'] = 'Automaticky, na základe spustenia URL';
$string['baseurl'] = 'Základná adresa URL/registračný názov nástroja';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'Základný reťazec LTI OAuth';
$string['basiclti_endpoint'] = 'Koncový bod spustenia LTI';
$string['basiclti_in_new_window'] = 'Vaša aktivita bola otvorená v novom okne';
$string['basiclti_in_new_window_open'] = 'Otvoriť v novom okne';
$string['basiclti_parameters'] = 'Parametre spustenia LTI';
$string['basicltiactivities'] = 'LTI Aktivity';
$string['basicltifieldset'] = 'Príklad vlastného nastavenia poľa';
$string['basicltiintro'] = 'Opis aktivity';
$string['basicltiname'] = 'Názov aktivity';
$string['basicltisettings'] = 'Základné nastavenia LTI (Learning Tool Interoperability)';
$string['cachedef_keyset'] = 'Ukladá informácie o súprave kľúčov nástrojov do vyrovnávacej pamäte';
$string['cancel'] = 'Zrušiť';
$string['cancelled'] = 'Zrušené';
$string['cannot_delete'] = 'Nemôžete zrušiť konfiguráciu tohto nástroja.';
$string['cannot_edit'] = 'Nemôžete upraviť konfiguráciu tohto nástroja.';
$string['capabilities'] = 'Schopnosti';
$string['capabilities_help'] = 'Zvoľte tie schopnosti, ktoré si želáte ponúknuť poskytovateľovi nástroja. Je možné zvoliť viac ako jednu schopnosť.';
$string['capabilitiesrequired'] = 'Tento nástroj vyžaduje na aktiváciu prístup k nasledujúcim údajom:';
$string['cleanaccesstokens'] = 'Externý nástroj na odstránenie prístupových tokenov, ktorých platnosť vypršala';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Pokračujte kliknutím</a>';
$string['clientidadmin'] = 'Klientske ID';
$string['clientidadmin_help'] = 'Klientske ID je jedinečná hodnota používaná na identifikáciu nástroja. Vytvára sa automaticky pre každý nástroj, ktorý používa bezpečnostný profil JWT zavedený v LTI 1.3 a mal by byť súčasťou podrobností odovzdaných poskytovateľovi nástroja, aby mohol na svojom konci nakonfigurovať pripojenie.';
$string['comment'] = 'Poznámka';
$string['configpassword'] = 'Východzie heslo vzdialeného nástroja';
$string['configpreferheight'] = 'Východzia preferovaná výška';
$string['configpreferwidget'] = 'Nastaviť widget ako štandardné spúšťanie';
$string['configpreferwidth'] = 'Východzia preferovaná šírka';
$string['configresourceurl'] = 'Východzie URL zdroja';
$string['configtoolurl'] = 'Východzie URL vzdialeného nástroja';
$string['configtypes'] = 'Povoliť aplikácie LTI';
$string['configured'] = 'Konfigurované';
$string['confirmtoolactivation'] = 'Naozaj chcete aktivovať tento nástroj?';
$string['contentitem_deeplinking_help'] = 'Ak je začiarknuté, pri pridávaní externého nástroja bude k dispozícii možnosť „Vybrať obsah“.';
$string['contentitem_help'] = 'Ak je začiarknuté, pri pridávaní externého nástroja bude k dispozícii možnosť „Vybrať obsah“.';
$string['contentitem_multiple_description'] = 'Do vášho kurzu budú pridané nasledujúce položky:';
$string['contentitem_multiple_graded'] = 'Hodnotená aktivita (maximálna známka: {$a})';
$string['course_tool_types'] = 'Nástroje kurzu';
$string['courseactivitiesorresources'] = 'Aktivity alebo zdroje kurzu';
$string['courseid'] = 'ID číslo kurzu';
$string['courseinformation'] = 'Informácie o kurze';
$string['courselink'] = 'Ísť na kurz';
$string['coursemisconf'] = 'Kurz je nesprávne nakonfigurovaný';
$string['createdon'] = 'Vytvorené dňa';
$string['curllibrarymissing'] = 'Pre použitie LTI sa musí nainštalovať knižnica PHP Curl';
$string['custom'] = 'Používateľské parametre';
$string['custom_config'] = 'Použiť vlastný nástroj konfigurácie.';
$string['custom_help'] = 'Používateľské parametre sú nastavenia, používané poskytovateľom nástroja. Napríklad, používateľský parameter sa môže použiť na zobrazenie špecifického zdroja od poskytovateľa.

Je bezpečné nechať toto pole nezmenené, ak to nie je nariadené poskytovateľom nástroja.';
$string['custominstr'] = 'Používateľské parametre';
$string['debuglaunch'] = 'Voľby ladenia';
$string['debuglaunchoff'] = 'Normálne spustenie';
$string['debuglaunchon'] = 'Spustenie v ladiacom režime';
$string['default'] = 'Východzie';
$string['default_launch_container'] = 'Kontajner východzieho spustenia';
$string['default_launch_container_help'] = 'Kontajner spustenia ovplyvňuje zobrazenie nástroja pri spúšťaní z kurzu. Niektoré kontajnery spustenia vytvárajú plochu v zobrazení kurzu, iné sa integrujú do prostredia Moodle.

* **Štandardný** - Použije kontajner spustenia špecifikovaný konfiguráciou nástroja.
* **Vložený** - Nástroj sa zobrazí v rámci existujúceho okna Moodle , spôsobom podobným väčšine ostatných typov aktivít.
* **Vložený, bez blokov** - Nástroj sa zobrazí v rámci existujúceho okna Moodle ,  iba s ovládačmi navigácie v hornej časti stránky.
* **Nové okno** - Nástroj sa otvorí v novom okne, zaberajúc celý dostupný priestor.

   V závislosti od prehliadača ho otvorí v novej tabuľke alebo vyskakovacom okne.
   Je možné, že prehliadače zabránia otvoreniu nového okna.';
$string['delegate'] = 'Delegovať na učiteľa';
$string['delegate_tool'] = 'Ako je uvedené v Definícii priameho prepojenia alebo Delegovanie na učiteľa';
$string['delete'] = 'Odstrániť';
$string['delete_confirmation'] = 'Naozaj chcete odstrániť tento vopred nakonfigurovaný nástroj?';
$string['deletetype'] = 'Odstrániť vopred nakonfigurovaný nástroj';
$string['display_description'] = 'Pri spustení zobraziť opis aktivity';
$string['display_description_help'] = 'Ak je táto možnosť zvolená, opis aktivity (špecifikovaný vyššie) sa zobrazí nad obsahom nástroja.

Opis je možné využiť na poskytnutie dodatočných inštrukcií pre používateľa spúšťajúceho nástroj, ale nie je povinný.

Opis sa nikdy nezobrazí, ak je kontajner spúšťania nástroja otvorený v novom okne.';
$string['display_name'] = 'Pri spustení zobraziť opis aktivity';
$string['display_name_help'] = 'Ak je táto možnosť zvolená, názov aktivity (špecifikovaný vyššie) sa zobrazí nad obsahom nástroja.

Je možné, že poskytovateľ nástroja zobrazí jeho názov tiež. Táto možnosť zabráni tomu, aby sa názov zobrazil dvakrát.

Názov sa nikdy nezobrazí, ak je kontajner spúšťania nástroja otvorený v novom okne.';
$string['domain_mismatch'] = 'Doména URL spúšťania nevyhovuje konfigurácii nástroja.';
$string['donot'] = 'Neodoslať';
$string['donotaccept'] = 'Neprijať';
$string['donotallow'] = 'Nepovoliť';
$string['duplicateregurl'] = 'Táto URL adresa registrácie sa už používa';
$string['dynreg_update_btn_new'] = 'Odstrániť vopred nakonfigurovaný nástroj';
$string['dynreg_update_btn_update'] = 'Aktualizovať';
$string['dynreg_update_name'] = 'Názov nástroja';
$string['dynreg_update_notools'] = 'V tomto kontexte neexistuje žiaden nástroj.';
$string['dynreg_update_text'] = 'K doméne registrácie sú pripojené existujúce nástroje. Chcete aktualizovať už nainštalovaný
externý nástroj alebo vytvoriť nový externý nástroj?';
$string['dynreg_update_url'] = 'Základné URL';
$string['dynreg_update_version'] = 'LTI verzia';
$string['dynreg_update_warn_dupdomain'] = 'Neodporúča sa mať viacero externých nástrojov pod jednou doménou.';
$string['editdescription'] = 'Kliknutím sem zadajte opis tohto nástroja';
$string['edittype'] = 'Upravte vopred nakonfigurovaný nástroj';
$string['embed'] = 'Vložený';
$string['embed_no_blocks'] = 'Vložený bez blokov';
$string['enableemailnotification'] = 'Odoslať potvrdzujúce emaily';
$string['enableemailnotification_help'] = 'Ak je táto možnosť aktivovaná, študenti dostanú e-mailovú notifikáciu vtedy, keď sú ich práce odoslané prostredníctvom nástroja ohodnotené.';
$string['enterkeyandsecret'] = 'Zadajte svoj zákaznícky kľúč a zdieľaný tajný kľúč';
$string['enterkeyandsecret_help'] = 'Ak ste dostali zákaznícky kľúč a/alebo zdieľané tajomstvo, zadajte ich sem';
$string['errorbadurl'] = 'Adresa URL nie je platná adresa URL nástroja alebo objektu.';
$string['errorincorrectconsumerkey'] = 'Zákaznícky kľúč je neplatný';
$string['errorinvaliddata'] = 'Neplatné údaje: {$a}';
$string['errorinvalidmediatype'] = 'Neplatný typ média: {$a}';
$string['errormisconfig'] = 'Nástroj je zle nakonfigurovaný. Prosím, požiadajte vášho Moodle administrátora, aby opravil konfiguráciu nástroja.';
$string['errortooltypenotfound'] = 'Typ nástroja LTI sa nenašiel.';
$string['existing_window'] = 'Existujúce okno';
$string['extensions'] = 'Externé služby LTI';
$string['external_tool_type'] = 'Vopred nakonfigurovaný nástroj';
$string['external_tool_type_help'] = '* **Automaticky, na základe adresy URL nástroja** - Automaticky sa vyberie najlepšia konfigurácia nástroja. Ak adresa URL nástroja nie je rozpoznaná, možno bude potrebné zadať podrobnosti o konfigurácii nástroja manuálne.
* **Špecifický predkonfigurovaný nástroj** – Konfigurácia nástroja pre zadaný nástroj sa použije pri komunikácii s externým poskytovateľom nástroja. Ak adresa URL nástroja zrejme nepatrí poskytovateľovi nástroja, zobrazí sa varovanie. Nie vždy je potrebné zadávať adresu URL nástroja.
* **Vlastná konfigurácia** – Spotrebiteľský kľúč a zdieľaný tajný kľúč možno bude potrebné zadať manuálne. Zákaznícky kľúč a zdieľaný tajný kľúč možno získať od poskytovateľa nástroja. Nie všetky nástroje však vyžadujú zákaznícky kľúč a zdieľané heslo, v takom prípade môžu byť polia ponechané prázdne.

### Vopred nakonfigurované úpravy nástroja

Po rozbaľovacej ponuke vopred nakonfigurovaného nástroja sú k dispozícii tri ikony:

* **Pridať** – Vytvorte konfiguráciu nástroja na úrovni kurzu. Všetky inštancie externého nástroja v tomto kurze môžu používať konfiguráciu nástroja.
* **Upraviť** – Z rozbaľovacej ponuky vyberte nástroj na úrovni kurzu a kliknite na túto ikonu. Podrobnosti o konfigurácii nástroja je možné upraviť.
* **Odstrániť** – Odstráňte vybratý nástroj na úrovni kurzu.';
$string['external_tool_types'] = 'Predkonfigurované nástroje';
$string['failedtoconnect'] = 'Moodle nemôže komunikovať so systémom  "{$a}"';
$string['failedtocreatetooltype'] = 'Nepodarilo sa vytvoriť nový nástroj. Skontrolujte adresu URL a skúste to znova.';
$string['failedtodeletetoolproxy'] = 'Nepodarilo sa odstrániť registráciu nástroja. Možno budete musieť navštíviť stránku „Spravovať registrácie externých nástrojov“ a odstrániť ju manuálne.';
$string['filter_basiclti_configlink'] = 'Nakonfigurujte svoje obľúbené weby a ch heslá';
$string['filter_basiclti_password'] = 'Heslo je povinné';
$string['filterconfig'] = 'Správa LTI';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Pre nesprávne nastavenú konfiguráciu použite tú, ktorá existuje';
$string['fixnew'] = 'Nová konfigurácia';
$string['fixnewconf'] = 'Pre nesprávne nastavenú konfiguráciu definujte novú';
$string['fixold'] = 'Použite existujúcu';
$string['force_ssl'] = 'Vnútiť SSL';
$string['force_ssl_help'] = 'Voľba tejto možnosti donúti použiť SSL pre všetky spustenia smerom k poskytovateľovi tohto nástroja.

Okrem toho aj všetky požiadavky webovej služby od poskytovateľa nástroja budú používať SSL.

Ak používate túto možnosť, potvrďte, že tento Moodle portál a poskytovateľ nástroja podporujú SSL.';
$string['forced_help'] = 'Toto nastavenie bolo vynútené v konfigurácii úrovne kurzu alebo portálu. Z tohto rozhrania ho nemôžete zmeniť.';
$string['generaltool'] = 'Všeobecný nástroj';
$string['global_tool_types'] = 'Predkonfigurované nástroje';
$string['grading'] = 'Smerovanie hodnotenia';
$string['icon_url'] = 'Ikona URL';
$string['icon_url_help'] = 'URL adresa ikony umožňuje, aby sa dala ikona, ktorá sa zobrazuje vo výpise kurzov pre túto aktivitu, upravovať. Namiesto použitia štandardnej ikony LTI je možné špecifikovať ikonu, ktorá vyjadruje typ aktivity.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'Kognitívne LTI';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na študentom získanej kognitívnej hĺbke v aktivite LTI.';
$string['indicator:cognitivedepthdef'] = 'kognitívne LTI';
$string['indicator:cognitivedepthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento kognitívnej angažovanosti ponúkanej  aktivitami LTI (Úrovne = Bez zobrazenia, Zobrazenie, Príspevok, Zobrazenie spätnej väzby)';
$string['indicator:socialbreadth'] = 'sociálne LTI';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založený na študentom získanej sociálnej šírke v aktivite LTI.';
$string['indicator:socialbreadthdef'] = 'sociálne LTI';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento sociálnej angažovanosti ponúkanej aktivitami LTI (Úrovne = Bez účasti, Účastník sám, Účastník s ostatnými)';
$string['initiatelogin'] = 'Spustiť prihlasovaciu adresu URL';
$string['initiatelogin_help'] = 'URL nástroja, na ktorý sa majú posielať požiadavky na spustenie prihlásenia. Táto adresa URL sa vyžaduje pred úspešným odoslaním správy do nástroja.';
$string['invalidid'] = 'LTI ID bolo nesprávne';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Typ verejného kľúča';
$string['keytype_help'] = 'Spôsob overenia použitý na overenie nástroja.';
$string['keytype_rsa'] = 'RSA kľúč';
$string['launch_in_moodle'] = 'Spustiť nástroj v Moodle';
$string['launch_in_popup'] = 'Spustiť nástroj vo vyskakovacom okne';
$string['launch_url'] = 'URL spustenia';
$string['launch_url_help'] = 'Spúšťacia URL označuje webovú adresu externého nástroja a môže obsahovať dodatočné informácie na zobrazenie (napr. zdroj).
Ak si nie ste istý, čo zadať ako URL adresu, požiadajte poskytovateľa nástroja o viac informácií.

Ak ste zvolili špecifický typ nástroja, možno nebude potrebovať zadať spúšťaciu URL adresu. Príkladom takéhoto použitia je, ak sa odkaz na nástroj používa iba na spustenie systému poskytovateľa nástroja a nie na spojenie so špecifickým zdrojom.';
$string['launchinpopup'] = 'Spustiť kontajner';
$string['launchinpopup_help'] = 'Kontajner spustenia ovplyvňuje zobrazenie nástroja pri spúšťaní z kurzu. Niektoré kontajnery spustenia vytvárajú plochu v zobrazení kurzu, iné sa integrujú do prostredia Moodle.

* **Štandardný** - Použite kontajner spustenia špecifikovaný konfiguráciou nástroja.
* **Vložený** - Nástroj sa zobrazí v rámci existujúceho okna Moodle , spôsobom podobným väčšine ostatných typov aktivít.
* **Vložený, bez blokov** - Nástroj sa zobrazí v rámci existujúceho okna Moodle,  iba s ovládačmi navigácie v hornej časti stránky.
* **Nové okno** - Nástroj sa otvorí v novom okne, zaberajúc všetok dostupný priestor.

    V závislosti od prehliadača ho otvorí v novej tabuľke alebo vyskakovacom okne.
    Je možné, že prehliadače zabránia otvoreniu nového okna.';
$string['launchoptions'] = 'Možnosti spustenia';
$string['leaveblank'] = 'Ak ich nepotrebujete, nechajte prázdne';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = '';
$string['lti:addinstance'] = 'Pridať nový externý nástroj';
$string['lti:addmanualinstance'] = 'Pridať manuálne konfigurovaný nástroj';
$string['lti:addpreconfiguredinstance'] = 'Pridať predkonfigurovaný nástroj';
$string['lti:admin'] = 'Po spustení nástroja byť správcom';
$string['lti:grade'] = 'Zobraziť známky vrátené externým nástrojom';
$string['lti:manage'] = 'Po spustení nástroja byť učiteľom';
$string['lti:requesttooladd'] = 'Odoslať nástroj administrátorom pre konfiguráciu na celom portáli';
$string['lti:view'] = 'Spustiť činnosti externého nástroja';
$string['lti_administration'] = 'Upraviť predkonfigurovaný nástroj';
$string['lti_errormsg'] = 'Nástroj vrátil nasledujúcu chybovú správu: "{$a}"';
$string['lti_launch_error'] = 'Pri spustení externého nástroja sa objavila chyba:';
$string['lti_launch_error_tool_request'] = '<p>
Ak chcete odoslať žiadosť správcovi o dokončenie konfigurácie nástroja, kliknite <a href="{$a->admin_request_url}" target="_top">sem</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Táto chyba môže byť dôsledkom chýbajúceho zákazníckeho kľúča a zdieľaného hesla pre poskytovateľa nástroja.</p> <p>Ak máte zákaznícky kľúč a zdieľané heslo, môžete ich zadať pri editovaní inštancie externého nástroja (presvedčte sa, že sú rozšírené možnosti viditeľné).</p> <p>Alternatívne, môžete <a href="{$a->course_tool_editor}">vytvoriť konfiguráciu na úrovni kurzu pre poskytovateľa nástroja</a>.</p>';
$string['lti_tool_request_added'] = 'Požiadavka na konfiguráciu nástroja bola úspešne odoslaná. Na dokončenie konfigurácie nástroja budete možno potrebovať kontaktovať administrátora.';
$string['lti_tool_request_existing'] = 'Konfigurácia nástroja pre doménu nástroja už bola odoslaná.';
$string['ltisettings'] = 'Nastavenia LTI';
$string['ltiunknownserviceapicall'] = 'Neznáme volanie LTI služby API';
$string['ltiversion'] = 'LTI verzia';
$string['ltiversion_help'] = 'Verzia LTI používaná na podpisovanie správ a servisných požiadaviek: LTI 1.0/1.1 a LTI 2.0 používajú bezpečnostný profil OAuth 1.0A; LTI 1.3.0 používa JWT.';
$string['main_admin'] = 'Všeobecná nápoveda';
$string['main_admin_help'] = 'Externé nástroje umožňujú používateľom Moodle bezproblémové vzájomné pôsobenie so vzdelávacími zdrojmi hostovanými na diaľku. Cez špeciálny spúšťací protokol bude mať vzdialený nástroj prístup k niektorým všeobecným informáciám o používateľovi, ktorý ho spúšťa - napr. názov inštitúcie, ID kurzu, ID používateľa a iné informácie, ako je meno používateľa alebo jeho e-mailová adresa.

Typy nástrojov vymenované na tejto stránke sú rozdelené do troch kategórií:

* **Aktívne** - Títo poskytovatelia nástrojov boli schválení a nakonfigurovaní administrátorom. Môžu sa používať v akomkoľvek kurze tejto inštancie Moodle . Ak sú zadané zákaznícky kľúč a zdieľané heslo, vytvorí sa chránené spojenie medzi touto inštanciou Moodle a vzdialeným nástrojom, poskytujúc bezpečný komunikačný kanál.
* **Čakajúce** - Títo poskytovatelia nástrojov boli súčasťou importu balíka, ale ešte neboli nakonfigurovaní administrátorom. Učiteľia ale môžu používať nástroje od týchto poskytovateľov, ak majú zákaznícky kľúč a zdieľané heslo, alebo ak žiadne nie sú požadované.
* **Zamietnuté** - Títo poskytovatelia nástrojov sú označení ako tí, ktorých administrátor nemieni sprístupniť celej inštancii Moodle . Učiteľia ale môžu používať nástroje od týchto poskytovateľov, ak majú zákaznícky kľúč a zdieľané heslo, alebo ak žiadne nie sú požadované.';
$string['manage_external_tools'] = 'Spravovať nástroje';
$string['manage_tool_proxies'] = 'Spravovať registrácie externých nástrojov';
$string['manage_tools'] = 'Spravovať typy externých nástrojov';
$string['manuallyaddtype'] = 'Prípadne môžete <a href="{$a}">nástroj nakonfigurovať manuálne</a>.';
$string['miscellaneous'] = 'Rôzne';
$string['misconfiguredtools'] = 'Boli nájdené chybné nástroje';
$string['missingparameterserror'] = 'Stránka je chybná: "{$a}"';
$string['module_class_type'] = 'Typ modulu Moodle';
$string['modulename'] = 'Externý nástroj';
$string['modulename_help'] = 'Modul Externý nástroj umožňuje interakciu študentov so vzdelávacími zdrojmi a aktivitami na iných webových stránkach. Napríklad, externý nástroj môže poskytnúť prístup k novému typu aktivity alebo študijným materiálom od vydavateľa.

Aby ste vytvorili aktivitu Externý nástroj, vyžaduje sa poskytovateľ nástroja, ktorý podporuje LTI (Learning Tools Interoperability). Učiteľ môže vytvoriť aktivitu externého nástroja alebo použiť nástroj nakonfigurovaný administrátorom portálu.

Aktivity externých nástrojov sa odlišujú od URL niekoľkými spôsobmi:

* Externé nástroje vnímajú obsah, t.j.  majú prístup k informáciám o používateľovi, ktorý nástroj spustil, ako napr. inštitúcia, kurz a meno
* Externé nástroje podporujú čítanie, aktualizáciu a odstraňovanie hodnotení spojených s inštanciou aktivity
* Konfigurácie externých nástrojov vytvárajú chránené spojenie medzi vaším portálom a poskytovateľom nástroja, umožňujúce medzi nimi bezpečnú komunikáciu';
$string['modulenameplural'] = 'Externé nástroje';
$string['modulenamepluralformatted'] = 'Inštancie LTI';
$string['name'] = 'Názov';
$string['never'] = 'Nikdy';
$string['new_window'] = 'Nové okno';
$string['no_lti_configured'] = 'Nie sú nakonfigurované žiadne aktívne externé nástroje.';
$string['no_lti_pending'] = 'Nie sú  žiadne čakajúce externé nástroje.';
$string['no_lti_rejected'] = 'Nie sú  žiadne odmietnuté externé nástroje.';
$string['no_lti_tools'] = 'Nie sú žiadne aktívne externé nástroje.';
$string['no_tp_accepted'] = 'Neexistujú žiadne prijaté registrácie externých nástrojov.';
$string['no_tp_cancelled'] = 'Neexistujú žiadne zrušené registrácie externých nástrojov.';
$string['no_tp_configured'] = 'Nie sú nakonfigurované žiadne neregistrované registrácie externých nástrojov.';
$string['no_tp_pending'] = 'Neexistujú žiadne čakajúce registrácie externých nástrojov.';
$string['no_tp_rejected'] = 'Neexistujú žiadne zamietnuté registrácie externých nástrojov.';
$string['noattempts'] = 'Pre túto inštanciu nástroja neboli urobené žiadne pokusy';
$string['noltis'] = 'Nie sú  žiadne inštancie externých nástrojov';
$string['noprofileservice'] = 'Služba profilu sa nenašla';
$string['noservers'] = 'Neboli nájdené žiadne servery';
$string['notypes'] = 'Zatiaľ nie je v Moodle nastavený žiadny LTI nástroj. Kliknite na odkaz Inštalovať vyššie a niektorý pridajte.';
$string['noviewusers'] = 'Nebol nájdený žiadny používateľ s oprávnením používať tento nástroj';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 vyžaduje, aby bol nakonfigurovaný platný súbor openssl.cnf a aby bol dostupný pre váš webový server. Ak chcete nakonfigurovať a povoliť openssl pre túto stránku, kontaktujte správcu portálu.';
$string['optionalsettings'] = 'Možnosti nastavenia';
$string['organization'] = 'Detaily organizácie';
$string['organizationdescr'] = 'Opis organizácie';
$string['organizationid'] = 'ID organizácie';
$string['organizationid_default'] = 'Predvolené ID organizácie';
$string['organizationid_default_help'] = 'Predvolená hodnota, ktorá sa má použiť pre ID organizácie. ID lokality identifikuje túto inštaláciu Moodle.';
$string['organizationid_help'] = 'Jedinečný identifikátor tejto inštancie Moodle. Zvyčajne sa používa DNS názov organizácie.

Ak sa toto pole nechá prázdne, ako štandardná hodnota sa použije meno hostiteľa tohto Moodle portálu.';
$string['organizationidguid'] = 'ID organizácie';
$string['organizationidguid_help'] = 'Jedinečný identifikátor pre túto inštanciu Moodle odovzdaný nástroju ako GUID inštancie platformy.

Ak toto pole ponecháte prázdne, použije sa predvolená hodnota.';
$string['organizationurl'] = 'URL organizácie';
$string['organizationurl_help'] = 'Základná URL adresa tejto inštancie Moodle.

Ak sa toto pole nechá prázdne, použije sa štandardná hodnota na základe konfigurácie portálu.';
$string['pagesize'] = 'Počet odpovedí na stránku';
$string['parameter'] = 'Parametre nástrojov';
$string['parameter_help'] = 'Parametre nástrojov sú nastavenia prenosu dát cez proxy prijatých nástrojov, ktorých splnenie sa požaduje od poskytovateľa nástroja.';
$string['password'] = 'Zdieľané heslo';
$string['password_admin'] = 'Zdieľané heslo';
$string['password_admin_help'] = 'Zdieľané heslo môže byť považované za heslo použité na overenie prístupu k nástroju. Môže byť poskytnuté spolu so zákazníckym kľúčom od poskytovateľa nástroja.

Nástroje, ktoré nevyžadujú od Moodle bezpečnú komunikáciu a neposkytujú dodatočné služby (napr. spätné hlásenie hodnotení), nemusia požadovať zdieľané heslo.';
$string['password_help'] = 'Pre predkonfigurované nástroje nie je potrebné zadať zdieľané heslo, pretože je poskytované ako súčasť procesu konfigurácie.

Toto pole by sa malo zadávať pri vytváraní odkazu na poskytovateľa nástroja, ktorý ešte nie je nakonfigurovaný. Ak sa poskytovateľ nástroja musí použiť v tomto kurze viac ako raz, pridanie konfigurácie nástroja kurzu je dobrý nápad.

Zdieľané heslo môže byť považované za heslo použité na overenie prístupu k nástroju. Môže byť poskytnuté spolu so zákazníckym kľúčom od poskytovateľa nástroja.

Nástroje, ktoré nevyžadujú od Moodle bezpečnú komunikáciu a neposkytujú dodatočné služby (napr. spätné hlásenie hodnotení), nemusia požadovať zdieľané heslo.';
$string['pending'] = 'Prebiehajúci';
$string['pluginadministration'] = 'Administratíva externého nástroja';
$string['pluginname'] = 'Externý nástroj';
$string['preferheight'] = 'Preferovaná výška';
$string['preferwidget'] = 'Preferovať spúšťanie widgetu';
$string['preferwidth'] = 'Preferovaná šírka';
$string['press_to_submit'] = 'Stlačte na spustenie tejto aktivity';
$string['privacy'] = 'Súkromie';
$string['privacy:metadata:coursefullname'] = 'Celé meno kurzu, z ktorého používateľ pristupuje k spotrebiteľovi LTI';
$string['privacy:metadata:courseid'] = 'ID kurzu, z ktorého používateľ pristupuje k spotrebiteľovi LTI';
$string['privacy:metadata:courseidnumber'] = 'Identifikačné číslo kurzu, z ktorého používateľ pristupuje k spotrebiteľovi LTI';
$string['privacy:metadata:courseshortname'] = 'Skrátený názov kurzu, z ktorého používateľ pristupuje k spotrebiteľovi LTI';
$string['privacy:metadata:createdby'] = 'Používateľ, ktorý vytvoril záznam';
$string['privacy:metadata:email'] = 'E-mailová adresa používateľa, ktorý pristupuje k spotrebiteľovi LTI';
$string['privacy:metadata:externalpurpose'] = 'Spotrebiteľ LTI poskytuje informácie o používateľovi a kontext poskytovateľovi nástroja LTI.';
$string['privacy:metadata:firstname'] = 'Krstné meno používateľa pristupujúceho k spotrebiteľovi LTI';
$string['privacy:metadata:fullname'] = 'Celé meno používateľa pristupujúceho k spotrebiteľovi LTI';
$string['privacy:metadata:lastname'] = 'Priezvisko používateľa pristupujúceho k spotrebiteľovi LTI';
$string['privacy:metadata:lti_submission'] = 'LTI podanie';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Časová pečiatka označujúca, kedy bolo podanie uskutočnené';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Časová pečiatka označujúca, kedy bol príspevok upravený';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Známka pre používateľa v percentách';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Pôvodná známka pre používateľa';
$string['privacy:metadata:lti_submission:userid'] = 'Identifikátor používateľa, ktorý odoslal aktivitu LTI';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI proxy';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Názov proxy LTI';
$string['privacy:metadata:lti_types'] = 'LTI typy';
$string['privacy:metadata:lti_types:name'] = 'Názov typu LTI';
$string['privacy:metadata:role'] = 'Rola v kurze pre používateľa pristupujúceho k spotrebiteľovi LTI';
$string['privacy:metadata:timecreated'] = 'Čas, kedy bol záznam vytvorený';
$string['privacy:metadata:timemodified'] = 'Čas, kedy bol záznam vytvorený';
$string['privacy:metadata:userid'] = 'ID používateľa pristupujúceho k spotrebiteľovi LTI';
$string['privacy:metadata:useridnumber'] = 'Identifikačné číslo používateľa pristupujúceho k spotrebiteľovi LTI';
$string['privacy:metadata:username'] = 'Používateľské meno používateľa pristupujúceho k spotrebiteľovi LTI';
$string['publickey'] = 'Verejný kľúč';
$string['publickey_help'] = 'Verejný kľúč (vo formáte PEM) poskytnutý nástrojom, ktorý umožňuje overenie podpisov prichádzajúcich správ a požiadaviek na služby.';
$string['publickeyset'] = 'Súprava verejných kľúčov';
$string['publickeyset_help'] = 'Súprava verejných kľúčov, odkiaľ táto stránka získa verejný kľúč nástroja, aby bolo možné overiť podpisy prichádzajúcich správ a servisných požiadaviek.';
$string['quickgrade'] = 'Povoliť rýchle hodnotenie';
$string['quickgrade_help'] = 'Ak je táto možnosť aktivovaná, viacero nástrojov môže byť hodnotených na jednej stránke. Pridajte hodnotenia a komentáre, potom stlačte tlačidlo "Uložiť všetky moje spätné väzby", aby ste uložili všetky zmeny tejto stránky.';
$string['redirect'] = 'Budete presmerovaný počas niekoľkých sekúnd. Ak nie, stlačte tlačidlo.';
$string['redirectionuris'] = 'URI presmerovania';
$string['redirectionuris_help'] = 'Zoznam URI (jeden na riadok), ktoré nástroj používa pri vytváraní žiadostí o autorizáciu. Aby bolo možné úspešne odoslať správu do nástroja, musí byť zaregistrovaný aspoň jeden.';
$string['register'] = 'Registrovať';
$string['register_warning'] = 'Zdá sa, že stránka registrácie potrebuje nejaký čas na svoje otvorenie. Ak sa neobjaví, preverte, či ste zadali správnu URL adresu v nastaveniach konfigurácie.';
$string['registertype'] = 'Konfigurovať registráciu nového externého nástroja';
$string['registration_options'] = 'Možnosti registrácie';
$string['registrationname'] = 'Meno poskytovateľa nástroja';
$string['registrationname_help'] = 'Vložte zaregistrované meno poskytovateľa nástroja.';
$string['registrationurl'] = 'URL adresa registrácie';
$string['registrationurl_help'] = 'URL adresa registrácie by mala byť k dispozícii od poskytovateľa nástroja ako lokalita, na ktorú by sa mali posielať žiadosti o registráciu.';
$string['reject'] = 'Odmietnuť';
$string['rejected'] = 'Odmietnuté';
$string['resource'] = 'Zdroj';
$string['resourcekey'] = 'Spotrebiteľský kľúč';
$string['resourcekey_admin'] = 'Spotrebiteľský kľúč';
$string['resourcekey_admin_help'] = 'Zákaznícky kľúč môže byť myslený ako používateľské meno použité na overenie prístupu k nástroju. Môže byť použitý poskytovateľom nástroja na jedinečnú identifikáciu Moodle portálu, z ktorého používatelia spúšťajú nástroj.

Zákaznícky kľúč musí poskytnúť poskytovateľ nástroja. Metóda získania zákazníckeho kľúča sa líši od poskytovateľa k poskytovateľovi. Môže to byť automatický proces, alebo sa môže požadovať dialóg s poskytovateľom nástroja.

Nástroje, ktoré nevyžadujú od Moodle bezpečnú komunikáciu a neposkytujú dodatočné služby (napr. spätné hlásenie hodnotení), nemusia požadovať heslo zdroja.';
$string['resourcekey_help'] = 'Pre predkonfigurované nástroje nie je potrebné zadať heslo zdroja, pretože zákaznícky kľúč je poskytovaný ako súčasť procesu konfigurácie.

Toto pole by sa malo zadávať pri vytváraní odkazu na poskytovateľa nástroja, ktorý ešte nie je nakonfigurovaný. Ak sa poskytovateľ nástroja musí použiť v tomto kurze viac ako raz, pridanie konfigurácie nástroja kurzu je dobrý nápad.

Zákaznícky kľúč môže byť myslený ako používateľské meno použité na overenie prístupu k nástroju. Môže byť použitý poskytovateľom nástroja na jedinečnú identifikáciu Moodle portálu, z ktorého používatelia spúšťajú nástroj.

Zákaznícky kľúč musí poskytnúť poskytovateľ nástroja. Metóda získania zákazníckeho kľúča sa líši od poskytovateľa k poskytovateľovi. Môže to byť automatický proces, alebo sa môže požadovať dialóg s poskytovateľom nástroja.

Nástroje, ktoré nevyžadujú od Moodle bezpečnú komunikáciu a neposkytujú dodatočné služby (napr. spätné hlásenie hodnotení), nemusia požadovať heslo zdroja.';
$string['resourceurl'] = 'URL zdroja';
$string['return_to_course'] = 'Aby ste sa vrátili do kurzu, kliknite na <a href="{$a->link}" target="_top">tu</a>.';
$string['saveallfeedback'] = 'Uložiť všetky moje odpovede';
$string['secure_icon_url'] = 'Ikona URL pre bezpečný prístup';
$string['secure_icon_url_help'] = 'Podobná ikone URL, ale používa sa, ak používateľ pristupuje do Moodle bezpečne cez SSL. Toto pole má zabrániť prehliadaču zobraziť varovanie pred nezabezpečeným obrázkom.';
$string['secure_launch_url'] = 'Ikona spustenia URL pre bezpečný prístup';
$string['secure_launch_url_help'] = 'Podobná spúšťacej URL, ale používa sa namiesto nej, ak sa vyžaduje vyššia bezpečnosť. Moodle použije bezpečnú spúšťaciu URL namiesto spúšťacej URL, ak sa na Moodle portál pristupuje cez SSL, alebo ak je konfigurácia nástroja nastavená tak, aby sa vždy spúšťal cez SSL.

Spúšťacia URL môže byť tiež nastavená na https adresu, aby sa vynútilo spúšťanie cez SSL a toto pole potom môže zostať prázdne.';
$string['selectcontent'] = 'Vybrať obsah';
$string['send'] = 'Odoslať';
$string['services'] = 'Služby';
$string['services_help'] = 'Vyberte tie služby, ktoré chcete ponúkať poskytovateľovi nástrojov. Je možné vybrať viac ako jednu službu.';
$string['setupoptions'] = 'Nastavenie volieb';
$string['share_email'] = 'Zdieľajte mail poskytovateľa';
$string['share_email_admin'] = 'Zdieľajte mail poskytovateľa';
$string['share_email_admin_help'] = 'Špecifikujte, či bude e-mailová adresa používateľa, spúšťajúceho nástroj, zdieľaná s poskytovateľom nástroja.
Poskytovateľ nástroja môže potrebovať e-mailové adresy spúšťajúcich, aby rozlíšil používateľov s rovnakým menom v UI, alebo aby posielal e-maily používateľom na základe akcií vykonávaných v rámci nástroja.';
$string['share_email_help'] = 'Špecifikujte, či bude e-mailová adresa používateľa, spúšťajúceho nástroj, zdieľaná s poskytovateľom nástroja.

Poskytovateľ nástroja môže potrebovať e-mailové adresy spúšťajúcich, aby rozlíšil používateľov s rovnakým menom, alebo aby posielal e-maily používateľom na základe akcií vykonávaných v rámci nástroja.

Poznámka: Toto nastavenie je možné v konfigurácii nástroja ignorovať.';
$string['share_name'] = 'Zdieľajte názov poskytovateľa';
$string['share_name_admin'] = 'Zdieľajte mail poskytovateľa';
$string['share_name_admin_help'] = 'Špecifikujte, či by malo byť celé meno používateľa, spúšťajúceho nástroj, zdieľané s poskytovateľom nástroja.
Poskytovateľ nástroja môže potrebovať celé mená spúšťajúcich, aby zobrazoval v rámci nástroja zmysluplné informácie.';
$string['share_name_help'] = 'Špecifikujte, či by malo byť celé meno používateľa, spúšťajúceho nástroj, zdieľané s poskytovateľom nástroja.

Poskytovateľ nástroja môže potrebovať celé mená spúšťajúcich, aby zobrazoval v rámci nástroja zmysluplné informácie.

Poznámka: Toto nastavenie je možné v konfigurácii nástroja ignorovať.';
$string['share_roster'] = 'Povoliť nástroj pre prístup k zoznamu kurzov';
$string['share_roster_admin'] = 'Nástroj umožňujúci prístup k zoznamu kurzov';
$string['share_roster_admin_help'] = 'Špecifikujte, či nástroj môže pristupovať k zoznamu používateľov zapísaných do kurzov, z ktorých sa tento typ nástroja spúšťa.';
$string['share_roster_help'] = 'Špecifikujte, či nástroj môže pristupovať k zoznamu používateľov zapísaných do tohto kurzu.

Poznámka: Toto nastavenie je možné v konfigurácii nástroja ignorovať.';
$string['show_in_course_activity_chooser'] = 'Zobraziť vo výbere aktivít a ako predkonfigurovaný nástroj';
$string['show_in_course_lti1'] = 'Použitie konfiguračného nástroja';
$string['show_in_course_lti1_help'] = 'Tento nástroj sa môže učiteľovi zobraziť vo výbere aktivít, ktorý si môže vybrať a pridať do kurzu. Alternatívne sa môže zobraziť v rozbaľovacej ponuke vopred nakonfigurovaných nástrojov pri pridávaní externého nástroja do kurzu. Ďalšou možnosťou je použiť konfiguráciu nástroja iba vtedy, ak je pri pridávaní externého nástroja do kurzu zadaná presná adresa URL nástroja.';
$string['show_in_course_lti2'] = 'Použitie konfiguračného nástroja';
$string['show_in_course_lti2_help'] = 'Tento nástroj môže byť zobrazený vo výbere aktivity pre učiteľa, ktorý si môže vybrať na pridanie do kurzu, alebo v rozbaľovacej ponuke vopred nakonfigurovaných nástrojov pri pridávaní externého nástroja do kurzu.';
$string['show_in_course_no'] = 'Nezobraziť; použite iba vtedy, keď je zadaná zhodná adresa URL nástroja';
$string['show_in_course_preconfigured'] = 'Zobraziť ako predkonfigurovaný nástroj pri pridávaní externého nástroja';
$string['sitehost'] = 'Názov hostiteľa portálu';
$string['siteid'] = 'ID portálu';
$string['size'] = 'Veľkosť parametrov';
$string['submission'] = 'Odoslanie';
$string['submissions'] = 'Odovzdané zadania';
$string['submissionsfor'] = 'Odovzdané práce pre {$a}';
$string['subplugintype_ltiresource'] = 'Zdroj LTI služby';
$string['subplugintype_ltiresource_plural'] = 'Zdroje LTI služieb';
$string['subplugintype_ltiservice'] = 'LTI služba';
$string['subplugintype_ltiservice_plural'] = 'LTI služby';
$string['subplugintype_ltisource'] = 'LTI zdroj';
$string['subplugintype_ltisource_plural'] = 'LTI zdroje';
$string['successfullycreatedtooltype'] = 'Nový nástroj bol úspešne vytvorený!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Z vybratého obsahu bola úspešne načítaná konfigurácia nástroja.';
$string['toggle_debug_data'] = 'Prepnúť dáta ladenia programu';
$string['tool_config_not_found'] = 'Konfigurácia nástroja sa pre túto URL adresu nenašla.';
$string['tool_settings'] = 'Nastavenie nástroja';
$string['tooldescription'] = 'Opis nástroja';
$string['tooldescription_help'] = 'Opis nástroja, ktorý sa zobrazí učiteľom v zozname aktivít.

Toto by malo popisovať, na čo nástroj slúži a na čo slúži, ako aj ďalšie informácie, ktoré môže učiteľ potrebovať vedieť.';
$string['tooldetailsaccesstokenurl'] = 'Adresa URL prístupového tokenu';
$string['tooldetailsauthrequesturl'] = 'Adresa URL žiadosti o overenie';
$string['tooldetailsclientid'] = 'ID klienta';
$string['tooldetailsdeploymentid'] = 'ID nasadenia';
$string['tooldetailsmailtosubject'] = 'Konfigurácia nástroja LTI';
$string['tooldetailsmodalemail'] = 'Email';
$string['tooldetailsmodallink'] = 'Zobraziť podrobnosti konfigurácie';
$string['tooldetailsmodaltitle'] = 'Podrobnosti o konfigurácii nástroja';
$string['tooldetailsplatformid'] = 'ID platformy';
$string['tooldetailspublickeyseturl'] = 'Adresa URL verejnej sady kľúčov';
$string['toolisbeingused'] = 'Tento nástroj sa používa {$a}-krát';
$string['toolisnotbeingused'] = 'Tento nástroj ešte nebol použitý';
$string['toolproxy'] = 'Registrácie externého nástroja';
$string['toolproxy_help'] = 'Registrácie externých nástrojov umožňujú administrátorom Moodle stránok konfigurovať externé nástroje z proxy nástrojov, získaného od poskytovateľa nástroja a podporujúceho štandard LTI 2.0. Všetko, čo sa požaduje na zahájenie tohto procesu, je URL adresa registrácie, poskytnutá poskytovateľom nástroja. Schopnosti a služby ponúknuté poskytovateľovi nástroja sa zvolia pri konfigurovaní novej registrácie.

Registrácie nástrojov uvedené na tejto stránke sú rozdelené do štyroch kategórií:

* **Konfigurované** - Tieto registrácie nástrojov boli nastavené, ale proces ich registrácie sa ešte nezačal.
* **Čakajúce** - Proces registrácie týchto nástrojov sa začal, ale ešte nebol dokončený. Otvorte a uložte nastavenia, aby ste ich presunuli späť do kategórie \'Konfigurované\' .
* **Prijaté** - Tieto registrácie nástrojov boli schválené; zdroje špecifikované v proxy nástrojov sa objavia na stránke typov externých nástrojov s úvodným stavom \'Čakajúce\'.
* **Zamietnuté** - Tieto registrácie nástrojov sú tie, ktoré boli počas registračného procesu zamietnuté. Otvorte a uložte nastavenia, aby ste ich presunuli späť do kategórie \'Konfigurované\' , aby mohol registračný proces znovu začať.';
$string['toolproxyregistration'] = 'Registrácia externého nástroja';
$string['toolregistration'] = 'Registrácia externého nástroja';
$string['toolsetup'] = 'Konfigurácia externého nástroja';
$string['tooltypeadded'] = 'Predkonfigurovaný nástroj bol pridaný';
$string['tooltypedeleted'] = 'Predkonfigurovaný nástroj bol odstránený';
$string['tooltypenotdeleted'] = 'Predkonfigurovaný nástroj nebolo možné odstrániť';
$string['tooltypes'] = 'Nástroje';
$string['tooltypeupdated'] = 'Predkonfigurovaný nástroj bol aktualizovaný';
$string['toolurl'] = 'URL nástroja';
$string['toolurl_contentitemselectionrequest'] = 'Adresa URL výberu obsahu';
$string['toolurl_contentitemselectionrequest_help'] = 'Adresa URL výberu obsahu sa použije na spustenie stránky na výber obsahu od poskytovateľa nástroja. Ak je prázdna, použije sa URL nástroja';
$string['toolurl_help'] = 'Základná URL adresa nástroja sa používa na to, aby spojila spúšťacie URL adresy nástroja so správnou konfiguráciou nástroja. Umiestnenie predpony http(s) pred URL adresu je nepovinné.

Okrem toho sa základná URL adresa používa ako spúšťacia URL adresa, ak nie je spúšťacia URL adresa špecifikovaná v inštancii externého nástroja.

Napríklad, základná URL adresa  *tool.com* by vyhovovala nasledujúcim:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Základná URL adresa *www.tool.com/quizzes* by vyhovovala nasledujúcim:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Základná URL adresa *quiz.tool.com* by vyhovovala nasledujúcim:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Ak sú dve rôzne konfigurácie nástroja pre tú istú doménu, použije sa tá, ktorá je najšpecifickejšia.';
$string['toolurlplaceholder'] = 'Adresa URL nástroja...';
$string['typename'] = 'Názov nástroja';
$string['typename_help'] = 'Názov nástroja sa používa na identifikáciu poskytovateľa nástroja v rámci Moodle. Zadaný názov budú vidieť učiteľia pri pridávaní externých nástrojov do kurzov.';
$string['types'] = 'Typy';
$string['unabletocreatetooltype'] = 'Nie je možné vytvoriť nástroj';
$string['unabletofindtooltype'] = 'Nie je možné nájsť nástroj pre {$a->id}';
$string['unknownstate'] = 'Neznámy stav';
$string['update'] = 'Aktualizovať';
$string['useraccountinformation'] = 'Informácie o používateľskom účte';
$string['userpersonalinformation'] = 'Osobné informácie používateľa';
$string['using_tool_configuration'] = 'Použiť konfiguráciu nástroja:';
$string['validurl'] = 'Správna adresa URL musí začínať s http(s)://';
$string['viewsubmissions'] = 'Zobraziť stránku s odovzdanými zadaniami a hodnotením';
