<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'sk', version '4.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akcie';
$string['activate'] = 'Povoliť prístup';
$string['activatesuccess'] = 'Prístup k odznakom bol úspešne povolený.';
$string['addalignment'] = 'Pridajte externú zručnosť alebo štandard';
$string['addbackpack'] = 'Pridať zbierku';
$string['addbadge'] = 'Pridajte odznaky';
$string['addbadge_help'] = 'Vyberte všetky odznaky, ktoré sa majú pridať k tejto požiadavke na odznak. Podržaním klávesy CTRL vyberiete viac položiek.';
$string['addbadgecriteria'] = 'Pridať kritériá odznakov';
$string['addcohort'] = 'Pridať globálnu skupinu';
$string['addcohort_help'] = 'Vyberte všetky globálne skupiny, ktoré by mali byť pridané k tejto požiadavke na odznak. Podržaním klávesy CTRL vyberiete viac položiek.';
$string['addcompetency'] = 'Pridať kompetenciu';
$string['addcompetency_help'] = 'Vyberte všetky kompetencie, ktoré by mali byť pridané k tejto požiadavke na odznak. Ak chcete vybrať viac položiek, podržte klávesu CTRL.';
$string['addcourse'] = 'Pridať kurzy';
$string['addcourse_help'] = 'Vyberte všetky kurzy, ktoré by mali byť pridané do tejto požiadavky odznaku. Pre výber viacerých položiek stlačte klávesu CTRL .';
$string['addcriteria'] = 'Pridať kritériá';
$string['addcriteriatext'] = 'Pre pridávanie kritérií prosím vyberte jednu z možností v rozbaľovacom zozname.';
$string['addedtobackpack'] = 'Pridať odznak do zbierky';
$string['addrelated'] = 'Pridajte príslušný odznak';
$string['addtobackpack'] = 'Pridať do batoha';
$string['adminonly'] = 'Táto stránka je prístupná len administrátorom.';
$string['after'] = 'po dátume vydania.';
$string['aggregationmethod'] = 'metóda zoskupenia';
$string['alignment'] = '';
$string['all'] = 'Všetky';
$string['allmethod'] = 'Všetky vybrané podmienky sú splnené';
$string['allmethodactivity'] = 'Všetky vybrané aktivity sú úplné';
$string['allmethodbadges'] = 'Všetky vybraté odznaky boli udelené';
$string['allmethodcohort'] = 'Členstvo vo všetkých vybraných globálnych skupinách';
$string['allmethodcompetencies'] = 'Všetky vybrané kompetencie boli splnené';
$string['allmethodcourseset'] = 'Všetky vybrané kurzy sú kompletné';
$string['allmethodmanual'] = 'Všetky vybrané oprávnenia môžu udeľovať odznak';
$string['allmethodprofile'] = 'Všetky vybrané polia profilu boli úplné';
$string['allowcoursebadges'] = 'Povoliť odznaky kurzu';
$string['allowcoursebadges_desc'] = 'Povoliť vytváranie a udeľovanie odznakov';
$string['allowexternalbackpack'] = 'Pripojenie externej zbierky odznakov';
$string['allowexternalbackpack_desc'] = 'Povoliť používateľom nastavenie pripojení a zobrazení odznakov od ich externých poskytovateľov. Používatelia sa tiež môžu rozhodnúť zobraziť akékoľvek verejné zbierky odznakov zo svojho externého batohu na svojej profilovej stránke na tomto portáli.  Poznámka: Odporúčame túto možnosť nepovoliť, pokiaľ stránka nie je dostupná z internetu (napríklad pre firewall).';
$string['any'] = 'Akýkoľvek';
$string['anymethod'] = 'Je splnená aspoň jedna z vybraných podmienok';
$string['anymethodactivity'] = 'Ktorákoľvek z vybraných aktivít je dokončená';
$string['anymethodbadges'] = 'Všetky vybrané odznaky boli udelené';
$string['anymethodcohort'] = 'Členstvo v ktorejkoľvek z vybraných globálnych skupín';
$string['anymethodcompetencies'] = 'Niektoré z vybraných kompetencií boli splnené';
$string['anymethodcourseset'] = 'Všetky vybrané kurzy sú dokončené';
$string['anymethodmanual'] = 'Odznak udeľuje aspoň jedna z vybraných rol';
$string['anymethodprofile'] = 'Ktorékoľvek z vybratých profilových polí bolo dokončené';
$string['apiversion'] = 'API verzia podporovaná';
$string['archivebadge'] = 'Chcete vymazať odznak \'{$a}\', ale ponechať existujúce odznaky?';
$string['archiveconfirm'] = 'Vymazať a ponechať existujúce odznaky';
$string['archivehelp'] = '<p> Táto možnosť znamená, že odznak bude označený ako "vyradený" a už sa nebude zobrazovať v zozname odznakov. Používatelia už nebudú môcť získať tento odznak, avšak existujúci príjemcovia odznakov budú naďalej zobrazovať tento odznak na svojej profilovej stránke a budú môcť preniesť odznaky do svojich externých odznakových batohov. </ P>
<p> Ak chcete, aby Vaši používatelia zachovali prístup k získaným odznakom, je dôležité vybrať túto možnosť namiesto úplného odstránenia odznakov. </ p>';
$string['attachment'] = 'Priložiť odznak do správy';
$string['attachment_help'] = 'Ak je táto možnosť povolená, vydaný odznak bude priložený k e-mailu príjemcu na stiahnutie. (Prílohy e-mailu musia byť povolené v Administrácii stránok / Konfigurácia servera / E-mail / Odchádzajúcej pošta, aby ste túto možnosť použili.)';
$string['award'] = 'Udeliť odznak';
$string['awardedto'] = 'Udelené {$a}';
$string['awardedtoyou'] = 'Vydaný pre mňa';
$string['awardoncron'] = 'Prístup k odznakom bol úspešne povolený. Príliš veľa používateľov môže okamžite získať tento odznak. Ak chcete zabezpečiť výkonnosť webových stránok, táto akcia bude trvať určitý čas na spracovanie.';
$string['awards'] = 'Príjemcovia';
$string['backpackapiurl'] = 'API URL zbierky';
$string['backpackavailability'] = 'Externé overenie odznaku';
$string['backpackavailability_help'] = 'Pre príjemcov odznaku, aby dokázali, že od vás získali odznaky, musí mať externá zálohová služba prístup k vašej stránke a overiť odznaky, ktoré z nej pochádzajú. Vaša stránka sa momentálne nezdá byť prístupná, čo znamená, že odznaky, ktoré ste už vydali alebo budú vydané v budúcnosti, nie je možné overiť.

** Prečo sa zobrazuje táto správa? **

Je možné, že brána firewall bráni prístupu od používateľov mimo vašej siete, vaša lokalita je chránená heslom alebo spustíte lokalitu v počítači, ktorý nie je dostupný z Internetu (napríklad lokálny vývojový stroj).

** Je to problém? **

Tento problém by ste mali vyriešiť na ktoromkoľvek mieste systému, kde plánujete vydávať odznaky, inak príjemcovia nebudú schopní dokázať, že od vás odznaky získali. Ak vaše stránky ešte nie sú živé (spustené), môžete vytvoriť a vydať testovacie odznaky, pokiaľ sú stránky prístupné predtým, ako je vydávanie odznakov nastavené naživo.

** Čo keď nemôžem verejne sprístupniť celú stránku? **

Jedinou adresou URL potrebnou na overenie je [your-site-url] /badges/assertion.php, takže ak ste schopní zmeniť bránu firewall tak, aby umožňovala externý prístup k tomuto súboru, overenie odznaku bude naďalej fungovať.';
$string['backpackbadgessettings'] = 'Zmeniť nastavenie zbierky';
$string['backpackbadgessummary'] = 'Máte {$a->totalbadges} odznak(ov) zobrazených z kolekcie(í) {$a->totalcollections}.';
$string['backpackcannotsendverification'] = 'Nemôžem odoslať overovací email.';
$string['backpackconnected'] = 'Zbierka je pripojená';
$string['backpackconnection'] = 'Prepojenie na batoh odznakov.';
$string['backpackconnection_help'] = 'Pripojenie ku zbierke vám umožní zdieľať vaše odznaky z tohto portálu a zobrazovať verejné kolekcie odznakov zo zbierky na stránke profilu na tomto portáli.';
$string['backpackconnectioncancelattempt'] = 'Pripojte sa inou emailovou adresou.';
$string['backpackconnectionconnect'] = 'Pripojte sa k batohu odznakov';
$string['backpackconnectionnottested'] = 'Pripojenie nie je možné otestovať pre túto zbierku, pretože podporuje iba zbierky Open Badges v2.0.';
$string['backpackconnectionok'] = 'Pripojenie zbierky bolo úspešne vytvorené';
$string['backpackconnectionresendemail'] = 'Znovaposlanie overovacieho emailu';
$string['backpackconnectionunexpectedmessage'] = 'Zbierka vrátila chybu: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Vyskytol sa problém s pripojením ku zbierke odznakov. Skontrolujte údaje nastavenia a skúste to znova.';
$string['backpackdetails'] = 'Nastavenia zbierky';
$string['backpackdisconnected'] = 'Zbierka je odpojená';
$string['backpackemail'] = 'Emailová adresa';
$string['backpackemail_help'] = 'E-mailová adresa priradená k vášmu batohu odznakov. Kým ste pripojení, akékoľvek odznaky získané na týchto stránkach budú priradené k tejto e-mailovej adrese.';
$string['backpackemailverificationpending'] = 'Overovanie čaká.';
$string['backpackemailverifyemailbody'] = 'Ahoj,

Nové spojenie s vaším odznakovým batohom  bolo vyžiadané z adresy „{$a->sitename} \' pomocou Vašej e-mailovej adresy.

Ak chcete potvrdiť a aktivovať pripojenie k batohu, prejdite na stránku

{$a->link}

Vo väčšine poštových programov by sa to malo zobraziť ako modrý odkaz, na ktorý stačí kliknúť. Ak to nepomôže, potom URL adresu vložte do riadka adresy v hornej časti webového prehliadača.

Ak potrebujete pomoc, kontaktujte správcu stránky, {$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Overenie emailu pre zbierku odznakov';
$string['backpackemailverifypending'] = 'Overovací e-mail bol odoslaný na adresu <strong> {$a} </strong>. Kliknutím na overovací odkaz v e-maile aktivujete pripojenie k odznakovému batohu.';
$string['backpackemailverifysuccess'] = 'Ďakujeme za overenie e-mailovej adresy. Teraz ste pripojení k odznakovému batohu.';
$string['backpackemailverifytokenmismatch'] = 'Token v prepojení, na ktoré ste klikli, sa nezhoduje s uloženým tokenom. Uistite sa, že ste klikli na odkaz v poslednom prijatom e-maile.';
$string['backpackexporterror'] = 'Odznak nie je možné exportovať do zbierky';
$string['backpackimport'] = 'Nastavenie importu odznakov';
$string['backpackimport_help'] = 'Po úspešnom nadviazaní spojenia s batohom je možné na stránke s odznakmi a na stránke profilu zobraziť odznaky z batohu.

V tejto oblasti môžete vybrať kolekcie odznakov z batohu, ktoré chcete zobraziť vo svojom profile.';
$string['backpackneedsupdate'] = 'Zbierka spojená s týmto profilom nezodpovedá zbierke na portáli. Zbierku musíte odpojiť a znovu pripojiť.';
$string['backpackprovider'] = 'Poskytovateľ zbierky';
$string['backpacksettings'] = 'Nastavenia zbierky';
$string['backpackweburl'] = 'URL zbierky';
$string['badgedetails'] = 'Detaily odznaku';
$string['badgeimage'] = 'Obrázok';
$string['badgeimage_help'] = 'Obrázok by mal mať veľkosť aspoň 300 x 300 pixelov. Na stránke odznaku sa zobrazí ako 300 x 300 pixelov a na stránke profilu používateľa 100 x 100 pixelov.';
$string['badgeprivacysetting'] = 'Nastavenia súkromia pre odznaky';
$string['badgeprivacysetting_help'] = 'Získané odznaky sa môžu zobraziť na stránke profilu vášho účtu. Toto nastavenie umožňuje automaticky nastaviť viditeľnosť novozískaných odznakov.

Stále môžete kontrolovať individuálne nastavenia ochrany osobných údajov na stránke s odznakmi.';
$string['badgeprivacysetting_str'] = 'Zobraziť automaticky odznaky, ktoré som získal, na mojej profilovej stránke';
$string['badges'] = 'Odznaky';
$string['badgesalt'] = 'Soľ pre hašovanie e-mailovej adresy príjemcu';
$string['badgesalt_desc'] = 'Použitie hash umožňuje službám batohov odznakov potvrdenie príjemcovi odznaku, bez toho aby museli vystaviť ich e-mailovú adresu. Toto nastavenie by malo používať iba čísla a písmená.

Poznámka: Ak chcete overiť príjemcov, po začatí vydávania odznakov toto nastavenie nemeňte.';
$string['badgesdisabled'] = 'Odznaky nie sú povolené na tejto stránke';
$string['badgesearned'] = 'Počet získaných odznakov: {$a}';
$string['badgesettings'] = 'Nastavenia odznakov';
$string['badgestatus_0'] = 'Nedostupné';
$string['badgestatus_1'] = 'Dostupné';
$string['badgestatus_2'] = 'Nedostupné (zamknuté kritérium)';
$string['badgestatus_3'] = 'Dostupné (zamknuté kritérium)';
$string['badgestatus_4'] = 'Archivovaný';
$string['badgestoearn'] = 'Počet dostupných odznakov: {$a}';
$string['badgesview'] = 'Odznaky kurzu';
$string['badgeurl'] = 'Vydaný odkaz na odznak';
$string['balignment'] = '';
$string['bawards'] = 'Príjemcovia ({$a})';
$string['bcriteria'] = 'Kritériá';
$string['bdetails'] = 'Upraviť podrobnosti';
$string['bendorsement'] = 'Podpora';
$string['bmessage'] = 'Správa';
$string['boverview'] = 'Prehľad';
$string['brelated'] = 'Súvisiace odznaky ({$a})';
$string['bydate'] = 'dokončené';
$string['claim'] = 'Nárok';
$string['claimcomment'] = 'Komentár k podpore';
$string['claimid'] = 'Vyžiadanie URL';
$string['clearsettings'] = 'Vymazať nastavenia';
$string['completioninfo'] = 'Tento odznak bol vydaný z dôvodu dokončenia:';
$string['completionnotenabled'] = 'Ukončenie kurzu nie je pre tento kurz povolené, preto ho nemožno zahrnúť do kritérií vydania odznaku. Ukončenie kurzu môže byť povolené v nastaveniach kurzu.';
$string['configenablebadges'] = 'Keď je táto funkcia povolená, umožňuje vytvárať odznaky a udeľovať ich používateľom.';
$string['configuremessage'] = 'Správa o odznaku';
$string['connect'] = 'Pripojenie';
$string['connected'] = 'Pripojené';
$string['connecting'] = 'Pripájanie...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'E-mailová adresa priradená k vydavateľovi odznaku.';
$string['copyof'] = 'Kópia {$a}';
$string['course'] = 'Kurz: {$a}';
$string['coursebadges'] = 'Odznaky';
$string['coursebadgesdisabled'] = 'Odznaky kurzu nie sú na tejto stránke povolené.';
$string['coursebadgetitle'] = 'Odznak kurzu {$a}';
$string['coursecompletion'] = 'Používatelia musia ukončiť tento kurz.';
$string['create'] = 'Nový odznak';
$string['createbutton'] = 'Vytvoriť odznak';
$string['creatorbody'] = '<p>  Používateľ {$a->user} splnil všetky požiadavky a získal tak odznak. Vydaný odznak si možno prezrieť na adrese {$a->link} </p>';
$string['creatorsubject'] = 'Používateľovi \'{$a}\' bol udelený odznak!\'';
$string['criteria_0'] = 'Tento odznak sa udeľuje keď...';
$string['criteria_1'] = 'Splnenie aktivity';
$string['criteria_1_help'] = 'Umožňuje udelenie odznaku používateľom na základe splnenia súboru aktivít v rámci kurzu.';
$string['criteria_2'] = 'Manuálne vydanie podľa roly';
$string['criteria_2_help'] = 'Umoženie používateľom, ktorí majú konkrétnu rolu v rámci lokality alebo kurzu, ručné vydávanie odznakov.';
$string['criteria_3'] = 'Sociálna účasť';
$string['criteria_3_help'] = 'Sociálne';
$string['criteria_4'] = 'Absolvovanie kurzu';
$string['criteria_4_help'] = 'Umožňuje udelenie odznaku používateľom, ktorí dokončili kurz. Toto kritérium môže mať ďalšie parametre, ako napríklad minimálny stupeň a dátum ukončenia kurzu.';
$string['criteria_5'] = 'Ukončenie množiny kurzov';
$string['criteria_5_help'] = 'Umožňuje udelenie odznaku používateľom, ktorí dokončili sériu kurzov. Každý kurz môže mať ďalšie parametre ako minimálnu známku, či dátum ukončenia kurzu.';
$string['criteria_6'] = 'Dokončenie profilu';
$string['criteria_6_help'] = 'Umožňuje udelenie odznaku používateľom za vyplnenie určitých polí v ich profile. Môžete vybrať z predvolených a vlastných profilov, ktoré sú k dispozícii používateľom.';
$string['criteria_7'] = 'Vydané odznaky';
$string['criteria_7_help'] = 'Umožňuje udelenie odznaku používateľom na základe ostatných získaných odznakov.';
$string['criteria_8'] = 'Členstvo v globálnych skupinách.';
$string['criteria_8_help'] = 'Umožňuje udelenie odznaku používateľom na základe členstva v globálnej skupine.';
$string['criteria_9'] = 'Kompetencie';
$string['criteria_9_help'] = 'Umožňuje používateľovi udeliť odznak na základe kompetencií, ktoré boli splnené.';
$string['criteria_descr'] = 'Používateľom sa udeľuje tento odznak, keď splnia nasledujúce požiadavky:';
$string['criteria_descr_0'] = 'Používateľom sa tento odznak udeľuje, keď splnia <strong>{$a}</strong> uvedených požiadaviek.';
$string['criteria_descr_1'] = '<strong> {$a} </strong> z nasledujúcich aktivít je dokončených:';
$string['criteria_descr_2'] = 'Tento odznak musia udeľovať používatelia  <strong> {$a} </strong> s uvedenými rolami:';
$string['criteria_descr_4'] = 'Používatelia musia dokončiť kurz';
$string['criteria_descr_5'] = 'Je potrebné dokončiť <strong> {$a} </strong> nasledujúcich kurzov:';
$string['criteria_descr_6'] = 'Musí byť vyplnených  <strong>{$a} </strong> nasledujúcich polí profilu používateľa:';
$string['criteria_descr_7'] = 'Je potrebné získať <strong>{$a}</strong> z nasledujúcich odznakov:';
$string['criteria_descr_8'] = 'Je požadované členstvo v <strong>{$a}</strong> nasledujúcich globálnych skupinách:';
$string['criteria_descr_9'] = 'Musí byť splnené <strong>{$a}</strong> nasledujúcich kompetencií:';
$string['criteria_descr_bydate'] = '&nbsp;do <em>{$a}</em>';
$string['criteria_descr_grade'] = '&nbsp;s minimálnym hodnotením <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Dokončené <strong>{$a}</strong> z:';
$string['criteria_descr_short1'] = 'Dokončené <strong>{$a}</strong> z:';
$string['criteria_descr_short2'] = 'Udelené <strong>{$a}</strong> z:';
$string['criteria_descr_short4'] = 'Dokončiť kurz';
$string['criteria_descr_short5'] = 'Dokončené <strong>{$a}</strong> z:';
$string['criteria_descr_short6'] = 'Dokončené <strong>{$a}</strong> z:';
$string['criteria_descr_short7'] = 'Splniť <strong>{$a}</strong> z:';
$string['criteria_descr_short8'] = 'Členstvo v globálnej skupine  <strong>{$a}</strong>  z:';
$string['criteria_descr_short9'] = 'Splnené <strong>{$a}</strong> z:';
$string['criteria_descr_single_1'] = 'Nasledujúca činnosť musí byť dokončená:';
$string['criteria_descr_single_2'] = 'Tento odznak udeľujú používatelia s niektorou z nasledujúcich rolí:';
$string['criteria_descr_single_4'] = 'Používatelia musia absolvovať kurz';
$string['criteria_descr_single_5'] = 'Nasledujúci kurz musí byť dokončený:';
$string['criteria_descr_single_6'] = 'Nasledujúce pole profilu je nutné vyplniť:';
$string['criteria_descr_single_7'] = 'Musí byť získaný nasledujúci odznak:';
$string['criteria_descr_single_8'] = 'Členstvo v nasledujúcej globálnej skupine je povinné:';
$string['criteria_descr_single_9'] = 'Musia byť splnené nasledujúce kompetencie:';
$string['criteria_descr_single_short1'] = 'Ukončené:';
$string['criteria_descr_single_short2'] = 'Udelené:';
$string['criteria_descr_single_short4'] = 'Absolvovať kurz';
$string['criteria_descr_single_short5'] = 'Ukončené:';
$string['criteria_descr_single_short6'] = 'Ukončené:';
$string['criteria_descr_single_short7'] = 'Ukončite:';
$string['criteria_descr_single_short8'] = 'Členstvo v:';
$string['criteria_descr_single_short9'] = 'Ukončené:';
$string['criteriacreated'] = 'Kritériá na udelenie odznaku boli úspešne vytvorené';
$string['criteriadeleted'] = 'Kritériá na udelenie odznaku boli zmazané';
$string['criteriasummary'] = 'Prehľad kritérií';
$string['criteriaupdated'] = 'Kritériá odznaku boli úspešne aktualizované';
$string['criterror'] = 'Aktuálne parametre vydania';
$string['criterror_help'] = 'Toto pole zobrazuje všetky parametre, ktoré boli pôvodne pridané k tejto požiadavke na odznak, ale už nie sú k dispozícii. Odporúča sa, aby ste tieto parametre zrušili  a aby ste sa uistili, že používatelia môžu v budúcnosti získať tento odznak.';
$string['currentimage'] = 'Aktuálny obrázok';
$string['currentstatus'] = 'Súčasný stav';
$string['dateawarded'] = 'Dátum vydania';
$string['dateearned'] = 'Dátum: {$a}';
$string['day'] = 'Dní';
$string['deactivate'] = 'Zakázať prístup';
$string['deactivatesuccess'] = 'Prístup k odznakom bol úspešne zakázaný.';
$string['defaultissuercontact'] = 'Emailová adresa vydavateľa odznaku';
$string['defaultissuercontact_desc'] = 'E-mailová adresa priradená k vydavateľovi odznaku. Pre zbierky Open Badges v2.0 sa používa pre overovanie pri publikovaní odznakov do zbierky.';
$string['defaultissuername'] = 'Názov vydavateľa odznaku';
$string['defaultissuername_desc'] = 'Meno vydávajúcej autority.';
$string['defaultissuerpassword'] = 'Heslo vydavateľa odznaku';
$string['defaultissuerpassword_help'] = 'Na stránke zbierky je vyžadovaný účet s e-mailovou adresou, ako je uvedené v nastavení e-mailovej adresy vydavateľa odznaku v nastavení Správa / Odznaky / Nastavenie odznakov. Tu by malo byť zadané heslo pre účet.';
$string['delbadge'] = 'Chcete odstrániť odznak „{$a}“ a odstrániť všetky existujúce vydané odznaky?';
$string['delconfirm'] = 'Zmažte a odstráňte existujúce vydané znaky';
$string['delcritconfirm'] = 'Naozaj chcete odstrániť toto kritérium?';
$string['deletehelp'] = '<p>Úplné odstránenie odznaku znamená, že všetky jeho informácie a záznamy kritérií budú natrvalo odstránené. Používatelia, ktorí získali tento odznak, už nebudú mať k nemu mať prístup a nebudú si ho mocť zobraziť ho na svojich profilových stránkach. </p>
<p> Poznámka: Používatelia, ktorí získali tento odznak a už ho pridali do svojho externého batohu, budú mať tento odznak vo svojom externom odznakovom batohu. Nebudú však mať prístup k kritériám a dôkazovým stránkam, ktoré odkazujú na túto webovú stránku. </p>';
$string['delexternalbackpack'] = 'Odstrániť zbierku na portáli';
$string['delexternalbackpackconfirm'] = 'Odstrániť zbierku na portáli  "{$a}"?';
$string['delparamconfirm'] = 'Naozaj chcete odstrániť tento parameter?';
$string['description'] = 'Opis';
$string['disconnect'] = 'Odpojiť';
$string['donotaward'] = 'Tento odznak momentálne nie je aktívny, takže ho nemožno udeliť používateľom. Ak chcete tento odznak udeliť, nastavte jeho stav na aktívny.';
$string['editsettings'] = 'Upravit nastavenia';
$string['enablebadges'] = 'Povoliť odznaky';
$string['endorsement'] = 'Schválenie';
$string['error:backpackdatainvalid'] = 'Vrátenie údajov z odznakového batohu bolo neplatné.';
$string['error:backpackemailnotfound'] = 'E-mail „{$a}“ nie je spojený s odznakovým batohom. Pre tento účet si musíte <a href="http://backpack.openbadges.org"> vytvoriť odznakový batoh </a> alebo sa prihlásiť pomocou inej e-mailovej adresy.';
$string['error:backpacknotavailable'] = 'Vaša stránka nie je prístupná z internetu, a teda odznaky z tejto stránky nemôžu byť overené externými odznakovými službami.';
$string['error:backpackproblem'] = 'Vyskytol sa problém s pripojením k vášmu poskytovateľovi služieb. Skúste prosím neskôr.';
$string['error:badgeawardnotfound'] = 'Tento udelený odznak nie je možné overiť -  odznak môže byť zrušený.';
$string['error:badgenotfound'] = 'Odznak nebol nájdený';
$string['error:cannotact'] = 'Nie je možné aktivovať odznak.';
$string['error:cannotawardbadge'] = 'Používateľovi nie je možné udeliť odznak.';
$string['error:cannotdeletecriterion'] = 'Toto kritérium nie je možné  vymazať.';
$string['error:cannotrevokebadge'] = 'Nie je možné odňať odznak  používateľovi.';
$string['error:clone'] = 'Odznak nie je možné klonovať.';
$string['error:connectionunknownreason'] = 'Spojenie bolo neúspešné, ale nebol uvedený žiadny dôvod prečo.';
$string['error:duplicatename'] = 'Odznak s takýmto menom už existuje v systéme.';
$string['error:externalbadgedoesntexist'] = 'Odznak nebol nájdený';
$string['error:guestuseraccess'] = 'Práve používate hosťovský prístup. Ak chcete zobraziť odznaky, musíte sa prihlásiť pomocou svojho používateľského účtu.';
$string['error:invalidcriteriatype'] = 'Neplatný typ kritérií.';
$string['error:invalidexpiredate'] = 'Dátum vypršania platnosti musí byť v budúcnosti.';
$string['error:invalidexpireperiod'] = 'Čas vypršania nemôže byť záporný alebo rovný 0.';
$string['error:invalidparambadge'] = 'Odznak neexistuje.';
$string['error:invalidparamcohort'] = 'Globálna skupina neexistuje.';
$string['error:noactivities'] = 'V tomto kurze nie sú žiadne aktivity so sledovaním plnenia činnosti';
$string['error:nobadges'] = 'V súčasnej dobe neexistujú žiadne odznaky s povoleným prístupom, ktoré by bolo možné pridať ako kritériá. Odznak portálu môže mať ako kritériá iba ďalšie odznaky portálu. Odznak kurzu môže mať ako kritériá ďalšie odznaky kurzu alebo odznaky portálu.';
$string['error:nocohorts'] = 'Žiadne globálne skupiny';
$string['error:nocourses'] = 'Ukončenie kurzu nie je povolené pre žiadny z kurzov na tejto stránke, takže nie je možné zobraziť žiadne ukončenie. Ukončenie kurzu sa povoľuje v nastaveniach kurzu.';
$string['error:nogroupslink'] = '<p>Zobrazia sa iba verejné kolekcie. <a href="{$a}" target="_blank" rel="nofollow">Navštívte svoju zbierku</a> a vytvorte nejakú verejnú kolekciu.</p>';
$string['error:nogroupssummary'] = '<p>Vo vašej zbierke nie sú žiadne verejné kolekcie odznakov. </p>';
$string['error:nopermissiontoview'] = 'Nemáte žiadne práva na zobrazenie príjemcov odznakov';
$string['error:nosuchbadge'] = 'Odznak s identifikátorom  {$a} neexistuje.';
$string['error:nosuchcohort'] = 'Upozornenie: Táto globálna skupina už nie je k dispozícii.';
$string['error:nosuchcourse'] = 'Upozornenie: Tento kurz už nie je k dispozícii.';
$string['error:nosuchfield'] = 'Upozornenie: Toto pole profilu používateľa už nie je k dispozícii.';
$string['error:nosuchmod'] = 'Upozornenie: Táto aktivita už nie je k dispozícii.';
$string['error:nosuchrole'] = 'Upozornenie: Táto rola už nie je k dispozícii';
$string['error:nosuchuser'] = 'Používateľ s touto emailovou adresou nemá účet u pripojeného poskytovateľa zbierky.';
$string['error:notifycoursedate'] = 'Upozornenie: Odznaky spojené s kurzom a dokončenými aktivitami nebudú vydané pred začiatkom kurzu.';
$string['error:parameter'] = 'Upozornenie: Pre hladký priebeh vydávania odznaku by mal byť vybraný aspoň jeden parameter.';
$string['error:relatedbadgedoesntexist'] = 'Neexistuje žiaden verejný odznak s týmto identifikátorom';
$string['error:requesterror'] = 'Žiadosť o pripojenie nebola úspešná (kód chyby {$a}).';
$string['error:requesttimeout'] = 'Žiadosť o pripojenie vypršala pred dokončením.';
$string['error:save'] = 'Odznak nie je možné uložiť';
$string['error:userdeleted'] = '{$a->user} (Tento používateľ v {$a->site} už neexistuje)';
$string['eventbadgearchived'] = 'Odznak bol archivovaný';
$string['eventbadgeawarded'] = 'Odznak bol udelený';
$string['eventbadgecreated'] = 'Odznak bol vytvorený';
$string['eventbadgecriteriacreated'] = 'Kritériá odznaku boli vytvorené';
$string['eventbadgecriteriadeleted'] = 'Kritériá odznaku boli odstránené';
$string['eventbadgecriteriaupdated'] = 'Kritériá odznaku boli aktualizované';
$string['eventbadgedeleted'] = 'Odznak bol odstránený';
$string['eventbadgedisabled'] = 'Odznak bol zakázaný';
$string['eventbadgeduplicated'] = 'Odznak bol skopírovaný';
$string['eventbadgeenabled'] = 'Odznak bol povolený';
$string['eventbadgelistingviewed'] = 'Zobrazený zoznam odznakov';
$string['eventbadgerevoked'] = 'Odznak bol zrušený';
$string['eventbadgeupdated'] = 'Odznak bol aktualizovaný';
$string['eventbadgeviewed'] = 'Odznak bol zobrazený';
$string['evidence'] = 'Evidencia';
$string['existingrecipients'] = 'Existujúci príjemcovia odznakov';
$string['existsinbackpack'] = 'Odznak už vo zbierke existuje';
$string['expired'] = 'Platnosť vypršala';
$string['expiredate'] = 'Platnosť odznaku vyprší {$a}.';
$string['expireddate'] = 'Platnosť odznaku vypršala {$a}.';
$string['expiredin'] = 'Platnosť vypršala {$a}.';
$string['expireperiod'] = 'Platnosť odznaku vyprší {$a} dní potom, ako bol vydaný.';
$string['expireperiodh'] = 'Platnosť odznaku vyprší {$a} hodín potom, ako bol vydaný.';
$string['expireperiodm'] = 'Platnosť odznaku vyprší {$a} minút potom, ako bol vydaný.';
$string['expireperiods'] = 'Platnosť odznaku vyprší {$a} sekúúnd potom, ako bol vydaný.';
$string['expiresin'] = 'Platnosť vyprší {$a}';
$string['expirydate'] = 'Dátum vypršania';
$string['expirydate_help'] = 'Voliteľne je možné platnosť odznakov ukončiť k určitému dátumu, alebo je možné dátum platnosti vypočítať na základe dátumu, kedy bol odznak používateľovi vydaný.';
$string['externalbadges'] = 'Moje odznaky z iných webových portálov';
$string['externalbadges_help'] = 'Táto oblasť obsahuje odznaky z externej zbierky.';
$string['externalbadgesp'] = 'Odznaky z iných webových portálov:';
$string['externalconnectto'] = 'Ak chcete zobraziť externé odznaky, musíte sa <a href="{$a}">pripojiť k zbierke</a>.';
$string['fixed'] = 'Pevný dátum';
$string['hidden'] = 'Skryté';
$string['hiddenbadge'] = 'Bohužiaľ, majiteľ odznaku nedal tieto informácie k dispozícii.';
$string['hostedurl'] = 'Externá URL';
$string['hostedurldescription'] = 'Externá URL, na ktorej je odznak umiestnený';
$string['imageauthoremail'] = 'Zobrazenie emailu autora';
$string['imageauthoremail_help'] = 'Ak je uvedená zobrazí sa emailová adresa autora obrázku odznaku na stránke s odznakom.';
$string['imageauthorname'] = 'Zobrazenie mena autora';
$string['imageauthorname_help'] = 'Ak je uvedené, zobrazí sa meno autora obrázku odznaku na stránke s odznakom.';
$string['imageauthorurl'] = 'Zobrazenie URL adresy autora';
$string['imageauthorurl_help'] = 'Ak je zadané, zobrazí sa na stránke s odznakom odkaz na webovú stránku autora obrázku odznaku. Adresa URL by mala mať predponu http:// alebo https://.';
$string['imagecaption'] = 'Titulné zobrazenie';
$string['imagecaption_help'] = 'Ak je zadané, zobrazí sa na stránke s odznakom nálepka obrázku.';
$string['includeauthdetails'] = 'Uveďte podrobnosti o autentizácii so zbierkou';
$string['invalidurl'] = 'Neplatná URL adresa';
$string['issuancedetails'] = 'Vypršanie platnosti';
$string['issuedbadge'] = 'Informácia o vydanom odznaku';
$string['issuedby'] = 'Vydal {$a}';
$string['issuedon'] = 'Vydané {$a}';
$string['issuerdetails'] = 'Detaily vydania';
$string['issueremail'] = 'Email';
$string['issueremail_help'] = 'Kontaktná emailová adresa organizácie, ktorá odznak schválila.';
$string['issuername'] = 'Meno vydavateľa';
$string['issuername_endorsement'] = 'Meno schvaľovateľa';
$string['issuername_endorsement_help'] = 'Meno schvaľovateľa';
$string['issuername_help'] = 'Meno vydavateľa odznaku';
$string['issuerurl'] = 'URL vydavateľa';
$string['issuerurl_help'] = 'Webová stránka organizácie, ktorá odznak schválila. Adresa URL by mala mať predponu http:// alebo https://.';
$string['language'] = 'Jazyk';
$string['language_help'] = 'Jazyk používaný na stránke s odznakmi';
$string['listbackpacks'] = 'Zoznam zbierok';
$string['localbadges'] = 'Moje odznaky z webu {$a}';
$string['localbadgesh'] = 'Moje odznaky z tohto webu';
$string['localbadgesh_help'] = 'Všetky odznaky získané na týchto stránkach vyplnením kurzov, kurzových aktivít a ďalších požiadaviek.

Svoje odznaky si môžete spravovať tu a zvrejniť ich na svojom profile.

Môžete si stiahnuť všetky vaše odznaky alebo každý odznak samostatne a uložiť ich do počítača. Stiahnuté odznaky môžu byť pridané do vašeho externého odznakového batoha.';
$string['localbadgesp'] = 'Odznaky od  {$a}:';
$string['localconnectto'] = 'Ak chcete zdieľať tieto odznaky mimo tohto portálu, web musíte sa <a href="{$a}"> pripojiť k zbierke</a>.';
$string['makeprivate'] = 'Nastaviť ako súkromné';
$string['makepublic'] = 'Zverejniť';
$string['managebackpacks'] = 'Spravovať zbierky';
$string['managebadges'] = 'Správa odznakov';
$string['message'] = 'Text správy';
$string['messagebody'] = '<p> Získali ste odznak "%badgename%"! </p>
<p> Viac informácií o tomto odznaku nájdete na informačnej stránke %badgelink% . </p>
<p> Váš odznak si môžete spravovať a prevziať zo stránky {$a}. </p>';
$string['messagesubject'] = 'Blahoželáme! Práve ste získali odznak!';
$string['method'] = 'Toto kritérium je splnené, keď ...';
$string['mingrade'] = 'Požadovaná minimálna známka';
$string['month'] = 'Mesiac(e)';
$string['moredetails'] = 'Viac informácií';
$string['mybackpack'] = 'Nastavenia mojej zbierky';
$string['mybadges'] = 'Moje odznaky';
$string['never'] = 'Nikdy';
$string['newbackpack'] = 'Pridať novú zbieku';
$string['newbadge'] = 'Pridať odznak';
$string['newimage'] = 'Nový obrázok';
$string['noalignment'] = 'Tento odznak nemá žiadne špecifikované zručnosti či štandardy.';
$string['noawards'] = 'Tento odznak ešte nebol získaný.';
$string['nobackpack'] = 'K tomuto účtu nie je pripojená žiadna služba odznakového batohu. <br/>';
$string['nobackpackbadgessummary'] = 'Vo vybraných zbierkach nie sú žiadne odznaky.';
$string['nobackpackcollectionssummary'] = 'Neboli vybrané žiadne kolekcie odznakov.';
$string['nobackpacks'] = 'Nie sú k dispozícii žiadne zbierky';
$string['nobadges'] = 'V súčasnej dobe nie sú k dispozícii žiadne odznaky, ktoré by používatelia mohli získať.';
$string['nocompetencies'] = 'Neboli vybrané žiadne kompetencie.';
$string['nocriteria'] = 'Kritériá pre tento odznak ešte neboli nastavené.';
$string['noendorsement'] = 'Tento odznak nemá podporu.';
$string['noexpiry'] = 'Tento odznak nemá dátum skončenia platnosti.';
$string['noparamstoadd'] = 'K požiadavke na tento odznak nie sú k dispozícii žiadne ďalšie parametre.';
$string['norelated'] = 'Tento odznak nemá žiadne súvisiace odznaky.';
$string['notacceptedrole'] = 'Vaša súčasná rola nie je medzi rolami, ktoré môžu manuálne vydávať tento odznak. <br/> Ak chcete vidieť používateľov, ktorí tento odznak už získali, navštívte stránku {$a} .';
$string['notconnected'] = 'Nepripojené';
$string['notealignment'] = 'Môžu byť špecifikované externé kompetencie, zručnosti alebo normy, na ktoré sa odznak vzťahuje. Všetky externé kompetencie sú zobrazené na stránke s odznakom.';
$string['noteendorsement'] = 'Na pridanie hodnoty do odznaku sa môže použiť potvrdenie tretej strany. Napríklad škola môže schváliť odznak vydaný učiteľom, alebo národný orgán môže potvrdiť odznak vydaný miestnym vydávateľom.';
$string['noterelated'] = 'Odznaky s pripojením môžu byť označené ako súvisiace. Napríklad odznaky s rovnakými kritériami, ktoré sú zobrazené v rôznych jazykoch, môžu byť označené ako súvisiace. Všetky súvisiace odznaky sa zobrazia na stránke odznaku.';
$string['nothingtoadd'] = 'Neexistujú žiadne dostupné kritériá na pridanie.';
$string['notification'] = 'Upozorniť tvorcu odznaku';
$string['notification_help'] = 'Upozorniť správou tvorcu odznaku, ak je odznak udelený. Môžete si zvoliť, ako často bude notifikácia odoslaná.

* Nikdy - Neposielať žiadne upozornenia.
* Vždy - Vždy, keď je odznak udelený.
* Denne - Súhrnná správa raz za deň.
* Týždenne - Súhrnná správa raz za týždeň.
* Mesačne - Súhrnná správa raz za mesiac.';
$string['notifydaily'] = 'Denne';
$string['notifyevery'] = 'Vždy';
$string['notifymonthly'] = 'Mesačne';
$string['notifyweekly'] = 'Týždenne';
$string['numawards'] = 'Tento odznak bol udelený používateľom <a href="{$a->link}"> {$a->count} </a>.';
$string['numawardstat'] = 'Tento odznak bol vydaný {$a} používateľom.';
$string['oauth2issuer'] = 'Služby OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Iná navigácia ...';
$string['overallcrit'] = 'z vybraných kritérií sú ukončené.';
$string['potentialrecipients'] = 'Potenciálni príjemcovia odznaku';
$string['preferences'] = 'Nastavenie odznakov';
$string['privacy:metadata:backpack'] = 'Záznam zbierky odznakov používateľa';
$string['privacy:metadata:backpack:backpackuid'] = 'Jedinečný identifikátor batohu odznakov';
$string['privacy:metadata:backpack:email'] = 'E-mail spojený s batohom odznakov';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID zbierky';
$string['privacy:metadata:backpack:userid'] = 'ID používateľa, vlastníka zbierky odznakov';
$string['privacy:metadata:backpackoauth2'] = 'Informácia OAuth2, keď sa používateľ pripojí k externej zbierke';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID služby OAuth2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Zoznam rozsahu pripojenia zbierky';
$string['privacy:metadata:backpackoauth2:token'] = 'Token pripojenia zbierky';
$string['privacy:metadata:backpackoauth2:userid'] = 'ID pripojenia používateľa ku zbierke';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ID používateľa, ktorý upravil pripojenie';
$string['privacy:metadata:badge'] = 'Zbierka odznakov';
$string['privacy:metadata:badge:timecreated'] = 'Čas vytvorenia odznaku';
$string['privacy:metadata:badge:timemodified'] = 'Čas úpravy odznaku';
$string['privacy:metadata:badge:usercreated'] = 'ID používateľa, ktorý odznak vytvoril';
$string['privacy:metadata:badge:usermodified'] = 'ID používateľa, ktorý odznak upravil';
$string['privacy:metadata:criteriamet'] = 'Súbor kritérií, ktoré boli splnené';
$string['privacy:metadata:criteriamet:datemet'] = 'Dátum splnenia kritérií';
$string['privacy:metadata:criteriamet:userid'] = 'ID používateľa, ktorý splnil kritériá';
$string['privacy:metadata:external:backpacks'] = 'Zdieľané informácie, keď používatelia odosielajú svoje odznaky do externej zbierky odznakov';
$string['privacy:metadata:external:backpacks:badge'] = 'Názov odznaku';
$string['privacy:metadata:external:backpacks:description'] = 'Opis odznaku';
$string['privacy:metadata:external:backpacks:image'] = 'Obrázok odznaku';
$string['privacy:metadata:external:backpacks:issuer'] = 'Niektoré informácie o vydavateľovi';
$string['privacy:metadata:external:backpacks:url'] = 'Adresa URL Moodle, na ktorej je možné vidieť informácie o vydanom odznaku';
$string['privacy:metadata:issued'] = 'Záznam udelených odznakov';
$string['privacy:metadata:issued:dateexpire'] = 'Dátum skončenia platnosti odznaku';
$string['privacy:metadata:issued:dateissued'] = 'Dátum udelenia';
$string['privacy:metadata:issued:userid'] = 'ID používateľa, ktorému bol udelený odznak';
$string['privacy:metadata:manualaward'] = 'Záznam manuálnych udelení odznakov';
$string['privacy:metadata:manualaward:datemet'] = 'Dátum, kedy bol používateľovi udelený odznak';
$string['privacy:metadata:manualaward:issuerid'] = 'ID používateľa, ktorý udeľuje odznak';
$string['privacy:metadata:manualaward:issuerrole'] = 'Rola používateľa, ktorý udeľuje odznak';
$string['privacy:metadata:manualaward:recipientid'] = 'Identifikátor používateľa, ktorému bol ručne udelený  odznak';
$string['recipientdetails'] = 'Podrobnosti o príjemcovi';
$string['recipientidentificationproblem'] = 'Medzi existujúcimi používateľmi nie je možné nájsť príjemcu tohto odznaku.';
$string['recipients'] = 'Príjemcovia odznaku';
$string['recipientvalidationproblem'] = 'Aktuálneho používateľa nemožno overiť ako príjemcu tohto odznaku.';
$string['relatedbages'] = 'Súvisiace odznaky';
$string['relative'] = 'Relatívny dátum';
$string['requiredbadge'] = 'Do kritéria odznaku by mal byť pridaný aspoň jeden odznak.';
$string['requiredcohort'] = 'Do kritéria globálnej skupiny by mala byť pridaná aspoň jedna globálna skupina.';
$string['requiredcompetency'] = 'Ku kompetencii by malo byť pridané aspoň jedno kritérium kompetencie.';
$string['requiredcourse'] = 'Do kritéria sady kurzov musí byť pridaný aspoň jeden kurz.';
$string['reviewbadge'] = 'Zmeny v prístupe k odznaku';
$string['reviewconfirm'] = '<p> To umožní, aby vaše odznaky pre užívateľov boli viditeľné a umožní im začať získavanie. </p>
<p> Je možné, že niektorí používatelia už spĺňajú kritériá získania odznaku a tento odznak bude udelený ihneď potom, čo ho povolíte. </p>
<p> Hneď ako bude odznak udelený, bude <strong> zamknutý</strong>. - niektoré nastavenia vrátane kritérií a nastavenia platnosti už nie je možné zmeniť </p>
<p> Ste si istí, že chcete odznak "{$a}" sprístupniť? </p>';
$string['revoke'] = 'Zrušiť odznak';
$string['save'] = 'Uložiť';
$string['searchname'] = 'Vyhľadať podľa mena';
$string['selectaward'] = 'Vyberte rolu, ktorú chcete použiť na prideľovanie tohto odznaku:';
$string['selectgroup_end'] = 'Sú zobrazené iba verejné kolekcie. <a href="{$a}">Navštívte vašu zbierku</a> a vytvorte ďalšie verejné kolekcie.';
$string['selectgroup_start'] = 'Vyberte odznaky z Vášho batohu, aby sa zobrazili na tejto stránke:';
$string['selecting'] = 'S vybratými odznakmi ...';
$string['setup'] = 'Nastaviť pripojenie';
$string['sitebackpack'] = 'Aktívna externá zbierka';
$string['sitebackpack_help'] = 'Externá zbierka, ku ktorej sa môžu používatelia pripojiť z tohto portálu. Všimnite si, že zmena tohto nastavenia potom, čo používatelia pripojili svoje zbierky, bude vyžadovať, aby každý používateľ išiel na stránku nastavenia zbierky a odpojil a znova sa pripojil.';
$string['sitebackpackdeleted'] = 'Zbierka na portáli bola odstránená.';
$string['sitebackpacknotdeleted'] = 'Nie je možné odstrániť túto zbierku, pretože je aktuálne na portáli východzia.';
$string['sitebackpackverify'] = 'Pripojenie zbierky';
$string['sitebackpackwarning'] = 'Nie je možné sa pripojiť k zbierke.<br/><br/>Skontrolujte, či je nastavená "E-mailová adresa vydavateľa odznaku" s platným e-mailom pre účet na portáli zbierky. <br/><br/>Skontrolujte, či je "Heslo vydavateľa odznaku" na stránke <a href="{$a->url}"> nastavené odznaku správne heslo účtu na portáli vydavateľa zvierky. <br/><br/>Zbierka vrátila: "{$a->warning}"';
$string['sitebadges'] = 'Stránky odznaky';
$string['sitebadges_help'] = 'Odznaky na stránkach môžu byť udelené len používateľom za aktivity v lokálnych systémoch. Patrí medzi ne absolvovanie množiny kurzov alebo častí užívateľských profilov. Stránky odznakov môžu byť tiež vydané ručne jedným užívateľom na druhého.

Odznaky pre aktivity súvisiace s kurzom musia byť vytvorené na úrovni kurzu. Odznaky kurzov nájdete v časti Správa kurzu> Odznaky.';
$string['sitebadgetitle'] = 'webu odznaku {$a}';
$string['status'] = 'Stav odznaku';
$string['status_help'] = 'Stav odznaku určuje jeho správanie v systéme:

**DOSTUPNÝ** - znamená, že tento odznak môže byť získaný študentom. Ak je odznak v stave Dostupný, nemôžu byť jeho vlastnosti menené.

**NEDOSTUPNÝ** znamená, že tento odznak nie je študentom dostupný a nemôžu ho získať ani ručným priradením. Pokiaľ tento odznak ešte nebol v minulosti niektorým zo študentov získaný, je možné jeho vlastnosti meniť.

Pokiaľ bol však odznak už v minulosti niekomu udelený, automaticky sa **ZAMKNE**. Zamknuté odznaky stále môžu byť získané alebo udelené študentom, ale už sa nedajú vlastnosti odznaku meniť. Ak tak chcete upraviť vlastnosti pri zamknutom odznaku, je potrebné odznaku zduplikovať a vykonávať požadované zmeny na duplikáte.

*Prečo odznaky zamykáme?*

Chceme sa uistiť, že všetci študenti, ktorí odznak získajú, musia splniť tie isté podmienky. Ak by sme odznaky nezamykali, mohli by sa neustále meniť ich vlastnosti a podmienky na získanie. Nakoniec by sme tu mali študentov, ktorí síce majú rovnaký odznak, avšak na jeho získanie museli splniť úplne odlišné podmienky.';
$string['statusmessage_0'] = 'Tento odznak momentálne nie je k dispozícii používateľom. Povoľte prístup, ak chcete, aby používatelia mohli získavať tento odznak.';
$string['statusmessage_1'] = 'Tento odznak je momentálne k dispozícii používateľom. Zakázať prístup na vykonanie zmien.';
$string['statusmessage_2'] = 'Tento odznak momentálne nie je k dispozícii používateľom a kritériá pre jeho vydanie  sú zamknuté. Povolte prístup, ak chcete, aby používatelia mohli získavať tento odznak.';
$string['statusmessage_3'] = 'Tento odznak je momentálne k dispozícii používateľom a kritériá na udelenie odznaku sú zamknuté.';
$string['statusmessage_4'] = 'Tento odznak je momentálne archivovaný.';
$string['subject'] = 'Predmet správy';
$string['targetcode'] = 'Kód';
$string['targetcode_help'] = 'Jedinečný identifikátor reťazca na odkazovanie na externú zručnosť alebo štandard v jeho rámci.';
$string['targetdescription'] = 'Opis';
$string['targetdescription_help'] = 'Stručný opis externej zručnosti alebo štandardu.';
$string['targetframework'] = 'Rámec';
$string['targetframework_help'] = 'Názov rámca externej zručnosti alebo normy.';
$string['targetname'] = 'Názov';
$string['targetname_help'] = 'Kompetencia, zručnosť alebo štandard, vztiahnutá odznakom.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Odkaz na stránku opisujúcu kompetenciu, zručnosť alebo štandard. Adresa URL by mala mať predponu http:// alebo https://.';
$string['testbackpack'] = 'Vyskúšajte zbierku "{$a}"';
$string['testsettings'] = 'Test nastavení';
$string['type'] = 'Typ';
$string['variablesubstitution'] = 'Premenné v správach.';
$string['variablesubstitution_help'] = 'V správe s odznakom môžu byť určité premenné vložené do predmetu a/alebo do tela správy tak, aby boli pri odoslaní správy nahradené reálnymi hodnotami. Premenné by sa mali vložiť do textu presne tak, ako sú uvedené nižšie. Môžu byť použité nasledujúce premenné:

%badgename%
: Toto bude nahradené celým menom odznaku.

%username%
: Toto bude nahradené celým menom príjemcu.

%badgelink%
: Toto bude nahradené verejnou URL s informáciou o vydanom odznaku.';
$string['version'] = 'Verzia';
$string['version_help'] = 'Pole verzie môže byť použité na sledovanie vývoja odznaku. Ak je povolené, verzia odznaku sa zobrazí na stránke odznaku.';
$string['viewbadge'] = 'Zobraziť vydaný odznak';
$string['visible'] = 'Viditeľný';
$string['warnexpired'] = '(Platnosť tohto odznaku vypršala!)';
$string['year'] = 'Rok (y)';
