<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlecloudsignup', language 'es', version '4.0'.
 *
 * @package     local_moodlecloudsignup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['FOSUserBundle:change_password.flash.success'] = 'La contraseña ha sido cambiada';
$string['FOSUserBundle:change_password.submit'] = 'Cambiar contraseña';
$string['FOSUserBundle:form.current_password'] = 'Contraseña actual:';
$string['FOSUserBundle:form.email'] = 'Email:';
$string['FOSUserBundle:form.group_name'] = 'Nombre del grupo:';
$string['FOSUserBundle:form.new_password'] = 'Nueva contraseña:';
$string['FOSUserBundle:form.new_password_confirmation'] = 'Repetir nueva contraseña:';
$string['FOSUserBundle:form.password'] = 'Contraseña:';
$string['FOSUserBundle:form.password_confirmation'] = 'Repetir contraseña:';
$string['FOSUserBundle:form.username'] = 'Nombre de usuario:';
$string['FOSUserBundle:group.edit.submit'] = 'Actualizar grupo';
$string['FOSUserBundle:group.flash.created'] = 'El grupo ha sido creado';
$string['FOSUserBundle:group.flash.deleted'] = 'El grupo ha sido borrado';
$string['FOSUserBundle:group.flash.updated'] = 'El grupo ha sido actualizado';
$string['FOSUserBundle:group.new.submit'] = 'Crear grupo';
$string['FOSUserBundle:group.show.name'] = 'Nombre del grupo';
$string['FOSUserBundle:layout.logged_in_as'] = 'Identificado como %username%';
$string['FOSUserBundle:layout.login'] = 'Entrar';
$string['FOSUserBundle:layout.logout'] = 'Salir';
$string['FOSUserBundle:layout.register'] = 'Registro';
$string['FOSUserBundle:profile.edit.submit'] = 'Actualización';
$string['FOSUserBundle:profile.flash.updated'] = 'El perfil ha sido actualizado';
$string['FOSUserBundle:profile.show.email'] = 'Email';
$string['FOSUserBundle:profile.show.username'] = 'Nombre de usuario';
$string['FOSUserBundle:registration.back'] = 'Volver a la página inicial.';
$string['FOSUserBundle:registration.check_email'] = 'Un email ha sido enviado a %email%. Contiene un enlace de activación que debes seguir para activar tu cuenta.';
$string['FOSUserBundle:registration.confirmed'] = 'Enhorabuena %username%, tu cuenta está ahora activada.';
$string['FOSUserBundle:registration.email.message'] = 'Hola %username%!

Para finalizar la activación de tu cuenta - por favor visita %confirmationUrl%

Saludos,
el Equipo.';
$string['FOSUserBundle:registration.email.subject'] = 'Bienvenido %username%!';
$string['FOSUserBundle:registration.flash.user_created'] = 'El usuario se ha creado correctamente';
$string['FOSUserBundle:registration.submit'] = 'Registrar';
$string['FOSUserBundle:resetting.check_email'] = 'Un email ha sido enviado a %email%. Contiene un enlace de activación que debes pulsar para restablecer tu contraseña.';
$string['FOSUserBundle:resetting.email.message'] = 'Hola %username%!

Para restablecer tu contraseña - por favor visita %confirmationUrl%

Saludos,
el Equipo.';
$string['FOSUserBundle:resetting.email.subject'] = 'Restablecer contraseña';
$string['FOSUserBundle:resetting.flash.success'] = 'La contraseña se ha restablecido correctamente';
$string['FOSUserBundle:resetting.password_already_requested'] = 'La contraseña para este usuario ya ha sido solicitada dentro de las últimas 24 horas.';
$string['FOSUserBundle:resetting.request.invalid_username'] = 'El nombre de usuario o dirección de correo electrónico %username% no existe.';
$string['FOSUserBundle:resetting.request.submit'] = 'Restablecer contraseña';
$string['FOSUserBundle:resetting.request.username'] = 'Nombre de usuario o dirección de correo electrónico:';
$string['FOSUserBundle:resetting.reset.submit'] = 'Cambiar contraseña';
$string['FOSUserBundle:security.login.password'] = 'Contraseña:';
$string['FOSUserBundle:security.login.remember_me'] = 'Recordarme';
$string['FOSUserBundle:security.login.submit'] = 'Iniciar sesión';
$string['FOSUserBundle:security.login.username'] = 'Nombre de usuario:';
$string['homepage:Table.activities'] = 'Actividades ilimitadas';
$string['homepage:Table.annualprice'] = 'Precio anual*';
$string['homepage:Table.button'] = 'Registrarse';
$string['homepage:Table.conferencing'] = 'Videoconferencia';
$string['homepage:Table.gb'] = '%limit% Gb';
$string['homepage:Table.mb'] = '%limit% Mb';
$string['homepage:Table.noplugins'] = 'Sin paquete extra de plugins';
$string['homepage:Table.notheme'] = 'Sin temas avanzados';
$string['homepage:Table.plugins'] = 'Paquete extra de plugins';
$string['homepage:Table.theme'] = 'Tema avanzado';
$string['homepage:Table.uptodate'] = 'Siempre actualizado';
$string['homepage:body.intro'] = 'de la gente que hace Moodle';
$string['homepage:general.faq'] = 'FAQ';
$string['homepage:general.servicestatus'] = 'Estado del servicio';
$string['homepage:needmore'] = '¿Necesitas un plan más grande?<a href="https://moodle.com/contact">Contacta con nosotros</a>.';
$string['homepage:notfound.badnews'] = 'Las malas noticias son que el sitio que estas buscando no existe - ha sido borrado o aún no está en línea.';
$string['homepage:notfound.button'] = 'Regístrate y consigue este sitio.';
$string['homepage:notfound.goodnews'] = 'Las buenas noticias son que el sitio está disponible y lo puedes conseguir';
$string['homepage:notfound.title'] = 'Tenemos buenas y malas noticias';
$string['homepage:page.description'] = 'Las soluciones de alojamiento Moodle que proporciona Moodle están disponibles para que cualquiera ejecute el software de aprendizaje en la nube';
$string['homepage:page.title'] = 'MoodleCloud: Servicios de Alojamiento Gratuito de los creadores de Moodle';
$string['homepage:plans.free.description'] = 'Para clases individuales o sólo para probar Moodle';
$string['homepage:plans.free.name'] = 'Moodle Gratis';
$string['homepage:plans.free.plan_free'] = 'Gratis';
$string['homepage:plans.school1.description'] = 'Ideal para varias clases';
$string['homepage:plans.school1.name'] = 'Moodle para el Colegio';
$string['homepage:plans.school1.plan_idmedium'] = 'Medio';
$string['homepage:plans.school1.plan_idsmall'] = 'Pequeño';
$string['homepage:plans.school1.plan_tiny'] = 'Diminuto';
$string['homepage:sitelimit'] = '** Limitado a uno por cliente';
$string['langconfig:langname'] = 'Inglés';
$string['login:brandname'] = 'MoodleCloud';
$string['login:gotoportal'] = 'Ir al Portal';
$string['login:logout'] = 'Cerrar sesión';
$string['login:security.login.password'] = 'Contraseña';
$string['login:security.login.password_placeholder'] = 'Contraseña';
$string['login:security.login.submit'] = 'Iniciar sesión';
$string['login:security.login.username'] = 'Nombre del sitio MoodleCloud';
$string['pluginname'] = 'Registro MoodleCloud y Portal';
$string['portal:graphs.filetypes.audio'] = 'Audio';
$string['portal:graphs.filetypes.example'] = 'Ejemplo';
$string['portal:graphs.filetypes.image'] = 'Imágenes';
$string['portal:graphs.filetypes.message'] = 'Mensajes';
$string['portal:graphs.filetypes.model'] = 'Modelos';
$string['portal:graphs.filetypes.multipart'] = 'Elementos multiparte';
$string['portal:graphs.filetypes.text'] = 'Texto';
$string['portal:graphs.filetypes.video'] = 'Vídeos';
$string['portal:historical.fetchfailure.lead'] = 'Lo siento, no pudimos recuperar tu información histórica.Si vuelves más tarde puede que tengamos algo para ti.';
$string['portal:historical.fetchfailure.title'] = '¡Oh no!';
$string['portal:list.body.title'] = 'Portal';
$string['portal:list.table.titles.location'] = 'Ubicación';
$string['portal:list.table.titles.package'] = 'Paquete';
$string['portal:list.table.titles.site'] = 'Sitio';
$string['portal:list.table.titles.subdomain'] = 'Subdominio';
$string['portal:messages.csrffailure'] = 'Imposible confirmar los cambios. Por favor inténtalo de nuevo.';
$string['portal:messages.pendingprovision'] = '<span class="mc-spin glyphicon glyphicon-refresh"></span> Este sitio todavía está siendo creado. Por favor espera, pronto estará en línea.';
$string['portal:messages.removalfailed'] = 'La eliminación falló. Se ha notificado al soporte de MoodleCloud. Por favor inténtalo de nuevo más tarde.';
$string['portal:messages.removalqueued'] = 'En cola para su borrado.';
$string['portal:messages.sitenotfound'] = 'El sitio no pudo ser cargado. Por favor inténtalo de nuevo.';
$string['portal:page.body.title'] = 'Portal';
$string['portal:page.button'] = 'Obtener otro sitio';
$string['portal:page.tabs.billing'] = 'Facturación';
$string['portal:page.tabs.package'] = 'Paquete';
$string['portal:page.tabs.paymentdetails'] = 'Detalles de pago';
$string['portal:page.tabs.statistics'] = 'Estadísticas';
$string['portal:page.tabs.support'] = 'Soporte';
$string['portal:page.tabs.tools'] = 'Herramientas';
$string['portal:page.title'] = 'MoodleCloud: Portal';
$string['portal:plans.plans.MCFREE.cost'] = 'Gratis';
$string['portal:plans.plans.MCFREE.invoicetitle'] = 'Add-ons para el Alojamiento Gratuito MoodleCloud';
$string['portal:plans.plans.MCFREE.invoicetitleurl'] = 'Add-ons para el Alojamiento Gratuito MoodleCloud en %url%';
$string['portal:plans.plans.MCSCHOOL.invoicetitle'] = 'Moodle para la Escuela';
$string['portal:plans.plans.MCSCHOOL.title'] = 'Moodle para la Escuela';
$string['portal:plans.strings.plan'] = 'Plan';
$string['portal:purchases.confirmationpage.cancel'] = 'No gracias';
$string['portal:purchases.confirmationpage.continue'] = 'Pagar ahora';
$string['portal:purchases.confirmationpage.lead'] = 'Estás comprando:';
$string['portal:purchases.confirmationpage.paymentnotice'] = 'Se te cargará esta cantidad hoy, y este día o alrededor del día %dayofmonth%  de cada mes hasta que quites este add-on.';
$string['portal:purchases.confirmationpage.title'] = 'Confirmación del método de pago';
$string['portal:siteinfo.page.title'] = 'Información del sitio para %subdomain%';
$string['portal:siteinfo.panels.historical.title'] = 'Histórico de estadísticas';
$string['portal:siteinfo.panels.info.limit_disk'] = '%maxbytes% Mb de espacio de disco';
$string['portal:siteinfo.panels.info.limit_users'] = '%maxusers% usuarios';
$string['portal:siteinfo.panels.info.limits'] = 'Límites';
$string['portal:siteinfo.panels.info.location'] = 'Localización del alojamiento';
$string['portal:siteinfo.panels.info.package'] = 'Paquete';
$string['portal:siteinfo.panels.info.sitename'] = 'Nombre del sitio';
$string['portal:siteinfo.panels.info.status'] = 'Estado';
$string['portal:siteinfo.panels.info.title'] = 'Información';
$string['portal:siteinfo.panels.info.version'] = 'Versión';
$string['portal:siteinfo.panels.statistics.title'] = 'Estadísticas';
$string['portal:statistics.fetchfailure.lead'] = 'Lo siento, no hemos podido obtener tus estadísticas actuales. Si regresas más tarde, podríamos tenerlas listas para tí.';
$string['portal:statistics.fetchfailure.title'] = '¡Oh no!';
$string['portal:statistics.graphs.databasesize'] = 'Tamaño de base de datos';
$string['portal:statistics.graphs.files'] = 'Ficheros';
$string['portal:statistics.graphs.users'] = 'Usuarios';
$string['portal:support.certifiedpartner'] = 'Tu Partner Moodle local es:';
$string['portal:support.contact.button'] = 'Contactar ahora';
$string['portal:support.contact.flash'] = 'Tu petición ha sido enviada, ¡gracias!';
$string['portal:support.contact.sendbutton'] = 'Enviar consulta';
$string['portal:support.title'] = '¿Necesitas ayuda con tu sitio Moodle?';
$string['portal:view.danger.modal.buttons.cancel'] = '¡No, ha sido una completa confusión!';
$string['portal:view.danger.modal.buttons.continue'] = 'Sí, de verdad. Borrar mi sitio MoodleCloud';
$string['portal:view.danger.modal.lead'] = 'Al confirmar abajo, estás confirmando que ya has obtenido todo el contenido, y aceptas que tu sitio será permanentemente borrado de nuestros sistemas.';
$string['portal:view.danger.modal.title'] = 'Confirmar borrado';
$string['portal:view.danger.panel.body.buttons.remove'] = 'Borrar mi sitio de MoodleCloud';
$string['portal:view.danger.panel.body.lead'] = '<p>Una vez que borres este sitio MoodleCloud, este realmente desaparecerá.</p>
<p>Por favor, asegurate de que has terminado con él y que has obtenido y puesto a salvo cualquier contenido que puedas necesitar.</p>';
$string['portal:view.danger.panel.body.title'] = 'Borrar mi sitio de MoodleCloud';
$string['portal:view.danger.panel.title'] = 'Cosas peligrosas';
$string['signup:authcode.body.title'] = 'Confirma tu número de teléfono.';
$string['signup:authcode.form.fields.authcode'] = 'Código de verificación';
$string['signup:authcode.form.fields.continue'] = 'Continuar';
$string['signup:authcode.form.placeholders.authcode'] = '123456';
$string['signup:errors.blacklistinline'] = 'Lo siento, este sitio no está disponible.';
$string['signup:errors.invalidinline'] = 'Lo siento, los nombres de los sitios deben tener entre 3 y 53 caracteres y únicamente pueden estar compuestos de letras (a-z), números y guiones.';
$string['signup:errors.maxsites'] = 'Ya existe una cuenta de usuario con ese número de teléfono. Los usuarios únicamente pueden crear un sitio MoodleCloud.';
$string['signup:errors.reserved'] = '¡Oh no! Alguien ya ha registrado este nombre.';
$string['signup:messages.failedvalidationcode'] = 'Algo no está del todo bien. ¿La has introducido correctamente?';
$string['signup:messages.passwordupdated'] = '¡Genial! Hemos actualizado tu contraseña. Puedes utilizarla para acceder a tu sitio MoodleCloud.';
$string['signup:messages.validationcode'] = '¡Hola desde MoodleCloud!  Para completar el proceso de configuración de %subdomain%.moodlecloud.com utiliza este código de verificación:  %code%';
$string['signup:page.description'] = 'Software de aprendizaje gratuito Moodle alojado en servidores en la nube para que profesores e instructores desplieguen sitios Moodle en un instante';
$string['signup:page.title'] = 'MoodleCloud: Registro para Alojamiento Moodle gratuito';
$string['signup:password.body.title'] = 'Por último, ¡indica tu contraseña!';
$string['signup:password.form.fields.password'] = 'Nueva contraseña';
$string['signup:password.form.fields.password_confirmation'] = 'Y otra vez, solo para estar seguros';
$string['signup:password.form.fields.save'] = 'Guardar contraseña';
$string['signup:personal.body.lead'] = 'Únicamente necesitamos saber quién eres y estar seguros de que aceptas nuestras Condiciones de Servicio.';
$string['signup:personal.body.title'] = '¡Tu sitio está disponible!';
$string['signup:personal.form.fields.continue'] = 'Continuar';
$string['signup:personal.form.fields.email'] = 'Correo electrónico';
$string['signup:personal.form.fields.firstname'] = 'Nombre';
$string['signup:personal.form.fields.lastname'] = 'Apellido(s)';
$string['signup:personal.form.fields.phonenumber'] = 'Teléfono móvil';
$string['signup:personal.form.fields.tandc'] = 'Para continuar, primero tienes que aceptar nuestras Condiciones de Servicio.';
$string['signup:personal.form.fields.timezone'] = 'Zona horaria';
$string['signup:personal.form.placeholders.timezone'] = 'Selecciona la zona horaria';
$string['signup:provision_mail.page.html'] = '<h1>¡Bienvenido a MoodleCloud!</h1>
<p>Tu sitio Moodle gratuito <a href="%url%">%url%</a> ha sido creado.</p>
<p>Puedes acceder a tu sitio Moodle utilizando el nombre de usuario "admin" y la contraseña que configuraste durante el registro.</p>
<p>Tu sitio gratuito está limitado a 50 usuarios activos por cuenta y a 200Mb de espacio en disco.</p>
<p>Consejos:</p>
<ul>
<li>Puedes eliminar usuarios no deseados desde la Administración de Sitio dejando espacio para más.</li>
<li>Para evitar tener contenido reduciendo tu espacio disponible, utiliza recursos públicos que están disponibles en la red, como páginas web, videos de Youtube y similares.</li>
</ul>
<p>Para monitorizar tu uso, en cualquier momento puedes visitar tu portal MoodleCloud en moodlecloud.com. Accede utilizando el nombre de tu sitio "%subdomain%" y la misma contraseña que la de la cuenta "admin" de tu sitio.</p>
<p>Saludos,</p>
<p>El equipo MoodleCloud</p>';
$string['signup:provision_mail.page.plain'] = '¡Bienvenido a MoodleCloud!
Tu sitio Moodle gratuito <a href="%url%">%url%</a> ha sido creado.
Puedes acceder a tu sitio Moodle utilizando el nombre de usuario "admin" y la contraseña que configuraste durante el registro.
Tu sitio gratuito está limitado a 50 usuarios activos por cuenta y a 200Mb de espacio en disco.
Consejos:
  - Puedes eliminar usuarios no deseados desde la Administración de Sitio dejando espacio para más.
  - Para evitar tener contenido reduciendo tu espacio disponible, utiliza recursos públicos que están disponibles en la red, como páginas web, videos de Youtube y similares.

Para monitorizar tu uso, en cualquier momento puedes visitar tu portal MoodleCloud en moodlecloud.com. Accede utilizando el nombre de tu sitio "%subdomain%" y la misma contraseña que la de la cuenta "admin" de tu sitio.

Saludos,
El equipo MoodleCloud';
$string['signup:provision_mail.page.title'] = '¡Tu sitio MoodleCloud %fqdn% está preparado!';
$string['signup:provision_mail.subject'] = '¡Tu sitio MoodleCloud %site.fqdn% está preparado!';
$string['signup:reserve.available'] = '!Hurra! El nombre de tu sitio está disponible.';
$string['signup:reserve.body.lead'] = 'Elige un nombre único para tu sitio y selecciona una localización (en ella es donde tu sitio será alojado, así que te recomendamos que elijas la más próxima a tí y tus estudiantes).';
$string['signup:reserve.body.title'] = '¡Tu sitio MoodleCloud está a solo unos clicks de distancia!';
$string['signup:reserve.form.fields.continue'] = 'Obtener mi sitio';
$string['signup:reserve.form.fields.region'] = 'Localización';
$string['signup:reserve.form.fields.subdomain'] = 'Nombre del sitio';
$string['signup:reserve.form.placeholders.subdomain'] = 'tusitio.moodlecloud.com';
$string['signup:reserve.form.tooltips.region'] = 'La localización es donde tu sitio será alojado. Recomendamos que elijas la más próxima a ti y tus estudiantes.';
$string['signup:status.body.ariasetupcomplete'] = 'La configuración de tu nuevo sitio se ha completado. Ahora puedes acceder.';
$string['signup:status.body.lead'] = '<p>¡Ha sido rápido!</p>
<p>Lo querías, ahora tienes tu propio sitio Moodle.</p>
<p>Entra y continua creando tu precioso espacio de apredizaje.</p>';
$string['signup:status.body.login'] = 'Acceder';
$string['signup:status.body.title'] = '¡Listo! Tu propio sitio Moodle, ¡gratuito!';
$string['signup:steps.x'] = 'Paso %x%';
$string['signup:steps.xofy'] = 'Paso %x% de %y%';
$string['signup:terms.title'] = 'Condiciones de Servicio del sitio MoodleCloud';
$string['signup:texts.statusintro'] = 'TODO';
$string['signup:texts.statustitle'] = 'Lo estabas esperando. Tu propio sitio Moodle, ¡gratuito!';
$string['status:label.expired'] = 'Borrado por inactividad';
$string['status:label.pendingIdentityConfirmation'] = 'Pendiente de verificación';
$string['status:label.pendingProvision'] = 'En cola para su creación';
$string['status:label.pendingRemoval'] = 'En cola para su borrado';
$string['status:label.provisioned'] = 'Funcionando';
$string['status:label.removed'] = 'Borrado';
$string['status:label.reserved'] = 'Reservado';
$string['status:tooltip.expired'] = 'Este sitio ha sido borrado de nuestros sistemas por inactividad.';
$string['status:tooltip.pendingIdentityConfirmation'] = 'Este sitio ha sido reservado y una confirmación ha sido enviada vía SMS';
$string['status:tooltip.pendingProvision'] = 'Este sitio ha sido enviado a nuestros sistemas y estará disponible para tí ¡realmente pronto!';
$string['status:tooltip.pendingRemoval'] = 'Este sitio ha sido programado para ser borrado y pronto desaparecerá de nuestros sistemas de forma completa.';
$string['status:tooltip.provisioned'] = 'Este sitio está actualmente funcionando y disponible.';
$string['status:tooltip.removed'] = 'Este sitio ha sido borrado.';
$string['status:tooltip.reserved'] = 'Este sitio ha sido reservado pero el proceso de registro todavía no se ha completado.';
$string['telephony:lookup.apifailure'] = '¡Oh, no! Algo fue mal con nuestro sistema de mensajes. Por favor, inténtalo de nuevo en unos momentos.';
$string['telephony:lookup.invalidnumber'] = 'Número de teléfono inválido.';
$string['telephony:lookup.notacellphone'] = 'Debes introducir un número válido de teléfono móvil/celular.';
$string['telephony:validator.apifailure'] = '¡Oh, no! Algo fue mal con nuestro sistema de mensajes. Por favor, inténtalo de nuevo en unos momentos.';
$string['validators:fos_user.current_password.invalid'] = 'La contraseña introducida es inválida';
$string['validators:fos_user.email.already_used'] = 'La dirección de email ya está siendo utilizada';
$string['validators:fos_user.email.blank'] = 'Por favor, introduce tu dirección de email';
$string['validators:fos_user.email.invalid'] = 'La dirección de email no es válida';
$string['validators:fos_user.email.long'] = '[-Inf,Inf]La dirección de email es muy larga';
$string['validators:fos_user.email.short'] = '[-Inf,Inf]La dirección de email es muy corta';
$string['validators:fos_user.group.blank'] = 'Por favor, introduce un nombre';
$string['validators:fos_user.group.long'] = '[-Inf,Inf]El nombre es muy largo';
$string['validators:fos_user.group.short'] = '[-Inf,Inf]El nombre es muy corto';
$string['validators:fos_user.new_password.blank'] = 'Por favor, introduce una nueva contraseña';
$string['validators:fos_user.new_password.short'] = '[-Inf,Inf]La nueva contraseña es muy corta';
$string['validators:fos_user.password.blank'] = 'Por favor, introduce una contraseña';
$string['validators:fos_user.password.mismatch'] = 'Las contraseñas introducidas no coinciden';
$string['validators:fos_user.password.short'] = '[-Inf,Inf]La contraseña es muy corta';
$string['validators:fos_user.username.already_used'] = 'El nombre de usuario ya está en uso';
$string['validators:fos_user.username.blank'] = 'Por favor, introduce un nombre de usuario';
$string['validators:fos_user.username.long'] = '[-Inf,Inf]El nombre de usuario es muy largo';
$string['validators:fos_user.username.short'] = '[-Inf,Inf]El nombre de usuario es muy corto';
$string['validators:signup.tandc.mustagree'] = 'Para utilizar el Servicio MoodleCloud debes aceptar las Condiciones de Servicio definidas.';
$string['validators:signup.timezone.mustselect'] = 'Por favor, selecciona tu zona horaria';
$string['validators:site.firstname.mustexist'] = 'Debes especificar tu nombre';
$string['validators:site.lastname.mustexist'] = 'Debes especificar tu apellido(s)';
$string['validators:site.subdomain.format'] = 'El nombre del sitio debe comenzar por una letra. Tiene que contener una combinación de letras, números y guiones únicamente.';
$string['validators:site.subdomain.maxlength'] = 'El nombre del sitio (sin el dominio) debe tener 53 caracteres o menos';
$string['validators:site.subdomain.minlength'] = 'El nombre del sitio (sin el dominio) debe tener por los menos 3 caracteres';
$string['validators:site.subdomain.mustexist'] = 'Debes especificar un nombre del sitio';
