<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'es_mx', version '4.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Entiendo y acepto el acuerdo de procesamiento de datos';
$string['activityoverview'] = 'Usted tiene futuras sesiones de BigBlueButton';
$string['bbbduetimeoverstartingtime'] = 'La hora en que termina esta actividad debe ser posterior a la hora en que empieza.';
$string['bbbdurationwarning'] = 'La duración máxima para esta sesión es de  %duration% minutos.';
$string['bbbrecordallfromstartwarning'] = 'Esta sesión está siendo grabada desde el inicio.';
$string['bbbrecordwarning'] = 'Esta sesión se puede grabar.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Agregar una nueva sala BigBlueButton';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Crear instancias de sesiones en vivo';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Crear instancias con grabación';
$string['bigbluebuttonbn:deleterecordings'] = 'Eliminar grabaciones';
$string['bigbluebuttonbn:importrecordings'] = 'Importar grabaciones';
$string['bigbluebuttonbn:join'] = 'Ingresar a una sala BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'Gestionar grabaciones';
$string['bigbluebuttonbn:protectrecordings'] = 'Proteger grabaciones';
$string['bigbluebuttonbn:publishrecordings'] = 'Publicar grabaciones';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Des-proteger grabaciones';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Des-publicar grabaciones';
$string['bigbluebuttonbn:view'] = 'Ver sala BigBlueButton';
$string['bigbluebuttondisablednotification'] = 'El módulo de actividad BigBlueButton ha sido deshabilitado y cualquier actividad de BigBlueButton existente en cursos actualmente no están disponibles. Antes de re-habilitar este plugin, por favor asegúrese de que haya leído y aceptado el <a href="{$a}" target="_blank">acuerdo de procesamiento de datos</a> con Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'Módulo de actividad BigBlueButton desactivado.';
$string['cachedef_currentfetch'] = 'Datos a enlistar cualquier grabación recientemente recuperada.';
$string['cachedef_recordings'] = 'Metadatos de grabación';
$string['cachedef_serverinfo'] = 'Información del servidor remoto';
$string['cachedef_validatedurls'] = 'Caché de comprobaciones de URLs validadas';
$string['calendarstarts'] = '{$a} está agendado para';
$string['cannotperformaction'] = 'No se puede realizar la acción de {$a} en esta grabación';
$string['completionattendance'] = 'El estudiante debe asistir a la reunión para:';
$string['completionattendance_desc'] = 'Ingresar y permanecer en la sala por al menos {$a} minuto(s)';
$string['completionattendance_event_desc'] = 'El estudiante ha ingresado a la sala y permaneció en la sesión por al menos {$a} minuto(s)';
$string['completionattendancegroup'] = 'Requerir asistencia';
$string['completionattendancegroup_help'] = 'El asistir a la sesión por (n) minutos es necesario para la finalización';
$string['completionengagement_desc'] = 'Participar en actividades durante la reunión';
$string['completionengagementchats'] = 'Chats';
$string['completionengagementchats_desc'] = 'Participar en {$a} chat(s).';
$string['completionengagementchats_event_desc'] = 'Ha levantado {$a} Chat(s)';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Cambiar {$a}veces su(s) emoji(s).';
$string['completionengagementemojis_event_desc'] = 'Cambió {$a} veces su(s) emoji(s)';
$string['completionengagementgroup'] = 'Requerir participación';
$string['completionengagementgroup_help'] = 'La participación activa durante la sesión es necesaria para la finalización.';
$string['completionengagementpollvotes'] = 'Encuestar votos';
$string['completionengagementpollvotes_desc'] = 'Votar en encuestas  {$a} vez(veces.';
$string['completionengagementpollvotes_event_desc'] = 'Ha contestado {$a} votación(es) en encuesta';
$string['completionengagementraisehand'] = 'Requerir levantar mano';
$string['completionengagementraisehand_desc'] = 'Levantar la mano {$a} vez(veces).';
$string['completionengagementraisehand_event_desc'] = 'Ha levantado la mano {$a} veces';
$string['completionengagementtalks'] = 'Hablar';
$string['completionengagementtalks_desc'] = 'Hablar {$a} vez(veces)';
$string['completionengagementtalks_event_desc'] = 'Ha levantado {$a} Habladas';
$string['completionupdatestate'] = 'Estado de actualización de finalización';
$string['completionvalidatestate'] = 'Validar finalización';
$string['completionvalidatestatetriggered'] = 'Validar finalización ha sido disparado';
$string['completionview'] = 'Requerir vista';
$string['completionview_desc'] = 'El estudiante debe ver la Sala para completarla.';
$string['completionview_event_desc'] = 'Ha visto la Sala.';
$string['config_default_messages'] = 'Mensajes predeterminados';
$string['config_default_messages_description'] = 'Configurar mensajes predeterminados para actividades';
$string['config_disablecam_default'] = 'Deshabilitar cámara habilitado por defecto';
$string['config_disablecam_default_description'] = 'Si se habilita, las cámaras web serán deshabilitadas';
$string['config_disablecam_editable'] = 'Deshabilitar webcam puede ser editado';
$string['config_disablecam_editable_description'] = 'Deshabilitar webcam por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_disablemic_default'] = 'Deshabilitar micrófonos habilitado por defecto';
$string['config_disablemic_default_description'] = 'Si se habilita, los micrófonos pueden ser deshabilitados.';
$string['config_disablemic_editable'] = 'Deshabilitar micrófonos puede ser editado';
$string['config_disablemic_editable_description'] = 'Deshabilitar micrófono por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_disablenote_default'] = 'Deshabilitar anotaciones compartidas por defecto';
$string['config_disablenote_default_description'] = 'Si se habilita, las anotaciones compartidas serán deshabilitadas.';
$string['config_disablenote_editable'] = 'Deshabilitar anotaciones compartidas puede ser editado';
$string['config_disablenote_editable_description'] = 'Deshabilitar anotaciones compartidas por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_disableprivatechat_default'] = 'Deshabilitar chat privado habilitado por defecto';
$string['config_disableprivatechat_default_description'] = 'Si se habilita, el chat privado será deshabilitado.';
$string['config_disableprivatechat_editable'] = 'Deshabilitar chat privado puede ser editado';
$string['config_disableprivatechat_editable_description'] = 'Deshabilitar chat privado por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_disablepublicchat_default'] = 'Deshabilitar chat público habilitado de forma predeterminada';
$string['config_disablepublicchat_default_description'] = 'Si se habilita, el chat público será deshabilitado.';
$string['config_disablepublicchat_editable'] = 'Deshabilitar chat público puede ser editado';
$string['config_disablepublicchat_editable_description'] = 'Deshabilitar chat público por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_dpa_note'] = 'Nota: Para cumplir con sus obligaciones de protección de datos, antes de habilitar este plugin, usted podría necesitar asegurarse de que ha leído y aceptado el acuerdo de procesamiento de datos. Para el servicio predeterminado gratuito de BigBlueButton, este es el <a href="{$a}" target="_blank">Acuerdo de procesamiento de datos con Blindside Networks</a>. Por favor consulte con sus propios profesionales de privacidad para asesoría.';
$string['config_experimental_features'] = 'Características experimentales';
$string['config_experimental_features_description'] = 'Configuración para características experimentales.';
$string['config_extended_capabilities'] = 'Capacidades extendidas';
$string['config_extended_capabilities_description'] = 'La configuración para capacidades extendidas cuando el servidor BigBlueButton las ofrece.';
$string['config_general'] = 'Configuraciones generales';
$string['config_general_description'] = 'Estas configuraciones son usadas siempre.';
$string['config_hideuserlist_default'] = 'Ocultar lista de usuarios habilitado de forma predeterminada';
$string['config_hideuserlist_default_description'] = 'Si se habilita, la lista de usuarios de la sesión puede ser ocultada.';
$string['config_hideuserlist_editable'] = 'Ocultar lista de usuarios puede ser editado';
$string['config_hideuserlist_editable_description'] = 'Ocultar lista de usuarios por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_importrecordings'] = 'Importar grabaciones';
$string['config_importrecordings_description'] = 'Estas configuraciones son específicas de la característica.';
$string['config_importrecordings_enabled'] = 'Importación de grabaciones habilitada';
$string['config_importrecordings_enabled_description'] = 'Cuando están habilitados esto  y la característica de grabaciones, es posible importar grabaciones desde cursos diferentes hacia una actividad.';
$string['config_importrecordings_from_deleted_enabled'] = 'Impotación de grabaciones desde actividades eliminadas habilitada';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Cuando esta característica y la de importar grabación están habilitadas, es posible importar grabaciones desde actividades que ya no están en el curso.';
$string['config_lockonjoin_default'] = 'Bloqueo al unirse habilitado por defecto';
$string['config_lockonjoin_default_description'] = 'Si se habilita, las configuraciones bloqueadas por configuración son aplicadas al usuario cuando se unen. La configuración del bloqueo debe estar habilitada para que esto aplique.';
$string['config_lockonjoin_editable'] = 'Bloqueo al unirse  puede ser editado';
$string['config_lockonjoin_editable_description'] = 'Bloqueo al unirse por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_locksettings'] = 'Configuraciones de bloqueo';
$string['config_locksettings_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario para bloquear configuraciones, y también definen valores predeterminados para estas opciones.';
$string['config_meetingevents_enabled'] = 'Registrar eventos en vivo';
$string['config_meetingevents_enabled_description'] = 'Si es habilitado, las sesiones en vivo serán procesadas después de que termine la sesión.Esta característica debe estar habilitada para "Finalización de actividad" y solamente funcionará si el servidor BigBlueButton es capaz de procesar scripts post_events.';
$string['config_muteonstart'] = 'Mudo al iniciar';
$string['config_muteonstart_default'] = 'Mudo al iniciar habilitado por defecto';
$string['config_muteonstart_default_description'] = 'Si se habilita la sesión será enmudecida al iniciar.';
$string['config_muteonstart_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario y también definen valores predeterminados para estas opciones.';
$string['config_muteonstart_editable'] = 'Mudo al iniciar puede ser editado';
$string['config_muteonstart_editable_description'] = 'Mudo al iniciar por defecto puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_participant'] = 'Participantes';
$string['config_participant_description'] = 'Estas configuraciones definen el rol por defecto para participantes.';
$string['config_participant_moderator_default'] = 'Moderador';
$string['config_participant_moderator_default_description'] = 'Esta regla es usada por defecto cuando es añadida una nueva sala.';
$string['config_presentation_default'] = 'Archivo predeterminado para la presentación';
$string['config_presentation_default_description'] = 'Un archivo puede ser proporcionado para uso en todas las salas.';
$string['config_preuploadpresentation'] = 'Pre-subir presentación';
$string['config_preuploadpresentation_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del usuario y también definen valores para estas opciones. Esta característica solamente funciona si el servidor Moodle está accesible para BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Pre-subida de editable de presentación';
$string['config_preuploadpresentation_editable_description'] = 'La característica de pre-subir presentación es editable  en la Interfaz del Usuario cuando la sala o la conferencia es añadida o actualizada.';
$string['config_recording'] = 'Grabación';
$string['config_recording_all_from_start_default'] = 'Iniciar grabación desde el principio';
$string['config_recording_all_from_start_default_description'] = '¿Debería de estar habilitada en forma predeterminada la configuración \' Iniciar grabación desde el principio\' al añadir una nueva sala BigBlueButton?';
$string['config_recording_all_from_start_editable'] = 'Iniciar grabación desde el principio puede ser editado';
$string['config_recording_all_from_start_editable_description'] = '¿Debería ser editable la configuración \' Iniciar grabación desde el principio\' en las configuraciones de la actividad BigBlueButton?';
$string['config_recording_default'] = 'Grabación habilitada de forma predeterminada';
$string['config_recording_default_description'] = '¿Debería de estar habilitada en forma predeterminada la configuración \' La sesión puede ser grabada\' al añadir una nueva sala BigBlueButton?';
$string['config_recording_description'] = 'Estas confguraciones son específicas de la característica';
$string['config_recording_editable'] = 'El que la sesión pueda ser grabada es editable';
$string['config_recording_editable_description'] = '¿Debería ser editable la configuración \' La sesión puede ser grabada\' en las configuraciones de la actividad BigBlueButton?';
$string['config_recording_hide_button_default'] = 'Ocultar botón de grabación';
$string['config_recording_hide_button_default_description'] = 'Si se activa, el botón para grabar estará oculto';
$string['config_recording_hide_button_editable'] = 'El ocultar botón de grabación puede ser editado';
$string['config_recording_hide_button_editable_description'] = '¿Debería ser editable la configuración \'Ocultar botón de grabación\' en las configuraciones de la actividad BigBlueButton?';
$string['config_recording_protect_editable'] = 'El estado protegido de las grabaciones puede ser editado';
$string['config_recording_protect_editable_description'] = 'Si se activa, la interfaz incluye una opción para proteger/desproteger grabaciones.';
$string['config_recording_refresh_period'] = 'Período de refresco de grabación (en segundos)';
$string['config_recording_refresh_period_description'] = '¿Que tan frecuente debería de ser consultado el servidor BigBlueButton para refrescar información remota para una grabación?';
$string['config_recordingready_enabled'] = 'Enviar notificaciones cuando la grabación esté disponible';
$string['config_recordingready_enabled_description'] = 'Si se habilita, una notificación  será enviada cuando esté disponible un enlace a la grabación- Esta característica requiere que el script post_publish_recording_ready_callback esté habilitado en el servidor BigBlueButton)';
$string['config_recordings'] = 'Mostrar grabaciones';
$string['config_recordings_asc_sort'] = 'Enlistar las grabaciones en orden cronológico';
$string['config_recordings_asc_sort_description'] = 'Las grabaciones son ordenadas por fecha, ya sea en orden cronológico o cronológico reverso.';
$string['config_recordings_deleted_default'] = 'Incluir grabaciones de actividades eliminadas habilitadas de forma predeterminada';
$string['config_recordings_deleted_default_description'] = 'Si se habilita, la tabla de grabaciones incluirá grabaciones de cualquier actividad que hubieran sido eliminadas.';
$string['config_recordings_deleted_editable'] = 'Puede ser editada la característica de incluir grabaciones de actividades eliminadas';
$string['config_recordings_deleted_editable_description'] = 'Incluir por defecto grabaciones de actividades eliminadas puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_recordings_description'] = 'Estas configuraciones son específicas de la característica';
$string['config_recordings_general'] = 'Mostrar configuraciones de grabación';
$string['config_recordings_general_description'] = 'Estas configuraciones son usadas solamente al mostrar grabaciones';
$string['config_recordings_imported_default'] = 'Mostrar solamente enlaces importados habilitado por defecto';
$string['config_recordings_imported_default_description'] = 'Si se habilita, la tabla de grabación incluirá solamente los enlaces importados a grabaciones.';
$string['config_recordings_imported_editable'] = 'Puede ser editada la característica de mostrar solamente enlaces importados';
$string['config_recordings_imported_editable_description'] = 'Mostrar  por defecto solamente enlaces importados puede ser editado cuando la instancia es añadida o actualizada.';
$string['config_recordings_preview_default'] = 'Vista previa está habilitada por defecto';
$string['config_recordings_preview_default_description'] = 'Si se habilita, la tabla incluye una vista previa de la presentación.';
$string['config_recordings_preview_editable'] = 'La característica de vista previa puede ser editada';
$string['config_recordings_preview_editable_description'] = 'La característica de vista previa puede ser editada cuando la instancia es añadida o actualizada.';
$string['config_scheduled'] = 'Sesiones agendadas';
$string['config_scheduled_description'] = 'Estas configuraciones definen el comportamiento predeterminado para las sesiones agendadas.';
$string['config_scheduled_pre_opening'] = 'Accesible antes de la hora de apertura';
$string['config_scheduled_pre_opening_description'] = 'El tiempo en minutos que la sala es abierta antes de la hora de apertura agendada.';
$string['config_server_url'] = 'URL del servidor BigBlueButton';
$string['config_server_url_description'] = 'Las credenciales predeterminadas son para un <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">servicio BigBlueButton gratuito para Moodle (abre en ventana nueva)</a> proporcionado por Blindside Networks con las restricciones siguientes:
<ol>
<li>La duración máxima para cada sesión es 60 minutos</li>
<li>El número máximo de usuarios concurrentes por sesión es 25</li>
<li>La grabación expira después de siete (7) días y no se puede descargar</li>
<li>Las webcams del estudiante solamente son visibles para el moderador.</li>
</ol>';
$string['config_shared_secret'] = 'Secreto compartido de BigBlueButton';
$string['config_shared_secret_description'] = 'El secreto de seguridad de su servidor BigBlueButton. El secreto predeterminado es para un servidor gratuito BigBlueButton proporcionado por Blindside Networks.';
$string['config_uidelegation_enabled'] = 'Delegación de Interfaz del Usuario está habilitada';
$string['config_uidelegation_enabled_description'] = 'Estas configuraciones habilitan o deshabilitan la delegación de la Interfaz del Usuario al servidor BigBlueButton.';
$string['config_userlimit'] = 'Límite de usuario';
$string['config_userlimit_default'] = 'Límite de usuario habilitado por defecto';
$string['config_userlimit_default_description'] = 'El número de usuarios permitidos en una sesión por defecto cuando es añadida una nueva sala. Si el número se configura a 0, no se establece límite.';
$string['config_userlimit_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario y también definen valores por defecto para estas opciones.';
$string['config_userlimit_editable'] = 'La característica de límite de usuarios puede ser editada';
$string['config_userlimit_editable_description'] = 'El valor del límite de usuarios por defecto puede ser editado cuando la sala o conferencia es añadida o actualizada.';
$string['config_voicebridge'] = 'Puente vocal';
$string['config_voicebridge_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del usuario y también definen valores por defecto para estas opciones.';
$string['config_voicebridge_editable'] = 'Puente vocal de conferencia puede ser editado';
$string['config_voicebridge_editable_description'] = 'El número de puente de voz de conferencia puede ser asignado permanentemente a una sala. Cuando es asignado, el número no puede ser usado por ninguna otra sala.';
$string['config_waitformoderator'] = 'Esperar al moderador';
$string['config_waitformoderator_cache_ttl'] = 'TTL (segundos) de caché de Esperar a moderador';
$string['config_waitformoderator_cache_ttl_description'] = 'Para soportar una carga fuerte de clientes, este plugin hace uso de una caché. Este parámetro define el tiempo que se conservará la caché antes de que la siguiente solicitud sea enviada al servidor BigBlueButton.';
$string['config_waitformoderator_default'] = 'Esperar a un moderador habilitado por defecto';
$string['config_waitformoderator_default_description'] = '¿Debería de estar habilitada en forma predeterminada la configuración \' Esperar al moderador\' al añadir una nueva sala BigBlueButton?';
$string['config_waitformoderator_description'] = 'Estas configuraciones son específicas de la característica';
$string['config_waitformoderator_editable'] = 'Esperar al moderador puede ser editada';
$string['config_waitformoderator_editable_description'] = '¿Debería ser editable la configuración \' Esperar al moderador\' en las configuraciones de la actividad BigBlueButton?';
$string['config_waitformoderator_ping_interval'] = 'Ping (segundos) de esperar al moderador';
$string['config_waitformoderator_ping_interval_description'] = '¿Qué tan a menudo debería de ser hecho un ping (https://es.wikipedia.org/wiki/Ping ) al servidor para comprobar si el moderador ha ingresado a la sala?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN hace uso de config.php con una variable global que ha quedado en desuso. Por favor convierta el archivo, ya que no será soportado en versiones futuras';
$string['config_warning_curl_not_installed'] = 'Esta función requiere que la extensión CURL para php  se encuentre instalada y habilitada. La configuración de estos parameteros será posible solo si esta condición se cumple.';
$string['config_welcome_default'] = 'Mensaje predeterminado de BienVenida';
$string['config_welcome_default_description'] = 'El mensaje de bienvenida es mostrado cuando los participantes ingresan a la sala. Si el campo es dejado vacío, se mostrará un mensaje configurado en el servidor BigBlueButton.';
$string['config_welcome_editable'] = 'El mensaje de BienVenida predeterminado es editable por profesores';
$string['config_welcome_editable_description'] = 'Mensaje de BienVenida puede ser editado cuando la instancia es añadida o actualizada';
$string['dpainfonotsigned'] = 'Antes de habilitar este plugin, usted debe confirmar que ha leído y aceptado el <a href="{$a}">acuerdo de procesamiento de datos con Blindside Networks </a>.';
$string['enablingbigbluebutton'] = 'Habilitando actividad BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'Para cumplir con sus obligaciones de protección de datos, antes de habilitar este plugin, usted podría necesitar asegurarse de que ha leído y aceptado el <a href="{$a}" target="_blank">acuerdo de procesamiento de datos con Blindside Networks Inc.</a>
Por favor consulte con sus propios profesionales de privacidad para asesoría.';
$string['end_session_confirm'] = '¿Está seguro de querer terminar la sesión?';
$string['end_session_confirm_title'] = '¿Realmente terminar la sesión?';
$string['end_session_notification'] = 'La sesión ha terminado.';
$string['ends_at'] = 'Termina';
$string['event_activity_created'] = 'Actividad creada';
$string['event_activity_deleted'] = 'Actividad eliminada';
$string['event_activity_updated'] = 'Actividad actualizada';
$string['event_live_session'] = 'Evento de sesión en vivo';
$string['event_meeting_created'] = 'Reunión creada';
$string['event_meeting_ended'] = 'Se ha finalizado la sesión de forma forzada';
$string['event_meeting_joined'] = 'Ingreso a reunión';
$string['event_meeting_left'] = 'Salida de reunión';
$string['event_recording_deleted'] = 'Grabación eliminada';
$string['event_recording_edited'] = 'Grabación editada';
$string['event_recording_imported'] = 'Grabación importada';
$string['event_recording_protected'] = 'Grabación protegida';
$string['event_recording_published'] = 'Grabación publicada';
$string['event_recording_unprotected'] = 'Grabación desprotegida';
$string['event_recording_unpublished'] = 'Grabación oculta';
$string['event_recording_viewed'] = 'Grabación vista';
$string['event_unknown'] = 'Evento desconocido';
$string['general_error_cannot_create_meeting'] = 'No se puede crear sesión..';
$string['general_error_cannot_get_recordings'] = 'No se pueden obtener las grabaciones.';
$string['general_error_no_answer'] = 'Respuesta vacía. Por favor revise el servidor BigBlueButton Y ADEMÁS compruebe si el servidor BigBlueButton está operando.';
$string['general_error_not_allowed_to_create_instances'] = 'El usuario no tiene permitido el crear cualquier tipo de instancias.';
$string['general_error_not_found'] = 'Entidad no encontrada : {$a}.';
$string['general_error_unable_connect'] = 'No se pudo conectar. Por favor verifique la URL del servidor BigBlueButtton Y ADEMÁS compruebe que el servidor BigBlueButton esté operando. Detalles : {$a}';
$string['index_confirm_end'] = '¿Quiere terminar la sesión?';
$string['index_disabled'] = 'deshabilitada';
$string['index_enabled'] = 'habilitada';
$string['index_ending'] = 'Terminando la sesión... por favor espere';
$string['index_error_bbtn'] = 'ID de BigBlueButton {$a} es incorrecta';
$string['index_error_checksum'] = 'Hubo un error de la suma de comprobación. Por favor asegúrese de haber ingresado el secreto correcto.';
$string['index_error_forciblyended'] = 'No se pudo unir a la sesión debido a que fue terminada manualmente.';
$string['index_error_noinstances'] = 'No hay instancias de salas BigBlueButton';
$string['index_error_unable_display'] = 'No se pueden mostrar las sessiones. Por favor revise la URL del servidor BigBlueButtton  Y TAMBIÉN que el servidor BigBlueButton esté operando.';
$string['index_heading'] = 'Salas BigBlueButton';
$string['index_heading_actions'] = 'Acciones';
$string['index_heading_group'] = 'Grupo';
$string['index_heading_moderator'] = 'Moderadores';
$string['index_heading_name'] = 'Sala';
$string['index_heading_recording'] = 'Grabación';
$string['index_heading_users'] = 'Usuarios';
$string['index_heading_viewer'] = 'Observadores';
$string['indicator:cognitivedepth'] = 'BigBlueButtonBN cognitivo';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitival alcanzada por el estudiante en una actividad BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButtonBN social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad BigBlueButton.';
$string['instance_type_default'] = 'Sala con grabaciones';
$string['instance_type_recording_only'] = 'Grabaciones solamente';
$string['instance_type_room_only'] = 'Sala solamente';
$string['instanceprofilewithoutrecordings'] = 'El perfil de la instancia no puede mostrar grabaciones';
$string['messageprovider:instance_updated'] = 'Sesión BigBlueButton actualizada';
$string['messageprovider:recording_ready'] = 'Grabación BigBlueButton disponible';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['mod_form_block_general'] = 'General';
$string['mod_form_block_participants'] = 'Rol asigado durante sesión en vivo';
$string['mod_form_block_presentation'] = 'Contenido de la Presentación';
$string['mod_form_block_presentation_default'] = 'Contenido predeterminado de presentación';
$string['mod_form_block_record'] = 'Configuraciones de grabación';
$string['mod_form_block_recordings'] = 'Vista de Grabación';
$string['mod_form_block_room'] = 'Configuraciones de Sala';
$string['mod_form_block_schedule'] = 'Agenda de la sesión';
$string['mod_form_field_closingtime'] = 'Cerrar';
$string['mod_form_field_conference_name'] = 'Nombre de Sesión';
$string['mod_form_field_disablecam'] = 'Deshabilitar cámaras web';
$string['mod_form_field_disablemic'] = 'Deshabilitar micrófonos';
$string['mod_form_field_disablenote'] = 'Deshabilitar anotaciones compartidas';
$string['mod_form_field_disableprivatechat'] = 'Deshabilitar chat privado';
$string['mod_form_field_disablepublicchat'] = 'Deshabilitar chat público';
$string['mod_form_field_duration'] = 'Duración';
$string['mod_form_field_duration_help'] = 'Fijar la duración para una sesión establecerá el tiempo máximo para mantener activa una sesión antes de que termine la grabación';
$string['mod_form_field_hideuserlist'] = 'Ocultar lista de usuarios';
$string['mod_form_field_instanceprofiles'] = 'Tipo de instancia';
$string['mod_form_field_instanceprofiles_help'] = 'Si una sesión será grabada, seleccionar \'Sala con grabación\'; en caso contrario \'Solamente sala. Después que una sesión sea grabada, si ya no habrá más sesiones, seleccionar \'Solamente grabaciones\'-';
$string['mod_form_field_intro'] = 'Descripción';
$string['mod_form_field_intro_help'] = 'Una breve descripción de la sala.';
$string['mod_form_field_lockonjoin'] = 'Bloquear configuraciones al unirse';
$string['mod_form_field_muteonstart'] = 'Mudo al iniciar';
$string['mod_form_field_name'] = 'Nombre de sala';
$string['mod_form_field_nosettings'] = 'No pueden editarse configuraciones';
$string['mod_form_field_openingtime'] = 'Abierto';
$string['mod_form_field_participant_add'] = 'Añadir asignatario';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderador';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Observador';
$string['mod_form_field_participant_list'] = 'Asignatario';
$string['mod_form_field_participant_list_action_add'] = 'Agregar';
$string['mod_form_field_participant_list_action_remove'] = 'Eliminar';
$string['mod_form_field_participant_list_text_as'] = 'se une a la sesión como';
$string['mod_form_field_participant_list_type_all'] = 'Todos los usuarios inscritos';
$string['mod_form_field_participant_list_type_owner'] = 'Propietario';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Usuario';
$string['mod_form_field_record'] = 'La sesión puede grabarse.';
$string['mod_form_field_recordallfromstart'] = 'Grabar todo desde el principio';
$string['mod_form_field_recordhidebutton'] = 'Ocultar botón de grabar';
$string['mod_form_field_recordings_deleted'] = 'Incluir grabaciones de actividades eliminadas';
$string['mod_form_field_recordings_html'] = 'Mostrar la tabla en HTML simple';
$string['mod_form_field_recordings_imported'] = 'Mostrar solamente enlaces importados';
$string['mod_form_field_recordings_preview'] = 'Mostrar vista previa de grabación';
$string['mod_form_field_room_name'] = 'Nombre de la sala';
$string['mod_form_field_userlimit'] = 'Límite de usuarios';
$string['mod_form_field_userlimit_help'] = 'Número máximo de usuarios permitidos en una sesión. Configurar a 0 para permitir un número ilimitado de usuarios .';
$string['mod_form_field_voicebridge'] = 'Puente de voz [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Error de formato. Debe de ingresar un número entre 1 y 9999.';
$string['mod_form_field_voicebridge_help'] = 'Un número entre 1 y 9999 para que los participantes tecleen para unirse a la sesión de voz usando marcación. Si el valor fuera 0 el número de puente-de-voz estático (static voicebridge) será ignorado y se generará un número aleatorio por BigBlueButton. Un número 7 precederá a los cuatro dígitos tecleados';
$string['mod_form_field_voicebridge_notunique_error'] = 'No es un valor único. Este número está siendo usado por otra sala.';
$string['mod_form_field_wait'] = 'Esperar al moderaror';
$string['mod_form_field_wait_help'] = '¿Los participantes tienen que esperar a un moderador antes de que ellos puedan ingresar a la sala?';
$string['mod_form_field_welcome'] = 'Mensaje de bienvenida';
$string['mod_form_field_welcome_default'] = 'Bienvenido a  %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'El mensaje de bienvenida es mostrado cuando los participantes ingresan a la sala. Si el campo es dejado vacío, se mostrará un mensaje predeterminado configurado en la administración del sitio.';
$string['mod_form_locksettings'] = 'Configuraciones de bloqueo';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButtones un sistema de conferencia web de código abierto diseñado para aprendizaje en línea, que soporta el compartir en tiempo real audio, video, chat,  diapositivas, pantalla, un pizarrón multi-usuarios, salas de descanso, encuestas y emojis.

Usando BigBlueButton usted puede crear una sala para sesiones como por ejemplo clases en línea en vivo, horas de oficina virtual, o colaboración en grupo con estudiantes remotos. La sesión puede ser grabada para reproducción posterior.';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Actividad BigBlueButton';
$string['nosuchinstance'] = 'No hay tal instancia {$a->entity} con ID: {$a->id}';
$string['notification_instance_created_intro'] = 'La sala BigBlueButton <a href="{$a->link}">{$a->name}</a> ha sido creada.';
$string['notification_instance_created_small'] = 'Una nueva sala BigBlueButton llamada {$a->name} fue creada.';
$string['notification_instance_created_subject'] = 'Una nueva sala BigBlueButton ha sido creada';
$string['notification_instance_description'] = 'Descripción';
$string['notification_instance_end_date'] = 'Fecha de término';
$string['notification_instance_name'] = 'Título';
$string['notification_instance_start_date'] = 'Fecha de inicio';
$string['notification_instance_updated_intro'] = 'La sala BigBlueButton <a href="{$a->link}">{$a->name}</a> ha sido actualizada.';
$string['notification_instance_updated_small'] = 'La sesión BigBlueButton {$a->name} fue actualizada';
$string['notification_instance_updated_subject'] = 'Su sala BigBlueButton ha sido actualizada';
$string['notification_recording_ready_html'] = 'Una grabación está ahora disponible para la sesión en la sala BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'Una grabación está ahora disponible para la sesión en la sala BigBlueButton {$a->name}. Vaya a {$a->link} para acceder al enlace a la grabación';
$string['notification_recording_ready_small'] = 'Una grabación está disponible para la sala BigBlueButton  {$a->name}';
$string['notification_recording_ready_subject'] = 'Grabación disponible';
$string['pluginadministration'] = 'Administración de BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Para crear y unirse a sesiones BigBlueButton, necesitan intercambiarse datos del usuario con el servidor.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'El nombre completo del usuario que accede al servidor BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'La userid del usuario que accede al servidor BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Configuración de la sesión BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Una lista de reglas que definen el rol que tendrán los usuarios en la sesión BigBlueButton. Una ID del usuario puede ser almacenada, ya que los permisos pueden ser otorgados por rol o por usuario.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Almacena eventos disparados al usar el plugin.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'El tipo de evento disparado por el usuario';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'La ID de la sesión a la que tuvo acceso el usuario.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Información adicional relacionada con la sesión de la grabación.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'La hora a la cual fue creada la bitácora.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'La ID del usuario que disparó el evento.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Almacena metadatos acerca de grabaciones';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'La ID del usuario que cambió por última vez una grabación.';
$string['recordings_from_deleted_activities'] = 'Grabaciones de actividades eliminadas';
$string['recordingurlnotfound'] = 'La URL de la grabación es inválida.';
$string['removedevents'] = 'Eventos eliminados';
$string['removedlogs'] = 'Bitácoras personalizadas eliminadas';
$string['removedrecordings'] = 'Grabaciones eliminadas';
$string['removedtags'] = 'Marcas eliminadas';
$string['report_join_info'] = 'Se ha unido a la sala {$a} vez/veces';
$string['report_play_recording_info'] = 'Ha reproducido una grabación {$a} vez/veces';
$string['report_room_view'] = 'Ha visto la Sala';
$string['resetevents'] = 'Eliminar eventos';
$string['resetlogs'] = 'Eliminar bitácoras personalizadas';
$string['resetlogs_help'] = 'Eliminar las bitácoras resultará en pérdida de referencias a grabaciones.';
$string['resetrecordings'] = 'Eliminar grabaciones';
$string['resetrecordings_help'] = 'Eliminar las grabaciones las hará inaccesibles desde cualquier lugar. ¡Esta acción no puede deshacerse!';
$string['resettags'] = 'Eliminar marcas';
$string['search:activity'] = 'BigBlueButton - información de actividad';
$string['search:tags'] = 'BigBlueButton - información de marcas';
$string['sendnotification'] = 'Enviar notificación';
$string['settings'] = 'Configuraciones de BigBlueButton';
$string['started_at'] = 'Inició';
$string['starts_at'] = 'inicia';
$string['taskname:check_pending_recordings'] = 'Obtener grabaciones pendientes';
$string['userlimitreached'] = 'El número de usuarios permitidos en una sesión ha sido alcanzado.';
$string['view_conference_action_end'] = 'Final de sesión';
$string['view_conference_action_join'] = 'Ingresar a sesión';
$string['view_error_action_not_completed'] = 'La acción no pudo ser completada';
$string['view_error_bigbluebutton'] = 'BigBlueButton respondió con errores. {$a}';
$string['view_error_create'] = 'El servidor BigBlueButton respondió con un mensaje de error. La sala no pudo ser creada.';
$string['view_error_current_state_not_found'] = 'El estado actual no fue encontrado. La grabación podría haber sido eliminada o podría ser que el servidor BigBlueButton no sea compatible con la acción realizada.';
$string['view_error_import_no_courses'] = 'No hay cursos donde buscar grabaciones';
$string['view_error_import_no_recordings'] = 'No hay grabaciones para importar en este curso.';
$string['view_error_invalid_session'] = 'La sesión ha expirado. Regresar a la página principal.';
$string['view_error_max_concurrent'] = 'El número permitido de reuniones concurrentes ha sido alcanzado.';
$string['view_error_meeting_not_running'] = 'Algo salió mal; la sesión no está corriendo.';
$string['view_error_no_group'] = 'Todavía no hay grupos. Usted necesita crear algunos grupos antes de intentar unirse a la sesión.';
$string['view_error_no_group_student'] = 'Usted todavía no se ha añadido a un grupo. Por favor póngase en contacto con su Profesor.';
$string['view_error_no_group_teacher'] = 'No hay grupos. Usted necesita crear algunos grupos.';
$string['view_error_unable_join'] = 'No se pudo ingresar a la sala. Por favor revise la URL del servidor BigBlueButton Y TAMBIÉN revise que el servidor BigBlueButton esté operando.';
$string['view_error_unable_join_student'] = 'No se pudo conectar al servidor BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'No se pudo conectar al servidor BigBlueButton. Por favor póngase en contacto con un Administrador.';
$string['view_error_url_missing_parameters'] = 'Hay parámetros que faltan en esta URL';
$string['view_error_userlimit_reached'] = 'El número de usuarios permitidos en una sesión ha sido alcanzado';
$string['view_groups_nogroups_warning'] = 'La sala fue configurada para usar grupos, pero el curso no tiene grupos definidos.';
$string['view_groups_notenrolled_warning'] = 'La sala fue configurada para usar grupos, pero Usted no es miembro de un grupo.';
$string['view_groups_selection'] = 'Seleccione el grupo al que quiere unirse y confirme la acción.';
$string['view_groups_selection_join'] = 'Ingresar';
$string['view_groups_selection_warning'] = 'Hay una sala para cada grupo y Usted tiene acceso a más de una. Asegúrese de seleccionar la correcta.';
$string['view_login_moderator'] = 'Ingresar como moderador...';
$string['view_login_viewer'] = 'Ingresar como observador...';
$string['view_message_and'] = 'y';
$string['view_message_conference_has_ended'] = 'Esta sesión ha terminado.';
$string['view_message_conference_in_progress'] = 'Esta sesión está en progreso';
$string['view_message_conference_not_started'] = 'La sesión todavía no ha empezado.';
$string['view_message_conference_room_ready'] = 'Esta sala está lista . Puede ingresar a la sesión en este instante.';
$string['view_message_conference_wait_for_moderator'] = 'Esperando a que se una un moderador.';
$string['view_message_finished'] = 'Esta actividad se acabó';
$string['view_message_has_joined'] = 'se ha unido';
$string['view_message_have_joined'] = 'se han unido';
$string['view_message_hour'] = 'hora';
$string['view_message_hours'] = 'horas';
$string['view_message_importrecordings_disabled'] = 'La característica de importar enlaces de grabaciones está deshabilitada en el servidor.';
$string['view_message_minute'] = 'minuto';
$string['view_message_minutes'] = 'minutos';
$string['view_message_moderator'] = 'moderador';
$string['view_message_moderators'] = 'moderadores';
$string['view_message_norecordings'] = 'No hay grabaciones disponibles.';
$string['view_message_notavailableyet'] = 'Esta sesión todavía no está disponible.';
$string['view_message_recordings_disabled'] = 'Las grabaciones fueron deshabilitadas en el servidor. Las actividades BigBlueButtondel tipo \'Solamente grabaciones\' no pueden ser usadas.';
$string['view_message_room_closed'] = 'Esta sala está cerrada.';
$string['view_message_room_open'] = 'Esta sala está abierta.';
$string['view_message_room_ready'] = 'Esta sala está lista.';
$string['view_message_session_for'] = 'la sesión para';
$string['view_message_session_has_user'] = 'Hay';
$string['view_message_session_has_users'] = 'Hay';
$string['view_message_session_no_users'] = 'No hay usuarios en esta sesión';
$string['view_message_session_running_for'] = 'Esta sesión ha estado activa por';
$string['view_message_session_started_at'] = 'Esta sesión inició a las';
$string['view_message_tab_close'] = 'Esta pestaña/ventana debe cerrarse manualmente';
$string['view_message_times'] = 'veces';
$string['view_message_user'] = 'usuario';
$string['view_message_users'] = 'usuarios';
$string['view_message_viewer'] = 'espectador';
$string['view_message_viewers'] = 'espectadores';
$string['view_mobile_message_groups_not_supported'] = 'Esta instancia está posibilitada para trabajar con grupos pero la App mobile aun no tiene apoyo para esto. Por favor use la versión web.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Usted excedió 45 segundos en esta página. Por favor refresque la página para unirse a la sesión.';
$string['view_noguests'] = 'La sala BigBlueButton no está abierto para invitados';
$string['view_nojoin'] = 'Usted no tiene un rol que le permita unirse a esta sesión.';
$string['view_recording'] = 'grabación';
$string['view_recording_actionbar'] = 'Barra de herramientas';
$string['view_recording_activity'] = 'Actividad';
$string['view_recording_button_import'] = 'Importar enlaces de grabación';
$string['view_recording_button_return'] = 'Regresar';
$string['view_recording_course'] = 'Curso';
$string['view_recording_date'] = 'fecha';
$string['view_recording_delete_confirmation'] = '¿Está seguro de querer eliminar {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si la grabación es eliminada, estos enlaces también serán eliminados';
$string['view_recording_delete_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace que fue importado en un diferente curso o actividad. Si la grabación es eliminada, este enlace también será eliminado';
$string['view_recording_description'] = 'Descripción';
$string['view_recording_description_edithint'] = 'Una descripción puede ser añadida para ayudar a identificar la grabación.';
$string['view_recording_description_editlabel'] = 'Editar Descripción';
$string['view_recording_duration'] = 'Duración';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'La URL para este formato de grabación es inalcanzable.';
$string['view_recording_format_notes'] = 'Notas';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentación';
$string['view_recording_format_screenshare'] = 'Screenshare';
$string['view_recording_format_statistics'] = 'Estadísticas';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = '¿Está Usted seguro de importar esta grabación?';
$string['view_recording_length'] = 'Tiempo';
$string['view_recording_link_warning'] = 'Este es un enlace que apunta hacia una grabación que fue creada en un curso o una actividad diferente';
$string['view_recording_list_action_delete'] = 'Eliminando';
$string['view_recording_list_action_edit'] = 'Actualizando';
$string['view_recording_list_action_play'] = 'Reproducir';
$string['view_recording_list_action_process'] = 'Procesando';
$string['view_recording_list_action_protect'] = 'Protegiendo';
$string['view_recording_list_action_publish'] = 'Publicando';
$string['view_recording_list_action_unprotect'] = 'Des-protegiendo';
$string['view_recording_list_action_unpublish'] = 'Des-publicando';
$string['view_recording_list_action_update'] = 'Actualizando';
$string['view_recording_list_actionbar'] = 'Barra de Herramientas';
$string['view_recording_list_actionbar_delete'] = 'Eliminar';
$string['view_recording_list_actionbar_edit'] = 'Editar';
$string['view_recording_list_actionbar_hide'] = 'Ocultar';
$string['view_recording_list_actionbar_import'] = 'Importar';
$string['view_recording_list_actionbar_protect'] = 'Hacerla privada';
$string['view_recording_list_actionbar_publish'] = 'Publicar';
$string['view_recording_list_actionbar_show'] = 'Mostrar';
$string['view_recording_list_actionbar_unprotect'] = 'Hacerla pública';
$string['view_recording_list_actionbar_unpublish'] = 'Ocultar';
$string['view_recording_list_activity'] = 'Actividad';
$string['view_recording_list_course'] = 'Curso';
$string['view_recording_list_date'] = 'Fecha';
$string['view_recording_list_description'] = 'Descripción';
$string['view_recording_list_duration'] = 'Duración';
$string['view_recording_list_recording'] = 'Grabando';
$string['view_recording_meeting'] = 'Reunión';
$string['view_recording_modal_button'] = 'Aplicar';
$string['view_recording_modal_title'] = 'Configurar valores para grabación';
$string['view_recording_name'] = 'Nombre';
$string['view_recording_name_edithint'] = 'Un nombre puede ser añadida para ayudar a identificar la grabación.';
$string['view_recording_name_editlabel'] = 'Editar Nombre';
$string['view_recording_playback'] = 'Reproducir';
$string['view_recording_preview'] = 'Vista previa';
$string['view_recording_preview_help'] = 'Pasar ratón sobre de una imagen para verla a tamaño completo';
$string['view_recording_protect_confirmation'] = '¿Está seguro de querer proteger este/esta {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en un curso o actividad diferente. Si la grabación es protegida, también afectará a los enlaces importados.';
$string['view_recording_protect_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace asociado que fue importado en un curso o actividad diferente. Si la grabación es protegida, también afectará a los enlaces importados.';
$string['view_recording_publish_confirmation'] = '¿Está seguro de querer publicar este/esta {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en un curso o actividad diferente. Si la grabación es publicada estos enlaces también serán publicados.';
$string['view_recording_publish_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace asociado que fue importado en un curso o actividad diferente. Si la grabación es publicada este enlace también será publicado.';
$string['view_recording_publish_link_deleted'] = 'Este enlace no puede ser re-publicado porque la grabación original no existe en el servidor BigBlueButton actual. El enlace debería de ser eliminado.';
$string['view_recording_publish_link_not_published'] = 'Este enlace no puede ser re-publicado porque la grabación original está des-publicada';
$string['view_recording_recording'] = 'Grabación';
$string['view_recording_select_course'] = 'Seleccionar un curso primero en el menú desplegable';
$string['view_recording_tags'] = 'Marcas';
$string['view_recording_unprotect_confirmation'] = '¿Está seguro de querer des-proteger este {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en un curso o actividad diferente. Si la grabación es desprotegida, también afectará a los enlaces importados.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace asociado que fue importado en un curso o actividad diferente. Si la grabación es desprotegida, también afectará a los enlaces importados.';
$string['view_recording_unprotect_link_deleted'] = 'Este enlace no puede ser des-protegido porque la grabación original no existe en el servidor BigBlueButton actual. El enlace debería de ser eliminado.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Este enlace no puede ser des-protegido porque la grabación original está protegida.';
$string['view_recording_unpublish_confirmation'] = '¿Está seguro de des-publicar esta {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si la grabación es des-publicada, esos enlaces también serán des-publicados';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace asociado que fue importado en un diferente cursos o actividad. Si la grabación es des-publicada, ese enlace también será des-publicado';
$string['view_recording_yui_first'] = 'Primero';
$string['view_recording_yui_go'] = 'Ir';
$string['view_recording_yui_last'] = 'Último';
$string['view_recording_yui_next'] = 'Siguiente';
$string['view_recording_yui_page'] = 'Página';
$string['view_recording_yui_prev'] = 'Anterior';
$string['view_recording_yui_rows'] = 'Filas';
$string['view_recording_yui_show_all'] = 'Mostrar todo';
$string['view_room'] = 'Ver sala';
$string['view_section_title_presentation'] = 'Archivo de presentación';
$string['view_section_title_recordings'] = 'Grabaciones';
$string['view_warning_default_server'] = 'Este sitio está usando un <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">servicio BigBlueButton gratuito para Moodle (abre en ventana nueva)</a> proporcionado por Blindside Networks con las restricciones siguientes:
<ol>
<li>La duración máxima para cada sesión es 60 minutos</li>
<li>El número máximo de usuarios concurrentes por sesión es 25</li>
<li>La grabación expira después de siete (7) días y no se puede descargar</li>
<li>Las webcams del estudiante solamente son visibles para el moderador.</li>
</ol>';
$string['waitformoderator'] = 'Esperando que se una un moderador';
