<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'eu', version '4.0'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountid'] = 'Zooom kontuaren IDa';
$string['accountid_desc'] = '';
$string['actions'] = 'Ekintzak';
$string['addparticipant'] = 'Gehitu parte-hartzaile bat';
$string['addparticipantgroup'] = 'Gehitu parte-hartzaile talde bat';
$string['addroom'] = 'Gehitu gela bat';
$string['addroomalert'] = 'Gehitu gela bat klik eginda';
$string['addtocalendar'] = 'Gehitu egutegira';
$string['allmeetings'] = 'Bilera guztiak';
$string['allmeetings_desc'] = 'Ezarpen honen bitartez, jarduera-instantzia guztien aurrebistaren azpiko aldean Zoom jardueraren aurkibide-orriaren esteka agertuko den edo ez kontrolatu dezakezu. Ezarpen honek Zoom-eko jardueraren aurrebista orrian esteka erakustea baino ez du kontrolatzen. Esteka ez erakustea aukeratuta ere, erabiltzailea ikastaroko beste esteken bitartez Zoom jardueraren aurkibide-orrian sartu ahalko da.';
$string['allmeetings_disable'] = 'Desgaitu bileren esteka guztiak';
$string['allmeetings_enable'] = 'Gaitu bileren esteka guztiak';
$string['alternative_hosts'] = 'Aurkezle gehigarriak';
$string['alternative_hosts_desc'] = 'Ezarpen honen bitartez, jarduera-instantziaren ezarpenetan erabiltzaileei aurkezle gehigarriak zehazteko aukera erakustea edo ez kontrolatu dezakezu. Ezarpen honentzako bi widget daude eskuragarri: komaz banatutako helbide elektronikoak onartzen dituen testu-lauko eremua eta ikastaroan {$a->roles} roletako batekin matrikulatutako eta Zoom-eko kontua duten erabiltzaileen aukeraketa erraza egiteko osatze automatikoa duen erabiltzaile-hautatzailea. Irakasleak Moodleko jardueraren aurrebista orrian erabiltzaile-hautatzailean agertzen ez diren erabiltzaileak zuzenean Zoom-en aurkezle gehigarri gisa jarrita egon ahal dira, eta erabiltzaile horiek mantenduko dira gerora Moodletik jardueraren ezarpenak eguneratzen badira ere.';
$string['alternative_hosts_disable'] = 'Desgaitu aurkezle gehigarrien aukera';
$string['alternative_hosts_help'] = 'Aurkezle gehigarrien aukerak bilerak programatu eta beste erabiltzaileei bilera hasteko baimena ematea ahalbidetzen dizu. Erabiltzaile hauei posta elektroniko bitartez aurkezle gehigarri gisa gehitu zaiela jakinaraziko zaie, bilerarako esteka bertan dutelarik.
Eremu honetan aurkezle gehigarrien helbide elektronikoak idatzi itzazu. Helbide elektroniko bat baino gehiago idatzi nahi izanez gero komaz banatu itzazu (hutsunerik gabe).';
$string['alternative_hosts_inputfield'] = 'Erakutsi aurkezle gehigarrien aukera testu lauko eremu gisa';
$string['alternative_hosts_picker'] = 'Erakutsi aurkezle gehigarrien aukera automatikoki osatzen den erabiltzaileen aukeratzaile gisa';
$string['alternative_hosts_picker_help'] = 'Aurkezle gehigarrien aukerak bilerak programatu eta ikastaro honetan matrikulatutako beste erabiltzaileei bilera hasteko baimena ematea ahalbidetzen dizu. Erabiltzaile hauei posta elektroniko bitartez aurkezle gehigarri gisa gehitu zaiola jakinaraziko zaie, bilerarako esteka bertan dutelarik.
Bileraren beharren arabera aurkezle gehigarri bat edo gehiago zehaztu ditzakezu.
Erabiltzaile-hautatzailean ez baduzu erabiltzaile zehatz bat aurkitzen, baliteke erabiltzailea ikastaro honetan rol egokiarekin matrikulatuta ez egotea edo Zoom-eko kontu baliagarria ez izatea.';
$string['alternative_hosts_picker_noneselected'] = 'Ez da aurkezle gehigarririk aukeratu';
$string['alternative_hosts_picker_placeholder'] = 'Aukeratu erabiltzailea(k)';
$string['apiendpoint'] = 'Zoom API-aren Amaiera-puntua';
$string['apiendpoint_desc'] = 'Aukeratu ezazu Zoom jarduerak konektatzeko erabiliko duen Zoom API-aren amaiera-puntua (endpoint). Europear Batasuneko (EU) API-aren amaiera-puntua soilik EBko hornitze-aukera duten Zoom lizentziak dituzten erabiltzaileentzat da. Ziur ez bazaude, API-aren amaiera-puntu globala aukeratu ezazu.';
$string['apiendpoint_eu'] = 'EU API-aren amaiera-puntua';
$string['apiendpoint_global'] = 'API-aren amaiera-puntu globala';
$string['apiidentifier'] = 'Zoom API-aren Identifikatzailea';
$string['apiidentifier_desc'] = 'Zoom API-aren kontsulta egiterakoan identifikatzaile gisa erabiliko den eremua';
$string['apikey'] = 'Zoom-eko API-aren gakoa (key)';
$string['apikey_desc'] = 'JWT 2023ko ekainean baztertuko da';
$string['apisecret'] = 'Zoom-eko API-aren sekretua (secret)';
$string['apisecret_desc'] = 'JWT 2023ko ekainean baztertuko da';
$string['apiurl'] = 'Zoom-eko API-aren URLa';
$string['apiurl_desc'] = '';
$string['audio_both'] = 'Ordenagailuko audioa eta Telefonoa';
$string['audio_telephony'] = 'Telefonoa soilik';
$string['audio_voip'] = 'Ordenagailuko audioa soilik';
$string['audiodefault'] = 'Lehenetsitako audioa';
$string['authentication'] = 'Autentifikazioa';
$string['autorecording_cloud'] = 'Hodeia';
$string['autorecording_local'] = 'Lokala';
$string['autorecording_none'] = 'Bat ere ez';
$string['autorecording_userdefault'] = 'Erabili Zoom erabiltzailearen ezarpen lehenetsiak';
$string['autorecordingoptionsupdate'] = 'Eguneratu grabazio automatikoaren aukerak';
$string['breakoutrooms'] = 'Banaketa-gelak';
$string['cachedef_oauth'] = 'Zoom OAuth gakoaren cachea';
$string['cachedef_zoomid'] = 'Erabiltzailearen Zoom-eko erabiltzaile-IDa';
$string['cachedef_zoommeetingsecurity'] = 'Zoom bileren segurtasun ezarpenak, kontuaren bileraren pasahitz eskakizunak barne';
$string['calendardescriptionURL'] = 'Bilerara sartzeko URLa: {$a}.';
$string['calendardescriptionintro'] = 'Deskribapena: {\\$a}';
$string['calendariconalt'] = 'Egutegiaren ikonoa';
$string['changehost'] = 'Aldatu aurkezlea';
$string['clickjoin'] = 'Bilerara sartzeko botoian klik egin du';
$string['clientid'] = 'Zoom bezeroaren IDa';
$string['clientid_desc'] = '';
$string['clientsecret'] = 'Zoom bezeroaren sekretua';
$string['clientsecret_desc'] = '';
$string['connectionfailed'] = 'Konexioak huts egin du:';
$string['connectionok'] = 'Konexioa martxan dago.';
$string['connectionsettings'] = 'Konexioaren ezarpenak';
$string['connectionsettings_desc'] = 'Ezarpen hauek Moodle Zoom-era nola konektatuko den zehazten dute.';
$string['connectionstatus'] = 'Konexioaren egoera';
$string['day'] = 'Eguna(k)';
$string['defaultsettings'] = 'Zoom-eko ezarpen lehenetsiak';
$string['defaultsettings_help'] = 'Ezarpen hauetan Zoom-eko bilera eta webinarrak sortzean erabiliko diren balio lehenetsiak zehazten dira.';
$string['deletemeetingrecordings'] = 'Ezabatu bileraren grabazioak Moodletik';
$string['deleteroom'] = 'Ezabatu gela';
$string['displayleadtime'] = 'Erakutsi irekitze-unea';
$string['displayleadtime_desc'] = 'Gaituz gero, erabiltzaileei bileraren irekitze-unea erakutsiko zaie. Modu honetan erabiltzaileei bilera hasi aurretik noiz konektatu ahalko diren jakinaraziko zaie eta erabiltzaileek orria behin eta berriz freskatzen ibiltzea neurri batean saihestu daiteke.';
$string['displayleadtime_nohideif'] = 'Kontuan izan, mesedez: Ezarpen hau soilik aplikatzen da \'{$a}\' ezarpenak 0 baino handiagoa den balio bat badauka.';
$string['displaypassword'] = 'Erakutsi pasahitza';
$string['displaypassword_help'] = 'Gaituz gero bileraren pasahitza hostalari ez direnei beti erakutsiko zaie.';
$string['downloadical'] = 'Jaitsi iCal formatuan';
$string['downloadical_desc'] = 'Ezarpen honekin, bilerarentzako iCal fitxategia deskargatzeko esteka jardueraren instantziaren aurrebistaren orrian erakustea edo ez kontrolatu dezakezu. Ezarpen honek hirugarrengoen tresnek iCal fitxategiak deskargatzeko aukerari soilik eragiten die. Ezarpen honen balioa edozein izanda ere, Zoom bileraren jardueraren ekitaldia Moodleko egutegira gehituko da hasiera-data zehazten denean.';
$string['downloadical_disable'] = 'Desgaitu iCal deskargatzeko esteka';
$string['downloadical_enable'] = 'Gaitu iCal deskargatzeko esteka';
$string['duration'] = 'Iraupena (minututan)';
$string['encryptiontype'] = 'Zifratze-mota';
$string['encryptiontype_alwaysshow'] = 'Erakutsi beti zifratze-motaren hautatzailea erabiltzaileak muturretik muturrerako zifratzea erabili ahal ez badu ere.';
$string['encryptiontype_desc'] = 'Ezarpen honen bitartez, erabiltzaileei muturretik muturrerako zifratzea eta zifratze hobetuaren artean hautatzeko aukera erakutsi edo ez kontrolatu dezakezu. Ezarpen honek Moodleko jarduera-instantziaren ezarpenei soilik eragiten dio. Aukera hau beti erakustea aukeratzen baduzu ere, erabiltzaileak muturretik muturrerako zifratzea izan beharko du Zoom-en muturretik muturrerako zifratzea gaitzeko.';
$string['encryptiontype_disable'] = 'Desgaitu zifratze-mota aukeratzeko menua';
$string['encryptiontype_showonlyife2epossible'] = 'Erakutsi zifratze-mota aukeratzeko menua soilik erabiltzaileak muturretik muturrerako (end-to-end) zifratzea erabili ahal badu.';
$string['end_date_option_after'] = 'Saio kopuru hauen ondoren:';
$string['end_date_option_by'] = 'Data honetan:';
$string['end_date_option_occurrences'] = 'errepikapen';
$string['enddate'] = 'Amaiera-data';
$string['endtime'] = 'Amaiera';
$string['err_downloadicaldisabled'] = 'Zoom-eko bileraren iCal fitxategien deskarga desgaituta dago.';
$string['err_downloadicalrecurringempty'] = 'Ezin da Zoom bilera honen iCal fitxategia jaitsi gutxienez gertakaria bat izan behar duelako.';
$string['err_downloadicalrecurringnofixed'] = 'Ezin da Zoom bilera honen iCal fitxategia jaitsi denbora-mugarik gabeko bilera errepikakorra delako.';
$string['err_duration_nonpositive'] = 'Iraupena positiboa izan behar da.';
$string['err_duration_too_long'] = 'Iraupenak ezin du 150 minutu baino gehiagokoa izan.';
$string['err_end_date'] = 'Errepikapenaren amaiera-data ezin da iraganekoa izan';
$string['err_end_date_before_start'] = 'Errepikapenaren amaiera-data ezin da hasiera-data baino lehenagokoa izan';
$string['err_invalid_password'] = 'Sarbide-kodeak karaktere baliogabeak ditu.';
$string['err_long_timeframe'] = 'Eskatutako denbora-tartea luzeegia da, tarteko azken hilabeteko emaitzak erakutsiko dira.';
$string['err_password'] = 'Sarbide-kodean hurrengo karaktereak baino ezin dira erabili: [a-z A-Z 0-9 @ - _ *]. Gehienez 10 karaktere.';
$string['err_password_required'] = 'Sarbide-kodea behar da.';
$string['err_repeat_monthly_interval'] = 'Hilabetekako bileren gutxieneko maiztasuna 3 hilabetekoa da';
$string['err_repeat_weekly_interval'] = 'Astekako bileren gutxieneko maiztasuna 12 astekoa da';
$string['err_start_time_past'] = 'Hasiera-data ezin da iraganekoa izan.';
$string['err_start_time_past_recurring'] = 'Bilera errepikakorren kasuan, eremu honetako data-tartea hurrengo bilerarako datarik gertuena izango da. Data hau gaurkoa ala etorkizunekoa izan behar da.';
$string['err_weekly_days'] = 'Aukeratu asteroko bilera errepikakorraren eguna(k)';
$string['erroraddinstance'] = 'Ezin izan da zoom bilera berria sortu. Bilera errepikakorraren ezarpen baliogabeak aukeratu dira.';
$string['errorwebservice'] = 'Zoom-eko web-zerbitzuaren errorea: {$a}.';
$string['errorwebservice_badrequest'] = 'Zoom-ek eskaera baliogabea jaso du: {$a}';
$string['errorwebservice_notfound'] = 'Baliabidea ez da existitzen';
$string['export'] = 'Esportatu';
$string['externaluser'] = 'Kanpoko erabiltzailea';
$string['firstjoin'] = 'Bilera aurretik sartzeko denbora-tartea';
$string['firstjoin_desc'] = 'Programatutako bilera bat hasi aurretik erabiltzaileak sartu daitezkeen denbora-tartea (hasiera aurretiko minutuak).';
$string['getmeetingrecordings'] = 'Eskuratu bileraren grabazioak Zoom-etik';
$string['getmeetingreports'] = 'Eskuratu bileraren txostena Zoom-etik';
$string['globalsettings'] = 'Ezarpen orokorrak';
$string['globalsettings_desc'] = 'Ezarpen hauek Zoom-eko plugin osoan aplikatzen dira.';
$string['host'] = 'Aurkezlea';
$string['hostintro'] = '<a target="_blank" href="https://support.zoom.us/hc/en-us/articles/208220166">Aurkezle gehigarriek</a> Zoom bilerak hasi eta Itxaron-gela kudeatu ahal dute.';
$string['indicator:cognitivedepth'] = 'Zoom kognitiboa';
$string['indicator:cognitivedepth_help'] = 'Adierazle hau ikasleak Zoom jardueran lortutako sakonera kognitiboan oinarrituta dago.';
$string['indicator:socialbreadth'] = 'Zoom soziala';
$string['indicator:socialbreadth_help'] = 'Adierazle hau ikasleak Zoom jardueran lortutako zabalera sozialean oinarrituta dago.';
$string['instanceusers'] = 'Egiaztatu instantziako erabiltzaileak';
$string['instanceusers_desc'] = '\'Birdefinitu lizentziak\' ezarpena gaituta badago eta ezarpen hau ere gaitzen bada, soilik Moodle instantzia honetako erabiltzaileen lizentziak egiaztatuko dira. Erabilgarria Zoom-eko lizentzia multzo bakarra hainbat instantzietatik erabiltzeko konfiguratuta badago.';
$string['invalid_status'] = 'Egoera baliogabea, datu-basea egiaztatu ezazu.';
$string['invalidscheduleuser'] = 'Ezin duzu saioa zehaztutako erabiltzailearentzat programatu.';
$string['invitation_dialin'] = 'Ahots-konferentziaren patroia';
$string['invitation_dialin_help'] = 'Zoom bileraren ahots-konferentziaren zenbakiak aurkitzeko adierazpen erregularraren patroia';
$string['invitation_h323'] = 'H.323 mezuen patroia';
$string['invitation_h323_help'] = 'Zoom bileraren H.323 informazioa aurkitzeko adierazpen erregularraren patroia. Zure gonbidapenak ez badu SIP edo H.323 elementurik, adierazpen erregularraren patroia hutsik utzi ezazu. (Hau arazketa gaituta daukaten zerbitzarietarako da, honek iCal esportatzea bezalako fitxategi-mota berezien formatua apurtu dezakeelako.)';
$string['invitation_icallink'] = 'iCal esteka-mezuaren patroia';
$string['invitation_icallink_help'] = 'Zoom bileraren iCal esteka aurkitzeko adierazpen erregularraren patroia.';
$string['invitation_invite'] = 'Gonbidapen-mezuaren patroia';
$string['invitation_invite_help'] = 'Zoom bileraren gonbidapen-mezua aurkitzeko adierazpen erregularraren patroia.';
$string['invitation_joinurl'] = 'Sarrerako URLaren patroia';
$string['invitation_joinurl_help'] = 'Zoom bileraren sarrerako URLa aurkitzeko adierazpen erregularraren patroia.';
$string['invitation_onetapmobile'] = 'Ttap bakarreko mugikorraren patroia';
$string['invitation_onetapmobile_help'] = 'Zoom bileraren ttap bakarreko mugikorraren xehetasunak aurkitzeko adierazpen erregularraren patroia.';
$string['invitation_sip'] = 'SIP patroia';
$string['invitation_sip_help'] = 'Zoom bileraren SIP informazioa aurkitzeko adierazpen erregularraren patroia. Zure gonbidapenak ez badu SIP edo H.323 elementurik, adierazpen erregularraren patroia hutsik utzi ezazu. (Hau arazketa gaituta daukaten zerbitzarietarako da, honek iCal esportatzea bezalako fitxategi-mota berezien formatua apurtu dezakeelako.)';
$string['invitationmatchnotfound'] = 'Ez da "{$a->element}" elementurako Zoom-eko gonbidapenik aurkitu "{$a->pattern}" patroiarekin.';
$string['invitationmodificationfailed'] = 'Errorea "{$a->element}" elementuaren Zoom-eko gonbidapenaren "{$a->pattern}" patroiaren adierazpen erregularrean.';
$string['invitationregex'] = 'Zoom gonbidapenen adierazpen erregularrak eta baimenak';
$string['invitationregex_help'] = 'Zehaztu adierazpen erregularraren patroiak Zoom-eko gonbidapenaren atal bakoitza banatzeko ondoren baimenen arabera kontrolatuak izan daitezen.';
$string['invitationregex_nohideif'] = 'Kontua izan mesedez: adierazpen erregularraren patroiak soilik erabiliko dira \'{$a}\' ezarpena gaituta badago.';
$string['invitationregexenabled'] = 'Gaitu Zoom gonbidapenen adierazpen erregularrak eta baimenak.';
$string['invitationregexenabled_help'] = 'Gaituz gero, jardueran erakutsitako zoom gonbidapena hurrengo adierazpen erregularra erabilita elementuetan zatituko da eta baimenak erabiliko dira atal bakoitza erabiltzaile bakoitzari erakustea erabakitzeko. Ikusi zoom/viewjoinurl eta zoom/viewdialin baimenak.';
$string['invitationremoveicallink'] = 'Kendu zoom gonbidapenaren iCal esteka';
$string['invitationremoveicallink_help'] = 'Gaituz gero, zoom bileraren e-mail mezuan gehitu daitekeen iCal esteka invitation_icallink adierazpen erregularraren patroia erabilita kenduko da.';
$string['invitationremoveinvite'] = 'Kendu Zoom gonbidapenaren gonbidapen-mezua';
$string['invitationremoveinvite_help'] = 'Gaituz gero, Zoom bilerako e-mail mezuaren sarrerako esaldia zatituko da invitation_invite adierazpen erregularreko patroia erabilita.';
$string['join'] = 'Sartu';
$string['join_meeting'] = 'Sartu Bileran';
$string['joinbeforehost'] = 'Bileran aurkezlearen aurretik sartzea';
$string['joinbeforehostenable'] = 'Baimendu partaideak edozein unetan sartzea';
$string['joinlink'] = 'Sartzeko esteka';
$string['jointime'] = 'Sarrera-unea';
$string['leavetime'] = 'Ateratze-unea';
$string['licenseonjoin'] = 'Markatu aukera hau aurkezleak, bilera sortzean lizentzia jasotzeaz <i>gain</i>, bilera hastean <i>ere</i> lizentzia bat jasotzea nahi baduzu.';
$string['licensesettings'] = 'Lizentziaren ezarpenak';
$string['licensesettings_desc'] = 'Ezarpen hauek Moodlek zure Zoom-eko lizentziak nola kudeatuko dituen zehazten dute.';
$string['licensesnumber'] = 'Lizentzia kopurua';
$string['lowlicenses'] = 'Zure lizentziak hemen zehaztutakoak baino gehiago badira, erabiltzaileak jarduera berri bat sortzen duenean PRO lizentzia bat esleituko zaio beste erabiltzaile bati kenduta. Aukera hau erabilgarria da gaituta dauden PRO lizentziak 5 baino gehiago badira.';
$string['maskparticipantdata'] = 'Ezkutatu partaideen datuak';
$string['maskparticipantdata_help'] = 'Partaideen datuak txostenetan agertzea eragozten du (erabilgarria erabiltzaileen datuak ezkutatzen dituzten guneentzat, esaterako datuen babeserako politikak direla-eta).';
$string['media'] = 'Multimedia';
$string['meeting_finished'] = 'Amaituta';
$string['meeting_invite'] = 'Telefono/Ahots-konferentzia informazioa';
$string['meeting_invite_hide'] = 'Ezkutatu bileraren gonbidapena';
$string['meeting_invite_show'] = 'Erakutsi bileraren gonbidapena';
$string['meeting_nonexistent_on_zoom'] = 'Ez da Zoom-en existitzen';
$string['meeting_not_started'] = 'Hasi gabea';
$string['meeting_started'] = 'Abian';
$string['meeting_time'] = 'Hasiera';
$string['meetingcapacitywarning'] = 'Bileraren edukierari buruzko oharra';
$string['meetingcapacitywarning_desc'] = 'Ezarpen honen bitartez, ikastaroan matrikulatutako erabiltzaile aktiboak aurkezlearen Zoom lizentziak baimentzen duen bileraren edukiera baino gehiago badira oharra erakutsi ahal duzu. Oharra aurkezleari erakutsiko zaio (baita aurkezle gehigarriei ere) Zoom jardueraren aurrebista-orrian. Aurkezleari Zoom kontuaren kudeatzailearekin harremanetan jartzea gomendatuko zaio behar izanez gero Zoom lizentzia handiago bat eskuratzeko. Mezu hau Moodleko hizkuntza-pertsonalizazioaren bidez aldatu dezakezu.';
$string['meetingcapacitywarning_disable'] = 'Desgaitu bileraren edukierari buruzko oharra';
$string['meetingcapacitywarning_enable'] = 'Gaitu bileraren edukierari buruzko oharra';
$string['meetingcapacitywarningbodyalthost'] = 'Bileraren aurkezlearen ({$a->hostname}) Zoom lizentziak bilera bakoitzeko <strong>{$a->meetingcapacity} partaideko</strong> edukiera-muga dauka, baina ikastaro honek <strong><a href="{$a->courseparticipantsurl}">{$a->eligiblemeetingparticipants} partaide aktibo ditu matrikulatuta</a></strong>.';
$string['meetingcapacitywarningbodyrealhost'] = 'Zure Zoom lizentziak bilera bakoitzeko <strong><a href="{$a->zoomprofileurl}" target="_blank">{$a->meetingcapacity} partaideko</a></strong> edukiera-muga dauka, baina ikastaro honek <strong><a href="{$a->courseparticipantsurl}">{$a->eligiblemeetingparticipants} partaide aktibo ditu matrikulatuta</a></strong>.';
$string['meetingcapacitywarningcontactalthost'] = 'Ikastaroko partaide guztiak bilerara sartu behar badira, esaiozu mesedez aurkezleari Zoom-eko kontuaren kudeatzailearekin harremanetan jartzeko Zoom lizentzia handiago bat eskatzeko.';
$string['meetingcapacitywarningcontactrealhost'] = 'Ikastaroko partaide guztiak bilerara sartu behar badira, zure Zoom-eko kontuaren kudeatzailearekin harremanetan jarri zaitez Zoom lizentzia handiago bat eskatzeko.';
$string['meetingcapacitywarningheading'] = 'Bileraren edukierari buruzko oharra:';
$string['meetingparticipantsdeleted'] = 'Bilerako partaideen erabiltzaile-datuak ezabatu dira.';
$string['meetingrecordingviewsdeleted'] = 'Bilerako grabazio-ikusteen erabiltzaile-datuak ezabatu dira.';
$string['modulename'] = 'Zoom bilera';
$string['modulename_help'] = 'Zoom bideo eta web-konferentzietarako plataforma bat da, eta baimendutako erabiltzaileei online bilerak antolatzeko aukera ematen die.';
$string['modulenameplural'] = 'Zoom bilerak';
$string['month'] = 'Hilabete';
$string['month_day_text'] = '(hilabetearena)';
$string['newmeetings'] = 'Bilera berriak';
$string['nextoccurrence'] = 'Hurrengo gertakaria';
$string['nomeetinginstances'] = 'Ez da bilera honetako saiorik aurkitu.';
$string['nooccurrenceleft'] = 'Azken gertakaria dagoeneko amaitu da';
$string['noparticipants'] = 'Une honetan ez da saio honentzako partaiderik aurkitu.';
$string['norecordings'] = 'Ez da bilera honetako grabaziorik aurkitu une honetan.';
$string['norooms'] = 'Gelarik ez';
$string['nosessions'] = 'Ez da saiorik aurkitu zehaztutako tartean.';
$string['nozooms'] = 'Bilerarik ez';
$string['nozoomsfound'] = 'Ez da bilerarik aurkitu ikastaro honetan.';
$string['occurson'] = 'Gertakaria';
$string['off'] = 'Itzali';
$string['oldmeetings'] = 'Amaitutako bilerak';
$string['on'] = 'Piztu';
$string['option_allow_recording_change'] = 'Baimendu grabazioa aldatzea';
$string['option_allow_recording_change_help'] = 'Baimendu erabiltzaileari grabazioaren konfigurazioa aldatzea jarduera sortzerakoan';
$string['option_audio'] = 'Audio aukerak';
$string['option_audio_help'] = 'Aukera honen bitartez, erabiltzaileei soilik telefonoa, soilik ordenagailuko audioa edo biak erabiltzeko aukera baimendu dezakezu.';
$string['option_authenticated_users'] = 'Behartu erabiltzaileen autentifikazioa sartzeko';
$string['option_authenticated_users_help'] = 'Aukera hau gaituz gero, partaide guztiek euren Zoom-eko kontu baimenduarekin saioa hasi beharko dute bileran sartu ahal izateko. Honek <em>ez</em> dauka inolako loturarik Moodlen saioa hastearekin.';
$string['option_auto_recording'] = 'Grabazio automatikoa';
$string['option_auto_recording_help'] = 'Aukera hau markatuta bilera automatikoki grabatuko da';
$string['option_encryption_type'] = 'Zifratzea';
$string['option_encryption_type_endtoendencryption'] = 'Muturretik muturrerako zifratzea';
$string['option_encryption_type_enhancedencryption'] = 'Zifratze hobetua';
$string['option_encryption_type_help'] = 'Aukera honen bitartez, bilera honetako zifratze-maila kontrolatu dezakezu.
*Zifratze hobetua* erabiliz gero zifratze-gakoak Zoom-eko hodeian gordetzen da.
*Muturretik muturrerako zifratzea* erabiliz gero zifratze-gakoak zure gailu lokalean gordetzen dira eta beste inork ez dauka zifratze-gako horietarako sarbiderik, ezta Zoom-ek ere.
Kontuan izan mesedez muturretik muturrerako zifratzea gaituz gero hainbat funtzionalitate ez direla eskuragarri egongo - [Ikusi xehetasunak Zoom-eko dokumentazioan](https://support.zoom.us/hc/en-us/articles/360048660871).';
$string['option_host_video'] = 'Aurkezlearen bideoa';
$string['option_host_video_help'] = 'Aukera hau gaituta aurkezlea bilerara sartzen denean bere bideoa gaituko da. Aukera hau desgaituz gero, aurkezleak gerora bideoa gaitu ahalko du.';
$string['option_jbh'] = 'Aurkezlearen aurretik sartzea';
$string['option_jbh_help'] = 'Aukera hau gaituta partaideei aurkezlearen aurretik (edo sartu ezin duenean) bilerara sartzeko aukera ematen zaie.
Aukera hau ez da \'Itxaron-gela\' aukerarekin bateragarria, eta beraz bat aukeratuta bestea desgaituko da.';
$string['option_mute_upon_entry'] = 'Mututu partaideak sartzean';
$string['option_mute_upon_entry_help'] = 'Aukera hau gaituta bilerara sartzen direnean partaide guztiak automatikoki mututuko dira. Sartu ondoren partaideek euren audioa gaitu dezakete.';
$string['option_participants_video'] = 'Partaideen bideoa';
$string['option_participants_video_help'] = 'Aukera hau gaituta partaideak bilerara sartzen direnean auren bideoa gaituko da. Aukera hau desgaituz gero, partaideek gerora bideoa gaitu ahalko dute.';
$string['option_proxyhost'] = 'Proxy-a erabili';
$string['option_proxyhost_desc'] = 'Hemen zehaztutako proxy-a, \'<code>&lt;hostalaria&gt;:&lt;ataka&gt;</code>\' formatuarekin, Zoom-ekin konektatzeko erabiliko da. Hutsik utzi ezazu Moodleko berezko proxy ezarpenak erabiltzeko. Aukera hau soilik da erabilgarria proxy hau Moodle osokoa ez izatea nahi baduzu.';
$string['option_view_recordings'] = 'Baimendu grabazioak ikusi ahal izatea';
$string['option_waiting_room'] = 'Itxaron-gela';
$string['option_waiting_room_help'] = 'Aukera hau gaituta aurkezleak partaideak bilerara noiz sartzen diren kontrolatu dezake.
Aukera hau ez da \'Aurkezlearen aurretik sartzea\' aukerarekin bateragarria, eta beraz bat aukeratuta bestea desgaituko da.';
$string['participantdatanotavailable'] = 'Xehetasunak ez daude eskuragarri';
$string['participantdatanotavailable_help'] = 'Partaideen datuak ez daude eskuragarri Zoom bilera honetan (esaterako datuen babeserako politika direla-eta).';
$string['participantgroups'] = 'Parte-hartzaile taldeak';
$string['participants'] = 'Partaideak';
$string['password'] = 'Sarbide-kodea';
$string['password_allowed_char'] = 'Pasahitzak soilik hurrengo karaktereak izan ditzake: [a-z A-Z 0-9 @ - _ *].';
$string['password_consecutive'] = 'Gehieneko elkarren segidako {$a} karaktere (abcd, 1111, 1234, etab.).';
$string['password_length'] = 'Gutxieneko {$a} karaktere.';
$string['password_letter'] = 'Pasahitzak gutxienez letra bat izan behar du.';
$string['password_lower_upper'] = 'Pasahitzak letra larri eta xeheak izan behar ditu.';
$string['password_max_length'] = '10 karaktere gehienez.';
$string['password_number'] = 'Pasahitzak gutxienez zenbaki 1 izan behar du.';
$string['password_only_numeric'] = 'Pasahitzak zenbakiak soilik eta beste karaktererik ez izan ditzake.';
$string['password_special'] = 'Pasahitzak gutxienez karaktere berezi bat izan behar du (@-_*).';
$string['passwordprotected'] = 'Sarbide-kodez babestua';
$string['pluginadministration'] = 'Kudeatu Zoom bilera';
$string['pluginname'] = 'Zoom bilera';
$string['privacy:metadata:zoom_breakout_participants'] = 'Zoom bileren banatze-gelen partaideen zerrenda gordetzeko datu-baseko taula';
$string['privacy:metadata:zoom_breakout_participants:userid'] = 'Parte hartzen duen erabiltzailearen IDa';
$string['privacy:metadata:zoom_meeting_details'] = 'Bilera-instantzia bakoitzaren informazioa gordetzen duen datu-baseko taula.';
$string['privacy:metadata:zoom_meeting_details:topic'] = 'Erabiltzaileak parte hartu zueneko bileraren izena.';
$string['privacy:metadata:zoom_meeting_participants'] = 'Bilerako partaideen inguruko informazioa gordetzen duen datu-baseko taula.';
$string['privacy:metadata:zoom_meeting_participants:duration'] = 'Erabiltzailea bileran egon zeneko denbora';
$string['privacy:metadata:zoom_meeting_participants:join_time'] = 'Erabiltzailea bileran sartu zeneko unea';
$string['privacy:metadata:zoom_meeting_participants:leave_time'] = 'Erabiltzailea bileratik irten zeneko unea';
$string['privacy:metadata:zoom_meeting_participants:name'] = 'Partaidearen izena';
$string['privacy:metadata:zoom_meeting_participants:user_email'] = 'Partaidearen helbide elektronikoa';
$string['privacy:metadata:zoom_meeting_view'] = 'Bileren grabazioak ikusten dituzten erabiltzaileen jarraipena egiteko datu-baseko taula.';
$string['privacy:metadata:zoom_meeting_view:userid'] = 'Grabazioa ikusi duen erabiltzailearen IDa.';
$string['recording'] = 'Grabazioa';
$string['recordingadd'] = 'Gehitu Grabazioa';
$string['recordingdate'] = 'Grabazioaren Data';
$string['recordingdelete'] = 'Ziur zaude "{$a}" grabazioa ezabatu nahi duzula?';
$string['recordinghide'] = 'Ezkutatu Grabazioa (orain ikusgai)';
$string['recordinglink'] = 'Grabazioaren Esteka';
$string['recordingname'] = 'Izenburua';
$string['recordingnotfound'] = 'Ezin izan da grabazioa aurkitu';
$string['recordingnotvisible'] = 'Grabazioa ez dago ikusgai. Hau errore bat dela uste baduzu jarri zaitez harremanetan zure guneko kudeatzailearekin.';
$string['recordingpasscode'] = 'Grabazioaren Pasahitza';
$string['recordings'] = 'Grabazioak';
$string['recordingshow'] = 'Erakutsi Grabazioa (orain ezkutuan)';
$string['recordingshowtoggle'] = 'Aldatu Erakutsi Grabazioa';
$string['recordingtypeaudio'] = 'Audioa soilik';
$string['recordingtypevideo'] = 'Bideoa eta Audioa';
$string['recordingurl'] = 'Grabazioaren URLa';
$string['recordingview'] = 'Ikusi Grabazioak';
$string['recordingvisibility'] = 'Bilera honetako grabazioak ikusgai egongo dira modu lehenetsian?';
$string['recordingvisibility_help'] = 'Bilera honetako grabazio berriak eskuratzen direnean, Moodlen ikusgai egon behar dira modu lehenetsian?';
$string['recreatesuccessful'] = 'Bilera berriz ondo sortu da.';
$string['recurrence_option_daily'] = 'Egunero';
$string['recurrence_option_monthly'] = 'Hilabetero';
$string['recurrence_option_no_time'] = 'Denbora-tartetik gabe';
$string['recurrence_option_weekly'] = 'Astero';
$string['recurrencetype'] = 'Errepikapena';
$string['recurringmeeting'] = 'Bilera errepikakorra';
$string['recurringmeeting_help'] = 'Aukera hau gaituz gero bilera errepikakorra bihurtuko da eta ez du amaiera datarik izango. Modu honetan bilerara edozein unetan sartu ahalko da.';
$string['recurringmeetingexplanation'] = 'Bilerak ez dauka amaiera-datarik';
$string['recurringmeetinglong'] = 'Bilera errepikakorra (bilerak ez dauka hasiera eta amaierarik)';
$string['recurringmeetingthisis'] = 'Bilera hau errepikakorra da';
$string['recycleonjoin'] = 'Birziklatu lizentzia sartzean';
$string['redefinelicenses'] = 'Birdefinitu lizentziak';
$string['refreshreports'] = 'Freskatu saioen txostenak';
$string['register'] = 'Erregistroa';
$string['registration'] = 'Behartu erregistratzea';
$string['registration_help'] = 'Aukera hau gaituta parte-hartzaileek Zoom bilera/webinarrean sartu aurretik erregistratu beharko dute.';
$string['registration_text'] = 'Behartu bilera/webinarreko parte-hartzaileen erregistroa';
$string['repeatinterval'] = 'Errepikapen-maiztasuna';
$string['report'] = 'Txostenak';
$string['reportapicalls'] = 'Report API deiak agortuta';
$string['requirepasscode'] = 'Behartu bileraren pasahitza';
$string['requirepasscode_help'] = 'Aukera hau gaituta aurkezleak bilerarako pasahitza zehaztu beharko du. Bilerara Moodle bitartez sartzen diren partaideek ez dute pasahitz hori sartu behar izango, baina beste partaideek pasahitz hori sartu beharko dute.';
$string['resetapicalls'] = 'Berrabiarazi eskuragarri dauden API deien kopurua';
$string['resetzoomsall'] = 'Ezabatu erabiltzaile guztien kalifikazioak, grabazio-ikusteen erabiltzaile-datuak eta bilerako partaideen erabiltzaile-datuak.';
$string['room'] = 'Gela';
$string['roomname'] = 'Gelaren izena';
$string['rooms'] = 'Gelak';
$string['schedule'] = 'Programazioa';
$string['schedulefor'] = 'Programatu bilera aurkezle honentzat:';
$string['schedulefor_help'] = 'Bilerak beste erabiltzaile baten izenean programatu ditzakezu. Horretarako aurretik erabiltzaile horrek zuri Zoom-en baimen hori eman behar dizu. Aukeratutako erabiltzailea izango da bileraren aurkezlea eta bilerarako bere Zoom-eko lizentzia erabiliko da.';
$string['scheduleforself'] = 'Zu zeu';
$string['schedulingprivilege'] = 'Programatze-baimena';
$string['schedulingprivilege_desc'] = 'Ezarpen honen bitartez erabiltzaileei jarduera-instantziaren ezarpenetan programatze-baimena erakutsiko zaien ala ez kontrolatu dezakezu. Ezarpen honek soilik Moodleko jarduera-instantziaren ezarpenei eragiten die. Aukera hau erakustea erabakitzen baduzu ere, erabiltzaile batek bilera bat beste erabiltzailearen izenean programatu ahal izateko Zoom-en beste erabiltzaile horren izenean saioak programatzeko baimena jaso behar du.';
$string['schedulingprivilege_disable'] = 'Desgaitu programatze-baimenaren aukera';
$string['schedulingprivilege_enable'] = 'Gaitu programatze-baimenaren aukera';
$string['search:activity'] = 'Zoom - jardueraren informazioa';
$string['security'] = 'Segurtasuna';
$string['selectionarea'] = 'Aukerarik ez';
$string['sessions'] = 'Saioak';
$string['sessionsreport'] = 'Saioen txostena';
$string['sesskeyinvalid'] = 'Saio baliogabea antzeman da. Ezin da jarraitu.';
$string['setpasscode'] = 'Zehaztu pasahitza';
$string['showmedia'] = 'Erakutsi Multimedia atala';
$string['showmedia_help'] = 'Aukera hau gaitzean Multimedia atala bileraren jarduera-orrian erakutsiko da.';
$string['showmediaonview'] = 'Erakutsi Multimedia atala bileraren orrian';
$string['showschedule'] = 'Erakutsi Programazioa atala';
$string['showschedule_help'] = 'Aukera hau gaitzean Programazioa atala bileraren jarduera-orrian erakutsiko da.';
$string['showscheduleonview'] = 'Erakutsi Programazioa atala bileraren orrian';
$string['showsecurity'] = 'Erakutsi Segurtasuna atala';
$string['showsecurity_help'] = 'Aukera hau gaitzean Segurtasuna atala bileraren jarduera-orrian erakutsiko da.';
$string['showsecurityonview'] = 'Erakutsi Segurtasuna atala bileraren orrian';
$string['start'] = 'Hasi';
$string['start_meeting'] = 'Hasi Bilera';
$string['start_time'] = 'Hasiera';
$string['starthostjoins'] = 'Gaitu bideoa aurkezlea sartzean';
$string['startpartjoins'] = 'Gaitu bideoa partaideak sartzean';
$string['starttime'] = 'Hasiera-data';
$string['status'] = 'Egoera';
$string['supplementaryfeaturessettings'] = 'Funtzio gehigarrien ezarpenak';
$string['supplementaryfeaturessettings_desc'] = 'Ezarpen hauek Zoom-eko funtzio gehigarriak erabiltzaileei erakutsiko zaizkien eta nola erakutsiko diren kontrolatzen dute.';
$string['title'] = 'Izenburua';
$string['topic'] = 'Gaia';
$string['trackingfields'] = 'Jarraitutako eremuak';
$string['trackingfields_help'] = 'Idatzi jarraitutako eremuen komaz banatutako izenak/etiketak, Zoom jardueretan gaitzeko.';
$string['trackingfields_recommendedvalues'] = 'Gomendatuko balioak';
$string['unavailable'] = 'Ezin zara une honetan sartu.';
$string['unavailablefinished'] = 'Bilera dagoeneko amaitu da.';
$string['unavailablefirstjoin'] = 'Bilera honetara hasiera-data baino {$a->mins} minutu lehenago sartu ahalko zara.';
$string['unavailablenotstartedyet'] = 'Bilera oraindik ez da hasi.';
$string['updatemeetings'] = 'Eguneratu bileraren ezarpenak Zoom-etik';
$string['updatetrackingfields'] = 'Eguneratu Zoometik jarraitutako eremuen ezarpenak';
$string['usepersonalmeeting'] = 'Erabili bilerako {$a} ID pertsonala';
$string['waitingroom'] = 'Itxaron-gela';
$string['waitingroomenable'] = 'Gaitu itxaron-gela';
$string['webinar'] = 'Webinarra';
$string['webinar_already_false'] = '<p><b>Modulu hau dagoeneko bilera gisa konfiguratu zen, eta ez webinar gisa. Ezarpen hau ezin da bilera sortu ondoren aldatu.</b></p>';
$string['webinar_already_true'] = '<p><b>Modulu hau dagoeneko webinar gisa konfiguratu zen, eta ez bilera gisa. Ezarpen hau ezin da webinarra sortu ondoren aldatu.</b></p>';
$string['webinar_alwaysshow'] = 'Beti erakutsi webinarren aukera erabiltzaileak webinarrak antolatzeko lizentzia izan gabe ere';
$string['webinar_by_default'] = 'Webinarra modu lehenetsian';
$string['webinar_by_default_desc'] = 'Sortu Zoom instantziak webinar gisa modu lehenetsian.';
$string['webinar_desc'] = 'Ezarpen honen bitartez, bileraren sorreran erabiltzaileei webinarrak sortzeko aukera erakutsiko zaien kontrolatu dezakezu. Ezarpen honek soilik Moodleko jarduera-instantziaren ezarpenei eragiten die. Aukera hau beti erakustea erabakitzen baduzu ere, webinarrak aurkezteko erabiltzaileak webinarrak aurkezteko lizentzia baliagarria izan beharko du.';
$string['webinar_disable'] = 'Desgaitu webinarrak';
$string['webinar_help'] = 'Webinarrak aurkezleei audientzia handientzako kontrol eta malgutasun hobea eskaintzen die.
Aukera hau aurrez baimendutako Zoom kontuentzat soilik dago eskuragarri.';
$string['webinar_showonlyiflicense'] = 'Erakutsi webinarraren aukera soilik erabiltzaileak webinarrak aurkezteko baimena badauka.';
$string['webinarthisis'] = 'Hau webinar bat da';
$string['week'] = 'Aste';
$string['weekoption_first'] = 'Lehen';
$string['weekoption_fourth'] = 'Laugarren';
$string['weekoption_last'] = 'Azken';
$string['weekoption_second'] = 'Bigarren';
$string['weekoption_third'] = 'Hirugarren';
$string['zoom:addinstance'] = 'Gehitu Zoom bilera berri bat';
$string['zoom:eligiblealternativehost'] = 'Aurkezle gehigarri gisa aukeragarria Zoom bileretarako';
$string['zoom:refreshsessions'] = 'Freskatu Zoom bileraren txostenak';
$string['zoom:view'] = 'Ikusi Zoom bilerak';
$string['zoom:viewdialin'] = 'Ikusi Zoom-eko ahots-konferentzia informazioa';
$string['zoom:viewjoinurl'] = 'Ikusi Zoom-eko sarrerako URLa';
$string['zoomerr'] = 'Errore bat gertatu da Zoom-ekin.';
$string['zoomerr_alternativehostusernotfound'] = '{$a} erabiltzailea ez da Zoom-en aurkitu.';
$string['zoomerr_apilimit'] = 'API honetarako eguneko ratio-mugara heldu da. Saiatu berriro {$a}(e)tan';
$string['zoomerr_field_missing'] = '{$a} ez da aurkitu';
$string['zoomerr_id_missing'] = 'Ikastaro-moduluaren IDa edo instantziaren IDa zehaztu behar duzu';
$string['zoomerr_licensesnumber_missing'] = 'Zoom-eko utmost ezarpena aurkitu da, baina ez da licensesnumber ezarpena aurkitu';
$string['zoomerr_maxretries'] = 'Deia {$a->maxretries} aldiz egiten saiatu da, baina huts egin du: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Bilera hau ezin da Zoom-en aurkitu. <a href="{$a->recreate}">Hemen berriz sortu dezakezu</a> edo bestela <a href="{$a->delete}">guztiz ezabatu dezakezu</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Bilera hau ezin da Zoom-en aurkitu. Zalantzarik baduzu jarri zaitez harremanetan bileraren aurkezlearekin.';
$string['zoomerr_no_access_token'] = 'Ez da sarbide-tokenik bueltatu';
$string['zoomerr_usernotfound'] = 'Ezin izan da zure Zoom kontua aurkitu. Zoom erabiltzen ari zaren lehen aldia bada, zure Zoom kontua aktibatu behar duzu <a href="{$a}" target="_blank">{$a}</a> webgunean saioa hasita. Behin zure Zoom kontua aktibatu duzula, freskatu ezazu orri hau eta jarraitu ezazu bilera konfiguratzen. Bestela ziurtatu ezazu zure Moodleko helbide elektronikoa eta Zoom-ekoa bat datozela.';
$string['zoomerr_viewrecordings_off'] = 'Ikusi Grabazioak itzalita dago, ezin da ataza exekutatu.';
$string['zoomurl'] = 'Zoom-eko hasiera-orriaren URLa';
$string['zoomurl_desc'] = '';
