<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'da', version '4.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Fejl under indlæsning af blogindlæg';
$string['addon.blog.showonlyyourentries'] = 'Vis kun dine indlæg';
$string['addon.calendar.calendarevents'] = 'Kalenderbegivenheder';
$string['addon.calendar.calendarreminders'] = 'Kalenderpåmindelser';
$string['addon.calendar.defaultnotificationtime'] = 'Standard notifikationstidspunkt';
$string['addon.calendar.errorloadevent'] = 'Fejl ved indlæsning af begivenhed.';
$string['addon.calendar.errorloadevents'] = 'Fejl ved indlæsning af begivenheder.';
$string['addon.calendar.noevents'] = 'Der er ingen begivenheder';
$string['addon.calendar.reminders'] = 'Påmindelser';
$string['addon.calendar.setnewreminder'] = 'Opret en ny påmindelse';
$string['addon.competency.errornocompetenciesfound'] = 'Ingen kompetencer fundet';
$string['addon.competency.nocompetencies'] = 'Ingen kompetencer';
$string['addon.coursecompletion.complete'] = 'Fuldfør';
$string['addon.coursecompletion.couldnotloadreport'] = 'Kunne ikke indlæse rapporten vedrørende  kursusfuldførelse, prøv igen senere.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigurer enheder';
$string['addon.messages.contactlistempty'] = 'Kontaktlisten er tom';
$string['addon.messages.contactname'] = 'Navn';
$string['addon.messages.deletemessage'] = 'Slet besked';
$string['addon.messages.deletemessageconfirmation'] = 'Er du sikker på at du vil slette denne besked? Den vil kun forsvinde fra din historik, din samtalepartner vil stadig kunne se den.';
$string['addon.messages.errordeletemessage'] = 'Fejl under sletning af filen';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Fejl ved hentning af kontakter fra serveren';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Fejl ved hentning af diskussioner fra serveren';
$string['addon.messages.errorwhileretrievingmessages'] = 'Fejl ved hentning af beskeder fra serveren.';
$string['addon.messages.errorwhileretrievingusers'] = 'Fejl under hentning af brugere fra serveren.';
$string['addon.messages.messagenotsent'] = 'Beskeden blev ikke sendt, prøv igen senere.';
$string['addon.messages.newmessages'] = 'Nye beskeder';
$string['addon.messages.nousersfound'] = 'Ingen brugere fundet';
$string['addon.messages.showdeletemessages'] = 'Vis slet beskeder';
$string['addon.messages.type_blocked'] = 'Blokeret';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Søgeresultat';
$string['addon.messages.type_strangers'] = 'Andre';
$string['addon.messages.useentertosenddescdesktop'] = 'Er indstillingen deaktiveret, kan du bruge Ctrl+Enter til at sende beskeden.';
$string['addon.messages.useentertosenddescmac'] = 'Er indstillingen deaktivereret, kan du bruge Cmd+Enter til at sende beskeden.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Kunne ikke sende besked(er) til samtalen {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Kunne ikke sende besked(er) til brugeren {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Du skal acceptere afleveringserklæringen.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Du kan ikke tilføje eller redigere en opgaveaflevering i appen, da vi kunne ikke modtage afleveringserklæringen fra websiden.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Nogle karaktergivningsmetoder understøttes endnu ikke i appen og kan ikke ændres.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Du kan ikke aflevere til bedømmelse i appen da vi ikke kunne modtage afleveringserklæringen fra websiden.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Du kan ikke tilføje eller redigere en opgaveaflevering i appen, nogle plugins understøtter ikke redigering:';
$string['addon.mod_assign.errorshowinginformation'] = 'Vi kan ikke vise information om aflevering';
$string['addon.mod_assign.feedbacknotsupported'] = 'Denne Feedback understøttes ikke af appen og indeholder nok ikke alle informationer';
$string['addon.mod_assign.gradenotsynced'] = 'Karakterer ikke synkroniseret';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Deltagere uden afleveringer vises ikke';
$string['addon.mod_assign.submissionnotsupported'] = 'Denne aflevering understøttes ikke af appen og indeholder nok ikke alle informationer';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Karakter for opgaven er ændret på websiden.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Opgavebesvarelsen er ændret på websiden.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Fejl ved tilkobling til chatten.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Fejl ved hentning af chatdata.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Fejl ved hentning af chatbrugere.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Fejl ved hentning af beskeder fra serveren.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Fejl ved afsendelse af besked.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Du skal være online for at sende beskeder';
$string['addon.mod_chat.nosessionsfound'] = 'Ingen sessioner fundet';
$string['addon.mod_chat.showincompletesessions'] = 'Vis ufuldstændige sessioner';
$string['addon.mod_choice.errorgetchoice'] = 'Fejl ved hentning af valgte data';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% af brugerne vælger denne mulighed: {{test}}';
$string['addon.mod_choice.resultsnotsynced'] = 'Resultater medtager ikke dine seneste svar. Synkroniser for at opdatere dem.';
$string['addon.mod_data.errorapproving'] = 'Fejl under godkendelse eller afvisning af opslag.';
$string['addon.mod_data.errordeleting'] = 'Fejl under sletning af opslag.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Feedback med captcha kan ikke bruges offline hvis den ikke er konfigureret eller hvis serveren nede.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Denne feedback er gemt til aflevering senere.';
$string['addon.mod_folder.emptyfilelist'] = 'Der er ingen filer at vise.';
$string['addon.mod_forum.errorgetforum'] = 'Fejl ved hentning af forumdata.';
$string['addon.mod_forum.errorgetgroups'] = 'Fejl ved hentning af gruppeindstillinger.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Der er endnu ingen indlæg i dette forum.';
$string['addon.mod_forum.group'] = 'Gruppe';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} diskussioner';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} svar';
$string['addon.mod_forum.refreshposts'] = 'Genindlæs indlæg';
$string['addon.mod_glossary.browsemode'] = 'Skim indlæg';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetisk';
$string['addon.mod_glossary.byauthor'] = 'Grupper efter forfatter';
$string['addon.mod_glossary.bycategory'] = 'Gruppér efter kategori';
$string['addon.mod_glossary.bynewestfirst'] = 'Nyeste først';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Senest opdateret';
$string['addon.mod_glossary.bysearch'] = 'Søg';
$string['addon.mod_glossary.cannoteditentry'] = 'Kan ikke redigere opslaget';
$string['addon.mod_glossary.entriestobesynced'] = 'Opslag der skal synkroniseres';
$string['addon.mod_glossary.entrypendingapproval'] = 'Dette opslag afventer godkendelse';
$string['addon.mod_glossary.errorloadingentries'] = 'Der opstod en fejl under indlæsning af opslag';
$string['addon.mod_glossary.errorloadingentry'] = 'Der opstod en fejl under indlæsning af opslaget';
$string['addon.mod_glossary.errorloadingglossary'] = 'Der opstod en fejl under indlæsning af ordbogen.';
$string['addon.mod_glossary.noentriesfound'] = 'Ingen opslag fundet';
$string['addon.mod_glossary.searchquery'] = 'Søgeord';
$string['addon.mod_imscp.showmoduledescription'] = 'Vis beskrivelse';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Denne lektion har et spring til en tilfældig indholdsside, den kan ikke bruges i appen før den er startet på hjemmesiden.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Dette forsøg kan ikke længere gennemses da et nyt forsøg er fuldført.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Dette forsøg blev afsluttet offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Et offline forsøg er synkroniseret. Vil du gennemse det?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Dette forsøg blev afsluttet på websiden.';
$string['addon.mod_lti.errorgetlti'] = 'Fejl ved hentning af moduldata.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Din start-URL er ikke gyldig.';
$string['addon.mod_lti.launchactivity'] = 'Start aktiviteten';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Fejl ved indlæsning af siden.';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Denne quizbesvarelse kan ikke afleveres af følgende årsager:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Denne besvarelse er ikke synkroniseret siden {{$a}}. Hvis du har arbejdet videre på besvarelsen på en anden enhed siden da, kan du miste data.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Der opstod en fejl under forsøg på at gemme svarene. Er du sikker på at du vil forlade quizzen?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Quizzen kan ikke afvikles i appen, som ikke understøtter quizzens opførsel:';
$string['addon.mod_quiz.errordownloading'] = 'Fejl under download af de krævede data.';
$string['addon.mod_quiz.errorgetattempt'] = 'Kunne ikke hente forsøgsdata';
$string['addon.mod_quiz.errorgetquestions'] = 'Kunne ikke hente spørgsmål.';
$string['addon.mod_quiz.errorgetquiz'] = 'Kunne ikke hente quizdata.';
$string['addon.mod_quiz.errorparsequestions'] = 'Der opstod en fejl ved læsning af spørgsmålene. Kør quizzen i en webbrowser i stedet.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Denne quiz kan ikke tages i appen, quizzen indeholder kun spørgsmål som ikke supporteres af appen:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Denne quiz virker ikke i appen, quizzen indeholder regler som den ikke supporterer:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Der opstod en fejl da dine forsøgsdata skulle gemmes.';
$string['addon.mod_quiz.finishnotsynced'] = 'Afsluttet, men ikke synkroniseret';
$string['addon.mod_quiz.opentoc'] = 'Åben navigations-popover';
$string['addon.mod_quiz.warningattemptfinished'] = 'Offline-forsøget blev ignoreret da det blev afsluttet på websiden eller ikke blev fundet.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Nogle offline-svar blev ignoreret da spørgsmålene var ændret online';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Forsøget er ikke færdigt da nogle offline svar blev frasorteret. Gennemse dine svar og aflever igen.';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Fejl under indlæsning af indhold.';
$string['addon.mod_resource.openthefile'] = 'Aben filen';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Karaktererne kunne ikke beregnes.';
$string['addon.mod_scorm.dataattemptshown'] = 'Disse data tilhører forsøg nummer {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'En fejl opstod ved oprettelse af et nyt offline forsøg. Prøv igen.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Fejl ved hentning af SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Fejl ved hentning af SCORM-data.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Beklager, programmet understøtter kun SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Indhentning af SCORM-pakker er deaktiveret på dit Moodlewebsted. Kontakt din Moodle wedstedsadministrator.';
$string['addon.mod_scorm.errornovalidsco'] = 'Denne SCORM har ikke en synlig SCO at indlæse.';
$string['addon.mod_scorm.errorpackagefile'] = 'Beklager, programmet understøtter kun zip-pakker.';
$string['addon.mod_scorm.errorsyncscorm'] = 'En fejl opstod under synkronisering. Prøv igen.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Dette forsøg har data, der ikke er synkroniseret.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Dette forsøg kan ikke sendes da du har overskredet det tilladte antal forsøg.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Denne SCORM er ikke downloadet. Den bliver automatisk downloadet når du åbner den.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Denne SCORM er ændret efter den sidste download. Den bliver automatisk downloadet når du åbner den.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Nogle af forsøgets offlinedata {{number}} er blevet slettet fordi de ikke kunne oprettes i et nyt forsøg.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Nogle forsøg kunne ikke synkroniseres med webstedet, fordi det sidste onlineforsøg ikke er afsluttet. Afslut først onlineforsøget.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Beklager, kunne ikke sende din undersøgelse. Prøv igen.';
$string['addon.mod_survey.errorgetsurvey'] = 'Fejl ved hentning af undersøgelsesdata.';
$string['addon.mod_survey.results'] = 'Resultater';
$string['addon.mod_url.accessurl'] = 'Gå til webadressen';
$string['addon.mod_url.pointingtourl'] = 'Ressourcen henviser til denne webadresse';
$string['addon.mod_wiki.errorloadingpage'] = 'Der opstod en fejl mens siden blev indlæst.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Denne wiki har endnu intet indhold.';
$string['addon.mod_wiki.gowikihome'] = 'Gå til wiki-forsiden';
$string['addon.mod_wiki.subwiki'] = 'Underwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Titlen skal være tom';
$string['addon.mod_wiki.viewpage'] = 'Se side';
$string['addon.mod_wiki.wikipage'] = 'Wikiside';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Bedømmelsesstrategien {{$a}} er ikke understøttet';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Du skal angive en titel.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Afleveringen er blevet ændret på sitet';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Bedømmelsen er blevet ændret på sitet.';
$string['addon.notes.warningnotenotsent'] = 'Kunne ikke tilføje note(r) til kurset {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Fejl ved hentning af underretninger';
$string['addon.notifications.notifications'] = 'Underretninger';
$string['addon.notifications.playsound'] = 'Afspil lyd';
$string['addon.notifications.therearentnotificationsyet'] = 'Der er ingen underretninger';
$string['appstoredescription'] = 'BEMÆRK: Denne officielle Moodle Mobil App virker KUN på Moodlewebsteder, som er sat op til adgang via app. Kontakt din Moodleadministrator, hvis du har problemer med at komme på.

Hvis dit Moodlewebsted er konfigureret til det, kan du bruge denne app til at:

- arbejde med dit kursusindhold, selv når du er offline
- få øjeblikkelig underretning om meddelelser og andre begivenheder
- hurtigt finde og kontakte andre deltagere på dine kurser
- uploade billeder, lyd og videoer samt andre filer fra din telefon eller tablet
- se dine kursusbedømmelser
- med mere!

Se de nyeste oplysninger på http://docs.moodle.org/da/Mobile_app.

Vi vil virkelig sætte pris på gode anmeldelser om funktionaliteten som den er nu, og dine forslag til hvad du ellers ønsker at denne app skal kunne!

Denne app kræver følgende tilladelser:
Optage lyd - Til optagelse af lyd for upload til Moodle
Læse og ændre indholdet af dit SD-kort - Indholdet hentes til SD-kortet, så du kan se det offline
Adgang til netværk - For at kunne  forbinde til dit Moodlewebsted og kontrollere om du er forbundet eller ej for at skifte til offline tilstand
Kør ved opstart - Så du modtager lokale meddelelser, selv når app\'en kører i baggrunden
Forhindre telefonen i at sove - Så du når som helst kan modtage beskeder';
$string['core.cannotconnect'] = 'Kan ikke forbinde';
$string['core.cannotdownloadfiles'] = 'Download af filer er deaktiveret i din mobilservice. Kontakt dit websteds administrator.';
$string['core.captureaudio'] = 'Optag lyd';
$string['core.capturedimage'] = 'Billede taget';
$string['core.captureimage'] = 'Tag et billede';
$string['core.capturevideo'] = 'Optag video';
$string['core.clearsearch'] = 'Fjern søgning';
$string['core.clicktoseefull'] = 'Klik for at se alt indhold.';
$string['core.confirmcanceledit'] = 'Er du sikker på at du vil forlade denne side? Alle ændringer vil gå tabt.';
$string['core.confirmloss'] = 'Er du sikker? Alle ændringer vil gå tabt.';
$string['core.confirmopeninbrowser'] = 'Vil du åbne den i en browser?';
$string['core.contenteditingsynced'] = 'Det indhold du redigerer er blevet synkroniseret.';
$string['core.contentlinks.chooseaccount'] = 'Vælg konto';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Vælg konto der skal åbne linket.';
$string['core.contentlinks.confirmurlothersite'] = 'Linket tilhører et andet site. Vil du åbne det?';
$string['core.contentlinks.errornoactions'] = 'Kunne ikke finde nogen handling af udføre med dette link';
$string['core.contentlinks.errornosites'] = 'Kunne ikke finde noget site til at håndtere dette link.';
$string['core.copiedtoclipboard'] = 'Teksten er kopieret til udklipsholderen';
$string['core.course.activitydisabled'] = 'Denne aktivitet er deaktiveret i mobilappen.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Din organisation har installeret et plugin, der endnu ikke er understøttet.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'Din organisations Moodle skal opdateres.';
$string['core.course.allsections'] = 'Alle sektioner';
$string['core.course.askadmintosupport'] = 'Kontakt din siteadministrator og fortæl, at du gerne vil bruge denne aktivitet med Moodle Mobile app\'en.';
$string['core.course.confirmdeletemodulefiles'] = 'Er du sikker på at du vil slette disse modulfiler?';
$string['core.course.confirmdownload'] = 'Du er ved at hente {{size}}.{{availableSpace}} Er du sikker på at du vil fortsætte?';
$string['core.course.confirmdownloadunknownsize'] = 'Vi kunne ikke beregne størrelsen af din download.{{availableSpace}} Er du sikker på du vil fortsætte?';
$string['core.course.confirmpartialdownloadsize'] = 'Du er ved at downloade <strong>mindst</strong> {{size}}.{{availableSpace}} Er du sikker på at du vil fortsætte?';
$string['core.course.contents'] = 'Indhold';
$string['core.course.couldnotloadsectioncontent'] = 'Kunne ikke indlæse sektionens indhold, prøv igen senere.';
$string['core.course.couldnotloadsections'] = 'Kunne ikke indlæse sektionerne, prøv igen senere.';
$string['core.course.errordownloadingcourse'] = 'Fejl i forbindelse med download af kurset.';
$string['core.course.errordownloadingsection'] = 'Fejl ved indlæsning af sektion.';
$string['core.course.errorgetmodule'] = 'Fejl under indhentning af aktivitetsdata.';
$string['core.course.manualcompletionnotsynced'] = 'Manuel gennemførsel er ikke synkroniseret';
$string['core.course.nocontentavailable'] = 'Intet indhold tilgængeligt lige nu.';
$string['core.course.refreshcourse'] = 'Genindlæs kurset';
$string['core.course.useactivityonbrowser'] = 'Du kan stadig bruge den med din browser.';
$string['core.course.warningmanualcompletionmodified'] = 'Den manuelle gennemførselsmarkering er ændret på websitet';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Nogle offline manuelle gennemførselsmarkeringer \'{{name}}\' er blevet slettet. {{error}}';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorier dybere end niveau  {{$a}} kan ikke hentes';
$string['core.courses.confirmselfenrol'] = 'Er du sikker på at du ønsker at tilmelde dig dette kursus?';
$string['core.courses.downloadcourses'] = 'Download kurser';
$string['core.courses.enrolme'] = 'Tilmeld mig';
$string['core.courses.errorloadcategories'] = 'Der skete en fejl i forbindelse med indlæsning af kategorier.';
$string['core.courses.errorloadcourses'] = 'En fejl opstod ved indlæsning af kurset.';
$string['core.courses.errorloadplugins'] = 'De plugins som kræves af kurset, kunne ikke indlæses korrekt. Genstart app\'en og prøv igen.';
$string['core.courses.errorsearching'] = 'En fejl opstod under søgning.';
$string['core.courses.errorselfenrol'] = 'En fejl opstod under selvtilmelding.';
$string['core.courses.filtermycourses'] = 'Filtrer mit kursus';
$string['core.courses.notenrollable'] = 'Du kan ikke selv tilmelde dig dette kursus.';
$string['core.courses.password'] = 'Tilmeldingsnøgle';
$string['core.courses.searchcoursesadvice'] = 'Du kan bruge knappen kursussøgning for at få adgang som gæst eller tilmelde dig kurser der tillader det.';
$string['core.courses.selfenrolment'] = 'Selvtilmelding';
$string['core.courses.totalcoursesearchresults'] = 'Kurser i alt: {{$a}}';
$string['core.currentdevice'] = 'Aktuelle enhed';
$string['core.datastoredoffline'] = 'Der blev gemt data på enheden da det ikke kunne sendes. Det vil blive sendt senere.';
$string['core.deletedoffline'] = 'Slettet offline';
$string['core.deleting'] = 'Sletter';
$string['core.dfdaymonthyear'] = 'DD-MM-YYY';
$string['core.dfdayweekmonth'] = 'ddd D. MMM';
$string['core.dffulldate'] = 'dddd D. MMMM YYYY h[:]mm';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm G';
$string['core.discard'] = 'Kasser';
$string['core.dismiss'] = 'Forkast';
$string['core.downloading'] = 'Downloader';
$string['core.emptysplit'] = 'Denne side vil blive vist uden indhold hvis det venstre panel er tomt eller ikke bliver indlæst.';
$string['core.errorchangecompletion'] = 'En fejl opstod under ændring af gennemførelsesstatus. Prøv igen.';
$string['core.errordeletefile'] = 'Fejl ved sletning af filen. Prøv igen.';
$string['core.errordownloading'] = 'Fejl ved download af fil.';
$string['core.errordownloadingsomefiles'] = 'Fejl ved download af modulfiler. Nogle filer mangler måske.';
$string['core.errorfileexistssamename'] = 'Der er allerede en fil med dette navn.';
$string['core.errorinvalidform'] = 'Formularen indeholder ugyldige data. Tjek at alle krævede felter er udfyldt og at værdierne er gyldige.';
$string['core.errorinvalidresponse'] = 'Ugyldigt svar modtaget. Kontakt dit Moodlewebsteds administrator hvis fejlen fortsætter.';
$string['core.errorloadingcontent'] = 'Fejl under indlæsning af indhold.';
$string['core.errorofflinedisabled'] = 'Offline gennemsyn er deaktiveret på dit site. Du skal være forbundet til internettet for at bruge app\'en.';
$string['core.erroropenfilenoapp'] = 'Fejl ved åbning af fil: intet program fundet der kan åbne denne type fil.';
$string['core.erroropenfilenoextension'] = 'Fejl ved åbning af fil: filen har ingen filendelse.';
$string['core.erroropenpopup'] = 'Denne aktivitet forsøger at åbne en popup. Det understøttes ikke i denne app.';
$string['core.errorrenamefile'] = 'Fejl under omdøbning af filen. Prøv igen.';
$string['core.errorsync'] = 'Der skete en fejl under synkronisering. Prøv igen.';
$string['core.errorsyncblocked'] = '{{$a}} kan ikke synkroniseres lige nu grundet en igangværende proces. Prøv igen senere. Fortsætter problemet, kan du prøve at genstarte appen.';
$string['core.filenameexist'] = 'Filnavnet eksisterer allerede: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Du er ved at oploade {{size}}. Er du sikker på at du vil fortsætte?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Vi kan ikke beregne hvor stor denne upload er. Er du sikker på at du vil fortsætte?';
$string['core.fileuploader.errorcapturingaudio'] = 'Fejl ved indspilning af lyd';
$string['core.fileuploader.errorcapturingimage'] = 'Fejl ved indhentning af billede.';
$string['core.fileuploader.errorcapturingvideo'] = 'Fejl ved indspilning af video';
$string['core.fileuploader.errorgettingimagealbum'] = 'Fejl ved indhentning af billede fra album';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Du skal være online for at uploade filer.';
$string['core.fileuploader.errornoapp'] = 'Du har ikke installeret en app som kan udføre denne handling.';
$string['core.fileuploader.errorreadingfile'] = 'Fejl ved læsning af fil.';
$string['core.fileuploader.errorwhileuploading'] = 'En fejl opstod under upload af filen.';
$string['core.fileuploader.file'] = 'Fil';
$string['core.fileuploader.fileuploaded'] = 'Filen er uploadet.';
$string['core.fileuploader.maxbytesfile'] = 'Filen {{$a.file}} er for stor. Den må ikke fylde mere end {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Fotoalbum';
$string['core.fileuploader.readingfile'] = 'Læser fil';
$string['core.fileuploader.readingfileperc'] = 'Læser fil: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Vælg en fil';
$string['core.fileuploader.uploadafile'] = 'Upload en fil';
$string['core.fileuploader.uploading'] = 'Uploader';
$string['core.fileuploader.uploadingperc'] = 'Uploader: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.hasdatatosync'] = 'Denne {{$a}} har data offline der skal synkroniseres.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Billede';
$string['core.imageviewer'] = 'Billedfremviser';
$string['core.lastdownloaded'] = 'Sidst downloadet';
$string['core.lastsync'] = 'Sidst synkroniseret';
$string['core.loadmore'] = 'Indlæs mere';
$string['core.login.authenticating'] = 'Godkender';
$string['core.login.confirmdeletesite'] = 'Er du sikker på at du ønsker at slette websiden {{sitename}}?';
$string['core.login.connect'] = 'Tilslut!';
$string['core.login.connecttomoodle'] = 'Tilslut til Moodle';
$string['core.login.contactyouradministrator'] = 'Kontakt administrator for yderligere hjælp';
$string['core.login.contactyouradministratorissue'] = 'Bed administrator om at tjekke følgende: {{$a}}';
$string['core.login.credentialsdescription'] = 'Skriv dit brugernavn og adgangskode for at logge på';
$string['core.login.emailconfirmsentnoemail'] = '<p>Du har fået tilsendt en mail.</p><p>Den har enkle retningslinjer for hvordan du bliver registreret.</p><p>Kontakt sidens administrator hvis du behøver hjælp.</p>';
$string['core.login.emailnotmatch'] = 'Mailadresserne matcher ikke';
$string['core.login.erroraccesscontrolalloworigin'] = 'Det Cross-Origin opkald du forsøger at udføre er blevet afvist. Kontroller  venligst https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'En fejl opstod ved sletning af denne webside. Prøv venligst igen.';
$string['core.login.errorupdatesite'] = 'En fejl opstod under opdatering af webstedets token.';
$string['core.login.findyoursite'] = 'Find dit site';
$string['core.login.helpmelogin'] = '<p>Der er mange tusinde Moodlesites rundt omkring i verden. Denne app kan kun anvendes på sites, der specifikt har aktiveret app-adgang.</p><p>Hvis du ikke kan tilgå dit Moodlesite, kan du kontakte din siteadministrator og gøre opmærksom på siden <a href="https://docs.moodle.org/en/Mobile_app" target="_blank">https://docs.moodle.org/en/Mobile_app</a></p><p>App\'en kan testes på et Moodle-demosite ved at skrive <i>teacher</i> elller<i>student</i> i feltet <i>Site address</i> og klikke på knappen <b>Connect</b>.</p>';
$string['core.login.invalidaccount'] = 'Kontroller venligst dine loginoplysninger eller spørg webstedets administrator om at kontrollere webstedets konfiguration.';
$string['core.login.invalidmoodleversion'] = '<p>Ugyldig Moodle version. Moodleappen fungerer kun sammen med Moodle version {{$a}} eller højere.</p>
<p>Du kan kontakte din Moodle-administrator og bede om at få Moodle opdateret.</p>
<p>Hvis du ikke ved hvordan du gør det, kan du kontakte din lærer.</p>';
$string['core.login.invalidsite'] = 'Denne webadresse er ugyldig.';
$string['core.login.invalidtime'] = 'Ugyldigt klokkeslæt';
$string['core.login.invalidvaluemax'] = 'Højeste værdi er {{$a}}';
$string['core.login.invalidvaluemin'] = 'Mindste værdi er {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'Du har fået en uventet reaktion fra Moodle Mobile Additional Features, så du vil blive godkendt ved hjælp af standard Mobile service.';
$string['core.login.loginbutton'] = 'Login';
$string['core.login.logininsiterequired'] = 'Du skal logge på websiden via en browser';
$string['core.login.mobileservicesnotenabled'] = 'Mobiladgang er ikke aktiveret på din side. Kontakt venligst din Moodles administrator, hvis du ønsker mobiladgang aktiveret.';
$string['core.login.notloggedin'] = 'Du skal være logget på.';
$string['core.login.passwordrequired'] = 'Adgangskode kræves';
$string['core.login.recaptchaincorrect'] = 'Svaret på sikkerhedsspørgsmålet er forkert.';
$string['core.login.reconnect'] = 'Genopret forbindelse';
$string['core.login.reconnectdescription'] = 'Din godkendelse er ugyldig eller udløbet, du skal forbinde til webstedet igen.';
$string['core.login.reconnectssodescription'] = 'Din godkendelse er ugyldig eller udløbet, du skal genoprette forbindelsen til webstedet. Du skal logge på webstedet via en browser.';
$string['core.login.selectsite'] = 'Vælg websted:';
$string['core.login.signupplugindisabled'] = '{{$a}} er ikke aktiveret.';
$string['core.login.siteaddress'] = 'Dit websted';
$string['core.login.siteinmaintenance'] = 'Dit websted er i vedligeholdelsestilstand';
$string['core.login.siteurl'] = 'Webadresse';
$string['core.login.siteurlrequired'] = 'Webside-URL kræves, f.eks.  <i>http://www.dinmoodle.dk eller https://www.dinmoodle.dk</i>';
$string['core.login.stillcantconnect'] = 'Stadig ingen forbindelse?';
$string['core.login.usernamerequired'] = 'Brugernavn kræves';
$string['core.login.visitchangepassword'] = 'Vil du besøge siden for at ændre adgangskoden?';
$string['core.login.webservicesnotenabled'] = 'Web Services er måske ikke aktiveret på dit websted. Bed din administrator om hjælp.';
$string['core.lostconnection'] = 'Din godkendelse er ugyldig eller udløbet, så du skal genoprette forbindelsen til webstedet.';
$string['core.mainmenu.changesite'] = 'Skift side';
$string['core.mainmenu.website'] = 'Websted';
$string['core.networkerroriframemsg'] = 'Dette indhold er ikke tilgængeligt offline. Forbind til internettet og prøv igen.';
$string['core.networkerrormsg'] = 'Der var problemer med at tilslutte til webstedet. Tjek din forbindelse og prøv igen.';
$string['core.nopasswordchangeforced'] = 'Du kan ikke fortsætte uden at ændre din adgangskode.';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Ikke sendt';
$string['core.openfullimage'] = 'Klik her for at vise billedet i fuld størrelse.';
$string['core.openinbrowser'] = 'Åben i browser';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Træk for at opdatere';
$string['core.question.errorquestionnotsupported'] = 'Appen understøtter ikke denne type spørgsmål: {{$a}}.';
$string['core.question.questionmessage'] = 'Spørgsmål {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Du bliver videresendt til siden';
$string['core.requireduserdatamissing'] = 'Denne bruger mangler nogle krævede profildata. Udfyld venligst de manglende data i din Moodle og prøv igen.<br>{{$a}}';
$string['core.retry'] = 'Prøv igen';
$string['core.searching'] = 'Søger';
$string['core.settings.about'] = 'Om';
$string['core.settings.cannotsyncoffline'] = 'Kan ikke synkronisere offline';
$string['core.settings.cannotsyncwithoutwifi'] = 'Kan ikke synkronisere fordi indstillingerne kun tillader synkronisering via Wi-Fi. Forbind til et Wi-Fi netværk.';
$string['core.settings.cordovadevicemodel'] = 'Cordova Device model';
$string['core.settings.cordovadeviceosversion'] = 'Cordova Device OS version';
$string['core.settings.cordovadeviceplatform'] = 'Cordova Device platform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova Device uuid';
$string['core.settings.cordovaversion'] = 'Cordova version';
$string['core.settings.deletesitefiles'] = 'Er du sikker på du vil slette de downloadede filer og cachede data fra webstedet \'{{sitename}}\'? Det vil forhindre dig i at bruge appen i offline tilstand.';
$string['core.settings.deletesitefilestitle'] = 'Slet webstedsfiler';
$string['core.settings.deviceinfo'] = 'Enhedsinfo';
$string['core.settings.deviceos'] = 'Enheds operativsystem';
$string['core.settings.displayformat'] = 'Vis format';
$string['core.settings.enabledownloadsection'] = 'Aktiver download af sektioner';
$string['core.settings.enablerichtexteditor'] = 'Aktiver "rich text"-editor';
$string['core.settings.enablerichtexteditordescription'] = '"Rich text"-editoren kan blive vist på steder der tillader det.';
$string['core.settings.enablesyncwifi'] = 'Tillad kun synkronisering når tilsluttet Wi-Fi';
$string['core.settings.errordeletesitefiles'] = 'Fejl ved sletning af websidefiler';
$string['core.settings.errorsyncsite'] = 'Fejl ved synkronisering. Kontroller din Internettilslutning og prøv igen.';
$string['core.settings.estimatedfreespace'] = 'Beregnet ledig plads';
$string['core.settings.filesystemroot'] = 'Filsystemets rod';
$string['core.settings.localnotifavailable'] = 'Lokale meddelelser tilgængelige';
$string['core.settings.locationhref'] = 'Webvisning af URL';
$string['core.settings.navigatorlanguage'] = 'Navigatorsprog';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Status for internetforbindelse';
$string['core.settings.privacypolicy'] = 'Privatlivspolitik';
$string['core.settings.reportinbackground'] = 'Anmeld fejl automatisk';
$string['core.settings.spaceusage'] = 'Pladsforbrug';
$string['core.settings.synchronization'] = 'Synkronisering';
$string['core.settings.synchronizenow'] = 'Synkroniser nu';
$string['core.settings.syncsettings'] = 'Indstilling for synkronisering';
$string['core.settings.wificonnection'] = 'WiFi-forbindelse';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Vælg den konto filen skal gemmes under.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Der er allerede en fil med dette navn. Vil du erstatte den eller omdøbe den til "{{$a}}"?';
$string['core.sharedfiles.nosharedfiles'] = 'Der er ikke gemt nogen delte filer på dette websted.';
$string['core.sharedfiles.rename'] = 'Omdøb';
$string['core.sharedfiles.replace'] = 'Erstat';
$string['core.sharedfiles.sharedfiles'] = 'Delte filer';
$string['core.sharedfiles.successstorefile'] = 'Filen er gemt. Du kan vælge den til upload til dine private filer eller vedlægge den i nogle aktiviteter.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Beklager...';
$string['core.tablet'] = 'Tablet';
$string['core.thereisdatatosync'] = 'Der er {{$a}} offline der skal synkroniseres.';
$string['core.tryagain'] = 'Prøv igen';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.unexpectederror'] = 'Uventet fejl. Luk og åben programmet igen i et nyt forsøg.';
$string['core.unicodenotsupported'] = 'Nogle smilies supporteres ikke på dette websted, og de vil blive fjernet når beskeden sendes.';
$string['core.unknown'] = 'Ukendt';
$string['core.unzipping'] = 'Udpakker';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Denne brugers data er ikke tilgængelige for dig.';
$string['core.user.errorloaduser'] = 'Fejl ved indlæsning af bruger.';
$string['core.user.sendemail'] = 'E-mail';
$string['core.whoops'] = 'Ups!';
$string['core.whyisthishappening'] = 'Hvorfor sker dette?';
$string['core.wsfunctionnotavailable'] = 'Denne webservicefunktion er ikke tilgængelig.';
$string['pluginname'] = 'Moodle Mobil-sprogstrenge';
