<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'da', version '4.0'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['add'] = 'Tilføj post';
$string['addcomment'] = 'Tilføj kommentar';
$string['addentries'] = 'Tilføj poster';
$string['addtemplate'] = 'Tilføj indtastningsskabelon';
$string['advancedsearch'] = 'Avanceret søgning';
$string['allowcomments'] = 'Tillad kommentarer til poster';
$string['alttext'] = 'Alternativ tekst';
$string['approvalstatus'] = 'Godkendelsesstatus';
$string['approve'] = 'Godkend';
$string['approved'] = 'Godkendt';
$string['areacontent'] = 'Felter';
$string['ascending'] = 'Stigende';
$string['asearchtemplate'] = 'Skabelon til avanceret søgning';
$string['atmaxentry'] = 'Der kan ikke tilføjes flere poster, maksimum er nået!';
$string['authorfirstname'] = 'Forfatterens fornavn';
$string['authorlastname'] = 'Forfatterens efternavn';
$string['autogenallforms'] = 'Generer alle standardskabeloner';
$string['autolinkurl'] = 'Autolink URL\'en';
$string['availablefromdate'] = 'Tilgængelig fra';
$string['availabletags'] = 'Tilgængelige variable';
$string['availabletags_help'] = 'Variable er pladsholdere der vil blive erstattet af data eller andet, f.eks. et redigeringsikon, når poster vises.

Datafelter har formatet [[feltnavn]].  Andre variable har formatet ##variabelnavn##.

Kun variable, der er i listen med "Tilgængelige variable", kan bruges i skabelonen.';
$string['availabletodate'] = 'Tilgængelig indtil';
$string['availabletodatevalidation'] = '"Tilgængelig til" kan ikke ligge før "tilgængelig fra".';
$string['blank'] = 'Tom';
$string['buttons'] = 'Handlinger';
$string['bynameondate'] = 'af: {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} lukker';
$string['calendarstart'] = '{$a} åbner';
$string['cancel'] = 'Annuller';
$string['cannotaccesspresentsother'] = 'Du har ikke adgang til skabeloner fra andre brugere';
$string['cannotadd'] = 'Kan ikke tilføje poster!';
$string['cannotdeletepreset'] = 'Fejl ved sletning af forudindstilling';
$string['cannotoverwritepreset'] = 'Mislykket overskrivning af foruddefineret skabelon!';
$string['cannotunziptopreset'] = 'Kan ikke udpakke til forvalgt mappe';
$string['checkbox'] = 'Tjekbokse';
$string['chooseexportfields'] = 'Vælg de felter du vil eksportere';
$string['chooseexportformat'] = 'Vælg det format du vil eksportere til';
$string['chooseorupload'] = 'Vælg fil';
$string['closebeforeopen'] = 'Du har opgivet en slutdato før startdatoen.';
$string['columns'] = 'kolonner';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentar slettet';
$string['commentempty'] = 'Kommentaren var tom';
$string['comments'] = 'Kommentarer';
$string['commentsaved'] = 'Kommentar gemt';
$string['commentsn'] = '{$a} kommentar(er)';
$string['commentsoff'] = 'Muligheden for at kommentere er ikke aktiveret';
$string['completiondetail:entries'] = 'Opret poster: {$a}';
$string['completionentries'] = 'Kræv poster';
$string['completionentriescount'] = 'Antal poster';
$string['completionentriesdesc'] = 'Obligatoriske antal poster: {$a}';
$string['configenablerssfeeds'] = 'Her kan RSS-feeds aktiveres for alle databaser. RSS skal også aktiveres manuelt i hver enkelt database.';
$string['confirmdeletefield'] = 'Du er ved at slette dette felt, vil du fortsætte?';
$string['confirmdeleterecord'] = 'Er du sikker på at du vil slette denne post?';
$string['confirmdeleterecords'] = 'Er du sikker på, du vil slette disse poster?';
$string['csstemplate'] = 'Tilpasset CSS';
$string['csvfailed'] = 'Kunne ikke læse de rå data fra CSV-filen';
$string['csvfile'] = 'CSV-fil';
$string['csvimport'] = 'Importer CSV-fil';
$string['csvimport_help'] = 'Poster kan importeres via en uformateret tekstfil med feltnavne på første linje og dernæst dataene, med en linje til hver post.';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Tilføj en ny database';
$string['data:approve'] = 'Godkend og forkast godkendte poster';
$string['data:comment'] = 'Skriv kommentarer';
$string['data:exportallentries'] = 'Eksporter alle databaseposter';
$string['data:exportentry'] = 'Eksporter en databasepost';
$string['data:exportownentry'] = 'Eksporter egne databaseposter';
$string['data:exportuserinfo'] = 'Eksporter brugerinformation';
$string['data:managecomments'] = 'Administrer kommentarer';
$string['data:manageentries'] = 'Administrer poster';
$string['data:managetemplates'] = 'Administrer skabeloner';
$string['data:manageuserpresets'] = 'Administrer forudindstillinger';
$string['data:rate'] = 'Vurder indlæg';
$string['data:readentry'] = 'Læs poster';
$string['data:view'] = 'Vis database';
$string['data:viewallratings'] = 'Vis alle rå vurderinger afgivet af enkeltpersoner';
$string['data:viewalluserpresets'] = 'Vis databaseskabeloner fra alle brugere';
$string['data:viewanyrating'] = 'Vis alle vurderinger, der er modtaget';
$string['data:viewentry'] = 'Vis poster';
$string['data:viewrating'] = 'Vis din samlede vurdering';
$string['data:writeentry'] = 'Opret poster';
$string['date'] = 'Dato';
$string['dateentered'] = 'Skrevet d.';
$string['defaultfielddelimiter'] = '(standard er komma)';
$string['defaultfieldenclosure'] = '(standard er ingenting)';
$string['defaultsortfield'] = 'Standard sorteringsfelt';
$string['delcheck'] = 'Tjekboks til massesletning';
$string['delete'] = 'Slet';
$string['deleteallentries'] = 'Slet alle poster';
$string['deletecomment'] = 'Er du sikker på at du vil slette denne kommentar?';
$string['deleted'] = 'slettet';
$string['deletefield'] = 'Slet felt';
$string['deletenotenrolled'] = 'Slet poster af ikke tilmeldte brugere';
$string['deletewarning'] = 'Er du sikker på at du vil slette denne skabelon?';
$string['descending'] = 'Faldende';
$string['directorynotapreset'] = '{$a->directory} Ikke en skabelon: Manglende filer: {$a->missing_files}';
$string['disapprove'] = 'Fortryd godkendelse';
$string['download'] = 'Download';
$string['edit'] = 'Rediger';
$string['editcomment'] = 'Rediger kommentar';
$string['editentry'] = 'Rediger post';
$string['editordisable'] = 'Deaktiver editoren';
$string['editorenable'] = 'Aktiver editoren';
$string['emptyadd'] = 'Layoutet er ikke defineret, der bliver genereret et standardlayout...';
$string['emptyaddform'] = 'Du udfyldte ingen felter!';
$string['enabletemplateeditorcheck'] = 'Er du sikker på at du vil aktivere editoren? Det kan resultere i ændring af indhold når skabelonen er gemt.';
$string['entries'] = 'Poster';
$string['entrieslefttoadd'] = 'Du mangler at tilføje {$a->entriesleft} post(er) for at færdiggøre databasen.';
$string['entrieslefttoaddtoview'] = 'Du skal tilføje {$a->entrieslefttoview} post(er mere) til denne database før du kan se andre deltageres bidrag.';
$string['entry'] = 'Post';
$string['entrysaved'] = 'Posten er gemt';
$string['errormustbeteacher'] = 'Denne side er kun for lærere!';
$string['errormustsupplyvalue'] = 'Du skal indsætte en værdi her.';
$string['errorpresetexists'] = 'Der er allerede en skabelon med det navn';
$string['eventfieldcreated'] = 'Felt oprettet';
$string['eventfielddeleted'] = 'Felt slettet';
$string['eventfieldupdated'] = 'Felt opdateret';
$string['eventrecordcreated'] = 'Post oprettet';
$string['eventrecorddeleted'] = 'Post slettet';
$string['eventrecordupdated'] = 'Post opdateret';
$string['eventtemplateupdated'] = 'Skabelon opdateret';
$string['eventtemplateviewed'] = 'Skabeloner set';
$string['example'] = 'Eksempel på databasemodul';
$string['excel'] = 'Excel';
$string['expired'] = 'Beklager, denne aktivitet lukkede {$a} og er ikke længere tilgængelig';
$string['export'] = 'Eksporter';
$string['exportaszip'] = 'Eksporter som zip';
$string['exportaszip_help'] = 'Med "Eksporter som zip" kan du gemme skabeloner og felter som en zip-fil med foruddefinerede layouts til download. Zip-filen kan derpå importeres på et andet kursus.';
$string['exportedtozip'] = 'Eksporteret til midlertidig zip...';
$string['exportentries'] = 'Eksporter poster';
$string['exportformat'] = 'Eksportformat';
$string['exportoptions'] = 'Eksportindstillinger';
$string['exportownentries'] = 'Eksporter kun dine egne poster? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Eksporter forindstilling';
$string['failedpresetdelete'] = 'Fejl under sletning af skabelon!';
$string['fieldadded'] = 'Felt tilføjet';
$string['fieldallowautolink'] = 'Tillad autolink';
$string['fielddeleted'] = 'Feltet er slettet';
$string['fielddelimiter'] = 'Feltseparator';
$string['fielddescription'] = 'Beskrivelse af felt(er)';
$string['fieldenclosure'] = 'Feltindkapsling';
$string['fieldheight'] = 'Højde';
$string['fieldheightlistview'] = 'Højde (i pixel) i listevisning';
$string['fieldheightsingleview'] = 'Højde (i pixel) i enkeltvisning';
$string['fieldids'] = 'Felt-id\'er';
$string['fieldmappings'] = 'Feltsammenkædning';
$string['fieldmappings_help'] = 'Denne menu giver dig mulighed for at bevare data fra den eksisterende database. For at bevare data i et felt skal du først knytte det til et nyt felt, hvor data vises. Alle felter kan også efterlades tomme uden data kopieret ind i dem. Ethvert gammelt felt som ikke er tilknyttet et nyt, vil gå tabt og alle data fjernes.
Du kan kun tilknytte felter af samme type, så hver rullemenu vil have forskellige felter. Du skal også være varsom med ikke at tilknytte et gammelt felt til mere end et nyt felt.';
$string['fieldname'] = 'Feltnavn';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'De følgende felter i din fil genkender databasen ikke: {$a}';
$string['fieldoptions'] = 'Muligheder (en pr linje)';
$string['fields'] = 'Felter';
$string['fieldupdated'] = 'Feltet er opdateret';
$string['fieldwidth'] = 'Bredde';
$string['fieldwidthlistview'] = 'Bredde (i pixel) i listevisning';
$string['fieldwidthsingleview'] = 'Bredde (i pixel) i enkeltvisning';
$string['file'] = 'Fil';
$string['fileencoding'] = 'Tegnsæt';
$string['filesnotgenerated'] = 'Ikke alle filer blev dannet: {$a}';
$string['filtername'] = 'Autolink database';
$string['footer'] = 'Sidefod';
$string['forcelinkname'] = 'Tvunget linknavn';
$string['foundnorecords'] = 'Ingen poster fundet (<a href="{$a->reseturl}">Nulstil filtre</a>)';
$string['foundrecords'] = 'Poster fundet: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Nulstil filtre</a>)';
$string['fromfile'] = 'Importer fra zip-fil';
$string['fromfile_help'] = 'Med importfunktionen kan du uploade zip-filer med skabeloner, der er gemt på din computer.';
$string['generateerror'] = 'Ikke alle filer blev genereret!';
$string['header'] = 'Sidehoved';
$string['headeraddtemplate'] = 'Definer brugerfladen for tilføjelse eller redigering af poster.';
$string['headerasearchtemplate'] = 'Definer brugerfladen for avanceret søgning.';
$string['headercsstemplate'] = 'Føj brugerdefineret CSS til skabeloner.';
$string['headerjstemplate'] = 'Tilføj brugerdefineret JavaScript til skabelonerne Liste, Enkeltpost eller Tilføj post.';
$string['headerlisttemplate'] = 'Definer udseendet af listevisning.';
$string['headerrsstemplate'] = 'Definer udseendet af poster i RSS-feeds.';
$string['headersingletemplate'] = 'Definer udseendet af enkeltvisning.';
$string['importentries'] = 'Importer poster';
$string['importpreset'] = 'Importer forindstilling';
$string['importsuccess'] = 'Skabelonen er tilføjet korrekt.';
$string['includeapproval'] = 'Inkluder godkendelsesstatus';
$string['includetags'] = 'Inkluder tags';
$string['includetime'] = 'Inkluder den tid, der er tilføjet/ændret';
$string['includeuserdetails'] = 'Inkluder brugeroplysninger';
$string['insufficiententries'] = 'flere indlæg er nødvendige for at se denne database';
$string['intro'] = 'Beskrivelse';
$string['invalidaccess'] = 'Denne side blev ikke indlæst korrekt';
$string['invalidfieldid'] = 'Felt-id er forkert';
$string['invalidfieldname'] = 'Vælg et andet navn til dette felt';
$string['invalidfieldtype'] = 'Felttype er forkert';
$string['invalidid'] = 'Forkert data-id';
$string['invalidpreset'] = '{$a} er ikke en skabelon.';
$string['invalidrecord'] = 'Forkert post';
$string['invalidurl'] = 'Den URL, du har skrevet, er ikke korrekt';
$string['jstemplate'] = 'Tilpasset JavaScript';
$string['latitude'] = 'Breddegrad';
$string['latlong'] = 'Koordinater';
$string['latlongboth'] = 'Skriv både bredde- og længdegrad';
$string['latlongdownloadallhint'] = 'Download link for alle poster som KML';
$string['latlongkmllabelling'] = 'Hvordan noget markeres i KML-filer (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Link-out services der vises';
$string['latlongotherfields'] = 'Andre felter';
$string['list'] = 'Vis liste';
$string['listtemplate'] = 'Liste';
$string['listview'] = 'Listevisninig';
$string['longitude'] = 'Længdegrad';
$string['manageapproved'] = 'Tillad at godkendte poster redigeres';
$string['manageapproved_help'] = 'Tillad de studerende at redigere eller slette deres poster, efter at de er blevet godkendt. Redigerede poster skal godkendes på ny.';
$string['mapexistingfield'] = 'Knyt til {$a}';
$string['mapnewfield'] = 'Opret et nyt felt';
$string['mappingwarning'] = 'Alle gamle felter der ikke er knyttet til et nyt felt vil gå tabt, og alle data i feltet vil blive fjernet.';
$string['maxentries'] = 'Højeste antal poster';
$string['maxentries_help'] = 'Det største antal poster en deltager må aflevere i denne aktivitet.';
$string['maxsize'] = 'Maksimum størrelse';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Vælg...';
$string['missingdata'] = 'Data-id eller objekt skal angives for feltklassen.';
$string['missingfield'] = 'Programmeringsfejl: Du skal specificere et felt og/eller data når du definerer en feltklasse ';
$string['modulename'] = 'Database';
$string['modulename_help'] = 'Database giver deltagerne mulighed for at oprette, vedligeholde og søge i en samling af poster.

Posternes struktur defineres ved hjælp af forskellige typer felter, f.eks. kort tekst, rullemenu, tekstboks, URL, billede eller fil.

Som lærer kan du kommentere og bedømme poster. Du kan også give de studerende mulighed for at bedømme og kommentere posterne (peer-evaluering). Vurderinger kan lægges sammen til en endelig karakter, som registreres i karakterbogen.

Hvis filteret Database auto-linking er aktiveret, vil alle poster i en database automatisk blive knyttet til de steder, hvor ordene eller sætningerne forekommer på kurset.

Du kan bruge Database til at:

* Oprette en fælles samling af links, bøger, boganmeldelser, tidsskriftsreferencer osv.
* Vise fotos, plakater, websteder eller digte, som de studerende har skabt, så de kan kommentere og gennemgå dem.';
$string['modulenameplural'] = 'Databaser';
$string['more'] = 'Flere';
$string['moreurl'] = 'Flere URL\'er';
$string['movezipfailed'] = 'Kan ikke flytte zip-fil';
$string['multientry'] = 'Gentaget post';
$string['multimenu'] = 'Menu (multi-valg)';
$string['multipletags'] = 'Flere tags fundet! Skabelonen er ikke gemt';
$string['newentry'] = 'Ny post';
$string['newfield'] = 'Opret et nyt felt';
$string['newfield_help'] = 'Et felt giver mulighed for input af data. Hver post i en database kan have flere felter af flere typer som f.eks. et datofelt, som giver deltagerne mulighed for at vælge en dag, måned og år fra en rullemenu, et billedfelt, som giver deltagerne mulighed for at uploade en billedfil, eller et område med afkrydsningsfelter, som giver deltagerne mulighed for at vælge en eller flere muligheder.

Hvert felt skal have et unikt feltnavn. Beskrivelsesfeltet er valgfrit at udfylde.';
$string['noaccess'] = 'Du har ikke adgang til denne side';
$string['nodefinedfields'] = 'Den nye skabelon har ingen felter!';
$string['nofieldcontent'] = 'Feltindhold ikke fundet';
$string['nofieldindatabase'] = 'Der er ingen felter oprettet i denne database';
$string['nolisttemplate'] = 'Listeskabelon er ikke defineret endnu';
$string['nomatch'] = 'Ingen matchende poster fundet';
$string['nomaximum'] = 'Ingen maksimum';
$string['norecords'] = 'Ingen indlæg i databasen';
$string['nosingletemplate'] = 'Skabelon til enkeltvisning af poster er ikke defineret';
$string['notapproved'] = 'Posten er ikke godkendt endnu.';
$string['notinjectivemap'] = 'Not an injective map';
$string['notopenyet'] = 'Beklager, denne aktivitet er først tilgængelig {$a}';
$string['number'] = 'Tal';
$string['numberrssarticles'] = 'RSS-poster';
$string['numnotapproved'] = 'Afventer godkendelse';
$string['numrecords'] = '{$a} poster';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet/Regneark">ODS</abbr> (LibreOffice)';
$string['openafterclose'] = 'Åbningsdatoen er lagt efter lukkedatoen.';
$string['optionaldescription'] = 'Kort beskrivelse (frivillig)';
$string['optionalfilename'] = 'Filnavn (frivillig)';
$string['other'] = 'Anden';
$string['overrwritedesc'] = 'Overskriv skabelonen hvis den allerede findes';
$string['overwrite'] = 'Overskriv';
$string['overwritesettings'] = 'Overskriv de nuværende indstillinger';
$string['page-mod-data-x'] = 'En hvilken som helst side i databasemodulet';
$string['pagesize'] = 'Antal poster pr. side';
$string['participants'] = 'Deltagere';
$string['picture'] = 'Billede';
$string['pleaseaddsome'] = 'Opret nogle nedenfor eller <a href="{$a}">vælg et predefineret sæt</a> til at begynde med.';
$string['pluginadministration'] = 'Database-administration';
$string['pluginname'] = 'Database';
$string['portfolionotfile'] = 'Eksporter hellere til en portefølje end til en fil (kun csv og leap2a)';
$string['presetinfo'] = 'Ved at gemme denne databaseskabelon vil opsætningen og udseendet blive tilgængelig for andre brugere, som dermed vil kunne bruge skabelonen til deres databaser.';
$string['presetnotselected'] = 'Der er ikke valgt nogen forudindstilling.';
$string['presets'] = 'Databaseskabeloner';
$string['privacy:metadata:commentpurpose'] = 'Kommentarer til databaseposter';
$string['privacy:metadata:data_content'] = 'Indholdet af et felt';
$string['privacy:metadata:data_content:content'] = 'Indhold';
$string['privacy:metadata:data_content:content1'] = 'Ekstra indhold 1';
$string['privacy:metadata:data_content:content2'] = 'Ekstra indhold 2';
$string['privacy:metadata:data_content:content3'] = 'Ekstra indhold 3';
$string['privacy:metadata:data_content:content4'] = 'Ekstra indhold 4';
$string['privacy:metadata:data_content:fieldid'] = 'Id på feltdefinition';
$string['privacy:metadata:data_records'] = 'Poster i databasemodulet';
$string['privacy:metadata:data_records:approved'] = 'Godkendelsesstatus';
$string['privacy:metadata:data_records:groupid'] = 'Gruppe';
$string['privacy:metadata:data_records:timecreated'] = 'Tidspunkt for oprettelse af posten';
$string['privacy:metadata:data_records:timemodified'] = 'Tidspunkt for seneste redigering af posten';
$string['privacy:metadata:data_records:userid'] = 'Bruger der oprettede posten';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Felter til databasemodulet';
$string['privacy:metadata:filepurpose'] = 'Fil vedhæftet databaseposten';
$string['privacy:metadata:ratingpurpose'] = 'Vurderinger af databaseposter';
$string['privacy:metadata:tagpurpose'] = 'Tags på databaseposter';
$string['radiobutton'] = 'Radioknapper';
$string['recordapproved'] = 'Post godkendt';
$string['recorddeleted'] = 'Posten er slettet';
$string['recorddisapproved'] = 'Posten er ikke godkendt';
$string['recordsnotsaved'] = 'Ingen poster blev gemt. Kontroller formatet på den uploadede fil.';
$string['recordssaved'] = 'poster gemt';
$string['removealldatatags'] = 'Fjern alle databasetags';
$string['requireapproval'] = 'Godkendelse kræves';
$string['requireapproval_help'] = 'En lærer skal godkende poster, før de er synlige for alle.';
$string['required'] = 'Krævet';
$string['requiredentries'] = 'Krævet antal poster for gennemførelse (gammel)';
$string['requiredentries_help'] = 'Hvis indstillingen er aktiveret, vises en besked om hvor mange poster der kræves for gennemførelse. Bemærk at indstillingen ikke er forbundet med aktivitetsfuldførelse.

Der er en ny indstilling til poster krævet for aktivitetsfuldførelse, "Krævede poster". Fjern denne indstilling ved at sætte den til 0 og gem. Brug i stedet indstillingen "Krævede poster".';
$string['requiredentriestoview'] = 'Krævede poster før visning';
$string['requiredentriestoview_help'] = 'Det antal poster, en studerende skal tilføje, før han/hun kan se poster fra andre studerende.

Dette er ikke kompatibelt med filteret til automatisk linking i databasen.';
$string['requiredentrieswarning'] = 'Denne indstilling er erstattet af indstillingen \'Kræv poster\' i sektionen for aktivitetsgennemførelse';
$string['requiredfield'] = 'Krævet felt';
$string['resetsettings'] = 'Nulstil filtre';
$string['resettemplate'] = 'Nulstil skabelon';
$string['resizingimages'] = 'Skalerer miniaturer...';
$string['rows'] = 'rækker';
$string['rssglobaldisabled'] = 'Deaktiveret. Se webstedets konfigurationsvariable.';
$string['rsstemplate'] = 'RSS-skabelon';
$string['rsstitletemplate'] = 'RSS-titelskabelon';
$string['rsstype'] = 'RSS-feed for denne aktivitet';
$string['save'] = 'Gem';
$string['saveandadd'] = 'Gem og tilføj en post mere';
$string['saveandview'] = 'Gem og vis';
$string['saveaspreset'] = 'Gem som databaseskabelon';
$string['saveaspreset_help'] = 'Funktionen Gem som databaseskabelon udgiver databasens opsætning og layout som en skabelon
andre på sitet kan se og anvende. (Du vil altid kunne fjerne den igen.)';
$string['saveaspresetmissingcapability'] = 'Brugeren har ikke tilladelse til at gemme databasen som en forudindstilling.';
$string['savedataaspreset'] = 'Gem alle felter og skabeloner, og udgiv dem som forudindstilling på dette websted';
$string['savesettings'] = 'Gem indstillinger';
$string['savesuccess'] = 'Gemt korrekt. Din skabelon vil være tilgængelig fra hele webstedet.';
$string['savetemplate'] = 'Gem';
$string['search'] = 'Søg';
$string['search:activity'] = 'Database - aktivitetsinformation';
$string['search:entry'] = 'Database - poster';
$string['selectedrequired'] = 'Alle valgte er påkrævet';
$string['selectexportoptions'] = 'Vælg eksportindstillinger';
$string['selectfields'] = 'Vælg felter';
$string['showall'] = 'Vis alle poster';
$string['single'] = 'Vis en enkelt post';
$string['singletemplate'] = 'Enkelt skabelon';
$string['singleview'] = 'Enkeltvisning';
$string['subplugintype_datafield'] = 'Type databasefelt';
$string['subplugintype_datafield_plural'] = 'Typer databasefelter';
$string['subplugintype_datapreset'] = 'Databaseskabelon';
$string['subplugintype_datapreset_plural'] = 'Databaseskabeloner';
$string['tagarea_data_records'] = 'Dataposter';
$string['tags'] = 'Tags';
$string['tagsdeleted'] = 'Databasetags er slettet';
$string['teachersandstudents'] = '{$a->teachers} og {$a->students}';
$string['templates'] = 'Skabeloner';
$string['templatesaved'] = 'Layoutet er gemt';
$string['text'] = 'Tekst';
$string['textarea'] = 'Tekstboks';
$string['timeadded'] = 'Tilføjet';
$string['timemodified'] = 'Ændret';
$string['todatabase'] = 'til denne database.';
$string['type'] = 'Felttype';
$string['undefinedprocessactionmethod'] = 'Der er ikke defineret en metode i Data_Preset til håndtering af handlingen "{$a}".';
$string['unsupportedexport'] = '({$a->fieldtype}) kan ikke eksporteres.';
$string['unsupportedfields'] = 'Ikke-understøttede felter';
$string['unsupportedfieldslist'] = 'Følgende felter kan ikke eksporteres:';
$string['updatefield'] = 'Opdater et eksisterende felt';
$string['uploadfile'] = 'Upload fil';
$string['uploadrecords'] = 'Hent poster fra en fil';
$string['uploadrecords_help'] = 'Poster kan uploades via en tekst-fil. Formatet på filen skal være som følger:

* Hver linje i filen skal indeholde én post
* Hver post er en række data adskilt af den valgte separator
* Den første linje indeholder en liste over feltnavne som definerer formatet på resten af filen.

Feltdata omgives af et tegn i starten og slutningen af feltet, men det skal normalt ikke angives.';
$string['url'] = 'URL';
$string['usedate'] = 'Inkluder i søgning.';
$string['usepredefinedset'] = 'Anvend foruddefineret sæt';
$string['usepreset'] = 'Anvend forindstilling';
$string['usestandard'] = 'Benyt en databaseskabelon';
$string['usestandard_help'] = 'Brug en skabelon fra webstedets fælles skabeloner ved at vælge den her. (Hvis du har tilføjet en skabelon med "Gem som databaseskabelon"-funktionen, vil du også få mulighed for at slette den igen.)';
$string['viewfromdate'] = 'Skrivebeskyttet fra';
$string['viewtodate'] = 'Skrivebeskyttet indtil';
$string['viewtodatevalidation'] = '\'Synlig indtil\' kan ikke ligge før \'Synlig fra\'.';
$string['wrongdataid'] = 'Forkert data-id angivet';
