<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'da', version '4.0'.
 *
 * @package     auth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Tilgængelige godkendelses-plugins';
$string['allowaccountssameemail'] = 'Tillad konti med samme e-mailadresse';
$string['allowaccountssameemail_desc'] = 'Er indstillingen aktiveret, kan flere brugere dele samme e-mailadresse. Dette kan resultere i problemer med sikkerheden eller privatlivshensyn, eksempelvis ved fremsendelse af mail med bekræftelse af at adgangskoden er ændret.';
$string['alternatelogin'] = 'Her kan du skrive en URL der vil blive brugt som loginside til dette websted. Siden bør indeholde en formular hvis handling er sat til <strong>"{$a}"</strong> og returnere 2 felter, <strong>brugernavn</strong> og <strong>adgangskode</strong>.<br />Pas på ikke at skrive en forkert URL, da du kan risikere ikke at kunne logge ind igen. <br />Lad feltet stå tomt for at bruge den almindelige loginside.';
$string['alternateloginurl'] = 'Alternativ loginside';
$string['auth_changepasswordhelp'] = 'Hjælp til ændring af adgangskode';
$string['auth_changepasswordhelp_expl'] = 'Vis hjælp til brugere som har glemt deres {$a} adgangskode. Dette vil blive vist enten sammen med eller i stedet for <strong>URL til skift af adgangskode</strong> eller Moodle\'s interne skift af adgangskode.';
$string['auth_changepasswordurl'] = 'URL til skift af adgangskode';
$string['auth_changepasswordurl_expl'] = 'Angiv den URL som brugere skal sendes til hvis de har mistet deres {$a} adgangskode. Sæt <strong>Benyt standardside til skift af adgangskode</strong> til <strong>Nej</strong>';
$string['auth_changingemailaddress'] = 'Du har anmodet om ændring af din e-mailadresse fra {$a->oldemail} til {$a->newemail}. Af hensyn til sikkerheden sender vi en mail til den nye adresse for at få bekræftet at den tilhører dig. Din nye adresse bliver ændret i din profil så snart du åbner linket i mailen.';
$string['auth_common_settings'] = 'Fælles indstillinger';
$string['auth_data_mapping'] = 'Data mapning';
$string['auth_fieldlock'] = 'Lås værdi';
$string['auth_fieldlock_expl'] = '<p><b>Låseværdi:</b> Er indstillingen aktiveret, kan brugerne ikke redigere feltet. Brug denne indstilling, hvis du vedligeholder disse data i det eksterne godkendelsessystem.</p>';
$string['auth_fieldlockfield'] = 'Lås værdi ({$a})';
$string['auth_fieldlocks'] = 'Lås brugerfelter';
$string['auth_fieldlocks_help'] = '<p>Du kan låse brugerdatafelter. Det er hensigtsmæssigt når brugerdata vedligeholdes manuelt af administratorer,  ved manuelt at rette brugerposter eller uploade brugerdata ved hjælp af funktionen "Upload brugere". Hvis du låser obligatoriske felter der kræves af Moodle, skal du sørge for at angive disse data ved oprettelse af brugerkonti, i modsat fald vil de oprettede brugerkonti være ubrugelige.</p><p>For at undgå dette problem kan låsemetoden "Ulåst hvis tom" benyttes.</p>';
$string['auth_fieldmapping'] = 'Datatilknytning ({$a})';
$string['auth_invalidnewemailkey'] = 'Fejl: Hvis du prøver at bekræfte en ny e-mailadresse er der sket en fejl. Prøv igen at gå ind på den internetadresse du har fået tilsendt.';
$string['auth_multiplehosts'] = 'Flere værter kan specificeres (f.eks. host1.dk;host2.dk;host3.dk) eller (ex xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_notconfigured'] = 'Godkendelsesmetoden er ikke konfigureret';
$string['auth_outofnewemailupdateattempts'] = 'Du har brugt de tilladte forsøg på at opdatere din e-mailadresse. Ændringen er blevet aflyst.';
$string['auth_passwordisexpired'] = 'Din kode er udløbet. Vær sød at ændre den nu.';
$string['auth_passwordwillexpire'] = 'Din adgangskode udløber om {$a} dage. Vil du at ændre den nu?';
$string['auth_remove_delete'] = 'Fuld intern sletning';
$string['auth_remove_keep'] = 'Behold intern';
$string['auth_remove_suspend'] = 'Suspender intern';
$string['auth_remove_user'] = 'Angiv hvad der skal ske med en intern brugerkonto under massesynkronisering hvis brugeren blev fjernet fra en ekstern kilde. Kun suspenderede brugerkonti vil automatisk blive genåbnet hvis de dukker op igen i en ekstern kilde.';
$string['auth_remove_user_key'] = 'Fjern ekstern bruger';
$string['auth_sync_script'] = 'Synkronisering af brugerkonto';
$string['auth_sync_suspended'] = 'Er indstillingen aktiveret, vil suspenderet-attributten blive brugt til opdatering af den lokale brugerkontos status for suspendering.';
$string['auth_sync_suspended_key'] = 'Synkroniser lokal brugers status på suspendering.';
$string['auth_updatelocal'] = 'Opdater lokale data';
$string['auth_updatelocal_expl'] = '<p><b>Opdater lokale data:</b> Er indstillingen aktiveret, vil feltet blive opdateret (fra ekstern godkendelse) hver gang brugeren logger ind eller der er en brugersynkronisering. Felter der er sat til lokal opdatering bør låses.</p>';
$string['auth_updatelocalfield'] = 'Opdater lokal ({$a})';
$string['auth_updateremote'] = 'Opdater eksterne data';
$string['auth_updateremote_expl'] = '<p><b>Opdater eksterne data:</b>Er indstillingen aktiveret, vil de eksterne godkendelsesdata blive opdateret når brugerposten bliver opdateret. Felter bør være ulåste for at tillade redigering.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Bemærk:</b> I forbindelse med opdatering af eksterne LDAP-data er det vigtigt at sætte binddn og bindpw til en bind-bruger med redigeringstilladelse til alle brugerposter. I øjeblikket bevarer den ikke attributter med flere værdier og fjerner ekstra værdier ved opdatering.</p>';
$string['auth_updateremotefield'] = 'Opdater ekstern ({$a})';
$string['auth_user_create'] = 'Tillad brugeroprettelse';
$string['auth_user_creation'] = 'Nye (anonyme) brugere kan blive oprettet vha. en ekstern godkendelseskilde og bekræftet via e-mail. Hvis du tillader dette, så husk at konfigurere modul-specifikke indstillinger for brugeroprettelse.';
$string['auth_usernameexists'] = 'Det valgte brugernavn eksisterer allerede. Vælg et andet.';
$string['auth_usernotexist'] = 'Kan ikke opdatere en bruger der ikke eksisterer: {$a}';
$string['authenticationoptions'] = 'Godkendelsesvalg';
$string['authinstructions'] = 'Lad feltet stå tomt hvis loginsiden skal vise standardinstruktionerne til login. Vil du vise dine egne instruktioner, kan du skrive dem her.';
$string['authloginviaemail'] = 'Tillad login via e-mail';
$string['authloginviaemail_desc'] = 'Tillad brugere at bruge både brugernavn og e-mailadresse (hvis unik) til login';
$string['auto_add_remote_users'] = 'Tilføj automatisk eksterne brugere';
$string['cannotmapfield'] = 'Feltet "{$a->fieldname}"  kan ikke tilknyttes, dets korte navn "{$a->shortname}" er for langt. Reducer profilfeltets korte navn til {$a->charlimit} tegn. <a href="{$a->link}">Rediger brugerprofilfelter</a>';
$string['changepassword'] = 'URL til ændring af adgangskode';
$string['changepasswordhelp'] = 'Her kan du angive et sted, hvor dine brugere kan finde eller ændre deres brugernavn/adgangskode, hvis de har glemt det. Brugerne vil få vist en knap på loginsiden og på deres brugerside. Hvis du ikke skriver noget her, vises knappen ikke.';
$string['chooseauthmethod'] = 'Vælg en godkendelsesmetode';
$string['chooseauthmethod_help'] = 'Her angives  godkendelsesmetode til når brugeren logger ind. Vælg kun aktiverede godkendelsesplugin, ellers vil brugere ikke længere kunne logge ind. Du kan forhindre brugeren i at logge ind ved at vælge "Ingen login".';
$string['createpassword'] = 'Generer adgangskode og notificer bruger';
$string['createpasswordifneeded'] = 'Generer om nødvendigt adgangskode og send den via e-mail';
$string['emailchangecancel'] = 'Annuller ændring af e-mail';
$string['emailchangepending'] = 'Ændring afventer at du åbner linket der er sendt til {$a->preference_newemail}.';
$string['emailnowexists'] = 'Den e-mailadresse du prøvede at angive i din profil, er tilknyttet en anden brugerkonto efter at du skrev den. Dit forsøg på at ændre adressen er derfor annulleret, men du kan prøve igen med en anden adresse.';
$string['emailupdate'] = 'Opdatering af e-mailadresse';
$string['emailupdatemessage'] = 'Kære {$a->fullname}

Du har bedt om ændring af din e-mail-adresse til din brugerkonto på {$a->site}. Bekræft ændringen ved at åbne dette link i din browser:

{$a->url}

{$a->supportemail}';
$string['emailupdatesuccess'] = '<em>{$a->fullname}</em>\'s e-mailadresse er ændret til <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Bekræftelse på ændring af e-mailadresse på {$a->site}';
$string['errormaxconsecutiveidentchars'] = 'Adgangskoder kan have højst {$a} fortløbende ens tegn.';
$string['errorminpassworddigits'] = 'Adgangskoder skal indeholde mindst {$a} tal.';
$string['errorminpasswordlength'] = 'Adgangskoder skal indeholde mindst {$a} tegn.';
$string['errorminpasswordlower'] = 'Adgangskoder skal indeholde mindst {$a} små bogstaver.';
$string['errorminpasswordnonalphanum'] = 'Adgangskoder skal indeholde mindst {$a} specialtegn såsom *, -, eller #.';
$string['errorminpasswordupper'] = 'Adgangskoder skal indeholde mindst {$a} store bogstaver.';
$string['errorpasswordreused'] = 'Adgangskoden har været brugt tidligere og må ikke genbruges';
$string['errorpasswordupdate'] = 'Opdatering af adgangskoden fejlede, koden blev ikke ændret';
$string['eventuserloggedin'] = 'Bruger er logget ind';
$string['eventuserloggedinas'] = 'Bruger er logget ind som anden bruger';
$string['eventuserloginfailed'] = 'Brugerlogin mislykkedes';
$string['forcechangepassword'] = 'Gennemtving skift af adgangskode';
$string['forcechangepassword_help'] = 'Tving brugere til at skifte adgangskode næste gang de logger ind.';
$string['forcechangepasswordfirst_help'] = 'Tving brugere til at skifte adgangskode første gang de logger ind på Moodle';
$string['forgottenpassword'] = 'Skriver du en URL her, vil den blive brugt som side til at få en ny kode. Den er beregnet på sider hvor adgangskoder håndteres udenfor Moodle. Vil du bruge Moodles standardmetode til at få en ny kode, skal du ikke skrive noget her.';
$string['forgottenpasswordurl'] = 'Glemt adgangskode-URL';
$string['getrecaptchaapi'] = 'Vil du bruge reCAPTCHA skal du hente en API-nøgle fra <a href=\'https://www.google.com/recaptcha/admin\'>https://www.google.com/recaptcha/admin</a>';
$string['guestloginbutton'] = 'Knap til gæstelogin';
$string['incorrectpleasetryagain'] = 'Forkert. Prøv igen.';
$string['infilefield'] = 'Nødvendige felter i filen';
$string['informminpassworddigits'] = 'mindst {$a} ciffer/cifre';
$string['informminpasswordlength'] = 'mindst {$a} tegn';
$string['informminpasswordlower'] = 'mindst {$a} små bogstav(er)';
$string['informminpasswordnonalphanum'] = 'mindst {$a} specialtegn såsom *, -, eller #.';
$string['informminpasswordreuselimit'] = 'Adgangskoder må genbruges efter {$a} ændringer';
$string['informminpasswordupper'] = 'mindst {$a} stort/store bogstav(er)';
$string['informpasswordpolicy'] = 'Adgangskoden skal have {$a}';
$string['instructions'] = 'Instruktioner';
$string['internal'] = 'Internt';
$string['limitconcurrentlogins'] = 'Begræns samtidige logins';
$string['limitconcurrentlogins_desc'] = 'Er indstillingen aktiveret, er antallet af samtidige browserlogins for hver bruger begrænset. Den ældste session vil blive afbrudt når grænsen er nået. Vær opmærksom på, at brugere risikerer at miste alle ikke-gemte data. Denne indstilling er ikke kompatibel med single sign-on (SSO) godkendelsesplugins';
$string['locked'] = 'Låst';
$string['md5'] = 'MD5-hash';
$string['nopasswordchange'] = 'Adgangskoden kan ikke ændres';
$string['nopasswordchangeforced'] = 'Du kan ikke fortsætte uden at ændre din adgangskode, men der er ingen tilgængelig side at ændre den på. Kontakt din Moodleadministrator.';
$string['noprofileedit'] = 'Profilen kan ikke redigeres';
$string['ntlmsso_attempting'] = 'Forsøg på Single Sign On via NTLM...';
$string['ntlmsso_failed'] = 'Auto-login mislykkedes, prøv den normale loginside...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO er deaktiveret.';
$string['passwordhandling'] = 'Behandling af adgangskodefelter';
$string['plaintext'] = 'Uformateret tekst';
$string['pluginnotenabled'] = 'Godkendelses-plugin\'et "{$a}" er ikke aktiveret.';
$string['pluginnotinstalled'] = 'Godkendelses-plugin\'et "{$a}" er ikke installeret.';
$string['potentialidps'] = 'Log in ved brug af din konto på:';
$string['privacy:metadata:userpref:createpassword'] = 'Indikerer at en adgangskode skal genereres til brugeren';
$string['privacy:metadata:userpref:forcepasswordchange'] = 'Indikerer om brugeren skal ændre adgangskode ved login';
$string['privacy:metadata:userpref:loginfailedcount'] = 'Brugerens antal fejlslagne login';
$string['privacy:metadata:userpref:loginfailedcountsincesuccess'] = 'Hvor mange gange brugeren forgæves har forsøgt at logge ind siden det sidst lykkeds';
$string['privacy:metadata:userpref:loginfailedlast'] = 'Den dag seneste forgæves loginforsøg blev registreret';
$string['privacy:metadata:userpref:loginlockout'] = 'Hvorvidt brugerens konto er låst grundet forgæves loginforsøg og datoen for hvornår kontoen blev låst';
$string['privacy:metadata:userpref:loginlockoutignored'] = 'Indikerer at brugerens konto aldrig skulle blive låst';
$string['privacy:metadata:userpref:loginlockoutsecret'] = 'Den hemmelighed brugeren skal bruge for at låse en låst konto op';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA bruges for at undgå misbrug fra automatiske programmer. Følg anvisningerne så vi kan se at du er et menneske. Der kan være en tjekboks der skal udfyldes, et billede med tegn du skal skrive, eller et sæt billeder at vælge mellem.

Hvis du er usikker på billederne, kan du få en ny CAPTCHA eller en lyd-CAPTCHA.';
$string['security_question'] = 'Sikkerhedsspørgsmål';
$string['selfregistration'] = 'Selvregistrering';
$string['selfregistration_help'] = 'Hvis et godkendelsesplugin såsom e-mailbaseret selvregistrering er valgt, giver det potentielle brugere mulighed for at registrere sig og oprette konti. Dette medfører at spammere vil kunne oprette konti og oprette forumindlæg, blogindlæg mv. til spam. Risikoen kan undgås ved at deaktivere selvregistrering eller begrænse det med indstillingen <em>tilladte e-maildomæner</em>.';
$string['settingmigrationmismatch'] = 'Der er fundet rod i værdier under tilslutning til plugin\'ets indstillingsnavne! Godkendelses-plugin\'et "{$a->plugin}" havde indstillingen "{$a->setting}" konfigureret som "{$a->legacy}" under det gamle navn, og til "{$a->current}" under det nuværende navn. Sidstnævnte værdi er indsat som det gyldige, men tjek og bekræft at det er som forventet.';
$string['sha1'] = 'SHA-1-hash';
$string['showguestlogin'] = 'Du kan vise eller gemme gæsteloginknappen på login-siden.';
$string['stdchangepassword'] = 'Brug standardsiden til ændring af adgangskode';
$string['stdchangepassword_expl'] = 'Hvis det eksterne godkendelsessystem tillader kodeskift gennem Moodle, sæt da denne indstilling til Ja. Denne indstilling erstatter "URL til ændring af adgangskode".';
$string['stdchangepassword_explldap'] = 'OBS: Det er tilrådeligt at bruge ldap over en ssl-krypteret tunnel (ldaps://) hvis ldap-serveren er ekstern.';
$string['suspended'] = 'Suspenderet konto';
$string['suspended_help'] = 'Suspenderede brugere kan ikke logge ind eller benytte webservices og alle udgående beskeder vil blive slettet';
$string['testsettings'] = 'Testindstillinger';
$string['testsettingsheading'] = 'Indstillinger til testgodkendelse - {$a}';
$string['unlocked'] = 'Ulåst';
$string['unlockedifempty'] = 'Ulåst hvis tom';
$string['update_never'] = 'Aldrig';
$string['update_oncreate'] = 'Ved oprettelse';
$string['update_onlogin'] = 'Ved hvert login';
$string['update_onupdate'] = 'Ved opdatering';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() understøtter ikke den valgte brugertype {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() understøtter ikke den valgte brugertype (..endnu)';
$string['username'] = 'Brugernavn';
$string['username_help'] = 'Vær opmærksom på, at nogle godkendelsesplugin ikke  tillader at du ændrer brugernavn';
