<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'sl', version '4.0'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Dejanja';
$string['activityoresourceis'] = 'Dejavnost ali vir je {$a}';
$string['addacondition'] = 'Dodaj pogoj';
$string['addarule'] = 'Dodaj pravilo';
$string['addinstructions'] = 'Dodaj več informacij';
$string['additionalresources'] = 'Dodatni viri';
$string['addoninstallationerror'] = 'Zaznana je težava z dodatkom (local_xp). Zdi se, da ni pravilno nameščen. Administrator mora zaključiti njegovo namestitev.';
$string['addrulesformhelp'] = 'V zadnjem stolpcu se določi število točk napredka, ki jih udeleženec pridobi, ko uspešno izpolni kriterij.';
$string['admindefaultrulesintro'] = 'Ta pravila bodo uporabljena kot privzeta, ko bo uporabnik dodal blok.';
$string['admindefaultsettingsintro'] = 'Spodnje nastavitve bodo uporabljene kot privzete, ko bo blok na novo dodan v predmet. Nekatere nastavitve je mogoče zakleniti. V tem primeru bodo uporabljene v vseh primerih vtičnika.';
$string['admindefaultvisualsintro'] = 'Nastavljeno bo uporabljeno kot privzeto, ko bo uporabnik na novo dodal blok v predmetu.';
$string['anonymity'] = 'Anonimnost';
$string['anonymity_help'] = 'Ta nastavitev določa, ali lahko udeleženci vidijo imena in slike drugih uporabnikov.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> točk se pridobi, ko:';
$string['basexp'] = 'Baza algoritma';
$string['blockappearance'] = 'Videz bloka';
$string['cachedef_filters'] = 'Filtri za stopnje';
$string['cachedef_ruleevent_eventslist'] = 'Seznam nekaterih dogodkov';
$string['cannotshowblockconfig'] = 'Tukaj se ponavadi prikažejo nastavitve videza, vendar vašega bloka ni bilo mogoče najti. Če želite spremeniti videz bloka, se vrnite nazaj ({$a}) (ali na mesto, kjer ste dodali blok), vklopite način urejanja in sledite možnosti "Nastavi blok Level up!" v spustnem meniju bloka. Če bloka ne najdete, ga dodajte ponovno.';
$string['cannotshowblockconfigsys'] = 'Tukaj se ponavadi prikažejo nastavitve videza, vendar vašega bloka ni bilo mogoče najti. Lahko da ga ni na osnovni strani ({$a->fp}) oziroma na pregledni plošči ({$a->mysys}) uporabnikov ali pa je prisoten na obeh mestih. Če želite urediti nastavitve od tukaj, se prepričajte, da je blok prikazan samo na enem od obeh mest.';
$string['changelevelformhelp'] = 'Če spremenite število stopenj, bodo značke stopenj začasno onemogočene, zato da se preprečijo stopnje z manjkajočimi značkami. Če spremenite število stopenj, pojdite na stran »Videz«, da ponovno omogočite značke po meri, takoj ko shranite ta obrazec.';
$string['cheatguard'] = 'Zaščita pred goljufijami';
$string['clicktoselectcm'] = 'Kliknite za izbiro dejavnosti ali vira';
$string['cmselector'] = 'Izbirnik modula';
$string['coefxp'] = 'Koeficient algoritma';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configdescription'] = 'Uvod';
$string['configdescription_help'] = 'Kratka uvodna predstavitev v bloku, ki se udeležencu prikaže pod trenutno doseženo stopnjo. Udeleženec lahko izključi to sporočilo. V tem primeru se mu ne bo več prikazalo.';
$string['configheader'] = 'Nastavitve';
$string['configrecentactivity'] = 'Prikazuj nedavne dosežke';
$string['configrecentactivity_help'] = 'Če je to omogočeno, potem se bo v bloku prikazoval kratek seznam nedavnih dogodkov, za katere je bil udeleženec nagrajen s točkami napredka.';
$string['configtitle'] = 'Naslov';
$string['configtitle_help'] = 'Naslov bloka Level up!';
$string['congratulationsyouleveledup'] = 'Čestitke!';
$string['coolthanks'] = 'Super, hvala!';
$string['courselog'] = 'Dnevnik';
$string['coursereport'] = 'Poročilo';
$string['courserules'] = 'Pravila';
$string['courseselectedcolon'] = 'Izbran predmet:';
$string['coursesettings'] = 'Nastavitve predmeta';
$string['coursevisuals'] = 'Videz';
$string['customizelevels'] = 'Prilagodi stopnje';
$string['dangerzone'] = 'Nevarno območje';
$string['defaultlevels'] = 'Privzete stopnje';
$string['defaultrules'] = 'Privzeta pravila';
$string['defaultrulesformhelp'] = 'To so privzeta pravila, ki jih omogoča vtičnik. Pravila samodejno podajo privzete točke in ignorirajo nekatere odvečne dogodke. Vaša lastna pravila imajo prednost pred njimi.';
$string['defaultsettings'] = 'Privzete nastavitve';
$string['defaultvisuals'] = 'Privzet videz';
$string['deletecondition'] = 'Izbriši pogoj';
$string['deleterule'] = 'Izbriši pravilo';
$string['description'] = 'Opis';
$string['difference'] = 'Razl.';
$string['discoverlevelupplus'] = 'Razišči Level up! Plus';
$string['dismissnotice'] = 'Prezri obvestilo';
$string['displayeveryone'] = 'Prikazuj vse';
$string['displaynneighbours'] = 'Prikaži {$a} sos.';
$string['displayoneneigbour'] = 'Prikaži enega soseda';
$string['displayparticipantsidentity'] = 'Prikazuj identitete udeležencev';
$string['displayrank'] = 'Prikaži rang';
$string['displayrelativerank'] = 'Prikaži relativni rang';
$string['documentation'] = 'Dokumentacija';
$string['editinstructions'] = 'Uredi informacije';
$string['enablecheatguard'] = 'Vključi zaščito pred goljufijami';
$string['enablecheatguard_help'] = 'Zaščita pred goljufijami ponuja preprost brezplačen mehanizem, ki preprečuje zlorabo sistema z uporabo očitnih tehnik udeležencev, kot je nenehno osveževanje iste strani ali ponavljanje istega dejanja.

[Več informacij](https://levelup.plus/docs/article/level-up-cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Omogoči stran z informacijami';
$string['enableinfos_help'] = 'Ko je izbrano "Ne", stran z informacijami udeležencem ne bo prikazana.';
$string['enableladder'] = 'Omogoči lestvico';
$string['enableladder_help'] = 'Ko je nastavljeno na "Ne", lestvica udeležencem ne bo prikazana.';
$string['enablelevelupnotif'] = 'Omogoči obveščanje o napredovanju';
$string['enablelevelupnotif_help'] = 'Ko je nastavljeno na »Da«, bo ob napredovanju na višjo stopnjo udeležencem prikazano pojavno okno s čestitkami.';
$string['enablelogging'] = 'Omogoči beleženje';
$string['enablexpgain'] = 'Omogoči pridobivanje točk';
$string['enablexpgain_help'] = 'Ko je nastavljeno na \'Ne\', je udeležencem onemogočeno pridobivanje točk. Ta nastavitev je koristna, kadar želimo zamrzniti stanje pridobljenih točk v določenem trenutku ali omogočiti pridobivanje točk v določenem terminu.

Prosimo, upoštevajte, da je pridobivanje točk mogoče nadzorovati tudi z uporabo možnosti _block/xp:earnxp_.';
$string['entersearchterm'] = 'Vnesite iskalni niz';
$string['errorcontextcoursemismatchforwholesite'] = 'URL te <em>Level up!</em> strani se ne ujema s trenutno konfiguracijo vtičnika. Vaša trenutna konfiguracija zahteva, da je <em>Level up!</em> uporabljen na nivoju "celotnega spletnega mesta", vendar ta stran pričakuje uporabo vtičnika na nivoju "predmeta". Kliknite <a href="{$a->nexturl}">tukaj</a> za premik na ustrezno stran. Konfiguracijo uredi administrator s spremembo nastavitve \'block_xp_context\'.';
$string['errorcontextcoursemismatchpercourse'] = 'URL te <em>Level up!</em> strani se ne ujema s trenutno konfiguracijo vtičnika. Vaša trenutna konfiguracija zahteva, da je <em>Level up!</em> uporabljen na nivoju "predmeta", vendar ta stran pričakuje uporabo vtičnika na nivoju "celotnega spletnega mesta". Težava najverjetneje izvira iz <em>bloka</em>, ki je bil dodan na pregledno ploščo ali domačo stran, medtem, ko je bila v uporabi drugačna konfiguracija. Blok je potrebno odstraniti z omenjenih strani in ga uporabiti samo znotraj posameznih predmetov.';
$string['errorformvalues'] = 'Obstaja nekaj težav z vrednostmi v obrazcu. Prosimo, popravite jih.';
$string['errorlevelsincorrect'] = 'Najmanjše število stopenj je 2';
$string['errornotalllevelsbadgesprovided'] = 'Vse značke stopenj niso bile podane. Manjkajoče število značk: {$a}';
$string['errorunknownevent'] = 'Napaka: neznani dogodek';
$string['errorunknownmodule'] = 'Napaka: neznana aktivnost';
$string['errorxprequiredlowerthanpreviouslevel'] = 'Število zahtevanih točk je manjše ali enako prejšnji stopnji.';
$string['event_user_leveledup'] = 'Uporabnik je napredoval';
$string['eventis'] = 'Dogodek je {$a}';
$string['eventname'] = 'Ime dogodka';
$string['eventproperty'] = 'Lastnost dogodka';
$string['eventsrules'] = 'Pravila dogodkov';
$string['eventsrules_help'] = 'Ta vtičnik uporablja atribute dogodkov za pripisovanje točk dejanjem udeležencev.
Uporabite spodnji obrazec za dodajanje svojih pravil ali spreminjanje privzetih pravil.

Priporočljivo je, da preverite stran _Log_, da ugotovite, kateri dogodki se sprožijo, ko udeleženci izvajajo dejanja v predmetu.

Dodatni viri:

- [Kako se izračunajo točke?] (https://levelup.plus/docs/article/how-are-experience-points-calculated?ref=blockxp_help)
- [Odpravljanje težav pri pravilih] (https://levelup.plus/docs/article/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Čas dogodka';
$string['filtermodules'] = 'Filtriraj module';
$string['for1day'] = 'Za 1 dan';
$string['for1month'] = 'Za 1 mesec';
$string['for1week'] = 'Za 1 teden';
$string['for3days'] = 'Za 3 dni';
$string['forever'] = 'Za vedno';
$string['forthewholesite'] = 'Za celotno spletno mesto';
$string['give'] = 'daj';
$string['gotofullladder'] = 'Pojdi na celotno lestvico';
$string['grid'] = 'Mreža';
$string['hideparticipantsidentity'] = 'Skrij identitete udeležencev';
$string['hiderank'] = 'Skrij rang';
$string['incourses'] = 'V predmetih';
$string['ineffective'] = 'Neučinkovito';
$string['infos'] = 'Informacije';
$string['instructions'] = 'Več informacij';
$string['invalidxp'] = 'Neveljavne vrednosti točk';
$string['keeplogs'] = 'Beleži dogodke';
$string['ladder'] = 'Lestvica';
$string['ladderadditionalcols'] = 'Dodatni stolpci';
$string['ladderadditionalcols_help'] = 'Ta nastavitev določa, kateri dodatni stolpci naj bodo prikazani na lestvici. Pritisnite in držite tipko CTRL ali CMD, da izberete več možnih stolpcev, ali da prekličete izbiro stolpca.';
$string['ladderempty'] = 'Lestvica je trenutno prazna. Vrni se kasneje.';
$string['level'] = 'Stopnja';
$string['levelbadges'] = 'Značke stopenj';
$string['levelbadgesformhelp'] = 'Poimenujte datoteke: [številka stopnje].[format], na primer: 1.png, 2.jpg ... Priporočljiva velikost slike je 100x100.';
$string['levelcount'] = 'Število stopenj';
$string['leveldesc'] = 'Opis stopnje';
$string['leveldesc_help'] = 'Kratek opis stopnje, ki bo prikazan na strani z informacijami poleg stopnje. Opišemo lahko nagrado ob doseženi stopnji; posredujemo navodila, kako doseči stopnjo; opišemo stopnjo na igriv način (npr. _Samo najbolj pogumne duše lahko dosežejo to stopnjo._) itd.';
$string['levelname'] = 'Ime stopnje';
$string['levelname_help'] = 'Kratko ime stopnje, ki se prikaže namesto privzetih imen: _Stopnja # 1_, _Stopnja # 2_ itd. V kolikor želite preimenovati imena stopenj, vam priporočamo, da to naredite za vse uporabljene stopnje.';
$string['levels'] = 'Stopnje';
$string['levelswillbereset'] = 'Opozorilo! Če boste shranili ta obrazec, se bodo ponovno izračunale stopnje vseh udeležencev.';
$string['levelup'] = 'Nova stopnja!';
$string['levelupplus'] = 'Level up! Plus';
$string['levelx'] = 'Stopnja #{$a}';
$string['likenotice'] = '<strong>Vam je vtičnik všeč?</strong> Prosimo, vzemite si trenutek, <a href="{$a->moodleorg}" target="_blank">dodajte ga med priljubljene</a> na strani Moodle.org in <a href="{$a->github}" target="_blank">ocenite na GitHubu</a>.';
$string['limitparticipants'] = 'Omejitev prikaza udeležencev';
$string['limitparticipants_help'] = 'Ta nastavitev nadzoruje, kdo je prikazan na lestvici. Sosedje so udeleženci, uvrščeni nad in pod trenutnim uporabnikom. Na primer, ko izberete »Prikaži 2 sos.«, bosta prikazana samo dva soseda: udeleženec, ki je uvrščen neposredno nad in neposredno pod uporabnikom.';
$string['list'] = 'Seznam';
$string['logging'] = 'Beleženje';
$string['manually'] = 'Ročno';
$string['maxactionspertime'] = 'Maks. število dejanj v časovnem okvirju';
$string['maxactionspertime_help'] = 'Največje število dejanj, ki bodo prispevala točke v danem časovnem okvirju. Vsako nadaljnje dejanje bo prezrto. Če je ta vrednost prazna ali enaka nič, nima vpliva.';
$string['movecondition'] = 'Premakni pogoj';
$string['moverule'] = 'Premakni pravilo';
$string['name'] = 'Ime';
$string['navinfos'] = 'Informacije';
$string['navladder'] = 'Lestvica';
$string['navlevels'] = 'Stopnje';
$string['navlog'] = 'Dnevnik';
$string['navpromo'] = 'Plus';
$string['navreport'] = 'Poročilo';
$string['navrules'] = 'Pravila';
$string['navsettings'] = 'Nastavitve';
$string['navvisuals'] = 'Videz';
$string['nodescription'] = 'Ni opisa';
$string['nologsrecordedyet'] = 'Ni dnevniških zapisov.';
$string['noname'] = 'Ni imena';
$string['notesomesettingslocked'] = 'Nekaterih nastavitev morda ni mogoče urejati, če jih je skrbnik zaklenil.';
$string['participant'] = 'Udeleženec';
$string['participatetolevelup'] = 'Sodelujte, pridobite točke in napredujte po stopnjah!';
$string['perpagecolon'] = 'Na stran:';
$string['pickaconditiontype'] = 'Izberi tip pogoja';
$string['pluginname'] = 'Level up!';
$string['pluginsoutofsync'] = '__Vtičniki niso sinhronizirani! __

To pomeni, da ste nadgradili _Level up! _, ne pa tudi _Level up! Plus_. Čeprav se po najboljših močeh trudimo, da bi preprečili morebitne težave, nekatere funkcije morda ne bodo več pravilno delovale, tudi v samem _Level up! _. Priporočamo, da nadgradite _Level up! Plus_ do najnovejše izdaje. [Preberite več] ({$ a-> url})';
$string['pointsintimelinker'] = 'na';
$string['pointsrequired'] = 'Zahtevane točke';
$string['privacy:metadata:log'] = 'Shranjuje dnevnik dogodkov';
$string['privacy:metadata:log:eventname'] = 'Ime dogodka';
$string['privacy:metadata:log:time'] = 'Datum dogodka';
$string['privacy:metadata:log:userid'] = 'Uporabnik, ki je pridobil točke';
$string['privacy:metadata:log:xp'] = 'Točke, ki so bile podeljene za dogodek';
$string['privacy:metadata:prefintro'] = 'Evidenca, ali je uporabnik prezrl uvodno obvestilo bloka';
$string['privacy:metadata:prefladderpagesize'] = 'Najpogosteje uporabljena velikost strani uporabnikov pri ogledu lestvice';
$string['privacy:metadata:preflevelup'] = 'Evidenca, ali naj se uporabniku prikazujejo obvestila o napredovanju na novo stopnjo';
$string['privacy:metadata:prefnotices'] = 'Evidenca, ali je uporabnik zaprl obvestilo podpore';
$string['privacy:metadata:prefseenpromo'] = 'Evidenca, kdaj si je uporabnik ogledal predstavitveno stran';
$string['privacy:metadata:xp'] = 'Shranjuje točke in stopnje uporabnikov';
$string['privacy:metadata:xp:lvl'] = 'Dosežena stopnja uporabnika';
$string['privacy:metadata:xp:userid'] = 'Uporabnik';
$string['privacy:metadata:xp:xp'] = 'Dosežene točke uporabnika';
$string['privacy:path:addon'] = 'Dodatek';
$string['privacy:path:level'] = 'Stopnja';
$string['privacy:path:logs'] = 'Dnevniki';
$string['progress'] = 'Napredek';
$string['progressbar'] = 'Vrstica napredka';
$string['promocheatguard'] = 'Zaščita pred goljufijami ni zasnovana za daljše časovne okvire. Razmislite o nadgradnji na <em>Level up! Plus</em> za omogočanje večjih časovnih okvirov in drugih funkcij. <a href="{$a->url}">Več o tem preberite tukaj</a>.';
$string['promocontactintro'] = 'Za več informacij nas kontaktirajte.';
$string['promocontactus'] = 'Stopite v stik';
$string['promoemailusat'] = 'Pošljite nam e-pošto na _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Ups! Sporočila ni bilo mogoče poslati ... Prosimo, pišite nam neposredno na: {$a}. Hvala!';
$string['promoifpreferemailusat'] = 'Pst! Če vam je ljubše, nam pošljite e-pošto neposredno na _{$a}_.';
$string['promointro'] = 'Spoznajte dodatek za _Level up!_, s katerim boste dodatno spodbujali udeležence, da dosežejo čim boljše rezultate.';
$string['promointroinstalled'] = 'Dodatek _Level up! Plus_ je nameščen v vašem sistemu in vse njegove funkcije so omogočene.';
$string['promorulesdidyouknow'] = 'Ste vedeli, da lahko udeleženci z <em>Level up! Plus</em> prejmejo točke za <em>zaključek učne enote</em>, <em>zaključek dejavnosti/virov</em> in tudi na podlagi prejetih <em>ocen</em>? <a href="{$a->url} ">Odkrijte več tukaj</a>.';
$string['promoyourmessagewassent'] = 'Hvala. Vaše sporočilo je bilo poslano. Odgovorili vam bomo v najkrajšem možnem času.';
$string['property:action'] = 'Dejanje dogodka';
$string['property:component'] = 'Komponenta dogodka';
$string['property:crud'] = 'CRUD dogodka';
$string['property:eventname'] = 'Ime dogodka';
$string['property:target'] = 'Cilj dogodka';
$string['rank'] = 'Rang';
$string['ranking'] = 'Rangiranje';
$string['ranking_help'] = 'Rang je absolutni položaj trenutnega uporabnika na lestvici. Relativni rang je razlika v točkah napredka med uporabnikom in njegovimi sosedi.';
$string['reallydeleteuserstate'] = 'Brisanje uporabnika je namenjeno le temu, da uporabnika odstranite z lestvice. Za druge namene vam priporočamo, da nastavite njegove točke na 0. Upoštevajte, da brisanje ne vpliva na možnost pridobivanja novih točk kasneje.

Pri uporabi _Level up!_ na nivoju spletnega mesta, brisanje uporabnika povzroči izbris iz poročila, kar pomeni, da ponovni pripis točk ni možen. Če uporabljate _Level up!_ na nivoju predmeta, se lahko udeleženec ponovno pojavi v poročilu, če je vpisan v ta predmet.

Ali res želite izbrisati točke tega uporabnika?';
$string['reallyresetallcoursestodefaults'] = 'Ste prepričani, da želite ponastaviti pravila vseh predmetov na privzete nastavitve? Tega dejanja ni mogoče razveljaviti.';
$string['reallyresetcourserulestodefaults'] = 'Ste prepričani, da želite ponastaviti pravila tega predmeta na privzete nastavitve? Tega dejanja ni mogoče razveljaviti.';
$string['reallyresetdata'] = 'Ste prepričani, da želite ponastaviti dosežene stopnje in točke vseh udeležencev v tem predmetu?';
$string['reallyresetgroupdata'] = 'Ste prepričani, da želite ponastaviti dosežene stopnje in točke vseh udeležencev v tej skupini?';
$string['reallyreverttopluginsdefaults'] = 'Ste prepričani, da želite ponastaviti privzeta pravila na privzete nastavitve vtičnika? Tega dejanja ni mogoče razveljaviti.';
$string['recentrewards'] = 'Nedavni dosežki';
$string['releasenotes'] = 'Opombe ob izdaji';
$string['reportisempty'] = 'Poročilo je prazno. Udeleženci še niso pridobili točk.';
$string['reportisemptyenrolstudents'] = 'Poročilo je prazno. So udeleženci vključeni v to učno enoto?';
$string['requires'] = 'Zahteva';
$string['resetallcoursestodefaults'] = 'Ponastavi vse predmete na privzete nastavitve';
$string['resetallcoursestodefaultsintro'] = 'Kliknite spodnji gumb, da ponastavite vse predmete na zgornje privzete nastavitve.';
$string['resetcoursedata'] = 'Ponastavi podatke predmeta';
$string['resetcourserulestodefaults'] = 'Ponastavi pravila predmeta na privzete nastavitve';
$string['resetgroupdata'] = 'Ponastavi podatke skupine';
$string['reverttopluginsdefaults'] = 'Povrni privzete nastavitve vtičnika';
$string['reverttopluginsdefaultsintro'] = 'Uporabite spodnji gumb, če želite, da se zgornje privzete vrednosti vrnejo na privzete nastavitve vtičnika. To ne vpliva na pravila obstoječih predmetov.';
$string['reward'] = 'Dosežek';
$string['rule'] = 'Pravilo';
$string['rule:contains'] = 'vključuje';
$string['rule:eq'] = 'je enako';
$string['rule:eqs'] = 'je strogo enako';
$string['rule:gt'] = 'je večje kot';
$string['rule:gte'] = 'je večje ali enako kot';
$string['rule:lt'] = 'je manjše kot';
$string['rule:lte'] = 'je manjše ali enako kot';
$string['rule:regex'] = 'ustreza regex';
$string['rulecm'] = 'Dejavnost ali vir';
$string['rulecm_help'] = 'Ta pogoj je izpolnjen, ko se v navedeni dejavnosti ali viru izvrši dejanje.';
$string['rulecmdesc'] = 'Dejavnost ali vir je \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'Dejavnost ali vir je: \'{$a->contextname}\' v \'{$a->coursename}\'.';
$string['rulecminfo'] = 'Ta pogoj zahteva, da se dogodek izvede v določeni učni dejavnosti ali viru.';
$string['ruleevent'] = 'Izbran dogodek';
$string['ruleeventdesc'] = 'Dogodek je \'{$a->eventname}\'';
$string['ruleeventinfo'] = 'Iz seznama izberite dogodek, ki ga mora udeleženec izvesti.';
$string['ruleproperty'] = 'Lastnost dogodka';
$string['rulepropertydesc'] = 'Lastnost \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rulepropertyinfo'] = 'Ta pogoj je namenjen naprednim uporabnikom z dobrim poznavanjem dnevniških dogodkov in njihovih nastavitev.';
$string['ruleset'] = 'Nabor pogojev';
$string['ruleset:all'] = 'VSI pogoji so izpolnjeni';
$string['ruleset:any'] = 'KATERIKOLI pogoj je izpolnjen';
$string['ruleset:none'] = 'NOBEN pogoj ni izpolnjen';
$string['rulesetinfo'] = 'Združitev več pogojev v enega.';
$string['rulesformhelp'] = '<p>Vtičnik uporablja dogodke za podeljevanje točk udeležencem za izvedena dejanja. S spodnjim obrazcem lahko dodate svoja pravila in si ogledate privzeta.</p>
<p>Priporočljivo je, da preverite <a href="{$a->log}">dnevnik vtičnika</a>, da ugotovite, kateri dogodki se sprožijo med izvajanjem dejanj, in da si preberete več o dogodkih: <a href="{$a->list}">seznam vseh dogodkov </a>, <a href="{$a->doc}">dokumentacija razvijalca</a>. </p>
<p>Upoštevajte, da vtičnik ignorira:
<ul>
     <li>Dejanja, ki jih izvajajo skrbniki, gostje ali uporabniki, ki niso prijavljeni.</li>
     <li>Dejanja, ki jih izvedejo uporabniki brez zmogljivosti <em>block/xp:earnxp</em>.</li>
     <li>Ponavljajoča dejanja v kratkem časovnem intervalu (preprečevanje goljufanja).</li>
     <li>Dogodke, ki so označeni kot <em>anonimni</em>, npr. v anonimnih Odzivih.</li>
     <li>Dogodke, ki ne sodijo v kategorijo <em>Sodelovanje</em>.</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Poišči in izberi predmet';
$string['searchandselectmodule'] = 'Poišči in izberi dejavnost ali vir';
$string['send'] = 'Pošlji';
$string['setpoints'] = 'Določite točke';
$string['shortcode:xpbadge'] = 'Značka, ki se povezuje s trenutno doseženo stopnjo uporabnika.';
$string['shortcode:xpiflevel'] = 'Prikažite to vsebino, ko se ujema dosežena stopnja uporabnika.';
$string['shortcode:xpiflevel_help'] = 'Za oblikovanje kratke kode si oglejte spodnje primere. Če je stopnja strogo določena, bo vsebina prikazana ne glede na druga pravila.
Pravila _greater_ in _less than_ se morajo ujemati z vsebino, ki bo prikazana. Bodite previdni, saj se lahko zgodi, da se vsebina nikoli ne prikaže.
Upoštevajte, da bodo izvajalci in uporabniki z možnostmi urejanja vedno videli vse.

```
[xpiflevel 1 3 5]
    Prikazano, če je stopnja uporabnika natanko 1, 3 ali 5.
[/xpiflevel]

[xpiflevel >3]
    Prikazano, če je stopnja uporabnika večja od 3.
[/xpiflevel]

[xpiflevel >=3]
    Prikazano, če je stopnja uporabnika večja ali enaka 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Prikazano, če je stopnja uporabnika večja ali enaka 10 IN je strogo manjša od 20  ALI je natančno enaka 30.
[/xpiflevel]

[xpiflevel <=10 >=20]
    Se ne prikaže, saj uporabnikova stopnja ne more biti hkrati manjša ali enaka 10 IN večja ali enaka 20.
[/xpiflevel]
```

Upoštevajte, da te kratke kode ne morejo biti ugnezdene ena v drugo.';
$string['shortcode:xpladder'] = 'Prikaži del lestvice okoli trenutnega ranga uporabnika.';
$string['shortcode:xpladder_help'] = 'Privzeto bo prikazana bližnja okolica lestvice uporabnika.

```
[xpladder]
```

Za prikaz najboljših 10 udeležencev (namesto uporabniku blizu uvrščenih), nastavite parameter `top`. Dodatno lahko nastavite število prikazanih v lestvici  npr. `top=20`.

```
[xpladder top]
[xpladder top=15]
```

Povezava na celotno lestvico bo samodejno prikazana pod tabelo. Če ne želite prikazati te povezave, dodajte argument `hidelink`.

```
[xpladder hidelink]
```

Tabela privzeto ne vsebuje stolpca napredka, ki prikazuje vrstico napredka. Če je bil ta stolpec izbran v dodatnih stolpcih v nastavitvah lestvice, lahko uporabite argument `withprogress` za prikaz.

```
[xpladder withprogress]
`` `

V primeru uporabe skupin, bo lestvica skušala prikazati lestvico za ustrezno skupino.';
$string['shortcode:xplevelname'] = 'Prikaži ime stopnje.';
$string['shortcode:xplevelname_help'] = 'Privzeto oznaka prikazuje ime trenutne stopnje uporabnika.
Alternativno lahko uporabite `level` argument za prikaz imena specifične stopnje.

```
[xplevelname]
[xplevelname level=5]
```

Če je`level` argument nastavljen in stopnja ne obstaja, ne bo prikazano nič.';
$string['shortcode:xpprogressbar'] = 'Vrstica napredka trenutnega uporabnika do naslednje stopnje.';
$string['someoneelse'] = 'Nekdo drug';
$string['somethinghappened'] = 'Nekaj se je zgodilo';
$string['taskcollectionloggerpurge'] = 'Počisti dnevnike zbiranja';
$string['thankyou'] = 'Hvala!';
$string['timebetweensameactions'] = 'Čas med enakimi dejanji';
$string['timebetweensameactions_help'] = 'To je minimalni čas, ki mora preteči, da se enako dejanje, ki se je že zgodilo, ponovno upošteva. Dejanje se šteje za enako, če je bilo postavljeno v isti kontekst in element (npr. branje objave na forumu se šteje za enako, če je bila ista objava ponovno prebrana). Če je ta vrednost prazna ali enaka nič, se ne upošteva.';
$string['timeformaxactions'] = 'Časovni okvir za maks. število dejanj';
$string['timeformaxactions_help'] = 'Časovni okvir (v sekundah), v katerem uporabnik ne sme preseči največjega števila dejanj.';
$string['tinytimedays'] = '{$a}d';
$string['tinytimehours'] = '{$a}h';
$string['tinytimeminutes'] = '{$a}m';
$string['tinytimenow'] = 'zdaj';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}w';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Skupaj';
$string['unknowneventa'] = 'Neznan dogodek ({$a})';
$string['updateandpreview'] = 'Posodobitev in predogled';
$string['upgradingplugins'] = 'Nadgradnja vtičnikov';
$string['urlaccessdeprecated'] = 'Dostop prek tega URL-ja je potekel, prosimo, posodobite povezave.';
$string['usealgo'] = 'Uporabi algoritem';
$string['usecustomlevelbadges'] = 'Uporabi značke stopenj po meri';
$string['usecustomlevelbadges_help'] = 'Ko je nastavljeno na "Da", morate zagotoviti sliko za vsako stopnjo.';
$string['usingalgo'] = 'Uporaba algoritma';
$string['value'] = 'Vrednost';
$string['valuessaved'] = 'Vrednosti so bile uspešno shranjene.';
$string['viewas'] = 'Poglej kot';
$string['viewtheladder'] = 'Ogled lestvice';
$string['visualsintro'] = 'Naložite slike, da prilagodite videz stopenj.';
$string['wewillreplyat'] = 'Odgovorili bomo ob: _{$a}_.';
$string['when'] = 'Kdaj';
$string['wherearexpused'] = 'Kje se točke uporabijo?';
$string['wherearexpused_desc'] = 'Ko je nastavljeno na "V predmetih", bodo pridobljene točke upoštevane le za predmet, v katerem je bil blok dodan. Ko je nastavljeno na »Za celotno spletno mesto«, bo uporabnik napredoval »stopnjo višje« na celotnem spletnem mestu in ne selektivno znotraj predmetov (uporabljene bodo vse točke, pridobljene na celotnem spletnem mestu).';
$string['whoops'] = 'Ups!';
$string['xp'] = 'Točke napredka';
$string['xp:addinstance'] = 'Dodaj nov blok';
$string['xp:earnxp'] = 'Pridobivanje točk';
$string['xp:manage'] = 'Upravljajte z vsemi vidiki točk';
$string['xp:myaddinstance'] = 'Dodaj blok na Pregledno ploščo';
$string['xp:view'] = 'Poglej blok in z njim povezane strani';
$string['xp:viewlogs'] = 'Ogled dnevnikov';
$string['xpgaindisabled'] = 'Pridobivanje točk onemogočeno';
$string['xprequired'] = 'zahtevane XP';
$string['xptogo'] = 'manjka še [[{$a}]]';
$string['youreachedlevel'] = 'Dosežena je stopnja:';
$string['youreachedlevela'] = '{$a}. stopnja je dosežena!';
$string['yourmessage'] = 'Vaše sporočilo';
$string['yourownrules'] = 'Vaša pravila';
