<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sl', version '4.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Dostop zavrnjen';
$string['accounts'] = 'Računi';
$string['addcategory'] = 'Dodaj kategorijo';
$string['additionalhtml'] = 'Dodatna koda HTML';
$string['additionalhtml_desc'] = 'Te nastavitve omogočajo, da določite kodo HTML, ki bi jo radi dodali na vsako stran. Določite lahko kodo HTML, ki bo dodana znotraj oznake HEAD na spletnem mestu, neposredno za odprtjem oznake BODY ali neposredno pred njenim zaprtjem.<br />To bo omogočilo, da zelo enostavno in neodvisno od izbrane teme na vsako stran dodate po meri izdelane glave ali noge spletne strani ali dodate podporo za storitve, kakršna je npr. Google Analytics.';
$string['additionalhtml_heading'] = 'Dodatna koda HTML bo dodana na vsako stran.';
$string['additionalhtmlfooter'] = 'Pred zaprtjem oznake BODY';
$string['additionalhtmlfooter_desc'] = 'Ta vsebina bo na vsako stran dodana neposredno pred zaprtjem oznake BODY.';
$string['additionalhtmlhead'] = 'Znotraj oznake HEAD';
$string['additionalhtmlhead_desc'] = 'Ta vsebina bo na vsaki strani dodana na dno oznake HEAD.';
$string['additionalhtmltopofbody'] = 'Ob odprtju oznake BODY';
$string['additionalhtmltopofbody_desc'] = 'Ta vsebina bo na vsako stran dodana neposredno pred odprtjem oznake BODY.';
$string['admincategory'] = 'Kategorija: {$a}';
$string['adminseesall'] = 'Skrbniki vidijo vse';
$string['adminseesallevents'] = 'Skrbniki vidijo vse dogodke';
$string['adminseesownevents'] = 'Skrbniki so enaki drugim uporabnikom';
$string['advancedfeatures'] = 'Napredne funkcije';
$string['agedigitalconsentverification'] = 'Preverjanje digitalne starosti privolitve';
$string['agedigitalconsentverification_desc'] = 'Omogoči preverjanje digitalne starosti privolitve pred prikazom prijavne strani za samovpisne uporabnike. To vašo stran zavaruje pred tem, da bi se mladoletniki vpisovali brez privolitve zakonitih zastopnikov. Za nadaljno pomoč so mladoletnikom na voljo podrobnosti o <a target="_blank" href="{$a}«>Kontaktu za podporo</a>.';
$string['ageofdigitalconsentmap'] = 'Digitalna starost privolitve';
$string['ageofdigitalconsentmap_desc'] = 'Tu lahko določite privzeto digitalno starost privolitve in starost v kateri koli državi, kjer se privzeta nastavitev razlikuje. Vsako starost vnesi v novo vrstico v obliki: koda države, starost (ločena z vejico). Privzeta starost je označena z * na mestu kode države. Kode držav so navedene v ISO 3166-2.';
$string['allcountrycodes'] = 'Vse kode držav';
$string['allowattachments'] = 'Dovoli priponke';
$string['allowbeforeblock'] = 'Seznam dovoljenih bo najprej obdelan';
$string['allowbeforeblockdesc'] = 'Privzeto se vnosi na seznamu blokiranih naslovov IP obdelajo najprej. Če je ta možnost omogočena, so vnosi na seznamu dovoljenih naslovov IP obdelani pred blokiranimi.';
$string['allowcategorythemes'] = 'Dovoli teme kategorij';
$string['allowcohortthemes'] = 'Dovoli teme kohort';
$string['allowcoursethemes'] = 'Dovoli teme predmetov';
$string['allowedemaildomains'] = 'Dovoljene domene e-poštnih naslovov';
$string['allowediplist'] = 'Seznam dovoljenih naslovov IP';
$string['allowemailaddresses'] = 'Dovoljene domene e-poštnih naslovov';
$string['allowemojipicker'] = 'Izbirnik emodžijev';
$string['allowframembedding'] = 'Omogoči vdelavo okvirjev';
$string['allowframembedding_help'] = 'Če je to omogočeno, lahko je lahko spletno mesto vdelano v okvir v zunanjem sistemu, kot je priporočljivo med uporabo vpisnega vtičnika »Objavi kot orodje LTI«. Drugače pa omogočanje te funkcije ni priporočljivo iz varnostnih razlogov. Upoštevajte, da je pri mobilni aplikaciji ta nastavitev prezrta in je vdelava okvirja vedno dovoljena.';
$string['allowguestmymoodle'] = 'Dovoli gostujoči dostop do Nadzorne plošče';
$string['allowindexing'] = 'Spletnim iskalnikom dovoli vpisovanje v kazalo';
$string['allowindexing_desc'] = 'To določi, ali lahko iskalniki vaše spletno mesto vpišejo v kazalo. »Povsod« omogoča iskalnikom iskanje povsod, vključno z prijavnimi in registracijskimi stranmi. To pomeni, da so strani z vsiljenim vpisom še vedno vpisane v kazalo. Da bi se izognili tveganju neželene vsebine, ki je povezana z izsledljivostjo prijavne strani, uporabite »Povsod, razen na prijavnih in registracijskih straneh«. Če izberete »Nikjer«, to iskalnikom sporoči, naj v kazalo ne vpišejo nobene strani. Upoštevajte, da je to le oznaka v glavi spletnega mesta. Od iskalnika je odvisno, ali bo oznako upošteval.';
$string['allowindexingeverywhere'] = 'Povsod';
$string['allowindexingexceptlogin'] = 'Povsod razen na prijavnih in registracijskih straneh';
$string['allowindexingnowhere'] = 'Nikjer';
$string['allowobjectembed'] = 'Dovoli oznaki EMBED in OBJECT';
$string['allowthemechangeonurl'] = 'Dovoli spremembe teme v URL-ju';
$string['allowuserblockhiding'] = 'Uporabnikom dovoli skrivanje blokov';
$string['allowusermailcharset'] = 'Uporabnikom dovoli izbiro nabora znakov';
$string['allowuserswitchrolestheycantassign'] = 'Uporabnikom brez zmožnosti dodeljevanja vlog dovoli, da zamenjajo vloge';
$string['allowuserthemes'] = 'Dovoli uporabniške teme';
$string['alternativefullnameformat'] = 'Nadomestna oblika polnega imena';
$string['alternativefullnameformat_desc'] = 'Nastavitev določa, kako se imena prikažejo uporabnikom s sposobnostjo ogleda celotnega imena (privzeto so to uporabniki z vlogo upravljavca, učitelja ali učitelja brez pravic urejanja). Spremenljivke, ki jih lahko uporabite, so iste kot pri nastavitvi "Oblika polnega imena".';
$string['always'] = 'Vedno';
$string['appearance'] = 'Videz';
$string['aspellpath'] = 'Pot do črkovalnika Aspell';
$string['authentication'] = 'Preverjanje pristnosti';
$string['authpreventaccountcreation'] = 'Prepreči ustvarjanje računa med preverjanjem pristnosti';
$string['authpreventaccountcreation_help'] = 'Ko uporabnik potrdi pristnost, se račun samodejno ustvari, če ta še ne obstaja. Izberite to možnost, če za preverjanje pristnosti uporabljate zunanjo podatkovno bazo (npr. LDAP) in želite dovoliti dostop le uporabnikom, ki že imajo svoj račun. Nove račune boste morali ustvariti ročno ali pa s pomočjo funkcije nalaganja uporabnikov. Upoštevajte, da ta nastavitev ne velja za preverjanje pristnosti MNet.';
$string['authsettings'] = 'Upravljaj preverjanje pristnosti';
$string['autolang'] = 'Samodejna zaznava jezika';
$string['autolangusercreation'] = 'Ob ustvarjanju računa se uporabnikov privzeti jezik brskalnika nastavi kot želeni jezik';
$string['autologinguests'] = 'Samodejna prijava gostov';
$string['availablelicenses'] = 'Licence na voljo';
$string['availableto'] = 'Na voljo';
$string['backgroundcolour'] = 'Prosojna barva';
$string['backup_shortname'] = 'Uporabite ime predmeta v imenu datoteke varnostne kopije';
$string['backup_shortnamehelp'] = 'Uporabite ime predmeta kot del imena datoteke varnostne kopije.';
$string['backups'] = 'Varnostne kopije';
$string['badwordsconfig'] = 'Vnesite svoj seznam slabih besed in jih ločite z vejicami.';
$string['badwordsdefault'] = 'Če je seznam po meri prazen, bo uporabljen privzet seznam iz jezikovnega paketa.';
$string['badwordslist'] = 'Seznam slabih besed po meri';
$string['blockediplist'] = 'Seznam blokiranih IP naslovov';
$string['blockinstances'] = 'Elementi';
$string['blockmultiple'] = 'Večkraten';
$string['blockprotect'] = 'Zaščita elementov';
$string['blockprotect_help'] = 'Če zaklenete določen tip bloka, nihče ne more vanj dodajati ali brisati elementov. (Seveda ga lahko odklenete in elemente popravite.)

Ta možnost je namenjena varovanju blokov, kot je navigacija ali nastavitve, ki jih je zelo težko povrniti, če so pomotoma izbrisani.';
$string['blocksettings'] = 'Upravljaj bloke';
$string['blockunprotect'] = 'Odstrani zaščito';
$string['bloglevel'] = 'Vidnost bloga';
$string['bookmarkadded'] = 'Zaznamek je dodan.';
$string['bookmarkalreadyexists'] = 'Stran je že dodana med zaznamke.';
$string['bookmarkdeleted'] = 'Zaznamek je izbrisan.';
$string['bookmarkthispage'] = 'Dodaj stran med zaznamke';
$string['cacheapplication'] = 'Aplikacijski predpomnilnik';
$string['cacheapplicationhelp'] = 'Predpomnjene elemente si lahko delijo vsi uporabniki, potečejo pa po določeni življenjski dobi (TTL).';
$string['cachejs'] = 'Predpomnilnik JavaScript';
$string['cachejs_help'] = 'Predpomnjenje in stiskanje JavaScript-a močno izboljša zmogljivost nalaganja strani. Za prednostna spletišča je to zelo priporočeno. Razvijalci bodo verjetno želeli to funkcijo onemogočiti.';
$string['cacherequest'] = 'Zahtevajte predpomnjenje';
$string['cacherequesthelp'] = 'Poseben uporabniški predpomnilnik, ki poteče, ko je zahteva izpolnjena. Nadomešča območja, kjer uporabljamo statične pomnilnike.';
$string['cachesession'] = 'Predpomnilnik seje';
$string['cachesessionhelp'] = 'Poseben uporabniški predpomnilnik, ki poteče, ko se konča uporabniška seja. Namenjen je razbremenitvi posamezne seje.';
$string['cachesettings'] = 'Nastavitve predpomnilnika';
$string['cachetemplates'] = 'Predpomnilne predloge';
$string['cachetemplates_help'] = 'Predpomnjenje predlog bo izboljšalo izvedbo nalaganja strani. Zelo je priporočljivo za prednostna spletišča. Razvijalci bodo to funkcijo verjetno želeli onemogočiti.';
$string['caching'] = 'Predpomnjenje';
$string['calendar_weekend'] = 'Vikend';
$string['calendarexportsalt'] = 'Varnostni niz za izvoz koledarja';
$string['calendarsettings'] = 'Koledar';
$string['calendartype'] = 'Tip koledarja';
$string['calendartype_desc'] = 'Izberite privzeti tip koledarja za celotno spletno mesto. To nastavitev lahko preglasijo nastavitve predmetov ali uporabniki na osebnih profilih.';
$string['cannotdeletemodfilter'] = 'Namestitve \'{$a->filter}\' ne morete odstraniti, ker je del modula \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} ne more biti odstranjen.';
$string['categoryemail'] = 'E-pošta';
$string['cfgwwwrootslashwarning'] = 'Pri nastavitvi $CFG->wwwroot v datoteki config.php je prišlo do napake. Na koncu niza ste vključili znak \'/\'. Prosimo odstranite znak.';
$string['cfgwwwrootwarning'] = 'Pri nastavitvi $CFG->wwwroot v datoteki config.php je prišlo do napake. Nastavitev se ne ujema z naslovom URL, ki ga uporabljate za dostop do te strani.';
$string['change'] = 'spremeni';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Da';
$string['checkupgradepending'] = 'Nadgradi';
$string['choosefiletoedit'] = 'Izberite datoteko za urejanje';
$string['cleanup'] = 'Čiščenje';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'd';
$string['cliexitgraceful'] = 'Izhod iz strani, prosimo, počakajte ...';
$string['cliexitnow'] = 'Izhod ZDAJ';
$string['cliincorrectvalueerror'] = 'Napaka, nepravilna vrednost "{$a->value}" za "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nepravilna vrednost, prosimo poskusite znova';
$string['clistatusdisabled'] = 'Stanje: onemogočeno';
$string['clistatusenabled'] = 'Stanje: omogočeno';
$string['clistatusenabledlater'] = 'stanje: vzdrževalni način CLI bo omogočen na {$a}';
$string['clitypevalue'] = 'vtipkajte vrednost';
$string['clitypevaluedefault'] = 'vtipkajte vrednost, kliknite Enter za uporabo privzete vrednosti ({$a})';
$string['cliunknowoption'] = 'Neprepoznane možnosti:
  {$a}
Uporabite možnost --help.';
$string['cliupgradedefault'] = 'Nova nastavitev: {$a}';
$string['cliupgradedefaultheading'] = 'Nastavitev novih privzetih vrednosti';
$string['cliupgradedefaultverbose'] = 'Nova nastavitev: {$a->name}, Privzeta vrednost: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Nadgradnja v ukazni vrstici z  {$a->oldversion} na {$a->newversion} je bila uspešno zaključena.';
$string['cliupgradenoneed'] = 'Nadgradnja za nameščeno različico {$a} ni potrebna.';
$string['cliupgradepending'] = 'Nadgradnja v čakanju';
$string['cliyesnoprompt'] = 'vtipkajte d (pomeni da) ali n (pomeni ne)';
$string['commentsperpage'] = 'Število komentarjev, prikazanih na strani';
$string['commonactivitysettings'] = 'Skupne nastavitve dejavnosti';
$string['commonfiltersettings'] = 'Skupne nastavitve filtra';
$string['commonsettings'] = 'Skupne nastavitve';
$string['componentinstalled'] = 'Komponenta je nameščena';
$string['computedfromlogs'] = 'Izračunano iz dnevnikov od dne {$a}.';
$string['condifmodeditdefaults'] = 'Ko ustvarjate novo dejavnost ali vir, so v nastavitvah obrazca uporabljene privzete vrednosti.';
$string['confeditorhidebuttons'] = 'Izberite gumbe, ki naj bodo skriti v urejevalniku HTML.';
$string['configallcountrycodes'] = 'To je seznam držav, ki jih lahko izberete na različnih mestih, na primer v profilu uporabnika. Če je prazen (privzeto), bo uporabljen seznam iz datoteke countries.php v standardnem angleškem jezikovnem paketu. To je seznam iz ISO 3166-1. V nasprotnem primeru lahko z vejico določite ločen seznam kod, na primer \'GB, FR, ES\'. Če sem dodate novo, nestandardno kodo, jo morate dodati tudi v countries.php v \'en\' in v vašem jezikovnem paketu.';
$string['configallowassign'] = 'Osebam, ki imajo vloge na levi strani, lahko dovolite, da določijo vloge nekaterih stolpcev drugim osebam';
$string['configallowattachments'] = 'Če je omogočeno, lahko elektronska sporočila s tega spletnega mesta vsebuje priponke, na primer značke.';
$string['configallowcategorythemes'] = 'Ta nastavitev omogoča nastavljanje tem na ravni kategorije. Nastavitev vpliva na vse podrejene kategorije in predmete, razen v primeru, da imajo nastavljeno svojo temo. OPOZORILO: Omogočanje tem kategorij lahko vpliva na učinkovitost delovanja.';
$string['configallowcohortthemes'] = 'Ta nastavitev omogoča nastavljanje tem na ravni kohorte. Nastavitev vpliva na vse uporabnike s samo eno kohorto oziroma več kohortami z isto temo.';
$string['configallowcoursethemes'] = 'Ta nastavitev omogoča, da je pri predmetih dovoljena nastavitev lastnih tem. Teme predmetov preglasijo vse druge izbore tem (teme spletnega mesta, uporabnika ali seje)';
$string['configallowedemaildomains'] = 'Navedite e-poštne domene, ki so lahko prikazane na odseku »Od« med odhodno pošto. Privzeta nastavitev »Prazno« bo uporabila poštne naslove Brez odgovora za vso izhodiščno pošto. Uporaba nadomestnih znakov je dovoljena npr. *.example.com bo dovolil pošiljanje e-poštnih sporočil iz katere koli poddomene example.com, ne pa tudi samega example.com. To bo zahtevalo ločen vnos.';
$string['configallowemailaddresses'] = 'Če želite omejiti vse nove e-poštne naslove na določene domene, jih navedite tu in ločite s presledki. Vse druge domene bodo zavrnjene. Da dovolite poddomene, dodajte domeno, ki se začne s \'.\'. Da dovolite korensko domeno skupaj s svojimi poddomenami, domeno dodajte dvakrat – enkrat tako, da se začne s \'.\' in enkrat brez tega, na primer: .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Izbirnik emodžijev omogoča uporabnikom, da preko gumba izbirnika emodžijev v Atto orodni vrstici izbirajo emodžije, kot so smeškoti, in jih dodajo v sporočila in druga tekstovna polja.';
$string['configallowemojipickerincompatible'] = 'Vaša tenutna konfiguracija podatkovne baze ne podpira emodžijev. Če želite omogočiti izbirnik emodžijev morate <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">za polno unicode podporo nadgraditi vašo podatkovno bazo</a>.';
$string['configallowguestmymoodle'] = 'Če je omogočeno, bo gostom dovoljen dostop do strani Nadzorna plošča, sicer bodo preusmerjeni na naslovno stran.';
$string['configallowobjectembed'] = 'Kot privzet varnostni ukrep običajnim uporabnikom v besedilih ni dovoljena vdelava večpredstavnosti (kot je Flash) z uporabo oznak EMBED in OBJECT v HTML kodi (čeprav je to še vedno moč varno narediti z uporabo filtra medijskih vtičnikov). Če želite dovoliti te oznake, omogočite to možnost.';
$string['configallowoverride'] = 'Vlogam na levi strani dovoli, da preglasijo vloge, označene v posameznem stolpcu';
$string['configallowoverride2'] = 'Izberite, katere vloge lahko preglasijo vloge na levi strani.<br />Upoštevajte, da nastavitev velja samo za uporabnike, ki imajo dovoljeno funkcijo moodle/role:override ali moodle/role:safeoverride.';
$string['configallowswitch'] = 'Izberite, katere vloge lahko uporabnik zamenja glede na vloge, ki jih že ima. Poleg vnosa v tej tabeli, mora uporabnik imeti tudi možnost moodle/role:switchroles, če želi menjati vloge.<br />Upoštevajte, da je to možno le za zamenjavo vlog, ki imajo zmožnost moodle/course:view in nimajo možnosti moodle/site:doanything, zato so nekateri stolpci v tej tabeli onemogočeni.';
$string['configallowthemechangeonurl'] = 'Če je omogočeno, se lahko temo spremeni, bodisi da dodate:<br />?theme=themename kateremkoli Moodle URL-ju (npr. mojamoodlestran.si/?theme=afterburner ) ali <br />&theme=themename kateremkoli inernem Moodle URL-ju (npr. mojamoodlestran.si/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Želite uporabnikom dovoliti skrivanje/prikazovanje stranskih blokov na celotnem spletnem mestu? Ta funkcija uporablja JavaScript in piškotke za pomnjenje stanja vsakega skrčljivega bloka in vpliva samo na uporabnikov lastni pogled.';
$string['configallowusermailcharset'] = 'Če to omogočite, bo vsak uporabnik strani lahko sam določil lasten nabor znakov za e-pošto.';
$string['configallowuserswitchrolestheycantassign'] = 'Privzeto je moodle/role:assign potrebno nastaviti, da uporabniki lahko zamenjajo vloge. S tem, ko omogočite to nastavitev, odstranite to zahtevo. Posledično se prikazane vloge v spustnem meniju "Zamenjaj vlogo v" določijo le v nastavitvah tabele "Dovoli določitve vlog".
Priporočljivo je, da nastavitve v tabeli "Dovoli dodelitev vlog" ne dovolijo uporabnikom, da njihovo trenutno vlogo zamenjajo v vlogo, ki ima več zmožnosti.';
$string['configallowuserthemes'] = 'Ta nastavitev omogoča, da bodo lahko uporabniki nastavili svoje lastne teme. Uporabniške teme preglasijo teme spletnega mesta (a ne tem predmetov)';
$string['configallowview'] = 'Izberite, katere vloge bo videl uporabnik, po katerih bo lahko filtriral rezultate itd. na podlagi njihove lastne vloge.';
$string['configallusersaresitestudents'] = 'Naj bodo VSI uporabniki šteti kot udeleženci dejavnosti na naslovni strani spletnega mesta? Če odgovorite "Da", bo vsak potrjen uporabniški račun smel sodelovati kot udeleženec v teh dejavnostih. Če odgovorite "Ne", bodo samo uporabniki, ki že sodelujejo v vsaj enem predmetu, smeli sodelovati v dejavnostih naslovne strani. Samo skrbniki in posebej dodeljeni učitelji smejo delovati kot učitelji za dejavnosti naslovne strani.';
$string['configauthenticationplugins'] = 'Prosimo, izberite vtičnike preverjanja pristnosti, ki jih želite uporabljati in jih razporedite po vrstnem redu, v katerem želite, da se poskusijo uporabiti.';
$string['configautolang'] = 'Zaznaj privzeti jezik iz nastavitev brskalnika. Če to ni onemogočeno, bo uporabljen privzeti jezik spletne strani.';
$string['configautolangusercreation'] = 'Če je omogočeno, je uporabnikov jezik brskalnika nastavljen na njihov zaželeni jezik, ko je uporabniški račun ustvarjen samodejno ob prvi prijavi (npr. z uporabo LDAP ali OAuth 2 preverjanja pristnosti). Drugače je privzeti jezik spletnega mesta nastavljen kot uporabnikov zaželeni jezik.';
$string['configautologinguests'] = 'Naj bodo obiskovalci ob vstopu v predmete z gostujočim dostopom samodejno prijavljeni kot gosti?';
$string['configbloglevel'] = 'Ta nastavitev omogoča omejitev ravni, do katere je možen ogled uporabniških blogov na tem spletnem mestu. Upoštevajte, da to določa najvišji kontekst BRALCA in ne pisca ali tipa prispevkov na blogu. Blogi so lahko tudi popolnoma onemogočeni, če jih sploh ne želite.';
$string['configcalendarcustomexport'] = 'Omogoči izvoz po meri prilagojenega datumskega razpona iz koledarja';
$string['configcalendarexportsalt'] = 'To naključno besedilo pomaga izboljšati varnost žetonov za preverjanje pristnosti, uporabljenih za izvoz koledarja. Upoštevajte, da ob spremembi obstoječi žetoni niso več veljavni.';
$string['configcookiehttponly'] = 'Omogoči novo funkcijo PHP 5.2.0, ki brskalnikom naroča, da piškotke pošljejo le s pravimi zahtevami HTTP. Piškotki ne smejo biti dostopni s skriptnimi jeziki. Vsi brskalniki te funkcije ne podpirajo, možno pa je tudi, da ni popolnoma združljiva s trenutno kodo. Pomaga pri preprečevanju določenih tipov napadov XSS.';
$string['configcookiesecure'] = 'Če strežnik sprejema samo povezave https, je priporočeno omogočenje funkcije pošiljanja varnih piškotkov. Če je omogočeno, zagotovite, da spletni strežnik ne sprejema povezav tipa http:// ali pa nastavite stalno preusmeritev na naslov https:// in po možnosti pošljite glave HSTS. V primeru, da se <em>wwwroot</em> naslov ne začne s https://, se ta nastavitev samodejno izključi.';
$string['configcountry'] = 'Če tu nastavite državo, bo ta država privzeto izbrana za nove uporabniške račune. Če želite uporabnike prisiliti k izbiri države, pustite možnost prazno.';
$string['configcoursegraceperiodafter'] = 'Obdrži pretekle predmete v seznamu »se izvaja« za toliko dni po datumu konca predmeta.';
$string['configcoursegraceperiodbefore'] = 'Razvrsti prihodnje predmete kot »se izvaja« za toliko dni pred datumom pričetka predmeta.';
$string['configcourseoverviewfilesext'] = 'Z vejicami ločen seznam dovoljenih razširitev datotek v povzetku predmeta.';
$string['configcourseoverviewfileslimit'] = 'Največje število datotek, ki so lahko prikazane poleg povzetka predmeta na spletni strani s seznamom predmetov. Prva slikovna datoteka je uporabljena kot slika premeta v pregledu premeta na uporabnikovi nadzorni plošči. Dodatne datoteke so prikazane le na spleni strani s seznamom predmetov.';
$string['configcourserequestnotify'] = 'Vtipkajte uporabniško ime uporabnika, ki bo obveščen o zahtevi za nov predmet.';
$string['configcourserequestnotify2'] = 'Uporabniki, ki bodo obveščeni v primeru zahteve po novem predmetu. Navedeni so samo uporabniki, ki lahko odobrijo zahtevo.';
$string['configcoursesperpage'] = 'Vnesite število predmetov, ki se bodo prikazali na posamezni strani seznama predmetov.';
$string['configcourseswithsummarieslimit'] = 'Največje število prikazanih predmetov na seznamu, ki vključuje povzetke, preden se prikaže preprostejši seznam.';
$string['configcronclionly'] = 'Zaganjanje crona iz spletnega brskalnika lahko anonimnim uporabnikom razkrije zaupne informacije. Zato je priporočljivo zaganjanje le iz ukazne vrstice ali nastavitev gesla za oddaljen dostop do crona.';
$string['configcronremotepassword'] = 'To pomeni, da skripta cron.php ni mogoče pognati iz spletnega brskalnika brez vnosa gesla z uporabo naslednje oblike URL: <pre>
http://stran.primer.com/admin/cron.php?password=opensesame
</pre> Če polje pustite prazno, geslo ni zahtevano.';
$string['configcurlcache'] = 'Življenjska doba za predpomnilnik cURL v sekundah.';
$string['configcustommenuitems'] = 'Tukaj lahko konfigurirate meni po meri za prikaz v temah. Vsaka vrstica je sestavljena iz besedila menija, povezave URL (neobvezno), naslova orodnega namiga (neobvezno) in kodo jezika oz. z vejicami ločen seznam kod (neobvezno, za prikaz vrstice uporabnikom določenih jezikov), ki so ločeni z navpičnico. Vrstice, ki se pričnejo z vezajem, se bodo pojavile kot elementi nadrejenega menija, niz ### pa deluje kot ločilnik. Na primer:
<pre>
Moodle skupnost|https://moodle.org
-Moodle brezplačna podpora|https://moodle.org/support
-###
-Moodle razvoj|https://moodle.org/development
--Moodle Dokumentacija|http://docs.moodle.org|Moodle Docs
--Slovenska Moodle Dokumentacija|http://docs.moodle.org/sl|Dokumentacija v slovenščini|sl
#####
Moodle.com|http://moodle.com/
</pre>';
$string['configcustomusermenuitems'] = 'Vsebine uporabniškega menija lahko konfigurirate (Z izjemo odjavne povezave, ki se doda avtomatsko). Vsaka vrsta je ločena z navpičnicami in jo sestavljajo 1) niz v "langstringname, componentname" obliki ali kot navadno besedilo, 2) URL, in 3) ikona kot bitna ikona (v mapi bit s strukturo [subfoldername]/[iconname], e.g. i/publish) ali kot URL. Delivce se lahko uporabi z dodajanjem vrste enega ali več # znakov, kjer to želite.';
$string['configdbsessions'] = 'Če je omogočeno, bo za hranjenje informacij o trenutnih sejah uporabljena podatkovna baza. Upoštevajte, da bo spreminjanje te nastavitve odjavilo vse trenutno prijavljene uporabnike (vključno z vami). Če uporabljate MySQL, se prepričajte, da je spremenljivka \'max_allowed_packet\' v my.cnf (ali my.ini) nastavljena na vsaj 4M. Druge gonilnike seje lahko konfigurira neposredno v config.php, za več podrobnosti glej config-dist.php. Ta možnosti izgine, če določite gonilnik seje v datoteki config.php.';
$string['configdebug'] = 'Če to vključite, bo povečana raven javljanja napak PHP (error_reporting) in bo prikazanih več opozoril. To je koristno samo za razvijalce.';
$string['configdebugdisplay'] = 'Če je omogočeno, se bo sporočilo o napaki prikazalo na strani HTML. Čeprav je funkcija priročna, onemogoči delovanje XHTML-ja, JS-ja, piškotkov in glav HTTP. Če je izklopljeno, se bo sporočilo o napaki shranilo v strežniški dnevnik, kar omogoča lažje razhroščevanje. Nastavitev PHP error_log določa, v kateri dnevnik se bodo shranila sporočila o napaki.';
$string['configdebugpageinfo'] = 'Omogočite, če želite informacije o strani prikazati v nogi strani.';
$string['configdebugvalidators'] = 'Omogočite, če želite imeti v nogi strani povezave do zunanjih potrditvenih strežnikov. Morda boste morali ustvariti novega uporabnika z uporabniškim imenom <em>w3cvalidator</em> in omogočiti gostujoči dostop. Te spremembe lahko povzročijo nepooblaščen dostop do strežnika. Ne omogočajte tega na prednostnih spletiščih!';
$string['configdefaulthomepage'] = 'To določa domačo stran pri navigaciji za prijavljene uporabnike';
$string['configdefaultrequestcategory'] = 'Predmeti, ki jih bodo zahtevali uporabniki, ki lahko zatevajo nove premete v sistemu, bodo samodejno uvrščeni v to kategorijo, razen če lahko izberejo drugo kategorijo.';
$string['configdefaultrequestedcategory'] = 'Privzeta kategorija, v katero se uvrstijo zahtevani predmeti, če so odobreni.';
$string['configdefaultuserroleid'] = 'Vsem prijavljenim uporabnikom bodo na ravni spletnega mesta dodeljene zmožnosti vloge, ki jo tu določite, in bodo DODANE vsem ostalim vlogam, ki jih uporabniki že imajo. Privzeta vloga je Uporabniška vloga preverjanja pristnosti (ali vloga Gosta v starejših verzijah). Upoštevajte, da ta nastavitev ne bo v sporu z ostalimi vlogami uporabnikov, ampak uporabnikom zagotovi zmožnosti, ki jih ni mogoče nastaviti na ravni predmeta (npr. vnosi prispevkov na blogu, upravljanje z lastnim koledarjem, ipd.).';
$string['configdeleteincompleteusers'] = 'Po preteku tega obdobja bodo vsi uporabniški računi, ki nimajo nastavljenega imena, priimka ali e-naslova, izbrisani.';
$string['configdeleteunconfirmed'] = 'Če uporabljate preverjanje pristnosti prek e-pošte, je to obdobje, v katerem bo sprejet uporabnikov odgovor. Po tem obdobju bodo stari nepotrjeni računi izbrisani.';
$string['configdenyemailaddresses'] = 'Za zavrnitev e-poštnih naslovov določenih domen, jih tu navedite na enak način. Vse druge domene bodo sprejete. Da poddomeno zavrnete, dodajte domeno, ki se konča s \'.\'. Primer: <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Uporabnikom onemogoči možnost spreminjanja slik profila.';
$string['configdisplayloginfailures'] = 'To bo uporabnikom prikazalo informacije o prejšnjih spodletelih prijavah.';
$string['configdndallowtextandlinks'] = 'Omogočite ali onemogočite način "povleci" in "spusti" za besedilo in povezave na strani predmeta, poleg že obstoječe možnosti "povleci" in "spusti" za datoteke. Upoštevajte, da ta funkcija v Firefoxu ali med različnimi brskalniki ne deluje zanesljivo. Lahko se zgodi, da se podatki ne naložijo ali pa, da je naloženo besedilo poškodovano.';
$string['configdoclang'] = 'Ta jezik bo uporabljen v povezavah na straneh dokumentacije.';
$string['configdocroot'] = 'Opredeli pot do Moodle Docs za zagotavljanje specifične kontekstualne dokumentacije prek povezave \'Moodle Docs za to stran\' v nogi na vsaki strani. Če polje pustite prazno, povezava ne bo prikazana.';
$string['configdoctonewwindow'] = 'Ta nastavitev omogoča, da se bodo povezave do Moodle Docs odprle v novem oknu.';
$string['configeditordictionary'] = 'Ta vrednost bo uporabljena v primeru, da črkovalnik Aspell nima slovarja za jezik uporabnika.';
$string['configeditorfontlist'] = 'Izberite pisave, ki bodo prikazane v spustnem seznamu urejevalnika.';
$string['configemailchangeconfirmation'] = 'Zahtevaj potrditev novega e-poštnega naslova, če uporabniki zamenjajo svoj e-poštni naslov v profilu.';
$string['configemaildkimselector'] = 'Izbirnik DKIM je poljuben in zapis(i) DNS se morajo s tem ujemati.';
$string['configemailfromvia'] = 'Dodajte prek informacij v odsek »Od« odhodne e-pošte. To obvesti prejemnika, od kod je prišlo to e-poštno sporočilo ter pomaga blokirati nenamerne odgovore prejemnikov na e-poštne naslove brez odgovora.';
$string['configemailheaders'] = 'Neobdelana glava e-pošte naj bo dobesedno dodana vsej izhodni e-pošti.';
$string['configemailsubjectprefix'] = 'Zadeva naj ima besedilno predpono pri vsej izhodni e-pošti.';
$string['configenableactivitychooser'] = 'Izbirnik dejavnosti je pogovorno okno, ki vključuje kratek opis posamezne dejavnosti ali vira. Če je onemogočen, ga nadomestita ločena spustna menija z dejavnostmi in viri.';
$string['configenableanalytics'] = 'Analitični modeli, na primer ‚Udeleženci, ki bi utegnili pasti‘ ali ‚Prihajajoče aktivnosti‘, lahko ustvarijo napovedi, pošiljajo obvestila o razumevanju in ponujajo nadaljne ukaze, kot je pošiljanje sporočil uporabnikom.';
$string['configenableblogs'] = 'To stikalo omogoča, da ima vsak uporabnik svoj blog.';
$string['configenablecalendarexport'] = 'Omogoči izvoz ali naročanje na koledarje.';
$string['configenablecomments'] = 'Omogoči komentarje';
$string['configenablecourserequests'] = 'Če je omogočeno, bodo imeli uporabniki, ki lahko zahtevajo nove predmete (moodle/course:request), možnost, da zahtevajo nov predmet. Ta možnost ni dostopna privzetim vlogam. Zahteva je na voljo v sistemu ali kontekstu kategorije.';
$string['configenabledevicedetection'] = 'Omogoča odkrivanje mobilnikov, pametnih telefonov, tabličnih računalnikov ali privzetih naprav (namizni računalniki, prenosni računalniki, itd.) za uporabo tem in drugih funkcij.';
$string['configenablemobilewebservice'] = 'Omogoči mobilno storitev za uradno Moodle aplikacijo ali druge aplikacije, ki jo zahtevajo. Za več informacij, preberite {$a}';
$string['configenablerssfeeds'] = 'Če je omogočeno, bodo viri RSS za celotno spletno mesto z različnih funkcij, kot so blogi, forumi, dejavnosti podatkovne baze in glosarji. Upoštevajte, da morajo biti viri RSS omogočeni tudi za posamezne module dejavnosti.';
$string['configenablerssfeedsdisabled'] = 'Ni na voljo, ker so viri RSS onemogočeni za celotno spletno mesto. Da bi jih omogočili, pojdite na nastavitve Spremenljivke pod Skrbniško konfiguracijo.';
$string['configenablerssfeedsdisabled2'] = 'Viri RSS so trenutno onemogočeni na ravni spletnega mesta. Omogočite jih lahko v Naprednih funkcijah v Skrbništvu spletnega mesta.';
$string['configenablestats'] = 'Če tu izberete \'da\', bo Moodle cron opravilo obdelalo dnevnike in zbralo nekaj statistike. Trajanje opravila bo odvisno od obsega prometa na spletnem mestu. Ta nastavitev omogoča, da boste lahko videli nekaj zanimivih grafov in statistik za vsak posamezen predmet ali za celotno spletno mesto.';
$string['configenabletrusttext'] = 'Moodle bo privzeto vedno popolnoma počistil uporabniško vnesena besedila in odstranil morebitne nevarne skripte, predstavnostne datoteke itd., ki so izpostavljene varnostnemu tveganju. Sistem zanesljive vsebine je način, ki posameznim uporabnikom omogoča, da v svojo vsebino vključijo napredne funkcije brez posredovanja. Če želite omogočiti sistem, morate najprej omogočiti to nastavitev, nato pa določiti dovoljenje Zanesljive vsebine za določeno vlogo Moodla. Besedila, ki jih bodo tovrstni uporabniki naložili ali ustvarili, bodo označena kot vredna zaupanja in ne bodo prečiščena pred objavo.';
$string['configenablewebservices'] = 'Spletne storitve omogočajo drugim sistemom prijavo v ta Moodle in opravljanje dejanj. Za večjo varnost mora biti ta nastavitev onemogočena, razen v primeru, če jo zares potrebujete.';
$string['configenablewsdocumentation'] = 'Omogoči samodejno generacijo dokumentacije spletnih storitev. Uporabnik lahko dostopa do svoje dokumentacije na svoji strani z varnostnimi ključi {$a}. Na njej je prikazana dokumentacija samo za omogočene protokole.';
$string['configerrorlevel'] = 'Izberite število opozoril PHP, ki želite, da se prikazujejo. Navadno je \'običajno\' najboljša izbira.';
$string['configexportlookahead'] = 'Prihodnji dnevi, ki naj se upoštevajo pri izvozu';
$string['configexportlookback'] = 'Pretekli dnevi, ki naj se upoštevajo pri izvozu';
$string['configextendedusernamechars'] = 'Omogočite to nastavitev, če želite uporabnikom omogočiti uporabo poljubnih znakov v njihovih uporabniških imenih (to ne vpliva na vnos dejanskih imen), razen velikih začetnic. Privzeto je "ne" kar omejuje uporabniška imena samo na male črke, številke, podčrtaje (_) vezaje (-), pike (.) ali simbol afna (@).';
$string['configextramemorylimit'] = 'Nekateri skripti, npr. iskanje, varnostna kopija/obnavljanje ali cron zahtevajo več spomina. Nastavite večje vrednosti za večja spletna mesta.';
$string['configfilterall'] = 'Filtriraj vse nize vključno z glavami, naslovi, navigacijsko vrstico in tako naprej. To je koristno predvsem, če uporabljate večjezični filter, sicer bo to povzročalo dodatno obremenitev vaše spletne strani z majhnim učinkom.';
$string['configfiltermatchoneperpage'] = 'Samodejno povezovalni filtri bodo generirali eno samo povezavo za prvi najden ujemajoči besedilni element na celotni strani. Vse ostale bodo prezrte.';
$string['configfiltermatchonepertext'] = 'Samodejno povezovalni filtri bodo ustvarili eno samo povezavo za prvi najden ujemajoči besedilni element v vsakem elementu besedila (npr. vir ali blok) na strani. Vse ostale bodo prezrte. Ta nastavitev je prezrta, če je nastavitev "ena na stran" nastavljena na <i>da</i>.';
$string['configfilteruploadedfiles'] = 'Obdela vse naložene kode HTML in besedilne datoteke s filtri pred prikazovanjem, samo naložene datoteke HTML ali nobene.';
$string['configforcelogin'] = 'Običajno lahko naslovno stran spletnega mesta in seznam predmetov (a ne samih predmetov) obiskovalci berejo, ne da bi se prijavili v spletno mesto. Če želite vsiliti prijavo obiskovalcev preden storijo KARKOLI na strani, potem omogočite to nastavitev.';
$string['configforceloginforprofiles'] = 'Ta nastavitev prisilili osebe, da se prijavijo z lastnimi računi (ne kot gosti), preden bodo pregledovali profile uporabnikov. Če to nastavitev onemogočite, bodo lahko nekateri uporabniki objavljali oglase (neželena vsebina) ali druge neprimerne vsebine na svojih proflih, kar bo vidno vsem.';
$string['configfrontpage'] = 'Zgoraj izbrani elementi bodo prikazani na naslovni strani spletnega mesta.';
$string['configfrontpagecourselimit'] = 'Največje število predmetov';
$string['configfrontpagecourselimithelp'] = 'Največje število prikazanih predmetov v seznamu predmetov na naslovni strani spletnega mesta.';
$string['configfrontpageloggedin'] = 'Zgoraj izbrani elementi bodo prikazani prijavljenih uporabnikom na naslovni strani spletnega mesta.';
$string['configfullnamedisplay'] = 'To opredeli, kako naj se prikazujejo celotna imena. Za večino enojezičnih strani je najučinkovitejša privzeta nastavitev "Ime + Priimek", vendar se lahko odločite in skrijete priimke oziroma prepustite odločitev trenutnemu jezikovnemu paketu (nekateri jeziki imajo različna pravila).';
$string['configgeoipfile'] = 'Lokacija binarne podatkovne datoteke GeoLite2 City. Ta datoteka ni del porazdelitve Moodla – prenesti jo morate sami z naslova <a href="http://www.maxmind.com/">MaxMind</a>. Lahko se odločite za nakup komercialne različice ali pa uporabite brezplačno.<br /Registritajte se in prenesite <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. in ga razširite v imenik "{$a}" svojega strežnika.';
$string['configgetremoteaddrconf'] = 'Če je vaš strežnik za obratnim posredniškim strežnikom, lahko s to nastavitvijo določite, katera polja iz glave HTTP smejo vsebovati oddaljeni naslov IP. Glave so brane po vrsti, pri tem se uporabi prva, ki je na voljo.';
$string['configgradebookroles'] = 'Ta nastavitev vam omogoča nadzor nad tem, kdo se pojavlja v redovalnici. Uporabniki morajo imeti vsaj eno izmed teh vlog v predmetu, da se lahko pojavijo v redovalnici predmeta.';
$string['configgradeexport'] = 'Izberite, katere izvozne oblike redovalnice predstavljajo vaše primarne metode za izvažanje ocen. Izbrani vtičniki bodo nato za vsako oceno nastavili in uporabili polje "nazadnje izvoženo". To lahko povzroči, da so izvoženi zapisi identificirani kot "novi" ali "posodobljeni". Če o tem niste prepričani, pustite vse odkljukano.';
$string['confighiddenuserfields'] = 'Izberite katera polja informacij o uporabnikih želite skriti pred drugimi uporabniki, ki niso učitelji ali skrbniki predmeta. To bo povečalo zasebnost udeležencev. Držite tipko CTRL za izbor več polj.';
$string['configidnumber'] = 'Ta možnost določa ali (a) Uporabnikov se sploh ne sprašuje po ID številki, (b) Uporabnike se vpraša po identifikacijski številki, a lahko pustijo polje prazno ali (c) Uporabnike se vpraša po identifikacijski številki, ki jo morajo vnesti. Če je podana, se uporabnikova identifikacijska številka prikaže v njihovem profilu.';
$string['configintro'] = 'Na tej strani lahko določite vrsto konfiguracijskih spremenljivk, ki pripomorejo k pravilnem delovanju Moodle na vašem strežniku. Ne skrbite preveč glede tega - privzete vrednosti bodo običajno delovale v redu in vedno se lahko vrnete nazaj na to stran in te nastavitve spremenite.';
$string['configintroadmin'] = 'Na tej strani morate konfigurirati vaš glavni skrbniški račun, ki bo imel popoln nadzor nad tem spletnim mestom. Zagotovite varno uporabniško ime in geslo ter veljaven naslov e-pošte. Pozneje lahko ustvarite več skrbniških računov.';
$string['configintrosite'] = 'Ta stran vam omogoča konfiguracijo naslovne strani in imena tega novega spletnega mesta. Pozneje se lahko vrnete sem in spremenite te nastavitve s povezavo \'Skrbniški meniji\' na domači strani.';
$string['configiplookup'] = 'Ko kliknete na IP naslov (kot npr. 34.12.222.93) npr. v dnevnikih, se vam prikaže mapa z najboljšo domnevo o lokaciji IP-ja. Pri tem lahko izbirate med različnimi vtičniki; vsak imajo svoje prednosti in slabosti.';
$string['configkeeptagnamecase'] = 'Odkljukajte, če želite ohraniti začetnice imena oznak, kot so jih vnesli uporabniki, ki so jih ustvarili';
$string['configlang'] = 'Izberite privzet jezik za celotno spletno mesto. Uporabniki lahko to nastavitev preglasijo z uporabo jezikovnega menija ali nastavitvijo v svojem osebnem profilu.';
$string['configlanglist'] = 'Pustite to prazno, da bi uporabnikom omogočite izbor poljubnega nameščenega jezika. Če želite skrajšati meni jezikov, lahko vnesete z vejicami ločen seznam jezikovnih kod, ki jih želite. Na primer: sl, en, es_es, fr, it';
$string['configlangmenu'] = 'Izberite, ali želite prikazovati splošen jezikovni meni na domači strani, prijavne strani itd. To ne vpliva na možnost uporabnika, da si nastavi zaželen jezik v svojem profilu.';
$string['configlangstringcache'] = 'Predpomni vse jezikovne nize v pripravljeno datoteko v podatkovnem imeniku. Če prevajate Moodle ali spreminjate nize v izvorni kodi Moodla, potem boste morda želeli to izklopiti. Sicer pustite vklopljeno, če želite videti koristi v zmogljivosti.';
$string['configlatinexcelexport'] = 'Izberite kodniranje za izvoze v Excel.';
$string['configlocale'] = 'Nastavite območne nastavitve za celotno spletno mesto – to bo preglasilo format in jezik datumov za vse jezikovne pakete (vendar bodo imena dni in koledar nespremenjeni). Podatke za to namestitev morate imeti nameščene v svojem operacijskem sistemu (npr. sl_SI ali en_US). Če ne veste, kaj izbrati, pustite polje prazno.';
$string['configlockrequestcategory'] = 'Če je omogočeno, uporabniki, ki lahko zahtevajo nove predmete v sistemskem kontekstu, pri zahtevi novega predmeta ne bodo mogli izbrati kategorije. Nadomestni način omejitve uporabnikov pri zahtevanju novega predmeta v samo eni kategoriji je uporaba možnosti zahteve novih predmetov v kategorijskem kontekstu.';
$string['configloglifetime'] = 'To določa časovno obdobje, za katero želite hraniti dnevnike o dejavnosti uporabnikov. Starejši dnevniki od te starosti bodo samodejno izbrisani. Najbolje je hraniti dnevnike čim dlje, če jih potrebujete. Če imate zelo obremenjen strežnik in se soočate z zmogljivostnimi težavami, boste morda želeli skrajšati življenjsko dobo dnevnikov. Vrednosti, nižje od 30, niso priporočljive, ker statistika morda ne bo delovala pravilno.';
$string['configlookahead'] = 'Dnevi za pogled v naprej';
$string['configmailnewline'] = 'Znaki za novo vrstico, ki bo uporabljeni v e-poštnih sporočilih. CRLF je zahtevan po standardu RFC 822bis, vendar nekateri e-poštni strežniki samodejno pretvarjajo LF v CRLF, drugi napačno popravljajo CRLF v CRCRLF, tretji pa zavračajo e-pošto, ki uporablja samo LF. Če imate težave z dostavljanjem e-pošte ali dvojnimi razmaki med vrsticami, poskusite spremeniti to nastavitev.';
$string['configmaxbytes'] = 'To določa največjo velikost naloženih datotek za celotno spletno mesto. To nastavitev omejujejo nastavitve PHP post_max_size in upload_max_filesize, kot tudi nastavitev Apache LimitRequestBody. Posledično maxbytes omejuje obseg velikosti, ki ga lahko izbirate na ravni predmeta ali dejavnosti. Če izberete Omejitev strežnika, bo uporabljen največji dovoljeni server.';
$string['configmaxconsecutiveidentchars'] = 'Gesla ne smejo imeti več kot to število zaporednih enakih znakov. Uporabite 0 za onemogočenje tega preverjanja.';
$string['configmaxeditingtime'] = 'To določa časovni okvir v katerem lahko osebe ponovno uredijo objave v forumu, komentarji pojmovnika ipd. Običajno je dobra vrednost 30 minut.';
$string['configmaxevents'] = 'Dogodki za pogled v naprej';
$string['configmaxusersperpage'] = 'Največje število prikazanih uporabnikov v uporabniškem izbirniku znotraj predmeta, skupine, kohorte, spletne storitve, itd.';
$string['configmessaging'] = 'Če je omogočeno, lahko uporabniki na spletnem mestu drugim uporabnikom pošiljajo sporočila.';
$string['configmessagingallowemailoverride'] = 'Omogočite, da uporabnik lahko prejme e-poštno obvestilo tudi na drug e-poštni naslov, ne le na naslov v svojem profilu';
$string['configmessagingallusers'] = 'Ob omogočeni funkciji si lahko uporabniki ogledajo seznam vseh uporabnikov spletnega mesta, ko si izberejo nekoga za pošiljanje sporočila, nastavitve sporočil ciljnega uporabnika pa omogočajo sprejem sporočil vseh na seznamu. Ob onemogočeni funkciji lahko uporabniki vidijo seznam uporabnikov na svojih predmetih, med nastavitvami sporočil pa imajo le dve možnosti: sprejem sporočil samo od njihovih kontaktov ali njihovih kontaktov ter sodelujočih na njihovih predmetih.';
$string['configmessagingdefaultpressenter'] = 'Če je v uporabnikovih nastavitvah sporočanja funkcija »Za pošiljanje pritisnite Enter«  privzeto omogočena.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Videna in nevidena obvestila lahko zbrišete za pridobitev prostora. Kdaj po nastanku lahko izbrišete obvestilo?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Prebrana obvestila lahko izbrišete in tako prihranite prostor. Koliko časa po tem, ko je obvestilo prebrano, naj se izbriše?';
$string['configminpassworddigits'] = 'Geslo mora imeti najmanj toliko številk.';
$string['configminpasswordlength'] = 'Geslo mora biti dolgo vsaj toliko znakov.';
$string['configminpasswordlower'] = 'Geslo mora imeti najmanj toliko malih črk.';
$string['configminpasswordnonalphanum'] = 'Geslo mora imeti vsaj toliko znakov, ki niso črke ali številke.';
$string['configminpasswordupper'] = 'Geslo mora imeti vsaj toliko velikih črk.';
$string['configmodchooserdefault'] = 'Ali naj bo izbirnik dejavnosti privzeto viden uporabnikom?';
$string['configmycoursesperpage'] = 'Maksimalno število predmetov za prikaz v kateremkoli seznamu uporabnikovih lastnih predmetov';
$string['configmymoodleredirect'] = 'Ta nastavitev vsili preusmeritev na /my ob prijavi za uporabnike, ki niso skrbniki, in zamenja zgornjo raven navigacije spletnega mesta z /my';
$string['configmypagelocked'] = 'Ta nastavitev preprečuje urejanje privzete strani vsem ne-skrbnikom';
$string['confignavcourselimit'] = 'Omeji število predmetov, ki so prikazani uporabniku, ko ni prijavljen ali ni vpisan v noben predmet.';
$string['confignavshowallcourses'] = 'Ta nastavitev določa, ali lahko uporabniki, ki so vpisani v predmete, v navigaciji, poleg Moji predmeti (seznam predmetov, v katere so vpisani), vidijo Predmeti (seznam vseh predmetov).';
$string['confignavshowcategories'] = 'Prikaže kategorije predmeta v navigacijski vrstici in v navigacijskih blokih. To se ne zgodi pri predmetih, v katere je uporabnik trenutno vpisan. Ti bodo še vedno navedeni v seznamu "Moji predmeti" brez prikaza kategorij.';
$string['confignoreplyaddress'] = 'Včasih so odposlana e-poštna sporočila v imenu uporabnika (npr. prispevki forumov). E-poštni naslov, ki ga določite tu, bo uporabljen kot naslov "Od" v primerih, ko prejemniki ne smejo imeti možnosti neposrednega odgovora uporabniku (npr. če se uporabnik odloči ohraniti svoj naslov zaseben). Ta nastavitev bo uporabljena tudi kot pošiljatelj ovojnice pri pošiljanju e-pošte.';
$string['confignotifyloginfailures'] = 'Pošiljaj obvestila o spodletelih prijavah izbranim uporabnikom. To zahteva, da je omogočeno notranje hranjenje dnevnikov.';
$string['confignotifyloginthreshold'] = 'Če so vključena obvestila o spodletelih prijavah, koliko spodletelih poskusov prijav posameznega uporabnika ali naslova IP zadošča za obveščanje?';
$string['confignotloggedinroleid'] = 'Uporabniki, ki niso prijavljeni na spletnem mestu, bodo obravnavani kot da imajo v kontekstu strani dodeljeno to vlogo. Tu si ponavadi želite imeti vlogo Gosta, vendar lahko ustvarite tudi vloge, ki so bolj ali manj omejujoče. Zmožnosti, kot je ustvarjanje prispevkov, pa še vedno zahtevajo prijavo od uporabnikov.';
$string['configopentowebcrawlers'] = 'Ta nastavitev omogoča, da bo lahko Google vstopal v spletno mesto kot gost. Dodatno bodo osebe, ki bodo na vašo stran prišle prek iskanja na iskalniku Google samodejno prijavljene kot gost. Upoštevajte, da to omogoča le dostop do predmetov, ki že dovoljujejo gostujoči dostop.';
$string['configoverride'] = 'Opredeleno v config.php';
$string['configpasswordpolicy'] = 'Če to omogočite, bo Moodle preveril, če uporabniška gesla ustrezajo pravilniku za gesla. Uporabite spodnje nastavitve, da ga določite (gesla bodo prezrta, če označite Ne).';
$string['configpasswordpolicycheckonlogin'] = 'Če je omogočeno, bo izvedeno preverjanje skladnosti uporabniškega gesla s pravilnikom za gesla ob vsaki prijavi uporabnika. Če preverjanje ne uspe, bo moral uporabnik geslo spremeniti, preden nadaljuje.
It je uporaben, da se omogoči to nastavitev po posodobitvi pravilnika za gesla.';
$string['configpasswordresettime'] = 'To določa časovni okvir, v katerem lahko osebe potrdijo zahtevo za ponastavitev gesla, preden poteče. Običajno je dobra vrednost 30 minut.';
$string['configpathtodu'] = 'Pot do du. Verjetno nekaj podobnega kot /usr/bin/du. Če to vnesete, bodo strani, ki prikazujejo vsebino imenika, delovale veliko hitreje pri imenikih z veliko datotekami.';
$string['configpathtophp'] = 'Pot do PHP CLI. Verjetno nekaj kot /usr/bin/php. Če to vnesete, lahko zaženete skripte cron s skrbnikovega spletnega vmesnika.';
$string['configperfdebug'] = 'Če to vključite, bo v nogi standardne teme prikazana informacija o zmogljivosti delovanja';
$string['configprofileroles'] = 'Seznam vlog, ki so vidne na profilih uporabnikov in na sodelovalnih straneh.';
$string['configprofilesforenrolledusersonly'] = 'Da bi preprečili zlorabe, so opisi profilov uporabnikov, ki še niso vpisani v noben predmet, skriti. Novi uporabniki morajo biti vpisati v vsaj en predmet, preden lahko dodajo v svoj profil opis.';
$string['configprotectusernames'] = 'Privzeto forget_password.php ne prikazuje namigov, ki bi omogočali ugibanje uporabniških imen ali e-poštnih naslovov.';
$string['configproxybypass'] = 'Z vejicami ločen seznam (delnih) naslovov gostiteljev ali naslovov IP, ki naj zaobidejo posredniški strežnik (npr. 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Če ta <b>strežnik</b> za dostop do interneta zahteva uporabo posredovalnega strežnika (npr. požarni zid), potem tu vpišite naslov gostitelja posredovalenga strežnika. Sicer pustite prazno.';
$string['configproxypassword'] = 'Če je zahtevano, potrebujete geslo za dostop do interneta prek posredovalnega strežnika. V nasprotnem primeru pustite prazno (zahtevana razširitev PHP cURL).';
$string['configproxyport'] = 'Če ta strežnik potrebuje posredovalni računalniki, vpišite tu vrata posredovalnega strežnika.';
$string['configproxytype'] = 'Tip posredovalnega strežnika (zahtevani razširitvi PHP5 in cURL za podporo SOCKS5).';
$string['configproxyuser'] = 'Če je zahtevano, potrebujete uporabniško ime za dostop do interneta prek posredovalnega strežnika. V nasprotnem primeru pustite prazno (zahtevana PHP cURL razširitev).';
$string['configrecaptchaprivatekey'] = 'Niz znakov (skrivni ključ) za komunikacijo med strežnikoma Moodle in strežnikom recaptcha. Svoj ključ za to spletno mesto lahko dobite, če obiščete <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Niz znakov (spletni znak), ki prikaže element reCAPTCHA v vpisnem obrazcu. Ključ za to spletno mesto lahko dobite, če obiščete <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Beseda za udeleženca, ki se uporablja v zahtevanih predmetih';
$string['configrequestedstudentsname'] = 'Beseda za udeležence, ki se uporablja v zahtevanih predmetih';
$string['configrequestedteachername'] = 'Beseda za učitelja, ki se uporablja v zahtevanih predmetih';
$string['configrequestedteachersname'] = 'Beseda za učitelje, ki se uporablja v zahtevanih predmetih';
$string['configreverseproxyignore'] = 'Če je vaš strežnik za več posredniškimi strežniki, ki dopolnjujejo glavi X-Forwarded-For, potem določite z vejicami ločen seznam naslovov IP ali podomrežij posredniških strežnikov, ki naj bodo prezrti, da bo najden uporabnikov pravi naslov IP.';
$string['configsectioninterface'] = 'Vmesnik';
$string['configsectionmail'] = 'E-pošta';
$string['configsectionmaintenance'] = 'Vzdrževanje';
$string['configsectionmisc'] = 'Razno';
$string['configsectionoperatingsystem'] = 'Operacijski sistem';
$string['configsectionpermissions'] = 'Dovoljenja';
$string['configsectionrequestedcourse'] = 'Zahteve za predmet';
$string['configsectionsecurity'] = 'Varnost';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Uporabnik';
$string['configsecureforms'] = 'Moodle lahko uporablja dodatno raven varnosti ob sprejemanju podatkov prek spletnih obrazcev. Če je to omogočeno je spremenljivka brskalnika HTTP_REFERER primerjana s trenutnim naslovom obrazca. V nekaterih redkih primerih to lahko povzroči težave, če uporabnik uporablja požarni zid (npr. Zonealarm) konfiguriran tako, da odreže HTTP_REFERER iz spletnega prometa. Simptomi so, da \'obtičite\' na obrazcu. Če imajo uporabniki težave (na primer) na prijavni strani lahko onemogočite to nastavitev, čeprav s tem pustite spletno mesto bolj odprto napadom ugibanja gesla s programskim ugibanjem. Če ste v dvomih, pustite to nastavljeno na \'Da\'.';
$string['configsessioncookie'] = 'Ta nastavitev prilagodi ime piškotka, ki ga uporabljajo seje Moodla. To je dodatna možnost in je uporabna v izogib zamenjavi piškotkov, kjer teče več kot ena kopija Moodla na istem spletišču.';
$string['configsessioncookiedomain'] = 'Ta nastavitev omogoča, da spremenite domeno Moodle piškotkov. To je uporabno za prilagoditve Moodla (denimo uporaba vtičnikov za preverjanje pristnosti ali vpisnih vtičnikov), ki si morajo informacije o seji Moodla deliti s spletnimi aplikacijami na drugi poddomeni.<strong>OPOZORILO: priporočamo, da to nastavitev pustite na privzeti vrednosti (prazno) - napačna nastavitev bo onemogočila vse prijave v Moodle.</strong>';
$string['configsessioncookiepath'] = 'Če morate spremeniti, kam brskalnik pošilja piškotke Moodla, lahko spremenite to nastavitev in navedete podimenik vašega spletišča. Sicer pa bi morala biti v redu privzeta vrednost \'/\'.';
$string['configsessiontimeout'] = 'Če so osebe prijavljene v to spletno mesto dlje časa nedejavne (ne da bi naložile kakšno stran), potem so samodejno odjavljene (njihova seja se zaključi). Ta spremenljivka določa, kako dolg naj bo ta čas.';
$string['configshowcommentscount'] = 'Pokaži število komentarjev. To bo, ob prikazu povezave na komentarje, povzročilo še eno dodatno poizvedbo';
$string['configshowicalsource'] = 'Prikaži vir informacije za iCal dogodke';
$string['configshowsiteparticipantslist'] = 'Vsi učitelji in udeleženci tega spletnega mesta bodo navedeni v seznamu sodelujočih na spletnem mestu. Kdo lahko vidi ta seznam sodelujočih na spletnem mestu?';
$string['configsitedefaultlicense'] = 'Privzeta licenca spletnega mesta';
$string['configsitedefaultlicensehelp'] = 'Privzeta licenca za objavljanje vsebin na tem spletnem mestu';
$string['configsitemailcharset'] = 'Vsa elektronska sporočila, ki jih generira vaša stran, bodo poslana v privzetem naboru znakov, ki je določen tu. Kljub temu bo lahko posamezen uporabnik prilagodil to nastavitev, če bo naslednja možnost omogočena.';
$string['configsitemaxcategorydepth'] = 'Največja globina kategorije';
$string['configsitemaxcategorydepthhelp'] = 'Določi največjo prikazano globino podrejenih kategorij.';
$string['configslasharguments'] = 'Datoteke (slike, naložene datoteke ipd.) so na voljo prek skripte z uporabo parametrov s poševnico (tu druga možnost). Ta način omogoča lažje predpomnenje datotek v spletnih brskalnikih, proxy strežnikih ipd. Žal nekateri spletni strežniki PHP ne podpirajo tega načina, zato nastavite to spremenljivko na prvo možnost, če imate težave z ogledom naloženih datotek ali slik (npr. slik uporabnikov).';
$string['configsmartpix'] = 'Če je ta možnost vključena, se ikone pridobivajo preko PHP skripta, ki najprej preišče trenutno temo, nato vse nadrejene teme, za tem pa še Moodle /pix mapo. To zmanjša potrebo po podvojenih slikovnih datotekah, vendar lahko v manjši meri vpliva na delovanje strežnika.';
$string['configsmtpauthtype'] = 'To določi tip preverjanja pristnosti, ki se uporabi na smtp strežniku.';
$string['configsmtphosts'] = 'Podajte polno ime enega ali več lokalnih SMTP strežnikov, ki naj jih Moodle uporablja za pošiljanje elektronske pošte (npr. \'mail.a.com\' ali \'mail.a.com;mail.b.com\'). Če polje pustite prazno, bo Moodle uporabljal PHP-jev privzet način pošiljanja elektronskih sporočil.';
$string['configsmtpmaxbulk'] = 'Največje število sporočil, poslanih med eno sejo SMTP. Skupek e-poštnih sporočil lahko pospeši njihovo pošiljanje. Vrednosti, nižje od 2, povzročijo odpiranje nove SMTP seje za vsako sporočilo.';
$string['configsmtpsecure'] = 'Če strežnik SMTP zahteva varno povezavo, določite pravilen tip protokola.';
$string['configsmtpuser'] = 'Če ste zgoraj navedli strežnik SMTP in strežnik zahteva preverjanje pristnosti, tu vnesite uporabniško ime in geslo.';
$string['configstartwday'] = 'Začetek tedna';
$string['configstatsfirstrun'] = 'To določa, koliko stari dnevniki naj se obdelajo <b>prvič</b>, ko bo cronjob obdeloval statistiko. Če imate precej prometa in uporabljate skupno gostovanje, verjetno ni dobro iti predaleč nazaj, saj lahko izvajanje traja precej časa in zahteva precej sistemskih virov. (Opomba za to nastavitev, 1 mesec = 28 dni. V grafih in generiranih poročilih, 1 mesec = 1 koledarski mesec.)';
$string['configstatsmaxruntime'] = 'Obdelava statistike je lahko precej intenzivna, zato uporabite kombinacijo tega in naslednjega polja za določitev, kdaj naj se izvaja in kako dolgo.';
$string['configstatsmaxruntime2'] = 'Obdelava statistike je lahko precej intenzivna, zato določite najdaljši čas, ki je dovoljen za zbiranje statistik enega dne. Največje število dni, obdelanih v okviru ene izvedbe cron, je 31.';
$string['configstatsmaxruntime3'] = 'To določa najdaljši čas, dovoljen za izračun statistik enega dneva. Pri tem imejte v mislih, da obdelava statistike lahko zelo obremeni strežnik. Največje število dni, ki bodo obdelani v okviru enega izvajanja cron, lahko določite spodaj.';
$string['configstatsruntimedays'] = 'To določa največje število dni, obdelanih med vsakim izvajanjem statistike. Če se statistika izvaja redno, bo obdelan samo en dan. Prilagodite to vrednost obremenitvi vašega strežnika ter zmanjšajte vrednost, če so potrebne izvedbe cron.';
$string['configstatsruntimestart'] = 'Kdaj naj se opravilo cronjob, ki obdeluje statistiko, zažene? Če je na enem strežniku več Moodlovih spletnih mest, potem je določanje različnih časovnih okvirov priporočljivo.';
$string['configstatsuserthreshold'] = 'Ta nastavitev določa najmanjše število vpisanih uporabnikov, da se predmet vključi v statistične izračune.';
$string['configstrictformsrequired'] = 'Če je omogočeno, uporabnik v zahtevana polja obrazcev ne more vnesti presledka ali skočiti v novo vrstico.';
$string['configstripalltitletags'] = 'Odznačite to nastavitev za omogočanje oznak HTML v dejavnostih in virih.';
$string['configsupportemail'] = 'Ta e-poštni naslov bo objavljen za uporabnike tega spletnega mesta v primeru, ko potrebujejo splošno pomoč (denimo, ko si novi uporabniki ustvarijo svoje uporabniške račune). Če pustite to polje prazno, uporabnikom ne bo javljen e-poštni naslov za pomoč.';
$string['configsupportname'] = 'Ime osebe ali drugega osebka, zadolženega za splošno pomoč prek podpornega e-poštnega naslova ali spletnega naslova.';
$string['configsupportpage'] = 'Ta spletni naslov bo objavljen za uporabnike tega spletnega mesta, na katere se lahko obrnejo v primeru, da potrebujejo splošno pomoč (denimo, ko si novi uporabniki ustvarijo svoje uporabniške račune). Če pustite to polje prazno, uporabnikom povezava za pomoč ne bo prikazana.';
$string['configtempdatafoldercleanup'] = 'Odstranite začasne podatkovne datoteke iz mape podatkov, ki so starejše od izbranega časa.';
$string['configthemedesignermode'] = 'Običajno se vse slike in slogovne datoteke tem, zaradi hitrejšega izvajanja, zelo dolgo predpomnijo v brskalnikih in na strežniku. Če oblikujete teme ali razvijate kodo, potem boste verjetno želeli ta način vklopiti, da vam ne bodo posredovane predpomnjene različice. Opozorilo: To bo upočasnilo vaše spletno mesto za vse uporabnike! Predpomnjeno temo lahko na strani za izbiro teme ponastavite tudi ročno.';
$string['configthemelist'] = 'Pustite to prazno, če želite dovoliti uporabo vseh veljavnih tem. Če želite skrajšati meni tem, lahko tu določite z vejicami ločen seznam imen (Ne uporabljajte presledkov!).
Na primer: standard, orangewhite.';
$string['configtimezone'] = 'Tu lahko nastavite privzet časovni pas. To je zgolj PRIVZET časovni pas za prikaz datumov – vsak uporabnik lahko to nastavitev preglasi z nastavitvijo v svojem profilu. Če nastavite "Čas strežnika«, bo Moodle prevzel nastavitve operacijskega sistema strežnika, "Čas strežnika" v uporabniškem profilu pa bo za uporabnika prevzel to nastavitev. Naloge cron, katerih izvajanje je odvisno od časa v dnevu, bodo uporabljale ta časovni pas.';
$string['configuseblogassociations'] = 'Ali lahko uporabniki oragnizirajo svoj blog s povezovanjem vnosov predmetov in modulov predmeta?';
$string['configuseexternalyui'] = 'Namesto krajevnih datotek uporabite spletne datoteke, ki so na voljo na Yahoojevih strežnikih. OPOZORILO: To zahteva internetno povezavo, saj v nasprotnem primeru noben AJAX ne bo deloval na vašem spletnem mestu. Ta nastavitev ni združljiva s spletnimi mesti, ki uporabljajo https.';
$string['configusesitenameforsitepages'] = 'Če je omogočeno, bo v bloku Navigacija uporabljeno kratko ime spletne strani, namesto niza \'Strani spletnega mesta\'';
$string['configusetags'] = 'Naj bodo oznake omogočene na celotnem spletnem mestu?';
$string['configvariables'] = 'Spremenljivke';
$string['configverifychangedemail'] = 'Omogoči preverjanje spremenjenih e-poštnih naslovov z uporabo dovoljenih in zavrnjenih e-poštnih domen. Če je ta nastavitev onemogočena, se domene vsilijo samo pri ustvarjanju novih uporabnikov.';
$string['configvisiblecourses'] = 'Navadno prikazuj predmete v skritih kategorijah';
$string['configwarning'] = 'Bodite previdni pri spreminjanju teh nastavitev. Nenavadne vrednosti lahko povzročijo težave.';
$string['configyuicomboloading'] = 'Ta možnost omogoča kombinirano optimizacijo nalaganja datotek za knjižnice YUI. Ta nastavitev naj bo na prednostnih spletiščih omogočena zaradi zmogljivostnih razlogov.';
$string['confirmation'] = 'Potrditev';
$string['confirmcontextlock'] = '{$a->contextname} je trenutno odklenjen. Zaklenitev ga bo spremenila v bralni način, kar bo uporabnikom preprečilo spreminjanje. Ste prepričani, da želite nadaljevati?';
$string['confirmcontextunlock'] = '{$a->contextname} je trenutno zaklenjen. Po odklenitvi ga bodo uporabniki lahko spreminjali. Ste prepričani, da želite nadaljevati?';
$string['confirmdeletecomments'] = 'Izbrisali boste komentarje. Ste prepričani?';
$string['confirmed'] = 'Potrjeno';
$string['contenttypeuninstalling'] = 'Vsebine {$a->count} podpira {$a->type}. Izbrisane bodo. Ste prepričani, da želite nadaljevati?';
$string['contextlockappliestoadmin'] = 'Zaklepanje konteksta uveljavljajo skrbniki';
$string['contextlockappliestoadmin_desc'] = 'Če je onemogočen, skrbnikom ostane pisni dostop do zaklenjenih kontekstov.';
$string['contextlocking'] = 'Zaklepanje konteksta';
$string['contextlocking_desc'] = 'Ta nastavitev omogoča dostop samo za branje, ki se ga lahko določi za izbrane kategorije, predmete, dejavnosti in bloke.';
$string['cookiehttponly'] = 'Samo piškotki http';
$string['cookiesecure'] = 'Samo varni piškotki';
$string['country'] = 'Privzeta država';
$string['course_customfield'] = 'Polja po meri za predmet';
$string['coursecolor'] = 'Barva {$a}';
$string['coursecolorheading_desc'] = 'Predmeti, ki v nastavitvah predmeta nimajo nastavljene slike premeta, so na Nadzorni plošči prikazani z vzorčastim ozadjem. Barve vzorca lahko določite spodaj.';
$string['coursecolorsettings'] = 'Barve ozadja predmeta';
$string['coursecontact'] = 'Kontakti predmeta';
$string['coursecontact_desc'] = 'Ta nastavitev omogoča nadzor nad osebami, ki se izpišejo pri opisu predmeta. Za izpis pri opisu predmeta morajo imeti uporabniki pri predmetu vsaj eno izmed navedenih vlog.';
$string['coursecontactduplicates'] = 'Prikaži vse kontaktne vloge predmeta';
$string['coursecontactduplicates_desc'] = 'Če je funkcija omogočena, bodo uporabniki z več kot eno izbrano kontaktno vlogo predmeta prikazani v opisu predmeta z vsako njihovo vlogo. Drugače bodo prikazani samo z eno vlogo (tisto, ki je najvišje na seznamu »Opredeli vloge« na Skrbništvu spletnega mesta).';
$string['coursegraceperiodafter'] = 'Moratorij za pretekle predmete';
$string['coursegraceperiodbefore'] = 'Dovoljeno obdobje za vse prihodnje predmete';
$string['courselistshortnames'] = 'Prikaži razširjena imena predmetov';
$string['courselistshortnames_desc'] = 'Če je omogočeno, bodo na seznamu predmetov prikazana kratka in dolga imena predmetov. Če je zahtevano, se lahko razširjena imena predmetov prilagodi z urejanjem jezikovnega niza \'courseextendednamedisplay\' preko funkcije za prilagoditev jezika.';
$string['coursemgmt'] = 'Upravljaj predmete in kategorije';
$string['courseoverview'] = 'Pregled predmeta';
$string['courserequestnotify'] = 'Obvestilo o zahtevi po predmetu';
$string['courserequestnotifyemail'] = 'Uporabnik {$a->user} je zahteval nov predmet na naslovu {$a->link}';
$string['courserequests'] = 'Zahteve za predmet';
$string['courserequestspending'] = 'Zahteve za predmete v čakanju';
$string['courses'] = 'Predmeti';
$string['coursesperpage'] = 'Predmeti na stran';
$string['courseswithsummarieslimit'] = 'Meja za prikaz predmetov s povzetki';
$string['creatornewroleid'] = 'Vloga ustvarjalcev v novih predmetih';
$string['creatornewroleid_help'] = 'Če uporabnik še nima dovoljenja za upravljanje novega predmeta, je uporabnik samodejno vpisan s to vlogo.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Omogoči cron';
$string['cron_enabled_desc'] = 'Pripomoček cron mora biti običajno omogočen, ta nastavitev pa omogoča, da je začasno onemogočen, na primer pred ponovnim zagonom strežnika. Če je onemogočen, sistem ne more začeti novih nalog v ozadju. Upoštevajte, da pripomoček cron ne sme biti onemogočen dalj časa, saj to prepreči pomembne dejavnosti.';
$string['cron_help'] = 'Vzdrževalni skript cron.php pomaga nekaterim modulom Moodla pri opravljanju nalog po načrtovanem časovnem razporedu, kot na primer pošiljanje obvestila po e-pošti o novih prispevkhi na forumu. Potreben je mehanizem za redno izvajanje skripta, najbolje bi bilo, da se izvede vsako minuto.';
$string['cron_link'] = 'skrbnik/cron';
$string['cronclionly'] = 'Izvedba Cron samo prek ukazne vrstice';
$string['cronerrorclionly'] = 'Internetni dostop do te strani je skrbnik žal onemogočil.';
$string['cronerrorpassword'] = 'Žal niste vnesli veljavnega gesla za dostop do te strani';
$string['croninfrequent'] = 'Med zadnjima dvema izvedbama skriptov vzdrževanja crona je bilo {$a->actual}. Izveden mora biti vsakih {$a->expected}. Priporočamo, da ga konfigurirate tako, da se izvede pogosteje.';
$string['cronremotepassword'] = 'Geslo cron za oddaljen dostop';
$string['cronwarning'] = '<a href="{$a->url}">admin/cron.php script</a> ni bil zagnan {$a->actual} ur, moral pa bi delovati vsakih {$a->expected} ur.';
$string['cronwarningcli'] = 'Skript <code>admin/cli/cron.php</code> ni bil zagnan {$a->actual} ur, moral pa bi delovati vsakih {$a->expected} ur.';
$string['cronwarningnever'] = 'Skript <code>skrbnik/cli/cron.php</code> še ni bil nikoli izveden in bi moral biti izveden vsakih {$a->expected}.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">admin/cron.php script</a> še nikoli ni bil zagnan, moral pa bi delovati vsakih {$a->expected} ur.';
$string['ctyperequired'] = 'Moodle zahteva razširitev ctype za PHP, kar bo omogočilo hitrejše delovanje spletnega mesta in ponudilo večjezično združljivost.';
$string['curlcache'] = 'življenjska doba (TTL) predpomnilnika cURL';
$string['curlrequired'] = 'Moodle zahteva razširitev PHP cURL za komunikacijo z Moodlovimi skladišči.';
$string['curlsecurityallowedport'] = 'seznam dovoljenih vrat za cURL';
$string['curlsecurityallowedportsyntax'] = 'Seznam številk vrat, na katere se cURL lahko poveže. Le cela števila so lahko veljavni vnosi. Vsak vnos vnesite v novo vrstico. Če je prazna, so dovoljena vsa vrata. Če so določena, bi morala biti v skoraj vseh primerih 443 in 80 navedena tako, da se cURL lahko poveže s standardnimi vrati HTTPS in HTTPS.';
$string['curlsecurityblockedhosts'] = 'seznam blokiranih gostiteljev za cURL';
$string['curlsecurityblockedhostssyntax'] = 'Vsak vnos vnesite v novo vrsto. Veljavni vnosi so ali celi naslovi Ipv4 ali Ipv6 (kot 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), ki se ujemajo z enim gostiteljem; ali notacijo CIDR (kot 231.54.211.0/20 ali fe80::/64); ali vrsto naslovov IP (kot 231.3.56.10-20 ali fe80::1111-bbbb), kjer se te vrste nanašajo na zadnjo skupino naslovov; ali z imeni domen (kot Localhost ali primer.com); ali domenami nadomestnih znakov (kot *.example.com or *.sub.example.com). Prazne vrste niso dovoljene.';
$string['curlsecurityurlblocked'] = 'URL je blokiran.';
$string['curltimeoutkbitrate'] = 'Bitna hitrost za uporabo pri izračunavanju časovne omejitve cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ta nastavitev se uporablja za izračun ustrezne časovne omejitve med velikimi zahtevki cURL. V okviru tega se ustvari zahteva HTTP HEAD za določitev velikosti vsebine. Nastavitev tega na 0 onemogoči tej zahtevi, da bi se izvršila.';
$string['currenttheme'] = 'Trenutna tema';
$string['customcheck'] = 'Druga preverjanja';
$string['custommenu'] = 'Meni po meri';
$string['custommenuitems'] = 'Elementi menija po meri';
$string['customusermenuitems'] = 'Elementi menija uporabnika';
$string['datarootsecurityerror'] = '<p><strong>VARNOSTNO OPOZORILO!</strong></p><p>Korenski imenik je na napačni lokaciji in je viden na spletu. To pomeni, da so vaše zasebne datoteke vidne vsem na spletu, nekatere od teh pa bi lahko zlonamernim uporabnikom omogočile pridobitev nepooblaščenega skrbiškega dostopa do vaše spletnega mesta!</p>
<p>Vaš korenski imenik ({$a}) <em>morate</em> premakniti na novo lokacijo, ki ni v javnem spletnem imeniku, in nato posodobiti nastavitev <code>$CFG->dataroot</code> v datoteki config.php na novo lokacijo.</p>';
$string['datarootsecuritywarning'] = 'Konfiguracija vašega spletnega mesta morda ni varna. Prepričajte se, da vaš korenski imenik ({$a}) ni neposredno dostopen na spletu.';
$string['dbsessions'] = 'Uporabi podatkovno bazo za podatke o seji';
$string['debug'] = 'Sporočila za iskanje napak';
$string['debugall'] = 'VSA: prikaži vsa upravičena sporočila PHP za odpravljanje napak';
$string['debugdeveloper'] = 'RAZVIJALEC: prikaži dodatna sporočila Moodla za odpravljanje napak, namenjena razvijalcem';
$string['debugdisplay'] = 'Prikaži sporočila za odpravljanje napak';
$string['debugging'] = 'Razhroščevanje';
$string['debugminimal'] = 'MINIMALNA: prikaži samo sporočila o usodnih napakah';
$string['debugnone'] = 'BREZ: ne prikaži nobenih napak ali opozoril';
$string['debugnormal'] = 'OBIČAJNO: Prikaži napake, opozorila in obvestila';
$string['debugpageinfo'] = 'Prikaži informacijo o strani';
$string['debugsqltrace'] = 'Pokaži izvor SQL klicev';
$string['debugsqltrace1'] = 'Pokaži le eno vrstico klica';
$string['debugsqltrace100'] = 'Pokaži vse sledi sklada';
$string['debugsqltrace2'] = 'Pokaži 2 vrstici sledi sklada';
$string['debugsqltrace_desc'] = 'Če je omogočeno, je delna ali popolna sled sklada PHP dodana v SQL kot komentar.';
$string['debugstringids'] = 'Prikaži izvor jezikovnih nizov';
$string['debugstringids_desc'] = 'Ta možnost je v pomoč prevajalcem. Ko je omogočena, se prikaže identifikator jezikovne datoteke in niza ob vsakem izhodnem nizu, če dodate parameter strings=1 zahtevku URL.';
$string['debugvalidators'] = 'Prikaži povezave preverjalnika';
$string['defaultcity'] = 'Privzeto mesto';
$string['defaultcity_help'] = 'Mesto, ki ga tukaj vnesete, bo privzeto mesto, ko boste ustvarjali nove uporabniške račune.';
$string['defaultformatnotset'] = 'Napaka pri določanju privzete oblike predmeta. Preverite nastavitve spletnega mesta.';
$string['defaulthomepage'] = 'Privzeta domača stran za uporabnike';
$string['defaultrequestcategory'] = 'Privzeta kategorija za zahteve predmetov';
$string['defaultsettinginfo'] = 'Privzeto: {$a}';
$string['defaultuserroleid'] = 'Privzeta vloga za vse uporabnike';
$string['deleteincompleteusers'] = 'Izbris nepopolnih uporabniških računov po';
$string['deleteunconfirmed'] = 'Izbriši nepopolno nastavljene uporabnike po';
$string['deleteuser'] = 'Izbriši uporabnika';
$string['density'] = 'Gostota';
$string['denyemailaddresses'] = 'Zavrnjene e-poštne domene';
$string['development'] = 'Razvoj';
$string['devicedetectregex'] = 'Naprava za odkrivanje regularnih izrazov';
$string['devicedetectregex_desc'] = '<p>Privzeto lahko Moodle zazna naprave tipa privzeto (namizni ali prenosni računalnik ...), mobilni (telefoni in dlančniki), tablični (iPadi in Android tablice) in podedovani (uporabniki Internet Explorer 6). Za dodelitev ločenih tem za vse te tipe lahko uporabite izbirnik tem. Ta nastavitev dovoljuje uporabo logičnih izrazov, kar omogoča zaznavanje dodatnih tipov naprav (te imajo prednost pred privzetimi tipi).</p>
<p>Na primer: vnesete lahko logični izraz \'/(MIDP-1.0|Maemo|Windows CE)/\' za zaznavanje nekaterih pogosto uporabljanih pametnih telefonov in dodate povratno vrednost \'pametnitelefon\'. To doda \'pametnitelefon\' v izbirnik tem, kar vam omogoča dodati temo, ki bo uporabljena na teh napravah. Ostali telefoni bodo še naprej uporabljali temo izbrano za tip mobilnih naprav. </p>';
$string['devicedetectregexexpression'] = 'Regularni izraz';
$string['devicedetectregexvalue'] = 'Vrni vrednost';
$string['devicetype'] = 'Tip naprave';
$string['devlibdirpresent'] = 'Mape z razvojnimi knjižnicami, še posebno <em>/vendor</em> in <em>/node_modules</em>, ne smeta biti vidna na javnih spletnih mestih. Glej <a href=«{$a->moreinfourl}«>poročilo pregleda varnosti</a> za več podrobnosti.';
$string['disabled'] = 'Onemogočeno';
$string['disableuserimages'] = 'Onemogoči slike v profilu uporabnika';
$string['displayerrorswarning'] = 'Omogočanje nastavitve PHP <em>display_errors</em> ni priporočena na prednostnih spletiščih, ker lahko določena sporočila o napaki odkrijejo občutljive varnostne informacije o vašem strežniku.';
$string['displayloginfailures'] = 'Prikaži neuspele prijave';
$string['divertallemails'] = 'Preusmeritev e-pošte';
$string['divertallemailsdetail'] = 'Uporabljeno kot varovalo v okoljih razvoja, ko se preizkuša e-pošta, zato se pri izdelavi ne sme uporabljati.';
$string['divertallemailsexcept'] = 'Izjeme preusmeritev e-pošte';
$string['divertallemailsexcept_desc'] = 'Seznam pravil o izjemah pri e-pošti, ki so ločena z vejicami ali novimi vrsticami. Vsako pravilo je razumljeno kot regularni izraz, npr. <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Preusmeri vso e-pošto';
$string['divertallemailsto_desc'] = 'Če je nastavljeno, bo vsa e-pošta preusmerjena na ta en e-poštni naslov.';
$string['dndallowtextandlinks'] = 'Naloži funkcijo povleci in spusti za besedila/povezave';
$string['doclang'] = 'Jezik za dokumente';
$string['docroot'] = 'Korenski imenik Moodle Docs';
$string['doctonewwindow'] = 'Odpri v novem oknu';
$string['doesnotfit'] = 'Nastavitve prikaza e-pošte';
$string['doesnotfitdetail'] = 'Nastavitve prikaza izhodne e-pošte.';
$string['download'] = 'Prenesi';
$string['downloadcoursecontentallowed'] = 'Prenesi razpoložljive funkcije vsebine predmeta';
$string['downloadcoursecontentallowed_desc'] = 'Če je funkcija prenosa vsebine predmeta na voljo predmetom. Ko je na voljo, so prenosi vsebine predmeta omogočeni/onemogočeni, tako da uporabite nastavitev »Omogočite prenos vsebine predmeta« v meniju urejanja predmeta (privzete nastavitve za to lahko nastavite v <a href={$a} target="_blank">Privzete nastavitve predmeta</a>).';
$string['durationunits'] = 'enote trajanja';
$string['edithelpdocs'] = 'Uredi dokumente pomoči';
$string['editlang'] = '<b>Uredi</b>';
$string['editorbackgroundcolor'] = 'Barva ozadja';
$string['editordictionary'] = 'Slovar urejevalnika';
$string['editorfontfamily'] = 'Družina pisave';
$string['editorfontlist'] = 'Seznam pisav';
$string['editorfontsize'] = 'Velikost pisave';
$string['editorhidebuttons'] = 'Skriti gumbi';
$string['editorkillword'] = 'Filter besednih formatov';
$string['editorspelling'] = 'Črkovanje urejevalnika';
$string['editorspellinghelp'] = 'Omogoči ali onemogoči črkovalnik. Ko imate možnost omogočeno, morate na strežniku imeti nameščen <strong>aspell</strong>.';
$string['editstrings'] = 'Uredi besede ali fraze';
$string['emailchangeconfirmation'] = 'Potrditev spremembe e-poštnega naslova';
$string['emaildkim'] = 'E-poštno podpisovanje (DomainKeys Identified Mail - DKIM)';
$string['emaildkiminfo'] = 'Če je izbirnik DKIM nastavljen in je najdena datoteka zasebnega certifikata, ki se ujema z domeno e-poštnega naslova »Od« v $CFG->dataroot/dkim/[domena]/[selektor].zasebno, potem bo e-pošta podpisana. V večini primerov (na primer, če je allowedemaildomains prazen) je potrebno samo eno potrdilo v <pre>{$a->path}</pre>. Za več podrobnosti o tej nastavitvi si oglejte dokumentacijo <a href=«{$a->docs}«>Konfuguracija e-pošte</a>.';
$string['emaildkimselector'] = 'Izbirnik DKIM';
$string['emailfromvia'] = 'E-pošta preko informacij';
$string['emailheaders'] = 'Glava e-pošte';
$string['emailsubjectprefix'] = 'Besedilna predpona v zadevi e-pošte';
$string['emoticonalt'] = 'Nadomestno besedilo';
$string['emoticoncomponent'] = 'Komponenta slike';
$string['emoticonimagename'] = 'Ime slike';
$string['emoticons'] = 'Čustveni simboli';
$string['emoticons_desc'] = 'Ta obrazec določa čustvene simbole (smeške), ki se uporabljajo na vašem spletnem mestu. Če želite odstraniti vrstico iz tabele, shranite obrazec s prazno vrednostjo v vsakem od zahtevanih polj. Če želite registrirati nov čustveni simbol, izpolnite polja v zadnji prazni vrstici. Če želite ponastaviti vsa polja na privzete vrednosti, sledite povezavi zgoraj.

* Besedilo (obvezno) – To besedilo bo zamenjano s sličico čustvenega simbola. Dolžina besedila mora biti vsaj dva znaka.
* Ime slike (obvezno) - Ime slikovne datoteke čustvenega simbola brez razširitve, v odvisnosti na mapo komponente pix.
* Komponenta slike (obvezno) - Komponenta, ki zagotavlja ikono.
* Nadomestno besedilo (neobvezno) - Identifikator niza in del alternativnega besedila čustvenega simbola.';
$string['emoticonsreset'] = 'Ponastavi nastavitve čustvenih simbolov na privzete vrednosti';
$string['emoticontext'] = 'Besedilo';
$string['emptysettingvalue'] = 'Prazno';
$string['enableactivitychooser'] = 'Omogoči izbirnik dejavnosti';
$string['enableanalytics'] = 'Analitika';
$string['enableblogs'] = 'Omogoči bloge';
$string['enablecalendarexport'] = 'Omogoči izvoz koledarja';
$string['enablecomments'] = 'Omogoči komentarje';
$string['enablecourserelativedates'] = 'Omogoči datume, povezane s predmetom';
$string['enablecourserelativedates_desc'] = 'Dovoli, da predmeti prikažejo datume, kdaj so uporabniki začeli s predmetom.';
$string['enablecourserequests'] = 'Omogoči zahteve za predmete';
$string['enabled'] = 'Omogočeno';
$string['enabledevicedetection'] = 'Omogoči odkrivanje naprav';
$string['enableglobalsearch'] = 'Omogoči globalno iskanje';
$string['enableglobalsearch_desc'] = 'Če je omogočeno, bodo podatki vpisani v kazalo in sinhronizirani z načrtovano nalogo.';
$string['enablegravatar'] = 'Omogoči Gravatar';
$string['enablegravatar_help'] = 'Če je omogočen, bo Moodle poskusil pridobiti sliko profila uporabnika iz Gravatarja, v kolikor uporabnik ni naložil slike.';
$string['enablemobilewebservice'] = 'Omogoči spletne storitve za mobilne naprave';
$string['enablerecordcache'] = 'Omogoči zapis predpomnilnika';
$string['enablerssfeeds'] = 'Omogoči vire RSS';
$string['enablesearchareas'] = 'Omogoči območja iskanja';
$string['enablestats'] = 'Omogoči statistiko';
$string['enabletrusttext'] = 'Omogoči zaupanja vredno vsebino';
$string['enableuserfeedback'] = 'Omogoči pripombe za to programsko opremo';
$string['enableuserfeedback_desc'] = 'Če je omogočeno, bo povezava do ‚Podajte pripombo o tej programski opremi‘ prikazana v nogi, da lahko uporabniki sedežu Moodla podajo pripombo o programski opremi Moodla. Če je izbrana možnost ‚Naslednji opomnik za pripombe‘, ima uporabnik na Nadzorni plošči prikazan opomnik z določenim časovnim razmakom. Če ‚Naslednji opomnik za pripombo‘ nastavite na ‚Nikoli‘, bo opomnik na nadzorni plošči onemogočen, povezava do ‚Podajte pripombo o tej programski opremi‘ pa bo še vedno v nogi.';
$string['enablewebservices'] = 'Omogoči spletne storitve';
$string['enablewsdocumentation'] = 'Dokumentacija spletnih storitev';
$string['encryptedpassword_edit'] = 'Vnesi novo vrednost';
$string['enrolinstancedefaults'] = 'Privzete vrednosti primerkov vpisa';
$string['enrolinstancedefaults_desc'] = 'Privzete nastavitve za vpis v novih predmetih.';
$string['enrolmultipleusers'] = 'Vpiši uporabnike';
$string['environment'] = 'Okolje';
$string['environmenterrortodo'] = 'Pred nadaljevanjem namestitve te različice Moodle morate razrešiti zgoraj odkrite težave okolja (napake)!';
$string['environmenterrorupgrade'] = 'Opozorilo: razrešite vse zgoraj odkrite težave (napake) okolja pred nadaljevanjem s nadgradnjo trenutne različice Moodla. Nadgradnja brez popravljanja teh zahtev utegne povzročiti napake, kot npr. izgubo podatkov. Ali ste prepričani, da želite nadaljevati s posodobitvijo?';
$string['environmentmariadbwrongdbtype'] = 'Napačna <code>$CFG->dbtype</code>: Morate jo spremeniti v vaši <code>config.php</code> datoteki, od \'<code>mysql</code>\' do \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'Nastavitve PHP morate spremeniti.';
$string['environmentok'] = 'Vaše strežniško okolje je v skladu z minimalnimi zahtevami.';
$string['environmentrecommendcustomcheck'] = 'če ta test ne uspe, to kaže na potencialen problem';
$string['environmentrecommendinstall'] = 'za boljše rezultate je priporočeno, da namestite in omogočite';
$string['environmentrecommendversion'] = 'različica {$a->needed} je priporočena, vi uporabljate {$a->current}';
$string['environmentrequirecustomcheck'] = 'ta test mora biti uspešen';
$string['environmentrequireinstall'] = 'zahtevano je, da namestite in omogočite';
$string['environmentrequireversion'] = 'različica {$a->needed} je zahtevana, vi uporabljate {$a->current}';
$string['environmentsettingok'] = 'zaznane priporočene nastavitve';
$string['environmentshouldfixsetting'] = 'Nastavitve PHP bi morali spremeniti.';
$string['environmentxmlerror'] = 'Napaka pri branju podatkov okolja ({$a->error_code})';
$string['errordeletingconfig'] = 'Pri brisanju konfiguracijskih zapisov za vtičnik \'{$a}‘ je prišlo do napake.';
$string['errorsetting'] = 'Nastavitve ni bilo mogoče shraniti:';
$string['errorwithsettings'] = 'Nekatere nastavitve niso bile spremenjene zaradi napake.';
$string['eventshandlersinuse'] = 'Sledeči vtičniki v vašem sistemu uporabljajo opuščene vodnike Events 1 API: ‚{$a}‘. Prosimo, posodobite jih, če želite uporabiti Events 2 API. Za več informacij si oglejte https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Vsi z dostopom do \'{$a}\'';
$string['exceptions'] = 'izjeme';
$string['execpathnotallowed'] = 'Izvršljive nastavitve in lokalne poti so onemogočene v config.php';
$string['experimental'] = 'Eksperimentalno';
$string['experimentalsettings'] = 'Poskusne nastavitve';
$string['extendedusernamechars'] = 'Dovoli razširjene znake v uporabniških imenih';
$string['extramemorylimit'] = 'Dodatna PHP omejitev spomina';
$string['fatalsessionautostart'] = '<p>Med konfiguracijo je prišlo do hude napake. Opozorite skrbnika strežnika.</p><p> Za pravilno delovanje Moodle zahteva, da skrbnik spremeni nastavitve PHP.</p><p><code>session.auto_start</code> mora biti nastavljena na <code>off</code>.</p><p>To se nastavi v <code>php.ini</code>, v nastavitvah Apache/IIS <br /> ali v datoteki <code>.htaccess</code> na strežniku.</p>';
$string['feedbacksettings'] = 'Nastavitve pripomb';
$string['fileconversioncleanuptask'] = 'Čiščenje začasnih zapisov pretvorbe datotek.';
$string['filecreated'] = 'Nova datoteka je ustvarjena';
$string['filescleanupperiod'] = 'Počisti datoteke skupinih virov za v smeti';
$string['filescleanupperiod_help'] = 'Kako pogosto so datoteke skupinih virov za v smeti izbrisane. Te datoteke so povezane s kontekstom, ki ne obstaja več, na primer, ko je predmet izbrisan. Prosimo, upoštevajte: Posledica te nastavitve so lahko manjkajoče datoteke pri predmetu, ki ste ga varnostno kopirali, izbrisali in nato obnovili, če je nastavitev ‚Vključi datoteke‘ (backup_auto_files) v ‚Nastavitve samodejne varnostne kopije‘ onemogočena.';
$string['filesizeunits'] = 'enote velikosti datotek';
$string['filestoredin'] = 'Shrani datoteko v mapo:';
$string['filestoredinhelp'] = 'Kje bo shranjena datoteka';
$string['filterall'] = 'Filtriraj vse nize';
$string['filtermatchoneperpage'] = 'Ujemanje filtra enkrat na stran';
$string['filtermatchonepertext'] = 'Ujemanje filtra enkrat na besedilo';
$string['filters'] = 'Filtri';
$string['filtersettings'] = 'Upravljaj filtre';
$string['filtersettingsgeneral'] = 'Splošne nastavitve filtra';
$string['filteruploadedfiles'] = 'Filtriraj naložene datoteke';
$string['forceclean'] = 'Čiščenje vsebin vsepovsod';
$string['forceclean_desc'] = 'Vsebina dodana na spletno mesto je pred prikazom običajno očiščena, zato da se odstrani vse kar predstavlja grožnjo varnosti. Vseeno pa vsebina ni očiščena na določenih mestih kot so opisi dejavnosti, viri spletnih strani ali bloki HTML, ki dovolijo dodajanje skriptov, predstavnostnih datotek, vrinjenih okvirov idr. Če je ta nastavitev omogočena, bo očiščena vsa vsebina. To lahko povzroči, da se obstoječa vsebina ne prikaže pravilno.';
$string['forcelogin'] = 'Prisili uporabnike k prijavi';
$string['forceloginforprofileimage'] = 'Prisili uporabnike k prijavi za ogled slik uporabnikov';
$string['forceloginforprofileimage_help'] = 'Če je omogočeno, se morajo uporabniki prijaviti za ogled slik profilov uporabnikov. Privzeta slika uporabnika bo prikazana v vseh obvestilih po e-pošti.';
$string['forceloginforprofiles'] = 'Prisili uporabnike k prijavi za profile';
$string['forcetimezone'] = 'Vsili časovni pas';
$string['formatuninstallwithcourses'] = 'Število predmetov oblike {$a->format}: {$a->count}. Njihov format bo spremenjen v {$a->defaultformat} (privzeta oblika za to spletno mesto). Nekateri podatki, značilni za določeno obliko predmeta, se lahko izgubijo. Ali želite nadaljevati?';
$string['frontpage'] = 'Naslovna stran';
$string['frontpagebackup'] = 'Varnostna kopija vstopne strani';
$string['frontpagedefaultrole'] = 'Privzeta vloga naslovne strani';
$string['frontpagefilters'] = 'Filtri naslovne strani';
$string['frontpageloggedin'] = 'Elementi naslovne strani ob prijavi';
$string['frontpageoverrides'] = 'Preglasitev dovoljenj naslovne strani';
$string['frontpagequestions'] = 'Vprašanja naslovne strani';
$string['frontpagerestore'] = 'Obnovi naslovno stran';
$string['frontpageroles'] = 'Vloge naslovne strani';
$string['frontpagesettings'] = 'Nastavitve naslovne strani';
$string['fullnamedisplay'] = 'Format celotnega imena';
$string['fullnamedisplayprivate'] = 'Format celotnega imena - zasebno';
$string['gdrequired'] = 'Moodle sedaj zahteva razširitev GD za pretvorbo slik.';
$string['generalsettings'] = 'Splošne nastavitve';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Vir dnevniškega naslova IP';
$string['globalsearch'] = 'Splošno iskanje';
$string['globalsearchmanage'] = 'Upravljaj globalno iskanje';
$string['googlemapkey3'] = 'Ključ za Google Maps API V3';
$string['googlemapkey3_help'] = 'Vnesti morate poseben ključ, da bi lahko uporabljali Google Maps za prikaz lokacije naslova IP. Ključ lahko brezplačno pridobite na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Pojdi na prvi manjkajoči niz';
$string['gradebook'] = 'Redovalnica';
$string['gradebookroles'] = 'Ocenjene vloge';
$string['gradeexport'] = 'Osnovni način izvoza ocen';
$string['gravatardefaulturl'] = 'Privzet URL za Gravatarjevo sliko';
$string['gravatardefaulturl_help'] = 'Če Gravatar ne najde uporabnikove slike, potrebuje za prikaz privzeto sliko. Vnesite polni URL slike. Če pustite to nastavitev prazno, bo Moodle poskusil uporabiti najprimernejšo privzeto sliko za stran, ki si jo ogledujete. Upoštevajte, da ima Gravatar številne kode za <a href="https://en.gravatar.com/site/implement/images/#default-image">ustvarjanje privzetih slik</a>.';
$string['groupenrolmentkeypolicy'] = 'Politika ključa za vpis v skupino';
$string['groupenrolmentkeypolicy_desc'] = 'Če je omogočeno, bo Moodle preverjal ključe za vpis v skupino kljub veljavnemu pravilniku za gesla, ki je določen v zgornjih nastavitvah.';
$string['guestroleid'] = 'Vloga za gosta';
$string['guestroleid_help'] = 'Ta vloga je samodejno dodeljena gostom. Prav tako je začasno dodeljena uporabnikom, ki niso vpisani, ampak v predmet vstopajo prek vtičnika za vpis gostov.';
$string['h5pgetcontenttypestask'] = 'Iz h5p.org prenesi razpoložljive tipe vsebin H5P';
$string['helpadminseesall'] = 'Ali skrbniki vidijo in filtrirajo vse dogodke koledarja spletnega mesta ali samo dogodke predmetov, v katere so vpisani? Neodvisno od izbrane možnosti, bodo lahko skrbniki vedno upravljali z dogodki vsakega koledarja premeta, tako da bodo najprej navigirali premet, potem pa dostopali neposredno do koledarja predmeta.';
$string['helpcalendarcustomexport'] = 'Omogočite možnost prilagoditve razpona datuma v izvozu koledarja. Izvozi koledarja morajo biti omogočeni, da je to lahko uspešno.';
$string['helpexportlookahead'] = 'Koliko dni vnaprej naj koledar išče dogodke med izvažanjem, glede na prilagojene možnosti izvoza?';
$string['helpexportlookback'] = 'Koliko dni nazaj naj koledar išče dogodke med izvažanjem, glede na prilagojene možnosti izvoza?';
$string['helpforcetimezone'] = 'Uporabnikom lahko dovolite, da sami izberejo svoj časovni pas, ali pa vsilite časovni pas vsem.';
$string['helpshowicalsource'] = 'Če je omogočeno, bosta naročniško ime in povezava prikazana za uvožene dogodke iCal.';
$string['helpsitemaintenance'] = 'Za nadgradnje in drugo delo';
$string['helpstartofweek'] = 'S katerim dnem se prične teden v koledarju?';
$string['helpupcominglookahead'] = 'Koliko dni vnaprej naj koledar kot privzeto išče prihajajoče dogodke?';
$string['helpupcomingmaxevents'] = 'Koliko (največ) prihajajočih dogodkov se privzeto prikaže uporabnikom?';
$string['helpweekenddays'] = 'Katere dni v tednu se obravnava kot "vikend" in so prikazani z drugo barvo?';
$string['hiddenuserfields'] = 'Skrij uporabniška polja';
$string['hidefromall'] = 'Skrij pred vsemi uporabniki';
$string['hidefromnone'] = 'Ne skrij pred nobenim';
$string['hidefromstudents'] = 'Skrij pred udeleženci';
$string['htmleditor'] = 'Urejevalnik HTML';
$string['htmleditorsettings'] = 'Nastavitve urejevalnika HTML';
$string['htmlsettings'] = 'Nastavitve HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Varnost HTTP';
$string['iconvrequired'] = 'Namestitev razširitve ICONV je zahtevana.';
$string['ignore'] = 'Prezri';
$string['includemoduleuserdata'] = 'Vključi podatke o uporabnikih modula';
$string['incompatibleblocks'] = 'Nezdružljivi bloki';
$string['incompleteunicodesupport'] = 'Trenutne nastavitve MySQL-ja ali MariaDB-ja uporabljajo \'utf8\'. Ta znakovni nabor ne podpira štiri-bitnih znakov, ki vsebujejo tudi smeške. Napaka med posodabljanjem zapisa bo posledica uporabe teh znakov, izgubljene pa bodo tudi vse informacije, ki so v prenosu v podatkovno bazo. Prosimo, spremenite vaše nastavitve na \'utf8mb4\'. Za podrobnosti poglejte dokumentacijo.';
$string['indexdata'] = 'Podatke vpiši v kazalo';
$string['indexinginfo'] = 'Priporočen način za vpisovanje vsebine vašega spletnega mesta v kazalo je uporaba načrtovane naloge »Urejanje splošnega iskanja«.';
$string['installhijacked'] = 'Namestitev mora biti zaključena iz izvirnega naslova IP.';
$string['installsessionerror'] = 'Ni mogoče vzpostaviti seje PHP. Preverite, ali vaš brskalnik omogoča piškotke.';
$string['intlrecommended'] = 'Razširitev Intl se uporablja za izboljšanje podpore internacionalizacije, kot je npr. lokalno sortiranje.';
$string['intlrequired'] = 'Intl razširitev je potrebna za izboljšanje mednarodne podpore.';
$string['invalidagedigitalconsent'] = 'Digitalna starost privolitve ni veljavna: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL za pozabljeno geslo ni veljaven URL.';
$string['invalidsection'] = 'Neveljaven odsek.';
$string['invalidthemepreset'] = 'Izbrana prednastavljena datoteka ni združljiva s to temo. Napaka pri združevanju SCSS je bila: "{$a}"';
$string['invaliduserchangeme'] = 'Uporabniško ime "changeme" je rezervirano -- z njim ne morete ustvariti uporabniškega računa.';
$string['ipblocked'] = 'Spletno mesto trenutno ni na voljo.';
$string['ipblocker'] = 'IP blokada';
$string['ipblockersyntax'] = 'Vstavite vsak vnos v eno vrstico. Veljavni vnosi so bodisi polni naslov IP (kot je <b> 192.168.10.1 </ b>), ki se ujema z enim gostiteljem; ali delen naslov (kot <b> 192.168 </ b>), ki bo ustrezal kateremu koli naslovu, začenši s temi številkami; ali CIDR zapis (na primer <b> 231.54.211.0/20 </ b>), ali razpon naslovov IP (na primer <b> 231.3.56.10-20 </ b>), kjer območje velja za zadnji del naslova. Besedilna domenska imena (kot je "example.com) niso podprta. Prazne vrstice in besedilo, ki sledi znaku "#", je prezrto.';
$string['iplookup'] = 'Iskanje naslovov IP';
$string['iplookupgeoplugin'] = 'Trenutno se uporablja storitev <a href="http://www.geoplugin.com">geoPlugin</a> za iskanje geografskih informacij. Za natančnejše rezultate priporočamo, da si namestite lokalno različico podatkovne baze MaxMind GeoLite.';
$string['iplookupinfo'] = 'Moodle privzeto uporablja zastonjski strežnik NetGeo (The Internet Geographic Database) za lociranje uporabnikov glede na IP naslov. Žal ta zbirka uporabnikov ni vzdrževana, zato lahko vrne <em>zelo napačne</em> podatke. Priporočamo, da si namestite lokalno kopijo zastonjske podatkovne baze GeoLite2 City podjetja MaxMind.<br />
Lokacija IP naslova je prikazana na preprostem zemljevidu ali pa z uporabo Google Maps. Upoštevajte, da za uporabo Google Maps potrebujete uporabniški račun Google, za interaktivne zemljevide pa potrebujete tudi brezplačen API ključ Google Maps.';
$string['iplookupmaxmindnote'] = 'Ta izdelek vključuje podatke GeoLite2 podjetja MaxMind, dostopnega na naslovu <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['ishttpswarning'] = 'Ugotovljeno je bilo da vaše spletno mesto ni zaščiteno s HTTPS-jem. Priporočamo selitev spletnega mesta na HTTPS za večjo varnost in boljšo vključevanje z drugimi sistemi.';
$string['keeptagnamecase'] = 'Ohrani velike in male črke';
$string['lang'] = 'Privzeti jezik';
$string['langcache'] = 'Predpomnenje menija jezika';
$string['langcache_desc'] = 'Predpomni jezikovni meni. Če je omogočeno, je seznam razpoložljivih prevodov shranjen v predpomnilniku. Predpomnilnik se samodejno osveži, ko namestite ali izbrišete jezikovni paket prek vgrajenega orodja za upravljanje z jezikovnimi paketi. Če namestite nov jezikovni paket ročno, boste morali uporabiti funkcijo "Počisti vse predpomnilnike" za osvežitev seznama.';
$string['langlist'] = 'Jeziki v jezikovnem meniju';
$string['langmenu'] = 'Prikaži jezikovni meni';
$string['langmenuinsecurelayout'] = 'Prikaži jezikovni meni v varni postavitvi';
$string['langmenuinsecurelayout_desc'] = 'Če je omogočeno, lahko uporabnik spremeni jezik, ko poskusi kviz ali drugo aktivnost z uporabo varne postavitve.';
$string['langpackwillbeupdated'] = 'OPOMBA: Med nadgradnjo bo Moodle poskušal naložiti posodobitve za nameščene jezikovne pakete.';
$string['langstringcache'] = 'Predpomni vse jezikovne nize';
$string['languagesettings'] = 'Nastavitve jezika';
$string['latinexcelexport'] = 'Kodiranje Excela';
$string['legacyfilesaddallowed'] = 'Dovoli dodajanje podedovanih datotek predmeta';
$string['legacyfilesaddallowed_help'] = 'Če ima predmet podedovane datoteke predmeta, dovoli, da se vanj dodajo nove datoteke in mape.';
$string['legacyfilesinnewcourses'] = 'Podedovane datoteke predmeta v novih predmetih';
$string['legacyfilesinnewcourses_help'] = 'Privzeto so podedovane datoteke predmeta na voljo le v nadgrajenih predmetih. Upoštevajte, da določene funkcije, kot je varnostno kopiranje in obnova posamezne dejavnosti, niso združljive s to nastavitvijo.';
$string['libcurlwarning'] = 'Ugotovljeno je bilo, da libcurl ne podpira CURLOPT_PROTOCOLa. Namestitev najnovejše verzije libcurla je priporočena iz varnostnih razlogov.';
$string['licensesettings'] = 'Nastavitve licence';
$string['linkadmincategories'] = 'Povezave do skrbniških kategorij';
$string['linkadmincategories_help'] = 'Če je omogočeno, bodo v navigaciji kategorije skrbniških nastavitev prikazane kot povezave do skrbniških strani posamezne kategorije.';
$string['linkcoursesections'] = 'Vedno pokaži povezave do odsekov predmeta';
$string['linkcoursesections_help'] = 'Vedno poskušaj podati povezavo za odseke predmeta.';
$string['loading'] = 'Nalaganje';
$string['localetext'] = 'Celotno spletišče';
$string['localstringcustomization'] = 'Prilagoditev lokalnih nizov';
$string['location'] = 'Lokacija';
$string['locationsettings'] = 'Nastavitve lokacije';
$string['locked'] = 'Zaklenjeno';
$string['lockoutduration'] = 'Čas, ko je račun zaklenjen';
$string['lockoutduration_desc'] = 'Zaklenjen račun bo samodejno odklenjen po preteku tega časa.';
$string['lockoutemailbody'] = 'Vaš račun z uporabniškim imenom {$a->username} na strežniku \'{$a->sitename}\'
was je po večkratnih neuspelih poskusih prijave zaklenil.

Da bi račun takoj odklenili, pojdite na naslednjo povezavo:

{$a->link}

V večini e-poštnih programov se ta povezava prikaže obarvana
modro in nanjo lahko kliknete. Če to ne deluje, naslov
skopirajte in prilepite v naslovno vrstico na vrhu okna
spletnega brskalnika.

Če potrebujete pomoč, se obrnite na skrbnika spletnega mesta
{$a->admin}';
$string['lockoutemailsubject'] = 'Vaš račun na {$a} je bil zaklenjen';
$string['lockouterrorunlock'] = 'Vnesli ste neveljavno geslo za odklenitev računa.';
$string['lockoutthreshold'] = 'Dovoljeno število neveljavnih poskusov prijave v račun';
$string['lockoutthreshold_desc'] = 'Izberite število dovoljenih spodletelih poskusov prijave, ki zaklenejo račun. To funkcijo lahko izrabijo pri napadih za zavrnitev storitve.';
$string['lockoutwindow'] = 'Časovno okno neuspelih prijav v račun';
$string['lockoutwindow_desc'] = 'Čas spremljanja praga zaklepa. Če ni spodletelih poskusov, se čas zaklepa ponastavi po preteku nastavljenega časa.';
$string['lockrequestcategory'] = 'Prepreči izbiro kategorij';
$string['log'] = 'Dnevniki';
$string['logguests'] = 'Zabeleži gostujoči dostop';
$string['logguests_help'] = 'Ta nastavitev omogoča beleženje ukazov gostujočih uporabniških računov in neprijavljenih uporabnikov. Visoko profilne strani lahko zahtevajo, da onemogočite beleženje zaradi boljšega delovanja. Priporočljivo je, da na prednostnih spletiščih pustite to nastavitev omogočeno.';
$string['logininfoinsecurelayout'] = 'Prikaži prijavljenega uporabnika v varni postavitvi';
$string['logininfoinsecurelayout_desc'] = 'Če je omogočeno, je polno ime prijavljenega uporabnika prikazano v navigacijski vrstici, ko poskusite kviz ali drugo dejavnost z uporabo varne postavitve.';
$string['loginpageautofocus'] = 'Samodejno fokusiraj obliko prijavne strani';
$string['loginpageautofocus_help'] = 'Omogočanje te možnosti izboljša uporabnost prijavne strani, vendar je lahko samodejno fokusiranje polj iz stališča dostopnosti sporno.';
$string['loglifetime'] = 'Obdrži dnevnike za';
$string['logo'] = 'Logotip';
$string['logo_desc'] = 'Nekatere teme (na primer glavna tema) za okras izkoristijo celoten logotip. Ta slika je lahko precej visoke ločljivosti, ker bo za uporabo zmanjšana (in predpomnjena za učinkovitost). Logotipi, katerih širina je večja od višine, dajo navadno boljše rezultate. Možni obliki: PNG in JPG.';
$string['logocompact'] = 'Kompakten logotip';
$string['logocompact_desc'] = 'Kompaktna različica istega logotipa kot zgoraj. Slika mora biti čista kljub majhni velikosti. Sprejeti obliki: PNG in JPG.';
$string['logossettings'] = 'Logotipi';
$string['logstorenotrequired'] = 'Dnevnikov ni potrebno hraniti';
$string['logstoressupported'] = 'Hranjenje dnevnikov, ki podpira to poročilo';
$string['longtimewarning'] = '<b>Upoštevajte, da lahko ta proces traja dlje časa.</b>';
$string['mailnewline'] = 'Znaki za novo vrstico v e-pošti';
$string['maintenancemode'] = 'V vzdrževalnem načinu';
$string['maintenancemodeisscheduled'] = 'To spletno mesto bo prešlo v vzdrževalni način čez {$a->min}:{$a->sec}';
$string['maintenancemodeisscheduledlong'] = 'To spletno mesto se bo preklopilo na način vzdrževanja čez {$a->hour} ur, {$a->min} minut in {$a->sec} sekund';
$string['maintfileopenerror'] = 'Napaka pri odpiranju vzdrževalnih datotek!';
$string['maintinprogress'] = 'Vzdrževanje v teku ...';
$string['managecontextlock'] = 'Zakleni ta kontekst';
$string['managecontextlocklocked'] = '{$a->contextname} in drugi nižji konteksti so zdaj zaklenjeni.';
$string['managecontextlockunlocked'] = '{$a->contextname} in drugi nižji konteksti so zdaj odklenjeni.';
$string['managecontextunlock'] = 'Odkleni ta kontekst';
$string['managecustomfields'] = 'Upravljaj tipe profilnega polja';
$string['manageformats'] = 'Upravljaj oblike predmetov';
$string['manageformatsgotosettings'] = 'Privzeto format lahko spremenite v {$a}';
$string['managelang'] = 'Upravljaj';
$string['managelicenses'] = 'Upravljaj licence';
$string['manageqbehaviours'] = 'Upravljaj vedenja vprašanj';
$string['manageqtypes'] = 'Upravljaj tipe vprašanj';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Sprosti kandidata';
$string['maturity200'] = 'Stabilna različica';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Namig: ta skript lahko zaženete z možnostjo --allow-unstable';
$string['maturitycoreinfo'] = 'Vaše spletno mesto trenutno deluje na nestabilni "{$a}" razvojni kodi.';
$string['maturitycorewarning'] = 'Različica Moodla, ki jo želite namestiti ali nadgraditi, vsebuje
nestabilno kodo razvijalca "{$a}", ki ni primerna za uporabo na večini prednostnih
spletišč. Če to ni kar ste želeli, potem se prepričajte da posodabljate
iz STABILNE Moodle kode. Za več podrobnosti poglejte Moodle Docs.';
$string['maxbytes'] = 'Največja velikost naložene datoteke';
$string['maxconsecutiveidentchars'] = 'Zaporedni enaki znaki';
$string['maxeditingtime'] = 'Največja časovna omejitev za urejanje prispevkov';
$string['maxsizeperdownloadcoursefile'] = 'Največja velikost na datoteko';
$string['maxsizeperdownloadcoursefile_desc'] = 'Največja velikost vsake datoteke, ko se prenaša vsebina predmeta. Datoteke, ki so večje od tega, bodo pri prenosu izpuščene.';
$string['maxtimelimit'] = 'Največja časovna omejitev';
$string['maxtimelimit_desc'] = 'Če želite omejiti največji čas izvajanja PHP, ki ga bo Moodle dovolil brez kakršnihkoli prikazanih izhodnih podatkov, vnesite tukaj vrednost v sekundah. Vrednost 0 pomeni, da so uporabljene Moodlove privzete omejitve. Če imate oblični strežnik s svojim časovnim okvirom, nastavite to vrednost nižje, da prejemate napake PHP v dnevnikih. To ne velja za skripte CLI.';
$string['maxusersperpage'] = 'Največje število uporabnikov na stran';
$string['mbstringrecommended'] = 'Namestitev neobvezne knjižnice MBSTRING je zelo priporočljiva za izboljšanje zmogljivosti spletne strani, zlasti če stran uporablja ne-latinične jezike.';
$string['mbstringrequired'] = 'Zahtevana je namestitev knjižnice MBSTRING, da bo delovanje spletnega mesta izboljšano, še posebej, če vaše spletno mesto podpira nelatinične jezike.';
$string['mediapluginavi'] = 'Omogoči filter .avi';
$string['mediapluginflv'] = 'Omogoči filter .flv';
$string['mediapluginimg'] = 'Omogoči samodejna vdelava povezanih slik';
$string['mediapluginmov'] = 'Omogoči filter .mov';
$string['mediapluginmp3'] = 'Omogoči filter .mp3';
$string['mediapluginmpg'] = 'Omogoči filter .mpg';
$string['mediapluginogg'] = 'Omogoči filter .ogg';
$string['mediapluginogv'] = 'Omogoči filter .ogv';
$string['mediapluginram'] = 'Omogoči filter .ram';
$string['mediapluginrm'] = 'Omogoči filter .rm';
$string['mediapluginrpm'] = 'Omogoči filter .rpm';
$string['mediapluginswf'] = 'Omogoči filter .swf';
$string['mediapluginswfnote'] = 'Kot privzet varnostni ukrep običajnim uporabnikom ni dovoljena vdelava datotek swf flash.';
$string['mediapluginwmv'] = 'Omogoči filter .wmv';
$string['mediapluginyoutube'] = 'Omogoči filter povezav YouTube';
$string['messaging'] = 'Omogoči sistem za sporočanje';
$string['messagingallowemailoverride'] = 'Preglasitev obvestila po e-pošti';
$string['messagingallusers'] = 'Dovoli spletiščno sporočanje';
$string['messagingcategory'] = 'Sporočanje';
$string['messagingdefaultpressenter'] = 'Pritisnite Enter, da pošljete privzeto omogočeno';
$string['messagingdeleteallnotificationsdelay'] = 'Izbriši vsa obvestila';
$string['messagingdeletereadnotificationsdelay'] = 'Izbriši prebrana obvestila';
$string['messagingssettings'] = 'Nastavitve sporočanja';
$string['minpassworddigits'] = 'Številke';
$string['minpasswordlength'] = 'Dolžina gesla';
$string['minpasswordlower'] = 'Male črke';
$string['minpasswordnonalphanum'] = 'Nealfanumerični znaki';
$string['minpasswordupper'] = 'Velike črke';
$string['misc'] = 'Razno';
$string['mlbackendsettings'] = 'Nastavitve zaledja strojnega učenja';
$string['mnetrestore_extusers'] = '<strong>Opozorilo:</strong> Ta datoteka varnostne kopije vsebuje uporabniške račune oddaljenega Moodlovega omrežja, ki bodo obnovljeni kot del procesa.';
$string['mnetrestore_extusers_admin'] = '<strong>Opozorilo:</strong> Ta datoteka varnostne kopije očitno izvira iz druge Moodle nastavitve in vsebuje uporabniške račune oddaljenega Moodle omrežja. Postopek obnovitve bo poskusil določiti gostitelje Moodle omrežja za vse nove uporabnike. Uporabniki, za katere to ne bo mogoče, bodo samodejno nastavljeni na interno preverjanje pristnosti (ne prek Moodle Network). Natančen seznam takih uporabnikov bo v dnevniku obnovitve (restore log).';
$string['mnetrestore_extusers_mismatch'] = '<strong>Opozorilo:</strong> Ta datoteka varnostne kopije očitno izvira iz druge Moodlove namestitve in vsebuje uporabniške račune oddaljenega Moodlovega omrežja, ki morda ne bodo obnovljeni. To dejanje ni podprto. Če ste prepričani, da je bila varnostna kopija narejena na tej Moodlovi namestitvi ali če lahko zagotovite, da so zahtevani gostitelji Moodlovega omrežja konfigurirani, boste morda želeli nadaljevati s povrnitvijo.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Opozorilo:</strong> Ta datoteka varnostne kopije očitno izvira iz druge Moodle namestitve in vsebuje uporabniške račune oddaljenega Moodle omrežja. Nimate dovoljenja za izvajanje tega tipa obnovitve. Stopite v stik s skrbnikom spletnega mesta ali obnovite ta predmet brez informacij o uporabnikih (modulov, datotek ...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Oddaljeni uporabnik Moodle omrežja {$a->username} (s strežnika {$a->mnethosturl}) je bil prirejen lokalno overjenemu uporabniku {$a->auth}.';
$string['mobilenotconfiguredwarning'] = 'Aplikacija Moodle ni omogočena.';
$string['modchooserdefault'] = 'Privzeta vrednost izbirnika dejavnosti';
$string['modeditdefaults'] = 'Privzete vrednosti za nastavitve dejavnosti';
$string['modsettings'] = 'Upravljaj dejavnosti';
$string['modulesecurity'] = 'Varnost Moodle';
$string['moodleapp'] = 'Aplikacija Moodle';
$string['moodleapp_help'] = '<p>Če imate račun na spletnem mestu Moodle, lahko na vašem mobilniku prek naše mobilne aplikacije za Moodle dostopate do vseh predmetov.</p>
<a href="https://moodle.com/mobile-app">Get the Moodle app</a><br />
<a href="https://apps.moodle.com">Moodle Apps Portal</a>';
$string['moodlebrandedapp'] = 'Tržna Aplikacija Moodle';
$string['moodlebrandedapp_help'] = '<p>Tržna aplikacija Moodle vsebuje vse funkcionalnosti naše brezplačne mobilne aplikacije za Moodle v kombinaciji z znamko po meri.</p>
<a href="https://moodle.com/branded-app">About the Branded Moodle app</a>';
$string['moodlebrandedappreference'] = 'Ali pa si naložite <a href=«https://moodle.com/branded-app/«>Tržno aplikacijo Moodle</a> z znamko po meri.';
$string['moodlepartners'] = 'Moodlovi partnerji';
$string['moodlepartners_help'] = '<p>Partnerji Moodla so ponudniki storitev, ki jim je certifikat podaril sedež Moodla, da bi spletnemu učnemu okolju vaše organizacije priskrbeli visoko kvalitetne Moodlove storitve.</p>
<a href="https://moodle.com/about-partners/">About our Partners</a><br />
<a href="https://moodle.com/partners">Find a Partner</a>';
$string['moodleservices'] = 'Moodlove storitve';
$string['moodleservices_help'] = 'Izkoristite najboljše, kar vam ponuja Moodlov učno okolje, tako da uporabite sledeče Moodlove storitve:';
$string['multilangforceold'] = 'Vsili staro večjezično sintakso: &lt;span&gt; brez class="multilang" in &lt;lang&gt;';
$string['mustenablestats'] = 'Statistika za to spletno mesto še ni bila omogočena.';
$string['mycoursesperpage'] = 'Število predmetov';
$string['mydashboard'] = 'Privzeta nadzorna plošča sistema';
$string['mymoodle'] = 'Nadzorna plošča';
$string['mymoodleredirect'] = 'Uporabnikom vsili, da uporabljajo stran Moj Moodle';
$string['mypage'] = 'Privzeta stran Nadzorna plošča';
$string['mypagelocked'] = 'Zakleni privzeto stran';
$string['myprofile'] = 'Privzeta profilna stran';
$string['navadduserpostslinks'] = 'Dodaj povezave za ogled prispevkov uporabnikov';
$string['navadduserpostslinks_help'] = 'Če je omogočeno, bosta vsakemu uporabniku v navigaciji dodeljeni dve povezavi za ogled svojih razprav in objav v forumih v celotnem spletnem mestu ali v posameznih predmetih..';
$string['navcourselimit'] = 'Meja predmeta';
$string['navigationupgrade'] = 'Ta nadgradnja prinaša dva nova navigacijska bloka, ki bosta nadomestila te bloke: Skrbništvo, Predmeti, Aktivnosti in Sodelujoči. Če ste na teh blokih nastavili kakšna posebna dovoljenja, preverite če vse deluje, kot si to želite.';
$string['navshowallcourses'] = 'Prikaži vse predmete';
$string['navshowcategories'] = 'Prikaži kategorije predmetov';
$string['navshowfrontpagemods'] = 'Prikaži dejavnosti na naslovni strani v navigaciji';
$string['navshowfrontpagemods_help'] = 'Če je omogočeno, bodo dejavnosti naslovne strani prikazane v navigaciji pod stranmi spletnega mesta.';
$string['navshowfullcoursenames'] = 'Prikaži celotna imena predmetov';
$string['navshowfullcoursenames_help'] = 'Če je omogočeno, bodo predmeti v navigaciji prikazani s celotnim namesto s kratkim imenom.';
$string['navshowmycoursecategories'] = 'Prikaži moje kategorije predmetov';
$string['navshowmycoursecategories_help'] = 'Če je omogočeno, bodo predmeti v izbiri Moji predmeti prikazani v kategorijah.';
$string['navsortmycourseshiddenlast'] = 'Skrite predmete razvrsti na konec';
$string['navsortmycourseshiddenlast_help'] = 'Če je omogočeno, bodo skriti predmeti navedeni za vidnimi predmeti (pri uporabnikih, ki si lahko ogledajo skrite predmete). Drugače bodo vsi predmeti, ne glede na njihovo vidnost, navedeni glede na nastavitev ‚Razvrsti moje premete\'.';
$string['navsortmycoursessort'] = 'Razvrsti moje predmete';
$string['navsortmycoursessort_help'] = 'Nastavitev določa, ali bodo predmeti v Moji predmeti razvrščeni po vrstnem redu (kot je nastavljeno v Skrbništvo spletnega mesta > Predmeti > Upravljaj predmete in kategorije) ali po abecednem redu.';
$string['never'] = 'Nikoli';
$string['neverdeleteruns'] = 'Nikoli ne izbriši izvajanj';
$string['newestdocindexed'] = 'Najnovejši dokument vpisan v kazalo';
$string['nobookmarksforuser'] = 'Nimate nobenih zaznamkov.';
$string['nodatabase'] = 'Ni podatkovne baze';
$string['nohttpsformobilewarning'] = 'Priporočljivo je, da omogočite HTTPS z veljavnim certifikatom. Aplikacija Moodle bo vedno najprej poskusila uporabiti varno povezavo.';
$string['nomissingstrings'] = 'Ni manjkajočih nizov';
$string['none'] = 'Brez';
$string['nonewsettings'] = 'Med nadgradnjo ni bilo dodanih novih nastavitev.';
$string['nonexistentbookmark'] = 'Zahtevan zaznamek ne obstaja.';
$string['noreplyaddress'] = 'E-poštni naslov brez odgovora';
$string['noreplydomain'] = 'Brez odgovora in domena';
$string['noreplydomaindetail'] = 'Nastavitve za Brez odgovors in konfigurirane domene';
$string['noresults'] = 'Ni bilo najdenih rezultatov.';
$string['noroles'] = 'Ni vlog';
$string['nosupportedlogstore'] = 'Najdeno ni bilo nobeno podprto hranjenje dnevnikov';
$string['notifications'] = 'Obvestila';
$string['notifyloginfailures'] = 'Pošlji e-pošto ob neuspelih prijavah na naslov';
$string['notifyloginthreshold'] = 'Prag za e-poštna obvestila';
$string['notloggedinroleid'] = 'Vloga za obiskovalce';
$string['numberofmissingstrings'] = 'Število manjkajočih nizov: {$a}';
$string['numberofstrings'] = 'Skupno število nizov: {$a->strings}<br />Manjka: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Osvežitveni žeton za eno izmed storitev OAuth {$a->issuer} na vaši spletni strani {$a->siteurl} je potekel. To bo omejilo funkcionalnost vaših vtičnikov, ki uporabljajo to storitev. Za odpravitev te napake obiščite konfiguracijsko stran Oauth 2 Services in kliknite ikono »Poveži sistemski račun« za to storitev. Bodite pozorni, da se vsakič vpišete z računom za isto storitev za sistem Oauth.';
$string['oauthrefreshtokenexpiredshort'] = 'Osvežitveni žeton OAuth na vaši spletni strani {$a->siteurl} potekel za {$a->issuer}.';
$string['onlynoreply'] = 'Samo če prihaja od naslova brez odgovora';
$string['opcacherecommended'] = 'Pomnilniška ukazna koda PHP izboljša delovanje in zmanjša zahteve spomina, razširitev OP predpomnilnika je priporočljiva in popolnoma podprta.';
$string['opensslrecommended'] = 'Namestitev neobvezne knjižnice OpenSSL je zelo priporočena, saj omogoča funkcionalnost Moodlovega omrežja.';
$string['opensslrequired'] = 'OpenSSL PHP razširitev se sedaj zahteva za nudenje močnejših kriptografskih storitev.';
$string['opentowebcrawlers'] = 'Odpri iskalnikom';
$string['optionalmaintenancemessage'] = 'Neobvezno sporočilo o vzdrževanju';
$string['order1'] = 'Prvi';
$string['order2'] = 'Drugi';
$string['order3'] = 'Tretji';
$string['order4'] = 'Četrti';
$string['outgoingmailconfig'] = 'Konfiguracija izhodne pošte';
$string['overridetossl'] = 'HTTPS za vpis je bil opuščen. Ta element je sedaj prisiljen SSL-u. Za odpravo tega opozorila spremenite svoj wwwroot v config.php na https://';
$string['pageinfodebugsummary'] = 'Ta stran je: {$a}';
$string['passwordchangelogout'] = 'Odjava po spremembi gesla';
$string['passwordchangelogout_desc'] = 'Če je omogočeno, se ob spremembi gesla ugasnejo vse seje brskalnika, razen tiste, v kateri je določeno novo geslo. (Ta nastavitev ne vpliva na spremembo gesla preko množičnega nalaganja uporabnikov)';
$string['passwordchangetokendeletion'] = 'Odstrani žetone spletnega strežnika po spremembi gesla';
$string['passwordchangetokendeletion_desc'] = 'Če je omogočeno, se ob spremembi gesla izbrišejo vsi uporabniški žetoni dostopa do spletnega strežnika.';
$string['passwordpolicy'] = 'Varnostna politika gesel';
$string['passwordpolicycheckonlogin'] = 'Ob prijavi preveri geslo';
$string['passwordresettime'] = 'Največji časovni okvir za potrditev zahteve ponastavitve gesla';
$string['passwordreuselimit'] = 'Omejitev rotacije gesel';
$string['passwordreuselimit_desc'] = 'Kolikokrat mora uporabnik spremeniti svoje geslo, preden lahko ponovno uporabi svoje staro geslo. Sledi prej uporabljenih gesel so shranjene v lokalni tabeli podatkovne baze. Ta funkcija je morda nezdružljiva z nekaterimi zunanjimi vtičniki za preverjanje pristnosti.';
$string['pathtodot'] = 'Pot do pike';
$string['pathtodot_help'] = 'Pot do pike. Najverjetneje nekaj podobnega /usr/bin/dot. Da boste lahko generirali grafiko iz DOT datotek, morate namestiti dot izvršilno datoteke in ji označiti pot do tu. Zapomnite si, da je za sedaj to uporabljeno za profilne lastnosti (Development->Profiling), vgrajene v Moodle.';
$string['pathtodu'] = 'Pot do du';
$string['pathtogs'] = 'Pot do ghostscript';
$string['pathtogs_help'] = 'Na večini Linuxovih namestitvah to lahko ostane kot \'/usr/bin/gs\'. Na sistemih Windows izgleda nekako tako \'c:\\gs\\bin\\gswin32c.exe\' (Poskrbite, da na poti ni presledkov - ob potrebi skopirajte datoteki \'gswin32c.exe\' in \'gsdll32.dll\' v novo mapo brez presledkov na poti)';
$string['pathtopdftoppm'] = 'Pot do pdftoppm';
$string['pathtopgdump'] = 'Pot do pg_dump';
$string['pathtopgdumpdesc'] = 'To je potrebno vnesti samo, če imate na vašem strežniku več kot en pg_dump (na primer, če imate nameščeno več kot eno različico postgresql)';
$string['pathtopgdumpinvalid'] = 'Neveljavna pot do pg_dump - bodisi napačna pot ali pa se ne more izvesti';
$string['pathtophp'] = 'Pot do PHP CLI';
$string['pathtopsql'] = 'Pot do psql';
$string['pathtopsqldesc'] = 'To je potrebno vnesti samo, če imate na vašem strežniku več kot en psql (na primer, če imate nameščeno več kot eno različico postgresql)';
$string['pathtopsqlinvalid'] = 'Neveljavna pot do psql - bodisi napačna pot ali pa se ne more izvesti';
$string['pathtopython'] = 'Pot do Pythona';
$string['pathtopythondesc'] = 'Pot do vašega izvršljivega binarnega sistema Python (tako Python 2 kot Python 3 sta sprejemljiva).';
$string['pathtosassc'] = 'Pot do SassC';
$string['pathtosassc_help'] = 'Z navajanjem lokacije binarnega sistema SassC bo prevajalnik SASS prešel iz implementacije PHP Moodle na SassC. Za več informacij si oglejte https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'Močno priporočamo, da uporabite razširitev PCRE PHP, ki je združljiva z znaki Unicode.';
$string['perfdebug'] = 'Podatki o zmogljivosti';
$string['performance'] = 'Zmogljivost';
$string['pgcluster'] = 'PostgreSQL gruča';
$string['pgclusterdescription'] = 'Parameter različica/gruča PostgreSQL za dejanja ukazne vrstice. Če imate samo en postgresql na vašem strežniku ali če niste prepričani, kaj je to, pustite to prazno.';
$string['phpfloatproblem'] = 'Pri obravnavi števil PHP s plavajočo vejico {$a} je zaznana nepričakovana težava';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Vaše spletno mesto je bilo registrirano. Ročno lahko kadarkoli obnovite registracijo. Privzeto bo načrtovana naloga \'Registracija strani\' sporti obnavljala vašo registracijo. Registracija zadnjič posodobljena pred: {$a}.<br />';
$string['pleaserefreshregistrationnewdata'] = 'Registracijske informacije so bile spremenjene. Prosim, potrdite s pritiskom na gumb »Posodobi registracijo«.';
$string['pleaserefreshregistrationunknown'] = 'Vaše spletno mesto je bilo registrirano, toda datum registracije je neznan. Prosimo, posodobite vašo registracijo s pritiskom na tipko »Posodobi registracijo« ali pa poskrbite, da je načrtovana naloga »Registracija spletnega mesta« omogočena, s čimer se vaša registracija posodobi avtomatsko.';
$string['plugin'] = 'Vtičnik';
$string['plugins'] = 'Vtičniki';
$string['pluginscheck'] = 'Preverjanje odvisnosti vtičnikov';
$string['pluginscheckfailed'] = 'Preverjanje odvisnosti je spodletelo za {$a->pluginslist}';
$string['pluginschecktodo'] = 'Pred nadaljevanjem namestitve te različice Moodla morate razrešiti vse zahteve vtičnikov.';
$string['pluginsoverview'] = 'Pregled vtičnikov';
$string['pluginsoverviewsee'] = 'Za več podrobnosti glejte <a href="{$a->url}">pregled vtičnikov</a>.';
$string['policysettings'] = 'Nastavitve politike';
$string['privacy:metadata'] = 'Ta Skrbniški vtičnik ne hrani nobenih osebnih podatkov.';
$string['privacyandpolicies'] = 'Politika zasebnosti';
$string['privacysettings'] = 'Nastavitve zasebnosti';
$string['profilecategory'] = 'Kategorija';
$string['profilecategoryname'] = 'Ime kategorije (biti mora edinstveno)';
$string['profilecategorynamenotunique'] = 'Ime kategorije je že v uporabi';
$string['profilecommonsettings'] = 'Skupne nastavitve';
$string['profileconfirmcategorydeletion'] = 'V tej kategoriji je {$a} polj, ki bodo premaknjena v zgornjo kategorijo (ali v spodnjo, če so polja v najvišji kategoriji).<br />Ali ste prepričani, da želite izbrisati to kategorijo?';
$string['profileconfirmfielddeletion'] = 'V tem polju je {$a} uporabniških zapisov, ki bodo izbrisani.<br />Ali ste prepričani, da želite izbrisati to polje?';
$string['profilecreatecategory'] = 'Ustvari novo kategorijo profila';
$string['profilecreatefield'] = 'Ustvari novo polje profila';
$string['profilecreatenewcategory'] = 'Ustvarjanje nove kategorije';
$string['profilecreatenewfield'] = 'Ustvarjanje novega \'{$a}\' polja profila';
$string['profiledefaultcategory'] = 'Druga polja';
$string['profiledefaultchecked'] = 'Privzeto preverjanje';
$string['profiledefaultdata'] = 'Privzeta vrednost';
$string['profiledeletecategory'] = 'Brisanje kategorije';
$string['profiledeletefield'] = 'Brisanje polja \'{$a}\'';
$string['profiledescription'] = 'Opis polja';
$string['profiledscript'] = 'Ta skript je bil profiliran';
$string['profiledscriptview'] = 'Ogled profilirane informacije za ta skript';
$string['profileeditcategory'] = 'Urejanje kategorije: {$a}';
$string['profileeditfield'] = 'Urejanje polja profila: {$a}';
$string['profilefield'] = 'Polje profila';
$string['profilefieldcolumns'] = 'Stolpci';
$string['profilefieldispassword'] = 'Je to polje za geslo?';
$string['profilefieldlink'] = 'Povezava';
$string['profilefieldlink_help'] = 'Za preoblikovanje besedila v povezavo, vnesite URL, ki vsebuje $$, kjer bo $$ zamenjano z besedilom. Na primer, za preoblikovanje Twitter ID-ja v povezavo, vnesite http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Cilj povezave';
$string['profilefieldmaxlength'] = 'Največja dolžina';
$string['profilefieldrows'] = 'Vrstice';
$string['profilefields'] = 'Polja profila uporabnika';
$string['profilefieldsize'] = 'Velikost prikaza';
$string['profileforceunique'] = 'Ali naj bodo podatki edinstveni?';
$string['profileinvaliddata'] = 'Neveljavna vrednost';
$string['profilelocked'] = 'Ali je to polje zaklenjeno?';
$string['profilemenudefaultnotinoptions'] = 'Privzeta vrednost ni ena izmed možnosti';
$string['profilemenunooptions'] = 'Ni ponujenih možnosti za meni';
$string['profilemenuoptions'] = 'Možnosti menija (vsak v svojo vrstico)';
$string['profilemenutoofewoptions'] = 'Ponuditi morate vsaj 2 možnosti';
$string['profilename'] = 'Ime';
$string['profilenofieldsdefined'] = 'Ni bilo opredeljenih polj';
$string['profilerequired'] = 'Ali je to polje zahtevano?';
$string['profileroles'] = 'Vidne vloge profila';
$string['profilesforenrolledusersonly'] = 'Profili samo za vpisane uporabnike';
$string['profileshortname'] = 'Kratko ime (biti mora edinstveno)';
$string['profileshortnameinvalid'] = 'To kratko ime lahko vsebuje le alfanumerične znake (črke in števila) ali podčrtaj (_).';
$string['profileshortnamenotunique'] = 'To kratko ime je že v uporabi';
$string['profilesignup'] = 'Prikaži na strani za prijavo?';
$string['profilespecificsettings'] = 'Posebne nastavitve';
$string['profilevisible'] = 'Kdo lahko vidi to polje?';
$string['profilevisible_help'] = 'Vsakemu izmed polj po meri lahko določite eno izmed treh nastavitev vidnosti: Nevidno, Vidno vsem in Vidno uporabniku. Nastavitev \'Nevidno\' bo ponavadi uporabil skrbnik, ki želi imeti zasebne podatke o uporabniku. Nastavitev \'Vidno uporabniku\' bo ponavadi izbrana za polje, ki vsebuje občutljive informacije, medtem ko je nastavitev \'Vidno vsem\' moč uporabiti za katerokoli vrsto informacije.';
$string['profilevisibleall'] = 'Vidno vsem';
$string['profilevisiblenone'] = 'Nevidno';
$string['profilevisibleprivate'] = 'Vidno uporabniku';
$string['profiling'] = 'Profiliranje';
$string['profilingallowall'] = 'Neprekinjeno profiliranje';
$string['profilingallowall_help'] = 'Ta nastavitev omogoča, da lahko nato kadarkoli uporabite parameter PROFILEALL kjerkoli (PGC), da omogočite profiliranje za vse izvedene skripte med Moodlovo sejo. Analogno lahko uporabite parameter PROFILEALLSTOP za preklic.';
$string['profilingallowme'] = 'Selektivno profiliranje';
$string['profilingallowme_help'] = 'Ta nastavitev omogoča, da lahko selektivno uporabite parameter PROFILIRAJME kjerkoli (PGC) in izvedlo se bo profiliranje tega skripta. Analogno lahko uporabite parameter NEPROFILIRAJ, da preprečite profiliranje';
$string['profilingautofrec'] = 'Samodejno profiliranje';
$string['profilingautofrec_help'] = 'S konfiguracijo te nastavitve, bodo izbrane in samodejno profilirane nekatere zahteve (naključne, ki temeljijo na pogostnosti, določeni - 1 od N), pri tem pa se bodo shranili rezultati za nadaljnje analize. Ta način profiliranja upošteva nastavitve vključi/izključi. Nastavite na 0, da onemogočite samodejno profiliranje.';
$string['profilingenabled'] = 'Omogoči profiliranje';
$string['profilingenabled_help'] = 'Ta nastavitev omogoča, da bo na voljo profiliranje na tem spletnem mestu in lahko boste opredelili njegovo vedenje s konfiguracijo naslednjih možnosti.';
$string['profilingexcluded'] = 'Izključi profiliranje';
$string['profilingexcluded_help'] = 'Seznam (z vejico ločeni, absolutno preskakovanje wwwroot, zavijalnik) URL-jev, ki bodo izključeni iz profiliranja tistih, ki so opredeljeni v nastavitvah pod Profiliraj te.';
$string['profilingimportprefix'] = 'Predpona uvoza profiliranja';
$string['profilingimportprefix_desc'] = 'Za lažje zaznavanje bodo vse uvožena izvajanja profilirana imela v predponi vrednost, ki je določena tu.';
$string['profilingincluded'] = 'Profiliraj te';
$string['profilingincluded_help'] = 'Seznam (z vejico ločeni, absolutno preskakovanje wwwroot, zavijalnik) URL-jev, ki bodo samodejno profilirani. Primeri: /index.php, /course/view.php. Sprejema tudi nadomestni znak * na kateri koli poziciji. Primeri: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Obdrži izvajanja profiliranja';
$string['profilinglifetime_help'] = 'Določi časovni okvir, v katerem želite hraniti podatke o starih izvajanjih profiliranja. Starejši bodo bili občasno oklesteni. To izključuje kakršnokoli izvajanje profiliranja, označeno kot \'referenčno izvajanje\'.';
$string['profilingslow'] = 'Profiliraj počasne strani';
$string['profilingslow_help'] = 'Z nastavitvijo minimalnega časa v sekundah bodo vse počasnejše strani profilirane. Ohranjeni bodo samo profili, ki so počasnejši od obstoječega profila z istim skriptom. Nastavitev onemogočite tako, da vrednost nastavite na 0. To upošteva nastavitev ‚izključi‘.';
$string['protectusernames'] = 'Zaščiti uporabniška imena';
$string['proxybypass'] = 'Posredovalni premostitveni strežnik gostiteljev';
$string['proxyhost'] = 'Posredovalni strežnik gostitelj';
$string['proxypassword'] = 'Geslo posredovalnega strežnika';
$string['proxyport'] = 'Vrata posredovalnega strežnika';
$string['proxytype'] = 'Tip posredovalnega strežnika';
$string['proxyuser'] = 'Uporabniško ime posredovalnega strežnika';
$string['purgecaches'] = 'Počisti vse predpomnilnike';
$string['purgecachesconfirm'] = 'Moodle lahko predpomni teme, JavaScript, jezikovne nize, filtrirana besedila, vire RSS in mnoge druge primerke preračunanih podatkov. Čiščenje teh predpomnilnikov bo izbrisalo te podatke iz strežnika in prisililo brskalnike, da ponovno pridobijo podatke, tako da ste lahko prepričani, da vidite najbolj sveže vrednosti, ki jih proizvaja trenutna koda. Čiščenje predpomnilnikov ni nevarno. Vaše spletno mesto bo morda nekaj časa delovalo počasneje, dokler strežnik in odjemalci ne preračunajo novih informacij in jih predpomnijo.';
$string['purgecachesfinished'] = 'Vsi predpomnilniki so počiščeni.';
$string['purgecachesnoneselected'] = 'Izberite enega ali več predpomnilnikov za očiščenje';
$string['purgecachespage'] = 'Počisti predpomnilnik';
$string['purgefiltercache'] = 'Besedilni filtri';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Jezikovni nizi';
$string['purgemuc'] = 'Vsi predpomnilniki MUC';
$string['purgeothercaches'] = 'Vsi datotečni in razni predpomnilniki';
$string['purgeselectedcaches'] = 'Počisti izbrane predpomnilnike';
$string['purgeselectedcachesfinished'] = 'Izbrani predpomnilniki so bili očiščeni.';
$string['purgetemplates'] = 'Predloge';
$string['purgethemecache'] = 'Teme';
$string['query'] = 'Poizvedba';
$string['question'] = 'Vprašanje';
$string['questionbehaviours'] = 'Vedenja vprašanj';
$string['questioncwqpfscheck'] = 'Eno ali več \'naključnih\' vprašanj v kvizu je nastavljenih za izbiro vprašanj iz nabora kategorij vprašanj z različnim statusom skupne rabe. Podrobnejše poročilo lahko najdete <a href="{$a->reporturl}">tukaj</a> in si ogledate stran v Moodlovi dokumentaciji <a href="{$a->docsurl}">tukaj</a>.';
$string['questioncwqpfsok'] = 'Dobro. V vaših kvizih ni \'naključnih\' vprašanj, ki bi izbirala iz nabora objavljenih in ne objavljenih kategorij vprašanj.';
$string['questiontype'] = 'Tip vprašanja';
$string['questiontypes'] = 'Tipi vprašanj';
$string['quizattemptsupgradedmessage'] = 'V Moodle različici 2.1 je bila večja nadgradnja vprašanj. Možno je bilo zakasniti dele nadgradnje podatkovne baze, da se zaženejo kasneje. Pred nadgradnjo v različico Moodle 2.7, mora biti dokončana ta nadgradnja.';
$string['recaptchaprivatekey'] = 'Skrivni ključ ReCAPTCHA';
$string['recaptchapublickey'] = 'Ključ spletnega mesta ReCAPTCHA';
$string['referrernone'] = 'Prevzete nastavitve brskalnika';
$string['referrerpolicy'] = 'Politika o napotitelju';
$string['referrerpolicydesc'] = 'Glavo politike napotitelja nastavite tako, da bo vključena v odgovorih iz vašega spletnega mesta.';
$string['register'] = 'Registrirajte svoje spletno mesto';
$string['registration'] = 'Registracija';
$string['registration_help'] = 'Priporočeno je, da registrirate vaše spletno mesto, da bi prejeli varnostna obvestila in dostop do Moodle.net, naše spletne platforme.';
$string['registrationwarning'] = 'Vaše spletno mesto še ni registrirano.';
$string['registrationwarningcontactadmin'] = 'Vaše spletno mesto še ni registrirano. Prosimo opozorite skrbnika vašega spletnega mesta.';
$string['releasenoteslink'] = 'Za informacije o tej različici Moodla si oglejte spletne <a target="_blank" href="{$a}">Opombe o različici</a>';
$string['rememberuserlicensepref'] = 'Zapomni si nastavitve uporabnikovih licenc';
$string['rememberuserlicensepref_help'] = 'Če je omogočeno, je zadnja licenca, ki jo izbere uporabnik, vnaprej izbrana, ko je na izbirnik datotek naložena datoteka. Drugače je vnaprej izbrana privzeta licenca spletnega mesta.';
$string['rememberusername'] = 'Zapomni si uporabniško ime';
$string['rememberusername_desc'] = 'Omogočite, če želite shraniti trajne piškotke z uporabniški imeni med prijavo uporabnika. Trajni piškotki lahko ogrozijo zasebnost, če se uporabljajo brez privolitve.';
$string['reportsmanage'] = 'Upravljaj poročila';
$string['required'] = 'Zahtevano';
$string['requiredentrieschanged'] = '<strong>POMEMBNO - PROSIMO PREBERITE<br/>(To opozorilo bo prikazano samo ob tej nadgradnji)</strong><br/>Zaradi popravka hrošča bo spremenjeno vedenje aktivnosti zbirk podatkov, ki uporabljajo nastavitev Zahtevani vnosi in Zahtevani vnosi pred ogledom. Bolj podrobno razlago lahko preberete na <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forumu modula podatkovne baze</a>. Pričakovano vedenje teh nastavitev lahko preberete tudi v <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle dokumentaciji</a>.
<br/><br/>Te spremembe vplivajo na sledeče zbirke podatkov na vašem sistemu: (Prosimo, da takoj shranite ta seznam in po nadgradnji preverite, če te aktivnosti še delujejo tako, kot si je zamislil učitelj.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Zahtevaj opis dejavnosti';
$string['requiremodintro_desc'] = 'Če je omogočeno, bodo uporabniki morali vnesti opis za vsako dejavnost.';
$string['requires'] = 'Zahteve';
$string['restorecourse'] = 'Obnovi predmet';
$string['restorernewroleid'] = 'Vloga obnovitve v predmetu';
$string['restorernewroleid_help'] = 'Če uporabnik še nima dovoljenja za upravljanje na novo obnovljenega predmeta, je uporabnik samodejno dodeljena ta vloga. Izberite »Noben«, če ne želite, da obnovitelji upravljajo vsak obnovljen predmet.';
$string['resultfilter'] = 'Filtriraj po rezultatih';
$string['reverseproxy'] = 'Obratni posredovalni strežnik';
$string['reverseproxyignore'] = 'Prezri posredniške strežnike';
$string['riskconfig'] = 'Uporabniki bi lahko spremenili konfiguracijo in vedenje spletnega mesta';
$string['riskconfigshort'] = 'Tveganje glede konfiguracije';
$string['riskdataloss'] = 'Uporabniki lahko uničijo veliko količino vsebine ali informacij';
$string['riskdatalossshort'] = 'Tveganje izgube podatkov';
$string['riskmanagetrust'] = 'Uporabniki bi lahko spremenili nastavitve zaupanja pri drugih uporabnikih';
$string['riskmanagetrustshort'] = 'Upravljanje zaupanja';
$string['riskpersonal'] = 'Uporabniki bi lahko dobili dostop do zasebnih informacij drugih uporabnikov';
$string['riskpersonalshort'] = 'Tveganje glede zasebnosti';
$string['riskspam'] = 'Uporabniki bi lahko drugim uporabnikom spletnega mesta ali drugim uporabnikom pošiljali neželeno vsebino.';
$string['riskspamshort'] = 'Tveganje neželene vsebine';
$string['riskxss'] = 'Uporabniki lahko dodajajo datoteke in besedila, ki dovoljujejo izvajanje skriptov na drugih strežnikih (XSS)';
$string['riskxssshort'] = 'Tveganje XSS';
$string['roleswithexceptions'] = '{$a->roles}, z {$a->exceptions}';
$string['rssglobaldisabled'] = 'Onemogočeno na ravni spletnega mesta';
$string['save'] = 'Shrani';
$string['savechanges'] = 'Shrani spremembe';
$string['scssinvalid'] = 'SCSS koda ni veljavna, konča se z: {$a}';
$string['search'] = 'Išči';
$string['searchablecourses'] = 'Predmeti, ki jih lahko iščete';
$string['searchallavailablecourses'] = 'Predmeti, ki jih lahko iščete';
$string['searchallavailablecourses_desc'] = 'V nekaterih primerih iskalnik ne bo deloval pravilno, ko se išče med velikim številom predmetov. Če potrebujete omejiti spekter iskanja, nastavite iskanje samo med vpisanimi predmeti.';
$string['searchallavailablecourses_off'] = 'Išči samo po vpisanih predmetih';
$string['searchallavailablecourses_on'] = 'Išči po vseh predmetih, dostopnih uporabniku';
$string['searchallavailablecoursesdesc'] = 'Če je nastavljeno na iskanje znotraj predmetov, v katere ste vpisani, bo iskanje po podatkih o predmetu (ime in povzetek) in vsebini predmeta potekalo le pri predmetih, v katere je uporabnik vpisan. Drugače bo iskanje po podatkih o predmetu in vsebini predmeta potekalo pri vseh predmetih, do katerih uporabnik lahko dostopa, na primer pri predmetih, ki imajo omogočen gostujoči dostop.';
$string['searchalldeleted'] = 'Vse vsebine v kazalu so bile izbrisane';
$string['searchalternatesettings'] = 'Izmeniče nastavitve samo s poizvedbo';
$string['searchalternatesettings_desc'] = 'Če dokončate te nastavitve, lahko z možnostjo iskalnika samo s poizvedbo na strani \'Upravljaj globalno iskanje‘ za ta iskalnik izberete \'izmenične nastavitve‘. To je uporabno le, če se premikate med dvema iskalnikoma istega tipa.';
$string['searchareadisabled'] = 'Območje iskanja onemogočeno';
$string['searchareaenabled'] = 'Območje iskanja omogočeno';
$string['searchareas'] = 'Območja iskanja';
$string['searchbanner'] = 'Podatki o iskanju';
$string['searchbannerenable'] = 'Prikaži podatke o iskanju';
$string['searchbannerenable_desc'] = 'Če je omogočeno, bo besedilo spodaj za vse uporabnike prikazano na vrhu iskalnega zaslona. To lahko uporabite, če želite uporabnike obvestiti, ko poteka vzdrževanje iskalnika.';
$string['searchdefaultcategory'] = 'Privzeta kategorija iskanja';
$string['searchdefaultcategory_desc'] = 'Rezultati izbrane kategorije območja iskanja bodo samodejno prikazani.';
$string['searchdeleteindex'] = 'Izbriši vse vsebine v kazalu';
$string['searchdisplay'] = 'Možnosti prikaza rezultatov iskanja';
$string['searchenablecategories'] = 'Prikaži rezulate v ločenih kategorijah';
$string['searchenablecategories_desc'] = 'Če je omogočeno, bodo rezultati iskanja prikazani v ločenih kategorijah.';
$string['searchengine'] = 'Iskalnik';
$string['searchenginealternatesettings'] = '{$a} (izmenične nastavitve)';
$string['searchenginequeryonly'] = 'Iskalnik samo s poizvedbo';
$string['searchenginequeryonly_desc'] = 'Ta iskalnik bo uporabljen zgolj za poizvedovanje, ne pa za vpisovanje v kazalo. Z uporabo te funkcije lahko ponovno vpišete v kazalo v drugih iskalnikih, medtem ko na tem uporabniško poizvedovanje še vedno deluje.';
$string['searchenginequeryonly_none'] = 'Brez (za poizvedbe uporabi glavni iskalnik)';
$string['searchenginequeryonlysame'] = 'Iskalnik samo s poizvedbo ter glavni iskalnik ne moreta biti nastavljena na isto vrednost.';
$string['searchhideallcategory'] = 'Skrij kategorijo Vsi rezultati';
$string['searchhideallcategory_desc'] = 'Če je obkljukano, bo kategorija z vsemi rezulatati na zaslonu z rezultati iskanja skrita.';
$string['searchincludeallcourses'] = 'Vključi vse vidne predmete';
$string['searchincludeallcourses_desc'] = 'Če je omogočeno, bodo rezultati iskanja vsebovali tudi podatke (ime in povzetek) o tistih predmetih, ki so uporabniku vidni, tudi če nimajo dostopa do vsebine predmeta.';
$string['searchindexactions'] = 'Ukaze vpisuj v kazalo';
$string['searchindexdeleted'] = 'Kazalo je izbrisano';
$string['searchindextime'] = 'Časovna omejitev vpisovanja v kazalo';
$string['searchindextime_desc'] = 'Ob vpisovanju velike količine vsebin v kazalo se bo načrtovana naloga ustavila, ko je ta časovna omejitev dosežena. Naloga se bo nadaljevala naslednjič, ko se zažene.';
$string['searchindexupdated'] = 'Vsebine iskalnika so bile posodobljene';
$string['searchindexwhendisabled'] = 'Vpiši v kazalo, ko je onemogočeno';
$string['searchindexwhendisabled_desc'] = 'Načrtovani nalogi omogoča izdelavo kazala iskanja, tudi če je iskanje onemogočeno. To je uporabno, če želite kazalo zgraditi, preden se udeležencem prikaže iskalnik.';
$string['searchinsettings'] = 'Išči po nastavitvah';
$string['searchlastrun'] = 'Zadnji zagon (čas, # dokumenti, # zapisi, # ignoriranje)';
$string['searchmanagement'] = 'Upravljanje iskanja';
$string['searchmanagement_desc'] = 'Te možnosti so uporabne, ko izvajate spremembe na spletnih mestih z velikimi kazali iskanja, ki za obnovo potrebujejo veliko časa.';
$string['searchnotavailable'] = 'Iskanje ni na voljo';
$string['searchoptions'] = 'Možnosti iskanja';
$string['searchpartial'] = '(ni še dokončno vpisano v kazalo)';
$string['searchreindexed'] = 'Vse vsebine spletnega mesta so bile ponovno vpisane v kazalo.';
$string['searchreindexindex'] = 'Vso vsebino spletnega mesta ponovno vpiši v kazalo';
$string['searchresults'] = 'Rezultati iskanja';
$string['searchsetupinfo'] = 'Nastavitev iskanja';
$string['searchupdateindex'] = 'Posodobi vsebino v kazalu';
$string['sectionerror'] = 'Področna napaka!';
$string['secureforms'] = 'Uporabi dodatno obliko varovanja';
$string['security'] = 'Varnost';
$string['selectdevice'] = 'Izberi napravo';
$string['selectsearchengine'] = 'Izberite iskalnik';
$string['selecttheme'] = 'Izberi temo za {$a} napravo';
$string['server'] = 'Strežnik';
$string['serverchecks'] = 'Kontrole strežnika';
$string['serverlimit'] = 'Omejitev na strežniku';
$string['sessionautostartwarning'] = '<p>Med konfiguracijo je prišlo do hude napake. Opozorite skrbnika strežnika.</p><p> Za pravilno delovanje Moodle zahteva, da skrbnik spremeni nastavitve PHP.</p><p><code>session.auto_start</code> mora biti nastavljena na <code>off</code>.</p><p>To se nastavi v <code>php.ini</code>, v nastavitvah Apache/IIS <br /> ali v datoteki <code>.htaccess</code> na strežniku.</p>';
$string['sessioncookie'] = 'Predpona za piškotke';
$string['sessioncookiedomain'] = 'Domena piškotkov';
$string['sessioncookiepath'] = 'Pot za piškotke';
$string['sessionhandling'] = 'Upravljanje seje';
$string['sessiontimeout'] = 'Časovna omejitev';
$string['settingdependenton'] = 'Ta nastavitev je lahko skrita glede na vrednost <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Za normalno delovanje je potrebna možnost nalaganja datotek. Omogočite jo v konfiguraciji PHP.';
$string['settingmemorylimit'] = 'Nezadostna količina pomnilnika. Prosimo, nastavite višjo mejo pomnilnika v nastavitvah PHP.';
$string['settingsafemode'] = 'Moodle ni popolno združljiv z varnim načinom. Prosite skrbnika strežnika, da ta način izklopi. Delovanje Moodla v varnem načinu ni podprto. Pričakujte raznovrstne težave, če ga boste uporabljali v tem načinu.';
$string['setupsearchengine'] = 'Nastavi iskalnik';
$string['showcommentscount'] = 'Prikaži števec komentarjev';
$string['showdetails'] = 'Prikaži podrobnosti';
$string['showuseridentity'] = 'Prikaži uporabniško identiteto';
$string['showuseridentity_desc'] = 'Pri izbiranju in iskanju uporabnikov in pri prikazu seznama uporabnikov so lahko ta polja prikazana dodatno k njihovemu celotnemu imenu. Ta polja vidijo samo tisti uporabniki, ki imajo omogočeno zmožnost moodle/site:viewuseridentity. Privzeto imajo to omogočeno učitelji in upravljavci. (Ta možnost je najbolj smiselna, če izberete eno ali dve polji, ki sta obvezni v vaši organizaciji.)';
$string['simplexmlrequired'] = 'Moodle zahteva razširitev SimpleXML PHP.';
$string['sitemailcharset'] = 'Nabor znakov';
$string['sitemaintenance'] = 'Na tem spletnem mestu ravnokar poteka vzdrževanje, zato trenutno ni na voljo';
$string['sitemaintenancemode'] = 'Vzdrževalni način';
$string['sitemaintenanceoff'] = 'Vzdrževalni način je bil onemogočen in spletno mesto znova normalno deluje';
$string['sitemaintenanceon'] = 'Vaša spletna stran je trenutno v vzdrževalnem načinu (samo skrbniki se lahko prijavijo ali uporabljajo stran).';
$string['sitemaintenanceoncli'] = 'Vaše spletno mesto je trenutno v vzdrževalnem načinu CLI, zato spletni dostop ni dovoljen.';
$string['sitemaintenancetitle'] = '{$a} v vzdrževanju';
$string['sitemaintenancewarning'] = 'Vaša spletna stran je trenutno v vzdrževalnem načinu (samo skrbniki se lahko prijavijo). Za vrnitev strani v normalno delovanje, <a href="maintenance.php">onemogočite vzdrževalni način</a>.';
$string['sitemaintenancewarning2'] = 'Vaše spletno mesto je trenutno v vzdrževalnem načinu (samo skrbniki se lahko prijavijo). Za vrnitev tega spletnega mesta v normalno delovanje, <a href="{$a}">disable maintenance mode</a>.';
$string['sitemenubar'] = 'Navigacija po spletnem mestu';
$string['sitepolicies'] = 'Varnostna politika spletnega mesta';
$string['sitepolicy'] = 'URL varnostne politike spletnega mesta';
$string['sitepolicy_help'] = 'Če ima spletno mesto politiko, ki jih morajo vsi uporabniki videti in se z njimi strinjati pred uporabo tega spletnega mesta, potem tu navedite URL teh pravil, ali pustite polje prazno. URL lahko kaže kamorkoli – primerno mesto bi bila datoteka med datotekami spletnega mesta. Npr. http://spletninaslov/file.php/1/pravila.html.';
$string['sitepolicyguest'] = 'URL varnostne politike spletnega mesta za goste';
$string['sitepolicyguest_help'] = 'Če imate varnostno politiko, ki jo morajo videti vsi gosti in se z njo strinjati pred uporabo tega spletnega mesta, potem tu navedite URL, v nasprotnem primeru pustite to polje prazno. Ta nastavitev lahko vsebuje katerikoli javni URL. Opozorilo: Dostop nevpisanih uporabnikov se lahko prepreči s prisiljeno vpisanimi nastavitvami.';
$string['sitepolicyhandler'] = 'Vodnik politike spletnega mesta';
$string['sitepolicyhandler_desc'] = 'To določa, kako se upravlja s politiko in uporabniškimi privolitvami. Privzeti (jedrni) vodnik omogoča, da se nastavita URL za politiko spletnega mesta in URL za politiko spletišča za goste. Vodnik politike omogoča vzpostavitev politike za spletno mesto, zasebnost in druge politike. Omogoča tudi pregled uporabniških privolitev in po potrebi dajanje privolitve za mladoletne v njihovem imenu.';
$string['sitepolicyhandlercore'] = 'Privzeti (jedrni)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Če izberete to možnost, bo na naslovni strani spletnega mesta prikazan odsek s temami.';
$string['sixtyfourbitswarning'] = 'Ugotovljeno je bilo, da vaše spletno mesto ne uporablja 64-bitne različice PHP. Priporočeno je, da nadgradite vaše spletno mesto za zagotovitev združljivosti v prihodnje.';
$string['slasharguments'] = 'Uporabi parametre s poševnico';
$string['slashargumentswarning'] = 'Priporočljivo je, da je raba parametrov s poševnico omogočena. V prihodnosti bo raba zahtevana. Za več podrobnosti glejte dokumentacijo <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smartpix'] = 'Pametno iskanje slik';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Overitveni tip SMTP';
$string['smtpdetail'] = 'Nastavitve protokola Simple Mail Transfer Protocol (SMTP) za pošiljanje e-pošte.';
$string['smtphosts'] = 'SMTP gostitelji';
$string['smtpmaxbulk'] = 'Omejitev SMTP seje';
$string['smtppass'] = 'SMTP geslo';
$string['smtpsecure'] = 'Varnost SMTP';
$string['smtpuser'] = 'SMTP uporabniško ime';
$string['soaprecommended'] = 'Namestitev neobvezne razširitve SOAP je uporabna za spletne storitve in nekatere vtičnike.';
$string['sort_fullname'] = 'Polno ime predmeta';
$string['sort_idnumber'] = 'ID številka predmeta';
$string['sort_shortname'] = 'Kratko ime predmeta';
$string['sort_sortorder'] = 'Vrstni red';
$string['spellengine'] = 'Orodje za črkovanje';
$string['spelllanguagelist'] = 'Seznam jezikov za črkovanje';
$string['splrequired'] = 'Moodle zahteva SPL PHP razširitev.';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Najdaljši interval obdelave';
$string['statsmaxruntime'] = 'Najdaljši čas delovanja';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Število dni za obdelavo';
$string['statsruntimestart'] = 'Zagnano ob';
$string['statsuserthreshold'] = 'Prag uporabnikov';
$string['stickyblocks'] = 'Zasidrani bloki';
$string['stickyblockscourseview'] = 'Stran predmeta';
$string['stickyblocksduplicatenotice'] = 'Če je katerikoli blok, ki ga tu dodate, že prisoten na določeni strani, se bo podvojil.<br />Samo pripetega bloka ne bo možno urejati, dvojnik pa bo še vedno možno urejati.';
$string['stickyblocksmymoodle'] = 'Moj dom';
$string['stickyblockspagetype'] = 'Tip strani za konfiguracijo';
$string['strictformsrequired'] = 'Natančno potrjevanje veljavnosti zahtevanih polj';
$string['stripalltitletags'] = 'Odstrani oznake HTML iz vseh imen dejavnosti';
$string['supportcontact'] = 'Kontakt za podporo';
$string['supportemail'] = 'E-poštni naslov za podporo';
$string['supportname'] = 'Ime podpore';
$string['supportpage'] = 'Stran podpore';
$string['suspenduser'] = 'Začasno onemogoči uporabniški račun';
$string['switchlang'] = 'Zamenjaj jezikovni imenik';
$string['systempaths'] = 'Pot do sistema';
$string['tablenosave'] = 'Spremembe v zgornji tabeli so shranjene samodejno.';
$string['tablesnosave'] = 'Spremembe v zgornjih tabelah so samodejno shranjene.';
$string['tabselectedtofront'] = 'V tabelah z zavihki prikaži spredaj vrstico s trenutno izbranim zavihkom';
$string['tabselectedtofronttext'] = 'Prikaži izbrani zavihek vrstice spredaj';
$string['task_adhoc_concurrency_limit'] = 'Omejitev sočasnega izvajanja priložnostnih nalog';
$string['task_adhoc_concurrency_limit_desc'] = 'Število priložnostnih izvajalnikov nalog, ki se lahko izvajajo sočasno. Če je omejitev visoka, načrtovane naloge morda ne bodo izvajane redno, če obstaja veliko priložnostnih nalog. Nastavitev na 0 bo popolnoma onemogočila obdelavo namenskih nalog.';
$string['task_adhoc_max_runtime'] = 'Življenjska doba priložnostnega izvajalnika nalog';
$string['task_adhoc_max_runtime_desc'] = 'Starost priložnostnega izvajalnika nalog, preden se sprosti. Priporočeno je kratko trajanje, ker ni omejitve števila priložnostnih nalog, ki so na vrsti. Če je ta številka prevelika in imate dolgo vrsto priložnostnih nalog, načrtovane naloge morda ne bodo izvedene redno.';
$string['task_dbstats'] = 'Podatkovna baza';
$string['task_duration'] = 'Trajanje';
$string['task_logmode'] = 'Kdaj zabeležiti v dnevnik';
$string['task_logmode_all'] = 'Shrani sporočila dnevnikov vseh opravil';
$string['task_logmode_desc'] = 'Izberete lahko, če želite beleženje nalog v dnevnik. Dnevniki so privzeto vedno zajeti. Beleženje lahko popolnoma onemogočite ali ga spremenite, da se beležijo samo neuspele naloge.';
$string['task_logmode_failonly'] = 'Shrani le dnevnike za neuspele naloge';
$string['task_logmode_none'] = 'Ničesar ne zabeleži v dnevnik';
$string['task_logretainruns'] = 'Ohrani izvedbe';
$string['task_logretainruns_desc'] = 'Število izvedb vsake naloge, ki naj se ohranijo. Ta nastavitev je povezana z nastavitvijo ‚Obdobje ohranitve‘: tista, ki jo izvedete najprej, bo uporabljena.';
$string['task_logretention'] = 'Čas hranjenja';
$string['task_logretention_desc'] = 'Najdaljše obdobje, za katero so dnevniki shranjeni. Ta nastavitev je povezana z nastavitvijo ‚Ohrani dnevnike‘: tista, ki jo izvedete najprej, bo uporabljena';
$string['task_logtostdout'] = 'Prikaži izhodne podatke dnevnika';
$string['task_logtostdout_desc'] = 'Ko opravila potekajo in so izhodni podatki zajeti, ali naj bodo zajeti izhodni podatki tudi prikazani kot izvajanje nalog.';
$string['task_result'] = 'Rezultat';
$string['task_result:failed'] = 'Neuspešno';
$string['task_scheduled_concurrency_limit'] = 'Načrtovana omejitev sočasnosti nalog';
$string['task_scheduled_concurrency_limit_desc'] = 'Število načrtovanih izvajalnikov nalog, ki se lahko izvajajo sočasno. Če je omejitev visoka, načrtovane naloge morda ne bodo izvajane redno, v primerih ko obstaja veliko namenskih nalog. Nastavitev na 0 bo popolnoma onemogočila obdelavo namenskih nalog.';
$string['task_scheduled_max_runtime'] = 'Načrtovana življenjska doba izvajalnika nalog';
$string['task_scheduled_max_runtime_desc'] = 'Starost načrtovanega izvajalnika nalog, preden se sprosti.';
$string['task_starttime'] = 'Čas začetka';
$string['task_stats:dbreads'] = '{$a} bere';
$string['task_stats:dbwrites'] = '{$a} piše';
$string['task_type:adhoc'] = 'Priložnostno';
$string['task_type:scheduled'] = 'Načrtovan';
$string['taskadmintitle'] = 'Naloge';
$string['taskanalyticscleanup'] = 'Čiščenje analitike';
$string['taskautomatedbackup'] = 'Samodejne varnostne kopije';
$string['taskbackupcleanup'] = 'Počisti varnostne kopije tabel, dnevnikov in datotek';
$string['taskbadgescron'] = 'Podeli značke';
$string['taskbadgesmessagecron'] = 'Obdelava v ozadju za pošiljanje obvestil o značkah';
$string['taskblogcron'] = 'Sinhroniziraj zunanje bloge';
$string['taskcachecleanup'] = 'Odstrani potekle predpomnilniške vnose';
$string['taskcachecron'] = 'Obdelava v ozadju za predpomnilnike';
$string['taskcalendarcron'] = 'Pošlji obvestila na koledarju';
$string['taskcheckforupdates'] = 'Preveri posodobitve';
$string['taskcompletiondaily'] = 'Zaključevanje označeno kot pričeto';
$string['taskcompletionregular'] = 'Izračunaj redne podatke zaključevanja';
$string['taskcontextcleanup'] = 'Počisti kontekste';
$string['taskcreatecontexts'] = 'Ustvari manjkajoči kontekst';
$string['taskdeletecachetext'] = 'Izbriši stare besedilne predpomnilnike zapisov';
$string['taskdeleteincompleteusers'] = 'Izbriši nepopolne uporabnike';
$string['taskdeleteunconfirmedusers'] = 'Izbriši nepotrjene uporabnike';
$string['taskeventscron'] = 'Obdelava v ozadju za dogodke';
$string['taskfiletrashcleanup'] = 'Počisti datoteke v smeteh';
$string['taskglobalsearchindex'] = 'Vpisovanje globalnega iskanja v kazalo';
$string['taskglobalsearchoptimize'] = 'Optimizacija kazala globalnega iskanja';
$string['taskgradecron'] = 'Obdelava v ozadju za redovalnico';
$string['taskgradehistorycleanup'] = 'Obdelava v ozadju za čiščenje tabel s preteklimi ocenami';
$string['tasklegacycron'] = 'Podedovana obdelava cron za vtičnike';
$string['tasklogcleanup'] = 'Čiščenje dnevnikov nalog';
$string['tasklogging'] = 'Konfiguracija dnevnikov nalog';
$string['tasklogs'] = 'Dnevniki nalog';
$string['taskmessagingcleanup'] = 'Obdelava v ozadju za sporočila';
$string['taskpasswordresetcleanup'] = 'Poskusi čiščenja ponastavitve gesla';
$string['taskplagiarismcron'] = 'Obdelava v ozadju za podedovane crone v vtičnikih za plagiatorstvo';
$string['taskportfoliocron'] = 'Obdelava v ozadju za portfelj vtičnikov';
$string['taskprocessing'] = 'Obdelava nalog';
$string['taskquestioncron'] = 'Obdelava v ozadju za čiščenje predogleda vprašanj';
$string['taskquestionstatscleanupcron'] = 'Obdelava v ozadju za čiščenje predpomnilnika statistike vprašanj';
$string['taskrefreshsystemtokens'] = 'Osveži žetone OAuth za storitvene račune';
$string['taskregistrationcron'] = 'Registracija spletnega mesta';
$string['tasksendfailedloginnotifications'] = 'Pošlji obvestilo o spodletelih prijavah';
$string['tasksendnewuserpasswords'] = 'Pošlji novo uporabniško geslo';
$string['tasksessioncleanup'] = 'Počisti stare seje';
$string['taskstatscron'] = 'Obdelava v ozadju za statistiko';
$string['tasktagcron'] = 'Obdelava v ozadju za oznake';
$string['tasktempfilecleanup'] = 'Izbriši zastarele začasne datoteke';
$string['tasktype'] = 'Tip';
$string['tempdatafoldercleanup'] = 'Počisti začasne podatkovne datoteke starjše od';
$string['templates'] = 'Predloge';
$string['testoutgoingmailconf'] = 'Preizkusi konfiguracijo izhodne e-pošte';
$string['testoutgoingmailconf_errorcommunications'] = 'Vaše spletno mesto se ni uspelo povezati z strežnikom vaše e-pošte. Prosimo, da preverite konfiguracijo izhodne e-pošte.';
$string['testoutgoingmailconf_message'] = 'To je testno sporočilo, ki potrjuje, da ste uspešno konfigurirali izhodno e-pošto vašega spletnega mesta.';
$string['testoutgoingmailconf_sendtest'] = 'Pošlji poskusno sporočilo';
$string['testoutgoingmailconf_sentmail'] = 'To spletno mesto je uspešno poslalo testno sporočilo strežniku e-pošte.<br />Od: {$a->fromemail}<br />Za: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a}: poskusno sporočilo';
$string['testoutgoingmailconf_toemail'] = 'Za e-poštni naslov';
$string['testoutgoingmaildetail'] = 'Opomba: Prosimo, da pred preizkušanjem shranite svojo konfiguracijo.<br />{$a}';
$string['testsiteupgradewarning'] = 'Trenutno uporabljate {$a} preizkusno spletno mesto. Za pravilno nadgradnjo uporabite vmesnik orodja ukazne vrstice';
$string['themedesignermode'] = 'Način oblikovanja tem';
$string['themedesignermodewarning'] = 'Način oblikovanja tem je vključen. Na prednostnih spletiščih ne bi smel biti vključen, saj lahko občutno zmanjša zmogljivost.';
$string['themelist'] = 'Seznam tem';
$string['themenoselected'] = 'Nobena tema ni izbrana';
$string['themeresetcaches'] = 'Počisti predpomnilnik teme';
$string['themeselect'] = 'Spremeni temo';
$string['themeselector'] = 'Izbirnik tem';
$string['themesettings'] = 'Nastavitve tem';
$string['therewereerrors'] = 'V vaših podatkih je prišlo do napak';
$string['thirdpartylibrary'] = 'Knjižnica';
$string['thirdpartylibrarylocation'] = 'Lokacija';
$string['thirdpartylibs'] = 'Zunanje knjižnice';
$string['timezone'] = 'Privzet časovni pas';
$string['timezoneforced'] = 'To je vsiljeno s strani skrbnika spletnega mesta';
$string['timezoneinvalid'] = 'Neveljavni časovni pas "{$a}"';
$string['timezoneisforcedto'] = 'Vsili vsem uporabnikom, da uporabljajo';
$string['timezonenotforced'] = 'Uporabniki lahko izberejo lasten časovni pas';
$string['timezonephpdefault'] = 'Privzeti PHP časovni pas ({$a})';
$string['timezoneserver'] = 'Časovni pas strežnika ({$a})';
$string['tlswarning'] = 'Razširitev PHP/cURL s podporo za TLSv1.2 ni bil najden. Nekatere storitve ne bodo delovale. Priporočamo nadgradnjo knjižnic TLS.';
$string['tokenduration'] = 'Trajanje uporabniško ustvarjenega žetona';
$string['tokenduration_desc'] = 'Čas veljavnosti žetona za spletne storitve, ki ga je ustvaril uporabnik (na primer preko mobilne aplikacije).';
$string['tokenizerrecommended'] = 'Priporočamo namestitev neobvezne razširitve PHP Tokenizer - izboljša delovanje Moodle omrežja.';
$string['tools'] = 'Orodja skrbnika';
$string['toolsmanage'] = 'Upravljaj orodja skrbnika';
$string['unattendedoperation'] = 'Nenadzorovano dejanje';
$string['unbookmarkthispage'] = 'Odstrani to stran iz zaznamkov';
$string['unicoderequired'] = 'Vaši podatki morajo biti shranjeni v formatu Unicode (UTF-8). Nove namestitve morajo biti nameščene na podatkovnih bazah s privzetim znakom, nastavljenim na Unicode. Če nadgrajujete sistem, morate izvesti migracijo na UTF-8 (več informacij na strani za skrbnike).';
$string['uninstallplugin'] = 'Odstrani';
$string['unlockaccount'] = 'Odkleni račun';
$string['unoconvwarning'] = 'Nameščena različica unoconv ni podprta.';
$string['unsettheme'] = 'Nenameščena tema';
$string['unsupported'] = 'Nepodprt';
$string['unsupporteddbfileformat'] = 'Vaša podatkovna baza za obliko datotek uporablja Antelope. Za polno podporo UTF-8 v MySQL in MariaDB je zahtevan datotečni format Barracuda. Poglejte dokumentacijo: <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">Polna podpora za unicode v MySQL</a> za podrobnosti.';
$string['unsupporteddbfilepertable'] = 'Za polno podporo UTF-8 tako MySQL kot MariaDB zahtevata, da vašo MySQL nastavitev \'innodb_file_per_table\' spremenite na \'ON\'. Za več podrobnosti preglejte dokumentacijo.';
$string['unsupporteddblargeprefix'] = 'Za polno podporo UTF-8 tako MySQL kot MariaDB zahtevata, da vašo MySQL nastavitev \'innodb_large_prefix\' spremenite na \'ON\'. Za več podrobnosti preglejte dokumentacijo.';
$string['unsupporteddbstorageengine'] = 'Shranjevalni način podatkovne baze, ki je v uporabi, ni več podprt.';
$string['unsupporteddbtablerowformat'] = 'Vaša podatkovna baza ima tabele, ki za datotečno obliko uporabljajo Antelope. Priporočamo vam, da tabele pretvorite v datotečni format Barracuda. Za več podrobnosti o orodju za pretvorbo InnoDB tabel v Barracuda glejte dokumentacijo <a href=«https://docs.moodle.org/en/cli«Skrbništo preko ukazne vrstice</a>.';
$string['unsupportedphpversion7'] = 'PHP različica 7 ni podprta.';
$string['unsupportedphpversion71'] = 'PHP različica 7.1 ni podprta.';
$string['unsupportedphpversion72'] = 'PHP različica 7.2 ni podprta.';
$string['unsupportedphpversion73'] = 'Različica PHP 7.3. ni podprta.';
$string['unsupportedphpversion74'] = 'Različica PHP 7.4 ni podprta.';
$string['unsuspenduser'] = 'Aktiviraj uporabniški račun';
$string['updateaccounts'] = 'Posodobi obstoječe uporabniške račune';
$string['updateautocheck'] = 'Samodejno preveri, ali so na voljo posodobitve';
$string['updateautocheck_desc'] = 'Če je omogočeno, bo vaše spletno mesto samodejno preverilo, ali so na voljo posodobitve za Moodlove kode in dodatne vtičnike. V tem primeru bodo skrbniki spletnega mesta o tem dobili obvestilo.';
$string['updateavailable'] = 'Na voljo je novejša različica Moodla!';
$string['updateavailable_moreinfo'] = 'Več o tem ...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Različica {$a}';
$string['updateavailabledetailslink'] = 'Za več podrobnosti glejte {$a->url}';
$string['updateavailableforplugin'] = 'Na voljo so novejše različice nekaterih vtičnikov!';
$string['updateavailableinstall'] = 'Namesti to posodobitev';
$string['updateavailableinstallall'] = 'Namesti razpoložljive posodobitve ({$a})';
$string['updateavailableinstallallhead'] = 'Nameščam razpoložljive posodobitve';
$string['updateavailablenot'] = 'Vaša različica Moodla je najnovejša!';
$string['updateavailablerecommendation'] = 'Močno se priporoča posodabljanje vašega spletnega mesta na zadnjo različico, da prejmete vse najnovejše varnostne popravke in popravke hroščev.';
$string['updatecomponent'] = 'Posodobi komponento';
$string['updateminmaturity'] = 'Zahtevana koda zapadlosti';
$string['updateminmaturity_desc'] = 'Obvesti o posodobitvah, ki so na voljo, samo, če ima koda na voljo nastavljeno raven zapadlosti na najmanjši vrednosti. Posodobitve za vtičnike, ki nimajo navedene ravni zapadlosti kode, so vedno prijavljene ne glede na to nastavitev.';
$string['updatenotificationfooter'] = 'Vaše spletno mesto Moodle {$a->siteurl} je konfigurirano tako, da samodejno preverja, če so na voljo posodobitve. To obvestilo ste prejeli kot skrbnik spletnega mesta. Samodejno preverjanje za posodobitve lahko onemogočite v Skrbništvu spletnega mesta v bloku Skrbništvo. Nastavitve glede pošiljanja tega obvestila lahko nastavite po meri na strani Nastavitve mojega profila.';
$string['updatenotifications'] = 'Obvestila o posodobitvah';
$string['updatenotificationsubject'] = 'Na voljo so posodobitve Moodla ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Opozori o novih gradnjah';
$string['updatenotifybuilds_desc'] = 'Če je omogočeno, so posodobitve na voljo za Moodlovo kodo prijavljene tudi, ko je na voljo graditev za trenutno različico. Graditve so nenehna izbolljševanja ponujene Moodlove različice. Običajno so na voljo vsak teden. Če je onemogočeno, bo posodobitev na voljo prijavljena samo, ko bo izdana novejša Moodlova različica. Ta nastavitev ne vpliva na preverjanje za vtičnike.';
$string['upgradeerror'] = 'Neznana napaka pri nadgradnji {$a->plugin} na različico {$a->version}. Ne morete nadaljevati.';
$string['upgradeforumread'] = 'V Moodle 1.5 je bila dodana nova funkcija sledenja prebranih/neprebranih objav foruma.<br />Za uporabo te funkcionalnosti morate <a href="{$a}">posodobiti vaše tabele</a>.';
$string['upgradeforumreadinfo'] = 'V Moodle 1.5 je bila dodana nova funkcija sledenja prebranih/neprebranih prispevkov na forumu. Za uporabo te funkcionalnosti morate vaše tabele posodobiti z vsemi informacijami o sledenju za obstoječe objave. Postopek lahko traja več ur (odvisno od velikosti vašega spletnega mesta) in lahko obremeni podatkovno bazo, zato je to najbolje storiti v obdobjih, ko ni veliko uporabnikov. Kljub temu bo vaše spletno mesto med to nadgradnjo še naprej delovalo in to ne bo vplivalo na uporabnike. Ko boste zagnali ta proces, ga morate pustiti, da se zaključi (pustite okno brskalnika odprto). Če kljub temu prekinete proces z zaprtjem okna, lahko še vedno začnete znova.<br /><br />Želite začeti s postopkom nadgradnje sedaj?';
$string['upgradekeyreq'] = 'Zahtevan je ključ za nadgradnjo';
$string['upgradekeyset'] = 'Ključ za nadgradnjo (pustite prazno, če ga ne želite nastaviti)';
$string['upgradelogs'] = 'Za polno funkcionalnost je treba nadgraditi stare dnevnike. <a href="{$a}">Več informacij</a>';
$string['upgradelogsinfo'] = 'Nedavno je prišlo do nekaj sprememb v načinu shranjevanja dnevnikov. Da bi si lahko ogledali starejše dnevnike za dejavnosti, je potrebno stare dnevnike nadgraditi. To lahko traja več ur (odvisno od velikosti vašega spletnega mesta) in lahko obremeni podatkovno bazo na večjih spletnih mestih. Ko boste začeli ta proces, ga morate pustiti, da se zaključi (tako, da pustite okno brskalnika odprto). Ne skrbite – vaše spletno mesto bo delovalo v redu za ostale osebe med procesom nadgradnje dnevnikov.<br /><br />Želite sedaj nadgraditi dnevnike sedaj?';
$string['upgradepluginsfirst'] = 'Priporočljivo je, da najprej namestite vse posodobitve';
$string['upgradepluginsinfo'] = 'Posodabljam vtičnike';
$string['upgradepluginsinfo_help'] = 'Za nekatere vtičnike so na voljo posodobitve. Namestite jih pred nadgradnjo Moodlove podatkovne baze. Če vaše spletno mesto ne podpira samodejne namestitve posodobitev, morate nov različice vtičnikov ročno prenesti in namestiti na vaš strežnik.';
$string['upgradepluginsinfo_link'] = 'skrbnik/podatki o nadgradnji vtičnikov';
$string['upgradesettings'] = 'Nove nastavitve';
$string['upgradesettingsintro'] = 'Spodaj prikazane nastavitve so bile dodane med vašo zadnjo nadgradnjo Moodla. Po potrebi spremenite privzete nastavitve ter nato kliknite »Shrani spremembe« na dnu strani.';
$string['upgradestalefiles'] = 'Obstajajo neskladne različice Moodla, zato se nadgradnja ne more nadaljevati';
$string['upgradestalefilesinfo'] = 'Proces posodobitve Moodla je bil začasno ustavljen, ker se v mapi Moodla nahajata vsaj dva PHP skripta različnih različic.

To lahko kasneje povzroči resne težave, zato morate zagotoviti, da imenik Moodle vsebuje datoteke samo ene verzije.

Priporočljivo je storiti naslednje:

* preimenujte trenuten imenik Moodle v "moodle_old"
* ustvarite novo mapo Moodle, ki vsebuje le datoteke iz standardnega paketa, ki ste ga prenesli ali pa iz Moodle Git skladišča
* premaknite izvirno datoteko config.php in druge nestandardne vtičnike iz mape "moodle_old" v novo Moodle mapo

Ko ste tako očistili mapo Moodle, osvežite to stran za nadaljevanje procesa nadgradnje.

To opozorilo se najpogosteje pojavi, če odzipate standardni Moodle paket čez prejšnjo različico Moodla. Za manjše nadgradnje je to sprejemljivo, močno pa se odsvetuje za večje posodobitve.

Vzrok za to sporočilo je lahko tudi spodletela preveritev oz. posodobitev iz Git skladišča. V tem primeru morate le počakati, da se dejanje zaključi ali pa zagnati ukaz za brisanje in ponoviti dejanje.

Več o tem lahko najdete v dokumentaciji za nadgradnjo na <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Moodlovo podatkovno bazo nadgradi zdaj';
$string['upgradesure'] = '<p>Datoteke vašega Moodla so bile spremenjene in sedaj boste samodejno nadgradili vaš strežnik na to različico:</p>
<p><strong>{$a}</strong></p>
<p>Ko to naredite, se ne morete več vrniti. Proces lahko traja več časa.</p>
<p>Ste prepričani, da želite nadgraditi ta strežnik na to različico?</p>';
$string['upgradetimedout'] = 'Nadgradnja je potekla. Prosimo, ponovno zaženite nadgradnjo.';
$string['upgradingdata'] = 'Nadgradnja podatkov';
$string['upgradinglogs'] = 'Nadgradnja dnevnikov';
$string['upgradingversion'] = 'Nadgradnja na novo različico';
$string['upwards'] = 'navzgor';
$string['useblogassociations'] = 'Omogoči povezovanja';
$string['useexternalyui'] = 'Uporabi mrežne knjižnice YUI';
$string['user'] = 'Uporabnik';
$string['userbulk'] = 'Množična uporabniška dejanja';
$string['userbulkdownload'] = 'Izvozi uporabnike kot';
$string['userdefaultpreferences'] = 'Privzete uporabniške nastavitve';
$string['userfeedbackafterupgrade'] = 'Po vsaki večji nadgradnji';
$string['userfeedbackencouragement'] = '<p>V Moodle 3.9 in sledečih različicah je vključena nova funkcija, ki uporabnikom ponuja možnost, da sedežu Moodla z reševanjem ankete na zunanji spletni strani, ki jo gostimo na sedežu Moodla, podajo pripombe o programski opremi Moodle. Spletni strani z anketo niso posredovani nobeni podatki, ki bi lahko razkrili identiteto uporabnika.</p>
<p>Na sedežu Moodla si prizadevamo biti odprti in odkriti glede zbiranja podatkov. Zato želimo zagotoviti, da ste o tem obveščeni in lahko to delovanje nadzorujete.</p>
<p>Pripombe uporabnikov bodo sedežu Moodla zelo pomagale izboljšati programsko opremo Moodle. To funkcijo lahko omogočite na <a href="{$a}">Nastavitve pripomb</a>.</p>';
$string['userfeedbacknextreminder'] = 'Naslednji opomnik za pripombe';
$string['userfeedbacknextreminder_desc'] = 'Kdaj naj uporabnika prosimo, da ponovno poda pripombe?';
$string['userfeedbackperiodically'] = 'Periodično';
$string['userfeedbackremindafter'] = 'Pokaži opomnik po';
$string['userfeedbackremindafter_desc'] = 'Uporabnike ponovno spomni, da po določenem številu dni podajo pripombo.';
$string['userfiltersdefault'] = 'Privzeti filtri uporabnika';
$string['userfiltersdefault_desc'] = 'Izberite filtre, ki naj bodo prikazani na strani ‚Brskajte po seznamu uporabnikov‘ in na strani ‚Množična uprabniška dejanja‘. Več elementov izberete tako, da tiščite tipko Ctrl. Filtri, ki jih ne boste izbrali, najdete tako, da kliknete na povezavo ‚Prikaži več‘.';
$string['userimagesdisabled'] = 'Profilne slike uporabnikov so onemogočene';
$string['userlist'] = 'Prebrskaj seznam uporabnikov';
$string['usermanagement'] = 'Upravljanje uporabnikov';
$string['userpolicies'] = 'Uporabniška politika';
$string['userpreference'] = 'Uporabniške nastavitve';
$string['userquota'] = 'Zasebni prostor za datoteke';
$string['userquota_desc'] = 'Maksimalno število podatkov, ki jih lahko vsak uporabnik shrani v zasebno mesto z datotekami.';
$string['users'] = 'Uporabniki';
$string['usesitenameforsitepages'] = 'Uporabi ime spletnega mesta za strani spletnega mesta';
$string['usetags'] = 'Omogoči funkcionalnost oznak';
$string['validateemptylineerror'] = 'Prazne vrstice niso veljavne';
$string['validateerror'] = 'Ta vrednost ni veljavna';
$string['validateerrorlist'] = 'Ti vnosi so neveljavni: {$a}';
$string['validateiperror'] = 'Ti naslovi IP so neveljavni: {$a}';
$string['verifychangedemail'] = 'Omeji domene pri spremembi e-poštnega naslova';
$string['warningcurrentsetting'] = 'Neveljavna trenutna vrednost: {$a}';
$string['warningiconvbuggy'] = 'Vaša različica ikone knjižnice ne podpira določila //PREZRI. Namestite si razširitev mbtring, ki jo lahko uporabite za čiščenja nizov, ki vsebujejo neveljavne znake UTF-8.';
$string['webproxy'] = 'Spletni strežnik';
$string['webproxyinfo'] = 'Izberite sledeče možnosti, če vaš Moodlov strežnik ne more direktno dostopati do interneta. Dostop do interneta je potreben za prenos podatkov o okolju, jezikovnih paketov, virov RSS, časovnih pasov itd.<br /><em>Priporočamo namestitev razširitve cURL za PHP.</em>';
$string['xmlrpcrecommended'] = 'Xmlrpc razširitev je potrebna za komunikacijo med vozlišči in je uporabna za spletne servise in Moodle mreženje.';
$string['yuicomboloading'] = 'YUI combo nalaganje';
$string['ziprequired'] = 'Moodle zahteva razširitev Zip PHP. Dvojiški info-ZIP ali knjižnica PclZIP niso več v uporabi.';
