<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotpot', language 'sr_lt', version '4.0'.
 *
 * @package     hotpot
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'Napušteno';
$string['abandonhotpot'] = 'Vaši dosadašnji rezultati biće sačuvani ali nećete moći da nastavite ili da kasnije ponovo pokrenete ovu aktivnost.';
$string['activitycloses'] = 'Aktivnost se završava';
$string['activitygrade'] = 'Ocena aktivnosti';
$string['activityopens'] = 'Aktivnost počinje';
$string['added'] = 'Dodato';
$string['addquizchain'] = 'Dodavanje niza testa';
$string['addquizchain_help'] = 'Da li treba sve testove dodati u niz testova?

**Ne**
: samo jedan test će biti dodat kursu

**Da**
: ako je izvorna datoteka **datoteka testa**, ona će biti tretirana kao početak niza testova i svi testovi u nizu biće dodati kursu sa identičnim podešavanjima, Svaki test u nizu mora da ima link ka narednoj datoteci u nizu.

Ako je izvorna datoteka **folder**, svi testovi koji se mogu prepoznati u tom folderu biće dodat kursu kako bi se formirao niz testova sa identičnim podešavanjima.

Ako je izvorna datoteka **jedinična datoteka**, kao što je tzv. Hot Potatoes Masher datoteka ili index.html, testovi koji se nalaze na spisku jedinice biće dodati kursu kao niz testova sa identičnim podešavanjima.';
$string['allowpaste'] = 'Dozvoli prenošenje';
$string['allowpaste_help'] = 'Ako je ovo podešavanje omogućeno studenti će moći da kopiraju, prenose i prеvlače tekst u okvir za unos teksta.';
$string['allowreview'] = 'Dozvoli pregled';
$string['allowreview_help'] = 'Ako je omogućeno, studenti mogu da pregledaju svoje pokušaje nakon što test bude zatvoren.';
$string['analysisreport'] = 'Analiza stavki';
$string['attempted'] = 'Pokušano';
$string['attemptlimit'] = 'Ograničenje pokušaja';
$string['attemptlimit_help'] = 'Maksimalan broj pokušaja koje student može da ima na ovoj HotPot aktivnosti';
$string['attemptnumber'] = 'Broj pokušaja';
$string['attempts'] = 'Pokušaji';
$string['attemptscore'] = 'Rezultat pokušaja';
$string['attemptsunlimited'] = 'Neograničeni broj pokušaja';
$string['average'] = 'Prosek';
$string['averagescore'] = 'Prosečan rezultat';
$string['bodystyles'] = 'Osnovni stilovi';
$string['bodystylesbackground'] = 'Boja i slika pozadine';
$string['bodystylescolor'] = 'Boja teksta';
$string['bodystylesfont'] = 'Veličina i familija fonta';
$string['bodystylesmargin'] = 'Leva i desna margina';
$string['cacherecords'] = 'HotPot keš zapis';
$string['canrestarthotpot'] = 'Vaši dosadašnji rezultati biće sačuvani, i  kasnije, možete ponovo da uradite "{$a}"';
$string['canresumehotpot'] = 'Vaši dosadašnji rezultati biće sačuvani i kasnije možete da nastavite "{$a}".';
$string['checks'] = 'Provere';
$string['checksomeboxes'] = 'Molimo, označite neka od polja';
$string['clearcache'] = 'Obriši HotPot keš';
$string['cleardetails'] = 'Obriši HotPot detalje';
$string['clearedcache'] = 'HotPot keš je obrisan';
$string['cleareddetails'] = 'HotPot detalji su obrisani';
$string['clickreporting'] = 'Omogučavanje izveštavanja o klikovima';
$string['clickreporting_help'] = 'Ako je omogućeno, svaki put kada se klikne na dugme "Savet", "Trag" ili "Proveri" biće sačuvan zaseban zapis. To dozvoljava predavaču da vidi vrlo detaljan izveštaj koji prikazuje stanje testa pri svakom kliku. U suprotnom, čuva se samo jedan zapis za svaki pokušaj rešavanja testa.';
$string['clicktrailreport'] = 'Praćenje klikova';
$string['closed'] = 'Ova aktivnost je zatvorena';
$string['clues'] = 'Tragovi';
$string['completed'] = 'Završeno';
$string['configbodystyles'] = 'Standardno, stilovi Moodle teme će zameniti stilove HotPot aktivnosti. Međutim, za sve stilove koji se ovde izaberu, stilovi HotPot aktivnost će imati prednost u odnosu na stilove Moodle teme.';
$string['configenablecache'] = 'Uključivanje HotPot keša može dramatično da ubrza isporuku testova studentima.';
$string['configenablecron'] = 'Navedite vreme u Vašoj vremenskoj zoni u koje se može pokrenuti Hotpot kron skript.';
$string['configenablemymoodle'] = 'Ovo podešavanje određuje da li se HotPot testovi pojavljuju na stranici MyMoodle';
$string['configenableobfuscate'] = '"Zamućivanje" (enkripcija) Javascript kôda za umetanje medija plejera otežava određivanje naziva multimedijalne datoteke, kao i nagađanje šta ona sadrži.';
$string['configenableswf'] = 'Dozvoli ugradnju SWF datoteka u HotPot aktivnosti. Ako je omogućeno, ovo podešavanje nadjačava filter_mediaplugin_enable_swf.';
$string['configfile'] = 'Konfiguraciona datoteka';
$string['configframeheight'] = 'Kada se test prikazuje unutar okvira, ova vrednost predstavlja visinu (u pikselima) gornjeg okvira koji sadrži Moodle navigacionu traku.';
$string['configlocation'] = 'Položaj konfiguracione datoteke';
$string['configlockframe'] = 'Ako je ovo podešavanje omogućeno, onda će navigacioni okvir, ukoliko  se koristi, biti zaključan tako da neće moći da se koristi traka sa klizačem i da se menja veličina okvira, niti će okvir imati borduru.';
$string['configmaxeventlength'] = 'Ako HotPot test ima navedeno i vreme otvaranja i vreme zatvaranja, i ako je razlika između ova dva vremena veća od broj dana ovde navedenih, onda će u kalendar kursa biti dodata dva odvojena događaja. Za kraće trajanje, ili kada je navedeno samo jedno vreme, onda će u kalendar biti dodat samo jedan događaj. Ako nijedno vreme nije navedeno, onda nijedan događaj neće biti dodat u kalendar.';
$string['configstoredetails'] = 'Ako je ovo podešavanje omogućeno, onda će neobrađeni XML detalji o pokušajima da se reše HotPot testovi biti sačuvani u tabeli hotpot_details. Ovo dozvoljava da pokušaji rešavanja mogu kasnije da budu ponovo ocenjeni ako se promeni HotPot sistem za bodovanje. Međutim, ako omogućite ovu opciju na sajtu koji se puno koristi, to može dovesti do toga da se tabela hotpot_details vrlo brzo uveća.';
$string['confirmdeleteattempts'] = 'Da li stvarno želite da obrišete ove pokušaje?';
$string['confirmstop'] = 'Da li ste sigurni da želite da odete sa ove stranice?';
$string['correct'] = 'Tačno';
$string['couldnotinsertsubmissionform'] = 'Nije moguće umetnuti obrazac za slanje';
$string['d_index'] = 'Indeks diskriminacije';
$string['delay1'] = 'Vremenski razmak 1';
$string['delay1_help'] = 'Najmanji vremenski razmak između prvog i drugog pokušaja';
$string['delay1summary'] = 'Vremenski razmak između prvog i drugog pokušaja';
$string['delay2'] = 'Vremenski razmak 2';
$string['delay2_help'] = 'Minimalni vremenski razmak između dva pokušaja';
$string['delay2summary'] = 'Vremenski razmak između kasnijih pokušaja';
$string['delay3'] = 'Vremenski razmak 3';
$string['delay3_help'] = 'Podešavanje određuje vremenski razmak između završetka testa i povratka kontrole prikaza Moodleu.

**Koristite određeno vreme (u sekundima)**
: kontrola će biti vraćena Moodleu nakon određenog broja sekundi.

**Koristite podešavanja iz izvorne ili datoteke šablona**
: kontrola će biti vraćena Moodleu nakon vremena (u sekundama) navedenog u izvornoj ili datotekama šablona za ovaj izlazni format.

**Sačekajte dok student ne klikne OK**
: kontrola će biti vraćena Moodleu nakon što student klikne dugme OK na završnoj poruci u kvizu.

**Nemojte nastavljati automatski**
: kontrola neće biti vraćena Moodleu nakon što test bude završen. Student će biti slobodan da ode sa stranice sa testom.

Imajte u vidu da se rezultati testa uvek vraćaju Moodleu odmah
nakon što je test završen ili napušten, bez obzira na ovo podešavanje.';
$string['delay3afterok'] = 'Sačekajte dok student ne klikne na OK';
$string['delay3disable'] = 'Nemojte nastavljati automatski';
$string['delay3specific'] = 'Koristite određeno vreme (u sekundima)';
$string['delay3summary'] = 'Vremenski razmak na kraju testa';
$string['delay3template'] = 'Koristite podešavanja iz izvorne ili datoteke šablona';
$string['deleteallattempts'] = 'Obriši sve pokušaje';
$string['deleteattempts'] = 'Obriši pokušaje';
$string['detailsrecords'] = 'Запис о HotPot детаљима';
$string['duration'] = 'Trajanje';
$string['enablecache'] = 'Uključi HotPot keš';
$string['enablecron'] = 'Omogući HotPot cron';
$string['enablemymoodle'] = 'Прикажи HotPot тестове на страници Мој Moodle';
$string['enableobfuscate'] = 'Omogući "zamućivanje" (enkripciju) kôda medija plejera';
$string['enableswf'] = 'Dozvoli ugrađivanje SWF datoteka u HotPot aktivnosti';
$string['entry_attempts'] = 'Pokušaji';
$string['entry_dates'] = 'Datum';
$string['entry_grading'] = 'Ocenjivanje';
$string['entry_title'] = 'Naziv jedinice kao naslov';
$string['entrycm'] = 'Prethodna aktivnost';
$string['entrycm_help'] = 'Ovo podešavanje određuje Moodle aktivnost i minimalnu ocenu koju student mora da postigne za tu aktivnost, pre nego što bude mogao da pokuša ovu HotPot aktivnost.

Predavač može da izabere određenu aktivnost ili jedno od sledećih opštih podešavanja:

* Prethodna aktivnost na ovom kursu
* Prethodna aktivnost u ovoj sekciji kursa
* Prethodni HotPot na ovom kursu
* Prethodni HotPot u ovoj sekciji kursa';
$string['entrycmcourse'] = 'Prethodna aktivnost na ovom kursu';
$string['entrycmsection'] = 'Prethodna aktivnost u ovoj sekciji kursa';
$string['entrycompletionwarning'] = 'Pre nego što započnete ovu aktivnost, prvo morate da pogledate {$a}.';
$string['entrygrade'] = 'Ocena prethodne aktivnosti';
$string['entrygradewarning'] = 'Ne možete da započnete ovu aktivnost dok ne osvojite {$a->entrygrade}% na {$a->entryactivity}. Trenutno, Vaša ocena za tu aktivnost je {$a->usergrade}%';
$string['entryhotpotcourse'] = 'Prethodni HotPot na ovom kursu';
$string['entryhotpotsection'] = 'Prethodni HotPot u ovoj sekcij kursa';
$string['entryoptions'] = 'Opcije uvodne stranice';
$string['entryoptions_help'] = 'Ova polja za potvrdu omogućuju i onemogućuju prikaz stavki na HotPot ulaznoj stranici.

**Naziv jedinice kao naslov**
: ako je polje potvrđeno, naziv jedinice biće prikazan kao naslov na ulaznoj stranici.

**Ocenjivanja**
: ako je polje potvrđeno, informacije o ocenjivanju HotPota biće prikazana na ulaznoj stranici.

**Datumi**
: ako je polje potvrđeno,  datumi otvaranja i zatvaranja HotPota biće prikazani na ulaznoj stranici.

**Pokušaji**
: ako je polje potvrđeno, tabela koja prikazuje detalje prethodnih pokušaja korisnika na ovom HotPot testu biće prikazana na ulaznoj stranici. Pokušaji koji mogu da se nastave imaće dugme za nastavak.';
$string['entrypage'] = 'Prikaži uvodnu stranicu';
$string['entrypage_help'] = 'Da li treba studentima prikazati inicijalnu stranicu pre nego što započnu HotPot aktivnost?

**Da**
: studentima će biti prikazana ulazna stranica pre nego što započnu HotPot. Sadržaj ulazne stranice je određen opcijama za ulaznu stranicu HotPota.

**Ne**
: studentima neće biti prikazana ulazna stranica, i odmah će započeti HotPot.

Ulazna stranica se uvek prikazuje predavačima kako bi mogli da pristupe izveštajima i uređivanju stranice sa testovima';
$string['entrypagehdr'] = 'Uvodna stranica';
$string['entrytext'] = 'Tekst na uvodnoj stranici';
$string['event_attempt_reviewed'] = 'Pregledan HotPot pokušaj';
$string['event_attempt_reviewed_description'] = 'Korisnik "{$a->userid}" je pregledao pokušaj "hotpot" aktivnosti u modulu kursa "{$a->cmid}"';
$string['event_attempt_reviewed_explanation'] = 'Korisnik je upravo pregledao pokušaj HotPot aktivnosti';
$string['event_attempt_started'] = 'Započet HotPot pokušaj';
$string['event_attempt_started_description'] = 'Korisnik "{$a->userid}" je započeo pokušaj "hotpot" aktivnosti u modulu kursa "{$a->cmid}"';
$string['event_attempt_started_explanation'] = 'Korisnik je upravo započeo pokušaj HotPot aktivnosti';
$string['event_attempt_submitted'] = 'HotPot pokušaj je predat';
$string['event_attempt_submitted_description'] = 'Korisnik "{$a->userid}" je predao pokušaj "hotpot" aktivnosti u modulu kursa "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'Korisnik je upravo predao pokušaj HotPot aktivnosti';
$string['event_base'] = 'Detektovan je HotPot događaj';
$string['event_base_description'] = 'Korisnik "{$a->userid}" je inicirao događaj u "hotpot" aktivnosti u modulu kursa "{$a->cmid}"';
$string['event_base_explanation'] = 'HotPоt modul je detektovao događaj';
$string['event_report_viewed'] = 'Pogledan HotPot izveštaj';
$string['event_report_viewed_description'] = 'Korisnik "{$a->userid}" je pogledao izveštaj o pokušajima "hotpot" aktivnosti u modulu kursa "{$a->cmid}"';
$string['event_report_viewed_explanation'] = 'Кorisnik je upravo pogledao izveštaj o pokušajuma u HotPot aktivnosti';
$string['exit_areyouok'] = 'Jeste li još uvek tu?';
$string['exit_attemptscore'] = 'Vaš rezultat za taj pokušaj je bio {$a}';
$string['exit_course'] = 'Kurs';
$string['exit_course_text'] = 'Povratak na naslovnu stranicu kursa';
$string['exit_encouragement'] = 'Ohrabrenje';
$string['exit_excellent'] = 'Odlično!';
$string['exit_feedback'] = 'Povratna informacija na izlaznoj stranici';
$string['exit_feedback_help'] = 'Ove opcije omogućavaju i onemogućavaju prikazivanje povratnih informacija na izlaznoj stranici HotPota.

**Naziv jedinice kao naslov**
: ako je polje potvrđeno, naziv jedinice biće prikazan kao naslov na izlaznoj stranici.

**Ohrabrenje**
: ako je polje potvrđeno, biće prikazane ohrabrujuće - povratne poruke na izlaznoj stranici. Koja povratna poruka će biti prikazana zavisi od rezultata na HotPot testu:
: **> 90%**: Odlično!
: **> 60%**: Dobro urađeno
: **> 0%**: Može i bolje
: **= 0%**: Da li je sve u redu?

**Ocena pokušaja**
: ako je polje potvrđeno, ocena za upravo završeni pokušaj biće prikazana na izlaznoj stranici.

**Ocena jedinice**
: ako je polje potvrđeno HotPot ocena biće prikazana na izlaznoj stranici.

Osim toga, ako način ocenjivanja jedinice podrazumeva najveću ocenu korisniku će biti prikazana poruka koja će mu reći da li je njegov poslednji pokušaj bio jednak ili bolji od prethodnih.';
$string['exit_goodtry'] = 'Može i bolje!';
$string['exit_grades'] = 'Ocene';
$string['exit_grades_text'] = 'Pogledajte svoje dosadašnje ocene na ovom kursu.';
$string['exit_hotpotgrade'] = 'Vaša ocena za ovu aktivnost je {$a}';
$string['exit_hotpotgrade_average'] = 'Vaša prosečna ocena do sada za ovu aktivnost je {$a}';
$string['exit_hotpotgrade_highest'] = 'Vaša najveća ocena do sada za ovu aktivnost je {$a}';
$string['exit_hotpotgrade_highest_equal'] = 'Izjednačili ste svoj prethodni najbolji rezultat za ovu aktivnost!';
$string['exit_hotpotgrade_highest_previous'] = 'Vaša prethodno najveća ocena za ovu aktivnost bila je {$a}';
$string['exit_hotpotgrade_highest_zero'] = 'Još uvek niste osvojili više od {$a} za ovu aktivnost';
$string['exit_index'] = 'Indeks';
$string['exit_index_text'] = 'Idi na indeks aktivnosti';
$string['exit_links'] = 'Linkovi na izlaznoj stranici';
$string['exit_links_help'] = 'Ove opcije omogućavaju i onemogućavaju prikazivanje odrećenih linkova na izlaznoj stranici HotPota.

**Pokušaj ponovo**
: ako su dozvoljeni višestruki pokušaji na ovom HotPot testu, a student ima još neiskorišćenih pokušaja na raspolaganju, biće prikazan link koji dozvoljava studentu da ponovo pokuša da reši HotPot test.

**Indeks**
: ako je polje potvrđeno, biće prikazan link ka indeksnoj stranici HotPot aktivnosti.

**Kurs**
: ako je polje potvrđeno, biće prikazana link ka stranici kursa u Moodleu.

**Ocene**
: ako je polje potvrđeno biće prikazan link ka knjizi ocena u  Moodleu.';
$string['exit_next'] = 'Sledeće';
$string['exit_next_text'] = 'Pokušajte sledeću aktivnost';
$string['exit_noscore'] = 'Uspešno ste završili ovu aktivnost!';
$string['exit_retry'] = 'Pokušaj ponovo';
$string['exit_retry_text'] = 'Pokušaj ponovo ovu aktivnost';
$string['exit_welldone'] = 'Dobro urađeno!';
$string['exit_whatnext_0'] = 'Šta biste želeli da radite sledeće?';
$string['exit_whatnext_1'] = 'Kuda dalje...';
$string['exit_whatnext_default'] = 'Molimo da odaberete jedno od sledećeg:';
$string['exitcm'] = 'Sledeća aktivnost';
$string['exitcm_help'] = 'Ovo podešavanje određuje Moodle aktivnost koju studenti moraju da  urade nakon što završe ovu HotPot aktivnost. Opciona ocena je minimalna ocena za ovu HotPot aktivnost koja se zahteva pre nego što se prikaže sledeća aktivnost.

Predavač može da izabere određenu aktivnost ili jedno od sledećih opštih podešavanja:

* Sledeća aktivnost na ovom kursu
* Sledeća aktivnost u ovoj sekciji kursa
* Sledeća HotPot aktivnost na ovom kursu
* Sledeća HotPot aktivnost u ovoj sekciji kursa

Ako su druge opcije za izlaznu stranicu onemogućene, a student je postigao traženu ocenu za ovu HotPot aktivnost, onda će mu odmah biti prikazana sledeća aktivnost. U suprotnom, studentu će biti prikazan link, na koji može da klikne, kada bude bio spreman za to.';
$string['exitcmcourse'] = 'Sledeća aktivnost na ovom kursu';
$string['exitcmsection'] = 'Sledeća aktivnost u ovoj sekciji kursa';
$string['exitgrade'] = 'Sledeća ocena aktivnosti';
$string['exithotpotcourse'] = 'Sledeći HotPot na ovom kursu';
$string['exithotpotsection'] = 'Sledeći HotPot u ovoj sekciji kursa';
$string['exitoptions'] = 'Opcije izlazne stranice';
$string['exitpage'] = 'Prikaži izlaznu stranicu';
$string['exitpage_help'] = 'Da li treba prikazati izlaznu stranicu nakon završetka HotPot testa?

**Da**
: studentima će nakon završetka HotPot testa biti prikazana izlazna stranica. Sadržaj izlazne stranice je određen podešavanjima za povratne informacije i linkove na HotPot izlaznoj stranici.

**Ne**
: studentima neće biti prikazana izlazna stranica. Umesto toga, oni će odmah ići na narednu aktivnost ili će biti vraćeni na stranice kursa u Moodleu.';
$string['exitpagehdr'] = 'Izlazna stranica';
$string['exittext'] = 'Tekst na izlaznoj stranici';
$string['feedbackdiscuss'] = 'Diskutujte o ovom testu na forumu';
$string['feedbackformmail'] = 'Obrazac za povratne informacije';
$string['feedbackmoodleforum'] = 'Moodle forum';
$string['feedbackmoodlemessaging'] = 'Moodle sistem za poruke';
$string['feedbacknone'] = 'Nema';
$string['feedbacksendmessage'] = 'Pošaljite poruku svom predavaču';
$string['feedbackwebpage'] = 'Web stranica';
$string['firstattempt'] = 'Prvi pokušaj';
$string['forceplugins'] = 'Obavezni multimedijalni dodaci';
$string['forceplugins_help'] = 'Ako je omogućeno, Moodle kompatibilni medija plejeri će prikazivati datoteke kao što su mpeg, mpg, mp3, mov i wmv.  U suprotnom, Moodle neće da promeni podešavanje bilo kog medija plejera u testu.';
$string['frameheight'] = 'Visina okvira';
$string['giveup'] = 'Odustajanje';
$string['grademethod'] = 'Način ocenjivanja';
$string['grademethod_help'] = 'Ovo podešavanje određuje kako se na osnovu rezultata pokušaja računa ocena za HotPot.

**Najveći rezultat**
: ocena će biti podešena na najveći rezultat za pokušaj na ovoj HotPot aktivnosti.

**Prosečan rezultat**
: ocena će biti podešena na  prosečan rezultat svih pokušaja na ovoj HotPot aktivnosti.

**Prvi pokušaj**
: ocena će biti podešena na rezultat prvog pokušaja na ovoj HotPot aktivnosti.

**Poslednji pokušaj**
: ocena će biti podešena na rezultat poslednjeg pokušaja na ovoj HotPot aktivnosti.';
$string['gradeweighting'] = 'Ponderisanje ocene';
$string['gradeweighting_help'] = 'Ocena za ovu HotPot aktivnost biće gradirana prema ovom broju u knjizi sa ocenama Moodlea.';
$string['highestscore'] = 'Najbolji rezultat';
$string['hints'] = 'Pomoć';
$string['hotpot:addinstance'] = 'Dodaj novu HotPot aktivnost';
$string['hotpot:attempt'] = 'Pokušajte HotPot test i pošaljite odgovore';
$string['hotpot:deleteallattempts'] = 'Obriši sve pokušaje korisnika na HotPot aktivnosti.';
$string['hotpot:deletemyattempts'] = 'Obriši sopstvene pokušaje na HotPot aktivnosti.';
$string['hotpot:ignoretimelimits'] = 'Ignoriši vremenska ograničenja HotPot aktivnosti';
$string['hotpot:manage'] = 'Izmeni podešavanja HotPot aktivnosti';
$string['hotpot:preview'] = 'Pregled HotPot aktivnosti';
$string['hotpot:reviewallattempts'] = 'Pogledaj sve pokušaje korisnika na HotPot aktivnosti.';
$string['hotpot:reviewmyattempts'] = 'Pogledaj sopstvene pokušaje na HotPot aktivnosti.';
$string['hotpot:view'] = 'Pogledaj ulaznu stranicu HotPot testa';
$string['hotpotname'] = 'Naziv HotPot aktivnosti';
$string['ignored'] = 'Ignorisano';
$string['inprogress'] = 'U toku';
$string['isgreaterthan'] = 'je veći od';
$string['islessthan'] = 'je manji od';
$string['lastaccess'] = 'Poslednji pristup';
$string['lastattempt'] = 'Poslednji pokušaj';
$string['lockframe'] = 'Zaključaj okvir';
$string['maxeventlength'] = 'Maksimalan broj dana za jedan kalendarski događaj';
$string['mediafilter_hotpot'] = 'HotPot medijski filter';
$string['mediafilter_moodle'] = 'Standardni medijski filteri Moodlea';
$string['migratingfiles'] = 'Migracija datoteka Hot Potatoes testa';
$string['migratinglogs'] = 'Premeštam Hot Potatoes zapise o aktivnostima';
$string['missingsourcetype'] = 'HotPot zapisu nedostaje izvorni tip';
$string['modulename'] = 'HotPot test';
$string['modulename_help'] = 'HotPot modul omogućava predavačima da svojim studentima distribuiraju interaktivne sadržaje za učenje putem Moodlea, kao i da vide izveštaje o njihovim odgovorima i rezultatima.

Jedna HotPot aktivnost se sastoji od uvodne stranice, koja je opciona, jedne onlajn vežbe i izlazne stranice, koja je, takođe, opciona. Onlajn vežba može biti statična veb stranica ili interaktivna veb stranica koja studentima nudi interaktivni tekstualni, audio i video sadržaj, i beleži njihove odgovore. Onlajn vežbu predavač kreira na svom računaru koristeći softverski alat za kreiranje sadržaja, a zatim pripremljeni materijal postavlja na Moodle.

HotPot aktivnost može da manipuliše vežbama koje su kreirane uz pomoć sledećih softverskih paketa:

* Hot Potatoes (version 6)
* Qedoc
* Xerte
* iSpring
* bilo koji HTML editor';
$string['modulenameplural'] = 'HotPot testovi';
$string['nameadd'] = 'Naziv';
$string['nameadd_help'] = 'Naziv može biti specifičan tekst koji je uneo predavač ili automatski generisani tekst

**Preuzmi iz izvorne datoteke**
: naziv će biti izvučen iz izvorne datoteke.

**Koristi naziv izvorne datoteke**
: naziv izvorne datoteke biće korišćen kao naziv.

**Koristi putanju izvorne datoteke**
: putanja izvorne datoteke biće korišćenа kao naziv. Sve kose crte u putanji biće zamenjene sa razmacima.

**Specifičan tekst**
: određeni tekst koji je uneo predavač biće korišćen kao naziv.';
$string['nameedit'] = 'Naziv';
$string['nameedit_help'] = 'Tekst koji se prikazuje studentima';
$string['navigation'] = 'Navigacija';
$string['navigation_embed'] = 'Ugrađena Web stranica';
$string['navigation_frame'] = 'Moodle navigacioni okvir';
$string['navigation_give_up'] = 'Dugme za pojedinačno odustajanje';
$string['navigation_help'] = 'Ovo podešavanje određuje koja vrsta navigacije će biti korišćena u testu:

**Moodle navigaciona traka**
: Moodle navigaciona traka biće prikazana u istom prozoru kao u test, na vrhu stranice

**Moodle navigaciona okvir**
: Moodle navigaciona traka biće prikazana u odvojenom okviru, na vrhu testa

**Ugrađena Web stranica**
: Moodle navigaciona traka biće prikazana u istom prozoru sa Hot Potatoes testom, ugrađenim u prozor

**Originalna navigacija**
: ako je unutar testa definisano bilo koje navigaciono dugme, test će biti prikazan sa njima

**Dugme "Odustani"**
: test će biti prikazan sa jednim jedinim dugmetom "Odustani" na vrhu stranice

** Nema navigacije**
: test će biti prikazan bez navigacionih pomagala, tako da će nakon tačnih odgovora na sva pitanja, zavisno od podešavanja "Prikaži sledeći test", Moodle ili preusmeriti korisnika na naslovnu stranicu kursa ili će prikazati sledeći test';
$string['navigation_moodle'] = 'Standardne Moodle navigacione trake (na vrhu i sa strane)';
$string['navigation_none'] = 'Nema';
$string['navigation_original'] = 'Originalna navigacija';
$string['navigation_topbar'] = 'Samo Moodle navigaciona traka na vrhu (bez navigacije sa strane)';
$string['noactivity'] = 'Nema aktivnosti';
$string['nohotpots'] = 'Nijedna HotPot aktivnost nije pronađena';
$string['nomoreattempts'] = 'Nažalost, nije Vam preostao više nijedan pokušaj  za ovu aktivnost';
$string['noresponses'] = 'Nisu pronađene informacije o pojedinačnim pitanjima i odgovorima.';
$string['noreview'] = 'Nažalost, nije vam dozvoljeno da pogledate detalje ovog pokušaja rešavanja testa';
$string['noreviewafterclose'] = 'Nažalost, ovaj test je zatvoren. Nije vam više dozvoljeno da pogledate detalje ovog pokušaja rešavanja testa.';
$string['noreviewbeforeclose'] = 'Nažalost, nije vam dozvoljeno da pogledate detalje ovog pokušaja rešavanja testa do {$a}';
$string['nosourcefilesettings'] = 'HotPot zapisu nedostaje informacija o izvornoj datoteci';
$string['notattemptedyet'] = 'Јоš nije pokušano';
$string['notavailable'] = 'Nažalost, ova aktivnost Vam trenutno nije dostupna';
$string['outputformat'] = 'Izlazni format';
$string['outputformat_best'] = 'Najbolje';
$string['outputformat_help'] = 'Izlazni format određuje kako će sadržaj biti prezentovan studentima

Izlazni formati koji su dostupni zavise od tipa izvorne datoteke. Neki tipovi izvornih datoteka imaju samo jedan izlazni format dok drugi tipovi imaju nekoliko izlaznih formata.

"Najbolje" podešavanje prikaće sadržaj koristeći optimalan izlazni formata za studentske Web čitače.';
$string['outputformat_hp_6_jcloze_html'] = 'JCloze (v6) from html';
$string['outputformat_hp_6_jcloze_html_dropdown'] = 'JCloze HP6 html: Rottmeier DropDown';
$string['outputformat_hp_6_jcloze_html_findit_a'] = 'FindIt (a) iz html';
$string['outputformat_hp_6_jcloze_html_findit_b'] = 'FindIt (b) iz html';
$string['outputformat_hp_6_jcloze_html_jgloss'] = 'JCloze HP6 html: Rottmeier JGloss';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'ANCT-Scan from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'DropDown from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'FindIt (a) from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'FindIt (b) from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'JGloss from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'JCloze (v6) from HP6 xml';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'JCloze (v6) iz HP6 xml-a (Automatsko napredovanje)';
$string['outputformat_hp_6_jcross_html'] = 'JCross (v6) from html';
$string['outputformat_hp_6_jcross_xml_v6'] = 'JCross (v6) from xml';
$string['outputformat_hp_6_jmatch_html'] = 'JMatch (v6) from html';
$string['outputformat_hp_6_jmatch_html_sort'] = 'JMatch sortiranje iz html';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'JMatch (flashcard) from xml';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'JMemori from xml';
$string['outputformat_hp_6_jmatch_xml_sort'] = 'JMatch sortiranje iz xml';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'JMatch (v6) from xml';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'JMatch (v6+) from xml';
$string['outputformat_hp_6_jmix_html'] = 'JMix (v6) from html';
$string['outputformat_hp_6_jmix_xml_v6'] = 'JMix (v6) from xml';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'JMix (v6+) from xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'JMix (v6+ with prefix, suffix with distractors) from xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'JMix (v6+ with key press) from xml';
$string['outputformat_hp_6_jquiz_html'] = 'JQuiz (v6) from html';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'JQuiz (v6) from xml';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'JQuiz (v6) from xml (Auto-advance)';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'JQuiz (v6) from xml (Exam)';
$string['outputformat_hp_6_rhubarb_html'] = 'Rhubarb (v6) from html';
$string['outputformat_hp_6_rhubarb_xml'] = 'Rhubarb (v6) from xml';
$string['outputformat_hp_6_sequitur_html'] = 'Sequitur (v6) from html';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'Sequitur (v6) from html, incremental scoring';
$string['outputformat_hp_6_sequitur_xml'] = 'Sequitur (v6) from xml';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'Sequitur (v6) from xml, incremental scoring';
$string['outputformat_html_ispring'] = 'iSpring HTMLdatoteka';
$string['outputformat_html_xerte'] = 'Xerte HTML datoteka';
$string['outputformat_html_xhtml'] = 'Standardna HTML datoteka';
$string['outputformat_qedoc'] = 'Qedoc datoteka';
$string['overviewreport'] = 'Pregled';
$string['penalties'] = 'Kazneni bodovi';
$string['percent'] = 'Procenat';
$string['pluginadministration'] = 'HotPot administracija';
$string['pluginname'] = 'Hot Potatoes modul';
$string['pressoktocontinue'] = 'Pritisni OK za nastavak ili Odustani da biste ostali na tekućoj stranici';
$string['questionshort'] = 'Pitanje {$a}';
$string['quizname_help'] = 'tekst pomoći za Naziv testa';
$string['quizzes'] = 'Testovi';
$string['responses'] = 'Odgovora';
$string['responsesreport'] = 'Odgovori';
$string['reviewafterattempt'] = 'Dozvoli pregled nakon pokušaja';
$string['reviewafterclose'] = 'Dozvoli pregled nakon što se HotPOt zatvori';
$string['reviewduringattempt'] = 'Dozvoli pregled tokom pokušaja';
$string['reviewoptions'] = 'Opcije pregleda';
$string['score'] = 'Rezultat';
$string['scoresreport'] = 'Rezultati';
$string['selectattempts'] = 'Izaberi pokušaje';
$string['showerrormessage'] = 'HotPot greška: {$a}';
$string['sourcefile'] = 'Naziv izvorne datoteke';
$string['sourcefile_help'] = 'Ovo podešavanje određuje datoteku u kojoj se nalazi sadržaj koji će biti prikazan studentima.

Obično se izvorna datoteka kreira izvan Moodlea, a zatim se postavlja u područje sa datotekama Moodle kursa.
To može da bude html ili neki drugi tip datoteke kreirane uz pomoć programa kao što su Hot Potatoes ili Qedoc

Izvorna datoteka može da bude navedena kao folder i putanja datoteke unutar područja za datoteke Moodle kursa ili kao  url adresa koja počinje sa http:// or https://

Za Qedec materijale, izvorna datoteka mora da bude url adresa Qedec modula koji postavljen na Qedec server.

* npr. http://www.qedoc.net/library/ABCDE_123.zip
* Za informacije o postavljanjz Qedoc modula pogledaj [Qedoc documentation: Uploading_modules](http://www.qedoc.org/en/index.php?title=Uploading_modules)';
$string['sourcefilenotfound'] = 'Izvorna datoteka nije pronađena (ili je prazna): {$a}';
$string['status'] = 'Status';
$string['stopbutton'] = 'Prikaži dugme za zaustavljanje';
$string['stopbutton_help'] = 'Ako je omogućeno, u test će biti ubačeno dugme za zaustvljanje.

Ako student klikne na dugme za zaustavljanje, dotadašnji njegov rezultat biće prosleđen Moodleu, a status pokušaja rešavanja testa biće postavljen na \'Napušteno\'

Tekst koji se prikazuje na dugmetu za zaustavljanje može biti neka od standardniih fraza iz Moodle jezičkog paketa ili predavač može da odredi sopstveni tekst za dugme.';
$string['stopbutton_langpack'] = 'Iz jezičkog paketa';
$string['stopbutton_specific'] = 'Koristi specifičan tekst';
$string['stoptext'] = 'Tekst na dugmetu za zaustavljanje';
$string['storedetails'] = 'Sačuvaj neobrađene XML detalje pokušaja rešavanja HotPot testa';
$string['studentfeedback'] = 'Povratne informacije studenta';
$string['studentfeedback_help'] = 'Ako je omogućeno, link ka iskačućem prozoru  sa povratnom informacijom će se prikazati uvek kada student klikne dugme "Proveri". Prozor  sa povratnom informacijom dozvoljava studentima da diskutuju o ovom testu sa svojim predavačima i kolegama na jedan od sledećih načina:

*Web stranica**
: zahteva URL adresu Web stranice, na primer http://myserver.com/feedbackform.html

**Obrazac povratne informacije**
: zahteva URL adresu skripta sa obrascem, na primer http://myserver.com/cgi-bin/formmail.pl

**Moodle forum**
: biće prikazan indeks foruma na kursu

**Moodle sistem za poruke**
: biće prikazan Moodle prozor za poruke. Ako kurs ima nekoliko predavača od studente će se tražiti da izabere jednog od njih pre nego što se prozor za poruke pojavi.';
$string['submits'] = 'Predata rešenja';
$string['subplugintype_hotpotattempt'] = 'Format rezultata';
$string['subplugintype_hotpotattempt_plural'] = 'Formati rezultata';
$string['subplugintype_hotpotreport'] = 'Izveštaj';
$string['subplugintype_hotpotreport_plural'] = 'Izveštaji';
$string['subplugintype_hotpotsource'] = 'Izvorna datoteka';
$string['subplugintype_hotpotsource_plural'] = 'Izvorne datoteke';
$string['textsourcefile'] = 'Preuzmi iz izvorne datoteke';
$string['textsourcefilename'] = 'Koristi naziv izvorne datoteke';
$string['textsourcefilepath'] = 'Koristi putanju izvorne datoteke';
$string['textsourcequiz'] = 'Preuzimanje iz testa';
$string['textsourcespecific'] = 'Specificiran tekst';
$string['timeclose'] = 'Dostupno do';
$string['timedout'] = 'Vreme je isteklo';
$string['timelimit'] = 'Vremensko ograničenje';
$string['timelimit_help'] = 'Ovo podešavanje određuje maksimalno dozvoljeno trajanje jednog pokušaja.

**Koristite podešavanja iz izvorne ili datoteke šablona**
: vremensko ograničenje će biti preuzeto iz izvorne ili datoteka šablona za ovaj izlazni format.

**Koristite određeno vreme**
: vremensko ograničenje određeno u podešavanjima HotPot testa biće korišćeno za pokušaje rešavanja ovog testa. Ovo podešavanje ima prednost u odnosu na vremensko ograničenje u izvornoj, konfiguracionoj ili datotekama šablona za ovaj izlazni format.

**Onemogući**
: vremensko ograničenje neće biti postavljeno za pokušaje rešavanja ovog testa.

Imajte u vidu, da ukoliko se pokušaj nastavlja, tajmer nastavlja tamo gde je stao u trenutku kada je pokušaj privremeno prekinut.';
$string['timelimitexpired'] = 'Vremensko ograničenje za ovaj pokušaj je isteklo';
$string['timelimitspecific'] = 'Koristi određeno vreme';
$string['timelimitsummary'] = 'Vremensko ograničenje za jedan pokušaj';
$string['timelimittemplate'] = 'Koristite podešavanja iz izvorne ili datoteke šablona';
$string['timeopen'] = 'Dostupno od';
$string['timeopenclose'] = 'Vreme otvaranja i zatvaranja';
$string['timeopenclose_help'] = 'Možete da odredite vreme kada je test dostupan korisnicima za rešavanje. Pre otvaranja i nakon zatvaranja, test će biti nedostupan.';
$string['title'] = 'Naslov';
$string['title_help'] = 'Ovo podešavanje određuje naslov koji će biti prikazan na Web stranici

**Naziv HotPot aktivnosti**
: naziv HotPot aktivnosti biće prikazan kao naslov Web stranice.

**Preuzmi iz izvorne datoteke**
: ako je naslov definisan u izvornoj datoteci, biće korišćen kao naslov Web stranice.

**Koristi naziv izvorne datoteke**
: kao naslov veb stranice biće korišćen naziv izvorne datoteke, isključujući nazive foldera.

**Koristi putanju izvorne datoteke**
: kao naslov Web stranice biće korišćena putanja izvorne datoteke, uključujući nazive bilo kog foldera.';
$string['toolsindex'] = 'Indeks HotPot alata';
$string['unitname_help'] = 'tekst pomoći za naziv jedinica';
$string['unrecognizedsourcefile'] = 'Žao nam je, HotPot modul nije mogao da detektuje tip izvorne datoteke: {$a}';
$string['updated'] = 'Ažurirano';
$string['updatinggrades'] = 'Ažuriram Hotpot ocene';
$string['usefilters'] = 'Koristi filtere';
$string['usefilters_help'] = 'Ako je ovo podešavanje omogućeno, sadržaj će biti propušten kroz filtere Moodlea pre nego što bude poslat Web čitaču.';
$string['useglossary'] = 'Koristi rečnik';
$string['useglossary_help'] = 'Ako je ovo podešavanje omogućeno, sadržaj će biti propušten kroz filter za automatsko-linkovanje Moodle rečnika pre nego što bude poslat Web čitaču.

Imajte u vidu da ovo podešavanje ima prednost nad istim takvim podešavanjem filterom za automatsko linkovanje na nivou sajta.';
$string['usemediafilter'] = 'Koristi medijske filtere';
$string['usemediafilter_help'] = 'Ovo podešavanje određuje medijske filtere koji će se koristiti.

**Bez filtera**
: sadržaj neće biti propušteni ni kroz jedan filter

**Standardni medijski filteri Moodlea**
: sadržaj će biti propušten kroz standardne medijske filtere Moodlea. Ovi filteri tragaju za linkovima uobičajenih audio i video datoteka i konvertuju ih za prikaz u odgovarajućim medija plejerima.

**HotPot medijski filter**
: sadržaj će biti propušten kroz filtere koji otkrivaju linkove, slike, audio i video datoteke koje će biti navedene pomoću uglastih zagrada (square bracket notation)

Notacija pomoću uglastih zagrada ima sledeću sintaksu:
<code>[url player width height options]</code>

**url**
: relativna ili apsolutna url adresa multimedijalne datoteke

**plejer** (opciono)
: naziv plejera koji će biti umetnut. Podrazumevana vrednost za ovo podešavanje je "moodle". Standardna verzija modula HotPot takođe nudi sledeće plejere:
: **dew**: mp3 plejer
: **dyer**: mp3 plejer Bernarda Dyera
: **hbs**: mp3 player firme Half-Baked Software
: **slika**: ubacuje sliku u veb stranicu
: **link**: ubacuje link u veb stranicu

**širina** (opciono)
: potrebna širina plejera

**visina** (opciono)
: potrebna visina plejera. Ako je izostavljena ova vrednost će biti ista kao i podešavanje za širinu.

**opcije** (opciono)
: spisak opcija razdvojenih zarezom biće prosleđena plejeru. Svaka opcija može biti jednostavan uključi/isključi prekidač, ili par naziva i vrednostri.
: **naziv=vrednost
: **naziv=neka vrednost sa razmacima"';
$string['viewreports'] = 'Pogledaj izveštaje za {$a} korisnika';
$string['views'] = 'Pregledi';
$string['weighting'] = 'Vrednovanje';
$string['wrong'] = 'Pogrešno';
$string['zeroduration'] = 'Bez trajanja';
$string['zeroscore'] = 'Nula bodova';
