<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'pt', version '4.0'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'A atividade está a ser apagada...';
$string['agedigitalconsentmapinvalidage'] = 'Não foi possível aceder a {$a->url} para verificar a notificação de pagamento instantâneo: {$a->result}';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" tem mais ou menos que um separador de vírgula.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" não é um valor válido para o país.';
$string['agedigitalconsentmapinvaliddefault'] = 'O valor predefinido (*) está em falta.';
$string['agelocationverificationdisabled'] = 'Verificação de idade e localização desativada';
$string['alreadyloggedin'] = 'Está autenticado como {$a}. Tem de sair antes de se autenticar como um utilizador diferente.';
$string['authnotexisting'] = 'O módulo de autorização não existe';
$string['backupcontainexternal'] = 'Esta cópia de segurança contém servidores de rede externos Moodle que não estão configurados localmente';
$string['backuptablefail'] = 'As tabelas da cópia de segurança NÃO foram configuradas com sucesso!';
$string['blockcannotconfig'] = 'Este bloco não permite configuração global.';
$string['blockcannotinistantiate'] = 'Erro ao instanciar objeto de bloco.';
$string['blockcannotread'] = 'Não é possível ler os dados do bloco com o id= {$a}';
$string['blockdoesnotexist'] = 'O bloco não existe';
$string['blockdoesnotexistonpage'] = 'O bloco (id={$a->instanceid}) não existe na página ({$a->url}).';
$string['blocknameconflict'] = 'Conflito de nomes: o  bloco {$a->name} possui o mesmo titulo do bloco: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Comentário callback rejeitou este comentário.';
$string['cannotaddcoursemodule'] = 'Não foi possível adicionar um novo módulo disciplina';
$string['cannotaddcoursemoduletosection'] = 'Não foi possível adicionar o novo módulo da disciplina à secção';
$string['cannotaddmodule'] = '{$a} módulo não pode ser adicionado à lista de módulos!';
$string['cannotaddnewmodule'] = 'Não foi possível adicionar um novo módulo {$a}';
$string['cannotaddrss'] = 'Não possui permissões para adicionar listas RSS';
$string['cannotaddthisblocktype'] = 'Não pode adicionar um bloco {$a} a esta página.';
$string['cannotassignrole'] = 'Não é possível atribuir papel na disciplina';
$string['cannotassignrolehere'] = 'Não tem permissão para atribuir este papel (id = {$a->roleid}) neste contexto ({$a->context})';
$string['cannotassignselfasparent'] = 'Não pode atribuir-se como pai de si próprio!';
$string['cannotcallscript'] = 'Não pode designar este script desta forma';
$string['cannotcallusgetselecteduser'] = 'Não pode designar user_selector::get_selected_user se selecionar vários.';
$string['cannotcreatebackupdir'] = 'Não foi possível criar a pasta backupdata. O administrador do site necessita de corrigir as permissões do ficheiro.';
$string['cannotcreatecategory'] = 'A categoria não foi inserida';
$string['cannotcreatedboninstall'] = '<p>Não é possível criar a base de dados.</p><p>A base de dados especificada não existe e o utilizador indicado não tem permissão para criar a base de dados.</p><p>O administrador do site deve verificar a configuração da base de dados.</p>';
$string['cannotcreategroup'] = 'Ocorreu um erro ao criar o grupo';
$string['cannotcreatelangbase'] = 'Erro: Não foi possível criar a pasta dos pacotes linguísticos';
$string['cannotcreatelangdir'] = 'Não é possível criar a pasta de pacotes linguísticos';
$string['cannotcreateorfindstructs'] = 'Erro a pesquisar ou a criar estruturas de secção para esta disciplina';
$string['cannotcreatepopupwin'] = 'Elemento Indefinido - não pode criar janela pop-up';
$string['cannotcreatesitedir'] = 'Não é possível criar a pasta do site. O administrador do site necessita de ajustar as permissões.';
$string['cannotcreatetempdir'] = 'Não é possível criar a pasta de ficheiros temporários';
$string['cannotcreateuploaddir'] = 'Não é possível criar a pasta de carregamento.O administrador do site necessita de ajustar as permissões.';
$string['cannotcustomisefiltersblockuser'] = 'Não pode personalizar filtros em contextos de utilizador ou de bloco.';
$string['cannotdeletebackupids'] = 'Não foi possível apagar os ids anteriores das cópias de segurança';
$string['cannotdeletecategorycourse'] = 'Não foi possível apagar a disciplina "{$a}".';
$string['cannotdeletecategoryquestions'] = 'Não foi possível apagar perguntas da categoria "{$a}"';
$string['cannotdeletecourse'] = 'Não tem permissão para apagar esta disciplina';
$string['cannotdeletecustomfield'] = 'Ocorreu um erro ao apagar os dados do campo personalizado';
$string['cannotdeletedir'] = 'Não é possível apagar ({$a})';
$string['cannotdeletefile'] = 'Não é possível apagar este ficheiro';
$string['cannotdeleterole'] = 'Não pode ser apagado, porque {$a}';
$string['cannotdeleterolewithid'] = 'Não foi possível apagar o papel com ID {$a}';
$string['cannotdeletethisrole'] = 'Não é possível apagar este papel porque é usado pelo sistema ou por ser o último papel com permissões de administrador.';
$string['cannotdisableformat'] = 'O formato predefinido não pode ser desativado.';
$string['cannotdownloadcomponents'] = 'Não é possível descarregar os componentes.';
$string['cannotdownloadlanguageupdatelist'] = 'Não é possível descarregar a lista de atualizações dos pacotes linguísticos a partir de download.moodle.org';
$string['cannotdownloadzipfile'] = 'Não é possível descarregar o ficheiro Zip.';
$string['cannoteditcomment'] = 'Este comentário não é seu para que o possa editar!';
$string['cannoteditcommentexpired'] = 'Não pode editar isto. O tempo expirou!';
$string['cannoteditpostorblog'] = 'Não pode postar ou editar blogues';
$string['cannoteditsiteform'] = 'Não é possível editar a disciplina do site usando este formulário';
$string['cannotedituserpreferences'] = 'Não é possível editar as preferências deste utilizador';
$string['cannotedityourprofile'] = 'Não pode editar o seu perfil';
$string['cannotexecduringupgrade'] = 'Não pode ser executado durante a atualização';
$string['cannotfindcategory'] = 'Não é possível encontrar a pasta com o ID -  {$a} na base de dados';
$string['cannotfindcomponent'] = 'Não é possível encontrar o componente';
$string['cannotfindcontext'] = 'Não foi possível encontrar o contexto';
$string['cannotfindcourse'] = 'Não foi possível encontrar a disciplina';
$string['cannotfinddocs'] = 'Não é possível encontrar "{$a}" no pacote linguístico';
$string['cannotfindgradeitem'] = 'Não é possível encontrar o grade_item';
$string['cannotfindgroup'] = 'Não é possível encontrar o grupo';
$string['cannotfindhelp'] = 'Não é possível encontrar os ficheiros de ajuda do idioma "{$a}"';
$string['cannotfindinfo'] = 'Não é possível encontrar informação para: "{$a}"';
$string['cannotfindlang'] = 'Não é possível encontrar o pacote linguístico "{$a}"!';
$string['cannotfindteacher'] = 'Não é possível encontrar o professor';
$string['cannotfinduser'] = 'Não é possível encontrar o nome de utilizador "{$a}"';
$string['cannotgeoplugin'] = 'Não é possível ligar ao módulo geoPlugin em http://www.geoplugin.com. Verifique as configurações do proxy ou instale o ficheiro de dados MaxMind GeoLite City';
$string['cannotgetblock'] = 'Não foi possível recuperar os blocos do banco de dados';
$string['cannotgetcats'] = 'Não é possível obter registos da categoria';
$string['cannotgetdata'] = 'Não é possível obter dados';
$string['cannotgradeuser'] = 'Não é possível avaliar este utilizador';
$string['cannothaveparentcate'] = 'A categoria da disciplina não pode ter ascendente!';
$string['cannotimport'] = 'Erro de importação';
$string['cannotimportformat'] = 'Desculpe, importar esse formato ainda não está implementado!';
$string['cannotimportgrade'] = 'Ocorreu um erro na importação de notas';
$string['cannotinsertgrade'] = 'Não é possível inserir notas sem o ID da disciplina!';
$string['cannotinsertrate'] = 'Não foi possível inserir uma nova avaliação ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Não foi possível inserir o novo registo com o ID {$a}';
$string['cannotmailconfirm'] = 'Ocorreu um erro no envio do e-mail de confirmação da mudança de senha';
$string['cannotmanualctrack'] = 'A atividade não prevê acompanhamento da conclusão manual';
$string['cannotmapfield'] = 'Foi detetada colisão entre correspondências - dois campos correspondem ao mesmo item de avaliação {$a}';
$string['cannotmarktopic'] = 'Não é possível marcar este tópico para esta disciplina';
$string['cannotmigratedatacomments'] = 'Não é possível migrar os comentários';
$string['cannotmodulename'] = 'Não é possível obter o nome do módulo no menu de navegação';
$string['cannotmoduletype'] = 'Não é possível obter o tipo de módulo no menu de navegação';
$string['cannotmovecategory'] = 'Não é possível mover a categoria';
$string['cannotmovecourses'] = 'Não é possível mover as disciplinas da categoria onde estão para outra.';
$string['cannotmoverolewithid'] = 'Não é possível mover o papel com ID {$a}';
$string['cannotopencsv'] = 'Não é possível abrir o ficheiro CSV';
$string['cannotopenfile'] = 'Não é possível abrir o ficheiro ({$a})';
$string['cannotopenforwrit'] = 'Não é possível abrir para editar ({$a})';
$string['cannotopentemplate'] = 'Não é possível abrir o ficheiro modelo ({$a})';
$string['cannotopenzip'] = 'Não é possível abrir o ficheiro Zip, provavelmente devido a um bug na extensão 64 bits.';
$string['cannotoverridebaserole'] = 'Não é possível redefinir as permissões do papel de base';
$string['cannotoverriderolehere'] = 'Não tem permissão para redefinir este papel (id = {$a->roleid}) neste contexto ({$a->context})';
$string['cannotreadfile'] = 'Não é possível ler o ficheiro ({$a})';
$string['cannotreadtmpfile'] = 'Erro ao ler ficheiro temporário';
$string['cannotreaduploadfile'] = 'Não foi possível ler o ficheiro submetido';
$string['cannotremovefrommeta'] = 'Não foi possível apagar a disciplina selecionada desta meta-disciplina!';
$string['cannotreprocessgrades'] = 'Não foi possível processar novamente as notas para esta atividade: {$a}';
$string['cannotresetguestpwd'] = 'Não é possível repor a senha do visitante';
$string['cannotresetmail'] = 'Ocorreu um erro ao alterar a senha e enviar por e-mail';
$string['cannotresetthisrole'] = 'Não é possível repor as definições deste papel';
$string['cannotrestore'] = 'Ocorreu um erro e o restauro não pôde ser concluído!';
$string['cannotrestoreadminorcreator'] = 'Necessita de ser um criador ou administrador para restaurar numa nova disciplina!';
$string['cannotrestoreadminoredit'] = 'Necessita de ser um professor editor ou administrador para restaurar na disciplina selecionada!';
$string['cannotsaveagreement'] = 'Não foi possível guardar a sua aceitação';
$string['cannotsaveblock'] = 'Ocorreu um erro ao configurar o bloco';
$string['cannotsavecomment'] = 'Não é possível guardar o comentário';
$string['cannotsavedata'] = 'Não é possível guardar os dados';
$string['cannotsavefile'] = 'Não é possível guardar o ficheiro "{$a}"!';
$string['cannotsavemd5file'] = 'Não é possível guardar o ficheiro md5';
$string['cannotsavezipfile'] = 'Não é possível guardar o ficheiro Zip';
$string['cannotservefile'] = 'Sem acesso devido a problemas na configuração do servidor.';
$string['cannotsetparentforcatoritem'] = 'Não é possível configurar o ascendente para a categoria ou item da disciplina!';
$string['cannotsetpassword'] = 'Não foi possível definir a senha do utilizador';
$string['cannotsetprefgrade'] = 'Não foi possível definir as preferências da agregação para {$a}, nesta categoria da pauta.';
$string['cannotsettheme'] = 'Não foi possível definir o tema!';
$string['cannotsetupblock'] = 'As tabelas dos blocos NÃO foram configuradas com sucesso!';
$string['cannotsetupcapformod'] = 'Não foi possível configurar as permissões para {$a}';
$string['cannotsetupcapforplugin'] = 'Não foi possível configurar as permissões para {$a}';
$string['cannotshowhidecoursesincategory'] = 'Não é possível mostrar/ocultar as disciplinas da categoria {$a}';
$string['cannotsignup'] = 'Não pode criar uma nova conta uma vez que já se encontra autenticado como {$a}.';
$string['cannotswitcheditmodeon'] = 'Não foi possível ativar o modo de edição';
$string['cannotunassigncap'] = 'Não foi possível remover a permissão descontinuada {$a->cap} do papel {$a->role}';
$string['cannotunassignrolefrom'] = 'Não é possível subscrever este utilizador do papel com o ID: {$a}';
$string['cannotunzipfile'] = 'Não é possível descompactar o ficheiro Zip';
$string['cannotupdatemod'] = 'Não foi possível atualizar {$a}';
$string['cannotupdatepasswordonextauth'] = 'Falha ao atualizar a senha na autenticação externa: {$a}. Veja os registos de atividade do servidor para obter mais detalhes.';
$string['cannotupdateprofile'] = 'Erro ao atualizar registo do utilizador';
$string['cannotupdaterecord'] = 'Não foi possível atualizar o registo com ID {$a}';
$string['cannotupdaterss'] = 'Não é possível atualizar a lista RSS';
$string['cannotupdatesubcourse'] = 'Não foi possível atualizar uma disciplina filha!';
$string['cannotupdateusermsgpref'] = 'Não foi possível atualizar as preferências de mensagem do utilizador';
$string['cannotupdateuseronexauth'] = 'Falha ao atualizar os dados do utilizador na autenticação externa: {$a}. Veja os registos de atividade do servidor para obter mais detalhes.';
$string['cannotuploadfile'] = 'Ocorreu um erro ao processar o ficheiro submetido';
$string['cannotuseadmin'] = 'Precisa de ser o administrador da plataforma para usar esta página';
$string['cannotuseadminadminorteacher'] = 'Precisa de ter o papel de professor ou administrador da plataforma para usar esta página';
$string['cannotusepage'] = 'Apenas professores e administradores podem usar esta página';
$string['cannotusepage2'] = 'Não pode usar esta página';
$string['cannotviewcategory'] = 'Não tem permissão para ver esta lista de disciplinas.';
$string['cannotviewprofile'] = 'Não pode ver o perfil deste utilizador';
$string['cannotviewreport'] = 'Não pode ver este relatório';
$string['cannotwritefile'] = 'Não pode editar o ficheiro ({$a})';
$string['categoryerror'] = 'Erro na categoria';
$string['categoryidnumbertaken'] = 'Este número de identificação já está a ser usado por outra categoria';
$string['categorynamerequired'] = 'O nome da categoria é obrigatório';
$string['categorytoolong'] = 'O nome da categoria é muito longo';
$string['commentmisconf'] = 'O comentário com o ID não está configurado';
$string['componentisuptodate'] = 'O componente está atualizado.';
$string['confirmationnotenabled'] = 'A confirmação do utilizador não está ativada neste site';
$string['confirmsesskeybad'] = 'A sua chave de sessão não pôde ser confirmada de modo a poder realizar esta ação. Este método de segurança previne a execução, acidental ou maliciosa, de funções importantes em seu nome. Certifique-se de que pretende realmente executar esta função.';
$string['contenttypenotfound'] = 'O tipo de banco de conteúdos \'{$a}\' não existe ou não é reconhecido.';
$string['contentvisibilitynotfound'] = 'A visibilidade do conteúdo com o valor \'{$a}\' não existe ou não é reconhecida.';
$string['couldnotassignrole'] = 'Ocorreu um erro sério, mas indeterminado, durante a operação de atribuição de um papel a si próprio.';
$string['couldnotupdatenoexistinguser'] = 'Não é possível atualizar este utilizador - não existe';
$string['couldnotverifyagedigitalconsent'] = 'Ocorreu um erro ao tentar verificar a idade do consentimento digital.<br /> Entre em contacto com o administrador.';
$string['countriesphpempty'] = 'Erro: O ficheiro countries.php no pacote linguístico {$a} está vazio ou não existe.';
$string['coursedoesnotbelongtocategory'] = 'A disciplina não pertence a esta categoria';
$string['courseformatnotfound'] = 'O formato da disciplina \'{$a}\' não existe ou não é reconhecido.';
$string['coursegroupunknown'] = 'A disciplina correspondente ao grupo {$a} não foi especificada';
$string['courseidnotfound'] = 'Este ID de disciplina não existe.';
$string['courseidnumbertaken'] = 'O número de ID já está a ser usado noutra disciplina ({$a})';
$string['coursemisconf'] = 'A disciplina está mal configurada';
$string['courserequestdisabled'] = 'Lamentamos, mas os pedidos de disciplina foram desativados pelo administrador.';
$string['csvcolumnduplicates'] = 'Foram detetadas colunas duplicadas.';
$string['csvemptyfile'] = 'O ficheiro CSV está vazio.';
$string['csvfewcolumns'] = 'Não existem colunas suficientes, verifique a definição do separador';
$string['csvfileerror'] = 'Existe algo de errado com o formato do ficheiro CSV. Verifique a correspondência entre o número de cabeçalhos e colunas e que o separador e a codificação do ficheiro estão corretos. {$a}';
$string['csvinvalidcols'] = '<b>Ficheiro CSV inválido:</b> A primeira linha deve incluir o "Nome dos campos" e o ficheiro tem de ser do tipo <br />"Campos/Separados por vírgulas"<br />or<br /> "Campos com código CAVV/Separados por vírgulas';
$string['csvinvalidcolsnum'] = 'Ficheiro CSV inválido - cada linha deve ter 49 ou 70 campos';
$string['csvloaderror'] = 'Ocorreu um erro ao carregar o ficheiro CSV: {$a}';
$string['csvnodata'] = 'Ficheiro CSV inválido - O ficheiro CSV tem cabeçalhos, mas não contém dados.';
$string['csvweirdcolumns'] = 'Formato de ficheiro CSV inválido; o número de colunas não é constante!';
$string['dbconnectionfailed'] = '<p>Erro: Falhou a ligação à Base de dados</p>
<p>É possível que a base de dados esteja sobrecarregada ou não está a funcionar corretamente.</p>
<p>O administrador do site também deve verificar se os dados da base de dados foram corretamente especificados no ficheiro config.php</p>';
$string['dbdriverproblem'] = '<p>Erro: foi detetado um erro no driver da base de dados.</p>
<p>O administrador do site deve verificar a configuração do servidor.</p>
<p>{$a}</p>';
$string['dbsessionbroken'] = 'Foram detetados problemas sérios na base de dados.<br /><br />Avise o administrador do servidor.';
$string['dbsessionhandlerproblem'] = 'A criação da base de dados de sessão falhou. Por favor, notifique o administrador do servidor.';
$string['dbsessionmysqlpacketsize'] = 'Foi detetado um erro grave na sessão. Por favor, avise o administrador. Este problema é provavelmente causado por um valor demasiado baixo do parâmetro max_allowed_packet na configuração do MySQL.';
$string['dbupdatefailed'] = 'A atualização da base de dados falhou.';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" não pode ser modificado. Foi encontrada dependência com {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Erro ao executar o sql DDL';
$string['ddlfieldalreadyexists'] = 'O campo "{$a}" já existe';
$string['ddlfieldnotexist'] = 'O campo "{$a->fieldname}" não existe na tabela "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'A tabela "{$a}" já existe';
$string['ddltablenotexist'] = 'A tabela "{$a}" não existe';
$string['ddlunknownerror'] = 'Erro desconhecido DDL library';
$string['ddlxmlfileerror'] = 'Foram encontrados erros nos ficheiros XML da base de dados';
$string['ddsequenceerror'] = 'Definição da tabela "{$a}" incorreta; só pode haver uma coluna auto e deve ser definida como uma chave.';
$string['destinationcmnotexit'] = 'O módulo da disciplina de destino não existe';
$string['detectedbrokenplugin'] = 'O módulo \'{$a}\' está com defeito ou desatualizado e, por isso, não pode continuar.';
$string['dmlexceptiononinstall'] = '<p>Ocorreu um erro de base de dados [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Erro ao analisar a consulta SQL';
$string['dmlreadexception'] = 'Ocorreu um erro na leitura da base de dados';
$string['dmltransactionexception'] = 'Ocorreu um erro numa transição da base de dados';
$string['dmlwriteexception'] = 'Ocorreu um erro ao guardar na base de dados';
$string['downgradedcore'] = 'ERRO!!! O código que está a usar é mais ANTIGO que a versão com que foram feitas as base de dados!';
$string['downloadedfilecheckfailed'] = 'A verificação do ficheiro descarregado falhou.';
$string['duplicatefieldname'] = 'Nome no campo "{$a}" em duplicado';
$string['duplicatenosupport'] = 'A atividade \'{$a->modname}\' não pode ser duplicada porque o módulo {$a->modtype} não suporta as funcionalidades de cópia de segurança e restauro.';
$string['duplicateparaminsql'] = 'ERRO: nome duplicado do parâmetro na consulta';
$string['duplicaterolename'] = 'Já existe um papel com este nome!';
$string['duplicateroleshortname'] = 'Já existe um papel com este nome curto!';
$string['duplicateusername'] = 'Nome de utilizador duplicado - registo ignorado';
$string['emailfail'] = 'Falhou o envio de e-mail';
$string['encryption_decryptfailed'] = 'Erro na desencriptação';
$string['encryption_encryptfailed'] = 'Erro na encriptação';
$string['encryption_invalidkey'] = 'Chave inválida';
$string['encryption_keyalreadyexists'] = 'Chave já existente';
$string['encryption_nokey'] = 'Chave não encontrada';
$string['encryption_wrongmethod'] = 'Os dados não correspondem a um método de criptografia compatível';
$string['enddatebeforestartdate'] = 'A data de conclusão da disciplina deve ser posterior à data de início.';
$string['error'] = 'Ocorreu um erro';
$string['error_question_answers_missing_in_db'] = 'Não foi possível encontrar uma resposta correspondente a "{$a->answer}" na tabela \'question_answers\' da base de dados. Ocorreu ao restaurar a pergunta com o id {$a->filequestionid} do ficheiro da cópia de segurança, que correspondia à pergunta existente com o id {$a->dbquestionid} na base de dados .';
$string['errorcleaningdirectory'] = 'Erro ao limpar a pasta "{$a}"';
$string['errorcopyingfiles'] = 'Erro ao copiar ficheiros';
$string['errorcreatingdirectory'] = 'Erro ao criar pasta "{$a}"';
$string['errorcreatingfile'] = 'Erro ao criar o ficheiro "{$a}"';
$string['errorcreatingrole'] = 'Erro ao criar papel';
$string['errorfetchingrssfeed'] = 'Erro ao pesquisar por lista RSS';
$string['erroronline'] = 'Erro na linha {$a}';
$string['erroroutput'] = 'Erro de envio. O redirecionamento automático vai ser desativado.';
$string['errorparsingxml'] = 'Erro ao analisar XML: {$a->errorstring} na linha {$a->errorline}, caráter {$a->errorchar}';
$string['errorprocessingarchive'] = 'Erro ao processar o ficheiro de arquivo';
$string['errorreadingfile'] = 'Erro na leitura do ficheiro "{$a}"';
$string['errorsavingrequest'] = 'Ocorreu um erro ao salvar o seu pedido.';
$string['errorsettinguserpref'] = 'Ocorreu um erro de configuração das preferências de utilizador';
$string['errorunzippingfiles'] = 'Erro ao descompactar os ficheiros';
$string['expiredkey'] = 'Chave expirada';
$string['externalauthpassworderror'] = 'Senha não-vazia para autenticação externa';
$string['externalfilenolocation'] = 'Os ficheiros externos não possuem caminho';
$string['failtoloadblocks'] = 'Um ou mais blocos estão registados na base de dados, mas todos eles falham ao carregar!';
$string['fieldrequired'] = 'o campo "{$a}" é de preenchimento obrigatório';
$string['fileexists'] = 'O ficheiro existe';
$string['filemismatch'] = 'Incompatibilidade de nome do ficheiro. O ficheiro "{$a->current}" deve ser {$a->file}';
$string['filenotfound'] = 'Não foi possível encontrar o ficheiro solicitado';
$string['filenotreadable'] = 'O ficheiro não é legível';
$string['filterdoesnothavelocalconfig'] = 'O filtro {$a} não permite configuração local.';
$string['filternotactive'] = 'O filtro {$a} não está ativo!';
$string['filternotenabled'] = 'O filtro não foi ativado!';
$string['filternotinstalled'] = 'O filtro {$a} não foi instalado';
$string['forumblockingtoomanyposts'] = 'Ultrapassou o limite de envio de mensagens estabelecido para este fórum.';
$string['functionalityremoved'] = 'Está a tentar aceder a uma funcionalidade que foi removida.';
$string['generalexceptionmessage'] = 'Exceção - {$a}';
$string['gradecantregrade'] = 'Ocorreu um erro durante o cálculo da nota: {$a}';
$string['gradepubdisable'] = 'A publicação de notas está desativada';
$string['gradesneedregrading'] = 'É necessário recalcular as notas da disciplina';
$string['groupalready'] = 'O utilizador já pertence ao grupo {$a}';
$string['groupexistforcourse'] = 'Já existe um grupo "{$a}" nesta disciplina';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: O grupo "{$a->name}" com o número de identificação "{$a->idnumber}" já existe nesta disciplina';
$string['grouphasidnumber'] = 'O grupo "{$a}" possui um número de identificação (ID) e pode ter sido criado por um sistema externo. Não tem permissão para remover este grupo.';
$string['groupinghasidnumber'] = 'O agrupamento "{$a}" possui um número de identificação (ID) e pode ter sido criado por um sistema externo. Não tem permissão para remover este agrupamento.';
$string['groupingnotaddederror'] = 'O agrupamento "{$a}" não foi adicionado';
$string['groupnotaddederror'] = 'O grupo "{$a}" não foi adicionado';
$string['groupnotaddedtogroupingerror'] = 'O grupo "{$a->groupname}" não foi adicionado ao agrupamento "{$a->groupingname}"';
$string['groupunknown'] = 'O grupo {$a} não está associado à disciplina especificada';
$string['groupusernotmember'] = 'O utilizador não é membro deste grupo.';
$string['guestcantaccessprofiles'] = 'Os visitantes não podem aceder aos perfis dos utilizador. Autentique-se com uma conta de utilizador para continuar.';
$string['guestnocomment'] = 'Os visitantes não têm permissão para inserir comentários!';
$string['guestnoeditprofile'] = 'Os visitantes não podem editar o seu perfil';
$string['guestnoeditprofileother'] = 'O perfil do visitante não pode ser editado';
$string['guestnorate'] = 'Os visitantes não podem avaliar mensagens';
$string['guestsarenotallowed'] = 'O utilizador visitante não tem permissão para essa ação';
$string['hackdetected'] = 'Hack ataque detetado!';
$string['hashpoolproblem'] = 'Conteúdo incorreto {$a}';
$string['headersent'] = 'Cabeçalhos já enviados';
$string['idnumbertaken'] = 'Este número de ID já está a ser usado';
$string['idnumbertoolong'] = 'O número de identificação é muito longo';
$string['importformatnotimplement'] = 'Desculpe, importar esse formato ainda não está implementado!';
$string['incorrectext'] = 'O ficheiro tem uma extensão incorreta';
$string['inplaceeditableerror'] = 'Erro ao chamar o processador de atualização';
$string['installproblem'] = 'Normalmente não é possível recuperar de erros desencadeados durante a instalação. Poderá ser preciso criar uma nova base de dados ou usar um prefixo diferente para a base de dados, caso pretenda repetir a instalação.';
$string['internalauthpassworderror'] = 'Falta senha ou senha inválida de autenticação interna';
$string['invalidaccess'] = 'Esta página não foi acedida da forma correta';
$string['invalidaccessparameter'] = 'Parâmetro de acesso inválido';
$string['invalidaction'] = 'Parâmetro de ação inválido';
$string['invalidactivityid'] = 'ID de atividade inválido';
$string['invalidadminsettingname'] = 'Configuração admin inválida ({$a})';
$string['invalidargorconf'] = 'Sem argumentos válidos ou configuração incorreta do servidor';
$string['invalidarguments'] = 'Os argumentos indicados não são válidos.';
$string['invalidblockinstance'] = 'Instância de bloco inválida para: {$a}';
$string['invalidbulkenrolop'] = 'Operação inválida é necessário o volume da inscrição.';
$string['invalidcategory'] = 'Categoria incorreta!';
$string['invalidcategoryid'] = 'ID de categoria incorreto!';
$string['invalidcomment'] = 'Comentário incorreto';
$string['invalidcommentarea'] = 'Area de comentários inválida';
$string['invalidcommentid'] = 'ID de comentário inválido';
$string['invalidcommentitemid'] = 'ID do item de comentário inválido';
$string['invalidcommentparam'] = 'Os parâmetros são inválidos';
$string['invalidcomponent'] = 'O nome é inválido';
$string['invalidconfirmdata'] = 'Informação de confirmação inválida';
$string['invalidcontentid'] = 'ID de conteúdo inválido';
$string['invalidcontext'] = 'Contexto inválido';
$string['invalidcountrycode'] = 'Código de país inválido: {$a}';
$string['invalidcourse'] = 'Disciplina não válida';
$string['invalidcourseformat'] = 'Formato da disciplina inválido';
$string['invalidcourseid'] = 'Está a tentar usar ID de disciplina inválido';
$string['invalidcourselevel'] = 'Nível de contexto inválido';
$string['invalidcoursemodule'] = 'O ID do módulo da disciplina é inválido';
$string['invalidcoursenameshort'] = 'O nome curto da disciplina é inválido';
$string['invaliddata'] = 'Os dados submetidos são inválidos';
$string['invaliddatarootpermissions'] = 'Foram detetadas permissões inválidas ao tentar criar a pasta. Ative a exibição de mensagens de erro para mais detalhes.';
$string['invaliddevicetype'] = 'O tipo é inválido';
$string['invalidelementid'] = 'ID do elemento incorreto!';
$string['invalidentry'] = 'Não é uma entrada válida!';
$string['invalidevent'] = 'Evento inválido';
$string['invalidfieldname'] = '"{$a}" não é um nome de campo válido';
$string['invalidfiletype'] = '"{$a}" não é um tipo de ficheiro válido';
$string['invalidformatpara'] = 'Formato incorreto para o parâmetro escolhido';
$string['invalidformdata'] = 'Formulário de dados incorreto';
$string['invalidfunction'] = 'Função incorreta';
$string['invalidgradeitemid'] = 'ID do item de avaliação incorreto';
$string['invalidgroupid'] = 'Especificado ID de grupo incorreto';
$string['invalidipformat'] = 'Formato inválido de endereço IP';
$string['invaliditemid'] = 'ID do item incorreto';
$string['invalidkey'] = 'Chave incorreta';
$string['invalidlanguagecode'] = 'Código de idioma inválido: {$a}';
$string['invalidlegacy'] = 'Definição incorreta de papel para o tipo de legado: {$a}';
$string['invalidmd5'] = 'A variável de verificação está errada - tente novamente.';
$string['invalidmode'] = 'Modo ({$a}) inválido';
$string['invalidmodule'] = 'Módulo inválido';
$string['invalidmoduleid'] = 'ID do módulo inválido: {$a}';
$string['invalidmodulename'] = 'Nome do módulo inválido: {$a}';
$string['invalidnum'] = 'Valor numérico inválido';
$string['invalidnumkey'] = 'A matriz $conditions não pode conter chaves numéricas. Por favor, corrija o código!!';
$string['invalidoutcome'] = 'ID do resultado da aprendizagem incorreto';
$string['invalidpagesize'] = 'O tamanho da página é inválido';
$string['invalidpasswordpolicy'] = 'A política de senha é inválida';
$string['invalidpaymentmethod'] = 'O método de pagamento é inválido: {$a}';
$string['invalidpersistenterror'] = 'Erro: {$a}';
$string['invalidqueryparam'] = 'ERRO: Número incorreto de parâmetros de consulta. Esperado {$a->expected}, obteve {$a->actual}.';
$string['invalidratingarea'] = 'Area de avaliações inválida';
$string['invalidrecord'] = 'Não foi possível encontrar dados referentes a este registo na tabela \'{$a}\' da base de dados.';
$string['invalidrecordunknown'] = 'Não foi possível encontrar os dados na base de dados';
$string['invalidrequest'] = 'Pedido inválido';
$string['invalidrole'] = 'Papel inválido';
$string['invalidroleid'] = 'ID do papel inválido';
$string['invalidscaleid'] = 'ID de escala inválido';
$string['invalidsection'] = 'Registo de módulo de disciplina contém secção inválida';
$string['invalidsesskey'] = 'É possível que a sua sessão tenha expirado. Autentique-se novamente.';
$string['invalidshortname'] = 'Nome curto da disciplina inválido';
$string['invalidsourcefield'] = 'O campo do rascunho do ficheiro de origem é inválido';
$string['invalidstatedetected'] = 'Algo de errado ocorreu: {$a}. Normalmente isso nunca deveria acontecer.';
$string['invalidurl'] = 'URL inválido';
$string['invaliduser'] = 'Utilizador inválido';
$string['invaliduserdata'] = 'Dados inválidos do utilizador: {$a}';
$string['invaliduserfield'] = 'Campo de utilizador inválido: {$a}';
$string['invaliduserid'] = 'ID de utilizador inválido';
$string['invalidusername'] = 'O nome de utilizador contém caracteres inválidos';
$string['invalidusernameblank'] = 'O nome de utilizador não pode ficar em branco';
$string['invalidxmlfile'] = '"{$a}" não é um ficheiro XML válido';
$string['iplookupfailed'] = 'Não é possível encontrar informação geográfica sobre este endereço IP {$a}';
$string['iplookupprivate'] = 'Não é possível exibir a pesquisa de endereço de IP privado';
$string['ipmismatch'] = 'Incompatibilidade no endereço IP do cliente';
$string['listcantmovedown'] = 'Não foi possível deslocar o item para baixo, já é o último item do seu nível.';
$string['listcantmoveleft'] = 'Não foi possível deslocar o item para a esquerda porque não existe item ascendente.';
$string['listcantmoveright'] = 'Não foi possível deslocar o item para a direita; não existe um outro item do mesmo nível que se possa tornar o item ascendente. Passe o item para baixo de outro e depois poderá deslocá-lo para a direita.';
$string['listcantmoveup'] = 'Não foi possível deslocar o item para cima, já é o primeiro item do seu nível.';
$string['listnochildren'] = 'Não foi encontrado qualquer item descendente.';
$string['listnoitem'] = 'O item não foi encontrado';
$string['listnopeers'] = 'Não foram encontrados mais items do mesmo nível.';
$string['listupdatefail'] = 'A operação da base de dados falhou ao editar a hierarquia da lista.';
$string['logfilenotavailable'] = 'Os registos de atividade não estão disponíveis';
$string['loginasnoenrol'] = 'Não pode inscrever nem cancelar inscrições quando está numa sessão "Entrar como".';
$string['loginasonecourse'] = 'Não pode entrar nesta disciplina.<br /> Tem de terminar a sessão "Entrar como" antes de entrar em qualquer outra disciplina.';
$string['maxareabytes'] = 'Este ficheiro é maior do que o espaço restante nesta área.';
$string['maxbytesfile'] = 'O ficheiro \'{$a->file}\' é muito grande. Apenas pode carregar ficheiros com um tamanho máximo de {$a->size}.';
$string['maxdraftitemids'] = 'O carregamento dos seus ficheiros está temporariamente limitado uma vez que carregou um grande volume de ficheiros. Tente novamente mais tarde.';
$string['messageundeliveredbynotificationsettings'] = 'A mensagem não foi enviada porque as mensagens pessoais entre utilizadores (nas Configurações das notificações) foram desativadas por um administrador do site.';
$string['messagingdisable'] = 'A troca de mensagens está desativada neste site';
$string['mimetexisnotexist'] = 'O seu sistema não está configurado para executar mimeTeX. É necessário  obter o código fonte em C a partir de <a href="http://www.forkosh.com/mimetex.zip">http://www.forkosh.com/mimetex.zip</a>, compilá-lo e colocar o executável na pasta moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Mimetex Custom não é executável!';
$string['missing_moodle_backup_xml_file'] = 'Na cópia de segurança fica em falta o ficheiro: {$a}';
$string['missingfield'] = 'O campo "{$a}" está em falta.';
$string['missingkeyinsql'] = 'ERRO: falta o parâmetro "{$a}" na consulta';
$string['missingparam'] = 'Está em falta um parâmetro necessário ({$a})';
$string['missingparameter'] = 'Parâmetro em falta';
$string['missingrequiredfield'] = 'Um dos campos obrigatórios está em falta';
$string['missinguseranditemid'] = 'Falta algum campo necessário';
$string['missingvarname'] = 'Nome da variável obrigatório está em falta';
$string['mixedtypesqlparam'] = 'ERRO: Mixed tipos de parâmetros de consulta sql!';
$string['mnetdisable'] = 'MNET está desativada';
$string['mnetlocal'] = 'Os utilizadores remotos MNET não podem autenticar-se localmente';
$string['moduledisable'] = 'O módulo ({$a}) foi desativado para esta disciplina';
$string['moduledoesnotexist'] = 'Este módulo não existe';
$string['moduleinstancedoesnotexist'] = 'Não existem instâncias deste módulo';
$string['modulemissingcode'] = 'O módulo {$a} não contém o código necessário para executar esta função';
$string['movecatcontentstoroot'] = 'Não é permitido mover os conteúdos da categoria para a raiz . Deve mover o conteúdo para uma categoria existente!';
$string['movecatcontentstoselected'] = 'Alguns conteúdos da categoria não podem ser movidos para a categoria selecionada.';
$string['movecategorynotpossible'] = 'Não pode mover a categoria \'{$a}\' para a categoria selecionada.';
$string['movecategoryownparent'] = 'Não pode fazer da categoria \'{$a}\' a categoria ascendente de si mesma.';
$string['movecategoryparentconflict'] = 'Não pode fazer da categoria \'{$a}\' uma subcategoria de uma das suas próprias subcategorias.';
$string['mssqlrcsmodemissing'] = 'A base de dados não está a utilizar o modo READ_COMMITTED_SNAPSHOT esperado, o que poderá conduzir a resultados inesperados, principalmente em cenários de alta concorrência. Por favor, proceda à sua ativação para um funcionamento correto. Para mais informações, consulte a documentação <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Instalação MSSQL para PHP</a>.';
$string['multiplerecordsfound'] = 'Foram encontrados vários registos, apenas era esperado um registo.';
$string['multiplerestorenotallow'] = 'Não são permitidas várias restaurações!';
$string['mustbeloggedin'] = 'Tem de ter uma sessão ativa para fazer isto';
$string['mustbeteacher'] = 'Só os professores podem ver esta página';
$string['myisamproblem'] = 'As tabelas da base de dados estão a usar o motor de base de dados MyISAM. É recomendado o uso de um motor compatível com ACID, com suporte completo de transações. Ex: InnoDB.';
$string['needcopy'] = 'Tem de copiar alguma coisa antes';
$string['needcoursecategroyid'] = 'Tem de indicar o ID da disciplina ou o ID da categoria';
$string['needphpext'] = 'Necessita de adicionar suporte {$a} à sua instalação PHP';
$string['noadmins'] = 'Não há administradores!';
$string['noblocks'] = 'Não foram encontrados blocos!';
$string['nocapabilitytousethisservice'] = 'O utilizador não tem a permissão necessária para utilizar este serviço';
$string['nocategorydelete'] = 'A categoria "{$a}" não pode ser apagada!';
$string['nocontext'] = 'Essa disciplina não é um contexto válido';
$string['nodata'] = 'Sem informação';
$string['noexistingcategory'] = 'Não existe categoria';
$string['nofile'] = 'Ficheiro não encontrado';
$string['nofiltersenabled'] = 'Não há filtros ativos.';
$string['nofolder'] = 'O diretório pedido não existe';
$string['noformdesc'] = 'Nenhum ficheiro de descrição formslib foi encontrado para essa atividade.';
$string['noguest'] = 'Não existem visitantes!';
$string['noinstances'] = 'Não existe nenhuma instância de {$a} nesta disciplina!';
$string['nologinas'] = 'Não tem permissões para se autenticar como esse utilizador.';
$string['nonmeaningfulcontent'] = 'Conteúdo não significativo';
$string['noparticipants'] = 'Não foram encontrados participantes para esta disciplina';
$string['noparticipatorycms'] = 'Não tem módulos de participação, para onde possa enviar relatórios, em nenhuma disciplina.';
$string['nopermissions'] = 'Atualmente, não tem permissões para realizar a operação ({$a})';
$string['nopermissiontoaccesspage'] = 'Não tem permissão para aceder a esta página.';
$string['nopermissiontocomment'] = 'Não pode adicionar comentários';
$string['nopermissiontodelentry'] = 'Não pode apagar este comentário!';
$string['nopermissiontoeditcomment'] = 'Não pode editar mensagens de outras pessoas!';
$string['nopermissiontohide'] = 'Não tem permissão para esconder!';
$string['nopermissiontoimportact'] = 'Não possui as permissões necessárias para importar atividades para esta disciplina';
$string['nopermissiontolock'] = 'Não tem permissão para bloquear!';
$string['nopermissiontomanagegroup'] = 'Não possui as permissões necessárias para gerir grupos';
$string['nopermissiontorate'] = 'Não é permitido avaliar itens!';
$string['nopermissiontoshow'] = 'Não tem permissão para ver isto!';
$string['nopermissiontounlock'] = 'Não tem permissão para desbloquear!';
$string['nopermissiontoupdatecalendar'] = 'Não tem permissão para atualizar o evento no calendário';
$string['nopermissiontoviewcalendar'] = 'Não tem permissão para ver o evento do calendário.';
$string['nopermissiontoviewgrades'] = 'Não pode consultar as notas.';
$string['nopermissiontoviewletergrade'] = 'Falta permissão para ver as notas alfabéticas';
$string['nopermissiontoviewpage'] = 'Não tem permissão para ver esta página';
$string['nosite'] = 'Não foi encontrada disciplina de primeiro nível!';
$string['nositeid'] = 'Sem ID do site';
$string['nostartdatenoenddate'] = 'A data de conclusão da disciplina só pode ser definida se a data de início também estiver definida.';
$string['nostatstodisplay'] = 'Não existem dados disponíveis para exibição';
$string['notallowedtoupdateprefremotely'] = 'Não tem permissão para atualizar esta preferência do utilizador remotamente';
$string['notavailable'] = 'Atualmente indisponível';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Não é um membro deste grupo';
$string['notownerofkey'] = 'Não é o(a) dono(a) desta chave';
$string['nousers'] = 'Este utilizador não existe!';
$string['oauth1accesstoken'] = 'Erro OAuth 1.0: não foi possível obter o token de acesso.';
$string['oauth1requesttoken'] = 'Erro OAuth 1.0: não foi possível obter o token de solicitação - o provedor do serviço pode estar temporariamente em baixo.';
$string['oauth2refreshtokenerror'] = 'Não foi possível atualizar o token de OAuth 2. O estado de HTTP para endpoint remoto: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Não foi possível atualizar o token de OAuth 2 para um ou mais emissores. Veja o relatório da tarefa para mais detalhes.';
$string['oauth2upgradetokenerror'] = 'Não foi possível atualizar o token de OAuth 2. O estado de HTTP para endpoint remoto: {$a}';
$string['onlyadmins'] = 'Só os administradores podem fazer isso';
$string['onlyeditingteachers'] = 'Só os professores com permissões de edição podem fazer isso';
$string['onlyeditown'] = 'Só pode editar a sua própria informação';
$string['orderidnotfound'] = 'ID ordem {$a} não foi encontrado';
$string['pagenotexist'] = '<p>Ocorreu um erro pouco frequente ao tentar visualizar uma página que não existe: </p>{$a}';
$string['pagenotexisttitle'] = 'Erro 404: ficheiro não encontrado';
$string['pathdoesnotstartslash'] = 'Sem argumentos válidos fornecidos, o caminho não começa com a barra!';
$string['pleasereport'] = 'Se tiver tempo, diga-nos o que estava a tentar fazer quando ocorreu esse erro:';
$string['pluginrequirementsnotmet'] = 'O módulo "{$a->pluginname}" ({$a->pluginversion}) não pôde ser instalado porque requer uma versão mais recente do Moodle (atualmente está a utilizar a versão {$a->currentmoodle} mas é requerida a versão {$a->requiremoodle}).';
$string['pluginunsupported'] = 'O módulo "{$a->pluginname}" {$a->pluginversion} não suporta esta versão do Moodle {$a->moodleversion}. Procure informações sobre o módulo para encontrar versões suportadas.';
$string['prefixcannotbeempty'] = '<p> Erro: O prefixo da tabela da base de dados não pode estar vazio ({$a}) </p>
 <p> O administrador do site deve corrigir esse problema.</p>';
$string['prefixtoolong'] = '<p>Erro: O prefixo da tabela da base de dados é muito longo ({$a->dbfamily})</p>
<p>O administrador do site deve corrigir esse problema. O comprimento máximo para prefixos na tabela {$a->dbfamily} é {$a->maxlength} caracteres.</p>';
$string['privatefilesupload'] = 'O carregamento direto para a área de ficheiros privados do utilizador já não é suportado. Carregue os ficheiros para uma área de rascunho e, em seguida, mova-os ficheiros com core_user::add_user_private_files';
$string['processingstops'] = 'O processamento terminou aqui. Os restantes registos foram ignorados.';
$string['protected_cc_not_supported'] = 'Não é permitido Protected cartridges';
$string['querystringcannotbeempty'] = 'A query string não pode ficar vazia.';
$string['redirecterrordetected'] = 'Não há suporte para redirecionar, a execução do script terminou';
$string['refoundto'] = 'Pode ser reembolsado para {$a}';
$string['refoundtoorigi'] = 'Reembolsado para o valor original: {$a}';
$string['registrationdisabled'] = 'O registo está desativado neste site';
$string['remotedownloaderror'] = 'Não foi possível descarregar o componente para o servidor. Verifique as configurações do proxy. É altamente recomendado a instalação da extensão cURL do PHP.<br /><br />Terá de descarregar manualmente o ficheiro <a href="{$a->url}">{$a->url}</a>, copiá-lo para a pasta "{$a->dest}" no seu servidor e descompactá-lo.';
$string['remotedownloadnotallowed'] = 'Não é permitido descarregar para este servidor (o parâmetro \'allow_url_fopen\' está desativado).<br /><br />Terá que descarregar o ficheiro <a href="{$a->url}">{$a->url}</a> manualmente, copiá-lo para a pasta "{$a->dest}" no servidor e descompactá-lo.';
$string['reportnotavailable'] = 'Este tipo de relatório está disponível somente para a disciplina do site';
$string['requirecorrectaccess'] = 'URL ou porta inválido';
$string['requireloginerror'] = 'A disciplina ou atividade não está disponível';
$string['restore_path_element_missingmethod'] = 'O método de restauro {$a} está em falta. Deve ser definido por um programador.';
$string['restore_path_element_noobject'] = 'O objeto restaurado {$a} não é um objeto.';
$string['restorechecksumfailed'] = 'Ocorreu um problema com o restauro das informações armazenadas na sua sessão. Verifique os limites da memória do PHP e/ou da base de dados. O processo de restauro parou.';
$string['restrictedcontextexception'] = 'A execução de funções externas viola restrições de contexto.';
$string['restricteduser'] = 'A sua conta atual "{$a}" não tem permissões para fazer isso.';
$string['reverseproxyabused'] = 'Reverse proxy ativado. O servidor não pode ser acedido diretamente.<br/> Por favor, contacte o administrador do servidor.';
$string['rpcerror'] = 'Ooops! A sua comunicação MNET falhou! Aqui segue a mensagem de erro para passar para o administrador: {$a}';
$string['scheduledbackupsdisabled'] = 'As cópias de segurança programadas foram desativadas pelo administrador do servidor';
$string['secretalreadyused'] = 'A hiperligação de confirmação de alteração de senha já foi usado, a senha não foi alterada';
$string['sectionnotexist'] = 'Esta secção não existe';
$string['sendmessage'] = 'Enviar mensagem';
$string['sendmessagesent'] = 'Obrigado pelo seu feedback acerca de: <br>{$a}';
$string['serverconnection'] = 'Ocorreu um erro ao ligar com o servidor';
$string['servicedonotexist'] = 'Esse serviço não existe';
$string['sessioncookiesdisable'] = 'Uso incorreto de \'require_key_login()\' - os cookies da sessão devem estar desativos!';
$string['sessiondiskfull'] = 'A partição da sessão está completa. Não é possível autenticar-se neste momento. Por favor, avise o administrador do site.';
$string['sessionerroruser'] = 'A sua sessão expirou. Autentique-se novamente.';
$string['sessionerroruser2'] = 'Foi detetado um erro no servidor que afeta a sua sessão atual. Por favor, volte a autenticar-se ou reinicie o seu navegador.';
$string['sessionexpired'] = 'Sessão expirada';
$string['sessionhandlerproblem'] = 'O handler de sessão está mal configurado';
$string['sessionipnomatch'] = 'O seu número de IP parece ter mudado desde a sua autenticação. Este dispositivo de segurança previne que crackers roubem a sua identidade durante a sessão neste site. Os utilizadores normais não deveriam ver esta mensagem - peça ajuda ao administrador do site.';
$string['sessionipnomatch2'] = 'O seu número de IP parece ter mudado desde a sua autenticação. Esta funcionalidade de segurança previne que crackers roubem a sua identidade durante a sessão neste site. Pode ver este erro se estiver a utilizar redes sem fios ou se estiver em roaming entre redes diferentes. Peça ajuda ao administrador do site. <br /><br />Se pretender continuar, por favor, pressione a tecla F5 para atualizar esta página.';
$string['sessionwaiterr'] = 'Esgotou o tempo limite enquanto aguardava pelo bloqueio da sessão.<br />Aguarde que os seus pedidos atuais terminem e tente novamente mais tarde.';
$string['shortnametaken'] = 'O nome curto já está a ser utilizado por outra disciplina ({$a})';
$string['sitepolicynotagreed'] = 'A política do site não aceite: <a href="{$a}">Clique aqui para abrir a política do site.</a>';
$string['socksnotsupported'] = 'SOCKS5 proxy não é suportado em PHP4';
$string['spellcheckernotconf'] = 'O verificador ortográfico não se encontra configurado';
$string['sslonlyaccess'] = 'Por questões de segurança apenas são permitidas ligações https.';
$string['statscatchupmode'] = 'Os relatórios de atividade encontram-se em modo de atualização. Até agora foram processados {$a->daysdone} dias e estão pendentes {$a->dayspending}. Tente mais tarde!';
$string['statsdisable'] = 'As estatísticas não foram ativadas.';
$string['statsnodata'] = 'Não existem dados disponíveis para essa combinação de disciplina e período de tempo';
$string['storedfilecannotcreatefile'] = 'Não é possível criar o ficheiro de pool de ficheiro local. Por favor, verifique as permissões em dataroot e o espaço disponível em disco.';
$string['storedfilecannotcreatefiledirs'] = 'Não é possível criar a lista de pastas. Por favor, verifique as permissões de escrita na pasta dos dados.';
$string['storedfilecannotread'] = 'Não é possível ler o ficheiro. O ficheiro não existe ou existem problemas de permissão.';
$string['storedfilecannotreadfile'] = 'Não é possível ler o ficheiro \'{$a}\'. Ou o ficheiro não existe ou há um problema de permissão.';
$string['storedfilenotcreated'] = 'Não é possível criar o ficheiro \'{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}\'';
$string['storedfileproblem'] = 'Exceção desconhecida nos ficheiros locais ({$a})';
$string['tagdisabled'] = 'As etiquetas estão desativadas!';
$string['tagnotfound'] = 'A senha especificada não foi encontrada na base de dados';
$string['targetdatabasenotempty'] = 'A base de dados de destino não está vazia. A transferência foi cancelada por razões de segurança.';
$string['textconditionsnotallowed'] = 'Não são permitidas comparações de condições de colunas de texto. Utilize a função sql_compare_text() no seu pedido.';
$string['themenotinstall'] = 'O tema não está instalado!';
$string['tokengenerationfailed'] = 'Não é possível gerar um novo token.';
$string['transactionvoid'] = 'A transação não pode ser anulada porque já foi cancelada';
$string['unenrolerror'] = 'Ocorreu um erro ao tentar cancelar o papel dessa pessoa';
$string['unicodeupgradeerror'] = 'A sua base de dados não está em Unicode, e esta versão do Moodle não consegue migrá-la para Unicode. Atualize para Moodle 1.7.x primeiro e execute a migração Unicode a partir da página de administração. Depois, deve conseguir migrar para Moodle {$a}';
$string['unknowaction'] = 'Ação desconhecida!';
$string['unknowcategory'] = 'Categoria desconhecida!';
$string['unknowcontext'] = 'Este é um contexto desconhecido ({$a}) em get_child_contexts!';
$string['unknowformat'] = 'Formato desconhecido ({$a})';
$string['unknownbackupexporterror'] = 'Erro desconhecido a preparar informação para importação';
$string['unknownblockregion'] = 'A região do bloco "{$a}" não é reconhecida nesta página.';
$string['unknowncontext'] = 'Este contexto é desconhecido.';
$string['unknowncourse'] = 'Disciplina desconhecida designada de "{$a}"';
$string['unknowncourseidnumber'] = 'Identificador de disciplina desconhecido "{$a}"';
$string['unknowncourserequest'] = 'Disciplina pedida desconhecida';
$string['unknowncoursesection'] = 'Tópico desconhecido na disciplina "{$a}"';
$string['unknownevent'] = 'Evento desconhecido';
$string['unknownfiletype'] = 'Erro desconhecido filtertype';
$string['unknowngroup'] = 'Grupo desconhecido "{$a}"';
$string['unknownhelp'] = 'Tópico de ajuda desconhecido {$a}';
$string['unknownjsinrequirejs'] = 'Não é possível encontrar a JS library \'{$a}\'.';
$string['unknownmodulename'] = 'Nome do módulo desconhecido para o formulário';
$string['unknownrole'] = 'Papel desconhecido "{$a}"';
$string['unknownsortcolumn'] = 'Coluna de ordenação desconhecida {$a}';
$string['unknownuseraction'] = 'Lamento, mas não compreendo essa ação de utilizador.';
$string['unknownuserselector'] = 'Seletor de utilizador desconhecido';
$string['unknoworder'] = 'Ordenação desconhecida';
$string['unknowparamtype'] = 'Tipo de parâmetro desconhecido: {$a}';
$string['unknowquestiontype'] = 'Tipo de pergunta não compatível {$a}';
$string['unknowuploadaction'] = 'Erro: ação de carregamento desconhecida ({$a})';
$string['unspecifycourseid'] = 'Deve especificar o ID da disciplina, nome curto ou Idnumber';
$string['unsupportedevent'] = 'Tipo de evento não suportado';
$string['unsupportedstate'] = 'Estado de conclusão não compatível';
$string['unsupportedwebserver'] = 'O Software de servidor Web ({$a}) não é compatível.';
$string['upgraderequires19'] = 'Erro: A nova versão do Moodle foi instalada no servidor, infelizmente não é possível fazer um upgrade da versão anterior <br /> Atualize em primeiro lugar a última versão 1.9.x. Também pode voltar à versão anterior, reinstalando os ficheiros originais.';
$string['upgraderunning'] = 'O site está em processo de atualização. Por favor, tente novamente mais tarde.';
$string['urlnotdefinerss'] = 'O URL não foi definido para a lista RSS';
$string['useradmineditadmin'] = 'Apenas os administradores têm permissão para modificar outras contas de administrador';
$string['useradminodelete'] = 'As contas de administrador não podem ser apagadas.';
$string['userautherror'] = 'Módulo de autenticação desconhecido';
$string['userauthunsupported'] = 'Módulo de autenticação não suportado aqui.';
$string['useremailduplicate'] = 'Endereço duplicado';
$string['usermustbemnet'] = 'Os utilizadores na lista de controle de acesso MNET devem ser utilizadores remotos MNET';
$string['usernamelowercase'] = 'O nome de utilizador tem de ser em minúsculas';
$string['usernotaddederror'] = 'Utilizador não adicionado - erro.';
$string['usernotaddedregistered'] = 'Utilizador não adicionado - já estava registado.';
$string['usernotavailable'] = 'Não tem permissão para ver informação detalhada deste utilizador.';
$string['usernotdeletedadmin'] = 'O utilizador não foi eliminado porque as contas de administrador não podem ser apagadas.';
$string['usernotdeleteddeleted'] = 'Este utilizador já foi apagado.';
$string['usernotdeletederror'] = 'Utilizador não eliminado - erro.';
$string['usernotdeletedmissing'] = 'Utilizador não eliminado - não foi possível encontrar o nome de utilizador.';
$string['usernotdeletedoff'] = 'Utilizador não eliminado - a operação não é permitida.';
$string['usernotfullysetup'] = 'O utilizador não está totalmente configurado';
$string['usernotincourse'] = 'Este utilizador não está nesta disciplina!';
$string['usernotrenamedadmin'] = 'Não é possível renomear as contas de administradores.';
$string['usernotrenamedexists'] = 'Utilizador não renomeado - a novo nome de utilizador já existe.';
$string['usernotrenamedmissing'] = 'Utilizador não renomeado - não foi possível encontrar o nome de utilizador anterior.';
$string['usernotrenamedoff'] = 'Utilizador não renomeado - a operação não é permitida.';
$string['usernotupdatedadmin'] = 'Não é possível atualizar as contas de administradores.';
$string['usernotupdatederror'] = 'Utilizador não atualizado - erro.';
$string['usernotupdatednotexists'] = 'Utilizador não atualizado - não existe.';
$string['userquotalimit'] = 'Atingiu o seu limite de cota de ficheiro.';
$string['userselectortoomany'] = 'user_selector tem mais de um utilizador selecionado, embora a multiseleção não se aplique.';
$string['verifyagedigitalconsentnotpossible'] = 'De momento, não é possível a verificação da idade mínima de consentimento.';
$string['wrongcall'] = 'Este script é chamado de forma errada';
$string['wrongcontextid'] = 'O contexto ID estava incorreto (não é possível encontrá-lo)';
$string['wrongdestpath'] = 'Caminho de destino errado';
$string['wrongroleid'] = 'ID do papel inválido';
$string['wrongsourcebase'] = 'Base do URL de origem errada';
$string['wrongusernamepassword'] = 'Utilizador/senha errado';
$string['wrongzipfilename'] = 'Nome de ficheiro Zip errado';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Não é possível criar a disciplina - Não tem permissões';
$string['wwwrootmismatch'] = 'Detetado um acesso incorreto, este servidor pode apenas ser acessado pelo endereço "{$a}"<br /> Informe o administrador do servidor.';
$string['wwwrootslash'] = 'Foi detetado um valor incorreto de $CFG->wwwroot no ficheiro config.php. Não deve conter um "/" no final.<br />Por favor, informe o administrador.';
$string['xmldberror'] = 'Erro XMLDB!';
$string['youcannotdeletecategory'] = 'Não pode apagar a categoria "{$a}" porque não pode apagar os conteúdos nem movê-los para outro local.';
