<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'el', version '4.0'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Μπορείτε να προεπισκοπήσετε αυτό το κουίζ αλλά αν αυτή ήταν μια κανονική προσπάθεια δε θα είχατε αυτή τη δυνατότητα επειδή:';
$string['action'] = 'Ενέργεια';
$string['activityoverview'] = 'Έχετε κουίζ που είναι μέχρι';
$string['adaptive'] = 'Κατάσταση προσαρμογής';
$string['adaptive_help'] = 'Εάν ενεργοποιηθεί, επιτρέπονται πολλαπλές απαντήσεις σε μια ερώτηση μέσα στην ίδια προσπάθεια στο κουίζ. Έτσι, για παράδειγμα, αν μια απόκριση έχει επισημανθεί ως λανθασμένη, ο μαθητής θα επιτρέπεται να προσπαθήσει ξανά αμέσως. Ωστόσο, ανάλογα με τη ρύθμιση «Εφαρμογή ποινών», μια ποινή θα αφαιρείται συνήθως για κάθε λάθος προσπάθεια.';
$string['add'] = 'Προσθήκη';
$string['addaquestion'] = 'Προσθήκη ερώτησης';
$string['addarandomquestion'] = 'Προσθήκη τυχαίας ερώτησης';
$string['addarandomquestion_help'] = 'Όταν προστίθεται τυχαία ερώτηση, οδηγεί σε μια τυχαία επιλεγμένη ερώτηση από την κατηγορία που εισάγεται στο κουίζ. Αυτό σημαίνει ότι οι διαφορετικοί μαθητές είναι πιθανό να πάρουν διαφορετική επιλογή ερωτήσεων και όταν ένα κουίζ επιτρέπει πολλαπλές προσπάθειες τότε κάθε προσπάθεια είναι πιθανό να περιέχει μια νέα επιλογή ερωτήσεων.';
$string['addarandomselectedquestion'] = 'Προσθέστε μια τυχαία επιλεγμένη ερώτηση ...';
$string['addasection'] = 'μια νέα επικεφαλίδα ενότητας';
$string['adddescriptionlabel'] = 'Προσθήκη περιγραφής';
$string['addingquestion'] = 'Προσθήκη ερώτησης';
$string['addingquestions'] = '<p>Αυτή η πλευρά της σελίδας είναι όπου διαχειρίζεστε τη βάση δεδομένων των ερωτημάτων. Τα ερωτήματα αποθηκεύονται σε κατηγορίες ώστε να τηρούνται οργανωμένα και μπορούν να χρησιμοποιηθούν σε οποιοδήποτε κουίζ στο μάθημά σας ή ακόμη και σε άλλα μαθήματα αν επιλέξετε να τις «δημοσιοποιήσετε».</p>
<p>Αφού επιλέξετε ή δημιουργήσετε μια κατηγορία ερωτημάτων τότε θα είστε σε θέση να δημιουργήσετε ή να επεξεργαστείτε ερωτήματα. Μπορείτε να επιλέξετε οποιαδήποτε από αυτά τα ερωτήματα για να τα προσθέσετε στο κουίζ σας στην άλλη πλευρά αυτής της σελίδας.</p>';
$string['addmoreoverallfeedbacks'] = 'Προσθήκη {no} ακόμη κενών πεδίων ανατροφοδότησης';
$string['addnewgroupoverride'] = 'Προσθήκη παράκαμψης ομάδας';
$string['addnewpagesafterselected'] = 'Προσθήκη νέων σελίδων μετά από την επιλογή ερωτήσεων';
$string['addnewquestionsqbank'] = 'Προσθήκη νέων ερωτήσεων στην κατηγορία {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Προσθήκη παράκαμψης χρήστη';
$string['addpagebreak'] = 'Προσθήκη αλλαγής σελίδας';
$string['addpagehere'] = 'Προσθήκη σελίδας εδώ';
$string['addquestion'] = 'Προσθήκη ερώτησης';
$string['addquestionfrombankatend'] = 'Προσθήκη από την τράπεζα ερωτήσεων στο τέλος';
$string['addquestionfrombanktopage'] = 'Προσθήκη από την τράπεζα ερωτήσεων στη σελίδα {$a}';
$string['addquestions'] = 'Προσθήκη ερωτημάτων';
$string['addquestionstoquiz'] = 'Προσθήκη ερωτημάτων σε υπάρχον κουίζ';
$string['addrandom'] = 'Πρόσθεσε {$a} τυχαίες ερωτήσεις';
$string['addrandom1'] = '<< Πρόσθεσε';
$string['addrandom2'] = 'τυχαίες ερωτήσεις';
$string['addrandomfromcategory'] = 'Προσθήκη τυχαίων ερωτήσεων από την κατηγορία:';
$string['addrandomquestion'] = 'Προσθήκη τυχαίας ερώτησης';
$string['addrandomquestionatend'] = 'Προσθήκη μιας τυχαίας ερώτησης στο τέλος';
$string['addrandomquestiontopage'] = 'Προσθήκη μία τυχαίας ερώτησης στην σελίδα {$a}';
$string['addrandomquestiontoquiz'] = 'Προσθήκη τυχαίας ερώτησης στο κουίζ {$a}';
$string['addselectedquestionstoquiz'] = 'Προσθήκη επιλεγμένων ερωτήσεων στο κουίζ';
$string['addselectedtoquiz'] = 'Προσθήκη επιλεγμένων στο κουίζ';
$string['addtoquiz'] = 'Προσθήκη στο κουίζ';
$string['affectedstudents'] = 'Επηρεασμένα {$a}';
$string['aftereachquestion'] = 'Μετά την προσθήκη της κάθε ερώτησης';
$string['afternquestions'] = 'Μετά την προσθήκη {$a} ερωτήσεων';
$string['age'] = 'ηλικία';
$string['allattempts'] = 'Όλες οι προσπάθειες';
$string['allinone'] = 'Χωρίς περιορισμό';
$string['allowreview'] = 'Επιτρέπεται η ανασκόπηση';
$string['alreadysubmitted'] = 'Είναι πιθανό να έχετε ήδη υποβάλει αυτή την προσπάθεια';
$string['alternativeunits'] = 'Εναλλακτικές μονάδες';
$string['alwaysavailable'] = 'Πάντα διαθέσιμο';
$string['analysisoptions'] = 'Επιλογές ανάλυσης';
$string['analysistitle'] = 'Πίνακας ανάλυσης στοιχείου';
$string['answer'] = 'Απάντηση';
$string['answered'] = 'Απαντημένη';
$string['answerhowmany'] = 'Μια ή πολλαπλές απαντήσεις;';
$string['answers'] = 'Απαντήσεις';
$string['answersingleno'] = 'Επιτρέπονται πολλαπλές απαντήσεις';
$string['answersingleyes'] = 'Μια απάντηση μόνο';
$string['answertoolong'] = 'Η απάντηση είναι πολύ μεγάλη μετά από τη γραμμή {$a} (255 χαρ. μέγιστο)';
$string['anytags'] = 'Κάθε ετικέτα';
$string['aon'] = 'Μορφή AON';
$string['areyousureremoveselected'] = 'Σίγουρα θέλετε να αφαιρέσετε όλες τις επιλεγμένες ερωτήσεις;';
$string['asshownoneditscreen'] = 'Όπως φαίνεται στην οθόνη επεξεργασίας';
$string['attempt'] = 'Προσπάθεια {$a}';
$string['attemptalreadyclosed'] = 'Αυτή η προσπάθεια έχει ήδη τελειώσει.';
$string['attemptclosed'] = 'προσπάθεια δεν έχει κλείσει ακόμη';
$string['attemptduration'] = 'Χρόνος που απαιτήθηκε';
$string['attemptedon'] = 'Δοκιμάστηκε στις';
$string['attempterror'] = 'Δεν μπορείτε να προσπαθήσετε αυτό το κουίζ αυτή τη στιγμή επειδή: {$a}';
$string['attempterrorcontentchange'] = 'Αυτή η προεπισκόπηση κουίζ δεν υπάρχει πλέον. (Κατά τη διάρκεια επεξεργασίας ενός κουίζ, όλες οι προεπισκοπήσεις που βρίσκονται σε εξέλιξη διαγράφονται αυτόματα.)';
$string['attempterrorcontentchangeforuser'] = 'Αυτή η προσπάθεια κουίζ δεν υπάρχει πλέον.';
$string['attempterrorinvalid'] = 'Μη έγκυρο αναγνωριστικό προσπάθειας κουίζ';
$string['attemptfirst'] = 'Πρώτη προσπάθεια';
$string['attemptincomplete'] = 'Η προσπάθεια (από το χρήστη {$a}) δεν έχει ολοκληρωθεί ακόμα.';
$string['attemptlast'] = 'Τελευταία προσπάθεια';
$string['attemptnumber'] = 'Προσπάθεια';
$string['attemptquiznow'] = 'Προσπάθεια κουίζ τώρα';
$string['attemptreviewtitle'] = '{$a}: Εξέταση προσπάθειας';
$string['attemptreviewtitlepaged'] = '{$a->name}: Εξέταση προσπάθειας (σελίδα {$a->currentpage} από {$a->totalpages})';
$string['attempts'] = 'Προσπάθειες';
$string['attempts_help'] = 'Ο συνολικός αριθμός επιτρεπόμενων προσπαθειών (όχι ο αριθμός των επιπλέον προσπαθειών).';
$string['attemptsallowed'] = 'Επιτρεπόμενες προσπάθειες';
$string['attemptsdeleted'] = 'Οι προσπάθειες κουίζ διαγράφηκαν';
$string['attemptselection'] = 'Επίλεξε ποιες προσπάθειες θα αναλυθούν ανά χρήστη:';
$string['attemptsexist'] = 'Δεν μπορείτε πλέον να προσθέσετε ή να αφαιρέσετε ερωτήσεις.';
$string['attemptsnum'] = 'Προσπάθειες: {$a}';
$string['attemptsnumthisgroup'] = 'Προσπάθειες: {$a->total} ({$a->group} από αυτήν την ομάδα)';
$string['attemptsnumyourgroups'] = 'Προσπάθειες: {$a->total} ({$a->group} από αυτές τις ομάδες)';
$string['attemptsonly'] = 'Δείξτε μόνο τους μαθητές που έχουν προσπαθήσει';
$string['attemptstate'] = 'Κατάσταση';
$string['attemptstillinprogress'] = 'Προσπάθεια ακόμη σε εξέλιξη';
$string['attemptsummarytitle'] = '{$a}: Περίληψη προσπάθειας';
$string['attemptsunlimited'] = 'Απεριόριστες προσπάθειες';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (σελίδα {$a->currentpage} από {$a->totalpages})';
$string['autosaveperiod'] = 'Καθυστέρηση αυτόματης αποθήκευσης';
$string['autosaveperiod_desc'] = 'Οι αποκρίσεις μπορούν να αποθηκευτούν αυτόματα κατά τη διάρκεια προσπαθειών κουίζ. Οι αποκρίσεις αποθηκεύονται κάθε φορά που κάποια αλλάζει, και μετά από αυτή εδώ την καθυστέρηση. Υπάρχει συμβιβασμός: η μικρότερη καθυστέρηση αυξάνει το φορτίο του εξυπηρετητή, αλλά μειώνει την πιθανότητα οι μαθητές να χάσουν τη δουλειά τους. Αν σκοπεύετε να κάνετε αυτήν την καθυστέρηση πολύ μικρότερη, θα πρέπει να αλλάξετε σταδιακά την τιμή και να παρακολουθήσετε το φορτίο του εξυπηρετητή. Αν το φορτίο γίνει πολύ υψηλό, κάντε ξανά την καθυστέρηση μεγαλύτερη. Η ρύθμιση της καθυστέρησης σε 0 απενεργοποιεί την αυτόματη αποθήκευση.';
$string['back'] = 'Επιστροφή στην προηγούμενη ερώτηση';
$string['backtocourse'] = 'Επιστροφή στο μάθημα';
$string['backtoquestionlist'] = 'Επιστροφή στη λίστα ερωτήσεων';
$string['backtoquiz'] = 'Επιστροφή στην επεξεργασία του κουίζ';
$string['basicideasofquiz'] = 'Οι βασικές ιδέες της κατασκευής κουίζ';
$string['bestgrade'] = 'Καλύτερος βαθμός';
$string['bothattempts'] = 'Εμφάνιση μαθητών με και χωρίς προσπάθειες';
$string['browsersecurity'] = 'Ασφάλεια περιηγητή';
$string['browsersecurity_help'] = 'Αν επιλεγεί «Αναδυόμενο παράθυρο πλήρους οθόνης με κάποια JavaScript ασφάλεια»,

* Το κουίζ θα ξεκινήσει μόνο αν ο μαθητής έχει περιηγητή με ενεργοποιημένη την JavaScript
* Το κουίζ θα εμφανιστεί σε ένα αναδυόμενο παράθυρο πλήρους οθόνης, το οποίο θα καλύπτει όλα τα άλλα παράθυρα και δεν θα έχει επιλογές πλοήγησης
* Οι εκπαιδευόμενοι περιορίζονται, όσο αυτό είναι δυνατό, από τη χρήση λειτουργιών όπως η αντιγραφή και η επικόλληση';
$string['cachedef_overrides'] = 'Πληροφορίες παράκαμψης χρήστη και ομάδας';
$string['calculated'] = 'Υπολογισμένο';
$string['calculatedquestion'] = 'Η υπολογισμένη ερώτηση δεν υποστηρίζεται στην γραμμή {$a}. Η ερώτηση θα αγνοηθεί';
$string['cannotcreatepath'] = 'Δεν είναι δυνατή η δημιουργία της διαδρομής ({$a})';
$string['cannoteditafterattempts'] = 'Δεν μπορείτε να προσθέσετε ή να διαγράψετε ερωτήσεις επειδή έχει ήδη γίνει προσπάθεια για αυτό το κουίζ. ({$a})';
$string['cannotfindprevattempt'] = 'Αδυναμία εύρεσης προηγούμενης προσπάθειας για να χρησιμοποιηθεί ως βάση.';
$string['cannotfindquestionregard'] = 'Αδυναμία ανάκτησης ερωτήσεων για αναβαθμολόγηση!';
$string['cannotinsert'] = 'Αδυναμία εισαγωγής ερώτησης';
$string['cannotinsertrandomquestion'] = 'Αδυναμία εισαγωγής νέας τυχαίας ερώτησης!';
$string['cannotloadquestion'] = 'Αδυναμία φόρτωσης επιλογών ερώτησης';
$string['cannotloadtypeinfo'] = 'Αδυναμία φόρτωσης πληροφοριών για τον τύπο ερώτησης';
$string['cannotopen'] = 'Αδυναμία εξαγωγής αρχείου ({$a})';
$string['cannotremoveallsectionslots'] = 'Έχετε επιλέξει όλες τις ερωτήσεις κάτω από την επικεφαλίδα της ενότητας «{$a}». Δεν επιτρέπεται η κατάργηση όλων των ερωτήσεων κάτω από μια επικεφαλίδα ενότητας.';
$string['cannotremoveslots'] = 'Αδυναμία κατάργησης ερωτήσεων';
$string['cannotrestore'] = 'Αδυναμία επαναφοράς συνόδων ερώτησης';
$string['cannotreviewopen'] = 'Δεν μπορείτε να επιθεωρήσετε αυτήν την προσπάθεια, είναι ακόμη ανοιχτή.';
$string['cannotsavelayout'] = 'Αδυναμία αποθήκευσης διάταξης';
$string['cannotsavenumberofquestion'] = 'Αδυναμία αποθήκευσης αριθμού ερωτήσεων ανά σελίδα';
$string['cannotsavequestion'] = 'Αδυναμία αποθήκευσης λίστας ερωτήσεων';
$string['cannotsetgrade'] = 'Αδυναμία ορισμού νέου μέγιστου βαθμού για το κουίζ';
$string['cannotsetsumgrades'] = 'Αδυναμία ορισμού sumgrades';
$string['cannotstartgradesmismatch'] = 'Δεν είναι δυνατόν να ξεκινήσει μια προσπάθεια σε αυτό το κουίζ. Το κουίζ έχει οριστεί για να βαθμολογηθεί ως {$a->grade}, αλλά καμία από τις ερωτήσεις στο κουίζ δεν έχει βαθμό. Αυτό μπορεί να διορθωθεί στη σελίδα «Επεξεργασία κουίζ».';
$string['cannotstartmissingquestion'] = 'Δεν είναι δυνατόν να ξεκινήσει μια προσπάθεια σε αυτό το κουίζ. Ο ορισμός του κουίζ περιλαμβάνει μια ερώτηση που δεν υπάρχει.';
$string['cannotstartnoquestions'] = 'Δεν είναι δυνατόν να ξεκινήσει μια προσπάθεια σε αυτό το κουίζ. Το κουίζ δεν έχει ρυθμιστεί ακόμα. Δεν έχουν προστεθεί ερωτήσεις.';
$string['cannotwrite'] = 'Αδυναμία εγγραφής στο εξαγόμενο αρχείο ({$a})';
$string['canredoquestions'] = 'Επέτρεψε να ξανά απαντηθεί μία ερώτηση μέσα σε μία προσπάθεια';
$string['canredoquestions_desc'] = 'Εάν ενεργοποιηθεί, μετά την ολοκλήρωση της προσπάθειας μιας ερώτησης, εμφανίζεται ένα κουμπί «Δοκιμάστε μια άλλη ερώτηση όπως αυτή». Αυτό επιτρέπει την προσπάθεια μιας παρόμοιας ερώτησης (επιλεγμένης τυχαία) ή της ίδιας ερώτηση ξανά, χωρίς να χρειάζεται να υποβληθεί ολόκληρη η προσπάθεια κουίζ και να ξεκινήσει άλλη προσπάθεια.

Αυτή η επιλογή είναι χρήσιμη για κουίζ εξάσκησης. Αυτή η ρύθμιση επηρεάζει μόνο ερωτήσεις και συμπεριφορές (όπως άμεση ανατροφοδότηση ή διαδραστική με πολλαπλές προσπάθειες) όπου είναι δυνατή η ολοκλήρωση μιας ερώτησης πριν από την υποβολή της προσπάθειας.';
$string['canredoquestions_help'] = 'Εάν ενεργοποιηθεί, μετά την ολοκλήρωση της προσπάθειας μιας ερώτησης, εμφανίζεται ένα κουμπί «Δοκιμάστε μια άλλη ερώτηση όπως αυτή». Αυτό επιτρέπει την προσπάθεια μιας παρόμοιας ερώτησης (επιλεγμένης τυχαία) ή της ίδιας ερώτηση ξανά, χωρίς να χρειάζεται να υποβληθεί ολόκληρη η προσπάθεια κουίζ και να ξεκινήσει άλλη προσπάθεια.

Αυτή η επιλογή είναι χρήσιμη για κουίζ εξάσκησης. Αυτή η ρύθμιση επηρεάζει μόνο ερωτήσεις και συμπεριφορές (όπως άμεση ανατροφοδότηση ή διαδραστική με πολλαπλές προσπάθειες) όπου είναι δυνατή η ολοκλήρωση μιας ερώτησης πριν από την υποβολή της προσπάθειας.';
$string['canredoquestionsyes'] = 'Ναι, δώστε την επιλογή για δοκιμή μιας άλλης ερώτησης';
$string['caseno'] = 'Όχι, δεν υπάρχει διαφορά μεταξύ μικρών και κεφαλαίων';
$string['casesensitive'] = 'Διάκριση μικρών/κεφαλαίων';
$string['caseyes'] = 'Ναι, μικρά/κεφαλαία πρέπει να ταιριάζουν';
$string['categoryadded'] = 'Προστέθηκε η κατηγορία «{$a}»';
$string['categorydeleted'] = 'Διαγράφηκε η κατηγορία «{$a}»';
$string['categorynoedit'] = 'Δεν έχετε δικαίωμα επεξεργασίας της κατηγορίας «{$a}».';
$string['categoryupdated'] = 'Η κατηγορία ενημερώθηκε επιτυχώς';
$string['close'] = 'Κλείσιμο παραθύρου';
$string['closebeforeopen'] = 'Δεν είναι δυνατή η ενημέρωση του κουίζ. Έχετε ορίσει ημερομηνία τερματισμού πριν την ημερομηνία έναρξης.';
$string['closed'] = 'Κλειστό';
$string['closepreview'] = 'Κλείσιμο προεπισκόπησης';
$string['closereview'] = 'Κλείσιμο ανασκόπησης';
$string['comment'] = 'Σχόλιο';
$string['commentorgrade'] = 'Εισαγάγετε σχόλιο ή παρακάμψτε το βαθμό';
$string['comments'] = 'Σχόλια';
$string['completedon'] = 'Ολοκληρώθηκε στις';
$string['completionattemptsexhausted'] = 'Ή όλες οι διαθέσιμες προσπάθειες ολοκληρώθηκαν';
$string['completionattemptsexhausted_help'] = 'Επισήμανση του κουίζ ως ολοκληρωμένου όταν ο μαθητής έχει εξαντλήσει το μέγιστο αριθμό προσπαθειών.';
$string['completionattemptsexhausteddesc'] = 'Ολοκληρωμένο εάν εξαντληθούν όλες οι διαθέσιμες προσπάθειες';
$string['completiondetail:minattempts'] = 'Κάντε προσπάθειες: {$a}';
$string['completiondetail:passgrade'] = 'Λάβετε βαθμολογία επιτυχίας';
$string['completiondetail:passorexhaust'] = 'Λάβετε βαθμολογία επιτυχίας ή ολοκληρώστε όλες τις διαθέσιμες προσπάθειες';
$string['completionminattempts'] = 'Ο μαθητής πρέπει να αποστείλει προσπάθειες:';
$string['completionminattemptsdesc'] = 'Απαιτείται ελάχιστος αριθμός προσπαθειών: {$a}';
$string['completionminattemptserror'] = 'Ο ελάχιστος αριθμός προσπαθειών πρέπει να είναι μικρότερος ή ίσος με τις επιτρεπόμενες προσπάθειες.';
$string['completionminattemptsgroup'] = 'Απαίτηση προσπαθειών';
$string['completionpass'] = 'Απαίτηση προβιβάσιμου βαθμού';
$string['completionpass_help'] = 'Αν ενεργοποιηθεί, αυτή η δραστηριότητα θεωρείται ολοκληρωμένη όταν ο μαθητής λαμβάνει ένα βαθμό επιτυχίας ή ανώτερο, όπως καθορίζεται στην ενότητα Βαθμών των ρυθμίσεων κουίζ.';
$string['completionpassdesc'] = 'Ο μαθητής πρέπει να επιτύχει ένα βαθμό επιτυχίας για να ολοκληρώσει αυτή τη δραστηριότητα';
$string['completionpassorattemptsexhausteddesc'] = 'Ο μαθητής πρέπει να επιτύχει βαθμολογία επιτυχίας (πάνω από τη βάση) ή να εξαντλήσει όλες τις διαθέσιμες προσπάθειες για να ολοκληρώσει αυτήν τη δραστηριότητα';
$string['configadaptive'] = 'Εάν επιλέξετε Ναι σε αυτήν την επιλογή τότε ο μαθητής θα μπορεί να απαντάει πολλές φορές σε μια ερώτηση ακόμη και στην ίδια προσπάθεια του κουίζ.';
$string['configattemptsallowed'] = 'Περιορισμός του αριθμού προσπαθειών των μαθητών στο κουίζ.';
$string['configdecimaldigits'] = 'Αριθμός ψηφίων που θα προβάλλονται μετά την υποδιαστολή στους βαθμούς.';
$string['configdecimalplaces'] = 'Αριθμός ψηφίων που θα προβάλλονται μετά την υποδιαστολή κατά την προβολή των βαθμών του κουίζ.';
$string['configdecimalplacesquestion'] = 'Αριθμός ψηφίων που θα προβάλλονται μετά την υποδιαστολή κατά την προβολή βαθμών για κάθε ερώτηση.';
$string['configdelay1'] = 'Εάν θέσετε μια χρονική καθυστέρηση, τότε ο μαθητής θα πρέπει να περιμένει αυτό το χρονικό διάστημα πριν να μπορεί να ξαναπροσπαθήσει στο κουίζ μετά την πρώτη προσπάθεια.';
$string['configdelay1st2nd'] = 'Εάν θέσετε μια χρονική καθυστέρηση, ο μαθητής δε θα μπορεί να αρχίσει τη δεύτερη προσπάθειά του πριν περάσει ο χρόνος αυτός από το τέλος της πρώτης προσπάθειάς του.';
$string['configdelay2'] = 'Εάν θέσετε μια χρονική καθυστέρηση, ο μαθητής θα πρέπει να περιμένει τόσο χρονικό διάστημα πριν τη δεύτερη ή τρίτη προσπάθεια.';
$string['configdelaylater'] = 'Εάν θέσετε μια χρονική καθυστέρηση, ο μαθητής δε θα μπορεί να ξεκινήσει την τρίτη, τέταρτη, ... προσπάθεια μέχρι αυτός ο χρόνος να έχει περάσει από το τέλος της προηγούμενης προσπάθειας.';
$string['configeachattemptbuildsonthelast'] = 'Εάν οι πολλαπλές προσπάθειες επιτρέπονται τότε κάθε νέα προσπάθεια θα περιέχει τα αποτελέσματα της προηγούμενης προσπάθειας.';
$string['configgrademethod'] = 'Όταν επιτρέπονται πολλαπλές προσπάθειες, ποια μέθοδος θα χρησιμοποιείται για τον υπολογισμό του τελικού βαθμού του μαθητή για το κουίζ.';
$string['configintro'] = 'Οι τιμές που ορίζονται εδώ καθορίζουν τις προεπιλεγμένες τιμές που χρησιμοποιούνται στη φόρμα ρυθμίσεων κατά τη δημιουργία νέου κουίζ. Μπορείτε επίσης να ρυθμίσετε ποιες ρυθμίσεις κουίζ θα θεωρούνται προχωρημένες.';
$string['configmaximumgrade'] = 'Ο προεπιλεγμένος μέγιστος βαθμός στην κλίμακα που θα χρησιμοποιηθεί για το κουίζ.';
$string['confignavmethod'] = 'Στην Ελεύθερη πλοήγηση, οι ερωτήσεις μπορεί να απαντηθούν με οποιαδήποτε σειρά χρησιμοποιώντας την πλοήγηση. Στην Διαδοχική, οι ερωτήσεις πρέπει να απαντηθούν με αυστηρή σειρά.';
$string['confignewpageevery'] = 'Κατά την προσθήκη ερωτήσεων στο κουίζ, οι αλλαγές σελίδας θα εισάγονται αυτόματα ανάλογα με τη ρύθμισή σας εδώ.';
$string['configoutcomesadvanced'] = 'Αν αυτή η επιλογή είναι ενεργοποιημένη, τότε τα μαθησιακά αποτελέσματα στην φόρμα επεξεργασίας του κουίζ είναι προχωρημένες ρυθμίσεις.';
$string['configpenaltyscheme'] = 'Ποινή που θα αφαιρείται για κάθε λάθος απόκριση στην προσαρμοστική κατάσταση λειτουργίας.';
$string['configpopup'] = 'Επιβολή του ανοίγματος της προσπάθειας σε αναδυόμενο παράθυρο και χρήση τεχνασμάτων JavaScript για τον εμποδισμό αντιγραφής-επικόλλησης, κτλ κατά την προσπάθεια κουίζ.';
$string['configrequirepassword'] = 'Οι μαθητές θα πρέπει να εισάγουν αυτόν τον κωδικό πρόσβασης προτού προσπαθήσουν το κουίζ.';
$string['configrequiresubnet'] = 'Οι μαθητές μπορούν να προσπαθήσουν το κουίζ μόνον από αυτούς τους υπολογιστές.';
$string['configreviewoptions'] = 'Οι επιλογές αυτές ελέγχουν ποιές πληροφορίες θα βλέπουν οι χρήστες όταν κάνουν ανασκόπηση μιας προσπάθειας ενός κουίζ ή όταν βλέπουν τις αναφορές κουίζ.';
$string['configshowblocks'] = 'Εμφάνιση μπλοκ κατά τη διάρκεια των προσπαθειών.';
$string['configshowuserpicture'] = 'Εμφάνιση της εικόνας χρήστη στην οθόνη κατά τη διάρκεια προσπαθειών.';
$string['configshufflewithin'] = 'Εάν ενεργοποιηθεί, τα σκέλη που αποτελούν τις ανεξάρτητες ερωτήσεις θα ανακατεύονται τυχαία κάθε φορά που ένας μαθητής αρχίζει μια προσπάθεια στο κουίζ, δεδομένου ότι αυτή η επιλογή είναι επίσης ενεργοποιημένη στις ρυθμίσεις της ερώτησης.';
$string['configtimelimit'] = 'Προεπιλεγμένο όριο χρόνου για κουίζ σε λεπτά. Το 0 σημαίνει πως δεν υπάρχει όριο.';
$string['configtimelimitsec'] = 'Προεπιλεγμένο όριο χρόνου για κουίζ σε δευτερόλεπτα. Το 0 σημαίνει πως δεν υπάρχει όριο.';
$string['configurerandomquestion'] = 'Ρύθμιση ερώτησης';
$string['confirmclose'] = 'Μόλις υποβάλετε, δεν θα μπορείτε πλέον να αλλάξετε τις απαντήσεις σας για αυτήν την προσπάθεια.';
$string['confirmremovequestion'] = 'Σίγουρα θέλετε να καταργήσετε αυτήν την ερώτηση {$a};';
$string['confirmremovesectionheading'] = 'Σίγουρα θέλετε να καταργήσετε την επικεφαλίδα της ενότητας «{$a}»;';
$string['confirmserverdelete'] = 'Σίγουρα θέλετε να διαγράψετε τον εξυπηρετητή <b>{$a}</b> από τη λίστα;';
$string['connectionerror'] = 'Η σύνδεση δικτύου χάθηκε. (Αποτυχία αυτόματης αποθήκευσης).

Σημειώστε τις απαντήσεις που καταχωρήσατε σε αυτή τη σελίδα τα τελευταία λεπτά και δοκιμάστε να συνδεθείτε ξανά.

Μόλις αποκατασταθεί η σύνδεση, οι αποκρίσεις σας θα πρέπει να αποθηκευτούν και αυτό το μήνυμα θα εξαφανιστεί.';
$string['connectionok'] = 'Η σύνδεση δικτύου έχει επαναφερθεί. Μπορείτε να συνεχίσετε με ασφάλεια.';
$string['containercategorycreated'] = 'Αυτή η κατηγορία έχει δημιουργηθεί για την αποθήκευση όλων των αρχικών κατηγοριών που μετακινήθηκαν στο επίπεδο δικτυακού τόπου εξαιτίας των λόγων που αναφέρονται παρακάτω.';
$string['continueattemptquiz'] = 'Συνέχιση της τελευταίας προσπάθειας';
$string['continuepreview'] = 'Συνέχιση της τελευταίας προεπισκόπησης';
$string['copyingfrom'] = 'Δημιουργία αντιγράφου της ερώτησης «{$a}»';
$string['copyingquestion'] = 'Αντιγραφή ερώτησης';
$string['correct'] = 'Σωστό';
$string['correctanswer'] = 'Σωστή απάντηση';
$string['correctanswerformula'] = 'Φόρμουλα σωστής απάντησης';
$string['correctansweris'] = 'Σωστή απάντηση: {$a}';
$string['correctanswerlength'] = 'Σημαντικές τιμές';
$string['correctanswers'] = 'Σωστές απαντήσεις';
$string['correctanswershows'] = 'Εμφάνιση σωστών απαντήσεων';
$string['corrresp'] = 'Σωστή απόκριση';
$string['countdown'] = 'Αντίστροφη μέτρηση';
$string['countdownfinished'] = 'Το κουίζ κλείνει, πρέπει να υποβάλλετε τις απαντήσεις σας τώρα.';
$string['countdowntenminutes'] = 'Το κουίζ θα κλείσει σε δέκα λεπτά.';
$string['coursetestmanager'] = 'Μορφή Διαχειριστή Τεστ Μαθήματος';
$string['createcategoryandaddrandomquestion'] = 'Δημιουργία κατηγορίας και προσθήκη τυχαίας ερώτησης';
$string['createfirst'] = 'Πρέπει πρώτα να δημιουργήσετε μία ερώτηση σύντομης απάντησης.';
$string['createmultiple'] = 'Προσθήκη πολλών τυχαίων ερωτήσεων στο κουίζ';
$string['createnewquestion'] = 'Δημιουργία νέας ερώτησης';
$string['createquestionandadd'] = 'Δημιουργία νέας ερώτησης και προσθήκη στο κουίζ.';
$string['custom'] = 'Προσαρμοσμένη μορφή';
$string['dataitemneed'] = 'Θα πρέπει να προσθέσετε τουλάχιστον ένα σύνολο αντικειμένων για να πάρετε μία έγκυρη ερώτηση';
$string['datasetdefinitions'] = 'Επαναχρησιμοποιούμενοι ορισμοί ομάδας δεδομένων για την κατηγορία {$a}';
$string['datasetnumber'] = 'Αριθμός';
$string['daysavailable'] = 'Διαθέσιμες ημέρες';
$string['decimaldigits'] = 'Δεκαδικά ψηφία στους βαθμούς';
$string['decimalplaces'] = 'Θέσεις δεκαδικών στους βαθμούς';
$string['decimalplaces_help'] = 'Αυτή η ρύθμιση καθορίζει τον αριθμό των ψηφίων που εμφανίζονται μετά από την υποδιαστολή όταν εμφανίζονται βαθμολογίες. Επηρεάζει μόνο την εμφάνιση των βαθμών και όχι (τους ίδιους) τους βαθμούς που αποθηκεύονται στην βάση δεδομένων, ούτε τους εσωτερικούς υπολογισμούς που εκτελούνται με πλήρη ακρίβεια.';
$string['decimalplacesquestion'] = 'Θέσεις δεκαδικών στους βαθμούς ερώτησης';
$string['decimalplacesquestion_help'] = 'Αυτή η ρύθμιση καθορίζει τον αριθμό των ψηφίων που εμφανίζονται μετά την υποδιαστολή όταν εμφανίζονται βαθμοί για κάθε ερώτηση.';
$string['decimalpoints'] = 'Δεκαδικά&nbsp;ψηφία';
$string['default'] = 'Προεπιλογή';
$string['defaultgrade'] = 'Προεπιλεγμένη βαθμολόγηση ερώτησης';
$string['defaultinfo'] = 'Η προεπιλεγμένη κατηγορία για αυτή την ερώτηση.';
$string['delay1'] = 'Χρονικό όριο μεταξύ πρώτης και δεύτερης προσπάθειας';
$string['delay1st2nd'] = 'Επιβαλλόμενη καθυστέρηση μεταξύ 1ης και 2ης προσπάθειας';
$string['delay1st2nd_help'] = 'Εάν ενεργοποιηθεί, ο μαθητής πρέπει να περιμένει να περάσει ο καθορισμένος χρόνος πριν μπορέσει να δοκιμάσει το κουίζ για δεύτερη φορά.';
$string['delay2'] = 'Χρονικό όριο μεταξύ επόμενων προσπαθειών';
$string['delaylater'] = 'Επιβαλλόμενη καθυστέρηση μεταξύ επόμενων προσπαθειών';
$string['delaylater_help'] = 'Εάν ενεργοποιηθεί, κάθε μαθητής πρέπει να περιμένει να περάσει ο καθορισμένος χρόνος (χρονοκαθυστέρηση) πριν επιχειρήσει το κουίζ για τρίτη και πάνω φορά.';
$string['deleteattemptcheck'] = 'Είστε απολύτως σίγουροι ότι θέλετε να διαγράψετε αυτές τις προσπάθειες;';
$string['deleteselected'] = 'Διαγραφή επιλεγμένων';
$string['deletingquestionattempts'] = 'Διαγραφή προσπαθειών ερώτησης';
$string['description'] = 'Περιγραφή';
$string['disabled'] = 'Απενεργοποιημένο';
$string['displayoptions'] = 'Επιλογές εμφάνισης';
$string['donotuseautosave'] = 'Μην χρησιμοποιείτε αυτόματη αποθήκευση';
$string['download'] = 'Κάντε κλικ για λήψη του εξαγόμενου αρχείου κατηγορίας';
$string['downloadextra'] = '(το αρχείο αποθηκεύτηκε επίσης στα αρχεία του μαθήματος στο φάκελο /backupdata/κουίζ)';
$string['dragtoafter'] = 'Μετά {$a}';
$string['dragtostart'] = 'Στην αρχή';
$string['duplicateresponse'] = 'Αυτή η υποβολή έχει αγνοηθεί γιατί δώσατε την ίδια απάντηση προηγουμένως.';
$string['eachattemptbuildsonthelast'] = 'Κάθε προσπάθεια στηρίζεται στο τελευταίο';
$string['eachattemptbuildsonthelast_help'] = 'Εάν επιτρέπονται πολλές προσπάθειες και αυτή η ρύθμιση είναι ενεργοποιημένη, κάθε νέα προσπάθεια κουίζ θα περιέχει τις απαντήσεις της προηγούμενης προσπάθειας. Αυτό επιτρέπει την σταδιακή ολοκλήρωση ενός κουίζ κατά τη διάρκεια αρκετών προσπαθειών.';
$string['editcategories'] = 'Επεξεργασία κατηγοριών';
$string['editcategory'] = 'Επεξεργασία κατηγορίας';
$string['editcatquestions'] = 'Επεξεργασία ερωτήσεων κατηγορίας';
$string['editingquestion'] = 'Επεξεργασία μιας ερώτησης';
$string['editingquiz'] = 'Επεξεργασία κουίζ';
$string['editingquiz_help'] = 'Κατά τη δημιουργία ενός κουίζ, οι κύριες έννοιες είναι:

* Το κουίζ, που περιέχει ερωτήσεις πάνω σε μία ή περισσότερες σελίδες
* Η τράπεζα ερωτήσεων, η οποία αποθηκεύει αντίγραφα όλων των ερωτήσεων που οργανώνονται σε κατηγορίες
* Τυχαίες ερωτήσεις - Ο μαθητής παίρνει διαφορετικές ερωτήσεις κάθε φορά που επιχειρεί το κουίζ και διαφορετικοί μαθητές μπορούν να πάρουν διαφορετικές ερωτήσεις';
$string['editingquiz_link'] = '';
$string['editingquizx'] = 'Επεξεργασία κουίζ: {$a}';
$string['editmaxmark'] = 'Επεξεργασία μέγιστου βαθμού';
$string['editoverride'] = 'Επεξεργασία παράκαμψης';
$string['editqcats'] = 'Επεξεργασία κατηγοριών ερωτήσεων';
$string['editquestion'] = 'Επεξεργασία ερώτησης';
$string['editquestions'] = 'Επεξεργασία ερωτήσεων';
$string['editquiz'] = 'Επεξεργασία κουίζ';
$string['editquizquestions'] = 'Επεξεργασία ερωτήσεων του κουίζ';
$string['emailconfirmautosubmitsmall'] = 'Σας ευχαριστούμε που υποβάλατε τις απαντήσεις σας στο «{$a->quizname}»';
$string['emailconfirmbody'] = 'Αγαπητέ {$a->username}, Ευχαριστούμε που υποβάλατε τις απαντήσεις σας στο «{$a->quizname}» για το μάθημα «{$a->coursename}» στις {$a->submissiontime}. Αυτό το μήνυμα ηλε.ταχυδρομείου επιβεβαιώνει ότι οι απαντήσεις σας έχουν ληφθεί με ασφάλεια. Μπορείτε να δείτε το κουίζ στο {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Γεια σας {$a->username},

Ο χρόνος για το κουίζ «{$a->quizname}» στο μάθημα «{$a->coursename}» έληξε. Οι απαντήσεις σας υποβλήθηκαν αυτόματα στις {$a->submissiontime}.

Αυτό το μήνυμα επιβεβαιώνει ότι οι απαντήσεις σας έχουν αποθηκευτεί.

Μπορείτε να έχετε πρόσβαση σε αυτό το κουίζ στη διεύθυνση {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Ευχαριστούμε για την υποβολή των απαντήσεων σας στο «{$a->quizname}»';
$string['emailconfirmsubject'] = 'Επιβεβαίωση υποβολής: {$a->quizname}';
$string['emailnotifybody'] = 'Αγαπητέ {$a->username},

ο {$a->studentname} έχει ολοκληρώσει το κουίζ
«{$a->quizname}» ({$a->quizurl})
για το μάθημα «{$a->coursename}»

Μπορείτε να κάνετε ανασκόπηση της προσπάθειας αυτής στο {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} έχει ολοκληρώσει {$a->quizname}. Δείτε {$a->quizreviewurl}';
$string['emailnotifysubject'] = 'Ο/Η «{$a->studentname}» έχει ολοκληρώσει το κουίζ «{$a->quizname}»';
$string['emailoverduebody'] = 'Γεια σας {$a->studentname}, Ξεκινήσατε μια προσπάθεια «{$a->quizname}» στο μάθημα «{$a->coursename}», αλλά ποτέ δεν την υποβάλατε. Έπρεπε να έχει υποβληθεί από {$a->tryduedate}. Εάν εξακολουθείτε να θέλετε να υποβάλετε αυτήν την προσπάθεια, μεταβείτε στη σελίδα {$a->attemptsummaryurl} και κάντε κλικ στο κουμπί αποστολής. Πρέπει να το κάνετε πριν από {$a->trygraceend}, διαφορετικά η προσπάθειά σας δεν θα ληφθεί υπόψη.';
$string['emailoverduesmall'] = 'Δεν υποβάλατε την προσπάθειά σας στο {$a->quizname}. Μεταβείτε στο {$a->attemptsummaryurl} πριν από την {$a->attemptgraceend} αν θέλετε ακόμα να υποβάλετε.';
$string['emailoverduesubject'] = 'Προσπάθεια τώρα εκπρόθεσμη: {$a->quizname}';
$string['empty'] = 'Κενό';
$string['enabled'] = 'Ενεργοποιημένο';
$string['endtest'] = 'Τέλος προσπάθειας...';
$string['erroraccessingreport'] = 'Δεν μπορείτε να προσπελάσετε αυτήν την αναφορά';
$string['errorinquestion'] = 'Σφάλμα στην ερώτηση';
$string['errormissingquestion'] = 'Σφάλμα: Το σύστημα δεν βρίσκει την ερώτηση με id {$a}';
$string['errornotnumbers'] = 'Σφάλμα - οι απαντήσεις πρέπει να είναι αριθμητικές';
$string['errorunexpectedevent'] = 'Απρόσμενο γεγονός με κωδικό {$a->event} βρέθηκε για την ερώτηση {$a->questionid} στην προσπάθεια {$a->attemptid}.';
$string['essay'] = 'Έκθεση';
$string['essayquestions'] = 'Ερωτήσεις';
$string['eventattemptautosaved'] = 'Αυτόματη αποθήκευση προσπάθειας κουίζ';
$string['eventattemptdeleted'] = 'Η προσπάθεια κουίζ διαγράφηκε';
$string['eventattemptpreviewstarted'] = 'Η προεπισκόπηση της προσπάθειας κουίζ ξεκίνησε';
$string['eventattemptquestionrestarted'] = 'Επανεκκινήθηκε η ερώτηση προσπάθειας κουίζ';
$string['eventattemptreviewed'] = 'Έγινε ανασκόπηση της προσπάθειας του κουίζ';
$string['eventattemptsummaryviewed'] = 'Εμφανίστηκε η περίληψη απόπειρας κουίζ';
$string['eventattemptupdated'] = 'Η προσπάθεια κουίζ ενημερώθηκε';
$string['eventattemptviewed'] = 'Η προσπάθεια κουίζ προβλήθηκε';
$string['eventeditpageviewed'] = 'Η σελίδα επεξεργασίας κουίζ προβλήθηκε';
$string['eventoverridecreated'] = 'Η παράκαμψη κουίζ δημιουργήθηκε';
$string['eventoverridedeleted'] = 'Η παράκαμψη κουίζ διαγράφηκε';
$string['eventoverrideupdated'] = 'Η παράκαμψη κουίζ ενημερώθηκε';
$string['eventquestionmanuallygraded'] = 'Η ερώτηση βαθμολογήθηκε χειροκίνητα';
$string['eventquizattemptabandoned'] = 'Η προσπάθεια στο κουίζ εγκαταλείφθηκε';
$string['eventquizattemptregraded'] = 'Η προσπάθεια κουίζ αναβαθμολογήθηκε';
$string['eventquizattemptstarted'] = 'Η προσπάθεια στο κουίζ ξεκίνησε';
$string['eventquizattemptsubmitted'] = 'Η προσπάθεια στο κουίζ υποβλήθηκε';
$string['eventquizattempttimelimitexceeded'] = 'Το χρονικό όριο προσπάθειας κουίζ ξεπεράστηκε';
$string['eventreportviewed'] = 'Η αναφορά κουίζ προβλήθηκε';
$string['everynquestions'] = 'Κάθε {$a} ερωτήσεις';
$string['everyquestion'] = 'Κάθε ερώτηση';
$string['everythingon'] = 'Όλα σε';
$string['existingcategory'] = 'Υπάρχουσα κατηγορία';
$string['exportcategory'] = 'εξαγωγή κατηγορίας';
$string['exporterror'] = 'Εντοπίστηκε σφάλμα κατά τη διαδικασία εξαγωγής';
$string['exportingquestions'] = 'Οι ερωτήσεις εξάγονται σε αρχείο';
$string['exportname'] = 'Όνομα αρχείου';
$string['exportquestions'] = 'Εξαγωγή ερωτήσεων σε αρχείο';
$string['extraattemptrestrictions'] = 'Έξτρα περιορισμοί στις προσπάθειες';
$string['false'] = 'Λάθος';
$string['feedback'] = 'Ανατροφοδότηση';
$string['feedbackerrorboundaryformat'] = 'Τα όρια του βαθμού ανατροφοδότησης πρέπει να είναι ποσοστό ή αριθμός. Η τιμή που εισαγάγατε στο όριο {$a} δεν είναι αναγνωρίσιμη.';
$string['feedbackerrorboundaryoutofrange'] = 'Τα όρια του βαθμού ανατροφοδότησης πρέπει να είναι μεταξύ 0% και 100%. Η τιμή που εισαγάγατε στο όριο {$a} είναι εκτός ορίων.';
$string['feedbackerrorjunkinboundary'] = 'Πρέπει να συμπληρώσετε τα πεδία για τα όρια του βαθμού ανατροφοδότησης χωρίς να αφήσετε κενά.';
$string['feedbackerrorjunkinfeedback'] = 'Πρέπει να συμπληρώσετε τα πεδία της ανατροφοδότησης χωρίς να αφήσετε κενά.';
$string['feedbackerrororder'] = 'Τα όρια του βαθμού ανατροφοδότησης πρέπει να είναι σε σειρά με το μεγαλύτερο πρώτο. Η τιμή που εισαγάγατε στο όριο {$a} δεν είναι σε σειρά.';
$string['file'] = 'Αρχείο';
$string['fileformat'] = 'Μορφή αρχείου';
$string['fillcorrect'] = 'Συμπληρώστε με το σωστό';
$string['filloutnumericalanswer'] = 'Δίνετε τουλάχιστον μια πιθανή απάντηση και βαθμό ανοχής. Η πρώτη απάντηση που θα ταιριάζει θα καθορίζει το βαθμό και την ανατροφοδότηση. Αν δώσετε ανατροφοδότηση χωρίς απάντηση στο τέλος, αυτή θα εμφανίζεται στους μαθητές των οποίων οι απαντήσεις δεν ταιριάζουν με καμία άλλη απάντηση.';
$string['filloutoneanswer'] = 'Πρέπει να συμπληρώσετε τουλάχιστον μία πιθανή απάντηση. Οι κενές απαντήσεις δε θα χρησιμοποιηθούν. Το «*» μπορεί να χρησιμοποιηθεί σαν μπαλαντέρ για να ταιριάζει σε κάθε χαρακτήρα. Η πρώτη απάντηση που ταιριάζει θα χρησιμοποιηθεί για τον προσδιορισμό του βαθμού και της ανατροφοδότησης.';
$string['filloutthreequestions'] = 'Πρέπει να συμπληρώσετε τουλάχιστον τρεις ερωτήσεις με αντίστοιχες απαντήσεις. Μπορείτε να παρέχετε επιπλέον λάθος απαντήσεις δίνοντας μια απάντηση με κενή ερώτηση. Εισαγωγές όπου η ερώτηση και η απάντηση αφήνονται κενές θα αγνοηθούν.';
$string['fillouttwochoices'] = 'Πρέπει να συμπληρώσετε τουλάχιστον δυο επιλογές. Οι κενές επιλογές δε θα χρησιμοποιηθούν.';
$string['finishattemptdots'] = 'Τελειώστε την προσπάθεια ...';
$string['finishreview'] = 'Τερματισμός ανασκόπησης';
$string['forceregeneration'] = 'επιβολή επαναδημιουργίας';
$string['formatnotfound'] = 'Αδυναμία εύρεσης μορφή εισαγωγής/εξαγωγής {$a}';
$string['formulaerror'] = 'Σφάλματα τύπων!';
$string['fractionsaddwrong'] = 'Οι θετικές βαθμολογίες που επιλέξατε δεν αθροίζονται ως το 100%
<br />Αντίθετα, αθροίζονται στο {$a}%
<br />Θέλετε να επιστρέψετε και να τροποποιήσετε την ερώτηση;';
$string['fractionsnomax'] = 'Μια από τις ερωτήσεις θα έπρεπε να είναι 100%, έτσι ώστε να είναι δυνατό
<br />να πάρει κάποιος το σύνολο της βαθμολογίας σε αυτή την ερώτηση.
<br />Θέλετε να επιστρέψετε και να τροποποιήσετε την ερώτηση;';
$string['fromfile'] = 'από αρχείο:';
$string['functiondisabledbysecuremode'] = 'Αυτή η λειτουργία είναι απενεργοποιημένη';
$string['generalfeedback'] = 'Γενική ανατροφοδότηση';
$string['generalfeedback_help'] = 'Η γενική ανατροφοδότηση είναι κείμενο που εμφανίζεται μετά από την προσπάθεια μιας ερώτησης. Σε αντίθεση με την ανατροφοδότηση για μια συγκεκριμένη ερώτηση που εξαρτάται από την απάντηση που δόθηκε, εδώ εμφανίζεται πάντα η ίδια γενική ανατροφοδότηση.';
$string['graceperiod'] = 'Περίοδος χάριτος υποβολής';
$string['graceperiod_desc'] = 'Εάν το τι πρέπει να γίνει όταν λήξει ο χρόνος έχει οριστεί σε «Υπάρχει περίοδος χάριτος...», τότε αυτός είναι ο προεπιλεγμένος επιπλέον χρόνος ((σε δευτερόλεπτα)) που δίνεται.';
$string['graceperiod_help'] = 'Εάν το τι πρέπει να γίνει όταν λήξει ο χρόνος έχει οριστεί σε «Υπάρχει περίοδος χάριτος...», τότε αυτός είναι ο επιπλέον χρόνος ((σε δευτερόλεπτα)) που δίνεται.';
$string['graceperiodmin'] = 'Τελευταία περίοδος χάριτος υποβολής';
$string['graceperiodmin_desc'] = 'Υπάρχει πιθανό πρόβλημα στο τέλος του κουίζ. Από τη μία πλευρά, θέλουμε να αφήσουμε τους μαθητές να συνεχίσουν να εργάζονται μέχρι το τελευταίο δευτερόλεπτο - με τη βοήθεια του χρονομετρητή που υποβάλλει αυτόματα το κουίζ όταν τελειώσει ο χρόνος. Από την άλλη πλευρά, ο εξυπηρετητής ενδέχεται να υπερφορτωθεί και να πάρει κάποιο χρόνο για να διεκπεραιώσει τις απαντήσεις. Ως εκ τούτου, θα αποδεχθούμε τις απαντήσεις για τόσο χρόνο μετά το τέλος του χρόνου, ώστε να μην τιμωρούνται αυτοί για την αργή ταχύτητα του εξυπηρετητή. Ωστόσο, ο μαθητής θα μπορούσε να εξαπατήσει και να πάρει αυτά τα πολλά δευτερόλεπτα για να απαντήσει στο κουίζ. Πρέπει να κάνετε ένα συμβιβασμό με βάση πόσο εμπιστεύεστε την απόδοση του εξυπηρετητή σας κατά τη διάρκεια των κουίζ.';
$string['graceperiodtoosmall'] = 'Η περίοδος χάριτος πρέπει να είναι περισσότερο από {$a}.';
$string['grade'] = 'Βαθμός';
$string['gradeall'] = 'Βαθμολόγηση όλων';
$string['gradeaverage'] = 'Μέσος βαθμός';
$string['gradeboundary'] = 'Όριο βαθμού';
$string['gradeessays'] = 'Βαθμολόγηση εκθέσεων';
$string['gradehighest'] = 'Ο υψηλότερος βαθμός';
$string['grademethod'] = 'Μέθοδος βαθμολόγησης';
$string['grademethod_help'] = 'Όταν επιτρέπονται πολλαπλές προσπάθειες, υπάρχουν οι ακόλουθοι μέθοδοι υπολογισμού του τελικού βαθμού στο κουίζ:

* Υψηλότερος βαθμός από όλες τις προσπάθειες.
* Μέσος όρος (μέση τιμή) όλων των προσπαθειών.
* Πρώτη προσπάθεια (όλες οι άλλες αγνοούνται).
* Τελευταία προσπάθεια (όλες οι άλλες αγνοούνται).';
$string['gradesdeleted'] = 'Οι βαθμοί του κουίζ διαγράφηκαν';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Ο βαθμός επιτυχίας δεν μπορεί να είναι μηδέν δεδομένου ότι το κουίζ έχει ως μέθοδο ελέγχου ολοκλήρωσης την απαίτηση για κάποιον ελάχιστο βαθμό επιτυχίας. Παρακαλούμε, ορίστε μη μηδενική τιμή.';
$string['gradetopassnotset'] = 'Αυτό το κουίζ δεν έχει ακόμα ορισμένο έναν βαθμό επιτυχίας. Μπορεί να οριστεί στην ενότητα Βαθμοί των ρυθμίσεων κουίζ.';
$string['gradetopassoutof'] = 'Βαθμός επιτυχίας: {$a->grade} στα {$a->maxgrade}';
$string['gradingdetails'] = 'Βαθμοί για αυτήν την υποβολή: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Με τις προηγούμενες ποινές αυτό δίνει <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Αυτή η υποβολή είχε ποινή {$a}.';
$string['gradingdetailszeropenalty'] = 'Δεν δεχθήκατε ποινή για αυτήν την υποβολή.';
$string['gradingmethod'] = 'Μέθοδος βαθμολόγησης: {$a}';
$string['groupoverrides'] = 'Παρακάμψεις ομάδας';
$string['groupoverridesdeleted'] = 'Οι παρακάμψεις ομάδας διαγράφηκαν';
$string['groupsnone'] = 'Δεν υπάρχουν προσβάσιμες για εσάς ομάδες.';
$string['guestsno'] = 'Λυπούμαστε, οι επισκέπτες δε μπορούν να δουν ή να συμμετέχουν σε κουίζ.';
$string['hidebreaks'] = 'Απόκρυψη αλλαγών σελίδας';
$string['hidereordertool'] = 'Απόκρυψη του εργαλείου επαναταξινόμησης';
$string['history'] = 'Ιστορικό αποκρίσεων:';
$string['howquestionsbehave_desc'] = 'Προεπιλεγμένη ρύθμιση για το πώς συμπεριφέρονται οι ερωτήσεις στο κουίζ.';
$string['imagedisplay'] = 'Εικόνα προς εμφάνιση';
$string['import_help'] = 'Αυτή η λειτουργία σας επιτρέπει να εισάγετε ερωτήσεις από εξωτερικά αρχεία κειμένου.

Εάν το αρχείο σας περιέχει χαρακτήρες που δεν είναι ASCII τότε πρέπει να χρησιμοποιηθεί κωδικοποίηση UTF-8. Να είστε ιδιαίτερα προσεκτικοί με τα αρχεία που παράγονται από εφαρμογές του Microsoft Office, καθώς αυτά συνήθως χρησιμοποιούν ειδική κωδικοποίηση η οποία δεν θα αντιμετωπιστεί σωστά.

Οι μορφότυποι Εισαγωγής και Εξαγωγής είναι συνδέσιμοι (pluggable) πόροι. Άλλοι προαιρετικοί μορφότυποι ενδέχεται να είναι διαθέσιμοι στη βάση δεδομένων Αρθρωμάτων και Πρόσθετων.';
$string['import_link'] = '';
$string['importcategory'] = 'εισαγωγή κατηγορίας';
$string['importerror'] = 'Εντοπίστηκε σφάλμα κατά τη διαδικασία εισαγωγής';
$string['importfilearea'] = 'Εισαγωγή από αρχείο που ήδη υπάρχει σε μάθημα...';
$string['importfileupload'] = 'Εισαγωγή από αρχείο...';
$string['importfromthisfile'] = 'Εισαγωγή από αυτό το αρχείο';
$string['importingquestions'] = 'Εισαγωγή {$a} ερωτήσεων από αρχείο';
$string['importmax10error'] = 'Υπάρχει σφάλμα στην ερώτηση. Δεν μπορείτε να έχετε περισσότερες από δέκα απαντήσεις';
$string['importmaxerror'] = 'Υπάρχει σφάλμα στην ερώτηση. Υπάρχουν πάρα πολλές απαντήσεις.';
$string['importquestions'] = 'Εισαγωγή ερωτήσεων από αρχείο';
$string['inactiveoverridehelp'] = '* Αυτή η παράκαμψη είναι ανενεργή, επειδή η πρόσβαση του χρήστη στη δραστηριότητα είναι περιορισμένη. Αυτό μπορεί να οφείλεται σε αναθέσεις ομάδων ή ρόλων, σε άλλους περιορισμούς πρόσβασης ή στην  απόκρυψη της δραστηριότητας.';
$string['incorrect'] = 'Λάθος';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης Κουίζ';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Κουίζ.';
$string['indicator:cognitivedepthdef'] = 'Βάθος κατανόησης Κουίζ';
$string['indicator:cognitivedepthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο βάθος κατανόησης που προσφέρεται από τις δραστηριότητες Κουίζ κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία εμφάνιση, Εμφάνιση, Υποβολή, Εμφάνιση ανατροφοδότησης, Σχόλιο στην ανατροφοδότηση, Επανυποβολή μετά την εμφάνιση της ανατροφοδότησης)';
$string['indicator:cognitivedepthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος Κουίζ';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Κουίζ.';
$string['indicator:socialbreadthdef'] = 'Κοινωνικό εύρος Κουίζ';
$string['indicator:socialbreadthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο κοινωνικό εύρος που προσφέρεται από τις δραστηριότητες Κουίζ κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία συμμετοχή, Συμμετέχων μόνος, Συμμετέχων με άλλους)';
$string['indicator:socialbreadthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['indivresp'] = 'Αποκρίσεις χρηστών σε κάθε στοιχείο';
$string['info'] = 'Πληροφορίες';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Αρχικός αριθμός πεδίων συνολικής ανατροφοδότησης';
$string['initialnumfeedbacks_desc'] = 'Κατά τη δημιουργία ενός νέου κουίζ, δώστε τόσα κενά πλαίσια συνολικής ανατροφοδότησης. Αφού δημιουργηθεί το κουίζ, η φόρμα εμφανίζει τον αριθμό των πεδίων που απαιτούνται για τον αριθμό των σχολίων στο κουίζ. Η ρύθμιση πρέπει να είναι τουλάχιστον 1.';
$string['inprogress'] = 'Σε εξέλιξη';
$string['introduction'] = 'Περιγραφή';
$string['invalidattemptid'] = 'Δεν υπάρχει αυτή η προσπάθεια';
$string['invalidcategory'] = 'Το ID της κατηγορίας είναι λάθος';
$string['invalidoverrideid'] = 'Άκυρο αναγνωριστικό παράκαμψης';
$string['invalidquestionid'] = 'Λανθασμένο αναγνωριστικό ερώτησης';
$string['invalidquizid'] = 'Μη έγκυρο αναγνωριστικό (κωδικός) κουίζ';
$string['invalidrandomslot'] = 'Μη έγκυρο αναγνωριστικό υποδοχής τυχαίας ερώτησης.';
$string['invalidsource'] = 'Μη έγκυρη πηγή.';
$string['invalidsourcetype'] = 'Λάθος τύπος πηγής.';
$string['invalidstateid'] = 'Λανθασμένο id κατάστασης';
$string['lastanswer'] = 'Η τελευταία σας απάντηση ήταν';
$string['layout'] = 'Διάταξη';
$string['layoutasshown'] = 'Διάταξη σελίδας όπως φαίνεται.';
$string['layoutasshownwithpages'] = 'Διάταξη σελίδας όπως φαίνεται. <small>(Νέα σελίδα κάθε {$a} ερωτήσεις.)</small>';
$string['layoutshuffledandpaged'] = 'Οι ερωτήσεις ανακατεύονται τυχαία με {$a} ερωτήσεις ανά σελίδα.';
$string['layoutshuffledsinglepage'] = 'Οι ερωτήσεις ανακατεύονται τυχαία, όλες σε μια σελίδα.';
$string['legacyquizaccessrulescron'] = 'Κανόνες πρόσβασης κουίζ με παλαιού τύπου cron';
$string['legacyquizreportscron'] = 'Αναφορές κουίζ με παλαιού τύπου cron';
$string['link'] = 'Σύνδεσμος';
$string['listitems'] = 'Λίστα στοιχείων στο κουίζ';
$string['literal'] = 'Κυριολεκτικά';
$string['loadingquestionsfailed'] = 'Η φόρτωση ερωτήσεων απέτυχε: {$a}';
$string['makecopy'] = 'Αποθήκευση ως νέα ερώτηση';
$string['managetypes'] = 'Διαχείριση τύπων ερωτήσεων και servers';
$string['manualgradequestion'] = 'Μη αυτόματη βαθμολογία ερώτησης «{$a->question}» στο κουίζ «{$a->quiz}» από τον/την «{$a->user}»';
$string['manualgrading'] = 'Βαθμολόγηση';
$string['mark'] = 'Υποβολή';
$string['markall'] = 'Υποβολή σελίδας';
$string['marks'] = 'Βαθμοί';
$string['marks_help'] = 'Οι αριθμητικοί βαθμοί για κάθε ερώτηση και το σκορ της συνολικής προσπάθειας';
$string['match'] = 'Αντιστοιχούν';
$string['matchanswer'] = 'Αντίστοιχη απάντηση';
$string['matchanswerno'] = 'Αντίστοιχη απάντηση {$a}';
$string['max'] = 'Μέγιστο';
$string['maxmark'] = 'Μέγιστος βαθμός';
$string['messageprovider:attempt_overdue'] = 'Προειδοποίηση όταν η προσπάθεια σας για το κουίζ γίνεται εκπρόθεσμη.';
$string['messageprovider:confirmation'] = 'Επιβεβαίωση για την υποβολή quiz';
$string['messageprovider:submission'] = 'Ειδοποίηση υποβολών κουίζ των μαθητών σας';
$string['min'] = 'Ελάχιστο';
$string['minutes'] = 'Λεπτά';
$string['missingcorrectanswer'] = 'Η σωστή απάντηση πρέπει να προσδιοριστεί';
$string['missingitemtypename'] = 'Απόν όνομα';
$string['missingquestion'] = 'Αυτή η ερώτηση δεν φαίνεται πλέον να υπάρχει';
$string['modulename'] = 'Κουίζ';
$string['modulename_help'] = 'Η δραστηριότητα κουίζ επιτρέπει σε έναν διδάσκοντα να δημιουργεί κουίζ που περιλαμβάνουν ερωτήσεις διαφόρων τύπων, συμπεριλαμβανομένων πολλαπλών επιλογών, αντιστοίχισης, σύντομης απάντησης και αριθμητικές.

Ο διδάσκοντας μπορεί να επιτρέψει την προσπάθεια του κουίζ πολλές φορές, με τις ερωτήσεις να ανακατεύονται ή τυχαία να επιλέγονται από την τράπεζα ερωτήσεων. Μπορεί να οριστεί χρονικό όριο.

Κάθε προσπάθεια βαθμολογείται αυτόματα, με εξαίρεση τις ερωτήσεις συγγραφής έκθεσης, και η βαθμολογία καταγράφεται στο βαθμολόγιο.

Ο διδάσκοντας μπορεί να επιλέξει πότε και αν οι υποδείξεις, η ανατροφοδότηση και οι σωστές απαντήσεις θα εμφανίζονται στους μαθητές.

Τα κουίζ μπορούν να χρησιμοποιηθούν:

* Ως εξετάσεις μαθήματος
* Ως μίνι τεστ για ανάγνωση εργασιών ή στο τέλος ενός θέματος
* Ως πρακτική εξάσκηση για εξετάσεις χρησιμοποιώντας ερωτήσεις από προηγούμενες εξετάσεις
* Για να παραδώσει άμεση ανατροφοδότηση σχετικά με την απόδοση
* Για αυτο-αξιολόγηση';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Κουίζ';
$string['moveselectedonpage'] = 'Μετακίνηση επιλεγμένων ερωτήσεων στη σελίδα: {$a}';
$string['multichoice'] = 'Πολλαπλή επιλογή';
$string['multipleanswers'] = 'Επιλέξτε τουλάχιστον μία απάντηση.';
$string['mustbesubmittedby'] = 'Αυτή η προσπάθεια πρέπει να υποβληθεί από {$a}.';
$string['name'] = 'Όνομα';
$string['navigatenext'] = 'Επόμενη σελίδα';
$string['navigateprevious'] = 'Προηγούμενη σελίδα';
$string['navmethod'] = 'Μέθοδο πλοήγησης';
$string['navmethod_free'] = 'Ελεύθερη';
$string['navmethod_help'] = 'Όταν ενεργοποιηθεί η διαδοχική πλοήγηση, ο μαθητής πρέπει να προχωρεί μέσα στο κουίζ με τη σειρά και δεν μπορεί να επιστρέψει σε προηγούμενες σελίδες ούτε να υπερπηδήσει (παραλείποντας) σε μεθεπόμενη σελίδα.';
$string['navmethod_seq'] = 'Διαδοχική';
$string['navnojswarning'] = 'Προειδοποίηση: οι σύνδεσμοι αυτοί δεν θα αποθηκεύσουν τις απαντήσεις σας. Χρησιμοποιήστε το επόμενο πλήκτρο στο κάτω μέρος της σελίδας.';
$string['neverallononepage'] = 'Ποτέ, όλες οι ερωτήσεις σε μια σελίδα';
$string['newattemptfail'] = 'Σφάλμα: Δεν ήταν δυνατή η εκκίνηση νέας προσπάθειας στο κουίζ';
$string['newcategory'] = 'Νέα κατηγορία';
$string['newpage'] = 'Νέα σελίδα';
$string['newpage_help'] = 'Για μεγαλύτερα κουίζ, είναι λογικό να εκτείνεται το κουίζ σε αρκετές σελίδες, με το να περιορίζεται ο αριθμός των ερωτήσεων ανά σελίδα. Κατά την προσθήκη ερωτήσεων στο κουίζ, οι αλλαγές σελίδας θα εισαχθούν αυτόματα σύμφωνα με αυτή τη ρύθμιση/αριθμό. Ωστόσο, οι αλλαγές σελίδας μπορούν αργότερα να μετακινηθούν χειροκίνητα στη σελίδα επεξεργασίας.';
$string['newpageevery'] = 'Αυτόματο ξεκίνημα νέας σελίδας';
$string['newsectionheading'] = 'Νέα επικεφαλίδα';
$string['noanswers'] = 'Δεν επιλέχθηκε καμία απάντηση!';
$string['noattempts'] = 'Καμιά προσπάθεια δεν έγινε για αυτό το κουίζ';
$string['noattemptsfound'] = 'Δεν βρέθηκαν προσπάθειες.';
$string['noattemptstoshow'] = 'Δεν υπάρχουν προσπάθειες για εμφάνιση';
$string['nocategory'] = 'Εσφαλμένη ή μη επιλεγμένη κατηγορία';
$string['noclose'] = 'Χωρίς ημερομηνία λήξης';
$string['nocommentsyet'] = 'Δεν υπάρχουν σχόλια προς το παρόν.';
$string['noconnection'] = 'Δεν υπάρχει αυτή τη στιγμή σύνδεση σε μία υπηρεσία ιστού που να μπορεί να επεξεργαστεί αυτήν την ερώτηση. Παρακαλούμε επικοινωνήστε με το διαχειριστή σας.';
$string['nodataset'] = 'τίποτα - δεν είναι μπαλαντέρ';
$string['nodatasubmitted'] = 'Δεν υποβλήθηκαν δεδομένα.';
$string['noessayquestionsfound'] = 'Δεν βρέθηκαν ερωτήσεις που να βαθμολογήθηκαν χειροκίνητα';
$string['nogradewarning'] = 'Αυτό το κουίζ δε βαθμολογείται, συνεπώς δεν μπορείτε να ορίσετε συνολική ανατροφοδότηση που διαφέρει ανάλογα με το βαθμό.';
$string['nomoreattempts'] = 'Δεν επιτρέπονται άλλες προσπάθειες';
$string['none'] = 'Κανένα';
$string['noopen'] = 'Καμία ημερομηνία ανοιχτή';
$string['nooverridedata'] = 'Πρέπει να παρακάμψετε τουλάχιστον μία ρύθμιση κουίζ.';
$string['nopossibledatasets'] = 'Κανένα πιθανό σύνολο δεδομένων';
$string['noquestionintext'] = 'Το κείμενο της ερώτησης δεν περιέχει ενσωματωμένες ερωτήσεις';
$string['noquestions'] = 'Καμία ερώτηση δεν έχει προστεθεί ακόμα';
$string['noquestionsfound'] = 'Δεν βρέθηκαν ερωτήσεις';
$string['noquestionsinquiz'] = 'Δεν υπάρχουν ερωτήσεις σε αυτό το κουίζ.';
$string['noquestionsnotinuse'] = 'Αυτή η τυχαία ερώτηση δε χρησιμοποιείται από τη στιγμή που η κατηγορία της είναι κενή.';
$string['noquestionsonpage'] = 'Κενή σελίδα';
$string['noresponse'] = 'Καμία απόκριση';
$string['noreview'] = 'Δε σας επιτρέπεται να αναθεωρήσετε αυτό το κουίζ';
$string['noreviewattempt'] = 'Δεν επιτρέπεται να αναθεωρήσετε αυτήν την προσπάθεια.';
$string['noreviewshort'] = 'Δεν επιτρέπεται';
$string['noreviewuntil'] = 'Δε σας επιτρέπεται να αναθεωρήσετε αυτό το κουίζ μέχρι {$a}';
$string['noreviewuntilshort'] = 'Διαθέσιμο {$a}';
$string['noscript'] = 'Η Javascript πρέπει να είναι ενεργοποιημένη για να συνεχίσετε!';
$string['notavailabletostudents'] = 'Σημείωση: Αυτό το κουίζ δεν είναι προς το παρόν διαθέσιμο για τους μαθητές';
$string['notenoughrandomquestions'] = 'Δεν υπάρχουν αρκετές ερωτήσεις στην κατηγορία «{$a->category}» για να δημιουργήσετε την ερώτηση «{$a->name}» ({$a->id}).';
$string['notenoughsubquestions'] = 'Δεν έχουν οριστεί αρκετά υποερωτήματα!<br />
Θέλετε να επιστρέψετε και να διορθώσετε αυτήν την ερώτηση;';
$string['notimedependentitems'] = 'Αντικείμενα που σχετίζονται με χρονικό όριο δεν υποστηρίζονται από το μηχανισμό του κουίζ. Εναλλακτικά, μπορείτε να θέσετε ένα χρονικό όριο για όλα το κουίζ. Θέλετε να επιλέξετε άλλο αντικείμενο (η να χρησιμοποιήσετε αυτό ανεξαρτήτως χρόνου);';
$string['notyetgraded'] = 'Χωρίς βαθμολογία ακόμη';
$string['notyetviewed'] = 'Καμία προβολή ακόμη';
$string['notyourattempt'] = 'Αυτή δεν είναι δική σας προσπάθεια!';
$string['noview'] = 'Ο εισηγμένος χρήσης δεν έχει δικαίωμα προβολής αυτού του κουίζ';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} έχουν κάνει {$a->attemptnum} προσπάθειες';
$string['numberabbr'] = '#';
$string['numerical'] = 'Αριθμητικό';
$string['numquestionsx'] = 'ερωτήσεις: {$a}';
$string['oneminute'] = '1 λεπτό';
$string['onlyteachersexport'] = 'Μόνο οι καθηγητές μπορούν να εξαγάγουν ερωτήσεις';
$string['onlyteachersimport'] = 'Μόνο οι διδάσκοντες με δικαίωμα επεξεργασίας μπορούν να εισαγάγουν ερωτήσεις';
$string['onthispage'] = 'Αυτή η σελίδα';
$string['open'] = 'Δεν απαντήθηκε';
$string['openafterclose'] = 'Δεν ήταν δυνατή η ενημέρωση του κουίζ. Έχετε ορίσει ημερομηνία έναρξης μετά την ημερομηνία λήξης.';
$string['openclosedatesupdated'] = 'Κουίζ ανοιχτό και οι ημερομηνίες κλεισίματος έχουν ενημερωθεί';
$string['optional'] = 'προαιρετικό';
$string['orderandpaging'] = 'Σειρά και σελιδοποίηση';
$string['orderandpaging_help'] = 'Οι αριθμοί 10, 20, 30, ... απέναντι σε κάθε ερώτηση δείχνουν τη σειρά των ερωτήσεων. Οι αριθμοί αυξάνουν σε βήματα των 10 για να αφεθεί χώρος για να εισαχθούν επιπρόσθετες ερωτήσεις. Για να αναδιατάξετε τις ερωτήσεις, αλλάξτε τους αριθμούς και, στη συνέχεια, κάντε κλικ στο κουμπί «Αναδιάταξη ερωτήσεων».

Για να προσθέσετε αλλαγή σελίδας μετά από συγκεκριμένες ερωτήσεις, επιλέξτε τα πλαίσια επιλογής δίπλα στις ερωτήσεις και στη συνέχεια κάντε κλικ στο πλήκτρο «Προσθήκη νέων σελίδων μετά από επιλεγμένες ερωτήσεις».

Για να διευθετήσετε τις ερωτήσεις σε ένα πλήθος σελίδων, κάντε κλικ στο πλήκτρο «Επανασελιδοποίηση» και επιλέξτε τον επιθυμητό αριθμό ερωτήσεων ανά σελίδα.';
$string['orderingquiz'] = 'Σειρά και σελιδοποίηση';
$string['orderingquizx'] = 'Σειρά και σελιδοποίηση: {$a}';
$string['outcomesadvanced'] = 'Τα μαθησιακά αποτελέσματα είναι προχωρημένες ρυθμίσεις';
$string['outof'] = '{$a->grade} από {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} από ένα μέγιστο {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Συνολική ανατροφοδότηση';
$string['overallfeedback_help'] = 'Η συνολική ανατροφοδότηση είναι κείμενο που εμφανίζεται αφού κάποιος προσπαθήσει ένα κουίζ. Καθορίζοντας επιπρόσθετα όρια βαθμών (ως ποσοστό ή σε απόλυτη τιμή), το κείμενο που εμφανίζεται μπορεί να εξαρτάται από τον βαθμό που επιτεύχθηκε.';
$string['overdue'] = 'Εκπρόθεσμο';
$string['overduehandling'] = 'Όταν παρέλθει ο χρόνος';
$string['overduehandling_desc'] = 'Τι πρέπει να συμβεί από προεπιλογή εάν ένας μαθητής δεν υποβάλει το κουίζ πριν λήξει η προθεσμία.';
$string['overduehandling_help'] = 'Αυτή η ρύθμιση ελέγχει τι θα συμβεί εάν ο μαθητής δεν υποβάλει την προσπάθειά του για το κουίζ πριν λήξει η προθεσμία. Εάν ο μαθητής εργάζεται ενεργά στο κουίζ εκείνη τη στιγμή, τότε το χρονόμετρο αντίστροφης μέτρησης θα υποβάλει πάντα αυτόματα την προσπάθεια για αυτόν, αλλά αν έχει αποσυνδεθεί, τότε αυτή η ρύθμιση ελέγχει τι θα συμβεί.';
$string['overduehandling_link'] = '';
$string['overduehandlingautoabandon'] = 'Οι προσπάθειες πρέπει να υποβληθούν πριν από τη λήξη του χρόνου, αλλιώς δεν υπολογίζονται';
$string['overduehandlingautosubmit'] = 'Οι ανοιχτές προσπάθειες υποβάλλονται αυτόματα';
$string['overduehandlinggraceperiod'] = 'Υπάρχει μια περίοδος χάριτος όπου μπορούν να υποβληθούν ανοιχτές προσπάθειες, αλλά δεν μπορούν να απαντηθούν περισσότερες ερωτήσεις';
$string['overduemustbesubmittedby'] = 'Αυτή η προσπάθεια είναι πλέον εκπρόθεσμη. Έπρεπε να έχει υποβληθεί ήδη. Εάν θέλετε να βαθμολογηθεί αυτό το κουίζ, πρέπει να το υποβάλετε μέχρι {$a}. Εάν δεν το υποβάλετε μέχρι τότε, δεν θα ληφθούν υπόψη βαθμολογίες για αυτή την προσπάθεια.';
$string['override'] = 'Παράκαμψη';
$string['overridedeletegroupsure'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την παράκαμψη για την ομάδα {$a};';
$string['overridedeleteusersure'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε την παράκαμψη για τον χρήστη {$a};';
$string['overridegroup'] = 'Παράκαμψη ομάδας';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Παρακάμψεις';
$string['overridesforquiz'] = 'Παρακάμψεις ρυθμίσεων: {$a}';
$string['overridesnoneforgroups'] = 'Δεν έχουν δημιουργηθεί παρακάμψεις ρυθμίσεων ομάδας για αυτό το κουίζ.';
$string['overridesnoneforusers'] = 'Δεν έχουν δημιουργηθεί παρακάμψεις ρυθμίσεων χρήστη για αυτό το κουίζ.';
$string['overridessummary'] = 'Υπάρχουν παρακάμψεις ρυθμίσεων ({$a})';
$string['overridessummarygroup'] = 'Ομάδες: {$a}';
$string['overridessummarythisgroup'] = 'Υπάρχουν παρακάμψεις ρυθμίσεων ({$a}) για αυτήν την ομάδα';
$string['overridessummaryuser'] = 'Χρήστες: {$a}';
$string['overridessummaryyourgroups'] = 'Υπάρχουν παρακάμψεις ρυθμίσεων ({$a}) για τις ομάδες σας';
$string['overrideuser'] = 'Παράκαμψη χρήστη';
$string['overrideusereventname'] = '{$a->quiz} - Παράκαμψη';
$string['page-mod-quiz-attempt'] = 'Προσπάθεια σελίδας κουίζ';
$string['page-mod-quiz-edit'] = 'Επεξεργασία σελίδας κουίζ';
$string['page-mod-quiz-report'] = 'Οποιαδήποτε σελίδα αναφοράς κουίζ';
$string['page-mod-quiz-review'] = 'Εξέταση σελίδας προσπάθειας κουίζ';
$string['page-mod-quiz-summary'] = 'Σελίδα περίληψης απόπειρας κουίζ';
$string['page-mod-quiz-view'] = 'Σελίδα πληροφοριών κουίζ';
$string['page-mod-quiz-x'] = 'Οποιαδήποτε σελίδα αρθρώματος κουίζ';
$string['pageshort'] = 'Σελ.';
$string['pagesize'] = 'Μέγεθος σελίδας';
$string['parent'] = 'Γονικό';
$string['parentcategory'] = 'Γονική κατηγορίας';
$string['parsingquestions'] = 'Ανάλυση ερωτήσεων από αρχείο εισαγωγής.';
$string['partiallycorrect'] = 'Μερικώς σωστή';
$string['penalty'] = 'Ποινή';
$string['penaltyscheme'] = 'Εφαρμογή ποινών';
$string['penaltyscheme_help'] = 'Εάν ενεργοποιηθεί, μια ποινή αφαιρείται από τον τελικό βαθμό μιας ερώτησης για κάθε λάθος απόκριση σε αυτή. Το μέγεθος της ποινής καθορίζεται στις ρυθμίσεις της ερώτησης. Η ρύθμιση αυτή εφαρμόζεται μόνο αν είναι ενεργοποιημένη η «Κατάσταση προσαρμογής».';
$string['percentcorrect'] = 'Ποσοστό σωστό';
$string['pleaseclose'] = 'Η αίτησή σας έχει ολοκληρωθεί. Μπορείτε να κλείσετε αυτό το παράθυρο';
$string['pluginadministration'] = 'Διαχείριση κουίζ';
$string['pluginname'] = 'Κουίζ';
$string['popup'] = 'Εμφάνιση κουίζ σε «ασφαλές» παράθυρο';
$string['popupblockerwarning'] = 'Αυτή η ενότητα του τεστ είναι σε ασφαλή λειτουργία. Αυτό σημαίνει ότι πρέπει να συμπληρώσετε το κουίζ σε ένα ασφαλές παράθυρο. Παρακαλούμε απενεργοποιήστε τον αποκλεισμό αναδυομένων παραθύρων. Ευχαριστούμε.';
$string['popupnotice'] = 'Οι μαθητές θα δουν αυτό το κουίζ σε ασφαλές παράθυρο';
$string['preprocesserror'] = 'Συνέβη σφάλμα κατά την προ-επεξεργασία!';
$string['preview'] = 'Προεπισκόπηση';
$string['previewquestion'] = 'Προεπισκόπηση ερώτησης';
$string['previewquiz'] = 'Προεπισκόπηση {$a}';
$string['previewquiznow'] = 'Προεπισκόπηση κουίζ';
$string['previous'] = 'Προηγούμενη κατάσταση';
$string['privacy:metadata:core_question'] = 'Η δραστηριότητα κουίζ αποθηκεύει πληροφορίες χρήσης ερωτήσεων στο υποσύστημα core_question (πυρήνας_ερώτηση).';
$string['privacy:metadata:quiz'] = 'Η δραστηριότητα του κουίζ χρησιμοποιεί αναφορές κουίζ.';
$string['privacy:metadata:quiz_attempts'] = 'Λεπτομέρειες για κάθε προσπάθεια ενός κουίζ.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Ο αριθμός προσπάθειας.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Η τρέχουσα σελίδα στην οποία είναι ο χρήστης.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Εάν αυτή είναι μια προεπισκόπηση του κουίζ.';
$string['privacy:metadata:quiz_attempts:state'] = 'Η τρέχουσα κατάσταση της προσπάθειας.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Το άθροισμα των βαθμών στην προσπάθεια.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Πότε ελέγχθηκε η κατάσταση.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Πότε ολοκληρώθηκε η προσπάθεια.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Πότε ενημερώθηκε η προσπάθεια.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Πότε ενημερώθηκε η προσπάθεια μέσω ενημέρωσης εκτός σύνδεσης.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Πότε ξεκίνησε η προσπάθεια.';
$string['privacy:metadata:quiz_grades'] = 'Λεπτομέρειες σχετικά με τη συνολική βαθμολογία για αυτό το κουίζ.';
$string['privacy:metadata:quiz_grades:grade'] = 'Ο συνολικός βαθμός για αυτό το κουίζ.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Το κουίζ που βαθμολογήθηκε.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Πότε τροποποιήθηκε η βαθμολογία.';
$string['privacy:metadata:quiz_grades:userid'] = 'Ο χρήστης που βαθμολογήθηκε.';
$string['privacy:metadata:quiz_overrides'] = 'Λεπτομέρειες για τις παρακάμψεις για αυτό το κουίζ.';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Το κουίζ με πληροφορίες παράκαμψης';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Η νέα ώρα λήξης για το κουίζ.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Το νέο χρονικό όριο για το κουίζ.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Η νέα ώρα έναρξης για το κουίζ.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Ο χρήστης που παρακάμπτεται';
$string['privacy:metadata:quizaccess'] = 'Η δραστηριότητα του κουίζ χρησιμοποιεί κανόνες πρόσβασης κουίζ.';
$string['publish'] = 'Δημοσίευση';
$string['publishedit'] = 'Πρέπει να έχετε δικαιώματα στο μάθημα για να προσθέσετε ή να επεξεργαστείτε ερωτήσεις σε αυτήν την κατηγορία';
$string['qbrief'] = 'Ερ. {$a}';
$string['qname'] = 'όνομα';
$string['qti'] = 'Μορφή IMS QTI';
$string['qtypename'] = 'τύπος, όνομα';
$string['question'] = 'Ερώτηση';
$string['questionbank'] = 'από τράπεζα ερωτήσεων';
$string['questionbankmanagement'] = 'Διαχείριση τράπεζας ερωτήσεων';
$string['questionbehaviour'] = 'Συμπεριφορά ερώτησης';
$string['questioncats'] = 'Κατηγορίες ερωτήσεων';
$string['questiondeleted'] = 'Αυτή η ερώτηση έχει διαγραφεί. Παρακαλούμε επικοινωνήστε με τον διδάσκοντά σας.';
$string['questiondependencyadd'] = 'Δεν υπάρχει περιορισμός για το πότε μπορεί να επιχειρηθεί η ερώτηση {$a->thisq} • Κάντε κλικ για αλλαγή';
$string['questiondependencyfree'] = 'Δεν υπάρχει περιορισμός σε αυτή την ερώτηση';
$string['questiondependencyremove'] = 'Η ερώτηση {$a->thisq} δεν μπορεί να επιχειρηθεί μέχρι να ολοκληρωθεί η προηγούμενη ερώτηση {$a->previousq} • Κάντε κλικ για αλλαγή';
$string['questiondependsonprevious'] = 'Αυτή η ερώτηση δεν μπορεί να επιχειρηθεί μέχρι να ολοκληρωθεί η προηγούμενη ερώτηση.';
$string['questioninuse'] = 'Η ερώτηση «{$a->questionname}» χρησιμοποιείται στο: <br />{$a->quiznames}<br /> Η ερώτηση δεν θα διαγραφεί από τα κουίζ αλλά μόνο από την λίστα κατηγοριών.';
$string['questionmissing'] = 'Η ερώτηση για αυτή τη σύνοδο λείπει';
$string['questionname'] = 'Όνομα ερώτησης';
$string['questionnonav'] = '<span class="accesshide">Ερώτηση </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Πληροφορίες </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Η ερώτηση {$a} δεν έχει φορτωθεί από τη βάση';
$string['questionorder'] = 'Σειρά ερώτησης';
$string['questionposition'] = 'Νέα θέση στη σειρά, για την ερώτηση {$a}';
$string['questions'] = 'Ερωτήσεις';
$string['questionsetpreview'] = 'Προεπισκόπηση του σετ ερωτήσεων';
$string['questionsinclhidden'] = 'Ερωτήσεις (συμπεριλαμβανομένων των κρυμμένων)';
$string['questionsinthisquiz'] = 'Ερωτήσεις σε αυτό το κουίζ';
$string['questionsmatchingfilter'] = 'Ερωτήσεις που ταιριάζουν με αυτό το φίλτρο: {$a}';
$string['questionsperpage'] = 'Ερωτήσεις ανά σελίδα';
$string['questionsperpageselected'] = 'Οι ερωτήσεις ανά σελίδα έχουν οριστεί ώστε η σελιδοποίηση είναι δεδομένη. Ως αποτέλεσμα, τα χειριστήρια σελιδοποίησης έχουν απενεργοποιηθεί. Μπορείτε να το αλλάξετε αυτό στο {$a}.';
$string['questionsperpagex'] = 'ερωτήσεις per σελίδα: {$a}';
$string['questiontext'] = 'Κείμενο ερώτησης';
$string['questiontextisempty'] = '[Κενό κείμενο ερώτησης]';
$string['questiontype'] = 'Τύπος ερώτησης {$a}';
$string['questiontypesetupoptions'] = 'Ρυθμίσεις για ερωτήσεις τύπων:';
$string['quiz:addinstance'] = 'Προσθήκη νέου κουίζ';
$string['quiz:attempt'] = 'Συμμετοχή σε κουίζ';
$string['quiz:deleteattempts'] = 'Διαγραφή προσπαθειών του κουίζ';
$string['quiz:emailconfirmsubmission'] = 'Λάβετε επιβεβαίωση των υποβολών σας για κουίζ';
$string['quiz:emailnotifysubmission'] = 'Λάβετε επιβεβαίωση των υποβολών των μαθητών σας για κουίζ';
$string['quiz:emailwarnoverdue'] = 'Λάβετε προειδοποίηση όταν η προσπάθεια κουίζ σας καθυστερήσει';
$string['quiz:grade'] = 'Χειροκίνητη βαθμολόγηση των κουίζ';
$string['quiz:ignoretimelimits'] = 'Αγνόηση του ορίου χρόνου στα κουίζ';
$string['quiz:manage'] = 'Διαχείριση των κουίζ';
$string['quiz:manageoverrides'] = 'Διαχείριση παρακάμψεων ρυθμίσεων κουίζ';
$string['quiz:preview'] = 'Προεπισκόπηση των κουίζ';
$string['quiz:regrade'] = 'Αναβαθμολόγηση προσπαθειών κουίζ';
$string['quiz:reviewmyattempts'] = 'Ανασκόπηση των δικών σου προσπαθειών';
$string['quiz:view'] = 'Εμφάνιση πληροφοριών του κουίζ';
$string['quiz:viewoverrides'] = 'Προβολή παρακάμψεων ρυθμίσεων κουίζ';
$string['quiz:viewreports'] = 'Εμφάνιση των αναφορών του κουίζ';
$string['quizavailable'] = 'Το κουίζ είναι διαθέσιμο μέχρι: {$a}';
$string['quizclose'] = 'Κλείσιμο κουίζ';
$string['quizclosed'] = 'Αυτό το κουίζ έκλεισε {$a}';
$string['quizcloses'] = 'Το κουίζ κλείνει';
$string['quizcloseson'] = 'Αυτό το κουίζ θα κλείσει στις {$a}.';
$string['quizeventcloses'] = '{$a} λήγει';
$string['quizeventopens'] = '{$a} αρχίζει';
$string['quizisclosed'] = 'Το κουίζ είναι κλειστό';
$string['quizisclosedwillopen'] = 'Το κουίζ έκλεισε (ανοίγει {$a})';
$string['quizisopen'] = 'Αυτό το κουίζ είναι ανοιχτό';
$string['quizisopenwillclose'] = 'Κουίζ ανοιχτό (κλείνει {$a})';
$string['quiznavigation'] = 'Πλοήγηση κουίζ';
$string['quizopen'] = 'Άνοιγμα του κουίζ';
$string['quizopenclose'] = 'Ημερομηνίες ανοίγματος και κλεισίματος';
$string['quizopenclose_help'] = 'Οι μαθητές μπορούν να αρχίσουν τις προσπάθειες τους μόνο μετά τον εναρκτήριο χρόνο και πρέπει να ολοκληρώσουν τις προσπάθειες τους πριν το κλείσιμό του.';
$string['quizopenclose_link'] = '';
$string['quizopened'] = 'Αυτό το κουίζ είναι ανοιχτό.';
$string['quizopenedon'] = 'Αυτό το κουίζ άνοιξε στις {$a}';
$string['quizopens'] = 'Άνοιγμα κουίζ';
$string['quizopenwillclose'] = 'Αυτό το κουίζ είναι ανοιχτό. Θα κλείσει στις {$a} στις';
$string['quizordernotrandom'] = 'Σειρά του κουίζ όχι ανακατεμένη';
$string['quizorderrandom'] = '* Σειρά του κουίζ ανακατεμένη';
$string['quizreport'] = 'Αναφορά κουίζ';
$string['quizsettings'] = 'Ρυθμίσεις κουίζ';
$string['quiztimer'] = 'Χρονόμετρο του κουίζ';
$string['quizwillopen'] = 'Το κουίζ αυτό θα ανοίξει {$a}';
$string['random'] = 'Τυχαία ερώτηση';
$string['randomcreate'] = 'Δημιουργία τυχαίων ερωτήσεων';
$string['randomediting'] = 'Επεξεργασία τυχαίας ερώτησης';
$string['randomfromcategory'] = 'Τυχαία ερώτηση από κατηγορία:';
$string['randomfromexistingcategory'] = 'Τυχαίες ερωτήσεις από μία υπάρχουσα κατηγορία';
$string['randomfromunavailabletag'] = '{$a} (δεν είναι διαθέσιμη)';
$string['randomnosubcat'] = 'Ερωτήσεις από αυτήν την κατηγορία και μόνο, όχι από τις υποκατηγορίες της.';
$string['randomnumber'] = 'Αριθμός τυχαίων ερωτήσεων';
$string['randomquestion'] = 'Τυχαία ερώτηση';
$string['randomquestion_help'] = 'Μια τυχαία ερώτηση είναι ένας τρόπος να εισαχθεί σε μια δραστηριότητα μια τυχαία επιλεγμένη ερώτηση από μια καθορισμένη κατηγορία ή από μια συγκεκριμένη ετικέτα.';
$string['randomquestiontags'] = 'Ετικέτες';
$string['randomquestiontags_help'] = 'Μπορείτε να περιορίσετε περαιτέρω τα κριτήρια επιλογής, καθορίζοντας εδώ ορισμένες ετικέτες ερωτήσεων.

Οι «τυχαίες» ερωτήσεις θα επιλεγούν από τις ερωτήσεις που έχουν όλες αυτές τις ετικέτες.';
$string['randomquestionusinganewcategory'] = 'Τυχαίες ερωτήσεις χρησιμοποιώντας μία νέα κατηγορία';
$string['randomwithsubcat'] = 'Ερωτήσεις από αυτήν την κατηγορία και από τις υποκατηγορίες της.';
$string['readytosend'] = 'Πρόκειται να στείλετε ολόκληρο το κουίζ σας για βαθμολόγηση. Είστε σίγουροι ότι θέλετε να συνεχίσετε;';
$string['reattemptquiz'] = 'Επαναπροσπάθεια του κουίζ';
$string['recentlyaddedquestion'] = 'Πρόσφατα προστιθεμένη ερώτηση!';
$string['recurse'] = 'Συμπερίληψη ερωτήσεων από υποκατηγορίες';
$string['redoesofthisquestion'] = 'Άλλες ερωτήσεις που επιχειρήθηκαν εδώ: {$a}';
$string['redoquestion'] = 'Δοκιμή κι άλλης ερώτησης όπως αυτή';
$string['regrade'] = 'Επαναβαθμολόγηση όλων των προσπαθειών';
$string['regradecomplete'] = 'Όλες οι προσπάθειες έχουν επαναβαθμολογηθεί';
$string['regradecount'] = '{$a->changed} από {$a->attempt} βαθμοί άλλαξαν';
$string['regradedisplayexplanation'] = 'Δοκιμές που αλλάζουν κατά την επαναβαθμολόγηση εμφανίζονται ως υπερσύνδεσμοι στο παράθυρο εξέτασης ερωτήσεων';
$string['regradenotallowed'] = 'Δεν έχετε δικαίωμα να επαναβαθμολογήσετε αυτό το κουίζ';
$string['regradingquestion'] = 'Επαναβαθμολόγηση «{$a}»';
$string['regradingquiz'] = 'Επαναβαθμολόγηση κουίζ «{$a}»';
$string['remove'] = 'Αφαίρεση';
$string['removeallgroupoverrides'] = 'Διαγραφή όλων των παρακάμψεων ομάδας';
$string['removeallquizattempts'] = 'Διαγραφή όλων των προσπαθειών κουίζ';
$string['removealluseroverrides'] = 'Διαγραφή όλων των παρακάμψεων χρήστη';
$string['removeemptypage'] = 'Διαγραφή κενής σελίδας';
$string['removepagebreak'] = 'Κατάργηση αλλαγής σελίδας';
$string['removeselected'] = 'Διαγραφή επιλεγμένων';
$string['rename'] = 'Μετονομασία';
$string['renderingserverconnectfailed'] = 'Ο εξυπηρετητής {$a} απέτυχε να επεξεργαστεί το αίτημα RQP. Ελέγξτε αν η URL διεύθυνση είναι σωστή.';
$string['reorderquestions'] = 'Αναδιάταξη ερωτήσεων';
$string['reordertool'] = 'Εμφάνιση του εργαλείου αναδιάταξης';
$string['repaginate'] = 'Επανασελιδοποίηση με {$a} ερωτήσεις ανά σελίδα';
$string['repaginatecommand'] = 'Επανασελιδοποίηση';
$string['repaginatenow'] = 'Επανασελιδοποίηση τώρα';
$string['replace'] = 'Αντικατάσταση';
$string['replacementoptions'] = 'Επιλογές αντικατάστασης';
$string['report'] = 'Αναφορές';
$string['reportanalysis'] = 'Ανάλυση αντικειμένου';
$string['reportattemptsfrom'] = 'Προσπάθειες από';
$string['reportattemptsthatare'] = 'Προσπάθειες που είναι';
$string['reportdisplayoptions'] = 'Επιλογές εμφάνισης';
$string['reportfullstat'] = 'Λεπτομερή στατιστικά';
$string['reportmulti_percent'] = 'Πολλαπλά ποσοστά';
$string['reportmulti_q_x_student'] = 'Επιλογές πολλών μαθητών';
$string['reportmulti_resp'] = 'Ατομικές αποκρίσεις';
$string['reportmustselectstate'] = 'Πρέπει να επιλέξετε τουλάχιστον μία κατάσταση.';
$string['reportnotfound'] = 'Άγνωστη αναφορά ({$a})';
$string['reportoverview'] = 'Επισκόπηση';
$string['reportregrade'] = 'Επαναβαθμολόγηση προσπαθειών';
$string['reportresponses'] = 'Λεπτομερείς απαντήσεις';
$string['reports'] = 'Αναφορές';
$string['reportshowonly'] = 'Εμφάνιση μόνο προσπαθειών';
$string['reportshowonlyfinished'] = 'Εμφανίστε το πολύ μία τελική προσπάθεια ανά χρήστη ({$a})';
$string['reportsimplestat'] = 'Απλά στατιστικά';
$string['reportusersall'] = 'όλους τους χρήστες που έχουν προσπαθήσει το κουίζ';
$string['reportuserswith'] = 'εγγεγραμμένους χρήστες που έχουν προσπαθήσει το κουίζ';
$string['reportuserswithorwithout'] = 'εγγεγραμμένους χρήστες που έχουν ή δεν έχουν προσπαθήσει το κουίζ';
$string['reportuserswithout'] = 'εγγεγραμμένους χρήστες που δεν έχουν προσπαθήσει το κουίζ';
$string['reportwhattoinclude'] = 'Τι να συμπεριληφθεί στην αναφορά';
$string['requirepassword'] = 'Απαιτείται κωδικός πρόσβασης';
$string['requirepassword_help'] = 'Αν έχει οριστεί ένας κωδικός πρόσβασης, ο μαθητής θα πρέπει να τον εισάγει για να κάνει προσπάθεια στο κουίζ.';
$string['requiresubnet'] = 'Απαιτείται διεύθυνση δικτύου';
$string['requiresubnet_help'] = 'Η πρόσβαση σε κουίζ μπορεί να περιοριστεί σε συγκεκριμένα υποδίκτυα στο τοπικό δίκτυο (LAN) ή στο Διαδίκτυο, καθορίζοντας μια λίστα χωρισμένων με κόμματα μερικών ή πλήρων αριθμών διεύθυνσης IP. Αυτό μπορεί να είναι χρήσιμο για ένα επιτηρούμενο (εποπτευόμενο) κουίζ, για να διασφαλιστεί ότι μόνο τα άτομα σε μια συγκεκριμένη τοποθεσία μπορούν να έχουν πρόσβαση στο κουίζ.';
$string['response'] = 'Απόκριση';
$string['responses'] = 'Απαντήσεις';
$string['results'] = 'Αποτελέσματα';
$string['returnattempt'] = 'Επιστροφή στην προσπάθεια';
$string['reuseifpossible'] = 'επαναχρησιμοποίηση αφαιρούμενων';
$string['reverttodefaults'] = 'Επαναφορά στις προεπιλογές κουίζ';
$string['review'] = 'Ανασκόπηση';
$string['reviewafter'] = 'Επιτρέπεται η αναθεώρηση μετά το κλείσιμο του κουίζ';
$string['reviewalways'] = 'Επιτρέπεται η αναθεώρηση σε οποιαδήποτε χρονική στιγμή';
$string['reviewattempt'] = 'Εξέταση προσπάθειας';
$string['reviewbefore'] = 'Επιτρέπεται η αναθεώρηση ενώ το κουίζ είναι ανοιχτό';
$string['reviewclosed'] = 'Μετά το κλείσιμο του κουίζ';
$string['reviewduring'] = 'Κατά τη διάρκεια της προσπάθειας';
$string['reviewimmediately'] = 'Αμέσως μετά την προσπάθεια';
$string['reviewnever'] = 'Δεν επιτρέπεται η αναθεώρηση';
$string['reviewofquestion'] = 'Εξέταση της ερώτησης «{$a->question}» στο κουίζ «{$a->quiz}» από τον/την «{$a->user}»';
$string['reviewopen'] = 'Αργότερα, ενώ το κουίζ είναι ακόμα ανοιχτό';
$string['reviewoptions'] = 'Οι μαθητές μπορούν να αναθεωρούν';
$string['reviewoptionsheading'] = 'Επιλογές αναθεώρησης';
$string['reviewoptionsheading_help'] = 'Αυτές οι επιλογές ελέγχουν ποιες πληροφορίες μπορούν να δουν οι μαθητές όταν εξετάζουν μια προσπάθεια κουίζ ή βλέπουν τις αναφορές κουίζ.

**Κατά τη διάρκεια της προσπάθειας** οι ρυθμίσεις είναι σχετικές μόνο για ορισμένες συμπεριφορές, όπως «διαδραστικό με πολλαπλές δοκιμές», οι οποίες μπορεί να εμφανίζουν ανατροφοδότηση κατά την προσπάθεια.
**Αμέσως μετά την προσπάθεια** οι ρυθμίσεις ισχύουν για τα πρώτα δύο λεπτά μετά την επιλογή «Υποβολή όλων και τερματισμός».
**Αργότερα, ενώ το κουίζ είναι ακόμα ανοιχτό** ισχύουν οι ρυθμίσεις μετά από αυτό και πριν από την ημερομηνία λήξης του κουίζ.
**Μετά την ολοκλήρωση του κουίζ** ισχύουν οι ρυθμίσεις αφού περάσει η ημερομηνία λήξης του κουίζ. Αν το κουίζ δεν έχει ημερομηνία λήξης, αυτή η κατάσταση δεν φτάνει ποτέ.';
$string['reviewoverallfeedback'] = 'Συνολική ανατροφοδότηση';
$string['reviewoverallfeedback_help'] = 'Η ανατροφοδότηση που δίνεται στο τέλος της προσπάθειας, ανάλογα με το συνολικό βαθμό του μαθητή.';
$string['reviewresponse'] = 'Αναθεώρηση απάντησης';
$string['reviewresponsetoq'] = 'Εξέταση απόκρισης (ερώτηση {$a})';
$string['reviewthisattempt'] = 'Αναθεώρηση των απαντήσεών σας σε αυτήν την προσπάθεια';
$string['rqp'] = 'Απομακρυσμένη ερώτηση';
$string['rqps'] = 'Απομακρυσμένες ερωτήσεις';
$string['sameasoverall'] = 'Το ίδιο με τους συνολικούς βαθμούς';
$string['save'] = 'Αποθήκευση';
$string['saveandedit'] = 'Αποθήκευση αλλαγών και επεξεργασία ερωτήσεων';
$string['saveattemptfailed'] = 'Αποτυχία αποθήκευσης της τρέχουσας προσπάθειας κουίζ.';
$string['savedfromdeletedcourse'] = 'Αποθηκευμένο από το διαγραμμένο μάθημα «{$a}»';
$string['savegrades'] = 'Αποθήκευση βαθμών';
$string['savemyanswers'] = 'Αποθήκευση των απαντήσεων μου';
$string['savenosubmit'] = 'Αποθήκευση χωρίς υποβολή';
$string['saveoverrideandstay'] = 'Αποθήκευση και εισαγωγή κι άλλης παράκαμψης';
$string['savequiz'] = 'Αποθήκευση όλου του κουίζ';
$string['saving'] = 'Αποθήκευση';
$string['savingnewgradeforquestion'] = 'Αποθήκευση νέου βαθμού για την ερώτηση με αναγνωριστικό {$a}.';
$string['savingnewmaximumgrade'] = 'Αποθήκευση νέου μέγιστου βαθμού.';
$string['score'] = 'Ανεπεξέργαστο σκορ';
$string['scores'] = 'Τα σκορ';
$string['search:activity'] = 'Κουίζ - πληροφορίες δραστηριότητας';
$string['sectionheadingedit'] = 'Επεξεργασία τίτλου «{$a}»';
$string['sectionheadingremove'] = 'Κατάργηση της επικεφαλίδας «{$a}»';
$string['seequestions'] = '(Δείτε ερωτήσεις)';
$string['select'] = 'Επιλογή';
$string['selectall'] = 'Επιλογή όλων';
$string['selectattempt'] = 'Επιλογή προσπάθειας';
$string['selectcategory'] = 'Επιλογή κατηγορίας';
$string['selectedattempts'] = 'Επιλεγμένες προσπάθειες...';
$string['selectmultipleitems'] = 'Επιλέξτε πολλά στοιχεία';
$string['selectmultipletoolbar'] = 'Επιλέξτε πολλές γραμμές εργαλείων';
$string['selectnone'] = 'Αποεπιλογή όλων';
$string['selectquestiontype'] = '-- Επιλογή τύπου ερώτησης --';
$string['serveradded'] = 'Προστέθηκε εξυπηρετητής';
$string['serveridentifier'] = 'Αναγνωριστικό';
$string['serverinfo'] = 'Πληροφορίες εξυπηρετητή';
$string['servers'] = 'Εξυπηρετητές';
$string['serverurl'] = 'Διεύθυνση URL εξυπηρετητή';
$string['shortanswer'] = 'Σύντομη απάντηση';
$string['show'] = 'Δείξε';
$string['showall'] = 'Εμφάνιση όλων των ερωτήσεων σε μία σελίδα';
$string['showblocks'] = 'Εμφάνιση μπλοκ κατά τη διάρκεια των προσπαθειών';
$string['showblocks_help'] = 'Αν ορισθεί σε «ναι», τότε τα κανονικά μπλοκ θα εμφανίζονται κατά τη διάρκεια προσπαθειών του κουίζ';
$string['showbreaks'] = 'Εμφάνιση αλλαγών σελίδας';
$string['showcategorycontents'] = 'Εμφάνιση περιεχομένων κατηγορίας {$a->arrow}';
$string['showcorrectanswer'] = 'Στην ανατροφοδότηση, προβολή σωστών απαντήσεων;';
$string['showdetailedmarks'] = 'Εμφάνιση λεπτομερειών βαθμών';
$string['showeachpage'] = 'Εμφάνιση μία σελίδα την φορά';
$string['showfeedback'] = 'Μετά την απάντηση, προβολή ανατροφοδότησης;';
$string['showinsecurepopup'] = 'Χρήση «ασφαλούς» αναδυόμενου παραθύρου για τις προσπάθειες';
$string['showlargeimage'] = 'Μεγάλη εικόνα';
$string['shownoattempts'] = 'Εμφάνιση μαθητών χωρίς προσπάθειες';
$string['shownoattemptsonly'] = 'Εμφάνιση μόνο των μαθητών χωρίς προσπάθειες';
$string['shownoimage'] = 'Καμία εικόνα';
$string['showreport'] = 'Εμφάνιση αναφοράς';
$string['showsmallimage'] = 'Μικρή εικόνα';
$string['showteacherattempts'] = 'Εμφάνιση προσπαθειών καθηγητών';
$string['showuserpicture'] = 'Εμφάνιση εικόνας χρήστη';
$string['showuserpicture_help'] = 'Εάν ενεργοποιηθεί, το όνομα και η εικόνα του μαθητή θα εμφανίζονται στην οθόνη κατά τη διάρκεια της προσπάθειας και στην οθόνη της εξέτασης, κάνοντας ευκολότερο τον έλεγχο αν ο μαθητής έχει συνδεθεί ο ίδιος σε μια επιτηρούμενη (εποπτευόμενη) εξέταση.';
$string['shuffle'] = 'Ανακάτεμα';
$string['shuffleanswers'] = 'Ανακάτεμα απαντήσεων';
$string['shuffledrandomly'] = 'Τυχαίο ανακάτεμα';
$string['shufflequestions'] = 'Ανακάτεμα';
$string['shufflequestions_help'] = 'Εάν ενεργοποιηθεί, τότε κάθε φορά που επιχειρείται το κουίζ, η σειρά των ερωτήσεων σε αυτήν την ενότητα θα ανακατευτεί σε μια διαφορετική τυχαία σειρά.

Αυτό μπορεί να δυσκολέψει τους μαθητές να μοιραστούν απαντήσεις, αλλά δυσκολεύει επίσης τους μαθητές να συζητήσουν για μια συγκεκριμένη ερώτηση με τον διδάσκοντα.';
$string['shufflewithin'] = 'Ανακάτεμα εντός των ερωτήσεων';
$string['shufflewithin_help'] = 'Εάν ενεργοποιηθεί, τα μέρη που αποτελούν κάθε ερώτηση θα ανακατευθούν τυχαία κάθε φορά που ένας μαθητής προσπαθεί το κουίζ, υπό τον όρο ότι η (αντίστοιχη) επιλογή είναι επίσης ενεργοποιημένη στις ρυθμίσεις ερωτήσεων. Αυτή η ρύθμιση ισχύει μόνο για ερωτήσεις που έχουν πολλά μέρη, όπως ερωτήσεις πολλαπλών επιλογών ή ερωτήσεις αντιστοίχισης.

<p>Αν ενεργοποιήσετε αυτή την επιλογή, τότε οι τυχόν υποερωτήσεις σε κάθε ερώτηση θα εμφανίζονται με τυχαία σειρά σε κάθε απόπειρα του κουίζ (θα πρέπει επίσης να έχετε ενεργοποιήσει την ίδια επιλογή σε κάθε ερώτηση ξεχωριστά).</p>

<p>Ο στόχος είναι απλά να γίνει κάπως πιο δύσκολο για τους μαθητές να αντιγράψουν μεταξύ τους.</p>

<p>Φυσικά αυτό ισχύει μόνο για τις ερωτήσεις που έχουν υποερωτήματα, όπως των πολλαπλών επιλογών και της αντιστοίχισης. Για τις ερωτήσεις πολλαπλής επιλογής η σειρά των απαντήσεων είναι τυχαία μόνο όταν αυτή επιλογή είναι ενεργοποιημένη. Για ερωτήσεις αντιστοίχισης οι απαντήσεις είναι πάντα με τυχαία σειρά, και η επιλογή αυτή ελέγχει εάν επιπρόσθετα εμφανίζονται με τυχαία σειρά και οι ερωτήσεις.</p>

<p>Αυτή η επιλογή δε σχετίζεται με τη χρήση των τυχαίων ερωτήσεων.</p>';
$string['singleanswer'] = 'Επιλογή μίας απάντησης.';
$string['sortage'] = 'Ταξινόμηση κατά ηλικία';
$string['sortalpha'] = 'Ταξινόμηση κατά όνομα';
$string['sortquestionsbyx'] = 'Ταξινόμηση ερωτήσεων κατά: {$a}';
$string['sortsubmit'] = 'Ταξινόμηση ερωτήσεων';
$string['sorttypealpha'] = 'Ταξινόμηση κατά τύπο, όνομα';
$string['specificapathnotonquestion'] = 'Το συγκεκριμένο μονοπάτι αρχείου δε βρίσκεται στη συγκεκριμένη ερώτηση';
$string['specificquestionnotonquiz'] = 'Η συγκεκριμένη ερώτηση δε βρίσκεται στο συγκεκριμένο κουίζ';
$string['startagain'] = 'Επανέναρξη';
$string['startattempt'] = 'Έναρξη προσπάθειας';
$string['startedon'] = 'Ξεκίνησε στις';
$string['startnewpreview'] = 'Ξεκινήστε μια νέα προεπισκόπηση';
$string['stateabandoned'] = 'Δεν έχει υποβληθεί';
$string['statefinished'] = 'Ολοκληρωμένο';
$string['statefinisheddetails'] = 'Υποβλήθηκε {$a}';
$string['stateinprogress'] = 'Σε εξέλιξη';
$string['statenotloaded'] = 'Η κατάσταση για την ερώτηση {$a} δεν έχει φορτωθεί από τη βάση δεδομένων';
$string['stateoverdue'] = 'Εκπρόθεσμο';
$string['stateoverduedetails'] = 'Πρέπει να υποβληθεί μέχρι {$a}';
$string['status'] = 'Κατάσταση';
$string['stoponerror'] = 'Διακοπή σε περίπτωση σφάλματος';
$string['submitallandfinish'] = 'Υποβολή όλων και τέλος';
$string['subneterror'] = 'Συγγνώμη, αυτό το κουίζ είναι κλειδωμένο έτσι ώστε να είναι προσπελάσιμο μόνο από ορισμένες διευθύνσεις. Αυτή τη στιγμή ο υπολογιστής σας δεν είναι από αυτούς στους οποίους επιτρέπεται η πρόσβαση στο κουίζ.';
$string['subnetnotice'] = 'Αυτό το κουίζ είναι κλειδωμένο έτσι ώστε να είναι προσπελάσιμο μόνο από ορισμένες διευθύνσεις. Αυτή τη στιγμή ο υπολογιστής σας δεν είναι σε ένα από τα επιτρεπόμενα δίκτυα. Ως διδάσκων έχετε το δικαίωμα προεπισκόπησης, ούτως ή άλλως.';
$string['subplugintype_quiz'] = 'Αναφορά';
$string['subplugintype_quiz_plural'] = 'Αναφορές';
$string['subplugintype_quizaccess'] = 'Κανόνας πρόσβασης';
$string['subplugintype_quizaccess_plural'] = 'Κανόνες πρόσβασης';
$string['substitutedby'] = 'θα αντικατασταθεί από';
$string['summaryofattempt'] = 'Περίληψη προσπάθειας';
$string['summaryofattempts'] = 'Σύνοψη προηγούμενων προσπαθειών σας';
$string['temporaryblocked'] = 'Προς το παρόν δεν έχετε το δικαίωμα να ξανα-προσπαθήσετε το κουίζ.<br />
Θα έχετε το δικαίωμα για νέα προσπάθεια:';
$string['theattempt'] = 'Η προσπάθεια';
$string['theattempt_help'] = 'Εάν ο μαθητής μπορεί γενικά να εξετάσει την προσπάθεια.';
$string['time'] = 'Ώρα';
$string['timecompleted'] = 'Συμπληρωμένο';
$string['timedelay'] = 'Δεν έχετε το δικαίωμα να ξανακάνετε το κουίζ, εφόσον δεν έχει περάσει η απαιτούμενη χρονική καθυστέρηση πριν προσπαθήσετε άλλο κουίζ.';
$string['timeleft'] = 'Υπολειπόμενος χρόνος';
$string['timelimit'] = 'Χρονικό όριο';
$string['timelimit_help'] = 'Εάν ενεργοποιηθεί, το χρονικό όριο δηλώνεται στην αρχική σελίδα κουίζ και εμφανίζεται ένα χρονόμετρο αντίστροφης μέτρησης στο μπλοκ πλοήγησης κουίζ.';
$string['timelimit_link'] = '';
$string['timelimitexeeded'] = 'Συγγνώμη! Ο χρόνος για το κουίζ έχει λήξει!';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Έληξε ο χρόνος!';
$string['timetaken'] = 'Χρόνος που χρειάστηκε';
$string['timing'] = 'Χρονομέτρηση';
$string['tofile'] = 'στο αρχείο';
$string['tolerance'] = 'Ανοχή';
$string['toomanyrandom'] = 'Ο αριθμός των τυχαίων ερωτημάτων που απαιτήθηκε είναι μεγαλύτερος από των αριθμό ερωτημάτων που έχει αυτή η κατηγορία! ({$a})';
$string['top'] = 'Πάνω';
$string['totalmarksx'] = 'Σύνολο βαθμών: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Σύνολο {$a} ερωτήσεων στην κατηγορία.';
$string['true'] = 'Σωστό';
$string['truefalse'] = 'Σωστό/λάθος';
$string['type'] = 'Τύπος';
$string['unfinished'] = 'ανοιχτό';
$string['ungraded'] = 'μη-βαθμολογημένο';
$string['unit'] = 'Μονάδα';
$string['unknowntype'] = 'Μη υποστηριζόμενος τύπος ερώτησης στη γραμμή {$a}. Η ερώτηση παραλείπεται';
$string['updateoverdueattemptstask'] = 'Ενημέρωση εκπρόθεσμων προσπαθειών κουίζ';
$string['updatequizslotswithrandomxofy'] = 'Ενημέρωση υποδοχών κουίζ με «τυχαία» δεδομένα ερώτησης ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Ανανέωση ρυθμίσεων κουίζ';
$string['updatingatttemptgrades'] = 'Ενημέρωση βαθμών προσπάθειας.';
$string['updatingfinalgrades'] = 'Ενημέρωση τελικών βαθμών.';
$string['updatingthegradebook'] = 'Ενημέρωση του βαθμολογίου.';
$string['upgradesure'] = '<div style="color: red;"> συγκεκριμένα το άρθρωμα του κουίζ θα εκτελέσει εκτενή αλλαγή των πινάκων κουίζ και αυτή η ανανέωση δεν έχει ελεγχθεί ακόμα. Καλό θα ήταν να πάρετε ένα αντίγραφο ασφαλείας των πινάκων της βάσης δεδομένων πριν προχωρήσετε.</div>';
$string['upgradingquizattempts'] = 'Αναβάθμιση προσπαθειών κουίζ: κουίζ {$a->done}/{$a->outof} (Αναγνωριστικό κουίζ {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Αναβάθμιση πολύ παλιών προσπαθειών κουίζ: {$a->done}/{$a->outof}';
$string['url'] = 'Τοποθεσία URL';
$string['usedcategorymoved'] = 'Αυτή η κατηγορία έχει διατηρηθεί και έχει μετακινηθεί στο επίπεδο δικτυακού τόπου γιατί είναι δημοσιευμένη κατηγορία που χρησιμοποιείται από άλλα μαθήματα.';
$string['useroverrides'] = 'Παρακάμψεις χρηστών';
$string['useroverridesdeleted'] = 'Οι παρακάμψεις χρηστών διαγράφηκαν';
$string['usersnone'] = 'Κανένας μαθητής δεν έχει πρόσβαση σε αυτό το κουίζ';
$string['validate'] = 'Επικυρώστε';
$string['viewallanswers'] = 'Δείτε {$a} τα ολοκληρωμένα κουίζ';
$string['viewallreports'] = 'Εμφάνιση αναφορών για {$a} προσπάθειες';
$string['viewed'] = 'Προβλήθηκαν';
$string['warningmissingtype'] = '<b>Ο τύπος αυτής της ερώτησης δεν έχει εγκατασταθεί στο Moodle προς το παρόν. <br>Παρακαλούμε ειδοποιήστε το διαχειριστή του Moodle. </b>';
$string['wheregrade'] = 'Πού είναι ο βαθμός μου;';
$string['wildcard'] = 'Μπαλαντέρ';
$string['windowclosing'] = 'Αυτό το παράθυρο θα κλείσει σύντομα.';
$string['withsummary'] = 'με συνοπτικά στατιστικά';
$string['wronguse'] = 'Δεν μπορείτε να χρησιμοποιήσετε αυτή την σελίδα έτσι';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Πρέπει να εγγραφείτε σε αυτό το μάθημα πριν εκκινήσετε προσπάθεια για αυτό το κουίζ';
$string['yourfinalgradeis'] = 'Ο τελικός σας βαθμός για αυτό το κουίζ είναι {$a}';
