<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'da', version '4.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'lige ved at blive installeret';
$string['accept'] = 'Accepter';
$string['action'] = 'Handling';
$string['actionchoice'] = 'Hvad vil du gøre med filen "{$a}"?';
$string['actions'] = 'Handlinger';
$string['actionsfor'] = 'Handlinger for {$a}';
$string['actionsmenu'] = 'Handlingsmenu';
$string['active'] = 'Aktiv';
$string['activeusers'] = 'Aktive brugere';
$string['activities'] = ' Aktiviteter';
$string['activities_help'] = 'Aktiviteter er interaktivt indhold på kurset såsom f.eks. et forum, en quiz eller en wiki.';
$string['activity'] = 'Aktivitet';
$string['activityclipboard'] = 'Flytter aktiviteten {$a}';
$string['activityheader'] = 'Aktivitetsmenu';
$string['activityiscurrentlyhidden'] = 'Desværre, denne aktivitet er skjult';
$string['activitymodule'] = 'Aktivitetsmodul';
$string['activitymodules'] = 'Aktivitetsmoduler';
$string['activityreport'] = 'Aktivitetsrapport';
$string['activityreports'] = 'Aktivitetsrapporter';
$string['activityselect'] = 'Vælg den aktivitet, der skal flyttes';
$string['activitysince'] = 'Aktivitet siden {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Aktivitet pr. bruger';
$string['add'] = 'Tilføj';
$string['addactivity'] = 'Tilføj en  aktivitet ...';
$string['addactivitytosection'] = 'Føj en aktivitet til sektionen "{$a}"';
$string['addadmin'] = 'Tilføj admin';
$string['addblock'] = 'Tilføj blok';
$string['addcomment'] = 'Tilføj kommentar...';
$string['addcountertousername'] = 'Opret en bruger ved at føje et tal til brugernavnet';
$string['addcreator'] = 'Tilføj kursusadministrator';
$string['adddots'] = 'Tilføj...';
$string['added'] = 'Tilføjet {$a}';
$string['addedtogroup'] = 'Tilføjet gruppen "{$a}"';
$string['addedtogroupnot'] = 'Ikke tilføjet gruppen "{$a}"';
$string['addedtogroupnotenrolled'] = 'Ikke tilføjet gruppen "{$a}", da personen ikke deltager på kurset.';
$string['addfilehere'] = 'Indsæt filer her for at tilføje dem nederst i dette afsnit';
$string['addinganew'] = 'Oprettelse af {$a}';
$string['addinganewto'] = 'Tilføjer {$a->what} til {$a->to}';
$string['addingdatatoexisting'] = 'Føj data til eksisterende';
$string['additionalcustomnav'] = 'Ekstra brugerdefineret navigation';
$string['additionalnames'] = 'Andre navne';
$string['addlinkhere'] = 'Tilføj link her';
$string['addnew'] = 'Tilføj en ny {$a}';
$string['addnewcategory'] = 'Ny kategori';
$string['addnewcourse'] = 'Tilføj kursus';
$string['addnewuser'] = 'Ny bruger';
$string['addnousersrecip'] = 'Tilføj brugere der ikke har tilgået denne {$a} til modtagerlisten.';
$string['addpagehere'] = 'Tilføj tekst her';
$string['addresource'] = 'Tilføj materiale...';
$string['addresourceoractivity'] = 'Tilføj aktivitet eller materiale';
$string['addresourcetosection'] = 'Tilføj materiale til sektionen "{$a}"';
$string['address'] = 'Adresse';
$string['addsections'] = 'Tilføj sektioner';
$string['addstudent'] = 'Tilføj studerende';
$string['addsubcategory'] = 'Tilføj en underkategori';
$string['addteacher'] = 'Tilføj lærer';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Opret en ny bruger manuelt';
$string['adminhelpassignadmins'] = 'Admins kan gøre alting og tilgå alle sider på sitet';
$string['adminhelpassigncreators'] = 'Kursusadministratorer kan oprette nye kurser';
$string['adminhelpassignsiteroles'] = 'Tilføj siteroller til bestemte brugere';
$string['adminhelpassignstudents'] = 'Gå ind på kurset og tilføj studerende fra admin-menuen';
$string['adminhelpauthentication'] = 'Du kan bruge interne brugerkonti eller brugere fra en ekstern database';
$string['adminhelpbackup'] = 'Konfigurer automatisk backup';
$string['adminhelpconfiguration'] = 'Konfigurer hvordan sitet skal se ud og fungere';
$string['adminhelpconfigvariables'] = 'Konfigurer variable der påvirker sitets generelle funktion';
$string['adminhelpcourses'] = 'Definer kurser og kategorier og tilføj personer til dem, rediger afventende kurser';
$string['adminhelpeditorsettings'] = 'Definer grundindstillinger for HTML-editoren';
$string['adminhelpedituser'] = 'Vis brugerlisten og rediger en vilkårlig brugerprofil';
$string['adminhelpenvironment'] = 'Kontroller om serveren opfylder nuværende og fremtidige krav';
$string['adminhelpfailurelogs'] = 'Skim logs for mislykkede login';
$string['adminhelplanguage'] = 'Tjek og rediger den nuværende sprogpakke';
$string['adminhelplogs'] = 'Vis loggen over alle aktiviteter på dette site';
$string['adminhelpmanageblocks'] = 'Administrer installerede blokke og deres indstillinger';
$string['adminhelpmanagedatabase'] = 'Tilgå databasen direkte (vær påpasselig!)';
$string['adminhelpmanagefilters'] = 'Vælg tekstfiltre og relaterede indstillinger';
$string['adminhelpmanagemodules'] = 'Administrer installerede moduler og deres indstillinger';
$string['adminhelpmanageroles'] = 'Opret og definer roller der kan tilknyttes brugere';
$string['adminhelpmymoodle'] = 'Konfigurer blokke til brugernes "Min Moodle"';
$string['adminhelpreports'] = 'Rapporter på siteniveau';
$string['adminhelpsitefiles'] = 'Publicering af filer generelt eller uploadning af eksterne backups';
$string['adminhelpsitesettings'] = 'Definer hvordan forsiden på sitet skal se ud';
$string['adminhelpstickyblocks'] = 'Konfigurer faste blokke for hele sitet';
$string['adminhelpthemes'] = 'Vælg hvordan sitet skal se ud (farver, fonte mm)';
$string['adminhelpuploadusers'] = 'Importer nye brugere fra en tekstfil';
$string['adminhelpusers'] = 'Definer dine brugere og sæt autorisationssystemet op';
$string['adminhelpxmldbeditor'] = 'Mulighed for at redigere XMLDB-filer. Kun for udviklere.';
$string['administration'] = 'Administration';
$string['administrationsite'] = 'Siteadministration';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratorer kan ændre alt på siden i alle kurser.';
$string['administrators'] = 'Administratorer';
$string['administratorsall'] = 'Alle administratorer';
$string['administratorsandteachers'] = 'Administratorer og lærere';
$string['advanced'] = 'Avanceret';
$string['advancedfilter'] = 'Avanceret søgning';
$string['advancedsettings'] = 'Avancerede indstillinger';
$string['afterresource'] = 'Efter materialet "{$a}"';
$string['aftersection'] = 'Efter sektion "{$a}"';
$string['again'] = 'igen';
$string['agelocationverification'] = 'Alders- og lokaliseringskontrol';
$string['aimid'] = 'AIM-id';
$string['ajaxuse'] = 'AJAX og Javascript';
$string['all'] = 'Alle';
$string['allactions'] = 'Alle handlinger';
$string['allactivities'] = 'Alle aktiviteter';
$string['allcategories'] = 'Alle kategorier';
$string['allchanges'] = 'Alle ændringer';
$string['alldays'] = 'Alle dage';
$string['allfiles'] = 'Alle filer';
$string['allgroups'] = 'Alle grupper';
$string['alllogs'] = 'Alle logs';
$string['allmods'] = 'Alle {$a}';
$string['allow'] = 'Tillad';
$string['allowinternal'] = 'Tillad også interne metoder';
$string['allownone'] = 'Tillad intet';
$string['allownot'] = 'Tillad ikke';
$string['allowstealthmodules'] = 'Aktiver aktiviteter hvortil der ikke er links på kursusforsiden';
$string['allowstealthmodules_help'] = 'Er indstillingen aktiveret, kan aktiviteter være tilgængelige uden at der er link til dem på kursusforsiden. I stedet skal der manuelt oprettes link til dem andre steder, f.eks. fra en webside. Disse aktiviteter optræder stadig i karakterbogen og i andre rapporter.';
$string['allparticipants'] = 'Alle deltagere';
$string['allteachers'] = 'Alle lærere';
$string['alphanumerical'] = 'Kan kun indeholde bogstaver, tal, bindestreger (-) eller punktum (.)';
$string['alreadyconfirmed'] = 'Registreringen er allerede bekræftet';
$string['alternatename'] = 'Alternativt navn';
$string['always'] = 'Altid';
$string['and'] = '{$a->one} og {$a->two}';
$string['answer'] = 'Svar';
$string['any'] = 'Alle';
$string['appearance'] = 'Udseende';
$string['approve'] = 'Godkend';
$string['areyousure'] = 'Er du sikker?';
$string['areyousuretorestorethis'] = 'Ønsker du at fortsætte?';
$string['areyousuretorestorethisinfo'] = 'Senere i processen får du mulighed for at føje denne backup til et eksisterende kursus eller oprette et helt nyt kursus.';
$string['asc'] = 'Stigende';
$string['assessment'] = 'Evaluering';
$string['assignadmins'] = 'Tilføj administratorer';
$string['assigncreators'] = 'Tilføj kursusadministratorer';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Tilknyt roller for hele sitet';
$string['authenticateduser'] = 'Godkendt bruger';
$string['authenticateduserdescription'] = 'Alle, der er logget ind';
$string['authentication'] = 'Validering';
$string['authenticationplugins'] = 'Godkendelsesplugins';
$string['autosubscribe'] = 'Forum auto-abonner';
$string['autosubscribeno'] = 'Nej: Jeg ønsker ikke automatisk at abonnere på fora';
$string['autosubscribeyes'] = 'Ja: Opret automatisk abonnement på tråden når jeg skriver et forumindlæg.';
$string['availability'] = 'Åbningsperiode';
$string['availablecourses'] = 'Tilgængelige kurser';
$string['back'] = 'Tilbage';
$string['backto'] = 'Tilbage til {$a}';
$string['backtocourselisting'] = 'Tilbage til kursuslisten';
$string['backtohome'] = 'Retur til webstedets startside';
$string['backtopageyouwereon'] = 'Tilbage til den side, du kom fra';
$string['backup'] = 'Backup';
$string['backupactivehelp'] = 'Vælg om der skal foretages automatisk backup';
$string['backupadhocpending'] = 'Ad hoc-opgaven kursusbackup afventer';
$string['backupcancelled'] = 'Backup annulleret';
$string['backupcoursefileshelp'] = 'Vælg denne indstilling, hvis du ønsker at inkludere kursusfiler i backuppen';
$string['backupdate'] = 'Backupdato';
$string['backupdatenew'] = '&nbsp; {$a->TAG} er nu {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} var {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Backupoplysninger';
$string['backuperrorinvaliddestination'] = 'Backupdestinations-mappen findes ikke eller der er ikke skriveadgang til den.';
$string['backupexecuteathelp'] = 'Vælg tidspunkt for hvornår automatisk backup skal foretages';
$string['backupfailed'] = 'Nogle af dine kurser blev ikke gemt!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Backup gennemført OK';
$string['backupfromthissite'] = 'Er der taget backup af dette site?';
$string['backupgradebookhistoryhelp'] = 'Er indstillingen aktiveret, vil karakterbogens historik blive inkluderet i automatiske sikkerhedskopierer. Karakterhistorik må ikke være deaktiveret i serverindstillinger (disablegradehistory) for at dette skal fungere';
$string['backupincludemoduleshelp'] = 'Vælg om du ønsker at inkludere kursusmoduler med eller uden brugerdata i backuppen.';
$string['backupincludemoduleuserdatahelp'] = 'Vælg om der skal inkluderes brugerdata fra modulerne i den automatiske backup';
$string['backuplogdetailed'] = 'Detaljeret eksekveringslog';
$string['backuploglaststatus'] = 'Sidste eksekveringslog';
$string['backupmissinguserinfoperms'] = 'Bemærk: Denne backup indeholder ingen brugerdata. Aktiviteterne "øvelse" og "workshop" vil ikke komme med i backup\'en da disse moduler ikke er kompatible med denne form for backup.';
$string['backupnext'] = 'Næste backup';
$string['backupnonisowarning'] = 'Advarsel: Denne backup er fra en non-unicode version af Moodle (før version 1.6). Hvis backuppen indeholder tegn udenfor ISO-8859-1 tegnsættet, kan de risikere at blive ØDELAGTE hvis du prøver at genskabe dem i denne unicode version af Moodle. Se <a href="https://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> for mere information om hvordan man genskaber og konverterer denne backup korrekt.';
$string['backupnotyetrun'] = 'Automatisk sikkerhedskopiering venter';
$string['backuporiginalname'] = 'Backupnavn';
$string['backuproleassignments'] = 'Tag backup af disse tildelte roller';
$string['backupsavetohelp'] = 'Angiv den fulde sti til den mappe backupfilerne skal gemmes i.';
$string['backupsitefileshelp'] = 'Er indstillingen aktiveret, vil site-filer der bruges på kurser, blive inkluderet i den automatiske backup';
$string['backuptakealook'] = 'Kontroller din backuplog i:
{$a}';
$string['backupuserfileshelp'] = 'Vælg om brugerfiler (f.eks. avatars) skal med i den automatiske backup';
$string['backupversion'] = 'Backupversion';
$string['badges'] = 'Badges';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurerer en {$a}-blok';
$string['blockconfigbad'] = 'Denne blok er ikke blevet implementeret korrekt og kan derfor ikke vise en konfigurationsside.';
$string['blocks'] = 'Blokke';
$string['blocksaddedit'] = 'Tilføj/Rediger blokke';
$string['blockseditoff'] = 'Blokredigering fra';
$string['blocksediton'] = 'Blokredigering til';
$string['blocksetup'] = 'Opsætning af blokke';
$string['blocksuccess'] = '{$a} blokke er sat korrekt op';
$string['brief'] = 'Kort';
$string['bulkactions'] = 'Masseredigering';
$string['bulkactionselect'] = '{$a} masseredigering valgt';
$string['bulkmovecoursessuccess'] = 'Flyttede {$a->courses} kurser til {$a->category}';
$string['bycourseorder'] = 'Efter kursusorden';
$string['byname'] = 'af {$a}';
$string['bypassed'] = 'Forbigået';
$string['cachecontrols'] = 'Cache-kontroller';
$string['calltofeedback'] = 'Udviklerne af denne software vil gerne have din feedback.';
$string['calltofeedback_give'] = 'Giv feedback på denne software';
$string['calltofeedback_remind'] = 'Påmind mig senere';
$string['cancel'] = 'Annuller';
$string['cancelled'] = 'Annulleret';
$string['categories'] = 'Kursuskategorier';
$string['categoriesandcourses'] = 'Vælg kategori og kurser';
$string['category'] = 'Kategori';
$string['categoryadded'] = 'Kategorien "{$a}" blev tilføjet';
$string['categorybulkaction'] = 'Masseredigering for valgte kategorier';
$string['categorycontents'] = 'Underkategorier og kurser';
$string['categorycurrentcontents'] = 'Indhold i {$a}';
$string['categorydeleted'] = 'Kategorien "{$a}" blev slettet';
$string['categoryduplicate'] = 'Kategorien "{$a}" eksisterer allerede';
$string['categoryheader'] = 'Kategorimenu';
$string['categoryhidden'] = '(skjult)';
$string['categorymodifiedcancel'] = 'Kategorien var ændret! Annuller og prøv igen.';
$string['categoryname'] = 'Kategorinavn';
$string['categorypath'] = 'Kategoristi';
$string['categorysubcategoryof'] = '{$a->category} underkategori af  {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorien "{$a}" blev opdateret';
$string['changedpassword'] = 'Koden er ændret';
$string['changepassword'] = 'Skift adgangskode';
$string['changesmade'] = 'Ændringer';
$string['changesmadereallygoaway'] = 'Du har foretaget ændringer. Er du sikker på du vil forlade siden og miste dine ændringer?';
$string['changessaved'] = 'Ændringerne er gemt';
$string['check'] = 'Kontroller';
$string['checkactual'] = 'Aktuel';
$string['checkall'] = 'Kontroller alt';
$string['checkexpected'] = 'Forventet';
$string['checkingbackup'] = 'Kontrollerer backup';
$string['checkingcourse'] = 'Kontrollerer kursus';
$string['checkingforbbexport'] = 'Kontrollerer Blackboardeksport';
$string['checkinginstances'] = 'Kontrollerer forekomster';
$string['checkingsections'] = 'Kontrollerer sektioner';
$string['checklanguage'] = 'Sprogindstillinger';
$string['checknone'] = 'Kontroller intet';
$string['checks'] = 'Kontroller';
$string['checksok'] = 'Alle "{$a}" tjek OK';
$string['childcoursenotfound'] = 'Underliggende kursus ikke fundet';
$string['childcourses'] = 'Underliggende kurser';
$string['choose'] = 'Vælg';
$string['choosecourse'] = 'Vælg et kursus';
$string['choosedots'] = 'Vælg...';
$string['chooselivelogs'] = 'Eller se igangværende aktivitet';
$string['chooselogs'] = 'Vælg hvilke logs du vil se';
$string['choosereportfilter'] = 'Vælg et filter til rapporten';
$string['choosetheme'] = 'Vælg layout';
$string['chooseuser'] = 'Vælg en bruger';
$string['city'] = 'By';
$string['cleaningtempdata'] = 'Fjerner midlertidige data';
$string['clear'] = 'Ryd';
$string['clearsearch'] = 'Ryd søgeindput';
$string['clickhelpiconformoreinfo'] = '...fortsætter... Klik på hjælpeikonet hvis du vil se hele artiklen';
$string['clickhere'] = 'Klik her...';
$string['clicktochangeinbrackets'] = '{$a} (Klik for at ændre)';
$string['clicktohideshow'] = 'Klik for at udvide eller folde sammen';
$string['closeblockdrawer'] = 'Luk blok-skuffe';
$string['closebuttontitle'] = 'Luk';
$string['closecourseindex'] = 'Luk kursusindeks';
$string['closedrawer'] = 'Luk skuffe';
$string['closewindow'] = 'Luk dette vindue';
$string['collapse'] = 'Luk';
$string['collapseall'] = 'Sammenfold alle';
$string['collapsecategory'] = 'Luk {$a}';
$string['commentincontext'] = 'Find denne kommentar i sin rette sammenhæng';
$string['comments'] = 'Kommentarer';
$string['commentscount'] = 'Kommentarer ({$a})';
$string['commentsnotenabled'] = 'Kommentarfunktionen er ikke aktiveret';
$string['commentsrequirelogin'] = 'Du skal logge ind, hvis du skal kunne se kommentarer.';
$string['comparelanguage'] = 'Sammenlign og rediger aktuelle sprog';
$string['complete'] = 'Færdiggør';
$string['completed'] = 'Færdiggjort';
$string['completereport'] = 'Komplet rapport';
$string['configuration'] = 'Konfiguration';
$string['confirm'] = 'Bekræft';
$string['confirmcheckfull'] = 'Er du fuldstændig sikker på at du vil bekræfte {$a}?';
$string['confirmcoursemove'] = 'Er du sikker på at du vil flytte dette kursus ({$a->course} til kategorien ({$a->category})?';
$string['confirmdeletesection'] = 'Er du sikker på, at du vil slette "{$a}" og alle de aktiviteter den indeholder?';
$string['confirmed'] = 'Registreringen er bekræftet';
$string['confirmednot'] = 'Din registrering er endnu ikke bekræftet! Tjek din mailboks om du har fået en bekræftelsesmail.';
$string['considereddigitalminor'] = 'Du er ikke gammel nok til selv at oprette en konto her.';
$string['content'] = 'Indhold';
$string['contentbank'] = 'Indholdsbank';
$string['contentexport_aboutthiscourse'] = 'Kursusbeskrivelse';
$string['contentexport_coursesummary'] = 'Denne fil er en del af indholdet downloadet fra <a href="{$a->courselink}">{$a->coursename}</a>';
$string['contentexport_footersummary'] = 'Denne fil er en del af indholdet downloadet fra <a href="{$a->courselink}">{$a->coursename}</a> af {$a->userfullname} den {$a->date}.';
$string['contentexport_modulesummary'] = 'Denne fil er en del af indholdet downloadet fra <a href="{$a->modulelink}">{$a->modulename}</a> den {$a->date}. Bemærk at noget af indholdet og filer større end {$a->maxfilesize} ikke er downloadet.';
$string['contentexport_viewfilename'] = 'Vis filen  {$a}';
$string['continue'] = 'Fortsæt';
$string['continuetocourse'] = 'Tryk her for at komme til dit kursus';
$string['convertingwikitomarkdown'] = 'Konverterer Wiki til Markdown-format';
$string['cookiesenabled'] = 'Cookies skal være aktiveret i din browser';
$string['cookiesenabled_help'] = 'Dette websted bruger 2 cookies:

Den vigtige er en "sessions-cookie", normalt kaldet MoodleSession. Den holder styr på om du er logget ind og sikrer kontinuitet under brug af siden, så den skal du tillade. Når du logger af eller lukker browseren, bliver cookien slettet (både i din browser og på serveren).

Den anden cookie er udelukkende for nemheds skyld, den kaldes som regel noget i retning af MOODLEID. Den husker dit brugernavn i browseren. Det betyder at feltet med brugernavn allerede vil være udfyldt for dig når du vender tilbage til siden næste gang. Du kan roligt afvise denne cookie, men så må du selv udfylde feltet hver gang du skal logge ind.';
$string['cookiesenabled_help_html'] = 'Der anvendes to cookies på dette websted:<br/><br/>

Den vigtigste er sessionscookien, som normalt kaldes MoodleSession. Du skal tillade denne cookie i din browser for at sikre kontinuitet og for at forblive logget ind, når du surfer på webstedet. Når du logger ud eller lukker browseren, destrueres denne cookie (i din browser og på serveren).<br/><br/>

Den anden cookie er en ren bekvemmelighedscookie, som normalt hedder MOODLEID eller lignende. Den husker blot dit brugernavn i browseren. Det betyder, at når du vender tilbage til dette websted, er feltet med brugernavn på loginsiden allerede udfyldt for dig. Det er sikkert at afvise denne cookie - du skal blot indtaste dit brugernavn igen, hver gang du logger ind.';
$string['cookiesenabledonlysession'] = 'Cookies skal være aktiveret i din browser';
$string['cookiesenabledonlysession_help'] = 'Dette websted bruger en "sessions-cookie", normalt kaldet MoodleSession. Den holder styr på om du er logget ind og sikrer kontinuitet når du bevæger dig rundt på sitet, så den skal du tillade. Når du logger af eller lukker browseren, bliver cookien slettet (både i din browser og på serveren).';
$string['cookiesnotenabled'] = 'Desværre er er din browser sat til ikke at modtage cookies.';
$string['cookiesnotice'] = 'Bemærkning om cookies';
$string['copy'] = 'Kopier';
$string['copyasnoun'] = 'kopi';
$string['copycourse'] = 'Kopier kurset';
$string['copyingcoursefiles'] = 'Kopierer kursusfiler';
$string['copyingsitefiles'] = 'Kopierer site-filer der bruges på kurset';
$string['copyinguserfiles'] = 'Kopierer brugerfiler';
$string['copyingzipfile'] = 'Kopierer zip-fil';
$string['copyrightnotice'] = 'Copyrightbesked';
$string['coresystem'] = 'System';
$string['cost'] = 'Pris';
$string['costdefault'] = 'Standardpris';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Land';
$string['course'] = 'Kursus';
$string['courseadministration'] = 'Kursusadministration';
$string['courseapprovedemail'] = 'Din forespørgsel på {$a->name} er godkendt og du er blevet {$a->teacher} på kurset. Gå til {$a->url} for at komme ind på kurset';
$string['courseapprovedemail2'] = 'Dit ønskede kursus, {$a->name}, er blevet oprettet. Få adgang her: {$a->url}';
$string['courseapprovedfailed'] = 'Kunne desværre ikke gemme kurset som godkendt!';
$string['courseapprovedsubject'] = 'Dit kursus er godkendt!';
$string['courseavailable'] = 'Dette kursus er tilgængeligt for studerende';
$string['courseavailablenot'] = 'Dette kursus er ikke tilgængeligt for studerende';
$string['coursebackup'] = 'Kursusbackup';
$string['coursebulkaction'] = 'Masseredigering for valgte kurser';
$string['coursecategories'] = 'Kursuskategorier';
$string['coursecategory'] = 'Kursuskategori';
$string['coursecategory_help'] = 'Indstillingen angiver hvilken kategori kurset vil optræde i på listen over kurser.';
$string['coursecategorydeleted'] = 'Kursuskategorien {$a} er slettet';
$string['coursecatmanagement'] = 'Kursus- og kategorihåndtering';
$string['coursecompletion'] = 'Kursusgennemførelse';
$string['coursecompletions'] = 'Kursusgennemførelser';
$string['coursecreators'] = 'Kursusadministrator';
$string['coursecreatorsdescription'] = 'Kursusadministratorer kan oprette nye kurser.';
$string['coursedeleted'] = 'Kurset {$a} er slettet';
$string['coursedetails'] = 'Kurser';
$string['coursedisplay'] = 'Kursuslayout';
$string['coursedisplay_help'] = 'Denne indstilling styrer, om kurset vises på en eller flere sider.';
$string['coursedisplay_multi'] = 'Vis en sektion pr. side';
$string['coursedisplay_single'] = 'Vis alle sektioner på en side';
$string['courseduration'] = 'Varighed af kurset';
$string['courseduration_desc'] = 'Kursets varighed bruges til beregning af en standard slutdato. Slutdatoen bruges til at bestemme om kurset vises på en brugers kursusliste. Den kan også bruges af brugerdefinerede rapporter. Brugere har stadig adgang til kurset efter denne dato.';
$string['courseenddateenabled'] = 'Slutdato aktiveret som standard';
$string['courseenddateenabled_desc'] = 'Indstillingen bestemmer om slutdatoen på kurset som udgangspunkt er aktiveret i nye kurser og beregnet ud fra kursets varighed.';
$string['courseextendednamedisplay'] = '{$a->shortname}  {$a->fullname}';
$string['coursefiles'] = 'Arvede kursusfiler';
$string['coursefilesedit'] = 'Håndter arvede kursusfiler';
$string['coursefileswarning'] = 'Kursusfiler er forældede';
$string['coursefileswarning_help'] = 'Kursusfiler er forældede siden Moodle 2.0, du skal i stedet bruge eksterne arkiver så meget som muligt.';
$string['courseformatdata'] = 'Kursusformatdata';
$string['courseformatoptions'] = 'Formatering af {$a}';
$string['courseformats'] = 'Kursusformat';
$string['courseformatudpate'] = 'Opdater format';
$string['coursegrades'] = 'Kursuskarakterer';
$string['courseheader'] = 'Kursusmenu';
$string['coursehelpcategory'] = 'Placer kurset på kursuslisten og gør det nemmere for de studerende at finde det.';
$string['coursehelpforce'] = 'Tving alle aktiviteter på kurset til at bruge grupper.';
$string['coursehelpformat'] = 'Kursets forside vil blive vist i dette format.';
$string['coursehelphiddensections'] = 'Hvordan skjulte sektioner på kurset vises for studerende.';
$string['coursehelpmaximumupload'] = 'Maksimal filstørrelse der kan uploades på kurset - begrænset af den generelle maksimumindstilling.';
$string['coursehelpnewsitemsnumber'] = 'Antal seneste meddelelser der vises på kursets forside i meddelelsesblokken. Vælges 0, oprettes meddelelsesforummet ikke.';
$string['coursehelpnumberweeks'] = 'Antal sektioner på kurset (gælder ikke alle kursusformater).';
$string['coursehelpshowgrades'] = 'Aktiver visning af karakterbogen. Det forhindrer ikke at karakterer bliver vist i de enkelte aktiviteter.';
$string['coursehidden'] = 'Dette kursus er på nuværende tidspunkt ikke tilgængeligt for studerende';
$string['courseinfo'] = 'Kursusinformation';
$string['courselegacyfiles'] = 'Arvede kursusfiler';
$string['courselegacyfiles_help'] = 'Kursets filområde giver bagudkompatibilitet med Moodle 1.9 og tidligere. Alle filer i dette område er altid tilgængelige for alle deltagere på kurset (uanset om du linker til dem eller ej), og der er ingen måde hvorpå du kan vide, hvor disse filer bliver brugt i Moodle.

Hvis du bruger dette område til at gemme kursusfiler i, kan du blive udsat for en række spørgsmål om sikkerhed og privatlivets fred, og du vil kunne opleve manglende filer i backups, kursusimport og hver gang indhold deles eller genbruges. Det anbefales derfor at du ikke bruger dette område medmindre du virkelig ved hvad du gør.';
$string['courselegacyfilesofcourse'] = 'Tidligere kursusfiler';
$string['coursenotaccessible'] = 'Dette kursus er ikke offentligt tilgængeligt';
$string['courseoverview'] = 'Kursusoversigt';
$string['courseoverviewfiles'] = 'Kursusbillede';
$string['courseoverviewfiles_help'] = 'Kursusbilledet vises i kursusoversigten på betjeningspanelet. Flere filtyper og flere end en fil kan aktiveres af administrator. I så fald vises de sammen med kursusbeskrivelsen på kursuslisten.';
$string['courseoverviewfilesext'] = 'Filendelser på kursusbilleder';
$string['courseoverviewfileslimit'] = 'Højeste antal kursusbilleder';
$string['courseoverviewgraph'] = 'Kursusoversigtsgraf';
$string['coursepreferences'] = 'Kursusindstillinger';
$string['courseprofiles'] = 'Kursusprofiler';
$string['coursereasonforrejecting'] = 'Dine grunde til at afvise denne anmodning';
$string['coursereasonforrejectingemail'] = 'Dette vil blive mailet til den der har sendt anmodningen';
$string['coursereject'] = 'Afvis en kursusanmodning';
$string['courserejected'] = 'Kurset er blevet afvist og ansøgeren har fået besked.';
$string['courserejectemail'] = 'Desværre, kurset du har anmodet om er blevet afvist. Her er begrundelsen:

{$a}';
$string['courserejectreason'] = 'Skriv årsagen til afslaget for kurset<br />(Den vil blive e-mailet til ansøgeren)';
$string['courserejectsubject'] = 'Dit kursus er blevet afvist';
$string['coursereport'] = 'Kursusrapport';
$string['coursereports'] = 'Kursusrapporter';
$string['courserequest'] = 'Kursusanmodning';
$string['courserequestdetails'] = 'Information om kurset du anmoder om';
$string['courserequestfailed'] = 'Af en eller anden årsag kunne din kursusanmodning ikke gemmes.';
$string['courserequestintro'] = 'Brug denne formular til at anmode om at der bliver oprettet et bestemt kursus.<br />Prøv at beskrive kurset så udførligt som muligt<br />så administratorerne kan få en idé om hvorfor kurset skal oprettes og hvad det skal indeholde.';
$string['courserequestreason'] = 'Baggrunden for at du gerne vil have oprettet dette kursus';
$string['courserequestsuccess'] = 'Din kursusanmodning er blevet gemt. Du vil modtage en mail om hvorvidt din forespørgsel er godkendt.';
$string['courserequestsupport'] = 'Yderligere information til hjælp til administratoren til at behandle anmodningen';
$string['courserequestwarning'] = 'Brugeren der har anmodet om dette kursus, vil automatisk blive tilmeldt og tildelt rollen som {$a}.';
$string['courserestore'] = 'Kursusgendannelse';
$string['coursereuse'] = 'Genanvendelse af kursus';
$string['courses'] = 'Kurser';
$string['coursesearch'] = 'Søg kurser';
$string['coursesearch_help'] = 'Du kan søge på flere ord samtidigt og du kan forfine din søgning sådan:

* ord - find enhver forekomst af ordet i teksten
* +ord - kun ord, der præcis matcher vil blive fundet
* -ord - udelad resultater, der indeholder dette ord.';
$string['coursesectionsummaries'] = 'Beskrivelser af kursussektioner';
$string['coursesectiontitle'] = 'Kursus: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'Standard kursusindstillinger';
$string['coursesmovedout'] = 'Kurser blev flyttet fra {$a}';
$string['coursespending'] = 'Kurser der afventer godkendelse';
$string['coursestart'] = 'Kursusstart';
$string['coursesummary'] = 'Kursusbeskrivelse';
$string['coursesummary_help'] = 'Kursusbeskrivelsen vises i kursuslisten. En kursussøgning søger i både beskrivelser og kursusnavne.';
$string['coursetitle'] = 'Kursus: {$a->course}';
$string['courseupdates'] = 'Kursusopdateringer';
$string['coursevisibility'] = 'Kursets synlighed';
$string['coursevisibility_help'] = 'Indstillingen styrer hvorvidt kurset optræder på listen over kurser, og om studerende har adgang til det. Vælges \'Skjul\', er kurset kun tilgængeligt for brugere med beføjelse til at se skjulte kurser (såsom lærere).';
$string['create'] = 'Opret';
$string['createaccount'] = 'Opret ny profil';
$string['createcategory'] = 'Opret kategori';
$string['createfolder'] = 'Opret en mappe i {$a}';
$string['createnew'] = 'Opret ny';
$string['createnewcategory'] = 'Opret en ny kategori';
$string['createnewcourse'] = 'Opret et nyt kursus';
$string['createnewsubcategory'] = 'Opret en ny underkategori';
$string['createsubcategoryof'] = 'Opret en underkategori af {$a}';
$string['createuser'] = 'Opret bruger';
$string['createuserandpass'] = 'Vælg  brugernavn og adgangskode';
$string['createziparchive'] = 'Opret zip-pakke';
$string['creatingblocks'] = 'Opretter blokke';
$string['creatingblocksroles'] = 'Opretter rolletildeling og undtagelser på blokniveau.';
$string['creatingblogsinfo'] = 'Opretter blogs-info';
$string['creatingcategoriesandquestions'] = 'Opretter kursuskategorier og spørgsmål';
$string['creatingcoursemodules'] = 'Opretter kursusmoduler';
$string['creatingcourseroles'] = 'Opretter rolletildeling og undtagelser på kursusniveau.';
$string['creatingevents'] = 'Opretter begivenheder';
$string['creatinggradebook'] = 'Opretter karakterbog';
$string['creatinggroupings'] = 'Opretter grupperinger';
$string['creatinggroupingsgroups'] = 'Tilføj grupper til grupperinger';
$string['creatinggroups'] = 'Opretter grupper';
$string['creatinglogentries'] = 'Opretter logoptegnelser';
$string['creatingmessagesinfo'] = 'Opretter beskedinfo';
$string['creatingmodroles'] = 'Opretter rolletildeling og undtagelser på modulniveau.';
$string['creatingnewcourse'] = 'Opretter et nyt kursus';
$string['creatingrolesdefinitions'] = 'Opretter rolledefinitioner';
$string['creatingscales'] = 'Opretter karakterskala';
$string['creatingsections'] = 'Opretter sektioner';
$string['creatingtemporarystructures'] = 'Opretter midlertidige strukturer';
$string['creatinguserroles'] = 'Opretter rolletildeling og undtagelser på brugerniveau.';
$string['creatingusers'] = 'Opretter brugere';
$string['creatingxmlfile'] = 'Opretter XML-fil';
$string['currency'] = 'Møntfod';
$string['currentcourse'] = 'Aktuelt kursus';
$string['currentcourseadding'] = 'Nuværende kursus, tilføjer data til det';
$string['currentcoursedeleting'] = 'Nuværende kursus, sletter det først';
$string['currentlanguage'] = 'Sprogvalg';
$string['currentlocaltime'] = 'din lokale tid';
$string['currentpicture'] = 'Nuværende billede';
$string['currentrelease'] = 'Nuværende versionsinformation';
$string['currentversion'] = 'Nuværende version';
$string['databasechecking'] = 'Opgraderer Moodledatabasen fra version{$a->oldversion} til {$a->newversion}...';
$string['databaseperformance'] = 'Databaseydelse';
$string['databasesetup'] = 'Opsætning af database';
$string['databasesuccess'] = 'Databasen opgraderet og OK';
$string['databaseupgradebackups'] = 'Backupversionen er nu {$a}';
$string['databaseupgradeblocks'] = 'Blokversion er nu:{$a}';
$string['databaseupgradegroups'] = 'Gruppeversion er nu {$a}';
$string['databaseupgradelocal'] = 'Den lokale databaseversion er nu {$a}';
$string['databaseupgrades'] = 'Opgraderer database';
$string['dataformats'] = 'Dataformater';
$string['date'] = 'Dato';
$string['datechanged'] = 'Dato ændret';
$string['datemostrecentfirst'] = 'Dato - seneste først';
$string['datemostrecentlast'] = 'Dato - seneste sidst';
$string['day'] = 'dag';
$string['days'] = 'dage';
$string['decodinginternallinks'] = 'Dekoder interne links';
$string['default'] = 'Standard';
$string['defaultcategoryname'] = 'Kategori 1';
$string['defaultcompetencescale'] = 'Standard kompetenceskala';
$string['defaultcompetencescaledesc'] = 'En binær vurderingsskala giver ikke yderligere information udover hvorvidt nogen har vist færdigheder eller ej.';
$string['defaultcompetencescalenotproficient'] = 'Endnu ikke kompetent';
$string['defaultcompetencescaleproficient'] = 'Kompetent';
$string['defaultcoursestudent'] = 'Studerende';
$string['defaultcoursestudentdescription'] = 'Studerende har generelt færre privilegier på et kursus';
$string['defaultcoursestudents'] = 'Studerende';
$string['defaultcoursesummary'] = 'Giv her en klar og interessant beskrivelse af dette kursus.';
$string['defaultcourseteacher'] = 'Lærer';
$string['defaultcourseteacherdescription'] = 'Lærere kan ændre alt på et kursus, inklusiv at ændre på aktiviteter og vurdere studerende.';
$string['defaultcourseteachers'] = 'Lærere';
$string['defaulteditor'] = 'Standard editor';
$string['defaulthomepageuser'] = 'Startside';
$string['defaulthomepageuser_help'] = 'Hvilken side skal du viderestilles til, efter at du er logget ind?';
$string['delete'] = 'Slet';
$string['deleteablock'] = 'Slet en blok';
$string['deleteall'] = 'Slet alt';
$string['deleteallcannotundo'] = 'Slet alt - kan ikke fortrydes';
$string['deleteallcomments'] = 'Slet alle kommentarer';
$string['deleteallratings'] = 'Slet alle vurderinger';
$string['deletecategory'] = 'Slet kategorien: {$a}';
$string['deletecategorycheck'] = 'Er du helt sikker på at du vil slette denne kategori <b>"{$a}"</b>?<br /> Det vil forårsage at evt. kurser i kategorien vil blive flyttet til den overliggende kategori eller til kategorien Diverse.';
$string['deletecategorycheck2'] = 'Hvis du sletter denne kategori, må du tage stilling til hvad der skal ske med dens underkategorier og kurser.';
$string['deletecategoryempty'] = 'Denne kategori er tom';
$string['deletecheck'] = 'Slet {$a}?';
$string['deletecheckfiles'] = 'Er du helt sikker på at du vil slette disse filer?';
$string['deletecheckfull'] = 'Er du helt sikker på at du vil slette brugeren {$a} inklusiv tilmeldinger, aktiviteter og andre brugerdata?';
$string['deletechecktype'] = 'Er du sikker på at du vil slette dette {$a->type}?';
$string['deletechecktypename'] = 'Er du sikker på at du vil slette {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Du er ved at slette disse filer';
$string['deletecommentbyon'] = 'Slet kommentar af {$a->user}, {$a->time}';
$string['deletecompletely'] = 'Slet helt';
$string['deletecourse'] = 'Slet et kursus';
$string['deletecoursecheck'] = 'Bekræft at du vil slette dette kursus og al dets indhold.';
$string['deleted'] = 'Slettet';
$string['deletedactivity'] = 'Slettet {$a}';
$string['deletedcourse'] = '{$a} er nu væk!';
$string['deletednot'] = 'Kunne ikke slette {$a}!';
$string['deletepicture'] = 'Slet';
$string['deletesection'] = 'Slet sektion';
$string['deleteselected'] = 'Slet valgte';
$string['deleteselectedkey'] = 'Slet den valgte nøgle';
$string['deletingcourse'] = 'Sletter {$a}';
$string['deletingexistingcoursedata'] = 'Slet eksisterende kursusdata';
$string['deletingolddata'] = 'Sletter gamle data';
$string['department'] = 'Afdeling';
$string['deprecatedeventname'] = '{$a} (bruges ikke mere)';
$string['desc'] = 'Faldende';
$string['description'] = 'Beskrivelse';
$string['descriptiona'] = 'Beskrivelse: {$a}';
$string['deselectall'] = 'Fravælg alle';
$string['deselectnos'] = 'Fravælg alle "Nej"';
$string['detailedless'] = 'Mindre detaljeret';
$string['detailedmore'] = 'Mere detaljeret';
$string['details'] = 'Detaljer';
$string['digitalminor'] = 'Digital mindreårig';
$string['digitalminor_desc'] = 'Bed dine forældre/din værge om at kontakte:';
$string['directory'] = 'Mappe';
$string['disable'] = 'Deaktiver';
$string['disabledcomments'] = 'Der er lukket for kommentarer';
$string['dismissnotification'] = 'Skrot denne underretning';
$string['displayingfirst'] = 'Kun de første {$a->count} {$a->things} vises';
$string['displayingrecords'] = 'Viser {$a} registreringer';
$string['displayingusers'] = 'Viser brugere {$a->start} til {$a->end}';
$string['displayonpage'] = 'Vis på side';
$string['dndcourse'] = 'Du kan trække og slippe dette kursus for at ændre dets sortering, eller for at flytte det til en anden kategori.';
$string['dndenabled_inbox'] = 'Du kan tilføje filer ved at trække og slippe dem hertil.';
$string['dndnotsupported'] = 'Upload med træk og slip er ikke understøttet';
$string['dndnotsupported_help'] = 'Din browser understøtter ikke upload ved hjælp af træk og slip. Denne funktion er tilgængelig i alle seneste versioner af Chrome, Firefox og Safari, såvel som i Internet Explorer v10 og senere.';
$string['dndnotsupported_insentence'] = 'træk og slip ikke understøttet';
$string['dnduploadwithoutcontent'] = 'Dette upload har ikke noget indhold';
$string['dndworkingfile'] = 'Træk og slip filer til en kursussektion for at uploade dem';
$string['dndworkingfilelink'] = 'Træk og slip filer eller links til en kursussektion for at uploade dem';
$string['dndworkingfiletext'] = 'Træk og slip filer eller tekst til en kursussektion for at uploade dem';
$string['dndworkingfiletextlink'] = 'Træk og slip filer, tekst eller links til en kursussektion for at uploade dem';
$string['dndworkinglink'] = 'Træk og slip links til en kursussektion for at uploade dem';
$string['dndworkingtext'] = 'Træk og slip tekst til en kursussektion for at uploade den';
$string['dndworkingtextlink'] = 'Upload tekst eller links til kursussektioner med træk og slip';
$string['documentation'] = 'Moodles dokumentation';
$string['dontsortcategories'] = 'Sorter ikke  kategorier';
$string['dontsortcourses'] = 'Sorter ikke kurser';
$string['down'] = 'Ned';
$string['download'] = 'Download';
$string['downloadall'] = 'Download alt';
$string['downloadexcel'] = 'Download i Excel-format';
$string['downloadfile'] = 'Download fil';
$string['downloadods'] = 'Download i ODS-format';
$string['downloadtext'] = 'Download i tekstformat';
$string['doyouagree'] = 'Har du læst og forstået disse betingelser?';
$string['droptoupload'] = 'Drop filer her for at uploade';
$string['duplicate'] = 'Dubler';
$string['duplicatedmodule'] = '{$a} (kopi)';
$string['edhelpaspellpath'] = 'For at benytte stavekontrol i editoren SKAL du have <strong>aspell 0.50</strong> eller nyere installeret på serveren, og du skal angive den korrekte sti til aspell-programmet. På Unix/Linux systemer er stien typisk <strong>/usr/bin/aspell</strong>, men det kan være andet.';
$string['edhelpbgcolor'] = 'Definer HTML-editorens baggrundsfarve<br />Korrekte værdier kunne være: #ffffff eller white';
$string['edhelpcleanword'] = 'Denne indstilling aktiverer eller deaktiverer MSWord-specifik formaterings-filtrering.';
$string['edhelpenablespelling'] = 'Aktiver eller deaktiver stavekontrol. For at stavekontrol kan aktiveres skal <strong>aspell</strong> være installeret på systemet. Den anden værdi er <strong>standardordbogen</strong>. Den bruges hvis ikke aspell findes til brugerens eget sprog.';
$string['edhelpfontfamily'] = 'Egenskaben font-family er en liste med navne på font-familier og/eller generiske familienavne. Navnene adskilles med komma.';
$string['edhelpfontlist'] = 'Definer de fonte der skal vises i html-editorens rullemenu.';
$string['edhelpfontsize'] = 'Skriftens standardstørrelse<br />Korrekte værdier kunne f.eks. være: medium, large, smaller, larger, 10pt, 11px';
$string['edit'] = 'Rediger';
$string['edita'] = 'Rediger {$a}';
$string['editcategorysettings'] = 'Rediger kategoriindstillinger';
$string['editcategorythis'] = 'Rediger denne kategori';
$string['editcoursesettings'] = 'Rediger kursusindstillinger';
$string['editfiles'] = 'Administrer filer';
$string['editgroupprofile'] = 'Rediger gruppeprofil';
$string['editinga'] = 'Redigerer {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Denne værdi kan ikke ændres!';
$string['editmode'] = 'Redigeringstilstand';
$string['editmyprofile'] = 'Rediger profil';
$string['editorbgcolor'] = 'Baggrundsfarve';
$string['editorcleanonpaste'] = 'Rens MS Word-HTML når tekst kopieres ind';
$string['editorcommonsettings'] = 'Almindelige indstillinger';
$string['editordefaultfont'] = 'Standard font';
$string['editorenablespelling'] = 'Aktiver stavekontrol';
$string['editorfontlist'] = 'Fontliste';
$string['editorfontsize'] = 'Standard skriftstørrelse';
$string['editorpreferences'] = 'Editorindstillinger';
$string['editorresettodefaults'] = 'Gendan standardværdier';
$string['editorsettings'] = 'Editorindstillinger';
$string['editorshortcutkeys'] = 'Genvejstaster til editoren';
$string['editsection'] = 'Rediger sektion';
$string['editsectionname'] = 'Rediger sektionsnavn';
$string['editsettings'] = 'Indstillinger';
$string['editsummary'] = 'Rediger tekst';
$string['editthisactivity'] = 'Rediger denne aktivitet';
$string['editthiscategory'] = 'Rediger denne kategori';
$string['edittitle'] = 'Omdøb';
$string['edittitleinstructions'] = 'Escape for at annullere, Enter når du er færdig';
$string['edituser'] = 'Rediger brugerkonti';
$string['edulevel'] = 'Alle begivenheder';
$string['edulevel_help'] = '* Undervisning - handlinger udført af en lærer, f.eks. opdatere undervisningsmateriale
* Deltagelse - handlinger udført af en studerende, f.eks. skrive i et forum
* Andre - handlinger udført af en bruger med en anden rolle end lærer eller studerende';
$string['edulevelother'] = 'Andre';
$string['edulevelparticipating'] = 'Deltagelse';
$string['edulevelteacher'] = 'Undervisning';
$string['email'] = 'E-mailadresse';
$string['emailactive'] = 'E-mail aktiveret';
$string['emailagain'] = 'E-mail (igen)';
$string['emailalreadysent'] = 'En e-mail om ny adgangskode er allerede afsendt. Tjek din e-mail.';
$string['emailcharset'] = 'Tegnsæt i e-mail';
$string['emailconfirm'] = 'Bekræft din konto';
$string['emailconfirmation'] = 'Hej

En ny konto er oprettet på "{$a->sitename}" med din e-mailaddresse.

For at bekræfte din oprettelse gå til følgende webadresse:

   {$a->link}

I de fleste mailprogrammer vises linket med blå skrift, som du kan klikke på. Hvis det ikke virker, kan du kopiere og indsætte (copy-paste) adressen i adressefeltet øverst i dit browservindue.

Har du brug for hjælp, kan du kontakte sidens administrator,
{$a->admin}';
$string['emailconfirmationresend'] = 'Gensend bekræftelsesmail';
$string['emailconfirmationsubject'] = '{$a}: Kontobekræftelse';
$string['emailconfirmsent'] = '<p>En e-mail skulle være sendt til din adresse <b>{$a}</b></p> <p>Den indeholder anvisninger på, hvordan du fuldfører din registrering.</p> <p>Hvis du stadig har problemer, så kontakt webadministratoren.</p>';
$string['emailconfirmsentfailure'] = 'Afsendelse af bekræftelsesmailen fejlede';
$string['emailconfirmsentsuccess'] = 'Bekræftelsesmail sendt';
$string['emaildigest'] = 'Abonnementstype';
$string['emaildigest_help'] = 'Dette er den generelle indstilling for abonnement på forumindlæg.

* Ingen sammendrag - du vil modtage en e-mail per forumindlæg;
* Sammendrag - fulde indlæg - du vil modtage en e-mail om dagen med alle forumindlæg.
* Sammendrag - kun emner - du vil modtage en e-mail per dag, som kun inderholder emnefeltet på hvert indlæg.

Du kan også vælge specifikke indstillinger i de enkelte fora.';
$string['emaildigestcomplete'] = 'Komplet (daglig e-mail med alle indlæg)';
$string['emaildigestoff'] = 'En e-mail per indlæg';
$string['emaildigestsubjects'] = 'Emner (daglig e-mail kun med emner)';
$string['emaildisable'] = 'Denne e-mailadresse er deaktiveret.';
$string['emaildisableclick'] = 'Tryk her for at forhindre at der bliver sendt e-mail til denne adresse';
$string['emaildisplay'] = 'Synlighed af e-mail';
$string['emaildisplay_help'] = '* Skjult - Kun brugere med de rette tilladelser, f.eks. lærere, kan se din e-mailadresse.
* Synlig for alle - Alle brugere på webstedet kan se din e-mailadresse.
* Synlig for kursusdeltagere - Kun deltagere på kurser du er tilmeldt, kan se din e-mailadresse.';
$string['emaildisplaycourse'] = 'Synlig for kursusdeltagerne';
$string['emaildisplaycoursemembersonly'] = '(Synlig for andre deltagere på kurset)';
$string['emaildisplayeveryone'] = '(Synlig for alle)';
$string['emaildisplayhide'] = '(Skjult for alle undtagen brugere med de fornødne tilladelser)';
$string['emaildisplayno'] = 'Skjult';
$string['emaildisplayyes'] = 'Synlig for alle';
$string['emailenable'] = 'Denne e-mailadresse er aktiveret.';
$string['emailenableclick'] = 'Klik her for at tillade at der bliver sendt e-mails til denne adresse.';
$string['emailexists'] = 'Denne e-mailadresse er allerede registreret.';
$string['emailexistshintlink'] = 'Gendan glemt brugernavn eller adgangskode';
$string['emailexistssignuphint'] = 'Måske har du tidligere oprettet en konto? {$a}';
$string['emailformat'] = 'E-mailformat';
$string['emailmustbereal'] = 'Bemærk: Din e-mailadresse skal være gyldig';
$string['emailnotallowed'] = 'E-mailadresser fra disse domæner er ikke tilladt ({$a}).';
$string['emailnotfound'] = 'E-mailadressen findes ikke i databasen';
$string['emailonlyallowed'] = 'Dette e-maildomæne er ikke et af de tilladte ({$a}).';
$string['emailpasswordchangeinfo'] = 'Hej {$a->firstname}

Nogen (sikkert dig selv) har bestilt en ny adgangskode til "{$a->username}" på "{$a->sitename}".

Du kan ændre din kode på denne side:

{$a->link}

I de fleste mailprogrammer vises linket med blå skrift, som du bare kan klikke på. Hvis det ikke virker, kan du kopiere adressen over i adressefeltet i toppen af dit browservindue.

Har du brug for hjælp, kan du kontakte administrator, {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hej {$a->firstname}

Nogen (sikkert dig selv) har bestilt en ny adgangskode til \'{$a->sitename}\'.

Desværre er din konto til siden deaktiveret så koden kan ikke ændres. Kontakt administrator, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hej {$a->firstname}

Nogen (sikkert dig selv) har bestilt en ny adgangskode til "{$a->sitename}".

Desværre kan adgangskoden ikke ændres på dette site, kontakt administrator, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Skift adgangskode';
$string['emailpasswordconfirmation'] = 'Hej {$a->firstname}

Nogen (sikkert dig selv) har bestilt en ny adgangskode til "{$a->sitename}".

Bekræft dette og få en ny kode tilsendt på mail ved at besøge denne side:

{$a->link}

I de fleste mailprogrammer kommer linket med blå skrift, som du kan klikke på. Hvis det ikke virker, kan du kopiere adressen ind i adressefeltet i toppen af dit browservindue.

Har du brug for hjælp, kontakt sidens administrator, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Bekræft bestilling af adgangskode';
$string['emailpasswordconfirmmaybesent'] = '<p>Hvis du har angivet korrekt brugernavn og e-mailadresse, skulle der være sendt en mail til dig.</p> <p>Den indeholder simple instruktioner til hvordan du godkender og gennemfører ændringen af din kode. Hvis det alligevel giver problemer, kan du altid kontakte administratoren.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Den brugerkonto du angav, har ikke en registreret e-mail tilknyttet.</p> </p>Kontakt administratoren.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>De brugerdata du indtastede, identificerer ikke en eksisterende bruger.<p> <p>Tjek din indtastning og prøv igen. Hvis du fortsat har problemer, så kontakt sidens administrator.</p>';
$string['emailpasswordconfirmsent'] = 'En e-mail skulle være sendt til dig på <b>{$a}</b>
<br />Den indeholder anvisninger på, hvordan du bliver registreret.
<br />Hvis du stadig har problemer, så kontakt webadministratoren.';
$string['emailpasswordsent'] = 'Du har accepteret at få en ny adgangskode. Der er sendt en e-mail til dig med nye kode. Mailen er sendt til <b>{$a->e-mail}</b> <br />Den nye kode er genereret automatisk. Du kan ændre den til en du lettere kan huske her: <a href="{$a->link}">Skift Adgangskode</a>';
$string['emailresetconfirmation'] = 'Hej {$a->firstname}

Der er blevet bestilt en nulstilling af adgangskoden for din bruger, {$a->username}, på {$a->sitename}.

Klik på det følgende link for at bekræfte nulstillingen og oprette en ny adgangskode

{$a->link}
(Linket er gyldigt i {$a->resetminutes} minutter efter at anmodningen blev sendt).

Hvis du ikke har bestilt nulstilling af din adgangskode, behøver du ikke gøre mere.

Har du brug for hjælp, kan du kontakte administrator,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Anmodning om nulstilling af adgangskode';
$string['emailresetconfirmsent'] = 'En e-mail er blevet sendt til din adresse <b>{$a}</b>. <br />Den indeholder enkle instruktioner til at bekræfte og færdiggøre denne adgangskodeændring. Hvis du fortsat har problemer, kontakt administratoren.';
$string['emailstop'] = 'Deaktiver underretninger';
$string['emailtoprivatefiles'] = 'Du kan også e-maile vedhæftede filer direkte ind i dit private filområde. Vedhæft blot din fil til en e-mail og send den til {$a}';
$string['emailtoprivatefilesdenied'] = 'Din administrator har deaktiveret muligheden for at du kan uploade private filer.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Aktiviteter';
$string['emojicategoryanimalsnature'] = 'Dyr & natur';
$string['emojicategoryflags'] = 'Flag';
$string['emojicategoryfooddrink'] = 'Mad & drikke';
$string['emojicategoryobjects'] = 'Objekter';
$string['emojicategorypeoplebody'] = 'Mennesker og krop';
$string['emojicategoryrecent'] = 'Seneste';
$string['emojicategorysmileysemotion'] = 'Smileys & humørikon';
$string['emojicategorysymbols'] = 'Symboler';
$string['emojicategorytravelplaces'] = 'Rejse & steder';
$string['emptycmids'] = 'Tomme kursusmodul-id\'er';
$string['emptydragdropregion'] = 'tom region';
$string['emptysectionids'] = 'Tomme sektions-id\'er';
$string['enable'] = 'Aktiver';
$string['encryptedcode'] = 'Krypteret kode';
$string['enddate'] = 'Slutdato';
$string['enddate_help'] = 'Kursets slutdato bestemmer, om et kursus er opført som afsluttet i kursusoversigten. Kursets slutdato kan også bruges i brugerdefinerede rapporter. Bemærk, at brugere stadig kan gå ind på kurset efter slutdatoen; datoen begrænser med andre ord ikke adgangen.';
$string['english'] = 'Engelsk';
$string['enrolmentmethods'] = 'Tilmeldingsmetoder';
$string['entercourse'] = 'Klik for at komme ind på kurset';
$string['enteremail'] = 'Skriv din e-mailadresse';
$string['enteremailaddress'] = 'Indtast din e-mailadresse for at nulstille din adgangskode og du får en ny sendt med en e-mail';
$string['enterusername'] = 'Skriv dit brugernavn';
$string['entries'] = 'Indlæg';
$string['error'] = 'Fejl';
$string['errorcreatingactivity'] = 'Kunne ikke oprette aktiviteten \'{$a}\\';
$string['errorfiletoobig'] = 'Filen var større end grænsen på {$a} bytes';
$string['errornouploadrepo'] = 'Der er ikke noget filarkiv at uploade til på dette site';
$string['errorwhenconfirming'] = 'Du er ikke godkendt da der er sket en fejl. Hvis du har klikket på et link der er sendt til dig pr. e-mail, så undersøg om webadressen er i orden og ikke delt over flere linjer. Hvis den er, så prøv at føje den sammen med kopier og sæt ind (copy-paste) så det bliver en lang linje.';
$string['eventcommentcreated'] = 'Kommentar oprettet';
$string['eventcommentdeleted'] = 'Kommentar slettet';
$string['eventcommentsviewed'] = 'Kommentar set';
$string['eventconfiglogcreated'] = 'Konfigurationslog oprettet';
$string['eventcontentviewed'] = 'Indhold set';
$string['eventcoursebackupcreated'] = 'Kursusbackup oprettet';
$string['eventcoursecategorycreated'] = 'Kategori oprettet';
$string['eventcoursecategorydeleted'] = 'Kategori slettet';
$string['eventcoursecategoryupdated'] = 'Kategori opdateret';
$string['eventcoursecategoryviewed'] = 'Kategori set';
$string['eventcoursecontentdeleted'] = 'Kursusindhold slettet';
$string['eventcoursecreated'] = 'Kursus oprettet';
$string['eventcoursedeleted'] = 'Kursus slettet';
$string['eventcourseinformationviewed'] = 'Kursusbeskrivelse set';
$string['eventcoursemodulecreated'] = 'Kursusmodul oprettet';
$string['eventcoursemoduledeleted'] = 'Kursusmodul slettet';
$string['eventcoursemoduleinstancelistviewed'] = 'Liste med kursusmoduler set';
$string['eventcoursemoduleupdated'] = 'Kursusmodul opdateret';
$string['eventcoursemoduleviewed'] = 'Kursusmodul set';
$string['eventcourseresetended'] = 'Kursus nulstillet';
$string['eventcourseresetstarted'] = 'Nulstilling af kursus startet';
$string['eventcourserestored'] = 'Kursus genoprettet';
$string['eventcoursesectioncreated'] = 'Kursussektion oprettet';
$string['eventcoursesectiondeleted'] = 'Kursussektion slettet';
$string['eventcoursesectionupdated'] = 'Kursussektion opdateret';
$string['eventcoursessearched'] = 'Kurser gennemsøgt';
$string['eventcourseupdated'] = 'Kursus opdateret';
$string['eventcourseuserreportviewed'] = 'Kursusdeltagerrapport set';
$string['eventcourseviewed'] = 'Kursus set';
$string['eventdashboardreset'] = 'Betjeningspanel nulstillet';
$string['eventdashboardsreset'] = 'Betjeningspaneler nulstillet';
$string['eventdashboardviewed'] = 'Betjeningspanel set';
$string['eventdatabasetextfieldcontentreplaced'] = 'Database - søg og erstat globalt';
$string['eventemailfailed'] = 'Det lykkedes ikke afsende e-mail';
$string['eventmycoursesviewed'] = 'Mine viste kurser';
$string['eventname'] = 'Begivenhedsnavn';
$string['eventrecentactivityviewed'] = 'Nylig aktivitet som blev vist';
$string['eventsearchindexed'] = 'Søgedata indekseret';
$string['eventsearchresultsviewed'] = 'Søgeresultater set';
$string['eventunknownlogged'] = 'Ukendt begivenhed';
$string['eventusercreated'] = 'Bruger oprettet';
$string['eventuserdeleted'] = 'Bruger slettet';
$string['eventuserfeedbackgiven'] = 'Klikket på link til feedback';
$string['eventuserfeedbackremind'] = 'Klikket på link til påmind mig senere';
$string['eventuserinfocategorycreated'] = 'Kategori til brugerprofilfelt oprettet';
$string['eventuserinfocategorydeleted'] = 'Kategori til brugerprofilfelt slettet';
$string['eventuserinfocategoryupdated'] = 'Kategori til brugerprofilfelt opdateret';
$string['eventuserinfofieldcreated'] = 'Brugerprofilfelt oprettet';
$string['eventuserinfofielddeleted'] = 'Brugerprofilfelt slettet';
$string['eventuserinfofieldupdated'] = 'Brugerprofilfelt opdateret';
$string['eventuserlistviewed'] = 'Brugerliste set';
$string['eventuserloggedout'] = 'Bruger logget ud';
$string['eventuserpasswordpolicyfailed'] = 'Adgangskode matcher ikke kodepolitikken';
$string['eventuserpasswordupdated'] = 'Brugeradgangskode opdateret';
$string['eventuserprofileviewed'] = 'Brugerprofil set';
$string['eventuserupdated'] = 'Bruger opdateret';
$string['everybody'] = 'Alle';
$string['executeat'] = 'Eksekver klokken';
$string['existing'] = 'Eksisterende';
$string['existingadmins'] = 'Eksisterende administratorer';
$string['existingcourse'] = 'Eksisterende kursus';
$string['existingcourseadding'] = 'Eksisterende kursus, tilføjer data til det';
$string['existingcoursedeleting'] = 'Eksisterende kursus, sletter det først';
$string['existingcreators'] = 'Eksisterende kursusadministratorer';
$string['existingstudents'] = 'Tilmeldte studerende';
$string['existingteachers'] = 'Eksisterende lærere';
$string['expand'] = 'Udvid';
$string['expandall'] = 'Udvid alle';
$string['expandcategory'] = 'Udvid {$a}';
$string['explanation'] = 'Forklaring';
$string['explanationdigitalminor'] = 'Denne information kræves fordi man kun må oprette en profil hvis man er over den "digitale lavalder". Det er den alder hvor man må give sit samtykke til betingelser og vilkår, og til at ens data lovligt må gemmes og behandles.';
$string['extendperiod'] = 'Forlænget periode';
$string['extendsession'] = 'Forlæng sessionen';
$string['failedloginattempts'] = '{$a->attempts} mislykkede login siden dit sidste login';
$string['favourites'] = 'Foretrukne';
$string['feedback'] = 'Feedback';
$string['file'] = 'Fil';
$string['fileexists'] = 'Der er allerede en fil der hedder {$a}';
$string['filemissing'] = '{$a} mangler';
$string['filereaderror'] = 'Kunne ikke læse filen "{$a}". Tjek at den faktisk er en fil og ikke en mappe.';
$string['files'] = 'Filer';
$string['filesanduploads'] = 'Filer og uploads';
$string['filesfolders'] = 'Filer/mapper';
$string['fileuploadwithcontent'] = 'Filupload skulle ikke inkludere inholdsparameter';
$string['filloutallfields'] = 'Udfyld alle felter i denne formular';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = 'Filtre';
$string['findmorecourses'] = 'Find flere kurser...';
$string['first'] = 'Første';
$string['firstaccess'] = 'Første besøg';
$string['firstname'] = 'Fornavn';
$string['firstnamephonetic'] = 'Fornavn - fonetisk';
$string['firstpage'] = 'Første side';
$string['firstsiteaccess'] = 'Første adgang til siden';
$string['firsttime'] = 'Er det dit første besøg?';
$string['folder'] = 'Mappe';
$string['folderclosed'] = 'Lukket mappe';
$string['folderopened'] = 'Åbnede mappe';
$string['followingoptional'] = 'Følgende er frivilligt at udfylde';
$string['followingrequired'] = 'Følgende SKAL udfyldes';
$string['for'] = 'For';
$string['force'] = 'Gennemtving';
$string['forcelanguage'] = 'Vælg sprog';
$string['forceno'] = 'Valgfrit (gennemtving ikke)';
$string['forcepasswordchange'] = 'Gennemtving skift af kode';
$string['forcepasswordchange_help'] = 'Tving brugeren til at ændre adgangskode ved næste login.';
$string['forcepasswordchangecheckfull'] = 'Er du helt sikker på at du vil tvinge ændring af adgangskode for {$a}?';
$string['forcepasswordchangenot'] = 'Kunne ikke gennemtvinge en ændring af adgangskode for {$a}';
$string['forcepasswordchangenotice'] = 'Du skal ændre din kode inden du kan fortsætte';
$string['forcepasswordresetfailurenotice'] = 'Din nuværende adgangskode overholder ikke længere den gældende adgangskodepolitik. Kontakt Moodle-administratoren for at få hjælp.
   {$a}';
$string['forcepasswordresetnotice'] = 'Din nuværende adgangskode overholder ikke længere den gældende adgangskodepolitik, du skal nulstille din kode for at logge ind.
   {$a}';
$string['forcetheme'] = 'Bestem layout';
$string['forgotaccount'] = 'Glemt adgangskode?';
$string['forgotten'] = 'Har du glemt dit brugernavn eller din adgangskode?';
$string['forgottenduplicate'] = 'Der er andre brugere der har denne e-mailadresse, skriv dit brugernavn i stedet';
$string['forgotteninvalidurl'] = 'URL til at nulstille forkert adgangskode.';
$string['format'] = 'Format';
$string['format_help'] = 'Kursusformatet styrer layoutet af kursussiden.

* Enkelt aktivitet-format - Til at vise en enkelt aktivitet eller materiale (som f.eks. en quiz eller SCORM-pakke) på kursussiden
* Socialt format - Et forum vises på kursussiden
* Emneformat - Kursussiden er organiseret med emnesektioner
* Ugeformat - Kursussiden er organiseret med ugesektioner, hvor første uge starter på kursets startdato';
$string['formathtml'] = 'HTML-format';
$string['formatmarkdown'] = '\'Markdown\'-format';
$string['formatplain'] = 'Uformateret tekst';
$string['formattext'] = 'Moodles auto-format';
$string['forumpreferences'] = 'Forumindstillinger';
$string['framesetinfo'] = 'Dette "frameset"-dokument indeholder:';
$string['from'] = 'Fra';
$string['frontpagecategorycombo'] = 'Komboliste';
$string['frontpagecategorynames'] = 'Vis liste over kategorier';
$string['frontpagecourselist'] = 'Vis liste over kurser';
$string['frontpagecoursesearch'] = 'Kursussøgeboks';
$string['frontpagedescription'] = 'Forsidebeskrivelse';
$string['frontpagedescriptionhelp'] = 'Denne beskrivelse kan blive vist på forsiden ved at bruge kursus-/site-resuméblokken.';
$string['frontpageenrolledcourselist'] = 'Tilmeldte kurser';
$string['frontpageformat'] = 'Forsideformat';
$string['frontpageformatloggedin'] = 'Forsideformat når man er logget ind';
$string['frontpagenews'] = 'Meddelelser';
$string['frontpagesettings'] = 'Forsideindstillinger';
$string['fulllistofcourses'] = 'Alle kurser';
$string['fullname'] = 'Fulde navn';
$string['fullnamecourse'] = 'Fulde kursusnavn';
$string['fullnamecourse_help'] = 'Kursets fulde navn vises øverst på hver kursusside og i listen over kurser.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Fulde navn';
$string['fullprofile'] = 'Fulde profil';
$string['fullsitename'] = 'Fulde sitenavn';
$string['functiondisabled'] = 'Denne funktion er i øjeblikket deaktiveret';
$string['general'] = 'Generelt';
$string['geolocation'] = 'breddegrad - længdegrad';
$string['gettheselogs'] = 'Hent disse logs';
$string['go'] = 'Start';
$string['gpl'] = 'Ophavsret (C) 1999 og fremefter Martin Dougiamas (https://moodle.com)

Programmet er fri software: Du kan redistribuere det og/eller modificere det under betingelserne i GNU General Public License, som er offentliggjort af the Free Software Foundation, enten version 2 af licensen, eller (efter eget valg) en senere version.

Dette program er distribueret i håbet om at det vil være nyttigt, men UDEN NOGEN GARANTI; uden den implicitte garanti for SALGBARHED eller EGNETHED TIL ET BESTEMT FORMÅL.

Se alle oplysninger på siden med Moodles licens (på engelsk): https://docs.moodle.org/dev/License';
$string['gpl3'] = 'Ophavsret (C) 1999 og fremefter Martin Dougiamas (https://moodle.com).

Programmet er fri software: Du kan redistribuere det og/eller modificere det under betingelserne i GNU General Public License, som er offentliggjort af the Free Software Foundation, enten version 3 af licensen, eller (efter eget valg) en senere version.

Dette program er distribueret i håbet om at det vil være nyttigt, men UDEN NOGEN GARANTI; uden den implicitte garanti for SALGBARHED eller EGNETHED TIL ET BESTEMT FORMÅL.

Se alle oplysninger på siden med Moodles licens (på engelsk): https://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL-licens';
$string['grade'] = 'Karakter';
$string['gradenoun'] = 'Karakter';
$string['grades'] = 'Karakterer';
$string['gradeverb'] = 'Karakter';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Gravatar</a> er aktiveret på dette site. Hvis du ikke uploader et profilbillede vil Moodle forsøge at indlæse et til dig fra Gravatar.';
$string['group'] = 'Gruppe';
$string['groupadd'] = 'Ny gruppe';
$string['groupaddusers'] = 'Føj til gruppe';
$string['groupfor'] = 'for gruppe';
$string['groupinfo'] = 'Gruppeinfo';
$string['groupinfoedit'] = 'Rediger gruppeindstillinger';
$string['groupinfomembers'] = 'Deltagerinfo';
$string['groupinfopeople'] = 'Personinfo';
$string['groupmembers'] = 'Gruppemedlemmer';
$string['groupmemberssee'] = 'Se gruppemedlemmer';
$string['groupmembersselected'] = 'Medlemmer af valgte gruppe';
$string['groupmode'] = 'Gruppeinddeling';
$string['groupmodeforce'] = 'Gennemtving gruppeindeling';
$string['groupmy'] = 'Min gruppe';
$string['groupnonmembers'] = 'Personer udenfor grupper';
$string['groupnotamember'] = 'Du er desværre ikke medlem af den gruppe';
$string['grouprandomassign'] = 'Tilfældig gruppering';
$string['groupremove'] = 'Nedlæg gruppe';
$string['groupremovemembers'] = 'Fjern valgte gruppemedlemmer';
$string['groups'] = 'Grupper';
$string['groupsnone'] = 'Ingen grupper';
$string['groupsseparate'] = 'Separate grupper';
$string['groupsvisible'] = 'Synlige grupper';
$string['guest'] = 'Gæster';
$string['guestdescription'] = 'Gæster har få privilegier og kan som regel ikke skrive nogen steder.';
$string['guestskey'] = 'Tillad at gæster får nøglen';
$string['guestsno'] = 'Tillad ikke gæster';
$string['guestsnotallowed'] = 'Beklager, "{$a}" tillader ikke gæsteadgang.';
$string['guestsyes'] = 'Tillad gæster uden nøgle';
$string['guestuser'] = 'Gæst';
$string['guestuserinfo'] = 'Denne bruger tillades kun læseadgang til visse kurser.';
$string['help'] = 'Hjælp';
$string['helpprefix2'] = 'Hjælp til {$a}';
$string['helpwiththis'] = 'Hjælp til dette';
$string['hiddenassign'] = 'Skjult opgave';
$string['hiddenfromstudents'] = 'Skjult for studerende';
$string['hiddenoncoursepage'] = 'Tilgængelig, men vises ikke på kursets forside';
$string['hiddensections'] = 'Skjulte uger/emner';
$string['hiddensections_help'] = 'Om skjulte sektioner vises for studerende som ikke tilgængelige (måske for et kursus i ugeformat for at angive helligdage) eller om de er helt skjulte.';
$string['hiddensectionscollapsed'] = 'Skjulte sektioner vises som ikke tilgængellige';
$string['hiddensectionsinvisible'] = 'Skjulte uger/emner er ikke vist';
$string['hiddenwithbrackets'] = '(skjult)';
$string['hide'] = 'Skjul';
$string['hideadvancedsettings'] = 'Skjul avancerede indstillinger';
$string['hidechartdata'] = 'Gem skemadata';
$string['hidefromstudents'] = 'Skjul for studerende';
$string['hideoncoursepage'] = 'Tilgængelig, men vis ikke på kursets forside';
$string['hidepicture'] = 'Skjul billede';
$string['hidepopoverwindow'] = 'Skjul popover-vindue';
$string['hidesection'] = 'Skjul sektionen {$a}';
$string['hidesettings'] = 'Skjul indstillinger';
$string['hideshowblocks'] = 'Skjul eller vis blokke';
$string['highlight'] = 'Fremhæv';
$string['highlighted'] = 'Fremhævet';
$string['highlightoff'] = 'Fremhæv ikke';
$string['hits'] = 'Hits';
$string['hitsoncourse'] = 'Hits på {$a->coursename} af {$a->username}';
$string['hitsoncoursetoday'] = 'Dagens hit på {$a->coursename} af {$a->username}';
$string['home'] = 'Hjem';
$string['homeheader'] = 'Hjem';
$string['hour'] = 'time';
$string['hours'] = 'timer';
$string['howtomakethemes'] = 'Hvordan man laver nye layouts';
$string['htmleditor'] = 'Brug HTML-editor';
$string['htmleditoravailable'] = 'HTML-editoren er tilgængelig';
$string['htmleditordisabled'] = 'Du har slået HTML-editoren fra i din brugerprofil';
$string['htmleditordisabledadmin'] = 'Administratoren har slået HTML-editoren fra på dette site';
$string['htmleditordisabledbrowser'] = 'HTML-editoren kan ikke bruges, da du ikke bruger Internet Explorer 5.5 eller nyere versioner';
$string['htmlfilesonly'] = 'Kun HTML-filer';
$string['htmlformat'] = 'HTML-format';
$string['icon'] = 'Ikon';
$string['icqnumber'] = 'ICQ-nummer';
$string['idnumber'] = 'Id-nummer';
$string['idnumbercourse'] = 'Kursus-id';
$string['idnumbercourse_help'] = 'Når et kursus skal kommunikere med eksterne systemer bruges et id-nummer. Har du et sådant skal du skrive det her, ellers springer du bare feltet over. Nummeret vises ingen steder på Moodles sider.';
$string['idnumbercoursecategory'] = 'Kategori-id-nummer';
$string['idnumbercoursecategory_help'] = 'Id-nummeret på en kursuskategori er kun brugt til at matche kategorien med et eksternt system, og vises ikke nogen steder på sitet. Hvis kategorien har et officielt kodenavn, skal det indtastes, hvis ikke, kan feltet forblive tomt.';
$string['idnumbergroup'] = 'Gruppe-id-nummer';
$string['idnumbergroup_help'] = 'Id-nummeret på en gruppe er kun brugt til at matche gruppen med et eksternt system. Det vises ikke nogen steder på sitet. Hvis gruppen har et officielt kodenavn, skal det indtastes, hvis ikke, kan feltet forblive tomt.';
$string['idnumbergrouping'] = 'Grupperings-id-nummer';
$string['idnumbergrouping_help'] = 'Id-nummeret på en gruppering bruges kun til at matche grupperingen med et eksternt system og vises ikke nogen steder på sitet. Hvis grupperingen har et officielt kodenavn kan det indtastes, ellers kan feltet efterlades tomt.';
$string['idnumbermod'] = 'Evt. id-nummer';
$string['idnumbermod_help'] = 'Fastsættelse af et id-nummer giver mulighed for at identificere aktiviteten eller materialet til brug for fx beregning af karakter eller brugerdefinerede rapporter. . Feltet kan evt. efterlades tomt.

Når det gælder aktiviteter der kan gives karakter, kan id-nummeret sættes i karakterbogen, men det kan kun redigeres på aktivitetens indstillingsside.';
$string['idnumbertaken'] = 'Dette id-nummer er allerede i brug';
$string['imagealt'] = 'Billedbeskrivelse';
$string['import'] = 'Importer';
$string['importdata'] = 'Importer kursusdata';
$string['importdataexported'] = 'Eksporterede data fra "fra-kurset" OK<br />
Fortsæt med at importere til "til-kurset".';
$string['importdatafinished'] = 'Import færdig! Fortsæt til kurset';
$string['importdatafrom'] = 'Find et kursus at importere fra:';
$string['inactive'] = 'Inaktiv';
$string['include'] = 'Inkluder';
$string['includeallusers'] = 'Inkluder alle brugere';
$string['includecoursefiles'] = 'Inkluder alle kursusfiler';
$string['includecourseusers'] = 'Inkluder alle kursusdeltagere';
$string['included'] = 'Inkluderet';
$string['includelogentries'] = 'Inkluder logposter';
$string['includemodules'] = 'Inkluder moduler';
$string['includemoduleuserdata'] = 'Inkluder brugerdata fra moduler';
$string['includeneededusers'] = 'Indkluder nødvendige brugere';
$string['includenoneusers'] = 'Inkluder ikke brugere';
$string['includeroleassignments'] = 'Inkluder tildelte roller';
$string['includesitefiles'] = 'Inkluder site-filer brugt på kurset';
$string['includeuserfiles'] = 'Inkluder brugerfiler';
$string['increasesections'] = 'Øg antallet af sektioner';
$string['indicator:accessesafterend'] = 'Kursus tilgået efter slutdatoen';
$string['indicator:accessesafterend_help'] = 'Denne indikator afspejler om studerende har tilgået kurset efter dets slutdato';
$string['indicator:accessesbeforestart'] = 'Kursus tilgået før startdatoen';
$string['indicator:accessesbeforestart_help'] = 'Denne indikator afspejler om studerende har tilgået kurset inden dets startdato';
$string['indicator:activitiesdue'] = 'Forestående aktiviteter';
$string['indicator:activitiesdue_help'] = 'Brugeren har forestående aktiviteter.';
$string['indicator:anycourseaccess'] = 'Enhver kursusadgang';
$string['indicator:anycourseaccess_help'] = 'Denne indikator reflekterer adgang til ethvert kursus brugeren deltager på.';
$string['indicator:anywrite'] = 'Enhver skrivehandling';
$string['indicator:anywrite_help'] = 'Denne indikator repræsenterer enhver (gemt) skrivehandling den studerende har foretaget.';
$string['indicator:anywriteincourse'] = 'Enhver skrivehandling på kurset';
$string['indicator:anywriteincourse_help'] = 'Denne indikator repræsenterer enhver (gemt) skrivehandling den studerende har foretaget i en kursusaktivitet.';
$string['indicator:completeduserprofile'] = 'Brugerprofilen er færdiggjort';
$string['indicator:completeduserprofile_help'] = 'Dette viser at den studerende har færdiggjort sin brugerprofil.';
$string['indicator:completeduserprofiledef'] = 'Brugerprofil færdiggjort';
$string['indicator:completeduserprofiledef_help'] = 'Sitets politikker er blevet accepteret og brugeren har udfyldt disse felter: Institution, Afdeling, Adresse, By, Land, URL.';
$string['indicator:completionenabled'] = 'Sporing af aktiveretsgennemførelse aktiveret';
$string['indicator:completionenabled_help'] = 'Dette viser at sporing af gennemførelse er aktiveret på dette kursus';
$string['indicator:nostudent'] = 'Tilmeldte studerende';
$string['indicator:nostudent_help'] = 'Denne indikator viser om kurset har studerende.';
$string['indicator:noteacher'] = 'Tilknyttede lærere';
$string['indicator:noteacher_help'] = 'Denne indikator viser om kurset har lærere.';
$string['indicator:potentialcognitive'] = 'Kursets potentielle kognitive dybde';
$string['indicator:potentialcognitive_help'] = 'Denne indikator er baseret på den potentielle kognitive dybde der kan opnås af en studerende der deltager i kursusaktiviteter.';
$string['indicator:potentialcognitivedef'] = 'Kursets potentielle kognitive dybde';
$string['indicator:potentialcognitivedef_help'] = 'Den grad med hvilken kurset tilbyder "dyb" kognitiv engagement, for eksempel aflevering af arbejde til feedback, muligheden for at gennemse arbejde udført af andre, og muligheden for at revidere og genaflevere arbejde.';
$string['indicator:potentialsocial'] = 'Potentiel social bredde på kursus';
$string['indicator:potentialsocial_help'] = 'Denne indikator er baseret på den potentielle sociale bredde der kan opnås af en studerende der deltager i kursusaktiviteter.';
$string['indicator:potentialsocialdef'] = 'Potentiel social bredde på kursus';
$string['indicator:potentialsocialdef_help'] = 'Den grad med hvilken kurset tilbyder "bredt" socialt engagement, interagerer med andre deltagere og med fællesskabet i praksis udover klassen.';
$string['indicator:readactions'] = 'Mængde læsehandlinger';
$string['indicator:readactions_help'] = 'Denne indikator repræsenterer antal læsehandlinger (visninger) en studerende har foretaget.';
$string['indicator:userforumstracking'] = 'Brugeren sporer fora';
$string['indicator:userforumstracking_help'] = 'Viser hvorvidt brugeren har aktiveret markering af ulæste indlæg i fora.';
$string['info'] = 'Information';
$string['inprogress'] = 'I gang';
$string['institution'] = 'Institution';
$string['instudentview'] = 'fra den studerendes synsvinkel';
$string['interests'] = 'Interesser';
$string['interestslist'] = 'Interesseliste';
$string['interestslist_help'] = 'Skriv dine interesser adskilt af komma. Dine interesser vil blive vist på din profilside som tags.';
$string['invalidemail'] = 'Ugyldig e-mailadresse';
$string['invalidlogin'] = 'Forkert login, prøv igen';
$string['invalidusername'] = 'Et brugernavn kan kun indeholde tal eller små bogstaver (minuskler), underscore (_), bindestreg (-), punktum (.) eller et snabel-a (@).';
$string['invalidusernameupload'] = 'Ugyldigt brugernavn';
$string['ip_address'] = 'IP-adresse';
$string['jump'] = 'Spring';
$string['jumpto'] = 'Spring til...';
$string['keep'] = 'Behold';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Sprog fra ventre mod højre';
$string['langrtl'] = 'Sprog fra højre mod venstre';
$string['language'] = 'Sprog';
$string['languagegood'] = 'Denne sprogpakke er opdateret! :-)';
$string['languageselector'] = 'Sprogvalg';
$string['last'] = 'Sidste';
$string['lastaccess'] = 'Sidst set';
$string['lastcourseaccess'] = 'Seneste adgang til kurset';
$string['lastedited'] = 'Senest redigeret';
$string['lastip'] = 'Sidste IP adresse';
$string['lastlogin'] = 'Sidste login';
$string['lastmodified'] = 'Senest ændret';
$string['lastname'] = 'Efternavn';
$string['lastnamephonetic'] = 'Efternavn - fonetisk';
$string['lastpage'] = 'Sidste side';
$string['lastsiteaccess'] = 'Sidste adgang til siden';
$string['lastyear'] = 'Sidste år';
$string['latestlanguagepack'] = 'Tjek seneste sprogpakke fra moodle.org';
$string['layouttable'] = 'Layouttabel';
$string['leavetokeep'] = 'Skriv ikke noget i dette felt hvis du vil beholde den nuværende adgangskode';
$string['legacylogginginuse'] = 'På dette websted kan der i øjeblikket skrives til det gamle logfillager. Skrivning til dette logfillager er forældet. Skriv til et understøttet loglager som f.eks. "standard" eller "ekstern".';
$string['legacythemeinuse'] = 'Denne side vises i kompatibilitetstilstand da din browser er for gammel.';
$string['license'] = 'Licens';
$string['licenses'] = 'Licenser';
$string['liketologin'] = 'Ønsker du at logge ind med en brugerkonto?';
$string['list'] = 'Liste';
$string['listfiles'] = 'Liste over filer i {$a}';
$string['listofallpeople'] = 'Liste over alle';
$string['listofcourses'] = 'Liste over kurser';
$string['loading'] = 'Indlæser';
$string['loadinghelp'] = 'Indlæser...';
$string['local'] = 'Lokal';
$string['localplugins'] = 'Lokale plugins';
$string['localpluginsmanage'] = 'Administrer lokale plugins';
$string['location'] = 'Sted';
$string['locktimeout'] = 'Operationen fik timeout under afventning af en lås.';
$string['log_excel_date_format'] = 'åååå mmmm d t:mm';
$string['loggedinas'] = 'Du er logget ind som {$a}';
$string['loggedinasguest'] = 'Du er logget ind som gæst';
$string['loggedinnot'] = 'Du er ikke logget ind';
$string['login'] = 'Log ind';
$string['login_failure_logs'] = 'Logfil over fejllogin';
$string['loginactivity'] = 'Login-aktivitet';
$string['loginagain'] = 'Log ind igen';
$string['loginalready'] = 'Du er allerede logget ind';
$string['loginas'] = 'Log ind som';
$string['loginaspasswordexplain'] = '<p>Du skal skrive et specielt "login-som"-kodeord for at bruge denne funktion.<br />Hvis du ikke kender det kan du prøve at spørge administratoren.</p>';
$string['loginguest'] = 'Log ind som gæst';
$string['loginsite'] = 'Log ind på dette websted';
$string['loginsteps'] = 'For at få fuld adgang til siden, skal du oprette en brugerkonto.';
$string['loginstepsnone'] = '<p>Hej!</p> <p>For at få fuld adgang til kurser er du nødt til at oprette en konto.</p> <p>Det kræver blot at du opretter et brugernavn og en adgangskode til brug her på siden </p> <p>Hvis en anden allerede har brugt dit brugernavn, er du nødt til at prøve igen med et nyt.</p>';
$string['loginto'] = 'Log ind på {$a}';
$string['logoof'] = 'Logo af {$a}';
$string['logout'] = 'Log ud';
$string['logoutconfirm'] = 'Bekræft at du vil logge ud.';
$string['logs'] = 'Logs';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">mere</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">mere</a> ]';
$string['lookback'] = 'Se tilbage';
$string['mailadmins'] = 'Informer administratorer';
$string['mailstudents'] = 'Informer studerende';
$string['mailteachers'] = 'Informer lærere';
$string['maincoursepage'] = 'Kursets forside';
$string['makeafolder'] = 'Opret en mappe';
$string['makeavailable'] = 'Gør tilgængelig';
$string['makeeditable'] = 'Hvis du sørger for at "{$a}" kan redigeres af webserveren (f.eks. apache) så kan du redigere filen direkte fra denne side.';
$string['makethismyhome'] = 'Brug denne side som min startside';
$string['makeunavailable'] = 'Gør utilgængelig';
$string['manageblocks'] = 'Blokke';
$string['managecategories'] = 'Rediger kursuskategorier';
$string['managecategorythis'] = 'Administrer denne kategori';
$string['managecombined'] = 'Rediger kursuskategorier og kurser';
$string['managecontentbanktypes'] = 'Håndter indholdstyper';
$string['managecourses'] = 'Administrer kurser';
$string['managedatabase'] = 'Databaseadministration';
$string['managedataformats'] = 'Administrer dataformater';
$string['manageeditorfiles'] = 'Administrer filer brugt af editoren';
$string['managefilters'] = 'Filtre';
$string['managemodules'] = 'Moduler';
$string['manageroles'] = 'Roller og tilladelser';
$string['markallread'] = 'Marker alle som læst';
$string['markedthistopic'] = 'Dette emne er markeret som det nuværende emne';
$string['markthistopic'] = 'Marker dette emne som det aktuelle';
$string['matchingsearchandrole'] = 'Matcher "{$a->search}" og {$a->role}';
$string['maxareabytesreached'] = 'Filen (eller den totale størrelse af flere filer) er større end den plads der er tilgængelig i dette område.';
$string['maxfilesize'] = 'Maksimal størrelse på nye filer: {$a}';
$string['maxfilesreached'] = 'Du kan vedhæfte op til {$a} fil(er) her';
$string['maximumchars'] = 'Maksimum {$a} tegn';
$string['maximumgrade'] = 'Maksimumkarakter';
$string['maximumgradex'] = 'Højeste karakter: {$a}';
$string['maximumshort'] = 'Maks.';
$string['maximumupload'] = 'Maksimal filstørrelse der kan uploades';
$string['maximumupload_help'] = 'Indstillingen definerer den maksimale filstørrelse, der kan uploades på kurset indenfor den begrænsning der gælder for hele sitet. Det er muligt at begrænse denne filstørrelse yderligere i indstillingerne for hver aktivitet.';
$string['maxnumberweeks'] = 'Maks. antal sektioner';
$string['maxnumberweeks_desc'] = 'Det højest mulige antal sektioner der kan vælges til et kursus (har kun betydning for visse kursusformater).';
$string['maxnumcoursesincombo'] = 'Browse <a href="{$a->link}">{$a->numberofcourses}
kurser</a>.';
$string['maxsectionslimit'] = 'Kan ikke oprette en ny sektion da det ville overskride det tilladte antal sektioner på dette kursus ({$a}).';
$string['maxsize'] = 'Maks. størrelse: {$a}';
$string['maxsizeandareasize'] = 'Maksimal størelse på nye filer: {$a->size}, maksimal grænse: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maksimal størrelse på filer: {$a->size}, højeste antal bilag: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksimal størrelse på nye filer {$a->size}, største antal bilag {$a->attachments}, i alt højest {$a->areasize}';
$string['memberincourse'] = 'Deltagere på kurset';
$string['menu'] = 'Menu';
$string['message'] = 'Besked';
$string['messagebody'] = 'Beskedens indhold';
$string['messagedselectedusers'] = 'De valgte brugere har fået beskeden og modtagerlisten er nulstillet.';
$string['messagedselectedusersfailed'] = 'Der gik desværre noget galt under afsendelsen af beskeder til de valgte brugere. Det kan være at der kun er nogle af dem der har fået beskeden.';
$string['messageprovider:asyncbackupnotification'] = 'Underretninger om asynkron backup/gendannelse';
$string['messageprovider:availableupdate'] = 'Tilgængelige opdateringsmeddelelser';
$string['messageprovider:backup'] = 'Backup-meddelelser';
$string['messageprovider:badgecreatornotice'] = 'Badgeopretter-meddelelser';
$string['messageprovider:badgerecipientnotice'] = 'Badgemodtager-meddelelser';
$string['messageprovider:competencyplancomment'] = 'Kommentar skrevet til en læringsplan';
$string['messageprovider:competencyusercompcomment'] = 'Kommentar skrevet til en kompetence';
$string['messageprovider:coursecompleted'] = 'Kursus færdiggjort';
$string['messageprovider:coursecontentupdated'] = 'Ændringer af kursusindhold';
$string['messageprovider:courserequestapproved'] = 'Underretning om godkendelse af kursusønske';
$string['messageprovider:courserequested'] = 'Underretning om forespørgsel på kursusoprettelse';
$string['messageprovider:courserequestrejected'] = 'Underretning om afslag på kursusoprettelse';
$string['messageprovider:errors'] = 'Vigtige fejl på webstedet';
$string['messageprovider:errors_help'] = 'Der er vigtige fejl som administrator bør kende til.';
$string['messageprovider:gradenotifications'] = 'Karakterunderretninger';
$string['messageprovider:infected'] = 'Meddelelser om fejl i antivirus.';
$string['messageprovider:insights'] = 'Indsigt genereret af forudsigelsesmodeller';
$string['messageprovider:instantmessage'] = 'Personlige beskeder mellem brugere';
$string['messageprovider:instantmessage_help'] = 'I denne sektion sættes indstillingerne for hvad der skal ske med beskeder der sendes direkte til dig fra brugere her på webstedet.';
$string['messageprovider:messagecontactrequests'] = 'Underretning om forespørgsler på kontakt i beskeder';
$string['messageprovider:newlogin'] = 'Meddelelser om nye login';
$string['messageprovider:notices'] = 'Meddelelser om mindre problemer';
$string['messageprovider:notices_help'] = 'Dette er notitser som administrator sikkert er interesseret i at se.';
$string['messageprovider:reportbuilderschedule'] = 'Tidsplaner til brugerdefinerede rapporter';
$string['messageselect'] = 'Vælg denne bruger som e-mailmodtager.';
$string['messageselectadd'] = 'Send besked';
$string['middlename'] = 'Mellemnavn';
$string['migratinggrades'] = 'Overfører karakterer';
$string['min'] = 'min.';
$string['mins'] = 'min.';
$string['minute'] = 'minut';
$string['minutes'] = 'minutter';
$string['miscellaneous'] = 'Diverse';
$string['missingcategory'] = 'Du skal vælge en kategori';
$string['missingdescription'] = 'Mangler beskrivelse';
$string['missingemail'] = 'Mangler e-mailadresse';
$string['missingfirstname'] = 'Mangler fornavn';
$string['missingfromdisk'] = 'Mangler på disken';
$string['missingfullname'] = 'Mangler fulde navn';
$string['missinglastname'] = 'Mangler efternavn';
$string['missingname'] = 'Mangler navn';
$string['missingnewpassword'] = 'Mangler ny adgangskode';
$string['missingpassword'] = 'Mangler adgangskode';
$string['missingrecaptchachallengefield'] = 'ReCAPTCHA-en mislykkedes, prøv igen.';
$string['missingreqreason'] = 'Mangler begrundelse';
$string['missingshortname'] = 'Mangler kort navn';
$string['missingshortsitename'] = 'Mangler kort sitenavn';
$string['missingsitedescription'] = 'Mangler sitebeskrivelse';
$string['missingsitename'] = 'Mangler sitenavn';
$string['missingstrings'] = 'Tjek for linjer der mangler';
$string['missingstudent'] = 'Du skal vælge noget';
$string['missingsummary'] = 'Mangler beskrivelse';
$string['missingteacher'] = 'Du skal vælge noget';
$string['missingurl'] = 'Mangler URL';
$string['missingusername'] = 'Mangler brugernavn';
$string['moddoesnotsupporttype'] = 'Modulet {$a->modname} understøtter ikke upload af typen {$a->type}';
$string['modhide'] = 'Skjul';
$string['modified'] = 'Ændret';
$string['modshow'] = 'Vis';
$string['moduleintro'] = 'Beskrivelse';
$string['modulesetup'] = 'Sætter modultabeller op';
$string['modulesuccess'] = '{$a} tabeller er sat op';
$string['modulesused'] = 'Moduler brugt';
$string['modvisible'] = 'Synlighed';
$string['modvisible_help'] = 'Er "Vis på kursets forside" valgt, er aktiviteten eller materialet tilgængeligt for studerende (underlagt eventuelle betingelser for adgang).

Er "Skjul for studerende" valgt, er aktiviteten eller materialet kun tilgængeligt for brugere med tilladelse til at se skjulte aktiviteter (som standard lærere og medundervisere).';
$string['modvisiblehiddensection'] = 'Tilgængelighed';
$string['modvisiblehiddensection_help'] = 'Er adgangen sat til "Skjul for studerende", er aktiviteten eller materialet kun tilgængeligt for brugere med beføjelse til at se skjulte aktiviteter (som standard lærere og medundervisere).

Indeholder kurset mange aktiviteter og materialer, kan kursussiden forenkles ved at sætte synligheden til "Tilgængelig men vis ikke på kursets forside". I stedet skal der manuelt oprettes et link til materialet et andet sted fra, for eksempel fra en webside. Aktiviteten vil stadig være opført i karakterbogen.';
$string['modvisiblewithstealth'] = 'Tilgængelighed';
$string['modvisiblewithstealth_help'] = 'Er "Vis på kursets forside" valgt, er aktiviteten eller materialet tilgængeligt for studerende (underlagt eventuelle betingelser for adgang).

Er "Skjul for studerende" valgt, er aktiviteten eller materialet kun tilgængeligt for brugere med tilladelse til at se skjulte aktiviteter (som standard lærere og medundervisere).

Indeholder kurset mange aktiviteter eller materialer, kan kursussiden forenkles ved at vælge "Tilgængelig men vis ikke på kursets forside". I stedet skal der manuelt oprettes et link til materialet et andet sted fra, for eksempel fra en webside. Aktiviteten vil stadig være opført i karakterbogen og i rapporter.';
$string['month'] = 'Måned';
$string['months'] = 'Måneder';
$string['moodledocs'] = 'Moodles Dokumentation';
$string['moodledocslink'] = 'Hjælp og dokumentation';
$string['moodlelogo'] = 'Moodlelogo';
$string['moodlerelease'] = 'Moodleudgivelse';
$string['moodleservicesandsupport'] = 'Moodle hjælpeartikler (på engelsk)';
$string['moodleversion'] = 'Moodleversion';
$string['more'] = 'mere';
$string['moreactions'] = 'Flere funktioner';
$string['morehelp'] = '<abbr title="på docs.moodle.org">Mere hjælp</abbr>';
$string['morehelpaboutmodule'] = 'Mere hjælp til aktiviteten {$a}';
$string['moreinfo'] = 'Mere information';
$string['moreinformation'] = 'Mere information om denne fejl';
$string['moremenu'] = 'Mere';
$string['morenavigationlinks'] = 'Mere...';
$string['moreprofileinfoneeded'] = 'Vær venlig at fortælle lidt mere om dig selv';
$string['mostrecently'] = 'sidste';
$string['move'] = 'Flyt';
$string['movecategoriessuccess'] = 'Flyttede {$a->count} kategorier ind i kategorien "{$a->to}"';
$string['movecategoriestotopsuccess'] = 'Flyttede {$a->count} kategorier til topniveau';
$string['movecategorycontentto'] = 'Flyt info';
$string['movecategorysuccess'] = 'Flyttede kategorien "{$a->moved}" ind i kategori "{$a->to}"';
$string['movecategoryto'] = 'Flyt kategori til:';
$string['movecategorytotopsuccess'] = 'Flyttede kategori \'{$a->moved}\' til topniveau';
$string['movecontent'] = 'Flyt {$a}';
$string['movecontentafter'] = 'Efter "{$a}"';
$string['movecontentstoanothercategory'] = 'Flyt indholdet til en anden kategori';
$string['movecontenttothetop'] = 'Til toppen af listen';
$string['movecoursemodule'] = 'Flyt materiale';
$string['movecoursesection'] = 'Flyt sektion';
$string['movecourseto'] = 'Flyt kurset til:';
$string['movedown'] = 'Flyt ned';
$string['movefilestohere'] = 'Flyt filer hertil';
$string['movefull'] = 'Flyt {$a} til denne plads';
$string['movehere'] = 'Flyt hertil';
$string['moveleft'] = 'Flyt til venstre';
$string['moveright'] = 'Flyt til højre';
$string['movesection'] = 'Flyt sektion {$a}';
$string['moveselectedcategoriesto'] = 'Flyt valgte kategorier til';
$string['moveselectedcoursesto'] = 'Flyt det valgte kursus til...';
$string['movetoanotherfolder'] = 'Flyt til en anden mappe';
$string['moveup'] = 'Flyt op';
$string['msnid'] = 'MSN-id';
$string['mustchangepassword'] = 'Den nye adgangskode skal være forskellig fra den nuværende.';
$string['mustconfirm'] = 'Du skal bekræfte din konto';
$string['mycourses'] = 'Mine kurser';
$string['myfiles'] = 'Mine private filer';
$string['myfilesmanage'] = 'Administrer mine private filer';
$string['myhome'] = 'Betjeningspanel';
$string['mymoodledashboard'] = 'Mit Moodlebetjeningspanel';
$string['myprofile'] = 'Min profil';
$string['name'] = 'Navn';
$string['namedfiletoolarge'] = 'Filen "{$a->filename}" er for stor og kan ikke uploades';
$string['nameforlink'] = 'Hvad vil du kalde dette link?';
$string['nameforpage'] = 'Navn';
$string['navigation'] = 'Navigation';
$string['needed'] = 'Nødvendigt';
$string['networkdropped'] = 'Vi har opdaget at din internetforbindelise er ustabil eller er blevet afbrudt. <br /> Vær opmærksom på at ændringer måske ikke bliver gemt ordentligt før forbindelsen bliver bedre.';
$string['never'] = 'Aldrig';
$string['neverdeletelogs'] = 'Slet aldrig logfiler';
$string['new'] = 'Ny';
$string['newaccount'] = 'Ny konto';
$string['newactivityname'] = 'Nyt navn på aktiviteten {$a}';
$string['newcourse'] = 'Nyt kursus';
$string['newloginnotificationbodyfull'] = '<p>Hej {$a->userfullname},</p>
<p>Din {$a->sitename}-konto er lige blevet logget ind fra en ny enhed.</p>
<ul>
<li>Din konto: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Device: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Hvis det var dig, behøver du ikke gøre noget.</p>
<p>Hvis du ikke genkender denne aktivitet, bedes du <a href="{$a->changepasswordlink}">ændre din adgangskode</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Der er lige logget ind på din {$a}-konto fra en ny enhed.';
$string['newloginnotificationtitle'] = 'Nyt log ind på din {$a}-konto';
$string['newpassword'] = 'Ny adgangskode';
$string['newpassword_help'] = 'Hvis du vil beholde den nuværende kode, skal du ikke skrive noget her.';
$string['newpasswordfromlost'] = '<strong>OBS:</strong> Din <strong>nuværende adgangskode</strong> er sendt til dig i den <strong>anden</strong> af de to e-mails der er en del af glemt-adgangskode-processen. Vær sikker på at du har fået din nye adgangskode før du fortsætter med denne side.';
$string['newpasswordtext'] = 'Hej {$a->firstname}

Din adgangskode til "{$a->sitename}" er ændret og du har fået en ny midlertidig kode.

Dine logindata er nu:
   brugernavn: {$a->username}
   adgangskode: {$a->newpassword}.

På denne side kan du ændre koden til en der er lettere at huske:
   {$a->link}.

I de fleste mailprogrammer kommer det op som et blåt link, som du kan klikke på. Hvis det ikke virker, kan du kopiere og indsætte URL\'en i adressefeltet i toppen af din browser.

Hilsen administrator af "{$a->sitename}"

{$a->signoff}';
$string['newpicture'] = 'Nyt billede';
$string['newpicture_help'] = 'Tilføj et nyt billede ved at finde og vælge et på computeren (i JPG- eller PNG-format) og derpå klikke på "Opdater profil". Billedet vil blive beskåret og tilpasset til en kvadrat på 100x100 pixel.';
$string['newpictureusernotsetup'] = 'Et profilbillede kan først tilføjes når alle obligatoriske profilinformationer er gemt.';
$string['newsectionname'] = 'Nyt navn til sektionen {$a}';
$string['newsitem'] = 'nyhed';
$string['newsitems'] = 'meddelelser';
$string['newsitemsnumber'] = 'Antal meddelelser';
$string['newsitemsnumber_help'] = 'Meddelelsesforummet er et specielt forum som oprettes automatisk på et kursus, har tvungen abonnement som udgangspunkt og kun brugere med tilladelse til det (som udgangspunkt lærere), kan skrive i det.

Indstillingen styrer hvor mange af de seneste indlæg der vises i meddelelsesblokken.

Hvis ikke meddelelsesforummet skal bruges, skal denne indstilling være nul.';
$string['newuser'] = 'Ny bruger';
$string['newusernewpasswordsubj'] = 'Ny brugerkonto';
$string['newusernewpasswordtext'] = 'Kære {$a->firstname}

Der er blevet oprettet en ny konto til dig på "{$a->sitename}" og du har fået tildelt en midlertidig adgangskode.

De nuværende loginoplysninger er:
   brugernavn: {$a->username}
   adgangskode: {$a->newpassword}
      (du vil blive bedt om at ændre koden første gang du logger ind).

Du kan begynde at bruge "{$a->sitename}" når du logger ind på siden
   {$a->link}

I de fleste mailprogrammer vises overstående link med blåt, der indikerer at du kan følge det ved at klikke på det. Hvis det ikke virker, kan du kopiere det over i adressefeltet i din browser.

Med venlig hilsen fra administrator af "{$a->sitename}"
{$a->signoff}';
$string['newusers'] = 'Nye brugere';
$string['newwindow'] = 'Nyt vindue';
$string['next'] = 'Næste';
$string['nextpage'] = 'Næste side';
$string['nextsection'] = 'Næste sektion';
$string['no'] = 'Nej';
$string['noblockstoaddhere'] = 'Der er ingen blokke du kan føje til denne side.';
$string['nobody'] = 'Ingen';
$string['nochange'] = 'Ingen ændring';
$string['nocomments'] = 'Ingen kommentarer';
$string['nocourses'] = 'Ingen kurser';
$string['nocoursesfound'] = 'Der blev ikke fundet nogen kurser med ordene "{$a}"';
$string['nocoursestarttime'] = 'Kurset har ingen startdato.';
$string['nocoursesyet'] = 'Der er ingen kurser i denne kategori';
$string['nodstpresets'] = 'Administratoren har ikke aktiveret understøttelse af sommertid.';
$string['nofilesselected'] = 'Der er ikke valgt nogen filer der skal genskabes';
$string['nofilesyet'] = 'Der er endnu ikke uploadet filer på dit kursus';
$string['nofiltersapplied'] = 'Ingen filtre anvendt';
$string['nograde'] = 'Ingen karakter';
$string['nohelpforactivityorresource'] = 'Der er i øjeblikket ingen hjælp til dette materiale eller denne aktivitet';
$string['noimagesyet'] = 'Der er endnu ikke uploadet billeder på dit kursus';
$string['nologsfound'] = 'Der blev ikke fundet nogen log';
$string['nomatchingusers'] = 'Ingen brugere matcher "{$a}"';
$string['nomorecourses'] = 'Der er ikke fundet flere matchende kurser';
$string['nomoreidnumber'] = 'Benytter ikke id-numre for at undgå sammenfald';
$string['none'] = 'Ingen';
$string['noneditingteacher'] = 'Medunderviser';
$string['noneditingteacherdescription'] = 'Medundervisere kan undervise på et kursus og bedømme studerende, men kan ikke ændre aktiviteterne.';
$string['nonstandard'] = 'Ikke-standard';
$string['nopendingcourses'] = 'Ingen kurser afventer godkendelse';
$string['nopotentialadmins'] = 'Ingen potentielle administratorer';
$string['nopotentialcreators'] = 'Der er ingen potentielle kursusadministratorer';
$string['nopotentialstudents'] = 'Ingen potentielle studerende';
$string['nopotentialteachers'] = 'Ingen potentielle lærere';
$string['norecentactivity'] = 'Ingen aktivitet for nylig';
$string['noreplybouncemessage'] = 'Du har skrevet til en noreply-adresse. Hvis du forsøgte at svare på et forumindlæg, så benyt i stedet forummet {$a}. Nedenfor kan du se indholdet af din mail:';
$string['noreplybouncesubject'] = '{$a} - afvist e-mail.';
$string['noreplyname'] = 'Svar ikke på denne e-mail';
$string['noresetrecord'] = 'Anmodningen om nulstilling af adgangskode er ikke registreret. Start en ny anmodning om nulstilling af adgangskode.';
$string['noresults'] = 'Ingen resultater';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Normal søgning';
$string['nosite'] = 'Kunne ikke finde forsidekurset';
$string['nostudentsfound'] = '{$a} ikke fundet';
$string['nostudentsingroup'] = 'Der er ingen studerende i denne gruppe endnu';
$string['nostudentsyet'] = 'Der er ikke tilmeldt nogen studerende på dette kursus.';
$string['nosuchemail'] = 'E-mailadressen eksisterer ikke';
$string['notavailable'] = 'Ikke tilgængelig';
$string['notavailablecourse'] = '{$a} er ikke tilgængelig';
$string['noteachersyet'] = 'Ingen lærere endnu';
$string['noteachingupcomingcourses'] = 'Næstkommende kurser har ingen lærere eller studerende';
$string['notenrolled'] = '{$a} deltager ikke på dette kursus.';
$string['notenrolledprofile'] = 'Denne profil er ikke tilgængelig da brugeren ikke er tilmeldt dette kursus.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Bemærk:</strong> Genberegning af datoer når der genetableres sikkerhedskopi er blevet deaktiveret fordi du mangler de krævede tilladelser.';
$string['noteuserschangednonetocourse'] = '<strong>Bemærk</strong> Kursusdeltagere skal opdateres når kurset genoprettes. Denne indstilling er rettet for dig.';
$string['nothingnew'] = 'Intet nyt siden dit sidste besøg.';
$string['nothingtodisplay'] = 'Ingenting at vise';
$string['notice'] = 'Bemærk';
$string['noticenewerbackup'] = 'Denne backupfil er lavet med Moodle {$a->backuprelease} ({$a->backupversion}). Den er nyere end den nuværende installation af Moodle {$a->serverrelease} ({$a->serverversion}). Dette kan medføre nogle fejl da backupfilerne ikke med garanti er bagudkompatible.';
$string['notifications'] = 'Beskeder';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, bruger: {$a->info}, fulde navn: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Du kan se loggen på {$a}';
$string['notifyloginfailuresmessagestart'] = 'Her er en liste over mislykkede loginforsøg {$a} siden du sidst blev underrettet om det.';
$string['notifyloginfailuressubject'] = '{$a} :: Underretning om forkerte loginforsøg';
$string['notincluded'] = 'Ikke inkluderet';
$string['notingroup'] = 'Desværre! Du skal være med i en gruppe for at se denne side.';
$string['notpublic'] = 'Ikke offentligt';
$string['nousersfound'] = 'Ingen brugere fundet';
$string['nousersmatching'] = 'Ingen passende "{$a}" blev fundet';
$string['nousersyet'] = 'Ingen brugere endnu';
$string['novalidcourses'] = 'Der er ingen gyldige kurser at vise';
$string['now'] = 'nu';
$string['numattempts'] = '{$a} mislykkede loginforsøg';
$string['numberofcourses'] = 'Antal kurser';
$string['numberweeks'] = 'Antal sektioner';
$string['numday'] = '{$a} dag.';
$string['numdays'] = '{$a} dage';
$string['numhours'] = '{$a} timer';
$string['numletters'] = '{$a} bogstaver';
$string['numminutes'] = '{$a} minutter';
$string['nummonth'] = '{$a} måned';
$string['nummonths'] = '{$a} måneder';
$string['numseconds'] = '{$a} sekunder';
$string['numviews'] = 'set {$a} gange';
$string['numweek'] = '{$a} uge';
$string['numweeks'] = '{$a} uger';
$string['numwords'] = '{$a} ord';
$string['numyear'] = '{$a} år';
$string['numyears'] = '{$a} år';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Nuværende adgangskode';
$string['olduserdirectory'] = 'Dette er den GAMLE brugermappe og den bruges ikke længere. Du kan roligt slette den. Filerne er kopieret til den NYE brugermappe.';
$string['opendrawerblocks'] = 'Åbn blok-skuffe';
$string['opendrawerindex'] = 'Åbn kursusindeks';
$string['opensinnewwindow'] = 'Åbner i nyt vindue';
$string['optional'] = 'valgfrit';
$string['options'] = 'Indstillinger';
$string['order'] = 'Rækkefølge';
$string['originalpath'] = 'Orginal sti';
$string['orphanedactivitiesinsectionno'] = 'Hjemløse aktiviteter (sektion {$a})̣';
$string['other'] = 'Andre';
$string['outline'] = 'Beskrivelse';
$string['outlinereport'] = 'Oversigtsrapport';
$string['page'] = 'Side';
$string['pagea'] = 'Side {$a}';
$string['pagedcontentnavigation'] = 'Sideopdelt navigation';
$string['pagedcontentnavigationactiveitem'] = 'Aktuel side, side {$a}';
$string['pagedcontentnavigationitem'] = 'Gå til side {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Vis {$a} elementer per side';
$string['pageheaderconfigablock'] = 'Konfigurerer en blok i {$a->fullname}';
$string['pagepath'] = 'Sidesti';
$string['pageshouldredirect'] = 'Denne side skulle automatisk viderestille. Gør den ikke det, kan du klikke på linket herunder.';
$string['parentcategory'] = 'Overordnet kategori';
$string['parentcoursenotfound'] = 'Overordnet kursus ikke fundet!';
$string['parentfolder'] = 'Overliggende mappe';
$string['participants'] = 'Deltagere';
$string['participantscount'] = 'Antal deltagere: {$a}';
$string['participantslist'] = 'Deltagerliste';
$string['participationratio'] = 'Deltagerforhold';
$string['participationreport'] = 'Deltagerrapport';
$string['password'] = 'Adgangskode';
$string['passwordchanged'] = 'Adgangskoden er ændret';
$string['passwordconfirmchange'] = 'Bekræft ændring af adgangskode';
$string['passwordextlink'] = 'Det følgende link er beregnet til at generere en ny adgangskode, hvis du har glemt den gamle. Linket vil bringe dig væk fra Moodle.';
$string['passwordforgotten'] = 'Glemt adgangskode';
$string['passwordforgotteninstructions'] = 'Din profil skal først findes i brugerdatabasen. Skriv <strong>enten</strong> dit brugernavn <strong>eller</strong> din e-mailadresse i det rigtige felt. Du behøver ikke skrive dem begge.';
$string['passwordforgotteninstructions2'] = 'Skriv dit brugernavn eller din e-mailadresse nedenfor hvis du skal have ny adgangskode. Hvis vi kan finde dig i databasen, vil en mail blive sendt til din e-mailadresse med instruktioner om, hvordan du får adgang igen.';
$string['passwordnohelp'] = 'Der er ingen hjælp til at finde din glemte adgangskode. Kontakt din administrator.';
$string['passwordpolicynomatch'] = 'Din nuværende adgangskode overholder ikke længere den gældende adgangskodepolitik.
   {$a}';
$string['passwordrecovery'] = 'Ja, hjælp mig med at logge ind';
$string['passwordsdiffer'] = 'Disse koder matcher ikke';
$string['passwordsent'] = 'Adgangskoden er sendt';
$string['passwordsenttext'] = '<p>Der er sendt en e-mail til {$a->email}.</p> <p><b>Den indeholder din nye adgangskode</b></p> <p>Den nye adgangskode er genereret automatisk, så du vil måske <a href="={$a->link}">ændre den til noget, som du nemmere kan huske</a>.</p>';
$string['passwordset'] = 'Din adgangskode er blevet oprettet';
$string['path'] = 'Sti';
$string['pathnotexists'] = 'Stien eksisterer ikke på serveren';
$string['pathslasherror'] = 'Stien må ikke ende med en skråstreg!!';
$string['paymentinstant'] = 'Brug knappen forneden til at betale og blive tilmeldt umiddelbart derefter.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> afventer</small>)';
$string['paymentrequired'] = 'Dette kursus kræver betaling for tilmelding.';
$string['payments'] = 'Betaling';
$string['paymentsorry'] = 'Tak for betalingen. Desværre er din betaling ikke blevet færdigbehandlet, og du er derfor ikke tilmeldt kurset "{$a->fullname}". Prøv igen om 5-10 sekunder. Hvis det ikke hjælper, så kontakt {$a->teacher} eller administratoren.';
$string['paymentthanks'] = 'Tak for din betaling. Du er nu tilmeldt kurset: <b />"{$a}"';
$string['pendingrequests'] = 'Afventende anmodninger';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Perioden slutter ({$a})';
$string['perpage'] = 'Per side';
$string['perpagea'] = 'Per side: {$a}';
$string['personal'] = 'Personlig';
$string['personalprofile'] = 'Personlig profil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobil';
$string['phpinfo'] = 'PHP-info';
$string['pictureof'] = 'Billede af {$a}';
$string['pictureofuser'] = 'Brugerbillede';
$string['pleaseclose'] = 'Luk dette vindue nu.';
$string['pleasesearchmore'] = 'Søg noget mere';
$string['pleaseusesearch'] = 'Brug søgefunktionen';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Tjekker plugins';
$string['plugindeletefiles'] = 'Alle data i forbindelse med plugin\'et "{$a->name}" er blevet slettet fra databasen. For at forhindre plugin\'et i at geninstallere sig selv, bør du nu slette denne mappe fra din server: {$a->directory}';
$string['pluginsetup'] = 'Indsætter tabeller til plugins';
$string['policyaccept'] = 'Jeg forstår og er enig';
$string['policyagree'] = 'Du må acceptere disse retningslinjer for at benytte dette site.
Accepterer du?';
$string['policyagreement'] = 'Retningslinjer for brug af webstedet';
$string['policyagreementclick'] = 'Link til retningslinjer for brug af webstedet';
$string['popup'] = 'pop op';
$string['popupwindow'] = 'Åbn fil i nyt vindue';
$string['popupwindowname'] = 'Pop op-vindue';
$string['post'] = 'Indlæg';
$string['posts'] = 'Indlæg';
$string['potentialadmins'] = 'Potentielle administratorer';
$string['potentialcreators'] = 'Potentielle kursusadministratorer';
$string['potentialstudents'] = 'Potentielle studerende';
$string['potentialteachers'] = 'Potentielle lærere';
$string['poweredbymoodle'] = 'Drevet af <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Indstillinger';
$string['preferredlanguage'] = 'Vælg sprog';
$string['preferredtheme'] = 'Foretrukket layout';
$string['preprocessingbackupfile'] = 'Forbereder backupfil';
$string['prev'] = 'Forrige';
$string['preview'] = 'Afprøv';
$string['previeworchoose'] = 'Afprøv eller vælg et layout';
$string['previous'] = 'Forrige';
$string['previouslyselectedusers'] = 'Tidligere valgte brugere, der ikke matcher "{$a}"';
$string['previouspage'] = 'Forrige side';
$string['previoussection'] = 'Forrige sektion';
$string['primaryadminsetup'] = 'Opret administratorkonto';
$string['privacy:metadata:config_log'] = 'Konfigurationsloggen ændres.';
$string['privacy:metadata:config_log:name'] = 'Navnet på indstillingen ændres';
$string['privacy:metadata:config_log:oldvalue'] = 'Den tidligere værdi for denne indstilling.';
$string['privacy:metadata:config_log:plugin'] = 'Pluginnet er blevet ændret.';
$string['privacy:metadata:config_log:timemodified'] = 'Det tidspunkt, hvor ændringen blev foretaget';
$string['privacy:metadata:config_log:userid'] = 'Brugeren, der foretog ændringen';
$string['privacy:metadata:config_log:value'] = 'Den nye værdi for denne indstilling.';
$string['privacy:metadata:events_queue'] = 'Køen af brugerhændelser, der venter på at blive behandlet';
$string['privacy:metadata:events_queue:eventdata'] = 'De data, der er gemt i begivenheden';
$string['privacy:metadata:events_queue:stackdump'] = 'Enhver stacktrace forbundet med denne begivenhed';
$string['privacy:metadata:events_queue:timecreated'] = 'Det tidspunkt, hvor denne begivenhed blev oprettet';
$string['privacy:metadata:events_queue:userid'] = 'Det bruger-id, der er knyttet til denne hændelse';
$string['privacy:metadata:log'] = 'En samling af tidligere begivenheder';
$string['privacy:metadata:log:action'] = 'En beskrivelse af handlingen';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kursus';
$string['privacy:metadata:log:info'] = 'Yderligere Information';
$string['privacy:metadata:log:ip'] = 'Den IP-adresse, der blev brugt på tidspunktet for begivenheden';
$string['privacy:metadata:log:module'] = 'modul';
$string['privacy:metadata:log:time'] = 'Det tidspunkt, hvor handlingen fandt sted';
$string['privacy:metadata:log:url'] = 'URL\'en relateret til begivenheden';
$string['privacy:metadata:log:userid'] = 'ID\'et på den bruger, der udførte handlingen';
$string['privacy:metadata:oauth2_refresh_token'] = 'Opdater token brugt i OAuth 2.0-kommunikation';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID\'et for den udsteder, som tokenet svarer til';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID\'et på den bruger, som tokenet svarer til';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Det tidspunkt, hvor tokenet blev oprettet';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Det tidspunkt, hvor tokenet sidst blev opdateret';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Opdateringstokenet for de respektive scopes og bruger';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID\'et på den bruger, som tokenet svarer til';
$string['privacy:metadata:task_adhoc'] = 'Status for ad hoc-opgaver.';
$string['privacy:metadata:task_adhoc:component'] = 'Komponenten, der ejer opgaven.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Hvornår denne opgave tidligst kan køres.';
$string['privacy:metadata:task_adhoc:userid'] = 'Brugeren som skal køre opgaven';
$string['privacy:metadata:task_log'] = 'Log output for en log';
$string['privacy:metadata:task_log:component'] = 'Komponenten, der ejer opgaven.';
$string['privacy:metadata:task_log:userid'] = 'Brugeren som opgaven tilhørte.';
$string['privacy:metadata:upgrade_log'] = 'Opgraderingsloggen.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Enhver backtrace forbundet med dette opgraderingstrin.';
$string['privacy:metadata:upgrade_log:details'] = 'Ekstra information vedrørende opgraderingen.';
$string['privacy:metadata:upgrade_log:info'] = 'De vigtigste oplysninger for dette opgraderingstrin.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Det plugin, der blev opgraderet.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Den nye version der skal opgraderes til.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Det tidspunkt, hvor opgraderingen fandt sted.';
$string['privacy:metadata:upgrade_log:type'] = 'Typen af logindtastning.';
$string['privacy:metadata:upgrade_log:userid'] = 'Brugeren, der kørte opgraderingen.';
$string['privacy:metadata:upgrade_log:version'] = 'Den gamle version af plugin.';
$string['private_files_handler'] = 'Gem vedhæftninger til e-mail i brugerens private filområde.';
$string['private_files_handler_name'] = 'E-mail til private filer';
$string['privatefiles'] = 'Private filer';
$string['privatefilesmanage'] = 'Administrer private filer';
$string['proceed'] = 'Fortsæt';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Denne profilbeskrivelse vises først når personen er tilmeldt mindst et kursus.';
$string['publicprofile'] = 'Offentlig profil';
$string['publicsitefileswarning'] = 'Bemærk: Filer placeret her kan tilgås af alle';
$string['publicsitefileswarning2'] = 'Bemærk: Filer der ses her, kan tilgås af enhver der kender (eller gætter) URL\'en. Af sikkerhedsmæssige årsager anbefales det at alle backupfiler slettes efter de er gendannet.';
$string['publicsitefileswarning3'] = 'Bemærk: Filer, der lægges her, kan ses af alle med kendskab til (eller som kan gætte) denne URL. Af sikkerhedsmæssige hensyn skal backupfiler gemmes i den sikrede mappe til backupdata.';
$string['question'] = 'Spørgsmål';
$string['questionsinthequestionbank'] = 'Spørgsmål i spørgsmålsbanken';
$string['queued'] = 'Sat i kø';
$string['quotausage'] = 'Du har nu brugt {$a->used} af din grænse på {$a->total}.';
$string['readinginfofrombackup'] = 'Læser info fra backup';
$string['readme'] = 'LÆSMIG';
$string['recentactivity'] = 'Seneste aktiviteter';
$string['recentactivityreport'] = 'Komplet rapport af seneste aktiviteter...';
$string['recipientslist'] = 'Modtagerliste {$a}';
$string['recommended'] = 'Anbefalet';
$string['recreatedcategory'] = 'Genskabt kategori {$a}';
$string['redirect'] = 'Viderestil';
$string['reducesections'] = 'Reducer antallet af sektioner';
$string['refresh'] = 'Genindlæs';
$string['refreshingevents'] = 'Opdaterer begivenheder';
$string['registration'] = 'Moodleregistrering';
$string['registrationcontact'] = 'Kontakt fra andre';
$string['registrationcontactno'] = 'Nej, jeg ønsker ikke at blive kontaktet af andre';
$string['registrationcontactyes'] = 'Ja, opret en kontaktformular så andre moodlere kan kontakte mig';
$string['registrationemail'] = 'E-mailmeddelelser';
$string['registrationinfo'] = '<p>På denne side kan du registrere din Moodle hos moodle.org. Registreringen er gratis. Hovedformålet med registreringen er, at du vil blive tilføjet en sjældent brugt mailingliste der bruges til vigtige informationer såsom sikkerhedshuller og nye versioner af Moodle.</p> <p>Som standard vil dine informationer blive hemmeligholdt, og aldrig solgt eller givet videre til nogen anden. Den eneste årsag til at opsamle denne information er udelukkende til at opbygge et statistisk billede af Moodles udbredelse globalt set.</p> <p>Hvis du ønsker det, kan du tillade at dit websteds navn, land og URL bliver tilføjet en frit tilgængelig liste af Moodlesites på moodle.org.</p>
<p>Alle nye registreringer er verificeret manuelt før de bliver tilføjet listen, men er du een gang blevet tilføjet kan du altid opdatere din registrering (og dine data på listen) ved at sende registreringen igen.</p>';
$string['registrationinfotitle'] = 'Registreringsinformation';
$string['registrationno'] = 'Nej, jeg ønsker ikke at modtage nogen mails';
$string['registrationsend'] = 'Send registreringsinformation til moodle.org';
$string['registrationyes'] = 'Ja, jeg vil gerne modtage underretninger om nye versioner af Moodle, sikkerhedsadvarsler og andre vigtige nyheder';
$string['reject'] = 'Afvis';
$string['rejectdots'] = 'Afvis...';
$string['relativedatesmode'] = 'Tilstand med relative datoer';
$string['relativedatesmode_help'] = 'Vis kursus- eller aktivitetsdatoer relativt til brugerens startdato på kurset.

Brugerens kursusstart vil være tilmeldingsdagen - med mindre den ligger før kursets start, i så fald bruges kursets startdato.

ADVARSEL: Dette er en eksperimentel funktion og det er ikke sikkert at den kan bruges til alle aktiviteter. Så snart kurset er oprettet, kan denne indstilling ikke længere ændres.';
$string['relativedatesmode_warning'] = '<strong>Advarsel:</strong>Tilstanden med relative datoer kan ikke ændres efter at kurset er oprettet.';
$string['reload'] = 'Genindlæs';
$string['remoteappuser'] = 'Ekstern {$a} bruger';
$string['remove'] = 'Fjern';
$string['removeadmin'] = 'Fjern administrator';
$string['removecreator'] = 'Fjern kursusadministrator';
$string['removestudent'] = 'Fjern studerende';
$string['removeteacher'] = 'Fjern lærer';
$string['rename'] = 'Omdøb';
$string['renamefileto'] = 'Omdøb <b>{$a}</b> til';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporter';
$string['reporttype'] = 'Rapporttype';
$string['repositories'] = 'Arkiver';
$string['requestcourse'] = 'Anmod om et nyt kursus';
$string['requestedby'] = 'Anmodet af';
$string['requestedcourses'] = 'Efterspurgte kurser';
$string['requestreason'] = 'Din motivation for at anmode om et nyt kursus';
$string['requests'] = 'Anmodninger';
$string['required'] = 'Påkrævet';
$string['requirespayment'] = 'Dette kursus kræver betaling for deltagelse';
$string['resendemail'] = 'Gensend mail';
$string['reset'] = 'Nulstil';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Nulstil kurset';
$string['resetinfo'] = 'På denne side kan du fjerne brugerdata fra kurset, mens aktiviteter, materialer og andre indstillinger vil blive bibeholdt. Vær især opmærksom på, at når du vælger emner herunder og nulstiller, vil de valgte brugerdata blive slettet fra kurset for altid!';
$string['resetnotimplemented'] = 'Nulstilling er ikke implementeret';
$string['resetrecordexpired'] = 'Det link du brugte til ændring af adgangskode, er mere end {$a} minutter gammelt og er udløbet. Anmod om en ny nulstilling af adgangskode.';
$string['resetstartdate'] = 'Nulstil startdatoen';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Nulstil tabelindstillinger';
$string['resettask'] = 'Opgave';
$string['resettodefaults'] = 'Nulstil til standard';
$string['resortcourses'] = 'Sorter kurser';
$string['resortsubcategoriesby'] = 'Sorter underkategorier efter {$a} stigende';
$string['resortsubcategoriesbyreverse'] = 'Sorter underkategorier efter {$a} faldende';
$string['resource'] = 'Materiale';
$string['resourcedisplayauto'] = 'Automatisk';
$string['resourcedisplaydownload'] = 'Tvungen download';
$string['resourcedisplayembed'] = 'Indlejret';
$string['resourcedisplayframe'] = 'I frame';
$string['resourcedisplaynew'] = 'Nyt vindue';
$string['resourcedisplayopen'] = 'Åben';
$string['resourcedisplaypopup'] = 'I pop op';
$string['resources'] = 'Materialer';
$string['resources_help'] = 'Materialetyper gør det muligt at indsætte næsten enhver form for webindhold på kurset.';
$string['restore'] = 'Gendan';
$string['restorecancelled'] = 'Gendannelse annulleret';
$string['restorecannotassignroles'] = 'Gendannelsesfunktionen har brug for at tildele roller, og det har du ikke tilladelse til';
$string['restorecannotcreateorassignroles'] = 'Gendannelsesfunktionen har brug for at oprette eller tildele roller, og det har du ikke tilladelse til';
$string['restorecannotcreateuser'] = 'Gendannelsesfunktionen skal have oprettet en bruger, {$a}, fra backupfilen, og det du har ikke tilladelse til';
$string['restorecannotoverrideperms'] = 'Gendannelsesfunktionen har behov for at overskrive tilladelser, og det har du ikke tilladelse til';
$string['restorecoursenow'] = 'Gendan dette kursus nu!';
$string['restoredaccount'] = 'Gendannet konto';
$string['restoredaccountinfo'] = 'Denne konto er importeret fra en anden server og adgangskoden er mistet. Få en ny kode via e-mail ved at klikke på "Fortsæt".';
$string['restorefinished'] = 'Gendannelse gennemført OK';
$string['restoremnethostidmismatch'] = 'MNets host-id for brugeren "{$a}" matcher ikke den lokale MNets host-id';
$string['restoreto'] = 'Gendan til';
$string['restoretositeadding'] = 'Advarsel: Du er lige ved at gendanne til forsiden og føje data til det eksisterende indhold!';
$string['restoretositedeleting'] = 'Advarsel: Du er lige ved at gendanne til en ren forside, hvor eksisterende data slettes først!';
$string['restoreuserconflict'] = 'Forsøg på at gendanne brugeren \'{$a}\' fra backupfilen vil skabe konflikter';
$string['restoreuserinfofailed'] = 'Gendannelsen er stoppet da du ikke har tilladelse til at gendanne brugerdata.';
$string['restoreusersprecheck'] = 'Tjekker brugerdata';
$string['restoreusersprecheckerror'] = 'Nogle problemer blev fundet under tjek af brugerdata';
$string['restricted'] = 'Begrænset';
$string['resultsfound'] = '{$a} resultater fundet';
$string['retry'] = 'Prøv igen';
$string['returningtosite'] = 'Har du besøgt os før?';
$string['returntooriginaluser'] = 'Retuner til {$a}';
$string['revert'] = 'Fortryd';
$string['role'] = 'Rolle';
$string['roleassignments'] = 'Rolletilding';
$string['rolemappings'] = 'Rolletildeling';
$string['rolerenaming'] = 'Dit ord for';
$string['rolerenaming_help'] = 'Du kan ændre de viste betegnelser for roller, der bruges på dit kursus. Du kan eksempelvis omdøbe "Lærer" til "Underviser" eller "Instruktør". Rollen som sådan påvirkes ikke, det vil kun være det viste rollenavn, der ændres. De nye betegnelser vil vises på siden med deltagerlisten og andre steder på kurset. Hvis rollen med den nye betegnelse er en som administratoren har valgt som rolle for kursusadministrator, så vil den nye betegnelse også vises på listen over kurser.';
$string['roles'] = 'Roller';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Antal seneste RSS-artikler';
$string['rsserror'] = 'Fejl under læsning af RSS-data';
$string['rsserrorauth'] = 'Dit RSS-link indeholder ikke en gyldig godkendelelsestoken.';
$string['rsserrorguest'] = 'Dette feed bruger gæsteadgang til at tilgå oplysningerne, men gæster har ikke tilladelse til at læse dataene. Besøg som godkendt bruger den oprindelige placering af feed\'et (URL) og få et nyt RSS-link derfra.';
$string['rsskeyshelp'] = 'Af hensyn til sikkerhed og privatliv indeholder URL\'er til rss-feed en specielt token som identificerer brugeren af dem. Dette gør, at andre brugere ikke får adgang til områder af Moodle som de ikke har tilladelse til.</p><p>Denne token er automatisk oprettet den første gang du får adgang til et område som producerer rss-feed. Hvis du føler at din rss-feed-token er blevet kompromitteret, kan du bede om en ny en ved at klikke på "Nulstil"-linket. Vær opmærksom på at din nuværende URL til rss-feed derefter bliver ugyldig.</p>';
$string['rsstype'] = 'RSS-feed for denne aktivitet';
$string['save'] = 'Gem';
$string['saveandnext'] = 'Gem og vis næste';
$string['savechanges'] = 'Gem';
$string['savechangesanddisplay'] = 'Gem og vis';
$string['savechangesandreturn'] = 'Gem og vend tilbage';
$string['savechangesandreturntocourse'] = 'Gem og returner til kurset';
$string['savecomment'] = 'Gem kommentar';
$string['savedat'] = 'Gemt ved:';
$string['savepreferences'] = 'Gem indstillinger';
$string['saveto'] = 'Gem i';
$string['scale'] = 'Skala';
$string['scale_help'] = 'En skala giver mulighed for at evaluere eller vurdere præstationen i en aktivitet. Den er defineret ved en kommasepareret ordnet liste over værdier, der spænder fra negativ til positiv, for eksempel "Skuffende, Ikke godt nok, Jævn, God, Meget god, Fremragende!"';
$string['scales'] = 'Skalaer';
$string['scalescustom'] = 'Egne skalaer';
$string['scalescustomcreate'] = 'Tilføj en ny skala';
$string['scalescustomno'] = 'Der er ikke oprettet egne skalaer endnu';
$string['scalesstandard'] = 'Standardskalaer';
$string['scalestandard'] = 'Standardskala';
$string['scalestandard_help'] = 'En standardskala er tilgængelig på hele webstedet for alle kurser.';
$string['scalestip'] = 'For at lave en skala, skal du bruge linket "Karakterer" i kursets administrationsmenu.';
$string['scalestip2'] = 'Opret en ny skala under punktet "Karakterer" i kursets administrationsmenu, vælg "Skalaer" og klik på "Tilføj ny skala".';
$string['schedule'] = 'Planlægge';
$string['screenshot'] = 'Skærmbillede';
$string['search'] = 'Søg';
$string['search_help'] = 'Til basal søgning efter et eller flere ord hvor som helst i teksten, skriv dem blot adskilt af mellemrum. Der kan søges på alle ord med mindst 3 tegn.

Få adgang til avanceret søgning ved at klikke på søgeknappen uden at skrive noget i søgefeltet.';
$string['searchactivities'] = 'Søg på aktiviteter efter navn eller beskrivelse';
$string['searchagain'] = 'Søg igen';
$string['searchbyemail'] = 'Søg på e-mailadresse';
$string['searchbyusername'] = 'Søg på brugernavn';
$string['searchcoursecategories'] = 'Søgekategorier';
$string['searchcourses'] = 'Søg efter kurser';
$string['searchoptions'] = 'Søgekriterier';
$string['searchresults'] = 'Søgeresultater';
$string['sec'] = 'sekunder';
$string['seconds'] = 'sekunder';
$string['secondsleft'] = '{$a} sekunder';
$string['secondstotime172800'] = '2 dage';
$string['secondstotime259200'] = '3 dage';
$string['secondstotime345600'] = '4 dage';
$string['secondstotime432000'] = '5 dage';
$string['secondstotime518400'] = '6 dage';
$string['secondstotime604800'] = '1 uge';
$string['secondstotime86400'] = '1 dag';
$string['secretalreadyused'] = 'Linket til ændring af adgangskode er allerede blevet brugt, adgangskoden blev ikke ændret.';
$string['secs'] = 'sekunder';
$string['section'] = 'Sektion';
$string['sectionactionnotsupported'] = 'Sektionshandlingen "{$a}" understøttes ikke her';
$string['sectionname'] = 'Sektionsnavn';
$string['sections'] = 'Sektioner';
$string['seealsostats'] = 'Se også: statistik';
$string['selctauser'] = 'Vælg en bruger';
$string['select'] = 'Vælg';
$string['selectacategory'] = 'Vælg en kategori';
$string['selectacountry'] = 'Vælg et land';
$string['selectacourse'] = 'Vælg et kursus';
$string['selectacoursesite'] = 'Vælg et kursus eller et site';
$string['selectagroup'] = 'Vælg en gruppe';
$string['selectall'] = 'Marker alle';
$string['selectallusersonpage'] = 'Vælg alle brugere på siden';
$string['selectalluserswithcount'] = 'Vælg alle {$a} brugere';
$string['selectamodule'] = 'Vælg et aktivitetsmodul';
$string['selectanaction'] = 'Vælg en handling';
$string['selectanoptions'] = 'Vælg en indstilling';
$string['selectaregion'] = 'Vælg en region';
$string['selectcategorysort'] = 'Hvilke kategorier vil du sortere?';
$string['selectcategorysortby'] = 'Vælg hvordan du vil sortere kategorierne';
$string['selectcoursesortby'] = 'Vælg hvordan du vil sortere kurser';
$string['selectdefault'] = 'Vælg standard';
$string['selectedcategories'] = 'Valgte kategorier';
$string['selectedfile'] = 'Valgt fil';
$string['selectednowmove'] = '{$a} filer valgt til flytning. Find destinationsmappen og tryk på \'Flyt filer hertil\'';
$string['selectfiles'] = 'Marker filer';
$string['selectitem'] = 'Vælg "{$a}"';
$string['selectmoduletoviewhelp'] = 'Vælg en aktivitet for at se dets hjælp.

Dobbeltklik på en aktivitet eller et materiale for hurtigt at tilføje det.';
$string['selectnos'] = 'Vælg "Nej" til alle';
$string['selectperiod'] = 'Vælg periode';
$string['senddetails'] = 'Send mine oplysninger via e-mail';
$string['separate'] = 'Separat';
$string['separateandconnected'] = 'Separate and tilknyttede måder at vide';
$string['separateandconnectedinfo'] = 'Skalaen er baseret på teorien om separat og forbundet viden. Denne teori beskriver to forskellige måder, hvorpå vi kan evaluere og lære om de ting, vi ser og hører.<ul><li><strong>Separate knowers</strong> forbliver så objektive som muligt uden at inkludere følelser og følelser. I en diskussion med andre mennesker kan de godt lide at forsvare deres egne ideer, ved at bruge logik til at finde huller i modstanderens ideer.</li><li><strong>Connected knowers</strong> er mere følsomme over for andre mennesker. De er dygtige til empati og har en tendens til at lytte og stille spørgsmål, indtil de føler, at de kan forbinde sig og "forstå tingene fra deres synspunkt". De lærer ved at prøve at dele de erfaringer, der førte til den viden, de finder hos andre mennesker.</li></ul>';
$string['servererror'] = 'Der opstod en fejl under kommunikation med serveren';
$string['serverlocaltime'] = 'Serverens lokale tid';
$string['sessionforceclean'] = 'Som en sikkerhedsforanstaltning er brugergenererede scripts deaktiverede i denne session.';
$string['sessiontimeoutsoon'] = 'Din session er ved at udløbe. Vil du forlænge den?';
$string['setcategorytheme'] = 'Vælg layout til kategorien';
$string['setmode'] = 'Indstillingstilstand';
$string['setpassword'] = 'Indstil adgangskode';
$string['setpasswordinstructions'] = 'Indtast din nye adgangskode herunder og gem ændringerne.';
$string['settings'] = 'Indstillinger';
$string['shortname'] = 'Kort navn';
$string['shortnamecollisionwarning'] = '[*] = Dette korte navn er allerede brugt til et kursus og skal derfor ændres ved godkendelsen';
$string['shortnamecourse'] = 'Korte navn';
$string['shortnamecourse_help'] = 'Kursets korte navn vises i navigationen og bruges i emnefeltet på e-mails fra kurset.';
$string['shortnametaken'] = 'Forkortelsen er allerede brugt en gang til et andet kursus ({$a})';
$string['shortnameuser'] = 'Kort brugernavn';
$string['shortsitename'] = 'Forkortelse for dette websted (f.eks. et enkelt ord)';
$string['show'] = 'Vis';
$string['showactions'] = 'Vis hændelser';
$string['showactivitydates'] = 'Vis datoer for aktiviteter';
$string['showactivitydates_help'] = 'Aktivitetsdatoer vises altid på aktivitetssiden. Denne indstilling bestemmer, om aktivitetsdatoer også vises under hver aktivitet på kursussiden.';
$string['showadvancededitor'] = 'Avanceret';
$string['showadvancedsettings'] = 'Vis avancerede indstillinger';
$string['showall'] = 'Vis alle {$a}';
$string['showallcourses'] = 'Vis alle kurser';
$string['showallusers'] = 'Vis alle brugere';
$string['showblockcourse'] = 'Vis hvilke kurser der bruger blokken';
$string['showcategory'] = 'Vis {$a}';
$string['showchartdata'] = 'Vis diagramdata';
$string['showcomments'] = 'Vis/skjul kommentarer';
$string['showcommentsnonjs'] = 'Vis kommentarer';
$string['showdescription'] = 'Vis beskrivelse på kursets forside';
$string['showdescription_help'] = 'Er indstillingen aktiveret, vil beskrivelsen herover blive vist på kursussiden lige under linket til aktiviteten/materialet.';
$string['showgrades'] = 'Vis karakterer til de studerende';
$string['showgrades_help'] = 'Mange aktiviteter giver mulighed for at give karakterer. Denne indstilling bestemmer, om en studerende kan se en liste over alle sine karakterer på kurset.';
$string['showingacourses'] = 'Vis alle {$a} kurser';
$string['showingxofycourses'] = 'Viser kurser {$a->start} til {$a->end} af {$a->total} kurser';
$string['showlistofcourses'] = 'Vis en kursusliste';
$string['showmodulecourse'] = 'Vis en lister over kurser der bruger aktiviteten';
$string['showoncoursepage'] = 'Vis på kursets forside';
$string['showonly'] = 'Vis kun';
$string['showperpage'] = 'Vis {$a} pr. side';
$string['showpopoverwindow'] = 'Vis popover-vindue';
$string['showrecent'] = 'Vis sidste aktivitet(er)';
$string['showreports'] = 'Vis aktivitetsrapport';
$string['showreports_help'] = 'Aktivitetsrapporter der viser aktiviteten på kurset, er tilgængelige for alle deltagere. Udover at vise deltagernes bidrag såsom forumindlæg eller opgavebesvarelser, viser rapporterne også hvornår de har været logget ind. Indstillingen styrer om den studerende kan se egen aktivitetsrapport via profilsiden.';
$string['showsettings'] = 'Vis indstillinger';
$string['showtheselogs'] = 'Vis disse logs';
$string['showthishelpinlanguage'] = 'Vis denne hjælp på: {$a}';
$string['sidepanel'] = 'Sidepanel';
$string['signoutofotherservices'] = 'Log ud overalt';
$string['signoutofotherservices_help'] = 'Er indstillingen markeret, vil kontoen blive logget af alle enheder og systemer der bruger webservicer såsom mobilappen.';
$string['since'] = 'Siden';
$string['sincelast'] = 'siden sidste login';
$string['site'] = 'Websted';
$string['sitedefault'] = 'Sitestandarder';
$string['sitedefaultspecified'] = 'Sites standard ({$a})';
$string['siteerrors'] = 'Site fejl';
$string['sitefiles'] = 'Site filer';
$string['sitefilesused'] = 'Sitefiler der bruges på dette kursus';
$string['sitehome'] = 'Webstedets forside';
$string['sitelegacyfiles'] = 'Arvede sitefiler';
$string['sitelogs'] = 'Sitelogs';
$string['sitenews'] = 'Sitemeddelelser';
$string['sitepages'] = 'Webstedssider';
$string['sitepartlist'] = 'Du har ikke de nødvendige tilladelser til at se deltagerlisten.';
$string['sitepartlist0'] = 'Du skal være lærer på sitet for at kunne se deltagerlisten.';
$string['sitepartlist1'] = 'Du skal være lærer for at kunne se deltagerlisten.';
$string['sites'] = 'Websteder';
$string['sitesection'] = 'Inkluder en emnesektion';
$string['sitesettings'] = 'Siteindstillinger';
$string['siteteachers'] = 'Sitelærere';
$string['size'] = 'Størrelse';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Sprunget over';
$string['skiptocategorylisting'] = 'Gå til listen over kategorier';
$string['skiptocoursedetails'] = 'Gå til den detaljerede kursusinformation';
$string['skiptocourselisting'] = 'Gå til listen over kurser';
$string['skypeid'] = 'Skype-ID';
$string['socialheadline'] = 'Socialt forum - sidste emner';
$string['someallowguest'] = 'Nogle kurser tillader gæsteadgang';
$string['someerrorswerefound'] = 'Nogle af oplysningerne manglede eller var forkerte. Se flere oplysninger nedenfor';
$string['sort'] = 'Sortér';
$string['sortby'] = 'Sorter efter';
$string['sortbyx'] = 'Sorter efter {$a} stigende';
$string['sortbyxreverse'] = 'Sorter efter {$a} faldende';
$string['sorting'] = 'Sortering';
$string['sourcerole'] = 'Oprindelig rolle';
$string['specifyname'] = 'Du skal skrive et navn';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = afventer kursusgodkendelse)';
$string['startdate'] = 'Startdato';
$string['startdate_help'] = 'Indstillingen styrer start på første uge på et kursus i ugeformat. Den styrer også hvornår logs med kursusaktiviteter tidligst er tilgængelig. Nulstilles kurset og startdatoen ændres, vil alle datoer på kurset flyttes i relation til den nye startdato.';
$string['startingfrom'] = 'Starter fra';
$string['startsignup'] = 'Opret ny profil';
$string['state'] = 'Stat/Provins';
$string['statistics'] = 'Statistikker';
$string['statisticsgraph'] = 'Statistikgraf';
$string['stats'] = 'Statistikker';
$string['statslogins'] = 'Login';
$string['statsmodedetailed'] = 'Detaljeret (bruger-)visning';
$string['statsmodegeneral'] = 'Generel visning';
$string['statsnodata'] = 'Der eksisterer ingen data for denne kombination af kursus og tidsramme.';
$string['statsnodatauser'] = 'Der eksisterer ingen data for denne kombination af kursus, bruger og tidsramme.';
$string['statsoff'] = 'Statistikfunktion er ikke slået til.';
$string['statsreads'] = 'Visninger';
$string['statsreport1'] = 'Login';
$string['statsreport10'] = 'Brugeraktivitet';
$string['statsreport11'] = 'Mest aktive kurser';
$string['statsreport12'] = 'Mest aktive kurser (vægtet)';
$string['statsreport13'] = 'Mest benyttede kurser (tilmeldinger)';
$string['statsreport14'] = 'Mest benyttede kurser (indlæg/visninger)';
$string['statsreport2'] = 'Visninger (alle roller)';
$string['statsreport3'] = 'Indlæg (alle roller)';
$string['statsreport4'] = 'Alle aktiviteter (alle roller)';
$string['statsreport5'] = 'Alle aktiviteter (visninger og indlæg)';
$string['statsreport7'] = 'Brugeraktiviteter (visninger og indlæg)';
$string['statsreport8'] = 'Alle brugeraktiviteter';
$string['statsreport9'] = 'Logins (forsidekurset)';
$string['statsreportactivity'] = 'Alle aktiviteter (alle roller)';
$string['statsreportactivitybyrole'] = 'Alle aktiviteter (visninger og indlæg)';
$string['statsreportforuser'] = 'for';
$string['statsreportlogins'] = 'Logget på';
$string['statsreportreads'] = 'Visninger (alle roller)';
$string['statsreporttype'] = 'Rapporttype';
$string['statsreportwrites'] = 'Indlæg (alle roller)';
$string['statsstudentactivity'] = 'Studerendes aktivitet';
$string['statsstudentreads'] = 'Visninger til studerende';
$string['statsstudentwrites'] = 'Indlæg af studerende';
$string['statsteacheractivity'] = 'Læreraktivitet';
$string['statsteacherreads'] = 'Lærervisninger';
$string['statsteacherwrites'] = 'Lærerindlæg';
$string['statstimeperiod'] = 'Tidsperiode - sidst:';
$string['statsuniquelogins'] = 'Unikke login';
$string['statsuseractivity'] = 'Al aktivitet';
$string['statsuserlogins'] = 'Login';
$string['statsuserreads'] = 'Visninger';
$string['statsuserwrites'] = 'Indlæg';
$string['statswrites'] = 'Indlæg';
$string['status'] = 'Status';
$string['statuscritical'] = 'Kritisk';
$string['statuserror'] = 'Fejl';
$string['statusinfo'] = 'Info';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Ukendt';
$string['statuswarning'] = 'Advarsel';
$string['stringsnotset'] = 'De følgende linjer er ikke definerede i {$a}';
$string['studentnotallowed'] = 'Beklager, du kan ikke deltage på dette kursus som "{$a}"';
$string['students'] = 'Studerende';
$string['studentsandteachers'] = 'Studerende og lærere';
$string['subcategories'] = 'Underkategorier';
$string['subcategory'] = 'Underkategori';
$string['subcategoryof'] = 'Underkategori af {$a}';
$string['subject'] = 'Emne';
$string['submit'] = 'Gem';
$string['success'] = 'Succes';
$string['successduration'] = 'Succes ({$a} sekunder)';
$string['summary'] = 'Kort beskrivelse';
$string['summary_help'] = 'Ideen med en uge-/emnebeskrivelse er en kort tekst som siger lidt om hvad ugen/emnet handler om. Teksten vises på kursussiden under sektionens navn.';
$string['summaryof'] = 'Resumé af {$a}';
$string['supplyinfo'] = 'Profiloplysninger';
$string['suspended'] = 'Suspenderet';
$string['suspendedusers'] = 'Suspenderet bruger';
$string['switchdevicedefault'] = 'Skift til standardlayoutet';
$string['switchdevicerecommended'] = 'Skift til det anbefalede layout til din skærm';
$string['switchrolereturn'] = 'Skift til min almindelige rolle';
$string['switchroleto'] = 'Skift rolle til...';
$string['switchroleto_help'] = 'Vælg en rolle for at få en idé om hvordan kurset ser ud for en deltager med den pågældende rolle. Bemærk at visningen nok ikke er perfekt (<a href="https://docs.moodle.org/en/Switch_roles">Se oplysninger og alternativer</a>).';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Dette tag er allerede oprettet';
$string['tagmanagement'] = 'Tilføj/fjern tags...';
$string['tags'] = 'Tags';
$string['targetrole'] = 'Destinationsrolle';
$string['teacheronly'] = 'kun for {$a}';
$string['teacherroles'] = '{$a} roller';
$string['teachers'] = 'Lærere';
$string['textcopiedtoclipboard'] = 'Tekst kopieret til udklipsholder';
$string['textediting'] = 'Tekst-editor';
$string['textediting_help'] = 'Hvis en html-editor såsom Atto eller TinyMCE er valgt, vil felter til tekstindtastning have en værktøjslinje med knapper til nem tilføjelse af indhold. Er "Uformateret tekstfelt" valgt, kan man vælge et format til tekst, f.eks. html eller markdown. Listen over tilgængelige editorer vedligeholdes af Administrator.';
$string['texteditor'] = 'Brug standard webformularer (uden formatering)';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Uformateret tekstformat';
$string['thanks'] = 'Tak';
$string['theme'] = 'Layout';
$string['themes'] = 'Layouts';
$string['themesaved'] = 'Nyt layout gemt';
$string['therearecourses'] = 'Der er {$a} kurser';
$string['thereareno'] = 'Der er ikke {$a} på dette kursus';
$string['thiscategory'] = 'Denne kategori';
$string['thiscategorycontains'] = 'Denne kategori indeholder';
$string['time'] = 'Tidspunkt';
$string['timecreated'] = 'Tidspunkt for oprettelse';
$string['timecreatedcourse'] = 'Kursus oprettet';
$string['timesplitting:deciles'] = 'Sidste tiendedel';
$string['timesplitting:deciles_help'] = 'Dette analyseinterval opdeler kurset i tiendedele, hvor hver forudsigelse bases på data fra den seneste af de forrige tiendedele.';
$string['timesplitting:decilesaccum'] = 'Alle foregående tiendedele';
$string['timesplitting:decilesaccum_help'] = 'Dette analyseinterval opdeler kurset i tiendedele, hvor hver forudsigelse bases på akkumulerede data fra alle foregående tiendedele.';
$string['timesplitting:nosplitting'] = 'Ingen tidsbegrænsning';
$string['timesplitting:nosplitting_help'] = 'Der er ikke defineret et analyseinterval for denne model.';
$string['timesplitting:onemonthafterstart'] = 'En måned efter start';
$string['timesplitting:onemonthafterstart_help'] = 'Analyseintervallet genererer en forudsigelse 1 måned efter analysens start.';
$string['timesplitting:oneweekafterstart'] = 'En uge efter start';
$string['timesplitting:oneweekafterstart_help'] = 'Analyseintervallet genererer en forudsigelse 1 uge efter analysens start.';
$string['timesplitting:past3days'] = 'Sidste 3 dage';
$string['timesplitting:past3days_help'] = 'Analyseintervallet genererer forudsigelser hver 3. dag. Indikatorberegningerne baseres på de sidste 3 dage.';
$string['timesplitting:pastmonth'] = 'Sidste måned';
$string['timesplitting:pastmonth_help'] = 'Analyseintervallet genererer forudsigelser hver måned. Indikatorberegningerne baseres på den forgangne måned.';
$string['timesplitting:pastweek'] = 'Sidste uge';
$string['timesplitting:pastweek_help'] = 'Analyseintervallet genererer forudsigelser hver uge. Indikatorberegningerne baseres på den forgangne uge.';
$string['timesplitting:quarters'] = 'Sidste fjerdedel';
$string['timesplitting:quarters_help'] = 'Dette analyseinterval opdeler kurset i fjerdedele, hvor hver forudsigelse bases på data fra den seneste fjerdedel.';
$string['timesplitting:quartersaccum'] = 'Alle foregående fjerdedele';
$string['timesplitting:quartersaccum_help'] = 'Dette analyseinterval opdeler kurset i fjerdedele, hvor hver forudsigelse bases på akkumulerede data fra de foregående fjerdedele.';
$string['timesplitting:singlerange'] = 'Fra start til slut';
$string['timesplitting:singlerange_help'] = 'Dette analyseinterval behandler hele kurset i en enkelt mundfuld.';
$string['timesplitting:tenpercentafterstart'] = '10% efter start';
$string['timesplitting:tenpercentafterstart_help'] = 'Dette analyseinterval genererer en forudsigelse når 10% af kurset er gennemført.';
$string['timesplitting:upcoming3days'] = 'Næste 3 dage';
$string['timesplitting:upcoming3days_help'] = 'Dette analyseinterval genererer forudsigelser hver 3. dag. Indikatorberegninger baseres på de kommende 3 dage.';
$string['timesplitting:upcomingfortnight'] = 'Næste to uger';
$string['timesplitting:upcomingfortnight_help'] = 'Dette analyseinterval genererer forudsigelser hver 14. dag. Indikatorberegninger baseres på de kommende 2 uger.';
$string['timesplitting:upcomingweek'] = 'Næste uge';
$string['timesplitting:upcomingweek_help'] = 'Dette analyseinterval genererer forudsigelser hver uge. Indikatorberegninger baseres på den kommende uge.';
$string['timezone'] = 'Tidszone';
$string['to'] = 'Til';
$string['tocontent'] = 'Til element "{$a}"';
$string['tocreatenewaccount'] = 'Spring til oprettelse af ny konto';
$string['today'] = 'I dag';
$string['todaylogs'] = 'Dagens logs';
$string['toeveryone'] = 'til alle';
$string['toggleemojipicker'] = 'Slå emojivælger til/fra';
$string['togglesearch'] = 'Skift søgeindput';
$string['toomanybounces'] = 'Denne mailadresse har haft for mange afviste mails. Du bliver nødt til at <b>ændre den</b> for at fortsætte.';
$string['toomanytags'] = 'Denne søgning inkluderede for mange tags, nogle af dem er blevet ignoreret.';
$string['toomanytoshow'] = 'Der er for mange brugere at vise';
$string['toomanyusersmatchsearch'] = 'Der er for mange brugere ({$a->count}) der matcher med "{$a->search}"';
$string['toomanyuserstoshow'] = 'Så mange brugere ({$a}) kan ikke vises';
$string['toonly'] = 'kun til {$a}';
$string['top'] = 'Top';
$string['topic'] = 'Emne';
$string['topichide'] = 'Skjul dette emne fra {$a}';
$string['topicoutline'] = 'Emneoversigt';
$string['topicshow'] = 'Vis dette emne til {$a}';
$string['toplevelcategory'] = 'Topniveaukategori';
$string['total'] = 'Total';
$string['totopofsection'] = 'Til toppen af sektion "{$a}"';
$string['trackforums'] = 'Gør mig opmærksom på nye forumindlæg';
$string['trackforumsno'] = 'Nej: Jeg tjekker selv om der er nye indlæg';
$string['trackforumsyes'] = 'Ja: Oplys mig om nye indlæg';
$string['trysearching'] = 'Prøv at søge i stedet.';
$string['turneditingoff'] = 'Slå redigering fra';
$string['turneditingon'] = 'Rediger';
$string['unabletocopytoclipboard'] = 'Kan ikke kopiere tekst til udklipsholderen';
$string['unauthorisedlogin'] = 'Brugerprofilen "{$a}" findes ikke på dette site.';
$string['undecided'] = 'Ubestemt';
$string['unexistingcmid'] = 'Kursusmodul-id ikke fundet';
$string['unexistingsectionid'] = 'Kursussektions-id blev ikke fundet';
$string['unfinished'] = 'Ufærdigt';
$string['unknowncategory'] = 'Ukendt kategori';
$string['unknownerror'] = 'Ukendt fejl';
$string['unknownuser'] = 'Ukendt bruger';
$string['unlimited'] = 'Ubegrænset';
$string['unpacking'] = 'Udpakker {$a}';
$string['unsafepassword'] = 'Usikker adgangskode - prøv en anden';
$string['untilcomplete'] = 'Indtil færdig';
$string['unusedaccounts'] = 'Brugerkonti der ikke har været brugt i {$a} dage, bliver automatisk udmeldt';
$string['unzip'] = 'Udpak';
$string['unzippingbackup'] = 'Udpakker backup';
$string['up'] = 'Op';
$string['update'] = 'Rediger';
$string['updated'] = 'Opdateret {$a}';
$string['updatemymoodleoff'] = 'Slå redigering fra';
$string['updatemymoodleon'] = 'Rediger denne side';
$string['updatemyprofile'] = 'Opdater profil';
$string['updatesevery'] = 'Opdater hvert {$a} sekund';
$string['updatethis'] = 'Opdater {$a}';
$string['updatethiscourse'] = 'Opdater dette kursus';
$string['updatinga'] = 'Opdaterer: {$a}';
$string['updatingain'] = 'Opdaterer: {$a->what} i {$a->in}';
$string['upload'] = 'Upload';
$string['uploadafile'] = 'Upload en fil';
$string['uploadcantwrite'] = 'Det mislykkedes at lægge filen på disken.';
$string['uploadedfile'] = 'Fil uploadet OK';
$string['uploadedfileto'] = 'Uploadet {$a->file} til {$a->directory}';
$string['uploadedfiletoobig'] = 'Desværre, men filen er for stor (maks. {$a} bytes)';
$string['uploadextension'] = 'Upload af filen blev stoppet på grund en php-udvidelse.';
$string['uploadfailednotrecovering'] = 'Upload af filen er gået galt fordi der var et problem med en af filerne, {$a->name}.<br />Her er en log med problemerne:<br />{$a->problem}<br />Behandles ikke';
$string['uploadfilelog'] = 'Uploadlog for filen {$a}';
$string['uploadformlimit'] = 'Den uploadede fil {$a} overskrider den maksimale størrelse';
$string['uploadlabel'] = 'Titel:';
$string['uploadlimitwithsize'] = '{$a->contextname}ets uploadgrænse ({$a->displaysize})';
$string['uploadnewfile'] = 'Upload en ny fil';
$string['uploadnofilefound'] = 'Ingen fil fundet - er du sikker på at du har valgt en at uploade?';
$string['uploadnotallowed'] = 'Upload er ikke tilladt';
$string['uploadnotempdir'] = 'Mangler en midlertidig mappe';
$string['uploadoldfilesdeleted'] = 'De gamle filer i dit uploadområde er blevet slettet';
$string['uploadpartialfile'] = 'Filen blev kun delvist uploadet.';
$string['uploadproblem'] = 'En ukendt fejl opstod mens filen "{$a}" blev uploadet (måske var den for stor?)';
$string['uploadrenamedchars'] = 'Filen er blevet omdøbt fra {$a->oldname} til {$a->newname} på grund af ugyldige tegn.';
$string['uploadrenamedcollision'] = 'Filen blev omdøbt fra {$a->oldname} til {$a->newname} fordi der var en navnekonflikt.';
$string['uploadserverlimit'] = 'Den uploadede fil var for stor i forhold til begrænsningen bestemt af serveren.';
$string['uploadthisfile'] = 'Upload denne fil';
$string['url'] = 'URL';
$string['used'] = 'Brugt';
$string['usedinnplaces'] = 'Brugt {$a} steder';
$string['user'] = 'Bruger';
$string['useraccount'] = 'Brugerkonto';
$string['useractivity'] = 'Aktivitet';
$string['userconfirmed'] = 'Bekræftet {$a}';
$string['userdata'] = 'Brugerdata';
$string['userdeleted'] = 'Denne brugerkonto er blevet slettet';
$string['userdescription'] = 'Beskrivelse';
$string['userdescription_help'] = 'I denne boks kan du skrive lidt om dig selv. Teksten vil blive vist for andre på din profilside.';
$string['userdetails'] = 'Brugeroplysninger';
$string['userfiles'] = 'Brugerfiler';
$string['userfilterplaceholder'] = 'Søg på nøgleord eller vælg et filter';
$string['userlist'] = 'Brugerliste';
$string['usermenu'] = 'Brugermenu';
$string['usermenugoback'] = 'Gå tilbage til brugermenuen';
$string['username'] = 'Brugernavn';
$string['usernameemail'] = 'Brugernavn eller e-mail';
$string['usernameemailmatch'] = 'Brugernavn og e-mailadresse passer ikke sammen';
$string['usernameexists'] = 'Dette brugernavn eksisterer allerede, vælg et andet';
$string['usernamelowercase'] = 'Brug kun små bogstaver';
$string['usernamenotfound'] = 'Brugernavnet blev ikke genkendt';
$string['usernameoremail'] = 'Skriv brugernavn eller e-mailadresse';
$string['usernotconfirmed'] = 'Kunne ikke bekræfte {$a}';
$string['userpic'] = 'Billede af bruger';
$string['userpreferences'] = 'Brugerindstillinger';
$string['users'] = 'Brugere';
$string['userselectorautoselectunique'] = 'Vælg automatisk hvis kun én bruger matcher søgningen';
$string['userselectorpreserveselected'] = 'Behold valgte brugere, også hvis de ikke længere matcher søgningen';
$string['userselectorsearchanywhere'] = 'Match søgestrengen hvor som helst i de viste felter';
$string['usersnew'] = 'Nye brugere';
$string['usersnoaccesssince'] = 'Inaktive i mere end';
$string['userswithfiles'] = 'Brugere med filer';
$string['useruploadtype'] = 'Brugerupload type: {$a}';
$string['userzones'] = 'Brugerzoner';
$string['usetheme'] = 'Anvend';
$string['usingexistingcourse'] = 'Benytter eksisterende kursus';
$string['validatehtml'] = 'Valider HTML';
$string['valuealreadyused'] = 'Denne værdi er i brug allerede.';
$string['version'] = 'Version';
$string['view'] = 'Vis';
$string['viewallcourses'] = 'Vis alle kurser';
$string['viewallcoursescategories'] = 'Vis alle kurser og kursuskategorier';
$string['viewallsubcategories'] = 'Se alle underkategorier';
$string['viewfileinpopup'] = 'Vis filen i et pop op-vindue';
$string['viewing'] = 'Ser:';
$string['viewmore'] = 'Vis flere';
$string['viewprofile'] = 'Vis profil';
$string['views'] = 'Visninger';
$string['viewsolution'] = 'vis løsning';
$string['visible'] = 'Synlig';
$string['visible_help'] = 'Indstillingen styrer om kurset vises i kursusoversigten. Bortset fra for lærere på kurset og administratorer, har brugere ikke mulighed for at tilgå kurset.';
$string['visibletostudents'] = 'Synlig for {$a}';
$string['warning'] = 'Advarsel';
$string['warningdeleteresource'] = 'Advarsel: Der referes til {$a} i noget materiale. Ønsker du at opdatere materialet?';
$string['wcagcheck'] = 'Web Content Accessibility Guidelines (WCAG) tjek';
$string['webpage'] = 'Webside';
$string['week'] = 'Uge';
$string['weekhide'] = 'Skjul denne uge fra {$a}';
$string['weeklyoutline'] = 'Ugeoversigt';
$string['weeks'] = 'uger';
$string['weekshow'] = 'Vis denne uge til {$a}';
$string['welcomeback'] = 'Velkommen tilbage, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Velkommen til {$a}';
$string['welcometocoursetext'] = 'Velkommen til {$a->coursename}!

Har du ikke allerede gjort det, bør du redigere din brugerprofil, så vi kan læse lidt om dig:

{$a->profileurl}';
$string['welcometosite'] = 'Velkommen, {$a->firstname}! 👋';
$string['whatforlink'] = 'Hvad vil du foretage dig med linket?';
$string['whatforpage'] = 'Hvad vil du gøre med teksten?';
$string['whatisyourage'] = 'Hvor gammel er du?';
$string['whattocallzip'] = 'Hvad vil du at kalde zip-filen?';
$string['whattodo'] = 'Hvad man skal gøre';
$string['wheredoyoulive'] = 'Hvilket land bor du i?';
$string['whyisthisrequired'] = 'Hvorfor spørger vi om det?';
$string['windowclosing'] = 'Dette vindue bør lukke automatisk. Lukker det ikke kan du lukke det nu.';
$string['withchosenfiles'] = 'Med valgte filer';
$string['withdisablednote'] = '{$a} (slået fra)';
$string['withoutuserdata'] = 'uden brugerdata';
$string['withselectedusers'] = 'Med markerede brugere...';
$string['withuserdata'] = 'med brugerdata';
$string['wordforstudent'] = 'Dit ord for studerende';
$string['wordforstudenteg'] = 'f.eks. Elev, Studerende, Deltager, Kursist etc';
$string['wordforstudents'] = 'Dit ord for studerende';
$string['wordforstudentseg'] = 'f.eks. Studerende, Deltagere, Kursister osv.';
$string['wordforteacher'] = 'Dit ord for lærer';
$string['wordforteachereg'] = 'f.eks.  Lærer, Instruktør, Vejleder, Underviser osv.';
$string['wordforteachers'] = 'Dit ord for lærere';
$string['wordforteacherseg'] = 'f.eks.  Lærere, Instruktører, Vejleder, Underviser osv.';
$string['writingblogsinfo'] = 'Skriver blogs-info';
$string['writingcategoriesandquestions'] = 'Gemmer kategorier og spørgsmål';
$string['writingcoursedata'] = 'Gemmer kursusdata';
$string['writingeventsinfo'] = 'Gemmer begivenhedsinfo';
$string['writinggeneralinfo'] = 'Gemmer generel info';
$string['writinggradebookinfo'] = 'Gemmer karakterbogsinfo';
$string['writinggroupingsgroupsinfo'] = 'Gemmer grupperings-grupper (groupings-groups) -information';
$string['writinggroupingsinfo'] = 'Gemmer grupperings-info';
$string['writinggroupsinfo'] = 'Gemmer gruppeinfo';
$string['writingheader'] = 'Gemmer overskrift';
$string['writingloginfo'] = 'Gemmer loginfo';
$string['writingmessagesinfo'] = 'Gemmer beskedinfo';
$string['writingmoduleinfo'] = 'Gemmer modulinfo';
$string['writingscalesinfo'] = 'Gemmer skalainfo';
$string['writinguserinfo'] = 'Gemmer brugerinfo';
$string['wrongpassword'] = 'Forkert adgangskode for denne bruger';
$string['yahooid'] = 'Yahoo-ID';
$string['year'] = 'år';
$string['years'] = 'år';
$string['yes'] = 'Ja';
$string['youareabouttocreatezip'] = 'Du er ved at oprette en zip-fil indeholdende';
$string['youaregoingtorestorefrom'] = 'Du er ved at starte gendannelsen af';
$string['youhaveupcomingactivitiesdue'] = 'Du har forestående aktiviteter';
$string['youhaveupcomingactivitiesdueinfo'] = 'Hej {$a} <br/><br/>Du har forestående aktiviteter:';
$string['youneedtoenrol'] = 'Dette kræver at du er tilmeldt kurset';
$string['yourlastlogin'] = 'Sidste login var';
$string['yourself'] = 'dig';
$string['yourteacher'] = 'din {$a}';
$string['yourwordforx'] = 'Dit ord for "{$a}"';
$string['zippingbackup'] = 'Zipper backup';
