<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'ro', version '4.0'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Evaluările se închid:';
$string['activitydate:assessmentsclosed'] = 'Evaluări închise:';
$string['activitydate:assessmentsopen'] = 'Evaluările se deschid:';
$string['activitydate:assessmentsopened'] = 'Evaluare deschisă:';
$string['activitydate:submissionsclose'] = 'Trimiterea răspunsurilor se închide:';
$string['activitydate:submissionsclosed'] = 'Trimiterea răspunsurilor este închisă:';
$string['activitydate:submissionsopen'] = 'Trimiterea răspunsurilor se deshide:';
$string['activitydate:submissionsopened'] = 'Trimiterea răspunsurilor este deschisă:';
$string['aggregategrades'] = 'Re-calculați notele';
$string['aggregation'] = 'Agregarea notelor';
$string['allocate'] = 'Alocați trimiterile';
$string['allocatedetails'] = 'așteptat: {$a->expected} <br /> trimis: {$a->submitted} <br /> de alocat: {$a->allocate}';
$string['allocation'] = 'Alocarea trimiterilor';
$string['allocationconfigured'] = 'Alocare configurată';
$string['allocationdone'] = 'Alocare finalizată';
$string['allocationerror'] = 'Eroare de alocare';
$string['allowedfiletypesforoverallfeedback'] = 'Tipurile permise de fișiere atașate unui feedback';
$string['allowedfiletypesforoverallfeedback_help'] = 'Tipurile de fișiere atașate la un feedback pot fi restricționate prin furnizarea unei liste de tipuri de fișiere permise. Dacă câmpul este lăsat gol, atunci toate tipurile de fișiere sunt permise.';
$string['allowedfiletypesforsubmission'] = 'Tipuri de fișiere permise';
$string['allowedfiletypesforsubmission_help'] = 'Tipurile de fișiere atașate unui răspuns trimis pot fi restricționate prin furnizarea unei liste de tipuri de fișiere permise. Dacă câmpul este lăsat gol, atunci toate tipurile de fișiere sunt permise.';
$string['allsubmissions'] = 'Toate trimiterile ({$a})';
$string['alreadygraded'] = 'Notat deja';
$string['areaconclusion'] = 'Text cu concluziile';
$string['areainstructauthors'] = 'Instrucțiuni pentru trimitere răspuns';
$string['areainstructreviewers'] = 'Instrucțiuni pentru evaluare răspunsuri';
$string['areaoverallfeedbackattachment'] = 'Atașamente de feedback generale';
$string['areaoverallfeedbackcontent'] = 'Textele generale de feedback';
$string['areasubmissionattachment'] = 'Atașamente răspuns trimis';
$string['areasubmissioncontent'] = 'Text răspuns trimis';
$string['assess'] = 'Evaluare';
$string['assessedexample'] = 'Exemplu de răspuns evaluat';
$string['assessedsubmission'] = 'Răspuns evaluat';
$string['assessingexample'] = 'Evaluarea răspunsului exemplu';
$string['assessingsubmission'] = 'Evaluarea răspunsului';
$string['assessment'] = 'Evaluare';
$string['assessmentby'] = 'de către <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Evaluare de către {$a}';
$string['assessmentbyyourself'] = 'Evaluarea ta';
$string['assessmentdeleted'] = 'Evaluare alocată';
$string['assessmentend'] = 'Termen limită pentru evaluare';
$string['assessmentendbeforestart'] = 'Termenul limită pentru evaluare nu poate fi specificat înainte de data deschisă pentru evaluare';
$string['assessmentenddatetime'] = 'Termen limită de evaluare: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = 'Termenul limită pentru evaluare este de {$a}';
$string['assessmentform'] = 'Formular de evaluare';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}"> Evaluarea </a> a <a href={$a->submissionurl}"> {$a->submissiontitle} </a>';
$string['assessmentreference'] = 'Evaluare de referință';
$string['assessmentreferenceconflict'] = 'Nu este posibil să evaluați un exemplu de răspuns pentru care ați furnizat o evaluare de referință.';
$string['assessmentreferenceneeded'] = 'Trebuie să evaluați acest exemplu de răspun pentru a furniza o evaluare de referință. Faceți clic pe butonul „Continuați” pentru a evalua răspunsul.';
$string['assessments'] = 'Evaluări';
$string['assessmentsettings'] = 'Setări de evaluare răspunsuri';
$string['assessmentstart'] = 'Deschis pentru evaluare de la';
$string['assessmentstartdatetime'] = 'Deschis pentru evaluare de la {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} se deschide spre evaluare';
$string['assessmentweight'] = 'Greutatea evaluării';
$string['assignedassessments'] = 'Răspunsuri alocate pentru evaluare';
$string['assignedassessmentsnone'] = 'Nu aveți niciun răspuns alocat pentru evaluare';
$string['backtoeditform'] = 'Înapoi la formularul de editare';
$string['byfullname'] = 'de <a href="{$a->url}"> {$a->name} </a>';
$string['byfullnamewithoutlink'] = 'de {$a}';
$string['calculategradinggrades'] = 'Calculați notele de evaluare';
$string['calculategradinggradesdetails'] = 'așteptat: {$a->expected} <br /> calculat: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Calculați notele răspunsului trimis';
$string['calculatesubmissiongradesdetails'] = 'așteptat: {$a->expected} <br /> calculat: {$a->calculated}';
$string['chooseuser'] = 'Alege utilizator...';
$string['clearaggregatedgrades'] = 'Ștergeți toate notele agregate';
$string['clearaggregatedgrades_help'] = 'Notele agregate pentru răspuns și notele pentru evaluare vor fi resetate. Puteți recalcula aceste note de la zero în faza de evaluare a notării din nou.';
$string['clearaggregatedgradesconfirm'] = 'Sigur doriți să ștergeți notele calculate pentru răspunsuri și notele pentru evaluare?';
$string['clearassessments'] = 'Elimină evaluările';
$string['clearassessments_help'] = 'Notele calculate pentru răspuns și notele pentru evaluare vor fi resetate. Informațiile despre cum sunt completate formularele de evaluare sunt păstrate în continuare, dar toți examinatorii trebuie să deschidă din nou formularul de evaluare și să-l salveze din nou pentru a se obține din nou notele date.';
$string['clearassessmentsconfirm'] = 'Sigur doriți să ștergeți toate notele de evaluare? Nu veți putea primi informațiile înapoi pe cont propriu, examinatorii vor trebui să reevalueze trimiterile alocate.';
$string['conclusion'] = 'Concluzii';
$string['conclusion_help'] = 'Textul concluziei este afișat participanților la sfârșitul activității.';
$string['configexamplesmode'] = 'Mod implicit de exemplelor de evaluare în ateliere';
$string['configgrade'] = 'Nota maximă implicită pentru trimitere răspuns în ateliere';
$string['configgradedecimals'] = 'Numărul implicit de cifre care trebuie afișat după punctul zecimal la afișarea notelor';
$string['configgradinggrade'] = 'Nota maximă implicită pentru evaluarea unui răspuns în ateliere';
$string['configmaxbytes'] = 'Dimensiunea maximă implicită a fișierului de răspuns pentru toate atelierele de pe site (sub rezerva limitelor cursului și a altor setări locale)';
$string['configstrategy'] = 'Strategie de notare implicită pentru ateliere';
$string['createsubmission'] = 'Adăugați răspunsul';
$string['crontask'] = 'Procesare de fundal pentru modulul atelier';
$string['daysago'] = 'Acum {$a} zile';
$string['daysleft'] = 'Au mai rămas {$a} zile';
$string['daystoday'] = 'astăzi';
$string['daystomorrow'] = 'mâine';
$string['daysyesterday'] = 'ieri';
$string['deadlinesignored'] = 'Restricțiile de timp nu se aplică dumneavoastră.';
$string['deletesubmission'] = 'Ștergeți răspunsul';
$string['editassessmentform'] = 'Editați formularul de evaluare';
$string['editassessmentformstrategy'] = 'Editați formularul de evaluare ({$a})';
$string['editingassessmentform'] = 'Editarea formularului de evaluare';
$string['editingsubmission'] = 'Editarea răspunsului';
$string['editsubmission'] = 'Modifică propunere';
$string['err_multiplesubmissions'] = 'În timpul editării acestui formular, a fost salvată o altă versiune a răspunsului. Răspunsurile multiple pentru un utilizator nu sunt permise.';
$string['err_removegrademappings'] = 'Imposibil de eliminat alocările de note neutilizate';
$string['evaluategradeswait'] = 'Vă rugăm să așteptați până când evaluările sunt evaluate și notele sunt calculate';
$string['evaluation'] = 'Evaluarea notării';
$string['evaluationmethod'] = 'Metoda de evaluare a notării';
$string['evaluationmethod_help'] = 'Metoda de notare a evaluării determină modul în care este calculată nota pentru evaluarea unui răspuns dat de colegi. Puteți permite să recalculeze notele în mod repetat cu setări diferite, dacă nu sunteți mulțumit de rezultat.';
$string['evaluationsettings'] = 'Setări notare evaluare';
$string['eventassessableuploaded'] = 'A fost încărcat un răspuns.';
$string['eventassessmentevaluated'] = 'Evaluare a fost evaluată';
$string['eventassessmentevaluationsreset'] = 'Resetarea evaluărilor evaluării';
$string['eventassessmentreevaluated'] = 'Evaluarea reevaluată';
$string['eventphaseautomaticallyswitched'] = 'Fază schimbată automat';
$string['eventphaseswitched'] = 'Faza schimbată';
$string['eventsubmissionassessed'] = 'Răspuns evaluat';
$string['eventsubmissionassessmentsreset'] = 'Evaluările răspunsului au fost șterse';
$string['eventsubmissioncreated'] = 'Răspunsul a fost creat';
$string['eventsubmissiondeleted'] = 'Răspunsul a fost șters';
$string['eventsubmissionreassessed'] = 'Răspunsul a fost re-evaluat';
$string['eventsubmissionupdated'] = 'Răspunsul a fost actualizat';
$string['eventsubmissionviewed'] = 'Răspunsul a fost vizualizat';
$string['example'] = 'Exemplu de răspuns';
$string['exampleadd'] = 'Adăugați un exemplu de răspuns';
$string['exampleassess'] = 'Evaluează exemplu răspuns';
$string['exampleassessments'] = 'Exemplu de răspuns  de evaluat';
$string['exampleassesstask'] = 'Evaluează exemple';
$string['exampleassesstaskdetails'] = 'așteptat: {$a->expected} <br /> evaluat: {$a->assessed}';
$string['examplecomparing'] = 'Compararea evaluărilor exemplului de răspuns';
$string['exampledelete'] = 'Șterge exemplul';
$string['exampledeleteconfirm'] = 'Sigur doriți să ștergeți următorul exemplu de răspuns? Faceți clic pe butonul „Continuați” pentru a șterge răspunsul.';
$string['exampleedit'] = 'Editează exemplul';
$string['exampleediting'] = 'Se editează exemplul';
$string['exampleneedassessed'] = 'Mai întâi trebuie să evaluați toate exemplele trimise';
$string['exampleneedsubmission'] = 'Trebuie să trimiteți lucrările dvs. și să evaluați mai întâi toate exemplele de răspunsuri';
$string['examplesbeforeassessment'] = 'Exemplele sunt disponibile după trimiterea răspunsului propriu și trebuie evaluate înainte de evaluarea colegilor';
$string['examplesbeforesubmission'] = 'Exemplele trebuie evaluate înainte de trimiterea răspunsului propriu';
$string['examplesmode'] = 'Modul de evaluare a exemplelor';
$string['examplesubmissions'] = 'Exemple de răspunsuri';
$string['examplesvoluntary'] = 'Evaluarea răspunsurilor de exemplu este opțională';
$string['exportsubmission'] = 'Exportă această pagină';
$string['feedbackauthor'] = 'Feedback pentru autor';
$string['feedbackauthorattachment'] = 'Atașament';
$string['feedbackby'] = 'Feedback de la {$a}';
$string['feedbackreviewer'] = 'Feedback pentru utilizatorul care a făcut recenzent';
$string['feedbacksettings'] = 'Feedback';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Note acordate';
$string['grade_grading_name'] = 'Evaluare';
$string['grade_submission_name'] = 'Răspuns';
$string['gradecalculated'] = 'Nota calculată pentru trimitere răspuns';
$string['gradedecimals'] = 'Note cu zecimale';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Notă: {$a->received} din {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (evaluare)';
$string['gradeitemsubmission'] = '{$a->workshopname} (răspuns)';
$string['gradeover'] = 'Înlocuiți nota pentru trimitere răspuns';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Raportul notelor atelierului';
$string['gradetopassgrading'] = 'Nota de trecere pentru evaluarea unui răspuns';
$string['gradetopasssubmission'] = 'Nota de trecere a răspunsului trimis';
$string['gradinggrade'] = 'Nota obținută pentru evaluarea unui răspuns dat de colegi';
$string['gradinggrade_help'] = 'Această setare specifică nota maximă care poate fi obținută pentru evaluarea răspunsului.';
$string['gradinggradecalculated'] = 'Nota calculată pentru evaluarea unui răspuns dat de colegi';
$string['gradinggradeof'] = 'Nota pentru evaluarea unui răspuns dat de colegi (din {$a})';
$string['gradinggradeover'] = 'Suprascrieți nota pentru evaluarea unui răspuns dat de colegi';
$string['gradingsettings'] = 'Setări de notare';
$string['groupnoallowed'] = 'Nu aveți voie să accesați niciun grup din acest atelier';
$string['iamsure'] = 'Da, sunt sigur(ă)';
$string['indicator:cognitivedepth'] = 'Workshop cognitiv';
$string['indicator:cognitivedepth_help'] = 'Acest indicator se bazează pe profunzimea cognitivă atinsă de cursant într-o activitate de atelier.';
$string['indicator:cognitivedepthdef'] = 'Workshop cognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Participantul a atins acest procent din implicarea cognitivă oferită de activitățile Workshop-ului în timpul acestui interval de analiză (niveluri = Fără vizualizare, Vizualizare, Trimitere, Vizualizare feedback, Comentariu la feedback, Retrimitere după vizualizare feedback)';
$string['indicator:socialbreadth'] = 'Workshop social';
$string['indicator:socialbreadth_help'] = 'Acest indicator se bazează pe angajamentul social atins de cursant într-o activitate de atelier.';
$string['indicator:socialbreadthdef'] = 'Workshop social';
$string['indicator:socialbreadthdef_help'] = 'Participantul a atins acest procent din angajamentul social oferit de activitățile Workshop-ului în timpul acestui interval de analiză (Nivele = Fără participare, Participant singur, Participant cu alții)';
$string['info'] = 'Info';
$string['instructauthors'] = 'Instrucțiuni pentru trimitere răspuns';
$string['instructreviewers'] = 'Instrucțiuni pentru evaluare răspunsuri';
$string['introduction'] = 'Descriere';
$string['latesubmissions'] = 'Trimitere răspunsuri întârziate';
$string['latesubmissions_desc'] = 'Permiteți răspunsuri după termenul limită';
$string['latesubmissions_help'] = 'Dacă este activat, autorul poate trimite răspunsul după termenul limită de trimitere sau în timpul fazei de evaluare. Însă răspunsurile întârziate nu mai pot fi editate.';
$string['latesubmissionsallowed'] = 'Este permisă trimiterea răspunsurilor întârziate, după data limită';
$string['legacyallocationplugincron'] = 'Alocarea vechiului cron de atelier';
$string['maxbytes'] = 'Dimensiunea maximă a atașamentului pentru un răspuns';
$string['modulename'] = 'Atelier';
$string['modulename_help'] = 'Activitatea de tip atelier permite colectarea, revizuirea și evaluarea  răspunsurilor colegilor într-un flux foarte bine definit.

Cursanții pot trimite orice tip de conținut digital (fișiere), cum ar fi documente prelucrate cu text și imagini sau foi de calcul,  de asemenea, pot introduce conținut direct în editorul de text.

Răspunsurile sunt evaluate utilizând un formular de evaluare cu mai multe criterii definite de profesor. Procesul de evaluare de către colegi și de înțelegere a formularului de evaluare poate fi exersat în prealabil, cu exemplificări trimise de către profesor, împreună cu o evaluare de referință ca exemplu. Cursanților li se oferă posibilitatea de a evalua una sau mai multe dintre răspunsurile colegilor. Răspunsurile și examinatorii (utilizatorul care evaluează) pot fi anonimi, dacă este necesar.

Cursanții obțin două note într-o activitate de atelier - o notă pentru răspunsul lor și o notă pentru evaluarea răspunsurilor colegilor lor. Ambele note sunt înregistrate în carnetul de note.';
$string['modulenameplural'] = 'Ateliere';
$string['myassessments'] = 'Evaluările mele';
$string['mysubmission'] = 'Lucrările mele';
$string['nattachments'] = 'Numărul maxim de atașamente';
$string['noexamples'] = 'Nu există încă exemple în acest atelier';
$string['noexamplesformready'] = 'Trebuie să definiți formularul de evaluare înainte de a furniza exemple de răspunsuri';
$string['nogradeyet'] = 'Nici o notă încă';
$string['nosubmissionfound'] = 'Nu a fost găsită niciun răspuns pentru acest utilizator';
$string['nosubmissions'] = 'Încă nu sunt răspunsuri trimise în acest atelier';
$string['nosubmissiontype'] = 'Trebuie să fie disponibil cel puțin un tip de răspuns';
$string['notassessed'] = 'Nu este evaluat încă';
$string['nothingfound'] = 'Nimic de afișat';
$string['nothingtoreview'] = 'Nimic de revizuit';
$string['notoverridden'] = 'Nu este suprascris';
$string['noworkshops'] = 'Nu există ateliere în acest curs';
$string['noyoursubmission'] = 'Nu ați trimis încă răspunsul';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Feedback general';
$string['overallfeedbackfiles'] = 'Numărul maxim de atașamente';
$string['overallfeedbackmaxbytes'] = 'Dimensiunea maximă a atașamentului de feedback global';
$string['overallfeedbackmode'] = 'Mod de feedback general';
$string['overallfeedbackmode_0'] = 'Dezactivat';
$string['overallfeedbackmode_1'] = 'Activat și opțional';
$string['overallfeedbackmode_2'] = 'Activat și obligatoriu';
$string['overallfeedbackmode_help'] = 'Dacă este activat, un câmp text este afișat în partea de jos a formularului de evaluare. Evaluatorii pot pune evaluarea generală a răspunsului acolo sau pot oferi explicații suplimentare despre evaluarea lor pentru acel răspuns.';
$string['page-mod-workshop-x'] = 'Pagina oricărui modul de atelier';
$string['participant'] = 'Participant';
$string['participantrevierof'] = 'Participantul este evaluatorul';
$string['participantreviewedby'] = 'Participantul este evaluat de';
$string['phaseassessment'] = 'Faza de evaluare';
$string['phaseclosed'] = 'Închis';
$string['phaseevaluation'] = 'Faza de notare a evaluării';
$string['phasesetup'] = 'Faza de configurare';
$string['phasesoverlap'] = 'Faza de trimitere răspuns și faza de evaluare nu se pot suprapune';
$string['phasesubmission'] = 'Faza de trimitere răspuns';
$string['pluginadministration'] = 'Administrarea atelierului';
$string['pluginname'] = 'Atelier';
$string['prepareexamples'] = 'Pregătiți exemplele de răspunsuri';
$string['previewassessmentform'] = 'Previzualizare';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Nota agregată pentru toate evaluările făcute de utilizator în activitatea de atelier dată';
$string['privacy:metadata:assessmentgrade'] = 'Nota agregată pentru răspunsul sugerat de această evaluare';
$string['privacy:metadata:assessmentgradinggrade'] = 'Nota pentru furnizarea acestei evaluări';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Valoarea suprascrisă manual a notei pentru furnizarea acestei evaluări';
$string['privacy:metadata:assessmentid'] = 'ID-ul evaluării';
$string['privacy:metadata:authorid'] = 'ID-ul autorului răspunsului trimis';
$string['privacy:metadata:dimensiongrade'] = 'Nota în dimensiunea de evaluare dată';
$string['privacy:metadata:dimensionid'] = 'ID-ul dimensiunii de evaluare';
$string['privacy:metadata:example'] = 'Dacă această înregistrare reprezintă un exemplu de răspuns';
$string['privacy:metadata:feedbackauthor'] = 'Feedback pentru autor';
$string['privacy:metadata:feedbackauthorformat'] = 'Formatul text al feedback-ului pentru autor';
$string['privacy:metadata:feedbackreviewer'] = 'Feedback pentru utilizatorul care furnizează evaluarea';
$string['privacy:metadata:feedbackreviewerformat'] = 'Formatul text al feedback-ului pentru utilizatorul care furnizează evaluarea';
$string['privacy:metadata:late'] = 'Dacă răspunsul a fost depus după termen';
$string['privacy:metadata:peercomment'] = 'Comentariu la nota acordată de utilizatorul care furnizează evaluarea';
$string['privacy:metadata:peercommentformat'] = 'Formatul textului comentariului la nota dată';
$string['privacy:metadata:preference:perpage'] = 'Numărul de răspunsuri pe care utilizatorul preferă să le vadă pe o singură pagină';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Starea restrânsă / extinsă pentru vizualizarea „Exemplu de răspunsuri”.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Starea restrânsă / extinsă pentru vizualizarea „Raportul răspunsurilor la atelier”.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Starea restrânsă / extinsă pentru vizualizarea „Formular de evaluare”.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Răspunsuri atribuite pentru evaluare”.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Instrumente atelier”.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Concluzie”.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Exemplu de răspunsuri pentru evaluare”.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Exemplu de răspunsuri pentru evaluare”.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Raportul notelor atelierului”';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Instrucțiuni pentru trimitere răspuns”.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „IInstrucțiuni pentru evaluare răspunsuri”.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Introducere”.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Feedback general”.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Răspunsul dvs.”.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Răspunsuri publicate”.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Starea restrânsă / extinsă pentru aspectul paginii „Notele tale”.';
$string['privacy:metadata:published'] = 'Dacă răspunsul trimis trebuie publicat tuturor participanților după închiderea atelierului';
$string['privacy:metadata:reviewerid'] = 'ID-ul utilizatorului care furnizează evaluarea';
$string['privacy:metadata:strategy'] = 'Numele subpluginului de strategie de notare care interpretează valorile înregistrării';
$string['privacy:metadata:submissioncontent'] = 'Conținutul răspunsului';
$string['privacy:metadata:submissioncontentformat'] = 'Formatul textului conținutului trimis';
$string['privacy:metadata:submissiongrade'] = 'Nota agregată pentru răspuns scrisă ca număr zecimal din intervalul 0..100';
$string['privacy:metadata:submissiongradeover'] = 'Valoarea suprascrisă manual a notei agregate';
$string['privacy:metadata:submissionid'] = 'ID-ul răspunsului';
$string['privacy:metadata:submissiontitle'] = 'Titlul răspunsului trimis';
$string['privacy:metadata:subsystem:corefiles'] = 'Modulul Atelier stochează fișiere încorporate în / atașate textului de răspuns';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Modulul de atelier are suport încorporat pentru sistemele de prevenire a plagiatului';
$string['privacy:metadata:timeaggregated'] = 'Când a fost calculată nota agregată ultima dată';
$string['privacy:metadata:timecreated'] = 'Când această înregistrare a fost creată în baza de date';
$string['privacy:metadata:timemodified'] = 'Când ultima înregistrare a fost modificată ultima dată în baza de date';
$string['privacy:metadata:userid'] = 'ID-ul utilizatorului pentru care este calculată nota agregată';
$string['privacy:metadata:weight'] = 'Ponderea evaluării';
$string['privacy:metadata:workshopaggregations'] = 'Deține note agregate pentru evaluare';
$string['privacy:metadata:workshopassessments'] = 'Deține informații despre evaluările alocate ale răspunsurilor la modulele de atelier';
$string['privacy:metadata:workshopgrades'] = 'Deține informații despre modul în care formularele de evaluare au fost completate cu note și comentarii';
$string['privacy:metadata:workshopid'] = 'ID-ul activității atelierului';
$string['privacy:metadata:workshopsubmissions'] = 'Deține informații despre răspunsurile la modulele de atelier';
$string['privacy:request:delete:content'] = 'Conținutul a fost șters (solicitat de utilizator sau expirat)';
$string['privacy:request:delete:title'] = '[Șters]';
$string['publishedsubmissions'] = 'Răspunsurile publicate';
$string['publishsubmission'] = 'Publică răspuns';
$string['publishsubmission_help'] = 'Răspunsurile publicate sunt disponibile celorlalți participanți când atelierul este închis.';
$string['reassess'] = 'Re-evaluare';
$string['receivedgrades'] = 'Note primite';
$string['recentassessments'] = 'Evaluările atelierului:';
$string['recentsubmissions'] = 'Răspunsurile atelierului:';
$string['resetassessments'] = 'Ștergeți toate evaluările';
$string['resetassessments_help'] = 'Puteți alege să ștergeți doar evaluările alocate fără a afecta răspunsurile. Dacă trimiterile vor fi șterse, evaluările lor vor fi șterse implicit și această opțiune este ignorată. Rețineți că include și evaluări ale exemplelor de trimiteri.';
$string['resetphase'] = 'Treceți la faza de configurare';
$string['resetphase_help'] = 'Dacă este activat, toate atelierele vor fi puse în faza inițială de configurare.';
$string['resetsubmissions'] = 'Șterge toate răspunsurile';
$string['resetsubmissions_help'] = 'Toate răspunsurile și evaluările lor vor fi șterse. Acest lucru nu afectează răspunsurile de exemplele.';
$string['saveandclose'] = 'Salvează și închide';
$string['saveandcontinue'] = 'Salvează și continuă editarea';
$string['saveandpreview'] = 'Salvați și previzualizați';
$string['saveandshownext'] = 'Salvați și afișați următorul';
$string['search:activity'] = 'Atelier - informații despre activitate';
$string['selfassessmentdisabled'] = 'Autoevaluarea este dezactivată';
$string['showingperpage'] = 'Afișează {$a} itemi pe pagină';
$string['showingperpagechange'] = 'Schimbă...';
$string['someuserswosubmission'] = 'Există cel puțin un autor care nu a trimis încă răpunsul';
$string['sortasc'] = 'Sortare în mod crescător';
$string['sortdesc'] = 'Sortare în mod descrescător';
$string['strategy'] = 'Strategia de notare';
$string['strategy_help'] = 'Strategia de notare determină forma de evaluare utilizată și metoda de notare a răspunsurilor.

Există 4 opțiuni:

* Notare cumulativă - Se dau comentarii și o notă cu privire la aspectele specificate
* Comentarii - Comentariile sunt date cu privire la aspecte specificate, dar nu se poate acorda nicio notă
* Număr de erori - Comentarii și o evaluare da / nu sunt date cu privire la afirmațiile specificate
* Barem - Se oferă o grilă de evaluare cu privire la criteriile specificate';
$string['strategyhaschanged'] = 'Strategia de notare a atelierului s-a schimbat de când formularul a fost deschis pentru editare.';
$string['submission'] = 'Propunere';
$string['submissionattachment'] = 'Atașament';
$string['submissionby'] = 'Trimis de {$a}';
$string['submissioncontent'] = 'Conținutul lucrării';
$string['submissiondeleteconfirm'] = 'Sigur doriți să ștergeți următorul răspuns?';
$string['submissiondeleteconfirmassess'] = 'Sigur doriți să ștergeți următorul răspuns? Rețineți că acest lucru va șterge, de asemenea, {$a->count} evaluări asociate cu acest răspuns, care pot afecta calificativele evaluatorilor.';
$string['submissionend'] = 'Termen limită de trimitere';
$string['submissionendbeforestart'] = 'Termenul limită pentru răspunsuri nu poate fi specificat înainte de data de deschidere';
$string['submissionenddatetime'] = 'Termen limită de trimitere răspuns: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = 'Termenul limită pentru trimiteri {$a}';
$string['submissionendswitch'] = 'Treceți la faza următoare după termenul limită de trimitere răspuns';
$string['submissionendswitch_help'] = 'Dacă este specificat termenul limită de trimitere și această casetă este bifată, atelierul va trece automat la faza de evaluare după termenul limită de trimitere răspuns.

Dacă activați această caracteristică, se recomandă să configurați și metoda de alocare programată. Dacă trimiterile nu sunt alocate, nu se poate face nicio evaluare chiar dacă atelierul în sine se află în faza de evaluare.';
$string['submissiongrade'] = 'Nota pentru trimitere răspuns';
$string['submissiongrade_help'] = 'Această setare specifică nota maximă care poate fi obținută pentru lucrările trimise.';
$string['submissiongradeof'] = 'Nota pentru trimitere răspuns (din {$a})';
$string['submissionlastmodified'] = 'Ultima dată modificat în';
$string['submissionrequiredcontent'] = 'Trebuie să inserați text sau să adăugați un fișier.';
$string['submissionrequiredfile'] = 'Trebuie să adăugați un fișier sau să inserați text.';
$string['submissionsallocation'] = 'Alocare de răspunsuri trimise';
$string['submissionsettings'] = 'Setări de trimitere răspuns';
$string['submissionsreport'] = 'Raport de răspunsuri la atelier';
$string['submissionstart'] = 'Deschis pentru trimiteri răspunsuri de la';
$string['submissionstartdatetime'] = 'Deschis pentru trimitere răspunsuri de la {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} se deschide pentru trimitere răspunsuri';
$string['submissiontitle'] = 'Titlu';
$string['submissiontypedisabled'] = 'Acest tip de trimitere răspuns este dezactivat pentru acest atelier.';
$string['submissiontypefileavailable'] = 'Fișier atașat <span class = "accesshide"> disponibil </span>';
$string['submissiontypefilerequired'] = '<span class = "accesshide"> Fișier atașat </span> Obligatoriu';
$string['submissiontypes'] = 'Tipuri de răspunsuri';
$string['submissiontypetextavailable'] = 'Text online <span class = "accesshide"> disponibil </span>';
$string['submissiontypetextrequired'] = '<span class = "accesshide"> Text online </span> Obligatoriu';
$string['submittednotsubmitted'] = 'Au fost trimise ({$a->submitted}) / nu au fost trimise ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Metoda de alocare a răspunsurile trimitse';
$string['subplugintype_workshopallocation_plural'] = 'Metoda de alocare a răspunsurile trimitse';
$string['subplugintype_workshopeval'] = 'Metoda de notare a evaluării';
$string['subplugintype_workshopeval_plural'] = 'Metoda de notare a evaluării';
$string['subplugintype_workshopform'] = 'Strategia de notare';
$string['subplugintype_workshopform_plural'] = 'Strategii de notare';
$string['switchingphase'] = 'Comutare fază';
$string['switchphase'] = 'Comută faza actuală';
$string['switchphase10'] = 'Treceți la faza de configurare';
$string['switchphase10info'] = 'Sunteți pe cale să comutați atelierul în <strong> Faza de configurare </strong>. În această fază, utilizatorii nu își pot modifica trimiterile sau evaluările. Profesorii pot folosi această fază pentru a modifica setările atelierului, pentru a modifica strategia de notare sau pentru a modifica formularele de evaluare.';
$string['switchphase20'] = 'Treceți la faza de trimitere răspunsuri';
$string['switchphase20info'] = 'Sunteți pe cale să comutați atelierul în <strong> Faza de trimitere răspuns </strong>. Cursanții își pot prezenta lucrările în această fază (în termenele de control al accesului la trimitere a răspunsului, dacă sunt stabilite). Profesorii pot aloca răspunsuri pentru evaluare din partea colegilor.';
$string['switchphase30'] = 'Treceți la faza de evaluare';
$string['switchphase30auto'] = 'Atelierul va trece automat în faza de evaluare după {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Sunteți pe punctul de a comuta atelierul în <strong> Faza de evaluare </strong>. În această fază, examinatorii pot evalua răspunsurile care le-au fost alocate (în termenele de control al accesului la evaluare, dacă sunt stabilite).';
$string['switchphase40'] = 'Treceți la faza de evaluare';
$string['switchphase40info'] = 'Sunteți pe cale să comutați atelierul în <strong> Faza de evaluare a notării </strong>. În această fază, utilizatorii nu își pot modifica trimiterile sau evaluările. Profesorii pot utiliza instrumentele de evaluare a notării pentru a calcula notele finale și pentru a oferi feedback pentru evaluatori.';
$string['switchphase50'] = 'Atelier închis';
$string['switchphase50info'] = 'Ești pe cale să închizi atelierul. Acest lucru va duce la apariția notelor calculate în carnetul de note. Cursanții își pot vizualiza răspunsurile și evaluările lor.';
$string['switchphaseauto'] = 'Comutarea a fost programată';
$string['switchphasenext'] = 'Treceți la faza următoare';
$string['taskassesspeers'] = 'Evaluează colegii';
$string['taskassesspeersdetails'] = 'total: {$a->total} <br /> în așteptare: {$a->todo}';
$string['taskassessself'] = 'Evaluează-te';
$string['taskconclusion'] = 'Furnizează o concluzie asupra activității';
$string['taskdone'] = 'Sarcina realizată';
$string['taskfail'] = 'Sarcina eșuează';
$string['taskinfo'] = 'Informații despre sarcină';
$string['taskinstructauthors'] = 'Furnizați instrucțiuni pentru trimitere răspuns';
$string['taskinstructreviewers'] = 'Furnizați instrucțiuni pentru evaluare răspunsuri';
$string['taskintro'] = 'Setați descrierea atelierului';
$string['tasksubmit'] = 'Trimiteți răspunsul';
$string['tasktodo'] = 'Sarcină de făcut';
$string['toolbox'] = 'Set de instrumente pentru atelier';
$string['undersetup'] = 'Atelierul este în prezent în proces de configurare. Vă rugăm să așteptați până când se trece la faza următoare.';
$string['useexamples'] = 'Utilizează exemple';
$string['useexamples_desc'] = 'Sunt furnizate exemple de răspunsuri pentru exersare în evaluare';
$string['useexamples_help'] = 'Dacă este activat, utilizatorii pot încerca să evalueze unul sau mai multe exemple de răspunsuri și să compare evaluarea lor cu o evaluare de referință. Nota nu se ia în considerare în nota pentru evaluarea unui răspuns dat de colegi.';
$string['usepeerassessment'] = 'Folosiți evaluarea colegilor';
$string['usepeerassessment_desc'] = 'Cursanții pot evalua răspunsul altor cursanți';
$string['usepeerassessment_help'] = 'Dacă este activat, unui utilizator i se pot aloca răspunsuri trimise de alți colegi pentru a le evalua, în acest caz utilizatorul va primi o notă pentru evaluarea unui răspuns dat de colegi.
Această notă este diferită de nota obținută pentru propriul răspuns trimis.';
$string['userdatecreated'] = 'trimis în <span>{$a}</span>';
$string['userdatemodified'] = 'modificat în <span>{$a}</span>';
$string['userplan'] = 'Planificator de atelier';
$string['userplan_help'] = 'Planificatorul atelierului afișează toate fazele activității și listează sarcinile pentru fiecare fază. Faza curentă este evidențiată și finalizarea sarcinii este indicată cu o bifă.';
$string['userplanaccessibilityskip'] = 'Treceți la sarcinile curente';
$string['userplanaccessibilitytitle'] = 'Cronologia atelierului cu {$a} faze';
$string['userplancurrentphase'] = 'Faza curentă';
$string['useselfassessment'] = 'Activați opțiunea de auto-evaluare';
$string['useselfassessment_desc'] = 'Cursanții își pot evalua propriul răspuns';
$string['useselfassessment_help'] = 'Dacă este activat, unui utilizator i se poate aloca propriul răspuns trimis pentru a-l evalua, în acest caz utilizatorul va primi o notă pentru evaluarea răspunsului propriu.
Această notă este diferită de nota obținută pentru propriul răspuns trimis.';
$string['viewworkshopsummary'] = 'Vizualizați rezumatul atelierului';
$string['weightinfo'] = 'Pondere: {$a}';
$string['withoutsubmission'] = 'Evaluator fără răspuns propriu';
$string['workshop:addinstance'] = 'Adaugă un nou workshop';
$string['workshop:allocate'] = 'Alocați răspunsurile spre examinare';
$string['workshop:deletesubmissions'] = 'Ștergeți trimiterile';
$string['workshop:editdimensions'] = 'Editați formularele de evaluare';
$string['workshop:exportsubmissions'] = 'Exportați răspunsurile';
$string['workshop:ignoredeadlines'] = 'Ignorați restricțiile de timp';
$string['workshop:manageexamples'] = 'Gestionați răspunsurile exemplu';
$string['workshop:overridegrades'] = 'Înlocuiți notele calculate';
$string['workshop:peerassess'] = 'Evaluarea colegilor';
$string['workshop:publishsubmissions'] = 'Publică răspunsurile trimise';
$string['workshop:submit'] = 'Trimite';
$string['workshop:switchphase'] = 'Comutați faza';
$string['workshop:view'] = 'Vezi atelierul';
$string['workshop:viewallassessments'] = 'Vizualizați toate evaluările';
$string['workshop:viewallsubmissions'] = 'Vizualizați toate răspunsurile';
$string['workshop:viewauthornames'] = 'Vezi numele autorilor';
$string['workshop:viewauthorpublished'] = 'Vizualizați autorii răspunsurilor publicate';
$string['workshop:viewpublishedsubmissions'] = 'Vizualizați răspunsurile publicate';
$string['workshop:viewreviewernames'] = 'Vizualizați numele evaluatorilor';
$string['workshopname'] = 'Denumire atelier';
$string['yourassessmentfor'] = 'Evaluarea dvs. pentru {$a}';
$string['yourgrades'] = 'Notele dumneavoastră';
$string['yoursubmission'] = 'Lucrările dumneavoastră';
$string['yoursubmissionwithassessments'] = 'Răspunsul trimis și evaluările';
