<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'zh_cn', version '4.0'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = '活动';
$string['addcategory'] = '添加类别';
$string['addcategoryerror'] = '不能添加类别。';
$string['addexceptionerror'] = '添加例外时出错（用户ID：成绩项）';
$string['addfeedback'] = '添加反馈';
$string['addgradeletter'] = '添加一个分数段';
$string['addidnumbers'] = '添加 ID 号';
$string['additem'] = '添加成绩项';
$string['additionalfeedback'] = '额外的反馈';
$string['addoutcome'] = '添加一个成果';
$string['addoutcomeitem'] = '添加成果项';
$string['addscale'] = '添加一个量表';
$string['adjustedweight'] = '已调整权重';
$string['aggregateextracreditmean'] = '平均分（包括加分）';
$string['aggregatemax'] = '最高分';
$string['aggregatemean'] = '平均分';
$string['aggregatemedian'] = '中位数';
$string['aggregatemin'] = '最低分';
$string['aggregatemode'] = '众数';
$string['aggregatenotonlygraded'] = '包括空成绩';
$string['aggregateonlygraded'] = '排除空成绩';
$string['aggregateonlygraded_help'] = '空成绩是指成绩册中没有的成绩。一份还未评分的作业，或一个还未参加的测验等都会导致空成绩的出现。

此设置确定空成绩是不包含在汇总中，还是以最低分（例如评分范围为0-100的作业的最低分是0）计算。';
$string['aggregateoutcomes'] = '汇总中包括成果';
$string['aggregateoutcomes_help'] = '如果启用，成果将包括在汇总中。 这可能会导致意外的类别总分。';
$string['aggregatesonly'] = '更改为仅汇总';
$string['aggregatesubcatsupgradedgrades'] = '注意：作为站点升级的一部分，汇总设置“汇总包括子类别”已被删除。 由于本课程以前使用了“汇总包括子类别”，因此建议您在成绩册中查看此更改。';
$string['aggregatesum'] = '加权总分';
$string['aggregateweightedmean'] = '加权平均分';
$string['aggregateweightedmean2'] = '简单加权平均分';
$string['aggregation'] = '汇总';
$string['aggregation_help'] = '汇总算法确定一个类别中的成绩如何合并计算。例如：

* 平均分 - 所有分数的总和除以分数个数
* 中位数 - 把所有分数按大小排序后，处于中间位置的数值
* 最低分
* 最高分
* 众数 - 出现频率最高的分数
* 加权总分 - 所有按权重调整的分数的总和';
$string['aggregationcoef'] = '汇总系数';
$string['aggregationcoefextra'] = '加分';
$string['aggregationcoefextra_help'] = '当使用“加权总分”或“简单加权平均分”为汇总算法且“加分”复选框被勾选时，成绩项的最高分不会添加到类别的最高分。这将导致有可能在类别中获得最高分而在所有成绩项中均未达到最高分。如果站点管理员允许成绩超过最高分，则可能存在成绩超过最高分。

当使用“平均分（含加分）”汇总算法且加分值设为大于0时，此加分值会被当作一个因数与成绩相乘，然后再被加入总分，以计算平均分。';
$string['aggregationcoefextrasum'] = '加分';
$string['aggregationcoefextrasum_help'] = '如果“加分”复选框被勾选，此成绩项的最高分不会添加到类别的最高分，这将导致有可能在类别中获得最高分（或者超过最高分，如果站点管理员允许）而在所有成绩项中均未达到最高分。';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = '加分权重';
$string['aggregationcoefextraweight_help'] = '如果加分权重被设为一个大于0的数值，那么该成绩在汇总时会被当作加分。此数值会被当作一个因数与成绩相乘，然后再被加入总分，以计算平均分。';
$string['aggregationcoefweight'] = '成绩项权重';
$string['aggregationcoefweight_help'] = '在类别汇总中使用成绩项权重，以影响该成绩项相对于同一类别中其他成绩项的重要性。';
$string['aggregationhintdropped'] = '（去掉）';
$string['aggregationhintexcluded'] = '（排除）';
$string['aggregationhintextra'] = '（加分）';
$string['aggregationhintnovalue'] = '（空）';
$string['aggregationofa'] = '{$a}汇总';
$string['aggregationposition'] = '汇总位置';
$string['aggregationposition_help'] = '此设置确定类别和课程的总分列是显示在成绩册报表的第一列还是最后一列。';
$string['aggregationsvisible'] = '可用的汇总类型';
$string['aggregationsvisiblehelp'] = '选择所有可用的汇总类型。按住ctrl键选择多个。';
$string['allgrades'] = '按类别分类的所有成绩';
$string['allstudents'] = '所有学生';
$string['allusers'] = '所有用户';
$string['autosort'] = '自动排序';
$string['availableidnumbers'] = '可用的ID号';
$string['average'] = '平均值';
$string['averagesdecimalpoints'] = '列平均分小数位数';
$string['averagesdecimalpoints_help'] = '此设置确定每个平均分显示的小数位数，或者是否使用（继承）类别或成绩项的整体小数位数设置。';
$string['averagesdisplaytype'] = '列平均分显示类型';
$string['averagesdisplaytype_help'] = '此设置确定平均分显示为实际分数、百分比或分数段，或者类别或成绩项使用的显示类别（继承）。';
$string['backupwithoutgradebook'] = '备份不包含成绩册配置';
$string['badgrade'] = '提供的成绩无效';
$string['badlyformattedscale'] = '请输入若干个英文逗号分隔的值（至少要有两个值）。';
$string['baduser'] = '提供的用户不可用';
$string['bonuspoints'] = '奖励分';
$string['bulkcheckboxes'] = '批量复选框';
$string['calculatedgrade'] = '计算成绩';
$string['calculation'] = '计算方法';
$string['calculation_help'] = '成绩计算器是一个用来确定成绩的公式。该公式应该以等号（=）开始，可以使用常见的数学运算，比如max、min和sum。如果需要，也可以包含其它成绩项。只需在公式中输入它们的ID号，并用两个方括号括起来。';
$string['calculationadd'] = '添加计算方法';
$string['calculationedit'] = '编辑计算方法';
$string['calculationsaved'] = '计算方法已保存';
$string['calculationview'] = '查看计算方法';
$string['cannotaccessgroup'] = '无法访问选定小组的成绩，抱歉。';
$string['categories'] = '类别';
$string['category'] = '类别';
$string['categoryedit'] = '编辑类别';
$string['categoryname'] = '类别名称';
$string['categorytotal'] = '类别总分';
$string['categorytotalfull'] = '{$a->category}总分';
$string['categorytotalname'] = '类别总分名称';
$string['changedefaults'] = '更改默认设置';
$string['changereportdefaults'] = '更改报表默认设置';
$string['chooseaction'] = '选择一个操作…';
$string['choosecategory'] = '选择类别';
$string['collapsecriterion'] = '折叠标准';
$string['combo'] = '标签页和下拉菜单';
$string['compact'] = '学习契约';
$string['componentcontrolsvisibility'] = '在活动设置中控制是否隐藏该成绩项。';
$string['contract'] = '学习契约类别';
$string['contributiontocoursetotal'] = '对课程总分的贡献';
$string['controls'] = '控制';
$string['courseavg'] = '课程平均值';
$string['coursegradecategory'] = '课程成绩类别';
$string['coursegradedisplaytype'] = '课程成绩显示类型';
$string['coursegradedisplayupdated'] = '课程成绩显示类型已更新';
$string['coursegradesettings'] = '课程成绩设置';
$string['coursename'] = '课程名称';
$string['coursescales'] = '课程量表';
$string['coursesettings'] = '课程设置';
$string['coursesettingsexplanation'] = '课程设置确定此课程的参与人会看到什么样的成绩册';
$string['coursesiamtaking'] = '我正在学习的课程';
$string['coursesiamteaching'] = '我正在教授的课程';
$string['coursetotal'] = '课程总分';
$string['createcategory'] = '创建类别';
$string['createcategoryerror'] = '无法创建新类别';
$string['creatinggradebooksettings'] = '创建成绩册设置';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = '当前父汇总';
$string['curveto'] = '曲线拟合到';
$string['decimalpoints'] = '整体小数位数';
$string['decimalpoints_help'] = '此设置确定每个成绩要显示的小数位数。 它对成绩计算没有影响，成绩计算精确到小数点后五位。';
$string['default'] = '默认值';
$string['defaultprev'] = '默认({$a})';
$string['deletecategory'] = '删除类别';
$string['deletescale'] = '删除分数等级';
$string['disablegradehistory'] = '禁用成绩历史记录';
$string['disablegradehistory_help'] = '禁用与成绩相关的表的更改的历史记录跟踪。 这可能会加快服务器速度，并节省数据库空间。';
$string['displaylettergrade'] = '显示分数段';
$string['displaypercent'] = '显示百分比';
$string['displaypoints'] = '显示分数';
$string['displayweighted'] = '显示加权成绩';
$string['dropdown'] = '下拉菜单';
$string['droplow'] = '去掉最低分';
$string['droplow_help'] = '此设置允许从汇总中排除指定数量的最低分。';
$string['droplowestvalue'] = '设置去掉最低分值';
$string['droplowestvalues'] = '去掉{$a}个最低分值';
$string['dropped'] = '去掉';
$string['dropxlowest'] = '去掉X个最低分';
$string['dropxlowestwarning'] = '注意：如果您使用“去掉X个最低分”，则评分将假定类别中的所有成绩项都具有相同的分值。 如果分值不同，结果将不可预测';
$string['duplicatedgradeitem'] = '{$a} (复制)';
$string['duplicatescale'] = '复制量表';
$string['edit'] = '编辑';
$string['editcalculation'] = '编辑计算方法';
$string['editcalculationverbose'] = '编辑{$a->category}{$a->itemmodule}{$a->itemname}的计算方法';
$string['editfeedback'] = '编辑反馈';
$string['editgrade'] = '编辑成绩';
$string['editgradeletters'] = '编辑分数段';
$string['editoutcome'] = '编辑成果';
$string['editoutcomes'] = '编辑成果';
$string['editscale'] = '编辑量表';
$string['edittree'] = '设置';
$string['editverbose'] = '编辑{$a->category}{$a->itemmodule}{$a->itemname}';
$string['enableajax'] = '启用 AJAX';
$string['enableajax_help'] = '在评分人报表中添加一层 AJAX 功能，将简化和加速常用操作。这取决于在用户浏览器端 Javascript 功能是否启用。';
$string['enableoutcomes'] = '启用成果';
$string['enableoutcomes_help'] = '如果启用，成绩项可以使用一个或多个与成果声明绑定的量表进行评分。';
$string['encoding'] = '编码';
$string['encoding_help'] = '选择用于该数据的字符编码。（标准编码为UTF-8。）如果不小心选择了错误编码，在预览导入的数据时会很明显。';
$string['errorcalculationbroken'] = '很可能为循环引用或错误的计算公式';
$string['errorcalculationnoequal'] = '公式必须以等号开始(=1+2)';
$string['errorcalculationunknown'] = '无效的公式';
$string['errorgradevaluenonnumeric'] = '您输入的低分或高分不是数值';
$string['errornocalculationallowed'] = '不允许对此项进行计算';
$string['errornocategorisedid'] = '无法获取未分类的ID！';
$string['errornocourse'] = '无法获取课程信息';
$string['errorreprintheadersnonnumeric'] = '重印标题的值不是数值';
$string['errorsavegrade'] = '不能保存成绩，抱歉。';
$string['errorsettinggrade'] = '保存用户 {$a->userid}的"{$a->itemname}" 成绩时发生错误。';
$string['errorupdatinggradecategoryaggregateonlygraded'] = '在更新 ID 为{$a->id}的成绩类别的“只汇总非空成绩”设置时出错';
$string['errorupdatinggradecategoryaggregateoutcomes'] = '更新成绩类别 ID 为{$a->id}的“汇总中包括成果”设置出错';
$string['errorupdatinggradecategoryaggregation'] = '更新成绩类别ID为{$a->id}的汇总类型出错';
$string['errorupdatinggradeitemaggregationcoef'] = '更新成绩项 ID 为{$a->id}的汇总系数(权重或加分)出错';
$string['eventgradedeleted'] = '成绩已删除';
$string['eventgradeitemcreated'] = '成绩项已创建';
$string['eventgradeitemdeleted'] = '成绩项目已删除';
$string['eventgradeitemupdated'] = '成绩项已更新';
$string['eventgradelettercreated'] = '分数段已创建';
$string['eventgradeletterdeleted'] = '分数段已删除';
$string['eventgradeletterupdated'] = '分数段已更新';
$string['eventgradeviewed'] = '在成绩册中查看了成绩';
$string['eventscalecreated'] = '量表已创建';
$string['eventscaledeleted'] = '量表已删除';
$string['eventscaleupdated'] = '量表已更新';
$string['eventusergraded'] = '用户已评分';
$string['excluded'] = '排除';
$string['excluded_help'] = '如果勾选，此成绩将不包括在任何汇总中。';
$string['expand'] = '展开类别';
$string['expandcriterion'] = '展开标准';
$string['export'] = '导出';
$string['exportalloutcomes'] = '导出所有成果';
$string['exportfeedback'] = '导出中包括反馈';
$string['exportfeedback_desc'] = '可以在导出期间覆盖它。';
$string['exportformatoptions'] = '导出格式选项';
$string['exportonlyactive'] = '不包括已暂停用户';
$string['exportonlyactive_help'] = '导出中只包括选课活跃且未暂停的学生';
$string['exportplugins'] = '导出插件';
$string['exportsettings'] = '导出设置';
$string['exportto'] = '导出至';
$string['externalurl'] = '外部网址';
$string['externalurl_desc'] = '如使用外部成绩册，必须在此处指定网址。';
$string['extracreditvalue'] = '{$a}的加分值';
$string['extracreditwarning'] = '注意：将一个类别的所有成绩项设置为加分将有效地从成绩计算中移除它们。因为将没有总分';
$string['fail'] = '不及格';
$string['feedback'] = '反馈';
$string['feedback_help'] = '此框允许添加有关成绩的任何评论。';
$string['feedbackadd'] = '添加反馈';
$string['feedbackedit'] = '编辑反馈';
$string['feedbackfiles'] = '反馈文件';
$string['feedbackforgradeitems'] = '给{$a}反馈';
$string['feedbackhistoryfiles'] = '反馈历史记录文件';
$string['feedbacks'] = '反馈';
$string['feedbacksaved'] = '反馈已保存';
$string['feedbackview'] = '查看反馈';
$string['finalgrade'] = '最终成绩';
$string['finalgrade_help'] = '如果选中了覆盖复选框，则可以添加或修改成绩。';
$string['fixedstudents'] = '锁定学生列';
$string['fixedstudents_help'] = '锁定学生列，可以水平滚动成绩，而不会看不到学生列。';
$string['forceimport'] = '强制导入';
$string['forceimport_help'] = '强制导入成绩，即使在导入文件导出后更新了成绩';
$string['forceoff'] = '强制：关闭';
$string['forceon'] = '强制：打开';
$string['forelementtypes'] = '对选定的{$a}';
$string['forstudents'] = '对学生';
$string['full'] = '完整';
$string['fullmode'] = '切换至完整视图';
$string['generalsettings'] = '常规设置';
$string['grade'] = '成绩';
$string['grade_help'] = '对学生的学习给予的成绩。';
$string['gradeadministration'] = '成绩管理';
$string['gradealreadyupdated'] = '{$a}成绩未被导入，因为导入文件中的成绩比评分人报表中的更旧。如仍要继续导入成绩，请使用强制导入选项。';
$string['gradeanalysis'] = '成绩分析';
$string['gradebook'] = '成绩册';
$string['gradebookcalculationsfixbutton'] = '接受成绩变更并修正计算错误';
$string['gradebookcalculationsuptodate'] = '成绩册中的计算是最新的。 您可能需要重新加载此页面才能查看更改。';
$string['gradebookcalculationswarning'] = '注意：在计算成绩册中显示的成绩时检测到一些错误。 如果您的课程尚未开始或正在进行中，建议通过点击下面的按钮来修复错误，尽管这会导致某些成绩被更改。 如果您的课程已经结束并且已提交成绩，您最好不要修复此错误。

较新的版本是{$a->currentversion}，您使用的是成绩册版本是{$a->gradebookversion}。 您可以在<a href="{$a->url}“> 成绩册计算更改</a>中看到更改列表。';
$string['gradebookhiddenerror'] = '当前成绩册设置为对学生隐藏所有信息。';
$string['gradebookhistories'] = '成绩历史记录';
$string['gradebooksetup'] = '成绩册设置';
$string['gradeboundary'] = '分数段范围';
$string['gradeboundary_help'] = '此设置确定将为成绩分配分数段的最小百分比。';
$string['gradecategories'] = '成绩类别';
$string['gradecategory'] = '成绩类别';
$string['gradecategoryonmodform'] = '成绩类别';
$string['gradecategoryonmodform_help'] = '此设置控制此活动的成绩在成绩册中放置的类别。';
$string['gradecategorysettings'] = '成绩类别设置';
$string['gradedisplay'] = '成绩显示';
$string['gradedisplaytype'] = '成绩显示类型';
$string['gradedisplaytype_help'] = '此设置确定评分人和用户报表中显示成绩的类型。

* 分数段 - 多个字母或词语用来表示一个成绩范围，如在成绩册设置中定义的“分数段”
* 百分比 - 相对于最高和最低分
* 实际 - 实际分数或量表值';
$string['gradedon'] = '评分：{$a}';
$string['gradeexport'] = '成绩导出';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = '成绩导出自定义个人档案字段';
$string['gradeexportcustomprofilefields_desc'] = '在成绩导出中包含这些自定义个人档案字段，用逗号分隔。';
$string['gradeexportdecimalpoints'] = '成绩导出的小数位数';
$string['gradeexportdecimalpoints_desc'] = '导出时显示的小数位数。在导出时可以更改这个选项。';
$string['gradeexportdisplaytype'] = '导出成绩的显示类型';
$string['gradeexportdisplaytype_desc'] = '成绩在导出时可以以实际分数、百分比（基于最低分和最高分计算）或分数段（优秀、良好、及格等等）类型显示。在导出时可以更改这个选项。';
$string['gradeexportdisplaytypes'] = '成绩导出显示类型';
$string['gradeexportuserprofilefields'] = '成绩导出用户个人档案字段';
$string['gradeexportuserprofilefields_desc'] = '在成绩导出中包含这些用户个人档案字段，用逗号分隔。';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = '初始的最低和最高分';
$string['gradehelp'] = '成绩帮助';
$string['gradehistorylifetime'] = '成绩历史记录生存期';
$string['gradehistorylifetime_help'] = '这指定您要保留与成绩相关的表的更改历史记录的时间长度。 建议保持尽可能长的时间。 如果遇到性能问题或数据库空间有限，请尝试设置较低的值。';
$string['gradeimport'] = '成绩导入';
$string['gradeimportfailed'] = '成绩导入失败。详情：';
$string['gradeitem'] = '成绩项';
$string['gradeitemaddusers'] = '不参与评分';
$string['gradeitemadvanced'] = '高级成绩项选项';
$string['gradeitemadvanced_help'] = '选择编辑成绩项时应显示为高级的所有元素。';
$string['gradeitemislocked'] = '该活动在成绩册中被锁定。因此该活动的成绩更改将不会复制到成绩册中，除非该锁定解除。';
$string['gradeitemlocked'] = '评分锁定';
$string['gradeitemmembersselected'] = '不参与评分';
$string['gradeitemminmax'] = '成绩项设置中指定的最低和最高分';
$string['gradeitemnonmembers'] = '参与评分';
$string['gradeitemremovemembers'] = '参与评分';
$string['gradeitems'] = '成绩项';
$string['gradeitemsettings'] = '成绩项设置';
$string['gradeitemsinc'] = '包含成绩项';
$string['gradeletter'] = '分数段';
$string['gradeletter_help'] = '分数段是一系列表示分数所处范围的文字，比如“优秀、中等、良好、及格、...”，“A、B、C、...”';
$string['gradeletternote'] = '要删除一个分段，只需清空上面三项中的任何一项，并提交。';
$string['gradeletteroverridden'] = '默认的分数段当前被覆盖。';
$string['gradeletters'] = '分数段';
$string['gradelocked'] = '成绩被锁定';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = '最高分';
$string['grademax_help'] = '此设置确定使用数值成绩类型时的最高分。基于活动的成绩项的最高分在活动设置页面设置。';
$string['grademin'] = '最低分';
$string['grademin_help'] = '此设置确定使用数值成绩类型时的最低分。';
$string['gradenotificationmessage'] = '您对“ {$a}”的学习有新的反馈';
$string['gradenotificationsubject'] = '您已被评分';
$string['gradeoutcomeitem'] = '成绩成果项';
$string['gradeoutcomes'] = '成果';
$string['gradeoutcomescourses'] = '课程成果';
$string['gradepass'] = '及格成绩';
$string['gradepass_help'] = '此设置确定及格成绩的最低分。 该值用于计算活动和课程的完成情况。在成绩册中，及格成绩以绿色突出显示，不及格成绩以红色突出显示。';
$string['gradepassgreaterthangrade'] = '及格成绩不能超过可能的最高成绩{$a}';
$string['gradepointdefault'] = '默认分数';
$string['gradepointdefault_help'] = '此设置确定成绩项中可用分数的默认值。';
$string['gradepointdefault_validateerror'] = '此设置必须是1到最高分之间的整数。';
$string['gradepointmax'] = '最高分';
$string['gradepointmax_help'] = '此设置确定活动可用的最高分。';
$string['gradepointmax_validateerror'] = '此设置必须是1到10000之间的整数。';
$string['gradepreferences'] = '成绩偏好';
$string['gradepreferenceshelp'] = '成绩偏好帮助';
$string['gradepublishing'] = '启用成绩发布功能';
$string['gradepublishing_help'] = '成绩发布功能无需登录 Moodle 即可通过URL导入和导出成绩。如启用，各课程成绩册中将为管理员及拥有发布成绩权限的用户(默认仅管理员角色用户)提供成绩导出发布设置。';
$string['gradepublishinglink'] = '下载：{$a}';
$string['gradereport'] = '成绩报表';
$string['graderreport'] = '评分人报表';
$string['grades'] = '成绩';
$string['gradesforuser'] = '{$a->user}的成绩';
$string['gradesmoduledeletionpendingwarning'] = '警告：正在删除活动！一些成绩也将被移除。';
$string['gradesmoduledeletionprefix'] = '[删除进行中]';
$string['gradesonly'] = '更改为仅分数';
$string['gradessettings'] = '成绩设置';
$string['gradetype'] = '成绩类型';
$string['gradetype_help'] = '有 4 种成绩类型：

* 无 - 没有成绩
* 数值 - 一个有最大值和最小值的数值
* 量表 - 列表中的一项
* 文本 - 只有反馈

只有数值和量表成绩类型可以汇总。基于活动的成绩项的成绩类型在活动设置页面设置。';
$string['gradevaluetoobig'] = '一个成绩值大于{$a}所允许的最高分值';
$string['gradeview'] = '查看成绩';
$string['gradewasmodifiedduringediting'] = '为 {$a->username}输入的{$a->itemname}成绩被忽略，因为最近有人更新了它。';
$string['gradeweighthelp'] = '成绩权重帮助';
$string['gradingmodulename'] = '评分 ({$a})';
$string['groupavg'] = '小组平均分';
$string['hidden'] = '隐藏';
$string['hidden_help'] = '如果勾选，则对学生隐藏成绩。 如果需要，可以设置一个隐藏的截止日期，以便在评分完成后公布成绩。';
$string['hiddenasdate'] = '显示隐藏成绩的提交日期';
$string['hiddenasdate_help'] = '如果用户不能看到隐藏的成绩，那么显示提交时间，而不是“-”。';
$string['hiddenuntil'] = '隐藏到';
$string['hiddenuntildate'] = '隐藏到: {$a}';
$string['hideadvanced'] = '隐藏高级功能';
$string['hideaverages'] = '隐藏平均分';
$string['hidecalculations'] = '隐藏计算方法';
$string['hidecategory'] = '隐藏';
$string['hideeyecons'] = '隐藏 显示/隐藏 图标';
$string['hidefeedback'] = '隐藏反馈';
$string['hideforcedsettings'] = '隐藏强制设置';
$string['hideforcedsettings_help'] = '不要在评分界面中显示强制设置。';
$string['hidegroups'] = '隐藏小组';
$string['hidelocks'] = '隐藏锁定';
$string['hidenooutcomes'] = '显示成果';
$string['hidequickfeedback'] = '隐藏快速反馈';
$string['hideranges'] = '隐藏范围';
$string['hidetotalifhiddenitems'] = '如果包含隐藏的成绩项，就隐藏总分';
$string['hidetotalifhiddenitems_help'] = '此设置确定包含隐藏成绩项的总分是显示给学生，还是被替换为连字符（-）。如果显示，总分的计算可以包含或不包含隐藏的成绩项。

如果不包含隐藏的成绩项，总分可能会和教师在评分人报表中看到的不同，因为教师总是能看到包含所有成绩项的总分，无论隐藏的还是不隐藏的。如果包含隐藏的成绩项，那么学生可以计算出隐藏的成绩项。';
$string['hidetotalshowexhiddenitems'] = '显示不包含隐藏成绩项的总分';
$string['hidetotalshowinchiddenitems'] = '显示包含隐藏成绩项的总分';
$string['hideverbose'] = '隐藏 {$a->category}{$a->itemmodule}{$a->itemname}';
$string['highgradeascending'] = '按高分升序排序';
$string['highgradedescending'] = '按高分降序排序';
$string['highgradeletter'] = '高至';
$string['identifier'] = '识别用户';
$string['idnumbers'] = 'ID号';
$string['ignore'] = '忽视';
$string['import'] = '导入';
$string['importcsv'] = '导入 CSV';
$string['importcsv_help'] = '成绩可以通过 CSV 文件导入，格式如下：

* 文件的每一行包含一条记录
* 每一条记录是一系列以逗号(或其他分隔符号)分隔的数据
* 第一条记录是包含所有字段名称的清单，用来定义文件其余部分的格式
* 其中一个字段名称必须要包含用户的识别数据，可以是用户名、ID号或EMAIL地址

您可以先导出一些成绩来获得这个文件的正确格式。然后将这一文件加以编辑并保存为 CSV 文件。';
$string['importcustom'] = '作为自定义成果导入（仅在此课程中）';
$string['importdata'] = '数据';
$string['importdata_help'] = '成绩可以直接从 OpenDocument 或 Excel 电子表格粘贴，格式如下：

* 至少一列应包含用户身份数据 - 用户名、电子邮件地址或 ID 号。
* 其他栏应有与现有活动或成绩项目相同的标题。

通过首先导出一些成绩可以获得格式正确的电子表格。 然后可以编辑电子表格以添加更多成绩并保存。

从电子表格中选择并复制要导入的列，然后将它们粘贴到此字段中。';
$string['importerror'] = '发生错误，脚本调用参数不正确。';
$string['importfailed'] = '导入失败。未导入任何数据。';
$string['importfeedback'] = '导入反馈';
$string['importfile'] = '导入文件';
$string['importfilemissing'] = '没有收到文件，请返回表单并确保上传有效文件。';
$string['importfrom'] = '导入从';
$string['importoutcomenofile'] = '上传的文件为空或损坏。请确认这是有效文件。在{$a}行检测到问题。这是由于数据行的列数不及第一行（标题行）或导入的文件缺少预期的标题而触发的。请查看导出的文件，以获取具有有效标题的文件示例。';
$string['importoutcomes'] = '导入成果';
$string['importoutcomes_help'] = '可以从 CSV 文件导入成果。文件格式和导出成果的 CSV 文件一致。';
$string['importoutcomesuccess'] = '已导入成果"{$a->name}"，ID：#{$a->id}。';
$string['importplugins'] = '导入插件';
$string['importpreview'] = '导入预览';
$string['importsettings'] = '导入设置';
$string['importskippednomanagescale'] = '您没有添加新量表的权限，因此成果“{$a}”被跳过，因为它需要创建一个新量表。';
$string['importskippedoutcome'] = '在此场景中已经存在简称为“{$a}”的成果，已跳过导入文件中的成果。';
$string['importstandard'] = '作为标准成果导入';
$string['importsuccess'] = '成绩导入成功';
$string['importxml'] = '导入 XML';
$string['includescalesinaggregation'] = '在汇总中包括量表';
$string['includescalesinaggregation_help'] = '您可以更改是否将量表以数字的形式在所有课程的所有成绩册中进行汇总。警告：更改该设置将强制所有的汇总成绩重新计算。';
$string['incorrectcourseid'] = '课程 ID 不正确';
$string['incorrectcustomscale'] = '（不正确的自定义量表，请修改）';
$string['incorrectminmax'] = '最低分必须低于最高分';
$string['inherit'] = '继承';
$string['intersectioninfo'] = '学生/成绩信息';
$string['invalidgradeexporteddate'] = '此导出日期无效，因为它早于一年以前，或日期在将来，或日期格式无效。';
$string['item'] = '成绩项';
$string['iteminfo'] = '成绩项信息';
$string['iteminfo_help'] = '此设置提供了用于输入成绩项信息的空间。 该信息不会在其他任何地方显示。';
$string['itemname'] = '成绩项名称';
$string['itemnamehelp'] = '此成绩项的名称，由模块推入。';
$string['items'] = '成绩项';
$string['itemsedit'] = '编辑成绩项';
$string['keephigh'] = '保留最高分';
$string['keephigh_help'] = '如果设置，此选项将只保留X个最高分，X是该选项的选定值。';
$string['keephighestvalues'] = '保留 {$a} 个最高分';
$string['keymanager'] = '密钥管理器';
$string['lessthanmin'] = '为 {$a->username} 的 {$a->itemname} 输入的分数小于允许的最低分';
$string['letter'] = '分数段';
$string['lettergrade'] = '分数段';
$string['lettergradenonnumber'] = '低分和/或高分不是数值';
$string['letterpercentage'] = '分数段（百分比）';
$string['letterreal'] = '分数段（分数）';
$string['letters'] = '分数段';
$string['linkedactivity'] = '链接的活动';
$string['linkedactivity_help'] = '此设置指定一个与此成果项链接的活动。这将作为与活动成绩无关的评价标准来衡量学生的表现。';
$string['linktoactivity'] = '链接到 {$a->name} 活动 {$a->title}';
$string['lock'] = '锁定';
$string['locked'] = '锁定';
$string['locked_help'] = '如果选中，则成绩不再可以由相关活动自动更新。';
$string['locktime'] = '在何时之后锁定';
$string['locktimedate'] = '在{$a}之后锁定';
$string['lockverbose'] = '锁定{$a->category}{$a->itemmodule}{$a->itemname}';
$string['lowest'] = '最低';
$string['lowgradeletter'] = '低';
$string['manageoutcomes'] = '管理成绩';
$string['manualitem'] = '手动成绩项';
$string['mapfrom'] = '映射自';
$string['mapfrom_help'] = '选择电子表格中包含用于标识用户的数据列，如用户名、用户ID或电子邮件地址。';
$string['mappings'] = '成绩项映射';
$string['mappings_help'] = '对于电子表格中的每一列分数，选择相应的成绩项将分数导入。';
$string['mapto'] = '映射到';
$string['mapto_help'] = '选择与“映射自”相同的标识数据。';
$string['max'] = '最高';
$string['maxgrade'] = '最高分';
$string['meanall'] = '所有成绩';
$string['meangraded'] = '非空成绩';
$string['meanselection'] = '为列平均分选择的分数';
$string['meanselection_help'] = '此设置确定在计算每个类别或成绩项的平均分（均值）时是否应包括没有成绩的单元格。';
$string['median'] = '中位数';
$string['min'] = '最低';
$string['minimum_show'] = '显示最低分';
$string['minimum_show_help'] = '最低分用于计算成绩和权重。 如果不显示，则最低分将默认为0，并且无法编辑。';
$string['minmaxtouse'] = '计算中使用的最低和最高分';
$string['minmaxtouse_desc'] = '‎此设置确定在计算成绩册中显示的成绩时，是使用给出成绩时的初始最低和最高分，还是使用成绩项设置中指定的最低和最高分。建议在非高峰时间修改此设置，因为将重新计算所有成绩，这可能导致服务器负载高。‎';
$string['minmaxtouse_help'] = '‎此设置确定在计算成绩册中显示的成绩时，是使用给出成绩时的初始最低和最高分，还是使用成绩项设置中指定的最低和最高分。建议在非高峰时间修改此设置，因为将重新计算所有成绩，这可能导致服务器负载高。‎';
$string['minmaxupgradedgrades'] = '注意：为了解决成绩册中由于计算显示的成绩时使用的最低和最高分更改而引起的不一致，对某些成绩进行了更改。 建议检查并接受更改。';
$string['minmaxupgradefixbutton'] = '解决不一致';
$string['minmaxupgradewarning'] = '注意：为了解决成绩册中由于计算显示的成绩时使用的最低和最高分更改而引起的不一致，对某些成绩进行了更改。 建议检查并接受更改。';
$string['missingitemtypeoreid'] = '数组键(itemtype或eid)在grade_edit_tree_column_select::get_item_cell($item， $params)的第二个参数中丢失';
$string['missingscale'] = '必须选择量表';
$string['mode'] = '模式';
$string['modgrade'] = '成绩';
$string['modgrade_help'] = '选择该活动使用的评分类型。如果选择“量表”，那么您可以从“量表”下拉菜单中选择量表。如果使用“分数”评分，您可以输入这个活动可用的最高分。';
$string['modgradecantchangegradetype'] = '您不能更改类型，因为此项的分数已经存在。';
$string['modgradecantchangegradetypemsg'] = '某些分数已经授予，所以不能更改成绩类型。如果您想更改最高分，您必须首先选择是否重新调整现有分数。';
$string['modgradecantchangegradetyporscalemsg'] = '某些分数已经授予，所以该成绩类型和量表不能更改。';
$string['modgradecantchangeratingmaxgrade'] = '当一个活动的评分已经存在时，您不能更改该活动的最高分。';
$string['modgradecantchangescale'] = '您不能更改该量表，因为这个项目已经有分数了。';
$string['modgradecategorycantchangegradetypemsg'] = '与此类别相关的成绩项已经被覆盖。因此，某些分数已经被授予，所以不能更改成绩类型。如果您想更改最高分，您必须首先选择是否重新调整现有分数。';
$string['modgradecategorycantchangegradetyporscalemsg'] = '与此类别相关的成绩项已经被覆盖。因此，某些分数已经被授予，所以不能更改成绩类型和量表。';
$string['modgradecategoryrescalegrades'] = '重新调整覆盖的分数';
$string['modgradecategoryrescalegrades_help'] = '更改成绩册项目的最高分时，您需要指定是否会导致现有百分比成绩也发生变化。

如果将其设置为“是”，则将重新调整任何现有的已覆盖成绩，以使百分比成绩保持不变。

例如，如果将此选项设置为“是”，则将项目的最高分从10更改为20将导致成绩6/10（60％）重新调整为12/20（60％）。 将此选项设置为“否”时，成绩将保持不变，需要手动调整成绩项以确保分数正确。';
$string['modgradedonotmodify'] = '不修改现有分数';
$string['modgradeerrorbadpoint'] = '无效的分数值。它必须是1和{$a}之间的整数';
$string['modgradeerrorbadscale'] = '选择的量表无效。请确保您从下面的选项中选择一个量表。';
$string['modgrademaxgrade'] = '最高分';
$string['modgraderescalegrades'] = '重新调整已有的分数';
$string['modgraderescalegrades_help'] = '更改成绩册项目的最高分时，您需要指定是否会导致现有百分比成绩也发生变化。

如果将其设置为“是”，则将重新调整任何现有的已覆盖成绩，以使百分比成绩保持不变。

例如，如果将此选项设置为“是”，则将项目的最高分从10更改为20将导致成绩6/10（60％）重新调整为12/20（60％）。 将此选项设置为“否”时，成绩将保持不变，需要手动调整成绩项以确保分数正确。';
$string['modgradetype'] = '类型';
$string['modgradetypenone'] = '无';
$string['modgradetypepoint'] = '分数';
$string['modgradetypescale'] = '量表';
$string['morethanmax'] = '为{$a->username}的{$a->itemname}输入的分数高于允许的最高分';
$string['moveselectedto'] = '将所选项目移至';
$string['movingelement'] = '移至{$a}';
$string['multfactor'] = '乘数';
$string['multfactor_help'] = '乘数是该成绩项的所有成绩将相乘的因数，其最大值为最高分。例如，如果乘数为2，最大分为100，那么所有小于50的成绩都乘以2，所有50及以上的成绩都更改为100。';
$string['multfactorvalue'] = '对{$a}的乘数值';
$string['mustchooserescaleyesorno'] = '您必须选择是否重新调整现有的分数。';
$string['mygrades'] = '用户菜单成绩链接';
$string['mygrades_desc'] = '此设置允许您从用户菜单中选择链接到外部成绩册的选项。';
$string['mypreferences'] = '我的偏好';
$string['myreportpreferences'] = '我的成绩报表偏好';
$string['navmethod'] = '导航模式';
$string['neverdeletehistory'] = '永远不删除历史记录';
$string['newcategory'] = '新类别';
$string['newitem'] = '新成绩项';
$string['newoutcomeitem'] = '新成果项';
$string['no'] = '否';
$string['nocategories'] = '此课程的成绩类别无法添加或找不到';
$string['nocategoryname'] = '未给出类别名称。';
$string['nocategoryview'] = '没有要查看的类别';
$string['nocourses'] = '目前还没有课程';
$string['noexistingoutcomes'] = '没有已出成绩。';
$string['noexistingscales'] = '没有已有的成绩等级。';
$string['noforce'] = '不强制';
$string['nogradeletters'] = '未设定分数段';
$string['nogradesreturned'] = '没有返回成绩';
$string['noidnumber'] = '没有 ID 号';
$string['nolettergrade'] = '无分数段给';
$string['nomode'] = '无';
$string['nonnumericweight'] = '收到的非数字值';
$string['nonunlockableverbose'] = '只有{$a->itemname}解锁后成绩才能解锁。';
$string['nonweightedpct'] = '非加权%';
$string['nooutcome'] = '没有成果';
$string['nooutcomes'] = '成果项必须链接到一个课程成果，但是此课程没有成果。您想添加一个吗？';
$string['nopermissiontoresetweights'] = '没有权限重设权重';
$string['nopublish'] = '不发布';
$string['noreports'] = '您没有选课，也没有在该站点上教授任何课程。';
$string['norolesdefined'] = '在“管理 > 成绩 > 常规设置 > 有成绩的角色”中没有定义角色';
$string['noscales'] = '成果必须链接到一个课程量表或全局量表，但现在没有。 您要添加一个吗？';
$string['noselectedcategories'] = '没有选择类别。';
$string['noselecteditems'] = '没有选择任何项目。';
$string['notenrolled'] = '您目前没有加入任何课程。';
$string['notteachererror'] = '只有教师能使用此特性。';
$string['nousersloaded'] = '未加载任何用户';
$string['nouserstograde'] = '没有用户需要评分';
$string['numberofgrades'] = '成绩数量';
$string['onascaleof'] = '在{$a->grademin}到{$a->grademax}的量表上';
$string['operations'] = '操作';
$string['options'] = '选项';
$string['others'] = '其它';
$string['outcome'] = '成果';
$string['outcome_help'] = '此设置确定此成绩项在成绩册中将用哪个成果表示。';
$string['outcomeassigntocourse'] = '向此课程分配另一个成果';
$string['outcomecategory'] = '在类别中创建成果';
$string['outcomecategorynew'] = '新类别';
$string['outcomeconfirmdelete'] = '您确定要删除成果"{$a}"吗?';
$string['outcomecreate'] = '添加新成果';
$string['outcomedelete'] = '删除成果';
$string['outcomefullname'] = '全名';
$string['outcomeitem'] = '成果项';
$string['outcomeitemsedit'] = '编辑成果项';
$string['outcomereport'] = '成果报表';
$string['outcomes'] = '成果';
$string['outcomescourse'] = '在课程中使用的结果';
$string['outcomescoursecustom'] = '已使用自定义（不移除）';
$string['outcomescoursenotused'] = '未使用的标准';
$string['outcomescourseused'] = '已使用的标准(不移除)';
$string['outcomescustom'] = '自定义成果';
$string['outcomeshortname'] = '简称';
$string['outcomesstandard'] = '标准成果';
$string['outcomesstandardavailable'] = '可用的标准成果';
$string['outcomestandard'] = '标准成果';
$string['outcomestandard_help'] = '标准成果可以被全站所有课程使用。';
$string['overallaverage'] = '总体平均分';
$string['overridden'] = '覆盖';
$string['overridden_help'] = '如果选中，则不再可以在相关活动中更改成绩。

在评分人报表中编辑成绩后，将自动选中“覆盖”复选框。 但是，可以取消勾选，允许通过相关活动更改成绩。';
$string['overriddennotice'] = '您在此活动中的最终成绩是手动调整的。';
$string['overridecat'] = '允许类别成绩被手动覆盖';
$string['overridecat_help'] = '禁用此设置将使用户无法覆盖类别成绩。';
$string['overridesitedefaultgradedisplaytype'] = '覆盖站点默认值';
$string['overridesitedefaultgradedisplaytype_help'] = '如果勾选，则可以设置课程的分数段和分数范围，而不是使用站点默认值。';
$string['overrideweightofa'] = '覆盖{$a}的权重';
$string['parentcategory'] = '父类别';
$string['pass'] = '通过';
$string['pctoftotalgrade'] = '%的总分';
$string['percent'] = '百分比';
$string['percentage'] = '百分比';
$string['percentageletter'] = '百分比（分数段）';
$string['percentagereal'] = '百分比（分数）';
$string['percentascending'] = '按百分比升序排序';
$string['percentdescending'] = '按百分比降序排序';
$string['percentshort'] = '%';
$string['plusfactor'] = '加数';
$string['plusfactor_help'] = '加数是一个数字，它会在乘数被应用后，被加到该成绩项的每个分数中去。';
$string['plusfactorvalue'] = '{$a}的加数值';
$string['points'] = '分数';
$string['pointsascending'] = '按分数升序排序';
$string['pointsdescending'] = '按分数降序排序';
$string['positionfirst'] = '开始';
$string['positionlast'] = '末尾';
$string['preferences'] = '偏好';
$string['prefgeneral'] = '常规';
$string['prefletters'] = '分数段和范围';
$string['prefrows'] = '指定行';
$string['prefshow'] = '显示/隐藏 触发器';
$string['previewrows'] = '预览行';
$string['privacy:metadata:categorieshistory'] = '成绩类别先前版本的记录';
$string['privacy:metadata:filepurpose'] = '用户存储在成绩册中的反馈文件。';
$string['privacy:metadata:grade_import_newitem'] = '用于存储来自成绩导入的新的成绩项名称的临时表';
$string['privacy:metadata:grade_import_newitem:importcode'] = '用于标识一批导入的唯一批处理代码';
$string['privacy:metadata:grade_import_newitem:importer'] = '用户导入数据';
$string['privacy:metadata:grade_import_newitem:itemname'] = '新成绩项名称';
$string['privacy:metadata:grade_import_values'] = '导入成绩临时表';
$string['privacy:metadata:grade_import_values:feedback'] = '成绩反馈';
$string['privacy:metadata:grade_import_values:finalgrade'] = '原始成绩值';
$string['privacy:metadata:grade_import_values:importcode'] = '用于标识一批导入的唯一批处理代码';
$string['privacy:metadata:grade_import_values:importer'] = '用户导入数据';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = '如果只导入反馈，则标记';
$string['privacy:metadata:grade_import_values:userid'] = '导入成绩的用户';
$string['privacy:metadata:grades'] = '成绩记录';
$string['privacy:metadata:grades:aggregationstatus'] = '汇总状态';
$string['privacy:metadata:grades:aggregationweight'] = '汇总权重';
$string['privacy:metadata:grades:feedback'] = '反馈';
$string['privacy:metadata:grades:finalgrade'] = '成绩';
$string['privacy:metadata:grades:information'] = '关于成绩的附加信息';
$string['privacy:metadata:grades:timemodified'] = '最后修改成绩的时间';
$string['privacy:metadata:grades:userid'] = '该成绩的用户的 ID';
$string['privacy:metadata:grades:usermodified'] = '最后修改记录的用户的ID';
$string['privacy:metadata:gradeshistory'] = '以前成绩的记录';
$string['privacy:metadata:history:loggeduser'] = '版本控制发生时登录的用户的ID';
$string['privacy:metadata:history:timemodified'] = '发生成绩版本控制的时间';
$string['privacy:metadata:itemshistory'] = '成绩项以前版本的记录';
$string['privacy:metadata:outcomes'] = '成果记录';
$string['privacy:metadata:outcomes:timemodified'] = '记录被修改的时间';
$string['privacy:metadata:outcomes:usermodified'] = '最后修改记录的用户';
$string['privacy:metadata:outcomeshistory'] = '以前版本成果的记录';
$string['privacy:metadata:scale'] = '量表的记录';
$string['privacy:metadata:scale:timemodified'] = '记录最后一次修改的时间';
$string['privacy:metadata:scale:userid'] = '最后修改记录的用户';
$string['privacy:metadata:scalehistory'] = '以前版本量表的记录';
$string['privacy:path:relatedtome'] = '与我有关';
$string['privacy:request:historyactiondelete'] = '删除';
$string['privacy:request:historyactioninsert'] = '插入';
$string['privacy:request:historyactionupdate'] = '更新';
$string['privacy:request:unknowndeletedgradeitem'] = '未知(删除成绩项)';
$string['profilereport'] = '用户个人档案报表';
$string['profilereport_help'] = '在用户个人档案页显示成绩报表。';
$string['publishing'] = '发布';
$string['publishingoptions'] = '成绩发布选项';
$string['quickfeedback'] = '快速反馈';
$string['quickgrading'] = '快速评分';
$string['quickgrading_help'] = '如果启用，则在打开编辑时，每个成绩将显示一个文本输入框，允许同时编辑多个成绩。点击更新按钮时，更改将保存并突出显示。

请注意，在评分人报表中编辑成绩时，将设置覆盖标志，这意味着该成绩不再可以在相关活动中进行更改。';
$string['range'] = '范围';
$string['rangedecimals'] = '范围小数位数';
$string['rangedecimals_help'] = '要显示的范围的小数位数。';
$string['rangesdecimalpoints'] = '范围显示的小数位数';
$string['rangesdecimalpoints_help'] = '此设置确定每个范围显示的小数位数，或者使用类别或成绩项的小数位数设置（继承）。';
$string['rangesdisplaytype'] = '范围显示类型';
$string['rangesdisplaytype_help'] = '此设置确定范围显示为实际分数、百分比还是分数段，或者使用类别或成绩项的显示设置（继承）。';
$string['rank'] = '排名';
$string['rawpct'] = '原始%';
$string['real'] = '分数';
$string['realletter'] = '分数（分数段）';
$string['realpercentage'] = '分数（百分比）';
$string['recalculatinggrades'] = '重新计算成绩';
$string['recovergradesdefault'] = '恢复成绩默认';
$string['recovergradesdefault_help'] = '当用户重新加入课程时默认恢复原来的成绩。';
$string['refreshpreview'] = '刷新预览';
$string['regradeanyway'] = '仍然重新评分';
$string['removeallcoursegrades'] = '删除所有成绩';
$string['removeallcoursegrades_help'] = '如果选中，则将删除所有手动添加到成绩册的成绩项，以及与覆盖、例外、隐藏和锁定的成绩有关的成绩和数据。 只保留与活动相关的成绩项。';
$string['removeallcourseitems'] = '删除所有成绩项和类别';
$string['removeallcourseitems_help'] = '如果选中，则将删除所有手动添加到成绩册的成绩项，以及与覆盖、例外、隐藏和锁定的成绩有关的成绩和数据。 只保留与活动相关的成绩项。';
$string['report'] = '报表';
$string['reportdefault'] = '报表默认值（{$a}）';
$string['reportplugins'] = '报表插件';
$string['reportsettings'] = '报表设置';
$string['reprintheaders'] = '重印标题';
$string['resetweights'] = '重置{$a->itemname}的权重';
$string['resetweightsshort'] = '重置权重';
$string['respectingcurrentdata'] = '保留当前配置不变';
$string['rowpreviewnum'] = '预览行数';
$string['rowpreviewnum_help'] = '在确认导入之前，可以预览导入的数据。此设置确定在预览中显示多少行。';
$string['savechanges'] = '保存更改';
$string['savepreferences'] = '保存偏好';
$string['scaleconfirmdelete'] = '您确定要删除量表“{$a}”吗？';
$string['scaledpct'] = '调整%';
$string['seeallcoursegrades'] = '查看所有课程成绩';
$string['select'] = '选择{$a}';
$string['selectalloroneuser'] = '选择所有或一个用户';
$string['selectauser'] = '选择一个用户';
$string['selectdestination'] = '选择{$a}的目标';
$string['separator'] = '分隔符';
$string['separator_help'] = '选择 CSV 文件中使用的分隔符（通常为逗号）。';
$string['sepcolon'] = '冒号';
$string['sepcomma'] = '逗号';
$string['sepsemicolon'] = '分号';
$string['septab'] = '制表符';
$string['setcategories'] = '设置类别';
$string['setcategorieserror'] = '您必须先设置课程的类别，然后才能给它们权重。';
$string['setgradeletters'] = '设置分数段';
$string['setpreferences'] = '设置偏好';
$string['setting'] = '设置';
$string['settings'] = '设置';
$string['setup'] = '设置';
$string['setweights'] = '设置权重';
$string['showactivityicons'] = '显示活动图标';
$string['showactivityicons_help'] = '如果启用，活动图标将显示在活动名称旁边。';
$string['showallhidden'] = '显示隐藏的';
$string['showallstudents'] = '显示所有学生';
$string['showanalysisicon'] = '显示成绩分析图标';
$string['showanalysisicon_desc'] = '默认情况下是否显示成绩分析图标。 如果活动模块支持，则成绩分析图标链接到页面，其中包含有关成绩及其获取方式的详细说明。';
$string['showanalysisicon_help'] = '如果活动模块支持，则成绩分析图标链接到页面，其中包含有关成绩及其获取方式的详细说明。';
$string['showaverage'] = '显示平均分';
$string['showaverage_help'] = '是否显示平均分列。注意：如果是从较少的成绩计算出的平均分，那么学生可能会估算出其它学生的成绩。考虑到性能因素，如果平均分依赖于任何隐藏成绩项，那么将只是近似值。';
$string['showaverages'] = '显示列平均分';
$string['showaverages_help'] = '如果启用，则评分人报表将包含一个附加行，显示每个类别和成绩项的平均分（均值）。';
$string['showcalculations'] = '显示计算器';
$string['showcalculations_help'] = '如果启用，则在编辑时，将为每个成绩项和类别显示一个计算器图标，并带有一个视觉指示器，指示已计算成绩项。';
$string['showcontributiontocoursetotal'] = '显示对课程总分的贡献';
$string['showcontributiontocoursetotal_help'] = '是否显示百分比列，以显示每个成绩项对用户课程总分贡献的百分比（应用加权后）。';
$string['showeyecons'] = '显示 显示/隐藏 图标';
$string['showeyecons_help'] = '如果启用，则在打开编辑后，将为每个成绩显示一个显示/隐藏图标，以控制其对学生的可见性。';
$string['showfeedback'] = '显示反馈';
$string['showfeedback_help'] = '是否显示反馈列。';
$string['showgrade'] = '显示成绩';
$string['showgrade_help'] = '是否显示成绩列。';
$string['showgroups'] = '显示小组';
$string['showhiddenitems'] = '显示隐藏项';
$string['showhiddenitems_help'] = '隐藏的成绩项是完全隐藏还是隐藏的成绩项名称对学生可见。

* 显示隐藏 - 显示隐藏的成绩项名称，但隐藏学生成绩
* 只隐藏到 - 设置了“隐藏到”日期的成绩项将完全隐藏，直到设置日期为止，之后将显示整个成绩项
* 不显示 - 隐藏的成绩项被完全隐藏';
$string['showhiddenuntilonly'] = '只隐藏到';
$string['showingaggregatesonly'] = '只显示汇总';
$string['showingfullmode'] = '显示完整视图';
$string['showinggradesonly'] = '只显示分数';
$string['showlettergrade'] = '显示分数段';
$string['showlettergrade_help'] = '是否显示分数段列。';
$string['showlocks'] = '显示锁定';
$string['showlocks_help'] = '如果启用，则在打开编辑时，将为每个成绩显示一个锁定/解锁图标，用于控制是否可以通过相关活动自动更新成绩。';
$string['shownohidden'] = '不显示';
$string['shownooutcomes'] = '隐藏成果';
$string['shownumberofgrades'] = '显示平均分的成绩数';
$string['shownumberofgrades_help'] = '如果启用，则在计算平均分（平均值）时使用的成绩数将显示在每个平均分后的方括号中。';
$string['showonlyactiveenrol'] = '只显示活跃的选课';
$string['showonlyactiveenrol_help'] = '此设置确定，在成绩册报表中是否只有活跃选课用户可见。如果启用，则已暂停的用户将不显示在成绩册中。';
$string['showpercentage'] = '显示百分比';
$string['showpercentage_help'] = '是否显示每个成绩项的百分比值。';
$string['showquickfeedback'] = '显示快速反馈';
$string['showquickfeedback_help'] = '如果启用，则在打开编辑时，每个成绩将显示一个带虚线边框的反馈文本输入框，允许同时编辑多个成绩的反馈。 点击更新按钮时，更改将保存并突出显示。

请注意，在评分人报表中编辑反馈后，将设置覆盖标志，这意味着不再可以在相关活动中更改反馈。';
$string['showrange'] = '显示范围';
$string['showrange_help'] = '是否显示范围列。';
$string['showranges'] = '显示范围';
$string['showranges_help'] = '如果启用，则评分人报表将包含一个附加行，显示每个类别和成绩项的范围。';
$string['showrank'] = '显示排名';
$string['showrank_help'] = '是否显示每个成绩项相对于班级其他学生的位置。';
$string['showuserimage'] = '显示用户头像';
$string['showuserimage_help'] = '是否在评分人报表的姓名旁边显示用户头像。';
$string['showverbose'] = '显示{$a->category}{$a->itemmodule}{$a->itemname}';
$string['showweight'] = '显示权重';
$string['showweight_help'] = '是否显示成绩权重列。';
$string['simpleview'] = '独立视图';
$string['singleview'] = '{$a}的独立视图';
$string['sitewide'] = '全站';
$string['sort'] = '排序';
$string['sortasc'] = '升序排列';
$string['sortbyfirstname'] = '按名字排序';
$string['sortbylastname'] = '按姓氏排序';
$string['sortdesc'] = '降序排列';
$string['standarddeviation'] = '标准偏差';
$string['stats'] = '统计';
$string['statslink'] = '统计';
$string['student'] = '学生';
$string['studentsperpage'] = '每页显示的学生数';
$string['studentsperpage_help'] = '此设置确定了评分人报表中每页显示的学生数。';
$string['studentsperpagereduced'] = '每页的最大学生数从 {$a->originalstudentsperpage} 减少到 {$a->studentsperpage}。考虑增加 PHP 设置中 max_input_vars 的值 {$a->maxinputvars}。';
$string['subcategory'] = '常规类别';
$string['submissions'] = '提交';
$string['submittedon'] = '已提交: {$a}';
$string['sumofgradesupgradedgrades'] = '注意：作为站点升级的一部分，汇总方法“分数总和”已更改为“加权总分”。 由于此课程以前使用“分数总和”，因此建议您在成绩册中查看此更改。';
$string['switchtofullview'] = '切换到完整视图';
$string['switchtosimpleview'] = '切换到简略视图';
$string['tabs'] = '标签页';
$string['topcategory'] = '超级类别';
$string['total'] = '总分';
$string['totalweight100'] = '总权重等于100';
$string['totalweightnot100'] = '总权重不等于100';
$string['turnfeedbackoff'] = '关闭反馈';
$string['turnfeedbackon'] = '开启反馈';
$string['typenone'] = '无';
$string['typescale'] = '量表';
$string['typescale_help'] = '此设置确定使用量表成绩类型时使用的量表。 基于活动的成绩项量表在活动设置页面设置。';
$string['typetext'] = '文本';
$string['typevalue'] = '数值';
$string['uncategorised'] = '未分类';
$string['unchangedgrade'] = '成绩不变';
$string['unenrolledusersinimport'] = '此导入包括当前未加入此课程的用户的以下成绩：{$a}';
$string['unlimitedgrades'] = '不限制分数';
$string['unlimitedgrades_help'] = '默认情况下，成绩受成绩项的最高分和最低分限制。 启用此设置将移除此限制，并允许将超过100％的成绩直接输入到成绩册中。';
$string['unlock'] = '解锁';
$string['unlockverbose'] = '解锁{$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = '未使用';
$string['updatedgradesonly'] = '只导出新的或者已更新的成绩';
$string['upgradedgradeshidemessage'] = '驳回通知';
$string['upgradedminmaxrevertmessage'] = '恢复更改';
$string['uploadgrades'] = '上传成绩';
$string['useadvanced'] = '使用高级功能';
$string['usedcourses'] = '已使用的课程';
$string['usedgradeitem'] = '已使用的成绩项';
$string['usenooutcome'] = '不使用成果';
$string['usenoscale'] = '不使用量表';
$string['usepercent'] = '使用百分比';
$string['user'] = '用户';
$string['userenrolmentsuspended'] = '用户选课暂停';
$string['userfields_show'] = '显示用户字段';
$string['userfields_show_help'] = '在评分人报表中显示额外的用户字段，如电子邮件地址。显示的特定字段由站点设置“显示用户身份”控制';
$string['usergrade'] = '成绩项{$a-> gradeidnumber}上的用户{$a-> fullname}（{$a-> useridnumber}）';
$string['userid'] = '用户ID';
$string['useridnumberwarning'] = '没有ID号的用户被排除在导出之外，因为他们不能被导入';
$string['usermappingerror'] = '用户映射错误：找不到{$a-> field}为“{$a-> value}”的用户。';
$string['usermappingerrorcurrentgroup'] = '用户不是当前小组的成员。';
$string['usermappingerrormultipleusersfound'] = '用户映射错误：找到多个{$a-> field}为“{$a-> value}”的用户。 请使用更唯一的映射字段。';
$string['usermappingerrorusernotfound'] = '用户映射错误，找不到用户。';
$string['userpreferences'] = '用户偏好';
$string['useweighted'] = '使用加权';
$string['verbosescales'] = '详细量表';
$string['verbosescales_help'] = '详细量表使用词语而不是数字。 如果要同时导入数字量表和详细量表，则设置为“是”。 如果只导入数字量表，则设置为“否”。';
$string['viewbygroup'] = '小组';
$string['viewgrades'] = '查看成绩';
$string['weight'] = '权重';
$string['weight_help'] = '用于确定类别或课程中多个成绩项的相对值的值。';
$string['weightcourse'] = '对课程使用加权成绩';
$string['weightedascending'] = '按加权百分比升序排序';
$string['weighteddescending'] = '按加权百分比降序排序';
$string['weightedpct'] = '加权 %';
$string['weightedpctcontribution'] = '加权 % 贡献';
$string['weightofa'] = '{$a}权重';
$string['weightorextracredit'] = '权重或加分';
$string['weightoverride'] = '权重调整';
$string['weightoverride_help'] = '取消选中此选项可将成绩项的权重重置为其自动计算的值。 选中此项将防止自动调整权重。';
$string['weights'] = '权重';
$string['weightsadjusted'] = '您的权重已调整为总计100。';
$string['weightsedit'] = '编辑权重和加分';
$string['weightuc'] = '计算权重';
$string['writinggradebookinfo'] = '编写成绩册设置';
$string['xml'] = 'XML';
$string['yes'] = '是';
$string['yourgrade'] = '您的成绩';
