<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'zh_cn', version '4.0'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = '所有子条目都已完成';
$string['competencies'] = '能力';
$string['competenciesarenotenabled'] = '能力没有启用。';
$string['competenciessettings'] = '能力设置';
$string['completeplanstask'] = '按时完成学习计划';
$string['coursecompetencyoutcome_complete'] = '完成该能力';
$string['coursecompetencyoutcome_evidence'] = '附加证据';
$string['coursecompetencyoutcome_none'] = '什么都不做';
$string['coursecompetencyoutcome_recommend'] = '送去审查';
$string['coursemodulecompetencyoutcome_complete'] = '完成该能力';
$string['coursemodulecompetencyoutcome_evidence'] = '附加证据';
$string['coursemodulecompetencyoutcome_none'] = '什么都不做';
$string['coursemodulecompetencyoutcome_recommend'] = '送去审查';
$string['deletecompetencyratings'] = '删除能力等级';
$string['duplicateditemname'] = '{$a} (复制)';
$string['enablecompetencies'] = '启用能力';
$string['enablecompetencies_desc'] = '允许用户根据学习计划进行能力评估';
$string['errorcannotchangeapastduedate'] = '已过到期日期，不能更改。';
$string['errorcannotsetduedateinthepast'] = '到期日期不能设置在过去。';
$string['errorcannotsetduedatetoosoon'] = '到期日期太早了。';
$string['errorcompetencyrule'] = '课程能力规则“{$a}”未知';
$string['errorcoursecompetencyrule'] = '课程能力规则“{$a}”未知';
$string['errorinvalidcourse'] = '无效课程。';
$string['errornocompetency'] = '无法找到{$a}能力';
$string['errorplanstatus'] = '学习计划“{$a}”状态未知';
$string['errorscalealreadyused'] = '能力量表已在使用，不能更改。';
$string['errorscaleconfiguration'] = '需要通过选择默认项目和精通项目来配置量表。';
$string['errorusercomptencystatus'] = '用户能力状态“{$a}”未知';
$string['eventcompetencycreated'] = '能力已建立。';
$string['eventcompetencydeleted'] = '能力已删除。';
$string['eventcompetencyframeworkcreated'] = '能力框架已建立。';
$string['eventcompetencyframeworkdeleted'] = '能力框架已删除。';
$string['eventcompetencyframeworkupdated'] = '能力框架已更新。';
$string['eventcompetencyframeworkviewed'] = '能力框架已查看。';
$string['eventcompetencyupdated'] = '能力已更新。';
$string['eventcompetencyviewed'] = '能力已查看。';
$string['eventevidencecreated'] = '证据已建立。';
$string['eventplanapproved'] = '学习计划已批准。';
$string['eventplancompleted'] = '学习计划已完成。';
$string['eventplancreated'] = '学习计划已建立。';
$string['eventplandeleted'] = '学习计划已删除。';
$string['eventplanreopened'] = '学习计划已重新开启。';
$string['eventplanreviewrequestcancelled'] = '学习计划审查申请已取消。';
$string['eventplanreviewrequested'] = '学习计划审查已申请。';
$string['eventplanreviewstarted'] = '学习计划审查已开始。';
$string['eventplanreviewstopped'] = '学习计划审查已停止。';
$string['eventplanunapproved'] = '学习计划未批准。';
$string['eventplanunlinked'] = '学习计划已取消链接。';
$string['eventplanupdated'] = '学习计划已更新。';
$string['eventplanviewed'] = '学习计划已查看。';
$string['eventtemplatecreated'] = '学习计划模板已建立。';
$string['eventtemplatedeleted'] = '学习计划模板已删除 。';
$string['eventtemplateupdated'] = '学习计划模板已更新。';
$string['eventtemplateviewed'] = '学习计划模板已查看。';
$string['eventusercompetencyplanviewed'] = '用户能力计划已查看。';
$string['eventusercompetencyrated'] = '用户能力已评估。';
$string['eventusercompetencyratedincourse'] = '课程用户能力已评估。';
$string['eventusercompetencyratedinplan'] = '学习计划的用户能力已评估。';
$string['eventusercompetencyreviewrequestcancelled'] = '用户能力审查申请已取消。';
$string['eventusercompetencyreviewrequested'] = '用户能力审查已申请。';
$string['eventusercompetencyreviewstarted'] = '用户能力审查已开始。';
$string['eventusercompetencyreviewstopped'] = '用户能力审查已停止。';
$string['eventusercompetencyviewed'] = '用户能力已查看。';
$string['eventusercompetencyviewedincourse'] = '课程用户能力已查看。';
$string['eventusercompetencyviewedinplan'] = '已在学习计划中查看用户能力。';
$string['eventuserevidencecreated'] = '先前学习证据已建立。';
$string['eventuserevidencedeleted'] = '先前学习证据已删除。';
$string['eventuserevidenceupdated'] = '先前学习证据已更新。';
$string['evidence_competencyrule'] = '满足能力规则。';
$string['evidence_coursecompleted'] = '课程“{$a}”已完成。';
$string['evidence_coursemodulecompleted'] = '活动“{$a}”已完成。';
$string['evidence_courserestored'] = '此等级随课程“{$a}”一起恢复。';
$string['evidence_evidenceofpriorlearninglinked'] = '先前学习证据“{$a}”已链接。';
$string['evidence_evidenceofpriorlearningunlinked'] = '先前学习证据“{$a}”已取消链接。';
$string['evidence_manualoverride'] = '能力等级是手动设置的。';
$string['evidence_manualoverrideincourse'] = '能力等级是在课程“{$a}”中手动设置的。';
$string['evidence_manualoverrideinplan'] = '能力等级是在学习计划“{$a}”中手动设置的。';
$string['invalidevidencedesc'] = '无效的证据描述';
$string['invalidgrade'] = '无效等级';
$string['invalidpersistenterror'] = '错误: {$a}';
$string['invalidplan'] = '无效的学习计划';
$string['invalidtaxonomy'] = '无效的分类：{$a}';
$string['invalidurl'] = '网址无效，请确保以"http://"或“https://”开头。';
$string['nouserplanswithcompetency'] = '没有学习计划包含此能力。';
$string['planstatusactive'] = '活跃的';
$string['planstatuscomplete'] = '完成';
$string['planstatusdraft'] = '草稿';
$string['planstatusinreview'] = '审查中';
$string['planstatuswaitingforreview'] = '等待审查';
$string['pointsrequiredaremet'] = '满足需要的分数';
$string['privacy:evidence:action:complete'] = '如果未评估则完成能力';
$string['privacy:evidence:action:log'] = '日志操作';
$string['privacy:evidence:action:override'] = '覆盖能力等级';
$string['privacy:metadata:competency'] = '能力记录';
$string['privacy:metadata:competency_coursecomp'] = '连接到课程的能力记录';
$string['privacy:metadata:competency_coursecompsetting'] = '课程中的能力设置记录';
$string['privacy:metadata:competency_evidence'] = '影响能力状态的证据记录';
$string['privacy:metadata:competency_framework'] = '能力框架记录';
$string['privacy:metadata:competency_modulecomp'] = '连接到模块的能力记录';
$string['privacy:metadata:competency_plan'] = '学习计划记录';
$string['privacy:metadata:competency_plancomp'] = '学习计划中的能力记录';
$string['privacy:metadata:competency_relatedcomp'] = '能力之间关系的记录';
$string['privacy:metadata:competency_template'] = '学习计划模板的记录';
$string['privacy:metadata:competency_templatecohort'] = '与学习计划模板关联的群组记录';
$string['privacy:metadata:competency_templatecomp'] = '学习计划模板中的能力记录';
$string['privacy:metadata:competency_usercomp'] = '用户的能力状态记录';
$string['privacy:metadata:competency_usercompcourse'] = '用户在课程中的能力状态记录';
$string['privacy:metadata:competency_usercompplan'] = '学习计划中的能力状态记录';
$string['privacy:metadata:competency_userevidence'] = '先前学习证据的记录';
$string['privacy:metadata:competency_userevidencecomp'] = '与先前学习证据关联的能力记录';
$string['privacy:metadata:core_comments'] = '对学习计划和能力的评论';
$string['privacy:metadata:evidence:action'] = '根据证据采取的操作类型';
$string['privacy:metadata:evidence:actionuserid'] = '执行操作的用户';
$string['privacy:metadata:evidence:desca'] = '可转化证据描述的可选参数';
$string['privacy:metadata:evidence:desccomponent'] = '可转化证据描述的组成部分';
$string['privacy:metadata:evidence:descidentifier'] = '可转化证据描述的标识符';
$string['privacy:metadata:evidence:grade'] = '与证据关联的成绩';
$string['privacy:metadata:evidence:note'] = '附在证据上的非本地化备注';
$string['privacy:metadata:evidence:url'] = '与证据关联的网址';
$string['privacy:metadata:plan:description'] = '学习计划的描述';
$string['privacy:metadata:plan:duedate'] = '学习计划的到期日期';
$string['privacy:metadata:plan:name'] = '学习计划的名称';
$string['privacy:metadata:plan:reviewerid'] = '学习计划审查人的 ID';
$string['privacy:metadata:plan:status'] = '学习计划的状态';
$string['privacy:metadata:plan:userid'] = '学习计划所有人的 ID';
$string['privacy:metadata:timecreated'] = '记录创建的时间';
$string['privacy:metadata:timemodified'] = '记录编辑的时间';
$string['privacy:metadata:usercomp:grade'] = '能力对应的成绩';
$string['privacy:metadata:usercomp:proficiency'] = '是否达到精通';
$string['privacy:metadata:usercomp:reviewerid'] = '审查人 ID';
$string['privacy:metadata:usercomp:status'] = '能力状态';
$string['privacy:metadata:usercomp:userid'] = '能力所有人的 ID';
$string['privacy:metadata:userevidence:description'] = '证据的描述';
$string['privacy:metadata:userevidence:name'] = '先前学习证据的名称';
$string['privacy:metadata:userevidence:url'] = '与证据关联的网址';
$string['privacy:metadata:usermodified'] = '创建或修改此记录的用户';
$string['privacy:path:plans'] = '学习计划';
$string['privacy:path:relatedtome'] = '与我有关';
$string['privacy:path:userevidence'] = '先前学习证据';
$string['pushcourseratingstouserplans'] = '推送课程等级到个人学习计划';
$string['pushcourseratingstouserplans_desc'] = '课程设置的默认值，用于在对课程能力进行评估时更新个人学习计划。';
$string['syncplanscohorts'] = '从学习计划模板群组同步计划';
$string['taxonomy_behaviour'] = '行为';
$string['taxonomy_competency'] = '能力';
$string['taxonomy_concept'] = '概念';
$string['taxonomy_domain'] = '领域';
$string['taxonomy_indicator'] = '指标';
$string['taxonomy_level'] = '级别';
$string['taxonomy_outcome'] = '成果';
$string['taxonomy_practice'] = '练习';
$string['taxonomy_proficiency'] = '精通';
$string['taxonomy_skill'] = '技能';
$string['taxonomy_value'] = '值';
$string['usercommentedonacompetency'] = '{$a->fullname}评论了"{$a->competency}"：

{$a->comment}

请参看：{$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname}评论了"{$a->competency}"：</p> <div>{$a->comment}</div> <p>请参看：<a href="{$a->url}">{$a->urlname}</a>。</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname}评论了"{$a->competency}"。';
$string['usercommentedonacompetencysubject'] = '{$a}评论了一个能力。';
$string['usercommentedonaplan'] = '{$a->fullname}评论了学习计划 "{$a->plan}"：

{$a->comment}

请参看： {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname}评论了学习计划 "{$a->plan}"：</p> <div>{$a->comment}</div> <p>请参看： <a href="{$a->url}">{$a->urlname}</a>。</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname}评论了学习计划 "{$a->plan}"。';
$string['usercommentedonaplansubject'] = '{$a}评论了一个学习计划。';
$string['usercompetencystatus_idle'] = '闲置';
$string['usercompetencystatus_inreview'] = '审查中';
$string['usercompetencystatus_waitingforreview'] = '等待审查';
$string['userplans'] = '学习计划';
