<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'ja', version '4.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'データ処理規約を理解および同意します';
$string['activityoverview'] = 'あなたにはまもなく始まるBigBlueButtonセッションがあります。';
$string['bbbduetimeoverstartingtime'] = '終了日は開始日以降に設定する必要があります。';
$string['bbbdurationwarning'] = 'このセッションの最大継続時間は %duration% 分です。';
$string['bbbrecordallfromstartwarning'] = 'このセッションは開始からレコーディングされます。';
$string['bbbrecordwarning'] = 'このセッションはレコーディングできます。';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = '新しいBigBlueButtonルームを追加する';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'ライブセッションインスタンスを作成する';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'レコーディングできるインスタンスを作成する';
$string['bigbluebuttonbn:deleterecordings'] = 'レコーディングを削除する';
$string['bigbluebuttonbn:importrecordings'] = 'レコーディングをインポートする';
$string['bigbluebuttonbn:join'] = 'BigBlueButtonルームに参加する';
$string['bigbluebuttonbn:managerecordings'] = 'レコーディングを管理する';
$string['bigbluebuttonbn:protectrecordings'] = 'レコーディングを保護する';
$string['bigbluebuttonbn:publishrecordings'] = 'レコーディングを公開する';
$string['bigbluebuttonbn:unprotectrecordings'] = 'レコーディングを保護解除する';
$string['bigbluebuttonbn:unpublishrecordings'] = 'レコーディングを非公開にする';
$string['bigbluebuttonbn:view'] = 'BigBlueButtonを表示する';
$string['bigbluebuttondisablednotification'] = 'BigBlueButtonの活動モジュールが無効にされたため、現在、既存のBigBlueButtonコース活動にアクセスできません。このプラグインを再度有効にする前にあなたがBlindside Networks Inc.の<a href="{$a}" target="_blank">データ処理規約</a>を読んで同意していることを確認してください。';
$string['bigbluebuttondisablednotification_subject'] = 'BigBlueButton活動モジュールが無効にされました。';
$string['cachedef_currentfetch'] = '最近取得したデータを一覧表示するデータです。';
$string['cachedef_recordings'] = 'レコーディングメタデータ';
$string['cachedef_serverinfo'] = 'リモートサーバ情報';
$string['cachedef_validatedurls'] = '検証済みURLチェックのキャッシュ';
$string['calendarstarts'] = '{$a} は次にスケジュールされています:';
$string['cannotperformaction'] = 'このレコーディングではアクション {$a} を実行できません。';
$string['completionattendance'] = '学生は次のセッションに参加する必要があります:';
$string['completionattendance_desc'] = 'ルームに入って少なくとも {$a} 分間滞在する必要があります。';
$string['completionattendance_event_desc'] = '学生は少なくとも {$a} 分以上ルームに入っているかセッションに参加しています。';
$string['completionattendancegroup'] = '要出席';
$string['completionattendancegroup_help'] = '完了には (n) 分のミーティング参加を要します。';
$string['completionengagement_desc'] = 'ミーティング中に活動に参加する必要があります。';
$string['completionengagementchats'] = 'チャット';
$string['completionengagementchats_desc'] = 'チャット参加件数 {$a} 件';
$string['completionengagementchats_event_desc'] = '{$a} 件のチャットを立ち上げました。';
$string['completionengagementemojis'] = '絵文字';
$string['completionengagementemojis_desc'] = '絵文字変更回数: {$a} 回';
$string['completionengagementemojis_event_desc'] = '絵文字変更回数: {$a} 回';
$string['completionengagementgroup'] = '要参加';
$string['completionengagementgroup_help'] = '完了するにはセッション中の積極的な参加が必要です。';
$string['completionengagementpollvotes'] = '投票結果';
$string['completionengagementpollvotes_desc'] = '投票回数 {$a} 回';
$string['completionengagementpollvotes_event_desc'] = '投票回数 {$a} 回';
$string['completionengagementraisehand'] = '要挙手';
$string['completionengagementraisehand_desc'] = '挙手回数 {$a} 回';
$string['completionengagementraisehand_event_desc'] = '{$a} 件の挙手を立ち上げました。';
$string['completionengagementtalks'] = 'トーク';
$string['completionengagementtalks_desc'] = 'トーク回数 {$a} 回';
$string['completionengagementtalks_event_desc'] = '{$a} 件のトークを立ち上げました。';
$string['completionupdatestate'] = '完了更新状況';
$string['completionvalidatestate'] = '完了確認';
$string['completionvalidatestatetriggered'] = '検証完了がトリガーされました。';
$string['completionview'] = '要閲覧';
$string['completionview_desc'] = '完了するには学生はルームを閲覧する必要があります。';
$string['completionview_event_desc'] = 'ルームを閲覧しました。';
$string['config_default_messages'] = 'デフォルトメッセージ';
$string['config_default_messages_description'] = '活動のメッセージデフォルトを設定する';
$string['config_disablecam_default'] = '「ウェブカム有効化」をデフォルトで無効にする';
$string['config_disablecam_default_description'] = 'この設定を有効にした場合、ウェブカメラは無効にされます。';
$string['config_disablecam_editable'] = '「ウェブカム無効化」を編集できる';
$string['config_disablecam_editable_description'] = 'デフォルトでの「ウェブカム無効化」はインスタンス追加または更新時に編集できます。';
$string['config_disablemic_default'] = '「マイク有効化」をデフォルトで無効にする';
$string['config_disablemic_default_description'] = 'この設定を有効にした場合、マイクは無効にされます。';
$string['config_disablemic_editable'] = '「マイク無効化」を編集できる';
$string['config_disablemic_editable_description'] = 'デフォルトでの「マイク無効化は」インスタンス追加または更新時に編集できます。';
$string['config_disablenote_default'] = '「共有ノート有効化」をデフォルトで無効にする';
$string['config_disablenote_default_description'] = 'この設定を有効にした場合、共有ノートは無効にされます。';
$string['config_disablenote_editable'] = '「共有ノート無効化」を編集できる';
$string['config_disablenote_editable_description'] = 'デフォルトでの「共有ノート無効化」はインスタンス追加または更新時に編集できます。';
$string['config_disableprivatechat_default'] = '「プライベートチャット有効化」をデフォルトで無効にする';
$string['config_disableprivatechat_default_description'] = 'この設定を有効にした場合、プライベートチャットは無効にされます。';
$string['config_disableprivatechat_editable'] = '「プライベートチャット無効化」を編集できる';
$string['config_disableprivatechat_editable_description'] = 'デフォルトでの「プライベートチャット無効化」はインスタンス追加または更新時に編集できます。';
$string['config_disablepublicchat_default'] = '「パブリックチャット有効化」をデフォルトで無効にする';
$string['config_disablepublicchat_default_description'] = 'この設定を有効にした場合、パブリックチャットは無効にされます。';
$string['config_disablepublicchat_editable'] = '「パブリックチャット無効化」を編集できる';
$string['config_disablepublicchat_editable_description'] = 'デフォルトでの「パブリックチャット無効化」はインスタンス追加または更新時に編集できます。';
$string['config_dpa_note'] = '注意: あなたのデータ保護義務に合致するため、このプラグインにサービスプロバイダを使用する前にサービスプロバイダのデータ処理規約を読んで同意したことを確認する必要があります。
デフォルトの無料BigBlueButtonサービスについては以下の<a href="{$a}" target="_blank">Blindside Networksデータ処理規約</a>を読んで同意してください。
<br />
アドバイスについてはあなたの個人情報保護専門家にご相談ください。';
$string['config_experimental_features'] = '実験機能';
$string['config_experimental_features_description'] = '実験機能設定';
$string['config_extended_capabilities'] = '拡張機能設定';
$string['config_extended_capabilities_description'] = 'BigBlueButtonサーバが提供できる拡張機能の設定です。';
$string['config_general'] = '一般設定';
$string['config_general_description'] = 'これらの設定は常に使用されます。';
$string['config_hideuserlist_default'] = '「ユーザ一覧秘匿」をデフォルトで有効にする';
$string['config_hideuserlist_default_description'] = 'この設定を有効にした場合、セッションユーザ一覧は秘匿されます。';
$string['config_hideuserlist_editable'] = '「ユーザ一覧を秘匿する」を編集できる';
$string['config_hideuserlist_editable_description'] = 'デフォルトでの「ユーザ一覧を秘匿する」はインスタンス追加または更新時に編集できます。';
$string['config_importrecordings'] = 'レコーディングインポート';
$string['config_importrecordings_description'] = 'これらの設定は機能ごとに異なります。';
$string['config_importrecordings_enabled'] = 'レコーディングインポート有効';
$string['config_importrecordings_enabled_description'] = 'この設定およびレコーディング機能が有効にされた場合、異なるコースから活動にレコーディングをインポートできます。';
$string['config_importrecordings_from_deleted_enabled'] = '削除済みコースのレコーディングインポート有効化';
$string['config_importrecordings_from_deleted_enabled_description'] = 'この設定およびレコーディングインポート機能が有効にされた場合、コース内に存在しなくなった活動からレコーディングをインポートできます。';
$string['config_lockonjoin_default'] = '参加時のロックをデフォルトで有効にする';
$string['config_lockonjoin_default_description'] = 'この設定を有効にした場合、ユーザの参加時にロック設定が適用されます。これを適用するにはロック設定を有効にする必要があります。';
$string['config_lockonjoin_editable'] = '参加時のロックを編集できる';
$string['config_lockonjoin_editable_description'] = 'デフォルトでの参加時のロックはインスタンス追加または更新時に編集できます。';
$string['config_locksettings'] = 'ロック設定';
$string['config_locksettings_description'] = 'これらの設定はロック設定のためのUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_meetingevents_enabled'] = 'ライブセッションを登録する';
$string['config_meetingevents_enabled_description'] = 'この設定を有効にした場合、ライブセッションはセッション終了後に処理されます。この機能は活動完了に必要であり、BigBlueButtonサーバがpost_eventsスクリプトを処理できる場合のみ機能します。';
$string['config_muteonstart'] = '開始時ミュートする';
$string['config_muteonstart_default'] = '「開始時ミュート」をデフォルトで有効にする';
$string['config_muteonstart_default_description'] = 'この設定を有効にした場合、セッションは開始時にミュートされます。';
$string['config_muteonstart_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_muteonstart_editable'] = '「開始時ミュート」を編集できる';
$string['config_muteonstart_editable_description'] = 'デフォルトでの「開始時ミュート」はインスタンス追加または更新時に編集できます。';
$string['config_participant'] = '参加者';
$string['config_participant_description'] = 'これらの設定では参加者のデフォルトのロールを定義します。';
$string['config_participant_moderator_default'] = 'モデレータ';
$string['config_participant_moderator_default_description'] = 'このルールは新しいルームの追加時にデフォルトで使用されます。';
$string['config_presentation_default'] = 'デフォルトプレゼンテーションファイル';
$string['config_presentation_default_description'] = 'すべてのルームで使用するにはファイルを提供する必要があります。';
$string['config_preuploadpresentation'] = 'プレアップロードプレゼンテーション';
$string['config_preuploadpresentation_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。この機能はMoodleサーバがBigBlueButtonにアクセスできる場合のみ動作します。';
$string['config_preuploadpresentation_editable'] = 'プリアップロードプレゼンテーション編集可';
$string['config_preuploadpresentation_editable_description'] = 'ルームまたはカンファレンスの追加または更新時にUIでプリアップロードプレゼンテーション機能を編集できます。';
$string['config_recording'] = 'レコーディング';
$string['config_recording_all_from_start_default'] = '最初からレコーディングする';
$string['config_recording_all_from_start_default_description'] = '新しいBigBlueButtonルーム追加時に「最初からレコーディングを開始する」設定をデフォルトで有効にしますか?';
$string['config_recording_all_from_start_editable'] = '「最初からレコーディングする」を編集できる';
$string['config_recording_all_from_start_editable_description'] = 'この設定を有効に場合、インタフェースには「最初からレコーディングする」機能を有効または無効にするオプションが含まれます。';
$string['config_recording_default'] = 'レコーディングをデフォルトで有効にする';
$string['config_recording_default_description'] = '新しいBigBlueButtonルーム追加時に「セッションをレコーディングできる」設定をデフォルトで有効にしますか?';
$string['config_recording_description'] = 'これらの設定は機能ごとに異なります。';
$string['config_recording_editable'] = '「セッションをレコーディングできる」を編集できる';
$string['config_recording_editable_description'] = 'BigBlueButton活動設定で「セッションをレコーディングできる」を編集可能にしますか?';
$string['config_recording_hide_button_default'] = 'レコーディングボタンを秘匿する';
$string['config_recording_hide_button_default_description'] = 'この設定を有効に場合、レコーディングボタンが秘匿されます。';
$string['config_recording_hide_button_editable'] = '「レコーディング秘匿ボタン」を編集できる';
$string['config_recording_hide_button_editable_description'] = 'BigBlueButton活動設定で「レコーディング秘匿ボタン」ボタンを編集可能にしますか?';
$string['config_recording_protect_editable'] = '保護されたレコーディング状態を編集できる';
$string['config_recording_protect_editable_description'] = 'この設定を有効にした場合、インタフェースにレコーディングの保護/保護解除オプションが含まれます。';
$string['config_recording_refresh_period'] = 'レコーディング更新期間 (秒)';
$string['config_recording_refresh_period_description'] = 'レコーディングのリモート情報を更新するためにどのくらいの頻度でBigBlueButtonサーバに問い合わせしますか?';
$string['config_recordingready_enabled'] = 'レコーディング利用可能通知を送信する';
$string['config_recordingready_enabled_description'] = 'この設定を有効にした場合、レコーディングリンクが利用可能になった時点で通知が送信されます。この機能を使用するにはBigBlueButtonサーバでpost_publish_recording_ready_callbackスクリプトが有効にされている必要があります。';
$string['config_recordings'] = 'レコーディングを表示する';
$string['config_recordings_asc_sort'] = 'レコーディングを昇順に一覧表示する';
$string['config_recordings_asc_sort_description'] = 'レコーディングは日付順の昇順または降順 (最も新しいレコーディングを先頭) で表示されます。';
$string['config_recordings_deleted_default'] = '「削除済み活動のレコーディングを含む」をデフォルトで有効にする';
$string['config_recordings_deleted_default_description'] = 'この設定を有効にした場合、削除された活動もレコーディングに含まれます。';
$string['config_recordings_deleted_editable'] = '「削除済み活動のレコーディングを含む」機能を編集できる';
$string['config_recordings_deleted_editable_description'] = 'デフォルトでの「削除済み活動のレコーディングを含む」はインスタンス追加または更新時に編集できます。';
$string['config_recordings_description'] = 'これらの設定は機能ごとに異なります。';
$string['config_recordings_general'] = 'レコーディング設定を表示する';
$string['config_recordings_general_description'] = 'これらの設定はレコーディング表示時のみ使用できます。';
$string['config_recordings_imported_default'] = '「インポートリンクのみ表示する」をデフォルトで有効にする';
$string['config_recordings_imported_default_description'] = 'この設定を有効にした場合、レコーディングテーブルにはインポートされたレコーディングへのリンクのみ含まれます。';
$string['config_recordings_imported_editable'] = '「インポートリンクのみ表示する」機能を編集できる';
$string['config_recordings_imported_editable_description'] = 'デフォルトでの「インポートリンクのみ表示する」はインスタンス追加または更新時に編集できます。';
$string['config_recordings_preview_default'] = '「プレビュ」をデフォルトで有効にする';
$string['config_recordings_preview_default_description'] = 'この設定を有効にした場合、テーブルにプレゼンテーションのプレビュが含まれます。';
$string['config_recordings_preview_editable'] = '「プレビュ」機能を編集できる';
$string['config_recordings_preview_editable_description'] = '「プレビュ」機能はインスタンス追加または更新時に編集できます。';
$string['config_scheduled'] = 'スケジュールセッション';
$string['config_scheduled_description'] = 'これらの設定ではスケジュールセッションのデフォルトの挙動を設定します。';
$string['config_scheduled_pre_opening'] = 'オープニング時間前にアクセスできる';
$string['config_scheduled_pre_opening_description'] = 'スケジュールオープニング時間前にルームが開く時間 (分) です。';
$string['config_server_url'] = 'BigBlueButtonサーバURL';
$string['config_server_url_description'] = 'デフォルトの認証情報はBlindside Networksが提供する<a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">Free BigBlueButton service for Moodle (新しいウィンドウで開く)</a>で以下のように制限されます:
<ol>
<li>1セッション最大長: 60分</li>
<li>1セッション最大同時使用人数: 25人</li>
<li>レコーディング有効期限: 7日間 (ダウンロード不可)</li>
<li>学生のウェブカム: モデレータにのみ表示される</li>
</ol>';
$string['config_shared_secret'] = 'BigBlueButton共有シークレット';
$string['config_shared_secret_description'] = 'BigBlueButtonサーバーのセキュリティシークレットです。デフォルトのシークレットはBlindside Networksが提供する無料のBigBlueButtonサービスのためのものです。';
$string['config_uidelegation_enabled'] = 'UIデリゲーション有効';
$string['config_uidelegation_enabled_description'] = 'これらの設定はBigBlueButtonサーバへのUIのデリゲーションを有効または無効にします。';
$string['config_userlimit'] = 'ユーザ制限';
$string['config_userlimit_default'] = '「ユーザ制限」デフォルトでを有効にする';
$string['config_userlimit_default_description'] = '新しいルーム追加時にデフォルトでセッションに許可されるユーザ数を設定します。ゼロに設定した場合、制限は設けられません。';
$string['config_userlimit_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_userlimit_editable'] = '「ユーザ制限」機能を編集できる';
$string['config_userlimit_editable_description'] = '「ユーザ制限」はルームまたはカンファレンスの追加または更新時に編集できます。';
$string['config_voicebridge'] = 'ボイスブリッジ';
$string['config_voicebridge_description'] = 'これらの設定はUIのオプションを有効または無効にします。また、これらのオプションのデフォルト値を定義します。';
$string['config_voicebridge_editable'] = '「カンファレンスボイスブリッジ」を編集できる';
$string['config_voicebridge_editable_description'] = 'カンファレンスボイスブリッジ番号はルームに恒久的に割り当てできます。割り当てられた番号は他のルームでは使用できません。';
$string['config_waitformoderator'] = 'モデレータ待ち';
$string['config_waitformoderator_cache_ttl'] = '「モデレータ待ち」キャッシュTTL (秒)';
$string['config_waitformoderator_cache_ttl_description'] = 'このプラグインではクライアントの高負荷をサポートするためキャッシュを使用します。このパラメータは次のリクエストがBigBlueButtonサーバに送信されるまでのキャッシュ保持時間を定義します。';
$string['config_waitformoderator_default'] = '「モデレータ待ちを」デフォルトで有効にする';
$string['config_waitformoderator_default_description'] = '「モデレータ待ち」設定は新しいBigBlueButtonルーム追加時にデフォルトで有効にされます。';
$string['config_waitformoderator_description'] = 'これらの設定は機能ごとに異なります。';
$string['config_waitformoderator_editable'] = '「モデレータ待ち」機能を編集できる';
$string['config_waitformoderator_editable_description'] = '「モデレータ待ち」はBigBlueButton活動設定で編集できますか?';
$string['config_waitformoderator_ping_interval'] = 'モデレータ待ちピング (秒)';
$string['config_waitformoderator_ping_interval_description'] = 'モデレータの入室を確認するためどれくらいの頻度でサーバにpingを送信しますか?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonは非推奨のグローバル変数を持つconfig.phpを使用しています。今後のバージョンではサポートされないため、ファイルを変換してください。';
$string['config_warning_curl_not_installed'] = 'この機能ではPHPのcURL拡張モジュールがインストールおよび有効にされている必要があります。この条件に合致している場合のみ、設定にアクセスすることができます。';
$string['config_welcome_default'] = 'デフォルトウェルカムメッセージ';
$string['config_welcome_default_description'] = 'ルームへの参加者の入室時に表示されるウェルカムメッセージです。フィールドを空白にした場合、BigBlueButtonサーバに設定されているメッセージが表示されます。';
$string['config_welcome_editable'] = 'デフォルトのウェルカムメッセージは教師が編集可能です。';
$string['config_welcome_editable_description'] = 'インスタンスの追加または更新時にウェルカムメッセージの編集が可能です。';
$string['dpainfonotsigned'] = 'このプラグインを有効にする前にあなたは<a href="{$a}">Blindside Networksデータ処理契約</a>を確実に読んで承諾する必要があります。';
$string['enablingbigbluebutton'] = 'BigBlueButton活動を有効にする';
$string['enablingbigbluebuttondpainfo'] = 'あなたのデータ保護義務に合致するため、このプラグインにサービスプロバイダを使用する前に<a href="{$a}" target="_blank">Blindside Networksデータ処理規約</a>を読んで同意したことを確認する必要があります。
<br />
アドバイスについてはあなたの個人情報保護専門家にご相談ください。';
$string['end_session_confirm'] = '本当にセッションを終了してもよろしいですか?';
$string['end_session_confirm_title'] = '本当にセッションを終了してもよろしいですか?';
$string['end_session_notification'] = 'セッションは終了しました。';
$string['ends_at'] = '終了';
$string['event_activity_created'] = '活動が作成されました。';
$string['event_activity_deleted'] = '活動が削除されました。';
$string['event_activity_updated'] = '活動が更新されました。';
$string['event_live_session'] = 'ライブセッションイベント';
$string['event_meeting_created'] = 'ミーティングが作成されました。';
$string['event_meeting_ended'] = 'ミーティングが強制終了されました。';
$string['event_meeting_joined'] = 'ミーティングに参加しました。';
$string['event_meeting_left'] = 'ミーティングを退出しました。';
$string['event_recording_deleted'] = 'レコーディングが削除されました。';
$string['event_recording_edited'] = 'レコーディングが編集されました。';
$string['event_recording_imported'] = 'レコーディングがインポートされました。';
$string['event_recording_protected'] = 'レコーディングが保護されました。';
$string['event_recording_published'] = 'レコーディングが公開されました。';
$string['event_recording_unprotected'] = 'レコーディングが保護解除されました。';
$string['event_recording_unpublished'] = 'レコーディングが非公開にされました。';
$string['event_recording_viewed'] = 'レコーディングが閲覧されました。';
$string['event_unknown'] = '不明なイベント';
$string['general_error_cannot_create_meeting'] = 'セッションを作成できません。';
$string['general_error_cannot_get_recordings'] = 'レコーディングを取得できません。';
$string['general_error_no_answer'] = 'レスポンスが空です。BigBlueButtonサーバのURLを確認してしてください。また、BigBlueButtonサーバが稼働しているかどうか確認してください。';
$string['general_error_not_allowed_to_create_instances'] = 'ユーザーはいかなるタイプのインスタンスも作成できません。';
$string['general_error_not_found'] = 'エンティティが見つかりませんでした : {$a}';
$string['general_error_unable_connect'] = '接続できません。BigBlueButtonサーバのURLおよびBigBlueButtonサーバの稼働状況を確認してください。
詳細 : {$a}';
$string['index_confirm_end'] = '本当にセッションを終了してもよろしいですか?';
$string['index_disabled'] = '無効';
$string['index_enabled'] = '有効';
$string['index_ending'] = 'セッションを終了しています ... お待ちください。';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} が正しくありません。';
$string['index_error_checksum'] = 'チェックサムにエラーが発生しました。あなたが正しいシークレットを入力したことを確認してください。';
$string['index_error_forciblyended'] = '手動で終了されたためこのセッションに参加できません。';
$string['index_error_noinstances'] = 'BigBlueButtonルームのインスタンスはありません。';
$string['index_error_unable_display'] = 'セッションを表示できません。BigBlueButtonサーバのURLおよびBigBlueButtonサーバの稼働状況を確認してください。';
$string['index_heading'] = 'BigBlueButtonルーム';
$string['index_heading_actions'] = '操作';
$string['index_heading_group'] = 'グループ';
$string['index_heading_moderator'] = 'モデレータ';
$string['index_heading_name'] = 'ルーム';
$string['index_heading_recording'] = 'レコーディング';
$string['index_heading_users'] = 'ユーザ';
$string['index_heading_viewer'] = '視聴者';
$string['indicator:cognitivedepth'] = 'BigBlueButton設定';
$string['indicator:cognitivedepth_help'] = 'この指標はBigBlueButton活動で学生が到達した認知的な深さに基づきます。';
$string['indicator:socialbreadth'] = 'BigBlueButtonBNソーシャル';
$string['indicator:socialbreadth_help'] = 'この指標はBigBlueButton活動で学生が到達した社会的広がりに基づきます。';
$string['instance_type_default'] = 'レコーディング付きルーム';
$string['instance_type_recording_only'] = 'レコーディングのみ';
$string['instance_type_room_only'] = 'ルームのみ';
$string['instanceprofilewithoutrecordings'] = 'このインスタンスプロファイルはレコーディングを表示できません。';
$string['messageprovider:instance_updated'] = 'BigBlueButtonセッションが更新されました。';
$string['messageprovider:recording_ready'] = 'BigBlueButtonセッション利用可能';
$string['minute'] = '分';
$string['minutes'] = '分';
$string['mod_form_block_general'] = '一般';
$string['mod_form_block_participants'] = 'ライブセッション中に割り当てられたロール';
$string['mod_form_block_presentation'] = 'プレゼンテーションコンテンツ';
$string['mod_form_block_presentation_default'] = 'プレゼンテーションデフォルトコンテンツ';
$string['mod_form_block_record'] = 'レコーディング設定';
$string['mod_form_block_recordings'] = 'レコーディングビュー';
$string['mod_form_block_room'] = '/ルーム設定';
$string['mod_form_block_schedule'] = 'セッションタイミング';
$string['mod_form_field_closingtime'] = '終了';
$string['mod_form_field_conference_name'] = 'セッション名';
$string['mod_form_field_disablecam'] = 'ウェブカメラを無効にする';
$string['mod_form_field_disablemic'] = 'マイクを無効にする';
$string['mod_form_field_disablenote'] = '共有ノートを無効にする';
$string['mod_form_field_disableprivatechat'] = 'プライベートチャットを無効にする';
$string['mod_form_field_disablepublicchat'] = 'パブリックチャットを無効にする';
$string['mod_form_field_duration'] = '継続時間';
$string['mod_form_field_duration_help'] = 'ミーティングの継続時間を設定することにより、レコーディングが終了するまでのミーティングの最大継続時間を設定します。';
$string['mod_form_field_hideuserlist'] = 'ユーザ一覧を秘匿する';
$string['mod_form_field_instanceprofiles'] = 'インスタンスタイプ';
$string['mod_form_field_instanceprofiles_help'] = 'セッションをレコーディングする場合、「レコーディング付きルーム」、そうでない場合、「ルームのみ」を選択してください。セッションレコーディング後、それ以上のセッションを開始しない場合、「レコーディングのみ」を選択してください。';
$string['mod_form_field_intro'] = '説明';
$string['mod_form_field_intro_help'] = 'ルームの短い説明です。';
$string['mod_form_field_lockonjoin'] = '参加のロック設定';
$string['mod_form_field_muteonstart'] = '開始時ミュートする';
$string['mod_form_field_name'] = 'ルーム名';
$string['mod_form_field_nosettings'] = '編集できる設定はありません。';
$string['mod_form_field_openingtime'] = '開始';
$string['mod_form_field_participant_add'] = '割り当てを追加する';
$string['mod_form_field_participant_bbb_role_moderator'] = 'モデレータ';
$string['mod_form_field_participant_bbb_role_viewer'] = '視聴者';
$string['mod_form_field_participant_list'] = '割り当て';
$string['mod_form_field_participant_list_action_add'] = '追加する';
$string['mod_form_field_participant_list_action_remove'] = '削除する';
$string['mod_form_field_participant_list_text_as'] = '-';
$string['mod_form_field_participant_list_type_all'] = 'すべての登録済みユーザ';
$string['mod_form_field_participant_list_type_owner'] = 'オーナー';
$string['mod_form_field_participant_list_type_role'] = 'ロール';
$string['mod_form_field_participant_list_type_user'] = 'ユーザ';
$string['mod_form_field_record'] = 'セッションをレコーディングできる';
$string['mod_form_field_recordallfromstart'] = '最初からすべてレコーディングする';
$string['mod_form_field_recordhidebutton'] = 'レコーディングボタンを隠す';
$string['mod_form_field_recordings_deleted'] = '削除済み活動のレコーディングを含む';
$string['mod_form_field_recordings_html'] = 'プレインHTMLでテーブルを表示する';
$string['mod_form_field_recordings_imported'] = 'インポート済みリンクのみ表示する';
$string['mod_form_field_recordings_preview'] = 'レコーディングプレビュを表示する';
$string['mod_form_field_room_name'] = 'ルーム名';
$string['mod_form_field_userlimit'] = 'ユーザ制限';
$string['mod_form_field_userlimit_help'] = 'セッションで許可される最大ユーザ制限です。制限にゼロが設定された場合、ユーザ数は無制限となります。';
$string['mod_form_field_voicebridge'] = 'ボイスブリッジ [####]';
$string['mod_form_field_voicebridge_format_error'] = 'フォーマットエラーです。あなたは1から9999までの数字を入力する必要があります。';
$string['mod_form_field_voicebridge_help'] = 'ダイヤルイン使用時に参加者が音声セッションに参加するために入力する1〜9999の番号です。この値が0の場合、静的なボイスブリッジ番号は無視されてBigBlueButtonによってランダムな番号が生成されます。入力された4桁の数字の前に7が付加されます。';
$string['mod_form_field_voicebridge_notunique_error'] = '値がユニークではありません。このナンバーは別のルームで使用されています。';
$string['mod_form_field_wait'] = 'モデレータを待つ';
$string['mod_form_field_wait_help'] = '視聴者は入室までモデレータを待つ必要がありますか?';
$string['mod_form_field_welcome'] = 'ウェルカムメッセージ';
$string['mod_form_field_welcome_default'] = '%%CONFNAME%% にようこそ';
$string['mod_form_field_welcome_help'] = 'ルームへの参加者の入室時に表示されるウェルカムメッセージです。フィールドを空白にした場合、サイト管理に設定されているデフォルトメッセージが表示されます。';
$string['mod_form_locksettings'] = 'ロック設定';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButtonはオンライン学習用に設計されたオープンソースのウェブ会議システムです。音声、ビデオ、チャット、スライド、画面共有、マルチユーザホワイトボード、ブレイクアウトルーム、投票、絵文字等のリアルタイム共有に対応しています。

BigBlueButtonの使用により、あなたはライブのオンライン授業、バーチャルオフィスアワー、遠隔地の学生とのグループコラボレーション等のセッションのためのルームを作成できます。セッションは後で再生するためにレコーディングできます。';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton活動';
$string['nosuchinstance'] = 'そのようなインスタンス {$a->entity} (ID: {$a->id}) は存在しません。';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButtonルームが作成されました。';
$string['notification_instance_created_small'] = '{$a->name} という名称の新しいBigBlueButtonルームが作成されました。';
$string['notification_instance_created_subject'] = '新しいBigBlueButtonルーム活動が作成されました。';
$string['notification_instance_description'] = '説明';
$string['notification_instance_end_date'] = '終了日';
$string['notification_instance_name'] = 'タイトル';
$string['notification_instance_start_date'] = '開始日';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButtonルームが更新されました。';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButtonセッションが更新されました。';
$string['notification_instance_updated_subject'] = 'あなたのBigBlueButtonルームが更新されました。';
$string['notification_recording_ready_html'] = 'BigBlueButtonルーム <a href="{$a->link}">{$a->name}</a> でのセッションのレコーディングが利用可能となりました。';
$string['notification_recording_ready_plain'] = 'BigBlueButtonルーム {$a->name} でのセッションのレコーディングが利用可能となりました。レコーディングリンクにアクセスするには {$a->link} に移動してください。';
$string['notification_recording_ready_small'] = 'BigBlueButton {$a->name} のレコーディングが利用可能となりました。';
$string['notification_recording_ready_subject'] = 'レコーディング利用可能';
$string['pluginadministration'] = 'BigBlueButton管理';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButtonセッションを作成および参加するにはユーザデータをサーバと交換する必要があります。';
$string['privacy:metadata:bigbluebutton:fullname'] = 'BigBlueButtonサーバにアクセスするユーザのフルネームです。';
$string['privacy:metadata:bigbluebutton:userid'] = 'BigBlueButtonサーバにアクセスするユーザのユーザIDです。';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButtonセッション設定';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'BigBlueButtonセッションでのユーザのロールを定義するルール一覧です。ロールまたはユーザごとにパーミッションを付与できるためユーザIDを保存できます。';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'プラグイン使用時に発生したイベントを保存します。';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'ユーザにより発生したイベントのタイプです。';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ユーザがアクセスしたセッションIDです。';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'セッションまたはレコーディングに関連する追加情報です。';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'ログが作成された時間です。';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'イベントを発生させたユーザのユーザIDです。';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'レコーディングに関するメタデータを保存します。';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = '最後にレコーディングを変更したユーザのユーザIDです。';
$string['recordings_from_deleted_activities'] = '削除された活動のレコーディング';
$string['recordingurlnotfound'] = 'レコーディングURLは有効ではありません。';
$string['removedevents'] = '削除されたイベント';
$string['removedlogs'] = '削除されたカスタムログ';
$string['removedrecordings'] = '削除されたレコーディング';
$string['removedtags'] = '削除されたタグ';
$string['report_join_info'] = 'ルーム参加 {$a} 回';
$string['report_play_recording_info'] = 'レコーディング再生 {$a} 回';
$string['report_room_view'] = 'ルーム閲覧済み';
$string['resetevents'] = 'イベントを削除';
$string['resetlogs'] = 'カスタムログを削除';
$string['resetlogs_help'] = 'ログの削除によりレコーディングへの参照を失うことになります。';
$string['resetrecordings'] = 'レコーディングの削除';
$string['resetrecordings_help'] = 'レコーディングを削除した場合、どこからもアクセスできなくなります。この操作は元に戻せません!';
$string['resettags'] = 'タグの削除';
$string['search:activity'] = 'BigBlueButton - 活動情報';
$string['search:tags'] = 'BigBlueButton - タグ情報';
$string['sendnotification'] = '通知を送信する';
$string['settings'] = 'BigBlueButton設定';
$string['started_at'] = '開始';
$string['starts_at'] = '開始';
$string['taskname:check_pending_recordings'] = '保留中レコーディングを取得する';
$string['userlimitreached'] = 'セッションに参加できるユーザ数が上限に達しました。';
$string['view_conference_action_end'] = 'セッション終了';
$string['view_conference_action_join'] = 'セッションに参加する';
$string['view_error_action_not_completed'] = 'アクションを完了できませんでした。';
$string['view_error_bigbluebutton'] = 'BigBlueButtonにエラーが発生しました: {$a}';
$string['view_error_create'] = 'BigBlueButtonサーバがエラーメッセージを返しました。ルームを作成できませんでした。';
$string['view_error_current_state_not_found'] = '現在の状態が見つかりませんでした。レコーディングが削除されたか、実行したアクションにBigBlueButtonサーバが対応していない可能性があります。';
$string['view_error_import_no_courses'] = 'レコーディングのために検索するコースはありません。';
$string['view_error_import_no_recordings'] = 'このコースにはインポートするレコーディングはありません。';
$string['view_error_invalid_session'] = 'セッションの有効期限が切れました。活動ページに戻ってください。';
$string['view_error_max_concurrent'] = '許可される同時セッション数に達しました。';
$string['view_error_meeting_not_running'] = '問題が発生しました。セッションが実行されていません。';
$string['view_error_no_group'] = 'グループがありません。あなたはセッションに参加する前にグループを作成する必要があります。';
$string['view_error_no_group_student'] = 'あなたはグループに登録されていません。あなたの教師にご連絡ください。';
$string['view_error_no_group_teacher'] = 'グループがありません。あなたはグループを作成する必要があります。';
$string['view_error_unable_join'] = 'ルームに参加できません。BigBlueButtonサーバのURLおよびBigBlueButtonサーバの稼働状況を確認してください。';
$string['view_error_unable_join_student'] = 'BigBlueButtonサーバに接続できません。';
$string['view_error_unable_join_teacher'] = 'BigBlueButtonサーバに接続できません。管理者にご連絡ください。';
$string['view_error_url_missing_parameters'] = 'このURLにはパラメータが不足しています。';
$string['view_error_userlimit_reached'] = 'セッションに許可されるユーザ数に達しました。';
$string['view_groups_nogroups_warning'] = 'ルームはグループを使用するよう設定されていますが、コースにはグループが定義されていません。';
$string['view_groups_notenrolled_warning'] = 'ルームはグループを使用するよう設定されていますが、あなたはグループのメンバーではありません。';
$string['view_groups_selection'] = 'あなたが参加したいグループを選択して操作を確認してください。';
$string['view_groups_selection_join'] = '参加';
$string['view_groups_selection_warning'] = 'それぞれのグループにルームがあります。あなたは2つ以上のルームにアクセスしています。正しいルームを選択してください。';
$string['view_login_moderator'] = 'モデレータとしてログインする ...';
$string['view_login_viewer'] = '視聴者としてログインする ...';
$string['view_message_and'] = 'および';
$string['view_message_conference_has_ended'] = 'このセッションは終了しています。';
$string['view_message_conference_in_progress'] = 'このセッションは開催中です。';
$string['view_message_conference_not_started'] = 'このセッションはまだ開始されていません。';
$string['view_message_conference_room_ready'] = 'このルームの準備が完了しました。あなたはセッションに参加できます。';
$string['view_message_conference_wait_for_moderator'] = '参加するためのモデレータを待っています。';
$string['view_message_finished'] = 'この活動は終了しました。';
$string['view_message_has_joined'] = '参加しました。';
$string['view_message_have_joined'] = '参加しました。';
$string['view_message_hour'] = '時間';
$string['view_message_hours'] = '時間';
$string['view_message_importrecordings_disabled'] = 'このサーバではレコーディングインポートリンクが無効にされています。';
$string['view_message_minute'] = '分';
$string['view_message_minutes'] = '分';
$string['view_message_moderator'] = 'モデレータ';
$string['view_message_moderators'] = 'モデレータ';
$string['view_message_norecordings'] = '利用可能なレコーディングはありません。';
$string['view_message_notavailableyet'] = 'このセッションはまだ利用できません。';
$string['view_message_recordings_disabled'] = 'サーバのレコーディングが無効にされています。BigBlueButton活動の「レコーディングのみ」タイプは利用できません。';
$string['view_message_room_closed'] = 'このルームはクローズされています。';
$string['view_message_room_open'] = 'このルームはオープンされています。';
$string['view_message_room_ready'] = 'このルームの準備が完了しました。';
$string['view_message_session_for'] = 'セッション:';
$string['view_message_session_has_user'] = '&nbsp;';
$string['view_message_session_has_users'] = '&nbsp;';
$string['view_message_session_no_users'] = 'このセッションにはユーザはいません。';
$string['view_message_session_running_for'] = 'このセッションは次の時間開催されています:';
$string['view_message_session_started_at'] = 'このセッションは次の時間に開始しました:';
$string['view_message_tab_close'] = 'タブ/ウィンドウは手動で閉じる必要があります。';
$string['view_message_times'] = '回';
$string['view_message_user'] = 'ユーザ';
$string['view_message_users'] = 'ユーザ';
$string['view_message_viewer'] = '視聴者';
$string['view_message_viewers'] = '視聴者';
$string['view_mobile_message_groups_not_supported'] = 'このインスタンスはグループとの連携が可能ですが、まだモバイルアプリでは対応していません。ウェブバージョンをご利用ください。';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'あなたはこのページで45秒を超えました。セッションに参加するにはページをリロードしてください。';
$string['view_noguests'] = 'BigBlueButtonルームはゲストに公開されていません。';
$string['view_nojoin'] = 'あなたにはこのセッションに参加できるロールはありません。';
$string['view_recording'] = 'レコーディング';
$string['view_recording_actionbar'] = 'ツールバー';
$string['view_recording_activity'] = '活動';
$string['view_recording_button_import'] = 'レコーディングインポートリンク';
$string['view_recording_button_return'] = '戻る';
$string['view_recording_course'] = 'コース';
$string['view_recording_date'] = '日付';
$string['view_recording_delete_confirmation'] = '本当に {$a} を削除してもよろしいですか?';
$string['view_recording_delete_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動にインポートされた {$a} のリンクがあります。レコーディングが削除された場合、インポートされたリンクも削除されます。';
$string['view_recording_delete_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動にインポートされた {$a} のリンクがあります。レコーディングが削除された場合、インポートされたリンクも削除されます。';
$string['view_recording_description'] = '説明';
$string['view_recording_description_edithint'] = 'レコーディングを識別するため説明を追加できます。';
$string['view_recording_description_editlabel'] = '説明を編集する';
$string['view_recording_duration'] = '継続時間';
$string['view_recording_duration_min'] = '分';
$string['view_recording_format_errror_unreachable'] = 'このレコーディングフォーマットのURLには到達できません。';
$string['view_recording_format_notes'] = 'ノート';
$string['view_recording_format_podcast'] = 'ポッドキャスト';
$string['view_recording_format_presentation'] = 'プレゼンテーション';
$string['view_recording_format_screenshare'] = 'スクリーン共有';
$string['view_recording_format_statistics'] = '統計';
$string['view_recording_format_video'] = 'ビデオ';
$string['view_recording_import_confirmation'] = '本当にこのレコーディングをインポートしてもよろしいですか?';
$string['view_recording_length'] = '長さ';
$string['view_recording_link_warning'] = 'このリンクは異なるコースまたは活動で作成されたレコーディングを指しています。';
$string['view_recording_list_action_delete'] = '削除';
$string['view_recording_list_action_edit'] = '更新';
$string['view_recording_list_action_play'] = '再生';
$string['view_recording_list_action_process'] = '処理中';
$string['view_recording_list_action_protect'] = '保護中';
$string['view_recording_list_action_publish'] = '公開';
$string['view_recording_list_action_unprotect'] = '保護解除';
$string['view_recording_list_action_unpublish'] = '非公開';
$string['view_recording_list_action_update'] = '更新';
$string['view_recording_list_actionbar'] = 'ツールバー';
$string['view_recording_list_actionbar_delete'] = '削除';
$string['view_recording_list_actionbar_edit'] = '編集';
$string['view_recording_list_actionbar_hide'] = '隠す';
$string['view_recording_list_actionbar_import'] = 'インポート';
$string['view_recording_list_actionbar_protect'] = '非公開にする';
$string['view_recording_list_actionbar_publish'] = '公開する';
$string['view_recording_list_actionbar_show'] = '表示する';
$string['view_recording_list_actionbar_unprotect'] = '公開にする';
$string['view_recording_list_actionbar_unpublish'] = '非公開にする';
$string['view_recording_list_activity'] = '活動';
$string['view_recording_list_course'] = 'コース';
$string['view_recording_list_date'] = '日付';
$string['view_recording_list_description'] = '説明';
$string['view_recording_list_duration'] = '継続時間';
$string['view_recording_list_recording'] = 'レコーディング';
$string['view_recording_meeting'] = 'ミーティング';
$string['view_recording_modal_button'] = '適用';
$string['view_recording_modal_title'] = 'レコーディングの値を設定する';
$string['view_recording_name'] = '名称';
$string['view_recording_name_edithint'] = 'レコーディングを識別するため名称を追加できます。';
$string['view_recording_name_editlabel'] = '名称を編集する';
$string['view_recording_playback'] = 'プレイバック';
$string['view_recording_preview'] = 'プレビュ';
$string['view_recording_preview_help'] = 'フルサイズで表示するにはイメージにカーソルを合わせてください。';
$string['view_recording_protect_confirmation'] = '本当にこの {$a} を保護してもよろしいですか?';
$string['view_recording_protect_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが保護されている場合、インポートされたリンクにも影響します。';
$string['view_recording_protect_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが保護されている場合、インポートされたリンクにも影響します。';
$string['view_recording_publish_confirmation'] = '本当にこの {$a} を公開してもよろしいですか?';
$string['view_recording_publish_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが公開されている場合、インポートされたリンクも公開されます。';
$string['view_recording_publish_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが公開されている場合、インポートされたリンクも公開されます。';
$string['view_recording_publish_link_deleted'] = '現在のBigBlueButtonサーバにオリジナルのレコーディングが存在しないため、このリンクは再公開できません。このリンクは削除してください。';
$string['view_recording_publish_link_not_published'] = 'オリジナルのレコーディングが非公開のため、このリンクは再公開できません。';
$string['view_recording_recording'] = 'レコーディング';
$string['view_recording_select_course'] = 'ドロップダウンメニューで最初にコースを選択する';
$string['view_recording_tags'] = 'タグ';
$string['view_recording_unprotect_confirmation'] = '本当にこの {$a} を保護解除してもよろしいですか?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが保護解除された場合、インポートされたリンクにも影響します。';
$string['view_recording_unprotect_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動でインポートされた {$a} のリンクが関連付けられています。レコーディングが保護解除された場合、インポートされたリンクにも影響します。';
$string['view_recording_unprotect_link_deleted'] = '現在のBigBlueButtonサーバに実際のレコーディングが存在しないため、このリンクは保護解除できません。このリンクは削除してください。';
$string['view_recording_unprotect_link_not_unprotected'] = '実際のレコーディングが保護されているため、このリンクは保護解除できません。';
$string['view_recording_unpublish_confirmation'] = '本当に {$a} を非公開にしてもよろしいですか?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'このレコーディングには異なるコースまたは活動にインポートされた {$a} のリンクがあります。レコーディングが非公開にされた場合、インポートされたリンクも非公開にされます。';
$string['view_recording_unpublish_confirmation_warning_s'] = 'このレコーディングには異なるコースまたは活動にインポートされた {$a} のリンクがあります。レコーディングが非公開にされた場合、インポートされたリンクも非公開にされます。';
$string['view_recording_yui_first'] = '最初';
$string['view_recording_yui_go'] = 'Go';
$string['view_recording_yui_last'] = '最後';
$string['view_recording_yui_next'] = '次へ';
$string['view_recording_yui_page'] = 'ページ';
$string['view_recording_yui_prev'] = '前へ';
$string['view_recording_yui_rows'] = '行';
$string['view_recording_yui_show_all'] = 'すべてを表示する';
$string['view_room'] = 'ルームを表示する';
$string['view_section_title_presentation'] = 'プレゼンテーションファイル';
$string['view_section_title_recordings'] = 'レコーディング';
$string['view_warning_default_server'] = 'このサイトはBlindside Networksが提供する<a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">Free BigBlueButton service for Moodle (新しいウィンドウで開く)</a>を以下の制限で使用しています:
<ol>
<li>1セッション最大長: 60分</li>
<li>1セッション最大同時使用人数: 25人</li>
<li>レコーディング有効期限: 7日間 (ダウンロード不可)</li>
<li>学生のウェブカム: モデレータにのみ表示される</li>
</ol>';
$string['waitformoderator'] = 'モデレータの参加を待っています。';
