<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'pt_br', version '4.0'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Você pode visualizar este teste, mas se isto fosse uma tentativa real, você seria bloqueado porque:
';
$string['action'] = 'Ação';
$string['activityoverview'] = 'Você tem questionários pendentes';
$string['adaptive'] = 'Modo adaptativo';
$string['adaptive_help'] = 'Se habilitado, serão permitidas várias respostas a uma questão em uma mesma tentativa do questionário. Por exemplo, se uma resposta está marcada como incorreta, será permitido ao estudante tentar novamente. No entanto, dependendo da configuração de "Aplicar penalidades", uma penalidade normalmente será aplicada a cada tentativa errada.';
$string['add'] = 'Adicionar';
$string['addaquestion'] = 'uma nova questão';
$string['addarandomquestion'] = 'uma questão aleatória';
$string['addarandomquestion_help'] = 'Quando uma questão aleatória é adicionada, resulta em uma questão escolhida aleatoriamente da categoria que está sendo inserida no questionário. Isso significa que diferentes estudantes provavelmente receberão uma seleção diferente de questões, e quando um questionário permitir múltiplas tentativas, cada tentativa provavelmente conterá uma nova seleção de questões.';
$string['addarandomselectedquestion'] = 'Adicionar uma questão aleatória...';
$string['addasection'] = 'Novo título da seção';
$string['adddescriptionlabel'] = 'Adicionar um item de descrição';
$string['addingquestion'] = 'Adicionando uma questão';
$string['addingquestions'] = '<p>Neste lado da página você administra seu banco de questões. As questões são organizadas em categorias e podem ser utilizadas por qualquer questionário deste curso ou mesmo em outros cursos se você optar por "publicá-las".</p>
<p>Depois de selecionar ou criar uma categoria você poderá criar ou editar questões. Você pode selecionar qualquer uma destas questões para adicionar ao seu questionário no outro lado desta página.';
$string['addmoreoverallfeedbacks'] = 'Adicionar {no} outro(s) campo(s) de feedback';
$string['addnewgroupoverride'] = 'Adicionar sobreposição de grupo';
$string['addnewpagesafterselected'] = 'Adicionar novas páginas após questões selecionadas';
$string['addnewquestionsqbank'] = 'Adicionar questões à categoria {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Adicionar sobreposição de usuário';
$string['addpagebreak'] = 'Adicionar quebra de página';
$string['addpagehere'] = 'Adicionar página aqui';
$string['addquestion'] = 'Adicionar questão';
$string['addquestionfrombankatend'] = 'Adicionar questão do banco de questões no final';
$string['addquestionfrombanktopage'] = 'Adicionar questão do banco de questões na página {$a}';
$string['addquestions'] = 'Adicionar questões';
$string['addquestionstoquiz'] = 'Adicionar questões ao questionário atual';
$string['addrandom'] = 'Adicionar {$a} questões aleatórias';
$string['addrandom1'] = '<< Adicionar';
$string['addrandom2'] = 'questões aleatórias';
$string['addrandomfromcategory'] = 'Adicionar questões aleatórias da categoria:';
$string['addrandomquestion'] = 'Adicionar questões aleatórias';
$string['addrandomquestionatend'] = 'Adicionar uma questão aleatória no final';
$string['addrandomquestiontopage'] = 'Adicionar uma questão aleatória na página {$a}';
$string['addrandomquestiontoquiz'] = 'Adicionar uma questão aleatória ao questionário {$a}';
$string['addselectedquestionstoquiz'] = 'Adicionar questão selecionadas ao questionário';
$string['addselectedtoquiz'] = 'Adicionar as questões selecionadas ao questionário';
$string['addtoquiz'] = 'Adicionar ao questionário';
$string['affectedstudents'] = 'Atingidos {$a}';
$string['aftereachquestion'] = 'Após adicionar cada questão';
$string['afternquestions'] = 'Após adicionar {$a} questões';
$string['age'] = 'idade';
$string['allattempts'] = 'Todas as tentativas';
$string['allinone'] = 'Ilimitado';
$string['allowreview'] = 'Permitir revisão';
$string['alreadysubmitted'] = 'É provável que você já tenha enviado esta tentativa';
$string['alternativeunits'] = 'Unidades alternativas';
$string['alwaysavailable'] = 'Sempre disponível';
$string['analysisoptions'] = 'Opções de análise';
$string['analysistitle'] = 'Tabela de análise de itens';
$string['answer'] = 'Resposta';
$string['answered'] = 'Respondido';
$string['answerhowmany'] = 'Uma ou múltiplas respostas?';
$string['answers'] = 'Respostas';
$string['answersingleno'] = 'Respostas múltiplas permitidas';
$string['answersingleyes'] = 'Apenas uma resposta';
$string['answertoolong'] = 'Resposta longa demais a partir da linha {$a} (máximo de 255 caracteres)';
$string['anytags'] = 'Qualquer tag';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = 'Você quer mesmo remover todas as questões selecionadas?';
$string['asshownoneditscreen'] = 'Como mostrado na tela de edição';
$string['attempt'] = 'Tentativa {$a}';
$string['attemptalreadyclosed'] = 'Essa tentativa já foi encerrada.';
$string['attemptclosed'] = 'A tentativa ainda não foi fechada';
$string['attemptduration'] = 'Tempo utilizado';
$string['attemptedon'] = 'Tentativas em';
$string['attempterror'] = 'Você não tem permissão de tentar este questionário neste momento porque: {$a}';
$string['attempterrorcontentchange'] = 'Essa visualização do questionário não existe mais. (Quando um questionário é editado, todas as visualizações em andamento são excluídas automaticamente.)';
$string['attempterrorcontentchangeforuser'] = 'Esta tentativa do questionário não existe mais.';
$string['attempterrorinvalid'] = 'ID de tentativa de questionário inválido';
$string['attemptfirst'] = 'Primeira tentativa';
$string['attemptincomplete'] = 'Esta tentativa (por {$a}) ainda não foi concluída.';
$string['attemptlast'] = 'Última tentativa';
$string['attemptnumber'] = 'Tentativa';
$string['attemptquiz'] = 'Tentativa do questionário';
$string['attemptquiznow'] = 'Tentar responder o questionário agora';
$string['attemptreviewtitle'] = '{$a}: Revisão da tentativa';
$string['attemptreviewtitlepaged'] = '{$a->name}: Revisão da tentativa (página {$a->currentpage} de {$a->totalpages})';
$string['attempts'] = 'Tentativas';
$string['attempts_help'] = 'O número total de tentativas permitidas (não o número de tentativas extras).';
$string['attemptsallowed'] = 'Tentativas permitidas';
$string['attemptsdeleted'] = 'Excluir tentativas do questionário';
$string['attemptselection'] = 'Selecionar as tentativas a serem analisadas em relação aos usuários:';
$string['attemptsexist'] = 'Este questionário já foi respondido.';
$string['attemptsnum'] = 'Tentativas: {$a}';
$string['attemptsnumthisgroup'] = 'Tentativas: {$a->total} ({$a->group} deste grupo)';
$string['attemptsnumyourgroups'] = 'Tentativas: {$a->total} ({$a->group} do seu grupo)';
$string['attemptsonly'] = 'Mostrar apenas estudantes com tentativas realizadas';
$string['attemptstate'] = 'Estado';
$string['attemptstillinprogress'] = 'Tentativa em andamento';
$string['attemptsummarytitle'] = '{$a}: Resumo da tentativa';
$string['attemptsunlimited'] = 'Tentativas ilimitadas';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (página {$a->currentpage} de {$a->totalpages})';
$string['autosaveperiod'] = 'Intervalo de tempo para salvamento automático';
$string['autosaveperiod_desc'] = 'As respostas podem ser salvas automaticamente durante as tentativas de questionário. As respostas são salvas sempre que alteradas e depois desse tempo. Existe uma relação de perda e ganho: um tempo menor aumenta a carga do servidor, mas reduz a chance dos estudantes perderem o trabalho. Se você quiser diminuir esse tempo, altere o valor gradualmente e monitore a carga do servidor. Se a carga ficar muito alta, aumente o tempo novamente. Definir o tempo como 0 desativa o salvamento automático.';
$string['back'] = 'Voltar à visualização prévia da questão';
$string['backtocourse'] = 'Voltar ao curso';
$string['backtoquestionlist'] = 'Voltar à lista de questões';
$string['backtoquiz'] = 'Voltar para edição do questionário';
$string['basicideasofquiz'] = 'As ideias básicas de construção do questionário';
$string['bestgrade'] = 'Melhor nota';
$string['bothattempts'] = 'Mostrar estudantes com e sem tentativas';
$string['browsersecurity'] = 'Segurança do navegador';
$string['browsersecurity_help'] = 'Se a opção "Tela cheia pop-up com segurança JavaScript" estiver selecionada,

* O questionário só vai começar se o JavaScript estiver habilitado no navegador do estudante.
* O questionário aparece em uma janela <em>pop-up</em> em tela cheia, que abrange todas as outras janelas e não tem controles de navegação
 * Estudantes são impedidos, na medida do possível, de usar os recursos como copiar e colar.';
$string['cachedef_overrides'] = 'Informação de sobreposições de usuário e grupo';
$string['calculated'] = 'Calculado';
$string['calculatedquestion'] = 'A questão calculada da linha {$a} não é suportada. A questão será ignorada';
$string['cannotcreatepath'] = 'Percurso não pode ser criado ({$a})';
$string['cannoteditafterattempts'] = 'Você não pode adicionar ou remover questões, porque existem tentativas registradas neste questionário. ({$a})';
$string['cannotfindprevattempt'] = 'Não foi possível encontrar a tentativa anterior.';
$string['cannotfindquestionregard'] = 'Falha ao obter questões para reavaliação!';
$string['cannotinsert'] = 'Impossível inserir questão';
$string['cannotinsertrandomquestion'] = 'Não foi possível inserir uma nova questão aleatória!';
$string['cannotloadquestion'] = 'Não foi possível carregar as opções da questão';
$string['cannotloadtypeinfo'] = 'Não foi possível carregar questiontype informações questão específica';
$string['cannotopen'] = 'Impossível abrir arquivo de exportação ({$a})';
$string['cannotremoveslots'] = 'Não é possível excluir questões';
$string['cannotrestore'] = 'Não foi possível restaurar as sessões de questões';
$string['cannotreviewopen'] = 'Você não pode rever essa tentativa, ela ainda está aberta.
';
$string['cannotsavelayout'] = 'Não foi possível salvar o layout';
$string['cannotsavenumberofquestion'] = 'Não foi possível salvar número de questões por página';
$string['cannotsavequestion'] = 'Não foi possível salvar lista de questões';
$string['cannotsetgrade'] = 'Não foi possível definir nova nota máxima para questionário';
$string['cannotsetsumgrades'] = 'Falhou ao definir soma de notas';
$string['cannotstartgradesmismatch'] = 'Você não pode iniciar uma tentativa neste questionário. O Questionário está configurado para ser avaliado com nota {$a->grade}, mas nenhuma das questões valem nota. Isso pode ser arrumado na página \'Editar questionário".';
$string['cannotstartmissingquestion'] = 'Não foi possivel iniciar tentativa para esse questionário.  As definições do questionário incluem uma questão que não existe.';
$string['cannotstartnoquestions'] = 'Não é possível iniciar uma tentativa neste questionário. O questionário não foi configurado ainda. Nenhuma questão foi adicionada.';
$string['cannotwrite'] = 'Impossível escrever arquivo de exportação ({$a})';
$string['canredoquestions'] = 'Permitir refazer dentro de uma tentativa';
$string['canredoquestions_desc'] = 'Se habilitado, quando os estudantes terminarem a tentativa de uma questão específica, eles verão um botão Refazer questão. Isso permite que eles tentem uma outra versão da mesma questão, sem ter de submeter toda a tentativa do questionário e começar outro. Essa opção é útil principalmente para testes de prática.

Esta configuração afeta somente questões (por exemplo questões não dissertativas) e comportamentos (por exemplo, feedback imediato, ou interativo com várias tentativas), onde é posível ao estudante finalizar a questão antes da tentativa ser submetida.';
$string['canredoquestions_help'] = 'Se habilitado, quando os estudantes terminarem a tentativa de uma questão específica, eles verão um botão Refazer questão. Isso permite que eles tentem uma outra versão da mesma questão, sem ter de submeter toda a tentativa do questionário e começar outro. Essa opção é útil principalmente para testes de prática.

Esta configuração afeta somente questões (por exemplo questões não dissertativas) e comportamentos (por exemplo, feedback imediato, ou interativo com várias tentativas), onde é posível ao estudante finalizar a questão antes da tentativa ser submetida.';
$string['canredoquestionsyes'] = 'Sim, fornecer a opção de tentar outra questão';
$string['caseno'] = 'Não importa a diferença entre maiúsculas e minúsculas';
$string['casesensitive'] = 'Considerar diferenças entre maiúsculas e minúsculas';
$string['caseyes'] = 'Sim, a correspondência com maiúsculas ou minúsculas deve ser exata';
$string['categoryadded'] = 'A categoria \'{$a}\' foi acrescentada';
$string['categorydeleted'] = 'A categoria \'{$a}\' foi cancelada';
$string['categorynoedit'] = 'O seu perfil de usuário não permite a edição na categoria \'{$a}\'.';
$string['categoryupdated'] = 'A categoria foi atualizada com sucesso';
$string['close'] = 'Fechar janela';
$string['closebeforeopen'] = 'Não foi possível atualizar o questionário. A data final é muito próxima à data de abertura.';
$string['closed'] = 'Fechada';
$string['closepreview'] = 'Fechar janela';
$string['closereview'] = 'Fechar janela';
$string['comment'] = 'Comentário';
$string['commentorgrade'] = 'Faça um comentário ou modifique a avaliação';
$string['comments'] = 'Comentários';
$string['completedon'] = 'Concluída em';
$string['completionattemptsexhausted'] = 'Todas as tentativas disponíveis concluídas';
$string['completionattemptsexhausted_help'] = 'Marcar questionário como completo quando o estudante tiver esgotado o número máximo de tentativas.';
$string['completionattemptsexhausteddesc'] = 'Considerar como finalizado após o término de todas as tentativas permitidas.';
$string['completiondetail:minattempts'] = 'Fazer tentativas: {$a}';
$string['completiondetail:passgrade'] = 'Receber uma nota de aprovação';
$string['completiondetail:passorexhaust'] = 'Receber uma nota de aprovação ou concluir todas as tentativas disponíveis';
$string['completionminattempts'] = 'Número mínimo de tentativas:';
$string['completionminattemptsdesc'] = 'Número mínimo de tentativas necessárias: {$a}';
$string['completionminattemptserror'] = 'O número mínimo de tentativas deve ser inferior ou igual às tentativas permitidas.';
$string['completionminattemptsgroup'] = 'Requerer tentativas';
$string['completionpass'] = 'Exigir nota de aprovação';
$string['completionpass_help'] = 'Se habilitado, esta atividade é considerada concluída quando o estudante receber uma nota igual ou superior à nota de aprovação (conforme definido na seção Nota das configurações do questionário).';
$string['completionpassdesc'] = 'O estudante deve obter uma nota de aprovação para completar esta atividade';
$string['completionpassorattemptsexhausteddesc'] = 'O estudante deve alcançar uma nota de aprovação ou terminar todas as tentativas disponíveis para completar essa atividade';
$string['configadaptive'] = 'Se você escolher \'Sim\' para esta opção, então será permitido ao estudante a utilização de múltiplas respostas a uma questão, até mesmo em uma mesma tentativa do questionário.';
$string['configattemptsallowed'] = 'Restrição no número de tentativas permitidas aos estudantes no questionário.';
$string['configdecimaldigits'] = 'Número de dígitos que devem ser mostrados após o ponto decimal ao mostrar notas.';
$string['configdecimalplaces'] = 'Número de dígitos que devem ser mostrados após o ponto decimal ao mostrar a pontuação para o questionário.';
$string['configdecimalplacesquestion'] = 'Número de dígitos que devem ser mostrados após o ponto decimal ao mostrar a nota para questões individuais.';
$string['configdelay1'] = 'Se você definir um intervalo de tempo, então um estudante tem que esperar que o tempo antes que eles podem tentar um teste após a primeira tentativa.';
$string['configdelay1st2nd'] = 'Se você definir aqui um tempo, o estudante não pode iniciar a sua segunda tentativa, até que esse tempo tenha se passado desde o final da primeira tentativa.';
$string['configdelay2'] = 'Se você definir um período de tempo aqui, então um estudante tem que esperar que o tempo antes que eles possam tentar as suas tentativas de terceiros ou posterior.';
$string['configdelaylater'] = 'Se você definir aqui um tempo, o estudante não pode iniciar a sua terceira, quarta ... tentativa até que este tempo tenha passado desde o fim da tentativa anterior.';
$string['configeachattemptbuildsonthelast'] = 'Se forem permitidas múltiplas tentativas, então cada nova tentativa contém o resultado da anterior.';
$string['configgrademethod'] = 'Quando são permitidas múltiplas tentativas, qual método deve ser utilizado para calcular a nota final do estudante para o questionário.';
$string['configintro'] = 'Os valores que você definir aqui determina os valores padrões que são utilizados nas configurações de formulário quando você cria um novo questionário. Você também pode definir as configurações avançadas.';
$string['configmaximumgrade'] = 'A nota máxima deste questionário.';
$string['confignavmethod'] = 'Usando navegação Livre, as questões pode ser respondidas em qualquer ordem usando a navegação.';
$string['confignewpageevery'] = 'Ao adicionar questões no questionário, as quebras de página serão inserida automaticamente conforme a configuração aqui escolhida.';
$string['configoutcomesadvanced'] = 'Se esta opção estiver ativada, então os resultados no formulário de edição de teste são configurações avançadas.';
$string['configpenaltyscheme'] = 'Punição atribuída a cada resposta errada no modo adaptativo.';
$string['configpopup'] = 'Força a tentativa de abrir em uma janela <em>pop-up</em>, e usar truques do JavaScript  para tentar restringir a copiar e colar, etc. durante as tentativas do questionário.';
$string['configrequirepassword'] = 'Os estudantes devem digitar essa senha antes que eles possam tentar responder o questionário.';
$string['configrequiresubnet'] = 'Os estudantes podem tentar responder o questionário apenas a partir desses computadores.';
$string['configreviewoptions'] = 'Estas opções controlam que informações os usuários podem ver ao rever uma tentativa de questionário ou ver nos relatórios.';
$string['configshowblocks'] = 'Mostra blocos durante as tentativas de resposta.';
$string['configshowuserpicture'] = 'Mostra a foto do usuário na tela durante as tentativas.';
$string['configshufflewithin'] = 'Se você habilitar esta opção, então as partes que compõem cada uma das questões será mudada aleatoriamente toda vez que um estudante iniciar uma tentativa no questionário, desde que a opção também esteja ativada nas configurações do questionário.';
$string['configtimelimit'] = 'Limite padrão de tempo para questionário em minutos. 0 significa sem limite de tempo.';
$string['configtimelimitsec'] = 'Limite padrão de tempo para questionário em segundos. 0 significa sem limite de tempo.';
$string['configurerandomquestion'] = 'Configurar questão';
$string['confirmclose'] = 'Uma vez enviada, você não poderá alterar as respostas para esta tentativa.';
$string['confirmremovequestion'] = 'Tem certeza de que deseja remover esta questão {$a}?';
$string['confirmremovesectionheading'] = 'Você tem certeza de que deseja remover o cabeçalho da seção \'{$a}\'?';
$string['confirmserverdelete'] = 'Você quer mesmo remover o servidor <b>{$a}</b> da lista?';
$string['connectionerror'] = 'Conexão de rede perdida. (Salvamento automático falhou). Anote quaisquer respostas registradas nesta página nos últimos minutos e tente conectar-se novamente. Quando a conexão for restabelecida, suas respostas devem ser salvas e esta mensagem irá desaparecer.';
$string['connectionok'] = 'Conexão de rede restaurada. Você pode continuar com segurança.';
$string['containercategorycreated'] = 'Esta categoria foi criada para arquivar todas as categorias que foram movidas para o nível do site principal pelas seguintes razões:';
$string['continueattemptquiz'] = 'Continuar sua tentativa';
$string['continuepreview'] = 'Continuar a última prévia';
$string['copyingfrom'] = 'Criando uma cópia da questão \'{$a}\'';
$string['copyingquestion'] = 'Copiando uma questão';
$string['correct'] = 'Correto';
$string['correctanswer'] = 'Resposta correta';
$string['correctanswerformula'] = 'Fórmula de resposta correta';
$string['correctansweris'] = 'Resposta correta: {$a}';
$string['correctanswerlength'] = 'Algarismos significantes';
$string['correctanswers'] = 'Respostas corretas';
$string['correctanswershows'] = 'Exibições de respostas corretas';
$string['corrresp'] = 'Resposta correta';
$string['countdown'] = 'Contagem regressiva';
$string['countdownfinished'] = 'O prazo para o envio dos resultados do questionário terminou, envie as suas respostas agora.';
$string['countdowntenminutes'] = 'O prazo para o envio dos resultados do questionário vai acabar daqui a 10 minutos.';
$string['coursetestmanager'] = 'Formato Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Criar categoria e adicionar questão aleatória';
$string['createfirst'] = 'Você deve criar primeiro algumas questões de resposta curta.';
$string['createmultiple'] = 'Adicionar várias questões aleatórias ao questionário';
$string['createnewquestion'] = 'Criar nova questão';
$string['createquestionandadd'] = 'Criar uma nova questão e adicioná-la ao quiz.';
$string['custom'] = 'Formato personalizado';
$string['dataitemneed'] = 'Você tem que acrescentar pelo menos una série de dados para obter uma questão válida';
$string['datasetdefinitions'] = 'Definições de conjunto de dados reutilizáveis em categoria {$a}';
$string['datasetnumber'] = 'Número';
$string['daysavailable'] = 'Dias disponíveis';
$string['decimaldigits'] = 'Números decimais nas notas';
$string['decimalplaces'] = 'Casas decimais nas notas';
$string['decimalplaces_help'] = 'Essa configuração define o número de dígitos mostrados após o ponto decimal ao exibir as  notas. Isso afeta apenas a exibição das notas, não as notas armazenadas no banco de dados, nem os cálculos internos, que são realizados com precisão total.';
$string['decimalplacesquestion'] = 'Casas decimais nas notas da questão';
$string['decimalplacesquestion_help'] = 'Esta configuração especifica a quantidade de dígitos mostrados após o ponto decimal ao mostrar as notas para as questões individuais.';
$string['decimalpoints'] = 'Casas decimais';
$string['default'] = 'Predefinido';
$string['defaultgrade'] = 'Avaliação predefinida';
$string['defaultinfo'] = 'Categoria predefinida para questões';
$string['delay1'] = 'Intervalo entre a primeira e a segunda tentativa';
$string['delay1st2nd'] = 'Força demora entre a primeira e a segunda tentativas.';
$string['delay1st2nd_help'] = 'Se ativado, o estudante deve aguardar o tempo definido, para realizar uma segunda tentativa.';
$string['delay2'] = 'Intervalo entre a segunda e outras tentativas';
$string['delaylater'] = 'Força demora entre tentativas posteriores.';
$string['delaylater_help'] = 'Se ativado, o estudante deve aguardar o tempo definido, para realizar a terceira  e qualquer tentativa subsequente.';
$string['deleteattemptcheck'] = 'Você tem certeza que quer excluir estas tentativas completamente?';
$string['deleteselected'] = 'Excluir selecionadas';
$string['deletingquestionattempts'] = 'Excluir tentativas';
$string['description'] = 'Descrição';
$string['disabled'] = 'Desativado';
$string['displayoptions'] = 'Opções de Visualização';
$string['donotuseautosave'] = 'Não use auto-save';
$string['download'] = 'Clique para baixar o arquivo de categoria exportado';
$string['downloadextra'] = '(o arquivo pode ser encontrado também na pasta /quiz da seção arquivos do curso)';
$string['dragtoafter'] = 'Após {$a}';
$string['dragtostart'] = 'Para o início';
$string['duplicateresponse'] = 'Esta tentativa foi ignorada porque você já deu uma resposta idêntica em data anterior.';
$string['eachattemptbuildsonthelast'] = 'Cada tentativa se baseia na última';
$string['eachattemptbuildsonthelast_help'] = 'Se o questionário permitir múltiplas tentativas e esta configuração estiver habilitada, cada nova tentativa do questionário conterá os resultados da tentativa anterior. Isso permite que um questionário seja finalizado em várias tentativas.';
$string['editcategories'] = 'Editar categorias';
$string['editcategory'] = 'Editar categoria';
$string['editcatquestions'] = 'Editar questões da categoria';
$string['editingquestion'] = 'Editando uma questão';
$string['editingquiz'] = 'Editando questionário';
$string['editingquiz_help'] = 'Ao se criar um questionário, os conceitos principais são:

* O questionário contém questões que estejam em uma ou mais páginas
* O banco de questões, que armazena cópias de todas as questões organizadas em categorias
* Questões aleatórias - Um estudante recebe questões diferentes a cada tentativa de resposta ao questionário e estudantes diferentes podem obter diferentes questões.';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Editando questionário: {$a}';
$string['editmaxmark'] = 'Editar nota máxima';
$string['editoverride'] = 'Editar sobreposição';
$string['editqcats'] = 'Editar categorias de questões';
$string['editquestion'] = 'Editar questão';
$string['editquestions'] = 'Editar questões';
$string['editquiz'] = 'Editar questionário';
$string['editquizquestions'] = 'Editar questões do questionário';
$string['emailconfirmautosubmitsmall'] = 'Obrigado por enviar suas respostas para \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Prezado(a) {$a->username},

Obrigado pelo envio das suas respostas ao questionário \'{$a->quizname}\' no curso \'{$a->coursename}\' em {$a->submissiontime}.

Esta mensagem confirma que suas respostas foram salvas.

Você pode acessar o questionário em {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Olá {$a->username},

O tempo para o questionário \'{$a->quizname}\' no curso \'{$a->coursename}\' expirou. Suas respostas foram enviadas automaticamente em {$a->submittime}.

Esta mensagem confirma que suas respostas foram salvas.

Você pode acessar este questionário em {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Obrigado por submeter as respostas para \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Confirmação de envio: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Oi {$a->studentname},

Suas respostas para \'{$a->quizname}\' no curso \'{$a->coursename}\' em {$a->trytimefinish} foram avaliadas agora.

Você poderá ver sua pontuação e feedback visitando \'{$a->quizurl}\' e revisando sua tentativa.';
$string['emailmanualgradedsubject'] = 'Sua tentativa em {$a->quizname} foi avaliada';
$string['emailnotifybody'] = 'Prezado(a) {$a->username},

{$a->studentname} completou o questionário \'{$a->quizname}\' ({$a->quizurl}) do curso \'{$a->coursename}\'.

Para rever a tentativa acesse {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} completou {$a->quizname}. Veja {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} concluiu o questionário {$a->quizname}';
$string['emailoverduebody'] = 'Prezado {$a->studentname},

Você iniciou uma tentativa no questiontário \'{$a->quizname}\'  do curso \'{$a->coursename}\' mas não finalizou a tentativa. Ela deveria ter sido enviada até {$a->attemptduedate}.

Se você pretende ainda finalizar essa tentativa, por favor retorne para {$a->attemptsummaryurl} e clique no botão de envio. Você precisa fazer isso antes de {$a->attemptgraceend}, caso contrário sua tentativa não será levada em conta.';
$string['emailoverduesmall'] = 'Você não finalizou sua tentativa em {$a->quizname}. Por favor vá para {$a->attemptsummaryurl} antes de {$a->attemptgraceend} se você pretende finalizá-la.';
$string['emailoverduesubject'] = 'Tentativa agora vencida: {$a->quizname}';
$string['empty'] = 'Vazio';
$string['enabled'] = 'Ativado';
$string['endtest'] = 'Finalizar tentativa ...';
$string['erroraccessingreport'] = 'Você não pode acessar este relatório';
$string['errorinquestion'] = 'Erro na questão';
$string['errormissingquestion'] = 'Erro: o sistema não encontra a questão com ID {$a}';
$string['errornotnumbers'] = 'Erro - as respostas devem ser numéricas';
$string['errorunexpectedevent'] = 'Um código de evento inesperado {$a->event} foi encontado para a questão {$a->questionid} na tentativa {$a->attemptid}.';
$string['essay'] = 'Dissertação';
$string['essayquestions'] = 'Questões';
$string['eventattemptautosaved'] = 'Tentativa de questionário salva automaticamente';
$string['eventattemptdeleted'] = 'Tentativa do questionário excluída';
$string['eventattemptmanualgradingcomplete'] = 'Avaliação manual da tentativa do questionário concluída';
$string['eventattemptpreviewstarted'] = 'Pré-visualização do questionário iniciada';
$string['eventattemptquestionrestarted'] = 'Tentativa do questionário reiniciada';
$string['eventattemptreviewed'] = 'Tentativa do questionário revisada';
$string['eventattemptsummaryviewed'] = 'Resumo da tentativa do questionário visualizada';
$string['eventattemptupdated'] = 'Tentativa do questionário atualizada';
$string['eventattemptviewed'] = 'Tentativa do questionário visualizada';
$string['eventeditpageviewed'] = 'Edição da página do Quiz visualizada';
$string['eventoverridecreated'] = 'Sobreposição de questionário criada';
$string['eventoverridedeleted'] = 'Sobreposição de questionário apagada';
$string['eventoverrideupdated'] = 'Sobreposição de questionário atualizada';
$string['eventpagebreakcreated'] = 'Quebra de página criada';
$string['eventpagebreakdeleted'] = 'Quebra de página excluída';
$string['eventquestionmanuallygraded'] = 'Questões avaliadas manualmente';
$string['eventquizattemptabandoned'] = 'Tentativa do questionário abandonada';
$string['eventquizattemptregraded'] = 'Tentativa do questionário reavaliada';
$string['eventquizattemptstarted'] = 'Tentativa do questionário iniciada';
$string['eventquizattemptsubmitted'] = 'Tentativa do questionário entregue';
$string['eventquizattempttimelimitexceeded'] = 'Limite de tempo do questionário excedido';
$string['eventquizgradeupdated'] = 'Nota do questionário atualizada';
$string['eventquizrepaginated'] = 'Questionário repaginado';
$string['eventreportviewed'] = 'Relatório do questionário visualizado';
$string['eventsectionbreakcreated'] = 'Quebra de seção criada';
$string['eventsectionbreakdeleted'] = 'Quebra de seção excluída';
$string['eventsectionshuffleupdated'] = 'Embaralhamento de seção atualizado';
$string['eventsectiontitleupdated'] = 'Título da seção atualizado';
$string['eventslotcreated'] = 'Intervalo criado';
$string['eventslotdeleted'] = 'Intervalo excluído';
$string['eventslotmoved'] = 'Intervalo movido';
$string['everynquestions'] = 'Cada {$a} questões.';
$string['everyquestion'] = 'Cada questão';
$string['everythingon'] = 'Tudo sobre';
$string['existingcategory'] = 'Categoria existente';
$string['exportcategory'] = 'exportar categoria';
$string['exporterror'] = 'Erro durante a exportação';
$string['exportingquestions'] = 'As questões estão sendo exportadas em um arquivo';
$string['exportname'] = 'nome do arquivo';
$string['exportquestions'] = 'Exportar questões em um arquivo';
$string['extraattemptrestrictions'] = 'Restrições extras nas tentativas';
$string['false'] = 'Falso';
$string['feedback'] = 'Comentários';
$string['feedbackerrorboundaryformat'] = 'Os limites de nota do retorno devem ser em porcentagem ou um número. O valor digitado no limite {$a} não foi reconhecido.';
$string['feedbackerrorboundaryoutofrange'] = 'Os limites da nota de retorno devem estar entre 0% e 100%. O valor digitado no limite {$a} está fora do intervalo.';
$string['feedbackerrorjunkinboundary'] = 'Você tem que preencher os limites da nota de retorno sem deixar espaços/caracteres desnecessários.';
$string['feedbackerrorjunkinfeedback'] = 'Você precisa preencher as caixas de retorno sem deixar espaços/caracteres desnecessários.';
$string['feedbackerrororder'] = 'Os limites de nota de retorno devem estar em ordem decrescente. O valor digitado no limite {$a} está fora de sequência.';
$string['file'] = 'Arquivo';
$string['fileformat'] = 'Formato do arquivo';
$string['fillcorrect'] = 'Preencher com a opção correta';
$string['filloutnumericalanswer'] = 'Você precisa digitar uma resposta possível e a tolerância. A primeira resposta encontrada será usada para determinar a nota e o feedback. Se você fornecer algum feedback sem resposta no final, isso será mostrado aos estudante cuja resposta não corresponde a nenhuma das outras respostas.';
$string['filloutoneanswer'] = 'Pelo menos uma resposta tem que ser preenchida. Respostas em branco não serão consideradas. \'*\' pode ser usado com curinga para corresponder a qualquer caractere. A primeira resposta encontrada será usad para determinar a nota e feedback.';
$string['filloutthreequestions'] = 'Você deve fornecer pelo menos três questões com respostas correspondentes. Você pode fornecer respostas erradas extras dando uma resposta com uma questão em branco. Os itens em que a questão e a resposta estiverem em branco serão ignorados.';
$string['fillouttwochoices'] = 'Tem que preencher pelo menos duas opções. Respostas em branco não serão consideradas.';
$string['finishattemptdots'] = 'Tentativas encerradas...';
$string['finishreview'] = 'Terminar revisão';
$string['forceregeneration'] = 'forçar regeneração';
$string['formatnotfound'] = 'Formato {$a} não foi encontrado';
$string['formulaerror'] = 'Erros na fórmula!';
$string['fractionsaddwrong'] = 'As notas positivas escolhidas não somam 100%. <br />Elas somam {$a}%. <br />Quer voltar e corrigir esta questão?';
$string['fractionsnomax'] = 'Uma das respostas deve ser 100% para que seja<br />possível obter a nota total nesta questão.<br />Quer voltar e corrigir esta questão?';
$string['fromfile'] = 'do arquivo:';
$string['functiondisabledbysecuremode'] = 'Esta funcionalidade está desativada no momento';
$string['generalfeedback'] = 'Comentários gerais';
$string['generalfeedback_help'] = '<p>Feedback geral da Questão é um texto mostrado para os estudantes depois que eles responderam a questão. Diferente do feedback simples, que depende do tipo de questão e da resposta que o estudante deu, no feedback geral da Questão o mesmo texto é mostrado para todos os estudantes.</p>

<p>Você pode controlar quando o feedback geral é mostrado para os estudantes usando a caixa de maracação de escolha "Estudantes podem rever:" no formulário de edição do questionário.</p>

<p>Você pode usar o feedback geral para dar aos estudantes mais informações sobre qual conhecimento a questão estava testando. Ou dar a eles referências de outras informações para estudo caso eles não tenham entendido as questões.</p>';
$string['gobacktoquiz'] = 'Voltar';
$string['graceperiod'] = 'Período de carência de envio';
$string['graceperiod_desc'] = 'Se a opção "Quando o tempo expirar" for definida como "Existe um período de carência...", então esta será a quantidade padrão de tempo extra permitido.';
$string['graceperiod_help'] = 'Se a opção "Quando o tempo expirar" for definida como "Existe um período de carência...", então esta será a quantidade de tempo extra permitido.';
$string['graceperiodmin'] = 'Período de carência do último envio';
$string['graceperiodmin_desc'] = 'Há um problema potencial bem no final do questionário. Por um lado precisamos garantir que os estudantes continuem sua tentativa até o último segundo - com a ajuda do cronômetro que envia automaticamente a tentativa quando o tempo termina. Por outro lado, o servidor pode ficar sobrecarregado e levar algum tempo para processar todas as respostas. Tendo esse problema em vista, esta configuração cria um período de carência após a expiração do tempo assim os estudantes não são penalizados se o servidor ficar lento. Entretanto, seus estudantes podem \'colar\' e gastar estes segundos respondendo o questionário. Você terá que tomar uma decisão baseada em quanto confia nos seus servidores durante a aplicação de questionários.';
$string['graceperiodtoosmall'] = 'O período de carência deve ser mais do que {$a}.';
$string['grade'] = 'Avaliar';
$string['gradeall'] = 'Avaliar todos';
$string['gradeaverage'] = 'Nota média';
$string['gradeboundary'] = 'Limite das notas';
$string['gradeessays'] = 'Avaliar dissertações';
$string['gradehighest'] = 'Nota mais alta';
$string['grademethod'] = 'Método de avaliação';
$string['grademethod_help'] = '<p>Quando são permitidas diversas tentativas de resposta ao questionário, podem ser configurados 4 modos diversos de cálculo da nota final.

<h2>Nota mais alta</h2>
<ul>
<li>A nota final é a nota mais alta obtida nas diversas tentativas.</li>
</ul>

<h2>M&eacute;dia dos resultados</h2>
<ul>
<li>A nota final é a média entre as notas de todas as tentativas.</li>
</ul>

<h2>Primeira nota</h2>
<ul>
<li>Apenas os resultados da primeira tentativa são considerados.</li>
</ul>

<h2>Última nota</h2>
<ul>
<li>Apenas o resultado da última tentativa é considerado..</li>
</ul>';
$string['gradesdeleted'] = 'Excluir notas de questionário';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'A nota de aprovação não pode ser zero, pois o critério de conclusão para este questionário exige nota de aprovação. Defina um valor diferente de zero.';
$string['gradetopassnotset'] = 'Este questionário ainda não possui uma nota para aprovação. Isso pode ser definido na seção Nota nas configurações do questionário.';
$string['gradetopassoutof'] = 'Nota para aprovação: {$a->grade} de {$a->maxgrade}';
$string['gradingdetails'] = 'Notas relativas a este envio: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Considerando as penalidades: <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Penalidade de {$a} neste envio.';
$string['gradingdetailszeropenalty'] = 'Você não foi penalizado em relação a este envio.';
$string['gradingmethod'] = 'Método de avaliação: {$a}';
$string['groupoverrides'] = 'Sobreposições de grupo';
$string['groupoverridesdeleted'] = 'Sobreposições de grupo excluída';
$string['groupsnone'] = 'Não há grupos que você possa acessar.';
$string['guestsno'] = 'Sinto muito, os visitantes não podem ver ou responder questionários';
$string['hidebreaks'] = 'Ocultar quebras de página';
$string['hidereordertool'] = 'Ocultar ferramenta de reordenação';
$string['history'] = 'Histórico das respostas:';
$string['howquestionsbehave_desc'] = 'Configuração padrão para comportamento das questões no questionário.';
$string['imagedisplay'] = 'Imagem a ser mostrada';
$string['import_help'] = 'Esta função permite que você importe questões de arquivos externos de texto.

Se o arquivo contém caracteres em formato não-ASCII, você deverá usar a codificação UTF-8. Tenha especial cautela ao tratar com arquivos gerados por aplicativos do Microsoft Office, uma vez que estes geralmente usam codificação especial que não serão tratados adequadamente.

Formatos de importação e exportação são um recurso conectável. Outros formatos opcionais podem estar disponíveis na Modules and Plugins database.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importar categoria';
$string['importerror'] = 'Erro durante a importação';
$string['importfilearea'] = 'Importação do arquivo já presente no curso...';
$string['importfileupload'] = 'Importação de arquivo carregado...';
$string['importfromthisfile'] = 'Importar deste arquivo';
$string['importingquestions'] = 'Importando {$a} questões de arquivo';
$string['importmax10error'] = 'Erro nesta questão: você não pode incluir mais de dez respostas.';
$string['importmaxerror'] = 'Erro na questão: número de respostas superior ao limite máximo.';
$string['importquestions'] = 'Importar questões de arquivos externos';
$string['inactiveoverridehelp'] = '* Esta substituição está inativa porque o acesso do usuário à atividade está restrito. Isso pode ocorrer devido às atribuições de grupo ou função, outras restrições de acesso ou atividade oculta.';
$string['incorrect'] = 'Errado';
$string['indicator:cognitivedepth'] = 'Indicador cognitivo do questionário';
$string['indicator:cognitivedepth_help'] = 'Este indicador é baseado na profundidade cognitiva alcançada pelo estudante em uma atividade Questionário.';
$string['indicator:cognitivedepthdef'] = 'Questionário cognitivo';
$string['indicator:cognitivedepthdef_help'] = 'O participante atingiu esta porcentagem do envolvimento cognitivo oferecido pelas atividades do questionário durante este intervalo de análise (Níveis = Sem visualização, Visualizar, Enviar, Visualizar feedback, Comentar sobre o feedback, Reenviar após visualizar o feedback)';
$string['indicator:socialbreadth'] = 'Indicador social do Questionário';
$string['indicator:socialbreadth_help'] = 'Este indicador baseia-se na amplitude social alcançada pelo estudante em uma atividade Questionário.';
$string['indicator:socialbreadthdef'] = 'Questionário social';
$string['indicator:socialbreadthdef_help'] = 'O participante alcançou este percentual de engajamento social oferecido pelas atividades Questionário durante este intervalo de análise (Níveis = Sem participação, Participante único, Participante com outros)';
$string['indivresp'] = 'Respostas de indivíduos para cada item';
$string['info'] = 'Informações';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Número inicial de campos de feedbacks globais';
$string['initialnumfeedbacks_desc'] = 'Ao criar um novo questionário, são fornecidas muitas caixas de feedback global em branco. Uma vez que o questionário foi criado, o formulário mostra o número de campos obrigatórios para o número de feedbacks do questionário. O ajuste deve ser de pelo menos 1';
$string['inprogress'] = 'Em andamento';
$string['introduction'] = 'Descrição';
$string['invalidattemptid'] = 'Não existe ID dessa tentativa.';
$string['invalidcategory'] = 'O ID da categoria é inválido';
$string['invalidoverrideid'] = 'Identificador de sobreposição inválido';
$string['invalidquestionid'] = 'ID da questão inválido';
$string['invalidquizid'] = 'Identificador de questionário inválido';
$string['invalidrandomslot'] = 'Id inválido do intervalo da questão aleatória';
$string['invalidsource'] = 'O recurso não foi reconhecido como válido.';
$string['invalidsourcetype'] = 'Tipo de recurso inválido.';
$string['invalidstateid'] = 'Identificador de estado inválido';
$string['lastanswer'] = 'A sua última resposta foi';
$string['layout'] = 'Layout';
$string['layoutasshown'] = 'Layout da página como mostrado.';
$string['layoutasshownwithpages'] = 'Layout da página como mostrado. <small>(Nova página automaticamente a cada {$a} questões.)</small>';
$string['layoutshuffledandpaged'] = 'Questões embaralhadas aleatoriamente com {$a} questões por página.';
$string['layoutshuffledsinglepage'] = 'Questões aleatoriamente ordenadas, todas na mesma página.';
$string['link'] = 'Link';
$string['listitems'] = 'Lista de itens do questionário';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Falha no carregamento da questão: {$a}';
$string['makecopy'] = 'Salvar nova questão';
$string['managetypes'] = 'Gerenciar tipos de questão e servidores';
$string['manualgradequestion'] = 'Avaliação manual da questão {$a->question} em {$a->quiz} por {$a->user}';
$string['manualgrading'] = 'Avaliação';
$string['mark'] = 'Enviar';
$string['markall'] = 'Enviar página';
$string['marks'] = 'Notas';
$string['marks_help'] = 'A nota atribuída para cada questão e a nota total da tentativa.';
$string['match'] = 'Associação';
$string['matchanswer'] = 'Resposta associada';
$string['matchanswerno'] = 'Resposta associada {$a}';
$string['max'] = 'Max';
$string['maxmark'] = 'Nota máxima';
$string['messageprovider:attempt_overdue'] = 'Avisar quando suas tentativas se tornarem vencidas';
$string['messageprovider:confirmation'] = 'Confirmação de suas próprias submissões de questionário';
$string['messageprovider:submission'] = 'Notificação de questionários respondidos';
$string['min'] = 'Min';
$string['minutes'] = 'Minutos';
$string['missingcorrectanswer'] = 'A resposta correta deve ser especificada';
$string['missingitemtypename'] = 'Falta o nome';
$string['missingquestion'] = 'Esta questão parece não existir mais';
$string['modulename'] = 'Questionário';
$string['modulename_help'] = 'A atividade Questionário permite criar e configurar questionários com questões de vários tipos, incluindo múltipla escolha, verdadeiro ou falso, correspondência, resposta curta entre outras).

O professor pode permitir que o questionário tenha múltiplas tentativas, com questões embaralhadas ou selecionadas aleatoriamente de uma categoria do banco de questões.

Cada tentativa é corrigida automaticamente, com exceção das questões dissertativas, e a nota é registrada no livro de notas do curso.

O professor pode escolher quando e se sugestões, comentários e respostas corretas são mostradas aos estudantes.

Os questionários podem ser utilizados:

* Como provas de um curso
* Como pequenos testes para tarefas de leitura ou no final de um tópico
* Como prova de revisão usando questões de provas anteriores
* Enviar comentários imediatos sobre o desempenho
* Para auto-avaliação';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Questionários';
$string['moveselectedonpage'] = 'Move as questões selecionadas para página: {$a}';
$string['multichoice'] = 'Múltipla escolha';
$string['multipleanswers'] = 'Escolha pelo menos uma resposta.';
$string['mustbesubmittedby'] = 'Esta tentativa precisa ser enviada até {$a}.';
$string['name'] = 'Nome';
$string['navigatenext'] = 'Próxima página';
$string['navigateprevious'] = 'Página anterior';
$string['navmethod'] = 'Método de navegação';
$string['navmethod_free'] = 'Livre';
$string['navmethod_help'] = 'Quando a navegação sequencial está habilitada, os estudantes são obrigados a responder o questionário na ordem e não podem retornar às páginas anteriores, nem passar adiante.';
$string['navmethod_seq'] = 'Sequencial';
$string['navnojswarning'] = 'Atenção: esses links não vão salvar as suas respostas. Use o botão \'Próximo\' na parte inferior da página.';
$string['neverallononepage'] = 'Nunca, todas as questões em uma página';
$string['newattemptfail'] = 'Erro: Não foi possível iniciar uma tentativa deste questionário';
$string['newcategory'] = 'Nova categoria';
$string['newpage'] = 'Nova página';
$string['newpage_help'] = 'Em questionários longos, é recomendado dividi-los em páginas limitando o números de questões por página. As quebras de página serão inseridas automaticamente após o número de questões definidos por página ser atingido. Caso a divisão de páginas não seja satisfatória, é possível ajustar manualmente.';
$string['newpageevery'] = 'Começar nova página automaticamente';
$string['newsectionheading'] = 'Novo título';
$string['noanswers'] = 'Nenhuma resposta foi selecionada!';
$string['noattempts'] = 'Nenhuma tentativa foi feita neste questionário';
$string['noattemptsfound'] = 'Nenhuma tentativa encontrada.';
$string['noattemptstoshow'] = 'Nenhuma tentativa a ser mostrada';
$string['nocategory'] = 'Categoria incorreta ou não especificada';
$string['noclose'] = 'Sem data de fechamento';
$string['nocommentsyet'] = 'Nenhum comentário por enquanto.';
$string['noconnection'] = 'Atualmente não há nenhuma conexão com um serviço web que possa processar esta questão. Por favor contate o administrador';
$string['nodataset'] = 'Nada - isto não é um caractere genérico';
$string['nodatasubmitted'] = 'Senhum dado foi submetido.';
$string['noessayquestionsfound'] = 'Nenhuma questão avaliada manualmente encontrada';
$string['nogradewarning'] = 'Este quiz não foi avaliado e assim não é possível criar feedbacks gerais diferentes para cada nota.';
$string['nomoreattempts'] = 'Não são permitidas outras tentativas';
$string['none'] = 'Nenhum';
$string['noopen'] = 'Sem data de abertura';
$string['nooverridedata'] = 'Você precisa sobrepor pelo menos uma das configurações do questionário.';
$string['nopossibledatasets'] = 'Nenhum conjunto de dados possível';
$string['noquestionintext'] = 'O texto da questão não contém questões embutidas';
$string['noquestions'] = 'Ainda não foi inserida nenhuma questão';
$string['noquestionsfound'] = 'Nenhuma questão encontrada';
$string['noquestionsinquiz'] = 'Não há questões neste questionário.';
$string['noquestionsnotinuse'] = 'Esta questão aleatória não está em uso, uma vez que a sua categoria está vazia.';
$string['noquestionsonpage'] = 'Página vazia';
$string['noresponse'] = 'Nenhuma resposta';
$string['noreview'] = 'Não é permitido revisar este questionário';
$string['noreviewattempt'] = 'Você não tem permissão para revisar esta tentativa.';
$string['noreviewshort'] = 'Não permitido';
$string['noreviewuntil'] = 'Não é permitido revisar este questionário até {$a}';
$string['noreviewuntilshort'] = 'Disponível {$a}';
$string['noscript'] = 'Para continuar é necessário que o uso de javascript seja permitido no seu navegador!';
$string['notavailabletostudents'] = 'Nota: Este questionário não está disponível para os estudantes neste momento';
$string['notenoughrandomquestions'] = 'Não há questões suficientes na categoria {$a->category} para criar a questão {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Não foi definido um número suficiente de questões subordinadas!<br /> Deseja voltar e corrigir esta questão?';
$string['notimedependentitems'] = 'Os itens que dependem de tempo não são suportados pelo módulo questionário. Você pode estabelecer um tempo de execução para o questionário inteiro, se quiser. Você quer escolher um outro item ou usar este mesmo?';
$string['notyetgraded'] = 'Ainda não avaliado';
$string['notyetviewed'] = 'Ainda não visualizado';
$string['notyourattempt'] = 'Esta não é a sua tentativa!';
$string['noview'] = 'O usuário que está acessando não tem permissão para ver este questionário';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} fizeram {$a->attemptnum} tentativas';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numérica';
$string['numquestionsx'] = 'Questões: {$a}';
$string['oneminute'] = '1 minuto';
$string['onlyteachersexport'] = 'Apenas os professores podem exportar questões';
$string['onlyteachersimport'] = 'Apenas os professores com direitos de edição podem importar questões';
$string['onthispage'] = 'Esta página';
$string['open'] = 'Não respondido';
$string['openafterclose'] = 'Não foi possível atualizar o questionário. Você definiu uma data inicial posterior a data final';
$string['openclosedatesupdated'] = 'Datas de abertura e encerramento do questionário atualizadas';
$string['optional'] = 'opcional';
$string['orderandpaging'] = 'Ordem e paginação';
$string['orderandpaging_help'] = 'Os números 10, 20, 30, ... em frente de cada questão indicam a sua ordem. Os números aumentam em intervalos de 10 para possibilitar espaço para novas questões serem inseridas. Para reordená-las, modifique os números e clicque no botão "Reordenar questões".

Para adicionar quebras de página após uma questão, selecione as questões e clique em "Adicionar nova página, após as questões selecionadas".

Para definir um certo número questões por página, clique no botão "Repaginar" e selecione o número desejado de questões por página.';
$string['orderingquiz'] = 'Ordenar e paginar';
$string['orderingquizx'] = 'Ordem e paginação: {$a}';
$string['outcomesadvanced'] = 'Resultados são as configurações avançadas';
$string['outof'] = '{$a->grade} de um máximo de {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} de um máximo de {$a->maxgrade}({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback final';
$string['overallfeedback_help'] = '<p>Feedback final é um texto mostrado para o estudante depois que ele terminou, uma tentativa, de responder o questionário. O texto que é mostrado pode depender da nota que o estudante obteve.</p>

<p>Por exemplo, se voce entrou com:</p>

<p>Limite de notas: 100%<br />
Feedback: Muito Bom<br />
Limite de notas: 40%<br />
Feedback: Por favor estude outra vez o trabalho desta semana<br />
...<br />
Limite de notas: 0%</p>

<p>Assim, estudantes com avaliação entre 100% e 40% irão ver a mensagem "Muito Bom", e estudantes com avaliação entre 39.99% e 0% irão ver a outra mensagem. Isto é, os limites de notas definem intervalos de notas, e cada mensagem de feedback global é mostrada de acordo com o intervalo.</p>

<p>Os intervalos de notas podem ser especificados tanto em percentagem, por exemplo "31.41%", ou em um número, por exemplo "7". Se o seu questionário vale 10, um limite de notas de 7 significa 7 em 10 ou melhor.</p>';
$string['overdue'] = 'Expirado';
$string['overduehandling'] = 'Quando o tempo expirar';
$string['overduehandling_desc'] = 'O que deveria acontecer por padrão se um estudante não enviar o questionário antes de o tempo expirar.';
$string['overduehandling_help'] = 'Esta configuração controla o que acontece se um estudante não enviar sua tentativa de questionário antes do tempo expirar. Se neste momento o estudante estiver trabalhando no questionário, então o cronômetro de contagem regressiva sempre enviará automaticamente essa tentativa, mas se ele estiver desconectado, esta configuração controla o que acontece.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Tentativas devem ser submetidas antes que o tempo expire ou elas não serão contabilizadas';
$string['overduehandlingautosubmit'] = 'As tentativas abertas são enviadas automaticamente';
$string['overduehandlinggraceperiod'] = 'Existe um período de carência quando as tentativas abertas podem ser enviadas, mas não é possível modificar as questões respondidas';
$string['overduemustbesubmittedby'] = 'Esta tentativa está vencida. Ela já deveria ter sido enviada. Se você quiser que este questionário seja avaliado, você deve enviá-lo até {$a}. Se você não enviar até até lá, nenhuma nota dessa tentativa será levada em conta.';
$string['override'] = 'Sobreposição';
$string['overridedeletegroupsure'] = 'Você tem certeza que deseja apagar a sobreposição do grupo {$a}?';
$string['overridedeleteusersure'] = 'Você tem certeza que deseja apagar a sobreposição do usuário {$a}?';
$string['overridegroup'] = 'Sobreposições de grupo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Sobreposições';
$string['overridesforquiz'] = 'Substituições de configurações: {$a}';
$string['overridesnoneforgroups'] = 'Nenhuma substituição de configurações de grupo foi criada para este questionário.';
$string['overridesnoneforusers'] = 'Nenhuma substituição de configuração do usuário foi criada para este questionário.';
$string['overridessummary'] = 'Existem substituições de configurações ({$a})';
$string['overridessummarygroup'] = 'Grupos: {$a}';
$string['overridessummarythisgroup'] = 'Existem substituições de configurações ({$a}) para este grupo';
$string['overridessummaryuser'] = 'Usuários: {$a}';
$string['overridessummaryyourgroups'] = 'Existem substituições de configurações ({$a}) para seus grupos';
$string['overrideuser'] = 'Sobreposição de usuário';
$string['overrideusereventname'] = '{$a->quiz} - Sobreposição';
$string['page-mod-quiz-attempt'] = 'Página da tentativa do questionário';
$string['page-mod-quiz-edit'] = 'Editar página do questionário';
$string['page-mod-quiz-report'] = 'Qualquer página de relatório do questionário';
$string['page-mod-quiz-review'] = 'Revisão da página da tentativa do questionário';
$string['page-mod-quiz-summary'] = 'Página de resumo da tentativa do questionário';
$string['page-mod-quiz-view'] = 'Página de informações do questionário';
$string['page-mod-quiz-x'] = 'Qualquer página do módulo questionário';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Tamanho da página';
$string['parent'] = 'Pai';
$string['parentcategory'] = 'Categoria principal';
$string['parsingquestions'] = 'Analisando questões do arquivo importado.';
$string['partiallycorrect'] = 'Parcialmente correta';
$string['penalty'] = 'Penalidade';
$string['penaltyscheme'] = 'Aplicar penalidades';
$string['penaltyscheme_help'] = 'Se habilitado, a nota final da questão é subtraída pelo valor da penalidade a cada resposta errada. O valor da penalidade é definido individualmente para cada questão. Esta configuração não tem efeito a menos que o modo adaptativo esteja habilitado.';
$string['percentcorrect'] = 'Percentual correto';
$string['pleaseclose'] = 'O seu pedido foi processado. Você já pode fechar esta janela';
$string['pluginadministration'] = 'Administração do questionário';
$string['pluginname'] = 'Questionário';
$string['popup'] = 'Mostrar o questionário em uma janela "segura"';
$string['popupblockerwarning'] = 'A seção desse teste está em modo de segurança, o que significa que você precisa fazer o questionário numa janela segura. Por favor desligue o bloqueador de popups. Obrigado.';
$string['popupnotice'] = 'Os estudantes vão ver este questionário em uma janela segura';
$string['preprocesserror'] = 'Ocorreu um erro durante o pré-processamento!';
$string['preview'] = 'Visualização prévia';
$string['previewquestion'] = 'Visualização prévia da questão';
$string['previewquiz'] = 'Visualizar {$a}';
$string['previewquiznow'] = 'Pré-visualizar questionário agora';
$string['previewquizstart'] = 'Visualizar questionário';
$string['previous'] = 'Estado anterior';
$string['privacy:metadata:core_question'] = 'A atividade questionário armazena informações sobre o uso da questão no subsistema core_question.';
$string['privacy:metadata:quiz'] = 'A atividade questionário utiliza os relatórios de questionário';
$string['privacy:metadata:quiz_attempts'] = 'Detalhes sobre cada tentativa de um questionário.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'O número da tentativa';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'A página atual em que o usuário está.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Se esta é uma prévia do questionário.';
$string['privacy:metadata:quiz_attempts:state'] = 'O estado atual da tentativa.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'A soma das notas na tentativa.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'O horário em que a situação foi verificado.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'A horário em que a tentativa foi concluída.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'O horário que a tentativa foi atualizada.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'O horário em que a tentativa foi atualizada por meio de uma atualização offline.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'O horário que a tentativa foi iniciada.';
$string['privacy:metadata:quiz_grades'] = 'Detalhes sobre a nota total deste questionário.';
$string['privacy:metadata:quiz_grades:grade'] = 'A nota total deste questionário.';
$string['privacy:metadata:quiz_grades:quiz'] = 'O questionário que foi avaliado.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'O horário que a nota foi modificada.';
$string['privacy:metadata:quiz_grades:userid'] = 'O usuário que foi avaliado.';
$string['privacy:metadata:quiz_overrides'] = 'Detalhes sobre substituições para este questionário';
$string['privacy:metadata:quiz_overrides:quiz'] = 'O questionário com informações de substituição';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'O novo horário de encerramento do questionário.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'O novo limite de tempo para o questionário.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'O novo horário de abertura do questionário.';
$string['privacy:metadata:quiz_overrides:userid'] = 'O usuário que está sendo substituído(';
$string['privacy:metadata:quizaccess'] = 'A atividade questionário utiliza as regras de acesso de questionário';
$string['publish'] = 'Publicar';
$string['publishedit'] = 'Você deve ter direitos de publicação de cursos para adicionar ou editar questões nesta categoria';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'nome';
$string['qti'] = 'Formato IMS QTI';
$string['qtypename'] = 'tipo, nome';
$string['question'] = 'Questão';
$string['questionbank'] = 'do banco de questões';
$string['questionbankmanagement'] = 'Gerenciamento de banco de questões';
$string['questionbehaviour'] = 'Comportamento da questão';
$string['questioncats'] = 'Categorias de questão';
$string['questiondeleted'] = 'Esta questão foi excluída. Entre em contato com seu professor.';
$string['questiondependencyadd'] = 'Não há restrição de prazo para a tentativa da questão {$a->thisq}• Clique para alterar';
$string['questiondependencyfree'] = 'Não há restrição para esta questão';
$string['questiondependencyremove'] = 'Questão {$a->thisq} não pode ser respondida até que a anterior {$a->previousq} tenha sido concluída • Clique para alterar';
$string['questiondependsonprevious'] = 'Esta questão não pode ser respondida até que a anterior tenha sido concluída.';
$string['questioninuse'] = 'A questão \'{$a->questionname}\' é atualmente usada em:<br />{$a->quiznames}<br />A questão não será excluída destes questionários mas apenas das categorias.';
$string['questionmissing'] = 'Está faltando questão para esta sessão';
$string['questionname'] = 'Nome da questão';
$string['questionnonav'] = '<span class="accesshide">Questão </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informação </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'A questão {$a} não foi carregada da base de dados.';
$string['questionorder'] = 'Ordem da questão';
$string['questionposition'] = 'Nova posição para a questão {$a}';
$string['questions'] = 'Questões';
$string['questionsetpreview'] = 'Visualização do conjunto de questões';
$string['questionsinclhidden'] = 'Questões (inclusive escondidas)';
$string['questionsinthisquiz'] = 'Questões neste questionário';
$string['questionsmatchingfilter'] = 'Questões que correspondem a este filtro: {$a}';
$string['questionsperpage'] = 'Questões por página';
$string['questionsperpageselected'] = 'Questões por página foi estabelecido de modo a paginação está actualmente fixado. Como resultado, os controles de paginação foram desativados. Você pode mudar isso em {$a}.';
$string['questionsperpagex'] = 'Questões por página: {$a}';
$string['questiontext'] = 'Texto da questão';
$string['questiontextisempty'] = '[Texto vazio da questão]';
$string['questiontype'] = 'Tipo de questão {$a}';
$string['questiontypesetupoptions'] = 'Opções de configuração de tipos de questão:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (mais recente)';
$string['quiz:addinstance'] = 'Incluir um novo questionário';
$string['quiz:attempt'] = 'Responder questionários';
$string['quiz:deleteattempts'] = 'Cancelar tentativas';
$string['quiz:emailconfirmsubmission'] = 'Receber mensagem de confirmação de seus envios de questionário';
$string['quiz:emailnotifyattemptgraded'] = 'Receber notificação quando sua tentativa for avaliada';
$string['quiz:emailnotifysubmission'] = 'Receber mensagem de notificação quando uma tentativa é enviada';
$string['quiz:emailwarnoverdue'] = 'Receba um aviso quando sua tentativa de questionário estiver atrasada.';
$string['quiz:grade'] = 'Avaliar manualmente';
$string['quiz:ignoretimelimits'] = 'Ignorar limite de tempo do questionário';
$string['quiz:manage'] = 'Gerenciar questionários';
$string['quiz:manageoverrides'] = 'Administrar sobreposições do questionário';
$string['quiz:preview'] = 'Visualização prévia';
$string['quiz:regrade'] = 'Reclassificar as tentativas do questionário';
$string['quiz:reviewmyattempts'] = 'Rever as suas tentativas';
$string['quiz:view'] = 'Ver informação sobre o questionário';
$string['quiz:viewoverrides'] = 'Ver sobreposições de configurações do questionário';
$string['quiz:viewreports'] = 'Ver relatórios';
$string['quizavailable'] = 'O questionário estará disponível até: {$a}';
$string['quizclose'] = 'Encerrar o questionário';
$string['quizclosed'] = 'Este questionário foi encerrado em {$a}';
$string['quizcloses'] = 'O questionário se encerra';
$string['quizcloseson'] = 'O questionário será fechado em {$a}';
$string['quizeventcloses'] = 'Término de {$a}';
$string['quizeventopens'] = 'Início de {$a}';
$string['quizisclosed'] = 'Este questionário está fechado';
$string['quizisclosedwillopen'] = 'Questionário fechado (abre {$a})';
$string['quizisopen'] = 'Este questionário está aberto';
$string['quizisopenwillclose'] = 'Questionário aberto (fecha {$a})';
$string['quiznavigation'] = 'Navegação do questionário';
$string['quizopen'] = 'Abrir o questionário';
$string['quizopenclose'] = 'Datas de abertura e fechamento';
$string['quizopenclose_help'] = 'Os estudantes podem iniciar tentativas apenas depois do horário de abertura e devem concluir suas tentativas antes do horário de término.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Este questionário está aberto.';
$string['quizopenedon'] = 'Este questionário abriu em {$a}';
$string['quizopens'] = 'O questionário inicia';
$string['quizopenwillclose'] = 'Este questionário está aberto e será fechado em {$a} as';
$string['quizordernotrandom'] = 'Ordem do questionário não embaralhada';
$string['quizorderrandom'] = '* Ordem do questionário está embaralhada';
$string['quizreport'] = 'Relatório do questionário';
$string['quizsettings'] = 'Configurações do questionário';
$string['quiztimer'] = 'Cronômetro do questionário';
$string['quizwillopen'] = 'Este questionário abre em {$a}';
$string['random'] = 'Questão aleatória';
$string['randomcreate'] = 'Criar questões aleatórias';
$string['randomediting'] = 'Editando uma questão aleatória';
$string['randomfromcategory'] = 'Questão aleatória da categoria';
$string['randomfromexistingcategory'] = 'Questão aleatória de uma categoria existente';
$string['randomfromunavailabletag'] = '{$a} (indisponível)';
$string['randomnosubcat'] = 'Questões somente dessa categoria, não de suas subcategorias.';
$string['randomnumber'] = 'Número de questões aleatórias';
$string['randomquestion'] = 'Questão aleatória';
$string['randomquestiontags'] = 'Tags';
$string['randomquestiontags_help'] = 'Você pode restringir ainda mais os critérios de seleção especificando algumas tags de questões aqui.

As questões "aleatórias" serão selecionadas dentre todas as que possuem essas tags.';
$string['randomquestionusinganewcategory'] = 'Questão aleatória utilizando uma nova categoria';
$string['randomwithsubcat'] = 'Questões desta categoria e de suas subcategorias';
$string['readytosend'] = 'Você está enviando o seu questionário para ser avaliado. Tem certeza que quer continuar?';
$string['reattemptquiz'] = 'Fazer uma outra tentativa';
$string['recentlyaddedquestion'] = 'Questão adicionada recentemente!';
$string['recurse'] = 'Incluir também as questões das sub-categorias';
$string['redoesofthisquestion'] = 'Outras questões concluídas aqui: {$a}';
$string['redoquestion'] = 'Tentar outra questão como esta';
$string['regrade'] = 'Avaliar novamente todas as tentativas';
$string['regradecomplete'] = 'Todas as tentativas foram avaliadas novamente';
$string['regradecount'] = '{$a->changed} de {$a->attempt} notas foram modificadas';
$string['regradedisplayexplanation'] = 'Tentativas que são modificadas durante a reavaliação são mostradas como links à página de revisão da questão';
$string['regradenotallowed'] = 'Você não tem permissão para alterar notas neste questionário';
$string['regradingquestion'] = 'Reavaliando "{$a}".';
$string['regradingquiz'] = 'Reavaliando o questionário "{$a}"';
$string['remove'] = 'Remover';
$string['removeallgroupoverrides'] = 'Excluir todas as sobreposições de grupo';
$string['removeallquizattempts'] = 'Excluir todas as tentativas do questionário';
$string['removealluseroverrides'] = 'Excluir todas as sobreposições de usuário';
$string['removeemptypage'] = 'Remover página vazia';
$string['removepagebreak'] = 'Remover quebra de página';
$string['removeselected'] = 'Remover seleção';
$string['rename'] = 'Renomear';
$string['renderingserverconnectfailed'] = 'O servidor {$a} não processou um pedido RQP. Verifique se a URL está certa.';
$string['reorderquestions'] = 'Reordenar questões';
$string['reordertool'] = 'Mostrar o instrumento de ordenação';
$string['repaginate'] = 'Ordenar novamente com {$a} questões por página';
$string['repaginatecommand'] = 'Repaginar';
$string['repaginatenow'] = 'Repaginar agora';
$string['replace'] = 'Substituir';
$string['replacementoptions'] = 'Opções de substituição';
$string['report'] = 'Relatórios';
$string['reportanalysis'] = 'Análise de item';
$string['reportattemptsfrom'] = 'Tentativa de';
$string['reportattemptsthatare'] = 'Tentativas que estão';
$string['reportdisplayoptions'] = 'Opções de visualização';
$string['reportfullstat'] = 'Estatísticas detalhadas';
$string['reportmulti_percent'] = 'Multi-Percentuais';
$string['reportmulti_q_x_student'] = 'Multi-Escolhas de estudantes';
$string['reportmulti_resp'] = 'Respostas individuais';
$string['reportmustselectstate'] = 'Você precisa selecionar pelo menos um estado.';
$string['reportnotfound'] = 'Relatório não conhecido ({$a})';
$string['reportoverview'] = 'Visão Geral';
$string['reportregrade'] = 'Modificar notas';
$string['reportresponses'] = 'Respostas detalhadas';
$string['reports'] = 'Relatórios';
$string['reportshowonly'] = 'Mostrar apenas tentativas';
$string['reportshowonlyfinished'] = 'Mostrar no máximo uma tentativa finalizada por usuário ({$a})';
$string['reportsimplestat'] = 'Estatísticas simples';
$string['reportusersall'] = 'todos os usuário que tem';
$string['reportuserswith'] = 'usuários inscritos haviam tentado o questionário';
$string['reportuserswithorwithout'] = 'usuários inscritos que haviam ou não tentado o questionário';
$string['reportuserswithout'] = 'usuários inscritos que não haviam tentado o questionário';
$string['reportwhattoinclude'] = 'O que incluir no relatório';
$string['requirepassword'] = 'Senha necessária';
$string['requirepassword_help'] = '<P>Este campo é opcional</P>
<P>Caso se especifique uma senha neste campo então os participantes devem digitar a mesma
senha para receberem a permissão para fazer uma tentativa no
questionário.</P>';
$string['requiresubnet'] = 'Requer endereço de rede';
$string['requiresubnet_help'] = '<p>Este campo é opcional.</p>
<p>Pode-se restringir o acesso a um questionário a sub-redes particulares numa LAN ou
Internet especificando-se uma lista separada por vírgulas dos endereços IP completos ou parciais.</p>
<p>Isto é especialmente útil para um questionário pré-determinado ("proctored quiz"), onde se desejar certeza
que somente as pessoas de uma certa sala estiverem aptas a acessar o questionário.</p>
<p>Por exemplo: <strong>192.168. , 231.54.211.0/20, 231.3.56.211</strong></p>
<p>Existem três tipos de números que podem ser usados (não se podem utilizar nomes de domínios em texto como exemplo.com):</p>
<ol>
  <li>Endereços IP completos, tais como <strong>192.168.10.1</strong> designarão um simples
  computador (ou proxy).</li>
  <li>Endereços parciais, tais como <strong>192.168</strong> designarão qualquer um
  iniciando com estes números.</li>
  <li>Notação CIDR, tais como <strong>231.54.211.0/20</strong> permitirá que se especifiquem
  sub-redes mais detalhadas. </li>
</ol>

<p>Os espaços são ignorados.</p>';
$string['response'] = 'Resposta';
$string['responses'] = 'Respostas';
$string['results'] = 'Resultados';
$string['returnattempt'] = 'Retornar à tentativa';
$string['reuseifpossible'] = 'reutilizar removida anteriormente';
$string['reverttodefaults'] = 'Reverter para o questionário padrão';
$string['review'] = 'Revisão';
$string['reviewafter'] = 'Permitir revisão depois da data de fechamento';
$string['reviewalways'] = 'Permitir revisão sempre';
$string['reviewattempt'] = 'Revisão de tentativa';
$string['reviewbefore'] = 'Permitir revisão enquanto estiver aberto';
$string['reviewclosed'] = 'Depois do fechamento do questionário';
$string['reviewduring'] = 'Durante a tentativa';
$string['reviewimmediately'] = 'Após a tentativa';
$string['reviewnever'] = 'Nunca permitir revisões';
$string['reviewofquestion'] = 'Revisão da questão {$a->question} em {$a->quiz} por {$a->user}';
$string['reviewopen'] = 'Mais tarde, enquanto ainda estiver aberto';
$string['reviewoptions'] = 'Estudantes podem fazer revisão';
$string['reviewoptionsheading'] = 'Opções de revisão';
$string['reviewoptionsheading_help'] = '<p>Estas opções controlam quais informações estudantes podem ver quando eles revisam uma tentativa visualizam os relatórios do quiz.</p>

**Durante a tentativa** é relevante para alguns comportamentos como "interativo com múltiplas tentativas" que pode mostrar o feedback durante a tentativa.

**Imediatamente após a tentativa** se aplica aos primeiros dois minutos após clicar em "Enviar tudo e terminar".


**Mais tarde, enquanto o quiz ainda está aberto** se aplica após isto e antes da data de encerramento do quiz.

**Após o quiz estar fechado** se aplica após a data de encerramento. Se o quiz não tem uma data de encerramento, este estado nunca é alcançado.';
$string['reviewoverallfeedback'] = 'Feedback final';
$string['reviewoverallfeedback_help'] = 'Feedback exibido ao final da tentativa, dependendo da nota total do estudante.';
$string['reviewresponse'] = 'Resposta da revisão';
$string['reviewresponsetoq'] = 'Resposta da revisão (question {$a})';
$string['reviewthisattempt'] = 'Analise as suas respostas a esta tentativa';
$string['rqp'] = 'Questão remota';
$string['rqps'] = 'Questões remotas';
$string['sameasoverall'] = 'O mesmo que para as avaliações em geral';
$string['save'] = 'Gravar';
$string['saveandedit'] = 'Salvar mudanças e editar questões';
$string['saveattemptfailed'] = 'Falha ao salvar a tentativa atual do questionário.';
$string['savedfromdeletedcourse'] = 'Salvo do seguinte curso excluído: "{$a}"';
$string['savegrades'] = 'Gravar notas';
$string['savemyanswers'] = 'Gravar as minhas respostas';
$string['savenosubmit'] = 'Salvar sem enviar';
$string['saveoverrideandstay'] = 'Salvar e entrar com outra sobreposição';
$string['savequiz'] = 'Gravar este questionário inteiro';
$string['saving'] = 'Salvando';
$string['savingnewgradeforquestion'] = 'Salvando nova nota para a questão de id {$a}.';
$string['savingnewmaximumgrade'] = 'Salvando nova nota máxima.';
$string['score'] = 'Classificação';
$string['scores'] = 'Notas';
$string['search:activity'] = 'Questionário - informação sobre a atividade';
$string['sectionheadingedit'] = 'Editar título \'{$a}\'';
$string['sectionheadingremove'] = 'Remover título \'{$a}\'';
$string['sectionnoname'] = 'Seção sem título';
$string['seequestions'] = '(ver questões)';
$string['select'] = 'Selecione';
$string['selectall'] = 'Selecionar tudo';
$string['selectattempt'] = 'Selecionar tentativa';
$string['selectcategory'] = 'Selecionar categoria';
$string['selectedattempts'] = 'tentativas selecionadas...';
$string['selectmultipleitems'] = 'Selecione multiplas questões';
$string['selectmultipletoolbar'] = 'Selecione multiplas toolbars';
$string['selectnone'] = 'Deselecionar Tudo';
$string['selectquestiontype'] = '-- Selecionar tipo de questão --';
$string['serveradded'] = 'Servidor acrescentado';
$string['serveridentifier'] = 'Identificador';
$string['serverinfo'] = 'Informação do servidor';
$string['servers'] = 'Servidores';
$string['serverurl'] = 'URL do servidor';
$string['shortanswer'] = 'Resposta curta';
$string['show'] = 'Visualizar';
$string['showall'] = 'Mostrar todas as questões em uma página';
$string['showblocks'] = 'Mostrar blocos durante as tentativas do questionário';
$string['showblocks_help'] = 'Se definido como sim, então os blocos serão exibidos durante tentativas do quiz';
$string['showbreaks'] = 'Mostrar interrupções de página';
$string['showcategorycontents'] = 'Mostra o conteúdo da categoria {$a->arrow}';
$string['showcorrectanswer'] = 'Visualizar respostas corretas no feedback?';
$string['showdetailedmarks'] = 'Mostrar detalhes da nota';
$string['showeachpage'] = 'Mostrar uma página por vez';
$string['showfeedback'] = 'Mostrar feedback depois de responder?';
$string['showinsecurepopup'] = 'Use uma janela <em>pop-up</em> \'segura\' para as tentativas.';
$string['showlargeimage'] = 'Imagem grande';
$string['shownoattempts'] = 'Mostrar estudantes que ainda não responderam';
$string['shownoattemptsonly'] = 'Mostrar apenas estudantes que ainda não responderam';
$string['shownoimage'] = 'Nenhuma imagem';
$string['showreport'] = 'Mostrar relatório';
$string['showsmallimage'] = 'Imagem pequena';
$string['showteacherattempts'] = 'Mostrar tentativas de professores';
$string['showuserpicture'] = 'Mostrar a fotografia do usuário.';
$string['showuserpicture_help'] = 'Se ativado, o nome do estudante e a sua fotografia será mostrada na tela durante a tentativa e na revisão, tornando mais fácil verificar se o estudante está logado como ele mesmo em um exame supervisionado.';
$string['shuffle'] = 'Misturar';
$string['shuffleanswers'] = 'Misturar as respostas';
$string['shuffledrandomly'] = 'Embaralhar aleatoriamente';
$string['shufflequestions'] = 'Misturar as questões';
$string['shufflequestions_help'] = 'Se habilitado, toda vez que o questionário for respondido, a ordem das questões nesta seção será embaralhada em uma ordem aleatória diferente.

Isto pode dificultar aos estudantes compartilharem respostas, mas também dificulta a discussão de uma questão específica com o professor.';
$string['shufflewithin'] = 'Misturar entre as questões';
$string['shufflewithin_help'] = 'Se habilitada, as partes que compõem cada questão serão embaralhadas aleatoriamente toda vez que um estudante realizar uma tentativa, desde que esta opção também esteja ativada nas configurações da questão. Essa configuração se aplica apenas a questões com várias partes, como questões de múltipla escolha ou de associação.';
$string['singleanswer'] = 'Escolha uma resposta.';
$string['sortage'] = 'Ordenar por idade';
$string['sortalpha'] = 'Ordenar alfabeticamente';
$string['sortquestionsbyx'] = 'Ordenar questões por: {$a}';
$string['sortsubmit'] = 'Ordenar questões';
$string['sorttypealpha'] = 'Ordenar por tipo, nome';
$string['specificapathnotonquestion'] = 'O caminho de arquivo especificado não se encontra na questão especificada';
$string['specificquestionnotonquiz'] = 'A questão especificada não se encontra no questionário especificado';
$string['startagain'] = 'Iniciar novamente';
$string['startattempt'] = 'Iniciar tentativa';
$string['startedon'] = 'Iniciado em';
$string['startnewpreview'] = 'Iniciar nova visualização';
$string['stateabandoned'] = 'Nunca enviadas';
$string['statefinished'] = 'Finalizada';
$string['statefinisheddetails'] = 'Enviada(s) {$a}';
$string['stateinprogress'] = 'Em progresso';
$string['statenotloaded'] = 'O estado da questão {$a} não foi carregado do banco de dados';
$string['stateoverdue'] = 'Vencidas';
$string['stateoverduedetails'] = 'Precisam ser enviadas até {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Interromper em caso de erro';
$string['submitallandfinish'] = 'Enviar tudo e terminar';
$string['subneterror'] = 'O acesso a este questionário é limitado aos endereços de rede autorizados. Atualmente o computador que você está utilizando não está autorizado a utilizar este questionário.';
$string['subnetnotice'] = 'Este questionário pode ser acessado apenas em áreas definidas da rede. O seu computador não tem a permissão de acesso. Como professor você pode fazer uma prova de visualização.';
$string['subplugintype_quiz'] = 'Relatório';
$string['subplugintype_quiz_plural'] = 'Relatórios';
$string['subplugintype_quizaccess'] = 'Regra de acesso';
$string['subplugintype_quizaccess_plural'] = 'Regras de acesso';
$string['substitutedby'] = 'será substituído por';
$string['summaryofattempt'] = 'Resumo de tentativas';
$string['summaryofattempts'] = 'Resumo das suas tentativas anteriores';
$string['temporaryblocked'] = 'Você deve refletir um pouco antes de fazer uma nova tentativa.<br /> Você terá permissão para tentar novamente em:';
$string['theattempt'] = 'A tentativa';
$string['theattempt_help'] = 'Se o estudante pode revisar a tentativa.';
$string['time'] = 'Tempo';
$string['timecompleted'] = 'Completo';
$string['timedelay'] = 'Você ainda não pode resolver este questionário porque existe um tempo de espera definido entre a realização de duas tentativas.';
$string['timeleft'] = 'Tempo restante';
$string['timelimit'] = 'Limite de tempo';
$string['timelimit_help'] = '<p align=center><strong>Tempo Limite</strong></p>
<p>Na configuração padrão os questionários não têm tempo limite, permitindo-se aos estudantes o tempo
que for necessário para completar o questionário.</p>
<p>Caso se especifique um tempo limite,  diversas coisas  são feitas para tentar e assegurar
que os questionários sejam concluídos dentro deste tempo:</p>
<ul>
  <li>O suporte  ao Javascript no navegador torna-se prioritário - isto permite que o
  contador do tempo trabalhe corretamente.</li>
  <li>Uma janela com o contador é mostrada com a contagem regressiva</li>
  <li>Quando a contagem terminar, o questionário é submetido automaticamente com
  as respostas que foram preenchidas até então</li>
  <li>Se um estudante tentar enganar o sistema e gastar mais que 60 segundos acima do tempo permitido
  então o questionário é automaticamente avaliado com zero.
</li>
</ul>';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Desculpe! O limite de tempo do questionário foi superado!';
$string['timestr'] = '%H:%M:%S em %d/%m/%y';
$string['timesup'] = 'Acabou o tempo de duração!';
$string['timetaken'] = 'Tempo empregado';
$string['timing'] = 'Duração';
$string['tofile'] = 'para o arquivo';
$string['tolerance'] = 'Tolerância';
$string['toomanyrandom'] = 'O número de questões aleatórias requerido é superior ao conteúdo desta categoria! ({$a})';
$string['top'] = 'Topo';
$string['totalmarksx'] = 'Total de avaliações: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} questões na categoria.';
$string['true'] = 'Verdadeiro';
$string['truefalse'] = 'Verdadeiro/Falso';
$string['type'] = 'Tipo';
$string['unfinished'] = 'aberto';
$string['ungraded'] = 'Não avaliados';
$string['unit'] = 'Unidade';
$string['unknowntype'] = 'Tipo de questão não suportado na linha {$a}. A questão será ignorada';
$string['updateoverdueattemptstask'] = 'Atualizando tentativas de teste atrasadas';
$string['updatesettings'] = 'Atualizar configuração do questionário';
$string['updatingatttemptgrades'] = 'Atualizando notas da tentativa.';
$string['updatingfinalgrades'] = 'Atualizando notas finais.';
$string['updatingthegradebook'] = 'Atualizando livro de notas.';
$string['upgradesure'] = '<div>O módulo questionário provoca uma mudança profunda nas tabelas e esta atualização ainda não foi testada em modo satisfatório. Faça um backup das tabelas da sua base de dados antes de proceder.</div>';
$string['upgradingquizattempts'] = 'Atualizando tentativas do questionário {$a->done}/{$a->outof} (Id do questionário {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Atualizando tentativas muito antigas do questionário {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Esta categoria foi transferida ao nível do site porque é uma categoria compartilhada ainda em uso em outros questionários.';
$string['useroverrides'] = 'Sobreposições de usuário';
$string['useroverridesdeleted'] = 'Sobreposições de usuário excluídas';
$string['usersnone'] = 'Nenhum estudante tem acesso a este questionário';
$string['validate'] = 'Validar';
$string['viewallanswers'] = 'Ver {$a} questionários concluídos';
$string['viewallreports'] = 'Mostrar relatórios de {$a} tentativas';
$string['viewed'] = 'Visualizado';
$string['warningmissingtype'] = '<b>Este tipo de questão ainda não foi instalado em Moodle.<br />Por favor avise o administrador do sistema.</b>';
$string['wheregrade'] = 'Onde está a minha avaliação?';
$string['wildcard'] = 'Caractere genérico (wild card)';
$string['windowclosing'] = 'Esta janela será fechada em breve.';
$string['withsummary'] = 'com resumo de estatísticas';
$string['wronguse'] = 'Você não pode usar esta página assim';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Você deve estar inscrito neste curso para poder responder este questionário';
$string['yourfinalgradeis'] = 'A sua nota final neste questionário é {$a}.';
