<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_messageinbound', language 'no', version '4.0'.
 *
 * @package     tool_messageinbound
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['classname'] = 'Klassenavn';
$string['component'] = 'Komponent';
$string['configmessageinboundhost'] = 'Adressen til serveren som Moodle skal sjekke epost mot. Hvis du vil angi en ikke-standard port, kan du bruke [server]: [port], for eksempel mail.example.com:993 format. Hvis du lar dette feltet stå tomt, vil Moodle bruke standard port for den typen e-postserver du angir.';
$string['defaultexpiration'] = 'Standard utløpsperiode for adressen';
$string['defaultexpiration_help'] = 'Når en e-postadresse er generert av tjenesten, kan den settes til automatisk å utløpe etter en viss tid, slik at den ikke lenger kan brukes. Det anbefales å sette en utløpsperiode.';
$string['description'] = 'Beskrivelse';
$string['domain'] = 'E-postdomene';
$string['edit'] = 'Rediger';
$string['edithandler'] = 'Endre innstillinger for {$a} behandleren';
$string['editinghandler'] = 'Redigerer {$a}';
$string['enabled'] = 'Aktivert';
$string['fixedenabled_help'] = 'Du kan ikke endre status på denne behandleren. Det kan være fordi behandleren er påkrevd av andre behandlere.';
$string['fixedvalidateaddress'] = 'Sjekk avsenderadressen';
$string['fixedvalidateaddress_help'] = 'Du kan ikke endre adressevalidering for denne behandleren. Dette kan være fordi tjenesten krever en bestemt innstilling.';
$string['handlerdisabled'] = 'E-posttjenesten du forsøkte å kontakte har blitt deaktivert. Mislykkes i å behandle meldingen.';
$string['incomingmailconfiguration'] = 'Innstillinger for innkommende epost';
$string['incomingmailserversettings'] = 'Innstillinger for server for innkommende epost';
$string['incomingmailserversettings_desc'] = 'Moodle er i stand til å koble til riktig konfigurert IMAP-servere. Du kan her angi innstillingene som brukes til å koble til IMAP-serveren.';
$string['invalid_recipient_handler'] = 'Dersom en gyldig melding er mottatt, men avsenderen kan ikke godkjennes, lagres meldingen på e-postserveren, og brukeren blir kontaktet ved hjelp av e-postadressen i dennes brukerprofil.  Brukeren får sjansen til å svare for å bekrefte ektheten av den opprinnelige meldingen.

Denne tjenesten behandler disse svarene.

Det er ikke mulig å deaktivere avsenderverifikasjon av denne tjenesten fordi brukeren kan svare fra en feil e-postadresse hvis e-postklientens konfigurasjon er feil.';
$string['invalid_recipient_handler_name'] = 'Ugyldig avsenderbehandler';
$string['invalidrecipientdescription'] = 'Meldingen "{$a->subject}" kunne ikke autentiseres side den ble sent fra en annen epostaddresse enn den i brukerprofilen din. For å autentisere melding, må du svare på denne meldingen.';
$string['invalidrecipientdescriptionhtml'] = 'Meldingen "{$a->subject}" kunne ikke autentiseres side den ble sent fra en annen epostaddresse enn den i brukerprofilen din. For å autentisere melding, må du svare på denne meldingen.';
$string['invalidrecipientfinal'] = 'Meldingen "{$a->subject}" kunne ikke autentiseres. Kontroller at du sender meldingen fra samme e-postadresse som i profilen din.';
$string['mailbox'] = 'Postboksnavn';
$string['mailboxconfiguration'] = 'Postboksinnstillinger';
$string['mailboxdescription'] = '[mailbox]+subaddress@[domain]';
$string['mailsettings'] = 'Epostinnstillinger';
$string['message_handlers'] = 'Meldingsbehandlere';
$string['messageinbound'] = 'Innkommende melding';
$string['messageinboundenabled'] = 'Aktiver håndtering av innkommende epost';
$string['messageinboundenabled_desc'] = 'Innkommende epostbehandling må være aktivert for at meldingene skal sendes med riktig informasjon.';
$string['messageinboundgeneralconfiguration'] = 'Generelle innstillinger';
$string['messageinboundgeneralconfiguration_desc'] = 'Innkommende meldingshåndtering gjør at du kan motta og behandle e-post innenfra Moodle. Denne har applikasjoner som sender e-postsvar til foruminnlegg eller legger til filer i en brukers private filer.';
$string['messageinboundhost'] = 'Server for innkommende epost';
$string['messageinboundhostpass'] = 'Passord';
$string['messageinboundhostpass_desc'] = 'Dette er passordet du logger inn på e-postkontoen din med.';
$string['messageinboundhostssl'] = 'Bruk SSL';
$string['messageinboundhostssl_desc'] = 'Noen mailservere støtter et ekstra sikkerhetsnivå ved å kryptere kommunikasjonen mellom Moodle og serveren din. Vi anbefaler å bruke denne SSL-krypteringen dersom det støttes av serveren din.';
$string['messageinboundhosttype'] = 'SErvertype';
$string['messageinboundhostuser'] = 'Brukernavn';
$string['messageinboundhostuser_desc'] = 'Dette er brukernavnet som tjenestetilbyderen har gitt deg for å logge på e-postkontoen.';
$string['messageinboundmailboxconfiguration_desc'] = 'Når meldinger blir sendt ut, blir de innpasset i formatet address+data@example.com. For å generere pålitelige adresser fra Moodle, vennligst oppgi den adressen som du normalt ville bruke før @ -tegnet, og domenet etter @ -tegnethver for seg. For eksempel vil det Postkassenavn i eksempelet være "adresse", og e-postdomene ville være "example.com". Du bør bruke en dedikert e-postkonto for dette formålet.';
$string['messageprocessingerror'] = 'Du har nylig sendt en e-post "{$a->subject}", men dessverre kunne den ikke behandles.

Detaljer om feilen er vist nedenfor.

{$a->error}';
$string['messageprocessingerrorhtml'] = '<p>Du har nylig sendt en e-post "{$a->subject}", men dessverre kunne den ikke behandles.</p>
<p>Detaljer om feilen vises nedenfor.</p>
<p>{$a->error}</p>';
$string['messageprocessingfailed'] = 'E-postadressen "{$a->subject}" kunne ikke sendes. Feilen er: "{$a->message}".';
$string['messageprocessingfailedunknown'] = 'E-posten med emnet "{$a->subject}" kunne ikke sendes. Kontakt portaladministratoren din for mer informasjon.';
$string['messageprocessingsuccess'] = '{$a->plain}

Hvis du ikke ønsker å motta disse henvendelsene i fremtiden, kan du endre dine personalize meldingsinnstillinger bed å åpne {$a->messagepreferencesurl} in nettleseren din.';
$string['messageprocessingsuccesshtml'] = '{$a->html}
<p>Hvis du ikke ønsker å motta disse henvendelse i fremtiden, kan du <a href="{$a->messagepreferencesurl}">endre dine personlige meldingsinnstilligner</a>.</p>';
$string['messageprovider:invalidrecipienthandler'] = 'Melding for å bekrefte at innkommende meldinge kom fra deg';
$string['messageprovider:messageprocessingerror'] = 'Advarsel når en innkommende melding ikke kunne behandles';
$string['messageprovider:messageprocessingsuccess'] = 'Bekreftelse på at en melding ble behandlet';
$string['name'] = 'Navn';
$string['noencryption'] = 'Av - Ingen kryptering';
$string['noexpiry'] = 'Ingen foreldelse';
$string['oldmessagenotfound'] = 'Du prøvde å godkjenne en melding manuelt, men meldingen ble ikke funnet. Dette kan være fordi det allerede har blitt behandlet, eller fordi meldingen er utløpt.';
$string['oneday'] = 'En dag';
$string['onehour'] = 'En time';
$string['oneweek'] = 'En uke';
$string['oneyear'] = 'Et år';
$string['pluginname'] = 'Innstillinger for innkommende meldinger';
$string['privacy:metadata:coreuserkey'] = 'Brukers nøkkel til å validere den mottatte eposten';
$string['privacy:metadata:messagelist'] = 'En liste med meldingsidentifikatorer som feilet validering og som krever videre autentisering';
$string['privacy:metadata:messagelist:address'] = 'Addressen e-posten ble sendt til';
$string['privacy:metadata:messagelist:messageid'] = 'MeldingsID\'en';
$string['privacy:metadata:messagelist:timecreated'] = 'Tidspunktet oppføringen ble gjort';
$string['privacy:metadata:messagelist:userid'] = 'IDen til brukeren som må godkjenne meldingen';
$string['replysubjectprefix'] = 'Re:';
$string['requirevalidation'] = 'Validere avsenderadresse';
$string['ssl'] = 'SSL (Oppdager automatisk SSL-versjonen)';
$string['sslv2'] = 'SSLv2 (Force SSL Version 2)';
$string['sslv3'] = 'SSLv2 (Force SSL Version 3)';
$string['taskcleanup'] = 'Opprydding av ubekreftet innkommende e-post';
$string['taskpickup'] = 'Innkommende epost-fanger';
$string['tls'] = 'TLS (TLS, startet via protokoll-nivå forhandling om ukryptert kanal; ANBEFALT måte å initiere sikker tilkobling)';
$string['tlsv1'] = 'TLSv1 (direkte tilkoblinf til TLS server versjon 1.x)';
$string['validateaddress'] = 'Valider senderes epostaddresse';
$string['validateaddress_help'] = 'Når du mottar en melding fra en bruker, prøver Moodle å validere meldingen ved å sammenligne e-postadressen til avsenderen med e-postadressen i sin brukerprofil.

Hvis avsenderen ikke stemmer overens, blir brukeren sendt en melding for å bekrefte at de virkelig sendte e-posten.

Hvis denne innstillingen er deaktivert, vil e-postadressen til avsenderen ikke bli sjekket i det hele tatt.';
