<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'sr_cr', version '4.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.calendar.calendarevents'] = 'Догађаји у календару';
$string['addon.calendar.defaultnotificationtime'] = 'Подразумевано време за слање обавештења';
$string['addon.calendar.errorloadevent'] = 'Грешка приликом учитавања догађаја.';
$string['addon.calendar.errorloadevents'] = 'Грешка приликом учитавања догађаја.';
$string['addon.calendar.noevents'] = 'Нема догађаја';
$string['addon.competency.errornocompetenciesfound'] = 'Није пронађена ниједна компетенција';
$string['addon.competency.nocompetencies'] = 'Нема компетенција';
$string['addon.coursecompletion.complete'] = 'Заврши';
$string['addon.coursecompletion.couldnotloadreport'] = 'Није могуће учитати извештај о завршетку курса. Молимо вас, покушајте поново касније.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Конфигуриши уређаје';
$string['addon.messages.contactlistempty'] = 'Листа контаката је празна';
$string['addon.messages.contactname'] = 'Име особе';
$string['addon.messages.deletemessage'] = 'Обриши поруку';
$string['addon.messages.deletemessageconfirmation'] = 'Да ли сигурни да желите да обришете ову поруку? Она ће бити избрисан само из ваше историје порука али ће и даље бити видљива кориснику који је послао или примио поруку.';
$string['addon.messages.errordeletemessage'] = 'Грешка приликом брисања поруке.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Грешка приликом преузимања контаката са сервера.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Грешка приликом преузимања дискусија са сервера.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Грешка приликом преузимања порука са сервера.';
$string['addon.messages.errorwhileretrievingusers'] = 'Грешка приликом преузимања корисника са сервера.';
$string['addon.messages.messagenotsent'] = 'Порука није послата. Молимо вас, покушајте поново касније.';
$string['addon.messages.newmessages'] = 'Нове поруке';
$string['addon.messages.nousersfound'] = 'Није пронађен ниједан корисник';
$string['addon.messages.showdeletemessages'] = 'Прикажи брисање порука';
$string['addon.messages.type_blocked'] = 'Блокиран';
$string['addon.messages.type_offline'] = 'Офлајн';
$string['addon.messages.type_online'] = 'Онлајн';
$string['addon.messages.type_search'] = 'Резултати претраге';
$string['addon.messages.type_strangers'] = 'Други';
$string['addon.messages.warningconversationmessagenotsent'] = 'Није могуће послати поруку(е) у преписку {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Није могуће послати поруку(е) кориснику {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Молимо вас да прихватите изјаву о предаји рада.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Не можете да додате или мењате рад у апликацији јер изјава о предатом раду не може да се преузме са сајта.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Апликације још увек не подржава одређене методе оцењивања и оне се не могу мењати.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Не можете да предате рад на оцењивање у апликацији јер ниjе било могуће преузети са сајта изјаву о предаји рада.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Не можете да додате или мењате рад у апликацији јер неки додаци још увек немају подршку за уређивање.';
$string['addon.mod_assign.errorshowinginformation'] = 'Није могуће приказати информације о предатом раду.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Апликација не подржава ове повратне информације. Могуће је да оне не садржи све информације.';
$string['addon.mod_assign.gradenotsynced'] = 'Оцена није синхронизована';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Учесници који нису предали рад нису приказани.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Број радних верзија: {{count}}';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Број учесника: {{count}}';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Број предатих радова које треба оценити: {{count}}';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Број предатих задатака (радова): {{count}}';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Број тимова: {{count}}';
$string['addon.mod_assign.submissionnotsupported'] = 'Апликација не подржава овај предати рад. Могуће је да рад не садржи све информације.';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Оцена предатог рада је измењена на сајту.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Предати рад корисника је измењен на сајту.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Грешка приликом повезивања са причаоницом.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Грешка приликом преузимања података за \'Причаоницу\'.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Грешка приликом преузимања корисника причаонице.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Грешка приликом преузимања порука са сервера.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Грешка приликом слања поруке.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Морате бити онлајн како бисте слали поруке.';
$string['addon.mod_choice.errorgetchoice'] = 'Грешка приликом преузимања података за \'Избор\'';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% корисника је изабрало опцију: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Резултати не укључује ваш последњи одговор. Покрените синхронизацију како бисте их ажурирали.';
$string['addon.mod_data.errorapproving'] = 'Грешка приликом одобравања или неодобравања уноса.';
$string['addon.mod_data.errordeleting'] = 'Грешка приликом брисања уноса.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Упитник са Captcha елементом не може да буде завршен ако није конфигурисан, ако сте у офлајн режиму или ако је сервер искључен.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Овај упитник је сачуван како би касније био предат.';
$string['addon.mod_folder.emptyfilelist'] = 'Нема датотека за приказ.';
$string['addon.mod_forum.errorgetforum'] = 'Грешка приликом преузимања података за \'Форум\'';
$string['addon.mod_forum.errorgetgroups'] = 'Грешка приликом преузимања подешавања група.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Још нема тема за дискусију на овом форуму.';
$string['addon.mod_forum.group'] = 'Група';
$string['addon.mod_forum.numdiscussions'] = 'Број дискусија: {{numdiscussions}}';
$string['addon.mod_forum.numreplies'] = 'Број одговора: {{numreplies}}';
$string['addon.mod_forum.refreshposts'] = 'Освежи постове';
$string['addon.mod_glossary.browsemode'] = 'Прегледај појмове';
$string['addon.mod_glossary.byalphabet'] = 'Азбучним редом';
$string['addon.mod_glossary.byauthor'] = 'Групиши по аутору';
$string['addon.mod_glossary.bycategory'] = 'Групиши по категорији';
$string['addon.mod_glossary.bynewestfirst'] = 'Најновији прво';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Недавно ажурирани';
$string['addon.mod_glossary.bysearch'] = 'Претражи';
$string['addon.mod_glossary.cannoteditentry'] = 'Не можете да уређујете појам';
$string['addon.mod_glossary.entriestobesynced'] = 'Појмови за синхронизацију';
$string['addon.mod_glossary.entrypendingapproval'] = 'Овај појам чека одобрење.';
$string['addon.mod_glossary.errorloadingentries'] = 'Дошло је до грешке приликом учитавања појмова.';
$string['addon.mod_glossary.errorloadingentry'] = 'Дошло је до грешке приликом учитавања појма.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Дошло је до грешке приликом учитавања речника.';
$string['addon.mod_glossary.noentriesfound'] = 'Није пронађен ниједан појам.';
$string['addon.mod_glossary.searchquery'] = 'Упит за претрагу';
$string['addon.mod_imscp.showmoduledescription'] = 'Прикажи опис';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Ова лекција садржи прелаз на наусимично одабрану страницу са садржајем, па је није могуће урадити у апликацији док се не покрене на веб сајту.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Ова покушај не може више бити прегледан зато што је завршен други покушај.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Овај покушај је завршен у офлајн режиму.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Офлајн покушај је синхронизован. Да ли желите да га прегледате?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Покушај је завршен на веб сајту.';
$string['addon.mod_lti.errorgetlti'] = 'Грешка приликом преузимања података модула.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Иницијална URL адреса није исправна.';
$string['addon.mod_lti.launchactivity'] = 'Покрени активност';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Грешка приликом учитавања садржаја странице.';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Овај покушај решавања теста не може да буде предат због следећих разлога:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Овај покушај није синхронизован од {{$a}}. Ако сте у међувремену овај покушај наставили  на неком другом уређају, постоји могућност да сте изгубили податке.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Дошло је до грешке приликом покушаја да се сачувају одговори. Да ли сте сигурни да желите да напустите тест?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Овај тест не можете решавати у апликацији зато што она не подржава понашање питања:';
$string['addon.mod_quiz.errordownloading'] = 'Грешка приликом преузимања неопходних података.';
$string['addon.mod_quiz.errorgetattempt'] = 'Грешка приликом преузимања података о покушају решавања теста.';
$string['addon.mod_quiz.errorgetquestions'] = 'Грешка приликом преузимања питања.';
$string['addon.mod_quiz.errorgetquiz'] = 'Грешка приликом преузимања података о тесту.';
$string['addon.mod_quiz.errorparsequestions'] = 'Дошло је до грешке приликом учитавања питања. Молимо, покушајте да решите овај тест у веб читачу.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Овај тест се не може решавати у апликацији зато што садржи питања које апликација не подржава:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Овај тест се не може решавати у апликацији зато што садржи правила за приступ које апликација не подржава:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Дошло је до грешке приликом снимања података о покушају решавања теста.';
$string['addon.mod_quiz.finishnotsynced'] = 'Тест је завршен, али није синхронизован';
$string['addon.mod_quiz.opentoc'] = 'Отвори навигациони мени.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Офлајн покушај је одбачен зато што је или завршен на сајту или није пронађен.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Неки офлајн одговори су одбачени зато што су питања измењена онлајн.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Покушај решавања теста је није завршен зато што су неки офлајн одговори одбачени. Прегледајте своје одговоре, а затим поново пошаљите свој покушај.';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Грешка приликом учитавања садржаја.';
$string['addon.mod_resource.openthefile'] = 'Отвори датотеку';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Оцена не може да се израчуна.';
$string['addon.mod_scorm.dataattemptshown'] = 'Ови подаци припадају покушају број {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Дошло је до грешке приликом покушаја креирања новог офлајн покушаја. Молимо, покушајте поново.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Грешка приликом преузимања SCORM пакета: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Грешка приликом преузимања података SCORM пакета.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Извините, апликација подржава само SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Преузимање SCORM пакета је онемогућено на вашем сајту. Молимо, обратите се администратору вашег Moodle сајта.';
$string['addon.mod_scorm.errornovalidsco'] = 'Овај SCORM пакет нема видљив SCO који би био учитан.';
$string['addon.mod_scorm.errorpackagefile'] = 'Извините, апликација подржава само ZIP архиве.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Дошло је до грешке приликом синхронизације. Молимо, покушајте поново.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Овај покушај има податке који нису синхронизован.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Овај покушај не може бити послат зато што сте премашили максималан број дозвољених покушаја.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Овај SCORM пакет није преузет. Биће аутоматски преузет када га отворите.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Овај SCORM пакет је мењан од последњег преузимања. Биће аутоматски преузет када га отворите.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Неки офлајн подаци о покушају  {{number}} су обрисани зато што их није могуће креирати у новом покушају.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Неки покушаји нису могли бити синхронизовани са сајтом зато што последњи онлине покушај није завршен. Молимо вас да прво завршите онлајн покушај.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Нажалост, било је проблема са предајом вашег упитника. Молим вас, покушајте поново.';
$string['addon.mod_survey.errorgetsurvey'] = 'Грешка приликом преузимања података за \'Упитник\' (Survey)';
$string['addon.mod_survey.results'] = 'Резултати';
$string['addon.mod_url.accessurl'] = 'Приступи URL адреси';
$string['addon.mod_url.pointingtourl'] = 'URL адреса са којом је овај ресурс повезан';
$string['addon.mod_wiki.errorloadingpage'] = 'Дошло је до грешке приликом учитавања странице.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Овај вики још увек нема садржај.';
$string['addon.mod_wiki.gowikihome'] = 'Иди на почетну страницу викија';
$string['addon.mod_wiki.subwiki'] = 'Подвики';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Наслов не би требало да буде празан';
$string['addon.mod_wiki.viewpage'] = 'Погледај страницу';
$string['addon.mod_wiki.wikipage'] = 'Вики страница';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Стратегија процене {{$a}} није подржана';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Морате да унесете наслов.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Предати рад је измењен на сајту.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Процена је измењена на сајту.';
$string['addon.notes.warningnotenotsent'] = 'Није могуће додати белешку/е курсу {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Грешка приликом преузимања обавештења';
$string['addon.notifications.notifications'] = 'Обавештења';
$string['addon.notifications.playsound'] = 'Репродукуј звук';
$string['addon.notifications.therearentnotificationsyet'] = 'Нема обавештења';
$string['appstoredescription'] = 'НАПОМЕНА: Ова званична Moodle Mobile ће радити САМО са оним Moodle сајтовима који су подешени тако да то омогућавају. Ако имате проблема са повезивањем, обратите се администратору вашег Moodle сајта.

Ако је ваш Moodle сајт исправно конфигурисан, ову апликацију можете користити како бисте:

- прегледали садржаје својих курсева, чак и када сте офлајн
- примали тренутна обавештења о порукама и другим догађајима
- брзо пронашли и контактирали друге полазнике на својим курсевима
- отпремали слике, аудио, видео и друге датотеке са свог мобилног уређаја
- видели своје оцене на курсу
- и још много тога!

За све најновије информације молимо вас, погледајте http://docs.moodle.org/en/Mobile_app

Заиста бисмо волели да чујемо ваше коментаре о постојећим функционалностима, као и сугестије о томе шта још желите да ова апликација ради!

Апликација захтева следећа овлашћење:
Снимање звука - за снимање звука и отпремање снимка на Moodle
Читање и модификовање садржаја ваше SD картице - садржаји се преузимају на SD картицу вашег телефона тако да можете да их видите и када се у офлајн режиму
Приступ мрежи - како бисте могли да се повежете са својим Moodle сајтом и проверите да ли сте повезани или не (и у том случају се пребаците у офлајн режим)
Извршавање при покретању - тако да можете да примате локална обавештења чак и када апликација ради у позадини
Спречавања да мобилни телефон уђе у режим мировања - тако да можете да примите обавештења у било ком тренутку';
$string['core.cannotconnect'] = 'Није могуће успоставити везу.';
$string['core.cannotdownloadfiles'] = 'Преузимање датотека је онемогућено у подешавањима вашег мобилног сервиса. Обратите се администратору сајта.';
$string['core.captureaudio'] = 'Сними аудио';
$string['core.capturedimage'] = 'Снимљена слика';
$string['core.captureimage'] = 'Усликај';
$string['core.capturevideo'] = 'Сними видео';
$string['core.clearsearch'] = 'Обриши претрагу';
$string['core.clicktoseefull'] = 'Кликните да бисте видели комплетан садржај.';
$string['core.confirmcanceledit'] = 'Да ли сте сигурни да желите да напустите ову страницу? Све промене ће бити изгубљене.';
$string['core.confirmloss'] = 'Да ли сте сигурни? Све промене ће бити изгубљене.';
$string['core.confirmopeninbrowser'] = 'Да ли желите да отворите у веб читачу?';
$string['core.contenteditingsynced'] = 'Садржај који уређујете је синхронизован.';
$string['core.contentlinks.chooseaccount'] = 'Изабери налог';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Изаберите налог са којим треба отворити линк.';
$string['core.contentlinks.confirmurlothersite'] = 'Овај линк припада другом сајту. Да ли желите да га отворите?';
$string['core.contentlinks.errornoactions'] = 'Није могуће пронаћи акцију коју треба извести са овим линком.';
$string['core.contentlinks.errornosites'] = 'Није могуће пронаћи било који сајт који може изаћи на крај са овим линком.';
$string['core.copiedtoclipboard'] = 'Текст копиран у клипборд';
$string['core.course.activitydisabled'] = 'Ваша институција је онемогућила ову активност у мобилној апликацији.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Ваша институција је инсталирала додатак који још увек није подржан.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'Потребно је да се ажурира Moodle инсталација ваше институције.';
$string['core.course.allsections'] = 'Све секције';
$string['core.course.askadmintosupport'] = 'Обратите се администратору сајта и реците му да желите да користите ову активност са Moodle Mobile апликацијом.';
$string['core.course.confirmdeletemodulefiles'] = 'Да ли сте сигурни да желите да избришете датотеке овог модула?';
$string['core.course.confirmdownload'] = 'Намеравате да преузмете {{size}}. Да ли сте сигурни да желите да наставите?';
$string['core.course.confirmdownloadunknownsize'] = 'Нисмо могли да израчунамо величину преузимање. Да ли сте сигурни да желите да преузмете?';
$string['core.course.confirmpartialdownloadsize'] = 'Намеравате да преузмете <strong>најмање</strong> {{size}}. Да ли сте сигурни да желите да наставите?';
$string['core.course.contents'] = 'Садржаји';
$string['core.course.couldnotloadsectioncontent'] = 'Није могуће учитати садржај секције, покушајте поново касније.';
$string['core.course.couldnotloadsections'] = 'Није могуће учитати секције, покушајте поново касније.';
$string['core.course.errordownloadingcourse'] = 'Грешка приликом преузимању курса.';
$string['core.course.errordownloadingsection'] = 'Грешка приликом преузимања секције.';
$string['core.course.errorgetmodule'] = 'Грешка приликом преузимања података модула.';
$string['core.course.manualcompletionnotsynced'] = 'Ручни завршетак није синхронизован.';
$string['core.course.nocontentavailable'] = 'Никакав садржај није доступан у овом тренутку.';
$string['core.course.refreshcourse'] = 'Освежи курс';
$string['core.course.useactivityonbrowser'] = 'Још увек можете да га користите помоћу веб читача вашег уређаја.';
$string['core.course.warningmanualcompletionmodified'] = 'Ручни завршетак активности је измењен на сајту.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Неки офлајн ручни завршеци курса \'{{name}}\' су обрисани. {{error}}';
$string['core.courses.cannotretrievemorecategories'] = 'Категорије које су испод нивоа {{$a}} не могу се преузети.';
$string['core.courses.confirmselfenrol'] = 'Да ли сте сигурни да желите да се упишете на овај курс?';
$string['core.courses.downloadcourses'] = 'Преузми курс';
$string['core.courses.enrolme'] = 'Упиши ме';
$string['core.courses.errorloadcategories'] = 'Дошло је до грешке приликом учитавања категорија.';
$string['core.courses.errorloadcourses'] = 'Дошло је до грешке приликом учитавања курсева.';
$string['core.courses.errorsearching'] = 'Дошло је до грешке приликом претраживања.';
$string['core.courses.errorselfenrol'] = 'Дошло је до грешке приликом покушаја самосталног уписа.';
$string['core.courses.filtermycourses'] = 'Филтрирај моје курсеве';
$string['core.courses.notenrollable'] = 'Не можете сами да се упишете на овај курс.';
$string['core.courses.password'] = 'Приступна лозинка курса';
$string['core.courses.searchcoursesadvice'] = 'Можете користити дугме за претрагу курсева како бисте им приступили као гост или се уписали на курсеве који то допуштају.';
$string['core.courses.selfenrolment'] = 'Самостални упис';
$string['core.courses.totalcoursesearchresults'] = 'Укупно курсева: {{$a}}';
$string['core.currentdevice'] = 'Тренутни уређај';
$string['core.datastoredoffline'] = 'Подаци су сачувани у мобилном уређају, зато што не могу да се пошаљу. Аутоматски ће бити послати касније.';
$string['core.deletedoffline'] = 'Обрисано офлајн';
$string['core.deleting'] = 'Брисање';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Одбаци';
$string['core.dismiss'] = 'Обустави';
$string['core.downloading'] = 'Преузимање';
$string['core.emptysplit'] = 'Ова страница ће се појавити празна уколико је леви панел празан или се учитава.';
$string['core.errorchangecompletion'] = 'Дошло је до грешке приликом промене статуса завршетка. Молимо, покушајте поново.';
$string['core.errordeletefile'] = 'Грешка приликом брисања датотеке. Молимо, покушајте поново.';
$string['core.errordownloading'] = 'Грешка приликом преузимања датотеке.';
$string['core.errordownloadingsomefiles'] = 'Грешка приликом преузимања датотека модула. Могуће је да неке датотеке недостају.';
$string['core.errorfileexistssamename'] = 'Већ постоји датотека са овим називом.';
$string['core.errorinvalidform'] = 'Образац садржи неисправне податке. Уверите се да сте попунили сва неопходна поља и да су подаци исправни.';
$string['core.errorinvalidresponse'] = 'Примљен је неисправан одговор. Обратите се администратору вашег Moodle сајта ако се грешка понови.';
$string['core.errorloadingcontent'] = 'Грешка при учитавању садржаја.';
$string['core.errorofflinedisabled'] = 'Офлајн прегледање је онемогућено на вашем сајту.';
$string['core.erroropenfilenoapp'] = 'Грешка приликом отварања датотеке: није пронађена апликација која може да отвори овај тип датотеке.';
$string['core.erroropenfilenoextension'] = 'Грешка приликом отварања датотеке: датотека нема екстензију.';
$string['core.erroropenpopup'] = 'Ова активност покушава да отвори искачући прозор. Ова апликација то не подржава.';
$string['core.errorrenamefile'] = 'Грешка приликом покушаја промене назива датотеке. Молимо, покушајте поново.';
$string['core.errorsync'] = 'Дошло је до грешке приликом синхронизацији. Молимо, покушајте поново.';
$string['core.errorsyncblocked'] = '{{$a}} тренутно не може да се синхронизује због текућег процеса. Молимо, покушајте поново касније. Ако се проблем и даље буде постојао, покушајте поново да покренете апликацију.';
$string['core.filenameexist'] = 'Назив датотеке већ постоји: {{$a}}';
$string['core.fileuploader.audio'] = 'Аудио';
$string['core.fileuploader.camera'] = 'Камера';
$string['core.fileuploader.confirmuploadfile'] = 'Намеравате да отпремите {{size}}. Да ли сте сигурни да желите да наставите?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Нисмо могли да израчунамо величину датотека за отпремање. Да ли сте сигурни да желите да наставите?';
$string['core.fileuploader.errorcapturingaudio'] = 'Грешка приликом снимања аудио записа.';
$string['core.fileuploader.errorcapturingimage'] = 'Грешка приликом снимања слике.';
$string['core.fileuploader.errorcapturingvideo'] = 'Грешка приликом снимања видео записа.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Грешка приликом преузимања слике из албума.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Морате бити онлајн како бисте отпремили датотеке.';
$string['core.fileuploader.errornoapp'] = 'Немате инсталирану апликацију која може да изведе ову акцију.';
$string['core.fileuploader.errorreadingfile'] = 'Грешка приликом учитавања датотеке.';
$string['core.fileuploader.errorwhileuploading'] = 'Дошло је до грешке приликом отпремања датотеке.';
$string['core.fileuploader.file'] = 'Датотека';
$string['core.fileuploader.fileuploaded'] = 'Датотека је успешно отпремљена.';
$string['core.fileuploader.maxbytesfile'] = 'Датотека {{$a.file}} је превелика. Максимална величина коју можете да отпремите је {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Фото албум';
$string['core.fileuploader.readingfile'] = 'Учитавање датотеке';
$string['core.fileuploader.readingfileperc'] = 'Учитавање датотеке: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Изабери датотеку';
$string['core.fileuploader.uploadafile'] = 'Отпреми датотеку';
$string['core.fileuploader.uploading'] = 'Отпремање';
$string['core.fileuploader.uploadingperc'] = 'Отпремање: {{$a}}%';
$string['core.fileuploader.video'] = 'Видео';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.hasdatatosync'] = '{{$a}} има офлајн податке које треба синхронизовати.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Слика';
$string['core.imageviewer'] = 'Приказивач слике';
$string['core.lastdownloaded'] = 'Последњи пут преузето';
$string['core.lastsync'] = 'Последња синхронизација';
$string['core.loadmore'] = 'Учитај још';
$string['core.login.authenticating'] = 'Провера идентитета';
$string['core.login.confirmdeletesite'] = 'Да ли сте сигурни да желите да обришете сајт {{sitename}}?';
$string['core.login.connect'] = 'Повежите се!';
$string['core.login.connecttomoodle'] = 'Повежите се са Moodleom';
$string['core.login.connecttomoodleapp'] = 'Покушавате да се повежете са Moodle сајтом. Преузмите званичну Moodle апликацију како бисте приступили овом сајту.';
$string['core.login.contactyouradministrator'] = 'Обратите се администратору вашег сајта за даљу помоћ.';
$string['core.login.contactyouradministratorissue'] = 'Замолите администратора да провери следећи проблем: {{$a}}';
$string['core.login.credentialsdescription'] = 'За пријаву на систем унесите своје корисничко име и лозинку.';
$string['core.login.emailconfirmsentnoemail'] = '<p>Требало би да је послата е-порука на вашу адресу.</p><p><p>Порука садржи једноставна упутства о даљем поступку регистрације.</p><p>Ако и даље имате проблема, контактирајте администратора.</p>';
$string['core.login.emailnotmatch'] = 'Адресе е-поште се не поклапају';
$string['core.login.erroraccesscontrolalloworigin'] = 'Cross-Origin позив који покушавате да изведете је одбијен. Молимо, проверите https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Дошло је до грешке приликом брисања овог сајта. Молим, покушајте поново.';
$string['core.login.errorupdatesite'] = 'Дошло је до грешке приликом ажурирању токена сајта.';
$string['core.login.faqtestappanswer'] = 'Да бисте тестирали апликацију на Moodle Demo сајту, у поље „Ваш сајт“ унесите "teacher" или „student" и кликните на дугме „Повежи се са својим сајтом“.';
$string['core.login.faqwhatisurlanswer'] = '<p>Свака организација има сопствену јединствену адресу или URL  адресу за свој Moodle сајт. Да бисте пронашли адресу:</p><ol><li>Отворите веб читач и идите на страницу за пријављивање вашег Moodle сајта.</li><li>На врху странице, у траци за адресу, видећете URL адресу свог Moodle сајта нпр. "mojaskola.edu.rs".<br>{{$image}}</li><li>Копирајте адресу (немојте копирати део адресе који почиње са /login), у Moodle апликацију а онда кликните на дугме "Повежите се са својим сајтом"</li><li>Сада се можете пријавити на свој сајт користећи своје корисничко име и лозинку.</li>';
$string['core.login.findyoursite'] = 'Пронађите свој сајт';
$string['core.login.helpmelogin'] = '<p>Постоји више хиљада Moodle сајтова широм света. Ова апликација може да се повеже само са Moodle сајтовима који су експлицитно омогућили приступ мобилној апликацији.</p><p>Ако не можете да се повежете са Moodle сајтом, контактирајте администратора вашег сајта и затражите да прочита <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Да бисте тестирали апликацију на Moodle демо сајту упишите <i>teacher</i> или <i>student</i> у поље <i>Адреса сајта</i> и кликните дугме <b>Повежите се!</b>.</p>';
$string['core.login.invalidaccount'] = 'Проверите своје податке за пријаву или замолите вашег администратора да провери конфигурацију сајта.';
$string['core.login.invalidmoodleversion'] = 'Неисправна Moodle верзија. Неопходна је, минимално, верзија 2.4.';
$string['core.login.invalidsite'] = 'URL адреса сајта није исправна.';
$string['core.login.invalidtime'] = 'Неисправно време';
$string['core.login.invalidvaluemax'] = 'Максимална вредност је {{$a}}';
$string['core.login.invalidvaluemin'] = 'Минимална вредност је {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'Провера Moodle Mobile додатних функционалности вратила је неочекиван одговор. Ваш идентитет биће проверен помоћу стандардног мобилнog сервиса.';
$string['core.login.loggedoutssodescription'] = 'Морате поново да потврдите свој идентитет. Потребно је да се пријавите на сајт у прозору веб читача.';
$string['core.login.loginbutton'] = 'Пријава';
$string['core.login.logininsiterequired'] = 'Потребно је да се пријавите на сајт у прозору веб читача.';
$string['core.login.mobileservicesnotenabled'] = 'Мобилни сервиси нису омогућени на вашем сајту. Обратите се администратору вашег Moodle сајта ако мислите да мобилни приступ треба да буде омогућен.';
$string['core.login.notloggedin'] = 'Морате бити пријављени.';
$string['core.login.onboardingtoconnect'] = 'Да бисте се повезали са Moodle апликацијом, биће вам потребан Moodle сајт';
$string['core.login.onboardingwelcome'] = 'Добродошли у Moodle апликацију!';
$string['core.login.passwordrequired'] = 'Неопходна је лозинка';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA слика';
$string['core.login.recaptchaexpired'] = 'Верификација је истекла. Поново одговорите на безбедносно питање.';
$string['core.login.recaptchaincorrect'] = 'Одговор на безбедносно питање је нетачан.';
$string['core.login.reconnect'] = 'Повежите се поново';
$string['core.login.reconnectdescription'] = 'Ваш токен за проверу идентитета је неисправан или је истекао. Морате поново да успоставите везу са сајтом.';
$string['core.login.reconnectssodescription'] = 'Ваш токен за проверу идентитета је неисправан или је истекао. Морате поново да успоставите везу са сајтом. Потребно је да се пријавите на сајт у прозору веб читача.';
$string['core.login.searchby'] = 'Претрага по:';
$string['core.login.selectsite'] = 'Изаберите свој сајт:';
$string['core.login.signupplugindisabled'] = '{{$a}} није омогућен.';
$string['core.login.siteaddress'] = 'Адреса сајта';
$string['core.login.sitehasredirect'] = 'Ваш сајт садржи најмање једну HTTP редирекцију. Апликација не може да прати редирекције. Ово би могао да буде проблем који спречава апликацију да се повеже са вашим сајтом.';
$string['core.login.siteinmaintenance'] = 'Ваш сајт је у режиму одржавања';
$string['core.login.sitepolicynotagreederror'] = 'Сагласност са политиком сајта није потврђена.';
$string['core.login.siteurl'] = 'URL адреса сајта';
$string['core.login.siteurlrequired'] = 'Неопходна је URL адреса, нпр. <i>http://www.yourmoodlesite.abc или https://www.yourmoodlesite.efg</i>';
$string['core.login.stillcantconnect'] = 'Још увек не можете да се повежете?';
$string['core.login.usernamerequired'] = 'Корисничко име је неопходно';
$string['core.login.visitchangepassword'] = 'Да ли желите да посетите сајт како бисте променили лозинку?';
$string['core.login.webservicesnotenabled'] = 'Веб сервиси нису омогућени на вашем сајту. Обратите се администратору вашег Moodle сајта ако мислите да мобилни приступ треба да буде омогућен.';
$string['core.login.yourenteredsite'] = 'Повежите се са својим сајтом';
$string['core.lostconnection'] = 'Ваш токен за потврду идентитета је неважећи или је истекао. Мораћете поново да успоставите везу са сајтом.';
$string['core.mainmenu.changesite'] = 'Промени сајт';
$string['core.mainmenu.website'] = 'Веб сајт';
$string['core.networkerroriframemsg'] = 'Овај садржај није доступан офлајн. Повежите се на интернет и покушајте поново.';
$string['core.networkerrormsg'] = 'Било је проблема са повезивањем на сајт. Проверите везу и покушајте поново.';
$string['core.nopasswordchangeforced'] = 'Не можете наставити без промене своје лозинке.';
$string['core.nopermissionerror'] = 'Жао нам је, али тренутно немате овлашћења да то урадите';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Није послато';
$string['core.openfullimage'] = 'Кликните овде да бисте приказали слику у пуној величини';
$string['core.openinbrowser'] = 'Отвори у веб читачу';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Повуците за освежавање';
$string['core.question.cannotdeterminestatus'] = 'Није могуће одредити статус';
$string['core.question.errorquestionnotsupported'] = 'Апликација не подржава овај тип питања: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Додирните за избор, затим још једном за спуштање.';
$string['core.question.questionmessage'] = 'Питање {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Бићете преусмерени на сајт.';
$string['core.requireduserdatamissing'] = 'Овај корисник нема у свом профилу неке неопходне податке. Молимо вас, унесети ове податке у ваш Moodle и покушајте поново.<br>{{$a}}';
$string['core.retry'] = 'Покушај поново';
$string['core.searching'] = 'Претраживање';
$string['core.settings.about'] = 'О апликацији';
$string['core.settings.appsettings'] = 'Подешавања апликације';
$string['core.settings.cannotsyncoffline'] = 'Офлајн синхронизација није могућа.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Синхронизација није могућа зато што тренутна подешавања дозвољавају синхронизацију само када постоји веза са Wi-Fi мрежом. Повежите се на Wi-Fi мрежу.';
$string['core.settings.compilationinfo'] = 'Информације о компилацији';
$string['core.settings.cordovadevicemodel'] = 'Модел Cordova уређаја';
$string['core.settings.cordovadeviceosversion'] = 'Верзија оперативног система Cordova уређаја';
$string['core.settings.cordovadeviceplatform'] = 'Платформа Cordova уређаја';
$string['core.settings.cordovadeviceuuid'] = 'UUID Cordova уређаја';
$string['core.settings.cordovaversion'] = 'Cordova верзија';
$string['core.settings.debugdisplaydescription'] = 'Ако је омогућена ова опција, порука о грешци ће приказати више података о самој грешци ако је то могуће.';
$string['core.settings.deletesitefiles'] = 'Да ли сте сигурни да желите да обришете преузете датотеке са сајта \'{{sitename}}\'?';
$string['core.settings.deletesitefilestitle'] = 'Обриши датотеке сајта';
$string['core.settings.developeroptions'] = 'Опције за програмере';
$string['core.settings.deviceinfo'] = 'Информације о уређају';
$string['core.settings.deviceos'] = 'Оперативни систем уређаја';
$string['core.settings.displayformat'] = 'Формат приказа';
$string['core.settings.enabledownloadsection'] = 'Омогући преузимање секција.';
$string['core.settings.enablerichtexteditor'] = 'Омогући обогаћени едитор текста';
$string['core.settings.enablerichtexteditordescription'] = 'Ако је ова опција укључена обогаћени едитор текста биће приказан на местима која то дозвољавају.';
$string['core.settings.enablesyncwifi'] = 'Дозволите синхронизацију само када сте повезани на Wi-Fi мрежу.';
$string['core.settings.errordeletesitefiles'] = 'Грешка приликом брисања датотека сајта.';
$string['core.settings.errorsyncsite'] = 'Грешка приликом синхронизације података сајта. Молимо, проверите вашу интернет везу и покушајте поново.';
$string['core.settings.estimatedfreespace'] = 'Процењени слободан простора';
$string['core.settings.filesystemroot'] = 'Основни директоријум система датотека';
$string['core.settings.localnotifavailable'] = 'Локална обавештења доступна';
$string['core.settings.locationhref'] = 'Webview URL адреса';
$string['core.settings.navigatorlanguage'] = 'Језик навигатора';
$string['core.settings.navigatoruseragent'] = 'Кориснички агент навигатора';
$string['core.settings.networkstatus'] = 'Статус инернет везе';
$string['core.settings.privacypolicy'] = 'Политика приватности';
$string['core.settings.reportinbackground'] = 'Пријави грешке аутоматски';
$string['core.settings.showdownloadoptions'] = 'Прикажи опције преузимања';
$string['core.settings.spaceusage'] = 'Искориштеност простора';
$string['core.settings.synchronization'] = 'Синхронизација';
$string['core.settings.synchronizenow'] = 'Синхронизуј сада';
$string['core.settings.syncsettings'] = 'Подешавања синхронизације';
$string['core.settings.wificonnection'] = 'WiFi веза';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Изаберите налог за чување датотеке.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Већ постоји датотека са овим називом. Да ли желите да замените постојећу датотеку или да јој назив промените у "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Не постоје меморисани сајтови. Молимо, додајте сајт пре него што покушате да поделите датотеке са апликацијом.';
$string['core.sharedfiles.nosharedfiles'] = 'Не постоје дељене датотеке које се налазе на овом сајту.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Овде немате датотеке које можете да отпремите. Ако желите да отпремите датотеку из друге апликације, пронађите ту датотеку и кликните на дугме \'Отвори у\'.';
$string['core.sharedfiles.rename'] = 'Промени назив';
$string['core.sharedfiles.replace'] = 'Замени';
$string['core.sharedfiles.sharedfiles'] = 'Дељене датотеке';
$string['core.sharedfiles.successstorefile'] = 'Датотека је успешно сачувана. Сада можете да изаберете ову датотеку да бисте је отпремили међу своје приватне датотеке или је придружили некој активности.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Извините...';
$string['core.tablet'] = 'Таблет';
$string['core.thereisdatatosync'] = 'Број офлајн податак које треба синхронизовати: {{$a}}';
$string['core.tryagain'] = 'Покушај поново';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ух!';
$string['core.unexpectederror'] = 'Неочекивана грешка. Затворите и поново отворите апликацију, а затим покушајте поново.';
$string['core.unicodenotsupported'] = 'Неки емотикони нису подржани на овом сајту. Такви знакови ће бити уклоњени приликом слања поруке.';
$string['core.unicodenotsupportedcleanerror'] = 'Приликом чишћења Unicode карактера пронађен је празан текст.';
$string['core.unknown'] = 'Непознато';
$string['core.unzipping'] = 'Распакивање';
$string['core.user.contact'] = 'Контакт';
$string['core.user.detailsnotavailable'] = 'Подаци о овом кориснику вам нису доступни.';
$string['core.user.errorloaduser'] = 'Грешка приликом учитавања корисника.';
$string['core.user.sendemail'] = 'Е-пошта';
$string['core.viewcode'] = 'Прикажи кôд';
$string['core.vieweditor'] = 'Прикажи едитор';
$string['core.viewembeddedcontent'] = 'Прикажи уграђени садржај';
$string['core.warningofflinedatadeleted'] = 'Офлајн подаци компоненте {{component}} \'{{name}}\' су обрисани. {{error}}';
$string['core.whoops'] = 'Упс!';
$string['core.whyisthishappening'] = 'Зашто се ово дешава?';
$string['core.wsfunctionnotavailable'] = 'Функција веб service није доступна.';
$string['pluginname'] = 'Moodle Mobile језички стрингови';
