<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'techproject', language 'af', version '4.0'.
 *
 * @package     techproject
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'Afgegooi';
$string['abandoneddesc'] = 'Die taak is verby die voltooiingsvlak wat dit het. Uitslae word nie gebruik nie.';
$string['abstract'] = 'Abstrak';
$string['accepted'] = 'Aanvaar';
$string['access'] = 'Toegang';
$string['accesskey'] = 'Toegangsleutel';
$string['accesskey_help'] = 'Die stel van \'n toegangsleutel laat eksterne, niegeregistreerde mense toe om toegang tot die dokument te verkry.';
$string['adddeliv'] = 'Voeg stamlewering by';
$string['addmilestone'] = 'Voeg stammylpaal by';
$string['addrequ'] = 'Voeg stamvereiste by';
$string['addroottask'] = 'Voeg stamtaak by';
$string['addspec'] = 'Voeg stamspesifikasie by';
$string['addsubdeliv'] = 'Voeg sublewering by';
$string['addsubrequ'] = 'Voeg subvereiste by';
$string['addsubspec'] = 'Voeg subspesifikasie by';
$string['addsubtask'] = 'Voeg subtaak by';
$string['addtask'] = 'Voeg \'n taak by';
$string['addvalue'] = 'Voeg \'n kwalifiseringswaarde by';
$string['administrating'] = 'Administreer';
$string['administratingdesc'] = 'Administrasie en databestuur';
$string['allowdeletewhenassigned'] = 'Laat uitwis toe wanneer toegewys';
$string['allowdeletewhenassigned_help'] = '<p>As hierdie opsie ontsper is, kan toegewese entiteite uitgewis word sonder om uitdruklik voorheen ontoegewys te wees. Relevante
toewysings sal uitgewis word.</p>

<p>As hierdie opsie versper is, sal die databestuur beperk word, maar verhoudings beter uitdruk.</p>';
$string['allownotifications'] = 'Laat kennisgewings toe';
$string['allownotifications_help'] = '<p>Wanneer ontsper, word deelnemers per e-pos in kennis gestel wanneer data wat vir hulle tersaaklik is, verander word.</p>';
$string['alsoapplyroot'] = 'Pas ook stamnodus toe';
$string['analysing'] = 'Analise';
$string['analysingdesc'] = 'Oplossing (stelsel) analise en modelleringtake';
$string['applytemplateselected'] = 'Pas gekose templaat toe';
$string['apr'] = 'Apr.';
$string['april'] = 'April';
$string['asap'] = 'ASAP';
$string['asapdesc'] = 'So spoedig moontlik';
$string['assessment'] = 'Assessering';
$string['assessments'] = 'Assesserings';
$string['assessmentstart'] = 'Aanvang van assesserings';
$string['assessmentstart_help'] = 'Datum waarop die projekassessering begin';
$string['assessmentstartevent'] = 'Assesseringaanvangsgebeurtenis';
$string['assigneddeliverables'] = 'Toegekende lewerings';
$string['assignedspecs'] = 'Toegekende spesifikasies:';
$string['assignedtaskendsafter'] = '\'n Toegekende taak eindig ná spertyd';
$string['assignedtasks'] = 'Toegekende take';
$string['assignedto'] = 'Toegeken aan';
$string['assignedwork'] = 'Werk toegeken:';
$string['assignee'] = 'Toegekende';
$string['assigneeunloaded'] = 'Hierdie bydraer het geen werk geskeduleer nie';
$string['aug'] = 'Aug.';
$string['august'] = 'Augustus';
$string['autograde'] = 'Outogradeer';
$string['autogradingenabled'] = 'Ontsper outogradering';
$string['autogradingenabled_help'] = '<p>Hierdie opsie aktiveer \'n interne, outomatiese graderingsberekening gebaseer op die samestelling van ingevoerde inligtingseenhede. Hierdie punt
word basies gebaseer op die breedvoerigheid van die assosiasie en meta-inligtingvoere deur die studente. Hoe meer die
projekplan gedek is, hoe hoër sal die punt wees.</p>

<p>Die outogradering word op \'n drie-indeksbasis bereken:</p>

<ul>
<li>Die eerste indeks is die "assosiasiekoers". Enige vereiste behoort verkieslik \'n pad te hê wat dit met minstens een lewering skakel.
Verder behoort enige aflewering minstens een pad terug na vereistes te hê. Hierdie indeks tel die aantal finale inskrywings en
die aantal niegeskakelde (weesgelate) inskrywings. As laasgenoemde nul is, behoort hierdie indeks die maksimum punt toe te ken.</li>

<li>Die volgende indeks is die voltooiingsindeks, gebaseer op die voortgeplante taakvoltooiingsindekse tot vereistes.</li>

<li>Die laaste indeks werk op die taak van balansering tussen lede. Driekwart van die indeks word gegee deur die koers van die toegekende take
bo totale taakdefinisie. Die oorblywende word gegee deur die balansering van verwagte onkoste.
\'n Goedgebalanseerde werksverspreiding sal die
hoogste punt kry. \'n Meer ongebalanseerde verspreiding sal minder gee.</li>
</ul>

<p>Die drie kriteria word dan met gelyke gewigte geëwenaar.</p>

<p>Stap 2: Die onderwyser kan die calculusformule herdefinieer.</p>';
$string['autogradingweight'] = 'Gewig vir die outomatiese gradering';
$string['autogradingweight_help'] = '<p>Die outogradering sal met die ander punte gemeng word deur hierdie gewigsfaktor te gebruik. Jy kan nieheelgetal numeriese waardes hier invoer.</p>';
$string['backtosessions'] = 'Terug na afdelingopsomming';
$string['baddefaultqualifierseterror'] = 'Fout: kwalifiseerderstel is nie versoenbaar vir restourasie nie';
$string['beta'] = 'Beta';
$string['betadesc'] = 'Beta-toetseenheid. Gebruik sonder waarborg';
$string['blocked'] = 'Geblok';
$string['blockeddesc'] = 'Daar is geen manier om verder te gaan nie, ons moet eers \'n aantal eksterne kwessies oorheers.';
$string['bounditems'] = 'Bindings aan {$a}';
$string['buggy'] = 'Fout';
$string['byassignee'] = 'Volgens toegekende';
$string['bypriority'] = 'Volgens prioriteit';
$string['byworktype'] = 'Volgens werktipe';
$string['calculate'] = 'Bereken';
$string['cancel'] = 'Kanselleer';
$string['cannotevaluate'] = 'Werklike verstellings of projekinhoud verskaf geen evalueerbare element of moontlikheid nie.';
$string['cannotevaluatenocriteria'] = 'Kan nie evalueer nie. Geen kriteria is gedefinieer nie.<br/> Definieer asseblief eers kriteria';
$string['cannotselfcopy'] = '\'n Projek kan nie op homself gekopieer word nie';
$string['canwait'] = 'Kan wag';
$string['canwaitdesc'] = 'Dit kan \'n rukkie wag';
$string['chargedispersion'] = 'Verspreiding van werklading';
$string['choosewhat'] = 'Kies aksie ...';
$string['clearall'] = 'Maak alles skoon';
$string['clearallmilestones'] = 'Maak alle mylpale skoon';
$string['clearcustomcsssheet'] = 'Wis doelgemaakte CSS uit';
$string['clearcustomxslsheet'] = 'Wis die XSL-filter uit';
$string['cleargrades'] = 'Maak alle punte vir hierdie groep skoon';
$string['clearwarning'] = 'OPPAS: skoonmaak van data is \'n onomkeerbare proses!<br/>Alle ooreenstemmende kruisentiteittoekenning sal uitgewis word.<br/>Wil jy voortgaan?';
$string['close'] = 'Maak sessie toe';
$string['code'] = 'Kode';
$string['coding'] = 'Programmering';
$string['codingdesc'] = 'Programmeringsaktiwiteite';
$string['comment'] = 'Kommentaar';
$string['compatiblequalifiersfound'] = 'Versoenbare kwalifiseerderstel is gevind';
$string['compile'] = 'Stel alle verspreide waardes saam';
$string['complete'] = 'Voltooi';
$string['completedesc'] = 'Alles klaar. Alles is OK';
$string['completionrate'] = 'Tempo van werksvoltooiing';
$string['complexity'] = 'Kompleksiteit';
$string['complexity_help'] = '';
$string['configpreserveglobalqualifiers'] = 'Preserveer globale kwalifiseerders';
$string['configpreserveglobalqualifiers_desc'] = 'Preserveer globale kwalifiseerders wanneer \'n techproject-eksemplaar herstel word. Indien waar, sal kwalifiseerders wat dieselfde identifiseerdeers het, NIE oorheengeskryf word nie. Ouer waardes sal bewaar word. Indien ongemerk, sal die laaste herstel die nuwe waardes dwing.';
$string['configuring'] = 'Konfigurasie';
$string['configuringdesc'] = 'Konfigurasie en opstel';
$string['confirmdeletecriteria'] = 'Bevestig uitwissingskriteria';
$string['continue'] = 'Gaan voort';
$string['copyadvice'] = 'Pasop: Deur \'n projek na ander groepe te kopieer, sal <br/>alle vorige data vir daardie groepe uitgevee word.<br/> Die kopieerproses kan nie teruggerol word nie.<br/>Gaan in elk geval voort?';
$string['copyconfirm'] = 'Bevestig kopiëring van projek';
$string['copying'] = 'Kopiëring';
$string['copyselected'] = 'Kopieer geselekteerde items';
$string['copysetup'] = 'Kopie-operasie word voorberei';
$string['copyvalidationsession'] = 'Duplikaat validasiesessie';
$string['copywhat'] = 'Kies elemente om te kopieer';
$string['costelapsed_help'] = '<p>Hierdie kwalifiseerder sal die kwaliteit van die berekening van die projekskatting toelaat. Deur NADAT DIE WERK KLAAR IS aan te dui wat die regte tydonkoste van
\'n taak is, sal die projekbestuurder \'n "oor" of "onder" skattingstendens van die projekontwerpers bereken.</p>';
$string['costplanned'] = 'Beplande onkoste';
$string['costplanned_help'] = '<p>Hierdie kwalifiseerder maak voorsiening vir die vooruitskatting van die tydonkoste van die huidige taak. Hierdie onkoste behoort in huidge
tydeenhede ingevoer te word (ure, halfdae, dae). As taakverdeling akkuraat genoeg is, sal \'n redelik goeie skatting van algehele onkoste
bereken kan word.</p>';
$string['costrate'] = 'Onkostekoers';
$string['costunit'] = 'Onkoste-eenheid';
$string['covered'] = 'Gedek';
$string['covering'] = 'Dekking';
$string['created'] = 'Geskep';
$string['createddesc'] = 'Pakket is geskep maar moontlik onvolledig.';
$string['createvalidationsession'] = 'Skep validasiesessie';
$string['createvalidationsessionfollowup'] = 'Skep nuwe opvolgsessie';
$string['criteria'] = 'Kriteria';
$string['criteriadeleteadvice'] = 'Pasop, om \'n projek te verwyder, vee alle geassosieerde punte van alle aktiewe groepe in die projek uit.';
$string['criterion'] = 'Kriterium';
$string['criterion_help'] = '<p>\'n <b>Kriterium</b> is \'n sleutelwoord vir die identifikasie van die graderingselement. Dit behoort as \'n enkele tekstuele teken ingevoer te word, sonder
enige spasies.</p>';
$string['crossentitiesmappings'] = 'Kruisentiteit-afbeeldings';
$string['cssloaded'] = 'CSS is gelaai';
$string['currentgroup'] = 'Werksgroep:';
$string['currentphase'] = 'Huidige fase:';
$string['cvscontrol'] = 'CVS-beheer';
$string['datedued'] = 'Datum van indiening';
$string['days'] = 'Dae';
$string['deadline'] = 'Spertyd';
$string['deadlineenable'] = 'Ontsper spertyd';
$string['dec'] = 'Des.';
$string['december'] = 'Desember';
$string['default'] = 'Verstek';
$string['delayed'] = 'Vertraag';
$string['delayeddesc'] = 'Ons het vrywilliglik besluit om \'n rukkie te wag voordat ons weer daaraan werk.';
$string['delete'] = 'Wis uit';
$string['deletecriteria'] = 'Wis hierdie kriterium en alle gepaardgaande punte uit.';
$string['deletemilestone'] = 'Wis \'n mylpaal uit';
$string['deleteselected'] = 'Wis geselekteerde items uit';
$string['deletetask'] = 'Wis \'n taak uit';
$string['deliv_status'] = 'Leweringstatus';
$string['deliv_status_help'] = '<p>Hierdie kwalifiseerder bepaal die status van \'n leweringsvoorwerp. Hier is die verstek waardes vir \'n standaard sagtewarepakket wat gewoonlik gelewer kan word:</p>

<p>Verstek waardes is:</p>

<ul>
<li><b>GESKEP</b>: Die leweringsvoorwerp word as \'n koevert geskep, maar is leeg of in die proses om gevul te word.</li>

<li><b>BETA</b>: Die lewering is in beta, nie betroubaar vir produksie nie maar beskikbaar vir oop veldtoetse.</li>

<li><b>REGSTEL</b>: Die lewering het dele wat besig is om reggestel te word. Dit is \'n onderhoudstatus. Die pakket behoort nie gebruik te word nie.</li>

<li><b>VEROUDER</b>: Die leweringsinhoud word vir argivering gehou, maar bevat verouderde materiaal.</li>

<li><b>TOETS</b>: Die lewering beweeg deur die toetsprosedures.</li>

<li><b>VERPAKKING</b>: Die leweringsvoorwerp word met bykomstige inhoud, soos dokumentasie, voorbeelddata, demonstreerders en tutoriale, voltooi.</li>

<li><b>REVISIE</b>: Die leweringsinhoud word deur beoordeelaars bestudeer.</li>

<li><b>STABIEL</b>: Die lewering is stabiel en beskikbaar vir aflewering.</li>

</ul>';
$string['deliv_to_miles_help'] = '<p>\'n Mylpaal kan aan \'n lewering toegeken word, soos met \'n taak.
Toegekende lewerings impliseer dat indienings (stap 2) sal
gedoen moet word voordat die mylpaal verby is.</p>';
$string['deliverable'] = 'Lewering';
$string['deliverables'] = 'Lewerings';
$string['deliverablesrate'] = 'Lewering dekkingstarief';
$string['deliverableswithbindings'] = 'Lewerings met bindings';
$string['delivered'] = 'Gelewer';
$string['delivlinks'] = 'Geassosieerde lewerings';
$string['delivtitle'] = 'Leweringstitel';
$string['demomode'] = 'Demo-modus (gas kan wysig)';
$string['demomode_help'] = '<p>Hierdie spesifieke demonstrasiemodus word geaktiveer deur die module-
konfigurasie wanneer gastewysiging toegelaat word.</p>

<p>Gas sal slegs in die "alle gebruikers"-werksplek kan skryf,
en sal slegs uiteindelike uitdruklik gegroepeerde werkspasies kan besigtig.</p>

<p>Gaste sal net soos studente deur die wysigingsreëls geaffekteer word,
wat in die modulekonfigurasie vir elke entiteit opgestel is.</p>';
$string['demomodeclosedproject'] = 'Demo-modus (Geslote projek. Geen wysiging)';
$string['department'] = 'Departement';
$string['description'] = 'Beskrywing';
$string['detail'] = 'Besonderhede';
$string['difficult'] = 'Moeilik';
$string['difficultdesc'] = 'Sal \'n moeilike deel wees om te maak of te verkry';
$string['disableedit'] = 'Versper wysiging';
$string['documenting'] = 'Dokumentasie';
$string['documentingdesc'] = 'Dokumentasie word geskryf.';
$string['domains'] = 'Kwalifiseerders';
$string['done'] = 'Klaar';
$string['done_help'] = '<p>Hierdie kwalifiseerder dui aan hoeveel van \'n taak voltooi is,
(0 tot 100-skaal). Aanduiders van voltooiing word deur die hele datamodel
versprei, om voltooiingsintese te verrig waar dit ook al moontlik is.</p>';
$string['down'] = 'Laer';
$string['editcriteria'] = 'Wysig hierdie kriterium';
$string['editheading'] = 'Wysig opskrif';
$string['emptyproject'] = 'Ledig projek';
$string['enablecvs'] = 'Ontsper CVS-beheer';
$string['enablecvs_help'] = '<p>Indien ontsper, sal onderwyser toegang hê tot die
afstand-CVS-beheerpaneel.</p>

<p>Die afstand-CVS-beheerfunksie (stap 2) laat Moodle toe om
bewaarareabestuur binne \'n CVS-afstandsbediener te lei. Die projekbestuurder
sal die skep en uitwis van bewaareareas toelaat, sodat elke werkspasie
met sy eie projekhulpmiddel-bewaararea geassosieer kan word.</p>';
$string['enableedit'] = 'Ontsper wysiging';
$string['endofproject'] = 'Projek het geëindig';
$string['entities'] = 'Hoofentiteite';
$string['environment'] = 'Omgewing';
$string['errordeliverable'] = 'Fout in lewerings';
$string['errorfatalaction'] = 'Fatale Fout: Onbekende Aksie: {$a}';
$string['errormilestone'] = 'Fout in mylpale';
$string['errornovalidatingentity'] = 'Geen entiteit is ontsper wat teenoor validasies kan open nie';
$string['errorrequirement'] = 'Fout in vereistes';
$string['errorspecification'] = 'Fout in spesifikasies';
$string['errortask'] = 'Fout in take';
$string['essential'] = 'Noodsaaklik';
$string['essentialdesc'] = 'Eenvoudig noodsaaklik';
$string['evaluatingfor'] = 'Evaluasie vir:';
$string['evaluatingforusers'] = 'Evaluasie vir studente';
$string['event_deliv_created'] = 'Nuwe lewering';
$string['event_deliv_deleted'] = 'Lewering is bygewerk';
$string['event_deliv_updated'] = 'Lewering is bygewerk';
$string['event_delivs_cleared'] = 'Alle lewerings is skoongemaak';
$string['event_delivs_mutated'] = 'Sommige lewerings het gemuteer';
$string['event_grade_updated'] = 'Punt is bygewerk';
$string['event_mile_created'] = 'Nuwe mylpaal';
$string['event_mile_deleted'] = 'Mylpaal is bygewerk';
$string['event_mile_updated'] = 'Mylpaal is bygewerk';
$string['event_miles_cleared'] = 'Alle mylpale is skoongemaak';
$string['event_miles_mutated'] = 'Sommige mylpale het gemuteer';
$string['event_requ_created'] = 'Nuwe vereiste';
$string['event_requ_deleted'] = 'Taak is bygewerk';
$string['event_requ_updated'] = 'Taak is bygewerk';
$string['event_requs_cleared'] = 'Alle vereistes is skoongemaak';
$string['event_requs_mutated'] = 'Sommige vereistes het gemuteer';
$string['event_spec_created'] = 'Nuwe spesifikasie';
$string['event_spec_deleted'] = 'Spesifikasie is bygewerk';
$string['event_spec_updated'] = 'Spesifikasie is bygewerk';
$string['event_specs_cleared'] = 'Alle spesifikasies is skoongemaak';
$string['event_specs_mutated'] = 'Sommige spesifikasies het gemuteer';
$string['event_task_created'] = 'Nuwe taak';
$string['event_task_deleted'] = 'Taak is bygewerk';
$string['event_task_updated'] = 'Taak is bygewerk';
$string['event_tasks_cleared'] = 'Alle take is skoongemaak';
$string['event_tasks_mutated'] = 'Sommige take het gemuteer';
$string['evident'] = 'Klaarblyklik';
$string['evidentdesc'] = 'Triviale funksie. Binne \'n sekonde gedoen.';
$string['exportallforcurrentgroup'] = 'Voer die hele projek van die huidige groep in suiwer XML uit';
$string['exportheadingtoXML'] = 'Voer projekbeskrywing in XML uit';
$string['exports'] = 'Voer funksies uit';
$string['features'] = 'Funksies';
$string['feb'] = 'Feb.';
$string['february'] = 'Februarie';
$string['fix'] = 'Regstelling';
$string['fixdesc'] = 'Wees versigtig, hierdie hulpbron kan bekende foute bevat';
$string['fixingforeignkeys'] = 'Herberekening van vreemde sleutels';
$string['freecriteria_help'] = '<p>Hierdie kriteriastel is globaal op die algehele werk van toepassing. Die
projek kan teen \'n stel kwantifiseerbare metings geassesseer word.
Die kriteriastel, wanneer gebruik, word vir al die studente in die
projekopsomming gepubliseer.</p>';
$string['freecriteriaset'] = 'Kriteriastel vir globale evaluasie';
$string['from'] = 'Van:';
$string['fromtasks'] = 'Vanaf take';
$string['fullfillselected'] = 'Ten volle volledige seleksie';
$string['gantt'] = 'Gantt';
$string['ganttchart'] = 'Gantt-diagram';
$string['gettheprojectfulldocument'] = 'Verkry die volledige projekdokument';
$string['givedetail'] = 'Sien gedetailleerde kopieverslag';
$string['giveonefinalgrade'] = 'Gee \'n enkele, finale punt';
$string['giveonefinalgrade_help'] = '<p>Wanneer ontsper, sal die projekmodule \'n enkele punt per gebruiker vir die gebruiker se notaboek in Moodle bereken. Die punt word bereken
volgens die kriteriasteldefinisie. Dieselfde punt word aan al die deelnemers in dieselfde groep versprei (stap 1).</p>

<p>Stap 2: \'n Addisionele punt per gebruiker kan by die puntestel gevoeg word.</p>';
$string['giveurl'] = 'Gee \'n afstand-url aan aflaaibare hulpbron';
$string['globalevaluators'] = 'Globale evalueerders';
$string['goodie'] = 'Lekker';
$string['goodiedesc'] = 'Dit lyk asof dit \'n lekker een gaan wees';
$string['grade'] = 'Punt';
$string['grades'] = 'Punte';
$string['grading'] = 'Gradering';
$string['groupapplytemplate'] = 'Templaattoepassing op die groep';
$string['groupcopy'] = 'Groepoperasie: kopieer';
$string['groupcopymovewarning'] = 'Waarskuwing: die kopiëring van elemente tussen entiteitbome kopieer slegs abstrak en beskrywing. Ander kwalifiserende waardes gaan verlore.';
$string['groupdeleteitems'] = 'Groepoperasie: wis uit';
$string['grouped'] = 'Groepe (studentwerkspasie)';
$string['groupexport'] = 'Groepuitvoer na XML';
$string['groupfullfill'] = 'Volvoer voltooiing van die groep';
$string['groupless'] = 'Uit groep (verstek werkspasie)';
$string['groupmove'] = 'Groepoperasie: beweeg';
$string['groupname'] = 'Groepnaam';
$string['groupoperations'] = 'Groepoperasies';
$string['groupxmlexport'] = 'Groepoperasie: XML-uitvoer';
$string['guestsallowed'] = 'Laat gaste toe om te sien';
$string['guestsallowed_help'] = '<p>Wanneer hierdie opsie ontsper word, kan gaste binne die projek se werkspasies rondblaai. Gaste word toegelaat om die "verstek
werkspasie" te sien wat vir die groepmodus gedefinieer is. Ander situasies word hieronder opgesom:</p>

<ul>
<li>GEEN GROEPE<br>
<br>
Wanneer opsie ontsper is, kan gaste binne die verstek werkspasie rondblaai, met of sonder wysigingsvermoëns. (sien <a href=
"help.php?module=techproject&amp;file=guestscanuse.html&amp;forcelang=fr_utf8"> </a>).</li>

<li>SIGBARE GROEPE<br>
<br>
Wanneer opsie ontsper is, kan gaste in alle werkspasies rondblaai, en kan hulle wysigingsvermoëns op verstek werkspasies hê (sien <a href=
"help.php?module=techproject&amp;file=guestscanuse.html&amp;forcelang=fr_utf8">
</a>).</li>

<li>APARTE GROEPE<br>
<br>
Wanneer opsie ontsper is, kan gaste slegs in verstek werkspasie rondblaai en beskik hulle nie oor enige wysigingsvermoëns nie.</li>
</ul>

<p>In alle gevalle, wanneer die opsie versper is, word die gas teruggedryf na kursusaansig.</p>';
$string['guestscanuse'] = 'Laat gaste toe om te gebruik (demo)';
$string['guestscanuse_help'] = '<p>Jy kan \'n gas toelaat om sekere data op die verstek werkspasie (buite die groep) te wysig. Dit is beperk tot demo\'s en vereis dat groepe
versper of sigbaar is.</p>

<p>Gaste word net soos studente beperk deur die "entiteit vir entiteit" helpers in die modulekonfigurasie.</p>';
$string['guestspermissions'] = 'Toestemmings vir gaste';
$string['halfdays'] = 'Halfdae';
$string['hard'] = 'Moeilik';
$string['harddesc'] = 'Kompleks, kan goed elders breek.';
$string['haveassignedtasks'] = 'Het {$a} taak/take toegeken';
$string['haveownedtasks'] = 'Besit {$a} taak/take';
$string['haveuncompletedtasks'] = 'Het {$a} taak/take om te voltooi';
$string['headings'] = 'Opskrifelemente';
$string['heavy'] = 'Kompleks';
$string['heavydesc'] = 'Sal \'n swaar werk benodig';
$string['heavyness'] = 'Geloofwaardigheid';
$string['heavyness_help'] = '<p>Die swaarheid is die berekening van die moeilikheidsgraad om die vereiste aan die klant te verskaf.</p>
<p>Hierdie meting is anders as die kompleksiteit, wat feitelike inligting oor die funksie verskaf nadat die analise gedoen is.
Die swaarheid mag moontlik nie presies weet watter oplossing beskikbaar is wat aan die vereiste kan voldoen nie,
maar sal die vaardigheid van skatting op grond van ervaring uitdruk.</p>';
$string['hideall'] = 'Versteek alles';
$string['high'] = 'Hoog';
$string['highdesc'] = 'Hoog';
$string['horizontalscale'] = 'Horisontale skaalfaktor';
$string['hours'] = 'Ure';
$string['hurryup'] = 'Jy bestee dalk meer tyd as wat toegelaat word';
$string['implicit'] = 'KAN MOONTLIK';
$string['implicitdesc'] = 'Nie uitdruklik genoem nie, maar voor die hand liggend.';
$string['import'] = 'Voer in';
$string['importdata'] = 'Voer data in';
$string['importdata_help'] = '<p>Hierdie funksie sal die invoer van \'n volledige entiteitboom uit \'n CSV-dokument toelaat.<p>

<p>Die eerste lyn van die dokument moet kolomname verskaf. \'n Kommapunt ";" word vereis. Die inhoud moet in UTF-8 geënkodeer wees.</p>

<h4>Verpligtende elemente</h4>

<p>Die CSV-dokument moet verpligte inligting verskaf:</p>
<ul>
<li><b>"id":</b> rekordidentifiseerder. \'n Arbitrêre identifikasie, wat ook al die formaat, gevolg deur \'n unieke kode.</li>
<li><b> "moeder":</b> identifiseer \'n terugwaartse afhanklikheid met behulp van die primêre identifiseerders. Die dokument moet dus volgens die vertakkingsontwikkeling gesorteer word. Waardes vir moeder kan wees:
<ul>
<li>0 : Stamvlaktoegang</li>
<li>\'n Primêre identifiseerder ("id"-kolom): moederverwysing.</li>
</ul>
<li><b>"beskrywing":</b> Tekstuele beskrywing van entiteit. As geen abstrak verskaf is nie, sal die beskrywing verkort word om as abstrak te dien.</li>
</ul>

<h4>Algemene opsionele elemente</h4>

<p>\'n Addisionele kolom is algemeen vir al vier entiteite.</p>
<ul>
	<li><b>"abstrak":</b> Definieer \'n opskrif vir die entiteit</li>
</ul>

<h4>Spesifieke opsionele elemente</h4>

<p>Sekere spesifieke inligting kan in entiteite (kwalifiseerders) bygevoeg word.</p>';
$string['imports'] = 'Voer funksies in';
$string['importsexports'] = 'Voer in/uit';
$string['impossible'] = 'Onmoontlik';
$string['impossibledesc'] = 'Regtig nie moontlik nie, ons wens ook dit was';
$string['installing'] = 'Installeer/ontplooiing';
$string['installingdesc'] = 'Installeer/ontplooiing';
$string['introformat'] = 'Formatteer';
$string['introtechproject'] = 'Beskrywing';
$string['invaliddates'] = 'Ongeldige Datums';
$string['invalidobject'] = 'Ongeldige Voorwerp';
$string['investigating'] = 'Ondersoek';
$string['investigatingdesc'] = 'Ondersoek word gedoen, inligting word verkry en oplossingopsies word beskou';
$string['investigation'] = 'Ondersoek';
$string['itemcriteriaset'] = 'Kriteria gestel vir items wat gegradeer kan word';
$string['itemcriteriaset_help'] = '<p>Hierdie kriteriastel is van toepassing op individuele assesseerbare elemente (d.w.s. een punt per assesseerbare element). Alle assesseerbare elemente
sal dieselfde kriteriasteldefinisie deel.</p>

<p>In stap 1 is slegs gedateerde mylpale toeganklik. Stap 2 sal die definiëring van assesseerbaarheid van enige entiteitseenheid toelaat.</p>';
$string['itemevaluators'] = 'Evalueerders van itemomvang';
$string['jan'] = 'Jan.';
$string['january'] = 'Januarie';
$string['jul'] = 'Jul.';
$string['july'] = 'Julie';
$string['jun'] = 'Jun.';
$string['june'] = 'Junie';
$string['label'] = 'Etiket';
$string['label_help'] = '<p>Die etiket definieer die sigbare teks in die GUI wanneer kriteria aan gebruikers vertoon word.</p>';
$string['leaves'] = 'Gradering van Eindpuntnodusse';
$string['leaves_help'] = '<p>"Doeltreffende" entiteite is dié wat nie in subentiteite (eindpuntnodusse) verdeel word nie. Dit is "terminale" elemente van die projek,
d.w.s. elemente wat \'n "doeltreffende" werk om te verrig aanwys.</p>

<p>As voorbeeld, as taak A in twee take, take B en C, verdeel word, sal die uitvoer van B en C A verwesenlik. Die regte werk wat gedoen moet word,
is dit wat deur B en C gedefinieer is. Hier kom ons tot die gevolgtrekking dat daardie take "doeltreffend" is.</p>

<p>Hierdie definisie kan veralgemeen word tot die hele entiteitstel wat deur die projekbestuurder bestuur word. Finale vereistes kan ook
as "doeltreffend" gekwalifiseer word, dus sal dit dié wees waarop die finale leweringskontrole se visier sal konsentreer.</p>';
$string['left'] = 'Verhoog een vlak';
$string['light'] = 'Hoog';
$string['lightdesc'] = 'Hoog';
$string['load'] = 'Projekinvoer/-uitvoer';
$string['loadcustomcsssheet'] = 'Laai doelgemaakte CSS';
$string['loadcustomxslsheet'] = 'Laai die XSL-filter';
$string['makedocument'] = 'Lê die dokument voor';
$string['mandatory'] = 'Verpligtend';
$string['mandatorydesc'] = 'Ons kan ons nie die projek daarsonder voorstel nie.';
$string['mar'] = 'Mrt.';
$string['march'] = 'Maart';
$string['markasdoneselected'] = 'Merk as voltooi (100%)';
$string['markastemplate'] = 'Merk as templaat';
$string['mastertasks'] = 'Bemeester take';
$string['may'] = 'Mei';
$string['mean'] = 'Gemiddeld';
$string['mediatizing'] = 'Inlywing';
$string['mediatizingdesc'] = 'Illustrasie en inlywing van inhoud';
$string['medium'] = 'Medium';
$string['mediumdesc'] = 'Nie baie werk nie, maar die hande sal vuil gemaak moet word';
$string['milestone'] = 'Mylpaal';
$string['milestonedeadline_help'] = '<p>Daar kan \'n spertyd aan \'n mylpaal gegee word.</p>

<p>As hierdie spertyd ontsper is, word die gedateerde mylpaal \'n "amptelike" fase van die aktiwiteitsmodule, en kan die assesseringstrategie
gebruik word om laat aanwysers mee te bereken.</p>

<p>Spertyd kan nie gestel word voordat die projek begin nie, en ook nie die projek se einde oorheers nie. Projekeinde word as \'n ingeboue fase beskou,
bykomend tot enige gedateerde mylpaal.</p>

<p>Omdat die lysvolgorde in die GUI \'n ergonomiese fasiliteit is, word die konsistensie van spertydvolgorde nie geverifieer wanneer
mylpale op of af geskuif word nie. Stap 2 sal die sein aangaande sulke teenstydighede versterk.</p>';
$string['milestones'] = 'Mylpale';
$string['milestonetitle'] = 'Mylpaalnaam';
$string['missing'] = 'Ontbreek';
$string['modulename'] = 'Tegniese Projek';
$string['modulenameplural'] = 'Tegniese Projekte';
$string['moveselected'] = 'Skuif geselekteerde items';
$string['must'] = 'MOET';
$string['mustdesc'] = 'Dit móét daar wees. Onmoontlik!';
$string['mygroupsadvice'] = 'My groepe';
$string['nc'] = 'N.C.';
$string['needsmoreinfo'] = 'Benodig meer inligting';
$string['needsmoreinfodesc'] = 'Benodig meer inligting om te evalueer';
$string['needswork'] = 'Om te ontwikkel';
$string['needsworkdesc'] = 'Benodig werk om te verskaf';
$string['newvalueformfor'] = 'Nuwe waarde vir {$a}';
$string['next'] = 'Volgende';
$string['noassignee'] = 'Geen toegewysde';
$string['noassignees'] = 'Geen toegewysde';
$string['nodelivassigned'] = 'Geen lewering is toegewys nie.';
$string['nodeliverables'] = 'Geen lewering';
$string['nogroup'] = 'Uit groep (verstek)';
$string['nomilestone'] = 'Geen toegewysde mylpaal nie';
$string['nomilestones'] = 'Geen pylpaal nie';
$string['none'] = 'Geen';
$string['nonedesc'] = 'Geen';
$string['noonetoassess'] = 'Geen studente in hierdie groep hier nie. Geen assessering om te versprei nie.';
$string['noprojects'] = 'Daar is geen projekte nie';
$string['norequassigned'] = 'Geen vereiste is toegewys nie.';
$string['norequirements'] = 'Geen vereiste nie';
$string['noscale'] = 'Geen skaal (numeriese gradering)';
$string['nospecassigned'] = 'Geen spesifikasie is toegewys nie.';
$string['nospecifications'] = 'Geen spesifikasie nie';
$string['notaskassigned'] = 'Geen taak is toegewys nie';
$string['notasks'] = 'Geen taak is gedefinieer nie';
$string['notaskunassigned'] = 'Geen taak is nié toegewys nie';
$string['notevaluated'] = 'Nie geëvalueer nie';
$string['notifynewdeliv'] = 'Nuwe projeklewering';
$string['notifynewmile'] = 'Nuwe projekmylpaal';
$string['notifynewrequ'] = 'Nuwe projekvereiste';
$string['notifynewspec'] = 'Nuwe projekspesifikasie';
$string['notifynewtask'] = 'Nuwe taak ingevoer';
$string['notifyreleasedtask'] = 'Taak nie toegewys nie';
$string['notimplementedyet'] = 'Nie in hierdie vrystelling beskikbaar nie';
$string['notingroup'] = 'Die verstellings van hierdie module laat nie toe dat ongegroepeerde studente die projekmateriaal gebruik nie. Kontak asseblief jou onderwyser om aan \'n groep toegewys te word.';
$string['notprioritary'] = 'Nie prioriteit nie';
$string['notprioritarydesc'] = 'Kan ná ander werk gedoen word, maar sal help';
$string['notsubmittedyet'] = 'Nog nie ingedien nie.';
$string['nov'] = 'Nov.';
$string['novalidationsession'] = 'Ongeldige sessie';
$string['novaluesindomain'] = 'Geen waardes is in hierdie domein van toepassing nie. Globale gedeelde waardes is by verstek van toepassing. As jy \'n waarde hier byvoeg, sal al die gedeelde waardes oorheengeskryf word.';
$string['november'] = 'November';
$string['obsolete'] = 'Verouder';
$string['obsoletedesc'] = 'Hierdie pakket of hulpbron is of kan moontlik verouder wees';
$string['oct'] = 'Okt.';
$string['october'] = 'Oktober';
$string['of'] = 'van';
$string['optional'] = 'Opsioneel';
$string['optionaldesc'] = 'daar is \'n ander manier om dit te doen, maar dit is minder prakties of doeltreffend.';
$string['organisation'] = 'Organisasie';
$string['oruploadfile'] = 'of laai \'n dokument op';
$string['other'] = 'Ander';
$string['otherdesc'] = 'Ander taaktipe';
$string['outofreason'] = 'Buite rede';
$string['outofreasondesc'] = 'Dit is haalbaar, maar pragmaties buite rede';
$string['over'] = 'oor';
$string['overdone'] = 'Oorvleuel';
$string['overoverdone'] = 'Het oorvleuel ...';
$string['owner'] = 'Eienaar';
$string['packaging'] = 'Word verpak';
$string['packagingdesc'] = 'Verpakking, finalisering van grafiese apparate, finale dokumente, installeerders, implementeringsinstrumente, maak pakkette vir aflewering en aflaai.';
$string['parent'] = 'Moeder';
$string['perth'] = 'Perth-grafiek';
$string['phase'] = 'Fase';
$string['phaseend'] = 'Projek gaan binnekort eindig';
$string['phaseover'] = 'Projek is gesluit';
$string['phasestart'] = 'Projek het nog nie begin nie';
$string['planned'] = 'Is beplan';
$string['planneddesc'] = 'Taak is nie begin nie, maar is geregistreer';
$string['pluginadministration'] = 'Projekparameters';
$string['pluginname'] = 'Tegniese Projek';
$string['plus'] = 'EKSTRA';
$string['plusdesc'] = 'Wel, iets wat geensins verwag is nie, maar dit is uiters gaaf!';
$string['preparingrestore'] = 'Herstel word gereedgemaak';
$string['previous'] = 'Vorige';
$string['prioritary'] = 'Prioriteit';
$string['prioritarydesc'] = 'Prioriteit nadat dringende werk gedoen is.';
$string['priority'] = 'Prioriteit';
$string['priority_help'] = '<p>Hierdie kwalifiseerder laat die stel van \'n prioriteit van \'n spesifikasie toe. Prioriteit sal \'n invloed hê op die taakitems wat aan hierdie spesifikasies toegeken is. Prioriteit en hewigheid is verskillende kwalifiseerders, aangesien \'n spesifikasie met lae hewigheid (d.w.s.
belangrik in die finale lewering) \'n hoë prioriteit kan hê, omdat dit betrokke is by \'n stel dringende verwesenlikings.</p>';
$string['project'] = 'Projek';
$string['projectchangeddeliverable'] = 'Veranderinge in lewerings';
$string['projectchangedmilestone'] = 'Veranderinge in mylpale';
$string['projectchangedrequ'] = 'Veranderinge in vereistes';
$string['projectchangedspec'] = 'Veranderinge in spesifikasies';
$string['projectchangedtask'] = 'Veranderinge in taaklys';
$string['projectcopy'] = 'Kopieer en vee projek uit';
$string['projectelements'] = 'Projekelemente';
$string['projectend'] = 'Projekeinde';
$string['projectendevent'] = 'Projek {$a} eindig';
$string['projectis'] = 'Projek is:';
$string['projectisover'] = 'Projek is verby. Jy kan dit nie meer wysig nie!';
$string['projectproject'] = 'Projekaktiwiteite';
$string['projectscope'] = 'Plaaslike kwalifiseerders vir die projek';
$string['projectstart'] = 'Projekaanvang';
$string['projectstartevent'] = 'Projek {$a} begin';
$string['projecttitle'] = 'Projektitel';
$string['qualifiers'] = 'Kwalifiseerders';
$string['quoted'] = 'Geskatte onkoste';
$string['quoted_help'] = '';
$string['quoting'] = 'Kwotering/Evaluasie';
$string['quotingdesc'] = 'Kwotering/Evaluasie';
$string['rationale'] = 'Rasionaal';
$string['realwork'] = 'Doeltreffende werk:';
$string['recalculate'] = 'Herbereken alle aanwysers';
$string['redirectingtoview'] = 'Herlei na aansig';
$string['refused'] = 'Geweier';
$string['regression'] = 'Regressie';
$string['requirement'] = 'Vereiste';
$string['requirementriskcalculation'] = 'Vereiste risikoberekening is afhanklik van beide Kragtigheid en Gewig-kwalifiseerders. \'n Sterk en swaar vereiste sleep die projek na die gevaarsone, d.w.s. \'n sone waar die risiko om nie te lewer nie, kan toeneem weens die opeenhoping van ongunstige faktore. Vereistes wat meer inligting benodig, word geïgnoreer. \'n Vereiste \\"buite rede\\" verhoog die risiko op die gewig-as drasties.';
$string['requirements'] = 'Vereistes';
$string['requirementsrate'] = 'Dekkingskoers van vereistes';
$string['requirementswithbindings'] = 'Vereistes met bindings';
$string['requirementtitle'] = 'Vereistetitel';
$string['requlinks'] = 'Geassosieerde vereistes';
$string['resetproject'] = 'Projekdata word uitgewis';
$string['resetting_courseproject'] = 'Kursusvlak projekdata word uitgewis';
$string['resetting_criteria'] = 'Kriteria vir die assessering en punte word uitgewis';
$string['resetting_grades'] = 'Alle assesseringsdata word uitgewis';
$string['resetting_groupprojects'] = 'Alle groepvlakdata en alle assesserings word uitgewis';
$string['restoringandfixingfiles'] = 'Die dokumentstelsel word herstel en reggemaak';
$string['restoringcriteria'] = 'Kriteria word herstel';
$string['restoringdefaultprojectdata'] = 'Verstek projekdata word herstel';
$string['restoringqualifiers'] = 'Plaaslike kwalifiseerders word herstel';
$string['restoringuserprojectdata'] = 'Gebruikerprojekdata word herstel';
$string['review'] = 'Word hersien';
$string['reviewing'] = 'Word hersien';
$string['reviewingdesc'] = 'Kode, hulpbronne of dokumente word hersien. Word geharmonieer';
$string['right'] = 'Gaan een vlak laer';
$string['risk'] = 'Risikofaktore';
$string['rootnode'] = '-- Stamvlak';
$string['save'] = 'Berg';
$string['savechanges'] = 'Berg veranderinge';
$string['scale'] = 'Skaal';
$string['scheduled'] = 'Geskeduleer';
$string['scheduleddesc'] = 'Taak is vir \'n bekende datum geskeduleer, maar is nie begin nie';
$string['seecapabilitysettings'] = 'Besigtig rolle en vermoëverstellings';
$string['seedetail'] = 'Sien besonderhede';
$string['selectall'] = 'Kies alles';
$string['selectanobjectfirst'] = 'Kies eerste \'n voorwerp';
$string['sep'] = 'Sept.';
$string['september'] = 'September';
$string['severity'] = 'Hewigheid';
$string['severity_help'] = '<p>Hierdie kwalifiseerder kwalifiseer die hewigheid van \'n spesifikasie, d.w.s. die belangrikheid daarvan in die finale aflewering.</p>

<p>\'n Hewige spesifikasie sal sommige lewerings produseer wat hoogs verwag word. Hierdie eienskappe is sentrale oogmerke van die
projek self. Hewigheid word gewoonlik gekoppel aan die kragtigheid wat aan die toepaslike vereistes gegee is. Maar in sommige gevalle kan hewigheid egter \'n tegniese aanbeveling wees, weens sorg vir die finale klant.</p>

<p>Minder hewige spesifikasies sal steeds onderhandelbaar wees, alhoewel die gebrek daaraan altyd die finale lewering na
\'n laer kwaliteit sal trek.</p>';
$string['sharedocumentwithexterns'] = 'URL om met niegeregistreerde gebruikers te deel: {$a}';
$string['sharedscope'] = 'Globale kwalifiseerders (by verstek gedeel)';
$string['sharethisdocument'] = 'Deel hierdie dokument met eksterne mense met die volgende url:</br> {$a}';
$string['should'] = 'BEHOORT';
$string['shoulddesc'] = 'Ons sou graag wou hê dat jy dit kry, maar dit is steeds onderhandelbaar';
$string['showcost'] = 'Vertoon kostekwotasies';
$string['showdetails'] = 'Vertoon besonderhede';
$string['showrisk'] = 'Vertoon risikoëvaluasie';
$string['simple'] = 'Eenvoudig';
$string['simpledesc'] = '\'n Bietjie werk, maar maklik gedaan';
$string['singularentries'] = 'Doeltreffende inskrywings';
$string['slavetasks'] = 'Slaaftake';
$string['sortbydate'] = 'Sorteer volgens datum';
$string['spec_to_req'] = 'Spesifikasie vir vereistetoewysings';
$string['spec_to_req_help'] = '<p>Hierdie selektorkaarte se huidige spesifikasie van tersaaklike vereistes, volgens die volgende semantiek.</p>

<p><i>"Spesifikasie X is \'n beskrywing van die funksionele en/of tegniese oplossing wat die vereiste Y volvoer"</i></p>

<p>Hier is die seleksie veelvuldig: \'n Ongedetailleerde spesifikasie kan \'n hele stel vereistes volvoer, bv. die spesifisering van die bestaan van
\'n validasie-eenheid kan aanleiding tot die volgende prestasies gee:</p>

<ol>
<li>gebruikeridentiteitsvereiste.</li>

<li>intekening-/wagwoordvalidasie.</li>

<li>rolabstraksiedefinisie.</li>
</ol>

<p>Omgekeerd kan \'n stel gedetailleerde spesifikasies nodig wees om \'n minder gedetailleerde vereiste te beskryf.</p>';
$string['spec_to_reqs'] = 'Spesifikasie van vereistetoewysing';
$string['spec_to_reqs_help'] = '';
$string['specification'] = 'Spesifikasie';
$string['specifications'] = 'Spesifikasies';
$string['specificationswithbindings'] = 'Spesifikasies met bindings';
$string['specifying'] = 'Spesifikasies';
$string['specifyingdesc'] = 'Skryfspesifikasies';
$string['speclinks'] = 'Geassosieerde spesifikasies';
$string['spectitle'] = 'Spesifikasietitel';
$string['spectoreq'] = 'Toegewysde vereistes';
$string['spent'] = 'Onkoste spandeer';
$string['stable'] = 'Stabiel';
$string['stabledesc'] = 'Stabiele pakket, produksie ontsper';
$string['started'] = 'Is begin';
$string['starteddesc'] = 'Ons werk aan die monster';
$string['status'] = 'Status';
$string['status_help'] = '<p>Hierdie kwalifiseerder toon in watter toestand die taak is. Die taak se lewensiklus sal plaasvind en verander van toestand tot toestand. In stap 1 is taakstatusverandering gratis.</p>

<p>Die verstek status kan verander word deur die databasis te verander, of om \'n nuwe waardestel vir daardie projekeksemplaar te stel.</p>

<p>Verstek waardes is:</p>

<ul>
<li><b>BEPLAN:</b> taak is geskeduleer (met of sonder datums).</li>

<li><b>HET BEGIN:</b> taak is aan die werk.</li>

<li><b>GEBLOK:</b> iets ekstern blokkeer ons werk. Ons wag vir probleemoplossing.</li>

<li><b>VERTRAAG:</b> ons het besluit om ons werk vir hierdie taak tydelik te staak.</li>

<li><b>VOLTOOI:</b> taak is voltooi. Geen verdere werk om te doen nie.</li>
<li><b>AFGEGOOI:</b> taak is verby. Geen verdere werk om te doen nie en die uitslag is nie beduidend nie.</li>
</ul>

<p>Stap 2 kan formele "werksvloei"-eienskap vir die bestuur van taak-lewensiklusbeheer byvoeg.</p>';
$string['strengh_help'] = '<p>Hierdie kwalifiseerder laat \'n mate van definisie van die "kragtigheid" van \'n vereiste toe, d.w.s. die hoeveelheid waarde wat die klant aan
hierdie vereiste heg.</p>

<p>Sterk vereistes sal ononderhandelbare dele van die projek wees. Dit is gewoonlik sentrale onderwerpe waarvoor die projek
gelanseer word.</p>

<p>Minder gewigtige vereistes kan onderwerp word aan verandering of selfs onderhandeling, indien personeel of vaardighede onvoldoende voorkom
nadat daar met \'n projek begin is.</p>';
$string['strength'] = 'Kragtigheid';
$string['strength_help'] = '<p>Kragtigheid is die mate van belangrikheid van die vereiste vir die klant.</p>';
$string['studentscanchange'] = 'Studente kan verander ...';
$string['sublinks'] = 'Afhanklikhede';
$string['summary'] = 'Opsomming';
$string['summaryforproject'] = 'Opsomming van projek:';
$string['task'] = 'Taak';
$string['task_dependencys'] = 'oorkruistaakafhanklikhede';
$string['task_to_deliv'] = 'Lewerbaar aan taaktoewysings';
$string['task_to_deliv_help'] = '<p>Take word verrig met die doel om sommige konkrete dele van die projek se doelwit te produseer. Hierdie geïdentifiseerde produkte is
sogenaamde "lewerings".</p>

<p>Met hierdie selektor kan jy die lewerings waarvoor die huidige taak verantwoordelik is, aanwys.</p>

<p>Deur sulke enititeite te bind, laat jy toe dat sommige aanwysers deur die projekdatamodel versprei word, en laat byvoorbeeld toe dat die voltooiingskoers van sekere lewerings vertoon word op grond van taakvoltooiingsanalise.</p>';
$string['task_to_delivs'] = 'toewysing van lewerings aan take';
$string['task_to_miles'] = 'Taak tot mylpaal-binding';
$string['task_to_miles_help'] = '<p>\'n Mylpaal kan aan \'n taak toegewys word. Wanneer dit aan \'n mylpaal gebind word, word sekere beperkings op spertye bygevoeg. Die taak staan daarvoor bekend dat dit voltooi moet word VOORDAT die mylpaal verby is.</p>

<p>Implementering van Stap 2 sal meer akkurate beheer en konsekwentheidstoetse by die skedule voeg.</p>';
$string['task_to_spec'] = 'Opdragte volgens spesifikasies';
$string['task_to_spec_help'] = '<p>Taak kan aangewys word as die verwesenliking van \'n substel spesifikasies. \'n Enkele taak kan etlike spesifikasies verwesenlik,
indien dit eerder as \'n algemene taak gedefinieer word (bv. "maak die sagtewarekomponent" is \'n redelike ongedetailleerde taakdefinisie wat \'n
hele stel gedetaillerde spesifikasies vir daardie module kan verwesenlik). Omgekeerd, \'n stel take kan in die verwesenliking van \'n
enkele spesifikasie-invoer geïmpliseer word.</p>

<p>Hierdie selektor laat die binding van die huidige taak met etlike spesifikasie-invoere toe.</p>

<p>Deur sulke entiteite te bind, laat jy toe dat sommige aanwysers deur die projekdatamodel versprei word wat, byvoorbeeld, toelaat dat die voltooiingskoers van sommige spesifikasies vertoon word, gebaseer op taakvoltooiingsanalise.<p>';
$string['task_to_specs'] = 'toewysings van take aan spesifikasies';
$string['task_to_task'] = 'Taak-interafhanklikhede';
$string['taskalone'] = 'Alleenstaande taak';
$string['taskcircularitypost'] = 'kon nie geregistreer word nie: sirkulariteitsbeperking';
$string['taskcircularitypre'] = 'Die afhanklikheid van taak';
$string['taskdependency'] = 'Afhanklik van';
$string['taskdependency_help'] = '<p>Laat binding van taakafhanklikhede toe.</p>

<p>In \'n komplekse projek is \'n taak waarskynlik afhanklik van vorige werk wat voltooi word, omdat wat deur laasgenoemde geproduseer is,
in eersgenoemde betrokke is.</p>

<p>Die taakboom definieer subtake uitdruklik as die bemeestering van \'n supertaak, d.w.s. \'n supertaak kan slegs voltooi word
nadat alle subtake voltooi is. Dit definieer \'n vanselfsprekende afhanklikheidsbinding wat geen spesiale werk benodig nie. Dus sal die afhanklikheidsbindinglys slegs
take toon wat nie in dieselfde hiërargie-subboom is nie.</p>

<p>Die projekbestuurder word toegerus met is sirkulariteitopsporingsfunksie, wat sal verhoed dat sirkulêre afhanklikhede sal bind. In
die geval dat sirkulariteit of interafhanklikheid \'n doel het (in die werklikheid) sal ontwerpers \'n oorwegende rigting
vir afhanklikheid moet kies.</p>

<p>Sirkulariteit-vermyding sal ook verbied dat \'n subtaak afhanklik van enige van sy supertake is.</p>';
$string['taskend'] = 'Slaaftaak';
$string['taskenddate'] = 'Taakeinddatum';
$string['taskenddate_help'] = '<p>\'n Spertyd kan vir \'n taak gestel word. Hierdie spertyd MOET met die taakaanvangsdatum teenoor geskatte taaktydsduur ooreenstem.</p>

<ul>
<li>Indien die aanvangsdatum gedefinieer is, kan \'n spertyd nie voorkom voor die aanvangsdatum saam met die verwagte tydsduur bereken nie.</li>

<li>As die aanvangsdatum nie ontsper is nie, sal dit nietemin outomaties bereken word as spertyd minus die verwagte tydsduur (0
as verstek vir tydsduur).</li>

<li>As die taak aan \'n gedateerde mylpaal toegewys is, kan die spertyd nie die mylpaal se spertyd oorheers nie.</li>

<li>Spertyd kan nie die projek se einddatum oorheers nie.</li>
</ul>';
$string['taskendenable'] = 'Taakeinde ontsper';
$string['taskfinishesaftermilestone'] = 'Taak eindig nadat mylpaal eindig';
$string['taskfinishesbeforeitstarts'] = 'Taak eindig voor projek begin';
$string['taskfinishestoolate'] = 'Taak eindig nadat projek eindig';
$string['tasklinks'] = 'Geassosieerde take';
$string['taskmiddle'] = 'Middewegtaak';
$string['tasks'] = 'Take';
$string['taskstart'] = 'Meestertaak';
$string['taskstartdate'] = 'Taakaanvangsdatum';
$string['taskstartdate_help'] = '<p>\'n Aanvangsdatum kan aan \'n taak toegewys word. Hierdie datum sal gebruik word vir Gantt-werkkaartgenerasie (stap 2) en uitvoerbaarheidskontroles (stap 2)</p>

<p>In stap 1 sal die aanvangsdatum sekere kontroles moet ondergaan.</p>

<ul>
<li>Taak kan nie begin ná die mylpaal se sperdatum minus die verwagte tydsduur nie, indien die huidige taak aan \'n gedateerde
mylpaal toegewys is.</li>

<li>Taak kan nie begin nadat projek eindig nie (minus verwagte tydsduur).</li>

<li>Taak kan nie begin voordat projek begin nie.<li>
</ul>';
$string['taskstartenable'] = 'Taakaanvang ontsper';
$string['taskstartsaftermilestone'] = 'Taak kan nie in hierdie mylpaal uitgevoer word nie';
$string['taskstatus'] = 'Taaktoestand';
$string['taskswithbindings'] = 'Taak met bindings';
$string['tasktitle'] = 'Taaktitel';
$string['tasktodeliv'] = 'Lewering aan taakbindings';
$string['tasktoolate'] = 'Taak begin nadat projek eindig';
$string['tasktooshort'] = 'Taak is te kort. Beplande tydsduur pas nie binne aanvang- en einddatumomvang nie.';
$string['tasktoosoon'] = 'Taak begin voordat projek begin.';
$string['tasktospec'] = 'Toegewysde spesifikasies';
$string['teachergrade'] = 'Onderwyser punt';
$string['teacherstools'] = 'Onderwyser se hulpmiddels';
$string['teacherusescriteria'] = 'Onderwyser gebruik kriteria';
$string['teacherusescriteria_help'] = '<p>Wanneer hierdie opsie ontsper is, sal die assessering van die projek \'n kriteriastel wat deur \'n onderwyser gedefinieer is, gebruik.</p>

<p>Onderwysers sal die kriteria opstel met \'n toepaslike paneel in die "onderwyser se hulpmiddels"-afdelings.</p>

<p>Kriteria kan gewysig word selfs nadat assesserings begin het. Die uitwis van \'n kriterium sal die vorige punte daarvoor in alle geassesseerde werkspasies uitwis.</p>';
$string['techproject'] = 'Tegniese projek';
$string['techproject:addinstance'] = 'Voeg \'n projek by';
$string['techproject:beassignedtasks'] = 'Word take toegewys';
$string['techproject:canattachfiles'] = 'Kan dokumente aanheg';
$string['techproject:canbeevaluated'] = 'Word geëvalueer';
$string['techproject:changedelivs'] = 'Wysig lewerings';
$string['techproject:changemiles'] = 'Definieer mylpale';
$string['techproject:changenotownedtasks'] = 'Verander take (binne groep) wat geen eienaar het nie';
$string['techproject:changerequs'] = 'Wysig spesifikasies';
$string['techproject:changespecs'] = 'Wysig projekvereistes';
$string['techproject:changetasks'] = 'Wysig en verander take';
$string['techproject:configure'] = 'Konfigureer die projekomgewing';
$string['techproject:gradeproject'] = 'Deinieer assessering en evalueer die projek';
$string['techproject:manage'] = 'Bestuur die projekomgewing';
$string['techproject:managecriteria'] = 'Bestuur evaluasiekriteria';
$string['techproject:manageremoterepository'] = 'Bestuur afstandbewaararea (CVS)';
$string['techproject:managevalidations'] = 'Bestuur validasiesessies';
$string['techproject:posttodelivs'] = 'Pos na lewerings';
$string['techproject:validate'] = 'Valideer';
$string['techproject:viewpreproductionentities'] = 'Besigtig preproduksie-entiteite';
$string['techproject:viewprojectcontrols'] = 'Besigtig projekbeheerskerms';
$string['techproject_help'] = 'Tegniese projek';
$string['testing'] = 'Toetsing';
$string['testingdesc'] = 'Pakket is voltooi maar word nog getoets.';
$string['thedelivs'] = 'Die lewerings';
$string['themiles'] = 'Die mylpale';
$string['therequs'] = 'Die vereistes';
$string['thespecs'] = 'Die spesifikasies';
$string['thetasks'] = 'Die take';
$string['timetocomplete'] = 'Tyd tot voltooiing';
$string['timeunit'] = 'Tydeenheid';
$string['title'] = 'Projeknaam';
$string['to'] = 'om';
$string['todo'] = 'om te doen';
$string['toenhance'] = 'Om te verbeter';
$string['totalcost'] = 'Totale tyd bestee';
$string['totaldeliv'] = 'Lewerings (alle)';
$string['totalplanned'] = 'Totale tyd beplan';
$string['totalquote'] = 'Totale kwotasie';
$string['totalrequ'] = 'Vereistes (alle)';
$string['totalspec'] = 'Spesifikasies (alle)';
$string['totaltask'] = 'Take (alle)';
$string['totaltime'] = 'Totale tyd bestee';
$string['tuning'] = 'Instelling/Opstelling';
$string['tuningdesc'] = 'Instelling- en konfigurasie-operasies';
$string['unassigned'] = 'Ontoegewys';
$string['unassigneddesc'] = 'Ongespesifiseerde lewering';
$string['unassignedtasks'] = 'Ontoegewysde take';
$string['uncovered'] = 'Onbedek';
$string['ungroupedsees'] = 'Ongegroepeerde student se toegang';
$string['ungroupedsees_help'] = '<p>As hierdie vermoë ontsper is, en sigbaarheid is op die een of ander manier liberam (geen groepe of sigbare groepe),
kan ongegroepeerde lede (nie-onderwysers) die verstek projekinhoud besigtig en data
wysig
indien hulle oor die tersaaklike vermoëns beskik.</p>
<p>Indien ontsper en die sigbaarheidsbeleid is redelik liberaal, behoort ongegroepeerde studente die
projekinhoud te kan dophou, maar nie toegelaat word om enigiets daarin te verander nie.
<p>Indien ontsper en groepe geskei is, ontvang ongegroepeerde gebruikers \'n foutboodskap.</p>';
$string['unqualified'] = 'N.C.';
$string['unscheduledtasks'] = 'Ongeskeduleerde take';
$string['unselectall'] = 'Ontkies almal';
$string['unset'] = 'Keer instelling om';
$string['unspecifiedtasks'] = 'Ongespesifiseerde take';
$string['unspecifiedtasks_help'] = '<p>Prioriteit word aan die spesifikasie verleen, wat vir \'n meer dwingende projekkomponent staan en voor ander gedoen moet word. Take wat geen toewysing het nie, kan nie hul prioriteit oplos nie. Hulle bly binne \'n "ontoegewysde stel".';
$string['untracked'] = 'Ongespoor';
$string['untypedtasks'] = 'Ongetikte take';
$string['up'] = 'Verhoog';
$string['update'] = 'bywerk';
$string['updatedeliv'] = 'Werk \'n lewering by';
$string['updategrades'] = 'Berg die punte';
$string['updatemilestone'] = 'Verander \'n mylpaal';
$string['updaterequ'] = 'Verander \'n vereiste';
$string['updatespec'] = 'Verander \'n spesifikasie';
$string['updatetask'] = 'Verander \'n taak';
$string['updatevalidation'] = 'Werk validasiesessie by';
$string['uploadfile'] = 'Laai \'n dokument op';
$string['upto'] = 'Aan:';
$string['urgent'] = 'Dringend';
$string['urgentdesc'] = 'Dringend';
$string['url'] = 'URL';
$string['used'] = 'Tyd gebruik';
$string['useful'] = 'Nuttig';
$string['usefuldesc'] = 'Sou dit anders kon doen, maar dit is \'n goeie en gewaardeerde funksie';
$string['useriskcorrection'] = 'Gebruik risikokorreksie';
$string['useriskcorrection_help'] = 'Gebruik risikokorreksie';
$string['validations'] = 'Validasies';
$string['verycomplex'] = 'Baie Kompleks';
$string['verycomplexdesc'] = 'Verg afbreek van groot dele van die argitektuur. Duur.';
$string['viewalltasks'] = 'Besigtig alle take';
$string['viewonlyleaves'] = 'Besigtig slegs doeltreffende take';
$string['viewonlymasters'] = 'Besigtig slegs meestertake';
$string['views'] = 'Besigtigings';
$string['wecanhave'] = 'Bestaan, ons kan hê';
$string['wecanhavedesc'] = 'Ons het reeds iets soortgelyk, of kan dit maklik aankoop';
$string['wehave'] = 'Beskikbaar';
$string['wehavedesc'] = 'Ons het reeds iets soortgelyk';
$string['weight'] = 'Gewig';
$string['weight_help'] = '<p>Die kriteriumgewig laat die invloed van elke kriterium in die stel balanseer. Die balansering word uitgevoer d.m.v. "barisentriese" gemiddeld: die som van alle gewigte sal die 100%-faktor op die maks.
punt bepaal.</p>';
$string['what'] = 'Wat?';
$string['will'] = 'SAL';
$string['willdesc'] = 'Ons verwag regtig dat dit daar sal wees.';
$string['wished'] = 'KAN';
$string['wisheddesc'] = 'Streng gesproke nie nodig nie, maar sou gaaf wees as jy dit kon hê';
$string['withchosennodes'] = 'met gekose nodusse ...';
$string['worktype'] = 'Werktipe';
$string['worktype_help'] = '<p>Hierdie kwalifiseerder dui aan watter tipe werk gedoen moet word. Om te weet watter vaardighede nuttig vir \'n spesifieke taak sou wees, help
baie met die toewys van werk aan deelnemers.</p>

<p>Standaard waardes is geskik vir \'n pragmatiese sagteware-ontwikkelingsprojek, maar enige ander skaal kan vir \'n spesifieke
eksemplaar gedefinieer word.</p>

<p>Verstek waardes:</p>

<ul>
<li><b>PRE</b> Voorskou: Inligtingsoekend, dokumentlesend ...</li>

<li><b>ANA</b>Analise: Stelselontwerp, oplossingmodellering</li>

<li><b>SPK</b> Spesifikasies: Spesifikasieskepping</li>

<li><b>COD</b> Skryf van kodes</li>

<li><b>Rev</b> Oorsig: Kode-oorsig, skoonmaak, harmonisering</li>

<li><b>PAK</b> Verpakking: Toepassingverpakking, installeerders, ontplooiing</li>

<li><b>DOC</b> Dokumentering: Skryf van dokumentasie</li>
</ul>';
$string['writing'] = 'Skryf';
$string['writingdesc'] = 'Inhoud word geskryf';
$string['xmlexport'] = 'XML-uitvoer';
$string['xmlexportselected'] = 'Voer gekose items na XML uit ...';
$string['xslloaded'] = 'Gelaaide XSL';
