<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'sr_lt', version '4.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.calendar.calendarevents'] = 'Događaji u kalendaru';
$string['addon.calendar.defaultnotificationtime'] = 'Podrazumevano vreme za slanje obaveštenja';
$string['addon.calendar.errorloadevent'] = 'Greška prilikom učitavanja događaja.';
$string['addon.calendar.errorloadevents'] = 'Greška prilikom učitavanja događaja.';
$string['addon.calendar.noevents'] = 'Nema događaja';
$string['addon.competency.errornocompetenciesfound'] = 'Nije pronađena nijedna kompetencija';
$string['addon.competency.nocompetencies'] = 'Nema kompetencija';
$string['addon.coursecompletion.complete'] = 'Završi';
$string['addon.coursecompletion.couldnotloadreport'] = 'Nije moguće učitati izveštaj o završetku kursa. Molimo vas, pokušajte ponovo kasnije.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Komfiguriši uređaj';
$string['addon.messages.contactlistempty'] = 'Lista kontakata je prazna';
$string['addon.messages.contactname'] = 'Ime osobe';
$string['addon.messages.deletemessage'] = 'Obriši poruku';
$string['addon.messages.deletemessageconfirmation'] = 'Da li sigurni da želite da obrišete ovu poruku? Ona će biti izbrisan samo iz vaše istorije poruka ali će i dalje biti vidljiva korisniku koji je poslao ili primio poruku.';
$string['addon.messages.errordeletemessage'] = 'Greška prilikom brisanja poruke.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Greška prilikom preuzimanja kontakata sa servera.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Greška prilikom preuzimanja diskusija sa servera.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Greška prilikom preuzimanja poruka sa servera.';
$string['addon.messages.errorwhileretrievingusers'] = 'Greška prilikom preuzimanja korisnika sa servera.';
$string['addon.messages.messagenotsent'] = 'Poruka nije poslata. Molimo vas, pokušajte ponovo kasnije.';
$string['addon.messages.newmessages'] = 'Nove poruke';
$string['addon.messages.nousersfound'] = 'Nije pronađen nijedan korisnik';
$string['addon.messages.showdeletemessages'] = 'Prikaži brisanje poruka';
$string['addon.messages.type_blocked'] = 'Blokiran';
$string['addon.messages.type_offline'] = 'Oflajn';
$string['addon.messages.type_online'] = 'Onlajn';
$string['addon.messages.type_search'] = 'Rezultati pretrage';
$string['addon.messages.type_strangers'] = 'Drugi';
$string['addon.messages.warningconversationmessagenotsent'] = 'Nije moguće poslati poruku(e) u prepisku {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Nije moguće poslati poruku(e) korisniku {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Molimo vas da prihvatite izjavu o predaji rada.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Ne možete da dodate ili menjate rad u aplikaciji jer izjava o predatom radu ne može da se preuzme sa sajta.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Aplikacije još uvek ne podržava određene metode ocenjivanja i one se ne mogu menjati.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Ne možete da predate rad na ocenjivanje u aplikaciji jer nije bilo moguće preuzeti sa sajta izjavu o predaji rada.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Ne možete da dodate ili menjate rad u aplikaciji jer neki dodaci još uvek nemaju podršku za uređivanje.';
$string['addon.mod_assign.errorshowinginformation'] = 'Nije moguće prikazati informacije o predatom radu.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Aplikacija ne podržava ove povratne informacije. Moguće je da one ne sadrži sve informacije.';
$string['addon.mod_assign.gradenotsynced'] = 'Ocena nije sinhronizovana';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Učesnici koji nisu predali rad nisu prikazani.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Broj radnih verzija: {{count}}';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Broj učesnika: {{count}}';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Broj predatih radova koje treba oceniti: {{count}}';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Broj predatih zadataka (radova): {{count}}';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Broj timova: {{count}}';
$string['addon.mod_assign.submissionnotsupported'] = 'Aplikacija ne podržava ovaj predati rad. Moguće je da rad ne sadrži sve informacije.';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Ocena predatog rada je izmenjena na sajtu.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Predati rad korisnika je izmenjen na sajtu.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Greška prilikom povezivanja sa pričaonicom.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Greška prilikom preuzimanja podataka za \'Pričaonicu\'.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Greška prilikom preuzimanja korisnika pričaonice.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Greška prilikom preuzimanja poruka sa servera.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Greška prilikom slanja poruke.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Morate biti onlajn kako biste slali poruke.';
$string['addon.mod_choice.errorgetchoice'] = 'Greška prilikom preuzimanja podataka za \'Izbor\'';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% korisnika je izabralo opciju: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Rezultati ne uključuje vaš poslednji odgovor. Pokrenite sinhronizaciju kako biste ih ažurirali.';
$string['addon.mod_data.errorapproving'] = 'Greška prilikom odobravanja ili neodobravanja unosa.';
$string['addon.mod_data.errordeleting'] = 'Greška prilikom brisanja unosa.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Upitnik sa Captcha elementom ne može da bude završen ako nije konfigurisan, ako ste u oflajn režimu ili ako je server isključen.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Ovaj upitnik je sačuvan kako bi kasnije bio predat.';
$string['addon.mod_folder.emptyfilelist'] = 'Nema datoteka za prikaz.';
$string['addon.mod_forum.errorgetforum'] = 'Greška prilikom preuzimanja podataka za \'Forum\'';
$string['addon.mod_forum.errorgetgroups'] = 'Greška prilikom preuzimanja podešavanja grupa.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Greška prilikom preuzimanja podešavanja grupa.';
$string['addon.mod_forum.group'] = 'Grupa';
$string['addon.mod_forum.numdiscussions'] = 'Broj diskusija: {{numdiscussions}}';
$string['addon.mod_forum.numreplies'] = 'Broj odgovora: {{numreplies}}';
$string['addon.mod_forum.refreshposts'] = 'Osveži postove';
$string['addon.mod_glossary.browsemode'] = 'Pregledaj pojmove';
$string['addon.mod_glossary.byalphabet'] = 'Abecednim redom';
$string['addon.mod_glossary.byauthor'] = 'Grupiši po autoru';
$string['addon.mod_glossary.bycategory'] = 'Grupiši po kategoriji';
$string['addon.mod_glossary.bynewestfirst'] = 'Najnoviji prvo';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Nedavno ažurirani';
$string['addon.mod_glossary.bysearch'] = 'Pretraži';
$string['addon.mod_glossary.cannoteditentry'] = 'Ne možete da uređujete pojam';
$string['addon.mod_glossary.entriestobesynced'] = 'Pojmovi za sinhronizaciju';
$string['addon.mod_glossary.entrypendingapproval'] = 'Ovaj pojam čeka odobrenje.';
$string['addon.mod_glossary.errorloadingentries'] = 'Došlo je do greške prilikom učitavanja pojmova.';
$string['addon.mod_glossary.errorloadingentry'] = 'Došlo je do greške prilikom učitavanja pojma.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Došlo je do greške prilikom učitavanja rečnika.';
$string['addon.mod_glossary.noentriesfound'] = 'Nije pronađen nijedan pojam.';
$string['addon.mod_glossary.searchquery'] = 'Upit za pretragu';
$string['addon.mod_imscp.showmoduledescription'] = 'Prikaži opis';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Ova lekcija sadrži prelaz na nausimično odabranu stranicu sa sadržajem, pa je nije moguće uraditi u aplikaciji dok se ne pokrene na veb sajtu.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Ova pokušaj ne može više biti pregledan zato što je završen drugi pokušaj.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Ovaj pokušaj je završen u oflajn režimu.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Oflajn pokušaj je sinhronizovan. Da li želite da ga pregledate?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Pokušaj je završen na veb sajtu.';
$string['addon.mod_lti.errorgetlti'] = 'Greška prilikom preuzimanja podataka modula.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Inicijalna URL adresa nije ispravna.';
$string['addon.mod_lti.launchactivity'] = 'Pokreni aktivnost';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Greška prilikom učitavanja sadržaja stranice.';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Ovaj pokušaj rešavanja testa ne može da bude predat zbog sledećih razloga:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Ovaj pokušaj nije sinhronizovan od {{$a}}. Ako ste u međuvremenu ovaj pokušaj nastavili  na nekom drugom uređaju, postoji mogućnost da ste izgubili podatke.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Došlo je do greške prilikom pokušaja da se sačuvaju odgovori. Da li ste sigurni da želite da napustite test?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Ovaj test ne možete rešavati u aplikaciji zato što ona ne podržava ponašanje pitanja:';
$string['addon.mod_quiz.errordownloading'] = 'Greška prilikom preuzimanja neophodnih podataka.';
$string['addon.mod_quiz.errorgetattempt'] = 'Greška prilikom preuzimanja podataka o pokušaju rešavanja testa.';
$string['addon.mod_quiz.errorgetquestions'] = 'Greška prilikom preuzimanja pitanja.';
$string['addon.mod_quiz.errorgetquiz'] = 'Greška prilikom preuzimanja podataka o testu.';
$string['addon.mod_quiz.errorparsequestions'] = 'Došlo je do greške prilikom učitavanja pitanja. Molimo, pokušajte da rešite ovaj test u veb čitaču.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Ovaj test se ne može rešavati u aplikaciji zato što sadrži pitanja koje aplikacija ne podržava:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Ovaj test se ne može rešavati u aplikaciji zato što sadrži pravila za pristup koje aplikacija ne podržava:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Došlo je do greške prilikom snimanja podataka o pokušaju rešavanja testa.';
$string['addon.mod_quiz.finishnotsynced'] = 'Test je završen, ali nije sinhronizovan';
$string['addon.mod_quiz.opentoc'] = 'Otvori navigacioni meni.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Oflajn pokušaj je odbačen zato što je ili završen na sajtu ili nije pronađen.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Neki oflajn odgovori su odbačeni zato što su pitanja izmenjena onlajn.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Pokušaj rešavanja testa je nije završen zato što su neki oflajn odgovori odbačeni. Pregledajte svoje odgovore, a zatim ponovo pošaljite svoj pokušaj.';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Greška prilikom učitavanja sadržaja.';
$string['addon.mod_resource.openthefile'] = 'Otvori datoteku';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Ocena ne može da se izračuna.';
$string['addon.mod_scorm.dataattemptshown'] = 'Ovi podaci pripadaju pokušaju broj {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Došlo je do greške prilikom pokušaja kreiranja novog oflajn pokušaja. Molimo, pokušajte ponovo.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Greška prilikom preuzimanja SCORM paketa: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Greška prilikom preuzimanja podataka SCORM paketa.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Izvinite, aplikacija podržava samo SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Preuzimanje SCORM paketa je onemogućeno na vašem sajtu. Molimo, obratite se administratoru vašeg Moodle sajta.';
$string['addon.mod_scorm.errornovalidsco'] = 'Ovaj SCORM paket nema vidljiv SCO koji bi bio učitan.';
$string['addon.mod_scorm.errorpackagefile'] = 'Izvinite, aplikacija podržava samo ZIP arhive.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Došlo je do greške prilikom sinhronizacije. Molimo, pokušajte ponovo.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Ovaj pokušaj ima podatke koji nisu sinhronizovan.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Ovaj pokušaj ne može biti poslat zato što ste premašili maksimalan broj dozvoljenih pokušaja.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Ovaj SCORM paket nije preuzet. Biće automatski preuzet kada ga otvorite.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Ovaj SCORM paket je menjan od poslednjeg preuzimanja. Biće automatski preuzet kada ga otvorite.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Neki oflajn podaci o pokušaju  {{number}} su obrisani zato što ih nije moguće kreirati u novom pokušaju.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Neki pokušaji nisu mogli biti sinhronizovani sa sajtom zato što poslednji online pokušaj nije završen. Molimo vas da prvo završite onlajn pokušaj.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Nažalost, bilo je problema sa predajom vašeg upitnika. Molim vas, pokušajte ponovo.';
$string['addon.mod_survey.errorgetsurvey'] = 'Greška prilikom preuzimanja podataka za \'Upitnik\' (Survey)';
$string['addon.mod_survey.results'] = 'Rezultati';
$string['addon.mod_url.accessurl'] = 'Pristupi URL adresi';
$string['addon.mod_url.pointingtourl'] = 'URL adresa sa kojom je ovaj resurs povezan';
$string['addon.mod_wiki.errorloadingpage'] = 'Došlo je do greške prilikom učitavanja stranice.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Ovaj viki još uvek nema sadržaj.';
$string['addon.mod_wiki.gowikihome'] = 'Idi na početnu stranicu vikija';
$string['addon.mod_wiki.subwiki'] = 'Podviki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Naslov ne bi trebalo da bude prazan';
$string['addon.mod_wiki.viewpage'] = 'Pogledaj stranicu';
$string['addon.mod_wiki.wikipage'] = 'Viki stranica';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Strategija procene {{$a}} nije podržana';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Morate da unesete naslov.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Predati rad je izmenjen na sajtu.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Procena je izmenjena na sajtu.';
$string['addon.notes.warningnotenotsent'] = 'Nije moguće dodati belešku/e kursu {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Greška prilikom preuzimanja obaveštenja';
$string['addon.notifications.notifications'] = 'Obaveštenja';
$string['addon.notifications.playsound'] = 'Reprodukuj zvuk';
$string['addon.notifications.therearentnotificationsyet'] = 'Nema obaveštenja';
$string['appstoredescription'] = 'NAPOMENA: Ova zvanična Moodle Mobile će raditi SAMO sa onim Moodle sajtovima koji su podešeni tako da to omogućavaju. Ako imate problema sa povezivanjem, obratite se administratoru vašeg Moodle sajta.
 
Ako je vaš Moodle sajt ispravno konfigurisan, ovu aplikaciju možete koristiti kako biste:
 
- pregledali sadržaje svojih kurseva, čak i kada ste oflajn
- primali trenutna obaveštenja o porukama i drugim događajima
- brzo pronašli i kontaktirali druge polaznike na svojim kursevima
- otpremali slike, audio, video i druge datoteke sa svog mobilnog uređaja
- videli svoje ocene na kursu
- i još mnogo toga!
 
Za sve najnovije informacije molimo vas, pogledajte http://docs.moodle.org/en/Mobile_app
 
Zaista bismo voleli da čujemo vaše komentare o postojećim funkcionalnostima, kao i sugestije o tome šta još želite da ova aplikacija radi!
 
Aplikacija zahteva sledeća ovlašćenje:
Snimanje zvuka - za snimanje zvuka i otpremanje snimka na Moodle
Čitanje i modifikovanje sadržaja vaše SD kartice - sadržaji se preuzimaju na SD karticu vašeg telefona tako da možete da ih vidite i kada se u oflajn režimu
Pristup mreži - kako biste mogli da se povežete sa svojim Moodle sajtom i proverite da li ste povezani ili ne (i u tom slučaju se prebacite u oflajn režim)
Izvršavanje pri pokretanju - tako da možete da primate lokalna obaveštenja čak i kada aplikacija radi u pozadini
Sprečavanja da mobilni telefon uđe u režim mirovanja - tako da možete da primite obaveštenja u bilo kom trenutku';
$string['core.cannotconnect'] = 'Nije moguće uspostaviti vezu.';
$string['core.cannotdownloadfiles'] = 'Preuzimanje datoteka je onemogućeno u podešavanjima vašeg mobilnog servisa. Obratite se administratoru sajta.';
$string['core.captureaudio'] = 'Snimi audio';
$string['core.capturedimage'] = 'Snimljena slika';
$string['core.captureimage'] = 'Uslikaj';
$string['core.capturevideo'] = 'Snimi video';
$string['core.clearsearch'] = 'Obriši pretragu';
$string['core.clicktoseefull'] = 'Kliknite da biste videli kompletan sadržaj.';
$string['core.confirmcanceledit'] = 'Da li ste sigurni da želite da napustite ovu stranicu? Sve promene će biti izgubljene.';
$string['core.confirmloss'] = 'Da li ste sigurni? Sve promene će biti izgubljene.';
$string['core.confirmopeninbrowser'] = 'Da li želite da otvorite u veb čitaču?';
$string['core.contenteditingsynced'] = 'Sadržaj koji uređujete je sinhronizovan.';
$string['core.contentlinks.chooseaccount'] = 'Izaberi nalog';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Izaberite nalog sa kojim treba otvoriti link.';
$string['core.contentlinks.confirmurlothersite'] = 'Ovaj link pripada drugom sajtu. Da li želite da ga otvorite?';
$string['core.contentlinks.errornoactions'] = 'Nije moguće pronaći akciju koju treba izvesti sa ovim linkom.';
$string['core.contentlinks.errornosites'] = 'Nije moguće pronaći bilo koji sajt koji može izaći na kraj sa ovim linkom.';
$string['core.copiedtoclipboard'] = 'Tekst kopiran u klipbord';
$string['core.course.activitydisabled'] = 'Vaša institucija je onemogućila ovu aktivnost u mobilnoj aplikaciji.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Vaša institucija je instalirala dodatak koji još uvek nije podržan.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'Potrebno je da se ažurira Moodle instalacija vaše institucije.';
$string['core.course.allsections'] = 'Sve sekcije';
$string['core.course.askadmintosupport'] = 'Obratite se administratoru sajta i recite mu da želite da koristite ovu aktivnost sa Moodle Mobile aplikacijom.';
$string['core.course.confirmdeletemodulefiles'] = 'Da li ste sigurni da želite da izbrišete datoteke ovog modula?';
$string['core.course.confirmdownload'] = 'Nameravate da preuzmete {{size}}. Da li ste sigurni da želite da nastavite?';
$string['core.course.confirmdownloadunknownsize'] = 'Nismo mogli da izračunamo veličinu preuzimanje. Da li ste sigurni da želite da preuzmete?';
$string['core.course.confirmpartialdownloadsize'] = 'Nameravate da preuzmete <strong>najmanje</strong> {{size}}. Da li ste sigurni da želite da nastavite?';
$string['core.course.contents'] = 'Sadržaji';
$string['core.course.couldnotloadsectioncontent'] = 'Nije moguće učitati sadržaj sekcije, pokušajte ponovo kasnije.';
$string['core.course.couldnotloadsections'] = 'Nije moguće učitati sekcije, pokušajte ponovo kasnije.';
$string['core.course.errordownloadingcourse'] = 'Greška prilikom preuzimanju kursa.';
$string['core.course.errordownloadingsection'] = 'Greška prilikom preuzimanja sekcije.';
$string['core.course.errorgetmodule'] = 'Greška prilikom preuzimanja podataka modula.';
$string['core.course.manualcompletionnotsynced'] = 'Ručni završetak nije sinhronizovan.';
$string['core.course.nocontentavailable'] = 'Nikakav sadržaj nije dostupan u ovom trenutku.';
$string['core.course.refreshcourse'] = 'Osveži kurs';
$string['core.course.useactivityonbrowser'] = 'Još uvek možete da ga koristite pomoću veb čitača vašeg uređaja.';
$string['core.course.warningmanualcompletionmodified'] = 'Ručni završetak aktivnosti je izmenjen na sajtu.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Neki oflajn ručni završeci kursa \'{{name}}\' su obrisani. {{error}}';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorije koje su ispod nivoa {{$a}} ne mogu se preuzeti.';
$string['core.courses.confirmselfenrol'] = 'Da li ste sigurni da želite da se upišete na ovaj kurs?';
$string['core.courses.downloadcourses'] = 'Preuzmi kurs';
$string['core.courses.enrolme'] = 'Upiši me';
$string['core.courses.errorloadcategories'] = 'Došlo je do greške prilikom učitavanja kategorija.';
$string['core.courses.errorloadcourses'] = 'Došlo je do greške prilikom učitavanja kurseva.';
$string['core.courses.errorsearching'] = 'Došlo je do greške prilikom pretraživanja.';
$string['core.courses.errorselfenrol'] = 'Došlo je do greške prilikom pokušaja samostalnog upisa.';
$string['core.courses.filtermycourses'] = 'Filtriraj moje kurseve';
$string['core.courses.notenrollable'] = 'Ne možete sami da se upišete na ovaj kurs.';
$string['core.courses.password'] = 'Pristupna lozinka kursa';
$string['core.courses.searchcoursesadvice'] = 'Možete koristiti dugme za pretragu kurseva kako biste im pristupili kao gost ili se upisali na kurseve koji to dopuštaju.';
$string['core.courses.selfenrolment'] = 'Samostalni upis';
$string['core.courses.totalcoursesearchresults'] = 'Ukupno kurseva: {{$a}}';
$string['core.currentdevice'] = 'Trenutni uređaj';
$string['core.datastoredoffline'] = 'Podaci su sačuvani u mobilnom uređaju, zato što ne mogu da se pošalju. Automatski će biti poslati kasnije.';
$string['core.deletedoffline'] = 'Obrisano oflajn';
$string['core.deleting'] = 'Brisanje';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Odbaci';
$string['core.dismiss'] = 'Obustavi';
$string['core.downloading'] = 'Preuzimanje';
$string['core.emptysplit'] = 'Ova stranica će se pojaviti prazna ukoliko je levi panel prazan ili se učitava.';
$string['core.errorchangecompletion'] = 'Došlo je do greške prilikom promene statusa završetka. Molimo, pokušajte ponovo.';
$string['core.errordeletefile'] = 'Greška prilikom brisanja datoteke. Molimo, pokušajte ponovo.';
$string['core.errordownloading'] = 'Greška prilikom preuzimanja datoteke.';
$string['core.errordownloadingsomefiles'] = 'Greška prilikom preuzimanja datoteka modula. Moguće je da neke datoteke nedostaju.';
$string['core.errorfileexistssamename'] = 'Već postoji datoteka sa ovim nazivom.';
$string['core.errorinvalidform'] = 'Obrazac sadrži neispravne podatke. Uverite se da ste popunili sva neophodna polja i da su podaci ispravni.';
$string['core.errorinvalidresponse'] = 'Primljen je neispravan odgovor. Obratite se administratoru vašeg Moodle sajta ako se greška ponovi.';
$string['core.errorloadingcontent'] = 'Greška pri učitavanju sadržaja.';
$string['core.errorofflinedisabled'] = 'Oflajn pregledanje je onemogućeno na vašem sajtu.';
$string['core.erroropenfilenoapp'] = 'Greška prilikom otvaranja datoteke: nije pronađena aplikacija koja može da otvori ovaj tip datoteke.';
$string['core.erroropenfilenoextension'] = 'Greška prilikom otvaranja datoteke: datoteka nema ekstenziju.';
$string['core.erroropenpopup'] = 'Ova aktivnost pokušava da otvori iskačući prozor. Ova aplikacija to ne podržava.';
$string['core.errorrenamefile'] = 'Greška prilikom pokušaja promene naziva datoteke. Molimo, pokušajte ponovo.';
$string['core.errorsync'] = 'Došlo je do greške prilikom sinhronizaciji. Molimo, pokušajte ponovo.';
$string['core.errorsyncblocked'] = '{{$a}} trenutno ne može da se sinhronizuje zbog tekućeg procesa. Molimo, pokušajte ponovo kasnije. Ako se problem i dalje bude postojao, pokušajte ponovo da pokrenete aplikaciju.';
$string['core.filenameexist'] = 'Naziv datoteke već postoji: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Nameravate da otpremite {{size}}. Da li ste sigurni da želite da nastavite?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Nismo mogli da izračunamo veličinu datoteka za otpremanje. Da li ste sigurni da želite da nastavite?';
$string['core.fileuploader.errorcapturingaudio'] = 'Greška prilikom snimanja audio zapisa.';
$string['core.fileuploader.errorcapturingimage'] = 'Greška prilikom snimanja slike.';
$string['core.fileuploader.errorcapturingvideo'] = 'Greška prilikom snimanja video zapisa.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Greška prilikom preuzimanja slike iz albuma.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Morate biti onlajn kako biste otpremili datoteke.';
$string['core.fileuploader.errornoapp'] = 'Nemate instaliranu aplikaciju koja može da izvede ovu akciju.';
$string['core.fileuploader.errorreadingfile'] = 'Greška prilikom učitavanja datoteke.';
$string['core.fileuploader.errorwhileuploading'] = 'Došlo je do greške prilikom otpremanja datoteke.';
$string['core.fileuploader.file'] = 'Датотека';
$string['core.fileuploader.fileuploaded'] = 'Datoteka je uspešno otpremljena.';
$string['core.fileuploader.maxbytesfile'] = 'Datoteka {{$a.file}} je prevelika. Maksimalna veličina koju možete da otpremite je {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Foto album';
$string['core.fileuploader.readingfile'] = 'Učitavanje datoteke';
$string['core.fileuploader.readingfileperc'] = 'Učitavanje datoteke: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Izaberi datoteku';
$string['core.fileuploader.uploadafile'] = 'Otpremi datoteku';
$string['core.fileuploader.uploading'] = 'Otpremanje';
$string['core.fileuploader.uploadingperc'] = 'Otpremanje: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.hasdatatosync'] = '{{$a}} ima oflajn podatke koje treba sinhronizovati.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Slika';
$string['core.imageviewer'] = 'Prikazivač slike';
$string['core.lastdownloaded'] = 'Poslednji put preuzeto';
$string['core.lastsync'] = 'Poslednja sinhronizacija';
$string['core.loadmore'] = 'Učitaj još';
$string['core.login.authenticating'] = 'Provera identiteta';
$string['core.login.confirmdeletesite'] = 'Da li ste sigurni da želite da obrišete sajt {{sitename}}?';
$string['core.login.connect'] = 'Povežite se!';
$string['core.login.connecttomoodle'] = 'Povežite se sa Moodleom';
$string['core.login.connecttomoodleapp'] = 'Pokušavate da se povežete sa Moodle sajtom. Preuzmite zvaničnu Moodle aplikaciju kako biste pristupili ovom sajtu.';
$string['core.login.contactyouradministrator'] = 'Obratite se administratoru vašeg sajta za dalju pomoć.';
$string['core.login.contactyouradministratorissue'] = 'Zamolite administratora da proveri sledeći problem: {{$a}}';
$string['core.login.credentialsdescription'] = 'Za prijavu na sistem unesite svoje korisničko ime i lozinku.';
$string['core.login.emailconfirmsentnoemail'] = '<p>Trebalo bi da je poslata e-poruka na vašu adresu.</p><p><p>Poruka sadrži jednostavna uputstva o daljem postupku registracije.</p><p>Ako i dalje imate problema, kontaktirajte administratora.</p>';
$string['core.login.emailnotmatch'] = 'Adrese e-pošte se ne poklapaju';
$string['core.login.erroraccesscontrolalloworigin'] = 'Cross-Origin poziv koji pokušavate da izvedete je odbijen. Molimo, proverite https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Došlo je do greške prilikom brisanja ovog sajta. Molim, pokušajte ponovo.';
$string['core.login.errorupdatesite'] = 'Došlo je do greške prilikom ažuriranju tokena sajta.';
$string['core.login.faqtestappanswer'] = 'Da biste testirali aplikaciju na Moodle Demo sajtu, u polje „Vaš sajt“ unesite "teacher" ili „student" i kliknite na dugme „Poveži se sa svojim sajtom“.';
$string['core.login.faqwhatisurlanswer'] = '<p>Svaka organizacija ima sopstvenu jedinstvenu adresu ili URL  adresu za svoj Moodle sajt. Da biste pronašli adresu:</p><ol><li>Otvorite veb čitač i idite na stranicu za prijavljivanje vašeg Moodle sajta.</li><li>Na vrhu stranice, u traci za adresu, videćete URL adresu svog Moodle sajta npr. "mojaskola.edu.rs".<br>{{$image}}</li><li>Kopirajte adresu (nemojte kopirati deo adrese koji počinje sa /login), u Moodle aplikaciju a onda kliknite na dugme "Povežite se sa svojim sajtom"</li><li>Sada se možete prijaviti na svoj sajt koristeći svoje korisničko ime i lozinku.</li>';
$string['core.login.findyoursite'] = 'Pronađite svoj sajt';
$string['core.login.helpmelogin'] = '<p>Postoji više hiljada Moodle sajtova širom sveta. Ova aplikacija može da se poveže samo sa Moodle sajtovima koji su eksplicitno omogućili pristup mobilnoj aplikaciji.</p><p>Ako ne možete da se povežete sa Moodle sajtom, kontaktirajte administratora vašeg sajta i zatražite da pročita <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Da biste testirali aplikaciju na Moodle demo sajtu upišite <i>teacher</i> ili <i>student</i> u polje <i>Adresa sajta</i> i kliknite dugme <b>Povežite se!</b>.</p>';
$string['core.login.invalidaccount'] = 'Proverite svoje podatke za prijavu ili zamolite vašeg administratora da proveri konfiguraciju sajta.';
$string['core.login.invalidmoodleversion'] = 'Neispravna Moodle verzija. Neophodna je, minimalno, verzija 2.4.';
$string['core.login.invalidsite'] = 'URL adresa sajta nije ispravna.';
$string['core.login.invalidtime'] = 'Neispravno vreme';
$string['core.login.invalidvaluemax'] = 'Maksimalna vrednost je {{$a}}';
$string['core.login.invalidvaluemin'] = 'Minimalna vrednost je {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'Provera Moodle Mobile dodatnih funkcionalnosti vratila je neočekivan odgovor. Vaš identitet biće proveren pomoću standardnog mobilnog servisa.';
$string['core.login.loggedoutssodescription'] = 'Morate ponovo da potvrdite svoj identitet. Potrebno je da se prijavite na sajt u prozoru veb čitača.';
$string['core.login.loginbutton'] = 'Prijava';
$string['core.login.logininsiterequired'] = 'Potrebno je da se prijavite na sajt u prozoru veb čitača.';
$string['core.login.mobileservicesnotenabled'] = 'Mobilni servisi nisu omogućeni na vašem sajtu. Obratite se administratoru vašeg Moodle sajta ako mislite da mobilni pristup treba da bude omogućen.';
$string['core.login.notloggedin'] = 'Morate biti prijavljeni.';
$string['core.login.onboardingtoconnect'] = 'Da biste se povezali sa Moodle aplikacijom, biće vam potreban Moodle sajt';
$string['core.login.onboardingwelcome'] = 'Dobrodošli u Moodle aplikaciju!';
$string['core.login.passwordrequired'] = 'Neophodna je lozinka';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA slika';
$string['core.login.recaptchaexpired'] = 'Verifikacija je istekla. Ponovo odgovorite na bezbednosno pitanje.';
$string['core.login.recaptchaincorrect'] = 'Odgovor na bezbednosno pitanje je netačan.';
$string['core.login.reconnect'] = 'Povežite se ponovo';
$string['core.login.reconnectdescription'] = 'Vaš token za proveru identiteta je neispravan ili je istekao. Morate ponovo da uspostavite vezu sa sajtom.';
$string['core.login.reconnectssodescription'] = 'Vaš token za proveru identiteta je neispravan ili je istekao. Morate ponovo da uspostavite vezu sa sajtom. Potrebno je da se prijavite na sajt u prozoru veb čitača.';
$string['core.login.searchby'] = 'Pretraga po:';
$string['core.login.selectsite'] = 'Izaberite svoj sajt:';
$string['core.login.signupplugindisabled'] = '{{$a}} nije omogućen.';
$string['core.login.siteaddress'] = 'Adresa sajta';
$string['core.login.sitehasredirect'] = 'Vaš sajt sadrži najmanje jednu HTTP redirekciju. Aplikacija ne može da prati redirekcije. Ovo bi mogao da bude problem koji sprečava aplikaciju da se poveže sa vašim sajtom.';
$string['core.login.siteinmaintenance'] = 'Vaš sajt je u režimu održavanja';
$string['core.login.sitepolicynotagreederror'] = 'Saglasnost sa politikom sajta nije potvrđena.';
$string['core.login.siteurl'] = 'URL adresa sajta';
$string['core.login.siteurlrequired'] = 'Neophodna je URL adresa, npr. <i>http://www.yourmoodlesite.abc ili https://www.yourmoodlesite.efg</i>';
$string['core.login.stillcantconnect'] = 'Još uvek ne možete da se povežete?';
$string['core.login.usernamerequired'] = 'Korisničko ime je neophodno';
$string['core.login.visitchangepassword'] = 'Da li želite da posetite sajt kako biste promenili lozinku?';
$string['core.login.webservicesnotenabled'] = 'Veb servisi nisu omogućeni na vašem sajtu. Obratite se administratoru vašeg Moodle sajta ako mislite da mobilni pristup treba da bude omogućen.';
$string['core.login.yourenteredsite'] = 'Povežite se sa svojim sajtom';
$string['core.lostconnection'] = 'Vaš token za potvrdu identiteta je nevažeći ili je istekao. Moraćete ponovo da uspostavite vezu sa sajtom.';
$string['core.mainmenu.changesite'] = 'Promeni sajt';
$string['core.mainmenu.website'] = 'Veb sajt';
$string['core.networkerroriframemsg'] = 'Ovaj sadržaj nije dostupan oflajn. Povežite se na internet i pokušajte ponovo.';
$string['core.networkerrormsg'] = 'Bilo je problema sa povezivanjem na sajt. Proverite vezu i pokušajte ponovo.';
$string['core.nopasswordchangeforced'] = 'Ne možete nastaviti bez promene svoje lozinke.';
$string['core.nopermissionerror'] = 'Žao nam je, ali trenutno nemate ovlašćenja da to uradite';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Nije poslato';
$string['core.openfullimage'] = 'Kliknite ovde da biste prikazali sliku u punoj veličini';
$string['core.openinbrowser'] = 'Otvori u veb čitaču';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Povucite za osvežavanje';
$string['core.question.cannotdeterminestatus'] = 'Nije moguće odrediti status';
$string['core.question.errorquestionnotsupported'] = 'Aplikacija ne podržava ovaj tip pitanja: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Dodirnite za izbor, zatim još jednom za spuštanje.';
$string['core.question.questionmessage'] = 'Pitanje {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Bićete preusmereni na sajt.';
$string['core.requireduserdatamissing'] = 'Ovaj korisnik nema u svom profilu neke neophodne podatke. Molimo vas, uneseti ove podatke u vaš Moodle i pokušajte ponovo.<br>{{$a}}';
$string['core.retry'] = 'Pokušaj ponovo';
$string['core.searching'] = 'Pretraživanje';
$string['core.settings.about'] = 'O aplikaciji';
$string['core.settings.appsettings'] = 'Podešavanja aplikacije';
$string['core.settings.cannotsyncoffline'] = 'Oflajn sinhronizacija nije moguća.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Sinhronizacija nije moguća zato što trenutna podešavanja dozvoljavaju sinhronizaciju samo kada postoji veza sa Wi-Fi mrežom. Povežite se na Wi-Fi mrežu.';
$string['core.settings.compilationinfo'] = 'Informacije o kompilaciji';
$string['core.settings.cordovadevicemodel'] = 'Model Cordova uređaja';
$string['core.settings.cordovadeviceosversion'] = 'Verzija operativnog sistema Cordova uređaja';
$string['core.settings.cordovadeviceplatform'] = 'Platforma Cordova uređaja';
$string['core.settings.cordovadeviceuuid'] = 'UUID Cordova uređaja';
$string['core.settings.cordovaversion'] = 'Cordova verzija';
$string['core.settings.debugdisplaydescription'] = 'Ako je omogućena ova opcija, poruka o grešci će prikazati više podataka o samoj grešci ako je to moguće.';
$string['core.settings.deletesitefiles'] = 'Da li ste sigurni da želite da obrišete preuzete datoteke sa sajta \'{{sitename}}\'?';
$string['core.settings.deletesitefilestitle'] = 'Obriši datoteke sajta';
$string['core.settings.developeroptions'] = 'Opcije za programere';
$string['core.settings.deviceinfo'] = 'Informacija o uređaju';
$string['core.settings.deviceos'] = 'Operativni sistem uređaja';
$string['core.settings.displayformat'] = 'Format prikaza';
$string['core.settings.enabledownloadsection'] = 'Omogući preuzimanje sekcija.';
$string['core.settings.enablerichtexteditor'] = 'Omogući obogaćeni editor teksta';
$string['core.settings.enablerichtexteditordescription'] = 'Ako je ova opcija uključena obogaćeni editor teksta biće prikazan na mestima koja to dozvoljavaju.';
$string['core.settings.enablesyncwifi'] = 'Dozvolite sinhronizaciju samo kada ste povezani na Wi-Fi mrežu.';
$string['core.settings.errordeletesitefiles'] = 'Greška prilikom brisanja datoteka sajta.';
$string['core.settings.errorsyncsite'] = 'Greška prilikom sinhronizacije podataka sajta. Molimo, proverite vašu internet vezu i pokušajte ponovo.';
$string['core.settings.estimatedfreespace'] = 'Procenjeni slobodan prostora';
$string['core.settings.filesystemroot'] = 'Osnovni direktorijum sistema datoteka';
$string['core.settings.localnotifavailable'] = 'Lokalna obaveštenja dostupna';
$string['core.settings.locationhref'] = 'Webview URL adresa';
$string['core.settings.navigatorlanguage'] = 'Jezik navigatora';
$string['core.settings.navigatoruseragent'] = 'Korisnički agent navigatora';
$string['core.settings.networkstatus'] = 'Status inernet veze';
$string['core.settings.privacypolicy'] = 'Politika privatnosti';
$string['core.settings.reportinbackground'] = 'Prijavi greške automatski';
$string['core.settings.showdownloadoptions'] = 'Prikaži opcije preuzimanja';
$string['core.settings.spaceusage'] = 'Iskorištenost prostora';
$string['core.settings.synchronization'] = 'Sinhronizacija';
$string['core.settings.synchronizenow'] = 'Sinhronizuj sada';
$string['core.settings.syncsettings'] = 'Podešavanja sinhronizacije';
$string['core.settings.wificonnection'] = 'WiFi veza';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Izaberite nalog za čuvanje datoteke.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Već postoji datoteka sa ovim nazivom. Da li želite da zamenite postojeću datoteku ili da joj naziv promenite u "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Ne postoje memorisani sajtovi. Molimo, dodajte sajt pre nego što pokušate da podelite datoteke sa aplikacijom.';
$string['core.sharedfiles.nosharedfiles'] = 'Ne postoje deljene datoteke koje se nalaze na ovom sajtu.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Ovde nemate datoteke koje možete da otpremite. Ako želite da otpremite datoteku iz druge aplikacije, pronađite tu datoteku i kliknite na dugme \'Otvori u\'.';
$string['core.sharedfiles.rename'] = 'Promeni naziv';
$string['core.sharedfiles.replace'] = 'Zameni';
$string['core.sharedfiles.sharedfiles'] = 'Deljene datoteke';
$string['core.sharedfiles.successstorefile'] = 'Datoteka je uspešno sačuvana. Sada možete da izaberete ovu datoteku da biste je otpremili među svoje privatne datoteke ili je pridružili nekoj aktivnosti.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Izvinite...';
$string['core.tablet'] = 'Tablet';
$string['core.thereisdatatosync'] = 'Broj oflajn podatak koje treba sinhronizovati: {{$a}}';
$string['core.tryagain'] = 'Pokušaj ponovo';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh!';
$string['core.unexpectederror'] = 'Neočekivana greška. Zatvorite i ponovo otvorite aplikaciju, a zatim pokušajte ponovo.';
$string['core.unicodenotsupported'] = 'Neki emotikoni nisu podržani na ovom sajtu. Takvi znakovi će biti uklonjeni prilikom slanja poruke.';
$string['core.unicodenotsupportedcleanerror'] = 'Prilikom čišćenja Unicode karaktera pronađen je prazan tekst.';
$string['core.unknown'] = 'Nepoznato';
$string['core.unzipping'] = 'Raspakivanje';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Podaci o ovom korisniku vam nisu dostupni.';
$string['core.user.errorloaduser'] = 'Greška prilikom učitavanja korisnika.';
$string['core.user.sendemail'] = 'E-pošta';
$string['core.viewcode'] = 'Prikaži kôd';
$string['core.vieweditor'] = 'Prikaži editor';
$string['core.viewembeddedcontent'] = 'Prikaži ugrađeni sadržaj';
$string['core.warningofflinedatadeleted'] = 'Oflajn podaci komponente {{component}} \'{{name}}\' su obrisani. {{error}}';
$string['core.whoops'] = 'Ups!';
$string['core.whyisthishappening'] = 'Zašto se ovo dešava?';
$string['core.wsfunctionnotavailable'] = 'Funkcija veb service nije dostupna.';
$string['pluginname'] = 'Moodle Mobile jezički stringovi';
