<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'nl', version '4.0'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handeling';
$string['addedandupdatedpp'] = '{$a->%new} nieuwe H5P bibliotheken toegevoegd en {$a->%old} oude bijgewerkt.';
$string['addedandupdatedps'] = '{$a->%new} nieuwe H5P bibliotheken toegevoegd en {$a->%old} oude bijgewerkt.';
$string['addedandupdatedsp'] = '{$a->%new} nieuwe H5P bibliotheek toegevoegd en {$a->%old} oude bijgewerkt.';
$string['addedandupdatedss'] = '{$a->%new} nieuwe H5P bibliotheek toegevoegd en {$a->%old} oude bijgewerkt.';
$string['addednewlibraries'] = '{$a->%new} nieuwe H5P bibliotheken toegevoegd.';
$string['addednewlibrary'] = '{$a->%new} nieuwe H5P bibliotheek toegevoegd.';
$string['additionalinfo'] = 'Aanvullende informatie';
$string['additionallicenseinfo'] = 'Aanvullende informatie over de licentie';
$string['addlibraries'] = 'Bibliotheken toevoegen';
$string['ajaxfailed'] = 'Gegevens laden mislukt.';
$string['anunexpectedsave'] = 'Er is iets onverwachts gebeurd. Hierdoor was het niet mogelijk om de content te bewaren.';
$string['attribution'] = 'Naamsvermelding 4.0';
$string['attributionnc'] = 'Naamsvermelding-NietCommercieel 4.0';
$string['attributionncnd'] = 'Naamsvermelding-NietCommercieel-GeenAfgeleideWerken 4.0';
$string['attributionncsa'] = 'Naamsvermelding-NietCommercieel-GelijkDelen 4.0';
$string['attributionnd'] = 'Naamsvermelding-GeenAfgeleideWerken 4.0';
$string['attributionsa'] = 'Naamsvermelding-GelijkDelen 4.0';
$string['author'] = 'Auteur';
$string['authorcomments'] = 'Opmerkingen auteur';
$string['authorcommentsdescription'] = 'Opmerkingen voor de uitgever van de inhoud (deze tekst zal niet gepubliceerd worden als deel van copyright info)';
$string['authorname'] = 'Naam auteur';
$string['authorrole'] = 'Rol auteur';
$string['by'] = 'door';
$string['cancellabel'] = 'Annuleren';
$string['ccattribution'] = 'Naamsvermelding (CC BY)';
$string['ccattributionnc'] = 'Naamsvermelding-Niet-Commercieel (CC BY-NC)';
$string['ccattributionncnd'] = 'Naamsvermelding-Niet-Commercieel-Geen Afgeleide Werken (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Naamsvermelding - Niet-Commercieel - Gelijk Delen licentie (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Naamsvermelding - Geen afgeleide werken (CC BY-ND)';
$string['ccattributionsa'] = 'Naamsvermelding - Gelijk Delen Licentie (CC BY-SA)';
$string['ccpdd'] = 'Publiek Domein Verklaring (CC0)';
$string['changedby'] = 'Vervangen door';
$string['changedescription'] = 'Omschrijving van de verandering';
$string['changelog'] = 'Wijzigingenlogboek';
$string['changeplaceholder'] = 'Foto verkleind, tekst veranderd, etc';
$string['close'] = 'Sluiten';
$string['confirmdialogbody'] = 'Bevestig dat je wilt doorgaan. Deze actie kan niet worden teruggedraaid.';
$string['confirmdialogheader'] = 'Handeling bevestigen';
$string['confirmlabel'] = 'Bevestigen';
$string['contentchanged'] = 'Deze inhoud is gewijzigd sinds de laatste keer dat je hem hebt gebruikt.';
$string['contentcopied'] = 'De content is gekopieerd naar het klipbord.';
$string['contentstatefrequency'] = 'Frequentie van opslaan van de inhoud';
$string['contentstatefrequency_help'] = 'In seconden, hoe vaak je wilt dat de gebruiker zijn werk automatisch opslaat. Verhoog deze waarde als er problemen zijn met Ajax-verzoeken.';
$string['contenttype'] = 'Inhoudstype';
$string['contenttypecacheheader'] = 'Content Type Cache';
$string['copyright'] = 'Rechten van gebruik';
$string['copyrightinfo'] = 'Copyrightinformatie';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Bekijk de copyrightinformatie voor deze content.';
$string['couldnotcopy'] = 'Kan bestand niet kopiëren.';
$string['couldnotsave'] = 'Kan bestand niet opslaan.';
$string['create'] = 'Maak';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Update content type cache';
$string['ctcacheconnectionfailed'] = 'Kan niet verbinden met de H5P-hub. Probeer het later opnieuw.';
$string['ctcachedescription'] = 'Om de laatste bibliotheken te kunnen gebruiken, is het belangrijk ervoor te zorgen dat de content type cache up-to-date is. Dit is anders dan het updaten van de bibliotheken zelf.';
$string['ctcachelastupdatelabel'] = 'Laatste update';
$string['ctcacheneverupdated'] = 'Nooit';
$string['ctcachenolibraries'] = 'Geen content types ontvangen van H5P-hub. Probeer later opnieuw.';
$string['ctcachesuccess'] = 'Bibliotheek-cache succesvol geüpdatet!';
$string['ctcachetaskname'] = 'Update content type cache';
$string['currentpage'] = 'Pagina $current van $total';
$string['dataviewreportlabel'] = 'Bekijk antwoorden';
$string['date'] = 'Datum';
$string['disablefileextensioncheck'] = 'Bestandsextensie controleren uitschakelen';
$string['disablefileextensioncheckwarning'] = 'Waarschuwing! Het uitschakelen van het controleren bestandsextensies kan gevolgen hebben voor de beveiliging omdat hierdoor php bestanden kunnen worden geüploaded. Dat kan ervoor zorgen dat hackers kwaadaardige code kunnen uitvoeren op je site. Zorg ervoor dat je weet wat je uploadt.';
$string['disablefullscreen'] = 'Volledig scherm uitschakelen';
$string['disablehubconfirmationmsg'] = 'Wil je de hub nog steeds inschakelen?';
$string['disablehubdescription'] = 'Het wordt sterk aangeraden deze optie ingeschakeld te laten. De H5P-hub zorgt voor een eenvoudige interface om nieuwe content types te halen en bestaande content types up-to-date te houden. In de toekomst zal dit het delen en hergebruiken van content vereenvoudigen. Als deze optie is uitgeschakeld, moet je content types handmatig via upload bestanden installeren en updaten.';
$string['displayoptionalwaysshow'] = 'Altijd tonen';
$string['displayoptionauthoroff'] = 'Gecontroleerd door auteur, standaard uitgeschakeld';
$string['displayoptionauthoron'] = 'Gecontroleerd door auteur, standaard ingeschakeld';
$string['displayoptiondownloadalways'] = 'Altijd';
$string['displayoptiondownloadnever'] = 'Nooit';
$string['displayoptiondownloadpermission'] = 'Alleen tonen wanneer gebruiker toestemming heeft om H5P te exporteren';
$string['displayoptionnevershow'] = 'Nooit tonen';
$string['displayoptionpermissions'] = 'Alleen tonen wanneer de gebruiker permissie heeft H5P te exporteren';
$string['displayoptionpermissionsembed'] = 'Toon alleen wanneer de gebruiker permissie heeft H5P in te bedden';
$string['displayoptions'] = 'Weergaveopties';
$string['download'] = 'Downloaden';
$string['downloadfailed'] = 'Downloaden gevraagde bibliotheek mislukt.';
$string['downloadtitle'] = 'Deze inhoud downloaden als H5P bestand.';
$string['editor'] = 'Editor';
$string['embed'] = 'Inbedden';
$string['embedloginfailed'] = 'Je hebt geen toegang tot deze inhoud. Probeer in te loggen.';
$string['embedtitle'] = 'Bekijk de inbedcode voor deze inhoud.';
$string['empty'] = 'Geen resultaten beschikbaar';
$string['enableabout'] = 'Over H5P knop';
$string['enablecopyright'] = 'Copyright knop';
$string['enabledlrscontenttypes'] = 'LRS afhankelijke inhoudstypes inschakelen';
$string['enabledlrscontenttypes_help'] = 'Dit maakt het mogelijk inhoudstypes te gebruiken die voor correcte werking afhankelijk zijn van een Learning Record Store, zoals het inhoudstype Vragenlijst.';
$string['enabledownload'] = 'Sta downloaden toe';
$string['enableembed'] = 'Inbedden-knop';
$string['enableframe'] = 'Toon activiteitenbalk en frame';
$string['enablehublabel'] = 'Gebruik H5P-hub.';
$string['enablejavascript'] = 'JavaScript moet ingeschakeld zijn.';
$string['enablesavecontentstate'] = 'Inhoudstoestand opslaan';
$string['enablesavecontentstate_help'] = 'Automatisch de huidige toestand van interactieve inhoud opslaan voor iedere gebruiker. Dit betekent dat de gebruiker kan verdergaan waar hij was.';
$string['failedtodownloadh5p'] = 'Downloaden gevraagd H5P-bestand mislukt.';
$string['filenotfoundonserver'] = 'Bestand niet gevonden op de server. Controleer instellingen bestand uploaden.';
$string['filenotimage'] = 'Bestand is geen afbeelding';
$string['filetypenotallowed'] = 'Bestand is niet toegestaan';
$string['finished'] = 'Klaar';
$string['fullscreen'] = 'Volledig scherm';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'H5P bestand';
$string['h5ptitle'] = 'Ga naar H5P.org om nog meer coole inhoud te ontdekken.';
$string['hide'] = 'Verberg';
$string['hideadvanced'] = 'Geavanceerd verbergen';
$string['hubcommunicationdisabled'] = 'Communicatie met H5P-hub is uitgeschakeld vanwege het mislukken van één of meer H5P-vereisten.';
$string['hubisdisabled'] = 'De hub is uitgeschakeld. Je kunt dit opnieuw inschakelen in de instellingen van H5P.';
$string['hubisdisableduploadlibraries'] = 'De H5P-hub is uitgeschakeld totdat dit probleem kan worden opgelost. Je kunt nog steeds bibliotheken uploaden via de "H5P bibliotheken" pagina.';
$string['hubsettingsheader'] = 'Content Types';
$string['hvp:addinstance'] = 'Creéer nieuwe H5P activiteiten';
$string['hvp:getcachedassets'] = 'Vereist voor het bekijken van H5P activiteiten';
$string['hvp:getembedcode'] = 'Bekijk H5P inbedcode wanneer de \'geregeld via permissie\' optie is ingeschakeld';
$string['hvp:getexport'] = 'Download .h5p bestand wanneer de \'geregeld via permissie\' optie is ingeschakeld';
$string['hvp:installrecommendedh5plibraries'] = 'Installeer nieuwe en veilige H5P content types aanbevolen door H5P.org';
$string['hvp:manage'] = 'Bewerk bestaande H5P activiteiten';
$string['hvp:restrictlibraries'] = 'Beperk toegang tot bepaalde H5P content types';
$string['hvp:savecontentuserdata'] = 'Bewaar de voortgang van gebruikers in H5P activiteiten';
$string['hvp:saveresults'] = 'Bewaar de resultaten van voltooide H5P activiteiten';
$string['hvp:updatelibraries'] = 'Nieuwe H5P content types installeren of bestaande updaten';
$string['hvp:userestrictedlibraries'] = 'Gebruik beperkte H5P content types';
$string['hvp:view'] = 'Bekijk en neem deel aan H5P activiteiten';
$string['hvp:viewallresults'] = 'Bekijk alle resultaten voor voltooide H5P activiteiten';
$string['hvp:viewresults'] = 'Bekijk eigen resultaten voor voltooide H5P activiteiten';
$string['installdenied'] = 'Je hebt het recht niet om content types te installeren. Neem contact op met de beheerder van jouw site.';
$string['installedlibraries'] = 'Geïnstalleerde bibliotheken';
$string['intro'] = 'Introductie';
$string['invalidaudioformat'] = 'Ongeldig audiobestandsformat. Gebruik mp3 of wav.';
$string['invalidcontentfolder'] = 'Ongeldige inhoudsmap';
$string['invalidcontenttype'] = 'Het gekozen content type is ongeldig.';
$string['invalidfieldtype'] = 'Ongeldig veldtype';
$string['invalidfile'] = 'Bestand "{a->%filename}" is niet toegestaan. Alleen bestanden met de volgende extensies zijn toegestaan: {$a-%files-allowed}.';
$string['invalidh5ppost'] = 'Kon geplaatste H5P niet ophalen.';
$string['invalidimageformat'] = 'Ongeldig afbeeldingsbestandsformat. Gebruik jpg, png of gif.';
$string['invalidlanguagefile'] = 'Ongeldig taalbestand {$a->%file} in library {$a->%library}';
$string['invalidlanguagefile2'] = 'Ongeldig taalbestand {$a->%languageFile} is toegevoegd aan de library {$a->%name}';
$string['invalidlibrary'] = 'Ongeldige bibliotheek';
$string['invalidlibrarydata'] = 'Ongeldige data voor {$a->%property} in {$a-%library}';
$string['invalidlibrarydataboolean'] = 'Ongeldige data voor {$a->%property} in {$a-%library}. Boolean werd verwacht.';
$string['invalidlibraryname'] = 'Ongeldige bibliotheeknaam: {$a->%name}';
$string['invalidlibrarynamed'] = 'De H5P bibliotheek {$a->library} gebruikt in de content is ongeldig';
$string['invalidlibraryoption'] = 'Ongeldige optie {$a-%option} in {$a->%library}';
$string['invalidlibraryproperty'] = 'Kan eigenschap {$a->%property} in {$a->%library} niet lezen';
$string['invalidmainjson'] = 'Een geldig h5p.json hoofdbestand ontbreekt';
$string['invalidmultiselectoption'] = 'Ongeldige geselecteerde optie in multi-select.';
$string['invalidparameters'] = 'Ongeldige parameters';
$string['invalidselectoption'] = 'Ongeldige gekozen optie in select.';
$string['invalidsemanticsjson'] = 'Ongeldig semantics.json bestand is opgenomen in de library {$a->%name}';
$string['invalidsemanticstype'] = 'Interne H5P fout: onbekend inhoudstype "{$a->@type}" in semantics. Verwijder inhoud!';
$string['invalidstring'] = 'Geleverde string is niet geldig volgens regexp in semantics. (waarde: "{$a->%value}", regexp: \\"{$a->%regexp}"\\)';
$string['invalidtoken'] = 'Ongeldig beveiligingstoken.';
$string['invalidvideoformat'] = 'Ongeldig videobestandsformat. Gebruik mp4 of webm.';
$string['invalidxapiresult'] = 'Er zijn geen xAPI resultaten gevonden voor deze combinatie van content en user id';
$string['javascriptloading'] = 'Wachten op JavaScript...';
$string['libraries'] = 'H5P bibliotheken';
$string['librarydirectoryerror'] = 'De naam van de bibliothekenmap moet overeenkomen met machineName of machineName-majorVersion.minorVersion (uit library.json). (Directory: {$a->%directoryName}, machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Handelingen';
$string['librarylistinstancedependencies'] = 'Afhankelijkheden van instantie';
$string['librarylistinstances'] = 'Instanties';
$string['librarylistlibrarydependencies'] = 'Afhankelijkheden van bibliotheek';
$string['librarylistrestricted'] = 'Beperkt';
$string['librarylisttitle'] = 'Titel';
$string['librarynotselected'] = 'Je moet een content type selecteren.';
$string['license'] = 'Licentie';
$string['licenseCC010'] = 'CC0 1.0 Universeel (CC0 1.0) Publiek Domein Verklaring';
$string['licenseCC010U'] = 'CC0 1.0 Universeel';
$string['licenseCC10'] = '1.0 Generiek';
$string['licenseCC20'] = '2.0 Generiek';
$string['licenseCC25'] = '2.5 Generiek';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 Internationaal';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Versie 1';
$string['licenseV2'] = 'Versie 2';
$string['licenseV3'] = 'Versie 3';
$string['licensee'] = 'Licentie';
$string['licenseextras'] = 'Licenties Extra\'s';
$string['licenseversion'] = 'Licentieversie';
$string['loadingdata'] = 'Gegevens laden.';
$string['lookforupdates'] = 'Zoek H5P updates';
$string['maximumgrade'] = 'Maximaal cijfer';
$string['maximumgradeerror'] = 'Voor een geldige positief heel getal in als maximale punten voor deze activiteit';
$string['maxpostsizetoosmall'] = 'Je PHP post_max_size-waarde is behoorlijk laag. Met de huidige instellingen kun je geen bestanden uploaden groter dan {$a->number} MB. Dit zou een probleem kunnen zijn bij het uploaden van H5Ps, afbeeldingen en video\'s. Gelieve dit te vergroten tot hoger dan 5 MB.';
$string['maxscore'] = 'Maximum score';
$string['maxuploadsizetoosmall'] = 'Je PHP upload_max_filesize-waarde is behoorlijk laag. Met de huidige instellingen kun je geen bestanden uploaden groter dan {$a->number} MB. Dit zou een probleem kunnen zijn bij het uploaden van H5Ps, afbeeldingen en video\'s. Gelieve dit te vergroten tot hoger dan 5 MB.';
$string['missingcontentfolder'] = 'Een geldige inhoudsmap ontbreekt';
$string['missingcontentuserdata'] = 'Fout: Kan geen inhoudsgebruikersdata vinden';
$string['missingcoreversion'] = 'Het systeem kon het onderdeel <em>{$a->%component}</em> van het pakket niet installeren. Er is een nieuwere versie van de H5P plugin vereist. Deze site draait momenteel versie {$a-%current}, terwijl de vereiste versie {$a->%required} of hoger is. Gelieve te upgraden en probeer het daarna opnieuw.';
$string['missingdependency'] = 'Ontbrekende afhankelijkheid {$a->@dep} vereist door {$a->@lib}.';
$string['missinglibrary'] = 'Ontbrekende vereiste bibliotheek {$a->@library}';
$string['missinglibraryfile'] = 'Het bestand "{$a->%file}" ontbreekt in bibliotheek: "{$a->%name}"';
$string['missinglibraryjson'] = 'Kan bestand library.json met geldig json format voor bibliotheek {$a->%name} niet vinden';
$string['missinglibraryproperty'] = 'De vereiste eigenschap {$a->%property} ontbreekt in {$a->%library}';
$string['missingmbstring'] = 'De mbstring PHP extensie is niet geladen. H5P heeft deze nodig om correct te functioneren';
$string['missingparameters'] = 'Ontbrekende parameters';
$string['missinguploadpermissions'] = 'Let erop dat de bibliotheken kunnen bestaan in het bestand dat je hebt geüpload, maar dat je geen nieuwe bibliotheken mag uploaden. Neem hiervoor contact op met de sitebeheerder.';
$string['modulename'] = 'Interactieve inhoud';
$string['modulename_help'] = 'Met de H5P activiteitenmodule maak je interactieve inhoud zoals bijvoorbeeld Interactieve Video, Question Sets, Drag and Drop vragen, Multiple Choice vragen, Presentaties en nog veel meer.

Niet alleen is H5P een authoring tool voor rijke inhoud, maar kun je er ook H5P bestanden mee importeren en exporteren om inhoud eenvoudig te kunnen delen en hergebruiken.

Gebruikersinteracties en scores worden opgeslagen met behulp van xAPI en zijn beschikbaar via het Moodle Cijferboek.

Je kunt interactieve H5P-inhoud toevoegen door een .h5p bestand te uploaden. Je kunt .h5p bestanden maken en downloaden op H5P.org.';
$string['modulenameplural'] = 'Interactieve inhoud';
$string['nextpage'] = 'Volgende pagina';
$string['noanswersubmitted'] = 'Deze gebruiker heeft nog geen antwoord ingediend in de H5P activiteit';
$string['nocontent'] = 'Kan het bestand content.json niet vinden of parsen.';
$string['nocontenttype'] = 'Er is geen content type gespecificeerd.';
$string['nocopyright'] = 'Er is geen copyrightinformatie beschikbaar voor deze inhoud.';
$string['nodata'] = 'Er is geen data beschikbaar die overeenkomt met jouw criteria.';
$string['noextension'] = 'Het bestand dat je hebt geüpload is geen geldig HTML5 pakket (het heeft niet de .h5p bestandsextensie)';
$string['noh5ps'] = 'Er is geen interactieve inhoud beschikbaar voor deze cursus.';
$string['nojson'] = 'Het hoofdbestand h5p.json is niet geldig';
$string['noparameters'] = 'Geen parameters';
$string['noparse'] = 'Kan het hoofdbestand h5p.json niet parsen.';
$string['nopermissiontogettranslations'] = 'Je hebt geen toestemming om vertalingen te ontvangen.';
$string['nopermissiontorestrict'] = 'Je hebt geen toestemming om bibliotheken te beperken.';
$string['nopermissiontosavecontentuserdata'] = 'Je hebt geen toestemming om gebruikersdata van inhoud op te slaan.';
$string['nopermissiontosaveresult'] = 'Je hebt geen toestemming om resultaten voor deze cinhoud op te slaan.';
$string['nopermissiontoupgrade'] = 'Je hebt geen toestemming om bibliotheken te upgraden.';
$string['nopermissiontouploadcontent'] = 'Je hebt geen permissie hier inhoud te uploaden.';
$string['nopermissiontouploadfiles'] = 'Je hebt geen permissie hier bestanden te uploaden.';
$string['nopermissiontoviewcontenttypes'] = 'Je hebt geen permissie de content types te bekijken.';
$string['nopermissiontoviewresult'] = 'Je hebt geen toestemming om de resultaten voor deze inhoud te bekijken.';
$string['nosuchlibrary'] = 'Er is geen bibliotheek met die naam';
$string['notapplicable'] = 'N.v.t.';
$string['nounzip'] = 'Het bestand dat je hebt geüpload is geen geldig HTML5 pakket (We kunnen het niet unzippen)';
$string['noversionattribution'] = 'Naamsvermelding';
$string['noversionattributionnc'] = 'Naamsvermelding-NietCommercieel';
$string['noversionattributionncnd'] = 'Naamsvermelding-NietCommercieel-GeenAfgeleiden';
$string['noversionattributionncsa'] = 'Naamsvermelding-NietCommercieel-GelijkDelen';
$string['noversionattributionnd'] = 'Naamsvermelding-GeenAfgeleideWerken';
$string['noversionattributionsa'] = 'Naamsvermelding-GelijkDelen';
$string['nowriteaccess'] = 'Er is een probleem gedetecteerd met de schrijftoegang op de server. Gelieve ervoor te zorgen dat je server schrijfrechten heeft op je datamap.';
$string['noziparchive'] = 'Je PHP versie ondersteunt ZipArchive niet.';
$string['oldphpversion'] = 'Je PHP versie is verouderd. H5P vereist versie 5.2 om correct te functioneren. Versie 5.6 of hoger wordt aanbevolen.';
$string['onlyupdate'] = 'Alleen bestaande bibliotheken updaten';
$string['options'] = 'Opties';
$string['pd'] = 'Publiek domein';
$string['pddl'] = 'Publiek domein toewijzing en licentie';
$string['pdm'] = 'Publiek domein merkteken';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Er is een post melding vereist voor toegang tot het opgegeven eindpunt.';
$string['previouspage'] = 'Vorige pagina';
$string['privacy:metadata:core_files'] = 'De H5P activiteit slaat bestanden op die zijn geüpload als onderdeel van de H5P inhoud.';
$string['privacy:metadata:core_grades'] = 'De H5P activiteit slaat cijfers op van gebruikers die geantwoord hebben in H5P inhoud.';
$string['privacy:metadata:hvp_content_user_data'] = 'Beschrijft de huidige toestand van de inhoud voor een gebruiker. Wordt gebruikt om inhoud te herstellen naar een eerdere toestand.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Gebruikersdata die is opgeslagen.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Data type identifier.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Markering die aangeeft of data verwijderd zou moeten worden wanneer de inhoud verandert.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'Het ID van de H5P inhoud waartoe de data behoort.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'Het ID van de relatie tussen inhoud en gebruikersdata.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Markering die aangeeft of data vooraf geladen zou moeten worden in inhoud.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Subinhoud van H5P, 0 als dit geen subinhoud is.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'Het ID van de gebruiker van wie de data is.';
$string['privacy:metadata:hvp_events'] = 'Volgt gelogde H5P gebeurtenissen.';
$string['privacy:metadata:hvp_events:content_id'] = 'Het ID van de inhoud waarop de handeling is uitgevoerd, 0 als deze nieuw is of er geen inhoud is.';
$string['privacy:metadata:hvp_events:content_title'] = 'Titel van de inhoud.';
$string['privacy:metadata:hvp_events:created_at'] = 'De tijd dat de gebeurtenis is aangemaakt.';
$string['privacy:metadata:hvp_events:id'] = 'Het unieke ID van de gebeurtenis.';
$string['privacy:metadata:hvp_events:library_name'] = 'De bibliotheek waarop de gebeurtenis invloed had.';
$string['privacy:metadata:hvp_events:library_version'] = 'De versie van de bibliotheek waarop de gebeurtenis invloed had.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Het subtype gebeurtenis, of gebeurtenishandeling.';
$string['privacy:metadata:hvp_events:type'] = 'Het type gebeurtenis.';
$string['privacy:metadata:hvp_events:user_id'] = 'Het ID van de gebruiker die de handeling uitvoerde.';
$string['privacy:metadata:hvp_xapi_results'] = 'Slaat xAPI gebeurtenissen in H5P inhoud op.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Aanvullende informatie die de H5P activiteit kan insturen.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'Het ID van de inhoud waarop de gebeurtenis is uitgevoerd.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Het correcte antwoordpatroon.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'De beschrijving, taak of vraag van de inhoud waarop de handeling is uitgevoerd.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Het unieke ID van de xAPI gebeurtenis.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Het type interactie.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Maximaal haalbare score voor de gebeurtenis.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'Het ID van de bovenliggende inhoud waarop deze gebeurtenis is uitgevoerd. Geen waarde als er geen bovenliggende inhoud is.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Behaalde score voor de gebeurtenis.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Het antwoord dat de gebruiker heeft ingestuurd.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'Het ID van de gebruiker die de handeling heeft uitgevoerd.';
$string['question'] = 'Vraag';
$string['removeoldlogentries'] = 'Oude H5P log entries verwijderen';
$string['removetmpfiles'] = 'Oude tijdelijke H5P bestanden verwijderen';
$string['reportingquestionsremaininglabel'] = 'resterende vragen om te beoordelen';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Score in Cijferboek:';
$string['reportingscoredelimiter'] = 'van';
$string['reportingscorelabel'] = 'Score:';
$string['reportnotsupported'] = 'Niet ondersteund';
$string['reportsubmitgradelabel'] = 'Cijfer indienen';
$string['resizescript'] = 'Neem dit script op je website op als je wilt dat de weergave van de inhoud zich aanpast aan de schermgrootte;';
$string['reuse'] = 'Hergebruik';
$string['reusecontent'] = 'Hergebruik content';
$string['reusedescription'] = 'Hergebruik deze content';
$string['reveal'] = 'Tonen';
$string['reviseserversetupandretry'] = 'Wanneer je je serverinstellingen hebt aangepast, kun je de communicatie met de H5P-hub opnieuw inschakelen via H5P Instellingen.';
$string['score'] = 'Score';
$string['search'] = 'Zoeken';
$string['sendusagestatistics'] = 'Gebruiksstatistieken bijdragen';
$string['sendusagestatistics_help'] = 'Gebruiksstatistieken worden automatisch gerapporteerd om de ontwikkelaars te helpen beter te begrijpen hoe H5P wordt gebruikt en om mogelijke verbeterpunten te bepalen. Lees meer over welke <a {$a}>data verzameld wordt op h5p.org</a>.';
$string['settings'] = 'H5P Instellingen';
$string['showadvanced'] = 'Toon geavanceerd';
$string['showless'] = 'Toon minder';
$string['showmore'] = 'Toon meer';
$string['sitecouldnotberegistered'] = 'Site kon niet worden geregistreerd bij de hub. Neem contact op met je site beheerder.';
$string['sitekey'] = 'Site-sleutel';
$string['sitekeydescription'] = 'De site-sleutel is een geheime code die alleen deze site identificeert bij de hub.';
$string['sitekeyregistered'] = 'Je hebt een unieke sleutel ontvangen die je identificeert met de Hub bij het ontvangen van nieuwe updates. De sleutel kan worden bekeken op de pagina "H5P Instellingen".';
$string['size'] = 'Grootte';
$string['source'] = 'Bron';
$string['sslnotenabled'] = 'Je server heeft SSL niet ingeschakeld. SSL zou ingeschakeld moeten worden voor een veilige verbinding met de H5P-hub.';
$string['startingover'] = 'Je zult opnieuw beginnen.';
$string['sublevel'] = 'Subniveau';
$string['successfullyregisteredwithhub'] = 'Je site is succesvol bij de H5P-hub geregistreerd.';
$string['thumbnail'] = 'Miniatuur';
$string['title'] = 'Titel';
$string['unabletocreatedir'] = 'Kon directory niet aanmaken';
$string['unabletogetfieldtype'] = 'Kon veldtype niet ophalen';
$string['undisclosed'] = 'Niet onthuld';
$string['updatedlibraries'] = '{$a->%old} H5P bibliotheken geüpdatet.';
$string['updatedlibrary'] = '{$a->%old} oude H5P bibliotheek geüpdatet.';
$string['updatelibraries'] = 'Alle bibliotheken updaten.';
$string['upgrade'] = 'H5P upgraden';
$string['upgradebuttonlabel'] = 'Upgraden';
$string['upgradedone'] = 'Je hebt succesvol {$a} inhoudsinstanties geüpgraded.';
$string['upgradeerror'] = 'Er is een fout opgetreden bij het verwerken van de parameters:';
$string['upgradeerrorcontent'] = 'Kan inhoud %id niet upgraden:';
$string['upgradeerrordata'] = 'Kan geen data laden van bibliotheek %lib.';
$string['upgradeerrorparamsbroken'] = 'Parameters verbroken.';
$string['upgradeerrorscript'] = 'Kan geen upgrades script laden voor %lib.';
$string['upgradeheading'] = '{$a} inhoud upgraden';
$string['upgradeinprogress'] = 'Upgraden naar %ver...';
$string['upgradeinvalidtoken'] = 'Fout: Ongeldig beveiligingstoken';
$string['upgradelibrarycontent'] = 'Bibliotheekinhoud upgraden';
$string['upgradelibrarymissing'] = 'Fout: Je bibliotheek ontbreekt!';
$string['upgrademessage'] = 'Je gaat {$a} inhoudsinstantie(s) upgraden. Selecteer upgrade-versie.';
$string['upgradenoavailableupgrades'] = 'Er zijn geen upgrades beschikbaar voor deze bibliotheek.';
$string['upgradenothingtodo'] = 'Er zijn geen inhoudsinstanties om te upgraden.';
$string['upgradereturn'] = 'Terug';
$string['upload'] = 'Uploaden';
$string['uploadlibraries'] = 'Bibliotheken uploaden';
$string['uploadsizelargerthanpostsize'] = 'Je PHP max upload waarde is hoger dan je max post waarde. Dit kan problemen veroorzaken bij sommige installaties.';
$string['user'] = 'Gebruiker';
$string['validatingh5pfailed'] = 'Valideren van h5p-pakket is mislukt.';
$string['validationfailed'] = 'De opgevraagde H5P is niet geldig.';
$string['viewreportlabel'] = 'Rapport';
$string['welcomecommunity'] = 'We hopen dat je H5P met plezier gebruikt en betrokken raakt bij onze almaar groeiende community via onze <a {$a->forums}>forums</a>.';
$string['welcomecontactus'] = 'Als je feedback hebt, aarzel dan niet op <a {$a}>contact met ons op te nemen</a>. Wij nemen feedback erg serieus en gaan ervoor H5P iedere dag beter te maken!';
$string['welcomegettingstarted'] = 'Neem om te beginnen met H5P en Moodle een kijkje bij onze <a {$a->moodle_tutorial}>tutorial</a> en bekijk de <a {$a->example_content}>voorbeelden</a> op H5P.org voor inspiratie.';
$string['welcomeheader'] = 'Welkom in de wereld van H5P!';
$string['wrongversion'] = 'De versie van de H5P bibliotheek {$a->%machineName} gebruikt in deze content is niet geldig. De content bevat {$a->%contentLibrary}, maar dit zou {$a->%semanticsLibrary} moeten zijn.';
$string['year'] = 'Jaar';
$string['years'] = 'Jaar';
$string['yearsfrom'] = 'Jaar (vanaf)';
$string['yearsto'] = 'Jaar (tot)';
