<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'via', language 'fr', version '4.0'.
 *
 * @package     via
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Qualitedebase'] = 'Qualité de base';
$string['Qualitestandard'] = 'Qualité standard';
$string['Qualitesuperieure'] = 'Qualité supérieure';
$string['STATUS_INVALID'] = 'La connexion n\'est pas possible.';
$string['absent'] = 'Absent';
$string['accessactivity'] = 'Accéder à votre activité :';
$string['activity_deleted'] = 'L\'activité Via a été supprimée directement depuis l\'environnement Via par un utilisateur. Il est donc impossible d\'y accéder. Nous vous recommandons de supprimer cette activité dans Moodle et d\'en créer une nouvelle.';
$string['activitydeletion'] = 'Limiter la suppression d\'activité';
$string['activitydeletiondesc'] = 'Si cette case est cochée, les activitiés seront supprimées dans Moodle, mais pas dans Via.';
$string['activitydone'] = 'Cette activité est terminée.';
$string['activitytemplatebutton'] = 'Synchroniser les valeurs de modèle d\'activité.';
$string['activitytemplatedesc'] = 'Les valeurs par défaut dans le portail Via (mode d\'enregistrement, le profil multimédia, la salle d’attente, etc.) seront appliquées comme valeur par défaut lors de la création d\'une nouvelle classe virtuelle. Vous devez vous connecter au portail Via, accéder à la section « Modèle d’activité » pour modifier les valeurs par défaut.';
$string['activitytemplateheader'] = 'Modèle d\'activité';
$string['activitytitle'] = 'Titre de l\'activité';
$string['activityversion'] = 'Version';
$string['activityversion_help'] = 'Vous pouvez choisir entre Via classique et Via HTML5. La version ne peut pas être modifiée en mode édition.';
$string['activitywaserased'] = 'Impossible de trouver cette activité sur le serveur SVI. Elle semble avoir été supprimée.';
$string['add'] = 'Ajouter';
$string['adminid_nosuccess'] = 'La clé Moodle n\'est pas valide.';
$string['adminid_success'] = 'La clé Moodle a été testée avec succèss.';
$string['adminid_toolow'] = 'Les droits de l\'utilisateur ne permettront pas la création d\'activités, veuillez contacter l\'administrateur du site pour faire augmenter les droits.';
$string['adminnotrenrolled'] = 'En tant qu\'administrateur vous avez accès à l\'activité sans être inscrit.';
$string['and'] = 'et';
$string['animator'] = 'Animateur';
$string['animators'] = 'Animateurs';
$string['apibranch'] = 'Branche Lära';
$string['apibranchsetting'] = 'Identifiant API de la branche associée à Lära. Les activités et les utilisateurs seront associés à cette branche.';
$string['apiconfig'] = 'Configuration de l\'API - étape 1';
$string['apiid'] = 'Clé API (ApiID)';
$string['apiidsetting'] = 'Identifiant unique donné à ceux qui communiquent avec l\'API. Cette donnée est comparée avec l\'IP du serveur appelant.';
$string['apiportal'] = 'Portail Lära';
$string['apiportalsetting'] = 'Identifiant API du portail associé dans Lära. Les redirections vers les activités seront basées sur l\'URL de ce portail.';
$string['apiurl'] = 'URL de l\'API de Via';
$string['apiurlsetting'] = 'URL de base de l\'API pour Via';
$string['attending'] = 'Je participerai';
$string['audiomodelabel'] = 'Mode audio pour la conférence';
$string['audiorecord'] = 'Audio (MP3)';
$string['audiorecordinfo'] = 'Audio seulement';
$string['automatic'] = 'Automatique';
$string['automaticenrol'] = 'Inscription automatique';
$string['availabledate'] = 'Disponible dès le';
$string['awaitingauthorization'] = 'En attente d\'autorisation (manuelle)';
$string['backup'] = 'Inclure dans la sauvegarde de cours';
$string['backup_options'] = 'Sauvegarde d\'activité et options de duplication';
$string['backupdesc'] = 'Si cette case est cochée, les sondages d\'une activité seront inclus dans la sauvegarde du cours. Les documents sont toujours inclus dans ce processus tandis que l\'ajout des utilisateurs est facultatif.';
$string['basedon'] = 'Le statut de présence est basé sur {$a} minutes.';
$string['by'] = 'par';
$string['cancel'] = 'Annuler';
$string['cat_check'] = 'Ajouter';
$string['cat_default'] = 'Par défaut';
$string['cat_intro'] = 'Choisissez les catégories de Via que vous voulez rendre disponible dans Moodle.';
$string['cat_name'] = 'Noms des catégories';
$string['categoriesheader'] = 'Catégories';
$string['category'] = 'Choisissez une catégorie';
$string['cats_modified'] = 'Les catégories ont été modifiées avec succès !';
$string['choosecategories'] = 'Configurez les catégories';
$string['choosehost'] = 'Un seul présentateur peut être associé à l\'activité. Pour choisir un nouveau présentateur, simplement ajouter un utilisateur comme présentateur. Il sera automatique substitué.';
$string['cieid'] = 'Clé Via (CieID)';
$string['cieidsetting'] = 'Identifiant de l\'organisation à laquelle l\'utilisateur est associé dans Via.';
$string['config'] = 'Configuration';
$string['configassist'] = 'Assistant de configuration';
$string['confirmation'] = 'Confirmation des participants';
$string['confirmationstatus'] = 'Confirmation de la présence';
$string['confirmdelete'] = 'Voulez-vous vraiment supprimer cet enregistrement définitivement ?';
$string['confirmed'] = 'Présence confirmée';
$string['confirmneeded'] = 'Vous devez confirmer votre présence';
$string['connectsuccess'] = 'Connexion à l\'API réussie avec succès.';
$string['conntest'] = 'Test de connexion';
$string['createdby'] = 'Rapport généré par :';
$string['creationdate'] = 'Date de création du rapport :';
$string['date'] = 'Date de l\'activité';
$string['delete'] = 'Supprimer';
$string['delete_activity'] = 'Supprimer cette activité';
$string['deleteconfirm'] = 'Voulez-vous vraiment supprimer cette activité ?';
$string['desactivatedMessage'] = 'Cette activité et ses enregistrements ou documents associés ont été supprimés et ne sont plus accessibles. Merci de supprimer cette activité du cours.';
$string['description'] = 'Description';
$string['df_button_manage'] = 'Gérer le contenu';
$string['df_header_download'] = 'Télécharger';
$string['df_header_nbpages'] = 'Pages';
$string['df_header_size'] = 'Taille';
$string['df_header_title'] = 'Titre';
$string['df_header_type'] = 'Type';
$string['df_nofiles'] = 'Aucun téléchargement';
$string['df_type_0'] = 'Non-catégorisé';
$string['df_type_1'] = 'Image JPG';
$string['df_type_10'] = 'Vidéo AVI';
$string['df_type_11'] = 'Vidéo MPG';
$string['df_type_12'] = 'Vidéo WMV';
$string['df_type_13'] = 'Vidéo MOV';
$string['df_type_14'] = 'Audio MP3';
$string['df_type_15'] = 'Audio WAV';
$string['df_type_16'] = 'Audio WMA';
$string['df_type_17'] = 'Audio OGG';
$string['df_type_18'] = 'Présentation Powerpoint';
$string['df_type_19'] = 'URL';
$string['df_type_2'] = 'Image BMP';
$string['df_type_20'] = 'Fichier MP4';
$string['df_type_21'] = 'Document Word';
$string['df_type_22'] = 'Document Excel';
$string['df_type_23'] = 'Fichier OD';
$string['df_type_24'] = 'Fichier SXW';
$string['df_type_25'] = 'Document RTF';
$string['df_type_26'] = 'Fichier WPD';
$string['df_type_27'] = 'Fichier Text';
$string['df_type_28'] = 'Fichier ODS';
$string['df_type_29'] = 'Fichier SXC';
$string['df_type_3'] = 'Image PNG';
$string['df_type_30'] = 'Fichier CSV';
$string['df_type_31'] = 'Fichier TSV';
$string['df_type_32'] = 'Fichier ODP';
$string['df_type_33'] = 'Fichier SXI';
$string['df_type_34'] = 'Fichier ODG';
$string['df_type_35'] = 'Lien HTML';
$string['df_type_36'] = 'Présentation Powerpoint';
$string['df_type_37'] = 'Document Word';
$string['df_type_38'] = 'Présentation Powerpoint';
$string['df_type_39'] = 'Document Excel';
$string['df_type_4'] = 'Image GIF';
$string['df_type_40'] = 'Présentation Powerpoint';
$string['df_type_41'] = 'Lien HTM';
$string['df_type_42'] = 'Présentation Powerpoint';
$string['df_type_43'] = 'Tableau blanc';
$string['df_type_44'] = 'Sondage';
$string['df_type_45'] = 'Vidéo M4V';
$string['df_type_46'] = 'Audio M4A';
$string['df_type_47'] = 'Vidéo MKV';
$string['df_type_48'] = 'Séquence GIF';
$string['df_type_5'] = 'Image PICT';
$string['df_type_6'] = 'Document PDF';
$string['df_type_7'] = 'Image TIFF';
$string['df_type_8'] = 'Fichier SWF';
$string['df_type_9'] = 'Vidéo Flash';
$string['displayuserlist'] = 'Afficher la liste des utilisateurs associés à tous';
$string['displayuserlistdesc'] = 'Si cochée, tous les utilisateurs seront en mesure de voir les autres utilisateurs associés à l\'activité.';
$string['donousewaitingroom'] = 'Ne pas utiliser (désactiver)';
$string['downloadablefiles'] = 'Contenu téléchargeable';
$string['downloadplaybacks'] = 'Télécharger les enregistrements';
$string['downloadplaybacksdesc'] = 'Si cette case est cochée, les utilisateurs avec des rôles d\'édition seront autorisés à télécharger des enregistrements  Via. Avant de cocher cette case, veuillez contacter SVIesolutions pour valider que votre serveur le permet.';
$string['duplication'] = 'Inclure dans la duplication';
$string['duplicationdesc'] = 'Si cette case est cochée, les sondages d\'une activité seront inclus à la nouvelle activité créée pendant le processus de duplication. Les utilisateurs et les documents sont toujours inclus dans ce processus.';
$string['duration'] = 'Durée (minutes)';
$string['durationheader'] = 'Durée';
$string['edit'] = 'Modifier';
$string['editrecord'] = 'Modification d\'un enregistrement';
$string['email_personnalised_options'] = 'Personnalisez vos rappels et courriels d\'invitation Via';
$string['emailaccesslinkcolor'] = 'Couleur du lien d\'accès du courriel';
$string['emailaccesslinkcolor_desc'] = 'Cela s\'appliquera au lien d\'accès de vos rappels et courriels d\'invitation Via.
Nous vous recommandons d\'utiliser une couleur différente de celle des autres liens, celui-ci étant plus important.';
$string['emailheaderbgcolor'] = 'Couleur de fond du titre des courriels';
$string['emailheaderbgcolor_desc'] = 'Cela s\'appliquera au fond du titre et à l\'arrière plan des images des rappels et courriels d\'invitation Via.';
$string['emailheadercolor'] = 'Couleur du titre des courriels';
$string['emailheadercolor_desc'] = 'Cela s\'appliquera au rappel et aux courriels d\'invitation Via, ainsi qu\'au nom de votre Moodle';
$string['emailheaderimage'] = 'Image de l\'entête du courriel';
$string['emailheaderimage_desc'] = 'Une image par défaut a été ajoutée, vous pourrez la changer à tout moment. Les dimensions par défaut des images sont 750 x 98 pixels et la partie droite de l\'image a la même couleur que le "emailheaderbgcolor" ci-dessous. IMPORTANT : les courriels ne supportent pas la transparence.';
$string['emaillinkcolor'] = 'Couleur des liens';
$string['emaillinkcolor_desc'] = 'Cela s\'appliquera aux liens de vos rappels et courriels d\'invitation Via, Nous vous recommandons d\'ajouter la même couleur que votre thème.';
$string['emails_alert_address'] = 'Courriels pour l\'envoi d\'avertissements';
$string['emails_alert_addressdesc'] = 'Adresses courriels pour l\'envoi des avertissements de débordement. Si plusieurs courriels, séparer les adresses par des virgules.';
$string['emailtextcolor'] = 'Couleur du texte des courriels';
$string['emailtextcolor_desc'] = 'Cela s\'appliquera aux textes des rappels et courriels d\'invitation Via à l\'exception des liens et du titre.';
$string['enddate'] = 'Termine le';
$string['enrolmentheader'] = 'Inscription des participants';
$string['enrolmenttype'] = 'Type d\'inscription';
$string['enrolmenttype_help'] = 'Inscription automatique : tous les utilisateurs inscrits au cours seront ajoutés à l\'activité Via. Si un étudiant est ajouté au cours après la création de l\'activité Via, il sera ajouté lors de la prochaine synchronisation du Cron. Si par contre il accède   à l\'activité avant que le Cron l\'ait ajouté, il sera ajouté à l\'affichage de la page des détails de l\'activité. Les utilisateurs inscrits avec des droits d\'édition dans le cours Moodle seront automatiquement synchronisés comme animateurs, mais cette liste demeure éditable.
Inscription manuelle : les participants doivent être ajoutés à partir de la liste des participants en choisissant le participant parmi la liste des « Participants potentiels » (droite) et ajoutés à l\'aide de la flèche au « Participant actuel » (gauche). Précision : dans les deux modes d\'inscription, l\'utilisateur qui créera l\'activité est ajouté comme présentateur de façon automatique, mais reste éditable, tout comme la liste des animateurs. Il n\'est pas possible d\'avoir plus d\'un présentateur.';
$string['error:ACTIVITYID_EMPTY'] = 'ACTIVITYID_EMPTY - La valeur ActivityID est vide.';
$string['error:ACTIVITYID_INVALID'] = 'ACTIVITYID_INVALID - La valeur passée dans le noeud ActivityID n\'est pas valide.';
$string['error:ACTIVITY_ACCESS_FAILED'] = 'ACTIVITY_ACCESS_FAILED - Lorsque l\'utilisateur n\'est pas associé ou n\'a pas le droit d\'accès à cette rencontre ou que la rencontre n\'est pas encore accessible.';
$string['error:ACTIVITY_DOES_NOT_EXIST'] = 'ACTIVITY_DOES_NOT_EXIST - Doit représenter une activité valide.';
$string['error:ACTIVITY_EXCEED_MAX_USERS'] = 'Nombre maximum d\'utilisateurs atteint';
$string['error:APIID_NOT_FOUND'] = 'APIID_NOT_FOUND - L\'ApiID n\'existe pas. Merci de vérifier les informations de configuration.';
$string['error:APPLY_PERIODICITY_INVALID'] = 'APPLY_PERIODICITY_INVALID - La valeur passée doit être 0 ou 1.';
$string['error:AUTH_FAILED_BAD_APIID'] = 'AUTH_FAILED_BAD_APIID - La valeur APIID n\'est pas autorisée.';
$string['error:AUTH_FAILED_BAD_CIEID'] = 'AUTH_FAILED_BAD_CIEID - La valeur CieID n\'est pas autorisée.';
$string['error:AUTH_FAILED_BAD_IP'] = 'AUTH_FAILED_BAD_IP - Contactez SVIeSolutions pour ajouter cette adresse IP à la liste IP autorisées.';
$string['error:CANNOT_CHANGE_STATE'] = 'CANNOT_CHANGE_STATE - L\'activité ne peut changer d\'état.';
$string['error:CIEID_NOT_FOUND'] = 'CIEID_NOT_FOUND - La CieID n\'existe pas. Merci de vérifier les informations de configuration.';
$string['error:COMPANYNAME_TOO_LONG'] = 'COMPANYNAME_TOO_LONG - La valeur CompanyName dépasse le maximum de 50 caractères.';
$string['error:EMAIL_TOO_LONG'] = 'EMAIL_TOO_LONG - La valeur Email dépasse le  maximum de 100 caractères.';
$string['error:ERROR_AUTH_BAD_CIEID'] = 'ERROR_AUTH_BAD_CIEID - La valeur IP de l\'appelant n\'est pas valide.';
$string['error:ERROR_FAILED_EDIT_USER'] = 'ERROR_FAILED_EDIT_USER - Erreur dans l\'édition. L\'usager n\'a pas été modifié.';
$string['error:ERROR_LOGIN_NO_SPACE_ALLOWED'] = 'ERROR_LOGIN_NO_SPACE_ALLOWED - Le login contient des espaces.';
$string['error:FIRSTNAME_TOO_LONG'] = 'FIRSTNAME_TOO_LONG - La valeur Firsname dépasse le maximum de 50 caractères.';
$string['error:FONCTIONTILE_TOO_LONG'] = 'FONCTIONTILE_TOO_LONG - La valeur Fonction dépasse le maximum de 50 caractères.';
$string['error:INVALID_ACTIVITYID'] = 'INVALID_ACTIVITYID - Lorsque la valeur ID de l\'activité synchrone n\'est pas valide.';
$string['error:INVALID_ACTIVITYSTATE'] = 'INVALID_ACTIVITYSTATE - La valeur passée dans le noeud ActivityState n\'est pas valide.';
$string['error:INVALID_ACTIVITYTYPE'] = 'INVALID_ACTIVITYTYPE - La valeur passée dans le noeud ActivityType n\'est pas valide.';
$string['error:INVALID_AUDIOTYPE'] = 'INVALID_AUDIOTYPE - La valeur passée dans le noeud AudioType n\'est pas valide.';
$string['error:INVALID_CIEID'] = 'INVALID_CIEID - La valeur CIEID doit être une valeur numérique.';
$string['error:INVALID_CONFIRMATION_STATUS'] = 'INVALID_CONFIRMATION_STATUS - La valeur passée dans le noeud ConfirmationStatus n\'est pas valide.';
$string['error:INVALID_DATE'] = 'INVALID_DATE - Date au format AAAA-MM-JJ HH:MM:SS.';
$string['error:INVALID_DURATION'] = 'INVALID_DURATION - La valeur DURATION doit être une valeur numérique.';
$string['error:INVALID_FRIDAY_VALUE'] = 'INVALID_FRIDAY_VALUE - La valeur de la propriété Friday est invalide.';
$string['error:INVALID_GENDER'] = 'INVALID_GENDER - La valeur passée dans le noeud Genre n\'est pas valide.';
$string['error:INVALID_ISNUMBEREDTITLE'] = 'NVALID_ISNUMBEREDTITLE - La valeur passée dans le noeud IsNumberedTitle n\'est pas valide.';
$string['error:INVALID_ISPUBLIC'] = 'INVALID_ISPUBLIC - La valeur ISPUBLIC doit être 0 ou 1.';
$string['error:INVALID_ISRECORDED'] = 'INVALID_ISRECORDED - La valeur passée dans le noeud IsRecorded n\'est pas valide.';
$string['error:INVALID_ISREPLAYALLOWED'] = 'INVALID_ISREPLAYALLOWED - La valeur passée dans le noeud IsReplayAllowed n\'est pas valide.';
$string['error:INVALID_LANGUAGE'] = 'INVALID_LANGUAGE - La valeur passée dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_MAIL_FORMAT'] = 'INVALID_MAIL_FORMAT - Le format du courriel n\'est pas valide.';
$string['error:INVALID_MONDAY_VALUE'] = 'INVALID_MONDAY_VALUE - La valeur de la propriété Monday est invalide.';
$string['error:INVALID_MONTHLYDAY'] = 'INVALID_MONTHLYDAY - La valeur de la journée mensuel n\'est pas valide.';
$string['error:INVALID_NEEDCONFIRMATION'] = 'INVALID_NEEDCONFIRMATION - La valeur passée dans le noeud NeedConfirmation n\'est pas valide.';
$string['error:INVALID_OBJECT_FORMAT'] = 'INVALID_OBJECT_FORMAT - Le INNERXML du soap:body est invalide.';
$string['error:INVALID_PARTICIPANT_TYPE'] = 'INVALID_PARTICIPANT_TYPE - La valeur passée dans le noeud ParticipantType n\'est pas valide.';
$string['error:INVALID_PERIODICITY_ENDDATE'] = 'INVALID_PERIODICITY_ENDDATE - Date au format AAAA-MM-JJ.';
$string['error:INVALID_PERIODICITY_STARTDATE'] = 'INVALID_PERIODICITY_STARTDATE - Date au format AAAA-MM-JJ HH:MM:SS.';
$string['error:INVALID_PHONERIGHT'] = 'INVALID_PHONERIGHT - Le pont téléphonique n\'est pas actif pour cette compagnie.';
$string['error:INVALID_PLAYBACK_ID'] = 'INVALID_PLAYBACK_ID - La valeur ID du playback n\'est pas valide.';
$string['error:INVALID_PROFILID'] = 'INVALID_PROFILID - Le profil n\'est pas valide ou n\'existe pas pour le client.';
$string['error:INVALID_RECNOTIFICATION'] = 'INVALID_RECNOTIFICATION - La valeur passée dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_RECORDMODEBEHAVIOR'] = 'INVALID_RECORDMODEBEHAVIOR - La valeur passée dans le noeud RecordModeBehaviour n\'est pas valide.';
$string['error:INVALID_RECORD_TYPE'] = 'INVALID_RECORD_TYPE - Le type d\'enregistrement n\'est pas valide.';
$string['error:INVALID_REDIRECT_TYPE'] = 'INVALID_REDIRECT_TYPE - La valeur passée au noeud RedirectType n\'est pas valide.';
$string['error:INVALID_REMINDERTIME'] = 'INVALID_REMINDERTIME - La valeur passée dans le noeud ReminderTime n\'est pas valide.';
$string['error:INVALID_ROOMTYPE'] = 'INVALID_ROOMTYPE - La valeur passée dans le noeud RoomType n\'est pas valide.';
$string['error:INVALID_SATURDAY_VALUE'] = 'INVALID_SATURDAY_VALUE - La valeur de la propriété Saturday est invalide.';
$string['error:INVALID_SOAP_FORMAT'] = 'INVALID_SOAP_FORMAT - La requête SOAP n\'a pas été instanciée correctement.';
$string['error:INVALID_STATUS'] = 'INVALID_STATUS - La valeur passée dans le noeud Status n\'est pas valide.';
$string['error:INVALID_SUNDAY_VALUE'] = 'INVALID_SUNDAY_VALUE - La valeur de la propriété Sunday est invalide.';
$string['error:INVALID_THURSDAY_VALUE'] = 'INVALID_THURSDAY_VALUE - La valeur de la propriété Thursday est invalide.';
$string['error:INVALID_TIMEZONE'] = 'INVALID_TIMEZONE - La valeur passée dans le noeud TIMEZONE n\'est pas valide.';
$string['error:INVALID_TITLE_TOO_LONG'] = 'INVALID_TITLE_TOO_LONG - Le titre dépasse le maximum de 100 caractères.';
$string['error:INVALID_TUESDAY_VALUE'] = 'INVALID_TUESDAY_VALUE - La valeur de la propriété Tuesday est invalide.';
$string['error:INVALID_USERID'] = 'INVALID_USERID - La valeur ID de l\'utilisateur n\'est pas valide.';
$string['error:INVALID_USERTYPE'] = 'INVALID_USERTYPE - La valeur passée dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_USER_RIGHT'] = 'NVALID_USER_RIGHT - L\'utilisateur n\'a pas le droit d\'édition ou de création sur les activités.';
$string['error:INVALID_WAITINGROOMACCESSMODE'] = 'INVALID_WAITINGROOMACCESSMODE - La valeur passée dans le noeud WaitingRoomAccesMode n\'est pas valide.';
$string['error:INVALID_WEDNESDAY_VALUE'] = 'INVALID_WEDNESDAY_VALUE - La valeur de la propriété Wednesday est invalide.';
$string['error:LASTNAME_TOO_LONG'] = 'LASTNAME_TOO_LONG - La valeur Lastname dépasse le maximum de 50 caractères.';
$string['error:LOGIN_EMPTY'] = 'LOGIN_EMPTY - La valeur Login est vide.';
$string['error:LOGIN_TOO_LONG'] = 'LOGIN_TOO_LONG - La valeur Login dépasse le maximum de 15 caractères.';
$string['error:LOGIN_USED'] = 'LOGIN_USED - La valeur Login est déjà utilisée.';
$string['error:PASSWORD_EMPTY'] = 'PASSWORD_EMPTY - La valeur Password est vide.';
$string['error:PASSWORD_TOO_LONG'] = 'PASSWORD_TOO_LONG - La valeur Password dépasse le maximum de 15 caractères.';
$string['error:PERIODICITY_NODE_MISSING'] = 'PERIODICITY_NODE_MISSING - La node Périodicité n\'a pas été passé.';
$string['error:PHONEBUS_TOO_LONG'] = 'PHONEBUS_TOO_LONG - La valeur PHONEBUS dépasse le maximum de 20 caractères.';
$string['error:PHONECEL_TOO_LONG'] = 'PHONECEL_TOO_LONG - La valeur PHONECEL dépasse le maximum de 20 caractères.';
$string['error:PHONEHOME_TOO_LONG'] = 'PHONEHOME_TOO_LONG - La valeur PHONEHOME dépasse le maximum de 20 caractères.';
$string['error:PLAYBACK_NOT_PUBLIC'] = 'PLAYBACK_NOT_PUBLIC - Ce playback n\'est pas disponible a tous.';
$string['error:RECORD_NOT_DOWNLOADABLE'] = 'RECORD_NOT_DOWNLOADABLE - L\'enregistrement n\'est pas disponible.';
$string['error:STATUS_INVALID'] = 'La connexion n\'est pas possible.';
$string['error:TITLE_IS_REQUIRED'] = 'TITLE_IS_REQUIRED - Le titre est requis.';
$string['error:TITLE_TOO_LONG'] = 'TITLE_TOO_LONG - La valeur Title dépasse le maximum de 100 caractères.';
$string['error:UNABLE_TO_CREATEDATE'] = 'UNABLE_TO_CREATEDATE - Erreur dans la création des dates de la périodicité.';
$string['error:URL_ERROR'] = 'URL_ERROR - L\'url de l\'API n\'existe pas. Merci de vérifier les informations de configuration.';
$string['error:USERID_EMPTY'] = 'USERID_EMPTY - La valeur UserID est vide.';
$string['error:USER_DOES_NOT_EXIST'] = 'USER_DOES_NOT_EXIST - L\'usager n\'est pas valide.';
$string['error:USER_DOWNLOAD_NOT_ALLOWED'] = 'USER_DOWNLOAD_NOT_ALLOWED - L\'utilisateur n\'a pas le droit de télécharger l\'enregistrement.';
$string['error:_CANNOT_CHANGE_ISNEWVIA'] = 'CANNOT_CHANGE_ISNEWVIA - Une fois que l\'activité a été accédée, il n’est plus possible de modifier la version de Via pour celle-ci.';
$string['error:_INVALID_PROFILID'] = 'INVALID_PROFILID - Le profil n\'est pas valide ou n\'existe pas pour le client.';
$string['error:allseatstaken'] = 'Désolé, tous les sièges disponibles sur le serveur SVI sont pris. Vous ne pouvez donc pas accéder à cette activité pour le moment. Un avis vient d\'être envoyé aux responsables afin de les aviser du débordement. Vous pouvez également envoyé un courriel à <a href=\'mailto:$a->email?subject=Avis de débordement sur Via\'>{$a->email}</a> pour les aviser.<br><br> Veuillez réessayer de vous connecter plus tard.';
$string['error:deletefailed'] = 'La suppression des activités a échoué.';
$string['error:disablereviews'] = 'La désactivation du mode revoir a échoué.';
$string['error:resetparticipants'] = 'Retirer tous les participants et animateurs (fonctionne seulement pour les activités avec inscription manuelle)';
$string['error_user'] = 'Une erreur est survenue, l\'utilisateur {$a} n\'a pas pu être ajouté à l\'activité.';
$string['export'] = 'Visionner/Exporter';
$string['finish'] = 'Complétée';
$string['fullvideo'] = 'Grand format (MP4)';
$string['fullvideoinfo'] = 'Tel que disponible à revoir. Résolution : 1024x768';
$string['gotoactivity'] = 'Accéder';
$string['gotorecording'] = 'Accéder l\'enregistrement';
$string['groupusers'] = 'Les utilisateurs du groupement associé : {$a} ne peuvent pas être dissociés de l\'activité, mais vous pouvez en ajouter.';
$string['hasconfirmed'] = 'Vous avez confirmé votre présence à l\'activité';
$string['hasconfirmednot'] = 'Vous avez confirmé que vous ne serez pas présent à l\'activité.';
$string['headerduration'] = 'Durée';
$string['hidelist'] = 'Cacher';
$string['highquality'] = 'Qualité haute';
$string['host'] = 'Hôte';
$string['host_replace'] = 'Remplacer l\'hôte';
$string['html5activation'] = 'Utiliser via HTML5';
$string['html5activationdesc'] = 'Si cette case est cochée, vous aurez la possibilité de choisir entre Via et Via HTML5 lors de la création d\'une classe virtuelle.';
$string['incomplete'] = 'Incomplète';
$string['inhostabsence'] = 'En l\'absence du présentateur (automatique)';
$string['inviteclicktoaccesshtml'] = 'Pour accéder à l\'activité, cliquez sur ce lien :';
$string['inviteemail'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

L\'actitivé « {$a->title} » qui aura lieu le {$a->datebegin} de {$a->hourbegin} à {$a->hourend}.

{$a->invitemsg}

---------------------------------------------------------------------
Préparation à l\'activité

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}
Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Accès Web

Pour accéder à l\'activité, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------


Attention : chaque activité peut être enregistrée. Merci de ne pas y accéder si vous ne voulez pas être enregistré. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas être partagées.';
$string['inviteemail_viahtml5'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

Moodle vous invite à participer à l\'activité  &quot; {$a->title} &quot; qui se déroulera le {$a->datebegin} entre {$a->hourbegin} et {$a->hourend}

{$a->invitemsg}

---------------------------------------------------------------------
Accès web

Pour accéder à l\'activité, utilisez ce lien : {$a->activitylink}

---------------------------------------------------------------------';
$string['inviteemailhtml'] = '<p>Bonjour {$a->username},</p>
<p>L\'activité &laquo; {$a->title} &raquo; aura lieu le <b>{$a->datebegin}</b> de <b>{$a->hourbegin}</b> à <b>{$a->hourend}</b>.</p><p>{$a->invitemsg}</p>';
$string['inviteemailhtmlpermanent'] = '<p>Bonjour {$a->username},</p>

<p>{$a->invitemsg}</p>';
$string['inviteemailpermanent'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

{$a->invitemsg}

---------------------------------------------------------------------
Préparation à l\'activité

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}
Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Accès Web

Pour accéder à l\'activité, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------

Attention : chaque activité peut être enregistrée. Merci de ne pas y accéder si vous ne voulez pas être enregistré. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas être partagées.';
$string['inviteemailpermanent_viahtml5'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

{$a->invitemsg}

---------------------------------------------------------------------
Accès web

Pour accéder à l\'activité, utilisez ce lien : {$a->activitylink}

---------------------------------------------------------------------';
$string['inviteemailsubject'] = 'INVITATION : {$a->title}';
$string['invitepreparationhtml'] = 'Préparation à l\'activité';
$string['invitessend'] = 'Les courriels d\'invitation seront envoyés d\'ici 15 minutes.';
$string['invitessent'] = 'Les courriels ont été envoyés.';
$string['invitewarninghtml'] = 'Attention : chaque activité peut être enregistrée. Merci de ne pas y accéder si vous ne voulez pas être enregistré. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas être partagées.';
$string['invitewebaccesshtml'] = 'Accès Web';
$string['ish264'] = 'Activer le mode vidéo pour les appareils mobiles';
$string['ish264_help'] = 'Si vous cochez la case, un codec vidéo moins performant sera utilisé et les gens sur mobiles pourront voir les vidéos des participants. Si la case n\'est pas cochée, un codec vidéo plus performant (H264) sera utilisé et les utilisateurs sur mobiles ne recevront pas les vidéos des participants, mais seulement la voix. Ils auront, malgré tout, accès à l\'ensemble des autres fonctions multimédia (documents, annotations, partage d\'écran, etc.).';
$string['list_activities'] = 'Liste de toutes les activités Via dans ce cours';
$string['lowquality'] = 'Qualité basse';
$string['manageparticipants'] = 'Gérer les utilisateurs';
$string['manual'] = 'Manuel';
$string['manualenrol'] = 'Inscription manuelle';
$string['mask'] = 'Afficher';
$string['mediumquality'] = 'Qualité moyenne';
$string['mobilevideo'] = 'Mobile (MP4)';
$string['mobilevideoinfo'] = 'Optimisé pour un affichage réduit. Résolution : 480x320';
$string['mode'] = 'Mode audio';
$string['modephone'] = 'Conférence téléphonique seulement';
$string['modevoiceweb'] = 'Voix par Internet';
$string['modewebphone'] = 'Voix par conférence téléphonique';
$string['modulename'] = 'Via';
$string['modulename_help'] = 'Le module Via vous permet de créer des rencontres en classe virtuelle synchrone afin d\'échanger en  direct à l\'aide de la voix et la vidéo pour :
- Des classes à distance en temps réel
- Des réunions
- Des rencontres pour les travaux d\'équipes
- Du tutorat
- Des séminaires
- Etc.

L\'outil permet de gérer des sous-groupes de travail, d\'annoter, de partager son écran, d\'importer/présenter des documents et d\'échanger par la voix/vidéo.

L\'option « Inscription des participants » vous permet d\'inscrire manuellement les participants ou encore de les synchroniser automatiquement avec les droits de votre espace Moodle par la sélection de l\'option « Inscription automatique ».

La section « Paramètres de sessions » vous permet de paramétrer l\'enregistrement des rencontres et la disponibilité de ces derniers pour vos apprenants.

Précision : l\'édition et la modification des enregistrements doivent se faire dans l\'environnement Via.';
$string['modulenameplural'] = 'Via';
$string['moodle_adminid'] = 'Clé Admin Moodle';
$string['moodle_config'] = 'Configuration de l\'API - étape 2';
$string['moodleidsetting'] = 'ID Administrateur unique pour ce Moodle';
$string['multimediaquality'] = 'Qualité multimédia';
$string['multimediaquality_help'] = 'Sélectionnez le profil multimédia à utiliser dans l\'activité pour les échanges multimédias (caméra Web, microphone et documents multimédias). Cette option peut avoir un impact important sur la fluidité des échanges et sur la bande passante nécessaire pour chaque participant. De façon générale, pour une meilleure expérience ou si vous êtes incertain, il est préférable d\'utiliser une qualité moindre pour assurer la fluidité des échanges. Il est possible de faire configurer d\'autres profils multimédia en fonction de vos besoins spécifiques (par exemple de grandes vignettes vidéo d\'excellente qualité pour une utilisation en mode local). Contactez un de nos experts Via pour en savoir davantage à ce sujet.';
$string['multiple'] = 'Multiple';
$string['mustaccept'] = 'Cochez la case pour accéder à l\'activité.';
$string['name'] = 'Nom';
$string['needconfirmation'] = 'Confirmation de disponibilité';
$string['needconfirmation_help'] = 'Confirmation de disponibilité';
$string['neverbegin'] = 'À faire';
$string['no_categories'] = 'Il n\'y a aucune catégorie de disponible, celles-ci doivent être créées dans le portail Via par un administrateur.';
$string['no_default'] = 'Aucune catégorie par défaut.';
$string['noanimators'] = 'Aucun animateur n\'est inscrit à cette activité.';
$string['nocategories'] = 'Aucune catégorie';
$string['noparticipants'] = 'Aucun participant n\'est inscrit à cette activité.';
$string['noparticipants_help'] = 'Cette option est disponible seulement en mode d\'inscription automatique et fait en sorte que les utilisateurs ayant le statut d\'étudiant sont tous inscrits avec les droits d\'animateurs dans via.';
$string['noparticipantscheckbox'] = 'Ajouter les étudiants comme animateurs.';
$string['norecall'] = 'Aucun rappel';
$string['notactivated'] = 'Désactivé';
$string['notactivatedfeminin'] = 'Désactivée';
$string['notattending'] = 'Je ne participerai pas';
$string['notenrolled'] = 'Vous n\'êtes pas inscrit à cette activité. Contactez le professeur du cours si vous croyez que vous devez y avoir accès.';
$string['noticeclicktoaccesshtml'] = 'Cliquez sur le lien ci-dessous pour un accès direct :';
$string['noticeemail'] = 'Bonjour {$a->username},

Ceci est un message automatisé.

L\'exportation en format {$a->type} demandé pour l\'enregistrement &quot;{$a->playbacktitle}&quot; est terminée depuis le {$a->date}.
Vous pouvez accéder aux détails de votre activité &quot;{$a->activitytitle}&quot; pour télécharger votre enregistrement ou les rendre disponibles aux participants.

---------------------------------------------------------------------

Cliquez le lien suivant pour un accès direct : {$a->activitylink}

---------------------------------------------------------------------';
$string['noticeemailhtml'] = '<p>Bonjour {$a->username},</p>
<p>Ceci est un message automatisé.</p>
<p>L\'exportation en format {$a->type} demandé pour l\'enregistrement « {$a->playbacktitle} » est terminée depuis le {$a->date}.<br/>
Vous pouvez accéder aux détails de votre activité « {$a->activitytitle} » pour télécharger votre enregistrement ou les rendre disponibles aux participants.</p>';
$string['noticeemailsubject'] = 'ALERTE : Exportation enregistrement';
$string['notificationemail'] = 'Bonjour {$a->username},

Ceci est un message automatique.

L’utilisateur {$a->userfrom} essaie de vous contacter en se connectant à votre activité: «{$a->activitytitle} »

Accès Web
---------------------------------------------------------------------

Cliquez sur le lien suivant pour un accès direct : {$a->activitylink}

---------------------------------------------------------------------';
$string['notificationemailhtml'] = '<p>Bonjour {$a->username},</p>
<p>Ceci est un message automatique.</p>
<p>L’utilisateur {$a->userfrom} essaie de vous contacter en se connectant à votre activité: &quot;{$a->activitytitle} &quot;</p>';
$string['notificationemailsubject'] = 'ALERTE : notification d\'activité';
$string['notifysuccess_synch1'] = 'Tous les utilisateurs ont été synchronisés avec succès avec Via.';
$string['notifysuccess_synch2'] = 'Certains utilisateurs ne peuvent pas être synchronisés, s\'il vous plaît valider leurs informations et essayer à nouveau.';
$string['notstarted'] = 'Cette activité n\'a pas encore débuté.';
$string['nounifiedrecordpermanent'] = 'Le mode « Unifié » n\'est pas possible pour une activité permanente. Veuillez sélectionner un choix différent.';
$string['nousers'] = 'Attention - Il n\'y a aucun utilisateur associé à cette activité !';
$string['oldapiversion'] = 'Vous utilisez une version anterieur à {$a} de l\'API';
$string['options'] = 'Options pour l\'activité';
$string['overview'] = 'Débute le {$a->start} et se termine le {$a->end}';
$string['participant'] = 'Participant';
$string['participantmustconfirm'] = 'Confirmation de disponibilité';
$string['participantmustconfirmdesc'] = 'Si cette option est cochée, l\'option est disponible lors de la création des nouvelles activités. Une colonne de plus apparaitra dans la liste des participants avec leur disponibilité.';
$string['participants'] = 'Participants';
$string['participants_search'] = 'Recherche de participants';
$string['participantsynchronization'] = 'Synchroniser les informations des participants';
$string['participantsynchronizationdesc'] = 'Cette option permet de synchroniser les informations des utilisateurs, incluant leur avatar, lors de leur connexion à Via. Même si cette option est cochée, le code d\'utilisateur Via, le type d\'utilisateur Via et le mot de passe dans Via ne seront pas mis à jour.';
$string['passdate'] = 'La date sélectionnée est dépassée.';
$string['permanent'] = 'Activité permanente';
$string['permanent_help'] = 'Cocher l\'option « Permanente » afin de rendre votre activité toujours accessible, sans date précise. Vous serez alors dans l\'obligation d\'utiliser la salle d\'attente afin d\'en limiter l\'accès aux utilisateurs inscrits ayant le statut « participant ».';
$string['permanentactivities'] = 'Activités permanentes';
$string['permanentactivitiesdesc'] = 'Cochez cette case si vous désirez que vos utilisateurs puissent créer des activités permanentes (qui n\'ont pas de date de début et de fin).';
$string['personalinvitemsg'] = 'Message personnalisé :';
$string['playbackSynchronize'] = 'Synchroniser les enregistrements';
$string['playback_downloaded'] = 'Enregistrement téléchargé';
$string['playback_viewed'] = 'Enregistrement visionné';
$string['playbackaccesstype0'] = 'Visible pour les utilisateurs avec droits d\'édition';
$string['playbackaccesstype1'] = 'Visible pour les utilisateurs associés à la classe virtuelle';
$string['playbackaccesstype2'] = 'Visible pour les utilisateurs associés à l\'activité déléguée';
$string['playbackaccesstypelbl'] = 'Droits d\'accès pour l\'enregistrement';
$string['playbackheader'] = 'Différé (h:m:s)';
$string['pluginadministration'] = 'Administration de Via';
$string['pluginname'] = 'Via';
$string['portalaccess'] = 'Accès au portail Via.';
$string['portalaccessdesc'] = 'Permet aux utilisateurs d\'accéder au portail Via à partir de leur état de session dans Moodle. En effet, lorsque l\'utilisateur accès  à une activité Via à partir de Moodle, son état de session est actif dans le portail Via et il est en mesure, simplement en ouvrant un nouvel onglet de son navigateur et en accédant au portail, de s\'y connecter sans avoir à entrer de code utilisateur/mot de passe. Autrement, si l\'option n\'est pas activée, l\'utilisateur ne peut pas se connecter au portail Via à partir de son état de session Moodle.';
$string['potentialusers'] = 'Participants potentiels';
$string['preparation'] = 'Préparer votre activité';
$string['prepareactivity'] = 'Préparer votre activité.';
$string['presence'] = 'Temps minimum requis de présence';
$string['presence_help'] = 'Valeur correspondante à la durée en minutes à partir de laquelle l\'utilisateur obtient le statut de présence pour l\'activité.';
$string['presenceheader'] = 'Présence en direct (h:m:s)';
$string['presenceheaderreport'] = 'Présence en direct';
$string['presencestatus'] = 'Rapport de présence sur les activités';
$string['presencestatusdesc'] = 'Si cette case est cochée, il vous est alors possible de fixer un temps minimum de présence (en minutes) afin que vos utilisateurs soient considérés comme présents dans votre activité. Ainsi, si vous fixez à 50 minutes le seuil de présence pour votre activité, et que votre utilisateur s\'y connecte pendent 48 minutes, il sera considéré comme absent par le système.';
$string['presencetable'] = 'Statut de présence :';
$string['presencewarning'] = 'Important : le Statut de présence en direct est déterminé en fonction du temps minimum requis pour être considéré présent pour cette activité. Ce statut influence la barre de progression du participant dans le déroulement de son parcours. Il vous est possible d\'ajuster ce statut en modifiant la valeur « Temps minimum requis de présence » dans les paramètres de l\'activité.';
$string['present'] = 'Présent';
$string['recalloneday'] = 'Un jour avant';
$string['recallonehour'] = 'Une heure avant';
$string['recalloneweek'] = 'Une semaine avant';
$string['recalltwodays'] = 'Deux jours avant';
$string['recalltwohours'] = 'Deux heures avant';
$string['recentrecordings'] = 'Enregistrement récent';
$string['recordaccept'] = 'J\'accepte';
$string['recording'] = 'Enregistrement';
$string['recordingisdownloadable'] = 'L\'enregistrement est téléchargeable';
$string['recordingisdownloadableinfo'] = 'Important : vous devez d\'abord exporter la vidéo afin qu\'elle soit disponible pour téléchargement.';
$string['recordingmode'] = 'Mode d\'enregistrement';
$string['recordingmode_help'] = 'Si vous désirez activer l\'enregistrement de vos activités, deux modes sont offerts : « Unifié » et « Multiple ». La fonction d\'enregistrement unifié produira un enregistrement unique peu importe le nombre d\'enregistrements effectués durant la rencontre tandis que les enregistrements multiples sont séparés et segmentés dans la liste.';
$string['recordings'] = 'Enregistrement(s) disponible(s) :';
$string['recordingtitle'] = 'Titre de l\'enregistrement';
$string['recordmodebehavior'] = 'Enregistrement';
$string['recordmodebehavior_help'] = 'En plus du mode, vous pouvez également décider de démarrer automatiquement l\'enregistrement à l\'accès en utilisant l\'option « Automatique ». Choisissez l\'option « Manuel » si vous ne désirez pas que l\'enregistrement démarre automatiquement à l\'accès. Vous devrez alors démarrer l\'enregistrement vous-même en accédant à l\'interface synchrone.';
$string['recordwarning'] = 'Les activités peuvent être enregistrées. En cochant cette case, vous acceptez d\'être enregistré.';
$string['refused'] = 'Ne sera pas présent';
$string['reminderemail'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

L\'actitivé « {$a->title} » qui aura lieu le {$a->datebegin} de {$a->hourbegin} à {$a->hourend}.

---------------------------------------------------------------------
Préparation à l\'activité

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}

Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Accès Web

Pour accéder à l\'activité, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------

Attention : chaque activité peut être enregistrée. Merci de ne pas y accéder si vous ne voulez pas être enregistré. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas être partagées.';
$string['reminderemail_viahtml5'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

Moodle vous invite à participer à l\'activité  &quot; {$a->title} &quot; qui se déroulera le {$a->datebegin} entre {$a->hourbegin} et {$a->hourend}

---------------------------------------------------------------------
Accès web

Pour accéder à l\'activité, utilisez ce lien : {$a->activitylink}

---------------------------------------------------------------------';
$string['reminderemailhtml'] = '<p>Bonjour {$a->username}, reminderemailhtml</p>
<p>Ceci est un rappel pour une activité qui aura lieu sous peu :</p>
<p><b>Titre :</b> {$a->title}<br/>
<b>Date et heure :</b> {$a->activitydate}<br/>
<b>Durée :</b> {$a->duration} minutes</p>';
$string['reminderemailsubject'] = 'RAPPEL : {$a->title}';
$string['replace_host'] = 'Remplacer l\'hôte';
$string['report'] = 'Rapport de présence';
$string['resetdeletemodules'] = 'Supprimer toutes les activités';
$string['resetdisablereviews'] = 'Désactiver le revisionnement des activités';
$string['resetparticipants'] = 'Retirer tous les participants et animateurs (fonctionne seulement pour les activités avec inscription manuelle)';
$string['return'] = 'Retour';
$string['returnto'] = 'Retour à l\'activité';
$string['reviewacitvity'] = 'Rendre public tous les enregistrements par défaut';
$string['reviewacitvity_help'] = 'Dans le cas où vous désirez rendre tous les enregistrements disponibles au visionnement, sélectionnez l\'option « Rendre public tous les enregistrements par défaut ». Dans le cas contraire, aucun participant ne pourra visionner les enregistrements à moins de les cocher individuellement dans la liste. Veuillez noter que cette option est modifiable en tout temps, même lorsque l\'activité est terminée.';
$string['reviewactivity'] = 'Cliquez ici pour revoir l\'activité.';
$string['reviewactivity_help'] = 'Sélectionnez qui peut voir les enregistrements.';
$string['role'] = 'Rôle';
$string['roomtype'] = 'Type d\'activité';
$string['roomtype_help'] = 'Le type « Standard » est une activité dans laquelle tous les participants sont listés et peuvent interagir normalement, selon le rôle attribué. Si vous choisissez plutôt une activité de type « Webinaire », seuls le présentateur et les animateurs verront les noms des participants. De plus, ces derniers ne pourront interagir autrement que par le clavardage. Ce dernier type est idéal pour les activités comprenant de larges audiences (plus de 100 participants) ou pour des activités confidentielles.
Lorsque l\'option « Permanente » est sélectionnée, l\'activité n\'aura alors plus de date et d\'heure fixe. Tous les participants associés à cette activité pourront alors y accéder à n\'importe quel moment. Veuillez prendre note que seul le mode d\'enregistrement multiple est disponible pour ce type d\'activité.';
$string['roomversion'] = 'Choisissez la version de Via';
$string['roomversion_help'] = 'Choisissez la version de Via que vous voulez utiliser pour cette activité, une fois sauvegardé, ceci n\'est pas modifiable.';
$string['save'] = 'Enregistrer';
$string['seminar'] = 'Webinaire';
$string['sendinvitation'] = 'Envoyer courriel d\'invitation';
$string['sendrecall'] = 'Envoyer un courriel de rappel';
$string['sendrecall_help'] = 'Permet de fixer un rappel automatique selon la période demandée. Vous pouvez choisir d\'envoyer un rappel automatiquement à tous les participants 1 ou 2 heures avant, 1 ou 2 jours avant et même 1 semaine avant la tenue de l\'activité. Ils recevront alors le rappel directement par courriel.';
$string['sessionparameters'] = 'Paramètres de la session';
$string['show'] = 'Cacher';
$string['showlist'] = 'Afficher';
$string['showparticipants'] = 'Afficher la liste des participants';
$string['showparticipants_help'] = 'Vous permet d\'afficher la liste des participants dans l\'activité via en mode webinaire.';
$string['standard'] = 'Standard';
$string['startdate'] = 'Débute le';
$string['submitinvite'] = 'Envoyer les invitations';
$string['subscribeparticipants'] = 'Inscription des usagers';
$string['synctemplateend'] = 'Le modèle d\'activité a été synchronisé avec succès.';
$string['technicalassist'] = 'Assistance technique';
$string['technicalassist_url'] = 'Spécifier une page d\'assistance technique';
$string['technicalassist_urldesc'] = 'Par défaut, la page d\'assistance technique affichera les informations fournies dans Via. Vous pouvez spécifier une page personnalisée d\'assistance en appelant directement l\'URL. Cela peut  être une page créée dans Moodle ou un autre site.';
$string['testadminid'] = 'Tester la clé Moodle';
$string['testconnection'] = 'Tester la connexion à l\'API';
$string['testconnectionhtml5'] = 'Tester la connexion à l\'API HTML5';
$string['timeduration'] = 'Durée :';
$string['title_exists'] = 'Le titre existe déjà, veuillez essayer à nouveau.';
$string['typepInscriptionCoordinator'] = 'Coordinateur';
$string['typepInscriptioncollaborator'] = 'Collaborateur';
$string['typepInscriptionmember'] = 'Participant';
$string['typepInscriptionsetting'] = 'Lors de la création des utilisateurs dans Via, ce droit est octroyé par défaut.';
$string['unified'] = 'Unifié';
$string['unplanned'] = 'Non planifié';
$string['unplanned_error'] = 'Vous pouvez sauvegarder vos modifications uniquement si c\'est une activité planifiée.';
$string['unplanned_text'] = 'Cette activité n\'a pas encore été planifiée.';
$string['unplannedsettings'] = 'Utiliser les activités non planifiées';
$string['unplannedsettings_desc'] = 'Si cette case est cochée, les activités restaurées seront « non planifiées » par défaut. Pour les activer, il faut modifier leurs paramètres et leur attribuer une date ou les définir comme permanentes. Quelles que soient les autres options de duplication, les utilisateurs et les documents ne seront pas copiés.<br/>Si la case n’est pas cochée, les activités restaurées seront définies à un mois plus tard par défaut.';
$string['updatethisvia'] = 'Modifier Via';
$string['userishost'] = 'Cet utilisateur est l\'hôte, choisissez un nouveau afin de donner à cet utilisateur un nouveau rôle.';
$string['users_search'] = 'Recherche de participant potentiel';
$string['usersynch'] = 'Les utilisateurs seront automatiquement associés à l\'activité lorsqu\'ils se connectent. <br/> Si vous souhaitez effectuer une pré-association afin de les affecter à des ateliers, cliquez ici :';
$string['usersynchbtn'] = 'Associer tous les utilisateurs maintenant';
$string['usersynchwarning'] = 'Veuillez patienter, ceci peut prendre un certain temps !';
$string['versionnew'] = 'Utiliser la version la plus récente de Via';
$string['versionold'] = 'Utiliser la version 6 de Via';
$string['versions_not_compatible'] = 'Les versions du module et de VIA ne sont pas compatible. Cette version du module requière un minimum de';
$string['versionscompatible'] = 'Les versions du module et de VIA sont compatible.';
$string['via9'] = 'Via';
$string['via:access'] = 'Accéder à Via sans être associé à l\'activité';
$string['via:addinstance'] = 'Ajouter une activité Via';
$string['via:manage'] = 'Gérer les activités Via';
$string['via:view'] = 'Voir les activités Via';
$string['via:viewpresence'] = 'Voir les rapports de présence pour les activités Via';
$string['via_branchsync_task'] = 'Synchronisation des branches Via';
$string['via_ciesettings_task'] = 'Paramètres de synchronisation VIA';
$string['via_mail_task'] = 'VIA envoi de courriels';
$string['via_notification_task'] = 'Via notifications d\'activité';
$string['via_typepInscription'] = 'Droit par défaut dans Via';
$string['via_usersync_task'] = 'Via synchronisation des utilisateurs';
$string['viaaccessed'] = 'Via accédé';
$string['viaaudiotypes'] = 'Sélectionnez les modes audios que vous voulez conserver.';
$string['viacategoriesdesc'] = 'Si cochée, les catégories créées dans Via peuvent être ajoutées à l\'activité.';
$string['viauserreset'] = 'Réinitialisation des utilisateurs Via';
$string['viauserresetbutton'] = 'Réinitialisation des utilisateurs Via';
$string['viauserresetdesc'] = 'Cette opération supprime l\'association entre Moodle et Via. Vous pouvez l\'utiliser, si vos utilisateurs rencontrent des problèmes pour se connecter.

Une nouvelle association sera créée. Aucune différence ne sera visible pour les utilisateurs. Votre site peut sembler plus lent jusqu\'à ce que l\'opération soit terminée.';
$string['viausers'] = 'Utilisateurs';
$string['viausersresetend'] = 'Réinitialisation complétée avec succès';
$string['view'] = 'Visionner';
$string['vroom'] = 'Via HTML5';
$string['waitingconfirm'] = 'En attente de la confirmation';
$string['waitingroomaccessmode'] = 'Salle d\'attente';
$string['waitingroomaccessmode_help'] = 'L\'option « En attente d\'autorisation » permet au présentateur d\'autoriser individuellement l\'accès des participants tandis que l\'option « En l\'absence du présentateur » vous assure qu\'aucun utilisateur ne pourra accéder à l\'activité tant que le présentateur n\'est pas connecté. Cette dernière option est particulièrement utile lors d\'activités permanentes.';
