<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'fr', version '4.0'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Activités';
$string['addcategory'] = 'Ajouter une catégorie';
$string['addcategoryerror'] = 'Impossible d\'ajouter une catégorie.';
$string['addexceptionerror'] = 'Une erreur est survenue lors de l\'ajout d\'une exception pour userid:gradeitem';
$string['addfeedback'] = 'Ajouter un feedback';
$string['addgradeletter'] = 'Ajouter une note lettre';
$string['addidnumbers'] = 'Ajouter les identifiants';
$string['additem'] = 'Ajouter un élément d\'évaluation';
$string['additionalfeedback'] = 'Feedback supplémentaire';
$string['addoutcome'] = 'Ajouter un objectif';
$string['addoutcomeitem'] = 'Ajouter un élément d\'objectif';
$string['addscale'] = 'Ajouter un barème';
$string['adjustedweight'] = 'Pondération ajustée';
$string['aggregateextracreditmean'] = 'Moyenne des notes (avec bonus)';
$string['aggregatemax'] = 'Note la plus haute';
$string['aggregatemean'] = 'Moyenne des notes';
$string['aggregatemedian'] = 'Médiane des notes';
$string['aggregatemin'] = 'Note la plus basse';
$string['aggregatemode'] = 'Mode des notes';
$string['aggregatenotonlygraded'] = 'Inclure les notes vides';
$string['aggregateonlygraded'] = 'Exclure les notes vides';
$string['aggregateonlygraded_help'] = 'Une note vide est une note manquante dans le carnet de notes. Elle peut provenir d\'un travail qui n\'a pas encore été évalué, d\'un test qui n\'a pas encore été tenté, etc.

Ce réglage détermine si les notes vides sont exclues du calcul des tendances centrales ou si elles sont traitées comme notes minimales (par exemple 0 dans un travail noté de 0 à 20).';
$string['aggregateoutcomes'] = 'Inclure les objectifs dans les tendances centrales';
$string['aggregateoutcomes_help'] = 'Si ce réglage est activé, les objectifs sont inclus dans le calcul des tendances centrales. Dans ce cas, le total de la catégorie peut être inattendu.';
$string['aggregatesonly'] = 'Passer aux tendances centrales seulement';
$string['aggregatesubcatsupgradedgrades'] = 'Remarque : le réglage « Inclure les sous-catégories dans les tendances centrales » a été supprimé au cours de la mise à jour du site. Puisque ce réglage était utilisé antérieurement dans ce cours, il vous est conseillé de vérifier le résultat de cette modification dans le carnet de notes.';
$string['aggregatesum'] = 'Naturelle';
$string['aggregateweightedmean'] = 'Moyenne pondérée des notes';
$string['aggregateweightedmean2'] = 'Simple moyenne pondérée des notes';
$string['aggregation'] = 'Tendance centrale';
$string['aggregation_help'] = 'La tendance centrale détermine comment les notes d\'une catégorie sont combinées.

* Moyenne des notes : la somme de toutes les notes divisée par le nombre total de notes.
* Médiane des notes : la note du milieu de la liste, lorsque les notes sont classées par ordre de grandeur.
* Note la plus basse.
* Note la plus haute.
* Mode des notes : la note qui revient le plus souvent dans la liste.
* Naturelle : la somme de toutes les notes pondérées.';
$string['aggregationcoef'] = 'Coefficient';
$string['aggregationcoefextra'] = 'Bonus';
$string['aggregationcoefextra_help'] = 'Lorsque la tendance centrale choisie est la « Naturelle » ou « Moyenne simple pondérée » et que la case « Bonus » est cochée, la note maximale de l\'élément d\'évaluation n\'est pas comptée dans le maximum du total des notes. Cela a pour conséquence qu\'il est possible d\'obtenir la note maximale (ou une note dépassant la note maximale, si l\'administrateur du site a activé cette possibilité) dans la catégorie sans obtenir la note maximale dans tous les éléments d\'évaluation.

Si la tendance centrale choisie est « Moyenne des notes (avec points supplémentaires) » et que les points supplémentaires indiqués sont plus grands que 0, les points supplémentaires constituent le facteur qui multiplie la note avant de l\'ajouter au total, après le calcul de la moyenne.';
$string['aggregationcoefextrasum'] = 'Bonus';
$string['aggregationcoefextrasum_help'] = 'Si la case « Bonus » est cochée, la note maximale de l\'élément d\'évaluation ne sera pas ajoutée à la note maximale de la catégorie, offrant la possibilité d\'obtenir la note maximale (ou une note dépassant la note maximale, si l\'administrateur du site a activé cette possibilité) dans la catégorie sans obtenir la note maximale dans tous les éléments d\'évaluation.';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Coefficient de bonus';
$string['aggregationcoefextraweight_help'] = 'Si la pondération pour le bonus est plus grande que 0, la note est traitée comme bonus lors du calcul de la tendance centrale. Ce nombre est le facteur par lequel la note est multipliée avant d\'être ajoutée au total des notes pour le calcul de la moyenne.';
$string['aggregationcoefweight'] = 'Coefficient de l\'élément';
$string['aggregationcoefweight_help'] = 'La pondération d\'un élément est utilisée lors du calcul de la tendance centrale d\'une catégorie, afin d\'influencer l\'importance de l\'élément, en comparaison avec les autres éléments d\'évaluation de la même catégorie.';
$string['aggregationhintdropped'] = '(écarté)';
$string['aggregationhintexcluded'] = '(exclu)';
$string['aggregationhintextra'] = '(bonus)';
$string['aggregationhintnovalue'] = '(vide)';
$string['aggregationofa'] = 'Tendance centrale de {$a}';
$string['aggregationposition'] = 'Position de la tendance centrale';
$string['aggregationposition_help'] = 'Ce réglage détermine si les colonnes des tendances centrales de la catégorie et du cours sont affichées en premier ou en dernier dans les rapports du carnet de notes.';
$string['aggregationsvisible'] = 'Types de tendances centrales disponibles';
$string['aggregationsvisiblehelp'] = 'Sélectionnez tous les types de tendances centrales que vous voulez autoriser.';
$string['allgrades'] = 'Toutes les notes par catégorie';
$string['allstudents'] = 'Tous les étudiants';
$string['allusers'] = 'Tous les utilisateurs';
$string['autosort'] = 'Tri automatique';
$string['availableidnumbers'] = 'Identifiants disponibles';
$string['average'] = 'Moyenne';
$string['averagesdecimalpoints'] = 'Décimales des moyennes de colonnes';
$string['averagesdecimalpoints_help'] = 'Ce réglage spécifie le nombre de décimales à afficher pour chaque moyenne de colonne. Si « Hériter » est sélectionné, le type d\'affichage de chaque colonne est utilisé.';
$string['averagesdisplaytype'] = 'Type d\'affichage des moyennes de colonnes';
$string['averagesdisplaytype_help'] = 'Ce réglage spécifie comment afficher des moyennes de chaque colonne. Si « Hériter » est sélectionné, le type d\'affichage de chaque colonne est utilisé.';
$string['backupwithoutgradebook'] = 'La sauvegarde ne contient pas la configuration du carnet de notes';
$string['badgrade'] = 'La note fournie n\'est pas valide';
$string['badlyformattedscale'] = 'Veuillez spécifier une liste de valeurs séparées par des virgules (au moins deux valeurs requises).';
$string['baduser'] = 'L\'utilisateur indiqué n\'est pas valide';
$string['bonuspoints'] = 'Bonus';
$string['bulkcheckboxes'] = 'Cases à cocher en vrac';
$string['calculatedgrade'] = 'Note calculée';
$string['calculation'] = 'Calcul';
$string['calculation_help'] = 'Les calculs de notes utilisent une syntaxe similaire à celle des fonctions de tableurs. Une formule commence par un signe d\'égalité (=) et emploie des opérateurs et fonctions mathématiques usuels, comme min, max ou sum. On peut au besoin inclure dans les formules les valeurs d\'autres éléments d\'évaluations en indiquant leur identifiant entouré de deux paires de crochets [[…]].';
$string['calculationadd'] = 'Ajouter calcul';
$string['calculationedit'] = 'Modifier calcul';
$string['calculationsaved'] = 'Calcul enregistré';
$string['calculationview'] = 'Afficher calcul';
$string['cannotaccessgroup'] = 'Impossible d\'accéder aux notes du groupe sélectionné.';
$string['categories'] = 'Catégories';
$string['category'] = 'Catégorie';
$string['categoryedit'] = 'Modifier catégorie';
$string['categoryname'] = 'Nom de la catégorie';
$string['categorytotal'] = 'Total de la catégorie';
$string['categorytotalfull'] = 'Total de {$a->category}';
$string['categorytotalname'] = 'Nom du total de la catégorie';
$string['changedefaults'] = 'Modifier les réglages par défaut';
$string['changereportdefaults'] = 'Modifier les rapports par défaut';
$string['chooseaction'] = 'Choisir une action…';
$string['choosecategory'] = 'Choisir une catégorie';
$string['collapsecriterion'] = 'Replier le critère';
$string['combo'] = 'Onglets et menu déroulant';
$string['compact'] = 'Compact';
$string['componentcontrolsvisibility'] = 'La visibilité de cet élément d\'évaluation est contrôlée par les réglages de l\'activité.';
$string['contract'] = 'Minimiser la catégorie';
$string['contributiontocoursetotal'] = 'Contribution au total du cours';
$string['controls'] = 'Commandes';
$string['courseavg'] = 'Moyenne du cours';
$string['coursegradecategory'] = 'Catégorie de notes du cours';
$string['coursegradedisplaytype'] = 'Type d\'affichage des notes du cours';
$string['coursegradedisplayupdated'] = 'Le type d\'affichage des notes du cours a été modifié.';
$string['coursegradesettings'] = 'Réglages des notes du cours';
$string['coursename'] = 'Nom du cours';
$string['coursescales'] = 'Barèmes du cours';
$string['coursesettings'] = 'Réglages du cours';
$string['coursesettingsexplanation'] = 'Les réglages d\'évaluation du cours déterminent la présentation du carnet de notes pour tous les participants du cours.';
$string['coursesiamtaking'] = 'Les cours que je suis';
$string['coursesiamteaching'] = 'Les cours que je donne';
$string['coursetotal'] = 'Total du cours';
$string['createcategory'] = 'Créer une catégorie';
$string['createcategoryerror'] = 'Impossible de créer une nouvelle catégorie';
$string['creatinggradebooksettings'] = 'Création des réglages du carnet de notes';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Tendance centrale parente actuelle';
$string['curveto'] = 'Normaliser à';
$string['decimalpoints'] = 'Décimales';
$string['decimalpoints_help'] = 'Ce réglage détermine le nombre de décimales à afficher pour chaque note. Il n\'a pas d\'effet sur le résultat des calculs des notes, qui sont effectués dans tous les cas avec une précision de 5 décimales.';
$string['default'] = 'Défaut';
$string['defaultprev'] = 'Défaut ({$a})';
$string['deletecategory'] = 'Supprimer une catégorie';
$string['deletescale'] = 'Supprimer le barème';
$string['disablegradehistory'] = 'Désactiver l\'historique des notes';
$string['disablegradehistory_help'] = 'Désactiver le suivi des modifications des tables concernant les notes. Ce réglage peut améliorer la vitesse de votre serveur et conserve plus d\'espace disque dans votre base de données.';
$string['displaylettergrade'] = 'Afficher les notes lettres';
$string['displaypercent'] = 'Afficher les pourcentages';
$string['displaypoints'] = 'Afficher les points';
$string['displayweighted'] = 'Afficher les notes pondérées';
$string['dropdown'] = 'Menu déroulant';
$string['droplow'] = 'Ignorer les plus basses';
$string['droplow_help'] = 'Ce réglage permet d\'indiquer le nombre de notes les plus basses à ignorer lors du calcul de la tendance centrale.';
$string['droplowestvalue'] = 'Spécifier la valeur de rejet de la plus petite note';
$string['droplowestvalues'] = 'Écarter les {$a} valeurs les plus basses';
$string['dropped'] = 'Ignoré';
$string['dropxlowest'] = 'Ignorer les <em>n</em> notes les plus basses';
$string['dropxlowestwarning'] = 'Remarque : si vous utilisez l\'option « ignorer les n notes les plus basses »,<br />tous les éléments de la catégorie seront considérés comme valant<br />le même nombre de points. Si ces valeurs varient, les résultats seront imprévisibles !';
$string['duplicatedgradeitem'] = '{$a} (copie)';
$string['duplicatescale'] = 'Barème en doublon';
$string['edit'] = 'Modifier';
$string['editcalculation'] = 'Modifier calcul';
$string['editcalculationverbose'] = 'Modifier le calcul de {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Modifier feedback';
$string['editgrade'] = 'Modifier note';
$string['editgradeletters'] = 'Modifier les notes lettres';
$string['editoutcome'] = 'Modifier l\'objectif';
$string['editoutcomes'] = 'Modifier les objectifs';
$string['editscale'] = 'Modifier le barème';
$string['edittree'] = 'Réglages';
$string['editverbose'] = 'Modifier {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Activer AJAX';
$string['enableajax_help'] = 'Ajoute des fonctionnalités AJAX au rapport de l\'évaluateur, pour simplifier et accélérer les opérations habituelles. Nécessite l\'activation de Javascript sur le navigateur de l\'utilisateur.';
$string['enableoutcomes'] = 'Activer les objectifs';
$string['enableoutcomes_help'] = 'Si ce réglage est activé, les éléments d\'évaluation peuvent être évalués d\'après un ou plusieurs barèmes liés à des énoncés d\'objectifs.';
$string['encoding'] = 'Encodage';
$string['encoding_help'] = 'Sélectionner l\'encodage des caractères utilisé pour ces données (l\'encodage standard est UTF-8). Si un mauvais encodage est choisi par inadvertance, cela sera visible lors de la prévisualisation des données à importer.';
$string['errorcalculationbroken'] = 'Référence circulaire ou formule de calcul incorrecte';
$string['errorcalculationnoequal'] = 'La formule doit commencer par un signe d\'égalité (=1+2)';
$string['errorcalculationunknown'] = 'Formule non valide';
$string['errorgradevaluenonnumeric'] = 'Une note non-numérique a été reçue (note haute ou basse) pour';
$string['errornocalculationallowed'] = 'Les calculs ne sont pas autorisés pour cet élément';
$string['errornocategorisedid'] = 'Impossible d\'obtenir un identifiant sans catégorie !';
$string['errornocourse'] = 'Impossible d\'obtenir les informations du cours';
$string['errorreprintheadersnonnumeric'] = 'Valeur non-numérique reçue pour le réaffichage des entêtes';
$string['errorsavegrade'] = 'Impossible d\'enregistrer la note.';
$string['errorsettinggrade'] = 'Erreur de l\'enregistrement de la note « {$a->itemname} » pour l\'identifiant utilisateur {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Erreur lors de la modification du réglage « Tendance centrale pour notes non vides » de la catégorie de note d\'identifiant {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Erreur lors de la modification du réglage « Inclure les objectifs dans les tendances centrales » de la catégorie de note d\'identifiant {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Erreur lors de la modification du type de tendance centrale de la catégorie de note d\'identifiant {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Erreur lors de la modification du coefficient (pondération ou bonus) de l\'élément d\'évaluation d\'identifiant {$a->id}';
$string['eventgradedeleted'] = 'Note supprimée';
$string['eventgradeitemcreated'] = 'Élément d\'évaluation créé';
$string['eventgradeitemdeleted'] = 'Élément d\'évaluation supprimé';
$string['eventgradeitemupdated'] = 'Élément d\'évaluation modifié';
$string['eventgradelettercreated'] = 'Note lettre créée';
$string['eventgradeletterdeleted'] = 'Note lettre supprimée';
$string['eventgradeletterupdated'] = 'Note lettre modifiée';
$string['eventgradeviewed'] = 'Notes consultées dans le carnet de notes';
$string['eventscalecreated'] = 'Barème créé';
$string['eventscaledeleted'] = 'Barème supprimé';
$string['eventscaleupdated'] = 'Barème modifié';
$string['eventusergraded'] = 'Utilisateur évalué';
$string['excluded'] = 'Exclue';
$string['excluded_help'] = 'Si ce réglage est activé, la note ne sera prise en compte dans aucun calcul de tendance centrale.';
$string['expand'] = 'Déplier la catégorie';
$string['expandcriterion'] = 'Déplier le critère';
$string['export'] = 'Exporter';
$string['exportalloutcomes'] = 'Exporter tous les objectifs';
$string['exportfeedback'] = 'Inclure les feedbacks dans l\'exportation';
$string['exportfeedback_desc'] = 'Ce réglage peut être modifié durant l\'exportation.';
$string['exportformatoptions'] = 'Options de formats d\'exportation';
$string['exportonlyactive'] = 'Exclure les utilisateurs suspendus';
$string['exportonlyactive_help'] = 'N\'inclure dans l\'exportation que les participants dont l\'inscription est active et n\'a pas été suspendue';
$string['exportplugins'] = 'Modules d\'exportation';
$string['exportsettings'] = 'Réglages d\'exportation';
$string['exportto'] = 'Exporter vers';
$string['externalurl'] = 'URL externe';
$string['externalurl_desc'] = 'Si un carnet de notes externe est utilisé, veuillez indiquer son URL ici.';
$string['extracreditvalue'] = 'Bonus pour {$a}';
$string['extracreditwarning'] = 'Remarque : si tous les éléments d\'une catégorie sont cochés comme bonus, cela aura pour effet de les retirer complètement du calcul des notes, puisqu\'il n\'y aura pas de point au total.';
$string['fail'] = 'Échoué';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Ce champ permet à l\'enseignant d\'ajouter des remarques sur la note donnée.';
$string['feedbackadd'] = 'Ajouter feedback';
$string['feedbackedit'] = 'Modifier feedback';
$string['feedbackfiles'] = 'Fichiers de feedback';
$string['feedbackforgradeitems'] = 'Feedback pour {$a}';
$string['feedbackhistoryfiles'] = 'Fichiers d\'historique de feedback';
$string['feedbacks'] = 'Feedbacks';
$string['feedbacksaved'] = 'Feedback enregistré';
$string['feedbackview'] = 'Afficher feedback';
$string['finalgrade'] = 'Note finale';
$string['finalgrade_help'] = 'Si ce réglage est activé, des notes peuvent être ajoutées ou modifiées.';
$string['fixedstudents'] = 'Colonne étudiants statique';
$string['fixedstudents_help'] = 'Permet aux notes de défiler horizontalement sans perdre de vue la colonne des étudiants, en rendant statique cette dernière.';
$string['forceimport'] = 'Forcer l\'importation';
$string['forceimport_help'] = 'Forcer l\'importation des notes, même si les notes ont été modifiées après l\'exportation du fichier à importer';
$string['forceoff'] = 'Imposer : non';
$string['forceon'] = 'Imposer : oui';
$string['forelementtypes'] = 'pour les {$a} sélectionnés';
$string['forstudents'] = 'Pour les étudiants';
$string['full'] = 'Complet';
$string['fullmode'] = 'Passer à l\'affichage complet';
$string['generalsettings'] = 'Réglages généraux';
$string['grade'] = 'Note';
$string['grade_help'] = 'La note à donner à l\'étudiant pour son travail.';
$string['gradeadministration'] = 'Administration des notes';
$string['gradealreadyupdated'] = '{$a} notes n\'ont pas été importées, car les notes du fichier à importer sont plus anciennes que celles du rapport de l\'évaluateur. Pour poursuivre malgré tout l\'importation, utiliser l\'option « Forcer l\'importation ».';
$string['gradeanalysis'] = 'Analyse de l\'évaluation';
$string['gradebook'] = 'Carnet de notes';
$string['gradebookcalculationsfixbutton'] = 'Accepter les modifications de notes et corriger les erreurs de calcul';
$string['gradebookcalculationsuptodate'] = 'Les calculs du carnet de notes sont à jour. Veuillez recharger cette page pour voir les modifications.';
$string['gradebookcalculationswarning'] = 'Des erreurs ont été détectées dans le calcul des notes affichées dans le carnet de notes. Si votre cours n\'a pas commencé ou est en cours, il vous est recommandé de corriger ces erreurs en cliquant sur le bouton ci-dessous. Cette opération aura pour résultat de modifier certaines notes. Si votre cours est terminé et que les notes ont été données, il n\'est probablement pas judicieux de corriger ce problème.

La nouvelle version du carnet de notes est {$a->currentversion} ; vous utilisez la version {$a->gradebookversion}. Vous pouvez consulter les changements entre les versions {$a->gradebookversion} et {$a->currentversion}, sur la page <a href="{$a->url}">Modifications du calcul du carnet de notes</a>.';
$string['gradebookhiddenerror'] = 'Le carnet de notes est configuré de façon à cacher toutes ses données aux étudiants.';
$string['gradebookhistories'] = 'Historiques d\'évaluation';
$string['gradebooksetup'] = 'Configuration du carnet de notes';
$string['gradeboundary'] = 'Limite pour note lettre';
$string['gradeboundary_help'] = 'Ce réglage détermine le pourcentage minimal au-dessus duquel les notes seront converties en une lettre.';
$string['gradecategories'] = 'Catégories de note';
$string['gradecategory'] = 'Catégorie de note';
$string['gradecategoryonmodform'] = 'Catégorie de note';
$string['gradecategoryonmodform_help'] = 'Ce réglage définit la catégorie du carnet de notes dans laquelle les notes de cette activité sont placées.';
$string['gradecategorysettings'] = 'Réglages des catégories';
$string['gradedisplay'] = 'Affichage des notes';
$string['gradedisplaytype'] = 'Type d\'affichage des notes';
$string['gradedisplaytype_help'] = 'Ce réglage détermine comment les notes sont affichées dans les rapports de l\'évaluateur et du participant.

* Réel – Note elle-même ou valeur dans le barème
* Pourcentage – Pourcentage relativement aux notes maximale et minimale
* Lettre – Lettre (ou mot) représentant un intervalle de notes, spécifié dans l\'onglet Lettres de la configuration du carnet de notes';
$string['gradedon'] = 'Évalué le {$a}';
$string['gradeexport'] = 'Exportation de notes';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Champs de profil personnalisés pour exportation des notes';
$string['gradeexportcustomprofilefields_desc'] = 'Inclure ces champs de profil personnalisés dans l\'exportation des notes, séparés par des virgules.';
$string['gradeexportdecimalpoints'] = 'Nombre de décimales des notes exportées';
$string['gradeexportdecimalpoints_desc'] = 'Nombre de décimales à afficher lors de l\'exportation. Ce réglage peut être modifié lors de chaque exportation.';
$string['gradeexportdisplaytype'] = 'Type d\'affichage des notes exportées';
$string['gradeexportdisplaytype_desc'] = 'Lors de l\'exportation, les notes peuvent être affichées comme notes brutes, comme pourcentages (relativement aux notes maximale et minimale) ou comme lettres (A, B, C, etc.). Ce réglage peut être modifié lors de chaque exportation.';
$string['gradeexportdisplaytypes'] = 'Type d\'affichage de l\'exportation des notes';
$string['gradeexportuserprofilefields'] = 'Champs de profil pour exportation des notes';
$string['gradeexportuserprofilefields_desc'] = 'Inclure ces champs de profil dans l\'exportation des notes, séparés par des virgules.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Notes initiales minimale et maximale';
$string['gradehelp'] = 'Aide sur les notes';
$string['gradehistorylifetime'] = 'Durée de l\'historique des notes';
$string['gradehistorylifetime_help'] = 'Ce réglage permet d\'indiquer la durée pendant laquelle vous voulez conserver le suivi des modifications des tables concernant les notes. Il est recommandé de les conserver le plus longtemps possible. Si vous avez des problèmes de performance ou un espace disque limité pour votre base de données, essayez d\'indiquer une durée plus basse.';
$string['gradeimport'] = 'Importation de notes';
$string['gradeimportfailed'] = 'L\'importation de notes a échoué. Détails :';
$string['gradeitem'] = 'Élément d\'évaluation';
$string['gradeitemaddusers'] = 'Exclure de la note';
$string['gradeitemadvanced'] = 'Options avancées éléments d\'évaluation';
$string['gradeitemadvanced_help'] = 'Sélectionnez tous les éléments qui devront être affichés comme éléments avancés lors de la modification des éléments d\'évaluation.';
$string['gradeitemislocked'] = 'La note de cette activité est verrouillée dans le carnet de notes. Les modifications des notes de cette activité ne seront pas répercutées dans le carnet de notes tant qu\'il n\'est pas déverrouillé.';
$string['gradeitemlocked'] = 'Évaluation verrouillée';
$string['gradeitemmembersselected'] = 'Exclu(s) de la note';
$string['gradeitemminmax'] = 'Notes minimale et maximale telles que définies dans les réglages de l\'élément d\'évaluation';
$string['gradeitemnonmembers'] = 'Inclus dans la note';
$string['gradeitemremovemembers'] = 'Inclure dans la note';
$string['gradeitems'] = 'Éléments d\'évaluation';
$string['gradeitemsettings'] = 'Réglages des éléments';
$string['gradeitemsinc'] = 'Éléments d\'évaluation à inclure';
$string['gradeletter'] = 'Note lettre';
$string['gradeletter_help'] = 'Les notes lettres sont des lettres (A, B, C, etc.) ou des mots (Distingué, Promu, etc.) utilisés pour représenter un intervalle de notes.';
$string['gradeletternote'] = 'Pour supprimer une note lettre, effacer simplement le contenu des trois<br />zones lui correspondant et cliquer sur « Enregistrer les changements ».';
$string['gradeletteroverridden'] = 'Les lettres notes par défaut sont actuellement court-circuitées.';
$string['gradeletters'] = 'Notes lettres';
$string['gradelocked'] = 'La note est verrouillée';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Note maximale';
$string['grademax_help'] = 'Ce réglage détermine la note maximale lorsque le type de note est une valeur. La note maximale pour un élément d\'évaluation basé sur une activité est gérée dans les paramètres de l\'activité.';
$string['grademin'] = 'Note minimale';
$string['grademin_help'] = 'Ce réglage détermine la note minimale lorsque le type de note est une valeur.';
$string['gradenotificationmessage'] = 'Vous avez un nouveau feedback pour votre travail dans « {$a} »';
$string['gradenotificationsubject'] = 'Vous avez été évalué';
$string['gradeoutcomeitem'] = 'Évaluer élément d\'objectif';
$string['gradeoutcomes'] = 'Objectifs';
$string['gradeoutcomescourses'] = 'Objectifs du cours';
$string['gradepass'] = 'Note pour passer';
$string['gradepass_help'] = 'Ce réglage détermine la note minimale de réussite. La valeur est utilisée dans l\'achèvement d\'activités et de cours, ainsi que dans le carnet de notes, où les notes supérieures sont en vert et les notes inférieures en rouge.';
$string['gradepassgreaterthangrade'] = 'La note pour réussir ne peut pas être plus grande que la note maximale possible {$a}';
$string['gradepointdefault'] = 'Nombre de points par défaut';
$string['gradepointdefault_help'] = 'Ce réglage détermine le nombre de points par défaut pour la note d\'un élément d\'évaluation.';
$string['gradepointdefault_validateerror'] = 'Ce paramètre doit être un nombre entier entre 1 et le nombre de points maximum pour la note.';
$string['gradepointmax'] = 'Nombre maximum de points';
$string['gradepointmax_help'] = 'Ce réglage détermine le nombre maximum de points pour la note d\'une activité.';
$string['gradepointmax_validateerror'] = 'Ce paramètre doit être un nombre entier entre 1 et 10000.';
$string['gradepreferences'] = 'Préférences des notes';
$string['gradepreferenceshelp'] = 'Aide sur les préférences des notes';
$string['gradepublishing'] = 'Activer la publication';
$string['gradepublishing_help'] = 'La publication des notes permet d\'importer et d\'exporter des notes au moyen d\'une URL, sans être connecté à Moodle. Si elle est activée, les administrateurs et utilisateurs au bénéfice des permissions requises pour publier les notes (par défaut, uniquement les utilisateurs ayant le rôle de gestionnaire) peuvent avoir accès aux réglages de publications des notes dans le carnet de notes de chaque cours.';
$string['gradepublishinglink'] = 'Télécharger : {$a}';
$string['gradereport'] = 'Rapport d\'évaluation';
$string['graderreport'] = 'Rapport de l\'évaluateur';
$string['grades'] = 'Notes';
$string['gradesforuser'] = 'Notes de {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Attention ! La suppression d\'une activité est en cours ! Certaines notes vont être supprimées.';
$string['gradesmoduledeletionprefix'] = '[Suppression en cours]';
$string['gradesonly'] = 'Passer aux notes seulement';
$string['gradessettings'] = 'Réglages des notes';
$string['gradetype'] = 'Type de note';
$string['gradetype_help'] = 'Il y a 4 types de notes :

* Aucune – Pas de note possible
* Valeur – Une valeur numérique avec un maximum et un minimum
* Barème – Un élément d\'une liste
* Texte – Pour les feedbacks uniquement

Seuls les types valeur et barème permettent le calcul d\'une tendance centrale. Le type de note pour un élément d\'évaluation basé sur une activité est géré dans les paramètres de l\'activité.';
$string['gradevaluetoobig'] = 'Une des notes dépasse la note maximale autorisée {$a}';
$string['gradeview'] = 'Afficher la note';
$string['gradewasmodifiedduringediting'] = 'La note saisie donnée à {$a->username} pour {$a->itemname} a été ignorée, car elle a été mise à jour ultérieurement par quelqu\'un d\'autre.';
$string['gradeweighthelp'] = 'Aide sur les coefficients des notes';
$string['gradingmodulename'] = 'Évaluation ({$a})';
$string['groupavg'] = 'Moyenne du groupe';
$string['hidden'] = 'Caché';
$string['hidden_help'] = 'Si cette case est cochée, les notes sont cachées aux étudiants. Un délai peut être fixé au besoin, afin d\'afficher les notes après que l\'évaluation soit terminée.';
$string['hiddenasdate'] = 'Afficher la date de remise pour les notes cachées';
$string['hiddenasdate_help'] = 'Si le participant n\'a pas les permissions requises pour voir les notes cachées, afficher la date de remise au lieu d\'un tiret.';
$string['hiddenuntil'] = 'Caché jusqu\'au';
$string['hiddenuntildate'] = 'Caché jusqu\'au {$a}';
$string['hideadvanced'] = 'Cacher les fonctions avancées';
$string['hideaverages'] = 'Cacher les moyennes';
$string['hidecalculations'] = 'Cacher les calculs';
$string['hidecategory'] = 'Caché';
$string['hideeyecons'] = 'Cacher icônes afficher/cacher';
$string['hidefeedback'] = 'Cacher les feedbacks';
$string['hideforcedsettings'] = 'Cacher les réglages imposés';
$string['hideforcedsettings_help'] = 'Ne pas montrer dans l\'interface les réglages imposés.';
$string['hidegroups'] = 'Cacher les groupes';
$string['hidelocks'] = 'Cacher les cadenas';
$string['hidenooutcomes'] = 'Afficher les objectifs';
$string['hidequickfeedback'] = 'Cacher le feedback rapide';
$string['hideranges'] = 'Cacher les valeurs possibles';
$string['hidetotalifhiddenitems'] = 'Cacher les totaux contenant des éléments cachés';
$string['hidetotalifhiddenitems_help'] = 'Ce réglage détermine si les totaux contenant un ou plusieurs éléments d\'évaluation cachés seront affichés pour les participants ou remplacés par un tiret (-). S\'ils sont affichés, les totaux seront calculés soit en incluant, soit en excluant les éléments d\'évaluation cachés.

Si les éléments cachés sont exclus, le total vu par les participants sera différent de celui vu dans le rapport d\'évaluation par l\'enseignant, puisque celui-ci voit toujours les totaux calculés à partir de tous les éléments, qu\'ils soient cachés ou non. Si les éléments cachés sont inclus, les participants seront potentiellement en mesure de déduire par le calcul la valeur des éléments cachés.';
$string['hidetotalshowexhiddenitems'] = 'Afficher les totaux en excluant les éléments cachés';
$string['hidetotalshowinchiddenitems'] = 'Afficher les totaux en incluant les éléments cachés';
$string['hideverbose'] = 'Cacher {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Tri croissant par note maximale';
$string['highgradedescending'] = 'Tri décroissant par note maximale';
$string['highgradeletter'] = 'Haut';
$string['identifier'] = 'Identifier les utilisateurs par';
$string['idnumbers'] = 'Identifiants';
$string['ignore'] = 'Ignorer';
$string['import'] = 'Importer';
$string['importcsv'] = 'Importation CSV';
$string['importcsv_help'] = 'Les notes peuvent être importées d\'un fichier CSV dont le format est le suivant :

* chaque ligne du fichier contient un enregistrement ;
* chaque enregistrement est constitué d\'une série de données séparées par le caractère de séparation sélectionné ;
* le premier enregistrement contient la liste des noms des champs définissant le format du reste du fichier ;
* un champ contenant l\'identité de l\'utilisateur est requis : soit le nom d\'utilisateur, soit le numéro d\'ID, soit l\'adresse de courriel.

Un fichier dont la syntaxe est correcte peut être obtenu à titre d\'exemple en exportant quelques notes. Le fichier peut alors être modifié et enregistré en format CSV.';
$string['importcustom'] = 'Importer comme objectifs de ce cours';
$string['importdata'] = 'Données';
$string['importdata_help'] = 'Les notes peuvent être collées directement depuis une feuille de calcul OpenDocument ou Excel dont le format est le suivant :

* au moins une colonne doit comporter les données d\'identification de l\'utilisateur - nom d\'utilisateur, adresse de courriel ou numéro d\'ID ;
* chaque autre colonne doit avoir l\'entête d\'une activité ou d\'un élément d\'évaluation présent.

Une feuille de calcul correctement formatée peut être obtenue en exportant d\'abord quelques notes. Elle peut être alors modifiée et enregistrée après l\'ajout d\'autres notes.

Sélectionnez et copiez dans la feuille de calcul les colonnes à importer et collez-les dans ce champ.';
$string['importerror'] = 'Une erreur est survenue. Ce script n\'a pas été appelé avec les paramètres adéquats.';
$string['importfailed'] = 'L\'importation a échoué. Aucune donnée n\'a été importée.';
$string['importfeedback'] = 'Importer les feedbacks';
$string['importfile'] = 'Fichier à importer';
$string['importfilemissing'] = 'Aucun fichier n\'a été reçu. Veuillez revenir au formulaire et vous assurer de déposer un fichier valide.';
$string['importfrom'] = 'Importer de';
$string['importoutcomenofile'] = 'Le fichier déposé est vide ou corrompu. Veuillez le vérifier. Le problème a été détecté à la ligne {$a} ; cette erreur survient lorsque des lignes ne comportent pas le même nombre de colonnes que la première ligne (entête) ou quand le fichier importé ne comprend pas l\'entête attendue. Veuillez consulter le fichier exporté à titre d\'exemple de fichier avec un entête valide.';
$string['importoutcomes'] = 'Importer des objectifs';
$string['importoutcomes_help'] = 'Des objectifs peuvent être importés depuis un fichier CSV du même format que les objectifs exportés.';
$string['importoutcomesuccess'] = 'Objectif « {$a->name} » importé avec l\'identifiant {$a->id}';
$string['importplugins'] = 'Modules d\'importation';
$string['importpreview'] = 'Prévisualisation de l\'importation';
$string['importsettings'] = 'Réglages d\'importation';
$string['importskippednomanagescale'] = 'Vous n\'avez pas les permissions requises pour ajouter un nouveau barème. L\'objectif « {$a} » a donc été ignoré, car il requiert la création d\'un nouveau barème';
$string['importskippedoutcome'] = 'Un objectif de même intitulé abrégé « {$a} » existe déjà dans ce contexte. L\'objectif du même nom à importer a été ignoré.';
$string['importstandard'] = 'Importer comme objectifs standards';
$string['importsuccess'] = 'Importation des notes réussie';
$string['importxml'] = 'Importation XML';
$string['includescalesinaggregation'] = 'Inclure les barèmes dans les tendances centrales';
$string['includescalesinaggregation_help'] = 'Vous pouvez indiquer si les barèmes doivent être inclus en tant que nombres dans toutes les tendances centrales des notes de tous les carnets de tous les cours. ATTENTION : la modification de ce réglage entraînera le re-calcul de toutes les tendances centrales.';
$string['incorrectcourseid'] = 'Le no de cours est incorrect';
$string['incorrectcustomscale'] = '(Barème personnel incorrect. Veuillez le modifier.)';
$string['incorrectminmax'] = 'Le minimum doit être inférieur au maximum';
$string['inherit'] = 'Hériter';
$string['intersectioninfo'] = 'Infos participant/note';
$string['invalidgradeexporteddate'] = 'La date d\'exportation n\'est pas valide, car elle est plus ancienne qu\'une année, ou située dans le futur, ou encore que son format n\'est pas correct.';
$string['item'] = 'Élément';
$string['iteminfo'] = 'Info élément';
$string['iteminfo_help'] = 'Ce champ fournit une zone où indiquer des informations concernant l\'élément d\'évaluation. Le texte saisi n\'apparaît nulle part ailleurs.';
$string['itemname'] = 'Nom élément';
$string['itemnamehelp'] = 'Le nom de cet élément, fourni par le module.';
$string['items'] = 'Éléments';
$string['itemsedit'] = 'Modifier un élément d\'évaluation';
$string['keephigh'] = 'Garder les plus hautes';
$string['keephigh_help'] = 'Cette option permet de ne considérer que les <em>n</em> notes les plus élevées, le nombre <em>n</em> étant sélectionné dans le menu déroulant.';
$string['keephighestvalues'] = 'Conserver les {$a} notes les plus élevées';
$string['keymanager'] = 'Gestionnaire de clefs';
$string['lessthanmin'] = 'La note saisie dans {$a->itemname} pour {$a->username} est inférieure au minimum permis';
$string['letter'] = 'Lettre';
$string['lettergrade'] = 'Note lettre';
$string['lettergradenonnumber'] = 'La note maximale et/ou minimale n\'est pas numérique pour';
$string['letterpercentage'] = 'Lettre (pourcentage)';
$string['letterreal'] = 'Lettre (brute)';
$string['letters'] = 'Lettres';
$string['linkedactivity'] = 'Activité liée';
$string['linkedactivity_help'] = 'Ce réglage spécifie une activité optionnelle à laquelle cet élément d\'objectif est lié. On utilise ceci pour mesurer la performance d\'un participant par rapport à un critère non évalué par la note de l\'activité.';
$string['linktoactivity'] = 'Lien vers l\'activité {$a->name} {$a->title}';
$string['lock'] = 'Verrouiller';
$string['locked'] = 'Verrouillé';
$string['locked_help'] = 'Si cette case est cochée, les notes ne sont plus mises à jour automatiquement par l\'activité d\'où elles proviennent.';
$string['locktime'] = 'Verrouiller après';
$string['locktimedate'] = 'Verrouillé après le {$a}';
$string['lockverbose'] = 'Verrouiller {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Le plus bas';
$string['lowgradeletter'] = 'Bas';
$string['manageoutcomes'] = 'Gérer les objectifs';
$string['manualitem'] = 'Élément manuel';
$string['mapfrom'] = 'Lier depuis';
$string['mapfrom_help'] = 'Sélectionner la colonne de la feuille de calcul qui comprend les données permettant l\'identification de l\'utilisateur, par exemple le nom d\'utilisateur, le numéro d\'ID ou l\'adresse de courriel.';
$string['mappings'] = 'Correspondance des éléments d\'évaluation';
$string['mappings_help'] = 'Pour chaque colonne de la feuille de calcul, sélectionner l\'élément d\'évaluation correspondant dans lequel importer les notes.';
$string['mapto'] = 'Lier à';
$string['mapto_help'] = 'Sélectionner les mêmes données d\'identification, telles que sélectionnées sous « Lier depuis ».';
$string['max'] = 'Maximum';
$string['maxgrade'] = 'Note maximale';
$string['meanall'] = 'Toutes les notes';
$string['meangraded'] = 'Notes non vides';
$string['meanselection'] = 'Notes sélectionnées pour moyennes de colonnes';
$string['meanselection_help'] = 'Indique si les cellules sans note doivent être incluses dans le calcul des moyennes de chaque colonne.';
$string['median'] = 'Médiane';
$string['min'] = 'Minimum';
$string['minimum_show'] = 'Afficher la note minimale';
$string['minimum_show_help'] = 'La note minimale est utilisée dans le calcul des notes et pondérations. Si elle n\'est pas affichée, la note minimale est fixée à 0 et ne peut pas être modifiée.';
$string['minmaxtouse'] = 'Notes minimale et maximale utilisées dans les calculs';
$string['minmaxtouse_desc'] = 'Ce réglage détermine si, pour le calcul de la note affichée dans le carnet de notes, les notes maximale et minimale initiales (lorsque la note a été donnée) ou plutôt celles définies dans les réglages de l\'élément d\'évaluation seront utilisées. Il recommandé de modifier ce réglage en dehors des heures de pointe, car toutes les notes seront recalculées, ce qui chargera le serveur de manière importante.';
$string['minmaxtouse_help'] = 'Ce réglage détermine si, pour le calcul de la note affichée dans le carnet de notes, les notes maximale et minimale initiales (lorsque la note a été donnée) ou plutôt celles définies dans les réglages de l\'élément d\'évaluation seront utilisées.';
$string['minmaxupgradedgrades'] = 'Certaines notes ont été modifiées afin de résoudre une incohérence dans le carnet de notes, causée par une modification des notes minimale et maximale utilisées lors du calcul de la note affichée. Il est recommandé de passer en revue ces changements et de les confirmer.';
$string['minmaxupgradefixbutton'] = 'Lever les incohérences';
$string['minmaxupgradewarning'] = 'Une incohérence a été détectée pour certaines notes, causée par une modification des notes minimale et maximale utilisées lors du calcul de la note affichée dans le carnet de notes. Il est recommandé de lever cette incohérence en cliquant sur le bouton ci-dessus. Certaines notes seront alors modifiées.';
$string['missingitemtypeoreid'] = 'Clef de tableau (itemtype ou eid) manquante dans le 2ème paramètre de grade_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Un barème doit être sélectionné';
$string['mode'] = 'Mode';
$string['modgrade'] = 'Note';
$string['modgrade_help'] = 'Sélectionnez le type de note utilisée dans cette activité. Si « Barème » est choisi, vous pourrez sélectionner un barème dans le menu déroulant. Si « Point » est choisi, vous pourrez spécifier la note maximale pour cette activité.';
$string['modgradecantchangegradetype'] = 'Il n\'est pas possible de modifier le type, car des notes existent déjà pour cet élément.';
$string['modgradecantchangegradetypemsg'] = 'Des notes ont déjà été données, donc le type de note ne peut plus être modifié. Si vous voulez changer la note maximale, vous devez d\'abord décider si vous voulez ou non adapter en conséquence les notes existantes.';
$string['modgradecantchangegradetyporscalemsg'] = 'Des notes ont déjà été données, donc le type de note et le barème ne peuvent plus être modifiés.';
$string['modgradecantchangeratingmaxgrade'] = 'Il n\'est pas possible de modifier la note maximale lorsque des notes existent déjà pour une activité.';
$string['modgradecantchangescale'] = 'Il n\'est pas possible de modifier ce barème, car des notes existent déjà avec cet élément.';
$string['modgradecategorycantchangegradetypemsg'] = 'Certains éléments d\'évaluation associés à cette catégorie ont été modifiés manuellement et des notes ont déjà été attribuées. De ce fait, le type de note ne peut pas être modifié. Si vous voulez changer la note maximale, vous devez d\'abord décider si vous voulez adapter proportionnellement les notes existantes.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Certains éléments d\'évaluation associés à cette catégorie ont été modifiés manuellement et des notes ont déjà été attribuées. De ce fait, le type de note ne peut pas être modifié.';
$string['modgradecategoryrescalegrades'] = 'Adapter proportionnellement les notes modifiées manuellement';
$string['modgradecategoryrescalegrades_help'] = 'Lorsque l\'on modifie la note maximale d\'un élément d\'évaluation, il faut indiquer si cette modification doit être reportée sur les pourcentages également.

Si ce réglage est sur « Oui », toutes les notes modifiées manuellement seront adaptées proportionnellement, afin que le pourcentage reste identique.

Par exemple, si la note maximale d\'un élément est changée de 10 à 20, une note de 6/10 (= 60 %) sera adaptée à 12/20 (= 60 %). Si ce réglage est sur « Non », la note ne sera pas modifiée, et nécessitera un ajustement manuel afin que le score pour l\'élément d\'évaluation reste correct.';
$string['modgradedonotmodify'] = 'Ne pas modifier les notes existantes';
$string['modgradeerrorbadpoint'] = 'Note non valide. Ce doit être un nombre entier entre 1 et {$a}';
$string['modgradeerrorbadscale'] = 'Barème non valide sélectionné. Veuillez vous assurer de choisir un barème dans la liste ci-dessous.';
$string['modgrademaxgrade'] = 'Note maximale';
$string['modgraderescalegrades'] = 'Adapter les notes existantes';
$string['modgraderescalegrades_help'] = 'Lors du changement de la note maximale d\'un élément du carnet de notes, il est nécessaire d\'indiquer si la modification devra également adapter en conséquence les notes déjà existantes.

Si ce réglage est activé, toutes les notes existantes seront adaptées afin que les pourcentages restent identiques.

Par exemple, si le réglage est activé, en modifiant la note maximale d\'un élément de 10 à 20, une note de 6/10 (60 %) sera adaptée à 12/20 (60 %). Si le réglage est désactivé, la note restera à 6, et donc passera effectivement de 6/10 (60 %) à 6/20 (30 %), ce qui nécessitera un ajustement manuel afin d\'assurer que les scores soient corrects.';
$string['modgradetype'] = 'Type';
$string['modgradetypenone'] = 'Aucun';
$string['modgradetypepoint'] = 'Point';
$string['modgradetypescale'] = 'Barème';
$string['morethanmax'] = 'La note saisie dans {$a->itemname} pour {$a->username} est supérieure au maximum permis';
$string['moveselectedto'] = 'Déplacer les éléments sélectionnés vers';
$string['movingelement'] = 'Déplacement de {$a}';
$string['multfactor'] = 'Multiplicateur';
$string['multfactor_help'] = 'Le multiplicateur est un nombre par lequel toutes les notes de cet élément d\'évaluation seront multipliées, sans toutefois dépasser la note maximale. Par exemple, si le multiplicateur est 2 et que la note maximale est 100, toutes les notes inférieures à 50 seront doublées, et les notes 50 et plus seront mises à 100.';
$string['multfactorvalue'] = 'Multiplicateur pour {$a}';
$string['mustchooserescaleyesorno'] = 'Veuillez décider si vous voulez ou non adapter les notes existantes.';
$string['mygrades'] = 'Lien notes du menu utilisateur';
$string['mygrades_desc'] = 'Ce réglage permet de spécifier dans le menu utilisateur un lien vers un carnet de notes externe.';
$string['mypreferences'] = 'Mes préférences';
$string['myreportpreferences'] = 'Mes préférences de rapport';
$string['navmethod'] = 'Méthode de navigation';
$string['neverdeletehistory'] = 'Ne jamais supprimer l\'historique';
$string['newcategory'] = 'Nouvelle catégorie';
$string['newitem'] = 'Nouvel élément d\'évaluation';
$string['newoutcomeitem'] = 'Nouvel élément d\'objectif';
$string['no'] = 'Non';
$string['nocategories'] = 'Les catégories de note ne peuvent être ajoutées ou trouvées dans ce cours';
$string['nocategoryname'] = 'Aucun nom de catégorie n\'a été donné.';
$string['nocategoryview'] = 'Aucune catégorie à afficher par';
$string['nocourses'] = 'Il n\'y a pas encore de cours';
$string['noexistingoutcomes'] = 'Il n\'y a pas d\'objectif.';
$string['noexistingscales'] = 'Il n\'y a pas de barème.';
$string['noforce'] = 'Ne pas imposer';
$string['nogradeletters'] = 'Aucune note lettre fixée';
$string['nogradesreturned'] = 'Aucune note retournée';
$string['noidnumber'] = 'Pas d\'identifiant';
$string['nolettergrade'] = 'Pas de note lettre pour';
$string['nomode'] = 'ND';
$string['nonnumericweight'] = 'Valeur non numérique reçue pour';
$string['nonunlockableverbose'] = 'Pour déverrouiller cette note, vous devez d\'abord déverrouiller {$a->itemname}.';
$string['nonweightedpct'] = '% non pondéré';
$string['nooutcome'] = 'Aucun objectif';
$string['nooutcomes'] = 'Les éléments d\'objectif doivent être liés à un objectif de cours. Il n\'y a cependant aucun objectif défini dans ce cours. Voulez-vous en définir un ?';
$string['nopermissiontoresetweights'] = 'Vous n\'avez pas les permissions requises pour réinitialiser les pondérations';
$string['nopublish'] = 'Ne pas publier';
$string['noreports'] = 'Vous n\'êtes inscrit à aucun cours, et n\'enseignez dans aucun cours sur ce site.';
$string['norolesdefined'] = 'Aucun rôle défini dans Administration > Notes > Réglages généraux > Rôles évalués';
$string['noscales'] = 'Les éléments d\'objectif doivent être liés à un barème de cours ou un barème global. Il n\'y a cependant aucun barème. Voulez-vous en définir un ?';
$string['noselectedcategories'] = 'Aucune catégorie sélectionnée.';
$string['noselecteditems'] = 'Aucun élément sélectionné.';
$string['notenrolled'] = 'Vous n\'êtes inscrit à aucun cours sur ce site.';
$string['notteachererror'] = 'Vous devez être enseignant pour utiliser cette fonctionnalité.';
$string['nousersloaded'] = 'Aucun utilisateur chargé';
$string['nouserstograde'] = 'Aucun utilisateur à évaluer';
$string['numberofgrades'] = 'Nombre de notes';
$string['onascaleof'] = 'sur un barème de {$a->grademin} à {$a->grademax}';
$string['operations'] = 'Opérations';
$string['options'] = 'Options';
$string['others'] = 'Autres';
$string['outcome'] = 'Objectif';
$string['outcome_help'] = 'Spécifie l\'objectif représenté par cet élément d\'évaluation dans le carnet de notes. Seuls les objectifs associés à ce cours et les objectifs globaux du site sont disponibles';
$string['outcomeassigntocourse'] = 'Attribuer un autre objectif à ce cours';
$string['outcomecategory'] = 'Créer des objectifs dans la catégorie';
$string['outcomecategorynew'] = 'Nouvelle catégorie';
$string['outcomeconfirmdelete'] = 'Voulez-vous vraiment supprimer l\'objectif « {$a} » ?';
$string['outcomecreate'] = 'Ajouter un objectif';
$string['outcomedelete'] = 'Supprimer objectif';
$string['outcomefullname'] = 'Nom complet';
$string['outcomeitem'] = 'Élément d\'objectif';
$string['outcomeitemsedit'] = 'Modifier élément d\'objectif';
$string['outcomereport'] = 'Rapport des objectifs';
$string['outcomes'] = 'Objectifs';
$string['outcomescourse'] = 'Objectifs utilisés dans le cours';
$string['outcomescoursecustom'] = 'Personnalisé utilisé (pas de suppression)';
$string['outcomescoursenotused'] = 'Standard non utilisé';
$string['outcomescourseused'] = 'Standard utilisé (pas de suppression)';
$string['outcomescustom'] = 'Objectifs personnalisés';
$string['outcomesdisabled'] = 'Les objectifs ne sont pas activés';
$string['outcomeshortname'] = 'Nom abrégé';
$string['outcomesstandard'] = 'Objectifs standards';
$string['outcomesstandardavailable'] = 'Objectifs standards disponibles';
$string['outcomestandard'] = 'Objectif standard';
$string['outcomestandard_help'] = 'Un objectif standard est disponible dans tout le site, pour tous les cours.';
$string['overallaverage'] = 'Moyenne globale';
$string['overridden'] = 'Court-circuité';
$string['overridden_help'] = 'Si ce réglage est activé, la note ne pourra pas être modifiée à partir de l\'activité d\'où elle provient.

Si une note est modifiée dans le rapport de l\'évaluateur, cette case est automatiquement cochée. Elle peut cependant être décochée pour permettre d\'être modifiée par le résultat de l\'activité.';
$string['overriddennotice'] = 'Votre note finale pour cette activité a été ajustée manuellement.';
$string['overridecat'] = 'Autoriser la modification manuelle des notes de catégorie';
$string['overridecat_help'] = 'Si ce réglage est activé, les notes de catégorie peuvent être modifiées manuellement.';
$string['overridesitedefaultgradedisplaytype'] = 'Court-circuiter les réglages du site';
$string['overridesitedefaultgradedisplaytype_help'] = 'Si ce réglage est activé, les notes lettres et les valeurs limites des notes peuvent être configurées par cours, au lieu d\'utiliser les valeurs par défaut de la plateforme.';
$string['overrideweightofa'] = 'Pondération forcée de {$a}';
$string['parentcategory'] = 'Catégorie mère';
$string['pass'] = 'Réussi';
$string['pctoftotalgrade'] = '% de la note maximale';
$string['percent'] = 'Pourcent';
$string['percentage'] = 'Pourcentage';
$string['percentageletter'] = 'Pourcentage (lettre)';
$string['percentagereal'] = 'Pourcentage (brut)';
$string['percentascending'] = 'Tri croissant par pourcent';
$string['percentdescending'] = 'Tri décroissant par pourcent';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Décalage';
$string['plusfactor_help'] = 'Ce nombre est ajouté à toutes les notes de cet élément d\'évaluation, après l\'application du multiplicateur.';
$string['plusfactorvalue'] = 'Décalage pour {$a}';
$string['points'] = 'points';
$string['pointsascending'] = 'Tri croissant par points';
$string['pointsdescending'] = 'Tri décroissant par points';
$string['positionfirst'] = 'Première ligne';
$string['positionlast'] = 'Dernière ligne';
$string['preferences'] = 'Préférences';
$string['prefgeneral'] = 'Général';
$string['prefletters'] = 'Notes lettres et limites';
$string['prefrows'] = 'Rangées spéciales';
$string['prefshow'] = 'Cacher/afficher';
$string['previewrows'] = 'Prévisualiser les rangées';
$string['privacy:metadata:categorieshistory'] = 'Un enregistrement des versions antérieures des catégories de notes';
$string['privacy:metadata:filepurpose'] = 'Les fichiers de feedback enregistrés dans le carnet de notes pour un utilisateur.';
$string['privacy:metadata:grade_import_newitem'] = 'Table temporaire enregistrant les nouveaux noms grade_items provenant d\'importations de notes';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Un identifiant unique de chaque lot d\'importations';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Utilisateur qui importe les données';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Nouveau nom de l\'élément d\'évaluation';
$string['privacy:metadata:grade_import_values'] = 'Table temporaire pour l\'importation des notes';
$string['privacy:metadata:grade_import_values:feedback'] = 'Feedback de note';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Valeur brute de la note';
$string['privacy:metadata:grade_import_values:importcode'] = 'Un identifiant unique de chaque lot d\'importation';
$string['privacy:metadata:grade_import_values:importer'] = 'Utilisateur qui importe les données';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Marque si seul le feedback a été importé';
$string['privacy:metadata:grade_import_values:userid'] = 'Utilisateur dont la note a été importé';
$string['privacy:metadata:grades'] = 'Un enregistrement des notes';
$string['privacy:metadata:grades:aggregationstatus'] = 'Le statut d\'agrégation';
$string['privacy:metadata:grades:aggregationweight'] = 'La pondération dans l\'agrégation';
$string['privacy:metadata:grades:feedback'] = 'Le feedback';
$string['privacy:metadata:grades:finalgrade'] = 'La note';
$string['privacy:metadata:grades:information'] = 'Informations complémentaires sur la note';
$string['privacy:metadata:grades:timemodified'] = 'La date et l\'heure de la dernière modification de la note';
$string['privacy:metadata:grades:userid'] = 'L\'identifiant de l\'utilisateur dont c\'est la note';
$string['privacy:metadata:grades:usermodified'] = 'L\'identifiant de l\'utilisateur qui a modifié l\'enregistrement pour la dernière fois';
$string['privacy:metadata:gradeshistory'] = 'Un enregistrement des notes antérieures';
$string['privacy:metadata:history:loggeduser'] = 'L\'identifiant de l\'utilisateur qui était connecté lorsque le changement de version a eu lieu';
$string['privacy:metadata:history:timemodified'] = 'La date et l\'heure du changement de version de la note';
$string['privacy:metadata:itemshistory'] = 'Un enregistrement des versions antérieures des éléments d\'évaluation';
$string['privacy:metadata:outcomes'] = 'Un enregistrement des objectifs';
$string['privacy:metadata:outcomes:timemodified'] = 'La date et l\'heure de la modification de l\'enregistrement';
$string['privacy:metadata:outcomes:usermodified'] = 'L\'utilisateur qui a modifié l\'enregistrement pour la dernière fois';
$string['privacy:metadata:outcomeshistory'] = 'Un enregistrement des versions antérieures des objectifs';
$string['privacy:metadata:scale'] = 'Un enregistrement des barèmes';
$string['privacy:metadata:scale:timemodified'] = 'La date et l\'heure de la dernière modification de l\'enregistrement';
$string['privacy:metadata:scale:userid'] = 'L\'utilisateur qui a modifié l\'enregistrement pour la dernière fois';
$string['privacy:metadata:scalehistory'] = 'Un enregistrement des versions antérieures des barèmes';
$string['privacy:path:relatedtome'] = 'En lien avec moi';
$string['privacy:request:historyactiondelete'] = 'Suppression';
$string['privacy:request:historyactioninsert'] = 'Insertion';
$string['privacy:request:historyactionupdate'] = 'Mise à jour';
$string['privacy:request:unknowndeletedgradeitem'] = 'Inconnu (l\'élément d\'évaluation a été supprimé)';
$string['profilereport'] = 'Rapport du profil utilisateur';
$string['profilereport_help'] = 'Rapport d\'évaluation présenté dans les profils utilisateur.';
$string['publishing'] = 'Publication en cours';
$string['publishingoptions'] = 'Options de publication des notes';
$string['quickfeedback'] = 'Feedback rapide';
$string['quickgrading'] = 'Évaluation rapide';
$string['quickgrading_help'] = 'Si ce réglage est activé, lorsque le mode de modification est actif, un champ de texte est affiché à côté des notes du rapport de l\'évaluateur, permettant de modifier de nombreuses notes à la fois. Les modifications sont enregistrées et surlignées quand le bouton Modifier est cliqué.

Quand une note est modifiée dans le rapport de l\'évaluateur, elle ne peut plus être modifiée par le résultat de l\'activité d\'où elle provient.';
$string['range'] = 'Valeurs possibles';
$string['rangedecimals'] = 'Décimales de l\'intervalle';
$string['rangedecimals_help'] = 'Nombre de décimales à afficher pour l\'intervalle.';
$string['rangesdecimalpoints'] = 'Décimales des valeurs possibles';
$string['rangesdecimalpoints_help'] = 'Ce réglage spécifie le nombre de décimales à afficher pour chaque intervalle valeurs possibles, ou si le réglage de la catégorie ou de l\'élément d\'évaluation est utilisé (par héritage).';
$string['rangesdisplaytype'] = 'Type d\'affichage des valeurs possibles';
$string['rangesdisplaytype_help'] = 'Ce réglage spécifie comment afficher les valeurs possibles : comme notes réelles, pourcentages ou lettres, ou si l\'affichage défini au niveau de la catégorie ou de l\'élément d\'évaluation est utilisé (par héritage).';
$string['rank'] = 'Rang';
$string['rawpct'] = '% brut';
$string['real'] = 'Brut';
$string['realletter'] = 'Brut (lettre)';
$string['realpercentage'] = 'Brut (pourcentage)';
$string['recalculatinggrades'] = 'Re-calcul des notes';
$string['recovergradesdefault'] = 'Récupérer par défaut les notes';
$string['recovergradesdefault_help'] = 'Par défaut, récupérer les anciennes notes lors de la ré-inscription d\'un participant à un cours.';
$string['refreshpreview'] = 'Actualiser la prévisualisation';
$string['regradeanyway'] = 'Réévaluer malgré tout';
$string['removeallcoursegrades'] = 'Supprimer toutes les notes';
$string['removeallcoursegrades_help'] = 'Si ce réglage est activé, tous les éléments d\'évaluation et les notes ajoutées manuellement au carnet de notes seront supprimés, ainsi que les notes et autres données associées aux notes modifiées, exclues, cachées et verrouillées. Seuls les éléments d\'évaluation et notes associés avec des activités persisteront.';
$string['removeallcourseitems'] = 'Supprimer tous les éléments et catégories';
$string['removeallcourseitems_help'] = 'Si ce réglage est activé, toutes les catégories et tous les éléments d\'évaluation ajoutés manuellement au carnet de notes seront supprimés, ainsi que les notes et autres données associées aux notes modifiées, exclues, cachées et verrouillées. Seuls les éléments d\'évaluation associés avec des activités persisteront.';
$string['report'] = 'Rapport';
$string['reportdefault'] = 'Réglage par défaut du rapport ({$a})';
$string['reportplugins'] = 'Modules de rapport';
$string['reportsettings'] = 'Réglages des rapports';
$string['reprintheaders'] = 'Réafficher les entêtes';
$string['resetweights'] = 'Réinitialiser les pondérations de {$a->itemname}';
$string['resetweightsshort'] = 'Réinitialiser les pondérations';
$string['respectingcurrentdata'] = 'en conservant la configuration actuelle';
$string['rowpreviewnum'] = 'Prévisualiser les rangées';
$string['rowpreviewnum_help'] = 'Les données a importer peuvent être prévisualisées avant de confirmer l\'importation. Ce réglage détermine le nombre de lignes à afficher dans la prévisualisation.';
$string['savechanges'] = 'Enregistrer les changements';
$string['savepreferences'] = 'Enregistrer les préférences';
$string['scaleconfirmdelete'] = 'Voulez-vous vraiment supprimer le barème « {$a} » ?';
$string['scaledpct'] = '% pondéré';
$string['seeallcoursegrades'] = 'Voir toutes les notes du cours';
$string['select'] = 'Sélectionner {$a}';
$string['selectalloroneuser'] = 'Sélectionner tous ou un utilisateur';
$string['selectauser'] = 'Sélectionner un utilisateur';
$string['selectdestination'] = 'Choisir la destination de {$a}';
$string['separator'] = 'Séparateur';
$string['separator_help'] = 'Sélectionner le caractère de séparation utilisé dans le fichier CSV (en principe une virgule).';
$string['sepcolon'] = 'Deux-points';
$string['sepcomma'] = 'Virgule';
$string['sepsemicolon'] = 'Point-virgule';
$string['septab'] = 'Tabulateur';
$string['setcategories'] = 'Catégories';
$string['setcategorieserror'] = 'Les catégories doivent être mises en place dans votre cours avant de pouvoir leur attribuer des coefficients.';
$string['setgradeletters'] = 'Notes lettres';
$string['setpreferences'] = 'Préférences';
$string['setting'] = 'Réglage';
$string['settings'] = 'Réglages';
$string['setup'] = 'Réglages';
$string['setweights'] = 'Coefficients';
$string['showactivityicons'] = 'Afficher icônes d\'activité';
$string['showactivityicons_help'] = 'Si ce réglage est activé, l\'icône de l\'activité est affichée en regard des noms des activités.';
$string['showallhidden'] = 'Afficher les éléments cachés';
$string['showallstudents'] = 'Afficher tous les étudiants';
$string['showanalysisicon'] = 'Afficher l\'icône d\'analyse de l\'évaluation';
$string['showanalysisicon_desc'] = 'Ce réglage détermine s\'il faut afficher par défaut l\'icône d\'analyse de l\'évaluation. Si l\'activité le permet, l\'icône d\'analyse de l\'évaluation lie vers une page avec des informations plus détaillées sur l\'évaluation et comment elle a été obtenue.';
$string['showanalysisicon_help'] = 'Si l\'activité le permet, l\'icône d\'analyse de l\'évaluation lie vers une page avec des informations plus détaillées sur l\'évaluation et comment elle a été obtenue.';
$string['showaverage'] = 'Afficher la moyenne';
$string['showaverage_help'] = 'Si ce réglage est activé, la colonne avec la moyenne sera affichée. Les étudiants pourraient alors être en mesure d\'estimer les notes d\'autres étudiants, si la moyenne est calculée à partir de peu de notes. Pour des raisons de performance, la moyenne est une estimation lorsqu\'elle dépend d\'éléments cachés.';
$string['showaverages'] = 'Afficher les moyennes';
$string['showaverages_help'] = 'Si ce réglage est activé, le rapport de l\'évaluateur contiendra une rangée supplémentaire affichant la moyenne de chaque catégorie et chaque élément d\'évaluation.';
$string['showcalculations'] = 'Afficher les calculs';
$string['showcalculations_help'] = 'Si ce réglage est activé, une icône de calculatrice est affichée pour chaque élément d\'évaluation et chaque catégorie, avec un indicateur visuel montrant qu\'une colonne est calculée.';
$string['showcontributiontocoursetotal'] = 'Afficher la contribution au total du cours';
$string['showcontributiontocoursetotal_help'] = 'Ce réglage détermine si une colonne doit être affichée, comprenant la contribution en pour-cents de chaque élément d\'évaluation au pourcentage total de l\'utilisateur dans ce cours, après pondération.';
$string['showeyecons'] = 'Afficher icônes afficher/cacher';
$string['showeyecons_help'] = 'Afficher une icône afficher/cacher pour chaque note (cette icône permet de masquer ou d\'afficher la note pour les participants) ?';
$string['showfeedback'] = 'Afficher les feedbacks';
$string['showfeedback_help'] = 'Si ce réglage est activé, la colonne des feedbacks sera affichée.';
$string['showgrade'] = 'Afficher les notes';
$string['showgrade_help'] = 'Si ce réglage est activé, la colonne des notes sera affichée.';
$string['showgroups'] = 'Afficher les groupes';
$string['showhiddenitems'] = 'Afficher les éléments cachés';
$string['showhiddenitems_help'] = 'Spécifie si les éléments d\'évaluations cachés sont totalement invisibles ou si les noms des éléments d\'évaluations cachés sont visibles pour les étudiants.

* Afficher les éléments cachés : les noms des éléments d\'évaluations cachés sont affichés, mais les notes sont cachées
* Cacher les éléments jusqu\'au : les éléments d\'évaluation et les notes sont totalement invisibles, jusqu\'à l\'échéance de la date fixée, s\'il y en a une. Une fois le date passée, l\'élément et les notes sont affichées
* Cacher les éléments : les éléments d\'évaluation et les notes sont totalement invisibles';
$string['showhiddenuntilonly'] = 'Cacher les éléments jusqu\'au';
$string['showingaggregatesonly'] = 'N\'afficher que les tendances centrales';
$string['showingfullmode'] = 'Afficher la vue complète';
$string['showinggradesonly'] = 'N\'afficher que les notes';
$string['showlettergrade'] = 'Afficher les notes lettres';
$string['showlettergrade_help'] = 'Si ce réglage est activé, la colonne des notes lettres sera affichée.';
$string['showlocks'] = 'Afficher les cadenas';
$string['showlocks_help'] = 'Afficher une icône de verrouillage/déverrouillage pour chaque note ?';
$string['shownohidden'] = 'Cacher les éléments';
$string['shownooutcomes'] = 'Cacher les objectifs';
$string['shownumberofgrades'] = 'Afficher le nombre des notes dans les moyennes';
$string['shownumberofgrades_help'] = 'Spécifie si le nombre des notes utilisées pour calculer la moyenne doit être affiché entre parenthèses, à côté de chaque moyenne. Exemple : 45 (34).';
$string['showonlyactiveenrol'] = 'N\'afficher que les inscriptions actives';
$string['showonlyactiveenrol_help'] = 'Ce réglage détermine si les seuls utilisateurs visibles dans le carnet de notes sont ceux dont l\'inscription est active. Si le réglage est actif, les utilisateurs suspendus ne seront pas affichés dans le carnet de notes.';
$string['showpercentage'] = 'Afficher les pour-cents';
$string['showpercentage_help'] = 'Si ce réglage est activé, la valeur en pour-cents de chaque élément d\'évaluation sera affichée.';
$string['showquickfeedback'] = 'Afficher le feedback rapide';
$string['showquickfeedback_help'] = 'Le feedback rapide ajoute un champ de texte à chaque cellule de note du rapport de l\'évaluateur, vous permettant de modifier de nombreux feedbacks à la fois. Vous pouvez alors cliquer sur le bouton Modifier pour effectuer d\'un coup toutes les modifications, au lieu de les faire une à la fois.';
$string['showrange'] = 'Afficher les intervalles';
$string['showrange_help'] = 'Si ce réglage est activé, la colonne des intervalles sera affichée.';
$string['showranges'] = 'Afficher les valeurs possibles';
$string['showranges_help'] = 'Si ce réglage est activé, le rapport de l\'évaluateur contiendra une rangée supplémentaire affichant pour chaque catégorie et chaque élément d\'évaluation les valeurs possibles des notes.';
$string['showrank'] = 'Afficher le rang';
$string['showrank_help'] = 'Si ce réglage est activé, le rang du participant par rapport aux autres participants sera affiché pour chaque élément d\'évaluation.';
$string['showuserimage'] = 'Afficher les avatars';
$string['showuserimage_help'] = 'Afficher l\'image de l\'utilisateur à côté de son nom dans le rapport de l\'évaluateur.';
$string['showverbose'] = 'Afficher {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Afficher les coefficients';
$string['showweight_help'] = 'Si ce réglage est activé, la colonne des coefficients sera affichée.';
$string['simpleview'] = 'Affichage simplifié';
$string['singleview'] = 'Affichage simplifié pour {$a}';
$string['sitewide'] = 'Pour tout le site';
$string['sort'] = 'Trier';
$string['sortasc'] = 'Trier par ordre croissant';
$string['sortbyfirstname'] = 'Trier par prénom';
$string['sortbylastname'] = 'Trier par nom';
$string['sortdesc'] = 'Trier par ordre décroissant';
$string['standarddeviation'] = 'Écart type';
$string['stats'] = 'Statistiques';
$string['statslink'] = 'Stats';
$string['student'] = 'Participants';
$string['studentsperpage'] = 'Participants par page';
$string['studentsperpage_help'] = 'Le nombre de participants à afficher par page dans le rapport de l\'évaluateur.';
$string['studentsperpagereduced'] = 'Le nombre maximum de participants par page a été réduit de {$a->originalstudentsperpage} à {$a->studentsperpage}. Vous devriez peut-être augmenter le réglage PHP max_input_vars, actuellement de {$a->maxinputvars}.';
$string['subcategory'] = 'Catégorie normale';
$string['submissions'] = 'Remises';
$string['submittedon'] = 'Remis le {$a}';
$string['sumofgradesupgradedgrades'] = 'Remarque : la méthode de calcul de la tendance centrale « Somme des notes » a été changé à « Naturelle » au cours de la mise à jour du site. Puisque la méthode « Somme des notes » était utilisée dans ce cours, il vous est conseillé de vérifier le résultat de cette modification dans le carnet de notes.';
$string['switchtofullview'] = 'Passer à l\'affichage complet';
$string['switchtosimpleview'] = 'Passer à l\'affichage simple';
$string['tabs'] = 'Onglets';
$string['topcategory'] = 'Super-catégorie';
$string['total'] = 'Total';
$string['totalweight100'] = 'Le total des coefficients vaut 100';
$string['totalweightnot100'] = 'Le total des coefficients n\'est pas égal à 100';
$string['turnfeedbackoff'] = 'Désactiver le feedback';
$string['turnfeedbackon'] = 'Activer le feedback';
$string['typenone'] = 'Aucun';
$string['typescale'] = 'Barème';
$string['typescale_help'] = 'Ce réglage détermine le barème à utiliser lorsque le type de note est barème. Le barème d\'un élément d\'évaluation basé sur une activité est géré dans les paramètres de l\'activité.';
$string['typetext'] = 'Texte';
$string['typevalue'] = 'Valeur';
$string['uncategorised'] = 'Sans catégorie';
$string['unchangedgrade'] = 'Non inchangée';
$string['unenrolledusersinimport'] = 'Ce fichier d\'importation contenait les notes suivantes d\'utilisateurs n\'étant actuellement pas inscrits dans ce cours : {$a}';
$string['unlimitedgrades'] = 'Notes illimitées';
$string['unlimitedgrades_help'] = 'Par défaut, les notes sont limitées par les valeurs maximales et minimales de l\'élément d\'évaluation. L\'activation de ce réglage retire cette limite et permet de saisir directement dans le carnet de notes des notes dépassant 100%.';
$string['unlock'] = 'Déverrouiller';
$string['unlockverbose'] = 'Déverrouiller {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Pas utilisée';
$string['updatedgradesonly'] = 'N\'exporter que les notes nouvelles ou modifiées';
$string['upgradedgradeshidemessage'] = 'Ignorer l\'avertissement';
$string['upgradedminmaxrevertmessage'] = 'Annuler les modifications';
$string['uploadgrades'] = 'Déposer des notes';
$string['useadvanced'] = 'Fonctions avancées';
$string['usedcourses'] = 'Cours utilisés';
$string['usedgradeitem'] = 'Élément d\'évaluation utilisé';
$string['usenooutcome'] = 'Ne pas utiliser d\'objectif';
$string['usenoscale'] = 'Ne pas utiliser de barème';
$string['usepercent'] = 'Utiliser les pourcentages';
$string['user'] = 'Utilisateur';
$string['userenrolmentsuspended'] = 'Inscription d\'utilisateurs suspendue';
$string['userfields_show'] = 'Afficher les champs utilisateur';
$string['userfields_show_help'] = 'Afficher sur le rapport de l\'évaluateur les champs utilisateur supplémentaires, tels que l\'adresse de courriel. L\'affichage de ces champs est contrôlé par le réglage de site <em>showuseridentity</em>.';
$string['usergrade'] = 'Utilisateur {$a->fullname} ({$a->useridnumber}) dans l\'élément {$a->gradeidnumber}';
$string['userid'] = 'ID utilisateur';
$string['useridnumberwarning'] = 'Les utilisateurs sans numéro d\'identification sont exclus de l\'exportation, car il ne peuvent pas être importés';
$string['usermappingerror'] = 'Erreur de correspondance utilisateur : impossible de trouver un utilisateur avec une valeur « {$a->value} » pour le champ {$a->field}.';
$string['usermappingerrorcurrentgroup'] = 'L\'utilisateur n\'appartient pas au groupe actuel.';
$string['usermappingerrormultipleusersfound'] = 'Erreur de correspondance utilisateur : plusieurs utilisateurs ont été trouvés avec la valeur « {$a->value} » dans le champ {$a->field}. Veuillez utiliser un autre champ avec valeurs uniques pour effectuer la correspondance.';
$string['usermappingerrorusernotfound'] = 'Erreur de correspondance utilisateur : impossible de trouver l\'utilisateur.';
$string['userpreferences'] = 'Préférences utilisateur';
$string['useweighted'] = 'Utiliser les pondérations';
$string['verbosescales'] = 'Barèmes textuels';
$string['verbosescales_help'] = 'Un barème textuel utilise des mots plutôt que des nombres. Indiquez « Oui » si les barèmes numériques et textuels doivent être importés. Indiquez « Non » si vous ne voulez importer que les barèmes numériques.';
$string['viewbygroup'] = 'Groupe';
$string['viewgrades'] = 'Affichage des notes';
$string['weight'] = 'Pondération';
$string['weight_help'] = 'Valeur utilisée pour déterminer l\'importance relative des éléments d\'évaluation dans une catégorie ou un cours.';
$string['weightcourse'] = 'Utiliser les coefficients pour le cours';
$string['weightedascending'] = 'Tri croissant par pourcent pondéré';
$string['weighteddescending'] = 'Tri décroissant par pourcent pondéré';
$string['weightedpct'] = '% pondéré';
$string['weightedpctcontribution'] = 'contribution en % pondérée';
$string['weightofa'] = 'Pondération de {$a}';
$string['weightorextracredit'] = 'Pondération ou bonus';
$string['weightoverride'] = 'Ajustement de la pondération';
$string['weightoverride_help'] = 'Dé-cocher pour réinitialiser la pondération d\'un élément d\'évaluation à sa valeur calculée automatiquement. Si cette case est cochée, la pondération ne sera pas ajustée automatiquement.';
$string['weights'] = 'Coefficients';
$string['weightsadjusted'] = 'Les pondérations ont été ajustées à un total de 100.';
$string['weightsedit'] = 'Modifier les pondérations et les bonus';
$string['weightuc'] = 'Pondération calculée';
$string['writinggradebookinfo'] = 'Écriture des réglages du carnet de notes';
$string['xml'] = 'XML';
$string['yes'] = 'Oui';
$string['yourgrade'] = 'Votre note';
