<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'lo', version '4.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'ກຳລັງຈະຖືກຕິດຕັ້ງ';
$string['accept'] = 'ຍອມຮັບ';
$string['action'] = 'ການປະຕິບັດ';
$string['actionchoice'] = 'ທ່ານຕ້ອງການເຮັດຫຍັງກັບໄຟລ໌ \'{$a}\'?';
$string['actions'] = 'ການປະຕິບັດ';
$string['actionsfor'] = 'ການປະຕິບັດສຳລັບ';
$string['actionsmenu'] = 'ເມນູການປະຕິບັດ';
$string['active'] = 'ການໃຊ້ງານ';
$string['activeusers'] = 'ສະມາຊິກປະຈຸບັນ';
$string['activities'] = 'ກິດຈະກຳຕ່າງໆ';
$string['activities_help'] = 'ກິດຈະກໍາຕ່າງໆ, ເຊັ່ນ: ກອງປະຊຸມ, ແບບທົດສອບ ແລະ wikis, ເຮັດໃຫ້ເນື້ອໃນການໂຕ້ຕອບໄດ້ຖືກເພີ່ມເຂົ້າໃນຫຼັກສູດ.';
$string['activity'] = 'ກິດຈະກຳ';
$string['activityclipboard'] = 'ກຳລັງຍ້າຍກິດຈະກຳນີ້ : {$a}';
$string['activityheader'] = 'ເມນູກິດຈະກຳ';
$string['activityiscurrentlyhidden'] = 'ຂໍອະໄພ, ປະຈຸບັນກິດຈະກໍານີ້ຖືກເຊື່ອງໄວ້';
$string['activitymodule'] = 'ຊຸດກິດຈະກຳ';
$string['activitymodules'] = 'ຊຸດກິດຈະກຳ';
$string['activityreport'] = 'ລາຍງານຜົນກິດຈະກຳ';
$string['activityreports'] = 'ລາຍງານຜົນກິດຈະກຳ';
$string['activityselect'] = 'ເລືອກກິດຈະກຳນີ້ເພື່ອຍ້າຍໄປບ່ອນອື່ນ';
$string['activitysince'] = 'ກິດຈະກຳ ຕັ້ງແຕ່ {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'ກິດຈະກຳຕໍ່ຜູ້ໃຊ້';
$string['add'] = 'ເພີ່ມ';
$string['addactivity'] = 'ເພີ່ມກິດຈະກຳ...';
$string['addactivitytosection'] = 'ເພີ່ມກິດຈະກຳໄປພາກສ່ວນ \'{$a}\'';
$string['addadmin'] = 'ເພີ່ມຜູ້ເບິ່ງແຍງລະບົບ';
$string['addblock'] = 'ເພີ່ມບລັອກ';
$string['addcomment'] = 'ຂຽນຄຳເຫັນ...';
$string['addcountertousername'] = 'ສ້າງຜູ້ໃຊ້ໂດຍການເພີ່ມຕົວເລກໃສ່ຊື່ຜູ້ໃຊ້';
$string['addcreator'] = 'ເພີ່ມຜູ້ສ້າງລາຍວິຊາ';
$string['adddots'] = 'ເພີ່ມ...';
$string['added'] = 'ເພີ່ມ {$a}  ແລ້ວ';
$string['addedtogroup'] = 'ເພີ່ມໃນກຸ່ມ "{$a}" ແລ້ວ';
$string['addedtogroupnot'] = 'ຍັງບໍ່ໄດ້ເພີ່ມເຂົ້າໄປໃນກຸ່ມ "{$a}"';
$string['addedtogroupnotenrolled'] = 'ຍັງບໍ່ໄດ້ເພີ່ມເຂົ້າໄປໃນກຸ່ມ "{$a}", ເພາະຍັງບໍ່ໄດ້ສະໝັກເຂົ້າຮຽນໃນວິຊານີ້';
$string['addfilehere'] = 'ວາງໄຟລ໌ທີ່ນີ້ເພື່ອເພີ່ມມັນທີ່ດ້ານລຸ່ມຂອງພາກສ່ວນນີ້';
$string['addinganew'] = 'ກຳລັງເພີ່ມ {$a} ໃໝ່';
$string['addinganewto'] = 'ເພີ່ມ {$a->what} ໃໝ່ລົງໃນ {$a->to}';
$string['addingdatatoexisting'] = 'ເພີ່ມຂໍ້ມູນລົງໃນທີ່ມີຢູ່ແລ້ວ';
$string['additionalcustomnav'] = 'ການນຳທາງແບບກຳນົດເອງເພີ່ມເຕີມ';
$string['additionalnames'] = 'ຊື່ເພີ່ມຕື່ມ';
$string['addlinkhere'] = 'ເພີ່ມລິ້ງທີ່ນີ້';
$string['addnew'] = 'ເພີ່ມ {$a} ໃໝ່';
$string['addnewcategory'] = 'ເພີ່ມປະເພດໃໝ່';
$string['addnewcourse'] = 'ເພີ່ມລາຍວິຊາໃໝ່';
$string['addnewuser'] = 'ເພີ່ມຜູ້ໃຊ້ໃໝ່';
$string['addnousersrecip'] = 'ເພີ່ມຜູ້ໃຊ້ທີ່ບໍ່ສາມາດເຂົ້າເຖິງ {$a} ນີ້ລົງໃນລາຍຊື່ຜູ້ຮັບ';
$string['addpagehere'] = 'ຂຽນຂໍ້ຄວາມທີ່ນີ້';
$string['addresource'] = 'ເພີ່ມແຫຼ່ງຂໍ້ມູນ...';
$string['addresourceoractivity'] = 'ເພີ່ມກິດຈະກຳ ຫຼື ແຫຼ່ງຂໍ້ມູນ';
$string['addresourcetosection'] = 'ເພີ່ມແຫຼ່ງຂໍ້ມູນໄປພາກທີ {$a}\'';
$string['address'] = 'ທີ່ຢູ່';
$string['addsections'] = 'ເພີ່ມພາກ';
$string['addstudent'] = 'ເພີ່ມນັກຮຽນ';
$string['addsubcategory'] = 'ເພີ່ມປະເພດຍ່ອຍ';
$string['addteacher'] = 'ເພີ່ມອາຈານ';
$string['admin'] = 'ຜູ້ເບິ່ງແຍງລະບົບ';
$string['adminhelpaddnewuser'] = 'ເພີ່ມຜູ້ໃຊ້ໃໝ່ດ້ວຍຕົນເອງ';
$string['adminhelpassignadmins'] = 'ຜູ້ເບິ່ງແຍງລະບົບສາມາດເຮັດຫຍັງກໍໄດ້ ແລະ ໄປທີ່ໃດກໍໄດ້ໃນເວັບ';
$string['adminhelpassigncreators'] = 'ຜູ້ສ້າງວິຊາສາມາດເພີ່ມວິຊາຕ່າງໆໃໝ່ໄດ້';
$string['adminhelpassignsiteroles'] = 'ນຳໃຊ້ບົດບາດຂອງເວັບໄຊທ໌ທີ່ໄດ້ກຳນົດໄວ້ໃຫ້ກັບຜູ້ໃຊ້ສະເພາະ';
$string['adminhelpassignstudents'] = 'ໄປຍັງລາຍວິຊາ ແລະ ເພີ່ມນັກຮຽນຈາກເມນູຜູ້ເບິ່ງແຍງລະບົບ';
$string['adminhelpauthentication'] = 'ເຈົ້າສາມາດໃຊ້ບັນຊີຜູ້ໃຊ້ພາຍໃນ ຫຼື ນອກລະບົບຖານຂໍ້ມູນ';
$string['adminhelpbackup'] = 'ຕັ້ງຄ່າການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['adminhelpconfiguration'] = 'ຕັ້ງຄ່າວ່າ ໜ້າເວັບເປັນແນວໃດ ແລະ ເຮັດວຽກແນວໃດ';
$string['adminhelpconfigvariables'] = 'ຕັ້ງຄ່າຕົວແປທີ່ມີຜົນຕໍ່ການເຮັດວຽກທົ່ວໄປຂອງເວັບໄຊທ໌';
$string['adminhelpcourses'] = 'ກຳນົດວິຊາ ແລະ ປະເພດແລ້ວມອບໝາຍຄົນໃຫ້ເຂົາເຈົ້າ, ແກ້ໄຂວິຊາຕ່າງໆທີ່ຍັງຄົງຄ້າງ';
$string['adminhelpeditorsettings'] = 'ກຳນົດຄ່າພື້ນຖານຂອງ HTML editor';
$string['adminhelpedituser'] = 'ເບິ່ງລາຍຊື່ສະມາຊິກແລະແກ້ໄຂຂອງໃຜກໍໄດ້';
$string['adminhelpenvironment'] = 'ກວດສອບ server ວ່າເໝາະສົມກັບຄວາມຕ້ອງການໃນການຕິດຕັ້ງໂປແກມ Moodle';
$string['adminhelpfailurelogs'] = 'ເບິ່ງບັນທຶກການລັອກອິນເຂົ້າສູ່ລະບົບທີ່ບໍ່ສຳເລັດ';
$string['adminhelplanguage'] = 'ສຳລັບກວດສອບແລະແກ້ໄຂພາສາປະຈຸບັນ';
$string['adminhelplogs'] = 'ເບິ່ງບັນທຶກກິດຈະກຳທັງໝົດເທິງເວັບໄຊຕ໌';
$string['adminhelpmanageblocks'] = 'ຈັດການ blocks ແລະຕັ້ງຄ່າ';
$string['adminhelpmanagedatabase'] = 'ເຂົ້າໄປຖານຂໍ້ມູນໂດຍກົງ ( ລະວັງ ! )';
$string['adminhelpmanagefilters'] = 'ເລືອກ text filters ແລະຕັ້ງຄ່າທີ່ກ່ຽວຂ້ອງ';
$string['adminhelpmanagemodules'] = 'ຈັດການຕິດຕັ້ງ Module ແລະຕັ້ງຄ່າຕ່າງ ໆ';
$string['adminhelpmanageroles'] = 'ສ້າງ ແລະ ກຳນົດບົດບາດທີ່ອາດຈະຖືກນຳໃຊ້ກັບຜູ້ໃຊ້';
$string['adminhelpmymoodle'] = 'ຕັ້ງຄ່າ Moodle blocks ຂອງຂ້ອຍສຳລັບຜູ້ໃຊ້';
$string['adminhelpreports'] = 'ລາຍງານລະດັບທັງເວັບໄຊທ໌';
$string['adminhelpsitefiles'] = 'ສຳລັບເຜີຍແຜ່ໄຟລ໌ທົ່ວໄປ ຫຼື ອັບໂຫຼດການສຳຮອງພາຍນອກ';
$string['adminhelpsitesettings'] = 'ກຳນົດວ່າໜ້າຫຼັກເວັບໄຊທ໌ເປັນແນວໃດ';
$string['adminhelpstickyblocks'] = 'ຕັ້ງຄ່າບລັອກໜຽວຂອງ Moodle-wide';
$string['adminhelpthemes'] = 'ເລືອກວ່າເວັບໄຊທ໌ເປັນແນວໃດ ( ສີ, ຕົວໜັງສື ແລະ ອື່ນໆ)';
$string['adminhelpuploadusers'] = 'ນຳເຂົ້າບັນຊີຜູ້ໃຊ້ໃໝ່ຈາກໄຟລ໌ຂໍ້ຄວາມ';
$string['adminhelpusers'] = 'ກຳນົດຜູ້ໃຊ້ຂອງທ່ານ ແລະ ຕັ້ງຄ່າການກວດສອບຄວາມຖືກຕ້ອງ';
$string['adminhelpxmldbeditor'] = 'ອິນເຕີເຟດເພື່ອແກ້ໄຂໄຟລ໌ XMLDB. ພຽງແຕ່ສໍາລັບນັກພັດທະນາ.';
$string['administration'] = 'ການຈັດການລະບົບ';
$string['administrationsite'] = 'ການດູແລເວັບໄຊທ໌';
$string['administrator'] = 'ຜູ້ເບິ່ງແຍງລະບົບ';
$string['administratordescription'] = 'ໂດຍປົກກະຕິແລ້ວຜູ້ບໍລິຫານສາມາດເຮັດທຸກໆຢ່າງໄດ້ຢູ່ໃນເວັບໄຊທ໌, ໃນທຸກວິຊາ.';
$string['administrators'] = 'ຜູ້ເບິ່ງແຍງລະບົບ';
$string['administratorsall'] = 'ຜູ້ເບິ່ງແຍງລະບົບທັງໝົດ';
$string['administratorsandteachers'] = 'ຜູ້ເບິ່ງແຍງລະບົບ ແລະ ອາຈານ';
$string['advanced'] = 'ຂັ້ນສູງ';
$string['advancedfilter'] = 'ການຄົ້ນຫາຂັ້ນສູງ';
$string['advancedsettings'] = 'ການຕັ້ງຄ່າຂັ້ນສູງ';
$string['afterresource'] = 'ຫຼັງຈາກແຫຼ່ງ "{$a}"';
$string['aftersection'] = 'ຫຼັງຈາກພາກ "{$a}"';
$string['again'] = 'ອີກຄັ້ງ';
$string['agelocationverification'] = 'ການຢັ້ງຢືນສະຖານທີ່ ແລະ ອາຍຸ';
$string['aimid'] = 'ລະຫັດ AIM ID';
$string['ajaxuse'] = 'AJAX ແລະ Javascript';
$string['all'] = 'ທັງໝົດ';
$string['allactions'] = 'ການປະຕິບັດທັງໝົດ';
$string['allactivities'] = 'ກິດຈະກຳທັງໝົດ';
$string['allcategories'] = 'ປະເພດທັງມົດ';
$string['allchanges'] = 'ການປ່ຽນແປງທັງໝົດ';
$string['alldays'] = 'ມື້ທັງໝົດ';
$string['allfiles'] = 'ໄຟລ໌ທັງໝົດ';
$string['allgroups'] = 'ກຸ່ມທັງໝົດ';
$string['alllogs'] = 'ບັນທຶກທັງໝົດ';
$string['allmods'] = '{$a} ທັງໝົດ';
$string['allow'] = 'ອະນຸຍາດ';
$string['allowinternal'] = 'ອະນຸຍາດວິທີພາຍໃນເຊັ່ນດຽວກັນ';
$string['allownone'] = 'ບໍ່ອະນຸຍາດທັງໝົດ';
$string['allownot'] = 'ບໍ່ອະນຸຍາດ';
$string['allowstealthmodules'] = 'ອະນຸຍາດໃຫ້ມີກິດຈະກຳເຊື່ອງ';
$string['allowstealthmodules_help'] = 'ຖ້າເປີດໃຊ້, ກິດຈະກໍາສາມາດເຮັດໄດ້ແຕ່ບໍ່ສະແດງຢູ່ໃນພາກສ່ວນທີ່ເບິ່ງເຫັນໄດ້ຂອງໜ້າຫຼັກສູດ. ຖ້າເປັນແນວນັ້ນ, ລິ້ງໄປຫາກິດຈະກໍາເຊື່ອງຕ້ອງໄດ້ສະໜອງໃຫ້ຈາກບ່ອນອື່ນ, ເຊັ່ນ: ຈາກແຫຼ່ງຂໍ້ມູນໜ້າ. ກິດຈະກຳເຊື່ອງຍັງມີລາຍຊື່ຢູ່ໃນປຶ້ມຮຽນ ແລະ ບົດລາຍງານອື່ນໆ.';
$string['allparticipants'] = 'ສະມາຊິກທັງໝົດ';
$string['allteachers'] = 'ອາຈານທັງໝົດ';
$string['alphanumerical'] = 'ສາມາດປະກອບມີຕົວອັກສອນ ແລະ ຕົວເລກ, ຂີດຊື່ (-) ຫຼືເຄື່ອງໝາຍຈໍ້າເມັດ (.) ເທົ່ານັ້ນ';
$string['alreadyconfirmed'] = 'ຢືນຢັນການລົງທະບຽນຮຽບຮ້ອຍແລ້ວ';
$string['alternatename'] = 'ຊື່ສຳຮອງ';
$string['always'] = 'ຕະຫລອດເວລາ';
$string['and'] = '{$a->one} and {$a->two}';
$string['answer'] = 'ຄຳຕອບ';
$string['any'] = 'ອັນໃດອັນໜຶ່ງ';
$string['appearance'] = 'ຮູບລັກສະນະ';
$string['approve'] = 'ເຫັນດີ';
$string['areyousure'] = 'ທ່ານແນ່ໃຈບໍ?';
$string['areyousuretorestorethis'] = 'ທ່ານຕ້ອງການສືບຕໍ່ໄປຫຼືບໍ່?';
$string['areyousuretorestorethisinfo'] = 'ຫຼັງຈາກໃນຂະບວນການນີ້ ທ່ານຈະມີທາງເລືອກທີ່ຈະເພີ່ມຂໍ້ມູນສຳຮອງໃສ່ຫຼັກສູດທີ່ມີຢູ່ແລ້ວ ຫຼື ສ້າງຫຼັກສູດໃໝ່ທັງໝົດ.';
$string['asc'] = 'ນ້ອຍຫາໃຫຍ່';
$string['assessment'] = 'ການປະເມີນ';
$string['assignadmins'] = 'ແຕ່ງຕັ້ງຜູ້ເບິ່ງແຍງລະບົບ';
$string['assigncreators'] = 'ມອບໝາຍຜູ້ສ້າງເວັບ';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'ມອບໝາຍໜ້າທີ່ທັງໝົດເວັບໄຊທ໌';
$string['authenticateduser'] = 'ຜູ້ໃຊ້ກວດສອບຄວາມຖືກຕ້ອງແລ້ວ';
$string['authenticateduserdescription'] = 'ຜູ້ໃຊ້ທີ່ເຂົ້າສູ່ລະບົບແລ້ວທັງໝົດ';
$string['authentication'] = 'ການກວດສອບຄວາມຖືກຕ້ອງ';
$string['authenticationplugins'] = 'ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງ';
$string['autosubscribe'] = 'ສະໝັກກອງປະຊຸມອັດຕະໂນມັດ';
$string['autosubscribeno'] = 'ບໍ່: ບໍ່ສະໝັກໃຫ້ຂ້ອຍໂດຍອັດຕະໂນມັດກັບກອງປະຊຸມສົນທະນາ';
$string['autosubscribeyes'] = 'ແມ່ນແລ້ວ: ເມື່ອຂ້ອຍໂພສ, ໃຫ້ສະໝັກຂ້ອຍໄປໃນກອງປະຊຸມສົນທະນານັ້ນ';
$string['availability'] = 'ບ່ອນທີ່ຫວ່າງຢູ່';
$string['availablecourses'] = 'ວິຊາທີ່ສາມາດຮຽນໄດ້';
$string['back'] = 'ກັບຄືນ';
$string['backto'] = 'ກັບຄືນໄປ {$a}';
$string['backtocourselisting'] = 'ກັບຄືນໄປລາຍການວິຊາ';
$string['backtohome'] = 'ກັບຄືນສູ່ໜ້າຫຼັກເວັບໄຊທ໌';
$string['backtopageyouwereon'] = 'ກັບຄືນສູ່ໜ້າທີ່ທ່ານເຄີຍຢູ່';
$string['backup'] = 'ການສຳຮອງຂໍ້ມູນ';
$string['backupactivehelp'] = 'ເລືອກວ່າຈະເຮັດການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດຫຼືບໍ່.';
$string['backupadhocpending'] = 'ການສຳຮອງວິຊາໃນວຽກທີ່ຍັງຄ້າງຢູ່';
$string['backupcancelled'] = 'ຍົກເລີກການສຳຮອງຂໍ້ມູນແລ້ວ';
$string['backupcoursefileshelp'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ ຫຼັງຈາກນັ້ນໄຟລ໌ວິຊາຈະມີການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['backupdate'] = 'ວັນທີທີ່ສຳຮອງຂໍ້ມູນ';
$string['backupdatenew'] = '&nbsp; {$a->TAG} ໃນຕອນນີ້ {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} ແມ່ນ {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'ລາຍລະອຽດການສຳຮອງຂໍ້ມູນ';
$string['backuperrorinvaliddestination'] = 'ໂຟນເດີປາຍທາງການສຳຮອງຂໍ້ມູນບໍ່ມີຢູ່ ຫຼື ບໍ່ສາມາດຂຽນໃສ່ໄດ້';
$string['backupexecuteathelp'] = 'ເລືອກວ່າເວລາທີ່ການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດຄວນດຳເນີນທີ່ເວລາໃດ.';
$string['backupfailed'] = 'ບາງວິຊາຍັງຂອງທ່ານບໍ່ໄດ້ຮັບການບັນທຶກ!!';
$string['backupfilename'] = 'ການຂໍ້ມູນສຳຮອງ';
$string['backupfinished'] = 'ການສຳຮອງຂໍ້ມູນສຳເລັດແລ້ວ';
$string['backupfromthissite'] = 'ການສຳຮອງຂໍ້ມູນແມ່ນເຮັດໃນເວັບໄຊທ໌ນີ້ບໍ?';
$string['backupgradebookhistoryhelp'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ ປະຫວັດປຶ້ມບັນທຶກຊັ້ນ ຈະຖືກລວມເຂົ້າຢູ່ໃນການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດ. ຈື່ໄວ້ວ່າປະຫວັດຊັ້ນຮຽນຈະຕ້ອງບໍ່ຖືກປິດໃຊ້ງານຢູ່ໃນການຕັ້ງຄ່າເຊີບເວີ (disablegradehistory) ເພື່ອໃຫ້ອັນນີ້ໃຊ້ໄດ້';
$string['backupincludemoduleshelp'] = 'ເລືອກວ່າທ່ານຕ້ອງການລວມຂໍ້ມູນຊຸດວິຊາກັບມີ ຫຼື ບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້, ຢູ່ໃນການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['backupincludemoduleuserdatahelp'] = 'ເລືອກວ່າທ່ານຕ້ອງການລວມເອົາຊຸດຂໍ້ມູນຜູ້ໃຊ້ໃນການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດຫຼືບໍ່.';
$string['backuplogdetailed'] = 'ບັນທຶກການປະຕິບັດລະອຽດ';
$string['backuploglaststatus'] = 'ບັນທຶກການປະຕິບັດເທື່ອລ່າສຸດ';
$string['backupmissinguserinfoperms'] = 'ໝາຍເຫດ: ການສຳຮອງຂໍ້ມູນນີ້ບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້. ກິດຈະກໍາການປະຕິບັດ ແລະ ກອງປະຊຸມຈະບໍ່ລວມຢູ່ໃນການສໍາຮອງຂໍ້ມູນ, ເນື່ອງຈາກວ່າຊຸດເຫຼົ່ານີ້ບໍ່ເຂົ້າກັນໄດ້ກັບການສໍາຮອງຂໍ້ມູນປະເພດນີ້.';
$string['backupnext'] = 'ການສຳຮອງຂໍ້ມູນຄັ້ງຕໍ່ໄປ';
$string['backupnonisowarning'] = 'ຄຳເຕືອນ : ຂໍ້ມູນສຳຮອງນີ້ມາຈາກ Module ທີ່ບໍ່ເປັນ unicode ( ເວີລ໌ຊັນກ່ອນໜ້າ 1.6). ຖ້າການສໍາຮອງຂໍ້ມູນນີ້ມີຕົວໜັງສືທີ່ບໍ່ແມ່ນ ISO-8859-1, ສະນັ້ນພວກມັນອາດຈະເສຍຫາຍ ຖ້າທ່ານພະຍາຍາມກູ້ພວກມັນຄືນມາເປັນ Moodle ສະບັບ Unicode ນີ້. ເບິ່ງ <a href="https://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> ສໍາລັບຂໍ້ມູນເພີ່ມເຕີມກ່ຽວກັບວິທີກູ້ຄືນການສໍາຮອງຂໍ້ມູນນີ້ຢ່າງຖືກຕ້ອງ.';
$string['backupnotyetrun'] = 'ລໍຖ້າການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['backuporiginalname'] = 'ຊື່ຂອງການສຳຮອງຂໍ້ມູນ';
$string['backuproleassignments'] = 'ການມອບໝາຍບົດບາດການສຳຮອງຂໍ້ມູນສຳລັບບົດບາດເຫຼົ່ານີ້';
$string['backupsavetohelp'] = 'ເສັ້ນທາງເຕັມໄປຫາລະບົບບ່ອນທີ່ທ່ານຕ້ອງການບັນທຶກໄຟລ໌ສຳຮອງ';
$string['backupsitefileshelp'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວໄຟລ໌ເວັບໄຊທ໌ທີ່ໃຊ້ຢູ່ໃນວິຊາຈະຖືກລວມເຂົ້າຢູ່ໃນການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['backuptakealook'] = 'ກະລຸນາເຂົ້າເບິ່ງບັນທຶກການສຳຮອງຂໍ້ມູນຂອງທ່ານໃນ:
 {$a}';
$string['backupuserfileshelp'] = 'ເລືອກວ່າໄຟລ໌ຂອງຜູ້ໃຊ້ (ຕົວຢ່າງ: ຮູບໂປຣໄຟລ໌) ຄວນລວມຢູ່ໃນການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດຫຼືບໍ່';
$string['backupversion'] = 'ລຸ້ນການສຳຮອງຂໍ້ມູນ';
$string['badges'] = 'ປ້າຍກຳກັບ';
$string['block'] = 'ບລັອກ';
$string['blockconfiga'] = 'ຕັ້ງຄ່າບລັອກ {$a}';
$string['blockconfigbad'] = 'ບລັອກນີ້ບໍ່ໄດ້ຖືກປະຕິບັດຢ່າງຖືກຕ້ອງ ແລະ ດັ່ງນັ້ນຈິ່ງບໍ່ສາມາດສະໜອງການໂຕ້ຕອບການຕັ້ງຄ່າໄດ້.';
$string['blocks'] = 'ບລັອກ';
$string['blocksaddedit'] = 'ເພີ່ມ/ແກ້ໄຂ ບລັອກ';
$string['blockseditoff'] = 'ປິດການແກ້ໄຂ ບລັອກ';
$string['blocksediton'] = 'ເປີດການແກ້ໄຂ ບລັອກ';
$string['blocksetup'] = 'ຕັ້ງຄ່າຕາຕະລາງ ບລັອກ';
$string['blocksuccess'] = 'ຕາຕະລາງ {$a} ຕັ້ງຄ່າຢ່າງຖືກຕ້ອງແລ້ວ';
$string['brief'] = 'ສະຫຼຸບຫຍໍ້';
$string['bulkactions'] = 'ຄຳສັ່ງຊຸດໃຫຍ່';
$string['bulkactionselect'] = 'ເລືອກຄຳສັ່ງ {$a} ຊຸດໃຫຍ່';
$string['bulkmovecoursessuccess'] = 'ຍ້າຍວິຊາ {$a->courses} ເຂົ້າໃນ {$a->category} ຢ່າງສຳເລັດ';
$string['bycourseorder'] = 'ລຽງຕາມລຳດັບວິຊາ';
$string['byname'] = 'ໂດຍ {$a}';
$string['bypassed'] = 'ຂ້າມ';
$string['cachecontrols'] = 'ການຄວບຄຸມແຄດ';
$string['calltofeedback'] = 'ຜູ້ສ້າງຊອບແວນີ້ຢາກໄດ້ຄຳຕິຊົມຂອງທ່ານ.';
$string['calltofeedback_give'] = 'ໃຫ້ຄຳຕິຊົມກ່ຽວກັບຊອບແວນີ້';
$string['calltofeedback_remind'] = 'ເຕືອນຂ້ອຍພາຍຫຼັງ';
$string['cancel'] = 'ຍົກເລີກ';
$string['cancelled'] = 'ຍົກເລີກແລ້ວ';
$string['categories'] = 'ປະເພດວິຊາ';
$string['categoriesandcourses'] = 'ປະເພດວິຊາ ແລະ ວິຊາຕ່າງໆ';
$string['category'] = 'ປະເພດ';
$string['categoryadded'] = 'ເພີ່ມປະເພດ \'{$a}\' ແລ້ວ';
$string['categorybulkaction'] = 'ການປະຕິບັດຊຸດໃຫຍ່ສຳລັບປະເພດທີ່ເລືອກແລ້ວ';
$string['categorycontents'] = 'ປະເພດຍ່ອຍ ແລະ ວິຊາຕ່າງໆ';
$string['categorycurrentcontents'] = 'ເນື້ອໃນຂອງ {$a}';
$string['categorydeleted'] = 'ລືບປະເພດ \'{$a}\' ແລ້ວ';
$string['categoryduplicate'] = 'ປະເພດຊື່ \'{$a}\' ມີຢູ່ແລ້ວ';
$string['categoryheader'] = 'ເມນູປະເພດ';
$string['categoryhidden'] = '(ເຊື່ອງໄວ້)';
$string['categorymodifiedcancel'] = 'ປະເພດຖືກແກ້ໄຂ! ກະລຸນາຍົກເລີກແລ້ວລອງໃໝ່.';
$string['categoryname'] = 'ຊື່ປະເພດ';
$string['categorypath'] = 'ເສັ້ນທາງປະເພດ';
$string['categorysubcategoryof'] = '{$a->category} - ປະເພດຍ່ອຍຂອງ {$a->parentcategory}';
$string['categoryupdated'] = 'ອັບເດດປະເພດ \'{$a}\' ແລ້ວ';
$string['changedpassword'] = 'ປ່ຽນລະຫັດຜ່ານແລ້ວ';
$string['changepassword'] = 'ປ່ຽນລະຫັດຜ່ານ';
$string['changesmade'] = 'ເຮັດການປ່ຽນແປງ';
$string['changesmadereallygoaway'] = 'ທ່ານໄດ້ເຮັດການປ່ຽນແປງ. ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການອອກໄປ ແລະ ສູນເສຍການປ່ຽນແປງຂອງທ່ານ?';
$string['changessaved'] = 'ບັນທຶກການປ່ຽນແປງແລ້ວ';
$string['check'] = 'ກວດສອບ';
$string['checkactual'] = 'ຕົວຈິງ';
$string['checkall'] = 'ກວດສອບທັງໝົດ';
$string['checkexpected'] = 'ຄາດວ່າ';
$string['checkingbackup'] = 'ກວດສອບການສຳຮອງຂໍ້ມູນ';
$string['checkingcourse'] = 'ກວດສອບວິຊາ';
$string['checkingforbbexport'] = 'ກວດສອບການສົ່ງອອກ BlackBoard';
$string['checkinginstances'] = 'ກຳລັງກວດສອບຕົວຢ່າງ';
$string['checkingsections'] = 'ກວດສອບພາກຕ່າງໆ';
$string['checklanguage'] = 'ກວດສອບພາສາ';
$string['checknone'] = 'ກວດສອບບໍ່ມີ';
$string['checks'] = 'ກວດສອບ';
$string['checksok'] = '\'{$a}\' ທັງໝົດ ຕົກລົງ';
$string['childcoursenotfound'] = 'ບໍ່ພົບວິຊາສຳລັບເດັກ';
$string['childcourses'] = 'ວິຊາສຳລັບເດັກ';
$string['choose'] = 'ເລືອກ';
$string['choosecourse'] = 'ເລືອກວິຊາ';
$string['choosedots'] = 'ເລືອກ...';
$string['chooselivelogs'] = 'ຫຼື ເບິ່ງກິດຈະກຳປະຈຸບັນ';
$string['chooselogs'] = 'ເລືອກບັນທຶກທີ່ຕ້ອງການເບິ່ງ';
$string['choosereportfilter'] = 'ເລືອກຕົວກອງສຳລັບບົດລາຍງານ';
$string['choosetheme'] = 'ເລືອກຮູບແບບສີສັນ';
$string['chooseuser'] = 'ເລືອກຜູ້ໃຊ້';
$string['city'] = 'ແຂວງ/ເມືອງ';
$string['cleaningtempdata'] = 'ລຶບລ້າງຂໍ້ມູນຊົ່ວຄາວ';
$string['clear'] = 'ລ້າງ';
$string['clearsearch'] = 'ລ້າງການປ້ອນເຂົ້າການຄົ້ນຫາ';
$string['clickhelpiconformoreinfo'] = '... ສືບຕໍ່ ... ຄລິກທີ່ໄອຄອນຊ່ວຍເຫຼືອເພື່ອອ່ານບົດຄວາມເຕັມ';
$string['clickhere'] = 'ຄລິກທີ່ນີ້ ...';
$string['clicktochangeinbrackets'] = '{$a} (ຄລິກເພື່ອປ່ຽນແປງ)';
$string['clicktohideshow'] = 'ຄລິກເພື່ອຂະຫຍາຍ ຫຼື ຍຸບ';
$string['closeblockdrawer'] = 'ປິດລິ້ນຊັກບລັອກ';
$string['closebuttontitle'] = 'ປິດ';
$string['closecourseindex'] = 'ປິດດັດສະນີລາຍວິຊາ';
$string['closedrawer'] = 'ປິດລິ້ນຊັກ';
$string['closewindow'] = 'ປິດໜ້າຕ່າງ';
$string['collapse'] = 'ຍຸບ';
$string['collapseall'] = 'ຫຍໍ້ລົງທັງໝົດ';
$string['collapsecategory'] = 'ຍຸບ {$a}';
$string['commentincontext'] = 'ຊອກຫາຄຳເຫັນນີ້ໃນຄວາມໝາຢທົ່ວໄປ';
$string['comments'] = 'ຄຳເຫັນ';
$string['commentscount'] = 'ຄຳເຫັນ ({$a})';
$string['commentsnotenabled'] = 'ຄຸນສົມບັດຄຳເຫັນບໍ່ໄດ້ຖືກເປີດນຳໃຊ້';
$string['commentsrequirelogin'] = 'ທ່ານຕ້ອງເຂົ້າສູ່ລະບົບເພື່ອເບິ່ງຄຳເຫັນ.';
$string['comparelanguage'] = 'ສົມທຽບ ແລະ ແກ້ໄຂພາສາປະຈຸບັນ';
$string['complete'] = 'ສຳເລັດ';
$string['completed'] = 'ສຳເລັດແລ້ວ';
$string['completereport'] = 'ລາຍງານສຳເລັດ';
$string['configuration'] = 'ການຕັ້ງຄ່າ';
$string['confirm'] = 'ຢືນຢັນ';
$string['confirmcheckfull'] = 'ທ່ານແນ່ໃຈແທ້ບໍວ່າທ່ານຕ້ອງການຢືນຢັນ {$a}?';
$string['confirmcoursemove'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການຍ້າຍວິຊາ ({$a->course}) ນີ້ເຂົ້າໄປໃນປະເພດ ({$a->category}) ນີ້?';
$string['confirmdeletesection'] = 'ທ່ານແນ່ໃຈແທ້ບໍວ່າທ່ານຕ້ອງການລຶບ "{$a}" ແລະ ກິດຈະກຳທັງໝົດທີ່ມັນມີ?';
$string['confirmed'] = 'ການລົງທະບຽນຂອງທ່ານໄດ້ຮັບການຢືນຢັນແລ້ວ';
$string['confirmednot'] = 'ການລົງທະບຽນຂອງທ່ານຍັງບໍ່ທັນໄດ້ຮັບການຢືນຢັນເທື່ອ. ກະລຸນາກວດເບິ່ງກ່ອງຈົດໝາຍຂອງທ່ານສຳລັບອີເມວການຢືນຢັນ.';
$string['considereddigitalminor'] = 'ທ່ານອາຍຸຍັງນ້ອຍເກີນໄປທີ່ຈະສ້າງບັນຊີຢູ່ໃນເວັບໄຊທ໌ນີ້.';
$string['content'] = 'ເນື້ອໃນ';
$string['contentbank'] = 'ທະນາຄານເນື້ອໃນ';
$string['contentexport_aboutthiscourse'] = 'ສະຫຼຸບວິຊາ';
$string['contentexport_coursesummary'] = 'ໄຟລ໌ນີ້ແມ່ນສ່ວນໜຶ່ງຂອງເນື້ອໃນທີ່ດາວໂຫຼດມາຈາກ <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'ໄຟລ໌ນີ້ແມ່ນສ່ວນໜຶ່ງຂອງເນື້ອໃນທີ່ດາວໂຫຼດມາຈາກ <a href="{$a->courselink}">{$a->coursename}</a> by {$a->userfullname} on {$a->date}.';
$string['contentexport_modulesummary'] = 'ໄຟລ໌ນີ້ແມ່ນສ່ວນໜຶ່ງຂອງເນື້ອໃນທີ່ດາວໂຫຼດມາຈາກ <a href="{$a->modulelink}">{$a->modulename}</a> on {$a->date}. ຈື່ໄວ້ວ່າເນື້ອໃນບາງອັນ ແລະ ໄຟລ໌ໃດໜຶ່ງທີ່ໃຫຍ່ກວ່າ {$a->maxfilesize} ແມ່ນບໍ່ໄດ້ດາວໂຫຼດ.';
$string['contentexport_viewfilename'] = 'ເບິ່ງໄຟລ໌ {$a}';
$string['continue'] = 'ສືບຕໍ່';
$string['continuetocourse'] = 'ຄລິກທີ່ນີ້ເພື່ອໃສ່ຊື່ວິຊາຂອງທ່ານ';
$string['convertingwikitomarkdown'] = 'ປ່ຽນ wiki ໄປເປັນ Markdown';
$string['cookiesenabled'] = 'ຄຸກກີ້ຕ້ອງໄດ້ເປີດໃຊ້ງານໃນບຣາວເຊີຂອງທ່ານ';
$string['cookiesenabled_help'] = 'ມີການໃຊ້ຄຸກກີ້ສອງອັນຢູ່ໃນເວັບໄຊທ໌ນີ້:

ອັນທີ່ຈຳເປັນແມ່ນຄຸກກີ້ເຊສຊັນ, ໂດຍປົກກະຕິເອີ້ນວ່າ MoodleSession. ທ່ານຕ້ອງອະນຸຍາດໃຫ້ຄຸກກີ້ນີ້ຢູ່ໃນບຣາວເຊີຂອງທ່ານ ເພື່ອໃຫ້ມີຄວາມຕໍ່ເນື່ອງ ແລະ ເພື່ອໃຫ້ໄດ້ເຂົ້າສູ່ລະບົບຢູ່ສະເໝີເມື່ອທ່ອງໃນເວັບໄຊທ໌. ເມື່ອທ່ານອອກຈາກລະບົບ ຫຼື ປິດບຣາວເຊີ, ຄຸກກີ້ນີ້ຈະຖືກທໍາລາຍ (ໃນບຣາວເຊີຂອງທ່ານແລະ ໃນເຊີບເວີ).

ຄຸກກີ້ອື່ນແມ່ນເພື່ອຄວາມສະດວກສະບາຍເທົ່ານັ້ນ, ໂດຍປົກກະຕິແລ້ວເອີ້ນວ່າ MOODLEID ຫຼື ຄ້າຍຄືກັນ. ມັນພຽງແຕ່ຈື່ຊື່ຜູ້ໃຊ້ຂອງທ່ານໃນບຣາວເຊີ. ນີ້ໝາຍຄວາມວ່າ ເມື່ອທ່ານກັບຄືນໄປຫາເວັບໄຊທ໌ນີ້, ຊ່ອງໃສ່ຊື່ຜູ້ໃຊ້ຢູ່ໃນໜ້າເຂົ້າສູ່ລະບົບແມ່ນໄດ້ຕື່ມໃສ່ໃຫ້ທ່ານແລ້ວ. ມັນປອດໄພທີ່ຈະປະຕິເສດຄຸກກີ້ນີ້ - ພຽງແຕ່ທ່ານຈະຕ້ອງໄດ້ພິມຊື່ຜູ້ໃຊ້ຂອງທ່ານຄືນໃໝ່ແຕ່ລະຄັ້ງທີ່ທ່ານເຂົ້າສູ່ລະບົບ.';
$string['cookiesenabled_help_html'] = 'ສອງຄຸກກີ້ຖືກໃຊ້ຢູ່ໃນເວັບໄຊນີ້:<br/><br/>

ສິ່ງທີ່ສໍາຄັນແມ່ນຄຸກກີ້ຊ່ວງເວລາ, ປົກກະຕິແລ້ວເອີ້ນວ່າ MoodleSession. ທ່ານຕ້ອງອະນຸຍາດໃຫ້ຄຸກກີ້ນີ້ຢູ່ໃນຕົວທ່ອງເວັບຂອງທ່ານ ເພື່ອສະໜອງຄວາມຕໍ່ເນື່ອງ ແລະ ສືບຕໍ່ເຂົ້າສູ່ລະບົບໃນເວລາທ່ອງເວັບ. ເມື່ອທ່ານອອກຈາກລະບົບ ຫຼື ປິດຕົວທ່ອງເວັບ, ຄຸກກີ້ນີ້ຈະຖືກທຳລາຍ (ໃນຕົວທ່ອງເວັບຂອງທ່ານ ແລະ ໃນເຊີບເວີ).<br/><br/>

ຄຸກກີ້ອື່ນແມ່ນເພື່ອຄວາມສະດວກຢ່າງແທ້ຈິງ, ປົກກະຕິແລ້ວເອີ້ນວ່າ MOODLEID ຫຼື ຄ້າຍຄືກັນ. ມັນພຽງແຕ່ຈື່ຊື່ຜູ້ໃຊ້ຂອງທ່ານໃນຕົວທ່ອງເວັບ. ນີ້ຫມາຍຄວາມວ່າ ເມື່ອທ່ານກັບຄືນໄປຫາເວັບໄຊທ໌ນີ້, ຊ່ອງຂໍ້ມູນຊື່ຜູ້ໃຊ້ຢູ່ໃນໜ້າເຂົ້າສູ່ລະບົບຈະຖືກຕື່ມໃສ່ໃຫ້ທ່ານແລ້ວ. ມັນປອດໄພທີ່ຈະປະຕິເສດຄຸກກີ້ນີ້ - ທ່ານພຽງແຕ່ຈະຕ້ອງພິມຊື່ຜູ້ໃຊ້ຂອງທ່ານຄືນໃໝ່ໃນແຕ່ລະຄັ້ງທີ່ທ່ານເຂົ້າສູ່ລະບົບ.';
$string['cookiesenabledonlysession'] = 'ຄຸກກີ້ຕ້ອງໄດ້ເປີດໃຊ້ງານໃນບຣາວເຊີຂອງທ່ານ';
$string['cookiesenabledonlysession_help'] = 'ເວັບໄຊທ໌ນີ້ໃຊ້ຄຸກກີ້ເຊສຊັນໜຶ່ງ, ໂດຍປົກກະຕິແລ້ວເອີ້ນວ່າ MoodleSession. ທ່ານຕ້ອງອະນຸຍາດໃຫ້ຄຸກກີ້ນີ້ຢູ່ໃນບຣາວເຊີຂອງທ່ານ ເພື່ອໃຫ້ມີຄວາມຕໍ່ເນື່ອງ ແລະ ເພື່ອໃຫ້ໄດ້ເຂົ້າສູ່ລະບົບຢູ່ສະເໝີເມື່ອທ່ອງໃນເວັບໄຊທ໌. ເມື່ອທ່ານອອກຈາກລະບົບ ຫຼື ປິດບຣາວເຊີ, ຄຸກກີ້ນີ້ຈະຖືກທໍາລາຍ (ໃນບຣາວເຊີຂອງທ່ານ ແລະ ໃນເຊີບເວີ).';
$string['cookiesnotenabled'] = 'ໂຊກບໍ່ດີ, ປະຈຸບັນຄຸກກີ້ບໍ່ໄດ້ຖືກເປີດໃຊ້ໃນລຣາວເຊີຂອງທ່ານ';
$string['cookiesnotice'] = 'ແຈ້ງການຄຸກກີ້';
$string['copy'] = 'ຄັດລອກ';
$string['copyasnoun'] = 'ຄັດລອກ';
$string['copycourse'] = 'ຄັດລອກວິຊາ';
$string['copyingcoursefiles'] = 'ກຳລັງຄັດລອກໄຟລ໌ວິຊາ';
$string['copyingsitefiles'] = 'ກຳລັງຄັດລອກໄຟລ໌ທີ່ໃຊ້ໃນວິຊາ';
$string['copyinguserfiles'] = 'ກຳລັງຄັດລອກໄຟລ໌ຜູ້ໃຊ້';
$string['copyingzipfile'] = 'ກຳລັງຄັດລອກໄຟລ໌ zip';
$string['copyrightnotice'] = 'ຄໍາເຕືອນດ້ານລິຂະສິດ';
$string['coresystem'] = 'ລະບົບ';
$string['cost'] = 'ຄ່າໃຊ້ຈ່າຍ';
$string['costdefault'] = 'ຄ່າໃຊ້ຈ່າຍເລີ່ມຕົ້ນ';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'ປະເທດ';
$string['course'] = 'ວິຊາ';
$string['courseadministration'] = 'ການບໍລິຫານວິຊາ';
$string['courseapprovedemail'] = 'ວິຊາທີ່ທ່ານຮ້ອງຂໍ, {$a->name}, ໄດ້ຮັບການອະນຸມັດແລ້ວ ແລະ ທ່ານໄດ້ສ້າງ {$a->teacher}.  ເພື່ອເຂົ້າເຖິງວິຊາໃໝ່ຂອງທ່ານ, ໄປທີ່ {$a->url}';
$string['courseapprovedemail2'] = 'ວິຊາທີ່ທ່ານຮ້ອງຂໍ, {$a->name}, ໄດ້ຮັບການອະນຸມັດແລ້ວ.  ເພື່ອເຂົ້າເຖິງວິຊາໃໝ່ຂອງທ່ານ, ໄປທີ່ {$a->url}';
$string['courseapprovedfailed'] = 'ຜິດພາດໃນການບັນທຶກວິຊາຕາມທີ່ໄດ້ຮັບອະນຸມັດ';
$string['courseapprovedsubject'] = 'ວິຊາຂອງທ່ານໄດ້ຮັບການອະນຸມັດແລ້ວ!';
$string['courseavailable'] = 'ວິຊານີ້ມີໃຫ້ກັບນັກຮຽນ';
$string['courseavailablenot'] = 'ວິຊານີ້ບໍ່ມີໃຫ້ກັບນັກຮຽນ';
$string['coursebackup'] = 'ການສຳຮອງຂໍ້ມູນວິຊາ';
$string['coursebulkaction'] = 'ຄຳສັ່ງຊຸດໃຫຍ່ສຳລັບວິຊາທີ່ເລືອກ';
$string['coursecategories'] = 'ບັນດາປະເພດວິຊາ';
$string['coursecategory'] = 'ປະເພດວິຊາ';
$string['coursecategory_help'] = 'ການຕັ້ງຄ່ານີ້ກຳນົດປະເພດທີ່ວິຊາທີ່ຈະປະກົດຢູ່ໃນລາຍການວິຊາ.';
$string['coursecategorydeleted'] = 'ລຶບປະເພດວິຊາ {$a} ແລ້ວ';
$string['coursecatmanagement'] = 'ການຈັດການໝວດໝູ ແລະ ລາຍວິຊາ';
$string['coursecompletion'] = 'ການສຳເລັດວິຊາ';
$string['coursecompletions'] = 'ການສຳເລັດວິຊາ';
$string['coursecreators'] = 'ຜູ້ສ້າງວິຊາ';
$string['coursecreatorsdescription'] = 'ຜູ້ສ້າງວິຊາສາມາດສ້າງລາຍວິຊາໃໝ່ໄດ້.';
$string['coursedeleted'] = 'ລຶບວິຊາ {$a} ແລ້ວ';
$string['coursedetails'] = 'ລາຍລະອຽດວິຊາ';
$string['coursedisplay'] = 'ໂຄງຮ່າງວິຊາ';
$string['coursedisplay_help'] = 'ການຕັ້ງຄ່ານີ້ກຳນົດວ່າວິຊາທັງໝົດຖືກສະແດງຢູ່ໃນ ໜ້າດຽວ ຫຼື ແຍກອອກເປັນຫຼາຍໜ້າ.';
$string['coursedisplay_multi'] = 'ສະແດງໜຶ່ງພາກຕໍ່ໜຶ່ງໜ້າ';
$string['coursedisplay_single'] = 'ສະແດງພາກທັງໝົດໃນໜຶ່ງໜ້າ';
$string['courseduration'] = 'ໄລຍະເວລາວິຊາ';
$string['courseduration_desc'] = 'ໄລຍະເວລາຂອງວິຊາແມ່ນໃຊ້ເພື່ອຄິດໄລ່ຄໍານວນວັນທີ່ໄດ້ຮຽນຈົບວິຊາ. ວັນທີ່ຮຽນຈົບວິຊາແມ່ນໃຊ້ເພື່ອກໍານົດວ່າລາຍວິຊາໃດໜຶ່ງຈະຖືກລວມເຂົ້າໃນບັນດາວິຊາທີ່ຜູ້ນໍາໃຊ້ໄດ້ເລືອກໄວ້ຫຼືບໍ່. ມັນອາດຈະຖືກໃຊ້ໂດຍການລາຍງານແບບກໍານົດເອງ. ຜູ້ນໍາໃຊ້ຍັງສາມາດເຂົ້າເຖິງລາຍວິຊາໄດ້ພາຍຫຼັງວັນທີ່ຈົບວິຊາແລ້ວ.';
$string['courseenddateenabled'] = 'ວັນທີສິ້ນສຸດວິຊາເປີດໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['courseenddateenabled_desc'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດວ່າຈະເປີດໃຊ້ວັນທີສິ້ນສຸດວິຊາຕາມຫຼັກສູດໃໝ່ ແລະ ຕັ້ງເປັນວັນທີທີ່ຄໍານວນຈາກໄລຍະເວລາຫຼັກສູດ.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'ໄຟລ໌ຫຼັກສູດເດີມ';
$string['coursefilesedit'] = 'ແກ້ໄຂໄຟລ໌ຫຼັກສູດເດີມ';
$string['coursefileswarning'] = 'ໄຟລ໌ວິຊາຖືກຢຸດໃຊ້ແລ້ວ';
$string['coursefileswarning_help'] = 'ໄຟລ໌ວິຊາຢຸດໃຊ້ແລ້ວນັບຕັ້ງແຕ່ Moodle 2.0, ກະລຸນາໃຊ້ບ່ອນເກັບຂໍ້ມູນພາຍນອກແທນໃຫ້ຫຼາຍເທົ່າທີ່ຈະຫຼາຍໄດ້.';
$string['courseformatdata'] = 'ຂໍ້ມູນຮູບແບບວິຊາ';
$string['courseformatoptions'] = 'ທາງເລືອກການປັບຮູບແບບສຳລັບ {$a}';
$string['courseformats'] = 'ຮູບແບບວິຊາ';
$string['courseformatudpate'] = 'ອັບເດດຮູບແບບ';
$string['coursegrades'] = 'ລະດັບຄະແນນຂອງວິຊາ';
$string['courseheader'] = 'ເມນູວິຊາ';
$string['coursehelpcategory'] = 'ວາງຕຳແໜ່ງວິຊາຢູ່ໃນລາຍການວິຊາ ແລະ ອາດຈະເຮັດໃຫ້ນັກຮຽນຊອກຫາມັນງ່າຍຂຶ້ນ.';
$string['coursehelpforce'] = 'ບັງຄັບໂໝດກຸ່ມວິຊາໃຫ້ທຸກກິດຈະກໍາໃນວິຊາ.';
$string['coursehelpformat'] = 'ໜ້າຫຼັກຂອງວິຊາຈະສະແດງໃນຮູບແບບນີ້.';
$string['coursehelphiddensections'] = 'ພາກສ່ວນທີ່ເຊື່ອງໄວ້ໃນວິຊາສະແດງໃຫ້ນັກຮຽນເຫັນແນວໃດ.';
$string['coursehelpmaximumupload'] = 'ກຳນົດຂະໜາດໄຟລ໌ທີ່ໃຫຍ່ທີ່ສຸດທີ່ສາມາດອັບໂຫຼດໄດ້ໃນວິຊານີ້, ຖືກຈຳກັດໂດຍການຕັ້ງຄ່າທົ່ວເວັບໄຊທ໌.';
$string['coursehelpnewsitemsnumber'] = 'ຈຳນວນແຈ້ງການລ່າສຸດແຈ້ງການລ່າສຸດທີ່ປາກົດຢູ່ໃນບລັອກການປະກາດລ້າສຸດຢູ່ໃນໜ້າວິຊາ. ຖ້າຕັ້ງຄ່າເປັນສູນ, ບັນດາແຈ້ງການຈະບໍ່ຖືກສ້າງຂຶ້ນ.';
$string['coursehelpnumberweeks'] = 'ຈໍານວນຂອງພາກສ່ວນຢູ່ໃນວິຊາ (ນໍາໃຊ້ກັບຮູບແບບວິຊາສະເພາະເທົ່ານັ້ນ).';
$string['coursehelpshowgrades'] = 'ເປີດໃຊ້ງານການສະແດງຂອງປຶ້ມບັນທຶກຄະແນນ. ມັນບໍ່ໄດ້ປ້ອງກັນຄະແນນຈາກການສະແດງຢູ່ພາຍໃນກິດຈະກໍາສ່ວນບຸກຄົນ.';
$string['coursehidden'] = 'ປະຈຸບັນຫຼັກສູດນີ້ບໍ່ມີໃຫ້ແກ່ນັກຮຽນ';
$string['courseinfo'] = 'ຂໍ້ມູນວິຊາ';
$string['courselegacyfiles'] = 'ໄຟລ໌ຫຼັກສູດເດີມ';
$string['courselegacyfiles_help'] = 'ພື້ນທີ່ໄຟລ໌ວິຊາໃຫ້ເຂົ້າກັນໄດ້ແບບກັບຫຼັງກັບ Moodle 1.9 ແລະ ສະບັບກ່ອນໜ້ານີ້. ໄຟລ໌ທັງໝົດຢູ່ໃນພື້ນທີ່ນີ້ ແມ່ນສາມາດເຂົ້າເຖິງໄດ້ໂດຍຜູ້ເຂົ້າຮ່ວມທັງໝົດໃນຫຼັກສູດ (ບໍ່ວ່າເຈົ້າຈະລິ້ງຫາເຂົາເຈົ້າຫຼືບໍ່ກໍ່ຕາມ) ແລະ ບໍ່ມີທາງທີ່ຈະຮູ້ໄດ້ວ່າມີໄຟລ໌ເຫຼົ່ານີ້ຢູ່ໃສໃນ Moodle.

ຖ້າທ່ານໃຊ້ພື້ນທີ່ນີ້ເພື່ອເກັບຮັກສາໄຟລ໌ວິຊາ, ທ່ານສາມາດເປີດເຜີຍຕົວທ່ານເອງຕໍ່ກັບບັນຫາຄວາມເປັນສ່ວນຕົວ ແລະ ຄວາມປອດໄພຈໍານວນໜຶ່ງ, ພ້ອມທັງປະສົບກັບການສູນເສຍໄຟລ໌ໃນການສໍາຮອງຂໍ້ມູນ, ການນໍາເຂົ້າວິຊາ ແລະ ເວລາໃດກໍ່ຕາມທີ່ມີການແບ່ງປັນ ຫຼື ນໍາມາໃຊ້ຄືນໃໝ່. ສະນັ້ນ ມັນຖືກແນະນໍາວ່າ ຢ່າໃຊ້ພື້ນທີ່ນີ້ເວັ້ນເສຍແຕ່ວ່າທ່ານຮູ້ແທ້ວ່າເຈົ້າກໍາລັງເຮັດຫຍັງຢູ່.';
$string['courselegacyfilesofcourse'] = 'ໄຟລ໌ຫຼັກສູດເດີມ: {$a}';
$string['coursenotaccessible'] = 'ຫຼັກສູດນີ້ບໍ່ໄດ້ອະນຸຍາດໃຫ້ສາທາລະນະເຂົ້າເຖິງ';
$string['courseoverview'] = 'ພາບລວມຂອງລາຍວິຊາ';
$string['courseoverviewfiles'] = 'ຮູບພາບວິຊາ';
$string['courseoverviewfiles_help'] = 'ຮູບພາບວິຊາ ແມ່ນສະແດງຢູ່ໃນພາບລວມຂອງວິຊາໃນ ແຜງໜ້າປັດ. ປະເພດໄຟລ໌ທີ່ຍອມຮັບເພີ່ມເຕີມ ແລະ ຫຼາຍກ່ວາໜຶ່ງໄຟລ໌ອາດຖືກເປີດໃຊ້ໂດຍຜູ້ຄວບຄຸມເວັບໄຊທ໌. ຖ້າເປັນແນວນັ້ນ, ໄຟລ໌ເຫຼົ່ານີ້ຈະຖືກສະແດງຢູ່ຖັດຈາກ ບົດສະຫຼຸບວິຊາ ຢູ່ໃນລາຍຊື່ໜ້າວິຊາ.';
$string['courseoverviewfilesext'] = 'ສ່ວນຂະຫຍາຍໄຟລ໌ຮູບພາບລາຍວິຊາ';
$string['courseoverviewfileslimit'] = 'ຈຳກັດໄຟລ໌ຮູບພາບລາຍວິຊາ';
$string['courseoverviewgraph'] = 'ເສັ້ນສະແດງພາບລວມຂອງວິຊາ';
$string['coursepreferences'] = 'ການຕັ້ງຄ່າລາຍວິຊາ';
$string['courseprofiles'] = 'ໂປຼໄຟລ໌ວິຊາ';
$string['coursereasonforrejecting'] = 'ເຫດຜົນຂອງທ່ານໃນການປະຕິເສດຄຳຮ້ອງຂໍນີ້';
$string['coursereasonforrejectingemail'] = 'ອັນນີ້ຈະຖືກສົ່ງອີເມລຫາຜູ້ຮ້ອງຂໍ';
$string['coursereject'] = 'ປະຕິເສດຄໍາຮ້ອງຂໍຫຼັກສູດ';
$string['courserejected'] = 'ວິຊາໄດ້ຖືກປະຕິເສດ ແລະ ໄດ້ມີການແຈ້ງຜູ້ຮ້ອງຂໍ.';
$string['courserejectemail'] = 'ຂໍອະໄພ, ວິຊາທີ່ທ່ານໄດ້ຮ້ອງຂໍແມ່ນຖືກປະຕິເສດ. ດ້ວຍເຫດຜົນດັ່ງນີ້:

{$a}';
$string['courserejectreason'] = 'ອະທິບາຍເຫດຜົນຂອງທ່ານວ່າເປັນຫຍັງຈຶ່ງປະຕິເສດວິຊານີ້ <br />(ຄໍາຕອບນີ້ຈະຖືກສົ່ງໃຫ້ຜູ້ຮ້ອງຂໍ)';
$string['courserejectsubject'] = 'ລາຍວິຊາຂອງທ່ານໄດ້ຖືກປະຕິເສດ';
$string['coursereport'] = 'ລາຍງານວິຊາ';
$string['coursereports'] = 'ລາຍງານວິຊາ';
$string['courserequest'] = 'ຄໍາຮ້ອງຂໍລາຍວິຊາ';
$string['courserequestdetails'] = 'ລາຍລະອຽດຂອງຫຼັກສູດທີ່ທ່ານກໍາລັງຮ້ອງຂໍ';
$string['courserequestfailed'] = 'ດ້ວຍເຫດຜົນບາງປະການ, ຄໍາຮ້ອງຂໍລາຍວິຊາຂອງທ່ານບໍ່ສາມາດບັນທຶກໄດ້';
$string['courserequestintro'] = 'ນໍາໃຊ້ແບບຟອມສະບັບນີ້ ເພື່ອຮ້ອງຂໍໃຫ້ສ້າງລາຍວິຊາໃຫ້ແກ່ທ່ານ. <br />ພະຍາຍາມຕື່ມຂໍ້ມູນໃຫ້ຫຼາຍເທົ່າທີ່ທ່ານສາມາດຕື່ມໄດ້ເພື່ອອະນຸຍາດໃຫ້<br />ຜູ້ເບິ່ງແຍງລະບົບເຂົ້າໃຈວ່າເປັນຫຍັງທ່ານຈຶ່ງຕ້ອງການລົງທະບຽນລາຍວີຊານີ້.';
$string['courserequestreason'] = 'ເຫດຜົນທີ່ຕ້ອງການຮຽນວິຊານີ້';
$string['courserequestsuccess'] = 'ຄໍາຮ້ອງຂໍລາຍວິຊາຂອງທ່ານແມ່ນໄດ້ຖືກບັນທຶກຮຽບຮ້ອຍແລ້ວ. ທ່ານຈະໄດ້ຮັບອີເມວເພື່ອແຈ້ງໃຫ້ຊາບເມື່ອຄໍາຮ້ອງຂອງທ່ານຖືກອະນຸມັດ.';
$string['courserequestsupport'] = 'ຂໍ້ມູນສະໜັບສະໜູນເພື່ອຊ່ວຍໃຫ້ຜູ້ຄວບຄຸມລະບົບປະເມີນການຮ້ອງຂໍນີ້';
$string['courserequestwarning'] = 'ຜູ້ໃຊ້ທີ່ຮ້ອງຂໍວິຊານີ້ຈະຖືກລົງທະບຽນໂດຍອັດຕະໂນມັດ ແລະ ມອບໝາຍບົດບາດຂອງ {$ a}.';
$string['courserestore'] = 'ການຟື້ນຟູວິຊາ';
$string['coursereuse'] = 'ນຳໃຊ້ລາຍວິຊາຄືນໃໝ່';
$string['courses'] = 'ວິຊາ';
$string['coursesearch'] = 'ຄົ້ນຫາລາຍວິຊາ';
$string['coursesearch_help'] = 'ທ່ານສາມາດຄົ້ນຫາຄຳສັບຫຼາຍຄຳໃນເວລາດຽວກັນ ແລະ ສາມາດປັບປ່ຽນການຄົ້ນຫາຂອງທ່ານໄດ້ດັ່ງນີ້:

* ຄໍາສັບ - ຊອກຫາຄໍາສັບທີ່ກົງກັນຢູ່ພາຍໃນຂໍ້ຄວາມ
* +ຄໍາສັບ - ຈະພົບພຽງແຕ່ຄໍາສັບທີ່ກົງກັນທີ່ແນ່ນອນ
* -ຄຳສັບ - ບໍ່ລວມເອົາຜົນການຄົ້ນຫາທີ່ມີຄໍາສັບນີ້.';
$string['coursesectionsummaries'] = 'ສະຫຼຸບພາກວິຊາ';
$string['coursesectiontitle'] = 'ວິຊາ: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'ການຕັ້ງຄ່າເລີ່ມຕົ້ນຂອງວິຊາ';
$string['coursesmovedout'] = 'ວິຊາທີ່ຖືກຍ້າຍອອກຈາກ {$a}';
$string['coursespending'] = 'ວິຊາທີ່ຍັງລໍຖ້າການອະນຸມັດ';
$string['coursestart'] = 'ເລີ່ມຕົ້ນວິຊາ';
$string['coursesummary'] = 'ສະຫຼຸບວິຊາ';
$string['coursesummary_help'] = 'ສະຫຼຸບວິຊາ ແມ່ນສະແດງຢູ່ໃນລາຍການວິຊາ. ການຄົ້ນຫາວິຊາ ໄດ້ຄົ້ນຫາຂໍ້ຄວາມສະຫຼຸບວິຊານອກ ເໜືອໄປຈາກຊື່ວິຊາ.';
$string['coursetitle'] = 'ວິຊາ: {$a->course}';
$string['courseupdates'] = 'ການຍົກລະດັບວິຊາ';
$string['coursevisibility'] = 'ການເບິ່ງເຫັນວິຊາ';
$string['coursevisibility_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດວ່າວິຊາປະກົດຂຶ້ນຢູ່ໃນລາຍການວິຊາແລະບໍ່ວ່ານັກຮຽນສາມາດເຂົ້າເຖິງວິຊານັ້ນໄດ້. ຖ້າຕັ້ງເປັນເຊື່ອງ, ການເຂົ້າເຖິງແມ່ນຖືກຈໍາກັດຕໍ່ກັບຜູ້ໃຊ້ທີ່ມີຄວາມສາມາດເບິ່ງວິຊາທີ່ເຊື່ອງໄວ້ (ເຊັ່ນ: ຄູສອນ).';
$string['create'] = 'ສ້າງ';
$string['createaccount'] = 'ສ້າງບັນຊີຂອງຂ້ອຍໃໝ່';
$string['createcategory'] = 'ສ້າງປະເພດ';
$string['createfolder'] = 'ສ້າງໂຟນເດີໃນ {$a}';
$string['createnew'] = 'ສ້າງໃໝ່';
$string['createnewcategory'] = 'ສ້າງປະເພດໃໝ່';
$string['createnewcourse'] = 'ສ້າງວິຊາໃໝ່';
$string['createnewsubcategory'] = 'ສ້າງປະເພດຍ່ອຍໃໝ່';
$string['createsubcategoryof'] = 'ສ້າງປະເພດຍ່ອຍຂອງ {$a}';
$string['createuser'] = 'ສ້າງຜູ້ໃຊ້';
$string['createuserandpass'] = 'ເລືອກຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານຂອງທ່ານ';
$string['createziparchive'] = 'ສ້າງແຟ້ມຈັດເກັບ zip';
$string['creatingblocks'] = 'ການສ້າງບລັອກ';
$string['creatingblocksroles'] = 'ກໍາລັງສ້າງວຽກທີ່ໄດ້ຮັບມອບໝາຍ ແລະ ການລຶບບລ໊ອກ';
$string['creatingblogsinfo'] = 'ກໍາລັງສ້າງຂໍ້ມູນຂອງບລ໊ອກ';
$string['creatingcategoriesandquestions'] = 'ກໍາລັງສ້າງປະເພດ ແລະ ຄໍາຖາມ';
$string['creatingcoursemodules'] = 'ກໍາລັງສ້າງຊຸດວິຊາ';
$string['creatingcourseroles'] = 'ກໍາລັງສ້າງວຽກທີ່ໄດ້ຮັບມອບໝາຍ ແລະ ການລຶບວິຊາ';
$string['creatingevents'] = 'ກຳລັງສ້າງເຫດການ';
$string['creatinggradebook'] = 'ກຳລັງສ້າງປື້ມຄະແນນ';
$string['creatinggroupings'] = 'ກຳລັງສ້າງການຈັດກຸ່ມ';
$string['creatinggroupingsgroups'] = 'ກຳລັງເພີ່ມກຸ່ມເຂົ້າໄປໃນການຈັດກຸ່ມ';
$string['creatinggroups'] = 'ກຳລັງສ້າງກຸ່ມ';
$string['creatinglogentries'] = 'ກຳລັງສ້າງລາຍການບັນທຶກ';
$string['creatingmessagesinfo'] = 'ກຳລັງສ້າງຂໍ້ມູນຂໍ້ຄວາມ';
$string['creatingmodroles'] = 'ກໍາລັງສ້າງວຽກທີ່ໄດ້ຮັບມອບໝາຍ ແລະ ການລຶບຊຸດວິຊາ';
$string['creatingnewcourse'] = 'ກຳລັງການສ້າງລາຍວິຊາໃໝ່';
$string['creatingrolesdefinitions'] = 'ກໍາລັງສ້າງຄໍານິຍາມຂອງຕໍາແໜ່ງ';
$string['creatingscales'] = 'ກໍາລັງສ້າງມາດຕະການ';
$string['creatingsections'] = 'ກຳລັງສ້າງພາກ';
$string['creatingtemporarystructures'] = 'ກຳລັງສ້າງໂຄງສ້າງຊົ່ວຄາວ';
$string['creatinguserroles'] = 'ກໍາລັງສ້າງວຽກທີ່ໄດ້ຮັບມອບໝາຍ ແລະ ການລຶບຜູ້ໃຊ້';
$string['creatingusers'] = 'ການສ້າງຜູ້ໃຊ້';
$string['creatingxmlfile'] = 'ການສ້າງໄຟລ໌ XML';
$string['currency'] = 'ສະກຸນເງິນ';
$string['currentcourse'] = 'ວິຊາປະຈຸບັນ';
$string['currentcourseadding'] = 'ວິຊາປະຈຸບັນ, ກໍາລັງເພີ່ມຂໍ້ມູນໃສ່';
$string['currentcoursedeleting'] = 'ວິຊາປະຈຸບັນ, ລຶບມັນກ່ອນ';
$string['currentlanguage'] = 'ພາສາປະຈຸບັນ';
$string['currentlocaltime'] = 'ເວລາທ້ອງຖີ່ນປະຈຸບັນຂອງທ່ານ';
$string['currentpicture'] = 'ຮູບພາບປະຈຸບັນ';
$string['currentrelease'] = 'ຂໍ້ມູນທີ່ເຜີຍແຜ່ໃນປະຈຸບັນ';
$string['currentversion'] = 'ສະບັບປະຈຸບັນ';
$string['databasechecking'] = 'ກໍາລັງຍົກລະດັບຖານຂໍ້ມູນຂອງ Moodle ຈາກ ສະບັບ {$a->oldversion} ໄປຫາສະບັບ {$a->newversion}';
$string['databaseperformance'] = 'ການປະຕິບັດຖານຂໍ້ມູນ';
$string['databasesetup'] = 'ການຕັ້ງຄ່າຖານຂໍ້ມູນ';
$string['databasesuccess'] = 'ຍົກລະດັບຖານຂໍ້ມູນສໍາເລັດແລ້ວ';
$string['databaseupgradebackups'] = 'Backup version is now {$a}';
$string['databaseupgradeblocks'] = 'ເວີຊັນສຳຮອງຕອນນີ້ແມ່ນ {$a}';
$string['databaseupgradegroups'] = 'ສະບັບຂອງກຸ່ມຕອນນີ້ແມ່ນ {$a}';
$string['databaseupgradelocal'] = 'ສະບັບຂອງການປັບແຕ່ງຂໍ້ມູນພື້ນຖານທ້ອງຖີ່ນຕອນນີ້ແມ່ນ {$a}';
$string['databaseupgrades'] = 'ກຳລັງຍົກລະດັບຖານຂໍ້ມູນ';
$string['dataformats'] = 'ຮູບແບບຂໍ້ມູນ';
$string['date'] = 'ວັນທີ';
$string['datechanged'] = 'ປ່ຽນແປງວັນທີແລ້ວ';
$string['datemostrecentfirst'] = 'ວັນທີ - ລ້າສຸດອັນດັບທຳອິດ';
$string['datemostrecentlast'] = 'ວັນທີ - ລ້າສຸດອັນດັບສຸດທ້າຍ';
$string['day'] = 'ວັນ';
$string['days'] = 'ຈຳນວນວັນ';
$string['decodinginternallinks'] = 'ການຖອດລະຫັດການເຊື່ອມຕໍ່ພາຍໃນ';
$string['default'] = 'ຄ່າເລີ່ມຕົ້ນ';
$string['defaultcategoryname'] = 'ປະເພດ 1';
$string['defaultcompetencescale'] = 'ມາດຕະເກນການວັດລະດັບຄວາມສາມາດເລີ່ມຕົ້ນ';
$string['defaultcompetencescaledesc'] = 'ມາດຕະເກນການຈັດອັນດັບແບບຄູ່ທີ່ບໍ່ໄດ້ໃຫ້ຂໍ້ມູນເພີ່ມຕື່ມນອກເໜືອໄປຈາກວ່າຈະມີຄົນສະແດງຄວາມສາມາດແລ້ວຫຼືຍັງ';
$string['defaultcompetencescalenotproficient'] = 'ຍັງບໍ່ທັນມີຄວາມສາມາດ';
$string['defaultcompetencescaleproficient'] = 'ມີຄວາມສາມາດ';
$string['defaultcoursestudent'] = 'ນັກຮຽນ';
$string['defaultcoursestudentdescription'] = 'ໂດຍທົ່ວໄປແລ້ວນັກຮຽນມີສິດທິພິເສດໜ້ອຍກວ່າພາຍໃນວິຊາ.';
$string['defaultcoursestudents'] = 'ນັກຮຽນ';
$string['defaultcoursesummary'] = 'ຈົ່ງຂຽນປະໂຫຍກທີ່ຫຍໍ້ ແລະ ໜ້າສົນໃຈທີ່ອະທິບາຍວ່າວິຊານີ້ກ່ຽວກັບຫຍັງ';
$string['defaultcourseteacher'] = 'ຄູສອນ';
$string['defaultcourseteacherdescription'] = 'ອາຈານສາມາດເຮັດຫຍັງໄດ້ພາຍໃນວິຊາ, ລວມທັງການປ່ຽນແປງກິດຈະກໍາ ແລະ ການໃຫ້ຄະແນນນັກຮຽນ.';
$string['defaultcourseteachers'] = 'ອາຈານ';
$string['defaulteditor'] = 'ຕົວແກ້ໄຂຄ່າເລີ່ມຕົ້ນ';
$string['defaulthomepageuser'] = 'ໜ້າເລີ່ມຕົ້ນ';
$string['defaulthomepageuser_help'] = 'ໜ້າໃດທີ່ທ່ານຄວນຖືກໂອນໄປຫາຫຼັງຈາກລົງຊື່ເຂົ້າໃຊ້ໃນເວັບໄຊທ໌?';
$string['delete'] = 'ລຶບ';
$string['deleteablock'] = 'ລຶບບລັອກ';
$string['deleteall'] = 'ລຶບທັງໝົດ';
$string['deleteallcannotundo'] = 'ລຶບທັງໝົດ - ບໍ່ສາມາດຍົກເລີກໄດ້';
$string['deleteallcomments'] = 'ລຶບຄຳເຫັນທັງໝົດ';
$string['deleteallratings'] = 'ລຶບການໃຫ້ຄະແນນທັງໝົດ';
$string['deletecategory'] = 'ລຶບປະເພດ: {$a}';
$string['deletecategorycheck'] = 'ທ່ານແນ່ໃຈແທ້ບໍ່ວ່າທ່ານຕ້ອງການລຶບປະເພດນີ້ <b>\'{$a}\'</b>?<br /> ອັນນີ້ຈະຍ້າຍວິຊາທັງໝົດໄປຢູ່ໃນປະເພດຫຼັກ ຖ້າມີວິຊາໜຶ່ງ, ຫຼື ເຂົ້າໄປໃນບ່ອນອື່ນໆ.';
$string['deletecategorycheck2'] = 'ຖ້າທ່ານລຶບປະເພດນີ້ອອກ, ທ່ານຈໍາເປັນຕ້ອງເລືອກວ່າຈະເຮັດແນວໃດກັບຫຼັກສູດ ແລະ ປະເພດຍ່ອຍທີ່ມີ.';
$string['deletecategoryempty'] = 'ປະເພດນີ້ຫວ່າງເປົ່າ.';
$string['deletecheck'] = 'ລຶບ {$a} ບໍ?';
$string['deletecheckfiles'] = 'ທ່ານແນ່ໃຈແທ້ບໍ່ວ່າທ່ານຕ້ອງການລຶບໄຟລ໌ເຫຼົ່ານີ້?';
$string['deletecheckfull'] = 'ທ່ານແນ່ໃຈແທ້ບໍ່ວ່າທ່ານຕ້ອງການລຶບຜູ້ໃຊ້ {$a} ທັງໝົດ, ລວມທັງການລົງທະບຽນ, ກິດຈະກໍາ ແລະ ຂໍ້ມູນຜູ້ໃຊ້ອື່ນໆຂອງເຂົາເຈົ້າ?';
$string['deletechecktype'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບ {$a->type} ນີ້?';
$string['deletechecktypename'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບ  {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'ທ່ານກຳລັງຈະລຶບໄຟລ໌ເຫຼົ່ານີ້';
$string['deletecommentbyon'] = 'ລຶບຄຳເຫັນທີ່ໂພສ໌ໂດຍ {$a->user} ໃນ {$a->time}';
$string['deletecompletely'] = 'ລຶບອອກໝົດ';
$string['deletecourse'] = 'ລຶບວິຊາ';
$string['deletecoursecheck'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບຫຼັກສູດນີ້ ແລະ ຂໍ້ມູນທັງໝົດທີ່ມີຢູ່?';
$string['deleted'] = 'ລຶບແລ້ວ';
$string['deletedactivity'] = 'ລຶບ {$a} ແລ້ວ';
$string['deletedcourse'] = '{$a} ຖືກລຶບອອກໝົດແລ້ວ';
$string['deletednot'] = 'ບໍ່ສາມາດລຶບ {$a} ໄດ້!';
$string['deletepicture'] = 'ລຶບຮູບພາບ';
$string['deletesection'] = 'ລຶບພາກ';
$string['deleteselected'] = 'ລຶບອັນທີ່ເລືອກ';
$string['deleteselectedkey'] = 'ລຶບກະແຈທີ່ເລືອກ';
$string['deletingcourse'] = 'ກຳລັງລຶບ {$a}';
$string['deletingexistingcoursedata'] = 'ການລຶບຊໍ້ມູນວິຊາທີ່ມີຢູ່';
$string['deletingolddata'] = 'ກຳລັງລຶບຂໍ້ມູນເກົ່າ';
$string['department'] = 'ພະແນກ';
$string['deprecatedeventname'] = '{$a} (ບໍ່ໄດ້ໃຊ້ອີກຕໍ່ໄປ)';
$string['desc'] = 'ໃຫຍ່ຫານ້ອຍ';
$string['description'] = 'ລາຍລະອຽດ';
$string['descriptiona'] = 'ລາຍລະອຽດ: {$a}';
$string['deselectall'] = 'ບໍ່ເລືອກທັງໝົດ';
$string['deselectnos'] = 'ບໍ່ເລືອກທັງໝົດ \'ບໍ່\'';
$string['detailedless'] = 'ລາຍລະອຽດໜ້ອຍລົງ';
$string['detailedmore'] = 'ລາຍລະອຽດຫຼາຍຂື້ນ';
$string['details'] = 'ລາຍລະອຽດ';
$string['digitalminor'] = 'ດິຈິຕອລເລັກນ້ອຍ';
$string['digitalminor_desc'] = 'ກະລຸນາຖາມຫາພໍ່ແມ່/ຜູ້ປົກຄອງຂອງທ່ານເພື່ອຕິດຕໍ່ຫາ:';
$string['directory'] = 'ບັນຊີລາຍຊື່';
$string['disable'] = 'ປິດໃຊ້ງານ';
$string['disabledcomments'] = 'ຄຳເຫັນຖືກປິດການນຳໃຊ້';
$string['dismissnotification'] = 'ປິດການແຈ້ງເຕືອນນີ້';
$string['displayingfirst'] = 'ມີພຽງແຕ່ {$a->count} {$a->things} ທໍາອິດຖືກສະແດງ';
$string['displayingrecords'] = 'ສະແດງບັນທຶກ {$a}';
$string['displayingusers'] = 'ກຳລັງສະແດງຜູ້ໃຊ້ {$a->start} ຫາ {$a->end}';
$string['displayonpage'] = 'ສະແດງຢູ່ໃນຫນ້າ';
$string['dndcourse'] = 'ເຈົ້າສາມາດລາກ ແລະ ວາງຫຼັກສູດນີ້ເພື່ອປ່ຽນແປງການຈັດຮຽງຂອງມັນ ຫຼື ຍ້າຍມັນໄປຫາໝວດອື່ນ.';
$string['dndenabled_inbox'] = 'ເຈົ້າສາມາດລາກ ແລະ ວາງໄຟລ໌ໃສ່ບ່ອນນີ້ ເພື່ອເພີ່ມພວກມັນໄດ້.';
$string['dndnotsupported'] = 'ບໍ່ຮອງຮັບການລາກ ແລະ ວາງການອັບໂຫຼດ';
$string['dndnotsupported_help'] = 'ໂປຣແກຣມທ່ອງເວັບຂອງທ່ານບໍ່ຮອງຮັບການລາກແລ້ວວາງການອັບໂຫຼດ. ຄຸນສົມບັດນີ້ມີຢູ່ໃນທຸກຮຸ່ນຂອງ Chrome, Firefox ແລະ Safari, ແລະ Internet Explorer v10 ຂຶ້ນໄປ.';
$string['dndnotsupported_insentence'] = 'ບໍ່ຮອງຮັບການລາກ ແລະ ວາງ';
$string['dnduploadwithoutcontent'] = 'ການອັບໂຫຼດນີ້ບໍ່ມີເນື້ອຫາໃດ';
$string['dndworkingfile'] = 'ລາກ ແລະ ວາງໄຟລ໌ໃສ່ພາກວິຊາຕ່າງໆ ເພື່ອອັບໂຫຼດພວກມັນ';
$string['dndworkingfilelink'] = 'ລາກ ແລະ ວາງໄຟລ໌ ຫຼື ລິ້ງໃສ່ພາກວິຊາຕ່າງໆ ເພື່ອອັບໂຫຼດມັນ';
$string['dndworkingfiletext'] = 'ລາກ ແລະ ວາງໄຟລ໌ ຫຼື ຂໍ້ຄວາມລົງໃສ່ພາກວິຊາຕ່າງໆ ເພື່ອອັບໂຫຼດພວກມັນ';
$string['dndworkingfiletextlink'] = 'ລາກ ແລະ ວາງໄຟລ໌, ຂໍ້ຄວາມ ຫຼື ລິ້ງໃສ່ພາກວິຊາຕ່າງໆ ເພື່ອອັບໂຫຼດມັນ';
$string['dndworkinglink'] = 'ລາກ ແລະ ວາງລິ້ງໃສ່ພາກວິຊາຕ່າງໆ ເພື່ອອັບໂຫຼດພວກມັນ';
$string['dndworkingtext'] = 'ລາກ ແລະ ວາງຂໍ້ຄວາມລົງໃສ່ພາກວິຊາຕ່າງໆ ເພື່ອອັບໂຫຼດມັນ';
$string['dndworkingtextlink'] = 'ລາກ ແລະ ວາງຂໍ້ຄວາມ ຫຼື ລິ້ງໃສ່ພາກວິຊາຕ່າງໆ ເພື່ອອັບໂຫຼດພວກມັນ';
$string['documentation'] = 'ເອກະສານ Moodle';
$string['dontsortcategories'] = 'ຢ່າຈັດປະເພດ';
$string['dontsortcourses'] = 'ຢ່າຈັດວິຊາ';
$string['down'] = 'ລົງ';
$string['download'] = 'ດາວໂຫຼດ';
$string['downloadall'] = 'ດາວໂຫຼດທັງໝົດ';
$string['downloadexcel'] = 'ດາວໂຫຼດໃນຮູບແບບໄຟລ໌ Excel';
$string['downloadfile'] = 'ດາວໂຫຼດໄຟລ໌';
$string['downloadods'] = 'ດາວໂຫຼດໃນຮູບແບບໄຟລ໌ ODS';
$string['downloadtext'] = 'ດາວໂຫຼດໃນຮູບແບບໄຟລ໌ຂໍ້ຄວາມ';
$string['doyouagree'] = 'ທ່ານໄດ້ອ່ານເງື່ອນໄຂເຫຼົ່ານີ້ ແລະ ເຂົ້າໃຈມັນບໍ?';
$string['droptoupload'] = 'ວາງໄຟລ໌ໃສ່ບ່ອນນີ້ເພື່ອອັບໂຫຼດ';
$string['duplicate'] = 'ຊໍ້າກັນ';
$string['duplicatedmodule'] = '{$a} (ຄັດລອກ)';
$string['edhelpaspellpath'] = 'ເພື່ອໃຊ້ການກວດການສະກົດຄໍາສັບພາຍໃນຕົວແກ້ໄຂ, ທ່ານຈະຕ້ອງມີ <strong>aspell 0.50 </strong> ຫຼື ໃໝ່ກວ່າຕິດຕັ້ງຢູ່ໃນເຊີບເວີຂອງທ່ານ, ແລະ ທ່ານຕ້ອງລະບຸເສັ້ນທາງທີ່ຖືກຕ້ອງເພື່ອເຂົ້າຫາ binary aspell. ໃນລະບົບ Unix/Linux, ເສັ້ນທາງນີ້ປົກກະຕິແລ້ວແມ່ນ <strong>/usr/bin/aspell</strong>, ແຕ່ມັນອາດຈະເປັນອັນອື່ນ.';
$string['edhelpbgcolor'] = 'ກຳນົດສີພື້ນຫຼັງຂອງພື້ນທີ່ແກ້ໄຂ. <br />ຄ່າທີ່ຖືກຕ້ອງແມ່ນ, ຕົວຢ່າງ: #FFFFFF ຫຼື ສີຂາວ';
$string['edhelpcleanword'] = 'ການຕັ້ງຄ່ານີ້ເປີດ ຫຼື ປິດການກັ່ນຕອງຮູບແບບສະເພາະຄຳສັບ.';
$string['edhelpenablespelling'] = 'ເປີດ ຫຼື ປິດການກວດການສະກົດຄໍາສັບ. ເມື່ອເປີດນຳໃຊ້, <strong>aspell</strong> ຈະຕ້ອງຖືກຕິດຕັ້ງໃສ່ເຊີບເວີ. ຄ່າທີສອງແມ່ນ <strong>ວັດຈະນານຸກົມເລີ່ມຕົ້ນ </strong>. ຄ່ານີ້ຈະຖືກໃຊ້ຖ້າ aspell ບໍ່ມີວັດຈະນານຸກົມສໍາລັບຜູ້ໃຊ້ພາສາຂອງຕົນເອງ.';
$string['edhelpfontfamily'] = 'ຄຸນສົມບັດຂອງຄອບຄົວຕົວອັກສອນແມ່ນລາຍຊື່ຂອງຄອບຄົວຕົວອັກສອນ ແລະ/ຫຼື ຊື່ຄອບຄົວທົ່ວໄປ. ນາມສະກຸນຈະຕ້ອງແຍກດ້ວຍໝາຍຈຸດ.';
$string['edhelpfontlist'] = 'ກໍານົດຕົວອັກສອນທີ່ໃຊ້ຢູ່ໃນເມນູເລື່ອນລົງຂອງຕົວແກ້ໄຂ.';
$string['edhelpfontsize'] = 'ຂະໜາດຕົວໜັງສືເລີ່ມຕົ້ນ ກຳນົດຂະໜາດຂອງຕົວອັກສອນ. <br/> ຄ່າທີ່ຖືກຕ້ອງແມ່ນຕົວຢ່າງ: ຂະໜາດກາງ, ໃຫຍ່, ນ້ອຍ, ໃຫຍ່, 10pt, 11px.';
$string['edit'] = 'ແກ້ໄຂ';
$string['edita'] = 'ແກ້ໄຂ {$a}';
$string['editcategorysettings'] = 'ແກ້ໄຂການຕັ້ງຄ່າປະເພດ';
$string['editcategorythis'] = 'ແກ້ໄຂປະເພດນີ້';
$string['editcoursesettings'] = 'ແກ້ໄຂການຕັ້ງຄ່າວິຊາ';
$string['editfiles'] = 'ແກ້ໄຂໄຟລ໌';
$string['editgroupprofile'] = 'ແກ້ໄຂໂປຼໄຟລ໌ກຸ່ມ';
$string['editinga'] = 'ກຳລັງແກ້ໄຂ {$a}';
$string['editingteachershort'] = 'ຕົວແກ້ໄຂ';
$string['editlock'] = 'ບໍ່ສາມາດແກ້ໄຂຄ່ານີ້ໄດ້!';
$string['editmode'] = 'ໂໝດແກ້ໄຂ';
$string['editmyprofile'] = 'ແກ້ໄຂໂປຼໄຟລ໌';
$string['editorbgcolor'] = 'ສີພື້ນຫຼັງ';
$string['editorcleanonpaste'] = 'ລ້າງ Word HTML ໃສ່ບ່ອນວາງ';
$string['editorcommonsettings'] = 'ການຕັ້ງຄ່າທົ່ວໄປ';
$string['editordefaultfont'] = 'ຮູບແບບຕົວໜັງສືເລີ່ມຕົ້ນ';
$string['editorenablespelling'] = 'ເປີດນຳໃຊ້ການກວດການສະກົດຄຳສັບ';
$string['editorfontlist'] = 'ລາຍຊື່ຕົວອັກສອນ';
$string['editorfontsize'] = 'ຂະໜາດຕົວໜັງສືເລີ່ມຕົ້ນ';
$string['editorpreferences'] = 'ການຕັ້ງຄ່າຕົວແກ້ໄຂ';
$string['editorresettodefaults'] = 'ການຕັ່ງຄ່າຄືນໃໝ່ເປັນຄ່າເລີ່ມຕົ້ນ';
$string['editorsettings'] = 'ການຕັ້ງຄ່າຕົວແກ້ໄຂ';
$string['editorshortcutkeys'] = 'ຕົວແກ້ໄຂປຸ່ມທາງລັດ';
$string['editsection'] = 'ແກ້ໄຂພາກ';
$string['editsectionname'] = 'ແກ້ໄຂຊື່ພາກ';
$string['editsettings'] = 'ແກ້ໄຂການຕັ້ງຄ່າ';
$string['editsummary'] = 'ແກ້ໄຂສະຫຼຸບ';
$string['editthisactivity'] = 'ແກ້ໄຂກິດຈະກໍານີ້';
$string['editthiscategory'] = 'ແກ້ໄຂປະເພດນີ້';
$string['edittitle'] = 'ແກ້ໄຂຫົວຂໍ້';
$string['edittitleinstructions'] = 'ກົດປຸ່ມ Escape ເພື່ອຍົກເລີກ, ກົດປຸ່ມ Enter ເມື່ອສໍາເລັດ';
$string['edituser'] = 'ແກ້ໄຂບັນຊີຜູ້ໃຊ້';
$string['edulevel'] = 'ເຫດການທັງໝົດ';
$string['edulevel_help'] = '* ການສອນ - ການປະຕິບັດໂດຍຄູສອນ, ຕົວຢ່າງ: ການປັບປຸງແຫຼ່ງຂໍ້ມູນ
* ການມີສ່ວນຮ່ວມ - ການກະທໍາທີ່ດໍາເນີນໂດຍນັກຮຽນ, ເຊັ່ນ: ການປະກາດໃນເວທີສົນທະນາ
* ອື່ນ - ການກະທໍາທີ່ດໍາເນີນໂດຍຜູ້ໃຊ້ທີ່ມີບົດບາດອັນອື່ນນອກຈາກຄູສອນ ຫຼື ນັກຮຽນ';
$string['edulevelother'] = 'ອື່ນໆ';
$string['edulevelparticipating'] = 'ເຂົ້າຮ່ວມ';
$string['edulevelteacher'] = 'ການສອນ';
$string['email'] = 'ທີ່ຢູ່ອີເມວ';
$string['emailactive'] = 'ເປີດໃຊ້ອີເມວແລ້ວ';
$string['emailagain'] = 'ອີເມວ (ອີກຄັ້ງ)';
$string['emailalreadysent'] = 'ອີເມວຕັ້ງລະຫັດຜ່ານໃໝ່ໄດ້ຖືກສົ່ງໄປແລ້ວ. ກະລຸນາກວດເບິ່ງອີເມວຂອງທ່ານ.';
$string['emailcharset'] = 'ຕົວອັກສອນອີເມລ';
$string['emailconfirm'] = 'ຢືນຢັນບັນຊີຂອງທ່ານ';
$string['emailconfirmation'] = 'ສະບາຍດີ,

ມີການຮ້ອງຂໍບັນຊີໃໝ່ຢູ່ທີ່ \'{$a->sitename}\'
ໂດຍການນໍາໃຊ້ທີ່ຢູ່ອີເມລຂອງທ່ານ.

ເພື່ອຢືນຢັນການໃຊ້ບັນຊີຂອງທ່ານ, ກະລຸນາໄປທີ່ທີ່ຢູ່ເວັບໄຊທ໌ນີ້:

{$a->link}

ຢູ່ໃນໂປຣແກມຈົດໝາຍສ່ວນໃຫຍ່, ອັນນີ້ຄວນປະກົດເປັນລິ້ງສີຟ້າ
ທີ່ທ່ານພຽງແຕ່ສາມາດຄລິກໃສ່. ຖ້າມັນບໍ່ໄດ້ຜົນ,
ໃຫ້ຕັດ ແລະ ວາງທີ່ຢູ່ໃສ່ແຖວທີ່ຢູ່
ຢູ່ເທິງສຸດຂອງປ່ອງຢ້ຽມທ່ອງເວັບບຣາວເຊີຂອງທ່ານ.

ຖ້າທ່ານຕ້ອງການຄວາມຊ່ວຍເຫຼືອ, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌,
{$a->admin}';
$string['emailconfirmationresend'] = 'ສົ່ງອີເມວຢືນຢັນຄືນໃໝ່';
$string['emailconfirmationsubject'] = '{$a}: ການຢືນຢັນບັນຊີ';
$string['emailconfirmsent'] = '<p>ອີເມວຄວນຈະຖືກສົ່ງໄປຫາທີ່ຢູ່ຂອງທ່ານທີ່ <b>{$a}</b></p>
   <p>ມັນມີຄຳແນະນຳງ່າຍໃນການເຮັດສຳເລັດການລົງທະບຽນຂອງທ່ານ.</p>
   <p>ຖ້າທ່ານຍັງປະສົບກັບຄວາມຫຍຸ້ງຍາກຢູ່, ຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌.</p>';
$string['emailconfirmsentfailure'] = 'ສົ່ງອີເມວການຢືນຢັນບໍ່ສຳເລັດ';
$string['emailconfirmsentsuccess'] = 'ສົ່ງອີເມວການຢືນຢັນສຳເລັດແລ້ວ';
$string['emaildigest'] = 'ປະເພດອີເມລເລື່ອງຫຍໍ້';
$string['emaildigest_help'] = 'ນີ້ແມ່ນການຕັ້ງຄ່າສະຫຼຸບປະຈໍາວັນທີ່ເວທີສົນທະນາຈະໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ.

* ບໍ່ເລື່ອງຫຍໍ້ - ທ່ານຈະໄດ້ຮັບໜຶ່ງອີເມລຕໍ່ໂພສຂອງເວທີສົນທະນາ;
* ເລື່ອງຫຍໍ້ - ປະກອບຂໍ້ຄວາມໂພສໃຫ້ຄົບຖ້ວນ - ທ່ານຈະໄດ້ຮັບອີເມລເລື່ອງຫຍໍ້ໜຶ່ງສະບັບຕໍ່ມື້ທີ່ປະກອບດ້ວຍເນື້ອໃນຄົບຖ້ວນຂອງແຕ່ລະໂພສຂອງເວທີສົນທະນາ;
* ເລື່ອງຫຍໍ້ - ວິຊາຕ່າງຕ່າງໆເທົ່ານັ້ນ - ທ່ານຈະໄດ້ຮັບອີເມລເລື່ອງຫຍໍ້ສະບັບໜຶ່ງຕໍ່ມື້ທີ່ປະກອບດ້ວຍພຽງແຕ່ຫົວຂໍ້ຂອງແຕ່ລະໂພສໃນເວທີສົນທະນາ.

ທ່ານຍັງສາມາດເລືອກການຕັ້ງຄ່າທີ່ແຕກຕ່າງກັນສຳລັບແຕ່ລະເວທີສົນທະນາ ຖ້າທານຕ້ອງການ.';
$string['emaildigestcomplete'] = 'ສໍາເລັດ (ອີເມລປະຈໍາວັນທີ່ມີຂໍ້ຄວາມໂພສເຕັມ)';
$string['emaildigestoff'] = 'ບໍ່ມີເລື່ອງຫຍໍ້ (ອີເມລ single ດຽວຕໍ່ໂພສຂອງກະດານສົນທະນາ)';
$string['emaildigestsubjects'] = 'ຫົວຂໍ້ (ອີເມລປະຈໍາວັນທີ່ມີຫົວຂໍ້ເທົ່ານັ້ນ)';
$string['emaildisable'] = 'ທີ່ຢູ່ອີເມວນີ້ຖືກປິດການນຳໃຊ້';
$string['emaildisableclick'] = 'ຄລິກບ່ອນນີ້ ເພື່ອປິດອີເມວທັງໝົດບໍ່ໃຫ້ຖືກສົ່ງຫາທີ່ຢູ່ນີ້';
$string['emaildisplay'] = 'ສະແດງອີເມລ';
$string['emaildisplay_help'] = 'ຜູ້ໃຊ້ທີ່ມີສິດທິພິເສດ (ເຊັ່ນ: ຄູອາຈານ ແລະ ຜູ້ຈັດການ) ຈະສາມາດເຫັນທີ່ຢູ່ອີເມວຂອງເຈົ້າສະເໝີ.';
$string['emaildisplaycourse'] = 'ອະນຸຍາດໃຫ້ສະເພາະຜູ້ເຂົ້າຮ່ວມວິຊາອື່ນທີ່ສາມາດເຫັນທີ່ຢູ່ອີເມວຂອງຂ້ອຍ';
$string['emaildisplaycoursemembersonly'] = '(ສາມາດເບິ່ງເຫັນໄດ້ກັບຜູ້ເຂົ້າຮ່ວມຫຼັກສູດອື່ນ)';
$string['emaildisplayeveryone'] = '(ສາມາດເບິ່ງເຫັນໄດ້ກັບທຸກຄົນ)';
$string['emaildisplayhide'] = '(ເຊື່ອງຈາກຜູ້ໃຊ້ທີ່ບໍ່ມີສິດທິພິເສດທັງໝົດ)';
$string['emaildisplayno'] = 'ເຊື່ອງທີ່ຢູ່ອີເມວຂອງຂ້ອຍຈາກຜູ້ໃຊ້ທີ່ບໍ່ມີສິດທິພິເສດ';
$string['emaildisplayyes'] = 'ອະນຸຍາດໃຫ້ທຸກຄົນເຫັນທີ່ຢູ່ອີເມວຂອງຂ້ອຍ';
$string['emailenable'] = 'ທີ່ຢູ່ອີເມວນີ້ຖືກເປີດນຳໃຊ້';
$string['emailenableclick'] = 'ຄລິກບ່ອນນີ້ເພື່ອເປີດນຳໃຊ້ອີເມວທັງໝົດທີ່ຖືກສົ່ງຄືນຫາທີ່ຢູ່ນີ້ຄືນໃໝ່';
$string['emailexists'] = 'ທີ່ຢູ່ອີເມວນີ້ຖືກລົງທະບຽນຢູ່ແລ້ວ.';
$string['emailexistshintlink'] = 'ກູ້ຄືນຊື່ຜູ້ໃຊ້ ຫຼື ລະຫັດຜ່ານທີ່ລືມ';
$string['emailexistssignuphint'] = 'ບາງທີເຈົ້າເຄີຍສ້າງບັນຊີໃນອະດີດບໍ? {$a}';
$string['emailformat'] = 'ຮູບແບບອີເມລ';
$string['emailmustbereal'] = 'ໝາຍເຫດ: ທີ່ຢູ່ອີເມວຂອງທ່ານຕ້ອງເປັນທີ່ຢູ່ແທ້';
$string['emailnotallowed'] = 'ບໍ່ອະນຸຍາດທີ່ຢູ່ອີເມວໃນໂດເມນເຫຼົ່ານີ້ ({$a})';
$string['emailnotfound'] = 'ບໍ່ພົບທີ່ຢູ່ອີເມວໃນຖານຂໍ້ມູນ';
$string['emailonlyallowed'] = 'ອີເມວນີ້ບໍ່ແມ່ນໜຶ່ງໃນນັ້ນທີ່ໄດ້ຮັບອະນຸຍາດ ({$a})';
$string['emailpasswordchangeinfo'] = 'ສະບາຍດີ {$a->firstname},

ບາງຄົນ (ອາດຈະແມ່ນທ່ານ) ໄດ້ຂໍເອົາລະຫັດຜ່ານໃໝ່ສໍາລັບບັນຊີຂອງ
ທ່ານ \'{$a->username}\' ໃນ \'{$a->sitename}\'.

ເພື່ອປ່ຽນລະຫັດຜ່ານຂອງທ່ານ, ກະລຸນາໄປຫາທີ່ຢູ່ເວັບຕໍ່ໄປນີ້:

{$a->link}

ຢູ່ໃນໂປຣແກມຈົດໝາຍສ່ວນໃຫຍ່, ອັນນີ້ຄວນປະກົດເປັນລິ້ງສີຟ້າ
ທີ່ທ່ານພຽງແຕ່ສາມາດຄລິກໃສ່. ຖ້າມັນບໍ່ໄດ້ຜົນ,
ໃຫ້ຕັດ ແລະ ວາງທີ່ຢູ່ໃສ່ແຖວທີ່ຢູ່
ຢູ່ເທິງສຸດຂອງປ່ອງຢ້ຽມທ່ອງເວັບບຣາວເຊີຂອງທ່ານ.

ຖ້າທ່ານຕ້ອງການຄວາມຊ່ວຍເຫຼືອ, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'ສະບາຍດີ {$a->firstname},

ບາງຄົນ (ອາດຈະແມ່ນທ່ານ) ໄດ້ຮ້ອງຂໍລະຫັດຜ່ານໃໝ່ສໍາລັບບັນຊີຂອງທ່ານຢູ່ໃນ \'{$a->sitename}\'.

ໂຊກບໍ່ດີບັນຊີຂອງທ່ານຢູ່ໃນເວັບໄຊທ໌ນີ້ຖືກປິດໃຊ້ງານ, ສະນັ້ນລະຫັດຜ່ານບໍ່ສາມາດຕັ້ງຄືນໃໝ່ໄດ້. ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌ {{$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'ສະບາຍດີ {$a->firstname},

ບາງຄົນ (ອາດຈະແມ່ນທ່ານ) ໄດ້ຮ້ອງຂໍລະຫັດຜ່ານໃໝ່ສໍາລັບບັນຊີຂອງທ່ານຢູ່ໃນ \'{$a->sitename}\'.

ໂຊກບໍ່ດີລະຫັດຜ່ານບໍ່ສາມາດຕັ້ງຄືນໃໝ່ໄດ້. ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌ {{$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: ປ່ຽນຂໍ້ມູນລະຫັດຜ່ານ';
$string['emailpasswordconfirmation'] = 'ສະບາຍດີ {$a->firstname},

ບາງຄົນ (ອາດຈະແມ່ນທ່ານ) ໄດ້ຂໍເອົາລະຫັດຜ່ານໃໝ່ສໍາລັບບັນຊີຂອງ
ທ່ານໃນ \'{$a->sitename}\'.

ເພື່ອຢືນຢັນສິ່ງນີ້ ແລະ ສົ່ງລະຫັດຜ່ານໃໝ່ໃຫ້ກັບທ່ານຜ່ານທາງອີເມວ, ກະລຸນາໄປຫາທີ່ຢູ່ເວັບຕໍ່ໄປນີ້:

{$a->link}

ຢູ່ໃນໂປຣແກມຈົດໝາຍສ່ວນໃຫຍ່, ອັນນີ້ຄວນປະກົດເປັນລິ້ງສີຟ້າ
ທີ່ທ່ານພຽງແຕ່ສາມາດຄລິກໃສ່. ຖ້າມັນບໍ່ໄດ້ຜົນ,
ໃຫ້ຕັດ ແລະ ວາງທີ່ຢູ່ໃສ່ແຖວທີ່ຢູ່
ຢູ່ເທິງສຸດຂອງປ່ອງຢ້ຽມທ່ອງເວັບບຣາວເຊີຂອງທ່ານ.

ຖ້າທ່ານຕ້ອງການຄວາມຊ່ວຍເຫຼືອ, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: ປ່ຽນການຢືນຢັນລະຫັດຜ່ານ';
$string['emailpasswordconfirmmaybesent'] = '<p>ຖ້າທ່ານໄດ້ສະໜອງຊື່ຜູ້ໃຊ້ທີ່ຖືກຕ້ອງ ຫຼື ທີ່ຢູ່ອີເມລ ທີ່ບໍ່ຊໍ້າກັນ ຈາກນັ້ນອີເມລຄວນຈະຖືກສົ່ງຫາທ່ານ.</p>
   <p>ມັນມີຄຳແນະນຳງ່າຍ ເພື່ອຢືນຢັນ ແລະ ເຮັດສຳເລັດການປ່ຽນລະຫັດຜ່ານນີ້.
ຖ້າທ່ານຍັງປະສົບກັບຄວາມຫຍຸ້ງຍາກຢູ່, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>ບັນຊີຜູ້ໃຊ້ທີ່ທ່ານລະບຸນັ້ນບໍ່ມີທີ່ຢູ່ອີເມວທີ່ບັນທຶກໄວ້.</p>
   <p>ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>ລາຍລະອຽດຜູ້ໃຊ້ທີ່ທ່ານໃຫ້ມາບໍ່ໄດ້ລະບຸບັນຊີຜູ້ໃຊ້ທີ່ມີຢູ່ແລ້ວ.</p>
   <p>ກະລຸນາກວດເບິ່ງຂໍ້ມູນທີ່ທ່ານໄດ້ປ້ອນເຂົ້າໄປ, ຈາກນັ້ນລອງໃໝ່ອີກຄັ້ງ.
ຖ້າທ່ານຍັງປະສົບກັບຄວາມຫຍຸ້ງຍາກຢູ່, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌.</p>';
$string['emailpasswordconfirmsent'] = 'ອີເມວຄວນຈະຖືກສົ່ງໄປຫາທີ່ຢູ່ຂອງທ່ານທີ່ <b>{$a}</b>.
<br />ມັນມີຄຳແນະນຳງ່າຍເພື່ອຢືນຢັນ ແລະ ເຮັດສຳເລັດການປ່ຽນລະຫັດຜ່ານນີ້.
ຖ້າເຈົ້າຍັງປະສົບກັບຄວາມຫຍຸ້ງຍາກຢູ່, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌.';
$string['emailpasswordsent'] = 'ຂອບໃຈທີ່ຢືນຢັນການປ່ຽນລະຫັດຜ່ານ.
ອີເມລທີ່ບັນຈຸລະຫັດຜ່ານໃໝ່ຂອງທ່ານໄດ້ຖືກສົ່ງໄປຫາທີ່ຢູ່ຂອງທ່ານແລ້ວທີ່<br /><b>{$a->email}</b>.<br />
ລະຫັດຜ່ານໃໝຖືກສ້າງຂຶ້ນໂດຍອັດຕະໂນມັດ - ທ່ານອາດຈະ <a href="{$a->link}">ປ່ຽນລະຫັດຜ່ານຂອງທ່ານ</a> ເປັນລະຫັດທີ່ຈື່ໄດ້ງ່າຍກວ່າ.';
$string['emailresetconfirmation'] = 'ສະບາຍດີ {$a->firstname},

ມີການຮ້ອງຂໍໃຫ້ປ່ຽນລະຫັດຜ່ານສໍາລັບບັນຊີຂອງທ່ານ \'{$a->username}\' ຢູ່ທີ່ {$a->sitename}.

ເພື່ອຢືນຢັນການຮ້ອງຂໍນີ້, ແລະ ຕັ້ງລະຫັດຜ່ານໃໝ່ສໍາລັບບັນຊີຂອງທ່ານ, ກະລຸນາ
ໄປທີ່ທີ່ຢູ່ເວັບຕໍ່ໄປນີ້:

{$a->link}
(ລິ້ງນີ້ໃຊ້ໄດ້ເປັນເວລາ {$a->resetminutes} ນາທີຈາກເວລາທີ່ຕັ້ງການຕັ້ງຄືນໃໝ່ນີ້ເປັນຄັ້ງທໍາອິດ)

ຖ້າທ່ານບໍ່ໄດ້ຮ້ອງຂໍໃຫ້ປ່ຽນລະຫັດຜ່ານໃໝ່, ບໍ່ຈໍາເປັນຕ້ອງດໍາເນີນການຫຍັງ.

ຖ້າທ່ານຕ້ອງການຄວາມຊ່ວຍເຫຼືອ, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: ຂໍຕັ້ງລະຫັດຜ່ານຄືນໃໝ່';
$string['emailresetconfirmsent'] = 'ອີເມລໄດ້ຖືກສົ່ງໄປຫາທີ່ຢູ່ຂອງທ່ານຢູ່ທີ່ <b>{$a}</b>.
<br />ມັນມີຄຳແນະນຳງ່າຍເພື່ອຢືນຢັນ ແລະ ເຮັດສຳເລັດການປ່ຽນລະຫັດຜ່ານນີ້.
ຖ້າທ່ານຍັງປະສົບກັບຄວາມຫຍຸ້ງຍາກຢູ່, ຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌.';
$string['emailstop'] = 'ປິດການແຈ້ງເຕືອນ';
$string['emailtoprivatefiles'] = 'ນອກນັ້ນ ທ່ານຍັງສາມາດສົ່ງໄຟລ໌-ທາງອີເມລເປັນໄຟລ໌ ແນບໄປຫາພື້ນທີ່ໄຟລ໌ສ່ວນຕົວຂອງທ່ານໂດຍກົງ. ພຽງແຕ່ຄັດລອກໄຟລ໌ຂອງທ່ານໃສ່ໃນອີເມລ ແລະ ສົ່ງໄປທີ່ {$a}';
$string['emailtoprivatefilesdenied'] = 'ຜູ້ເບິ່ງແຍງລະບົບຂອງທ່ານໄດ້ປິດການນຳໃຊ້ຕົວເລືອກໃນການອັບໂຫຼດໄຟລ໌ສ່ວນຕົວຂອງທ່ານເອງ.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'ກິດຈະກຳຕ່າງໆ';
$string['emojicategoryanimalsnature'] = 'ສັດ ແລະ ທຳມະຊາດ';
$string['emojicategoryflags'] = 'ທຸງ';
$string['emojicategoryfooddrink'] = 'ອາຫານ ແລະ ເຄື່ອງດື່ມ';
$string['emojicategoryobjects'] = 'ວັດຖຸ';
$string['emojicategorypeoplebody'] = 'ຄົນ ແລະ ຮ່າງກາຍ';
$string['emojicategoryrecent'] = 'ຫຼ້າສຸດ';
$string['emojicategorysmileysemotion'] = 'ຮອຍຍິ້ມ ແລະ ຄວາມຮູ້ສຶກ';
$string['emojicategorysymbols'] = 'ສັນຍາລັກ';
$string['emojicategorytravelplaces'] = 'ການເດີນທາງແລະສະຖານທີ່';
$string['emptycmids'] = 'ລະຫັດ ID ຂອງຊຸດຫຼັກສູດທີ່ຫວ່າງເປົ່າ';
$string['emptydragdropregion'] = 'ພາກພື້ນຫວ່າງເປົ່າ';
$string['emptysectionids'] = 'ລະຫັດ ID ຂອງພາກສ່ວນທີ່ຫວ່າງເປົ່າ';
$string['enable'] = 'ເປີດໃຊ້ງານ';
$string['encryptedcode'] = 'ລະຫັດລັບທີ່ໃຊ້ເຂົ້າລະຫັດ';
$string['enddate'] = 'ວັນທີຈົບຫຼັກສູດ';
$string['enddate_help'] = 'ວັນທີສິ້ນສຸດລາຍວິຊາ ກໍານົດວ່າ ວິຊາຄວນຈະລວມຢູ່ໃນລາຍຊື່ວິຊາຂອງຜູ້ໃຊ້ຫຼືບໍ່. ວັນທີຈົບຫຼັກສູດອາດຈະຖືກນຳໃຊ້ໂດຍລາຍງານແບບກຳນົດເອງ. ໝາຍວ່າ ຜູ້ໃຊ້ຍັງສາມາດເຂົ້າລາຍວິຊາພາຍຫຼັງວັນທີສິ້ນສຸດ; ເວົ້າອີກຢ່າງໜຶ່ງ, ວັນທີບໍ່ໄດ້ ຈຳກັດການເຂົ້າເຖິງ.';
$string['english'] = 'ອັງກິດ';
$string['enrolmentmethods'] = 'ວິທີການລົງທະບຽນ';
$string['entercourse'] = 'ຄລິກເພື່ອເຂົ້າວິຊານີ້';
$string['enteremail'] = 'ໃສ່ທີ່ຢູ່ອີເມວຂອງທ່ານ';
$string['enteremailaddress'] = 'ໃສ່ທີ່ຢູ່ອີເມລຂອງທ່ານເພື່ອຕັ້ງ
    ລະຫັດຜ່ານຄືນໃໝ່ ແລະ ໃຫ້ລະຫັດຜ່ານໃໝ່ສົ່ງໃຫ້ທ່ານຜ່ານທາງອີເມລ.';
$string['enterusername'] = 'ໃສ່ຊື່ຜູ້ໃຊ້ຂອງທ່ານ';
$string['entries'] = 'ລາຍການ';
$string['error'] = 'ຜິດພາດ';
$string['errorcreatingactivity'] = 'ບໍ່ສາມາດສ້າງຕົວຢ່າງຂອງກິດຈະກໍາ \'{$a}\' ໄດ້';
$string['errorfiletoobig'] = 'ໄຟລ໌ໃຫຍ່ກວ່າທີ່ຈຳກັດໄວ້ {$a} bytes';
$string['errornouploadrepo'] = 'ບໍ່ມີບ່ອນເກັບອັບໂຫຼດທີ່ເປີດໃຊ້ສໍາລັບເວັບໄຊທ໌ນີ້';
$string['errorwhenconfirming'] = 'ທ່ານຍັງບໍ່ໄດ້ຮັບການຢືນຢັນເທື່ອ ເນື່ອງຈາກເກີດຄວາມຜິດພາດຂຶ້ນ. ຖ້າທ່ານຄລິກໃສ່ລິ້ງຢູ່ໃນອີເມລທີ່ຈະມາຮອດທີ່ນີ້, ໃຫ້ແນ່ໃຈວ່າແຖວໃນອີເມລຂອງທ່ານບໍ່ຂາດ ຫຼື ຖືກຕັດ. ທ່ານອາດຈະຕ້ອງໃຊ້ການຕັດ ແລະ ວາງລົງເພື່ອສ້າງການເຊື່ອມຕໍ່ຄືນໃໝ່ໃຫ້ຖືກຕ້ອງ.';
$string['eventcommentcreated'] = 'ສ້າງຄຳເຫັນແລ້ວ';
$string['eventcommentdeleted'] = 'ຄຳເຫັນຖືກລຶບແລ້ວ';
$string['eventcommentsviewed'] = 'ເບິ່ງຄຳເຫັນແລ້ວ';
$string['eventconfiglogcreated'] = 'ສ້າງບັນທຶກການຕັ້ງຄ່າແລ້ວ';
$string['eventcontentviewed'] = 'ເບິ່ງເນື້ອຫາແລ້ວ';
$string['eventcoursebackupcreated'] = 'ສ້າງການສຳຮອງຂໍ້ມູນວິຊາແລ້ວ';
$string['eventcoursecategorycreated'] = 'ສ້າງປະເພດແລ້ວ';
$string['eventcoursecategorydeleted'] = 'ລຶບປະເພດແລ້ວ';
$string['eventcoursecategoryupdated'] = 'ອັບເດດປະເພດແລ້ວ';
$string['eventcoursecategoryviewed'] = 'ເບິ່ງປະເພດ';
$string['eventcoursecontentdeleted'] = 'ລຶບເນື້ອຫາວິຊາແລ້ວ';
$string['eventcoursecreated'] = 'ສ້າງວິຊາແລ້ວ';
$string['eventcoursedeleted'] = 'ລຶບວິຊາແລ້ວ';
$string['eventcourseinformationviewed'] = 'ເບິ່ງສະຫຼຸບວິຊາແລ້ວ';
$string['eventcoursemodulecreated'] = 'ສ້າງຊຸດວິຊາແລ້ວ';
$string['eventcoursemoduledeleted'] = 'ລຶບຊຸດວິຊາແລ້ວ';
$string['eventcoursemoduleinstancelistviewed'] = 'ເບິ່ງລາຍຊື່ຕົວຢ່າງຊຸດວິຊາແລ້ວ';
$string['eventcoursemoduleupdated'] = 'ອັບເດດຊຸດວິຊາແລ້ວ';
$string['eventcoursemoduleviewed'] = 'ເບິ່ງຊຸດວິຊາແລ້ວ';
$string['eventcourseresetended'] = 'ການຕັ້ງຄ່າຄືນລາຍວິຊາສິ້ນສຸດແລ້ວ';
$string['eventcourseresetstarted'] = 'ການຕັ້ງຄ່າຄືນລາຍວິຊາເລີ່ມຕົ້ນແລ້ວ';
$string['eventcourserestored'] = 'ຟື້ນຟູວິຊາແລ້ວ';
$string['eventcoursesectioncreated'] = 'ສ້າງພາກວິຊາແລ້ວ';
$string['eventcoursesectiondeleted'] = 'ລຶບພາກວິຊາແລ້ວ';
$string['eventcoursesectionupdated'] = 'ອັບເດດພາກວິຊາແລ້ວ';
$string['eventcoursessearched'] = 'ຄົ້ນຫາວິຊາ';
$string['eventcourseupdated'] = 'ອັບເດດວິຊາແລ້ວ';
$string['eventcourseuserreportviewed'] = 'ເບິ່ງລາຍງານຜູ້ໃຊ້ວິຊາແລ້ວ';
$string['eventcourseviewed'] = 'ເບິ່ງວິຊາແລ້ວ';
$string['eventdashboardreset'] = 'ຕັ້ງຄ່າແຜງໜ້າປັດຄືນໃໝ່';
$string['eventdashboardsreset'] = 'ຕັ້ງຄ່າແຜງໜ້າປັດຄືນໃໝ່';
$string['eventdashboardviewed'] = 'ເບິ່ງແຜງໜ້າປັດ';
$string['eventdatabasetextfieldcontentreplaced'] = 'ການຄົ້ນຫາຖານຂໍ້ມູນທົ່ວໂລກ ແລະ ປ່ຽນແທນ';
$string['eventemailfailed'] = 'ສົ່ງອີເມວບໍ່ສຳເລັດ';
$string['eventmycoursesviewed'] = 'ເບິ່ງວິຊາຂອງຂ້ອຍແລ້ວ';
$string['eventname'] = 'ຊື່ເຫດການ';
$string['eventrecentactivityviewed'] = 'ເບິ່ງການເຄື່ອນໄຫວຫຼ້າສຸດແລ້ວ';
$string['eventsearchindexed'] = 'ຂໍ້ມູນການຄົ້ນຫາຖືກເປັນດັດສະນີ';
$string['eventsearchresultsviewed'] = 'ເບິ່ງຜົນການຊອກຫາແລ້ວ';
$string['eventunknownlogged'] = 'ເຫດການທີ່ບໍ່ຮູ້ຈັກ';
$string['eventusercreated'] = 'ສ້າງຜູ້ໃຊ້ແລ້ວ';
$string['eventuserdeleted'] = 'ລຶບຜູ້ໃຊ້ແລ້ວ';
$string['eventuserfeedbackgiven'] = 'ຄລິກລິ້ງຄຳຕິຊົມແລ້ວ';
$string['eventuserfeedbackremind'] = 'ຄລິກລິ້ງຄຳຕິຊົມແຈ້ງເຕືອນຂ້ອຍຕາມພາຍຫຼັງ';
$string['eventuserinfocategorycreated'] = 'ສ້າງປະເພດຊ່ອງຂໍ້ມູນໂປຣໄຟລຜູ້ໃຊ້ແລ້ວ';
$string['eventuserinfocategorydeleted'] = 'ລຶບປະເພດຊ່ອງຂໍ້ມູນໂປຣໄຟລຜູ້ໃຊ້ແລ້ວ';
$string['eventuserinfocategoryupdated'] = 'ອັບເດດປະເພດຊ່ອງຂໍ້ມູນໂປຣໄຟລຜູ້ໃຊ້ແລ້ວ';
$string['eventuserinfofieldcreated'] = 'ສ້າງຊ່ອງຂໍ້ມູນໂປຣໄຟລຜູ້ໃຊ້ແລ້ວ';
$string['eventuserinfofielddeleted'] = 'ລຶບຊ່ອງຂໍ້ມູນໂປຣໄຟລຜູ້ໃຊ້ແລ້ວ';
$string['eventuserinfofieldupdated'] = 'ອັບເດດຊ່ອງຂໍ້ມູນໂປຣໄຟລຜູ້ໃຊ້ແລ້ວ';
$string['eventuserlistviewed'] = 'ເບິ່ງລາຍຊື່ຜູ້ໃຊ້ແລ້ວ';
$string['eventuserloggedout'] = 'ຜູ້ໃຊ້ອອກຈາກລະບົບແລ້ວ';
$string['eventuserpasswordpolicyfailed'] = 'ນະໂຍບາຍລະຫັດຜ່ານຂອງຜູ້ໃຊ້ລົ້ມເຫຼວ';
$string['eventuserpasswordupdated'] = 'ອັບເດດລະຫັດຜ່ານຂອງຜູ້ໃຊ້ແລ້ວ';
$string['eventuserprofileviewed'] = 'ເບິ່ງໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້ແລ້ວ';
$string['eventuserupdated'] = 'ອັບເດດຜູ້ໃຊ້ແລ້ວ';
$string['everybody'] = 'ທຸກຄົນ';
$string['executeat'] = 'ປະຕິບັດຢູ່ທີ່';
$string['existing'] = 'ທີ່ມີຢູ່ແລ້ວ';
$string['existingadmins'] = 'ຜູ້ເບິ່ງແຍງລະບົບທີ່ມີຢູ່ແລ້ວ';
$string['existingcourse'] = 'ວິຊາທີ່ມີຢູ່ແລ້ວ';
$string['existingcourseadding'] = 'ວິຊາທີ່ມີຢູ່ແລ້ວ, ເພີ່ມຂໍ້ມູນໃຫ້ມັນ';
$string['existingcoursedeleting'] = 'ວິຊາທີ່ມີຢູ່ແລ້ວ, ລຶບມັນກ່ອນ';
$string['existingcreators'] = 'ຜູ້ສ້າງວິຊາທີ່ມີຢູ່ແລ້ວ';
$string['existingstudents'] = 'ນັກຮຽນທີ່ລົງທະບຽນ';
$string['existingteachers'] = 'ຄູສອນທີ່ມີຢູ່ແລ້ວ';
$string['expand'] = 'ຂະຫຍາຍ';
$string['expandall'] = 'ຂະຫຍາຍທັງໝົດ';
$string['expandcategory'] = 'ຂະຫຍາຍ {$a}';
$string['explanation'] = 'ການອະທິບາຍ';
$string['explanationdigitalminor'] = 'ຂໍ້ມູນນີ້ແມ່ນຕ້ອງການເພື່ອກໍານົດວ່າ ອາຍຸຂອງທ່ານມີອາຍຸຫຼາຍກວ່າການຍິນຍອມເຫັນດີໃນຍຸກດິຈິຕອລຫຼືບໍ່. ນີ້ແມ່ນອາຍຸທີ່ບຸກຄົນສາມາດຍິນຍອມຕໍ່ກັບ ຂໍ້ກຳນົດ ແລະ ເງື່ອນໄຂແລະ ຂໍ້ມູນຂອງເຂົາເຈົ້າຖືກເກັບຮັກສາ ແລະ ປະມວນຜົນຕາມກົດໝາຍ.';
$string['extendperiod'] = 'ຂະຫຍາຍໄລຍະເວລາ';
$string['extendsession'] = 'ຂະຫຍາຍເຊດຊັນ';
$string['failedloginattempts'] = '{$a->attempts} ເຂົ້າສູ່ລະບົບບໍ່ໄດ້ຕັ້ງແຕ່ການເຂົ້າສູ່ລະບົບຄັ້ງສຸດທ້າຍຂອງທ່ານ';
$string['favourites'] = 'ໝາຍດາວແລ້ວ';
$string['feedback'] = 'ຄຳຕິຊົມ';
$string['file'] = 'ໄຟລ໌';
$string['fileexists'] = 'ມີໄຟລ໌ຊື່ວ່າ {$a} ຢູ່ແລ້ວ';
$string['filemissing'] = '{$a} ຂາດຫາຍໄປ';
$string['filereaderror'] = 'ບໍ່ສາມາດອ່ານໄຟລ໌ \'{$ a}\' ໄດ້. ກະລຸນາກວດເບິ່ງວ່າມັນແມ່ນໄຟລ໌ແທ້ ແລະ ບໍ່ແມ່ນໂຟນເດີ.';
$string['files'] = 'ໄຟລ໌';
$string['filesanduploads'] = 'ໄຟລ໌ ແລະ ອັບໂຫຼດ';
$string['filesfolders'] = 'ໄຟລ໌/ໂຟນເດີ';
$string['fileuploadwithcontent'] = 'ການອັບໂຫຼດໄຟລ໌ບໍ່ຄວນລວມເອົາພາລາມິເຕີເນື້ອຫາ';
$string['filloutallfields'] = 'ກະລຸນາຕື່ມຂໍ້ມູນໃສ່ທຸກຊ່ອງໃນແບບຟອມນີ້';
$string['filter'] = 'ຕົວກັ່ນກອງ';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = 'ຕົວກັ່ນກອງ';
$string['findmorecourses'] = 'ຊອກຫາວິຊາເພີ່ມເຕີມ...';
$string['first'] = 'ທໍາອິດ';
$string['firstaccess'] = 'ເຂົ້າເຖິງທຳອິດ';
$string['firstname'] = 'ຊື່';
$string['firstnamephonetic'] = 'ຊື່ - ການອອກສຽງ';
$string['firstpage'] = 'ໜ້າທຳອິດ';
$string['firstsiteaccess'] = 'ການເຂົ້າເຖິງເວັບໄຊທ໌ທີ່ທໍາອິດ';
$string['firsttime'] = 'ເຈົ້າເຂົ້າມາທີ່ນິ້ເປັນເທື່ອທຳອິດຫຼືບໍ່?';
$string['folder'] = 'ໂຟນເດີ';
$string['folderclosed'] = 'ເລືອກໂຟນເດີ';
$string['folderopened'] = 'ເປີດໂຟນເດີແລ້ວ';
$string['followingoptional'] = 'ລາຍການຕໍ່ໄປນີ້ແມ່ນທາງເລືອກ';
$string['followingrequired'] = 'ລາຍການຕໍ່ໄປນີ້ແມ່ນຈຳເປັນ';
$string['for'] = 'ສຳລັບ';
$string['force'] = 'ບັງຄັບ';
$string['forcelanguage'] = 'ພາສາບັງຄັບ';
$string['forceno'] = 'ບໍ່ບັງຄັບ';
$string['forcepasswordchange'] = 'ບັງຄັບໃຫ້ປ່ຽນແປງລະຫັດຜ່ານ';
$string['forcepasswordchange_help'] = 'ຖ້າປ່ອງໝາຍນີ້ຖືກໝາຍຕິກ, ຜູ້ໃຊ້ຈະຖືກເຕືອນໃຫ້ປ່ຽນລະຫັດຜ່ານຂອງເຂົາເຈົ້າຢູ່ໃນການເຂົ້າສູ່ລະບົບຄັ້ງຕໍ່ໄປ';
$string['forcepasswordchangecheckfull'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການບັງຄັບໃຫ້ປ່ຽນລະຫັດຜ່ານເປັນ {$a}?';
$string['forcepasswordchangenot'] = 'ບໍ່ສາມາດບັງຄັບປ່ຽນລະຫັດຜ່ານເປັນ {$a} ໄດ້';
$string['forcepasswordchangenotice'] = 'ກະລຸນາປ່ຽນລະຫັດຜ່ານຂອງທ່ານກ່ອນໄປຍັງຂັ້ນຕອນຕໍ່ໄປ';
$string['forcepasswordresetfailurenotice'] = 'ລະຫັດຜ່ານປັດຈຸບັນຂອງທ່ານບໍ່ຜ່ານນະໂຍບາຍລະຫັດຜ່ານທີ່ຕັ້ງໄວ້ອີກຕໍ່ໄປ. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ Moodle ຂອງທ່ານເພື່ອຂໍຄວາມຊ່ວຍເຫຼືອ.
    {$a}';
$string['forcepasswordresetnotice'] = 'ລະຫັດຜ່ານປັດຈຸບັນຂອງທ່ານບໍ່ຜ່ານນະໂຍບາຍລະຫັດຜ່ານທີ່ຕັ້ງໄວ້ອີກຕໍ່ໄປ. ທ່ານຕ້ອງຕັ້ງລະຫັດຜ່ານຂອງທ່ານຄືນໃໝ່ເພື່ອເຂົ້າສູ່ລະບົບ.
    {$a}';
$string['forcetheme'] = 'ບັງຄັບຮູບແບບສີສັນ';
$string['forgotaccount'] = 'ລືມລະຫັດຜ່ານບໍ?';
$string['forgotten'] = 'ລືມຊື່ຜູ້ໃຊ້ ຫຼື ລະຫັດຜ່ານຂອງທ່ານບໍ?';
$string['forgottenduplicate'] = 'ທີ່ຢູ່ອີເມວຖືກແບ່ງປັນໂດຍຫຼາຍບັນຊີ, ກະລຸນາໃສ່ຊື່ຜູ້ໃຊ້ແທນ';
$string['forgotteninvalidurl'] = 'URL ຕັ້ງລະຫັດຜ່ານຄືນໃໝ່ບໍ່ຖືກຕ້ອງ';
$string['format'] = 'ຮູບແບບ';
$string['format_help'] = 'ຮູບແບບວິຊາກຳນົດແຜນຜັງຂອງໜ້າວິຊາ.

* ຮູບແບບກິດຈະກໍາດ່ຽວ - ສໍາລັບການສະແດງກິດຈະກໍາ ຫຼື ຊັບພະຍາກອນອັນດຽວ (ເຊັ່ນວ່າຊຸດ Quiz ຫຼື SCORM) ຢູ່ໃນ ໜ້າວິຊາ
* ຮູບແບບຂອງສັງຄົມ - ເວທີສົນທະນາຖືກສະແດງຢູ່ໃນໜ້າ ວິຊາ
* ຮູບແບບຫົວຂໍ້ - ໜ້າວິຊາໄດ້ຖືກຈັດເປັນພາກສ່ວນຫົວຂໍ້
* ຮູບແບບປະຈໍາອາທິດ - ໜ້າວິຊາໄດ້ຖືກຈັດເປັນພາກສ່ວນປະຈໍາອາທິດ, ໂດຍອາທິດທໍາອິດເລີ່ມຕັ້ງແຕ່ມື້ເລີ່ມວິຊາ';
$string['formathtml'] = 'ຮູບແບບ HTML';
$string['formatmarkdown'] = 'ຮູບແບບ Markdown';
$string['formatplain'] = 'ຮູບແບບຂໍ້ຄວາມທຳມະດາ';
$string['formattext'] = 'ຮູບແບບອັດໂນມັດ Moodle';
$string['forumpreferences'] = 'ການຕັ້ງຄ່າກອງປະຊຸມ';
$string['framesetinfo'] = 'ເອກະສານ frameset ນີ້ປະກອບມີ:';
$string['from'] = 'ຈາກ';
$string['frontpagecategorycombo'] = 'ລາຍຊື່ຄອມໂບ';
$string['frontpagecategorynames'] = 'ລາຍຊື່ປະເພດ';
$string['frontpagecourselist'] = 'ລາຍຊື່ວິຊາ';
$string['frontpagecoursesearch'] = 'ກ່ອງຄົ້ນຫາວິຊາ';
$string['frontpagedescription'] = 'ສະຫຼຸບໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpagedescriptionhelp'] = 'ບົດສະຫຼຸບນີ້ສາມາດສະແດງຢູ່ໃນໜ້າທໍາອິດໂດຍນໍາໃຊ້ບລັອກບົດສະຫຼຸບລາຍວິຊາ/ເວັບໄຊທ໌.';
$string['frontpageenrolledcourselist'] = 'ວິຊາລົງທະບຽນ';
$string['frontpageformat'] = 'ຮູບແບບໜ້າຫຼັກເວັບໄຊທ໌';
$string['frontpageformatloggedin'] = 'ຮູບແບບໜ້າຫຼັກເວັບໄຊທ໌ເມື່ອເຂົ້າສູ່ລະບົບແລ້ວ';
$string['frontpagenews'] = 'ການປະກາດ';
$string['frontpagesettings'] = 'ການຕັ້ງຄ່າໜ້າຫຼັກເວັບໄຊທ໌';
$string['fulllistofcourses'] = 'ວິຊາທັງໝົດ';
$string['fullname'] = 'ຊື່ເຕັມ';
$string['fullnamecourse'] = 'ຊື່ເຕັມວິຊາ';
$string['fullnamecourse_help'] = 'ຊື່ເຕັມຂອງວິຊາແມ່ນສະແດງຢູ່ເທິງສຸດຂອງແຕ່ລະໜ້າໃນວິຊາ ແລະ ໃນລາຍການວິຊາ.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'ຊື່ເຕັມຜູ້ໃຊ້';
$string['fullprofile'] = 'ໂປຼໄຟລ໌ເຕັມ';
$string['fullsitename'] = 'ຊື່ເວັບໄຊທ໌ເຕັມ';
$string['functiondisabled'] = 'ການທໍາງານນັ້ນຖືກປິດໃຊ້ງານຢູ່ໃນປະຈຸບັນ';
$string['general'] = 'ທົ່ວໄປ';
$string['geolocation'] = 'ເສັ້ນຂະໜານ - ເສັ້ນແວງ';
$string['gettheselogs'] = 'ຮັບເອົາບັນທຶກເຫຼົ່ານີ້';
$string['go'] = 'ໄປ';
$string['gpl'] = 'Copyright (C) 1999 ເປັນຕົ້ນມາ Martin Dougiamas (https://moodle.com)

ໂປຼແກມນີ້ແມ່ນຊອບແວຟຣີ; ທ່ານສາມາດແຈກຢາຍມັນຄືນໃໝ່ ແລະ/ຫຼື ດັດແປງມັນພາຍໃຕ້ເງື່ອນໄຂຂອງ ໃບອະນຸຍາດສາທາລະນະທົ່ວໄປ GNU (GNU General Public License) ຕາມການຕີພິມໂດຍ Free Software Foundation; ທັງ 2 ຮຸ່ນຂອງໃບອະນຸຍາດ, ຫຼື (ຕາມຕົວເລືອກຂອງເຈົ້າ) ທຸກລຸ້ນຕໍ່ມາ.

ໂປຼແກມນີ້ໄດ້ຖືກແຈກຢາຍດ້ວຍຄວາມຫວັງວ່າມັນຈະເປັນປະໂຫຍດ, ແຕ່ບໍ່ມີການຮັບປະກັນໃດໆ; ໂດຍບໍ່ມີການຮັບປະກັນຄວາມສາມາດໃນການຂາຍ ຫຼື ຄວາມເໝາະສົມສໍາລັບຈຸດປະສົງສະເພາະ.

ເບິ່ງໜ້າຂໍ້ມູນໃບອະນຸຍາດ Moodle ສຳລັບລາຍລະອຽດທັງ:ໝົດ: https://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 ເປັນຕົ້ນມາ Martin Dougiamas (https://moodle.com)

ໂປຼແກມນີ້ແມ່ນຊອບແວຟຣີ; ທ່ານສາມາດແຈກຢາຍມັນຄືນໃໝ່ ແລະ/ຫຼື ດັດແປງມັນພາຍໃຕ້ເງື່ອນໄຂຂອງ ໃບອະນຸຍາດສາທາລະນະທົ່ວໄປ GNU (GNU General Public License) ຕາມການຕີພິມໂດຍ Free Software Foundation; ທັງ 3 ຮຸ່ນຂອງໃບອະນຸຍາດ, ຫຼື (ຕາມຕົວເລືອກຂອງທ່ານ) ທຸກລຸ້ນຕໍ່ມາ.

ໂປຼແກມນີ້ໄດ້ຖືກແຈກຢາຍດ້ວຍຄວາມຫວັງວ່າມັນຈະເປັນປະໂຫຍດ, ແຕ່ບໍ່ມີການຮັບປະກັນໃດໆ; ໂດຍບໍ່ມີການຮັບປະກັນຄວາມສາມາດໃນການຂາຍ ຫຼື ຄວາມເໝາະສົມສໍາລັບຈຸດປະສົງສະເພາະ.

ເບິ່ງໜ້າຂໍ້ມູນໃບອະນຸຍາດ Moodle ສຳລັບລາຍລະອຽດທັງ:ໝົດ: https://docs.moodle.org/dev/License';
$string['gpllicense'] = 'ໃບອະນຸຍາດ GPL';
$string['grade'] = 'ຄະແນນ';
$string['gradenoun'] = 'ຄະແນນ';
$string['grades'] = 'ຄະແນນ';
$string['gradeverb'] = 'ຄະແນນ';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Gravatar</a> ໄດ້ຖືກເປີດໃຊ້ສຳລັບເວັບໄຊທ໌ນີ້. ຖ້າເຈົ້າບໍ່ອັບໂຫຼດຮູບໂປຣໄຟລ໌ Moodle ຈະພະຍາຍາມໂຫຼດຮູບໂປຣໄຟລ໌ໃຫ້ເຈົ້າຈາກ Gravatar.';
$string['group'] = 'ກຸ່ມ';
$string['groupadd'] = 'ເພີ່ມກຸ່ມໃໝ່';
$string['groupaddusers'] = 'ເພີ່ມອັນທີ່ເລືອກໃສ່ກຸ່ມ';
$string['groupfor'] = 'ສຳລັບກຸ່ມ';
$string['groupinfo'] = 'ຂໍ້ມູນສຳລັບກຸ່ມທີ່ເລືອກ';
$string['groupinfoedit'] = 'ແກ້ໄຂການຕັ້ງຄ່າກຸ່ມ';
$string['groupinfomembers'] = 'ຂໍ້ມູນກ່ຽວກັບສະມາຊິກທີ່ເລືອກ';
$string['groupinfopeople'] = 'ຂໍ້ມູນກ່ຽວກັບຄົນທີ່ເລືອກ';
$string['groupmembers'] = 'ສະມາຊິກກຸ່ມ';
$string['groupmemberssee'] = 'ເບິ່ງສະມາຊິກກຸ່ມ';
$string['groupmembersselected'] = 'ສະມາຊິກຂອງກຸ່ມທີ່ເລືອກ';
$string['groupmode'] = 'ໂໝດກຸ່ມ';
$string['groupmodeforce'] = 'ບັງຄັບໃຊ້ໂໝດກຸ່ມ';
$string['groupmy'] = 'ກຸ່ມຂອງຂ້ອຍ';
$string['groupnonmembers'] = 'ຄົນທີ່ບໍ່ໄດ້ຢູ່ໃນກຸ່ມ';
$string['groupnotamember'] = 'ຂໍອະໄພ, ເຈົ້າບໍ່ໄດ້ເປັນສະມາຊິກຂອງກຸ່ມນັ້ນ';
$string['grouprandomassign'] = 'ສຸ່ມແຕ່ງຕັ້ງທັງໝົດໃຫ້ກຸ່ມ';
$string['groupremove'] = 'ລຶບກຸ່ມທີ່ເລືອກ';
$string['groupremovemembers'] = 'ລຶບສະມາຊິກທີ່ເລືອກ';
$string['groups'] = 'ກຸ່ມ';
$string['groupsnone'] = 'ບໍ່ມີກຸ່ມ';
$string['groupsseparate'] = 'ກຸ່ມແຍກ';
$string['groupsvisible'] = 'ກຸ່ມທີ່ເບິ່ງເຫັນໄດ້';
$string['guest'] = 'ແຂກ';
$string['guestdescription'] = 'ແຂກມີສິດທິພິເສດໜ້ອຍທີ່ສຸດ ແລະ ໂດຍປົກກະຕິແລ້ວບໍ່ສາມາດປ້ອນຂໍ້ຄວາມໄດ້ທຸກບ່ອນ.';
$string['guestskey'] = 'ອະນຸຍາດໃຫ້ແຂກຜູ້ທີ່ມີກະແຈ';
$string['guestsno'] = 'ບໍ່ອະນຸຍາດໃຫ້ແຂກເຂົ້າມາ';
$string['guestsnotallowed'] = 'ຂໍອະໄພ, \'{$a}\' ບໍ່ອະນຸຍາດໃຫ້ແຂກເຂົ້າມາ.';
$string['guestsyes'] = 'ອະນຸຍາດໃຫ້ແຂກເຂົ້າເຖິງໄດ້ໂດຍບໍ່ມີກະແຈ';
$string['guestuser'] = 'ຜູ້ໃຊ້ແຂກ';
$string['guestuserinfo'] = 'ຜູ້ໃຊ້ນີ້ເປັນຜູ້ໃຊ້ພິເສດທີ່ອະນຸຍາດໃຫ້ເຂົ້າເຖິງບາງວິຊາເທົ່ານັ້ນ.';
$string['help'] = 'ຊ່ວຍເຫຼືອ';
$string['helpprefix2'] = 'ຊ່ວຍເຫຼືອກັບ {$a}';
$string['helpwiththis'] = 'ຊ່ວຍເຫຼືອດ້ວຍສິ່ງນີ້';
$string['hiddenassign'] = 'ການມອບໝາຍທີ່ຖືກເຊື່ອງໄວ້';
$string['hiddenfromstudents'] = 'ເຊື່ອງຈາກນັກຮຽນ';
$string['hiddenoncoursepage'] = 'ມີໃຫ້ແຕ່ບໍ່ສະແດງຢູ່ໃນໜ້າຫຼັກສູດ';
$string['hiddensections'] = 'ພາກສ່ວນທີ່ຖືກເຊື່ອງໄວ້';
$string['hiddensections_help'] = 'ບໍ່ວ່າພາກສ່ວນທີ່ເຊື່ອງໄວ້ຈະຖືກສະແດງຕໍ່ກັບນັກຮຽນວ່າບໍ່ມີໃຫ້ (ບາງທີສໍາລັບວິຊາໃນຮູບແບບປະຈໍາອາທິດເພື່ອລະບຸວັນພັກ) ຫຼື ຖືກເຊື່ອງໄວ້ທັງໝົດ.';
$string['hiddensectionscollapsed'] = 'ພາກສ່ວນທີ່ເຊື່ອງໄວ້ແມ່ນສະແດງໃຫ້ເຫັນວ່າບໍ່ມີໃຫ້';
$string['hiddensectionsinvisible'] = 'ພາກສ່ວນທີ່ເຊື່ອງໄວ້ແມ່ນບໍ່ສາມາດເບິ່ງເຫັນໄດ້ທັງໝົດ';
$string['hiddenwithbrackets'] = '(ເຊື່ອງໄວ້)';
$string['hide'] = 'ເຊື່ອງ';
$string['hideadvancedsettings'] = 'ເຊື່ອງການຕັ້ງຄ່າຂັ້ນສູງ';
$string['hidechartdata'] = 'ເຊື່ອງຂໍ້ມູນແຜນວາດ';
$string['hidefromstudents'] = 'ເຊື່ອງຈາກນັກຮຽນ';
$string['hideoncoursepage'] = 'ເຮັດໃຫ້ມີຢູ່ແຕ່ບໍ່ສະແດງຢູ່ໃນໜ້າຫຼັກສູດ';
$string['hidepicture'] = 'ເຊື່ອງຮູບພາບ';
$string['hidepopoverwindow'] = 'ເຊື່ອງປ່ອງຢ້ຽມທີ່ລອຍຂື້ນ';
$string['hidesection'] = 'ເຊື່ອງພາກ {$a}';
$string['hidesettings'] = 'ເຊື່ອງການຕັ້ງຄ່າ';
$string['hideshowblocks'] = 'ເຊື່ອງ ຫຼື ສະແດງບລັອກ';
$string['highlight'] = 'ຈຸດເດັ່ນ';
$string['highlighted'] = 'ເນັ້ນໃສ່';
$string['highlightoff'] = 'ຍ້າຍຈຸດເດັ່ນອອກ';
$string['hits'] = 'ຍອດນິຍົມ';
$string['hitsoncourse'] = 'ຍອດນິຍົມໃນ {$a->coursename} ໂດຍ {$a->username}';
$string['hitsoncoursetoday'] = 'ຍອດນິຍົມຂອງມື້ນີ້.o {$a->coursename} ໂດຍ {$a->username}';
$string['home'] = 'ໜ້າຫຼັກ';
$string['homeheader'] = 'ເມນູໜ້າຫຼັກ';
$string['hour'] = 'ຊົ່ວໂມງ';
$string['hours'] = 'ຊົ່ວໂມງ';
$string['howtomakethemes'] = 'ວິທີສ້າງຮູບແບບສີສັນໃ່ໝ່';
$string['htmleditor'] = 'ໃຊ້ຕົວແກ້ໄຂ HTML';
$string['htmleditoravailable'] = 'ຕົວແກ້ໄຂ HTML ແມ່ນມີໃຫ້';
$string['htmleditordisabled'] = 'ເຈົ້າໄດ້ປິດການນຳໃຊ້ຕົວແກ້ໄຂ HTML ໃນໂປຣໄຟລ໌ຜູ້ໃຊ້ຂອງທ່ານ';
$string['htmleditordisabledadmin'] = 'ຜູ້ເບິ່ງແຍງລະບົບໄດ້ປິດການນຳໃຊ້ຕົວແກ້ໄຂ HTML ຢູ່ໃນເວັບໄຊທ໌ນີ້';
$string['htmleditordisabledbrowser'] = 'ຕົວແກ້ໄຂ HTML ບໍ່ສາມາດໃຊ້ໄດ້ເພາະວ່າໂປຣແກຣມທ່ອງເວັບຂອງທ່ານບໍ່ເຂົ້າກັນໄດ້';
$string['htmlfilesonly'] = 'ໄຟລ໌ HTML ເທົ່ານັ້ນ';
$string['htmlformat'] = 'ຮູບແບບ HTML ທີ່ສວຍງາມ';
$string['icon'] = 'ໄອຄອນ';
$string['icqnumber'] = 'ໝາຍເລກ ICQ';
$string['idnumber'] = 'ໝາຍເລກ ID';
$string['idnumbercourse'] = 'ໝາຍເລກ ID ວິຊາ';
$string['idnumbercourse_help'] = 'ໝາຍເລກ ID ຂອງວິຊາແມ່ນໃຊ້ສະເພາະເມື່ອຈັບຄູ່ວິຊາກັບລະບົບພາຍນອກເທົ່ານັ້ນ ແລະ ບໍ່ສະແດງຢູ່ທຸກບ່ອນໃນເວັບໄຊທ໌. ຖ້າວິຊາມີຊື່ລະຫັດເປັນທາງການ, ມັນອາດຈະຖືກປ້ອນເຂົ້າໄປ, ຖ້າບໍ່ດັ່ງນັ້ນຊ່ອງຂໍ້ມູນອາດຈະຖືກປະຫວ່າງໄວ້.';
$string['idnumbercoursecategory'] = 'ໝາຍເລກ ID ປະເພດ';
$string['idnumbercoursecategory_help'] = 'ໝາຍເລກ ID ຂອງປະເພດວິຊາແມ່ນໃຊ້ສະເພາະເມື່ອຈັບຄູ່ປະເພດກັບລະບົບພາຍນອກເທົ່ານັ້ນ ແລະ ບໍ່ສະແດງຢູ່ທຸກບ່ອນໃນເວັບໄຊທ໌. ຖ້າປະເພດມີຊື່ລະຫັດເປັນທາງການ, ມັນອາດຈະຖືກປ້ອນເຂົ້າໄປ, ຖ້າບໍ່ດັ່ງນັ້ນຊ່ອງຂໍ້ມູນອາດຈະຖືກປະຫວ່າງໄວ້.';
$string['idnumbergroup'] = 'ໝາຍເລກ ID ກຸ່ມ';
$string['idnumbergroup_help'] = 'ໝາຍເລກ ID ຂອງກຸ່ມແມ່ນໃຊ້ສະເພາະເມື່ອຈັບຄູ່ກຸ່ມກັບລະບົບພາຍນອກເທົ່ານັ້ນ ແລະ ບໍ່ສະແດງຢູ່ທຸກບ່ອນໃນເວັບໄຊທ໌. ຖ້າກຸ່ມມີຊື່ລະຫັດເປັນທາງການ, ມັນອາດຈະຖືກປ້ອນເຂົ້າໄປ, ຖ້າບໍ່ດັ່ງນັ້ນຊ່ອງຂໍ້ມູນອາດຈະຖືກປະຫວ່າງໄວ້.';
$string['idnumbergrouping'] = 'ໝາຍເລກ ID ການຈັດກຸ່ມ';
$string['idnumbergrouping_help'] = 'ໝາຍເລກ ID ຂອງການຈັດກຸ່ມແມ່ນໃຊ້ສະເພາະເມື່ອຈັບຄູ່ການຈັດກຸ່ມກັບລະບົບພາຍນອກເທົ່ານັ້ນ ແລະ ບໍ່ສະແດງຢູ່ທຸກບ່ອນໃນເວັບໄຊທ໌. ຖ້າການຈັດກຸ່ມມີຊື່ລະຫັດເປັນທາງການ, ມັນອາດຈະຖືກປ້ອນເຂົ້າໄປ, ຖ້າບໍ່ດັ່ງນັ້ນຊ່ອງຂໍ້ມູນອາດຈະຖືກປະຫວ່າງໄວ້.';
$string['idnumbermod'] = 'ໝາຍເລກ ID';
$string['idnumbermod_help'] = 'ການຕັ້ງໝາຍເລກ ID ໃຫ້ວິທີການລະບຸກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນເພື່ອຈຸດປະສົງເຊັ່ນ: ການຄິດໄລ່ຄະແນນ ຫຼືການລາຍງານແບບກໍານົດເອງ. ຖ້າບໍ່ດັ່ງນັ້ນຊ່ອງຂໍ້ມູນອາດຖືກປະຫວ່າງໄວ້.

ສໍາລັບກິດຈະກໍາທີ່ສາມາດໃຫ້ຄະແນນໄດ້, ໝາຍເລກ  ID ຍັງສາມາດຖືກກໍານົດໄວ້ຢູ່ໃນປຶ້ມບັນທຶກຄະແນນ, ເຖິງແມ່ນວ່າມັນສາມາດແກ້ໄຂໄດ້ຢູ່ໃນໜ້າການຕັ້ງຄ່າກິດຈະກໍາເທົ່ານັ້ນ.';
$string['idnumbertaken'] = 'ໝາຍເລກ ID ນີ້ຖືກເອົາໄປແລ້ວ';
$string['imagealt'] = 'ລາຍລະອຽດຮູບພາບ';
$string['import'] = 'ນຳເຂົ້າ';
$string['importdata'] = 'ນຳເຂົ້າຂໍ້ມູນວິຊາ';
$string['importdataexported'] = 'ສົ່ງອອກຂໍ້ມູນຈາກ \'ຈາກ\' ວິຊາສຳເລັດຜົນ. <br /> ສືບຕໍ່ ນຳເຂົ້າສູ່ \'ສູ່\' ວິຊາຂອງທ່ານ.';
$string['importdatafinished'] = 'ການນຳເຂົ້າສຳເລັດແລ້ວ! ສືບຕໍ່ວິຊາຂອງທ່ານ';
$string['importdatafrom'] = 'ຊອກຫາວິຊາເພື່ອນຳເຂົ້າຂໍ້ມູນຈາກ:';
$string['inactive'] = 'ບໍ່ເຄື່ອນໄຫວ';
$string['include'] = 'ລວມທັງ';
$string['includeallusers'] = 'ລວມເອົາຜູ້ໃຊ້ທັງໝົດ';
$string['includecoursefiles'] = 'ລວມເອົາໄຟລ໌ວິຊາ';
$string['includecourseusers'] = 'ລວມເອົາວິຊາຜູ້ໃຊ້';
$string['included'] = 'ລວມ';
$string['includelogentries'] = 'ລວມເອົາລາຍການບັນທຶກ';
$string['includemodules'] = 'ລວມເອົາຊຸດ';
$string['includemoduleuserdata'] = 'ລວມເອົາຊຸດຂໍ້ມູນຜູ້ໃຊ້';
$string['includeneededusers'] = 'ລວມເອົາຜູ້ໃຊ້ທີ່ຕ້ອງການ';
$string['includenoneusers'] = 'ບໍ່ລວມເອົາຜູ້ໃຊ້';
$string['includeroleassignments'] = 'ລວມເອົາການແຕ່ງຕັ້ງໜ້າທີ່';
$string['includesitefiles'] = 'ລວມເອົາໄຟລ໌ເວັບໄຊທ໌ທີ່ໃຊ້ຢູ່ໃນວິຊານີ້';
$string['includeuserfiles'] = 'ລວມເອົາໄຟລ໌ຜູ້ໃຊ້';
$string['increasesections'] = 'ລວມເອົາໝາຍເລກຂອງພາກ';
$string['indicator:accessesafterend'] = 'ເຂົ້າຮຽນວິຊາຫຼັງຈາກວັນທີສິ້ນສຸດ';
$string['indicator:accessesafterend_help'] = 'ຕົວຊີ້ວັດນີ້ສະທ້ອນໃຫ້ເຫັນວ່ານັກຮຽນເຂົ້າຫາວິຊາຫຼັງຈາກວັນທີຈົບຫຼັກສູດ.';
$string['indicator:accessesbeforestart'] = 'ເຂົ້າຮຽນວິຊາກ່ອນວັນທີເລີ່ມຮຽນ';
$string['indicator:accessesbeforestart_help'] = 'ຕົວຊີ້ວັດນີ້ສະທ້ອນໃຫ້ເຫັນວ່ານັກຮຽນເຂົ້າຫາວິຊາກ່ອນວັນເລີ່ມຫຼັກສູດ.';
$string['indicator:activitiesdue'] = 'ກິດຈະກຳຮອດກຳນົດ';
$string['indicator:activitiesdue_help'] = 'ຜູ້ໃຊ້ມີກິດຈະກໍາຮອດກໍານົດ.';
$string['indicator:anycourseaccess'] = 'ການເຂົ້າເຖິງວິຊາໃດໜຶ່ງ';
$string['indicator:anycourseaccess_help'] = 'ຕົວຊີ້ວັດນີ້ສະທ້ອນໃຫ້ເຫັນເຖິງການເຂົ້າເຖິງວິຊາໃດໜຶ່ງທີ່ຜູ້ໃຊ້ໄດ້ລົງທະບຽນເຂົ້າຮຽນ.';
$string['indicator:anywrite'] = 'ການກະທໍາໂດຍການຂຽນໃດໜຶ່ງ';
$string['indicator:anywrite_help'] = 'ຕົວຊີ້ວັດນີ້ສະແດງເຖິງການຂຽນ (ສົ່ງ) ທີ່ນັກຮຽນດໍາເນີນ.';
$string['indicator:anywriteincourse'] = 'ທຸກການກະທຳການຂຽນໃນວິຊາ';
$string['indicator:anywriteincourse_help'] = 'ຕົວຊີ້ວັດນີ້ສະແດງເຖິງການຂຽນ (ສົ່ງ) ຂອງນັກຮຽນໃນກິດຈະກໍາວິຊາໃດໜຶ່ງ.';
$string['indicator:completeduserprofile'] = 'ໂປຣໄຟລ໌ຜູ້ໃຊ້ສຳເລັດແລ້ວ';
$string['indicator:completeduserprofile_help'] = 'ຕົວຊີ້ວັດນີ້ສະແດງໃຫ້ເຫັນວ່ານັກຮຽນໄດ້ສຳເລັດໂປຣໄຟລຜູ້ໃຊ້ຂອງເຂົາເຈົ້າແລ້ວ.';
$string['indicator:completeduserprofiledef'] = 'ໂປຣໄຟລ໌ຜູ້ໃຊ້ສຳເລັດແລ້ວ';
$string['indicator:completeduserprofiledef_help'] = 'ນະໂຍບາຍຂອງເວັບໄຊທ໌ໄດ້ຕົກລົງເຫັນດີ ແລະ ຜູ້ໃຊ້ໄດ້ຕື່ມຂໍ້ມູນໃສ່ໃນຊ່ອງດັ່ງຕໍ່ໄປນີ້: ສະຖາບັນ, ພະແນກ, ທີ່ຢູ່, ເມືອງ, ປະເທດ, URL.';
$string['indicator:completionenabled'] = 'ເປີດການຕິດຕາມຄວາມສຳເລັດແລ້ວ';
$string['indicator:completionenabled_help'] = 'ຕົວຊີ້ວັດນີ້ສະແດງໃຫ້ເຫັນວ່າໄດ້ມີການເປີດໃຊ້ການຕິດຕາມຄວາມສໍາເລັດສໍາລັບວິຊານີ້ແລ້ວ.';
$string['indicator:nostudent'] = 'ການລົງທະບຽນນັກສຶກສາ';
$string['indicator:nostudent_help'] = 'ຕົວຊີ້ວັດນີ້ສະທ້ອນໃຫ້ເຫັນເຖິງຄວາມພ້ອມຂອງນັກຮຽນໃນຫຼັກສູດ.';
$string['indicator:noteacher'] = 'ຄວາມພ້ອມຂອງຄູ';
$string['indicator:noteacher_help'] = 'ຕົວຊີ້ວັດນີ້ສະທ້ອນເຖິງຄວາມພ້ອມຂອງຄູສອນຢູ່ໃນວິຊາ.';
$string['indicator:potentialcognitive'] = 'ຄວາມເລິກດ້ານການຮັບຮູ້ທີ່ເປັນໄປໄດ້ຂອງວິຊາ';
$string['indicator:potentialcognitive_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມເລິກດ້ານການຮັບຮູ້ທີ່ເປັນໄປໄດ້ທີ່ນັກຮຽນເຂົ້າຮ່ວມກິດຈະກໍາວິຊາ.';
$string['indicator:potentialcognitivedef'] = 'ຄວາມເລິກດ້ານການຮັບຮູ້ທີ່ເປັນໄປໄດ້ຂອງຫຼັກສູດ';
$string['indicator:potentialcognitivedef_help'] = 'ລະດັບທີ່ວິຊາສະເໜີໃຫ້ມີສ່ວນຮ່ວມທາງດ້ານມັນສະໝອງ "ເລິກເຊິ່ງ", ເຊັ່ນ: ການສົ່ງວຽກສໍາລັບຄໍາຄິດເຫັນ, ໂອກາດທີ່ຈະທົບທວນຄືນວຽກງານໂດຍຄົນອື່ນ, ແລະ ໂອກາດໃນການກວດແກ້ ແລະ ສົ່ງວຽກຄືນໃໝ່.';
$string['indicator:potentialsocial'] = 'ວິຊາທີ່ມີທ່າແຮງທາງສັງຄົມກວ້າງ';
$string['indicator:potentialsocial_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ທ່າແຮງທາງສັງຄົມກວ້າງທີ່ໃຫ້ນັກຮຽນເຂົ້າຮ່ວມກິດຈະກໍາວິຊາ.';
$string['indicator:potentialsocialdef'] = 'ວິຊາທີ່ມີທ່າແຮງທາງສັງຄົມກວ້າງ';
$string['indicator:potentialsocialdef_help'] = 'ລະດັບທີ່ຫຼັກສູດສະເໜີໃຫ້ມີສ່ວນຮ່ວມທາງສັງຄົມ "ກວ້າງຂວາງ", ພົວພັນກັບຜູ້ເຂົ້າຮ່ວມຄົນອື່ນ ແລະ ກັບຊຸມຊົນການປະຕິບັດນອກຊັ້ນຮຽນ.';
$string['indicator:readactions'] = 'ອ່ານຈຳນວນການປະຕິບັດ';
$string['indicator:readactions_help'] = 'ຕົວຊີ້ວັດນີ້ສະແດງເຖິງຈໍານວນການອ່ານ (ເບິ່ງ) ການກະທໍາທີ່ນັກຮຽນດໍາເນີນ.';
$string['indicator:userforumstracking'] = 'ຜູ້ໃຊ້ກຳລັງຕິດຕາມເວທີສົນທະນາ';
$string['indicator:userforumstracking_help'] = 'ຕົວຊີ້ວັດນີ້ສະແດງໃຫ້ເຫັນວ່ານັກຮຽນໄດ້ເປີດການຕິດຕາມຫຼືບໍ່ໃນເວທີສົນທະນາ.';
$string['info'] = 'ຂໍ້ມູນ';
$string['inprogress'] = 'ກໍາລັງດໍາເນີນການ';
$string['institution'] = 'ສະຖາບັນ';
$string['instudentview'] = 'ມຸມມອງນັກຮຽນ';
$string['interests'] = 'ຄວາມສົນໃຈ';
$string['interestslist'] = 'ລາຍການຄວາມສົນໃຈ';
$string['interestslist_help'] = 'ໃສ່ຄວາມສົນໃຈຂອງທ່ານ, ເທື່ອລະອັນ, ເຊິ່ງຈາກນັ້ນຈະຖືກສະແດງຢູ່ໃນໜ້າໂປຣໄຟລ໌ຂອງທ່ານເປັນປ້າຍ.';
$string['invalidemail'] = 'ທີ່ຢູ່ອີເມລບໍ່ຖືກຕ້ອງ';
$string['invalidlogin'] = 'ການເຂົ້າສູ່ລະບົບບໍ່ຖືກຕ້ອງ, ກະລຸນາລອງໃ່ໝ່';
$string['invalidusername'] = 'ຊື່ຜູ້ໃຊ້ສາມາດປະກອບມີຕົວອັກສອນຕົວພິມນ້ອຍເທົ່ານັ້ນ (ຕົວອັກສອນ ແລະ ຕົວເລກ), ຂີດກ້ອງ (_), ຂີດຕໍ່ (-), ເຄື່ອງໝາຍຈໍ້າເມັດ (.) ຫຼື ຢູ່ທີ່ສັນຍາລັກ (@).';
$string['invalidusernameupload'] = 'ຊື່ຜູ້ໃຊ້ບໍ່ຖືກຕ້ອງ';
$string['ip_address'] = 'ທີ່ຢູ່ IP';
$string['jump'] = 'ໄປ';
$string['jumpto'] = 'ໄປຍັງ...';
$string['keep'] = 'ເກັບ';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'ພາສາຈາກຊ້າຍໄປຂວາ';
$string['langrtl'] = 'ພາສາຈາກຂວາໄປຊ້າຍ';
$string['language'] = 'ພາສາທີ່ໃຊ້';
$string['languagegood'] = 'ພາສາໃຊ້ Version ລ່າສຸດແລ້ວ';
$string['languageselector'] = 'ຕົວເລືອກພາສາ';
$string['last'] = 'ສຸດທ້າຍ';
$string['lastaccess'] = 'ເຂົ້າມາເທື່ອສຸດທ້າຍເມື່ອ';
$string['lastcourseaccess'] = 'ເຂົ້າມາຫາລາຍວິຊາເທື່ອສຸດທ້າຍເມື່ອ';
$string['lastedited'] = 'ແກ້ໄຂເທື່ອສຸດທ້າຍ';
$string['lastip'] = 'ທີ່ຢູ່ IP ສຸດທ້າຍ';
$string['lastlogin'] = 'ເຂົ້າສູ່ລະບົບເທື່ອສຸດທ້າຍເມື່ອ';
$string['lastmodified'] = 'ແກ້ໄຂເທື່ອສຸດທ້າຍເມື່ອ';
$string['lastname'] = 'ນາມສະກຸນ';
$string['lastnamephonetic'] = 'ນາມສະກຸນ - ການອອກສຽງ';
$string['lastpage'] = 'ໜ້າສຸດທ້າຍ';
$string['lastsiteaccess'] = 'ເຂົ້າມາຫາເວັບໄຊທ໌ເທື່ອສຸດທ້າຍເມື່ອ';
$string['lastyear'] = 'ປີກາຍ';
$string['latestlanguagepack'] = 'ກວດສອບຫາໄຟລ໌ພາສາລ່າສຸດໃນ moodle.org';
$string['layouttable'] = 'ໂຄງຮ່າງຕາຕະລາງ';
$string['leavetokeep'] = 'ປະໄວ້ຫາກຕ້ອງການໃຊ້ລະຫັດຜ່ານເດີມ';
$string['legacylogginginuse'] = 'ປະຈຸບັນເວັບໄຊທ໌ນີ້ໄດ້ຂຽນໄປຫາບ່ອນຈັດເກັບບັນທຶກເດີມ. ການຂຽນໄປຫາບ່ອນຈັດເກັບບັນທຶກນີ້ຢຸດໃຊ້ແລ້ວ. ກະລຸນາຂຽນໄປຫາບ່ອນຈັດເກັບບັນທຶກທີ່ຮອງຮັບເຊັ່ນ: "ມາດຕະຖານ" ຫຼື "ພາຍນອກ".';
$string['legacythemeinuse'] = 'ເວັບໄຊທ໌ນີ້ກໍາລັງຖືກສະແດງໃຫ້ທ່ານຢູ່ໃນຮູບແບບທີ່ເຂົ້າກັນໄດ້ເພາະວ່າບຣາວເຊີຂອງທ່ານເກົ່າເກີນໄປ.';
$string['license'] = 'ໃບອານຸຍາດ';
$string['licenses'] = 'ໃບອານຸຍາດ';
$string['liketologin'] = 'ຕ້ອງການເຂົ້າສູ່ລະບົບຕອນນີ້ດ້ວຍບັນຊີຜູ້ໃຊ້ເຕັມຫຼືບໍ່?';
$string['list'] = 'ລາຍຊື່';
$string['listfiles'] = 'ລາຍຊື່ຂອງໄຟລ໌ໃນ {$a}';
$string['listofallpeople'] = 'ລາຍຊື່ຄົນທັງໝົດ';
$string['listofcourses'] = 'ລາຍຊື່ວິຊາ';
$string['loading'] = 'ກຳລັງໂຫຼດ';
$string['loadinghelp'] = 'ກຳລັງໂຫຼດ...';
$string['local'] = 'ທ້ອງຖີ່ນ';
$string['localplugins'] = 'ປຣັກອິນທ້ອງຖີ່ນ';
$string['localpluginsmanage'] = 'ຈັດການປຣັກອິນທ້ອງຖີ່ນ';
$string['location'] = 'ທີ່ຕັ້ງ';
$string['locktimeout'] = 'ໝົດເວລາປະຕິບັດງານໃນຂະນະທີ່ລໍຖ້າການລັອກ.';
$string['log_excel_date_format'] = 'ປປປປ ດດດດ ວ ຊມ:ນທ';
$string['loggedinas'] = 'ເຈົ້າເຂົ້າສູ່ລະບົບໃນຊື່ {$a}';
$string['loggedinasguest'] = 'ທ່ານເຂົ້າສູ່ລະບົບໃນຖານະແຂກ';
$string['loggedinnot'] = 'ເຈົ້າຍັງບໍ່ໄດ້ເຂົ້າສູ່ລະບົບ.';
$string['login'] = 'ລົງຊື່ເຂົ້າໃຊ້';
$string['login_failure_logs'] = 'ບັນທຶກການເຂົ້າສູ່ລະບົບພິດພາດ';
$string['loginactivity'] = 'ກິດຈະກຳເຂົ້າສູ່ລະບົບ';
$string['loginagain'] = 'ເຂົ້າສູ່ລະບົບອີກຄັ້ງ';
$string['loginalready'] = 'ທ່ານເຂົ້າສູ່ລະບົບຮຽບຮ້ອຍແລ້ວ';
$string['loginas'] = 'ເຂົ້າສູ່ລະບົບໃນຊື່';
$string['loginaspasswordexplain'] = '<p>ທ່ານຕ້ອງໃສ່ລະຫັດຜ່ານພິເສດ "loginas password" ເພື່ອໃຊ້ງານໃນສ່ວນນີ້.<br />ຖ້າຫາກທ່ານບໍ່ຮູ້ໃຫ້ສອບຖາມຜູ້ເບິ່ງແຍງລະບົບ.</p>';
$string['loginguest'] = 'ເຂົ້າສູ່ລະບົບໃນຖານະແຂກ';
$string['loginsite'] = 'ເຂົ້າສູ່ລະບົບຫາເວັບໄຊທ໌';
$string['loginsteps'] = 'ສໍາລັບການເຂົ້າເຖິງຢ່າງເຕັມທີ່ຫາເວັບໄຊທ໌ນີ້, ທໍາອິດທ່ານຈໍາເປັນຕ້ອງສ້າງບັນຊີ.';
$string['loginstepsnone'] = '<p>ສະບາຍດີ!</p>
<p>ສໍາລັບການເຂົ້າເຖິງຢ່າງເຕັມທີ່ຫາວິຊາ ທ່ານຈຳເປັນຕ້ອງໄດ້ສ້າງບັນດ້ວຍຕົວທ່ານເອງ.</p>
<p>ສິ່ງທີ່ທ່ານຕ້ອງເຮັດຄືສ້າງຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານ ແລະ ໃຊ້ມັນຢູ່ໃນແບບຟອມຢູ່ໃນໜ້ານີ້!</p>
<p>ຖ້າຄົນອື່ນໄດ້ເລືອກຊື່ຜູ້ໃຊ້ຂອງທ່ານແລ້ວ, ທ່ານຈະຕ້ອງໄດ້ລອງອີກຄັ້ງໂດຍໃຊ້ຊື່ຜູ້ໃຊ້ທີ່ແຕກຕ່າງກັນ.</p>';
$string['loginto'] = 'ເຂົ້າສູ່ລະບົບໄປຫາ  {$a}';
$string['logoof'] = 'ໂລໂກ້ຂອງ {$a}';
$string['logout'] = 'ອອກຈາກລະບົບ';
$string['logoutconfirm'] = 'ທ່ານຕ້ອງການອອກຈາກລະບົບແທ້ບໍ?';
$string['logs'] = 'ບັນທຶກ';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">ເພີ່ມເຕີມ</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">ເພີ່ມເຕີມ</a> ]';
$string['lookback'] = 'ເບິ່ງຄືນ';
$string['mailadmins'] = 'ແຈ້ງຜູ້ເບິ່ງແຍງລະບົບ';
$string['mailstudents'] = 'ແຈ້ງນັກຮຽນ';
$string['mailteachers'] = 'ແຈ້ງຄູສອນ';
$string['maincoursepage'] = 'ໜ້າວິຊາຫຼັກ';
$string['makeafolder'] = 'ສ້າງໂຟນເດີ';
$string['makeavailable'] = 'ເຮັດໃຫ້ມີ';
$string['makeeditable'] = 'ຖ້າທ່ານເຮັດໃຫ້ \'{$a}\' ສາມາດແກ້ໄຂໄດ້ໂດຍຂັ້ນຕອນຂອງເຊີບເວີເວັບ (ຕົວຢ່າງ: apache) ຈາກນັ້ນທ່ານສາມາດແກ້ໄຂໄຟລ໌ນີ້ໂດຍກົງຈາກໜ້ານີ້';
$string['makethismyhome'] = 'ເຮັດໃຫ້ເປັນໜ້າຫຼັກຂອງຂ້ອຍ';
$string['makeunavailable'] = 'ເຮັດໃຫ້ບໍ່ມີໃຫ້';
$string['manageblocks'] = 'ບລັອກ';
$string['managecategories'] = 'ຈັດການປະເພດລາຍວິຊາ';
$string['managecategorythis'] = 'ຈັດການປະເພດນີ້';
$string['managecombined'] = 'ຈັດການປະເພດລາຍວິຊາ ແລະ ວິຊາ';
$string['managecontentbanktypes'] = 'ຈັດການປະເພດເນື້ອຫາ';
$string['managecourses'] = 'ຈັດການລາຍວິຊາ';
$string['managedatabase'] = 'ຈັດການຖານຂໍ້ມູນ';
$string['managedataformats'] = 'ຈັດການຮູບແບບຂໍ້ມູນ';
$string['manageeditorfiles'] = 'ຈັດການໄຟລ໌ທີ່ໃຊ້ໂດຍຕົວແກ້ໄຂ';
$string['managefilters'] = 'ຈັດການຕົວກັ່ນກອງ';
$string['managemodules'] = 'ຊຸດ';
$string['manageroles'] = 'ພາລະບົດບາດ ແລະ ການອະນຸຍາດ';
$string['markallread'] = 'ໝາຍທັງໝົດວ່າໄດ້ອ່ານແລ້ວ';
$string['markedthistopic'] = 'ຫົວຂໍ້ນີ້ໄດ້ເນັ້ນໃຫ້ເປັນຫົວຂໍ້ປັດຈຸບັນ';
$string['markthistopic'] = 'ເນັ້ນຫົວຂໍ້ນີ້ໃຫ້ເປັນຫົວຂໍ້ປັດຈຸບັນ';
$string['matchingsearchandrole'] = 'ການຈັບຄູ່ \'{$a->search}\' ແລະ {$a->role}';
$string['maxareabytesreached'] = 'ໄຟລ% (ຫຼື ຂະໜາດລວມຂອງຫຼາຍໄຟລ໌) ແມ່ນໃຫຍ່ກວ່າພື້ນທີ່ທີ່ຍັງເຫຼືອຢູ່ໃນພື້ນທີ່ນີ້.';
$string['maxfilesize'] = 'ຂະໜາດສູງສຸດສຳລັບໄຟລ໌ໃໝ່: {$a}';
$string['maxfilesreached'] = 'ທ່ານໄດ້ຮັບອະນຸຍາດໃຫ້ແນບໄຟລ໌ສູງສຸດຂອງໄຟລ໌ {$a} ໃສ່ກັບລາຍການນີ້';
$string['maximumchars'] = 'ຕົວອັກສອນ {$a}  ສູງສຸດ';
$string['maximumgrade'] = 'ຄະແນນສູງສຸດ';
$string['maximumgradex'] = 'ຄະແນນສູງສຸດ: {$a}';
$string['maximumshort'] = 'ສູງສຸດ';
$string['maximumupload'] = 'ຂະໜາດອັບໂຫຼດສູງສຸດ';
$string['maximumupload_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດຂະໜາດໃຫຍ່ສຸດຂອງໄຟລ໌ທີ່ສາມາດອັບໂຫຼດໃສ່ຫຼັກສູດ, ຈໍາກັດໂດຍການຕັ້ງຄ່າທົ່ວເວັບທີ່ກໍານົດໂດຍຜູ້ຄວບຄຸມລະບົບ. ຊຸດກິດຈະກໍາຍັງລວມເຖິງການຕັ້ງຂະໜາດ ອັບໂຫຼດສູງສຸດສໍາລັບການຈໍາກັດຂະໜາດໄຟລ໌ຕື່ມອີກ.';
$string['maxnumberweeks'] = 'ຈຳນວນສູງສຸດຂອງພາກ';
$string['maxnumberweeks_desc'] = 'ຄ່າສູງສຸດຢູ່ໃນຈຳນວນພາກຂອງເມນູເລື່ອນລົງ (ໃຊ້ໄດ້ກັບບາງຮູບແບບວິຊາສະເພາະເທົ່ານັ້ນ).';
$string['maxnumcoursesincombo'] = 'ເລືອກເບິ່ງ <a href="{$a->link}">{$a->numberofcourses} courses</a>.';
$string['maxsectionslimit'] = 'ບໍ່ສາມາດສ້າງພາກໃໝ່ໄດ້ເພາະວ່າມັນເກີນຈໍານວນພາກສູງສຸດທີ່ອະນຸຍາດສໍາລັບວິຊານີ້ ({$a}).';
$string['maxsize'] = 'ຂະໜາດສູງສຸດ: {$a}';
$string['maxsizeandareasize'] = 'ຂະໜາດສູງສຸດສຳລັບໄຟລ໌ໃໝ່: {$a->size}, ຂີດຈໍາກັດໂດຍລວມ: {$a->areasize}';
$string['maxsizeandattachments'] = 'ຂະໜາດໄຟລ໌ສູງສຸດ: {$a->size}, ຈຳນວນສູງສຸດຂອງໄຟລ໌: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'ຂະໜາດໄຟລ໌ສູງສຸດ: {$a->size}, ຈຳນວນສູງສຸດຂອງໄຟລ໌: {$a->attachments}, ຂະໜາດລວມສູງສຸດ: {$a->areasize}';
$string['memberincourse'] = 'ຄົນໃນລາຍຊິວາ';
$string['menu'] = 'ເມນູ';
$string['message'] = 'ຂໍ້ຄວາມ';
$string['messagebody'] = 'ຕົວຂໍ້ຄວາມ';
$string['messagedselectedusers'] = 'ຜູ້ໃຊ້ທີ່ເລືອກໄດ້ຖືກສົ່ງຂໍ້ຄວາມ ແລະ ລາຍຊື່ຜູ້ຮັບໄດ້ຖືກຕັ້ງຄ່າຄືນໃໝ່.';
$string['messagedselectedusersfailed'] = 'ມີບາງຢ່າງພິດພາດໃນຂະນະກຳລັງສົ່ງຂໍ້ຄວາມໃຫ້ຜູ້ໃຊ້ທີ່ເລືອກ.  ບາງຄົນອາດຈະໄດ້ຮັບອີເມລ.';
$string['messageprovider:asyncbackupnotification'] = 'ການແຈ້ງເຕືອນການກູ້ຄືນ/ການສຳຮອງບໍ່ກົງກັນ';
$string['messageprovider:availableupdate'] = 'ການແຈ້ງເຕືອນອັບເດດທີ່ມີໃຫ້';
$string['messageprovider:backup'] = 'ການແຈ້ງເຕືອນການສຳຮອງຂໍ້ມູນ';
$string['messageprovider:badgecreatornotice'] = 'ການແຈ້ງເຕືອນປ້າຍກຳກັບຜູ້ສ້າງ';
$string['messageprovider:badgerecipientnotice'] = 'ການແຈ້ງເຕືອນປ້າຍກຳກັບຜູ້ຮັບ';
$string['messageprovider:competencyplancomment'] = 'ຄຳຄິດເຫັນໄດ້ໂພສໃສ່ແຜນການຮຽນ';
$string['messageprovider:competencyusercompcomment'] = 'ຄໍາເຫັນໄດ້ໂພສໃສ່ຄວາມສາມາດ';
$string['messageprovider:coursecompleted'] = 'ສຳເລັດວິຊາແລ້ວ';
$string['messageprovider:coursecontentupdated'] = 'ປ່ຽນແປງເນື້ອຫາລາຍວິຊາ';
$string['messageprovider:courserequestapproved'] = 'ການແຈ້ງເຕືອນການອານຸມັດການຮ້ອງຂໍການສ້າງລາຍວິຊາ';
$string['messageprovider:courserequested'] = 'ການແຈ້ງເຕືອນການຮ້ອງຂໍການສ້າງລາຍວິຊາ';
$string['messageprovider:courserequestrejected'] = 'ການແຈ້ງເຕືອນການປະຕິເສດການຮ້ອງຂໍການສ້າງລາຍວິຊາ';
$string['messageprovider:errors'] = 'ຂໍ້ພິດພາດສຳຄັນກັບເວັບໄຊທ໌';
$string['messageprovider:errors_help'] = 'ຂໍ້ພິດພາດເຫຼົ່ານີ້ທີ່ຜູ້ຄວບຄຸມລະບົບຄວນຮູ້.';
$string['messageprovider:gradenotifications'] = 'ການແຈ້ງເຕືອນຄະແນນ';
$string['messageprovider:infected'] = 'ການແຈ້ງເຕືອນຄວາມລົ້ມເຫຼວຂອງໂປຣແກມປ້ອງກັນໄວຣັດສ.';
$string['messageprovider:insights'] = 'ຄວາມເຂົ້າໃຈທີ່ສ້າງຂຶ້ນໂດຍຮູບແບບການຄາດເດົາ';
$string['messageprovider:instantmessage'] = 'ຂໍ້ຄວາມສ່ວນຕົວລະຫວ່າງຜູ້ໃຊ້';
$string['messageprovider:instantmessage_help'] = 'ພາກນີ້ກຳນົດຄ່າສິ່ງທີ່ເກີດຂຶ້ນກັບຂໍ້ຄວາມທີ່ຖືກສົ່ງຫາທ່ານໂດຍກົງຈາກຜູ້ໃຊ້ອື່ນຢູ່ໃນເວັບໄຊທ໌ນີ້.';
$string['messageprovider:messagecontactrequests'] = 'ການແຈ້ງເຕືອນການຮ້ອງຂໍການຕິດຕໍ່ທາງຂໍ້ຄວາມ';
$string['messageprovider:newlogin'] = 'ແຈ້ງການການເຂົ້າລະບົບໃໝ່';
$string['messageprovider:notices'] = 'ແຈ້ງການກ່ຽວກັບບັນຫາເລັກນ້ອຍ';
$string['messageprovider:notices_help'] = 'ນີ້ແມ່ນແຈ້ງການທີ່ຜູ້ຄວບຄຸມລະບົບອາດຈະສົນໃຈເບິ່ງ.';
$string['messageprovider:reportbuilderschedule'] = 'ກຳນົດເວລາຕົວສ້າງລາຍງານແບບກຳນົດເອງ';
$string['messageselect'] = 'ເລືອກຜູ້ໃຊ້ນີ້ເປັນຜູ້ຮັບຂໍ້ຄວາມ';
$string['messageselectadd'] = 'ສົ່ງຂໍ້ຄວາມ';
$string['middlename'] = 'ຊື່ກາງ';
$string['migratinggrades'] = 'ການຍົກຍ້າຍຄະແນນ';
$string['min'] = 'ນາທີ';
$string['mins'] = 'ນາທີ';
$string['minute'] = 'ນາທີ';
$string['minutes'] = 'ນາທີ';
$string['miscellaneous'] = 'ອື່ນໆ';
$string['missingcategory'] = 'ທ່ານຈຳເປັນຕ້ອງເລືອກປະເພດ';
$string['missingdescription'] = 'ບໍ່ມີຄຳອະທິບາຍ';
$string['missingemail'] = 'ບໍ່ມີທີ່ຢູ່ອີເມລ';
$string['missingfirstname'] = 'ບໍ່ມີຊື່ທີ່ລະບຸ';
$string['missingfromdisk'] = 'ຫາຍໄປຈາກດິສກ';
$string['missingfullname'] = 'ບໍ່ມີຊື່ເຕັມ';
$string['missinglastname'] = 'ບໍ່ມີນາມສະກຸນ';
$string['missingname'] = 'ບໍ່ມີຊື່';
$string['missingnewpassword'] = 'ບໍ່ມີລະຫັດຜ່ານໃໝ່';
$string['missingpassword'] = 'ບໍ່ມີລະຫັດຜ່ານ';
$string['missingrecaptchachallengefield'] = 'ການທົດສອບ reCAPTCHA ບໍ່ສຳເລັດ, ກະລຸນາລອງໃໝ່.';
$string['missingreqreason'] = 'ບໍ່ມີເຫດຜົນ';
$string['missingshortname'] = 'ບໍ່ມີຊື່ຫຍໍ້';
$string['missingshortsitename'] = 'ບໍ່ມີຊື່ຫຍໍ້ເວັບໄຊທ໌';
$string['missingsitedescription'] = 'ບໍ່ມີຄຳອະທິບາຍເວັບໄຊທ໌';
$string['missingsitename'] = 'ບໍ່ມີຊື່ເວັບໄຊທ໌';
$string['missingstrings'] = 'ກວດສອບຄຳສັບ ຫຼື ຄຳເວົ້າທີ່ຍັງບໍ່ໄດ້ແປ';
$string['missingstudent'] = 'ຕ້ອງເລືອກບາງສິ່ງບາງຢ່າງ';
$string['missingsummary'] = 'ບໍ່ມີການສະຫຼຸບ';
$string['missingteacher'] = 'ຕ້ອງເລືອກບາງສິ່ງບາງຢ່າງ';
$string['missingurl'] = 'ບໍ່ມີ URL';
$string['missingusername'] = 'ບໍ່ມີຊື່ຜູ້ໃຊ້';
$string['moddoesnotsupporttype'] = 'ຊຸດ {$a->modname} ບໍ່ຮອງຮັບການອັບໂຫຼດປະເພດ {$a->type}';
$string['modhide'] = 'ເຊື່ອງ';
$string['modified'] = 'ແກ້ໄຂແລ້ວ';
$string['modshow'] = 'ສະແດງ';
$string['moduleintro'] = 'ລາຍລະອຽດ';
$string['modulesetup'] = 'ການຕັ້ງຄ່າຊຸດຕາຕະລາງ';
$string['modulesuccess'] = '{$a} ຕາຕະລາງໄດ້ຖືກຕັ້ງຄ່າຢ່າງຖືກຕ້ອງ';
$string['modulesused'] = 'ຊຸດທີ່ນຳໃຊ້';
$string['modvisible'] = 'ຄວາມພ້ອມໃຊ້ງານ';
$string['modvisible_help'] = 'ຖ້າມີການຕັ້ງໃຫ້ເປັນ \'ສະແດງຢູ່ໃນໜ້າວິຊາ\', ກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນແມ່ນມີໃຫ້ກັບນັກຮຽນ (ອີງຕາມຂໍ້ຈໍາກັດການເຂົ້າເຖິງໃດໜຶ່ງທີ່ອາດຈະຖືກຕັ້ງໄວ້).

ຖ້າມີໃຫ້ຖືກຕັ້ງເປັນ \'ເຊື່ອງຈາກນັກຮຽນ\', ກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນແມ່ນມີໃຫ້ກັບຜູ້ໃຊ້ທີ່ມີການອະນຸຍາດເພື່ອເບິ່ງກິດຈະກໍາທີ່ເຊື່ອງໄວ້ເທົ່ານັ້ນ (ໂດຍຄ່າເລີ່ມຕົ້ນ, ຜູ້ໃຊ້ທີ່ມີບົດບາດເປັນຄູສອນ ຫຼື ຄູທີ່ບໍ່ໄດ້ແກ້ໄຂ).';
$string['modvisiblehiddensection'] = 'ຄວາມພ້ອມໃຊ້ງານ';
$string['modvisiblehiddensection_help'] = 'ຖ້າມີໃຫ້ຖືກຕັ້ງເປັນ \'ເຊື່ອງຈາກນັກຮຽນ\', ກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນແມ່ນມີໃຫ້ກັບຜູ້ໃຊ້ທີ່ມີການອະນຸຍາດເພື່ອເບິ່ງກິດຈະກໍາທີ່ເຊື່ອງໄວ້ເທົ່ານັ້ນ (ໂດຍຄ່າເລີ່ມຕົ້ນ, ຜູ້ໃຊ້ທີ່ມີບົດບາດເປັນຄູສອນ ຫຼື ຄູທີ່ບໍ່ໄດ້ແກ້ໄຂ).

ຖ້າວິຊາມີກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນຫຼາຍຢ່າງ, ໜ້າວິຊາອາດຈະເຮັດໃຫ້ງ່າຍຂຶ້ນໂດຍການກໍານົດໃຫ້ມີ \'ເຮັດໃຫ້ມີຢູ່ແຕ່ບໍ່ສະແດງຢູ່ໃນໜ້າວິຊາ\'. ໃນກໍລະນີນີ້, ຕ້ອງມີລິ້ງຫາກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນຈາກບ່ອນອື່ນ, ເຊັ່ນ: ຈາກໜ້າແຫຼ່ງຂໍ້ມູນ. ກິດຈະກໍາຍັງຈະຖືກລະບຸໄວ້ຢູ່ໃນປຶ້ມຄະແນນ ແລະ ບົດລາຍງານອື່ນ.';
$string['modvisiblewithstealth'] = 'ຄວາມພ້ອມໃຊ້ງານ';
$string['modvisiblewithstealth_help'] = 'ຖ້າມີການຕັ້ງໃຫ້ເປັນ \'ສະແດງຢູ່ໃນໜ້າວິຊາ\', ກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນແມ່ນມີໃຫ້ກັບນັກຮຽນ (ອີງຕາມຂໍ້ຈໍາກັດການເຂົ້າເຖິງໃດໜຶ່ງທີ່ອາດຈະຖືກຕັ້ງໄວ້).

ຖ້າມີໃຫ້ຖືກຕັ້ງເປັນ \'ເຊື່ອງຈາກນັກຮຽນ\', ກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນແມ່ນມີໃຫ້ກັບຜູ້ໃຊ້ທີ່ມີການອະນຸຍາດເພື່ອເບິ່ງກິດຈະກໍາທີ່ເຊື່ອງໄວ້ເທົ່ານັ້ນ (ໂດຍຄ່າເລີ່ມຕົ້ນ, ຜູ້ໃຊ້ທີ່ມີບົດບາດເປັນຄູສອນ ຫຼື ຄູທີ່ບໍ່ໄດ້ແກ້ໄຂ).

ຖ້າວິຊາມີກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນຫຼາຍຢ່າງ, ໜ້າວິຊາອາດຈະເຮັດໃຫ້ງ່າຍຂຶ້ນໂດຍການກໍານົດໃຫ້ມີ \'ເຮັດໃຫ້ມີຢູ່ແຕ່ບໍ່ສະແດງຢູ່ໃນໜ້າວິຊາ\'. ໃນກໍລະນີນີ້, ຕ້ອງມີລິ້ງຫາກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນຈາກບ່ອນອື່ນ, ເຊັ່ນ: ຈາກໜ້າແຫຼ່ງຂໍ້ມູນ. ກິດຈະກໍາຍັງຈະຖືກລະບຸໄວ້ຢູ່ໃນປຶ້ມຄະແນນ ແລະ ບົດລາຍງານອື່ນ.';
$string['month'] = 'ເດືອນ';
$string['months'] = 'ເດືອນ';
$string['moodledocs'] = 'ເອກະສານ Moodle';
$string['moodledocslink'] = 'ຊ່ວຍເຫຼືອ ແລະ ເອກະສານ';
$string['moodlelogo'] = 'ໂລໂກ້ Moodle';
$string['moodlerelease'] = 'ປ່ອຍ Moodle';
$string['moodleservicesandsupport'] = 'ການບໍລິການ ແລະ ການສະໜັບສະໜຸນ';
$string['moodleversion'] = 'ເວຊັນ Moodle';
$string['more'] = 'ເພີ່ມຕື່ມ';
$string['moreactions'] = 'ປະຕິບັດເພີ່ມເຕີມ';
$string['morehelp'] = 'ຊ່ວຍເຫຼືອເພີ່ມຕື່ມ';
$string['morehelpaboutmodule'] = 'ຊ່ວຍເຫຼືອເພີ່ມຕື່ມກ່ຽວກັບກິດຈະກຳ {$a}';
$string['moreinfo'] = 'ຂໍ້ມູນເພີ່ມເຕີມ';
$string['moreinformation'] = 'ຂໍ້ມູນເພີ່ມເຕີມກ່ຽວກັບຂໍ້ພິດພາດນີ້';
$string['moremenu'] = 'ເພີ່ມເຕີມ';
$string['morenavigationlinks'] = 'ເພີ່ມເຕີມ...';
$string['moreprofileinfoneeded'] = 'ກະລຸນາບອກພວກເຮົາເພີ່ມເຕີມກ່ຽວກັບຕົວທ່ານເອງ';
$string['mostrecently'] = 'ບໍ່ດົນມານີ້';
$string['move'] = 'ຍ້າຍ';
$string['movecategoriessuccess'] = 'ຍ້າຍລາຍປະເພດ {$a->count} ໄປຫາປະເພດ \'{$a->to}\' ສຳເລັດແລ້ວ';
$string['movecategoriestotopsuccess'] = 'ຍ້າຍລາຍປະເພດ {$a->count} ໄປຫາຂັ້ນສູງສຸດສຳເລັດແລ້ວ';
$string['movecategorycontentto'] = 'ຍ້າຍເຂົ້າໄປ';
$string['movecategorysuccess'] = 'ຍ້າຍປະເພດ \'{$a->moved}\' ເຂົ້າໄປຫາປະເພດ \'{$a->to}\' ສຳເລັດແລ້ວ';
$string['movecategoryto'] = 'ຍ້າຍປະເພດໄປ:';
$string['movecategorytotopsuccess'] = 'ຍ້າຍປະເພດ \'{$a->moved}\' ໄປຫາຂັ້ນສູງສຸດສຳເລັດແລ້ວ';
$string['movecontent'] = 'ຍ້າຍ {$a}';
$string['movecontentafter'] = 'ຫຼັງຈາກ "{$a}"';
$string['movecontentstoanothercategory'] = 'ຍ້າຍເນື້ອໃນໄປປະເພດອື່ນ';
$string['movecontenttothetop'] = 'ໄປທາງເທີງຂອງບັນຊີລາຍການ';
$string['movecoursemodule'] = 'ຍ້າຍແຫຼ່ງຂໍ້ມູນ';
$string['movecoursesection'] = 'ຍ້າຍພາກ';
$string['movecourseto'] = 'ຍ້າຍວິຊາໄປ:';
$string['movedown'] = 'ຍ້າຍລົງ';
$string['movefilestohere'] = 'ຍ້າຍໄຟລ໌ໄປທີ່ນີ້';
$string['movefull'] = 'ຍ້າຍ {$a} ໄປສະຖານທີ່ນີ້';
$string['movehere'] = 'ຍ້າຍໄປທີ່ນີ້';
$string['moveleft'] = 'ຍ້າຍໄປທາງຊ້າຍ';
$string['moveright'] = 'ຍ້າຍໄປທາງຂວາ';
$string['movesection'] = 'ຍ້າຍພາກ {$a}';
$string['moveselectedcategoriesto'] = 'ຍ້າຍບັນດາປະເພດທີ່ເລືອກໄປ';
$string['moveselectedcoursesto'] = 'ຍ້າຍວິຊາທີ່ເລືອກໄປ...';
$string['movetoanotherfolder'] = 'ຍ້າຍໄປຫາໂຟນເດີອື່ນ';
$string['moveup'] = 'ຍ້າຍຂື້ນ';
$string['msnid'] = 'ລະຫັດ ID MSN';
$string['mustchangepassword'] = 'ລະຫັດຜ່ານໃໝ່ຕ້ອງແຕກຕ່າງຈາກອັນທີ່ໃຊ້ໃນປະຈຸບັນ';
$string['mustconfirm'] = 'ທ່ານຈຳເປັນຕ້ອງຢືນຢັນບັນຊີຂອງທ່ານ';
$string['mycourses'] = 'ວິຊາຕ່າງໆຂອງຂ້ອຍ';
$string['myfiles'] = 'ໄຟລ໌ສ່ວນຕົວຂອງຂ້ອຍ';
$string['myfilesmanage'] = 'ຈັດການໄຟລ໌ສ່ວນຕົວຂອງຂ້ອຍ';
$string['myhome'] = 'ແຜງໜ້າປັດ';
$string['mymoodledashboard'] = 'ແຜງໜ້າປັດ Moodle ຂອງຂ້ອຍ';
$string['myprofile'] = 'ໂປຼໄຟລ໌ຂອງຂ້ອຍ';
$string['name'] = 'ຊື່';
$string['namedfiletoolarge'] = 'ໄຟລ໌ \'{$a->filename}\' ໃຫຍ່ເກີນໄປ ແລະ ບໍ່ສາມາດອັບໂຫຼດ';
$string['nameforlink'] = 'ທ່ານຕ້ອງການເອີ້ນລິ້ງນີ້ແນວໃດ?';
$string['nameforpage'] = 'ຊື່';
$string['navigation'] = 'ການນຳທາງ';
$string['needed'] = 'ຈຳເປັນ';
$string['networkdropped'] = 'ພວກເຮົາໄດ້ກວດພົບວ່າການເຊື່ອມຕໍ່ອິນເຕີເນັດຂອງທ່ານບໍ່ໜ້າເຊື່ອຖື ແລະ ໄດ້ຖືກຂັດຂ້ອງ.<br />ກະລຸນາຮັບຊາບວ່າການປ່ຽນແປງອາດຈະບໍ່ຖືກບັນທຶກໄວ້ຢ່າງຖືກຕ້ອງຈົນກ່ວາການເຊື່ອມຕໍ່ຂອງທ່ານຈະດີຂຶ້ນ.';
$string['never'] = 'ຢ່າ';
$string['neverdeletelogs'] = 'ຢ່າລຶບບັນທຶກ';
$string['new'] = 'ໃໝ່';
$string['newaccount'] = 'ບັນຊີໃໝ່';
$string['newactivityname'] = 'ຊື່ໃໝ່ສຳລັບກິດຈະກຳ {$a}';
$string['newcourse'] = 'ວິຊາໃໝ່';
$string['newloginnotificationbodyfull'] = '<p>ສະບາຍດີ {$a->userfullname},</p>
<p>ບັນຊີ {$a->sitename} ຂອງທ່ານຫາກໍ່ລົງຊື່ເຂົ້າໃຊ້ໄປຫາຈາກອຸປະກອນໃໝ່ນີ້.</p>
<ul>
<li>ບັນຊີຂອງທ່ານ: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>ອຸປະກອນ: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>ຖ້ານີ້ແມ່ນທ່ານ, ຫຼັງຈາກນັ້ນ, ທ່ານບໍ່ຈໍາເປັນຕ້ອງເຮັດຫຍັງ.</p>
<p>ຖ້າທ່ານບໍ່ຮູ້ຈັກກິດຈະກໍານີ້, ກະລຸນາ <a href="{$a->changepasswordlink}">ປ່ຽນລະຫັດຜ່ານຂອງທ່ານ</a></p>';
$string['newloginnotificationbodysmall'] = 'ບັນຊີ {$a} ຂອງທ່ານພຽງແຕ່ໄດ້ລົງຊື່ເຂົ້າໃຊ້ໄປຫາຈາກອຸປະກອນໃໝ່.';
$string['newloginnotificationtitle'] = 'ການລົງຊື່ເຂົ້າໃຊ້ໃໝ່ຫາບັນຊີ {$a} ຂອງທ່ານ';
$string['newpassword'] = 'ລະຫັດຜ່ານໃໝ່';
$string['newpassword_help'] = 'ໃສ່ລະຫັດຜ່ານໃໝ່ ຫຼື ປ່ອຍໃຫ້ຫວ່າງເປົ່າເພື່ອຮັກສາລະຫັດຜ່ານປະຈຸບັນ.';
$string['newpasswordfromlost'] = '<strong>ແຈ້ງການ:</strong> <strong>ລະຫັດຜ່ານປະຈຸບັນ</strong> ຂອງທ່ານຈະໄດ້ສົ່ງໄປຫາທ່ານໃນ <strong>second</strong> ຂອງທັງສອງອີເມວທີ່ສົ່ງເປັນສ່ວນໜຶ່ງຂອງຂັ້ນຕອນການກູ້ລະຫັດຜ່ານທີ່ເສຍໄປ. ກວດໃຫ້ແນ່ໃຈວ່າທ່ານໄດ້ຮັບລະຫັດປ່ຽນແທນຂອງທ່ານກ່ອນສືບຕໍ່ກັບໜ້າຈໍນີ້.';
$string['newpasswordtext'] = 'ສະບາຍດີ {$a->firstname},

ລະຫັດຜ່ານບັນຊີຂອງທ່ານຢູ່ທີ່ \'{$a->sitename}\' ໄດ້ຖືກຕັ້ງໃໝ່ແລ້ວ
ແລະ ທ່ານໄດ້ອອກລະຫັດຜ່ານຊົ່ວຄາວໃໝ່.

ຂໍ້ມູນເຂົ້າສູ່ລະບົບປັດຈຸບັນຂອງທ່ານດຽວນີ້ແມ່ນ:
    ຊື່ຜູ້ໃຊ້: {$a->username}
    ລະຫັດຜ່ານ: {$a->newpassword}

ກະລຸນາໄປທີ່ໜ້ານີ້ເພື່ອປ່ຽນລະຫັດຜ່ານຂອງທ່ານ:
    {$a->link}

ຢູ່ໃນໂປຣແກມຈົດໝາຍສ່ວນໃຫຍ່, ອັນນີ້ຄວນປະກົດເປັນລິ້ງສີຟ້າ
ທີ່ທ່ານພຽງແຕ່ສາມາດຄລິກໃສ່. ຖ້າມັນບໍ່ໄດ້ຜົນ,
ໃຫ້ຕັດ ແລະ ວາງທີ່ຢູ່ໃສ່ແຖວທີ່ຢູ່
ຢູ່ເທິງສຸດຂອງປ່ອງຢ້ຽມບລາວເຊີຂອງທ່ານ.

ເຊຍຈາກຜູ້ເບິ່ງແຍງລະບົບ \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'ຮູບພາບໃໝ່';
$string['newpicture_help'] = 'ເພື່ອເພີ່ມຮູບພາບໃໝ່, ເອີ້ນເບິ່ງ ແລະ ເລືອກຮູບໃດໜຶ່ງ (ໃນຮູບແບບ JPG ຫຼື PNG) ຈາກນັ້ນຄລິກທີ່ "ອັບເດດໂປຣໄຟລ໌". ຮູບພາບຈະຖືກຕັດເປັນສີ່ຫຼ່ຽມ ແລະ ປັບຂະໜາດ ເປັນ 100x100 ພິກເຊວ.';
$string['newpictureusernotsetup'] = 'ຮູບໂປຣໄຟລ໌ສາມາດເພີ່ມໃສ່ໄດ້ເພື່ອດຽວເມື່ອຂໍ້ມູນໂປຣໄຟລ໌ທີ່ຕ້ອງການທັງໝົດຖືກບັນທຶກໄວ້.';
$string['newsectionname'] = 'ຊື່ໃໝ່ສຳລັບພາກ {$a}';
$string['newsitem'] = 'ລາຍການຂ່າວ';
$string['newsitems'] = 'ການປະກາດ';
$string['newsitemsnumber'] = 'ຈຳນວນການປະກາດ';
$string['newsitemsnumber_help'] = 'ການປະກາດກອງປະຊຸມສົນທະນາແມ່ນກອງປະຊຸມສົນທະນາພິເສດທີ່ຖືກສ້າງຢ່າງອັດຕະໂນມັດໃນວິຊາ, ໄດ້ບັງຄັບໃຫ້ມີການສະໝັກໃຊ້ຕາມຄ່າເລີ່ມຕົ້ນ, ແລະ ມີພຽງແຕ່ຜູ້ໃຊ້ທີ່ມີການອະນຸຍາດທີ່ເໝາະສົມ (ໂດຍຄ່າເລີ່ມຕົ້ນຄູສອນ) ສາມາດປະກາດໃນມັນໄດ້.

ການຕັ້ງຄ່ານີ້ກໍານົດວ່າມີການປະກາດເມື່ອບໍ່ດົນມານີ້ຫຼາຍປານໃດຢູ່ໃນບລັອກການປະກາດລ້າສຸດ.

ຖ້າບໍ່ຕ້ອງການການປະກາດກອງປະຊຸມສົນທະນາໃນວິຊາ, ການຕັ້ງຄ່ານີ້ຄວນຕັ້ງເປັນສູນ.';
$string['newuser'] = 'ຜູ້ໃຊ້ໃໝ່';
$string['newusernewpasswordsubj'] = 'ບັນຊີຜູ້ໃຊ້ໃໝ່';
$string['newusernewpasswordtext'] = 'ສະບາຍດີ {$a->firstname},

ບັນຊີໃໝ່ໄດ້ສ້າງແລ້ວສຳລັບທ່ານຢູ່ທີ່ \'{$a->sitename}\'
ແລະ ທ່ານໄດ້ອອກລະຫັດຜ່ານຊົ່ວຄາວໃໝ່.

ຂໍ້ມູນເຂົ້າສູ່ລະບົບປັດຈຸບັນຂອງທ່ານດຽວນີ້ແມ່ນ:
    ຊື່ຜູ້ໃຊ້: {$a->username}
    ລະຫັດຜ່ານ: {$a->newpassword}
              (ທ່ານຈະຕ້ອງປ່ຽນລະຫັດຜ່ານຂອງທ່ານ
               ເມື່ອທ່ານເຂົ້າສູ່ລະບົບຄັ້ງທໍາອິດ)

ເພື່ອເລີ່ມໃຊ້  \'{$a->sitename}\', ເຂົ້າສູ່ລະບົບທີ່
    {$a->link}

ຢູ່ໃນໂປຣແກມຈົດໝາຍສ່ວນໃຫຍ່, ສິ່ງນີ້ຄວນປະກົດເປັນລິ້ງສີຟ້າ
ທີ່ທ່ານພຽງແຕ່ສາມາດຄລິກໃສ່. ຖ້າມັນບໍ່ໄດ້ຜົນ,
ໃຫ້ຕັດ ແລະ ວາງທີ່ຢູ່ໃສ່ແຖວທີ່ຢູ່
ຢູ່ເທິງສຸດຂອງປ່ອງຢ້ຽມເວັບບລາວເຊີຂອງທ່ານ.

ຊົມເຊຍຈາກຜູ້ເບິ່ງແຍງລະບົບ \'{$a->sitename}\',
{$a->signoff}';
$string['newusers'] = 'ບັນດາຜູ້ໃຊ້ໃໝ່';
$string['newwindow'] = 'ປ່ອງຢ້ຽມໃໝ່';
$string['next'] = 'ຕໍ່ໄປ';
$string['nextpage'] = 'ໜ້າຕໍ່ໄປ';
$string['nextsection'] = 'ພາກຕໍ່ໄປ';
$string['no'] = 'ບໍ່';
$string['noblockstoaddhere'] = 'ບໍ່ມີບລັອກໃດທີ່ທ່ານສາມາດເພີ່ມໃສ່ໜ້ານີ້ໄດ້.';
$string['nobody'] = 'ບໍ່ມີໃຜ';
$string['nochange'] = 'ບໍ່ມີການປ່ຽນແປງ';
$string['nocomments'] = 'ບໍ່ມີຄຳເຫັນ';
$string['nocourses'] = 'ບໍ່ມີວິຊາ';
$string['nocoursesfound'] = 'ບໍ່ພົບວິຊາທີ່ມີຄຳວ່າ \'{$a}\'';
$string['nocoursestarttime'] = 'ວິຊາບໍ່ມີວັນທີ່ເລີ່ມຕົ້ນ.';
$string['nocoursesyet'] = 'ບໍ່ມີວິຊາໃນປະເພດນີ້';
$string['nodstpresets'] = 'ຜູ້ເບິ່ງແຍງລະບົບຍັງບໍ່ໄດ້ເປີດການຮັບຮອງເວລາປະຫຍັດເວລາກາງເວັນ.';
$string['nofilesselected'] = 'ບໍ່ໄດ້ເລືອກໄຟລ໌ເພື່ອກູ້ຄືນ';
$string['nofilesyet'] = 'ຍັງບໍ່ໄດ້ອັບໂຫຼດໄຟລ໌ໄປຫາວິຊາຂອງທ່ານເທື່ອ';
$string['nofiltersapplied'] = 'ບໍ່ໄດ້ໃຊ້ຕົວກັ່ນກອງ';
$string['nograde'] = 'ບໍ່ມີຄະແນນ';
$string['nohelpforactivityorresource'] = 'ປະຈຸບັນບໍ່ມີການຊ່ວຍເຫຼືອທີ່ກ່ຽວຂ້ອງກັບແຫຼ່ງຂໍ້ມູນ ຫຼື ກິດຈະກໍານີ້';
$string['noimagesyet'] = 'ຍັງບໍ່ມີຮູບພາບຖືກອັບໂຫຼດໃສ່ວິຊາຂອງທ່ານເທື່ອ';
$string['nologsfound'] = 'ບໍ່ພົບບັນທຶກ';
$string['nomatchingusers'] = 'ບໍ່ມີຜູ້ໃຊ້ກົງກັບ \'{$a}\'';
$string['nomorecourses'] = 'ບໍ່ພົບວິຊາທີ່ກົງກັນເພີ່ມເຕີມ';
$string['nomoreidnumber'] = 'ບໍ່ໃຊ້ຕົວເລກເພື່ອຫຼີກເວັ້ນການຕຳກັນ';
$string['none'] = 'ບໍ່ມີ';
$string['noneditingteacher'] = 'ຄູສອນທີ່ບໍ່ໄດ້ດັດແກ້';
$string['noneditingteacherdescription'] = 'ຄູສອນທີ່ບໍ່ໄດ້ດັດແກ້ສາມາດສອນຢູ່ໃນວິຊາ ແລະ ນັກຮຽນໃນຊັ້ນຮຽນ, ແຕ່ອາດຈະບໍ່ປ່ຽນແປງກິດຈະກໍາ.';
$string['nonstandard'] = 'ບໍ່ໄດ້ມາດຕະຖານ';
$string['nopendingcourses'] = 'ບໍ່ມີຫຼັກສູດທີ່ລໍຖ້າການອະນຸມັດ';
$string['nopotentialadmins'] = 'ບໍ່ມີຜູ້ເບິ່ງແຍງລະບົບທີ່ເປັນໄປໄດ້';
$string['nopotentialcreators'] = 'ບໍ່ມີຜູ້ສ້າງວິຊາທີ່ເປັນໄປໄດ້';
$string['nopotentialstudents'] = 'ບໍ່ມີນັກຮຽນທີ່ເປັນໄປໄດ້';
$string['nopotentialteachers'] = 'ບໍ່ມີຄູສອນທີ່ເປັນໄປໄດ້';
$string['norecentactivity'] = 'ບໍ່ມີການເຄື່ອນໄຫວຫຼ້າສຸດ';
$string['noreplybouncemessage'] = 'ທ່ານໄດ້ຕອບກັບທີ່ຢູ່ອີເມວທີ່ບໍ່ມີການຕອບກັບ. ຖ້າທ່ານກຳ ລັງພະຍາຍາມຕອບກັບກະດານສົນທະນາ, ກະລຸນາຕອບຄືນດ້ວຍການໃຊ້ກະດານສົນທະນາ {$a}.

ຕໍ່ໄປນີ້ແມ່ນເນື້ອໃນຂອງອີເມວຂອງທ່ານ:';
$string['noreplybouncesubject'] = '{$a} - ອີເມລຖືກສົ່ງກັບຄືນ.';
$string['noreplyname'] = 'ຢ່າຕອບກັບອີເມລນີ້';
$string['noresetrecord'] = 'ບໍ່ມີບັນທຶກຄໍາຮ້ອງຂໍການຕັ້ງຄ່າຄືນໃໝ່. ກະລຸນາລິເລີ່ມຄໍາຮ້ອງຂໍການຕັ່ງຄ່າລະຫັດຄືນອີກຄັ້ງໃໝ່';
$string['noresults'] = 'ບໍ່ມີຜົນໄດ້ຮັບ';
$string['normal'] = 'ທຳມະດາ';
$string['normalfilter'] = 'ການຄົ້ນຫາທຳມະດາ';
$string['nosite'] = 'ບໍ່ສາມາດຊອກຫັນວິຊາລະດັບເວັບໄຊທ໌ໄດ້';
$string['nostudentsfound'] = 'ບໍ່ພົບ {$a}';
$string['nostudentsingroup'] = 'ຍັງບໍ່ມີນັກຮຽນໃນກຸ່ມນີ້ເທື່ອ';
$string['nostudentsyet'] = 'ບໍ່ມີນັກຮຽນລົງທະບຽນເຂົ້າຮຽນວິຊານີ້';
$string['nosuchemail'] = 'ບໍ່ມີທີ່ຢູ່ອີເມລດັ່ງກ່າວ';
$string['notavailable'] = 'ບໍ່ມີໃຫ້';
$string['notavailablecourse'] = '{$a} ບໍ່ມີໃຫ້';
$string['noteachersyet'] = 'ບໍ່ມີຄູສອນໃນວິຊານີ້ເທື່ອ';
$string['noteachingupcomingcourses'] = 'ວິຊາກຳລັງຈະມາໄວໄວນີ້ບໍ່ມີຄູສອນ ແລະ ນັກຮຽນ';
$string['notenrolled'] = '{$a} ບໍ່ໄດ້ລົງທະບຽນເຂົ້າໃນວິຊານີ້.';
$string['notenrolledprofile'] = 'ໂປຣໄຟລ໌ນີ້ບໍ່ສາມາດໃຊ້ໄດ້ເນື່ອງຈາກຜູ້ໃຊ້ນີ້ບໍ່ໄດ້ລົງທະບຽນໃນວິຊານີ້.';
$string['noteusercannotrolldatesoncontext'] = '<strong>ໝາຍເຫດ:</strong> ຄວາມສາມາດໃນການເລື່ອນວັນທີເມື່ອການກູ້ຄືນການສໍາຮອງຂໍ້ມູນນີ້ຖືກປິດໃຊ້ງານເພາະວ່າທ່ານຂາດການອະນຸຍາດທີ່ຕ້ອງການ.';
$string['noteuserschangednonetocourse'] = '<strong>ໝາຍເຫດ:</strong> ຜູ້ໃຊ້ວິຊາຕ້ອງໄດ້ຮັບການຟື້ນຟູຄືນມາໃນເວລາທີ່ການຟື້ນຟູຂໍ້ມູນຜູ້ໃຊ້ (ໃນກິດຈະກໍາ, ໄຟລ໌ ຫຼື ຂໍ້ຄວາມ). ການຕັ້ງຄ່ານີ້ໄດ້ຖືກປ່ຽນສຳລັບທ່ານ.';
$string['nothingnew'] = 'ບໍ່ມີການເຄື່ອນໄຫວຫຼ້າສຸດ';
$string['nothingtodisplay'] = 'ບໍ່ມີຫຍັງໃຫ້ສະແດງ';
$string['notice'] = 'ແຈ້ງການ';
$string['noticenewerbackup'] = 'ໄຟລ໌ສຳຮອງນີ້ຖືກສ້າງຂຶ້ນດ້ວຍ Moodle {$a->backuprelease} ({$a->backupversion}) ແລະ ມັນໃໝ່ກວ່າ Moodle ທີ່ຕິດຕັ້ງຢູ່ໃນປະຈຸບັນຂອງທ່ານ {$a->serverrelease} ({$a->serverversion}). ສິ່ງນີ້ອາດຈະເຮັດໃຫ້ເກີດຄວາມບໍ່ສອດຄ່ອງບາງຢ່າງເພາະວ່າການເຂົ້າກັນໄດ້ກັບຄືນຂອງໄຟລ໌ສຳຮອງບໍ່ສາມາດຮັບປະກັນໄດ້.';
$string['notifications'] = 'ການແຈ້ງເຕືອນ';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, ຜູ້ໃຊ້: {$a->info}, ຊື່ເຕັມຜູ້ໃຊ້: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'ທ່ານສາມາດເບິ່ງບັນທຶກເຫຼົ່ານີ້ໄດ້ທີ່ {$a}';
$string['notifyloginfailuresmessagestart'] = 'ນີ້ແມ່ນລາຍຊື່ຄວາມພະຍາຍາມເຂົ້າສູ່ລະບົບທີ່ລົ້ມເຫຼວຢູ່ທີ່ {$a} ນັບຕັ້ງແຕ່ທ່ານໄດ້ຮັບການແຈ້ງເຕືອນຄັ້ງສຸດທ້າຍ';
$string['notifyloginfailuressubject'] = '{$a} :: ການແຈ້ງເຕືອນການເຂົ້າສູ່ລະບົບບໍ່ສໍາເລັດ';
$string['notincluded'] = 'ບໍ່ລວມເອົາ';
$string['notingroup'] = 'ຂໍອະໄພ, ແຕ່ທ່ານຕ້ອງເປັນສ່ວນໜຶ່ງຂອງກຸ່ມເພື່ອເບິ່ງ ໜ້ານີ້.';
$string['notpublic'] = 'ບໍ່ເປັນສາທາລະນະ!';
$string['nousersfound'] = 'ບໍ່ພົບຜູ້ໃຊ້';
$string['nousersmatching'] = 'ບໍ່ພົບຜູ້ໃຊ້ທີ່ກົງກັບ \'{$a}\'';
$string['nousersyet'] = 'ບໍ່ມີຜູ້ໃຊ້ເທື່ອ';
$string['novalidcourses'] = 'ບໍ່ມີວິຊາທີ່ຖືກຕ້ອງໃຫ້ສະແດງ';
$string['now'] = 'ດຽວນີ້';
$string['numattempts'] = 'ພະຍາຍາມເຂົ້າສູ່ລະບົບ {$a} ບໍ່ສຳເລັດ';
$string['numberofcourses'] = 'ຈຳນວນວິຊາ';
$string['numberweeks'] = 'ຈຳນວນພາກ';
$string['numday'] = '{$a} ວັນ';
$string['numdays'] = '{$a} ວັນ';
$string['numhours'] = '{$a} ຊົ່ວໂມງ';
$string['numletters'] = '{$a} ຕົວໜັງສື';
$string['numminutes'] = '{$a} ນາທີ';
$string['nummonth'] = '{$a} ເດືອນ';
$string['nummonths'] = '{$a} ເດືອນ';
$string['numseconds'] = '{$a} ວິນາທີ';
$string['numviews'] = '{$a} ເບິ່ງ';
$string['numweek'] = '{$a} ອາທິດ';
$string['numweeks'] = '{$a} ອາທິດ';
$string['numwords'] = '{$a} ຄຳສັບ';
$string['numyear'] = '{$a} ປີ';
$string['numyears'] = '{$a} ປີ';
$string['ok'] = 'ໂອເຄ';
$string['oldpassword'] = 'ລະຫັດຜ່ານປະຈຸບັນ';
$string['olduserdirectory'] = 'ນີ້ແມ່ນບັນຊີລາຍຊື່ຜູ້ໃຊ້ເກົ່າ, ແລະ ບໍ່ຕ້ອງການອີກຕໍ່ໄປ. ທ່ານອາດຈະລຶບມັນໄດ້ຢ່າງປອດໄພ. ໄຟລ໌ທີ່ມັນບັນຈຸມີໄດ້ຖືກສຳເນົາໄປໃສ່ບັນຊີຜູ້ໃຊ້ໃໝ່.';
$string['opendrawerblocks'] = 'ເປີດລິ້ນຊັກບລັອກ';
$string['opendrawerindex'] = 'ເປີດດັດສະນີລາຍວິຊາ';
$string['opensinnewwindow'] = 'ເປີດໃນໜ້າຈໍໃໝ່';
$string['optional'] = 'ທາງເລືອກ';
$string['options'] = 'ທາງເລືອກ';
$string['order'] = 'ຄຳສັ່ງ';
$string['originalpath'] = 'ເສັ້ນທາງເດີມ';
$string['orphanedactivitiesinsectionno'] = 'ກິດຈະກຳກຳພ້າ (ພາກ {$a})';
$string['other'] = 'ອື່ນໆ';
$string['outline'] = 'ໂຄງຮ່າງ';
$string['outlinereport'] = 'ລາຍງານໂຄງຮ່າງ';
$string['page'] = 'ໜ້າ';
$string['pagea'] = 'ໜ້າ {$a}';
$string['pagedcontentnavigation'] = 'ການນຳທາງເລກໜ້າ';
$string['pagedcontentnavigationactiveitem'] = 'ໜ້າປະຈຸບັນ, ໜ້າ {$a}';
$string['pagedcontentnavigationitem'] = 'ໄປທີ່ໜ້າ {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'ສະແດງລາຍການ {$a} ຕໍ່ໜ້າ';
$string['pageheaderconfigablock'] = 'ຕັ້ງຄ່າບລັອກໃນ {$a->fullname}';
$string['pagepath'] = 'ເສັ້ນທາງຂອງຫນ້າ';
$string['pageshouldredirect'] = 'ໜ້ານີ້ຄວນປ່ຽນເສັ້ນທາງໂດຍອັດຕະໂນມັດ. ຖ້າບໍ່ມີຫຍັງເກີດຂຶ້ນກະລຸນາໃຊ້ລິ້ງຕໍ່ໄປລຸ່ມນີ້.';
$string['parentcategory'] = 'ປະເພດຜູ້ປົກຄອງ';
$string['parentcoursenotfound'] = 'ບໍ່ພົບວິຊາຜູ້ປົກຄອງ!';
$string['parentfolder'] = 'ໂຟເດີຜູ້ປົກຄອງ';
$string['participants'] = 'ຜູ້ເຂົ້າຮ່ວມ';
$string['participantscount'] = 'ຈຳນວນຜູ້ເຂົ້າຮ່ວມ: {$a}';
$string['participantslist'] = 'ລາຍຊື່ຜູ້ເຂົ້າຮ່ວມ';
$string['participationratio'] = 'ອັດຕາສ່ວນການມີສ່ວນຮ່ວມ';
$string['participationreport'] = 'ລາຍງານການມີສ່ວນຮ່ວມ';
$string['password'] = 'ລະຫັດຜ່ານ';
$string['passwordchanged'] = 'ລະຫັດຜ່ານປ່ຽນແປງຮຽບຮ້ອຍແລ້ວ';
$string['passwordconfirmchange'] = 'ຢືນຢັນການປ່ຽນລະຫັດຜ່ານ';
$string['passwordextlink'] = 'ໄດ້ມີການສະໜອງລິ້ງຕໍ່ໄປນີ້ ເພື່ອກູ້ລະຫັດຜ່ານທີ່ເສຍໄປຂອງທ່ານ. ອັນນີ້ຈະເອົາທ່ານອອກໄປຈາກ Moodle.';
$string['passwordforgotten'] = 'ລືມລະຫັດຜ່ານ';
$string['passwordforgotteninstructions'] = 'ລາຍລະອຽດຂອງທ່ານກ່ອນອື່ນໝົດຕ້ອງຢູ່ໃນຖານຂໍ້ມູນຜູ້ໃຊ້. ກະລຸນາໃສ່ <strong>ບໍ່ວ່າຈະເປັນ</strong> ຊື່ຜູ້ໃຊ້ຂອງທ່ານ ຫຼື ທີ່ຢູ່ອີເມລທີ່ລົງທະບຽນຂອງທ່ານໃສ່ໃນປ່ອງທີ່ເໝາະສົມ. ບໍ່ຈໍາເປັນຕ້ອງໃສ່ທັງສອງ.';
$string['passwordforgotteninstructions2'] = 'ເພື່ອຕັ້ງລະຫັດຜ່ານຂອງທ່ານຄືນໃໝ່, ສົ່ງຊື່ຜູ້ໃຊ້ ຫຼື ທີ່ຢູ່ອີເມລຂອງທ່ານລົງໄປທາງລຸ່ມນີ້. ຖ້າພວກເຮົາສາມາດຊອກຫາທ່ານຢູ່ໃນຖານຂໍ້ມູນ, ອີເມລຈະຖືກສົ່ງໄປຫາທີ່ຢູ່ອີເມລຂອງທ່ານ, ພ້ອມກັບຄໍາແນະນໍາວິທີການເຂົ້າຫາອີກຄັ້ງ.';
$string['passwordnohelp'] = 'ບໍ່ສາມາດຊ່ວຍເຫຼືອເພື່ອຊອກຫາລະຫັດຜ່ານທີ່ເສຍຂອງທ່ານ. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ Moodle ຂອງທ່ານ.';
$string['passwordpolicynomatch'] = 'ລະຫັດຜ່ານປັດຈຸບັນຂອງທ່ານບໍ່ກົງກັບນະໂຍບາຍລະຫັດຜ່ານທີ່ຕັ້ງໄວ້ອີກຕໍ່ໄປ.
    {$ a}';
$string['passwordrecovery'] = 'ແມ່ນແລ້ວ, ຊ່ວຍຂ້ອຍໃນການເຂົ້າສູ່ລະບົບດ້ວຍ';
$string['passwordsdiffer'] = 'ລະຫັດຜ່ານເຫຼົ່ານີ້ບໍ່ກົງກັນ';
$string['passwordsent'] = 'ລະຫັດຜ່ານຖືກສົ່ງແລ້ວ';
$string['passwordsenttext'] = '<p>ອີເມລໄດ້ຖືກສົ່ງໄປຫາທີ່ຢູ່ຂອງທ່ານຢູ່ທີ່ {$a->email}.</p>
   <p><b>ກະລຸນາກວດອີເມລຂອງທ່ານສໍາລັບລະຫັດຜ່ານໃໝ່ຂອງທ່ານ</b></p>
   <p>ລະຫັດຜ່ານໃໝ່ຖືກສ້າງຂຶ້ນໂດຍອັດຕະໂນມັດ, ດັ່ງນັ້ນທ່ານອາດຈະມັກ
   <a href="{$a->link}">ປ່ຽນມັນເປັນສິ່ງທີ່ຈື່ໄດ້ງ່າຍກວ່າ</a>.</p>';
$string['passwordset'] = 'ລະຫັດຜ່ານຂອງທ່ານຖືກຕັ້ງໄວ້ແລ້ວ.';
$string['path'] = 'ເສັ້ນທາງ';
$string['pathnotexists'] = 'ເສັ້ນທາງບໍ່ມີຢູ່ໃນເຊີບເວີຂອງທ່ານ!';
$string['pathslasherror'] = 'ເສັ້ນທາງບໍ່ສາມາດຈົບລົງດ້ວຍຮອຍຂີດຂ່ວນ!!';
$string['paymentinstant'] = 'ໃຊ້ປຸ່ມຂ້າງລຸ່ມເພື່ອຊໍາລະ ແລະ ຖືກລົງທະບຽນພາຍໃນນາທີ!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pending</small>)';
$string['paymentrequired'] = 'ວິຊານີ້ຕ້ອງການການຊໍາລະເງິນສໍາລັບການເຂົ້າ.';
$string['payments'] = 'ການຊຳລະ';
$string['paymentsorry'] = 'ຂອບໃຈສໍາລັບການຊໍາລະເງິນຂອງທ່ານ! ໂຊກບໍ່ດີ, ການຊໍາລະເງິນຂອງທ່ານຍັງບໍ່ທັນຖືກປະມວນຜົນຄົບຖ້ວນເທື່ອ, ແລະ ທ່ານຍັງບໍ່ໄດ້ລົງທະບຽນເຂົ້າວິຊາ "{$a->fullname}" ເທື່ອ. ກະລຸນາລອງສືບຕໍ່ໃນວິຊາໃນອີກສອງສາມວິນາທີ, ແຕ່ຖ້າທ່ານຍັງສືບຕໍ່ມີບັນຫາຢູ່, ກະລຸນາແຈ້ງເຕືອນ {$a->teacher} ຫຼື ຜູ້ຄວບຄຸມເວັບໄຊທ໌.';
$string['paymentthanks'] = 'ຂອບໃຈສໍາລັບການຊໍາລະເງິນຂອງທ່ານ! ດຽວນີ້ທ່ານໄດ້ລົງທະບຽນເຂົ້າຮຽນວິຊາຂອງທ່ານແລ້ວ:<br />"{$a}"';
$string['pendingrequests'] = 'ຄຳຂໍທີ່ຄ້າງຢູ່';
$string['percents'] = '{$a}%';
$string['periodending'] = 'ໄລຍະເວລາສິ້ນສຸດ ({$a})';
$string['perpage'] = 'ຕໍ່ໜ້າ';
$string['perpagea'] = 'ຕໍ່ໜ້າ {$a}';
$string['personal'] = 'ສ່ວນຕົວ';
$string['personalprofile'] = 'ໂປຼໄຟລ໌ສ່ວນຕົວ';
$string['phone'] = 'ໂທລະສັບ';
$string['phone1'] = 'ໂທລະສັບ';
$string['phone2'] = 'ໂທລະສັບມືຖື';
$string['phpinfo'] = 'ຂໍ້ມູນ PHP';
$string['pictureof'] = 'ຮູບພາບຂອງ {$a}';
$string['pictureofuser'] = 'ຮູບຜູ້ໃຊ້';
$string['pleaseclose'] = 'ກະລຸນາປິດໜ້າຕ່າງນີ້ດຽວນີ້.';
$string['pleasesearchmore'] = 'ກະລຸນາຄົ້ນຫາຕື່ມອີກ';
$string['pleaseusesearch'] = 'ກະລຸນານຳໃຊ້ການຄົ້ນຫາ';
$string['plugin'] = 'ປລັກອິນ';
$string['plugincheck'] = 'ກວດສອບປລັກອິນ';
$string['plugindeletefiles'] = 'ຂໍ້ມູນທັງໝົດທີ່ເຊື່ອມໂຍງກັບປລັກອິນ \'{$a->name}\' ໄດ້ຖືກລຶບອອກຈາກຖານຂໍ້ມູນ. ເພື່ອປ້ອງກັນການຕິດຕັ້ງປລັກອິນຕົວມັນເອງຄືນໃໝ່, ດຽວນີ້ທ່ານຄວນລຶບບັນຊີລາຍຊື່ນີ້ອອກຈາກເຊີບເວີຂອງທ່ານ: {$a->directory}';
$string['pluginsetup'] = 'ການຕັ້ງຄ່າຕາຕະລາງປລັກອິນ';
$string['policyaccept'] = 'ຂ້ອຍເຂົ້າໃຈ ແລະ ເຫັນດີ';
$string['policyagree'] = 'ທ່ານຕ້ອງຍອມຮັບນະໂຍບາຍນີ້ ເພື່ອສືບຕໍ່ນຳໃຊ້ເວັບໄຊທ໌ນີ້. ທ່ານເຫັນດີບໍ່?';
$string['policyagreement'] = 'ຂໍ້ຕົກລົງນະໂຍບາຍຂອງສະຖານທີ່';
$string['policyagreementclick'] = 'ລິ້ງກັບຂໍ້ຕົກລົງນະໂຍບາຍຂອງເວັບໄຊທ໌';
$string['popup'] = 'ລອຍຂື້ນ';
$string['popupwindow'] = 'ເປີດໄຟລ໌ຢູ່ໃນປ່ອງຢ້ຽມໃຫມ່';
$string['popupwindowname'] = 'ປ່ອງຢ້ຽມລອຍຂື້ນ';
$string['post'] = 'ໂພສ';
$string['posts'] = 'ບັນດາໂພສ';
$string['potentialadmins'] = 'ຜູ້ເບິ່ງແຍງທີ່ເປັນໄປໄດ້';
$string['potentialcreators'] = 'ຜູ້ສ້າງວິຊາທີ່ເປັນໄປໄດ້';
$string['potentialstudents'] = 'ນັກຮຽນທີ່ເປັນໄປໄດ້';
$string['potentialteachers'] = 'ອາຈານທີ່ເປັນໄປໄດ້';
$string['poweredbymoodle'] = 'ໃຫ້ພະລັງງານໂດຍ <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'ການຕັ້ງຄ່າ';
$string['preferredlanguage'] = 'ພາສາທີ່ມັກ';
$string['preferredtheme'] = 'ຮູບແບບສີສັນທີ່ມັກ';
$string['preprocessingbackupfile'] = 'ກຳລັງປະມວນຜົນໄຟລ໌ສຳຮອງລ່ວງໜ້າ';
$string['prev'] = 'ກ່ອນໜ້າ';
$string['preview'] = 'ເບິ່ງຕົວຢ່າງ';
$string['previeworchoose'] = 'ເບິ່ງຕົວຢ່າງ ຫຼື ເລືອກຮູບແບບສີສັນໃດໜຶ່ງ';
$string['previous'] = 'ທີ່ຜ່ານມາ';
$string['previouslyselectedusers'] = 'ຜູ້ໃຊ້ທີ່ເລືອກກ່ອນໜ້ານີ້ບໍ່ກົງກັບ \'{$a}\'';
$string['previouspage'] = 'ຫນ້າທີ່ຜ່ານມາ';
$string['previoussection'] = 'ພາກທີ່ຜ່ານມາ';
$string['primaryadminsetup'] = 'ຕັ້ງບັນຊີຜູ້ເບິ່ງແຍງລະບົບ';
$string['privacy:metadata:config_log'] = 'ບັນທຶກຂອງການປ່ຽນແປງການຕັ້ງຄ່າ.';
$string['privacy:metadata:config_log:name'] = 'ຊື່ຂອງການຕັ້ງຄ່າປ່ຽນແປງ.';
$string['privacy:metadata:config_log:oldvalue'] = 'ຄ່າກ່ອນໜ້າສຳລັບການຕັ້ງຄ່ານີ້.';
$string['privacy:metadata:config_log:plugin'] = 'ປລັກອິນຖືກດັດແກ້.';
$string['privacy:metadata:config_log:timemodified'] = 'ເວລາທີ່ມີການປ່ຽນແປງໄດ້.';
$string['privacy:metadata:config_log:userid'] = 'ຜູ້ໃຊ້ທີ່ເຮັດການປ່ຽນແປງ.';
$string['privacy:metadata:config_log:value'] = 'ຄ່າໃໝ່ສຳລັບການຕັ້ງຄ່ານີ້.';
$string['privacy:metadata:events_queue'] = 'ຄິວຂອງເຫດການຜູ້ໃຊ້ກຳລັງລໍຖ້າດຳເນີນການ.';
$string['privacy:metadata:events_queue:eventdata'] = 'ຂໍ້ມູນທີ່ຈັດເກັບໄວ້ໃນເຫດການ.';
$string['privacy:metadata:events_queue:stackdump'] = 'stacktrace ໃດໜຶ່ງທີ່ກ່ຽວຂ້ອງກັບເຫດການນີ້.';
$string['privacy:metadata:events_queue:timecreated'] = 'ເວລາທີ່ເຫດການນີ້ຖືກສ້າງຂຶ້ນ.';
$string['privacy:metadata:events_queue:userid'] = 'ID ຜູ້ໃຊ້ທີ່ເຊື່ອມໂຍງກັບເຫດການນີ້';
$string['privacy:metadata:log'] = 'ຄັງບັນທຶກເຫດການທີ່ຜ່ານມາ';
$string['privacy:metadata:log:action'] = 'ລາຍລະອຽດຂອງການປະຕິບັດ';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'ວິຊາ';
$string['privacy:metadata:log:info'] = 'ຂໍ້ມູນເພີ່ມເຕີມ';
$string['privacy:metadata:log:ip'] = 'ທີ່ຢູ່ IP ໃຊ້ໃນເວລາຂອງເຫດການ';
$string['privacy:metadata:log:module'] = 'ຊຸດ';
$string['privacy:metadata:log:time'] = 'ເວລາທີ່ການປະຕິບັດໄດ້ເກີດຂຶ້ນ';
$string['privacy:metadata:log:url'] = 'URL ທີ່ກ່ຽວຂ້ອງກັບເຫດການ';
$string['privacy:metadata:log:userid'] = 'ID ຂອງຜູ້ໃຊ້ທີ່ເຮັດການກະທໍາ';
$string['privacy:metadata:oauth2_refresh_token'] = 'ໂຫຼດໂທເຄັນຄືນໃໝ່ທີ່ໃຊ້ໃນການສື່ສານ OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID ຂອງຜູ້ອອກບັດທີ່ໂທເຄັນສອດຄ່ອງກັນ';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID ຂອງຜູ້ໃຊ້ທີ່ໂທເຄັນສອດຄ່ອງກັບ';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'ເວລາທີ່ສ້າງໂທເຄັນ';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'ເວລາທີ່ໂທເຄັນຖືກອັບເດດຄັ້ງລ້າສຸດ';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'ໂທເຄັນໂຫຼດຂໍ້ມູນຄືນໃໝ່ສໍາລັບຂອບເຂດ ແລະ ຜູ້ໃຊ້';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID ຂອງຜູ້ໃຊ້ທີ່ໂທເຄັນສອດຄ່ອງກັບ';
$string['privacy:metadata:task_adhoc'] = 'ສະຖານະພາບຂອງວຽກງານສະເພາະ.';
$string['privacy:metadata:task_adhoc:component'] = 'ອົງປະກອບທີ່ເປັນເຈົ້າຂອງໜ້າວຽກ.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'ເວລາທໍາອິດເພື່ອດໍາເນີນວຽກງານນີ້.';
$string['privacy:metadata:task_adhoc:userid'] = 'ຜູ້ໃຊ້ທີ່ຈະດໍາເນີນວຽກງານເປັນ.';
$string['privacy:metadata:task_log'] = 'ບັນທຶກຜົນໄດ້ຮັບສຳລັບບັນທຶກ';
$string['privacy:metadata:task_log:component'] = 'ອົງປະກອບທີ່ເປັນເຈົ້າຂອງໜ້າວຽກ.';
$string['privacy:metadata:task_log:userid'] = 'ຜູ້ໃຊ້ທີ່ໜ້າວຽກເປັນຂອງ.';
$string['privacy:metadata:upgrade_log'] = 'ການຍົກລະດັບບັນທຶກ.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'backtrace ໃດໜຶ່ງທີ່ກ່ຽວຂ້ອງກັບຂັ້ນຕອນການຍົກລະດັບນີ້.';
$string['privacy:metadata:upgrade_log:details'] = 'ຂໍ້ມູນເພີ່ມເຕີມທີ່ກ່ຽວຂ້ອງກັບການຍົກລະດັບ.';
$string['privacy:metadata:upgrade_log:info'] = 'ຂໍ້ມູນຫຼັກສໍາລັບຂັ້ນຕອນການຍົກລະດັບນີ້.';
$string['privacy:metadata:upgrade_log:plugin'] = 'ປລັກອິນທີ່ຖືກຍົກລະດັບ.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'ສະບັບໃໝ່ເພື່ອຍົກລະດັບເປັນ.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'ເວລາທີ່ການຍົກລະດັບໄດ້ເກີດຂຶ້ນ.';
$string['privacy:metadata:upgrade_log:type'] = 'ປະເພດຂອງການເຂົ້າບັນທຶກ.';
$string['privacy:metadata:upgrade_log:userid'] = 'ຜູ້ໃຊ້ທີ່ດຳເນີນການຍົກລະດັບ.';
$string['privacy:metadata:upgrade_log:version'] = 'ເວີຊັນເກົ່າຂອງປລັກອິນ.';
$string['private_files_handler'] = 'ເກັບຮັກສາໄຟລ໌ແນບໃສ່ກັບອີເມລໃນພື້ນທີ່ຈັດເກັບໄຟລ໌ສ່ວນຕົວຂອງຜູ້ໃຊ້.';
$string['private_files_handler_name'] = 'ສົ່ງອີເມວຫາໄຟລ໌ສ່ວນຕົວ';
$string['privatefiles'] = 'ໄຟລ໌ສ່ວນຕົວ';
$string['privatefilesmanage'] = 'ຈັດການໄຟລ໌ສ່ວນຕົວ';
$string['proceed'] = 'ດຳເນີນການ';
$string['profile'] = 'ໂປຼໄຟລ໌';
$string['profilenotshown'] = 'ລາຍລະອຽດໂປຣໄຟລ໌ນີ້ຈະບໍ່ຖືກສະແດງຈົນກ່ວາບຸກຄົນນີ້ໄດ້ລົງທະບຽນຢູ່ໃນຢ່າງໜ້ອຍໜຶ່ງວິຊາ.';
$string['publicprofile'] = 'ໂປຣໄຟລ໌ສາທາລະນະ';
$string['publicsitefileswarning'] = 'ໝາຍເຫດ: ໄຟລ໌ທີ່ຕັ້ງຢູ່ນີ້ສາມາດເຂົ້າຫາໄດ້ໂດຍທຸກຄົນ';
$string['publicsitefileswarning2'] = 'ໝາຍເຫດ: ໄຟລ໌ທີ່ຕັ້ງຢູ່ບ່ອນນີ້ສາມາດເຂົ້າຫາໄດ້ໂດຍທຸກຄົນທີ່ຮູ້ຈັກ (ຫຼື ສາມາດເດົາ) URL ໄດ້. ສໍາລັບເຫດຜົນດ້ານຄວາມປອດໄພ, ແນະນໍາໃຫ້ໄຟລ໌ສໍາຮອງຂໍ້ມູນໃດໜຶ່ງຖືກລຶບອອກທັນທີຫຼັງຈາກມີການກູ້ພວກມັນຄືນມາ.';
$string['publicsitefileswarning3'] = 'ໝາຍເຫດ: ໄຟລ໌ທີ່ຕັ້ງຢູ່ບ່ອນນີ້ສາມາດເຂົ້າຫາໄດ້ໂດຍທຸກຄົນທີ່ຮູ້ຈັກ (ຫຼື ສາມາດເດົາ) URL ໄດ້. <br />ສໍາລັບເຫດຜົນດ້ານຄວາມປອດໄພ, ໄຟລ໌ສໍາຮອງຂໍ້ມູນຄວນຖືກບັນທຶກໄວ້ຢູ່ໃນໂຟເດີ backupdata ທີ່ປອດໄພເທົ່ານັ້ນ.';
$string['question'] = 'ຄຳຖາມ';
$string['questionsinthequestionbank'] = 'ຄໍາຖາມຢູ່ໃນທະນາຄານຄໍາຖາມ';
$string['queued'] = 'ເຂົ້າຄິວແລ້ວ';
$string['quotausage'] = 'ປະຈຸບັນທ່ານໄດ້ໃຊ້ {$a->used} ຈາກຂີດຈໍາກັດ {$a->total} ຂອງທ່ານ.';
$string['readinginfofrombackup'] = 'ອ່ານຂໍ້ມູນຈາກການສໍາຮອງຂໍ້ມູນ';
$string['readme'] = 'ອ່ານ';
$string['recentactivity'] = 'ກິດຈະກໍາບໍ່ດົນມານີ້';
$string['recentactivityreport'] = 'ລາຍງານສະບັບເຕັມຂອງກິດຈະກໍາບໍ່ດົນມານີ້...';
$string['recipientslist'] = 'ລາຍຊື່ຜູ້ຮັບ';
$string['recommended'] = 'ແນະນໍາ';
$string['recreatedcategory'] = 'ປະເພດທີ່ສ້າງຄືນໃໝ່ {$a}';
$string['redirect'] = 'ປ່ຽນເສັ້ນທາງ';
$string['reducesections'] = 'ຫຼຸດຈຳນວນພາກ';
$string['refresh'] = 'ໂຫຼດຄືນໃໝ່';
$string['refreshingevents'] = 'ໂຫຼດເຫດການຄືນໃໝ່';
$string['registration'] = 'ການລົງທະບຽນ Moodle';
$string['registrationcontact'] = 'ລາຍຊື່ຕິດຕໍ່ຈາກສາທາລະ';
$string['registrationcontactno'] = 'ບໍ່, ຂ້ອຍບໍ່ຕ້ອງການຕິດຕໍ່ຫາຄົນອື່ນ';
$string['registrationcontactyes'] = 'ແມ່ນແລ້ວ, ປະກອບແບບຟອມໃຫ້ກັບ Moodlers ຄົນອື່ນໆເພື່ອຕິດຕໍ່ຫາຂ້ອຍ';
$string['registrationemail'] = 'ແຈ້ງເຕືອນອີເມລ';
$string['registrationinfo'] = '<p>ໜ້ານີ້ອະນຸຍາດໃຫ້ເຈົ້າລົງທະບຽນເວັບໄຊທ໌ Moodle ຂອງເຈົ້າກັບ moodle.org. ການລົງທະບຽນແມ່ນບໍ່ເສຍຄ່າ.
ຜົນປະໂຫຍດຕົ້ນຕໍຂອງການລົງທະບຽນແມ່ນວ່າ ເຈົ້າຈະຖືກເພີ່ມເຂົ້າໃນບັນຊີລາຍຊື່ທາງໄປສະນີໃນລະດັບສຽງຕໍ່າ
ສຳລັບການແຈ້ງເຕືອນທີ່ສຳຄັນເຊັ່ນ: ການເຕືອນຄວາມປອດໄພແລະ ການປ່ອຍໃໝ່ຂອງ Moodle.</p>
<p>ໂດຍຄ່າເລີ່ມຕົ້ນ, ຂໍ້ມູນຂອງທ່ານຈະຖືກເກັບຮັກສາເປັນສ່ວນຕົວ, ແລະ ຈະບໍ່ຖືກຂາຍ ຫຼື ສົ່ງຕໍ່ໃຫ້ຜູ້ອື່ນອີກ.
    ເຫດຜົນສໍາລັບການເກັບກໍາຂໍ້ມູນນີ້ແມ່ນເພື່ອຈຸດປະສົງສະ ໜັບສະໜູນ, ແລະ ເພື່ອຊ່ວຍສ້າງສະຖິຕິ
    ຮູບຂອງຊຸມຊົນ Moodle ທັງໝົດເທົ່ານັ້ນ. </p>
<p>ຖ້າເຈົ້າເລືອກ, ເຈົ້າສາມາດອະນຸຍາດໃຫ້ເພີ່ມຊື່ເວັບໄຊທ໌, ປະເທດ ແລະ URL ຂອງເຈົ້າໃສ່ໃນລາຍຊື່ສາທາລະນະຂອງ Moodle Sites. </p>
<p> ການລົງທະບຽນໃໝ່ທັງໝົດຖືກກວດສອບດ້ວຍຕົນເອງກ່ອນທີ່ມັນຈະຖືກເພີ່ມເຂົ້າໃນບັນຊີ, ແຕ່ເມື່ອທ່ານຖືກເພີ່ມເຂົ້າໄປ, ທ່ານສາມາດອັບເດດການລົງທະບຽນຂອງທ່ານ (ແລະ ລາຍການຂອງທ່ານຢູ່ໃນລາຍຊື່ສາທາລະນະ) ໄດ້ທຸກເວລາໂດຍການສົ່ງແບບຟອມນີ້ຄືນໃໝ່. </p>';
$string['registrationinfotitle'] = 'ຂໍ້ມູນການລົງທະບຽນ';
$string['registrationno'] = 'ບໍ່, ຂ້ອຍບໍ່ຕ້ອງການຮັບອີເມລໃດໆ';
$string['registrationsend'] = 'ສົ່ງຂໍ້ມູນການລົງທະບຽນໄປທີ່ moodle.org';
$string['registrationyes'] = 'ແມ່ນແລ້ວ, ແຈ້ງເຕືອນຂ້ອຍກ່ຽວກັບການອອກໃໝ່ຂອງ Moodle, ການແຈ້ງເຕືອນຄວາມປອດໄພ ແລະ ຂ່າວສໍາຄັນອື່ນໆ';
$string['reject'] = 'ປະຕິເສດ';
$string['rejectdots'] = 'ປະຕິເສດ...';
$string['relativedatesmode'] = 'ໂໝດວັນທີທີ່ກ່ຽວຂ້ອງ';
$string['relativedatesmode_help'] = 'ສະແດງວັນທີຂອງວິຊາ ຫຼື ກິດຈະກໍາທີ່ກ່ຽວຂ້ອງກັບວັນທີເລີ່ມຕົ້ນຂອງຜູ້ໃຊ້ໃນວິຊາ.

ວັນທີເລີ່ມວິຊາຂອງຜູ້ໃຊ້ຈະເປັນວັນເລີ່ມລົງທະບຽນຂອງເຂົາເຈົ້າ, ເວັ້ນເສຍແຕ່ເຂົາເຈົ້າໄດ້ລົງທະບຽນກ່ອນວິຊາເລີ່ມຕົ້ນ ເຊິ່ງໃນກໍລະນີນີ້ ວັນທີເລີ່ມຕົ້ນຂອງເຂົາເຈົ້າຈະເປັນວັນທີເລີ່ມຕົ້ນຂອງວິຊາ.

ຄຳເຕືອນ: ອັນນີ້ເປັນຄຸນສົມບັດທົດລອງ ແລະ ບໍ່ແມ່ນທຸກກິດຈະກຳອາດຈະຮອງຮັບມັນ. ເມື່ອຫຼັກສູດໄດ້ຖືກສ້າງຂຶ້ນ, ການຕັ້ງວິຊານີ້ບໍ່ສາມາດປ່ຽນແປງໄດ້ອີກຕໍ່ໄປ.';
$string['relativedatesmode_warning'] = '<strong>ຄຳເຕືອນ:</strong>ບໍ່ສາມາດປ່ຽນຮູບແບບວັນທີທີ່ກ່ຽວຂ້ອງໄດ້ເມື່ອສ້າງວິຊາແລ້ວ.';
$string['reload'] = 'ໂຫຼດຄືນໃໝ່';
$string['remoteappuser'] = 'ຜູ້ໃຊ້ {$a} ທາງໄກ';
$string['remove'] = 'ຍ້າຍ';
$string['removeadmin'] = 'ລຶບຜູ້ເບິ່ງແຍງລະບົບອອກ';
$string['removecreator'] = 'ລຶບຜູ້ສ້າງວິຊາອອກ';
$string['removestudent'] = 'ລຶບນັກຮຽນອອກ';
$string['removeteacher'] = 'ລຶບຄູສອນອອກ';
$string['rename'] = 'ປ່ຽນຊື່';
$string['renamefileto'] = 'ປ່ຽນຊື່ <b>{$a}</b> to';
$string['report'] = 'ລາຍງານ';
$string['reports'] = 'ບັນດາລາຍງານ';
$string['reporttype'] = 'ປະເພດລາຍງານ';
$string['repositories'] = 'ບ່ອນຈັດເກັບ';
$string['requestcourse'] = 'ຮຽກຮ້ອງວິຊາ';
$string['requestedby'] = 'ຮຽກຮ້ອງໂດຍ';
$string['requestedcourses'] = 'ຮຽກຮ້ອງວິຊາແລ້ວ';
$string['requestreason'] = 'ເຫດຜົນສຳລັບການຮຽກຮ້ອງ';
$string['requests'] = 'ການຮຽກຮ້ອງຕ່າງໆ';
$string['required'] = 'ຈຳເປັນ';
$string['requirespayment'] = 'ວິຊານີ້ຈຳເປັນຕ້ອງຊຳລະສຳລັບການເຂົ້າເຖິງ';
$string['resendemail'] = 'ສົ່ງອີເມລຄືນໃໝ່';
$string['reset'] = 'ການຕັ້ງຄ່າຄືນໃໝ່';
$string['resetcomponent'] = 'ອົງປະກອບ';
$string['resetcourse'] = 'ການຕັ້ງຄ່າວິຊາຄືນໃໝ່';
$string['resetinfo'] = 'ໜ້ານີ້ອະນຸຍາດໃຫ້ທ່ານລ້າງຫຼັກສູດຂອງຂໍ້ມູນຜູ້ໃຊ້, ໃນຂະນະທີ່ຮັກສາກິດຈະກໍາ ແລະ ການຕັ້ງຄ່າອື່ນ. ກະລຸນາຮັບຊາບວ່າໂດຍການເລືອກລາຍການຢູ່ລຸ່ມນີ້ ແລະ ສົ່ງ ໜ້ານີ້, ທ່ານຈະລຶບຂໍ້ມູນຜູ້ໃຊ້ທີ່ທ່ານເລືອກອອກຈາກຫຼັກສູດນີ້ຕະຫຼອດໄປ!';
$string['resetnotimplemented'] = 'ການຕັ້ງຄ່າຄືນໃໝ່ຍັງບໍ່ໄດ້ປະຕິບັດ';
$string['resetrecordexpired'] = 'ລິ້ງການຕັ້ງຄ່າລະຫັດຜ່ານຄືນໃໝ່ ທີ່ທ່ານໃຊ້ນັ້ນຍາວກວ່າ {$a} ນາທີ ແລະ ໝົດອາຍຸແລ້ວ. ກະລຸນາລິເລີ່ມການຕັ້ງຄ່າລະຫັດຜ່ານຄືນໃໝ່.';
$string['resetstartdate'] = 'ຕັ້ງຄ່າວັນທີເລີ່ມຕົ້ນຄືນໃໝ່';
$string['resetstatus'] = 'ສະຖານະ';
$string['resettable'] = 'ຕັ້ງຄ່າການຕັ້ງຄ່າຕາຕະລາງຄືນໃໝ່';
$string['resettask'] = 'ໜ້າວຽກ';
$string['resettodefaults'] = 'ຕັ້ງຄ່າຄືນໃໝ່ເປັນຄ່າເລີ່ມຕົ້ນ';
$string['resortcourses'] = 'ຈັດຮຽງວິຊາ';
$string['resortsubcategoriesby'] = 'ຈັດຮຽງປະເພດຍ່ອຍຕາມ {$a} ນ້ອຍຫາໃຫຍ່';
$string['resortsubcategoriesbyreverse'] = 'ຈັດຮຽງປະເພດຍ່ອຍຕາມ {$a} ໃຫຍ່ຫານ້ອຍ';
$string['resource'] = 'ແຫຼ່ງຂໍ້ມູນ';
$string['resourcedisplayauto'] = 'ອັດຕະໂນມັດ';
$string['resourcedisplaydownload'] = 'ບັງຄັບດາວໂຫຼດ';
$string['resourcedisplayembed'] = 'ຝັງ';
$string['resourcedisplayframe'] = 'ໃນຂອບ';
$string['resourcedisplaynew'] = 'ປ່ອງຢ້ຽມໃໝ່';
$string['resourcedisplayopen'] = 'ເປີດ';
$string['resourcedisplaypopup'] = 'ໃນໜ້າລອຍຂື້ນ';
$string['resources'] = 'ແຫຼ່ງຂໍ້ມູນຕ່າງໆ';
$string['resources_help'] = 'ປະເພດແຫຼ່ງຂໍ້ມູນເຮັດໃຫ້ເກືອບທຸກປະເພດຂອງເນື້ອຫາເວັບສາມາດຖືກໃສ່ເຂົ້າໃນວິຊາ.';
$string['restore'] = 'ກູ້ຄືນ';
$string['restorecancelled'] = 'ຍົກເລີກການກູ້ຄືນ';
$string['restorecannotassignroles'] = 'ການກູ້ຄືນຕ້ອງການມອບໝາຍໜ້າທີ່ ແລະ ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເຮັດແນວນັ້ນ';
$string['restorecannotcreateorassignroles'] = 'ການກູ້ຄືນຕ້ອງການສ້າງ ຫຼື ມອບໝາຍ ໜ້າທີ່ ແລະ ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເຮັດແນວນັ້ນ';
$string['restorecannotcreateuser'] = 'ການກູ້ຄືນຕ້ອງການສ້າງຜູ້ໃຊ້ \'{$a}\' ຈາກໄຟລ໌ສຳຮອງ ແລະ ເຈົ້າບໍ່ມີການອະນຸຍາດໃຫ້ເຮັດແນວນັ້ນ';
$string['restorecannotoverrideperms'] = 'ການກູ້ຄືນຕ້ອງການລົບລ້າງການອະນຸຍາດ ແລະ ທ່ານບໍ່ມີການອະນຸຍາດໃຫ້ເຮັດແນວນັ້ນ';
$string['restorecoursenow'] = 'ກູ້ຄືນວິຊາດຽວນີ້!';
$string['restoredaccount'] = 'ກູ້ຄືນບັນຊີ';
$string['restoredaccountinfo'] = 'ບັນຊີນີ້ຖືກນໍາເຂົ້າມາຈາກເຊີບເວີອື່ນ ແລະ ລະຫັດຜ່ານໄດ້ສູນເສຍໄປ. ເພື່ອຕັ້ງລະຫັດຜ່ານໃໝ່ທາງອີເມລ, ກະລຸນາຄລິກ "ສືບຕໍ່"';
$string['restorefinished'] = 'ການກູ້ຄືນສຳເລັດແລ້ວ';
$string['restoremnethostidmismatch'] = 'ID ແມ່ຂ່າຍ MNet ຂອງຜູ້ໃຊ້  \'{$a}\' ບໍ່ກົງກັບ ID ແມ່ຂ່າຍ MNet ທ້ອງຖິ່ນ.';
$string['restoreto'] = 'ກູ້ຄືນຫາ';
$string['restoretositeadding'] = 'ຄຳເຕືອນ: ທ່ານກຳລັງຈະກູ້ຄືນສູ່ໜ້າຫຼັກເວັບໄຊທ໌, ເພີ່ມຂໍ້ມູນໃສ່ໃນນັ້ນ!';
$string['restoretositedeleting'] = 'ຄຳເຕືອນ: ທ່ານກຳລັງຈະກູ້ຄືນສູ່ໜ້າຫຼັກເວັບໄຊທ໌, ລຶບຂໍ້ມູນໃສ່ໃນນັ້ນ!';
$string['restoreuserconflict'] = 'ພະຍາຍາມກູ້ຄືນຜູ້ໃຊ້ \'{$a}\' ຈາກໄຟລ໌ສໍາຮອງຈະເຮັດໃຫ້ເກີດຄວາມຂັດແຍ້ງກັນ';
$string['restoreuserinfofailed'] = 'ຂະບວນການກູ້ຄືນໄດ້ຢຸດລົງເພາະວ່າເຈົ້າບໍ່ມີການອະນຸຍາດກູ້ຄືນຂໍ້ມູນຜູ້ໃຊ້.';
$string['restoreusersprecheck'] = 'ກຳລັງກວດເບິ່ງຂໍ້ມູນຜູ້ໃຊ້';
$string['restoreusersprecheckerror'] = 'ກວດພົບບາງບັນຫາເມື່ອກວດສອບຂໍ້ມູນຜູ້ໃຊ້';
$string['restricted'] = 'ຂໍ້ຈຳກັດ';
$string['resultsfound'] = 'ພົບ {$a} ຜົນການຊອກຫາ';
$string['retry'] = 'ລອງໃໝ່';
$string['returningtosite'] = 'ກັບມາທີ່ເວັບໄຊຕ໌ນີ້?';
$string['returntooriginaluser'] = 'ກັບຄືນຫາ {$a}';
$string['revert'] = 'ຫັນກັບໄປ';
$string['role'] = 'ໜ້າທີ່';
$string['roleassignments'] = 'ການມອບໝາຍໜ້າທີ່';
$string['rolemappings'] = 'ການຈັດແຜນທີ່ບົດບາດ';
$string['rolerenaming'] = 'ປ່ຽນຊື່ໜ້າທີ່';
$string['rolerenaming_help'] = 'ການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ສະແດງຊື່ສໍາລັບບົດບາດທີ່ນໍາໃຊ້ໃນວິຊາທີ່ຈະຖືກປ່ຽນແປງ. ມີພຽງແຕ່ຊື່ທີ່ສະແດງເທົ່ານັ້ນຖືກປ່ຽນ - ການອະນຸຍາດໜ້າທີ່ບໍ່ໄດ້ຮັບຜົນກະທົບ. ຊື່ໜ້າທີ່ໃໝ່ຈະປະກົດຂຶ້ນຢູ່ໃນໜ້າຜູ້ເຂົ້າຮ່ວມວິຊາ ແລະ ບ່ອນອື່ນຢູ່ພາຍໃນວິຊາ. ຖ້າການປ່ຽນຊື່ໜ້າທີ່ແມ່ນໜ້າທີ່ທີ່ຜູ້ດູແລລະບົບໄດ້ເລືອກເປັນໜ້າທີ່ຂອງຜູ້ຈັດການຫຼັກສູດ, ຈາກນັ້ນຊື່ໜ້າທີ່ໃໝ່ຈະປາກົດເປັນສ່ວນໜຶ່ງຂອງລາຍການວິຊາ.';
$string['roles'] = 'ໜ້າທີ່ຕ່າງໆ';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'ຈຳນວນຂອງບົດຄວາມ RSS ຫຼ້າສຸດ';
$string['rsserror'] = 'ເກີດຄວາມຜິດພາດໃນການອ່ານຂໍ້ມູນ RSS';
$string['rsserrorauth'] = 'ລິ້ງ RSS ຂອງທ່ານບໍ່ມີໂທເຄັນການກວດສອບທີ່ຖືກຕ້ອງ.';
$string['rsserrorguest'] = 'ຟີດນີ້ໃຊ້ການເຂົ້າເຖິງຂອງແຂກເພື່ອເຂົ້າຫາຂໍ້ມູນ, ແຕ່ແຂກບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ອ່ານຂໍ້ມູນ. ໄປທີ່ສະຖານທີ່ເດີມທີ່ຟີດນີ້ມາຈາກ (URL) ເປັນຜູ້ໃຊ້ທີ່ຖືກຕ້ອງ ແລະ ເອົາລິ້ງ RSS ໃໝ່ຈາກບ່ອນນັ້ນ.';
$string['rsskeyshelp'] = '<p>ເພື່ອຮັບປະກັນຄວາມປອດໄພ ແລະ ຄວາມເປັນສ່ວນຕົວ, URL ຂອງ ຟີດ RSS ມີໂທເຄັນພິເສດ ທີ່ລະບຸຜູ້ໃຊ້ທີ່ເຂົາເຈົ້າເປັນສໍາລັບ. ອັນນີ້ປ້ອງກັນບໍ່ໃຫ້ຜູ້ໃຊ້ອື່ນເຂົ້າຫາພື້ນທີ່ຂອງເວັບໄຊທ໌ ບ່ອນທີ່ເຂົາເຈົ້າບໍ່ໄດ້ຮັບອະນຸຍາດ.</p><p>ໂທເຄັນຖືກສ້າງໂດຍອັດຕະໂນມັດຄັ້ງທໍາອິດທີ່ທ່ານເຂົ້າຫາພື້ນທີ່ທີ່ຟີດ RSS. ຖ້າເຈົ້າຄິດວ່າ ໂທເຄັນຟີດ RSS ຂອງທ່ານໄດ້ຖືກບຸກລຸກ, ເຈົ້າສາມາດຮ້ອງຂໍເອົາອັນໃໝ່ໄດ້ໂດຍການຄລິກທີ່ລິ້ງເຊື່ອມຕໍ່ຄືນໃໝ່. ກະລຸນາຮັບຊາບວ່າ URL ຂອງ ຟີດ RSS ປັດຈຸບັນຂອງທ່ານຈະບໍ່ຖືກຕ້ອງ. </p>';
$string['rsstype'] = 'ຟີດ RSS ສຳລັບກິດຈະກຳນີ້';
$string['save'] = 'ບັນທຶກ';
$string['saveandnext'] = 'ບັນທຶກ ແລະ ສະແດງຕໍ່ໄປ';
$string['savechanges'] = 'ບັນທຶກການປ່ຽນແປງ';
$string['savechangesanddisplay'] = 'ບັນທຶກ ແລະ ສະແດງ';
$string['savechangesandreturn'] = 'ບັນທຶກ ແລະ ສົ່ງຄືນ';
$string['savechangesandreturntocourse'] = 'ບັນທຶກ ແລະ ກັບຄືນຫາວິຊາ';
$string['savecomment'] = 'ບັນທຶກຄຳເຫັນ';
$string['savedat'] = 'ບັນທຶກໄວ້ທີ່:';
$string['savepreferences'] = 'ບັນທຶກການຕັ້ງຄ່າ';
$string['saveto'] = 'ບັນທຶກໄວ້ທີ່';
$string['scale'] = 'ມາດວັດ';
$string['scale_help'] = 'ມາດວັດໃຫ້ວິທີການປະເມີນຜົນ ຫຼື ການໃຫ້ຄະແນນຜົນງານຢູ່ໃນກິດຈະກຳໃດໜຶ່ງ. ມັນຖືກກຳນົດໂດຍບັນຊີລາຍຊື່ຕາມ ລຳດັບ, ຕັ້ງແຕ່ລົບໄປຫາບວກ, ແຍກດ້ວຍໝາຍຈຸດ, ຕົວຢ່າງ "ຜິດຫວັງ, ບໍ່ດີພໍ, ສະເລ່ຍ, ດີ, ດີຫຼາຍ, ດີເລີດ!"';
$string['scales'] = 'ມາດວັດ';
$string['scalescustom'] = 'ມາດວັດແບບກຳນົດເອງ';
$string['scalescustomcreate'] = 'ເພີ່ມມາດວັດໃໝ່';
$string['scalescustomno'] = 'ຍັງບໍ່ໄດ້ສ້າງມາດວັດແບບກຳນົດເອງເທື່ອ';
$string['scalesstandard'] = 'ມາດວັດມາດຕະຖານ';
$string['scalestandard'] = 'ມາດວັດມາດຕະຖານ';
$string['scalestandard_help'] = 'ມາດວັດມາດຕະຖານມີໃຫ້ບໍລິການໃນທົ່ວເວັບ, ສໍາລັບທຸກວິຊາ.';
$string['scalestip'] = 'ເພື່ອສ້າງມາດວັດແບບກຳນົດເອງ, ໃຫ້ໃຊ້ລິ້ງ \'ມາດວັດ... \' ຢູ່ໃນເມນູການບໍລິຫານວິຊາຂອງທ່ານ.';
$string['scalestip2'] = 'ເພື່ອສ້າງມາດວັດແບບກຳນົດເອງ, ຄລິກທີ່ລິ້ງຊັ້ນໃນເມນູການບໍລິຫານວິຊາ, ຈາກນັ້ນເລືອກແກ້ໄຂ, ມາດວັດ.';
$string['schedule'] = 'ກຳນົດເວລາ';
$string['screenshot'] = 'ຈັບພາບໜ້າຈໍ';
$string['search'] = 'ຄົ້ນຫາ';
$string['search_help'] = 'ສຳລັບການຄົ້ນຫາພື້ນຖານຂອງຄຳສັບໜຶ່ງ ຫຼື ຫຼາຍຄຳສັບ ທຸກໆບ່ອນຢູ່ໃນຂໍ້ຄວາມ, ພຽງແຕ່ພິມພວກມັນດ້ວຍການຍະຫວ່າງ. ທຸກຄຳສັບທີ່ຍາວກວ່າສອງຕົວອັກສອນແມ່ນຖືກໃຊ້.

ສໍາລັບການຄົ້ນຫາຂັ້ນສູງ, ກົດປຸ່ມຄົ້ນຫາໂດຍບໍ່ຕ້ອງພິມອັນໃດໃສ່ໃນປ່ອງຄົ້ນຫາເພື່ອເຂົ້າຫາແບບຟອມການຄົ້ນຫາຂັ້ນສູງ.';
$string['searchactivities'] = 'ຄົ້ນຫາກິດຈະກໍາຕາມຊື່ ຫຼື ລາຍລະອຽດ';
$string['searchagain'] = 'ຄົ້ນຫາອີກຄັ້ງ';
$string['searchbyemail'] = 'ຄົ້ນຫາໂດຍທີ່ຢູ່ອີເມລ';
$string['searchbyusername'] = 'ຄົ້ນຫາໂດຍຊື່ຜູ້ໃຊ້';
$string['searchcoursecategories'] = 'ບັນດາປະເພດການຄົ້ນຫາ';
$string['searchcourses'] = 'ວິຊາຄົ້ນຫາ';
$string['searchoptions'] = 'ທາງເລືອກຄົ້ນຫາ';
$string['searchresults'] = 'ຜົນການຄົ້ນຫາ';
$string['sec'] = 'ວິນາທີ';
$string['seconds'] = 'ວິນາທີ';
$string['secondsleft'] = '{$a} ວິນາທີ';
$string['secondstotime172800'] = '2 ວັນ';
$string['secondstotime259200'] = '3 ວັນ';
$string['secondstotime345600'] = '4 ວັນ';
$string['secondstotime432000'] = '5 ວັນ';
$string['secondstotime518400'] = '6 ວັນ';
$string['secondstotime604800'] = '1 ອາທິດ';
$string['secondstotime86400'] = '1 ວັນ';
$string['secretalreadyused'] = 'ລິ້ງຢືນຢັນການປ່ຽນລະຫັດຜ່ານຖືກໃຊ້ແລ້ວ, ລະຫັດຜ່ານບໍ່ໄດ້ຖືກປ່ຽນ.';
$string['secs'] = 'ວິນາທີ';
$string['section'] = 'ພາກ';
$string['sectionactionnotsupported'] = 'ບໍ່ຮອງຮັບພາກປະຕິບັດ "{$a}" ຢູ່ບ່ອນນີ້';
$string['sectionname'] = 'ຊື່ພາກ';
$string['sections'] = 'ພາກຕ່າງໆ';
$string['seealsostats'] = 'ເບິ່ງຕື່ມອີກ: ສະຖິຕິ';
$string['selctauser'] = 'ເລືອກຜູ້ໃຊ້';
$string['select'] = 'ເລືອກ';
$string['selectacategory'] = 'ກະລຸນາເລືອກປະເພດ';
$string['selectacountry'] = 'ເລືອກປະເທດ';
$string['selectacourse'] = 'ເລືອກວິຊາ';
$string['selectacoursesite'] = 'ເລືອກວິຊາ ຫຼື ເວັບໄຊທ໌';
$string['selectagroup'] = 'ເລືອກກຸ່ມ';
$string['selectall'] = 'ເລືອກທັງໝົດ';
$string['selectallusersonpage'] = 'ເລືອກຜູ້ໃຊ້ທັງໝົດໃນໜ້ານີ້';
$string['selectalluserswithcount'] = 'ເລືອກຜູ້ໃຊ້ {$a} ທັງໝົດ';
$string['selectamodule'] = 'ກະລຸນາເລືອກຊຸດກິດຈະກຳ';
$string['selectanaction'] = 'ເລືອກຄຳສັ່ງ';
$string['selectanoptions'] = 'ເລືອກທາງເລືອກ';
$string['selectaregion'] = 'ເລືອກພື້ນທີ່';
$string['selectcategorysort'] = 'ປະເພດໃດທີ່ທ່ານຢາກຈະຈັດລຽງ?';
$string['selectcategorysortby'] = 'ເລືອກວິທີທີ່ທ່ານຕ້ອງການຈັດຮຽງປະເພດຕ່າງໆ';
$string['selectcoursesortby'] = 'ເລືອກວິທີທີ່ທ່ານຕ້ອງການຈັດຮຽງວິຊາ';
$string['selectdefault'] = 'ເລືອກຄ່າເລີ່ມຕົ້ນ';
$string['selectedcategories'] = 'ປະເພດທີ່ເລືອກ';
$string['selectedfile'] = 'ໄຟລ໌ທີ່ເລືອກ';
$string['selectednowmove'] = 'ໄຟລ໌ {$a} ທີ່ເລືອກເພື່ອຍ້າຍ. ດຽວນີ້ເຂົ້າໄປໃນໂຟນເດີປາຍທາງ ແລະ ກົດ \'ຍ້າຍໄຟລ໌ມາທີ່ນີ້\'';
$string['selectfiles'] = 'ເລືອກໄຟລ໌';
$string['selectitem'] = 'ເລືອກ \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'ເລືອກກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນເພື່ອເບິ່ງການຊ່ວຍເຫຼືອຂອງມັນ.

ຄລິກສອງເທື່ອໃສ່ຊື່ກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນໃດໜຶ່ງເພື່ອເພີ່ມມັນໄດ້ໄວ.';
$string['selectnos'] = 'ເລືອກທັງໝົດ \'ບໍ່\'';
$string['selectperiod'] = 'ເລືອກໄລຍະ';
$string['senddetails'] = 'ສົ່ງລາຍລະອຽດຂອງຂ້ອຍຜ່ານອີເມລ';
$string['separate'] = 'ແຍກ';
$string['separateandconnected'] = 'ວິທີທີ່ຮູ້ຈັກແຍກອອກ ແລະ ເຊື່ອມຕໍ່';
$string['separateandconnectedinfo'] = 'ມາດວັດທີ່ອີງໃສ່ທິດສະດີຄວາມຮູ້ທີ່ແຍກຕ່າງຫາກ ແລະ ເຊື່ອມຕໍ່ກັນ. ທິດສະດີນີ້ອະທິບາຍສອງວິທີທີ່ແຕກຕ່າງກັນທີ່ພວກເຮົາສາມາດປະເມີນ ແລະ ຮຽນຮູ້ກ່ຽວກັບສິ່ງທີ່ພວກເຮົາເຫັນ ແລະ ໄດ້ຍິນ.<ul><li><strong>ຜູ້ຮູ້ແຍກຕ່າງຫາກ</strong>ຍັງຄົງໄວ້ດ້ວຍຈຸດປະສົງເທົ່າທີ່ເປັນໄປໄດ້ໂດຍບໍ່ລວມເອົາຄວາມຮູ້ສຶກ ແລະ ອາລົມ. ໃນການສົນທະນາກັບຄົນອື່ນ, ເຂົາເຈົ້າມັກປ້ອງກັນຄວາມຄິດຂອງຕົນເອງ, ໃຊ້ເຫດຜົນເພື່ອຊອກຫາຄວາມຄິດຂອງຄູ່ແຂ່ງ.</li><li><strong>ຜູ້ຮູ້ທີ່ເຊື່ອມຕໍ່</strong>ມີຄວາມອ່ອນໄຫວກັບຄົນອື່ນຫຼາຍຂຶ້ນ. ເຂົາເຈົ້າມີຄວາມຊໍານິຊໍານານໃນການໃຫ້ຄວາມເຫັນອົກເຫັນໃຈ ແລະ ມີແນວໂນ້ມທີ່ຈະຟັງ ແລະ ຖາມຄໍາຖາມຈົນກວ່າເຂົາເຈົ້າຮູ້ສຶກວ່າເຂົາເຈົ້າສາມາດເຊື່ອມຕໍ່ແລະ “ເຂົ້າໃຈສິ່ງຕ່າງໆຈາກທັດສະນະຂອງເຂົາເຈົ້າ”. ເຂົາເຈົ້າຮຽນຮູ້ໂດຍການພະຍາຍາມແບ່ງປັນປະສົບການທີ່ນຳໄປສູ່ຄວາມຮູ້ທີ່ເຂົາເຈົ້າພົບຢູ່ໃນຄົນອື່ນ.</li></ul>';
$string['servererror'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນຂະນະທີ່ກຳລັງສື່ສານກັບເຊີບເວີ';
$string['serverlocaltime'] = 'ເວລາທ້ອງຖິ່ນຂອງເຊີບເວີ';
$string['sessionforceclean'] = 'ເພື່ອເປັນການປ້ອງກັນລ່ວງໜ້າດ້ານຄວາມປອດໄພ, ສະຄຣິບທີ່ສ້າງຂຶ້ນໂດຍຜູ້ໃຊ້ໄດ້ຖືກປິດການນຳ ໃຊ້ພາຍຊ່ວງເວລານີ້.';
$string['sessiontimeoutsoon'] = 'ຊ່ວງເວລາຂອງທ່ານໃກ້ຈະໝົດເວລາແລ້ວ. ທ່ານຕ້ອງການຂະຫຍາຍຊ່ວງເວລາປະຈຸບັນຂອງທ່ານບໍ?';
$string['setcategorytheme'] = 'ຮູບແບບສີສັນຊຸດປະເພດ';
$string['setmode'] = 'ໂໝດຕັ້ງຄ່າ';
$string['setpassword'] = 'ຕັ້ງຄ່າລະຫັດຜ່ານ';
$string['setpasswordinstructions'] = 'ກະລຸນາໃສ່ລະຫັດຜ່ານໃໝ່ຂອງທ່ານຢູ່ລຸ່ມນີ້, ຈາກນັ້ນບັນທຶກການປ່ຽນແປງ.';
$string['settings'] = 'ການຕັ້ງຄ່າ';
$string['shortname'] = 'ຊື່ສັ້ນ';
$string['shortnamecollisionwarning'] = '[*] = ຊື່ຫຍໍ້ນີ້ໄດ້ຖືກໃຊ້ຢູ່ໃນຫຼັກສູດແລ້ວ ແລະ ຈະຕ້ອງໄດ້ມີການປ່ຽນແປງເມື່ອໄດ້ຮັບການອະນຸມັດ';
$string['shortnamecourse'] = 'ຊື່ສັ້ນຂອງວິຊາ';
$string['shortnamecourse_help'] = 'ຊື່ສັ້ນຂອງວິຊາແມ່ນສະແດງຢູ່ໃນການນຳທາງ ແລະ ຖືກໃຊ້ຢູ່ໃນແຖວຫົວຂໍ້ຂອງຂໍ້ຄວາມອີເມລຂອງວິຊາ.';
$string['shortnametaken'] = 'ຊື່ສັ້ນຖືກໃຊ້ສໍາລັບຫຼັກສູດອື່ນຢູ່ກ່ອນແລ້ວ ({$a})';
$string['shortnameuser'] = 'ຊື່ສັ້ນຜູ້ໃຊ້';
$string['shortsitename'] = 'ຊື່ສັ້ນສຳລັບເວັບໄຊທ໌ (ຕົວຢ່າງ: ຄຳສັບດ່ຽວ)';
$string['show'] = 'ສະແດງ';
$string['showactions'] = 'ສະແດງຄຳສັ່ງ';
$string['showactivitydates'] = 'ສະແດງວັນທີກິດຈະກຳ';
$string['showactivitydates_help'] = 'ວັນທີຂອງກິດຈະກໍາແມ່ນສະແດງຢູ່ໃນໜ້າກິດຈະກໍາສະເໜີ. ການຕັ້ງຄ່ານີ້ກໍານົດວ່າຈະມີການສະແດງວັນທີຂອງກິດຈະກໍາຢູ່ຂ້າງລຸ່ມແຕ່ລະກິດຈະກໍາຢູ່ໃນໜ້າວິຊາຫຼືບໍ່.';
$string['showadvancededitor'] = 'ຂັ້ນສູງ';
$string['showadvancedsettings'] = 'ສະແດງການຕັ້ງຄ່າຂັ້ນສູງ';
$string['showall'] = 'ສະແດງ {$a} ທັງໝົດ';
$string['showallcourses'] = 'ສະແດງລາຍວິຊາທັງໝົດ';
$string['showallusers'] = 'ສະແດງຜູ້ໃຊ້ທັງໝົດ';
$string['showblockcourse'] = 'ສະແດງລາຍການລາຍວິຊາທີ່ມີບລັອກ';
$string['showcategory'] = 'ສະແດງ {$a}';
$string['showchartdata'] = 'ສະແດງຂໍ້ມູນແຜນວາດ';
$string['showcomments'] = 'ສະແດງ/ເຊື່ອງຄຳເຫັນ';
$string['showcommentsnonjs'] = 'ສະແດງຄຳເຫັນ';
$string['showdescription'] = 'ສະແດງຄຳອະທິບາຍຢູ່ໃນໜ້າຫຼັກສູດ';
$string['showdescription_help'] = 'ຖ້າເປີດໃຊ້ງານ, ຄໍາອະທິບາຍຂ້າງເທິງຈະຖືກສະແດງຢູ່ໃນໜ້າລາຍວິຊາຢູ່ຂ້າງລຸ່ມການເຊື່ອມຕໍ່ກັບກິດຈະກໍາ ຫຼື ແຫຼ່ງຂໍ້ມູນ.';
$string['showgrades'] = 'ສະແດງຄະແນນໃຫ້ນັກຮຽນ';
$string['showgrades_help'] = 'ຫຼາຍກິດຈະກໍາ ອະນຸຍາດໃຫ້ກໍານົດຄະແນນ. ການຕັ້ງຄ່ານີ້ກຳນົດວ່ານັກຮຽນສາມາດເບິ່ງລາຍຊື່ຂອງຄະແນນທັງໝົດຂອງເຂົາເຈົ້າຢູ່ໃນຫຼັກສູດໄດ້ຫຼືບໍ່.';
$string['showingacourses'] = 'ສະແດງວິຊາທັງໝົດ {$a}';
$string['showingxofycourses'] = 'ສະແດງວິຊາ {$a->start} ຫາ {$an->end} ຂອງ {$ a->total} ວິຊາ';
$string['showlistofcourses'] = 'ສະແດງລາຍການວິຊາ';
$string['showmodulecourse'] = 'ສະແດງລາຍການວິຊາທີ່ມີກິດຈະກຳ';
$string['showoncoursepage'] = 'ສະແດງຢູ່ໃນໜ້າລາຍວິຊາ';
$string['showonly'] = 'ສະແດງເທົ່ານັ້ນ';
$string['showperpage'] = 'ສະແດງ {$a} ຕໍ່ໜ້າ';
$string['showpopoverwindow'] = 'ສະແດງປ່ອງຢ້ຽມລອຍຂື້ນ';
$string['showrecent'] = 'ສະແດງກິດຈະກຳຫຼ້າສຸດ';
$string['showreports'] = 'ສະແດງລາຍງານກິດຈະກຳ';
$string['showreports_help'] = 'ບົດລາຍງານກິດຈະກໍາແມ່ນມີໃຫ້ສໍາລັບຜູ້ເຂົ້າຮ່ວມແຕ່ລະຄົນທີ່ສະແດງກິດຈະກໍາຂອງເຂົາເຈົ້າຢູ່ໃນລາຍວິຊາ. ເຊັ່ນດຽວກັນກັບລາຍຊື່ການປະກອບສ່ວນຂອງເຂົາເຈົ້າ, ເຊັ່ນ: ກະທູ້ສົນທະນາ ຫຼື ການສົ່ງການມອບໝາຍ, ບົດລາຍງານເຫຼົ່ານີ້ຍັງລວມເຖິງບັນທຶກການເຂົ້າເຖິງ. ການຕັ້ງຄ່ານີ້ກໍານົດວ່ານັກຮຽນສາມາດເບິ່ງລາຍງານກິດຈະກໍາຂອງເຂົາເຈົ້າເອງຜ່ານໜ້າໂປຣໄຟລ໌ຂອງເຂົາເຈົ້າຫຼືບໍ່.';
$string['showsettings'] = 'ສະແດງການຕັ້ງຄ່າ';
$string['showtheselogs'] = 'ສະແດງບັນທຶກເຫຼົ່ານີ້';
$string['showthishelpinlanguage'] = 'ສະແດງການຊ່ວຍເຫຼືອນີ້ເປັນພາສາ: {$a}';
$string['sidepanel'] = 'ແຜງດ້ານຂ້າງ';
$string['signoutofotherservices'] = 'ອອກຈາກລະບົບທຸກບ່ອນ';
$string['signoutofotherservices_help'] = 'ຖ້າໝາຍຕິກ, ບັນຊີຈະອອກຈາກລະບົບໃນທຸກອຸປະກອນ ແລະ ທຸກລະບົບທີ່ໃຊ້ການບໍລິການເວັບເຊັ່ນ: ແອັບມືຖື.';
$string['since'] = 'ຕັ້ງແຕ່';
$string['sincelast'] = 'ຕັ້ງແຕ່ການເຂົ້າສູ່ລະບົບຄັ້ງສຸດທ້າຍ';
$string['site'] = 'ເວັບໄຊທ໌';
$string['sitedefault'] = 'ຄ່າເລີ່ມຕົ້ນຂອງເວັບໄຊທ໌';
$string['sitedefaultspecified'] = 'ຄ່າເລີ່ມຕົ້ນຂອງເວັບໄຊທ໌ ({$a})';
$string['siteerrors'] = 'ຂໍ້ຜິດພາດໃນເວັບໄຊທ໌';
$string['sitefiles'] = 'ໄຟລ໌ເວັບໄຊທ໌';
$string['sitefilesused'] = 'ໄຟລ໌ເວັບໄຊທີ່ໃຊ້ໃນລາຍວິຊານີ້';
$string['sitehome'] = 'ໜ້າຫຼັກເວັບໄຊທ໌';
$string['sitelegacyfiles'] = 'ໄຟລ໌ເວັບໄຊທ໌ເດີມ';
$string['sitelogs'] = 'ບັນທຶກເວັບໄຊທ໌';
$string['sitenews'] = 'ການປະກາດເວັບໄຊທ໌';
$string['sitepages'] = 'ບັນດາໜ້າຂອງເວັບໄຊທ໌';
$string['sitepartlist'] = 'ທ່ານບໍ່ມີສິດອະນຸຍາດທີ່ຕ້ອງການເພື່ອເບິ່ງລາຍຊື່ຜູ້ເຂົ້າຮ່ວມ';
$string['sitepartlist0'] = 'ທ່ານຕ້ອງເປັນຄູສອນເວັບໄຊທ໌ເພື່ອຈະໄດ້ຮັບອະນຸຍາດໃຫ້ເບິ່ງລາຍຊື່ຜູ້ເຂົ້າຮ່ວມເວັບໄຊທ໌';
$string['sitepartlist1'] = 'ເຈົ້າຕ້ອງເປັນຄູສອນເພື່ອຈະໄດ້ຮັບອະນຸຍາດໃຫ້ເບິ່ງລາຍຊື່ຜູ້ເຂົ້າຮ່ວມເວັບໄຊທ໌';
$string['sites'] = 'ເວັບໄຊທ໌';
$string['sitesection'] = 'ລວມທັງຫົວຂໍ້ພາກ';
$string['sitesettings'] = 'ການຕັ້ງຄ່າຂອງເວັບໄຊທ໌';
$string['siteteachers'] = 'ອາຈານປະຈຳເວັບໄຊທ໌';
$string['size'] = 'ຂະໜາດ';
$string['sizeb'] = 'ໄບຕ໌';
$string['sizegb'] = 'ກິກະໄບຕ໌';
$string['sizekb'] = 'ກິໂລໄບຕ໌';
$string['sizemb'] = 'ເມກະໄບຕ໌';
$string['sizepb'] = 'ເພຕາໄບຕ໌';
$string['sizetb'] = 'ເທລະໄບຕ໌';
$string['skipped'] = 'ຂ້າມ';
$string['skiptocategorylisting'] = 'ຂ້າມໄປຫາລາຍການປະເພດ';
$string['skiptocoursedetails'] = 'ຂ້າມໄປຫາຂໍ້ມູນລາຍວິຊາລະອຽດ';
$string['skiptocourselisting'] = 'ຂ້າມໄປຫາລາຍການວິຊາ';
$string['skypeid'] = 'ລະຫັດ ID ຂອງ Skype';
$string['socialheadline'] = 'ຫົວຂໍ້ລ່າສຸດ - ເວທີສົນທະນາສັງຄົມ';
$string['someallowguest'] = 'ບຸກຄົນທົ່ວໄປສາມາດເຂົ້າຊົມໄດ້ສະເພາະບາງລາຍວິຊາ';
$string['someerrorswerefound'] = 'ຂໍ້ມູນບາງຢ່າງສູນເສຍ ຫຼື ບໍ່ຖືກຕ້ອງ. ເບິ່ງຂ້າງລຸ່ມສໍາລັບລາຍລະອຽດ.';
$string['sort'] = 'ຮຽງລຳດັບ';
$string['sortby'] = 'ຮຽງລຳດັບໂດຍ';
$string['sortbyx'] = 'ຮຽງລຳດັບຕາມ {$a} ຈາກນ້ອຍຫາໃຫຍ່';
$string['sortbyxreverse'] = 'ຮຽງລຳດັບຕາມ {$a} ຈາກໃຫຍ່ຫານ້ອຍ';
$string['sorting'] = 'ການຮຽງລຳດັບ';
$string['sourcerole'] = 'ໜ້າທີ່ແຫຼ່ງຂໍ້ມູນ';
$string['specifyname'] = 'ຕ້ອງກຳນົດຊື່';
$string['standard'] = 'ມາດຕະຖານ';
$string['starpending'] = '([*] = ລາຍວິຊາທີ່ລໍການອານຸມັດ)';
$string['startdate'] = 'ມື້ເລີ່ມຕົ້ນລາຍວິຊາ';
$string['startdate_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດການເລີ່ມຕົ້ນຂອງອາທິດທໍາອິດສໍາລັບລາຍວິຊາໃນຮູບແບບປະຈໍາອາທິດ. ມັນຍັງກຳນົດວັນທີກ່ອນໜ້າໄວທີ່ສຸດທີ່ບັນທຶກກິດຈະກຳລາຍວິຊາສຳລັບ. ຖ້າຫຼັກສູດຖືກຕັ້ງຄືນໃໝ່ ແລະ ວັນທີເລີ່ມລາຍວິຊາມີການປ່ຽນແປງ, ວັນທີທັງໝົດຢູ່ໃນລາຍວິຊາຈະຖືກຍ້າຍທີ່ກ່ຽວຂ້ອງກັບວັນທີເລີ່ມຕົ້ນໃໝ່.';
$string['startingfrom'] = 'ເລີ່ມຕົ້ນຈາກ';
$string['startsignup'] = 'ສ້າງບັນຊີໃໝ່';
$string['state'] = 'ແຂວງ';
$string['statistics'] = 'ສະຖິຕິ';
$string['statisticsgraph'] = 'ເສັ້ນສະຖິຕິ';
$string['stats'] = 'ສະຖິຕິ';
$string['statslogins'] = 'ເຂົ້າສູ່ລະບົບ';
$string['statsmodedetailed'] = 'ມຸມມອງ (ຜູ້ໃຊ້) ໂດຍລະອຽດ';
$string['statsmodegeneral'] = 'ມຸມມອງທົ່ວໄປ';
$string['statsnodata'] = 'ບໍ່ມີຂໍ້ມູນທີ່ມີຢູ່ສໍາລັບການລວມກັນຂອງຫຼັກສູດ ແລະ ໄລຍະເວລານັ້ນ.';
$string['statsnodatauser'] = 'ບໍ່ມີຂໍ້ມູນທີ່ມີຢູ່ສໍາລັບການລວມກັນຂອງລາຍວິຊາ, ຜູ້ໃຊ້ ແລະ ໄລຍະເວລາ.';
$string['statsoff'] = 'ສະຖິຕິບໍ່ໄດ້ຖືກເປີດໃຊ້ໃນປະຈຸບັນ';
$string['statsreads'] = 'ຍອດເບິ່ງ';
$string['statsreport1'] = 'ເຂົ້າສູ່ລະບົບ';
$string['statsreport10'] = 'ກິດຈະກຳຜູ້ໃຊ້';
$string['statsreport11'] = 'ຫຼັກສູດທີ່ມີການເຄື່ອນໄຫວຫຼາຍທີ່ສຸດ';
$string['statsreport12'] = 'ຫຼັກສູດທີ່ມີການເຄື່ອນໄຫວຫຼາຍທີ່ສຸດ (ນໍ້າໜັກ)';
$string['statsreport13'] = 'ຫຼັກສູດທີ່ມີສ່ວນຮ່ວມຫຼາຍທີ່ສຸດ (ການລົງທະບຽນ)';
$string['statsreport14'] = 'ຫຼັກສູດມີສ່ວນຮ່ວມຫຼາຍທີ່ສຸດ (ໂພສ/ຍອດເບິ່ງ)';
$string['statsreport2'] = 'ຈຳນວນເບິ່ງ (ທຸກໜ້າທີ່)';
$string['statsreport3'] = 'ໂພສ (ທຸກໜ້າທີ່)';
$string['statsreport4'] = 'ກິດຈະກຳທັງໝົດ (ທຸກໜ້າທີ່)';
$string['statsreport5'] = 'ກິດຈະກຳທັງໝົດ  (ໂພສ/ຍອດເບິ່ງ)';
$string['statsreport7'] = 'ກິດຈະກຳຜູ້ໃຊ້ (ໂພສ/ຍອດເບິ່ງ)';
$string['statsreport8'] = 'ການເຄື່ອນໄຫວຂອງຜູ້ໃຊ້ທັງໝົດ';
$string['statsreport9'] = 'ເຂົ້າສູ່ລະບົບ (ເວັບໄຊທ໌ລາຍວິຊາ)';
$string['statsreportactivity'] = 'ກິດຈະກຳທັງໝົດ (ທຸກໜ້າທີ່)';
$string['statsreportactivitybyrole'] = 'ກິດຈະກຳທັງໝົດ (ຍອດເບິ່ງ ແລະ ໂພສ)';
$string['statsreportforuser'] = 'ສຳລັບ';
$string['statsreportlogins'] = 'ເຂົ້າສູ່ລະບົບ';
$string['statsreportreads'] = 'ຍອດເບິ່ງ (ທຸກໜ້າທີ່)';
$string['statsreporttype'] = 'ປິເພດລາຍງານ';
$string['statsreportwrites'] = 'ໂພສ (ທຸກໜ້າທີ່)';
$string['statsstudentactivity'] = 'ກິດຈະກຳນັກຮຽນ';
$string['statsstudentreads'] = 'ຍອດເບິ່ງຂອງນັກຮຽນ';
$string['statsstudentwrites'] = 'ໂພສຂອງນັກຮຽນ';
$string['statsteacheractivity'] = 'ກິດຈະກຳຄູສອນ';
$string['statsteacherreads'] = 'ຍອດເບິ່ງຂອງຄູສອນ';
$string['statsteacherwrites'] = 'ໂພສຂອງຄູສອນ';
$string['statstimeperiod'] = 'ໄລຍະເວລາ - ຫຼ້າສຸດ:';
$string['statsuniquelogins'] = 'ເຂົ້າສູ່ລະບົບທີ່ບໍ່ຊ້ຳ';
$string['statsuseractivity'] = 'ທຸກກິດຈະກຳ';
$string['statsuserlogins'] = 'ເຂົ້າສູ່ລະບົບ';
$string['statsuserreads'] = 'ຍອດເບິ່ງ';
$string['statsuserwrites'] = 'ໂພສ';
$string['statswrites'] = 'ໂພສ';
$string['status'] = 'ສະຖານະ';
$string['statuscritical'] = 'ສຳຄັນ';
$string['statuserror'] = 'ພິດພາດ';
$string['statusinfo'] = 'ຂໍ້ມູນ';
$string['statusna'] = 'ບໍ່ມີ';
$string['statusok'] = 'ຕົກລົງ';
$string['statusunknown'] = 'ບໍ່ຮູ້ຈັກ';
$string['statuswarning'] = 'ການເຕືອນ';
$string['stringsnotset'] = 'ສະຕຣິງຕໍ່ໄປນີ້ບໍ່ໄດ້ຖືກກໍານົດໄວ້ໃນ {$a}';
$string['studentnotallowed'] = 'ຂໍອະໄພ, ແຕ່ທ່ານບໍ່ສາມາດເຂົ້າລາຍວິຊານີ້ເປັນ \'{$a}\' ໄດ້';
$string['students'] = 'ນັກຮຽນ';
$string['studentsandteachers'] = 'ນັກຮຽນ ແລະ ອາຈານ';
$string['subcategories'] = 'ບັນດາປະເພດຍ່ອຍ';
$string['subcategory'] = 'ປະເພດຍ່ອຍ';
$string['subcategoryof'] = 'ປະເພດຍ່ອຍຂອງ {$a}';
$string['subject'] = 'ເລື່ອງ';
$string['submit'] = 'ສົ່ງ';
$string['success'] = 'ສຳເລັດ';
$string['successduration'] = 'ສຳ ເລັດ ({$a} ວິນາທີ)';
$string['summary'] = 'ສະຫຼຸບ';
$string['summary_help'] = 'ແນວຄວາມຄິດຂອງການສະຫຼຸບເປັນຂໍ້ຄວາມສັ້ນເພື່ອກະກຽມນັກຮຽນສໍາລັບກິດຈະກໍາພາຍໃນຫົວຂໍ້ ຫຼື ອາທິດ. ຂໍ້ຄວາມຖືກສະແດງຢູ່ໃນໜ້າລາຍວິຊາພາຍໃຕ້ຊື່ພາກ.';
$string['summaryof'] = 'ສະຫຼຸບຂອງ {$a}';
$string['supplyinfo'] = 'ລາຍລະອຽດເພີ່ມເຕີມ';
$string['suspended'] = 'ຖືກລະງັບ';
$string['suspendedusers'] = 'ຜູ້ໃຊ້ຖືກລະງັບ';
$string['switchdevicedefault'] = 'ສະຫຼັບໄປໃຊ້ຮູບແບບສີສັນມາດຕະຖານ';
$string['switchdevicerecommended'] = 'ສະຫຼັບໄປໃຊ້ຮູບແບບສີສັນທີ່ແນະນຳໃຫ້ກັບອຸປະກອນຂອງທ່ານ';
$string['switchrolereturn'] = 'ກັບຄືນສູ່ໜ້າທີ່ປົກກະຕິຂອງຂ້ອຍ';
$string['switchroleto'] = 'ສະຫຼັບໜ້າທີ່ໄປ...';
$string['switchroleto_help'] = 'ເລືອກໜ້າທີ່ເພື່ອໃຫ້ໄດ້ຄວາມຄິດວ່າຄົນທີ່ມີບົດບາດນັ້ນຈະເຫັນລາຍວິຊານີ້ແນວໃດ.

ກະລຸນາຮັບຊາບວ່າມຸມມອງນີ້ອາດຈະບໍ່ສົມບູນແບບ (<a href="https://docs.moodle.org/en/Switch_roles">ເບິ່ງລາຍລະອຽດ ແລະ ທາງເລືອກ</a>).';
$string['tag'] = 'ປ້າຍ';
$string['tagalready'] = 'ມີປ້າຍນີ້ແລ້ວ';
$string['tagmanagement'] = 'ເພີ່ມ/ລຶບປ້າຍ...';
$string['tags'] = 'ປ້າຍຕ່າງໆ';
$string['targetrole'] = 'ໜ້າທີ່ເປົ້າໝາຍ';
$string['teacheronly'] = 'ສໍາລັບ {$a} ເທົ່ານັ້ນ';
$string['teacherroles'] = 'ໜ້າທີ່ {$a}';
$string['teachers'] = 'ອາຈານ';
$string['textcopiedtoclipboard'] = 'ສຳເນົາຂໍ້ຄວາມໃສ່ຄລິບບອດແລ້ວ';
$string['textediting'] = 'ຕົວແກ້ໄຂຂໍ້ຄວາມ';
$string['textediting_help'] = 'ຖ້າເລືອກຕົວກວດແກ້ HTML ເຊັ່ນ: Atto ຫຼື TinyMCE, ພື້ນທີ່ປ້ອນຂໍ້ຄວາມຈະມີແຖບເຄື່ອງມືທີ່ມີປຸ່ມເພື່ອເພີ່ມເນື້ອຫາໄດ້ງ່າຍ.

ຖ້າ \'ພື້ນທີ່ຂໍ້ຄວາມທໍາມະດາ\' ຖືກເລືອກ, ຮູບແບບສໍາລັບພື້ນທີ່ປ້ອນຂໍ້ຄວາມເຊັ່ນ: HTML ຫຼື Markdown ສາມາດເລືອກໄດ້.

ລາຍຊື່ຕົວແກ້ໄຂຂໍ້ຄວາມທີ່ມີຢູ່ແມ່ນຖືກ ກຳນົດໂດຍຜູ້ບໍລິຫານເວັບໄຊທ໌.';
$string['texteditor'] = 'ໃຊ້ແບບຟອມເວັບມາດຕະຖານ';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'ຮູບແບບຂໍ້ຄວາມທຳມະດາ';
$string['thanks'] = 'ຂໍຂອບໃຈ';
$string['theme'] = 'ຮູບແບບສີສັນ';
$string['themes'] = 'ບັນດາຮູບແບບສີສັນ';
$string['themesaved'] = 'ບັນທຶກຮູບແບບສີສັນໃໝ່';
$string['therearecourses'] = 'ມີວິຊາ {$a}';
$string['thereareno'] = 'ບໍ່ມີ {$a} ໃນລາຍວິຊານີ້';
$string['thiscategory'] = 'ລາຍປະເພດນີ້';
$string['thiscategorycontains'] = 'ລາຍປະເພດນີ້ມີ';
$string['time'] = 'ເວລາ';
$string['timecreated'] = 'ສ້າງເວລາແລ້ວ';
$string['timecreatedcourse'] = 'ເວລາສ້າງຫຼັກສູດແລ້ວ';
$string['timesplitting:deciles'] = 'ສ່ວນສິບສຸດທ້າຍ';
$string['timesplitting:deciles_help'] = 'ໄລຍະຫ່າງການວິເຄາະນີ້ແບ່ງລາຍວິຊາອອກເປັນສ່ວນສິບ (10 ພາກສ່ວນເທົ່າກັນ), ໂດຍການຄາດຄະເນແຕ່ລະອັນແມ່ນອີງໃສ່ຂໍ້ມູນຂອງພຽງແຕ່ສ່ວນສິບທີ່ຜ່ານມາລ້າສຸດ.';
$string['timesplitting:decilesaccum'] = 'ສ່ວນສິບທັງໝົດທີ່ຜ່ານມາ';
$string['timesplitting:decilesaccum_help'] = 'ຊ່ວງເວລາການວິເຄາະນີ້ແບ່ງຫຼັກສູດອອກເປັນສ່ວນສິບ (10 ພາກສ່ວນເທົ່າກັນ), ໂດຍການຄາດຄະເນແຕ່ລະອັນແມ່ນອີງໃສ່ຂໍ້ມູນສະສົມຂອງສ່ວນສິບທັງໝົດທີ່ຜ່ານມາ.';
$string['timesplitting:nosplitting'] = 'ບໍ່ມີຂີດຈໍາກັດຂອງເວລາ';
$string['timesplitting:nosplitting_help'] = 'ບໍ່ມີການກຳນົດໄລຍະເວລາການວິເຄາະ ສຳລັບຮູບແບບນີ້.';
$string['timesplitting:onemonthafterstart'] = 'ໜຶ່ງເດືອນຫຼັງຈາກການເລີ່ມຕົ້ນ';
$string['timesplitting:onemonthafterstart_help'] = 'ໄລຍະຫ່າງການວິເຄາະນີ້ສ້າງການຄາດຄະເນ 1 ເດືອນຫຼັງຈາກການເລີ່ມຕົ້ນການວິເຄາະ.';
$string['timesplitting:oneweekafterstart'] = 'ຫນຶ່ງອາທິດຫຼັງຈາກການເລີ່ມຕົ້ນ';
$string['timesplitting:oneweekafterstart_help'] = 'ຊ່ວງເວລາການວິເຄາະນີ້ສ້າງການຄາດຄະເນ 1 ອາທິດຫຼັງຈາກການເລີ່ມຕົ້ນວິເຄາະ.';
$string['timesplitting:past3days'] = '3 ມື້ຜ່ານມາ';
$string['timesplitting:past3days_help'] = 'ຊ່ວງເວລາການວິເຄາະນີ້ສ້າງການຄາດຄະເນທຸກ 3 ມື້. ການຄຳນວນຕົວຊີ້ວັດຈະອີງໃສ່ 3 ວັນຜ່ານມາ.';
$string['timesplitting:pastmonth'] = 'ເດືອນທີ່ຜ່ານມາ';
$string['timesplitting:pastmonth_help'] = 'ໄລຍະຫ່າງການວິເຄາະນີ້ສ້າງການຄາດຄະເນທຸກເດືອນ. ການຄິດໄລ່ຕົວຊີ້ວັດຈະອີງໃສ່ເດືອນທີ່ຜ່ານມາ.';
$string['timesplitting:pastweek'] = 'ອາທິດທີ່ຜ່ານມາ';
$string['timesplitting:pastweek_help'] = 'ໄລຍະຫ່າງການວິເຄາະນີ້ສ້າງການຄາດຄະເນທຸກອາທິດ. ການຄິດໄລ່ຕົວຊີ້ວັດຈະອີງໃສ່ອາທິດທີ່ຜ່ານມາ.';
$string['timesplitting:quarters'] = 'ໄຕມາດທີ່ຜ່ານມາ';
$string['timesplitting:quarters_help'] = 'ຊ່ວງເວລາການວິເຄາະນີ້ແບ່ງລາຍອອກເປັນໄຕມາດ (4 ພາກສ່ວນເທົ່າທຽມກັນ), ໂດຍການຄາດຄະເນແຕ່ລະອັນແມ່ນອີງໃສ່ຂໍ້ມູນຂອງພຽງແຕ່ໄຕມາດທີ່ຜ່ານມາຫຼ້າສຸດ.';
$string['timesplitting:quartersaccum'] = 'ທຸກໄຕມາດກ່ອນໜ້ານີ້';
$string['timesplitting:quartersaccum_help'] = 'ຊ່ວງເວລາການວິເຄາະນີ້ແບ່ງລາຍວິຊາອອກເປັນໄຕມາດ (4 ພາກສ່ວນເທົ່າທຽມກັນ), ໂດຍການຄາດຄະເນແຕ່ລະອັນແມ່ນອີງໃສ່ຂໍ້ມູນສະສົມຂອງທຸກໄຕມາດກ່ອນ ໜ້າ.';
$string['timesplitting:singlerange'] = 'ຈາກຈຸດເລີ່ມຕົ້ນຈົນເຖິງປາຍທາງ';
$string['timesplitting:singlerange_help'] = 'ໄລຍະຫ່າງການວິເຄາະນີ້ພິຈາລະນາຫຼັກສູດທັງໝົດເປັນຊ່ວງດຽວ.';
$string['timesplitting:tenpercentafterstart'] = '10% ຫຼັງຈາກການເລີ່ມຕົ້ນ';
$string['timesplitting:tenpercentafterstart_help'] = 'ໄລຍະຫ່າງການວິເຄາະນີ້ສ້າງການຄາດຄະເນຫຼັງຈາກ 10% ຂອງຫຼັກສູດໄດ້ສໍາເລັດ.';
$string['timesplitting:upcoming3days'] = '3 ມື້ທີ່ຈະມາເຖິງ';
$string['timesplitting:upcoming3days_help'] = 'ຊ່ວງເວລາການວິເຄາະນີ້ສ້າງການຄາດຄະເນທຸກ 3 ມື້. ການຄິດໄລ່ຕົວຊີ້ວັດຈະອີງໃສ່ 3 ວັນຂ້າງໜ້າ.';
$string['timesplitting:upcomingfortnight'] = 'ສອງອາທິດທີ່ຈະມາເຖິງ';
$string['timesplitting:upcomingfortnight_help'] = 'ໄລຍະເວລາການວິເຄາະນີ້ສ້າງການຄາດຄະເນທຸກໆສອງອາທິດ. ການຄິດໄລ່ຕົວຊີ້ວັດຈະອີງໃສ່ສອງອາທິດທີ່ຈະມາເຖິງ.';
$string['timesplitting:upcomingweek'] = 'ອາທິດທີ່ຈະມາເຖິງ';
$string['timesplitting:upcomingweek_help'] = 'ໄລຍະຫ່າງການວິເຄາະນີ້ສ້າງການຄາດຄະເນທຸກໆອາທິດ. ການຄິດໄລ່ຕົວຊີ້ວັດຈະອີງໃສ່ອາທິດທີ່ຈະມາເຖິງ.';
$string['timezone'] = 'ເຂດເວລາ';
$string['to'] = 'ເຖິງ';
$string['tocontent'] = 'ເຖິງລາຍການ "{$a}"';
$string['tocreatenewaccount'] = 'ຂ້າມເພື່ອສ້າງບັນຊີໃໝ່';
$string['today'] = 'ມື້ນີ້';
$string['todaylogs'] = 'ບັນທຶກມື້ນີ້';
$string['toeveryone'] = 'ເຖິງທຸກຄົນ';
$string['toggleemojipicker'] = 'ສະຫຼັບຕົວເລືອກອີໂມຈິ';
$string['togglesearch'] = 'ສະຫຼັບການປ້ອນຂໍ້ມູນການຊອກຫາ';
$string['toomanybounces'] = 'ທີ່ຢູ່ອີເມລນີ້ມີບັນຫາຫຼາຍຢ່າງເກີນໄປ. ທ່ານ <b>ຕ້ອງ</b> ປ່ຽນມັນເພື່ອສືບຕໍ່.';
$string['toomanytags'] = 'ການຄົ້ນຫານີ້ລວມມີແທັກຫຼາຍເກີນໄປ; ບາງອັນຈະຖືກລະເລີຍ.';
$string['toomanytoshow'] = 'ມີຜູ້ໃຊ້ຫຼາຍເກີນໄປທີ່ຈະສະແດງໃຫ້ເຫັນ.';
$string['toomanyusersmatchsearch'] = 'ມີຜູ້ໃຊ້ຫຼາຍເກີນໄປ ({$a->count}) ກົງກັບ \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'ມີຜູ້ໃຊ້ຫຼາຍເກີນໄປ ({$a}) ສະແດງ';
$string['toonly'] = 'ຫາ {$a} ເທົ່ານັ້ນ';
$string['top'] = 'ທາງເທີງ';
$string['topic'] = 'ຫົວຂໍ້';
$string['topichide'] = 'ເຊື່ອງຫົວຂໍ້ນີ້ຈາກ {$a}';
$string['topicoutline'] = 'ໂຄງຮ່າງຫົວຂໍ້';
$string['topicshow'] = 'ສະແດງຫົວຂໍ້ນີ້ໃຫ້ {$a}';
$string['toplevelcategory'] = 'ປະເພດລະດັບສູງສຸດ';
$string['total'] = 'ລວມ';
$string['totopofsection'] = 'ໄປເທິງສຸດຂອງພາກ "{$ a}"';
$string['trackforums'] = 'ການຕິດຕາມເວທີສົນທະນາ';
$string['trackforumsno'] = 'ບໍ່: ຢ່າຕິດຕາມໂພສທີ່ຂ້ອຍເຄີຍເຫັນ';
$string['trackforumsyes'] = 'ແມ່ນແລ້ວ: ເນັ້ນຂໍ້ຄວາມໃໝ່ສຳລັບຂ້ອຍ';
$string['trysearching'] = 'ລອງຊອກຫາແທນ.';
$string['turneditingoff'] = 'ປິດການແກ້ໄຂ';
$string['turneditingon'] = 'ເປີດການແກ້ໄຂ';
$string['unabletocopytoclipboard'] = 'ບໍ່ສາມາດສຳເນົາຂໍ້ຄວາມໃສ່ຄລິບບອດໄດ້';
$string['unauthorisedlogin'] = 'ບັນຊີຜູ້ໃຊ້ "{$a}" ບໍ່ມີຢູ່ໃນເວັບໄຊທ໌ນີ້';
$string['undecided'] = 'ບໍ່ຕັດສິນໃຈ';
$string['unexistingcmid'] = 'ບໍ່ພົບ ID ໂມດູນວິຊາ';
$string['unexistingsectionid'] = 'ບໍ່ພົບ ID ພາກວິຊາ';
$string['unfinished'] = 'ຍັງບໍ່ແລ້ວ';
$string['unknowncategory'] = 'ປະເພດທີ່ບໍ່ຮູ້ຈັກ';
$string['unknownerror'] = 'ຄວາມຜິດພາດທີ່ບໍ່ຮູ້ຈັກ';
$string['unknownuser'] = 'ຜູ້ໃຊ້ທີ່ບໍ່ຮູ້ຈັກ';
$string['unlimited'] = 'ບໍ່ຈໍາກັດ';
$string['unpacking'] = 'ກຳລັງແກະກ່ອງ {$a}';
$string['unsafepassword'] = 'ລະຫັດຜ່ານທີ່ບໍ່ປອດໄພ - ລອງອັນອື່ນແທນ';
$string['untilcomplete'] = 'ຈົນສຳເລັດ';
$string['unusedaccounts'] = 'ບັນຊີທີ່ບໍ່ໄດ້ໃຊ້ຫຼາຍກວ່າ {$a} ມື້ແມ່ນຖືກຖອນລົງທະບຽນໂດຍອັດຕະໂນມັດ';
$string['unzip'] = 'ການແຍກໄຟລ໌';
$string['unzippingbackup'] = 'ກຳລັງແຍກໄຟລ໌ສຳຮອງ';
$string['up'] = 'ຂື້ນ';
$string['update'] = 'ປັບປຸງ';
$string['updated'] = 'ປັບປຸງ {$a} ແລ້ວ';
$string['updatemymoodleoff'] = 'ຢຸດການປັບແຕ່ງໜ້ານີ້';
$string['updatemymoodleon'] = 'ປັບແຕ່ງໜ້ານີ້';
$string['updatemyprofile'] = 'ປັບປຸງໂປຼໄຟລ໌';
$string['updatesevery'] = 'ປັບປຸງທຸກ {$a} ວິນາທີ';
$string['updatethis'] = 'ປັບປຸງ {$a} ນີ້';
$string['updatethiscourse'] = 'ປັບປຸງວິຊານີ້';
$string['updatinga'] = 'ກຳລັງ ປັບປຸງ: {$a}';
$string['updatingain'] = 'ກຳລັງ ປັບປຸງ {$a->what} ໃນ{$a->in}';
$string['upload'] = 'ອັບໂຫຼດ';
$string['uploadafile'] = 'ອັບໂຫຼດໄຟລ໌';
$string['uploadcantwrite'] = 'ການຂຽນໄຟລ໌ໃສ່ແຜ່ນດິສກ໌ລົ້ມເຫຼວ';
$string['uploadedfile'] = 'ອັບໂຫຼດໄຟລ໌ສຳເລັດແລ້ວ';
$string['uploadedfileto'] = 'ອັບໂຫຼດ {$a->file} ໃສ່ {$a->directory}';
$string['uploadedfiletoobig'] = 'ຂໍອະໄພ, ແຕ່ໄຟລ໌ໃຫຍ່ເກີນໄປ (ຈຳກັດໄວ້ທີ່ {$a} ໄບຕ໌)';
$string['uploadextension'] = 'ການອັບໂຫຼດໄຟລ໌ຢຸດເຊົາໂດຍສ່ວນຂະຫຍາຍ PHP';
$string['uploadfailednotrecovering'] = 'ການອັບໂຫຼດໄຟລ໌ຂອງທ່ານບໍ່ສໍາເລັດເພາະວ່າມີບັນຫາກັບໜຶ່ງໃນໄຟລ໌, {$a-> name}.<br /> ນີ້ແມ່ນບັນທຶກຂອງບັນຫາ:<br />{$a->problem}<br /> ຍັງບໍ່ກູ້ຄືນ.';
$string['uploadfilelog'] = 'ບັນທຶກການອັບໂຫຼດສຳລັບໄຟລ໌ {$a}';
$string['uploadformlimit'] = 'ໄຟລ໌ {$a} ທີ່ອັບໂຫຼດມາມີຂະໜາດເກີນຂີດຈຳກັດສູງສຸດທີ່ຕັ້ງໂດຍແບບຟອມ';
$string['uploadlabel'] = 'ຫົວຂໍ້:';
$string['uploadlimitwithsize'] = '{$a->contextname} ຂີດຈໍາກັດການອັບໂຫຼດ ({$ a->displayize})';
$string['uploadnewfile'] = 'ອັບໂຫຼດໄຟລ໌ໃຫມ່';
$string['uploadnofilefound'] = 'ບໍ່ພົບໄຟລ໌ - ເຈົ້າແນ່ໃຈບໍ່ວ່າເຈົ້າໄດ້ເລືອກອັນໜຶ່ງເພື່ອອັບໂຫຼດ?';
$string['uploadnotallowed'] = 'ບໍ່ອະນຸຍາດໃຫ້ອັບໂຫຼດ';
$string['uploadnotempdir'] = 'ບໍ່ມີໂຟນເດີຊົ່ວຄາວ';
$string['uploadoldfilesdeleted'] = 'ໄຟລ໌ເກົ່າຢູ່ໃນພື້ນທີ່ອັບໂຫຼດຂອງທ່ານຖືກລຶບອອກແລ້ວ';
$string['uploadpartialfile'] = 'ໄຟລ໌ຖືກອັບໂຫຼດບາງສ່ວນເທົ່ານັ້ນ';
$string['uploadproblem'] = 'ເກີດບັນຫາທີ່ບໍ່ຮູ້ຈັກໃນຂະນະທີ່ອັບໂຫຼດໄຟລ໌ \'{$a}\' (ບາງທີມັນໃຫຍ່ເກີນໄປບໍ?)';
$string['uploadrenamedchars'] = 'ໄຟລ໌ຖືກປ່ຽນຊື່ຈາກ {$a->oldname} ເປັນ {$a->newname} ເນື່ອງຈາກຕົວອັກສອນບໍ່ຖືກຕ້ອງ.';
$string['uploadrenamedcollision'] = 'ໄຟລ໌ຖືກປ່ຽນຊື່ຈາກ {$a->oldname} ເປັນ {$a->newname} ເພາະວ່າມີຊື່ໄຟລ໌ຂັດແຍ່ງກັນ.';
$string['uploadserverlimit'] = 'ໄຟລ໌ທີ່ອັບໂຫຼດມາມີຂະໜາດເກີນຂີດຈຳ ກັດທີ່ເຊີບເວີຕັ້ງໄວ້';
$string['uploadthisfile'] = 'ອັບໂຫຼດໄຟລ໌ນີ້';
$string['url'] = 'URL';
$string['used'] = 'ໃຊ້ແລ້ວ';
$string['usedinnplaces'] = 'ໃຊ້ຢູ່ໃນ {$a} ສະຖານທີ່';
$string['user'] = 'ຜູ້ໃຊ້';
$string['useraccount'] = 'ບັນຊີຜູ້ໃຊ້';
$string['useractivity'] = 'ກິດຈະກຳ';
$string['userconfirmed'] = 'ຢືນຢັນ {$a}';
$string['userdata'] = 'ຂໍ້ມູນຜູ້ໃຊ້';
$string['userdeleted'] = 'ບັນຊີຜູ້ໃຊ້ນີ້ຖືກລຶບແລ້ວ';
$string['userdescription'] = 'ລາຍລະອຽດ';
$string['userdescription_help'] = 'ປ່ອງນີ້ເຮັດໃຫ້ເຈົ້າສາມາດປ້ອນຂໍ້ຄວາມບາງຢ່າງກ່ຽວກັບຕົວເຈົ້າເອງເຊິ່ງຈາກນັ້ນຈະຖືກສະແດງຢູ່ໃນໜ້າໂປຼໄຟລ໌ຂອງທ່ານເພື່ອໃຫ້ຄົນອື່ນເບິ່ງ.';
$string['userdetails'] = 'ລາຍລະອຽດຜູ້ໃຊ້';
$string['userfiles'] = 'ໄຟລ໌ຜູ້ໃຊ້';
$string['userfilterplaceholder'] = 'ຊອກຫາຄຳສັບຫຼັກ ຫຼື ເລືອກຕົວກັ່ນຕອງ';
$string['userlist'] = 'ລາຍຊື່ຜູ້ໃຊ້';
$string['usermenu'] = 'ເມນູຜູ້ໃຊ້';
$string['usermenugoback'] = 'ກັບໄປທີ່ເມນູຜູ້ໃຊ້';
$string['username'] = 'ຊື່ຜູ້ໃຊ້';
$string['usernameemail'] = 'ຊື່ຜູ້ໃຊ້ ຫຼື ອີເມລ';
$string['usernameemailmatch'] = 'ຊື່ຜູ້ໃຊ້ ແລະ ທີ່ຢູ່ອີເມວບໍ່ກ່ຽວຂ້ອງກັບຜູ້ໃຊ້ຄົນດຽວກັນ';
$string['usernameexists'] = 'ຊື່ຜູ້ໃຊ້ນີ້ມີຢູ່ແລ້ວ, ເລືອກຊື່ອື່ນ';
$string['usernamelowercase'] = 'ອະນຸຍາດໃຫ້ໃຊ້ຕົວອັກສອນຕົວນ້ອຍເທົ່ານັ້ນ';
$string['usernamenotfound'] = 'ບໍ່ພົບຊື່ຜູ້ໃຊ້ໃນຖານຂໍ້ມູນ';
$string['usernameoremail'] = 'ກະລຸນາໃສ່ຊື່ຜູ້ໃຊ້ ຫຼື ທີ່ຢູ່ອີເມລ';
$string['usernotconfirmed'] = 'ບໍ່ສາມາດຢືນຢັນ {$a} ໄດ້';
$string['userpic'] = 'ຮູບຜູ້ໃຊ້';
$string['userpreferences'] = 'ຄວາມມັກຂອງຜູ້ໃຊ້';
$string['users'] = 'ບັນດາຜູ້ໃຊ້';
$string['userselectorautoselectunique'] = 'ຖ້າມີພຽງຜູ້ໃຊ້ຄົນດຽວກົງກັບການຄົ້ນຫາ, ເລືອກພວກມັນໂດຍອັດຕະໂນມັດ';
$string['userselectorpreserveselected'] = 'ຮັກສາຜູ້ໃຊ້ທີ່ເລືອກໄວ້, ເຖິງແມ່ນວ່າພວກມັນບໍ່ກົງກັບການຄົ້ນຫາອີກຕໍ່ໄປ';
$string['userselectorsearchanywhere'] = 'ຈັບຄູ່ຂໍ້ຄວາມຊອກຫາໄດ້ທຸກບ່ອນໃນຊ່ອງທີ່ສະແດງ';
$string['usersnew'] = 'ຜູ້ໃຊ້ໃໝ່';
$string['usersnoaccesssince'] = 'ບໍ່ເຄື່ອນໄຫວເປັນເວລາຫຼາຍກວ່າ';
$string['userswithfiles'] = 'ຜູ້ໃຊ້ທີ່ມີໄຟລ໌';
$string['useruploadtype'] = 'ປະເພດການອັບໂຫຼດຂອງຜູ້ໃຊ້: {$a}';
$string['userzones'] = 'ເຂດຜູ້ໃຊ້';
$string['usetheme'] = 'ໃຊ້ຮູບແບບສີສັນ';
$string['usingexistingcourse'] = 'ການນໍາໃຊ້ຫຼັກສູດທີ່ມີຢູ່';
$string['validatehtml'] = 'ກວດສອບ HTML';
$string['valuealreadyused'] = 'ຄ່ານີ້ໄດ້ຖືກນຳໃຊ້ແລ້ວ.';
$string['version'] = 'ສະບັບ';
$string['view'] = 'ເບິ່ງ';
$string['viewallcourses'] = 'ເບິ່ງວິຊາທັງໝົດ';
$string['viewallcoursescategories'] = 'ເບິ່ງຫຼັກສູດ ແລະ ປະເພດທັງໝົດ';
$string['viewallsubcategories'] = 'ເບິ່ງປະເພດຍ່ອຍທັງໝົດ';
$string['viewfileinpopup'] = 'ເບິ່ງໄຟລ໌ຢູ່ໃນປ່ອງຢ້ຽມລອຍຂື້ນ';
$string['viewing'] = 'ກຳລັງເບິ່ງ:';
$string['viewmore'] = 'ເບິ່ງເພີ່ມເຕີມ';
$string['viewprofile'] = 'ເບິ່ງໂປຼໄຟລ໌';
$string['views'] = 'ຍອດເບິ່ງ';
$string['viewsolution'] = 'ເບິ່ງການແກ້ໄຂ';
$string['visible'] = 'ເບິ່ງເຫັນໄດ້';
$string['visible_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດວ່າຫຼັກສູດປະກົດຂຶ້ນຢູ່ໃນລາຍການຫຼັກສູດຫຼືບໍ່. ນອກຈາກຄູອາຈານ ແລະ ຜູ້ບໍລິຫານ, ຜູ້ໃຊ້ບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເຂົ້າຫຼັກສູດ.';
$string['visibletostudents'] = 'ເບິ່ງເຫັນໄດ້ຕໍ່ກັບ {$a}';
$string['warning'] = 'ຄໍາເຕືອນ';
$string['warningdeleteresource'] = 'ຄຳເຕືອນ: {$a} ຖືກອ້າງອີງໃນແຫຼ່ງຂໍ້ມູນ. ທ່ານຕ້ອງການອັບເດດແຫຼ່ງຂໍ້ມູນບໍ່?';
$string['wcagcheck'] = 'ກວດສອບຂໍ້ແນະນຳການຊ່ວຍເຂົ້າເຖິງເນື້ອຫາເວັບ (WCAG)';
$string['webpage'] = 'ເວັບເພດ';
$string['week'] = 'ອາທິດ';
$string['weekhide'] = 'ຊ່ອນອາທິດນີ້ຈາກ {$a}';
$string['weeklyoutline'] = 'ໂຄງສ້າງລາຍອາທິດ';
$string['weeks'] = 'ອາທິດ';
$string['weekshow'] = 'ສະແດງອາທິດນີ້ແກ່ {$a}';
$string['welcomeback'] = 'ຍິນດີຕ້ອນຮັບກັບຄືນ, {$a->firstname}! 👋';
$string['welcometocourse'] = 'ຍິນດີຕ້ອນຮັບສູ່ {$a}';
$string['welcometocoursetext'] = 'ຍິນດີຕ້ອນຮັບສູ່ {$a->coursename}!

ຖ້າທ່ານບໍ່ໄດ້ເຮັດແນວນັ້ນເທື່ອ, ທ່ານຄວນດັດແກ້ໜ້າໂປຼໄຟລ໌ຂອງທ່ານ ເພື່ອວ່າພວກເຮົາສາມາດຮຽນຮູ້ເພີ່ມເຕີມກ່ຽວກັບທ່ານ:

   {$a->profileurl}';
$string['welcometosite'] = 'ຍິນດີຕ້ອນຮັບ, {$a->firstname}! 👋';
$string['whatforlink'] = 'ທ່ານຕ້ອງການເຮັດອັນໃດກັບລິ້ງ?';
$string['whatforpage'] = 'ທ່ານຕ້ອງການເຮັດອັນໃດກັບຂໍ້ຄວາມ?';
$string['whatisyourage'] = 'ທ່ານອາຍຸຈັກປີ?';
$string['whattocallzip'] = 'ທ່ານຕ້ອງການເອີ້ນຊື່ໄຟລ໌ zip ແນວໃດ?';
$string['whattodo'] = 'ຈະເຮັດແນວໃດ';
$string['wheredoyoulive'] = 'ທ່ານອາໄສຢູ່ໃນປະເທດໃດ?';
$string['whyisthisrequired'] = 'ເປັນຫຍັງອັນນີ້ຈິ່ງຈຳເປັນ?';
$string['windowclosing'] = 'ປ່ອງຢ້ຽມນີ້ຄວນປິດອັດຕະໂນມັດ. ຖ້າບໍ່, ກະລຸນາປິດມັນດຽວນີ້.';
$string['withchosenfiles'] = 'ໂດຍໄຟລ໌ທີ່ເລືອກ';
$string['withdisablednote'] = '{$a} (ປິດໃຊ້ງານ)';
$string['withoutuserdata'] = 'ບໍ່ລວມຂໍ້ມູນຜູ້ໃຊ້';
$string['withselectedusers'] = 'ລວມຜູ້ໃຊ້ທີ່ເລືອກ';
$string['withuserdata'] = 'ລວມຂໍ້ມູນຜູ້ໃຊ້';
$string['wordforstudent'] = 'ຄຳເວົ້າຂອງທ່ານສຳລັບນັກຮຽນ';
$string['wordforstudenteg'] = 'ເຊັ່ນ: ນັກຮຽນ, ຜູ້ເຂົ້າຮ່ວມ ແລະ ອື່ນໆ';
$string['wordforstudents'] = 'ຄຳເວົ້າຂອງທ່ານສຳລັບນັກຮຽນ';
$string['wordforstudentseg'] = 'ເຊັ່ນ: ບັນດານັກຮຽນ, ຜູ້ເຂົ້າຮ່ວມ ແລະ ອື່ນໆ';
$string['wordforteacher'] = 'ຄຳເວົ້າຂອງທ່ານສຳລັບຄູສອນ';
$string['wordforteachereg'] = 'ເຊັ່ນ: ອາຈານ, ຄູສອນເພີ່ມ, ຜູ້ອຳນວຍຄວາມສະດວກ ແລະ ອື່ນໆ';
$string['wordforteachers'] = 'ຄຳເວົ້າຂອງທ່ານສຳລັບຄູສອນ';
$string['wordforteacherseg'] = 'ເຊັ່ນ: ບັນດາອາຈານ, ຄູສອນເພີ່ມ, ຜູ້ອຳນວຍຄວາມສະດວກ ແລະ ອື່ນໆ';
$string['writingblogsinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນບລ໋ອກ';
$string['writingcategoriesandquestions'] = 'ກຳລັງຂຽນບັນດາປະເພດ ແລະ ຄໍາຖາມ';
$string['writingcoursedata'] = 'ກຳລັງຂຽນຂໍ້ມູນລາຍວິຊາ';
$string['writingeventsinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນເຫດການຕ່າງໆ';
$string['writinggeneralinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນທົ່ວໄປ';
$string['writinggradebookinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນປື້ມຄະແນນ';
$string['writinggroupingsgroupsinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນການຈັດກຸ່ມ-ກຸ່ມ';
$string['writinggroupingsinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນການຈັດກຸ່ມ';
$string['writinggroupsinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນກຸ່ມ';
$string['writingheader'] = 'ກຳລັງຂຽນຫົວຂໍ້';
$string['writingloginfo'] = 'ກຳລັງຂຽນຂໍ້ມູນບັນທຶກ';
$string['writingmessagesinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນຂໍ້ຄວາມ';
$string['writingmoduleinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນຊຸດ';
$string['writingscalesinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນມາດວັດ';
$string['writinguserinfo'] = 'ກຳລັງຂຽນຂໍ້ມູນຜູ້ໃຊ້';
$string['wrongpassword'] = 'ລະຫັດຜ່ານບໍ່ຖືກຕ້ອງສໍາລັບຊື່ຜູ້ໃຊ້ນີ້';
$string['yahooid'] = 'ລະຫັດ ID ຂອງ Yahoo';
$string['year'] = 'ປີ';
$string['years'] = 'ປີ';
$string['yes'] = 'ແມ່ນແລ້ວ';
$string['youareabouttocreatezip'] = 'ທ່ານກຳລັງຈະສ້າງໄຟລ໌ zip ທີ່ບັນຈຸມີ';
$string['youaregoingtorestorefrom'] = 'ທ່ານກຳລັງຈະເລີ່ມຂັ້ນຕອນການກູ້ຄືນ ສຳລັບ';
$string['youhaveupcomingactivitiesdue'] = 'ທ່ານມີກິດຈະກຳຮອດກຳນົດທີ່ຈະມາເຖິງ';
$string['youhaveupcomingactivitiesdueinfo'] = 'ສະບາຍດີ {$a},

<br/><br/>ທ່ານມີກິດຈະກຳຮອດກຳນົດທີ່ຈະມາເຖິງ:';
$string['youneedtoenrol'] = 'ເພື່ອປະຕິບັດການປະຕິບັດນັ້ນ ທ່ານຈຳເປັນຕ້ອງລົງທະບຽນໃນລາຍວິຊານີ້.';
$string['yourlastlogin'] = 'ການເຂົ້າສູ່ລະບົບຄັ້ງສຸດທ້າຍຂອງທ່ານແມ່ນ';
$string['yourself'] = 'ທ່ານເອງ';
$string['yourteacher'] = '{$a} ຂອງທ່ານ';
$string['yourwordforx'] = 'ຄຳເວົ້າຂອງທ່ານສຳລັບ \'{$a}\'';
$string['zippingbackup'] = 'ກຳລັງບີບອັດຂໍ້ມູນສຳຮອງ';
