<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'lo', version '4.0'.
 *
 * @package     mnet
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (ລົງຊື່ເຂົ້າໃຊ້ດ້ວຍຕົວເອງ)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (ລົງຊື່ເຂົ້າໃຊ້)';
$string['RPC_HTTP_PLAINTEXT'] = 'ບໍ່ໄດ້ເຂົ້າລະຫັດ HTTPS';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTPS (ລົງຊື່ເຂົ້າໃຊ້ດ້ວຍຕົວເອງ)';
$string['RPC_HTTP_VERIFIED'] = 'HTTPS (ລົງຊື່ເຂົ້າໃຊ້)';
$string['aboutyourhost'] = 'ກ່ຽວກັບເຊີບເວີຂອງທ່ານ';
$string['accesslevel'] = 'ລະດັບການເຂົ້າເຖິງ';
$string['addhost'] = 'ເພີ່ມເຈົ້າພາບ';
$string['addnewhost'] = 'ເພີ່ມເຈົ້າພາບໃໝ່';
$string['addtoacl'] = 'ເພີ່ມເພື່ອເຂົ້າເຖິງການຄວບຄຸມ';
$string['allhosts'] = 'ເຈົ້າພາບທັງໝົດໝົດ';
$string['allhosts_no_options'] = 'ບໍ່ມີທາງເລືອກໃນການເບິ່ງຫຼາຍເຈົ້າພາບ';
$string['allow'] = 'ອະນຸຍາດ';
$string['applicationtype'] = 'ປະເພດໂປຼແກຼມ';
$string['authfail_nosessionexists'] = 'ການອະນຸຍາດລົ້ມເຫຼວ: ບໍ່ມີຊ່ວງເວລາ mnet.';
$string['authfail_sessiontimedout'] = 'ການອະນຸຍາດລົ້ມເຫຼວ: ໝົດເວລາຊ່ວງເວລາ mnet.';
$string['authfail_usermismatch'] = 'ການອະນຸຍາດລົ້ມເຫຼວ: ຜູ້ໃຊ້ບໍ່ກົງກັນ.';
$string['authmnetdisabled'] = 'ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງ MNet ແມ່ນ <strong>ປິດໃຊ້ງານ</strong>.';
$string['badcert'] = 'ສິ່ງນີ້ບໍ່ແມ່ນໃບຢັ້ງຢືນທີ່ຖືກຕ້ອງ.';
$string['certdetails'] = 'ລາຍລະອຽດການຢັ້ງຢືນ';
$string['configmnet'] = 'MNet ອະນຸຍາດໃຫ້ການສື່ສານຂອງເຄື່ອງແມ່ຂ່າຍນີ້ກັບເຄື່ອງແມ່ຂ່າຍ ຫຼື ບໍລິການອື່ນໆ.';
$string['couldnotgetcert'] = 'ບໍ່ພົບໃບຢັ້ງຢືນທີ່ <br />{$a}. <br />ເຈົ້າພາບອາດຈະຂັດຂ້ອງ ຫຼື ຖືກຕັ້ງຄ່າບໍ່ຖືກຕ້ອງ.';
$string['couldnotmatchcert'] = 'ອັນນີ້ບໍ່ກົງກັບໃບຢັ້ງຢືນການເຜີຍແຜ່ໂດຍ webserver ໃນປັດຈຸບັນ.';
$string['courses'] = 'ລາຍວິຊາ';
$string['courseson'] = 'ລາຍວິຊາເທິງ';
$string['current_transport'] = 'ການຂົນສົ່ງປະຈຸບັນ';
$string['currentkey'] = 'ລະຫັດສາທາລະນະປະຈຸບັນ';
$string['databaseerror'] = 'ບໍ່ສາມາດຂຽນລາຍລະອຽດໄປຫາຖານຂໍ້ມູນ.';
$string['deleteaserver'] = 'ກຳລັງລຶບເຊີບເວີ';
$string['deletedhostinfo'] = 'ເຈົ້າພາບນີ້ຖືກລຶບແລ້ວ. ຖ້າທ່ານຕ້ອງການທີ່ຈະບໍ່ລຶບມັນ, ປ່ຽນສະຖານະການລຶບກັບໄປຫາ \'ບໍ່\'.';
$string['deletedhosts'] = 'ລຶບເຈົ້າພາບ: {$a}';
$string['deletehost'] = 'ລຶບເຈົ້າພາບ';
$string['deletekeycheck'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບລະຫັດນີ້ອອກ?';
$string['deleteoutoftime'] = 'ໜ້າຈໍ 60 ວິນາທີຂອງທ່ານສຳລັບການລຶບລະຫັດນີ້ໝົດອາຍຸແລ້ວ. ກະລຸນາເລີ່ມຕົ້ນອີກຄັ້ງ.';
$string['deleteuserrecord'] = 'SSO ACL: ລຶບບັນທຶກສຳລັບຜູ້ໃຊ້ \'{$a->user}\' ຈາກ {$a->host}.';
$string['deletewrongkeyvalue'] = 'ຂໍ້ຜິດພາດໄດ້ເກີດຂຶ້ນ. ຖ້າທ່ານບໍ່ໄດ້ພະຍາຍາມລຶບລະຫັດ SSL ຂອງເຊີເວີຂອງທ່ານ, ມັນເປັນໄປໄດ້ວ່າ ທ່ານເປັນຫົວເລື່ອງຂອງການໂຈມຕີທີ່ເປັນອັນຕະລາຍ. ບໍ່ມີການດໍາເນີນການໃດໆ.';
$string['deny'] = 'ປະຕິເສດ';
$string['description'] = 'ລາຍລະອຽດ';
$string['duplicate_usernames'] = 'ພວກເຮົາລົ້ມເຫຼວໃນການສ້າງດັດສະນີໃນຖັນ "mnethostid" ແລະ "ຊື່ຜູ້ໃຊ້" ໃນຕາຕະລາງຜູ້ໃຊ້ຂອງທ່ານ.<br />ນີ້ສາມາດເກີດຂຶ້ນໄດ້ເມື່ອທ່ານມີ <a href="{$a}" target="_blank">ຊື່ຜູ້ໃຊ້ຊໍ້າກັນໃນຕາຕະລາງຜູ້ໃຊ້ຂອງທ່ານ</a>.<br />ການຍົກລະດັບຂອງທ່ານຄວນຈະຍັງສໍາເລັດຢ່າງສົມບູນ. ໃຫ້ຄລິກໃສ່ການເຊື່ອມຕໍ່ຂ້າງເທິງ ແລະ ຄໍາແນະນໍາກ່ຽວກັບການແກ້ໄຂບັນຫານີ້ຈະປາກົດຢູ່ໃນໜ້າຈໍໃໝ່. ທ່ານສາມາດເຂົ້າຮ່ວມໃນຕອນທ້າຍຂອງການຍົກລະດັບ.<br />';
$string['enabled_for_all'] = '(ສະບັບນີ້ແມ່ນຖືກເປີດໃຊ້ງານສຳລັບເຈົ້າພາບໝົດທຸກຄົນ).';
$string['enterausername'] = 'ກະລຸນາໃສ່ຊື່ຜູ້ໃຊ້ ຫຼື ລາຍຊື່ຜູ້ໃຊ້ທີ່ແຍກອອກດ້ວຍເຄື່ອງໝາຍຈຸດ.';
$string['error7020'] = 'ຂໍ້ຜິດພາດນີ້ເກີດຂື້ນໂດຍປົກກະຕິຖ້າເວັບໄຊທ໌ທາງໄກ ໄດ້ສ້າງບັນທຶກສໍາລັບທ່ານດ້ວຍ wwwroot ທີ່ບໍ່ຖືກຕ້ອງ, ຕົວຢ່າງເຊັ່ນ: https://yoursite.com ແທນ https://www.yoursite.com. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງເວັບໄຊທ໌ທາງໄກດ້ວຍ wwwroot ຂອງທ່ານ (ຕາມທີ່ລະບຸໄວ້ໃນ config.php) ແລະ ຂໍໃຫ້ພວກເຂົາປັບປຸງບັນທຶກສໍາລັບເຈົ້າພາບຂອງທ່ານ.';
$string['error7022'] = 'ຂໍ້ຄວາມທີ່ທ່ານສົ່ງໄປຫາເວັບໄຊທ໌ທາງໄກໄດ້ຖືກເຂົ້າລະຫັດຢ່າງຖືກຕ້ອງ, ແຕ່ບໍ່ໄດ້ລົງຊື່ເຂົ້າໃຊ້. ສິ່ງນີ້ເປັນການບໍ່ຄາດຄິດຫຼາຍ; ທ່ານຄວນຍື່ນຂໍ້ບົກພ່ອງຖ້າວ່າສິ່ງນີ້ເກີດຂຶ້ນ (ໃຫ້ຂໍ້ມູນຫຼາຍເທົ່າທີ່ເປັນໄປໄດ້ກ່ຽວກັບສະບັບຂອງແອັບພລິເຄຊັນໃນຄໍາຖາມ ແລະອື່ນໆ).';
$string['error7023'] = 'ເວັບໄຊທ໌ທາງໄກໄດ້ພະຍາຍາມຖອດລະຫັດຂໍ້ຄວາມຂອງທ່ານ ດ້ວຍລະຫັດທັງໝົດທີ່ມັນມີຢູ່ໃນບັນທຶກສໍາລັບເວັບໄຊທ໌ຂອງທ່ານ. ພວກເຂົາເຈົ້າໄດ້ລົ້ມເຫຼວທັງຫມົດ. ທ່ານອາດຈະສາມາດແກ້ໄຂບັນຫານີ້ໄດ້ ໂດຍການກົດປຸ່ມຄືນໃໝ່ດ້ວຍຕົນເອງກັບເວັບໄຊທ໌ທາງໄກ. ສິ່ງນີ້ບໍ່ໜ້າຈະເກີດຂຶ້ນໄດ້ເວັ້ນເສຍແຕ່ວ່າ ທ່ານບໍ່ໄດ້ຕິດຕໍ່ສື່ສານກັບເວັບໄຊທ໌ທາງໄກເປັນເວລາສອງສາມເດືອນ.';
$string['error7024'] = 'ທ່ານສົ່ງຂໍ້ຄວາມທີ່ບໍ່ໄດ້ເຂົ້າລະຫັດໄປຫາເວັບໄຊທ໌ທາງໄກ, ແຕ່ເວັບໄຊທ໌ທາງໄກບໍ່ຍອມຮັບການສື່ສານທີ່ບໍ່ໄດ້ເຂົ້າລະຫັດຈາກເວັບໄຊທ໌ຂອງທ່ານ. ນີ້ແມ່ນບໍ່ຄາດຄິດຫຼາຍ; ທ່ານຄວນຈະຍື່ນຂໍ້ບົກພ່ອງຖ້າວ່າສິ່ງນີ້ເກີດຂຶ້ນ (ໃຫ້ຂໍ້ມູນຫຼາຍເທົ່າທີ່ເປັນໄປໄດ້ກ່ຽວກັບສະບັບຂອງແອັບພລິເຄຊັນ, ແລະອື່ນໆ).';
$string['error7026'] = 'ລະຫັດທີ່ຂໍ້ຄວາມຂອງທ່ານຖືກລົງນາມນັ້ນແຕກຕ່າງຈາກລະຫັດທີ່ເຈົ້າພາບທາງໄກມີຢູ່ໃນໄຟລ໌ໃຫ້ກັບເຊີເວີຂອງທ່ານ. ນອກຈາກນັ້ນ, ເຈົ້າພາບທາງໄກພະຍາຍາມດຶງເອົາລະຫັດປັດຈຸບັນຂອງທ່ານ ແລະ ເຮັດບໍ່ໄດ້. ກະລຸນາໃສ່ກະແຈດ້ວຍຕົນເອງກັບແມ່ຂ່າຍທາງໄກ ແລະ ພະຍາຍາມອີກເທື່ອໜຶ່ງ.';
$string['error709'] = 'ເວັບໄຊທ໌ທາງໄກລົ້ມເຫຼວເພື່ອຮັບເອົາສະຫັດ SSL ຈາກທ່ານ.';
$string['eventaccesscontrolcreated'] = 'ສ້າງການຄວບຄຸມການເຂົ້າຫາແລ້ວ';
$string['eventaccesscontrolupdated'] = 'ປັບປຸງການຄວບຄຸມການເຂົ້າຫາແລ້ວ';
$string['expired'] = 'ລະຫັດນີ້ໝົດອາຍຸໃນວັນທີ';
$string['expires'] = 'ໃຊ້ໄດ້ຈົນກວ່າ';
$string['expireyourkey'] = 'ລຶບລະຫັດນີ້';
$string['expireyourkeyexplain'] = 'Moodle ຈະໝຸນກະແຈຂອງທ່ານໂດຍອັດຕະໂນມັດທຸກໆ 28 ມື້ (ຕາມຄ່າເລີ່ມຕົ້ນ) ແຕ່ທ່ານມີທາງເລືອກທີ່ຈະ ໝົດອາຍຸລະຫັດນີ້ <em>ດ້ວຍຕົນເອງ</em> ໄດ້ທຸກເວລາ. ນີ້ຈະເປັນປະໂຫຍດພຽງແຕ່ຖ້າທ່ານເຊື່ອວ່າລະຫັດນີ້ຖືກລະເມີດ. ການທົດແທນຈະຖືກສ້າງຂື້ນໂດຍອັດຕະໂນມັດໃນທັນທີ.<br />ການລຶບລະຫັດນີ້ຈະເຮັດໃຫ້ແອັບພລິເຄຊັນອື່ນຕິດຕໍ່ສື່ສານກັບທ່ານບໍ່ໄດ້, ຈົນກວ່າທ່ານຈະຕິດຕໍ່ກັບຜູ້ເບິ່ງແຍງລະບົບແຕ່ລະຄົນດ້ວຍຕົນເອງ ແລະ ສະໜອງລະຫັດໃໝ່ໃຫ້ກັບເຂົາເຈົ້າ.';
$string['exportfields'] = 'ຊ່ອງຂໍ້ມູນເພື່ອສົ່ງອອກ';
$string['failedaclwrite'] = 'ລົ້ມເຫຼວໃນການຂຽນລາຍການຄວບຄຸມການເຂົ້າຫາຂອງ MNet ສຳລັບຜູ້ໃຊ້ \'{$a}\'.';
$string['findlogin'] = 'ຊອກຫາການລົງຊື່ເຂົ້າໃຊ້';
$string['forbidden-function'] = 'ຟັງຊັນນັ້ນບໍ່ໄດ້ຖືກເປີດໃຊ້ສໍາລັບ RPC.';
$string['forbidden-transport'] = 'ວິທີການຂົນສົ່ງທີ່ເຈົ້າພະຍາຍາມໃຊ້ແມ່ນບໍ່ໄດ້ຮັບອະນຸຍາດ.';
$string['forcesavechanges'] = 'ປ່ຽນແປງການບັນທຶກແບບບັງຄັບ';
$string['helpnetworksettings'] = 'ກຳນົດຄ່າການສື່ສານ MNet';
$string['hidelocal'] = 'ເຊື່ອງຜູ້ໃຊ້ທ້ອງຖີ່ນ';
$string['hideremote'] = 'ເຊື່ອງຜູ້ໃຊ້ທາງໄກ';
$string['host'] = 'ເຈົ້າພາບ';
$string['hostcoursenotfound'] = 'ບໍ່ພົບເຈົ້າພາບ ຫຼື ລາຍວິຊາ';
$string['hostdeleted'] = 'ລຶບເຈົ້າພາບ';
$string['hostexists'] = 'ບັນທຶກມີຢູ່ແລ້ວສຳລັບເຈົ້າພາບທີ່ມີ hostname ນັ້ນ (ມັນອາດຈະຖືກລຶບ). <a href="{$a}">ຄລິກທີ່ນີ້</a> ເພື່ອແກ້ໄຂບັນທຶກນັ້ນ.';
$string['hostlist'] = 'ລາຍການຂອງເຈົ້າພາບເຄື່ອຂ່າຍ';
$string['hostname'] = 'Hostname';
$string['hostnamehelp'] = 'ຊື່ໂດເມນທີ່ມີຄຸນສົມບັດຄົບຖ້ວນຂອງ ເຈົ້າພາບທາງໄກ, ເຊັ່ນ: www.example.com';
$string['hostnotconfiguredforsso'] = 'ເຊີເວີນີ້ບໍ່ໄດ້ຖືກກຳນົດຄ່າສຳລັບການເຂົ້າສູ່ລະບົບທາງໄກ.';
$string['hostsettings'] = 'ການຕັ້ງຄ່າເຈົ້າພາບ';
$string['http_self_signed_help'] = 'ອະນຸຍາດການເຊື່ອມຕໍ່ໂດຍການນຳໃຊ້ ໃບຢັ້ງຢືນ DIY SSL ລົງຊື່ເຂົ້າໃຊ້ດ້ວຍຕົວເອງເທິງເຈົ້າພາບທາງໄກ.';
$string['http_verified_help'] = 'ອະນຸຍາດໃຫ້ເຊື່ອມຕໍ່ໂດຍໃຊ້ໃບຢັ້ງຢືນ SSL ທີ່ຖືກຢືນຢັນໃນ PHP ໃນເຈົ້າພາບທາງໄກ, ແຕ່ຜ່ານ http (ບໍ່ແມ່ນ https).';
$string['https_self_signed_help'] = 'ອະນຸຍາດໃຫ້ເຊື່ອມຕໍ່ໂດຍໃຊ້ DIY SSL ທີ່ລົງຊື່ເຂົ້າໃຊ້ດ້ວຍຕົວເອງໃນ PHP ຢູ່ໃນເຈົ້າພາບທາງໄກຜ່ານ http.';
$string['https_verified_help'] = 'ອະນຸຍາດໃຫ້ການເຊື່ອມຕໍ່ການນໍາໃຊ້ໃບຢັ້ງຢືນ SSL ກວດສອບຢູ່ໃນແມ່ຂ່າຍທາງໄກ.';
$string['id'] = 'ລະຫັດປະຈຳຕົວ';
$string['idhelp'] = 'ຄ່ານີ້ຖືກກຳນົດໂດຍອັດຕະໂນມັດ ແລະ ບໍ່ສາມາດປ່ຽນແປງໄດ້';
$string['importfields'] = 'ຊ່ອງຂໍ້ມູນເພື່ອນຳເຂົ້າ';
$string['inspect'] = 'ກວດສອບ';
$string['installnosuchfunction'] = 'ລະຫັດຜິດພາດ! ມີບາງຢ່າງກຳລັງພະຍາຍາມຕິດຕັ້ງຟັງຊັນ mnet xmlrpc ({$a->method}) ຈາກໄຟລ໌ ({$a->file}) ແລະ ມັນບໍ່ພົບ!';
$string['installnosuchmethod'] = 'ລະຫັດຜິດພາດ! ມີບາງຢ່າງກຳລັງພະຍາຍາມຕິດຕັ້ງວິທີການ mnet xmlrpc ({$a->method}) ຢູ່ໃນຫ້ອງຮຽນ ({$a->class}) ແລະ ມັນບໍ່ພົບ!';
$string['installreflectionclasserror'] = 'ລະຫັດຜິດພາດ! ການກວດກາ MNet ລົ້ມເຫຼວສຳລັບວິທີການ \'{$a->method}\' ໃນຫ້ອງຮຽນ \'{$a->class}\'. ຂໍ້ຄວາມຂໍ້ຜິດພາດຕົ້ນສະບັບ, ໃນກໍລະນີທີ່ມັນຊ່ວຍ, ແມ່ນ: \'{$a->error}\'';
$string['installreflectionfunctionerror'] = 'ລະຫັດຜິດພາດ! ການກວດກາ MNet ລົ້ມເຫຼວສຳລັບການທຳງານ \'{$a->method}\' ໃນໄຟລ໌ \'{$a->file}\'. ຂໍ້ຄວາມຂໍ້ຜິດພາດຕົ້ນສະບັບ, ໃນກໍລະນີທີ່ມັນຊ່ວຍ, ແມ່ນ: \'{$a->error}\'';
$string['invalidaccessparam'] = 'ຕົວກຳນົດເຂົ້າຫາບໍ່ຖືກຕ້ອງ';
$string['invalidactionparam'] = 'ຕົວກຳນົດການປະຕິບັດບໍ່ຖືກຕ້ອງ';
$string['invalidhost'] = 'ທ່ານຕ້ອງສະໜອງຕົວລະບຸເຈົ້າພາບທີ່ຖືກຕ້ອງ';
$string['invalidpubkey'] = 'ລະຫັດນີ້ບໍ່ແມ່ນລະຫັດ SSL ທີ່ຖືກຕ້ອງ. ({$a})';
$string['invalidurl'] = 'ຕົວກຳນົດ URL ບໍ່ຖືກຕ້ອງ.';
$string['ipaddress'] = 'ທີ່ຢູ່ IP';
$string['is_in_range'] = 'ທີ່ຢູ່ IP <code>{$a}</code> ເປັນຕົວແທນຂອງເຈົ້າພາບທີ່ເຊື່ອຖືໄດ້ທີ່ຖືກຕ້ອງ.';
$string['ispublished'] = '{$a} ໄດ້ເປີດໃຊ້ງານການບໍລິການນີ້ສຳລັບທ່ານ.';
$string['issubscribed'] = '{$a} ກຳລັງຈອງການບໍລິການນີ້ເທິງເຈົ້າພາບຂອງທ່ານ.';
$string['keydeleted'] = 'ລະຫັດຂອງທ່ານຖືກລຶບ ແລະ ປ່ຽນແທນຢ່າງສຳເລັດ.';
$string['keymismatch'] = 'ລະຫັດສາທາລະນະທີ່ທ່ານກຳລັງຖືສຳລັບເຈົ້າພາບນີ້ແມ່ນແຕກຕ່າງຈາກລະຫັດສາທາລະນະທີ່ກຳລັງເຜີຍແຜ່ໃນປະຈຸບັນ. ລະຫັດສາທາລະນະທີ່ກຳລັງເຜີຍແຜ່ໃນປະຈຸບັນແມ່ນ:';
$string['last_connect_time'] = 'ເວລາການເຊື່ອມຕໍ່ຫຼ້າສຸດ';
$string['last_connect_time_help'] = 'ເວລາທີ່ທ່ານເຊື່ອມຕໍ່ຫາເຈົ້າພາບນີ້ຄັ້ງສຸດທ້າຍ.';
$string['last_transport_help'] = 'ການຂົນສົ່ງທີ່ທ່ານໃຊ້ສໍາລັບການເຊື່ອມຕໍ່ສຸດທ້າຍກັບເຈົ້າພາບນີ້.';
$string['leavedefault'] = 'ໃຊ້ການຕັ້ງຄ່າເລີ່ມຕົ້ນແທນ';
$string['listservices'] = 'ລາຍການບໍລິການ';
$string['loginlinkmnetuser'] = '<br />ຖ້າທ່ານເປັນຜູ້ໃຊ້ທາງໄກຂອງ MNet ແລະ ສາມາດ <a href="{$a}">ຢືນຢັນທີ່ຢູ່ອີເມລຂອງທ່ານທີ່ນີ້</a>, ທ່ານສາມາດຖືກໂອນໄປຫາໜ້າເຂົ້າສູ່ລະບົບຂອງທ່ານໄດ້.<br />';
$string['logs'] = 'ບັນທຶກ';
$string['managemnetpeers'] = 'ຈັດການກັບໝູ່ເພື່ອນ';
$string['method'] = 'ວິທີການ';
$string['methodhelp'] = 'ວິທີການຊ່ວຍເຫຼືອສຳລັບ {$a}';
$string['methodsavailableonhost'] = 'ວິທີການທີ່ມີໃຫ້ໃນ {$a}';
$string['methodsavailableonhostinservice'] = 'ວິທີການຊ່ວຍເຫຼືອສຳລັບ {$a->service} ໃນ {$a->host}';
$string['methodsignature'] = 'ວິທີການເຊັນສັນຍາສຳລັບ {$a}';
$string['mnet'] = 'MNet';
$string['mnet_concatenate_strings'] = 'Concatenate (ເຖິງ) 3 ສະຕິງ ແລະ ສົ່ງຜົນໄດ້ຮັບ';
$string['mnet_session_prohibited'] = 'ຜູ້ໃຊ້ຈາກເຊີບເວີໃນເຮືອນຂອງທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເລາະໄປຫາ {$a}.';
$string['mnetdisabled'] = 'MNet ແມ່ນ <strong>ປິດໃຊ້ງານ</strong>.';
$string['mnetidprovider'] = 'ຜູ້ໃຫ້ບໍລິການລະຫັດປະຈຳຕົວ MNet';
$string['mnetidproviderdesc'] = 'ທ່ານສາມາດນໍາໃຊ້ສະຖານທີ່ນີ້ ເພື່ອດຶງຂໍ້ມູນການເຊື່ອມຕໍ່ທີ່ທ່ານສາມາດເຂົ້າສູ່ລະບົບໄດ້, ຖ້າຫາກວ່າ ທ່ານສາມາດສະໜອງທີ່ຢູ່ອີເມລ໌ທີ່ຖືກຕ້ອງກັບຊື່ຜູ້ໃຊ້ທີ່ທ່ານໄດ້ພະຍາຍາມເຂົ້າສູ່ລະບົບໃນເມື່ອກ່ອນ.';
$string['mnetidprovidermsg'] = 'ທ່ານຄວນຈະສາມາດເຂົ້າສູ່ລະບົບທີ່ຜູ້ໃຫ້ບໍລິການ {$a} ຂອງທ່ານໄດ້.';
$string['mnetidprovidernotfound'] = 'ຂໍອະໄພ, ແຕ່ບໍ່ພົບຂໍ້ມູນເພີ່ມເຕີມ.';
$string['mnetpeers'] = 'ໝູ່ເພື່ອນ';
$string['mnetservices'] = 'ການບໍລິການ';
$string['mnetsettings'] = 'ການຕັ້ງຄ່າ MNet';
$string['moodle_home_help'] = 'ເສັ້ນທາງໄປຫາໜ້າທໍາອິດຂອງໂປຼແກຼມ MNet ຢູ່ໃນເຈົ້າພາບຫ່າງໄກ, ເຊັ່ນ: /moodle/.';
$string['name'] = 'ຊື່';
$string['net'] = 'ເຄື່ອຂ່າຍ';
$string['networksettings'] = 'ການຕັ້ງຄ່າ ເຄື່ອຂ່າຍ';
$string['never'] = 'ບໍ່ເຄີຍ';
$string['noaclentries'] = 'ບໍ່ມີລາຍການໃນລາຍການຄວບຄຸມການເຂົ້າຫາ SSO';
$string['noaddressforhost'] = 'ຂໍອະໄພ, ຊື່ເຈົ້າພາບນັ້ນ ({$a}) ບໍ່ສາມາດແກ້ໄຂໄດ້!';
$string['nocurl'] = 'ຫ້ອງສະໝຸດ PHP cURL ຍັງບໍ່ໄດ້ຕິດຕັ້ງ';
$string['nolocaluser'] = 'ບໍ່ມີການບັນທຶກທ້ອງຖິ່ນສໍາລັບຜູ້ໃຊ້ທາງໄກ ແລະ ມັນບໍ່ສາມາດສ້າງໄດ້, ເນື່ອງຈາກວ່າເຈົ້າພາບນີ້ ຈະບໍ່ສ້າງຜູ້ໃຊ້ອັດຕະໂນມັດ. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບຂອງທ່ານ!';
$string['nomodifyacl'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ແກ້ໄຂລາຍການຄວບຄຸມການເຂົ້າເຖິງ MNet.';
$string['nonmatchingcert'] = 'ເລື່ອງຂອງໃບຢັ້ງຢືນ: <br /><em>{$a->subject}</em><br />ບໍ່ກົງກັບເຈົ້າພາບທີ່ມັນມາຈາກ:<br /><em>{$a->host}</em>.';
$string['nopubkey'] = 'ມີບັນຫາໃນການດຶງລະຫັດສາທາລະນະ.<br />ບາງທີເຈົ້າພາບບໍ່ອະນຸຍາດໃຫ້ MNet ຫຼື ລະຫັດບໍ່ຖືກຕ້ອງ.';
$string['nosite'] = 'ບໍ່ສາມາດຊອກຫາເວັບໄຊທ໌ລະດັບລາຍວິຊາ';
$string['nosuchfile'] = 'ໄຟລ໌/ການທຳງານ {$a} ແມ່ນບໍ່ມີຢູ່';
$string['nosuchfunction'] = 'ບໍ່ສາມາດຊອກຫາຟັງຊັນ ຫຼື ຟັງຊັນຖືກຫ້າມສໍາລັບ RPC.';
$string['nosuchmodule'] = 'ຟັງຊັນຖືກແກ້ໄຂບໍ່ຖືກຕ້ອງ ແລະ ບໍ່ສາມາດຕັ້ງໄດ້. ກະລຸນາໃຊ້
mod/modulename/lib/functionname format.';
$string['nosuchpublickey'] = 'ບໍ່ສາມາດຮັບລະຫັດສາທາລະນະສຳລັບການຢັ້ງຢືນລາຍເຊັນ.';
$string['nosuchservice'] = 'ການບໍລິການ RPC ແມ່ນບໍ່ສາມາດແລ່ນໃນເຈົ້າພາບນີ້ໄດ້.';
$string['nosuchtransport'] = 'ບໍ່ມີການຂົນສົ່ງທີ່ມີລະຫັດປະຈໍາຕົວ.';
$string['notBASE64'] = 'ສະຕຣິງນີ້ບໍ່ໄດ້ຢູ່ໃນຮູບແບບທີ່ເຂົ້າລະຫັດ base64. ມັນບໍ່ສາມາດເປັນລະຫັດທີ່ຖືກຕ້ອງໄດ້.';
$string['notPEM'] = 'ລະຫັດນີ້ບໍ່ໄດ້ຢູ່ໃນຮູບແບບ PEM. ມັນຈະບໍ່ເຮັດວຽກ.';
$string['not_in_range'] = 'ທີ່ຢູ່ IP <code>{$a}</code> ບໍ່ໄດ້ເປັນຕົວແທນຂອງເຊີເວີທີ່ເຊື່ອຖືໄດ້ທີ່ຖືກຕ້ອງ.';
$string['notenoughidpinfo'] = 'ຜູ້ໃຫ້ບໍລິການລະບຸຕົວຕົນຂອງທ່ານ ບໍ່ໄດ້ໃຫ້ຂໍ້ມູນພຽງພໍແກ່ພວກເຮົາເພື່ອສ້າງ ຫຼື ປັບປຸງບັນຊີຂອງທ່ານຢູ່ໃນທ້ອງຖິ່ນ. ຂໍອາໄພ!';
$string['notinxmlrpcserver'] = 'ຄວາມພະຍາຍາມທີ່ຈະເຂົ້າເຖິງລູກຄ້າທາງໄກ MNet, ບໍ່ແມ່ນໃນລະຫວ່າງການປະຕິບັດເຄື່ອງແມ່ຂ່າຍ XMLRPC';
$string['notmoodleapplication'] = 'ຄໍາເຕືອນ: ນີ້ບໍ່ແມ່ນຄໍາຮ້ອງສະໝັກ Moodle, ດັ່ງນັ້ນ ບາງວິທີການກວດກາອາດຈະບໍ່ເຮັດວຽກຢ່າງຖືກຕ້ອງ.';
$string['notpermittedtojump'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເລີ່ມໄລຍະເວລາທາງໄກຈາກເຊີບເວີ Moodle ນີ້.';
$string['notpermittedtojumpas'] = 'ທ່ານບໍ່ສາມາດເລີ່ມໄລຍະເວລາທາງໄກໄດ້ ໃນຂະນະທີ່ທ່ານເຂົ້າສູ່ລະບົບເປັນຜູ້ໃຊ້ອື່ນ.';
$string['notpermittedtoland'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເລີ່ມໄລຍະເວລາທາງໄກ.';
$string['off'] = 'ປິດ';
$string['on'] = 'ເປີດ';
$string['options'] = 'ທາງເລືອກ';
$string['peerprofilefielddesc'] = 'ໃນທີ່ນີ້ທ່ານສາມາດລົບລ້າງການຕັ້ງຄ່າທົ່ວໂລກສໍາລັບຊ່ອງໂປຼໄຟລ໌ທີ່ຈະສົ່ງ ແລະ ນໍາເຂົ້າໃນເວລາທີ່ຜູ້ໃຊ້ໃໝ່ໄດ້ຖືກສ້າງ';
$string['permittedtransports'] = 'ການຂົນສົ່ງທີ່ໄດ້ອະນຸຍາດ';
$string['phperror'] = 'ຂໍ້ຜິດພາດພາຍໃນ PHP ປ້ອງກັນບໍ່ໃຫ້ຄໍາຮ້ອງຂໍຂອງທ່ານຖືກປະຕິບັດ.';
$string['position'] = 'ຕຳແໜ່ງ';
$string['postrequired'] = 'ການທຳງານທີ່ລຶບຕ້ອງການການຮ້ອງຂໍ POST.';
$string['privacy:metadata'] = 'ປັ໊ກອິນ MNet ບໍ່ເກັບຮັກສາຂໍ້ມູນສ່ວນຕົວໃດໆ.';
$string['profileexportfields'] = 'ຊ່ອງຂໍ້ມູນທີ່ຈະສົ່ງ';
$string['profilefielddesc'] = 'ທີ່ນີ້ທ່ານສາມາດກໍານົດບັນຊີລາຍຊື່ຂອງຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ທີ່ຖືກສົ່ງ ແລະ ຮັບຜ່ານ MNet ເມື່ອບັນຊີຜູ້ໃຊ້ຖືກສ້າງ, ຫຼື ປັບປຸງ. ນອກນັ້ນທ່ານຍັງສາມາດລົບລ້າງສິ່ງນີ້ສໍາລັບແຕ່ລະ MNet ໝູ່ເພື່ອນແຕ່ລະຄົນ. ກະລຸນາຮັບຊາບວ່າ ຊ່ອງຂໍ້ມູນຕໍ່ໄປນີ້ຈະຖືກສົ່ງສະເໝີ ແລະ ບໍ່ແມ່ນທາງເລືອກ: {$a}';
$string['profilefields'] = 'ຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌';
$string['profileimportfields'] = 'ຊ່ອງຂໍ້ມູນທີ່ຈະນຳເຂົ້າ';
$string['promiscuous'] = 'ຫຼາກຫຼາຍ';
$string['publickey'] = 'ລະຫັດ';
$string['publickey_help'] = 'ລະຫັດສາທາລະນະແມ່ນໄດ້ຮັບອັດຕະໂນມັດຈາກເຊີເວີທາງໄກ.';
$string['publickeyrequired'] = 'ທ່ານຕ້ອງໄດ້ສະໜອງລະຫັດສາທາລະນະ.';
$string['publish'] = 'ເຜີຍແຜ່';
$string['reallydeleteserver'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບເຊີເວີ?';
$string['receivedwarnings'] = 'ຄຳເຕືອນຕໍ່ໄປນີ້ແມ່ນໄດ້ຮັບແລ້ວ';
$string['recordnoexists'] = 'ບັນທຶກບໍ່ມີຢູ່.';
$string['reenableserver'] = 'ບໍ່ - ເລືອກທາງເລືອກເພື່ອເປີດໃຊ້ງານເຊີເວີນີ້ຄືນໃໝ່.';
$string['registerallhosts'] = 'ລົງທະບຽນເຈົ້າພາບທັງໝົດ (ໂໝດຫຼາກຫຼາຍ)';
$string['registerallhostsexplain'] = 'ທ່ານສາມາດເລືອກທີ່ຈະລົງທະບຽນເຈົ້າພາບທັງໝົດທີ່ພະຍາຍາມເຊື່ອມຕໍ່ກັບທ່ານໂດຍອັດຕະໂນມັດ. ນີ້ໝາຍຄວາມວ່າ ບັນທຶກຈະປາກົດຢູ່ໃນລາຍຊື່ເຈົ້າພາບຂອງທ່ານສໍາລັບເວັບໄຊທ໌ MNet ໃດໆທີ່ເຊື່ອມຕໍ່ກັບທ່ານ ແລະ ຮ້ອງຂໍລະຫັດສາທາລະນະຂອງທ່ານ.<br />ທ່ານມີທາງເລືອກຂ້າງລຸ່ມນີ້ ເພື່ອກໍານົດຄ່າບໍລິການສໍາລັບ \'ເຈົ້າພາບທັງໝົດ\' ແລະ ໂດຍການເປີດການບໍລິການບາງຢ່າງຢູ່ທີ່ນັ້ນ, ທ່ານສາມາດໃຫ້ບໍລິການກັບເຊີເວີທາງໄກໃດໆໂດຍບໍ່ຈຳແນກ.';
$string['registerhostsoff'] = 'ລົງທະບຽນເຈົ້າພາບທັງໝົດແມ່ນ <b>ປິດ</b> ໃນປະຈຸບັນ';
$string['registerhostson'] = 'ລົງທະບຽນເຈົ້າພາບທັງໝົດແມ່ນ <b>ເປີດ</b> ໃນປະຈຸບັນ';
$string['remotecourses'] = 'ລາຍວິຊາທາງໄກ';
$string['remotehost'] = 'ເຈົ້າພາບທາງໄກ';
$string['remotehosts'] = 'ບັນດາເຈົ້າພາບທາງໄກ';
$string['remoteuser'] = 'ຜູ້ໃຊ້  {$a->remotetype} ທາງໄກ';
$string['remoteuserinfo'] = 'ຂໍ້ມູນມາຈາກ <a href="{$a->remoteurl}">{$a->remotename}</a>';
$string['requiresopenssl'] = 'ເຄື່ອງຂ່າຍຕ້ອງການສ່ວນຂະຫຍາຍ OpenSSL';
$string['restore'] = 'ຟຶ້ນຟູ';
$string['returnvalue'] = 'ຂໍ້ມູນກັບຄືນ';
$string['reviewhostdetails'] = 'ທົບທວນຄືນລາຍລະອຽດເຈົ້າພາບ';
$string['reviewhostservices'] = 'ທົບທວນຄືນການບໍລິການເຈົ້າພາບ';
$string['selectaccesslevel'] = 'ກະລຸນາເລືອກການເຂົ້າຫາລະດັບຈາກລາຍການ.';
$string['selectahost'] = 'ກະລຸນາເລືອກເຈົ້າພາບທາງໄກ.';
$string['service'] = 'ຊື່ການບໍລິການ';
$string['serviceid'] = 'ລະຫັດປະຈຳຕົວບໍລິການ';
$string['servicesavailableonhost'] = 'ການບໍລິການມີໃຫ້ເທິງ {$a}';
$string['serviceswepublish'] = 'ການບໍລິການທີ່ພວກເຮົາເຜີຍແຜ່ຫາ {$a}.';
$string['serviceswesubscribeto'] = 'ການບໍລິການໃນ {$a} ທີ່ພວກເຮົາຈອງກັບ.';
$string['settings'] = 'ການຕັ້ງຄ່າ';
$string['showlocal'] = 'ສະແດງຜູ້ໃຊ້ທ້ອງຖີ່ນ';
$string['showremote'] = 'ສະແດງຜູ້ໃຊ້ທາງໄກ';
$string['ssl_acl_allow'] = 'SSO ACL: ອະນຸຍາດຜູ້ໃຊ້ \'{$a->user}\' ຈາກ \'{$a->host}\'';
$string['ssl_acl_deny'] = 'SSO ACL: ປະຕິເສດຜູ້ໃຊ້ \'{$a->user}\' ຈາກ \'{$a->host}\'';
$string['sslverification'] = 'ການຢືນຢັນ SSL';
$string['sslverification_help'] = 'ຕົວເລືອກນີ້ຊ່ວຍໃຫ້ທ່ານສາມາດຕັ້ງຄ່າລະດັບຄວາມປອດໄພໃນເວລາທີ່ເຊື່ອມຕໍ່ກັບເພື່ອນມິດໂດຍໃຊ້ HTTPS.

* ບໍ່ມີ: ບໍ່ມີລະດັບຄວາມປອດໄພ
* ຢືນຢັນເຈົ້າພາບເທົ່ານັ້ນ: ກວດສອບໂດເມນຂອງໃບຢັ້ງຢືນ SSL
* ຢືນຢັນເຈົ້າພາບ ແລະ ຄູ່ຮຽນ (ແນະນຳ): ກວດສອບໂດເມນ ແລະ ຜູ້ອອກໃບຢັ້ງຢືນ SSL';
$string['ssoaccesscontrol'] = 'ຄວບຄຸມການເຂົ້າຫາ SSO';
$string['ssoacldescr'] = 'ໃຊ້ໜ້ານີ້ເພື່ອໃຫ້/ປະຕິເສດການເຂົ້າເຖິງຜູ້ໃຊ້ສະເພາະຈາກເຈົ້າພາບ MNet ທາງໄກ. ນີ້ແມ່ນເປັນປະໂຫຍດໃນເວລາທີ່ທ່ານກໍາລັງໃຫ້ບໍລິການ SSO ໃຫ້ກັບຜູ້ໃຊ້ທາງໄກ. ເພື່ອຄວບຄຸມຄວາມສາມາດຂອງຜູ້ໃຊ້ <em>ທ້ອງຖິ່ນ</em> ຂອງທ່ານໃນການເລາະໄປຫາເຈົ້າພາບ MNet ອື່ນໆ, ໃຫ້ໃຊ້ລະບົບບົດບາດ ເພື່ອໃຫ້ຄວາມສາມາດ <em>mnetlogintoremote</em> ໃຫ້ເຂົາເຈົ້າ.';
$string['ssoaclneeds'] = 'ເພື່ອໃຫ້ການທຳງານນີ້ເຮັດວຽກໄດ້, ທ່ານຕ້ອງເປີດ Networking, ບວກກັບປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງ MNet ຖືກເປີດໃຊ້.';
$string['strict'] = 'ເຂັ້ມງວດ';
$string['subscribe'] = 'ຈອງ';
$string['system'] = 'ລະບົບ';
$string['testclient'] = 'ລູກຄ້າທົດສອບ MNet';
$string['testtrustedhosts'] = 'ທົດສອບທີ່ຢູ່';
$string['testtrustedhostsexplain'] = 'ໃສ່ທີ່ຢູ່ IP ເພື່ອເບິ່ງຖ້າວ່າມັນແມ່ນເຈົ້າທີ່ໜ້າເຊື່ອຖື.';
$string['theypublish'] = 'ພວກເຂົາເຜີຍແຜ່';
$string['theysubscribe'] = 'ພວກເຂົາຈອງ';
$string['transport_help'] = 'ທາງເລືອກເຫຼົ່ານີ້ເປັນແບບສ່ວນກັບກັນ, ດັ່ງນັ້ນ ທ່ານພຽງແຕ່ສາມາດບັງຄັບໃຫ້ເຈົ້າພາບທາງໄກໃຊ້ໃບຢັ້ງຢືນ SSL ທີ່ເຊັນແລ້ວຖ້າເຄື່ອງແມ່ຂ່າຍຂອງທ່ານມີໃບຢັ້ງຢືນ SSL ທີ່ເຊັນ.';
$string['trustedhosts'] = 'ເຈົ້າພາບ XML-RPC';
$string['trustedhostsexplain'] = '<p>ກົນໄກການເປັນເຈົ້າພາບທີ່ເຊື່ອຖືໄດ້ ອະນຸຍາດໃຫ້ເຄື່ອງຈັກສະເພາະເພື່ອດໍາເນີນການໂທຜ່ານ XML-RPC ໄປຫາສ່ວນໃດໜຶ່ງຂອງ Moodle API. ນີ້ມີໃຫ້ສະຄຣິບເພື່ອຄວບຄຸມພຶດຕິກຳຂອງ Moodle ແລະ ສາມາດເປັນທາງເລືອກທີ່ອັນຕະລາຍຫຼາຍໃນການເປີດໃຊ້ງານ. ຖ້າສົງໃສ, ໃຫ້ປິດມັນໄວ້.</p>
<p><strong>ສິ່ງນີ້ບໍ່ຈໍາເປັນສໍາລັບຄຸນສົມບັດມາດຕະຖານ MNet ໃດໜຶ່ງ!</strong> ເປີດມັນພຽງແຕ່ຖ້າຫາກວ່າ ທ່ານຮູ້ວ່າທ່ານກໍາລັງເຮັດຫຍັງ.</p>
<p>ເພື່ອເປີດໃຊ້ມັນ, ກະລຸນາໃສ່ລາຍຊື່ຂອງທີ່ຢູ່ IP ຫຼື ເຄືອຂ່າຍ,
ໜຶ່ງໃນແຕ່ລະເສັ້ນ. ບາງຕົວຢ່າງ:</p>
ເຈົ້າພາບທ້ອງຖິ່ນຂອງທ່ານ:<br />127.0.0.1<br />ເຈົ້າພາບທ້ອງຖິ່ນຂອງທ່ານ (ດ້ວຍການບລັອກເຄືອຂ່າຍ):<br />127.0.0.1/32<br />ສະເພາະເຈົ້າພາບທີ່ມີທີ່ຢູ່ IP 192.168.0.7:<br />192.168.0.7/32<br />ເຈົ້າພາບໃດໜຶ່ງກໍຕາມທີ່ມີທີ່ຢູ່ IP ລະຫວ່າງ 192.168.0.1 ແລະ 192.168.0.255:<br />192.168.0.0/24<br />ເຈົ້າພາບໃດກໍໄດ້:<br />192.168.0.0 /0<br />ແນ່ນອນຕົວຢ່າງສຸດທ້າຍແມ່ນ <strong>ບໍ່ແມ່ນ</strong> ການຕັ້ງຄ່າທີ່ແນະນໍາ.';
$string['turnitoff'] = 'ປິດມັນ';
$string['turniton'] = 'ເປີດມັນ';
$string['type'] = 'ປະເພດ';
$string['unknown'] = 'ບໍ່ຮູ້ຈັກ';
$string['unknownerror'] = 'ເກີດຂໍ້ຜິດພາດທີ່ບໍ່ຮູ້ຈັກໃນລະຫວ່າງການເຈລະຈາ.';
$string['usercannotchangepassword'] = 'ທ່ານບໍ່ສາມາດປ່ຽນລະຫັດຜ່ານຂອງທ່ານຢູ່ທີ່ນີ້ໄດ້ເນື່ອງຈາກທ່ານເປັນຜູ້ໃຊ້ທາງໄກ.';
$string['userchangepasswordlink'] = '<br /> ທ່ານອາດຈະສາມາດປ່ຽນລະຫັດຜ່ານຂອງທ່ານໄດ້ທີ່ຜູ້ໃຫ້ບໍລິການ <a href="{$a->wwwroot}/login/change_password.php">{$a->description</a> ຂອງທ່ານ.';
$string['usernotfullysetup'] = 'ບັນຊີຜູ້ໃຊ້ຂອງທ່ານບໍ່ສົມບູນ. ທ່ານຈໍາເປັນຕ້ອງໄປ <a href="{$a}">ກັບຄືນໄປຫາຜູ້ໃຫ້ບໍລິຂອງທ່ານ</a> ແລະ ໃຫ້ແນ່ໃຈວ່າຂໍ້ມູນຂອງທ່ານສໍາເລັດຢູ່ທີ່ນັ້ນ. ທ່ານອາດຈະຈໍາເປັນຕ້ອງໄດ້ອອກຈາກລະບົບ ແລະ ເຂົ້າສູ່ລະບົບອີກເທື່ອຫນຶ່ງເພື່ອໃຫ້ມີຜົນ.';
$string['usersareonline'] = 'ຄຳເຕືອນ: ຜູ້ໃຊ້ {$a} ຈາກເຊີບເວີນັ້ນເຂົ້າສູ່ລະບົບເວັບໄຊທ໌ຂອງທ່ານຢູ່.';
$string['validated_by'] = 'ມັນໄດ້ຖືກກວດສອບໂດຍເຄືອຂ່າຍ: <code>{$a}</code>';
$string['verifyhostandpeer'] = 'ຢືນຢັນເຈົ້າພາບ ແລະ ຄູ່ຮຽນ';
$string['verifyhostonly'] = 'ຢືນຢັນເຈົ້າພາບເທົ່ານັ້ນ';
$string['verifysignature-error'] = 'ລົ້ມເຫຼວໃນການຢືນຢັນລາຍເຊັນ. ເກີດມີຂໍ້ຜິດພາດ.';
$string['verifysignature-invalid'] = 'ລົ້ມເຫຼວໃນການຢືນຢັນລາຍເຊັນ. ປະກົດວ່າ payload ນີ້ບໍ່ໄດ້ເຊັນໂດຍທ່ານ.';
$string['version'] = 'ສະບັບ';
$string['warning'] = 'ການເຕືອນ';
$string['wrong-ip'] = 'ທີ່ຢູ່ IP ຂອງທ່ານບໍ່ກົງກັບທີ່ຢູ່ທີ່ພວກເຮົາມີຢູ່ໃນບັນທຶກ.';
$string['xmlrpc-missing'] = 'ທ່ານຕ້ອງມີ XML-RPC ຕິດຕັ້ງໃນການສ້າງ PHP ຂອງທ່ານ ເພື່ອຈະສາມາດນຳໃຊ້ຄຸນລັກສະນະນີ້.';
$string['yourhost'] = 'ເຈົ້າພາບຂອງທ່ານ';
$string['yourpeers'] = 'ຄູ່ຮຽນຂອງທ່ານ';
