<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'lo', version '4.0'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'ຍອມຮັບ';
$string['accept_grades'] = 'ຄະແນນຍອມຮັບຈາກເຄື່ອງມື';
$string['accept_grades_admin'] = 'ຄະແນນຍອມຮັບຈາກເຄື່ອງມື';
$string['accept_grades_admin_help'] = 'ລະບຸວ່າຜູ້ໃຫ້ບໍລິການເຄື່ອງມືສາມາດເພີ່ມ, ປັບປຸງ, ອ່ານ ແລະ ລຶບຄະແນນທີ່ກ່ຽວຂ້ອງກັບເຄື່ອງມືພາຍນອກນີ້ເທົ່ານັ້ນ.

ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືບາງຄົນຮອງຮັບການລາຍງານຄະແນນກັບຄືນໄປບ່ອນ Moodle ໂດຍອີງໃສ່ການປະຕິບັດພາຍໃນເຄື່ອງມື, ສ້າງປະສົບການປະສົມປະສານຫຼາຍຂຶ້ນ.';
$string['accept_grades_help'] = 'ລະບຸວ່າຜູ້ໃຫ້ບໍລິການເຄື່ອງມືສາມາດເພີ່ມ, ປັບປຸງ, ອ່ານ ແລະ ລຶບຄະແນນທີ່ກ່ຽວຂ້ອງກັບເຄື່ອງມືພາຍນອກນີ້ເທົ່ານັ້ນ.

ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືບາງຄົນຮອງຮັບການລາຍງານຄະແນນກັບຄືນໄປບ່ອນ Moodle ໂດຍອີງໃສ່ການປະຕິບັດພາຍໃນເຄື່ອງມື, ສ້າງປະສົບການປະສົມປະສານຫຼາຍຂຶ້ນ.

ກະລຸນາຮັບຊາບວ່າ: ການຕັ້ງຄ່ານີ້ອາດຈະຖືກລົບລ້າງໃນການຕັ້ງຄ່າເຄື່ອງມື.';
$string['accepted'] = 'ຍອມຮັບແລ້ວ';
$string['action'] = 'ການປະຕິບັດ';
$string['activate'] = 'ເປີດໃຊ້';
$string['activatetoadddescription'] = 'ທ່ານຈະຕ້ອງເປີດໃຊ້ເຄື່ອງມືນີ້ກ່ອນທີ່ທ່ານສາມາດເພີ່ມລາຍລະອຽດ';
$string['active'] = 'ເຄື່ອນໄຫວ';
$string['activity'] = 'ກິດຈະກຳ';
$string['add_ltiadv'] = 'ເພີ່ມ LTI ໄດ້ປຽບ';
$string['add_ltilegacy'] = 'ເພີ່ມ LTI ເດີມ';
$string['addnewapp'] = 'ເປີດໃຊ້ງານໂປຼແກຼມພາຍນອກ';
$string['addserver'] = 'ເພີ່ມເຊີບເວີທີ່ເຊື່ອຖືໄດ້ໃໝ່';
$string['addtype'] = 'ເພີ່ມເຄື່ອງມືການກຳນົດຄ່າລ່ວງໜ້າ';
$string['allow'] = 'ອະນຸຍາດ';
$string['allowsetting'] = 'ອະນຸຍາດເພື່ອເກັບຮັກສາ 8K ຂອງການຕັ້ງຄ່າໃນ Moodle';
$string['always'] = 'ສະເໝີ';
$string['autoaddtype'] = 'ເພີ່ມເຄື່ອງມື';
$string['automatic'] = 'ອັດຕະໂນມັດ, ອີງຕາມເຄື່ອງມື URL';
$string['baseurl'] = 'URL ພື້ນຖານ/ຊື່ການລົງທະບຽນເຄື່ອງມື';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth ຕາມສະຕຣິງ';
$string['basiclti_endpoint'] = 'LTI ເປີດຈຸດສິ້ນສຸດ';
$string['basiclti_in_new_window'] = 'ກິດຈະກຳຂອງທ່ານໄດ້ເປີດໃນໜ້າຈໍໃໝ່';
$string['basiclti_in_new_window_open'] = 'ເປີດໃນໜ້າຈໍໃໝ່';
$string['basiclti_parameters'] = 'LTI ເປີດຕົວກຳນົດ';
$string['basicltiactivities'] = 'ກິດຈະກຳ LTI';
$string['basicltifieldset'] = 'ຕົວຢ່າງການຕັ້ງຄ່າຊ່ອງຂໍ້ມູນປັບແຕ່ງເອງ';
$string['basicltiintro'] = 'ລາຍລະອຽດກິດຈະກຳ';
$string['basicltiname'] = 'ຊື່ກິດຈະກຳ';
$string['basicltisettings'] = 'ການຕັ້ງຄ່າ ຄວາມສາມາດໃນການເຮັດວຽກຮ່ວມກັນຂອງເຄື່ອງມືການຮຽນຮູ້ພື້ນຖານ (Basic Learning Tool Interoperability (LTI))';
$string['cachedef_keyset'] = 'ແຄັກຂໍ້ມູນການຕັ້ງຄ່າສະຫັດຂອງເຄື່ອງມື';
$string['cancel'] = 'ຍົກເລີກ';
$string['cancelled'] = 'ຍົກເລີກແລ້ວ';
$string['cannot_delete'] = 'ທ່ານອາດບໍ່ລຶບເຄື່ອງມືການກຳນົດຄ່ານີ້.';
$string['cannot_edit'] = 'ທ່ານອາດບໍ່ແກ້ໄຂເຄື່ອງມືການກຳນົດຄ່ານີ້.';
$string['capabilities'] = 'ຄວາມສາມາດ';
$string['capabilities_help'] = 'ເລືອກຄວາມສາມາດທີ່ທ່ານຕ້ອງການສະເໜີໃຫ້ຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ສາມາດເລືອກໄດ້ຫຼາຍກວ່າໜຶ່ງຄວາມສາມາດ.';
$string['capabilitiesrequired'] = 'ເຄື່ອງມືນີ້ຕ້ອງການການເຂົ້າເຖິງຂໍ້ມູນຕໍ່ໄປນີ້ເພື່ອເປີດໃຊ້:';
$string['cleanaccesstokens'] = 'ການຍົກຍ້າຍເຄື່ອງມືພາຍນອກຂອງໂທເຄັນການເຂົ້າເຖິງຫມົດອາຍຸ';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">ຄລິກເພື່ອສືບຕໍ່</a>';
$string['clientidadmin'] = 'ລະຫັດປະຈຳຕົວລູກຄ້າ';
$string['clientidadmin_help'] = 'ລະຫັດປະຈຳຕົວລູກຄ້າ ເປັນຄ່າທີ່ເປັນເອກະລັກທີ່ໃຊ້ເພື່ອກໍານົດເຄື່ອງມື. ມັນຖືກສ້າງຂຶ້ນໂດຍອັດຕະໂນມັດສໍາລັບແຕ່ລະເຄື່ອງມືທີ່ໃຊ້ໂປຼໄຟລ໌ຄວາມປອດໄພ JWT ທີ່ນໍາສະເຫນີໃນ LTI 1.3 ແລະ ຄວນຈະເປັນສ່ວນຫນຶ່ງຂອງລາຍລະອຽດທີ່ສົ່ງກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມື ເພື່ອໃຫ້ພວກເຂົາສາມາດຕັ້ງຄ່າການເຊື່ອມຕໍ່ໃນຕອນທ້າຍຂອງພວກເຂົາ.';
$string['comment'] = 'ຄຳເຫັນ';
$string['configpassword'] = 'ລະຫັດຜ່ານເຄື່ອງມືໄລຍະໄກເລີ່ມຕົ້ນ';
$string['configpreferheight'] = 'ຄວາມສູງທີ່ຕ້ອງການເລີ່ມຕົ້ນ';
$string['configpreferwidget'] = 'ຕັ້ງຄ່າວິດເຈັດເປັນການເປີດໃນຄ່າເລີ່ມຕົ້ນ';
$string['configpreferwidth'] = 'ຄວາມກວ້າງທີ່ຕ້ອງການເລີ່ມຕົ້ນ';
$string['configresourceurl'] = 'ແຫຼ່ງຂໍ້ມູນ URL ເລີ່ມຕົ້ນ';
$string['configtoolurl'] = 'URL ເຄື່ອງມືທາງໄກເລີ່ມຕົ້ນ';
$string['configtypes'] = 'ເປີກໃຊ້ງານໂປຼແກຼມ URL';
$string['configured'] = 'ກຳນົດຄ່າແລ້ວ';
$string['confirmtoolactivation'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການເປີດໃຊ້ເຄື່ອງມືນີ້?';
$string['contentitem'] = 'ຂໍ້ຄວາມລາຍການເນື້ອຫາ';
$string['contentitem_deeplinking'] = 'ການເຊື່ອມຕໍ່ເລີກການຮອງຮັບ (ຂໍ້ຄວາມລາຍການເນື້ອຫາ)';
$string['contentitem_deeplinking_help'] = 'ຖ້າໝາຍຖືກ, ຕົວເລືອກ \'ເລືອກເນື້ອຫາ\' ຈະມີໃຫ້ເມື່ອເພີ່ມເຄື່ອງມືພາຍນອກ.';
$string['contentitem_help'] = 'ຖ້າໝາຍຖືກ, ຕົວເລືອກ \'ເລືອກເນື້ອຫາ\' ຈະມີໃຫ້ເມື່ອເພີ່ມເຄື່ອງມືພາຍນອກ.';
$string['contentitem_multiple_description'] = 'ລາຍການຕໍ່ໄປນີ້ຈະຖືກເພີ່ມໃສ່ລາຍວິຊາຂອງທ່ານ:';
$string['contentitem_multiple_graded'] = 'ກິດຈະກຳໄດ້ຄະແນນ (ຄະແນນສູງສຸດ: {$a})';
$string['course_tool_types'] = 'ເຄື່ອງມືລາຍວິຊາ';
$string['courseactivitiesorresources'] = 'ກິດຈະກຳ ຫຼື ແຫຼ່ງຂໍ້ມູນລາຍວິຊາ';
$string['courseid'] = 'ເລກລະຫັດປະຈຳຕົວລາຍວິຊາ';
$string['courseinformation'] = 'ຂໍ້ມູນລາຍວິຊາ';
$string['courselink'] = 'ໄປຫາລາຍວິຊາ';
$string['coursemisconf'] = 'ລາຍວິຊາຖືກຕັ້ງຄ່າຜິດ';
$string['createdon'] = 'ສ້າງເທິງ';
$string['curllibrarymissing'] = 'ການຂະຫຍາຍ PHP cURL ຕ້ອງການສໍາລັບເຄື່ອງມືພາຍນອກ.';
$string['custom'] = 'ຕົວກຳນົດປັບແຕ່ງເອງ';
$string['custom_config'] = 'ການນຳໃຊ້ການກຳນົດຄ່າເຄື່ອງມືປັບແຕ່ງເອງ';
$string['custom_help'] = 'ຕົວກຳນົດແບບກຳນົດເອງ ແມ່ນການຕັ້ງຄ່າທີ່ໃຊ້ໂດຍຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ຕົວຢ່າງ, ຕົວກໍານົດແບບກໍານົດເອງ ອາດຈະຖືກນໍາໃຊ້ເພື່ອສະແດງ
ແຫຼ່ງຂໍ້ມູນສະເພາະຈາກຜູ້ໃຫ້ບໍລິການ. ແຕ່ລະຕົວກຳນົດ ຄວນໃສ່ໃນແຖວແຍກຕ່າງຫາກໂດຍໃຊ້ຮູບແບບຂອງ "name=value"; ຕົວຢ່າງ, "chapter=3".

ມັນປອດໄພທີ່ຈະປ່ອຍໃຫ້ຊ່ອງຂໍ້ມູນນີ້ບໍ່ປ່ຽນແປງ ເວັ້ນເສຍແຕ່ຈະຊີ້ບອກໂດຍຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.';
$string['custominstr'] = 'ຕົວກຳນົດປັບແຕ່ງເອງ';
$string['debuglaunch'] = 'ຕົວເລືອກດີບັກ';
$string['debuglaunchoff'] = 'ການເປີດທຳມະດາ';
$string['debuglaunchon'] = 'ການເປີດດີບັກ';
$string['default'] = 'ຄ່າເລີ່ມຕົ້ນ';
$string['default_launch_container'] = 'ກ່ອງບັນຈຸການເປີດຕົວເລີ່ມຕົ້ນ';
$string['default_launch_container_help'] = 'ຖັງເປີດຕົວສົ່ງຜົນກະທົບຕໍ່ການສະແດງຂອງເຄື່ອງມືເມື່ອເປີດຕົວຈາກລາຍວິຊາ. ບາງກ່ອງບັນຈຸເປີດໃຫ້ໜ້າຈໍຫຼາຍຂື້ນ
ອະສັງຫາລິມະສັບກັບເຄື່ອງມື, ແລະ ອື່ນໆໃຫ້ຄວາມຮູ້ສຶກປະສົມປະສານກັບສະພາບແວດລ້ອມ Moodle.

* **ຄ່າເລີ່ມຕົ້ນ** - ໃຊ້ກ່ອງບັນຈຸການເປີດຕົວທີ່ລະບຸໄວ້ໃນການຕັ້ງຄ່າເຄື່ອງມື.
* ** ຝັງ** - ເຄື່ອງມື ແມ່ນສະແດງຢູ່ພາຍໃນໜ້າຈໍ Moodle ທີ່ມີຢູ່ແລ້ວ, ໃນລັກສະນະຄ້າຍຄືກັນກັບປະເພດກິດຈະກໍາອື່ນໆທີ່ສຸດ.
* **ຝັງ, ໂດຍບໍ່ມີການປິດກັ້ນ** - ເຄື່ອງມື ແມ່ນສະແດງຢູ່ໃນໜ້າຈໍ Moodle ທີ່ມີຢູ່ແລ້ວ, ມີພຽງແຕ່ການຄວບຄຸມການນໍາທາງ.
         ຢູ່ເທິງສຸດຂອງໜ້າ.
* **ໜ້າຈໍໃຫມ່** - ເຄື່ອງມືເປີດຢູ່ໃນໜ້າຈໍໃຫມ່, ຄອບຄອງພື້ນທີ່ທັງໝົດທີ່ມີຢູ່.
         ຂຶ້ນຢູ່ກັບຕົວທ່ອງເວັບ, ມັນຈະເປີດຢູ່ໃນແຖບໃຫມ່ ຫຼື ໜ້າຈໍປ໊ອບອັບ.
         ມັນເປັນໄປໄດ້ວ່າ ຕົວທ່ອງເວັບຈະປ້ອງກັນບໍ່ໃຫ້ໜ້າຈໍໃຫມ່ເປີດ.';
$string['delegate'] = 'ໂອນສິດໃຫ້ຄູສອນ';
$string['delegate_tool'] = 'ດັ່ງທີ່ໄດ້ລະບຸໄວ້ໃນຄໍານິຍາມການເຊື່ອມຕໍ່ເລີກ (Deep Linking) ຫຼື ການໂອນສິດໃຫ້ກັບຄູສອນ';
$string['delete'] = 'ລຶບ';
$string['delete_confirmation'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການລຶບເຄື່ອງມືກຳນົດຄ່າລ່ວງໜ້າ?';
$string['deletetype'] = 'ລຶບເຄື່ອງມືກຳນົດຄ່າລ່ວງໜ້າ';
$string['display_description'] = 'ສະແດງຄຳອະທິບາຍກິດຈະກຳເມື່ອຖືກເປີດໃຊ້';
$string['display_description_help'] = 'ຖ້າເລືອກ, ລາຍລະອຽດກິດຈະກໍາ (ລະບຸໄວ້ຂ້າງເທິງ) ຈະສະແດງຢູ່ຂ້າງເທິງເນື້ອຫາຂອງຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.

ຄໍາອະທິບາຍອາດຈະຖືກນໍາໃຊ້ເພື່ອໃຫ້ຄໍາແນະນໍາເພີ່ມເຕີມສໍາລັບຕົວເປີດຂອງເຄື່ອງມື, ແຕ່ມັນບໍ່ຈໍາເປັນຕ້ອງ.

ຄຳອະທິບາຍຈະບໍ່ສະແດງເມື່ອກ່ອງບັນຈຸການເປີດຕົວຂອງເຄື່ອງມືຢູ່ໃນໜ້າຈໍໃໝ່.';
$string['display_name'] = 'ສະແດງຊື່ກິດຈະກຳເມື່ອຖືກເປີດໃຊ້';
$string['display_name_help'] = 'ຖ້າເລືອກ, ຊື່ກິດຈະກໍາ (ລະບຸໄວ້ຂ້າງເທິງ) ຈະສະແດງຢູ່ຂ້າງເທິງເນື້ອຫາຂອງຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.

ມັນເປັນໄປໄດ້ວ່າ ຜູ້ໃຫ້ບໍລິການເຄື່ອງມື ອາດຈະສະແດງຫົວຂໍ້. ທາງເລືອກນີ້ ສາມາດປ້ອງກັນບໍ່ໃຫ້ຫົວຂໍ້ກິດຈະກໍາຈາກ
ຖືກສະແດງສອງຄັ້ງ.

ຫົວຂໍ້ຈະບໍ່ສະແດງເມື່ອກ່ອງບັນຈຸການເປີດຕົວຂອງເຄື່ອງມືຢູ່ໃນໜ້າຈໍໃຫມ່.';
$string['domain_mismatch'] = 'ໂດເມນຂອງເຄື່ອງມື URL ບໍ່ກົງກັບການຕັ້ງຄ່າເຄື່ອງມື.';
$string['donot'] = 'ຢ່າສົ່ງ';
$string['donotaccept'] = 'ຢ່າຍອມຮັບ';
$string['donotallow'] = 'ຢ່າອະນຸຍາດ';
$string['duplicateregurl'] = 'ການລົງທະບຽນ URL ນີ້ຖືກນຳໃຊ້ແລ້ວ';
$string['dynreg_update_btn_new'] = 'ລົງທະບຽນເຄື່ອງມືພາຍນອກໃໝ່';
$string['dynreg_update_btn_update'] = 'ປັບປຸງ';
$string['dynreg_update_name'] = 'ຊື່ເຄື່ອງມື';
$string['dynreg_update_notools'] = 'ບໍ່ມີເຄື່ອງມືໃນເນື້ອຫາ.';
$string['dynreg_update_text'] = 'ມີເຄື່ອງມືທີ່ມີຢູ່ແລ້ວຕິດກັບຊຸດຂອງການລົງທະບຽນ. ທ່ານຕ້ອງການປັບປຸງເຄື່ອງທີ່ຕິດຕັ້ງແລ້ວບໍ່
ເຄື່ອງມືພາຍນອກ ຫຼື ສ້າງເຄື່ອງມືພາຍນອກໃຫມ່?';
$string['dynreg_update_url'] = 'URL ພື້ນຖານ';
$string['dynreg_update_version'] = 'ສະບັບ LTI';
$string['dynreg_update_warn_dupdomain'] = 'ມັນບໍ່ໄດ້ຖືກແນະນໍາໃຫ້ມີເຄື່ອງມືພາຍນອກຫຼາຍພາຍໃຕ້ຊຸດດຽວກັນ.';
$string['editdescription'] = 'ກົດທີ່ນີ້ເພື່ອໃຫ້ຄຳອະທິບາຍເຄື່ອງມືນີ້';
$string['edittype'] = 'ແກ້ໄຂເຄື່ອງມືການກຳນົດລ່ວງໜ້າ';
$string['embed'] = 'ຝັງ';
$string['embed_no_blocks'] = 'ຝັງ, ປາສະຈາກການປິດກັ້ນ';
$string['enableemailnotification'] = 'ສົ່ງອີເມລການແຈ້ງການ';
$string['enableemailnotification_help'] = 'ຖ້າເປີດໃຊ້ງານ, ນັກຮຽນຈະໄດ້ຮັບການແຈ້ງເຕືອນທາງອີເມລ໌ ເມື່ອການສົ່ງເຄື່ອງມືຂອງເຂົາເຈົ້າໄດ້ຄະແນນແລ້ວ.';
$string['enterkeyandsecret'] = 'ໃສ່ລະຫັດຜູ້ບໍລິໂພກ ແລະ ແບ່ງປັນຄວາມລັບ';
$string['enterkeyandsecret_help'] = 'ຖ້າທ່ານໃສ່ລະຫັດຜູ້ບໍລິໂພກ ແລະ/ຫຼື ແບ່ງປັນຄວາມລັບ, ປ້ອນໃສ່ພວກມັນທີ່ນີ້';
$string['errorbadurl'] = 'URL ບໍ່ແມ່ນ URL ເຄື່ອງມື ຫຼື ຕະລັບທີ່ຖືກຕ້ອງ';
$string['errorincorrectconsumerkey'] = 'ລະຫັດຜູ້ບໍລິໂພກບໍ່ຖືກຕ້ອງ.';
$string['errorinvaliddata'] = 'ຂໍ້ມູນບໍ່ຖືກຕ້ອງ: {$a}';
$string['errorinvalidmediatype'] = 'ປະເພດສື່ບໍ່ຖືກຕ້ອງ: {$a}';
$string['errorinvalidresponseformat'] = 'ຮູບແບບການຕອບກັບລາຍການເນື້ອຫາບໍ່ຖືກຕ້ອງ.';
$string['errormisconfig'] = 'ເຄື່ອງມືກຳນົດຄ່າຜິດ. ກະລຸນາຖາມຜູ້ບໍລິຫານ Moodle ຂອງທ່ານເພື່ອແກ້ໄຂການກຳນົດຄ່າຂອງເຄື່ອງມື.';
$string['errortooltypenotfound'] = 'ບໍ່ພົບປະເພດເຄື່ອງມື LTI.';
$string['existing_window'] = 'ໜ້າຕ່າງທີ່ມີຢູ່';
$string['extensions'] = 'ການບໍລິການສ່ວນຂະຫຍາຍ LTI';
$string['external_tool_type'] = 'ເຄື່ອງມືການກຳນົດຄ່າລ່ວງໜ້າ';
$string['external_tool_type_help'] = '* **ອັດຕະໂນມັດ, ໂດຍອີງໃສ່ URL ຂອງເຄື່ອງມື** - ການກຳນົດຄ່າເຄື່ອງມືທີ່ດີທີ່ສຸດຖືກຄັດເລືອກອັດຕະໂນມັດ. ຖ້າ URL ເຄື່ອງມືບໍ່ໄດ້ຖືກຮັບຮູ້, ລາຍລະອຽດການກຳນົດຄ່າເຄື່ອງມືອາດຈະຕ້ອງຖືກໃສ່ດ້ວຍຕົນເອງ.
* **ເຄື່ອງມືທີ່ກໍານົດໄວ້ລ່ວງໜ້າສະເພາະ** - ການກຳນົດຄ່າເຄື່ອງມືສໍາລັບເຄື່ອງມືທີ່ລະບຸໄວ້ຈະຖືກໃຊ້ໃນເວລາທີ່ຕິດຕໍ່ສື່ສານກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມືພາຍນອກ. ຖ້າ URL ເຄື່ອງມືບໍ່ປາກົດວ່າເປັນຂອງຜູ້ໃຫ້ບໍລິການເຄື່ອງມື, ການເຕືອນໄພຈະຖືກສະແດງ. ມັນບໍ່ຈໍາເປັນສະເໝີໄປທີ່ຈະໃສ່ URL ເຄື່ອງມື.
* **ການກຳນົດຄ່າແບບກຳນົດເອງ** - ລະຫັດຜູ້ບໍລິໂພກ ແລະ ຂໍ້ມູນລັບທີ່ແບ່ງປັນອາດຈະຕ້ອງໃສ່ດ້ວຍຕົນເອງ. ລະຫັດຜູ້ບໍລິໂພກ ແລະ ຄວາມລັບທີ່ແບ່ງປັນອາດຈະໄດ້ຮັບຈາກຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ຢ່າງໃດກໍຕາມ, ບໍ່ແມ່ນເຄື່ອງມືທັງໝົດຮຽກຮ້ອງໃຫ້ມີລະຫັດຜູ້ບໍລິໂພກ ແລະ ຄວາມລັບທີ່ແບ່ງປັນ, ໃນກໍລະນີນີ້, ຊ່ອງຂໍ້ມູນອາດຈະຖືກປະໄວ້ຫວ່າງເປົ່າ.

### ການແກ້ໄຂເຄື່ອງມືທີ່ກໍານົດໄວ້ລ່ວງໜ້າ

ສາມສັນຍາລັກ ມີຢູ່ຫຼັງຈາກເມນູເລື່ອນລົງຂອງເຄື່ອງມືທີ່ກໍານົດລ່ວງໜ້າ:

* **ຕື່ມ** - ສ້າງການຕັ້ງຄ່າເຄື່ອງມືລະດັບລາຍວິຊາ. ຕົວຢ່າງເຄື່ອງມືພາຍນອກທັງໝົດໃນລາຍວິຊານີ້ອາດຈະໃຊ້ການຕັ້ງຄ່າເຄື່ອງມື.
* **ແກ້ໄຂ** - ເລືອກເຄື່ອງມືລະດັບຫຼັກສູດຈາກເມນູເລື່ອນລົງ, ຈາກນັ້ນຄລິກສັນຍາລັກນີ້. ລາຍລະອຽດຂອງການກຳນົດຄ່າເຄື່ອງມືອາດຈະຖືກແກ້ໄຂ.
* **ລຶບ** - ເອົາເຄື່ອງມືລະດັບວິຊາການຄັດເລືອກອອກ.';
$string['external_tool_types'] = 'ເຄື່ອງມືການກຳນົດຄ່າລ່ວງໜ້າ';
$string['failedtoconnect'] = 'Moodle ບໍ່ສາມາດສື່ສານກັບລະບົບ "{$a}"';
$string['failedtocreatetooltype'] = 'ສ້າງເຄື່ອງມືໃໝ່ບໍ່ສຳເລັດ. ກະລຸນາກວດສອບ URL ແລ້ວລອງໃໝ່ອີກຄັ້ງ';
$string['failedtodeletetoolproxy'] = 'ລຶບການລົງທະບຽນເຄື່ອງມືບໍ່ສຳເລັດ. ທ່ານອາດຈະຈໍາເປັນຕ້ອງໄດ້ໄປຢ້ຽມຢາມ "ຈັດການການລົງທະບຽນເຄື່ອງມືພາຍນອກ" ແລະ ລຶບມັນດ້ວຍຕົນເອງ.';
$string['filter_basiclti_configlink'] = 'ຕັ້ງຄ່າເວັບໄຊທ໌ທີ່ທ່ານຕ້ອງການ ແລະ ລະຫັດຜ່ານຂອງເຂົາເຈົ້າ';
$string['filter_basiclti_password'] = 'ລະຫັດຜ່ານແມ່ນບັງຄັບ';
$string['filterconfig'] = 'ການບໍລິຫານ LTI';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'ໃຊ້ການກຳນົດຄ່າທີ່ມີຢູ່ສຳລັບຕົວຢ່າງການກຳນົດຄ່າຜິດ';
$string['fixnew'] = 'ການກຳນົດຄ່າໃໝ່';
$string['fixnewconf'] = 'ກຳນົດການກຳນົດຄ່າໃໝ່ສຳລັບຕົວຢ່າງການກຳນົດຄ່າຜິດ';
$string['fixold'] = 'ນຳໃຊ້ທີ່ມີຢູ້';
$string['force_ssl'] = 'SSL ບັງຄັບ';
$string['force_ssl_help'] = 'ການເລືອກທາງເລືອກນີ້ບັງຄັບການເປີດຕົວທັງໝົດໃຫ້ກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມືນີ້ເພື່ອໃຊ້ SSL.

ນອກຈາກນັ້ນ, ການຮ້ອງຂໍການບໍລິການເວັບທັງໝົດຈາກຜູ້ໃຫ້ບໍລິການເຄື່ອງມືຈະໃຊ້ SSL.

ຖ້າໃຊ້ທາງເລືອກນີ້, ຢືນຢັນວ່າເວັບໄຊທ໌ Moodle ນີ້ ແລະ ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືຮອງຮັບ SSL.';
$string['forced_help'] = 'ການຕັ້ງຄ່ານີ້ຖືກບັງຄັບຢູ່ໃນລາຍວິຊາ ຫຼື ການກຳນົດຄ່າເຄື່ອງມືລະດັບເວັບໄຊທ໌. ທ່ານອາດຈະບໍ່ປ່ຽນມັນຈາກການໂຕ້ຕອບນີ້.';
$string['generaltool'] = 'ເຄື່ອງມືທົ່ວໄປ';
$string['global_tool_types'] = 'ເຄື່ອງມືກຳນົດຄ່າລ່ວງໜ້າ';
$string['grading'] = 'ເສັ້ນທາງຄະແນນ';
$string['icon_url'] = 'ສັນຍາລັກ URL';
$string['icon_url_help'] = 'ສັນຍາລັກ URL ອະນຸຍາດໃຫ້ສັນຍາລັກທີ່ສະແດງຢູ່ໃນລາຍການລາຍວິຊາສໍາລັບກິດຈະກໍານີ້ຖືກດັດແປງ. ແທນທີ່ຈະໃຊ້ຄ່າເລີ່ມຕົ້ນ
ສັນຍາລັກ LTI, ສັນຍາລັກທີ່ບົ່ງບອກປະເພດຂອງການເຄື່ອນໄຫວອາດຈະຖືກລະບຸໄວ້.';
$string['id'] = 'ລະຫັດປະຈຳຕົວ';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ LTI';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມເລິກຂອງຄວາມຮູ້ທີ່ບັນລຸໄດ້ໂດຍນັກຮຽນໃນກິດຈະກໍາ LTI.';
$string['indicator:cognitivedepthdef'] = 'ຄວາມຮູ້ LTI';
$string['indicator:cognitivedepthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນນີ້ຂອງການມີສ່ວນພົວພັນທາງດ້ານສະຕິປັນຍາທີ່ສະເໜີໃຫ້ໂດຍກິດຈະກໍາ LTI ໃນລະຫວ່າງໄລຍະການວິເຄາະນີ້ (ລະດັບ = ບໍ່ເບິ່ງ, ເບິ່ງ, ສົ່ງ, ເບິ່ງຄໍາຄຶດຄໍາເຫັນ)';
$string['indicator:socialbreadth'] = 'ສັງຄົມ LTI';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມກວ້າງຂອງສັງຄົມທີ່ນັກຮຽນບັນລຸໄດ້ໃນກິດຈະກໍາ LTI.';
$string['indicator:socialbreadthdef'] = 'ສັງຄົມ LTI';
$string['indicator:socialbreadthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນນີ້ ຂອງການມີສ່ວນຮ່ວມທາງສັງຄົມທີ່ສະເຫນີໂດຍກິດຈະກໍາ LTI ໃນລະຫວ່າງການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເຂົ້າຮ່ວມ, ຜູ້ເຂົ້າຮ່ວມຢ່າງດຽວ, ຜູ້ເຂົ້າຮ່ວມກັບຄົນອື່ນ)';
$string['initiatelogin'] = 'ເລີ່ມຕົ້ນການເຂົ້າສູ່ລະບົບ URL';
$string['initiatelogin_help'] = 'URL ເຄື່ອງມືທີ່ຮ້ອງຂໍການລິເລີ່ມການເຂົ້າສູ່ລະບົບຈະຖືກສົ່ງ. URL ນີ້ແມ່ນຕ້ອງການກ່ອນທີ່ຂໍ້ຄວາມສາມາດຖືກສົ່ງຢ່າງສໍາເລັດຜົນກັບເຄື່ອງມື.';
$string['invalidid'] = 'ລະຫັດປະຈຳຕົວ LTI ບໍ່ຖືກຕ້ອງ';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'ປະເພດລະຫັດສາທາລະນະ';
$string['keytype_help'] = 'ວິທີການກວດສອບຄວາມຖືກຕ້ອງນຳໃຊ້ໃນການກວດສອບເຄື່ອງມື.';
$string['keytype_keyset'] = 'ຊຸດລະຫັດ URL';
$string['keytype_rsa'] = 'ລະຫັດ RSA';
$string['launch_in_moodle'] = 'ເຄື່ອງມືເປີດໃນ Moodle';
$string['launch_in_popup'] = 'ເຄື່ອງມືເປີດໃນໜ້າຈໍປັອບອັບ';
$string['launch_url'] = 'URL ເຄື່ອງມື';
$string['launch_url_help'] = 'URL ເຄື່ອງມືຊີ້ບອກທີ່ຢູ່ເວັບຂອງເຄື່ອງມືພາຍນອກ ແລະ ອາດຈະມີຂໍ້ມູນເພີ່ມເຕີມ, ເຊັ່ນ:ແຫຼ່ງຂໍ້ມູນທີ່ຈະສະແດງ.
ຖ້າທ່ານບໍ່ແນ່ໃຈວ່າ ຈະໃສ່ອັນໃດສໍາລັບ URL ເຄື່ອງມື, ກະລຸນາກວດເບິ່ງກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມືສໍາລັບຂໍ້ມູນເພີ່ມເຕີມ.

ທ່ານສາມາດໃສ່ຕະລັບ URL ໄດ້ຖ້າທ່ານມີ ແລະ ສ່ວນທີ່ເຫຼືອຂອງແບບຟອມຈະຕື່ມຂໍ້ມູນໃສ່ອັດຕະໂນມັດ.

ຖ້າທ່ານໄດ້ເລືອກເຄື່ອງມືທີ່ກໍານົດໄວ້ກ່ອນ, ທ່ານອາດຈະບໍ່ຈໍາເປັນຕ້ອງໃສ່ URL ເຄື່ອງມື. ຖ້າການເຊື່ອມຕໍ່ເຄື່ອງມືຖືກນໍາໃຊ້ເພື່ອພຽງແຕ່ເປີດຕົວ
ເຂົ້າໄປໃນລະບົບຂອງຜູ້ໃຫ້ບໍລິການເຄື່ອງມື ແລະ ບໍ່ໄປຫາແຫຼ່ງຂໍ້ມູນສະເພາະໃດຫນຶ່ງ, ນີ້ອາດຈະເປັນກໍລະນີ.';
$string['launchinpopup'] = 'ກ່ອງບັນຈຸການເປີດ';
$string['launchinpopup_help'] = 'ກ່ອງບັນຈຸເປີດຕົວສົ່ງຜົນກະທົບຕໍ່ການສະແດງຂອງເຄື່ອງມືເມື່ອເປີດຕົວຈາກລາຍວິຊາ. ບາງກ່ອງບັນຈຸເປີດໃຫ້ໜ້າຈໍຫຼາຍຂື້ນ
ອະສັງຫາລີມະຊັບກັບເຄື່ອງມື, ແລະ ອື່ນໆໃຫ້ຄວາມຮູ້ສຶກປະສົມປະສານກັບສະພາບແວດລ້ອມຂອງ Moodle.

* **ຄ່າເລີ່ມຕົ້ນ** - ໃຊ້ກ່ອງບັນຈຸການເປີດຕົວທີ່ລະບຸໄວ້ໃນການຕັ້ງຄ່າເຄື່ອງມື.
* **ຝັງ** - ເຄື່ອງມືແມ່ນສະແດງຢູ່ພາຍໃນໜ້າຈໍ Moodle ທີ່ມີຢູ່ແລ້ວ, ໃນລັກສະນະຄ້າຍຄືກັນກັບປະເພດກິດຈະກໍາອື່ນໆທີ່ສຸດ.
* **ຝັງ, ໂດຍບໍ່ມີການປິດກັ້ນ** - ເຄື່ອງມືແມ່ນສະແດງຢູ່ໃນໜ້າຈໍ Moodle ທີ່ມີຢູ່ແລ້ວ, ມີພຽງແຕ່ການຄວບຄຸມການນໍາທາງ.
         ຢູ່ເທິງສຸດຂອງໜ້າ.
* **ໜ້າຈໍໃຫມ່** - ເຄື່ອງມືເປີດຢູ່ໃນປ່ອງຢ້ຽມໃໝ່, ຄອບຄອງພື້ນທີ່ທັງໝົດທີ່ມີຢູ່.
         ຂຶ້ນຢູ່ກັບຕົວທ່ອງເວັບ, ມັນຈະເປີດຢູ່ໃນແຖບໃໝ່ ຫຼື ໜ້າຈໍປັອບອັບ.
         ມັນເປັນໄປໄດ້ວ່າຕົວທ່ອງເວັບຈະປ້ອງກັນບໍ່ໃຫ້ໜ້າໃໝ່ເປີດ.';
$string['launchoptions'] = 'ກ່ອງບັນຈຸການເປີດ';
$string['leaveblank'] = 'ປ່ອຍໃຫ້ຫວ່າງເປົ່າຖ້າທ່ານບໍ່ຕ້ອງການພວກມັນ';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'ເພີ່ມການກຳນົດເຄື່ອງມືລະບຸລາຍວິຊາ';
$string['lti:addinstance'] = 'ເພີ່ມເຄື່ອງມືພາຍນອກໃໝ່';
$string['lti:addmanualinstance'] = 'ເພີ່ມເຄື່ອງມືການກຳນົດດ້ວນຕົວເອງ';
$string['lti:addpreconfiguredinstance'] = 'ເພີ່ມເຄື່ອງມືການກຳນົດລ່ວງໜ້າ';
$string['lti:admin'] = 'ເປັນຜູ້ຄວບຄຸມລະບົບເມື່ອເປີດໃຊ້ເຄື່ອງມືແລ້ວ';
$string['lti:grade'] = 'ເບິ່ງການສົ່ງຄືນຄະແນນໂດຍເຄື່ອງມືພາຍນອກ';
$string['lti:manage'] = 'ເປັນຜູ້ສອນເມື່ອເປີດໃຊ້ເຄື່ອງມືແລ້ວ';
$string['lti:requesttooladd'] = 'ຮຽກຮ້ອງເຄື່ອງມືກຳນົດຄ່າທົ່ວເວັບໄຊທ໌';
$string['lti:view'] = 'ເປີດໃຊ້ກິດຈະກຳເຄື່ອງມືພາຍນອກ';
$string['lti_administration'] = 'ແກ້ໄຂເຄື່ອງມືການກຳນົດລ່ວງໜ້າ';
$string['lti_errormsg'] = 'ເຄື່ອງມືສົ່ງຄືນຂໍ້ຄວາມຜິດພາດດັ່ງຕໍ່ໄປນີ້ : "{$a}"';
$string['lti_launch_error'] = 'ເກີດມີຄວາມຜິດພາດເມື່ອເປີດໃຊ້ເຄື່ອງມືພາຍນອກ:';
$string['lti_launch_error_tool_request'] = '<p>
ເພື່ອສົ່ງຄໍາຮ້ອງຂໍສໍາລັບຜູ້ບໍລິຫານ ເພື່ອເຮັດສໍາເລັດການກຳນົດຄ່າເຄື່ອງມື, ຄລິກ <a href="{$a->admin_request_url}" target="_top">here</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>ຄວາມຜິດພາດນີ້ອາດຈະເປັນຜົນມາຈາກລະຫັດຜູ້ບໍລິໂພກທີ່ຂາດໄປ ແລະ ຄວາມລັບທີ່ແບ່ງປັນໃຫ້ຜູ້ໃຫ້ບໍລິເຄື່ອງມື.</p>
<p>ຫາກທ່ານມີລະຫັດຜູ້ບໍລິໂພກ ແລະ ຄວາມລັບທີ່ແບ່ງປັນ, ທ່ານອາດຈະໃສ່ມັນໃນເວລາທີ່ການແກ້ໄຂຕົວຢ່າງເຄື່ອງມືພາຍນອກ (ເບິ່ງໃຫ້ແນ່ໃຈວ່າທາງເລືອກຂັ້ນສູງແມ່ນສາມາດເບິ່ງໄດ້).</p>
<p>ອີກທາງເລືອກໜຶ່ງ, ທ່ານສາມາດ <a href="{$a->course_tool_editor}">ສ້າງການກຳນົດຄ່າເຄື່ອງມືລະດັບລາຍວິຊາ</a>.</p>';
$string['lti_tool_request_added'] = 'ສົ່ງຄຳຮ້ອງຂໍການກຳນົດຄ່າເຄື່ອງມືສຳເລັດແລ້ວ. ທ່ານອາດຈະຈໍາເປັນຕ້ອງໄດ້ຕິດຕໍ່ຜູ້ບໍລິຫານເພື່ອເຮັດສໍາເລັດການກຳນົດຄ່າເຄື່ອງມື.';
$string['lti_tool_request_existing'] = 'ການກຳນົດຄ່າເຄື່ອງມືສໍາລັບຊຸດເຄື່ອງມືໄດ້ຖືກສົ່ງແລ້ວ.';
$string['ltisettings'] = 'ການຕັ້ງຄ່າ LTI';
$string['ltiunknownserviceapicall'] = 'ການໂທ API ບໍລິການ LTI ທີ່ບໍ່ຮູ້ຈັກ.';
$string['ltiversion'] = 'ສະບັບ LTI';
$string['ltiversion_help'] = 'ສະບັບຂອງ LTI ທີ່ໃຊ້ສໍາລັບຂໍ້ຄວາມການເຂົ້າສູ່ລະບົບ ແລະ ການຮ້ອງຂໍການບໍລິການ: LTI 1.0/1.1 ແລະ LTI 2.0 ໃຊ້ໂປຼໄຟລ໌ຄວາມປອດໄພ OAuth 1.0A; LTI 1.3.0 ໃຊ້ JWTs.';
$string['main_admin'] = 'ການຊ່ວຍເຫຼືອທົ່ວໄປ';
$string['main_admin_help'] = 'ເຄື່ອງມືພາຍນອກອະນຸຍາດໃຫ້ຜູ້ໃຊ້ Moodle ສາມາດພົວພັນກັບແຫຼ່ງຂໍ້ມູນການຮຽນຮູ້ທີ່ເປັນເຈົ້າພາບຢູ່ທາງໄກ. ໂດຍຜ່ານລະບຽບການການເປີດຕົວພິເສດ, ເຄື່ອງມືທາງໄກໄດ້ເຂົ້າເຖິງຂໍ້ມູນທົ່ວໄປກ່ຽວກັບຜູ້ໃຊ້ເປີດຕົວ. ຕົວຢ່າງ: ຊື່ສະຖາບັນ, ລະຫັດປະຈຳຕົວລາຍວິຊາ, ລະຫັດປະຈຳຕົວຜູ້ໃຊ້, ແລະ ຂໍ້ມູນອື່ນໆເຊັ່ນ: ຊື່ຜູ້ໃຊ້ ຫຼື ທີ່ຢູ່ອີເມລ.

ເຄື່ອງມືທີ່ລະບຸໄວ້ໃນຫນ້ານີ້ໄດ້ຖືກແຍກອອກເປັນສາມປະເພດ:

* **ເຄື່ອນໄຫວ** - ຜູ້ໃຫ້ບໍລິເຄື່ອງມືເຫຼົ່ານີ້ ໄດ້ຮັບການອະນຸມັດ ແລະ ການຕັ້ງຄ່າໂດຍຜູ້ບໍລິຫານ. ພວກເຂົາສາມາດຖືກນໍາໃຊ້ຈາກພາຍໃນລາຍວິຊາໃດໜຶ່ງຢູ່ໃນເວັບໄຊທ໌ນີ້. ຖ້າລະຫັດຜູ້ບໍລິໂພກ ແລະ ຄວາມລັບທີ່ຖືກແບ່ງປັນຖືກປ້ອນໃສ່, ຄວາມສໍາພັນຄວາມໄວ້ວາງໃຈໄດ້ຖືກສ້າງຕັ້ງຂຶ້ນລະຫວ່າງເວັບໄຊທ໌ນີ້ ແລະ ເຄື່ອງມືທາງໄກ, ສະໜອງຊ່ອງທາງການສື່ສານທີ່ປອດໄພ.
* **ລໍຖ້າ ** - ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືເຫຼົ່ານີ້ ເຂົ້າມາໂດຍຜ່ານການນໍາເຂົ້າຊຸດ, ແຕ່ບໍ່ໄດ້ຖືກຕັ້ງຄ່າໂດຍຜູ້ເບິ່ງແຍງລະບົບ. ຄູສອນອາດຈະຍັງໃຊ້ເຄື່ອງມືຈາກຜູ້ໃຫ້ບໍລິການເຫຼົ່ານີ້ ຖ້າພວກເຂົາມີລະຫັດຜູ້ບໍລິໂພກ ແລະ ຄວາມລັບທີ່ແບ່ງປັນ, ຫຼື ຖ້າບໍ່ມີອັນໃດຕ້ອງການ.
* **ຖືກປະຕິເສດ** - ຜູ້ໃຫ້ບໍລິເຄື່ອງມືເຫຼົ່ານີ້ ແມ່ນໄດ້ຖືກໝາຍເປັນຜູ້ບໍລິຫານບໍ່ມີຄວາມຕັ້ງໃຈທີ່ຈະເຮັດໃຫ້ມີຢູ່ໃນເວັບໄຊທ໌ໄດ້. ຄູສອນ ອາດຈະຍັງໃຊ້ເຄື່ອງມືຈາກຜູ້ໃຫ້ບໍລິການເຫຼົ່ານີ້ ຖ້າພວກເຂົາມີລະຫັດຜູ້ບໍລິໂພກ ແລະ ຄວາມລັບທີ່ແບ່ງປັນ, ຫຼື ຖ້າບໍ່ມີອັນໃດຕ້ອງການ.';
$string['manage_external_tools'] = 'ເຄື່ອງມືຈັດການ';
$string['manage_tool_proxies'] = 'ຈັດການການລົງທະບຽນເຄື່ອງມືພາຍນອກ';
$string['manage_tools'] = 'ຈັດການເຄື່ອງມືການກຳນົດລ່ວງໜ້າ';
$string['manuallyaddtype'] = 'ນອກຈາກນີ້, ທ່ານສາມາດ <a href="{$a}">ກຳນົດຄ່າເຄື່ອງມືດ້ວຍຕົວເອງ</a>.';
$string['miscellaneous'] = 'ອື່ນໆ';
$string['misconfiguredtools'] = 'ໄດ້ກວດຈັບຕົວຢ່າງເຄື່ອງມືການກຳນົດຄ່າຜິດ';
$string['missingparameterserror'] = 'ໜ້ານີ້ຖືກກຳນົດຄ່າຜິດ: "{$a}"';
$string['module_class_type'] = 'ປະເພດຊຸດ Moodle';
$string['modulename'] = 'ເຄື່ອງມືພາຍນອກ';
$string['modulename_help'] = 'ຊຸດກິດຈະກໍາເຄື່ອງມືພາຍນອກ ຊ່ວຍໃຫ້ນັກຮຽນສາມາດພົວພັນກັບແຫຼ່ງຂໍ້ມູນການຮຽນຮູ້ ແລະກິດຈະກໍາຢູ່ໃນເວັບໄຊທ໌ອື່ນໆ. ຕົວຢ່າງ: ເຄື່ອງມືພາຍນອກ ສາມາດສະໜອງການເຂົ້າເຖິງປະເພດກິດຈະກໍາໃໝ່ ຫຼື ອຸປະກອນການຮຽນຮູ້ຈາກຜູ້ເຜີຍແຜ່.

ເພື່ອສ້າງກິດຈະກໍາຂອງເຄື່ອງມືພາຍນອກ, ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືທີ່ຮອງຮັບ LTI (ການເຮັດວຽກຮ່ວມກັນຂອງເຄື່ອງມືການຮຽນຮູ້) ແມ່ນຕ້ອງການ. ຄູສອນ ສາມາດສ້າງກິດຈະກໍາເຄື່ອງມືພາຍນອກ ຫຼື ນໍາໃຊ້ເຄື່ອງມືທີ່ກໍານົດຄ່າໂດຍຜູ້ເບິ່ງແຍງເວັບໄຊທ໌.

ກິດຈະກໍາເຄື່ອງມືພາຍນອກ ແຕກຕ່າງຈາກແຫຼ່ງຂໍ້ມູນ URL ໃນສອງສາມວິທີ:

* ເຄື່ອງມືພາຍນອກ ແມ່ນການຮັບຮູ້ສະພາບການເຊັ່ນ: ພວກເຂົາມີການເຂົ້າເຖິງຂໍ້ມູນກ່ຽວກັບຜູ້ໃຊ້ທີ່ເປີດເຄື່ອງມືເຊັ່ນ: ສະຖາບັນ, ລາຍວິຊາ ແລະ ຊື່.
* ເຄື່ອງມືພາຍນອກຮອງຮັບການອ່ານ, ການປັບປຸງ, ແລະ ການລົບຄະແນນທີ່ກ່ຽວຂ້ອງກັບຕົວຢ່າງກິດຈະກໍາ
* ການຕັ້ງຄ່າເຄື່ອງມືພາຍນອກ ສ້າງຄວາມສໍາພັນຄວາມໄວ້ວາງໃຈລະຫວ່າງເວັບໄຊທ໌ຂອງເຈົ້າ ແລະ ຜູ້ໃຫ້ບໍລິການເຄື່ອງມື, ຊ່ວຍໃຫ້ການສື່ສານທີ່ປອດໄພລະຫວ່າງພວກເຂົາ';
$string['modulenameplural'] = 'ເຄື່ອງມືພາຍນອກ';
$string['modulenamepluralformatted'] = 'ຕົວຢ່າງ LTI';
$string['name'] = 'ຊື່';
$string['never'] = 'ບໍ່ເຄີຍ';
$string['new_window'] = 'ໜ້າຈໍໃໝ່';
$string['no_lti_configured'] = 'ບໍ່ມີການກຳນົດຄ່າເຄື່ອງມືພາຍນອກທີ່ເຄື່ອນໄຫວ';
$string['no_lti_pending'] = 'ບໍ່ມີເຄື່ອງມືພາຍນອກກຳລັງລໍຖ້າ.';
$string['no_lti_rejected'] = 'ບໍ່ມີເຄື່ອງມືພາຍນອກໄດ້ປະຕິເສດ.';
$string['no_lti_tools'] = 'ບໍ່ມີການກຳນົດຄ່າເຄື່ອງມືພາຍນອກ.';
$string['no_tp_accepted'] = 'ບໍ່ມີການລົງທະບຽນເຄື່ອງມືພາຍນອກທີ່ໄດ້ຍອມຮັບ.';
$string['no_tp_cancelled'] = 'ບໍ່ມີການລົງທະບຽນເຄື່ອງມືພາຍນອກທີ່ໄດ້ຍົກເລີກ.';
$string['no_tp_configured'] = 'ບໍ່ມີການກຳນົດຄ່າເຄື່ອງມືພາຍນອກທີ່ບໍ່ໄດ້ລົງທະບຽນ.';
$string['no_tp_pending'] = 'ບໍ່ມີການລົງທະບຽນເຄື່ອງມືພາຍນອກກຳລັງລໍຖ້າ.';
$string['no_tp_rejected'] = 'ບໍ່ມີການລົງທະບຽນເຄື່ອງມືພາຍນອກທີ່ໄດ້ປະຕິເສດ.';
$string['noattempts'] = 'ບໍ່ມີຄວາມພະຍາຍາມໃນຕົວຢ່າງເຄື່ອງມືນີ້';
$string['noltis'] = 'ບໍ່ມີຕົວຢ່າງເຄື່ອງມືພາຍນອກ';
$string['noprofileservice'] = 'ບໍ່ພົບໂປຼໄຟລ໌ການບໍລິການ';
$string['noservers'] = 'ບໍ່ພົບການບໍລິການ';
$string['notypes'] = 'ໃນປັດຈຸບັນບໍ່ມີເຄື່ອງມື LTI ທີ່ຕັ້ງຢູ່ໃນ Moodle. ຄລິກທີ່ລິ້ງຕິດຕັ້ງຂ້າງເທິງເພື່ອເພີ່ມບາງອັນ.';
$string['noviewusers'] = 'ບໍ່ພົບຜູ້ໃຊ້ທີ່ມີການອະນຸຍາດນຳໃຊ້ເຄື່ອງມືນີ້';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 ຕ້ອງການ openssl.cnf ທີ່ຖືກຕ້ອງເພື່ອກຳນົດຄ່າ ແລະ ມີໃຫ້ກັບເຊີບເວີເວັບໄຊທ໌ຂອງທ່ານ. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງເວັບໄຊທ໌ເພື່ອຕັ້ງຄ່າ ແລະ ເປີດໃຊ້ openssl ສໍາລັບເວັບໄຊທ໌ນີ້.';
$string['optionalsettings'] = 'ການຕັ້ງຄ່າທາງເລືອກ';
$string['organization'] = 'ລາຍລະອຽດອົງກອນ';
$string['organizationdescr'] = 'ຄຳອະທິບາຍອົງກອນ';
$string['organizationid'] = 'ລະຫັດປະຈຳຕົວອົງກອນ';
$string['organizationid_default'] = 'ລະຫັດປະຈຳຕົວອົງກອນມາດຕະຖານ';
$string['organizationid_default_help'] = 'ຄ່າເລີ່ມຕົ້ນທີ່ຈະໃຊ້ສຳລັບ ລະຫັດປະຈຳຕົວອົງກອນ. ລະຫັດປະຈຳຕົວເວັບໄຊທ໌ (Site ID) ລະບຸການຕິດຕັ້ງຂອງ Moodle ນີ້.';
$string['organizationid_help'] = 'ຕົວລະບຸທີ່ເປັນເອກະລັກສໍາລັບຕົວຢ່າງ Moodle ນີ້. ໂດຍປົກກະຕິ, ຊື່ DNS ຂອງອົງກອນຖືກນໍາໃຊ້.

ຖ້າຊ່ອງຂໍ້ມູນນີ້ ຖືກປະໃຫ້ຫວ່າງເປົ່າ, ຊື່ເຈົ້າພາບຂອງເວັບໄຊທ໌ Moodle ນີ້ຈະຖືກໃຊ້ເປັນຄ່າເລີ່ມຕົ້ນ.';
$string['organizationidguid'] = 'ລະຫັດປະຈຳຕົວອົງກອນ';
$string['organizationidguid_help'] = 'ຕົວລະບຸທີ່ເປັນເອກະລັກສໍາລັບຕົວຢ່າງ Moodle ນີ້ສົ່ງໄປຫາເຄື່ອງມືເປັນຕົວຢ່າງຖານ GUID (Platform Instance GUID).

ຖ້າຊ່ອງຂໍ້ມູນນີ້ຖືກປະໃຫ້ຫວ່າງເປົ່າ, ຄ່າເລີ່ມຕົ້ນຈະຖືກໃຊ້.';
$string['organizationurl'] = 'URL ອົງກອນ';
$string['organizationurl_help'] = 'URL ພື້ນຖານຂອງຕົວຢ່າງ Moodle ນີ້.

ຖ້າຊ່ອງຂໍ້ມູນນີ້ຖືກປະໃຫ້ຫວ່າງເປົ່າ, ຄ່າເລີ່ມຕົ້ນຈະຖືກໃຊ້ໂດຍອີງຕາມການກຳນົດຄ່າເວັບໄຊທ໌.';
$string['pagesize'] = 'ສະແດງການຢື່ນຕໍ່ໜ້າ';
$string['parameter'] = 'ຕົວກຳນົດເຄື່ອງມື';
$string['parameter_help'] = 'ຕົວກໍານົດເຄື່ອງມື ແມ່ນການຕັ້ງຄ່າທີ່ຮ້ອງຂໍໃຫ້ຜ່ານໂດຍຜູ້ໃຫ້ບໍລິການເຄື່ອງມືໃນຕົວແທນເຄື່ອງມືທີ່ຍອມຮັບ.';
$string['password'] = 'ຄວາມລັບທີ່ແບ່ງປັນ';
$string['password_admin'] = 'ຄວາມລັບທີ່ແບ່ງປັນ';
$string['password_admin_help'] = 'ຄວາມລັບທີ່ແບ່ງປັນສາມາດຄິດໄດ້ວ່າເປັນລະຫັດຜ່ານທີ່ໃຊ້ເພື່ອກວດສອບການເຂົ້າເຖິງເຄື່ອງມື. ມັນຄວນຈະໄດ້ຮັບການສະໜອງໃຫ້
ພ້ອມກັບລະຫັດຜູ້ບໍລິໂພກຈາກຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.

ເຄື່ອງມືທີ່ບໍ່ຕ້ອງການການສື່ສານທີ່ປອດໄພຈາກ Moodle ແລະ ບໍ່ໃຫ້ບໍລິການເພີ່ມເຕີມ (ເຊັ່ນ: ການລາຍງານຄະແນນ)
ອາດຈະບໍ່ຮຽກຮ້ອງໃຫ້ມີຄວາມລັບຮ່ວມກັນ.';
$string['password_help'] = 'ສໍາລັບເຄື່ອງມືທີ່ກໍານົດຄ່າລ່ວງໜ້າ, ມັນບໍ່ຈໍາເປັນຕ້ອງໃສ່ຄວາມລັບທີ່ແບ່ງປັນຢູ່ທີ່ນີ້, ເພາະວ່າຄວາມລັບທີ່ແບ່ງປັນຈະ
ສະໜອງໃຫ້ເປັນສ່ວນໜຶ່ງຂອງຂະບວນການກຳນົດຄ່າ.

ຊ່ອງຂໍ້ມູນນີ້ຄວນຈະຖືກໃສ່ ຖ້າສ້າງລິ້ງໄປຫາຜູ້ໃຫ້ບໍລິການເຄື່ອງມືທີ່ບໍ່ໄດ້ກຳນົດຄ່າແລ້ວ.
ຖ້າຜູ້ໃຫ້ບໍລິການເຄື່ອງມືຈະຖືກໃຊ້ຫຼາຍກວ່າຫນຶ່ງຄັ້ງໃນລາຍວິຊານີ້, ການເພີ່ມການກຳນົດຄ່າເຄື່ອງມືຫຼັກສູດແມ່ນເປັນຄວາມຄິດທີ່ດີ.

ຄວາມລັບທີ່ແບ່ງປັນສາມາດຄິດໄດ້ວ່າເປັນລະຫັດຜ່ານທີ່ໃຊ້ເພື່ອກວດສອບການເຂົ້າເຖິງເຄື່ອງມື. ມັນຄວນຈະໄດ້ຮັບການສະໜອງໃຫ້
ພ້ອມກັບລະຫັດຜູ້ບໍລິໂພກຈາກຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.

ເຄື່ອງມືທີ່ບໍ່ຕ້ອງການການສື່ສານທີ່ປອດໄພຈາກ Moodle ແລະ ບໍ່ໃຫ້ບໍລິການເພີ່ມເຕີມ (ເຊັ່ນ: ການລາຍງານຄະແນນ)
ອາດຈະບໍ່ຮຽກຮ້ອງໃຫ້ມີຄວາມລັບຮ່ວມກັນ.';
$string['pending'] = 'ລໍຖ້າ';
$string['pluginadministration'] = 'ການບໍລິຫານເຄື່ອງມືພາຍນອກ';
$string['pluginname'] = 'ເຄື່ອງມືພາຍນອກ';
$string['preferheight'] = 'ຄວາມສູງທີ່ມັກ';
$string['preferwidget'] = 'ເປີດວິດເຈັດທີ່ມັກ';
$string['preferwidth'] = 'ຄວາມກວ້າງທີ່ມັກ';
$string['press_to_submit'] = 'ກົດເພື່ອເປີດໃຊ້ກິດຈະກຳນີ້';
$string['privacy'] = 'ສ່ວນຕົວ';
$string['privacy:metadata:coursefullname'] = 'ຊື່ເຕັມຂອງລາຍວິຊາຂອງຜູ້ໃຊ້ກຳລັງເຂົ້າຫາຜູ້ບໍລິໂພກ LTI ຈາກ';
$string['privacy:metadata:courseid'] = 'ລະຫັດປະຈຳຕົວຂອງລາຍວິຊາຂອງຜູ້ໃຊ້ກຳລັງເຂົ້າຫາຜູ້ບໍລິໂພກ LTI ຈາກ';
$string['privacy:metadata:courseidnumber'] = 'ເລກລະຫັດປະຈຳຕົວຂອງລາຍວິຊາຂອງຜູ້ໃຊ້ກຳລັງເຂົ້າຫາຜູ້ບໍລິໂພກ LTI ຈາກ';
$string['privacy:metadata:courseshortname'] = 'ຊື່ຫຍໍ້ຂອງລາຍວິຊາຂອງຜູ້ໃຊ້ກຳລັງເຂົ້າຫາຜູ້ບໍລິໂພກ LTI ຈາກ';
$string['privacy:metadata:createdby'] = 'ຜູ້ໃຊ້ທີ່ສ້າງບັນທຶກ';
$string['privacy:metadata:email'] = 'ທີ່ຢູ່ອີເມລຂອງຜູ້ໃຊ້ທີ່ເຂົ້າຫາຜູ້ບໍລິໂພກ LTI';
$string['privacy:metadata:externalpurpose'] = 'ຜູ້ບໍລິໂພກ LTIສະໜອງຂໍ້ມູນ ແລະ ບໍລິບົດໄປຫາຜູ້ໃຫ້ບໍລິການເຄື່ອງມື LTI.';
$string['privacy:metadata:firstname'] = 'ຊື່ແທ້ຂອງຜູ້ໃຊ້ທີ່ເຂົ້າຫາຜູ້ບໍລິໂພກ LTI';
$string['privacy:metadata:fullname'] = 'ຊື່ເຕັມຂອງຜູ້ໃຊ້ທີ່ເຂົ້າຫາຜູ້ບໍລິໂພກ LTI';
$string['privacy:metadata:lastname'] = 'ນາມສະກຸນຂອງຜູ້ໃຊ້ທີ່ເຂົ້າຫາຜູ້ບໍລິໂພກ LTI';
$string['privacy:metadata:lti_submission'] = 'ການສົ່ງ LTI';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'ສະແຕມເວລາທີ່ຊີ້ບອກເມື່ອເຮັດການສົ່ງ';
$string['privacy:metadata:lti_submission:dateupdated'] = 'ສະແຕມເວລາທີ່ຊີ້ບອກເມື່ອການສົ່ງຖືກດັດແປງ';
$string['privacy:metadata:lti_submission:gradepercent'] = 'ຄະແນນສຳລັບຜູ້ໃຊ້ເປັນອັດຕາສ່ວນ';
$string['privacy:metadata:lti_submission:originalgrade'] = 'ຄະແນນຕົ້ນສະບັບສຳລັບຜູ້ໃຊ້';
$string['privacy:metadata:lti_submission:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ໄດ້ສົ່ງສຳລັບກິດຈະກຳ LTI';
$string['privacy:metadata:lti_tool_proxies'] = 'ຕົວແທນ LTI';
$string['privacy:metadata:lti_tool_proxies:name'] = 'ຊື່ຕົວແທນ LTI';
$string['privacy:metadata:lti_types'] = 'ປະເພດ LTI';
$string['privacy:metadata:lti_types:name'] = 'ຊື່ປະເພດ LTI';
$string['privacy:metadata:role'] = 'ບົດບາດໃນຫຼັກສູດສໍາລັບຜູ້ໃຊ້ທີ່ເຂົ້າເຖິງຜູ້ບໍລິໂພກ LTI';
$string['privacy:metadata:timecreated'] = 'ເວລາເມື່ອບັນທຶກຖືກສ້າງ';
$string['privacy:metadata:timemodified'] = 'ເວລາເມື່ອບັນທຶກຖືກດັດແກ້';
$string['privacy:metadata:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ເຂົ້າຫາຜູ້ບໍລິໂພກ LTI';
$string['privacy:metadata:useridnumber'] = 'ເລກລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ເຂົ້າຫາຜູ້ບໍລິໂພກ LTI';
$string['privacy:metadata:username'] = 'ຊື່ຜູ້ໃຊ້ຂອງຜູ້ໃຊ້ທີ່ເຂົ້າຫາຜູ້ບໍລິໂພກ LTI';
$string['publickey'] = 'ລະຫັດສາທາລະນະ';
$string['publickey_help'] = 'ກະແຈສາທາລະນະ (ໃນຮູບແບບ PEM) ສະຫນອງໃຫ້ໂດຍເຄື່ອງມືເພື່ອໃຫ້ລາຍເຊັນຂອງຂໍ້ຄວາມຂາເຂົ້າ ແລະ ການຮ້ອງຂໍການບໍລິການໄດ້ຮັບການຢັ້ງຢືນ.';
$string['publickeyset'] = 'ຊຸດລະຫັດສາທາລະນະ';
$string['publickeyset_help'] = 'ຊຸດກະແຈສາທາລະນະຈາກບ່ອນທີ່ເວັບໄຊທ໌ນີ້ຈະດຶງລະຫັດສາທາລະນະຂອງເຄື່ອງມື ເພື່ອອະນຸຍາດໃຫ້ມີລາຍເຊັນຂອງຂໍ້ຄວາມຂາເຂົ້າ ແລະ ຄໍາຮ້ອງຂໍການບໍລິການໄດ້ຮັບການຢັ້ງຢືນ.';
$string['quickgrade'] = 'ອະນຸຍາດການໃຫ້ຄະແນນດ່ວນ';
$string['quickgrade_help'] = 'ຖ້າເປີດໃຊ້ງານ, ເຄື່ອງມືຫຼາຍອັນສາມາດໄດ້ຄະແນນຢູ່ໃນໜ້າດຽວ. ເພີ່ມຄະແນນ ແລະ ຄຳເຫັນ ຈາກນັ້ນຄລິກທີ່ປຸ່ມ "ບັນທຶກຄຳຕິຊົມທັງໝົດຂອງຂ້ອຍ" ເພື່ອບັນທຶກການປ່ຽນແປງທັງໝົດສຳລັບໜ້ານັ້ນ.';
$string['redirect'] = 'ທ່ານຈະຖືກປ່ຽນເສັ້ນທາງໃນສອງສາມວິນາທີ. ຖ້າທ່ານບໍ່ໄດ້ເຮັດ, ກົດປຸ່ມ.';
$string['redirectionuris'] = 'ການປ່ຽນເສັ້ນທາງ URI(s)';
$string['redirectionuris_help'] = 'ບັນຊີລາຍຊື່ຂອງ URIs (ໜຶ່ງຕໍ່ແຖວ) ທີ່ເຄື່ອງມືໃຊ້ໃນເວລາທີ່ເຮັດການຮ້ອງຂໍການອະນຸຍາດ. ຢ່າງໜ້ອຍຕ້ອງມີການລົງທະບຽນກ່ອນຂໍ້ຄວາມສາມາດຖືກສົ່ງໄປຫາເຄື່ອງມືຢ່າງສຳເລັດຜົນ.';
$string['register'] = 'ລົງທະບຽນ';
$string['register_warning'] = 'ຫນ້າລົງທະບຽນເບິ່ງຄືວ່າຈະໃຊ້ເວລາໄລຍະໜຶ່ງເພື່ອເປີດ. ຖ້າມັນບໍ່ປາກົດ, ໃຫ້ກວດເບິ່ງວ່າທ່ານໃສ່ URL ທີ່ຖືກຕ້ອງໃນການຕັ້ງຄ່າການຕັ້ງຄ່າ. ຖ້າ Moodle ກໍາລັງໃຊ້ https, ໃຫ້ແນ່ໃຈວ່າເຄື່ອງມືທີ່ທ່ານກໍາລັງກຳນົດຄ່າຮອງຮັບ https ແລະ ທ່ານກໍາລັງໃຊ້ https ໃນ URL.';
$string['registertype'] = 'ກຳນົດຄ່າການລົງທະບຽນເຄື່ອງມືພາຍນອກໃໝ່';
$string['registration_options'] = 'ທາງເລືອກການລົງທະບຽນ';
$string['registrationname'] = 'ຊື່ຜູ້ສະໜອງເຄື່ອງມື';
$string['registrationname_help'] = 'ໃສ່ຊື່ຂອງຜູ້ໃຫ້ບໍລິການເຄື່ອງມືທີ່ລົງທະບຽນ.';
$string['registrationurl'] = 'URL ການລົງທະບຽນ';
$string['registrationurl_help'] = 'URL ການລົງທະບຽນຄວນຈະມີຢູ່ຈາກຜູ້ໃຫ້ບໍລິການເຄື່ອງມືເປັນສະຖານທີ່ທີ່ຄໍາຮ້ອງຂໍການລົງທະບຽນຄວນຈະຖືກສົ່ງ.';
$string['reject'] = 'ປະຕິເສດ';
$string['rejected'] = 'ຖືກປະຕິເສດ';
$string['resource'] = 'ແຫຼ່ງນໍ້ມູນ';
$string['resourcekey'] = 'ລະຫັດຜູ້ບໍລິໂພກ';
$string['resourcekey_admin'] = 'ລະຫັດຜູ້ບໍລິໂພກ';
$string['resourcekey_admin_help'] = 'ລະຫັດຜູ້ບໍລິໂພກ ສາມາດຖືກຄິດວ່າເປັນຊື່ຜູ້ໃຊ້ທີ່ໃຊ້ເພື່ອຢືນຢັນການເຂົ້າເຖິງເຄື່ອງມື.
ມັນສາມາດຖືກນໍາໃຊ້ໂດຍຜູ້ໃຫ້ບໍລິການເຄື່ອງມື ເພື່ອກໍານົດເວັບໄຊທ໌ Moodle ເປັນເອກະລັກທີ່ຜູ້ໃຊ້ເປີດຕົວເຂົ້າໄປໃນເຄື່ອງມື.

ລະຫັດຜູ້ບໍລິໂພກ ຕ້ອງໄດ້ຮັບການສະໜອງໃຫ້ໂດຍຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ວິທີການທີ່ຈະໄດ້ຮັບລະຫັດຜູ້ບໍລິໂພກແຕກຕ່າງກັນລະຫວ່າງ
ຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ມັນອາດຈະເປັນຂະບວນການອັດຕະໂນມັດ, ຫຼື ມັນອາດຈະຮຽກຮ້ອງໃຫ້ມີການສົນທະນາກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.

ເຄື່ອງມືທີ່ບໍ່ຕ້ອງການການສື່ສານທີ່ປອດໄພຈາກ Moodle ແລະ ບໍ່ໃຫ້ບໍລິການເພີ່ມເຕີມ (ເຊັ່ນ: ການລາຍງານຄະແນນ)
ອາດຈະບໍ່ຕ້ອງການລະຫັດແຫຼ່ງຂໍ້ມູນ.';
$string['resourcekey_help'] = 'ສໍາລັບເຄື່ອງມືທີ່ກໍານົດຄ່າລ່ວງໜ້າ, ມັນບໍ່ຈໍາເປັນຕ້ອງໃສ່ລະຫັດແຫຼ່ງຂໍ້ມູນຢູ່ທີ່ນີ້, ເພາະວ່າລະຫັດຜູ້ບໍລິໂພກຈະເປັນ
ສະໜອງໃຫ້ເປັນສ່ວນຫນຶ່ງຂອງຂະບວນການກຳນົດຄ່າ.

ຊ່ອງຂໍ້ມູນນີ້ຄວນຈະຖືກໃສ່ຖ້າສ້າງລິ້ງໄປຫາຜູ້ໃຫ້ບໍລິການເຄື່ອງມືທີ່ບໍ່ໄດ້ກຳນົດຄ່າແລ້ວ.
ຖ້າຜູ້ໃຫ້ບໍລິການເຄື່ອງມືຈະຖືກໃຊ້ຫຼາຍກວ່າໜຶ່ງຄັ້ງໃນລາຍວິຊານີ້, ການເພີ່ມການກຳນົດຄ່າເຄື່ອງມືລາຍວິຊາແມ່ນເປັນຄວາມຄິດທີ່ດີ.

ລະຫັດຜູ້ບໍລິໂພກ ສາມາດຖືກຄິດວ່າເປັນຊື່ຜູ້ໃຊ້ທີ່ໃຊ້ເພື່ອຢືນຢັນການເຂົ້າເຖິງເຄື່ອງມື.
ມັນສາມາດຖືກນໍາໃຊ້ໂດຍຜູ້ໃຫ້ບໍລິການເຄື່ອງມື ເພື່ອກໍານົດເວັບໄຊທ໌ Moodle ເປັນເອກະລັກທີ່ຜູ້ໃຊ້ເປີດຕົວເຂົ້າໄປໃນເຄື່ອງມື.

ລະຫັດຜູ້ບໍລິໂພກ ຕ້ອງໄດ້ຮັບການສະໜອງໃຫ້ໂດຍຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ວິທີການທີ່ຈະໄດ້ຮັບລະຫັດຜູ້ບໍລິໂພກແຕກຕ່າງກັນລະຫວ່າງ
ຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ມັນອາດຈະເປັນຂະບວນການອັດຕະໂນມັດ, ຫຼື ມັນອາດຈະຮຽກຮ້ອງໃຫ້ມີການສົນທະນາກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.

ເຄື່ອງມືທີ່ບໍ່ຕ້ອງການການສື່ສານທີ່ປອດໄພຈາກ Moodle ແລະ ບໍ່ໃຫ້ບໍລິການເພີ່ມເຕີມ (ເຊັ່ນ: ການລາຍງານຄະແນນ)
ອາດຈະບໍ່ຕ້ອງການລະຫັດແຫຼ່ງຂໍ້ມູນ.';
$string['resourceurl'] = 'URL ແຫຼ່ງຂໍ້ມູນ';
$string['return_to_course'] = 'ຄລິກ <a href="{$a->link}" target="_top">ທີ່ນີ້</a> ເພື່ອກັບຄືນສູ່ລາຍວິຊາ.';
$string['saveallfeedback'] = 'ບັນທຶກຄຳຕິຊົມຂອງຂ້ອຍທັງໝົດ';
$string['search:activity'] = 'ເຄື່ອງມືພາຍນອກ - ຂໍ້ມູນກິດຈະກຳ';
$string['secure_icon_url'] = 'ສັນຍາລັກ URL ທີ່ປອດໄພ';
$string['secure_icon_url_help'] = 'ຄ້າຍຄືກັນກັບສັນຍາລັກ URL, ແຕ່ໃຊ້ເມື່ອເວັບໄຊທ໌ຖືກເຂົ້າເຖິງຢ່າງປອດໄພຜ່ານ SSL. ຊ່ອງຂໍ້ມູນນີ້ ແມ່ນເພື່ອປ້ອງກັນບໍ່ໃຫ້ຕົວທ່ອງເວັບສະແດງຄໍາເຕືອນກ່ຽວກັບຮູບພາບທີ່ບໍ່ປອດໄພ.';
$string['secure_launch_url'] = 'ເຄື່ອງມື URL ທີ່ປອດໄພ';
$string['secure_launch_url_help'] = 'ຄ້າຍຄືກັນກັບ URL ເຄື່ອງມື, ແຕ່ໃຊ້ແທນ URL ເຄື່ອງມືຖ້າມີຄວາມປອດໄພສູງ. Moodle ຈະໃຊ້ URL ເຄື່ອງມືທີ່ປອດໄພແທນ URL ເຄື່ອງມື ຖ້າເວັບໄຊທ໌ Moodle ຖືກເຂົ້າເຖິງຜ່ານ SSL, ຫຼື ຖ້າການຕັ້ງຄ່າເຄື່ອງມືຖືກຕັ້ງໃຫ້ເປີດຜ່ານ SSL ສະເໝີ.

URL ເຄື່ອງມືອາດຈະຖືກຕັ້ງເປັນທີ່ຢູ່ https ເພື່ອບັງຄັບໃຫ້ເປີດຜ່ານ SSL, ແລະ ຊ່ອງຂໍ້ມູນນີ້ອາດຈະຖືກປະໄວ້ຫວ່າງເປົ່າ.';
$string['selectcontent'] = 'ເລືອກເນື້ອຫາ';
$string['send'] = 'ສົ່ງ';
$string['services'] = 'ການບໍລິການ';
$string['services_help'] = 'ເລືອກການບໍລິການທີ່ທ່ານຕ້ອງການສະເໜີໃຫ້ຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ສາມາດເລືອກໄດ້ຫຼາຍກວ່າໜຶ່ງການບໍລິການ.';
$string['setupoptions'] = 'ທາງເລືອກການຕັ້ງຄ່າ';
$string['share_email'] = 'ແບ່ງປັນອີເມລຂອງຕົວເປີດໃຊ້ກັບເຄື່ອງມື';
$string['share_email_admin'] = 'ແບ່ງປັນອີເມລຂອງຕົວເປີດໃຊ້ກັບເຄື່ອງມື';
$string['share_email_admin_help'] = 'ລະບຸວ່າທີ່ຢູ່ອີເມລຂອງຜູ້ໃຊ້ທີ່ເປີດຕົວເຄື່ອງມືຄວນຈະຖືກແບ່ງປັນກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.
ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືອາດຈະຕ້ອງການທີ່ຢູ່ອີເມວຂອງຕົວເປີດໃຊ້ ເພື່ອຈໍາແນກຜູ້ໃຊ້ທີ່ມີຊື່ດຽວກັນຢູ່ໃນ UI, ຫຼື ສົ່ງອີເມລ.
ຫາຜູ້ໃຊ້ໂດຍອີງໃສ່ການປະຕິບັດພາຍໃນເຄື່ອງມື.';
$string['share_email_help'] = 'ລະບຸວ່າທີ່ຢູ່ອີເມລຂອງຜູ້ໃຊ້ທີ່ເປີດຕົວເຄື່ອງມືຄວນຈະຖືກແບ່ງປັນກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.

ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືອາດຈະຕ້ອງການທີ່ຢູ່ອີເມລຂອງ ຕົວເປີດໃຊ້ ເພື່ອຈໍາແນກຜູ້ໃຊ້ທີ່ມີຊື່ດຽວກັນ, ຫຼື ສົ່ງອີເມລໄປຫາຜູ້ໃຊ້ໂດຍອີງໃສ່ການກະທໍາພາຍໃນເຄື່ອງມື.

ກະລຸນາຮັບຊາບວ່າ ການຕັ້ງຄ່ານີ້ ອາດຈະຖືກລົບລ້າງໃນການກຳນົດຄ່າເຄື່ອງມື.';
$string['share_name'] = 'ແບ່ງປັນຊື່ຂອງຕົວເປີດໃຊ້ກັບເຄື່ອງມື';
$string['share_name_admin'] = 'ແບ່ງປັນຊື່ຂອງຕົວເປີດໃຊ້ກັບເຄື່ອງມື';
$string['share_name_admin_help'] = 'ລະບຸວ່າຊື່ເຕັມຂອງຜູ້ໃຊ້ທີ່ເປີດຕົວເຄື່ອງມືຄວນຈະຖືກແບ່ງປັນກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.
ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືອາດຈະຕ້ອງການຊື່ ຕົວເປີດໃຊ້ ເພື່ອສະແດງຂໍ້ມູນທີ່ມີຄວາມໝາຍພາຍໃນເຄື່ອງມື.';
$string['share_name_help'] = 'ລະບຸວ່າຊື່ເຕັມຂອງຜູ້ໃຊ້ທີ່ເປີດຕົວເຄື່ອງມືຄວນຈະຖືກແບ່ງປັນກັບຜູ້ໃຫ້ບໍລິການເຄື່ອງມື.

ຜູ້ໃຫ້ບໍລິການເຄື່ອງມືອາດຈະຕ້ອງການຊື່ ຕົວເປີດໃຊ້ ເພື່ອສະແດງຂໍ້ມູນທີ່ມີຄວາມໝາຍພາຍໃນເຄື່ອງມື.

ກະລຸນາຮັບຊາບວ່າ ການຕັ້ງຄ່ານີ້ ອາດຈະຖືກລົບລ້າງໃນການກຳນົດຄ່າເຄື່ອງມື.';
$string['share_roster'] = 'ອະນຸຍາດເຄື່ອງມືເຂົ້າຫາຕາຕະລາງເວລາຂອງລາຍວິຊານີ້';
$string['share_roster_admin'] = 'ເຄື່ອງມືອາດເຂົ້າຫາຕາຕະລາງເວລາຂອງລາຍວິຊານີ້';
$string['share_roster_admin_help'] = 'ລະບຸວ່າເຄື່ອງມືສາມາດເຂົ້າເຖິງລາຍຊື່ຜູ້ໃຊ້ທີ່ລົງທະບຽນໃນລາຍວິຊາທີ່ເຄື່ອງມືນີ້ຖືກເປີດຕົວຫຼືບໍ່.';
$string['share_roster_help'] = 'ລະບຸວ່າເຄື່ອງມືສາມາດເຂົ້າເຖິງລາຍຊື່ຜູ້ໃຊ້ທີ່ລົງທະບຽນໃນລາຍວິຊານີ້ຫຼືບໍ່.

ກະລຸນາຮັບຊາບວ່າ ການຕັ້ງຄ່ານີ້ ອາດຈະຖືກລົບລ້າງໃນການກຳນົດຄ່າເຄື່ອງມື.';
$string['show_in_course_activity_chooser'] = 'ສະແດງຕົວເລືອກກິດຈະກຳ ແລະ ເປັນເຄື່ອງມືການກຳນົດຄ່າລ່ວງໜ້າ';
$string['show_in_course_lti1'] = 'ນຳໃຊ້ເຄື່ອງມືການກຳນົດຄ່າ';
$string['show_in_course_lti1_help'] = 'ເຄື່ອງມືນີ້ອາດຈະໄດ້ຮັບການສະແດງໃຫ້ເຫັນໃນຕົວເລືອກກິດຈະກໍາສໍາລັບຄູສອນ ທີ່ຈະເລືອກທີ່ຈະເພີ່ມເຂົ້າໄປໃນລາຍວິຊາ. ອີກທາງເລືອກ, ມັນອາດຈະຖືກສະແດງຢູ່ໃນເມນູເລື່ອນລົງຂອງເຄື່ອງມືທີ່ກໍານົດຄ່າລ່ວງໜ້າ ເມື່ອເພີ່ມເຄື່ອງມືພາຍນອກເຂົ້າໃນລາຍວິຊາ. ທາງເລືອກເພີ່ມເຕີມແມ່ນສໍາລັບການກຳນົດຄ່າເຄື່ອງມືທີ່ຈະໃຊ້ພຽງແຕ່ຖ້າ URL ເຄື່ອງມືທີ່ແນ່ນອນຖືກໃສ່ເມື່ອເພີ່ມເຄື່ອງມືພາຍນອກເຂົ້າໃນລາຍວິຊາ.';
$string['show_in_course_lti2'] = 'ນຳໃຊ້ເຄື່ອງມືການກຳນົດຄ່າ';
$string['show_in_course_lti2_help'] = 'ເຄື່ອງມືນີ້ສາມາດສະແດງໃຫ້ເຫັນຢູ່ໃນຕົວເລືອກກິດຈະກໍາສໍາລັບຄູສອນທີ່ຈະເລືອກທີ່ຈະເພີ່ມເຂົ້າໄປໃນວິຊາ ຫຼື ໃນເມນູເລື່ອນລົງເຄື່ອງມືທີ່ກໍານົດຄ່າລ່ວງໜ້າ ໃນເວລາທີ່ການເພີ່ມເຄື່ອງມືພາຍນອກໃນລາຍວິຊາ.';
$string['show_in_course_no'] = 'ຢ່າສະແດງ; ໃຊ້ພຽງແຕ່ເມື່ອໃສ່ URL ເຄື່ອງມືທີ່ກົງກັນ';
$string['show_in_course_preconfigured'] = 'ສະແດງໃຫ້ເຫັນເປັນເຄື່ອງມືກຳນົດຄ່າລ່ວງໜ້າ ໃນເວລາທີ່ເພີ່ມເຄື່ອງມືພາຍນອກ';
$string['sitehost'] = 'ຊື່ເຈົ້າພາຍເວັບໄຊທ໌';
$string['siteid'] = 'ລະຫັດປະຈຳຕົວເວັບໄຊທ໌';
$string['size'] = 'ຂະໜາດຕົວກຳນົດ';
$string['submission'] = 'ການສົ່ງ';
$string['submissions'] = 'ການສົ່ງ';
$string['submissionsfor'] = 'ການສົ່ງສຳລັບ {$a}';
$string['subplugintype_ltiresource'] = 'ແຫຼ່ງຂໍ້ມູນການບໍລິການ LTI';
$string['subplugintype_ltiresource_plural'] = 'ແຫຼ່ງຂໍ້ມູນການບໍລິການ LTI';
$string['subplugintype_ltiservice'] = 'ການບໍລິການ LTI';
$string['subplugintype_ltiservice_plural'] = 'ການບໍລິການ LTI';
$string['subplugintype_ltisource'] = 'ແຫຼ່ງຂໍ້ມູນ LTI';
$string['subplugintype_ltisource_plural'] = 'ແຫຼ່ງຂໍ້ມູນ LTI';
$string['successfullycreatedtooltype'] = 'ສ້າງເຄື່ອງມືໃໝ່ສຳເລັດ!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'ດຶງເອົາການກຳນົດຄ່າເຄື່ອງມືສຳເລັດແລ້ວຈາກເນື້ອຫາທີ່ເລືອກ.';
$string['toggle_debug_data'] = 'ປຸ່ມສະລັກຂໍ້ມູນດີບັກ';
$string['tool_config_not_found'] = 'ບໍ່ພົບການຕັ້ງຄ່າເຄື່ອງມືສໍາລັບ URL ນີ້.';
$string['tool_settings'] = 'ການຕັ້ງຄ່າເຄື່ອງມື';
$string['tooldescription'] = 'ຄຳອະທິບາຍເຄື່ອງມື';
$string['tooldescription_help'] = 'ລາຍລະອຽດຂອງເຄື່ອງມືທີ່ຈະສະແດງໃຫ້ກັບຄູສອນໃນບັນຊີລາຍການກິດຈະກໍາ.

ສິ່ງນີ້ຄວນອະທິບາຍວ່າ ເຄື່ອງມືແມ່ນຫຍັງ ແລະ ມັນເຮັດຫຍັງແດ່ ແລະ ຂໍ້ມູນເພີ່ມເຕີມທີ່ຄູສອນອາດຈະຕ້ອງການຮູ້.';
$string['tooldetailsaccesstokenurl'] = 'ເຂົ້າເຖິງໂທເຄັນ URL';
$string['tooldetailsauthrequesturl'] = 'URL ຮ້ອງຂໍການກວດສອບຄວາມຖືກຕ້ອງ';
$string['tooldetailsclientid'] = 'ລະຫັດປະຈຳຕົວລູກຄ້າ';
$string['tooldetailsdeploymentid'] = 'ການປ່ອຍລະຫັດປະຈຳຕົວ';
$string['tooldetailsmailtosubject'] = 'ການກຳນົດຄ່າເຄື່ອງມື LTI';
$string['tooldetailsmodalemail'] = 'ອີເມລ';
$string['tooldetailsmodallink'] = 'ເບິ່ງລາຍລະອຽດການກຳນົດຄ່າ';
$string['tooldetailsmodaltitle'] = 'ລາຍລະອຽດການກຳນົດຄ່າເຄື່ອງມື';
$string['tooldetailsplatformid'] = 'ລະຫັດປະຈຳຕົວຖານ';
$string['tooldetailspublickeyseturl'] = 'ຊຸດລະຫັດ URL ສາທາລະນະ';
$string['toolisbeingused'] = 'ເຄື່ອງມືນີ້ກຳລັງຖືກນຳໃຊ້ {$a} ເທື່ອ';
$string['toolisnotbeingused'] = 'ເຄື່ອງມືນີ້ຍັງບໍ່ທັນຖືກນຳໃຊ້ເທື່ອ';
$string['toolproxy'] = 'ການລົງທະບຽນເຄື່ອງມືພາຍນອກ';
$string['toolproxy_help'] = 'ການລົງທະບຽນເຄື່ອງມືພາຍນອກອະນຸຍາດໃຫ້ຜູ້ບໍລິຫານເວັບໄຊທ໌ Moodle ກຳນົດຄ່າເຄື່ອງມືພາຍນອກ ຈາກຕົວແທນເຄື່ອງມືທີ່ໄດ້ຮັບຈາກຜູ້ໃຫ້ບໍລິການເຄື່ອງມືທີ່ຮອງຮັບ LTI 2.0. URL ການລົງທະບຽນທີ່ສະໜອງໃຫ້ ໂດຍຜູ້ໃຫ້ບໍລິການເຄື່ອງມືແມ່ນທັງໝົດທີ່ຕ້ອງການ ເພື່ອລິເລີ່ມຂະບວນການ. ຄວາມສາມາດ ແລະ ການບໍລິການທີ່ສະເໜີໃຫ້ຜູ້ໃຫ້ບໍລິການເຄື່ອງມື ຖືກເລືອກເມື່ອກຳນົດຄ່າການລົງທະບຽນໃໝ່.

ການຈົດທະບຽນເຄື່ອງມືທີ່ລະບຸໄວ້ໃນຫນ້ານີ້ໄດ້ຖືກແຍກອອກເປັນສີ່ປະເພດ:

**ການກຳນົດຄ່າແລ້ວ** - ການລົງທະບຽນເຄື່ອງມືເຫຼົ່ານີ້ໄດ້ຖືກສ້າງຕັ້ງຂຶ້ນແຕ່ຂະບວນການລົງທະບຽນຍັງບໍ່ທັນໄດ້ເລີ່ມຕົ້ນ.
* **ລໍຖ້າ** - ຂະບວນການລົງທະບຽນສໍາລັບການລົງທະບຽນເຄື່ອງມືເຫຼົ່ານີ້ໄດ້ຖືກເລີ່ມຕົ້ນແລ້ວແຕ່ຍັງບໍ່ສໍາເລັດ. ເປີດ ແລະ ບັນທຶກການຕັ້ງຄ່າເພື່ອຍ້າຍມັນ
ກັບໄປທີ່ໝວດ \'ກຳນົດຄ່າແລ້ວ\'.
* **ຍອມຮັບແລ້ວ** - ການລົງທະບຽນເຄື່ອງມືເຫຼົ່ານີ້ໄດ້ຮັບການອະນຸມັດ; ແຫຼ່ງຂໍ້ມູນທີ່ລະບຸໄວ້ໃນ ຕົວແທນ ເຄື່ອງມືຈະປາກົດຢູ່ໃນໜ້າເຄື່ອງມືທີ່ກໍານົດໄວ້ກ່ອນ
ດ້ວຍສະຖານະເບື້ອງຕົ້ນຂອງ \'ລໍຖ້າຢູ່\'.
* **ຖືກປະຕິເສດ** - ການລົງທະບຽນເຄື່ອງມືເຫຼົ່ານີ້ແມ່ນໜຶ່ງທີ່ໄດ້ຖືກປະຕິເສດໃນລະຫວ່າງການລົງທະບຽນ. ເປີດ ແລະ ບັນທຶກການຕັ້ງຄ່າເພື່ອຍ້າຍມັນ
ກັບໄປທີ່ປະເພດ \'ກຳນົດຄ່າແລ້ວ\' ດັ່ງນັ້ນ ຂະບວນການລົງທະບຽນສາມາດເລີ່ມຕົ້ນໃໝ່ໄດ້.';
$string['toolproxyregistration'] = 'ການລົງທະບຽນເຄື່ອງມືພາຍນອກ';
$string['toolregistration'] = 'ການລົງທະບຽນເຄື່ອງມືພາຍນອກ';
$string['toolsetup'] = 'ການກຳນົດຄ່າເຄື່ອງມືພາຍນອກ';
$string['tooltypeadded'] = 'ເພີ່ມເຄື່ອງມືການກຳນົດຄ່າລ່ວງໜ້າແລ້ວ';
$string['tooltypedeleted'] = 'ລຶບເຄື່ອງມືການກຳນົດຄ່າລ່ວງໜ້າແລ້ວ';
$string['tooltypenotdeleted'] = 'ບໍ່ສາມາດລຶບເຄື່ອງມືການກຳນົດຄ່າລ່ວງໜ້າ';
$string['tooltypes'] = 'ເຄື່ອງມື';
$string['tooltypeupdated'] = 'ປັບປຸງເຄື່ອງມືການກຳນົດຄ່າລ່ວງໜ້າແລ້ວ';
$string['toolurl'] = 'URL ເຄື່ອງມື';
$string['toolurl_contentitemselectionrequest'] = 'URL ການເລືອກເນື້ອຫາ';
$string['toolurl_contentitemselectionrequest_help'] = 'URL ການເລືອກເນື້ອຫາຈະຖືກໃຊ້ເພື່ອເປີດໜ້າການເລືອກເນື້ອຫາຈາກຜູ້ໃຫ້ບໍລິການເຄື່ອງມື. ຖ້າມັນຫວ່າງເປົ່າ, URL ເຄື່ອງມືຈະຖືກນໍາໃຊ້';
$string['toolurl_help'] = 'URL ເຄື່ອງມືຖືກນໍາໃຊ້ເພື່ອຈັບຄູ່ URL ເຄື່ອງມືກັບການກຳນົດຄ່າເຄື່ອງມືທີ່ຖືກຕ້ອງ. ການນຳໜ້າ URL ດ້ວຍ http(s) ແມ່ນທາງເລືອກ.

ນອກຈາກນັ້ນ, URL ພື້ນຖານຖືກນໍາໃຊ້ເປັນ URL ເຄື່ອງມືຖ້າ URL ເຄື່ອງມືບໍ່ໄດ້ຖືກລະບຸໄວ້ໃນຕົວຢ່າງເຄື່ອງມືພາຍນອກ.

ຕົວຢ່າງ: URL ພື້ນຖານຂອງ *tool.com* ຈະກົງກັບສິ່ງຕໍ່ໄປນີ້:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

URL ພື້ນຖານຂອງ *www.tool.com/quizzes* ຈະກົງກັບສິ່ງຕໍ່ໄປນີ້:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

URL ພື້ນຖານຂອງ *quiz.tool.com* ຈະກົງກັບສິ່ງຕໍ່ໄປນີ້:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

ຖ້າສອງການກຳນົດຄ່າເຄື່ອງມືທີ່ແຕກຕ່າງກັນແມ່ນສໍາລັບໂດເມນດຽວກັນ, ການຈັບຄູ່ສະເພາະທີ່ສຸດຈະຖືກນໍາໃຊ້.

ທ່ານຍັງສາມາດໃສ່ຕະລັບ URL ໄດ້ຖ້າທ່ານມີໜຶ່ງ ແລະ ລາຍລະອຽດຂອງເຄື່ອງມືຈະຖືກຕື່ມໃສ່ໂດຍອັດຕະໂນມັດ.';
$string['toolurlplaceholder'] = 'URL ເຄື່ອງມື...';
$string['typename'] = 'ຊື່ເຄື່ອງມື';
$string['typename_help'] = 'ຊື່ເຄື່ອງມືຖືກໃຊ້ເພື່ອລະບຸຜູ້ໃຫ້ບໍລິການເຄື່ອງມືພາຍໃນ Moodle. ຊື່ທີ່ປ້ອນເຂົ້າຈະເຫັນໄດ້ຕໍ່ກັບຄູສອນ ເມື່ອເພີ່ມເຄື່ອງມືພາຍນອກພາຍໃນວິຊາ.';
$string['types'] = 'ປະເພດ';
$string['unabletocreatetooltype'] = 'ບໍ່ສາມາດສ້າງເຄື່ອງມື';
$string['unabletofindtooltype'] = 'ບໍ່ສາມາດພົບເຄື່ອງມືສຳລັບ {$a->id}';
$string['unknownstate'] = 'ສະຖານະບໍ່ຮູ້ຈັກ';
$string['update'] = 'ປັບປຸງ';
$string['useraccountinformation'] = 'ຂໍ້ມູນບັນຊີຜູ້ໃຊ້';
$string['userpersonalinformation'] = 'ຂໍ້ມູນສ່ວນຕົວຜູ້ໃຊ້';
$string['using_tool_cartridge'] = 'ການນຳໃຊ້ຕະລັບເຄື່ອງມື';
$string['using_tool_configuration'] = 'ການນຳໃຊ້ການກຳນົດຄ່າເຄື່ອງມື:';
$string['validurl'] = 'URL ທີ່ຖືກຕ້ອງ ຕ້ອງເລີ່ມຕົ້ນດ້ວຍ http(s)://';
$string['viewsubmissions'] = 'ເບິ່ງການສົ່ງ ແລະ ການໃຫ້ຄະແນນຫນ້າຈໍ';
