<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'ru', version '4.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Я понимаю и принимаю соглашение об обработке данных';
$string['activityoverview'] = 'У вас есть предстоящие сеансы';
$string['bbbduetimeoverstartingtime'] = 'Время окончания должно быть позже времени начала';
$string['bbbdurationwarning'] = 'Максимальная продолжительность этого сеанса - %duration% мин.';
$string['bbbrecordallfromstartwarning'] = 'Этот сеанс записывается с самого начала.';
$string['bbbrecordwarning'] = 'Этот сеанс может быть записан.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Создавать новое собрание';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Создание экземпляров сеансов в реальном времени';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Создавать собрания с возможностью записи';
$string['bigbluebuttonbn:deleterecordings'] = 'Удалять записи';
$string['bigbluebuttonbn:importrecordings'] = 'Импортировать записи';
$string['bigbluebuttonbn:join'] = 'Участвовать в собрании';
$string['bigbluebuttonbn:managerecordings'] = 'Управлять записями';
$string['bigbluebuttonbn:protectrecordings'] = 'Защищать записи';
$string['bigbluebuttonbn:publishrecordings'] = 'Публиковать записи';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Снимать защиту с записей';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Отменять публикацию записей';
$string['bigbluebuttonbn:view'] = 'Видеть комнату BigBlueButton';
$string['bigbluebuttondisablednotification'] = 'Модуль BigBlueButton был отключен, и любые активные элементы BigBlueButton в курсе в настоящее время недоступны. Перед повторным включением этого плагина убедитесь, что вы прочитали и приняли <a href="{$a}" target="_blank">соглашение об обработке данных</a> с Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'Модуль BigBlueButton отключен.';
$string['cachedef_currentfetch'] = 'Данные для списка всех записей, полученных за последнее время.';
$string['cachedef_recordings'] = 'Запись метаданных';
$string['cachedef_serverinfo'] = 'Сведения об удаленном сервере';
$string['cachedef_validatedurls'] = 'Кэш проверенных URL';
$string['calendarstarts'] = '{$a} запланировано на';
$string['cannotperformaction'] = 'С этой записью невозможно выполнить действие {$a}';
$string['completionattendance'] = 'Студент должен присутствовать на собрании для:';
$string['completionattendance_desc'] = 'Студент должен присутствовать на собрании и участвовать в  сеансе не менее {$a} минут.';
$string['completionattendance_event_desc'] = 'Студент присутствовал на собрании или участвовал в сеансе не менее {$a} минут.';
$string['completionattendancegroup'] = 'Требуется присутствие';
$string['completionattendancegroup_help'] = 'Для выполнения требуется участие в собрании в течение (n) минут';
$string['completionengagement_desc'] = 'Студент должен участвовать в деятельности во время встречи';
$string['completionengagementchats'] = 'Требуемые события чата';
$string['completionengagementchats_desc'] = 'Студент должен принять участие в событиях чата ({$a}), чтобы пройти его.';
$string['completionengagementchats_event_desc'] = 'Участвовал в чатах {$a} раз(а)';
$string['completionengagementemojis'] = 'Смайлики';
$string['completionengagementemojis_desc'] = 'Для выполнения опроса студент должен отправить в него эмодзи - {$a} шт.';
$string['completionengagementemojis_event_desc'] = 'Отправлено эмодзи - {$a}';
$string['completionengagementgroup'] = 'Требуется участие';
$string['completionengagementgroup_help'] = 'Для выполнения необходимо активное участие во время сессии';
$string['completionengagementpollvotes'] = 'Результаты голосования';
$string['completionengagementpollvotes_desc'] = 'Для выполнения опроса студент должен проголосовать в нем {$a} раз(а).';
$string['completionengagementpollvotes_event_desc'] = 'Проголосовано в опросе {$a} раз(а)';
$string['completionengagementraisehand'] = 'События поднятия руки';
$string['completionengagementraisehand_desc'] = 'Учащийся должен поднять руку {$a} раз(а), чтобы выполнить задание.';
$string['completionengagementraisehand_event_desc'] = 'Рука поднята {$a} раз(а)';
$string['completionengagementtalks'] = 'События при разговоре';
$string['completionengagementtalks_desc'] = 'Студент должен говорить {$a} времени, чтобы выполнить задание.';
$string['completionengagementtalks_event_desc'] = 'Говорил(а) {a}';
$string['completionupdatestate'] = 'Состояние завершения обновления';
$string['completionvalidatestate'] = 'Состояние проверки выполнения';
$string['completionvalidatestatetriggered'] = 'Была инициирована проверка выполнения.';
$string['completionview'] = 'Требуется просмотр';
$string['completionview_desc'] = 'Студент должен присоединиться к собранию или ознакомиться с  записью, чтобы выполнить задание.';
$string['completionview_event_desc'] = 'Присоединений к собранию (просмотрена запись) - {$a} раз(а)';
$string['config_default_messages'] = 'Сообщения по умолчанию';
$string['config_default_messages_description'] = 'Задать сообщения по умолчанию для конференций';
$string['config_disablecam_default'] = 'Отключить веб-камеру, включенную по умолчанию';
$string['config_disablecam_default_description'] = 'При установленном параметре веб-камеры будут отключены.';
$string['config_disablecam_editable'] = 'Отключение веб-камер можно изменить';
$string['config_disablecam_editable_description'] = 'Отключение веб-камер по умолчанию можно редактировать при добавлении или обновлении экземпляра.';
$string['config_disablemic_default'] = 'Отключить микрофон, включенный по умолчанию';
$string['config_disablemic_default_description'] = 'При установленном параметре микрофоны будут отключены.';
$string['config_disablemic_editable'] = 'Отключение микрофона можно изменить';
$string['config_disablemic_editable_description'] = 'Отключение микрофона по умолчанию можно редактировать при добавлении или обновлении экземпляра.';
$string['config_disablenote_default'] = 'Отключить общие заметки, включенные по умолчанию';
$string['config_disablenote_default_description'] = 'При установленном параметре общие заметки будут отключены.';
$string['config_disablenote_editable'] = 'Отключение общих заметок можно изменить';
$string['config_disablenote_editable_description'] = 'Отключение общих заметок по умолчанию можно редактировать при добавлении или обновлении экземпляра.';
$string['config_disableprivatechat_default'] = 'Отключить приватный чат, включенный по умолчанию';
$string['config_disableprivatechat_default_description'] = 'При установленном параметре приватный чат будет отключен.';
$string['config_disableprivatechat_editable'] = 'Отключение приватного чата можно изменить';
$string['config_disableprivatechat_editable_description'] = 'Отключение приватного чата по умолчанию можно редактировать при добавлении или обновлении экземпляра.';
$string['config_disablepublicchat_default'] = 'Отключить публичный чат, включенный по умолчанию';
$string['config_disablepublicchat_default_description'] = 'Если этот параметр отмечен, публичный чат будет отключен.';
$string['config_disablepublicchat_editable'] = 'Отключение публичного чата можно изменить';
$string['config_disablepublicchat_editable_description'] = 'Отключение публичного чата по умолчанию можно редактировать при добавлении или обновлении экземпляра.';
$string['config_dpa_note'] = 'Примечание. Чтобы выполнить свои обязательства по защите данных, прежде чем использовать этот плагин, вы должны убедиться, что прочитали и приняли соглашение об обработке данных поставщика услуг. Для бесплатного сервиса BigBlueButton по умолчанию это <a href="{$a}" target="_blank">соглашение об обработке данных Blindside Networks</a>. Пожалуйста, посоветуйтесь или проконсультируйтесь со своими специалистами по конфиденциальности.';
$string['config_experimental_features'] = 'Экспериментальные функции';
$string['config_experimental_features_description'] = 'Конфигурация для экспериментальных функций';
$string['config_extended_capabilities'] = 'Расширенные возможности';
$string['config_extended_capabilities_description'] = 'Настройки для расширенных возможностей в случае, если сервер BigBlueButton позволяет их использование.';
$string['config_general'] = 'Общие настройки';
$string['config_general_description'] = 'Эти параметры используются <b>всегда</b>';
$string['config_hideuserlist_default'] = 'Список пользователей скрыт по умолчанию';
$string['config_hideuserlist_default_description'] = 'Если этот параметр включен, список пользователей сеанса будет скрыт.';
$string['config_hideuserlist_editable'] = 'Скрытие списка пользователей может быть изменено';
$string['config_hideuserlist_editable_description'] = 'Скрытие списка пользователей может быть изменено при добавлении или обновлении экземпляра.';
$string['config_importrecordings'] = 'Настройка функции «Импорт записей»';
$string['config_importrecordings_description'] = 'Эти настройки являются специфичными для конкретных функций';
$string['config_importrecordings_enabled'] = 'Импорт записей разрешен';
$string['config_importrecordings_enabled_description'] = 'Когда эта функция и функция записи включены, можно импортировать в конференцию записи из разных курсов.';
$string['config_importrecordings_from_deleted_enabled'] = 'Разрешен импорт из удаленных записей';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Когда эта функция и функция импорта записей включены, то можно импортировать записи из конференций, которые больше не находятся в курсе.';
$string['config_lockonjoin_default'] = 'Игнорирование блокировки при присоединении включено по умолчанию';
$string['config_lockonjoin_default_description'] = 'Если этот параметр включен, настройки блокировки будут проигнорированы. Для этого необходимо включить конфигурацию блокировки';
$string['config_lockonjoin_editable'] = 'Игнорирование блокировки при присоединении можно изменить';
$string['config_lockonjoin_editable_description'] = 'Игнорирование по умолчанию блокировки при присоединении можно изменить при добавлении или обновлении экземпляра.';
$string['config_locksettings'] = 'Конфигурация блокировки параметров';
$string['config_locksettings_description'] = 'Эти настройки включают или отключают в пользовательском интерфейсе блокировку параметров, а также определяют значения по умолчанию для этих параметров.';
$string['config_meetingevents_enabled'] = 'Зарегистрировать события встречи';
$string['config_meetingevents_enabled_description'] = 'Функция регистрации события встречи включена.';
$string['config_muteonstart'] = 'Конфигурация для функции «Без звука при запуске»';
$string['config_muteonstart_default'] = 'Без звука при запуске включено по умолчанию';
$string['config_muteonstart_default_description'] = 'Если включено, сеанс будет без звука при запуске.';
$string['config_muteonstart_description'] = 'Эти настройки включают или отключают параметры в пользовательском интерфейсе, а также определяют значения по умолчанию для этих параметров.';
$string['config_muteonstart_editable'] = '«Без звука при запуске» можно изменить';
$string['config_muteonstart_editable_description'] = 'Параметр по умолчанию «Без звука при запуске» может быть изменен при добавлении или обновлении экземпляра.';
$string['config_participant'] = 'Участники';
$string['config_participant_description'] = 'Эти параметры определяют роль по умолчанию для участников конференции.';
$string['config_participant_moderator_default'] = 'Модератор по умолчанию';
$string['config_participant_moderator_default_description'] = 'Это правило используется по умолчанию при добавлении нового собрания.';
$string['config_presentation_default'] = 'Файл по умолчанию для функции «Предварительная загрузка презентации»';
$string['config_presentation_default_description'] = 'Этот параметр позволяет выбрать файл, который будет использоваться по умолчанию во всех экземплярах BBB, если включена функция «Предварительная загрузка презентации».';
$string['config_preuploadpresentation'] = 'Настройка функции «Предварительная загрузка презентации»';
$string['config_preuploadpresentation_description'] = 'Эти настройки включают или отключают параметры в пользовательском интерфейсе, а также определяют значения по умолчанию для этих параметров.
Функция работает, только если сервер Moodle доступен для BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Предварительная загрузка презентации доступна для редактирования';
$string['config_preuploadpresentation_editable_description'] = 'Функция предварительной загрузки презентации доступна для редактирования в пользовательском интерфейсе при добавлении или обновлении конференции.';
$string['config_recording'] = 'Конфигурация для функции «Запись встречи»';
$string['config_recording_all_from_start_default'] = 'Записать всё с самого начала';
$string['config_recording_all_from_start_default_description'] = 'Если флажок установлен, то собрание будет записываться с самого начала';
$string['config_recording_all_from_start_editable'] = '«Записать всё с самого начала» можно изменить';
$string['config_recording_all_from_start_editable_description'] = 'Если этот флажок установлен, то интерфейс включает в себя опцию включения и отключения функции «Записать всё с самого начала».';
$string['config_recording_default'] = 'Функция записи включена по умолчанию';
$string['config_recording_default_description'] = 'Если включено, созданные сеансы будут иметь возможности записи.';
$string['config_recording_description'] = 'Эти настройки являются специфичными для конкретных функций';
$string['config_recording_editable'] = 'Функция записи может быть отредактирована';
$string['config_recording_editable_description'] = 'Если этот флажок установлен, то интерфейс включает в себя опцию включения и отключения функции записи';
$string['config_recording_hide_button_default'] = 'Скрыть кнопку записи';
$string['config_recording_hide_button_default_description'] = 'Если отмечено, кнопка для записи будет скрыта';
$string['config_recording_hide_button_editable'] = '«Скрыть кнопку записи» можно изменить';
$string['config_recording_hide_button_editable_description'] = 'Если отмечено, интерфейс включает в себя возможность включения и выключения функции скрытия кнопки записи.';
$string['config_recording_protect_editable'] = 'Состояние защиты записей можно изменять';
$string['config_recording_protect_editable_description'] = 'При установленном флажке интерфейс включает опцию защиты/снятия защиты записей.';
$string['config_recording_refresh_period'] = 'Период обновления записи (в секундах)';
$string['config_recording_refresh_period_description'] = 'Чтобы избежать слишком частых запросов к серверу Bigbluebutton, мы кэшируем записываемую информацию. Это период обновления в секундах, который определяет, как часто мы можем/будем обновлять информацию для данной записи. По умолчанию - 300 с (5 минут).';
$string['config_recordingready_enabled'] = 'Уведомления о готовности записи включены';
$string['config_recordingready_enabled_description'] = 'Включите плагин для отправки уведомлений, когда запись будет готова. (Он будет работать, только если на сервере BigBlueButton включен скрипт post_publish_recording_ready_callback)';
$string['config_recordings'] = 'Конфигурация для функции «Показать записи»';
$string['config_recordings_asc_sort'] = 'Упорядочить записи в порядке возрастания.';
$string['config_recordings_asc_sort_description'] = 'По умолчанию записи отображаются в порядке убывания. При проверке они будут отсортированы в порядке возрастания.';
$string['config_recordings_deleted_default'] = 'Параметр «Включить записи из удаленных собраний» включен по умолчанию';
$string['config_recordings_deleted_default_description'] = 'Если этот параметр включен, то в таблицу записи будут включены записи, относящиеся к удаленным конференциям, если таковые имеются.';
$string['config_recordings_deleted_editable'] = 'Функцию «Включить записи из удаленных собраний» можно изменить';
$string['config_recordings_deleted_editable_description'] = 'По умолчанию «Включить записи из удаленных конференций» можно редактировать при добавлении или обновлении экземпляра.';
$string['config_recordings_description'] = 'Эти настройки являются специфичными для конкретных функций';
$string['config_recordings_general'] = 'Показать настройки записи';
$string['config_recordings_general_description'] = 'Эти настройки используются только при показе записей';
$string['config_recordings_imported_default'] = '«Показывать только импортированные ссылки» включено по умолчанию';
$string['config_recordings_imported_default_description'] = 'Если этот параметр включен, таблица записи будет содержать только импортированные ссылки на записи.';
$string['config_recordings_imported_editable'] = 'Опцию «Показывать только импортированные ссылки» можно редактировать';
$string['config_recordings_imported_editable_description'] = 'По умолчанию «Показывать только импортированные ссылки» можно редактировать при добавлении или обновлении экземпляра.';
$string['config_recordings_preview_default'] = 'Предварительный просмотр включен по умолчанию';
$string['config_recordings_preview_default_description'] = 'Если включено, таблица включает предварительный просмотр презентации.';
$string['config_recordings_preview_editable'] = 'Функцию предварительного просмотра можно редактировать';
$string['config_recordings_preview_editable_description'] = 'Функцию предварительного просмотра можно редактировать при добавлении или обновлении экземпляра.';
$string['config_scheduled'] = 'Настройки для функции «Запланированные сеансы»';
$string['config_scheduled_description'] = 'Эти параметры определяют поведение по умолчанию для запланированных сеансов.';
$string['config_scheduled_pre_opening'] = 'Доступ заранее (в минутах)';
$string['config_scheduled_pre_opening_description'] = 'Этот параметр задает за сколько минут до времени открытия сеанс становится доступен.';
$string['config_server_url'] = 'URL сервера BigBlueButton';
$string['config_server_url_description'] = 'Учетные данные по умолчанию предназначены для <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">бесплатного сервиса BigBlueButton для Moodle (открывается в новом окне)</a >, предоставляемого Blindside Networks со следующими ограничениями:
<ol>
<li>Максимальная продолжительность каждого сеанса – 60 минут.</li>
<li>Максимальное количество одновременных пользователей за сеанс – 25.</li>
<li>Срок действия записей истекает через семь (7) дней, и их нельзя скачать.</li>
<li>Веб-камеры учащихся видны только модератору.</li>
</ol>';
$string['config_shared_secret'] = 'Секретный ключ BigBlueButton';
$string['config_shared_secret_description'] = 'Секретный ключ Вашего сервера BigBlueButton. (Значение по умолчанию — это секретный ключ сервера BigBlueButton, предоставленного компанией Blindside Networks, который Вы можете использовать для тестирования.)';
$string['config_uidelegation_enabled'] = 'Делегирование пользовательского интерфейса включено';
$string['config_uidelegation_enabled_description'] = 'Эти параметры включают или отключают делегирование пользовательского интерфейса серверу BigBlueButton.';
$string['config_userlimit'] = 'Конфигурация для функции «Ограничение пользователя»';
$string['config_userlimit_default'] = 'Ограничение пользователя включено по умолчанию';
$string['config_userlimit_default_description'] = 'Количество пользователей, разрешенных в сеансе по умолчанию при добавлении новой комнаты или конференции. Если число равно 0, ограничение не устанавливается';
$string['config_userlimit_description'] = 'Эти настройки включают или отключают параметры в пользовательском интерфейсе, а также определяют значения по умолчанию для этих параметров.';
$string['config_userlimit_editable'] = 'Функцию ограничения пользователей можно редактировать';
$string['config_userlimit_editable_description'] = 'Значение ограничения пользователей по умолчанию может быть изменено при добавлении или обновлении комнаты или конференции.';
$string['config_voicebridge'] = 'Конфигурация для функции «Голосовой мост»';
$string['config_voicebridge_description'] = 'Эти настройки включают или отключают параметры в пользовательском интерфейсе, а также определяют значения по умолчанию для этих параметров.';
$string['config_voicebridge_editable'] = 'Голосовой мост конференции можно редактировать';
$string['config_voicebridge_editable_description'] = 'Номер голосового моста конференции может быть постоянно присвоен комнате конференции. При присвоении этого номера он не может быть использован никакой другой комнатой или конференцией';
$string['config_waitformoderator'] = 'Настройка функции «Ожидание модератора»';
$string['config_waitformoderator_cache_ttl'] = 'Ожидание TTL кэша модератора (секунды)';
$string['config_waitformoderator_cache_ttl_description'] = 'Для поддержки большой нагрузки клиентов этот плагин использует кэш. Этот параметр определяет время хранения кэша до отправки следующего запроса на сервер BigBlueButton.';
$string['config_waitformoderator_default'] = 'Ожидание модератора включено по умолчанию';
$string['config_waitformoderator_default_description'] = 'Функция «Ожидание модератора» включена по умолчанию при добавлении новой комнаты или конференции.';
$string['config_waitformoderator_description'] = 'Эти настройки зависят от конкретных функций';
$string['config_waitformoderator_editable'] = '«Ожидание модератора» можно изменить';
$string['config_waitformoderator_editable_description'] = 'Ожидание модератора по умолчанию можно редактировать при добавлении или обновлении комнаты или конференции.';
$string['config_waitformoderator_ping_interval'] = 'Интервал пинга «Ожидание модератора» (секунды)';
$string['config_waitformoderator_ping_interval_description'] = 'Как часто нужно пинговать сервер, чтобы проверить, заходил ли модератор в комнату?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton использует config.php с глобальной переменной, которая была признана устаревшей. Пожалуйста, конвертируйте файл, так как он не будет поддерживаться в будущих версиях';
$string['config_warning_curl_not_installed'] = 'Для работы этой функции требуется, чтобы расширение CURL языка PHP было установлено и включено. Настройки будут доступны только если это условие выполнено.';
$string['config_welcome_default'] = 'Приветственное сообщение по умолчанию';
$string['config_welcome_default_description'] = 'Приветственное сообщение отображается, когда участники входят в комнату конференции. При пустом поле отображается сообщение, установленное на сервере BigBlueButton.';
$string['config_welcome_editable'] = 'Приветственное сообщение по умолчанию доступно для редактирования учителями';
$string['config_welcome_editable_description'] = 'Приветственное сообщение можно редактировать при добавлении или обновлении конференции';
$string['enablingbigbluebutton'] = 'Включение BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'Чтобы выполнить свои обязательства по защите данных, перед включением этого модуля вы должны подтвердить, что прочитали и приняли <a href="{$a}" target="_blank">соглашение об обработке данных Blindside Networks</a>. Пожалуйста, посоветуйтесь или проконсультируйтесь со своими специалистами по конфиденциальности.';
$string['end_session_confirm'] = 'Вы уверены, что хотите завершить сеанс виртуального класса?';
$string['end_session_confirm_title'] = 'Завершить сеанс?';
$string['end_session_notification'] = 'Сеанс уже закрыт.';
$string['ends_at'] = 'Окончания';
$string['event_activity_created'] = 'Элемент курса «Видеоконференция BigBlueButton» создан';
$string['event_activity_deleted'] = 'Элемент курса «Видеоконференция BigBlueButton» удален';
$string['event_activity_updated'] = 'Элемент обновлён';
$string['event_live_session'] = 'В прямом эфире';
$string['event_meeting_created'] = 'Собрание BigBlueButton создано';
$string['event_meeting_ended'] = 'Собрание BigBlueButton принудительно завершено';
$string['event_meeting_joined'] = 'Пользователь присоединился к собранию BigBlueButton';
$string['event_meeting_left'] = 'Пользователь покинул собрание BigBlueButton';
$string['event_recording_deleted'] = 'Запись собрания BigBlueButton удалена';
$string['event_recording_edited'] = 'Запись изменена';
$string['event_recording_imported'] = 'Запись импортирована';
$string['event_recording_protected'] = 'Запись защищена';
$string['event_recording_published'] = 'Запись собрания BigBlueButton опубликована';
$string['event_recording_unprotected'] = 'Запись не защищена';
$string['event_recording_unpublished'] = 'Отменена публикация записи собрания BigBlueButton';
$string['event_recording_viewed'] = 'Запись просмотрена';
$string['event_unknown'] = 'Неизвестное событие';
$string['general_error_cannot_create_meeting'] = 'Не удалось создать собрание.';
$string['general_error_cannot_get_recordings'] = 'Не удалось получить записи.';
$string['general_error_no_answer'] = 'Пустой ответ. Пожалуйста, проверьте URL-адрес сервера BigBlueButton И убедитесь в работе сервера BigBlueButton.';
$string['general_error_not_allowed_to_create_instances'] = 'Пользователю не разрешается создавать экземпляры любого типа.';
$string['general_error_not_found'] = 'Объект не найден: {$a}.';
$string['general_error_unable_connect'] = 'Невозможно подключится к серверу. Проверьте URL сервера BigBlueButton И убедитесь, что сервер BigBlueButton работает.
Подробности: {$a}';
$string['index_confirm_end'] = 'Вы хотите завершить это собрание?';
$string['index_disabled'] = 'отключено';
$string['index_enabled'] = 'включено';
$string['index_ending'] = 'Идет завершение собрания... Пожалуйста, подождите';
$string['index_error_bbtn'] = 'ID BigBlueButton {$a} неверен';
$string['index_error_checksum'] = 'Ошибка контрольной суммы. Убедитесь, что Вы ввели правильный секретный ключ сервера.';
$string['index_error_forciblyended'] = 'Невозможно принять участие в этом собрании, поскольку оно было принудительно завершено.';
$string['index_error_noinstances'] = 'Нет никаких экземпляров BigBlueButtonBN';
$string['index_error_unable_display'] = 'Невозможно отобразить собрание. Проверьте URL сервера BigBlueButton и убедитесь, что сервер BigBlueButton работает.';
$string['index_heading'] = 'Видеоконференции BigBlueButton';
$string['index_heading_actions'] = 'Действия';
$string['index_heading_group'] = 'Группа';
$string['index_heading_moderator'] = 'Руководители';
$string['index_heading_name'] = 'Собрание';
$string['index_heading_recording'] = 'Запись';
$string['index_heading_users'] = 'Пользователей';
$string['index_heading_viewer'] = 'Участники';
$string['indicator:cognitivedepth'] = 'BigBlueButton: познавательный аспект';
$string['indicator:cognitivedepth_help'] = 'Этот показатель основан на глубине познания, достигнутой учащимся в BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButton: социальный аспект';
$string['indicator:socialbreadth_help'] = 'Этот показатель основан на социальной активности, достигнутой студентом в BigBlueButton.';
$string['instance_type_default'] = 'Комната/Элемент с записями';
$string['instance_type_recording_only'] = 'Только записи';
$string['instance_type_room_only'] = 'Только Комнаты/Элементы';
$string['instanceprofilewithoutrecordings'] = 'Этот экземпляр профиля не может демонстрировать записи';
$string['messageprovider:instance_updated'] = 'Собрание BigBlueButton обновлено';
$string['messageprovider:recording_ready'] = 'Запись BigBlueButton готова к просмотру';
$string['minute'] = 'мин.';
$string['minutes'] = 'мин.';
$string['mod_form_block_general'] = 'Основные настройки';
$string['mod_form_block_participants'] = 'Участники';
$string['mod_form_block_presentation'] = 'Презентация';
$string['mod_form_block_presentation_default'] = 'Содержимое презентации по умолчанию';
$string['mod_form_block_record'] = 'Настройки записи';
$string['mod_form_block_recordings'] = 'Посмотреть запись';
$string['mod_form_block_room'] = 'Настройки Экземпляра/Комнат';
$string['mod_form_block_schedule'] = 'Расписание сеансов';
$string['mod_form_field_closingtime'] = 'Подключение закрывается';
$string['mod_form_field_conference_name'] = 'Название собрания';
$string['mod_form_field_disablecam'] = 'Отключить веб-камеры';
$string['mod_form_field_disablemic'] = 'Отключить микрофоны';
$string['mod_form_field_disablenote'] = 'Отключить общие заметки';
$string['mod_form_field_disableprivatechat'] = 'Отключить приватный чат';
$string['mod_form_field_disablepublicchat'] = 'Отключить публичный чат';
$string['mod_form_field_duration'] = 'Длительность';
$string['mod_form_field_duration_help'] = 'Установка продолжительности позволяет ограничить максимальное время собрания';
$string['mod_form_field_hideuserlist'] = 'Скрыть список пользователей';
$string['mod_form_field_instanceprofiles'] = 'Тип экземпляра';
$string['mod_form_field_instanceprofiles_help'] = 'Выберите тип для этого экземпляра BigBlueButton.';
$string['mod_form_field_intro'] = 'Описание';
$string['mod_form_field_intro_help'] = 'Краткое описание собрания';
$string['mod_form_field_lockonjoin'] = 'Игнорировать настройки блокировки';
$string['mod_form_field_muteonstart'] = 'Отключение микрофона при подключении';
$string['mod_form_field_name'] = 'Название виртуального собрания';
$string['mod_form_field_nosettings'] = 'Никакие настройки не могут быть изменены';
$string['mod_form_field_openingtime'] = 'Подключение открывается';
$string['mod_form_field_participant_add'] = 'Добавить участника';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Руководитель';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Наблюдатель';
$string['mod_form_field_participant_list'] = 'Список участников';
$string['mod_form_field_participant_list_action_add'] = 'Добавить';
$string['mod_form_field_participant_list_action_remove'] = 'Удалить';
$string['mod_form_field_participant_list_text_as'] = 'в качестве';
$string['mod_form_field_participant_list_type_all'] = 'Все записанные на курс пользователи';
$string['mod_form_field_participant_list_type_owner'] = 'Владелец';
$string['mod_form_field_participant_list_type_role'] = 'Роль';
$string['mod_form_field_participant_list_type_user'] = 'Пользователь';
$string['mod_form_field_record'] = 'Сеанс может быть записан';
$string['mod_form_field_recordallfromstart'] = 'Записывать всё с самого начала';
$string['mod_form_field_recordhidebutton'] = 'Скрыть кнопку Запись';
$string['mod_form_field_recordings_deleted'] = 'Включить записи из удаленных конференций';
$string['mod_form_field_recordings_html'] = 'Показать таблицу в обычном html';
$string['mod_form_field_recordings_imported'] = 'Показывать только импортированные ссылки';
$string['mod_form_field_recordings_preview'] = 'Показать предварительный просмотр записи';
$string['mod_form_field_room_name'] = 'Название собрания';
$string['mod_form_field_userlimit'] = 'Ограничение на количество пользователей';
$string['mod_form_field_userlimit_help'] = 'Максимальное разрешенное количество пользователей на собрании. Если установлено значение 0, то количество пользователей не будет ограничено.';
$string['mod_form_field_voicebridge'] = 'Номер голосового моста [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Некорректный формат. Вы должны указать число от 1 до 99999';
$string['mod_form_field_voicebridge_help'] = 'Номер, по которому участники могут подключиться к голосовой конференции с использованием телефонной связи. Необходимо указать число от 1 до 99999. Если указать значение 0, что вместо постоянного номера для голосового моста будет использоваться случайное значение. При использовании четырехзначного номера перед номером будет добавлена цифра 7.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Вы указали неуникальное значение. Этот номер используется другим собранием.';
$string['mod_form_field_wait'] = 'Участники должны ожидать входа руководителя';
$string['mod_form_field_wait_help'] = 'При включении этого параметра участники не смогут подключиться к сеансу до тех пор, пока не подключится руководитель';
$string['mod_form_field_welcome'] = 'Приветственное сообщение';
$string['mod_form_field_welcome_default'] = '<br>Добро пожаловать на собрание <b>«%%CONFNAME%%»</b>!<br><br>Чтобы разобраться, как пользоваться системой BigBlueButton, Вы можете посмотреть <a href="event:http://www.bigbluebutton.org/content/videos"><u>обучающие видео</u></a> (на английском языке).<br><br>Для участия в аудиоконференции нажмите на изображение головной гарнитуры (наушников) в верхнем левом углу. <b>Пожалуйста, используйте гарнитуру, чтобы  уберечь себя и других от неприятного гула.</b>';
$string['mod_form_field_welcome_help'] = 'Можно заменить стандартное сообщение, настроенное для сервера BigBlueButton. Сообщение может содержать подстановки (%%CONFNAME%% - название конференции, %%DIALNUM%% - номер телефона, %%CONFNUM%% - номер конференции), а также тэги html, например <b>...</b> или <i>...</i>.';
$string['mod_form_locksettings'] = 'Настройки блокировки';
$string['modulename'] = 'Видеоконференция BigBlueButton';
$string['modulename_help'] = 'Модуль «Видеоконференция BigBlueButton» позволяет создавать в Moodle ссылки на виртуальные онлайн собрания в BigBlueButton - системе с открытым исходным кодом для проведения веб-конференций для дистанционного обучения.
Используя этот модуль, Вы можете указать название, описание, событие календаря (диапазон дат, в который возможно участие), группы и параметры записи онлайн сеанса.';
$string['modulenameplural'] = 'Видеоконференции BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Видеоконференция BigBlueButton';
$string['nosuchinstance'] = 'Нет такого экземпляра {$a->entity} с ID: {$a->id}';
$string['notification_instance_created_intro'] = 'Создана видеоконференция  BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_instance_created_small'] = 'Создано новое собрание BigBlueButton с названием {$a->name}.';
$string['notification_instance_created_subject'] = 'Создано новое собрание BigBlueButton.';
$string['notification_instance_description'] = 'Описание';
$string['notification_instance_end_date'] = 'Дата окончания';
$string['notification_instance_name'] = 'Название';
$string['notification_instance_start_date'] = 'Дата начала';
$string['notification_instance_updated_intro'] = 'Видеоконференция  BigBlueButton <a href="{$a->link}">{$a->name}</a> была обновлена.';
$string['notification_instance_updated_small'] = 'Собрание BigBlueButton с названием {$a->name} было обновлено.';
$string['notification_instance_updated_subject'] = 'ваше собрание BigBlueButton было обновлено';
$string['notification_recording_ready_html'] = 'Запись недавнего собрания <b><a href="{$a->link}">{$a->name}</a></b> теперь доступна.';
$string['notification_recording_ready_plain'] = 'Запись недавнего смобрания {$a->name} теперь доступна. См. {$a->link}, чтобы просмотреть собрание.';
$string['notification_recording_ready_small'] = 'Доступна запись нового собрания {$a->name} BigBlueButton';
$string['notification_recording_ready_subject'] = 'Запись готова';
$string['pluginadministration'] = 'Управление модулем «Видеоконференция BigBlueButton»';
$string['pluginname'] = 'Видеоконференция BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Чтобы создавать сеансы BigBlueButton и присоединяться к ним, необходимо обмениваться пользовательскими данными с сервером.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Полное имя пользователя, получающего доступ к серверу BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'ID пользователя, обращающегося к серверу BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Сохраняет конфигурацию комнаты или конференции, которая определяет функции и общее поведение сеанса BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Список правил, определяющих роль пользователей в живом собрании. Идентификатор пользователя может быть сохранен, поскольку разрешения могут быть предоставлены для каждой роли или пользователя.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Хранит события, инициированные при использовании плагина.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Тип события, инициируемого пользователем.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Идентификатор собрания, к которому у пользователя был доступ.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Может включать дополнительную информацию, связанную с собранием или записью, на которую повлияло событие.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Время, в которое был создан журнал.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID пользователя, инициировавшего событие.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Хранит метаданные о записях.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'ID пользователя, который последним изменил запись.';
$string['recordings_from_deleted_activities'] = 'Записи удаленных собраний';
$string['recordingurlnotfound'] = 'URL-адрес записи недействителен.';
$string['removedevents'] = 'Удаленные события';
$string['removedlogs'] = 'Удаленные пользовательские журналы';
$string['removedrecordings'] = 'Удаленные записи';
$string['removedtags'] = 'Удаленные теги';
$string['report_join_info'] = 'Присоединение к комнате {$a} раз(а)';
$string['report_play_recording_info'] = 'Просмотрена запись {$a} раз(а)';
$string['report_room_view'] = 'Просмотрена комната';
$string['resetevents'] = 'Удалить события';
$string['resetlogs'] = 'Удалить пользовательские журналы';
$string['resetlogs_help'] = 'Удаление журналов приведет к потере ссылок на записи';
$string['resetrecordings'] = 'Удалить записи';
$string['resetrecordings_help'] = 'Удаление записей сделает их недоступными из любого места, и это невозможно отменить';
$string['resettags'] = 'Удалить теги';
$string['search:activity'] = 'BigBlueButton - информация о деятельности';
$string['search:tags'] = 'BigBlueButton - информация о тегах';
$string['sendnotification'] = 'Отправить уведомление';
$string['settings'] = 'Настройки BigBlueButton';
$string['started_at'] = 'Начато';
$string['starts_at'] = 'Началось';
$string['taskname:check_pending_recordings'] = 'Получить ожидаемые записи';
$string['userlimitreached'] = 'Достигнуто максимальное количество пользователей, разрешенных для участия в собрании.';
$string['view_conference_action_end'] = 'Завершить сеанс';
$string['view_conference_action_join'] = 'Подключиться к сеансу';
$string['view_error_action_not_completed'] = 'Действие не может быть завершено';
$string['view_error_bigbluebutton'] = 'BigBlueButton ответил ошибками. {$a}';
$string['view_error_create'] = 'Сервер BigBlueButton вернул сообщение об ошибке. Собрание не может быть создано.';
$string['view_error_current_state_not_found'] = 'Текущее состояние не найдено. Возможно, запись была удалена или сервер BigBlueButton несовместим с выполняемым действием.';
$string['view_error_import_no_courses'] = 'Нет курсов для поиска записей';
$string['view_error_import_no_recordings'] = 'В этом курсе нет записей для импорта';
$string['view_error_invalid_session'] = 'Срок действия сеанса истек. Вернитесь на главную страницу активного элемента.';
$string['view_error_max_concurrent'] = 'Достигнуто максимально количество одновременных собраний.';
$string['view_error_meeting_not_running'] = 'Что-то пошло не так, собрание не начато.';
$string['view_error_no_group'] = 'Группы еще не настроены. Пожалуйста, сначала настройте группы, а уже после этого повторите попытку подключения к собранию.';
$string['view_error_no_group_student'] = 'Вы не записаны ни в одну из групп. Пожалуйста, свяжитесь с учителем или администратором.';
$string['view_error_no_group_teacher'] = 'Группы еще не настроены. Пожалуйста, настройте группы или свяжитесь с администратором.';
$string['view_error_unable_join'] = 'Невозможно присоединиться к собранию. Проверьте URL сервера BigBlueButton и убедитесь, что сервер BigBlueButton работает.';
$string['view_error_unable_join_student'] = 'Невозможно подключиться к серверу BigBlueButton. Пожалуйста, свяжитесь с учителем или администратором.';
$string['view_error_unable_join_teacher'] = 'Невозможно подключиться к серверу BigBlueButton. Пожалуйста, свяжитесь с администратором.';
$string['view_error_url_missing_parameters'] = 'В этом URL-адресе отсутствуют параметры';
$string['view_error_userlimit_reached'] = 'Для этого собрания достигнуто максимально количество пользователей.';
$string['view_groups_nogroups_warning'] = 'Комната была настроена для использования групп, но на курсе не определены группы.';
$string['view_groups_notenrolled_warning'] = 'Комната была настроена для использования групп, но вы не зарегистрированы ни в одной из них.';
$string['view_groups_selection'] = 'Выберите группу, к которой Вы хотите присоединиться и нажмите «Войти»';
$string['view_groups_selection_join'] = 'Войти';
$string['view_groups_selection_warning'] = 'Для каждой из групп создано отдельное собрание. Если у Вас есть доступ к нескольким собраниям, убедитесь, что выбрали нужное.';
$string['view_login_moderator'] = 'Вход в качестве руководителя ...';
$string['view_login_viewer'] = 'Вход в качестве участника ...';
$string['view_message_and'] = 'и';
$string['view_message_conference_has_ended'] = 'Это собрание закончилось.';
$string['view_message_conference_in_progress'] = 'Это собрание сейчас идет.';
$string['view_message_conference_not_started'] = 'Это собрание еще не началось.';
$string['view_message_conference_room_ready'] = 'Собрание подготовлено. Сейчас Вы можете подключиться к сеансу.';
$string['view_message_conference_wait_for_moderator'] = 'Ожидание подключения руководителя.';
$string['view_message_finished'] = 'Это собрание завершено.';
$string['view_message_has_joined'] = 'подключился';
$string['view_message_have_joined'] = 'подключились';
$string['view_message_hour'] = 'час';
$string['view_message_hours'] = 'часов';
$string['view_message_importrecordings_disabled'] = 'Функция импорта ссылок для записи отключена на этом сервере.';
$string['view_message_minute'] = 'минута';
$string['view_message_minutes'] = 'минут';
$string['view_message_moderator'] = 'руководитель';
$string['view_message_moderators'] = 'руководители';
$string['view_message_norecordings'] = 'Нет записей этого собрания.';
$string['view_message_notavailableyet'] = 'Этот сеанс еще не доступен.';
$string['view_message_recordings_disabled'] = 'Записи на этом сервере были отключены. Экземпляры BigBlueButton нельзя использовать только для записей.';
$string['view_message_room_closed'] = 'Это собрание закрыто.';
$string['view_message_room_open'] = 'Это собрание открыто.';
$string['view_message_room_ready'] = 'Это собрание готово.';
$string['view_message_session_for'] = 'сессия для';
$string['view_message_session_has_user'] = 'Участвует';
$string['view_message_session_has_users'] = 'Участвуют';
$string['view_message_session_no_users'] = 'В этом сеансе нет пользователей';
$string['view_message_session_running_for'] = 'Этот сеанс идет уже';
$string['view_message_session_started_at'] = 'Этот сеанс начался в';
$string['view_message_tab_close'] = 'Эта вкладка или это окно должно быть закрыто вручную';
$string['view_message_times'] = 'раз';
$string['view_message_user'] = 'пользователь';
$string['view_message_users'] = 'пользователей';
$string['view_message_viewer'] = 'наблюдатель';
$string['view_message_viewers'] = 'наблюдателей';
$string['view_mobile_message_groups_not_supported'] = 'Этот экземпляр позволяет работать с группами, но мобильное приложение не поддерживает это. Пожалуйста, откройте на рабочем столе, если вы хотите воспользоваться поддержкой группы.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Вы превысили 45 секунд на этой странице, пожалуйста, перезагрузите страницу, чтобы правильно присоединиться к собранию.';
$string['view_noguests'] = 'Гости не могут участвовать в видеоконференции BigBlueButton';
$string['view_nojoin'] = 'У Вас недостаточно прав для участия в этом сеансе';
$string['view_recording'] = 'запись';
$string['view_recording_actionbar'] = 'Действия';
$string['view_recording_activity'] = 'Элемент курса';
$string['view_recording_button_import'] = 'Импорт ссылок записей';
$string['view_recording_button_return'] = 'Вернуться';
$string['view_recording_course'] = 'Курс';
$string['view_recording_date'] = 'Дата';
$string['view_recording_delete_confirmation'] = 'Вы уверены, что хотите удалить {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'С этой записью связаны ссылки ({$a}), которые были импортированы в различные курсы или конференции. Если запись будет удалена, эти ссылки также будут удалены.';
$string['view_recording_delete_confirmation_warning_s'] = 'С этой записью связана ссылка {$a}, которая была импортирована в другой курс или конференцию. Если запись будет удалена, эта ссылка также будет удалена';
$string['view_recording_description'] = 'Описание';
$string['view_recording_description_edithint'] = 'Отредактируйте описание. Это позже поможет найти запись';
$string['view_recording_description_editlabel'] = 'Редактировать описание';
$string['view_recording_duration'] = 'Длительность';
$string['view_recording_duration_min'] = 'мин.';
$string['view_recording_format_errror_unreachable'] = 'URL-адрес для этого формата записи недоступен.';
$string['view_recording_format_notes'] = 'Заметки';
$string['view_recording_format_podcast'] = 'Подкаст';
$string['view_recording_format_presentation'] = 'Презентация';
$string['view_recording_format_screenshare'] = 'Демонстрация рабочего стола';
$string['view_recording_format_statistics'] = 'Статистика';
$string['view_recording_format_video'] = 'Видео';
$string['view_recording_import_confirmation'] = 'Вы уверены, что хотите импортировать эту запись?';
$string['view_recording_length'] = 'Длина';
$string['view_recording_link_warning'] = 'Эта ссылка указывает на запись, созданную в другом курсе или конференции';
$string['view_recording_list_action_delete'] = 'Удаление';
$string['view_recording_list_action_edit'] = 'Обновление';
$string['view_recording_list_action_play'] = 'Воспроизведение';
$string['view_recording_list_action_process'] = 'Обработка';
$string['view_recording_list_action_protect'] = 'Установка защиты';
$string['view_recording_list_action_publish'] = 'Публикация';
$string['view_recording_list_action_unprotect'] = 'Снятие защиты';
$string['view_recording_list_action_unpublish'] = 'Снятие с публикации';
$string['view_recording_list_action_update'] = 'Обновление';
$string['view_recording_list_actionbar'] = 'Действия';
$string['view_recording_list_actionbar_delete'] = 'Удалить';
$string['view_recording_list_actionbar_edit'] = 'Изменить';
$string['view_recording_list_actionbar_hide'] = 'Скрыть';
$string['view_recording_list_actionbar_import'] = 'Импортировать';
$string['view_recording_list_actionbar_protect'] = 'Сделать приватной';
$string['view_recording_list_actionbar_publish'] = 'Опубликовать';
$string['view_recording_list_actionbar_show'] = 'Отобразить';
$string['view_recording_list_actionbar_unprotect'] = 'Сделать общедоступной';
$string['view_recording_list_actionbar_unpublish'] = 'Отменить публикацию';
$string['view_recording_list_activity'] = 'Элемент курса';
$string['view_recording_list_course'] = 'Курс';
$string['view_recording_list_date'] = 'Дата';
$string['view_recording_list_description'] = 'Описание';
$string['view_recording_list_duration'] = 'Длительность';
$string['view_recording_list_recording'] = 'Запись';
$string['view_recording_meeting'] = 'Собрание';
$string['view_recording_modal_button'] = 'Применить';
$string['view_recording_modal_title'] = 'Введите информацию об этой записи';
$string['view_recording_name'] = 'Название';
$string['view_recording_name_edithint'] = 'Измените название. Это позже поможет найти запись';
$string['view_recording_name_editlabel'] = 'Изменить название';
$string['view_recording_playback'] = 'Воспроизведение';
$string['view_recording_preview'] = 'Предпросмотр';
$string['view_recording_preview_help'] = 'Наведите курсор на изображение, чтобы просмотреть его в полном размере';
$string['view_recording_protect_confirmation'] = 'Вы уверены, что хотите защитить {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'С этой записью связаны ссылки ({$a}), которые были импортированы в другие курсы или активные элементы. Если запись защищена, это также повлияет на импортированные ссылки.';
$string['view_recording_protect_confirmation_warning_s'] = 'С этой записью связана ссылка {$a}, которая была импортирована в другой курс или активный элемент. Если запись защищена, это также повлияет на импортированные ссылки.';
$string['view_recording_publish_confirmation'] = 'Вы уверены, что хотите опубликовать {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'С этой записью связаны ссылки ( {$a}), которые были импортированы в другие курсы или занятия. Если запись будет опубликована, эти ссылки также будут опубликованы.';
$string['view_recording_publish_confirmation_warning_s'] = 'С этой записью связана ссылка {$a}, которая была импортирована в другой курс или занятие. Если запись будет опубликована, эта ссылка также будет опубликована.';
$string['view_recording_publish_link_deleted'] = 'Эта ссылка не может быть опубликована повторно, поскольку фактическая запись не существует на текущем сервере BigBlueButton. Ссылка должна быть удалена.';
$string['view_recording_publish_link_not_published'] = 'Эта ссылка не может быть повторно опубликована, поскольку фактическая запись не опубликована';
$string['view_recording_recording'] = 'Запись';
$string['view_recording_select_course'] = 'Сначала выберите курс в раскрывающемся меню';
$string['view_recording_tags'] = 'Теги';
$string['view_recording_unprotect_confirmation'] = 'Вы уверены, что хотите снять защиту с {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'С этой записью связаны ссылки ({$a}), которые были импортированы в другие курсы или занятия. Если запись не защищена, это также повлияет на импортированные ссылки.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'С этой записью связана ссылка {$a}, которая была импортирована в другой курс или занятие. Если запись не защищена, это также повлияет на импортированные ссылки.';
$string['view_recording_unprotect_link_deleted'] = 'Эта ссылка не может быть незащищена, поскольку фактическая запись не существует на текущем сервере BigBlueButton. Ссылка должна быть удалена.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Эта ссылка не может быть незащищена, так как фактическая запись защищена';
$string['view_recording_unpublish_confirmation'] = 'Вы уверены, что хотите снять с публикации {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'С этой записью связаны ссылки ({$a}), которые были импортированы в другие курсы или конференции. Если запись не опубликована, эти ссылки также будут не опубликованы';
$string['view_recording_unpublish_confirmation_warning_s'] = 'С этой записью связана ссылка {$a}, которая была импортирована в другой курс или конференцию. Если запись не опубликована, эта ссылка также будет не опубликована';
$string['view_recording_yui_first'] = 'Первая';
$string['view_recording_yui_go'] = 'Вперёд';
$string['view_recording_yui_last'] = 'Последняя';
$string['view_recording_yui_next'] = 'Следующая';
$string['view_recording_yui_page'] = 'Страница';
$string['view_recording_yui_prev'] = 'Предыдущая';
$string['view_recording_yui_rows'] = 'Строки';
$string['view_recording_yui_show_all'] = 'Показать все';
$string['view_room'] = 'Посмотреть комнату';
$string['view_section_title_presentation'] = 'Файл презентации';
$string['view_section_title_recordings'] = 'Записи';
$string['view_warning_default_server'] = 'Этот сайт использует <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">бесплатный сервис BigBlueButton для Moodle (открывается в новом окне)</a>, предоставляемый Blindside Networks со следующими ограничениями:
<ol>
<li>Максимальная продолжительность каждого сеанса – 60 минут.</li>
<li>Максимальное количество одновременных пользователей за сеанс – 25.</li>
<li>Срок действия записей истекает через семь (7) дней, и их нельзя скачать.</li>
<li>Веб-камеры учащихся видны только модератору.</li>
</ol>';
$string['waitformoderator'] = 'Ждем подключения модератора.';
