<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'de', version '4.0'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Zugriffssteuerung';
$string['actionaftercorrectanswer'] = 'Aktion nach richtiger Antwort';
$string['actionaftercorrectanswer_help'] = 'Nachdem eine Frage richtig beantwortet wurde, gibt es 3 Optionen für eine Fortsetzung:

* Normal - dem Pfad der Lektion folgen
* Ungesehene Seite zeigen - die Seiten werden in zufälliger Reihenfolge gezeigt, ohne eine Seite doppelt aufzurufen
* Unbeantwortete Seite zeigen - die Seiten werden in zufälliger Reihenfolge gezeigt, wobei Seiten mit unbeantworteten Fragen auch nochmal aufgerufen werden
';
$string['actions'] = 'Aktionen';
$string['activitylink'] = 'Link zur nächsten Aktivität';
$string['activitylink_help'] = 'Um einen Link am Ende der Lektion zu einer weiteren Aktivität im Kurs einzufügen, wählen Sie die Aktivität aus dem Auswahlmenü.';
$string['activitylinkname'] = 'Zu \'{$a}\' gehen';
$string['activityoverview'] = 'Eine oder mehrere Lektionen sind fällig';
$string['addabranchtable'] = 'Inhaltsseite einfügen';
$string['addanendofbranch'] = 'Ende des Zweigs hinzufügen';
$string['addanewpage'] = 'Weitere Seite einfügen';
$string['addaquestionpage'] = 'Frageseite einfügen';
$string['addaquestionpagehere'] = 'Frageseite hier einfügen';
$string['addbranchtable'] = 'Inhaltsseite einfügen';
$string['addcluster'] = 'Cluster hinzufügen';
$string['addedabranchtable'] = 'Inhaltsseite eingefügt';
$string['addedanendofbranch'] = 'Ende des Zweigs hinzugefügt';
$string['addedaquestionpage'] = 'Fragenseite hinzugefügt';
$string['addedcluster'] = 'Cluster hinzugefügt';
$string['addedendofcluster'] = 'Ende des Clusters hinzugefügt';
$string['addendofbranch'] = 'Ende des Asts hinzufügen';
$string['addendofcluster'] = 'Ende des Clusters hinzufügen';
$string['addessay'] = 'Seite mit Freitextfrage anlegen';
$string['addmatching'] = 'Seite mit Zuordnungsfrage anlegen';
$string['addmultichoice'] = 'Seite mit Multiple-Choice-Frage anlegen';
$string['addnewgroupoverride'] = 'Gruppenänderung hinzufügen';
$string['addnewuseroverride'] = 'Nutzeränderung hinzufügen';
$string['addnumerical'] = 'Seite mit numerischer Frage anlegen';
$string['addpage'] = 'Seite einfügen';
$string['addshortanswer'] = 'Seite mit Kurzantwortfrage anlegen';
$string['addtruefalse'] = 'Seite mit Wahr/Falsch-Frage anlegen';
$string['allotheranswers'] = 'Alle anderen Antworten';
$string['allotheranswersjump'] = 'Sprung bei einer anderen Antwort';
$string['allotheranswersscore'] = 'Alle anderen Antworten bewerten';
$string['allowofflineattempts'] = 'Versuch der Lektion offline in Moodle Mobile erlauben';
$string['allowofflineattempts_help'] = 'Wenn diese Option aktiviert ist, können Teilnehmer/innen die Lektion mit Moodle Mobile herunterladen und sie offline versuchen. Alle möglichen Antworten (auch die korrekten Antworten) werden heruntergeladen.

Hinweis: Es ist nicht möglich, dass eine Lektion offline versucht wird, wenn sie eine zeitliche Begrenzung hat.';
$string['anchortitle'] = 'Start des Hauptinhalts';
$string['and'] = 'UND';
$string['answer'] = 'Antwort';
$string['answeredcorrectly'] = 'der Zuordnungen waren richtig';
$string['answersfornumerical'] = 'Bei numerischen Fragen können ein Minimal- und ein Maximalwert als richtige Lösung angegeben werden.';
$string['arrangebuttonshorizontally'] = 'Verzweigungstasten horizontal anordnen?';
$string['attempt'] = 'Versuch: {$a}';
$string['attemptheader'] = 'Versuch';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Versuche';
$string['attemptsdeleted'] = 'Versuche gelöscht';
$string['attemptsremaining'] = 'Verbleibende Versuche: {$a}';
$string['available'] = 'Verfügbar ab';
$string['averagescore'] = 'Durchschnittliche Bewertung';
$string['averagetime'] = 'Durchschnittliche Zeit';
$string['branch'] = 'Inhalt';
$string['branchtable'] = 'Inhaltsseite';
$string['cachedef_overrides'] = 'Informationen zu Nutzer- und Gruppenänderungen';
$string['cancel'] = 'Abbrechen';
$string['cannotfindanswer'] = 'Fehler: Antwort konnte nicht gefunden werden';
$string['cannotfindattempt'] = 'Fehler: Versuch konnte nicht gefunden werden';
$string['cannotfindessay'] = 'Fehler: Freitext-Antwort konnte nicht gefunden werden';
$string['cannotfindfirstgrade'] = 'Fehler: Bewertungen konnten nicht gefunden werden';
$string['cannotfindfirstpage'] = 'Erste Seite konnte nicht gefunden werden';
$string['cannotfindgrade'] = 'Fehler: Bewertungen konnten nicht gefunden werden';
$string['cannotfindnewestgrade'] = 'Fehler: Aktuelle Bewertung konnte nicht gefunden werden';
$string['cannotfindnextpage'] = 'Lektionssicherung: Nächste Seite wurde nicht gefunden!';
$string['cannotfindpagerecord'] = 'Verzweigungsende hinzufügen: Seitendaten wurden nicht gefunden';
$string['cannotfindpages'] = 'Lektionsseiten konnten nicht gefunden werden';
$string['cannotfindpagetitle'] = 'Löschen bestätigen: Seitentitel wurde nicht gefunden';
$string['cannotfindpreattempt'] = 'Vorheriger Versuch konnte nicht gefunden werden!';
$string['cannotfindrecords'] = 'Fehler: Lektionsdaten konnten nicht gefunden werden';
$string['cannotfindtimer'] = 'Fehler: Die Daten lesson_timer konnten nicht gefunden werden';
$string['cannotfinduser'] = 'Fehler: Nutzer/innen konnten nicht gefunden werden';
$string['canretake'] = 'Wiederholungen';
$string['casesensitive'] = 'Reguläre Ausdrücke verwenden';
$string['casesensitive_help'] = 'Wenn diese Option aktiviert ist, werden reguläre Ausdrücke für die Auswertung der Antworten verwendet';
$string['checkbranchtable'] = 'Inhaltsseite testen';
$string['checkedthisone'] = 'Kreuzten dies an.';
$string['checknavigation'] = 'Navigation testen';
$string['checkquestion'] = 'Frage testen';
$string['classstats'] = 'Statistik';
$string['clicktodownload'] = 'Klicken Sie auf den Link, um die Datei herunter zu laden.';
$string['closebeforeopen'] = 'Die Lektion konnte nicht aktualisiert werden. Die Endzeit muss nach der Anfangszeit liegen.';
$string['cluster'] = 'Cluster';
$string['clusterjump'] = 'Ungesehene Frage innerhalb des Clusters';
$string['clustertitle'] = 'Cluster';
$string['collapsed'] = 'Kurzform';
$string['comments'] = 'Ihr Feedback';
$string['completed'] = 'Abgeschlossen';
$string['completederror'] = 'Lektion abschließen';
$string['completethefollowingconditions'] = 'Sie müssen die folgende(n) Bedingung(en) in der Lektion <b>{$a}</b> erfüllen, um fortfahren zu dürfen:';
$string['completiondetail:reachend'] = 'Das Ende der Lektion erreichen';
$string['completiondetail:timespent'] = 'Mindestens {$a} in dieser Lektion verbringen';
$string['completionendreached'] = 'Ende der Lektion muss erreicht sein';
$string['completionendreached_desc'] = 'Zum Abschluss der Lektion muss das Ende der Lektion erreicht worden sein';
$string['completiontimespent'] = 'Teilnehmer/in muss diese Zeit mit dieser Aktivität verbringen';
$string['completiontimespentdesc'] = 'Der/die Teilnehmer/in muss diese Aktivität für mindestens {$a} ausführen';
$string['completiontimespentgroup'] = 'Verbrachte Zeit erforderlich';
$string['conditionsfordependency'] = 'Bedingungen für Abhängigkeit';
$string['configintro'] = 'Die hier festgelegten Werte werden als Vorgaben beim Anlegen einer neuen Lektion verwendet. Einstellungen, die als erweitert bezeichnet sind, sind nur dann sichtbar, wenn der Link \'Mehr anzeigen ...\' angeklickt wird.';
$string['configmaxanswers'] = 'Maximalzahl von Antworten pro Seite';
$string['configmediaclose'] = 'Taste \'Schließen\' im Popup-Fenster für eine verlinkte Mediendatei anzeigen';
$string['configmediaheight'] = 'Höhe des Popup-Fensters für eine verlinkte Mediendatei';
$string['configmediawidth'] = 'Breite des Popup-Fensters für eine verlinkte Mediendatei';
$string['configpassword_desc'] = 'Die Option legt fest, ob ein Kennwort für den Zugriff auf die Lektion notwendig ist.';
$string['configslideshowbgcolor'] = 'Hintergrundfarbe der Slideshow, falls sie aktiviert ist';
$string['configslideshowheight'] = 'Höhe der Slideshow, falls sie aktiviert ist';
$string['configslideshowwidth'] = 'Breite der Slideshow, falls sie aktiviert ist';
$string['configtimelimit_desc'] = 'Wenn ein Zeitlimit gesetzt ist, wird zu Beginn der Lektion ein Hinweis angezeigt und während der Bearbeitung die Zeit heruntergezählt. Wenn das Zeitlimit auf 0 gesetzt wird, ist das Zeitlimit ausgeschaltet.';
$string['confirmdelete'] = 'Seite löschen';
$string['confirmdeletionofthispage'] = 'Diese Seite löschen?';
$string['congratulations'] = 'Das Ende der Lektion ist erreicht!';
$string['continue'] = 'Fortsetzen';
$string['continuetoanswer'] = 'Weitere Antworten ändern';
$string['continuetonextpage'] = 'Auf der nächsten Seite fortsetzen';
$string['correctanswerjump'] = 'Sprung bei richtiger Antwort';
$string['correctanswerscore'] = 'Bewertung bei richtiger Antwort';
$string['correctresponse'] = 'Feedback bei richtiger Antwort';
$string['createaquestionpage'] = 'Fragenseite anlegen';
$string['credit'] = 'Bewertung';
$string['customscoring'] = 'Standardbewertung (Punkte)';
$string['customscoring_help'] = 'Wenn diese Option aktiviert ist, kann jede Antwort mit einer numerischen Punktzahl zu versehen werden, wobei auch negative Punkte möglich sind.';
$string['deadline'] = 'Verfügbar bis';
$string['defaultessayresponse'] = 'Die Freitext-Antwort wird später bewertet.';
$string['deleteallattempts'] = 'Alle Versuche der Lektion löschen';
$string['deletedefaults'] = '{$a} x Lektionen gelöscht';
$string['deletedpage'] = 'Seite gelöscht';
$string['deletepagenamed'] = 'Seite löschen: {$a}';
$string['deleting'] = 'Lösche';
$string['deletingpage'] = 'Lösche Seite {$a}';
$string['dependencyon'] = 'Abhängigkeit von anderen Lektionen';
$string['dependencyon_help'] = 'Diese Option ermöglicht es, den Zugriff auf diese Lektion vom Ergebnis einer anderen Lektion innerhalb des Kurses abhängig zu machen. Dabei ist jede Kombination aus den Faktoren \'aufgewendete Zeit\', \'abgeschlossen\' oder \'Bewertung besser als\' möglich.';
$string['description'] = 'Beschreibung';
$string['deselectallattempts'] = 'Alle Versuche abwählen';
$string['detailedstats'] = 'Ergebnisanalyse';
$string['didnotanswerquestion'] = 'Hat diese Frage nicht beantwortet.';
$string['didnotreceivecredit'] = 'Hat keine Bewertung erhalten';
$string['disabled'] = 'Deaktiviert';
$string['displaydefaultfeedback'] = 'Standardfeedback benutzen';
$string['displaydefaultfeedback_help'] = '<p>Bei der Einstellung <strong>Ja</strong> wird die Standardrückmeldung (Richtig/Falsch) angezeigt, sofern keine individuelle Rückmeldung vorhanden ist.</p>
<p>Bei der Einstellung <strong>Nein</strong> wird keine Rückmeldung angezeigt, sofern keine individuelle Rückmeldung vorhanden ist. Die Teilnehmer/innen werden dann automatisch zur nächsten Seite der Lektion geführt. </p>';
$string['displayinleftmenu'] = 'Im Menü anzeigen?';
$string['displayleftif'] = 'Inhaltsverzeichnis nur anzeigen, wenn die Bewertung höher ist als';
$string['displayleftif_help'] = 'Diese Option legt fest, ob eine bestimmte Bewertung erreicht sein muss, damit das Menü sichtbar ist. Dies zwingt Teilnehmer/innen, bei ihrem ersten Versuch durch die gesamte Lektion zu gehen. Erst mit dem Erreichen einer bestimmten Punktzahl kann das Menü benutzt werden, um  alle Lösungen nochmals zu kontrollieren.';
$string['displayleftmenu'] = 'Inhaltsverzeichnis anzeigen';
$string['displayleftmenu_help'] = 'Diese Option legt fest, ob ein Menü zur Navigation zwischen den Seiten angezeigt wird.';
$string['displayofgrade'] = 'Anzeige der Bewertungen (für Teilnehmer/innen)';
$string['displayreview'] = 'Wiederholung bei falscher Antwort';
$string['displayreview_help'] = 'Wenn diese Option aktiviert ist und eine Frage falsch beantwortet wird, haben Teilnehmer/innen die Möglichkeit, die Frage erneut ohne Punkte zu wiederholen oder weiter mit der Lektion fortzufahren. Wenn Teilnehmer/innen klicken, zu einer anderen Frage zu gehen, wird die bereits gewählte (falsche) Antwort berücksichtigt. Standardmäßig sind Sprünge bei falscher Antwort auf "diese Seite" gesetzt und haben eine Punktzahl 0. Daher wird empfohlen, den Sprung bei falscher Antwort auf eine andere Seite zu setzen, um Konfusion bei den Teilnehmer/innen zu vermeiden.';
$string['displayscorewithessays'] = '<p>Sie haben bisher für die automatisch bewerteten Fragen die Bewertung {$a->score} von {$a->tempmaxgrade} erzielt.</p>
<p>Ihre Freitext-Aufgaben ({$a->essayquestions}) werden später bewertet und zur Gesamtbewertung hinzugefügt.</p>
<p>Ihre derzeitige Bewertung ohne die Freitextaufgaben ist {$a->score} von {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Ihre Bewertung: {$a->score} von {$a->grade}';
$string['duplicatepagenamed'] = 'Seite duplizieren: {$a}';
$string['edit'] = 'Bearbeiten';
$string['editbranchtable'] = 'Inhaltsseite bearbeiten';
$string['editcluster'] = 'Cluster bearbeiten';
$string['editendofbranch'] = 'Seite mit Astende bearbeiten';
$string['editendofcluster'] = 'Seite mit Clusterende bearbeiten';
$string['editessay'] = 'Seite mit Freitextfrage bearbeiten';
$string['editinglesson'] = 'Lektion bearbeiten';
$string['editingquestionpage'] = 'Frageseite {$a} bearbeiten';
$string['editlesson'] = 'Lektion bearbeiten';
$string['editlessonsettings'] = 'Einstellungen für Lektion bearbeiten';
$string['editmatching'] = 'Seite mit Zuordnungsfrage bearbeiten';
$string['editmultichoice'] = 'Seite mit Multiple-Choice-Frage bearbeiten';
$string['editnumerical'] = 'Seite mit numerischer Frage bearbeiten';
$string['editoverride'] = 'Überschreibung bearbeiten';
$string['editpage'] = 'Seite bearbeiten';
$string['editpagecontent'] = 'Inhalt der Seite bearbeiten';
$string['editquestion'] = 'Seite mit Frage bearbeiten';
$string['editshortanswer'] = 'Seite mit Kurzantwortfrage bearbeiten';
$string['edittruefalse'] = 'Seite mit Wahr/Falsch-Frage beantworten';
$string['email'] = 'E-Mail';
$string['emailallgradedessays'] = 'Benachrichtigungen zur Freitext-Bewertung versenden';
$string['emailgradedessays'] = 'Benachrichtigungen zur Freitext-Bewertung versenden';
$string['emailsuccess'] = 'Benachrichtigungen erfolgreich gesendet';
$string['emptypassword'] = 'Das Kennwort darf nicht leer sein.';
$string['enabled'] = 'Aktiviert';
$string['endofbranch'] = 'Ende des Zweigs';
$string['endofcluster'] = 'Clusterende';
$string['endofclustertitle'] = 'Clusterende';
$string['endoflesson'] = 'Ende der Lektion';
$string['enteredthis'] = 'der Antworten';
$string['enterpassword'] = 'Geben Sie bitte das Kennwort ein:';
$string['eolstudentoutoftime'] = 'Achtung: Die verfügbare Zeit ist abgelaufen. Die letzte Frage wird nicht bewertet, wenn die Antwort nach Zeitablauf abgegeben wurde.';
$string['eolstudentoutoftimenoanswers'] = 'Sie haben keine Fragen beantwortet. Sie erhalten deswegen 0 Punkte für die Lektion.';
$string['essay'] = 'Freitext';
$string['essayemailmessage2'] = '<p>Freitextfrage: {$a->question}</p><p>Ihre Antwort: <em>{$a->response}</em></p><p>Trainer/innenfeedback: <em>{$a->comment}</em></p><p>Sie haben {$a->earned} von {$a->outof} Punkten bei dieser Frage erhalten.</p><p>Ihre aktuelle Bewertung für die Lektion \'{$a->lesson}\' ist nun {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Sie haben {$a->earned} von {$a->outof} für diese Freitextfrage erhalten.</p><p>Ihre Bewertung für die Lektion {$a->lesson} wurde zu {$a->newgrade}% geändert.</p>';
$string['essayemailsubject'] = 'Bewertung für eine Lektionantwort verfügbar';
$string['essaynotgradedyet'] = 'Dieser Text wurde noch nicht bewertet.';
$string['essayresponses'] = 'Freitextantworten';
$string['essays'] = 'Freitexte';
$string['essayscore'] = 'Freitext-Bewertung';
$string['eventcontentpageviewed'] = 'Textseite angezeigt';
$string['eventessayassessed'] = 'Essay-Frage bewertet';
$string['eventessayattemptviewed'] = 'Essayversuch angesehen';
$string['eventhighscoreadded'] = 'Höchstwert hinzugefügt';
$string['eventhighscoresviewed'] = 'Höchstwerte angezeigt';
$string['eventlessonended'] = 'Lektion beendet';
$string['eventlessonrestarted'] = 'Lektion erneut gestartet';
$string['eventlessonresumed'] = 'Lektion wieder aufgenommen';
$string['eventlessonstarted'] = 'Lektion begonnen';
$string['eventoverridecreated'] = 'Lektionsüberschreibung angelegt';
$string['eventoverridedeleted'] = 'Lektionsüberschreibung gelöscht';
$string['eventoverrideupdated'] = 'Lektionsüberschreibung aktualisiert';
$string['eventpagecreated'] = 'Textseite angelegt';
$string['eventpagedeleted'] = 'Textseite gelöscht';
$string['eventpagemoved'] = 'Seite verschoben';
$string['eventpageupdated'] = 'Textseite bearbeitet';
$string['eventquestionanswered'] = 'Frage beantwortet';
$string['eventquestionviewed'] = 'Frage angezeigt';
$string['false'] = 'Falsch';
$string['fileformat'] = 'Dateiformat';
$string['finalwrong'] = 'Nicht ganz.';
$string['finish'] = 'Fertigstellen';
$string['firstanswershould'] = 'Die erste Antwort sollte zur Seite mit der Antwort "richtig" verzweigen';
$string['firstwrong'] = 'Ihre Antwort ist falsch. Möchten Sie es noch einmal (ohne Bewertung) versuchen?';
$string['flowcontrol'] = 'Ablaufkontrolle';
$string['fractionsaddwrong'] = 'Die positiven Bewertungen, die Sie gewählt haben, ergeben keine 100%.
<br />Statt dessen ergeben sie {$a}%.
<br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['fractionsnomax'] = 'Eine dieser Antworten sollte 100% sein, damit
<br />es möglich ist, die volle Punktzahl für diese Frage zu bekommen.
<br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['full'] = 'Erweitert';
$string['general'] = 'Allgemeines';
$string['gotoendoflesson'] = 'Zum Lektionende gehen';
$string['grade'] = 'Relative Bewertung';
$string['gradebetterthan'] = 'Bewertung besser als (%)';
$string['gradebetterthanerror'] = 'Bewertung muss besser als {$a} Prozent sein';
$string['graded'] = 'Bewertet';
$string['gradeessay'] = 'Freitextfragen bewerten ({$a->notgradedcount} - nicht bewertet, {$a->notsentcount} - nicht gesendet)';
$string['gradeis'] = 'Ihre Bewertung: {$a}';
$string['gradeoptions'] = 'Bewertung';
$string['groupoverrides'] = 'Gruppenänderungen';
$string['groupoverridesdeleted'] = 'Gruppenänderungen gelöscht';
$string['groupsnone'] = 'Keine Gruppen, auf die Sie zugreifen können';
$string['handlingofretakes'] = 'Bewertung bei Wiederholungen';
$string['handlingofretakes_help'] = 'Wenn die Teilnehmer/innen eine Lektion wiederholen dürfen, kann die Bewertung entweder als Durchschnittsnote oder als Bestnote aller Versuche erfolgen.
Diese Option kann jederzeit geändert werden.';
$string['havenotgradedyet'] = 'Noch nicht bewertet';
$string['here'] = 'hier';
$string['highscore'] = 'Beste Bewertung';
$string['hightime'] = 'Längste Zeit';
$string['importcount'] = '{$a} Fragen importieren';
$string['importquestions'] = 'Fragen importieren';
$string['importquestions_help'] = 'Diese Option ermöglicht den Import von Fragen in unterschiedlichen Formaten über eine Textdatei.';
$string['inactiveoverridehelp'] = '* Diese Nutzeränderung ist inaktiv, da der Zugriff der Person auf die Aktivität eingeschränkt ist. Dies kann durch Gruppen- oder Rollenzuordnungen, andere Zugriffsbeschränkungen oder durch das Verbergen der Aktivität bedingt sein.';
$string['indicator:cognitivedepth'] = 'Lektion kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die ein/e Teilnehmer/in in einer Lektionsaktivität erreicht hat.';
$string['indicator:cognitivedepthdef'] = 'Lektion kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Die Person hat diesen Prozentsatz des kognitiven Engagements erreicht, das die Lektionsaktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Ansicht, Ansicht, Beiträge, Feedback anzeigen, Feedback kommentieren, Beiträge nach Feedback überarbeiten).';
$string['indicator:socialbreadth'] = 'Lektion sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die eine Person in einer Lektionsaktivität erreicht hat.';
$string['indicator:socialbreadthdef'] = 'Lektion sozial';
$string['indicator:socialbreadthdef_help'] = 'Die Person hat diesen Prozentsatz des soziale Engagements erreicht, das die Lektionsaktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Teilnahme, Teilnahme allein, Teilnahme mit anderen).';
$string['insertedpage'] = 'Seite eingefügt';
$string['invalidfile'] = 'Ungültige Datei';
$string['invalidid'] = 'Keine Kursmodul-ID oder Lektions-ID angegeben';
$string['invalidlessonid'] = 'Falsche Lektions-ID';
$string['invalidoverrideid'] = 'Falsche Überschreibungs-ID';
$string['invalidpageid'] = 'Ungültige Seiten-ID';
$string['jump'] = 'Sprung';
$string['jumps'] = 'Sprünge';
$string['jumps_help'] = 'Jede Antwort (bei Fragen) oder jede Beschreibung (bei Inhaltsseiten) besitzt einen zugehörigen Sprung. Der Sprung kann relative sein, z.B. zu dieser Seite oder zur nächsten Seite führen. Oder der Sprung kann absolut sein, wobei dann jede Seite in der Lektion angesteuert werden kann';
$string['jumpsto'] = 'Sprung zu <em>{$a}</em>';
$string['leftduringtimed'] = 'Sie haben die Lektion abgebrochen. Die Bearbeitung der Lektion ist zeitlich begrenzt. <br />Klicken Sie auf Fortsetzen, um die Lektion erneut zu beginnen.';
$string['leftduringtimednoretake'] = 'Sie haben die Lektion abgebrochen. Die Bearbeitung der Lektion ist zeitlich begrenzt. <br />Sie können diese Lektion nicht weiter bearbeiten.';
$string['leftduringtimedsession'] = 'Sie haben eine zeitbegrenzte Lektion abgebrochen.';
$string['lesson:addinstance'] = 'Neue Lektion hinzufügen';
$string['lesson:edit'] = 'Lektion bearbeiten';
$string['lesson:grade'] = 'Freitextfragen in Lektionen bewerten';
$string['lesson:manage'] = 'Lektion verwalten';
$string['lesson:manageoverrides'] = 'Lektionsüberschreibungen verwalten';
$string['lesson:view'] = 'Lektionsaktivität anzeigen';
$string['lesson:viewreports'] = 'Lektionsbericht anzeigen';
$string['lessonbeingpreviewed'] = 'Die Lektion befindet sich derzeit in der Vorschau.';
$string['lessonclosed'] = 'Die Lektion war verfügbar bis {$a}';
$string['lessoncloses'] = 'Verfügbarkeit der Lektion endet';
$string['lessoneventcloses'] = '{$a} endet';
$string['lessoneventopens'] = '{$a} beginnt';
$string['lessonformating'] = 'Lektion wird formatiert';
$string['lessonmenu'] = 'Inhaltsverzeichnis';
$string['lessonnotready'] = 'Diese Lektion ist noch nicht verfügbar. Nehmen Sie bitte mit {$a} Kontakt auf.';
$string['lessonnotready2'] = 'Diese Lektion kann noch nicht bearbeitet werden.';
$string['lessonopen'] = 'Diese Lektion ist ab {$a} verfügbar.';
$string['lessonopens'] = 'Lektion verfügbar';
$string['lessonpagelinkingbroken'] = 'Die erste Seite wurde nicht gefunden. Die Verlinkung der Seite weist einen Fehler auf. Sprechen Sie die Administrator/innen an.';
$string['lessonstats'] = 'Statistik';
$string['linkedmedia'] = 'Verlinkte Medien';
$string['loginfail'] = 'Der Login ist gescheitert. Versuchen Sie es bitte noch einmal.';
$string['lowscore'] = 'Schlechteste Bewertung';
$string['lowtime'] = 'Niedrigste Zeit';
$string['manualgrading'] = 'Freitext-Bewertung';
$string['matchesanswer'] = 'Zugeordnete Antwort';
$string['matching'] = 'Zuordnung';
$string['matchingpair'] = 'Passendes Paar {$a}';
$string['maxgrade'] = 'Maximale Bewertung';
$string['maxgrade_help'] = 'Dieser Wert bestimmt die maximale Bewertung für die Lektion. Wenn Sie diesen Wert auf 0 setzen, erscheint die Lektion in der Bewertungsübersicht.';
$string['maximumnumberofanswersbranches'] = 'Höchstzahl der Antworten
';
$string['maximumnumberofanswersbranches_help'] = 'Diese Einstellung gibt die maximale Anzahl von Antworten an, die in der Lektion verwendet werden dürfen. Wenn ausschließlich Wahr/falsch-Fragen vorkommen, kann der Wert auf 2 gesetzt werden. Die Einstellung kann jederzeit geändert werden, da sie nur das betrifft, was die Trainer/innen sehen, aber nicht die Daten.';
$string['maximumnumberofattempts'] = 'Höchstzahl der Versuche pro Frage';
$string['maximumnumberofattempts_help'] = 'Dieser Wert legt die Zahl der maximal zulässigen Versuche für jede einzelne Frage fest. Wenn die Höchstzahl der zulässigen Versuche erreicht ist, wird automatisch die nächste Seite der Lektion angezeigt.';
$string['maximumnumberofattemptsreached'] = 'Sie haben die Höchstzahl der Versuche erreicht - weiter zur nächsten Seite';
$string['mediaclose'] = 'Taste \'Schließen\' anzeigen';
$string['mediafile'] = 'Verlinke Mediendatei';
$string['mediafile_help'] = 'Eine Mediendatei kann für die Nutzung in der Lektion hochgeladen werden. Ein Link \'Zum Anzeigen hier klicken\' wird anschließend auf jeder Seite der Lektion angezeigt.';
$string['mediafilepopup'] = 'Link zur Mediendatei';
$string['mediaheight'] = 'Höhe des Popup-Fensters';
$string['mediawidth'] = 'Breite des Popup-Fensters';
$string['messageprovider:graded_essay'] = 'Systemnachricht zur Freitextbewertung';
$string['minimumnumberofquestions'] = 'Mindestzahl der Fragen';
$string['minimumnumberofquestions_help'] = 'Dieser Wert legt eine untere Grenze für die Anzahl an Fragen fest, die in die Bewertung der Aktivität eingehen.';
$string['missingname'] = 'Bitte geben Sie einen Nicknamen ein';
$string['modattempts'] = 'Wiederholung erlauben';
$string['modattempts_help'] = 'Wenn diese Option aktiviert ist, können Teilnehmer/innen erneut durch die Lektion navigieren.';
$string['modattemptsnoteacher'] = 'Navigation nur für Teilnehmer/innen möglich';
$string['modulename'] = 'Lektion';
$string['modulename_help'] = 'Lektionen bestehen aus einer Reihe von Seiten und Verlinkungen zwischen den Seiten. Führen Sie die Teilnehmer/innen stringent von Seite zu Seite oder bieten Sie ihnen Auswahlmöglichkeiten. Je nach der Antwort der Teilnehmer/innen und der Art und Weise, wie die/der Trainer/in die Lektion entwickelt, können die Teilnehmer/innen auf die nächste Seite weitergehen, auf eine vorherige Seite zurückgeführt oder auf einen ganz anderen Weg umgeleitet werden.

Eine Lektion kann bewertet werden, wobei die Endnote in den Bewertungen festgehalten wird.

Alle Inhalte der Lektion können im Unterschied zu Lernpaketen oder IMS-Content direkt in Moodle erstellt werden.

Eine Lektions-Aktivität kann verwendet werden

* Zum selbstgesteuerten Lernen eines neuen Themas
* Für Szenarien oder Simulationen/Entscheidungsübungen
* Für differenzierte Repetitionen, mit verschiedenen Sätzen von Repetitionfragen, je nach den Antworten auf die ersten Fragen';
$string['modulenameplural'] = 'Lektionen';
$string['move'] = 'Seite verschieben';
$string['movedpage'] = 'Seite verschoben';
$string['movepagehere'] = 'Seite hierher verschieben';
$string['movepagenamed'] = 'Seite verschieben: {$a}';
$string['moving'] = 'Seite {$a} verschieben';
$string['multianswer'] = 'Mehrere Antworten';
$string['multianswer_help'] = 'Aktivieren Sie diese Option, wenn mehr als eine Antwort richtig sein kann.';
$string['multichoice'] = 'Multiple-Choice';
$string['multipleanswer'] = 'Mehrfachantwort';
$string['nameapproved'] = 'Name akzeptiert';
$string['namereject'] = 'Der eingegebene Name wurde zurückgewiesen.<br />Bitte versuchen Sie es mit einem anderem Namen noch einmal.';
$string['new'] = 'Neu';
$string['nextpage'] = 'Nächste Seite';
$string['noanswer'] = 'Eine oder mehrere Fragen wurden nicht beantwortet. Gehen Sie zurück und geben Sie Antworten ein.';
$string['noattemptrecordsfound'] = 'Keine aufgezeichneten Daten gefunden: Keine Bewertung vorgenommen';
$string['nobranchtablefound'] = 'Keine Inhaltsseite gefunden';
$string['noclose'] = 'Keine Endzeit';
$string['nocommentyet'] = 'Bisher kein Feedback';
$string['nocoursemods'] = 'Keine Aktivitäten gefunden';
$string['nocredit'] = 'Keine Bewertung';
$string['nodeadline'] = 'Keine zeitliche Beschränkung';
$string['noessayquestionsfound'] = 'Keine Freitext-Fragen in der Lektion vorhanden';
$string['nohighscores'] = 'Keine Bestenliste';
$string['nolessonattempts'] = 'Bisher keine Versuche';
$string['nolessonattemptsgroup'] = 'Keines der {$a} Gruppenmitglieder hat zu dieser Lektion einen Versuch gemacht.';
$string['none'] = 'Keine';
$string['nooneansweredcorrectly'] = 'Niemand hat richtig geantwortet.';
$string['nooneansweredthisquestion'] = 'Niemand hat diese Frage beantwortet.';
$string['noonecheckedthis'] = 'Niemand hat dies ausgewählt.';
$string['nooneenteredthis'] = 'Niemand hat dies eingegeben.';
$string['noonehasanswered'] = 'Bisher wurden keine Freitextfragen beantwortet.';
$string['noonehasansweredgroup'] = 'Bisher wurden in {$a} keine Freitextfragen beantwortet.';
$string['noopen'] = 'Keine Anfangszeit';
$string['nooverridecreated'] = 'Keine Lektionsüberschreibung angelegt.';
$string['nooverridedata'] = 'Sie müssen mindestens eine Lektionseinstellung außer Kraft setzen.';
$string['noretake'] = 'Sie können diese Lektion nicht wiederholen.';
$string['normal'] = 'Dem Pfad der Lektion folgen';
$string['notcompleted'] = 'Nicht beendet';
$string['notcompletedwithdate'] = 'Nicht abgeschlossen ({$a})';
$string['notdefined'] = 'Nicht definiert';
$string['notenoughsubquestions'] = 'Es wurden noch nicht genügend Unterfragen definiert! <br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['notenoughtimespent'] = 'Sie haben diese Lektion erledigt in {$a->timespent}, also weniger als die gefordert Zeit {$a->timerequired}. Möglicherweise müssen Sie die Lektion erneut versuchen.';
$string['notgraded'] = 'Nicht bewertet';
$string['notitle'] = 'Kein Titel';
$string['notyetcompleted'] = 'Die Lektion wurde begonnen, aber noch nicht abgeschlossen.';
$string['numberofcorrectanswers'] = 'Richtige Antworten: {$a}';
$string['numberofcorrectanswersheader'] = 'Anzahl richtiger Antworten';
$string['numberofcorrectmatches'] = 'Anzahl der richtigen Zuordnungen: {$a}';
$string['numberofpagestoshow'] = 'Zahl der zu zeigenden Seiten';
$string['numberofpagestoshow_help'] = 'Diese Einstellung legt die Zahl der Seiten fest, die in der Lektion gezeigt werden sollen. Eine Begrenzung ist sinnvoll für Lektionen, bei denen die Seiten in einer zufälligen Reihenfolge gezeigt werden, wenn also die Option "Aktion nach einer richtigen Antwort" auf "Ungesehene Seite anzeigen" oder "Unbeantwortete Seite anzeigen" gesetzt wurde.

Wenn die "Zahl der zu zeigenden Seiten" auf 0 gesetzt wird, dann werden alle Seiten in der Lektion angezeigt.';
$string['numberofpagesviewed'] = 'Beantwortete Fragen: {$a}';
$string['numberofpagesviewedheader'] = 'Anzahl beantworteter Fragen';
$string['numberofpagesviewednotice'] = 'Zahl der beantworteten Fragen: {$a->nquestions} (mindestens zu beantworten: {$a->minquestions})';
$string['numerical'] = 'Numerisch';
$string['numericanswer'] = 'Numerische Antwort';
$string['numericanswer_help'] = 'Sie können eine Zahl oder einen Zahlenbereich zwischen zwei Zahlen mit Doppelpunkt angeben. Beispielsweise bedeutet 2:5, dass jede Antwort zwischen 2 und 5 einschließlich dieser richtig ist.';
$string['offlinedatamessage'] = 'Sie haben an diesem Versuch mit einem mobilen Gerät gearbeitet. Die Daten wurden gespeichert, und zwar auf der Website zuletzt vor {$a}. Prüfen Sie, dass Sie keine ungespeicherten Arbeiten mehr auf dem mobilen Gerät haben.';
$string['ongoing'] = 'Aktuelle Bewertung anzeigen';
$string['ongoing_help'] = 'Wenn diese Option aktiviert ist, wird den Teilnehmer/innen auf jeder Seite ihre aktuelle Bewertung zusammen mit der maximal erreichbaren Bewertung angezeigt.';
$string['ongoingcustom'] = 'Gesamtpunktzahl: {$a->score} / {$a->currenthigh}';
$string['ongoingnormal'] = 'Richtige Antworten: {$a->correct} / {$a->viewed}';
$string['onpostperpage'] = 'Nur eine Mitteilung pro Bewertung';
$string['openafterclose'] = 'Sie haben ein offenes Datum nach dem Abschlussdatum angegeben.';
$string['options'] = 'Optionen';
$string['or'] = 'ODER';
$string['ordered'] = 'Geordnet';
$string['other'] = 'Weitere Einstellungen';
$string['outof'] = 'von {$a}';
$string['override'] = 'Überschreiben';
$string['overridedeletegroupsure'] = 'Möchten Sie wirklich die Überschreibung für die Gruppe \'{$a}\' löschen?';
$string['overridedeleteusersure'] = 'Möchten Sie wirklich die Überschreibung für das Nutzerkonto \'{$a}\' löschen?';
$string['overridegroup'] = 'Gruppe überschreiben';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Überschreibungen';
$string['overrideuser'] = 'Nutzer/in überschreiben';
$string['overrideusereventname'] = '{$a->lesson} - Überschreibung';
$string['overview'] = 'Übersicht';
$string['overview_help'] = 'Eine Lektion besteht mehreren Seiten und optionalen Inhaltsseiten.

Eine Seite stellt den Lerninhalt bereit und endet normalerweise mit einer Frage. Zugeordnet zu jeder Antwortmöglichkeit ist ein Sprung. Der Sprung kann relativ sein, also diese oder die nächste Seite adressieren. Ein Sprung kann aber auch absolut sein und dann jede beliebige Seite in der Lektion erreichen.

Eine Inhaltsseite enthält eine ganze Reihe von Links zu anderen Seiten der Lektion, wie beispielsweise ein Inhaltsverzeichnis.';
$string['page'] = 'Seite: {$a}';
$string['page-mod-lesson-edit'] = 'Lektionsbearbeitungsseite';
$string['page-mod-lesson-view'] = 'Lektionsansichtsseite';
$string['page-mod-lesson-x'] = 'Jede Lektionsseite';
$string['pageanswers'] = 'Seitenantworten';
$string['pagecontents'] = 'Seiteninhalt';
$string['pageresponses'] = 'Seitenantworten';
$string['pages'] = 'Seiten';
$string['pagetitle'] = 'Seitentitel';
$string['password'] = 'Kennwort';
$string['passwordprotectedlesson'] = 'Lektion {$a} erfordert ein Kennwort.';
$string['pleasecheckoneanswer'] = 'Wählen Sie eine Antwort';
$string['pleasecheckoneormoreanswers'] = 'Wählen Sie eine oder mehrere Antworten.';
$string['pleaseenteryouranswerinthebox'] = 'Bitte schreiben Sie Ihre Antwort ins Eingabefeld';
$string['pleasematchtheabovepairs'] = 'Ordnen Sie die obigen Paare einander zu';
$string['pluginadministration'] = 'Lektions-Administration';
$string['pluginname'] = 'Lektion';
$string['pointsearned'] = 'Erreichte Punkte';
$string['postprocesserror'] = 'Fehler während der Verarbeitung aufgetreten! (post-processing)';
$string['postsuccess'] = 'Erfolgreich gesendet';
$string['practice'] = 'Übungslektion';
$string['practice_help'] = 'Übungslektionen gehen nicht in die Gesamtbewertungen des Kurses ein.';
$string['preprocesserror'] = 'Fehler während der Verarbeitung aufgetreten! (pre-processing)';
$string['prerequisiteisobsolete'] = 'Die Option vorherige Lektion wird künftig wegfallen. Verwenden Sie stattdessen die Option \'Voraussetzungen\'.';
$string['prerequisitelesson'] = 'Abhängige Lektion';
$string['preview'] = 'Vorschau';
$string['previewlesson'] = 'Vorschau {$a}';
$string['previewpagenamed'] = 'Seite anzeigen: {$a}';
$string['previouspage'] = 'Vorherige Seite';
$string['privacy:metadata:attempts'] = 'Aufzeichnung der Versuche';
$string['privacy:metadata:attempts:answerid'] = 'Die Anwort ID';
$string['privacy:metadata:attempts:correct'] = 'Ob der Versuch richtig war oder nicht.';
$string['privacy:metadata:attempts:pageid'] = 'Die Seiten ID';
$string['privacy:metadata:attempts:retry'] = 'Nummer des Versuchs';
$string['privacy:metadata:attempts:timeseen'] = 'Zeit, zu der der Versuch ausgeführt wurde';
$string['privacy:metadata:attempts:useranswer'] = 'Details der Antwort des Nutzers';
$string['privacy:metadata:attempts:userid'] = 'Die Nutzer ID';
$string['privacy:metadata:branch'] = 'Aufzeichnung der angesehenen Seiten';
$string['privacy:metadata:branch:flag'] = 'Ob die folgende Seite zufällig  ausgewählt wurde';
$string['privacy:metadata:branch:nextpageid'] = 'Die nächste Seiten ID';
$string['privacy:metadata:branch:pageid'] = 'Die Seiten ID';
$string['privacy:metadata:branch:retry'] = 'Nummer des Versuchs';
$string['privacy:metadata:branch:timeseen'] = 'Zeit, zu der die Seite angezeigt wurde';
$string['privacy:metadata:branch:userid'] = 'Die Nutzer ID';
$string['privacy:metadata:grades'] = 'Bewertung für jede Lektion';
$string['privacy:metadata:grades:completed'] = 'Zeit, zu der die Bewertung erfolgte';
$string['privacy:metadata:grades:grade'] = 'Vergebene Bewertung';
$string['privacy:metadata:grades:userid'] = 'Die Nutzer ID';
$string['privacy:metadata:overrides'] = 'Aufzeichnung der Überschreibungen je Lektion';
$string['privacy:metadata:overrides:available'] = 'Zeit, zu der die Lektion versucht werden konnte';
$string['privacy:metadata:overrides:deadline'] = 'Zeit, bis zu der Teilnehmer/innen die Lektion beenden müssen';
$string['privacy:metadata:overrides:maxattempts'] = 'Maximale Anzahl an Versuchen';
$string['privacy:metadata:overrides:password'] = 'Kennwort für Zugriff auf die Lektion';
$string['privacy:metadata:overrides:retake'] = 'Ob Wiederholungen möglich sind';
$string['privacy:metadata:overrides:review'] = 'Ob eine neue Beantwortung der Frage zulässig ist';
$string['privacy:metadata:overrides:timelimit'] = 'Zeit, um eine Lektion zu bearbeiten (in Sekunden)';
$string['privacy:metadata:overrides:userid'] = 'Die Nutzer ID';
$string['privacy:metadata:timer'] = 'Aufzeichnung des Lektionsversuchs';
$string['privacy:metadata:timer:completed'] = 'Ob der Versuch vollständig ist';
$string['privacy:metadata:timer:lessontime'] = 'Letzter Moment als die Aktivität bearbeitet wurde';
$string['privacy:metadata:timer:starttime'] = 'Zeit, zu der der Versuch begonnen wurde';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Letzter Moment als die Aktivität in der Mobile App bearbeitet wurde';
$string['privacy:metadata:timer:userid'] = 'Die Nutzer ID';
$string['privacy:metadata:userpref:lessonview'] = 'Voreingestellter Darstellungsmodus beim Bearbeiten der Lektion';
$string['privacy:path:essayanswers'] = 'Freitextantworten';
$string['privacy:path:essayresponses'] = 'Essay-Antworten';
$string['privacy:path:pages'] = 'Seiten';
$string['processerror'] = 'Fehler während der Verarbeitung aufgetreten!';
$string['progressbar'] = 'Fortschrittsbalken';
$string['progressbar_help'] = 'Wenn diese Option aktiviert ist, wird ein Fortschrittsbalken unten auf den Lektionsseiten angezeigt, der einen ungefähren Prozentwert der Bearbeitung darstellt.';
$string['progressbarteacherwarning'] = 'Fortschrittsbalken wird für {$a} nicht anzeigen';
$string['progressbarteacherwarning2'] = 'Die Fortschrittsanzeige wird Ihnen nicht angezeigt, weil Sie diese Lektion als Trainer/in bearbeiten können.';
$string['progresscompleted'] = 'Sie haben {$a}% der Lektion erledigt.';
$string['qtype'] = 'Seitentyp';
$string['question'] = 'Frage';
$string['questionoption'] = 'Zusatzoption';
$string['questiontype'] = 'Fragetyp';
$string['randombranch'] = 'Zufällige Inhaltsseite';
$string['randompageinbranch'] = 'Zufällige Frage innerhalb des Zweiges';
$string['rank'] = 'Rang';
$string['rawgrade'] = 'Absolute Bewertung';
$string['receivedcredit'] = 'Bewertung';
$string['redisplaypage'] = 'Seite erneut anzeigen';
$string['removeallgroupoverrides'] = 'Alle Gruppenänderungen löschen';
$string['removealluseroverrides'] = 'Alle Nutzeränderungen löschen';
$string['report'] = 'Bericht';
$string['reports'] = 'Ergebnisse';
$string['response'] = 'Feedback';
$string['retakesallowed'] = 'Wiederholungen zulässig';
$string['retakesallowed_help'] = 'Wenn diese Option aktiviert ist, können Teilnehmer/innen die Lektion mehrfach bearbeiten.';
$string['returnto'] = 'Zurückkehren zu {$a}';
$string['returntocourse'] = 'Zurück zur Kursseite';
$string['reverttodefaults'] = 'Standardeinstellungen der Lektion wiederherstellen';
$string['review'] = 'Rückschau';
$string['reviewlesson'] = 'Zur Lektion';
$string['reviewquestionback'] = 'Wiederholen';
$string['reviewquestioncontinue'] = 'Fortsetzen';
$string['sanitycheckfailed'] = 'Verständlichkeitsprüfung gescheitert: Der Versuch wurde gelöscht.';
$string['save'] = 'Speichern';
$string['savechanges'] = 'Änderungen speichern';
$string['savechangesandeol'] = 'Alle Änderungen speichern und zum Ende der Lektion gehen.';
$string['saveoverrideandstay'] = 'Speichern und weitere Änderung anlegen';
$string['savepage'] = 'Seite speichern';
$string['score'] = 'Bewertung';
$string['score_help'] = 'Punkte werden nur verwendet, wenn eine benutzerdefinierte Bewertung aktiviert ist. Jeder Antwort kann einen (positiver oder negativer) Zahlenwert gegeben werden.';
$string['scores'] = 'Bewertung';
$string['search:activity'] = 'Lektion - Aktivitätsinfo';
$string['secondpluswrong'] = 'Nicht ganz. Möchten Sie es noch einmal versuchen?';
$string['selectallattempts'] = 'Alle Versuche auswählen';
$string['selectaqtype'] = 'Fragetyp auswählen';
$string['sent'] = 'Gesendet';
$string['shortanswer'] = 'Kurzantwort';
$string['showanunansweredpage'] = 'Noch nicht beantwortete Seite anzeigen';
$string['showanunseenpage'] = 'Noch nicht angezeigte Seite anzeigen';
$string['singleanswer'] = 'Einzelne Antwort';
$string['skip'] = 'Keine Navigation';
$string['slideshow'] = 'Slideshow';
$string['slideshow_help'] = 'Wenn diese Option aktiviert ist, wird die Lektion als Diashow mit einer festgelegten Breite und Höhe gezeigt.';
$string['slideshowbgcolor'] = 'Hintergrundfarbe für Slideshow';
$string['slideshowheight'] = 'Höhe für Slideshow';
$string['slideshowwidth'] = 'Breite für Slideshow';
$string['startlesson'] = 'Lektion bearbeiten';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname}: Versuch Nr. {$a->attempt}';
$string['studentname'] = 'Name';
$string['studentoneminwarning'] = 'Warnung: Sie haben noch eine Minute oder weniger Zeit, um die Lektion abzuschließen.';
$string['studentoutoftimeforreview'] = 'Achtung: Ihnen steht keine Zeit mehr zur Überprüfung dieser Einheit zur Verfügung.';
$string['studentresponse'] = '{$a}\'s  Antwort';
$string['submit'] = 'Einreichen';
$string['submitname'] = 'Absenden';
$string['teacherjumpwarning'] = 'In der Lektion kommt ein \'{$a->cluster}\'-Sprung oder ein \'{$a->unseen}\'-Sprung vor. Stattdessen werden \'Nächste Seite\'-Sprünge verwendet. Melden Sie sich als Teilnehmer/in an, um die Sprünge zu testen.';
$string['teacherongoingwarning'] = 'Die laufende Punktzahl wird nur für Teilnehmer/innen angezeigt. Melden Sie sich als Teilnehmer/in an, um diese Funktion zu testen.';
$string['teachertimerwarning'] = 'Die Zeitbegrenzung funktioniert nur für Teilnehmer/innen. Melden Sie sich als Teilnehmer/in an, um diese Funktion zu testen.';
$string['thatsthecorrectanswer'] = 'Richtig';
$string['thatsthewronganswer'] = 'Falsch';
$string['thefollowingpagesjumptothispage'] = 'Die folgenden Seiten springen auf diese Seite';
$string['thispage'] = 'Diese Seite';
$string['timeisup'] = 'Die Zeit ist abgelaufen';
$string['timelimit'] = 'Zeitbegrenzung';
$string['timelimit_help'] = 'Wenn diese Option aktiviert ist, wird zu Beginn der Lektion ein Hinweis zur Zeitbegrenzung angezeigt. Während der Bearbeitung wird die Restzeit heruntergezählt. Antworten nach Ablauf der Zeitbegrenzung werden nicht gewertet.';
$string['timelimitwarning'] = 'Noch {$a} bis zum Ende der Lektion';
$string['timeremaining'] = 'Verbleibende Zeit';
$string['timespenterror'] = 'Bearbeiten Sie diese Lektion mindestens {$a} Minuten lang.';
$string['timespentminutes'] = 'Aufgewendete Zeit (Minuten)';
$string['timetaken'] = 'Aufgewendete Zeit';
$string['totalpagesviewedheader'] = 'Anzahl von angezeigten Seiten';
$string['true'] = 'Wahr';
$string['truefalse'] = 'Wahr/falsch';
$string['unabledtosavefile'] = 'Die hochgeladene Datei konnte nicht gespeichert werden';
$string['unknownqtypesnotimported'] = '$ Fragen mit nicht unterstützten Fragetypen wurden nicht importiert';
$string['unseenpageinbranch'] = 'Noch nicht angezeigte Frage innerhalb einer Seite';
$string['unsupportedqtype'] = 'Der Fragetyp ({$a}) wird nicht unterstützt!';
$string['updatedpage'] = 'Seite aktualisiert';
$string['updatefailed'] = 'Aktualisierung fehlgeschlagen';
$string['updatepagenamed'] = 'Seite aktualisieren: {$a}';
$string['usemaximum'] = 'Bester Versuch';
$string['usemean'] = 'Durchschnitt';
$string['usepassword'] = 'Erfordert Kennwort';
$string['usepassword_help'] = 'Wenn Sie diese Option aktivieren, ist die Lektion durch ein Kennwort geschützt. Teilnehmer/innen haben nur Zugang, wenn sie das richtige Kennwort eingeben.';
$string['useroverrides'] = 'Nutzeränderungen';
$string['useroverridesdeleted'] = 'Nutzeränderungen gelöscht';
$string['usersnone'] = 'Zu dieser Lektion haben Nutzer/innen keinen Zugriff';
$string['viewessayanswers'] = 'Freitextantworten anzeigen';
$string['viewgrades'] = 'Bewertungen anzeigen';
$string['viewreports'] = '{$a->attempts} abgeschlossene von {$a->student} Versuchen anzeigen';
$string['viewreports2'] = 'Zeige {$a} komplette Versuche';
$string['warning'] = 'Warnung';
$string['welldone'] = 'Glückwunsch!';
$string['whatdofirst'] = 'Was wollen Sie zuerst tun?';
$string['withselectedattempts'] = 'Mit den ausgewählten Versuchen ...';
$string['wronganswerjump'] = 'Sprung bei falscher Antwort';
$string['wronganswerscore'] = 'Bewertung bei falscher Antwort';
$string['wrongresponse'] = 'Feedback bei falscher Antwort';
$string['youhaveseen'] = 'Sie haben einige Seiten der Lektion schon einmal bearbeitet. <br />Möchten Sie an der Stelle weitermachen, an der Sie damals aufgehört haben?';
$string['youranswer'] = 'Ihre Antwort';
$string['yourcurrentgradeis'] = 'Derzeitige Bewertung: {$a}';
$string['yourcurrentgradeisoutof'] = 'Ihre derzeitige Bewertung ist {$a->grade} von {$a->total}';
$string['youshouldview'] = 'mindestens zu beantworten: {$a}';
