<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'filter_filtercodes', language 'eu', version '4.0'.
 *
 * @package     filter_filtercodes
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['brief'] = 'Laburra';
$string['categorycardshowpic'] = 'Erakutsi {categorycards} atzeko planoa';
$string['categorycardshowpic_desc'] = 'Gaituz gero, {categorycards} etiketaren atzeko planoa ikastaroko irudiaren antzekoa izango da irudirik zehazten ez denean.';
$string['chartprogressbarlabel'] = '{$a->label}: {$a->value}';
$string['contentmissing'] = '<h1>Edukia falta da.</h1><p>Jakinarazi iezaiozu guneko kudeatzaileari, mesedez.</p>';
$string['coursecardsbyenrol'] = 'Gehieneko {coursecardsbyenrol} txartelak.';
$string['coursecardsbyenrol_desc'] = '{coursecardsbyenrol} etiketarentzat gehienez erakutsi beharreko ikastaro-txartel kopurua. Zero jarri ezazu mugarik ez jartzeko (ez da gomendagarria).';
$string['coursecontactlinktype'] = 'Kontaktuen esteka mota';
$string['coursecontactlinktype_desc'] = 'Aukeratu ezazu kontaktuen esteka mota {coursecontacts} etiketetan.';
$string['coursecontactshowdesc'] = 'Erakutsi kontaktuen profileko deskribapena.';
$string['coursecontactshowdesc_desc'] = 'Gaituz gero, {coursecontacts} etiketetan kontaktuen profileko deskribapena erakutsiko da.';
$string['coursecontactshowpic'] = 'Erakutsi kontaktuen irudia';
$string['coursecontactshowpic_desc'] = 'Gaituz gero, {coursecontacts} etiketetan kontaktuen profileko irudia erakutsiko da.';
$string['defaultemail'] = '';
$string['defaultfirstname'] = '';
$string['defaultsurname'] = '';
$string['defaultusername'] = '';
$string['disabled_customnav_description'] = '<strong>Menu pertsonalizatuari dagokionez kontuan izan ezazu:</strong> - Zure Moodle guneko menu pertsonalitzatuan Kode Iragazkia gaitzeko, baliteke zure azala edo Moodle sistema pertsonalizatu behar izatea. <a href="https://github.com/michael-milette/moodle-filter_filtercodes#can-i-use-filtercodes-in-moodles-custom-menus">Kode Iragazkia menu pertsonalizatuan nola gehitzearen inguruko informazioa</a>.';
$string['enable_customnav'] = 'Nabigazio pertsonalizaturako sostengua';
$string['enable_customnav_description'] = '<strong>Esperimentala</strong>: Gaitu FilterCode etiketen sostengua Moodleko nabigazio-menu pertsonalizatua.
Oharra: Dakigunez aukera hau soilik da bateragarria Moodle 3.2 eta 3.4 bertsioen arteko Garbia eta Boost-en oinarritutako azalekin. Ez du Moodleko Azalaren Ezarpenen orrian etiketak iragazten.';
$string['enable_scrape'] = 'Gaitu Scrape etiketa';
$string['enable_scrape_description'] = 'Scrape etiketa erabiltzea ahalbidetzen du beste webguneetako edukia txertatu ahal izateko, hurrengo formatua jarraituta: {scrape url="..." tag="..." class="..." id="..." code="..."}';
$string['enable_sesskey'] = 'Sesskey etiketaren sostengua';
$string['enable_sesskey_description'] = 'Gaitu globalki Sesskey etiketa. Funtzio hau foroetan desgaituta dago baita globalki gaituta dagoenean ere.';
$string['escapebraces'] = 'Saltatu etiketak';
$string['escapebraces_desc'] = 'Aukera hau markatuta dagoenean, Kode Iragazkiaren etiketak iragazki honek interpretatu gabe erakutsi ahalko dituzu zure etiketak [ kortxete artean ] inguratuz. Hau erabilgarria izan daiteke zure Moodle gunean irakasle eta ikastaro-sortzaileentzako Kode Iragazkiaren dokumentazioa sortzerakoan.<br><br>Adibidea: [{fullname}] jarrita ez da erakutsiko erabiltzailearen izen osoa, horren ordez {fullname} etiketa kortxete gabe erakutsiko da.';
$string['filtername'] = 'Kode-iragazkiak';
$string['formcheckin'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf check-in">
    <fieldset>
        <input type="hidden" id="subject" name="subject" value="Present!">
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="I\'m here!">
    </div>
</form>';
$string['formcontactus'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf contact-us">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Your name <strong class="required">(required)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Minimum 3 letters/spaces." required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">Email address <strong class="required">(required)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60"
                    required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{email}">
        </div>
        <div class="form-group">
            <label for="subject" id="subjectlabel" class="d-block">Subject <strong class="required">(required)</strong></label>
            <input id="subject" name="subject" type="text" size="57" maxlength="80" minlength="5"
                    title="Minimum 5 characters." required="required">
        </div>
        <div class="form-group">
            <label for="message" id="messagelabel" class="d-block">Message <strong class="required">(required)</strong></label>
            <textarea id="message" name="message" rows="5" cols="58" minlength="5"
                    title="Minimum 5 characters." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Send">
    </div>
</form>';
$string['formcourserequest'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf new-course-request">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Your name <strong class="required">(required)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Minimum 3 letters/spaces." required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">Email address <strong class="required">(required)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60" required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{email}">
        </div>
        <div class="form-group">
            <label for="new_course_name" id="new_course_namelabel" class="d-block">Proposed name of the new course <strong class="required">(required)</strong></label>
            <input id="new_course_name" name="new_course_name" type="text" size="57" maxlength="80" minlength="5"
                    title="Minimum 5 characters." required="required">
        </div>
        <div class="form-group">
            <label for="description" id="descriptionlabel" class="d-block">Course description <strong class="required">(required)</strong></label>
            <textarea id="description" name="description" rows="5" cols="58" minlength="5"
                    title="Minimum 5 characters." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Submit request for this course">
    </div>
</form>';
$string['formquickquestion'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf contact-us">
    <fieldset>
        <div class="form-group">
            <label for="subject" id="subjectlabel" class="d-block">Subject <strong class="required">(required)</strong></label>
            <input class="block" id="subject" name="subject" type="text" size="57" maxlength="80" minlength="5"
                    title="Minimum 5 characters." required="required">
        </div>
        <div class="form-group">
            <label for="message" id="messagelabel" class="d-block">Message <strong class="required">(required)</strong></label>
            <textarea id="message" name="message" rows="5" cols="58" minlength="5"
                    title="Minimum 5 characters." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Send">
    </div>
</form>';
$string['formsupport'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf support-request">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Your name <strong class="required">(required)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Minimum 3 letters/spaces." required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">Email address <strong class="required">(required)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60" required="required" {readonly}{ifloggedin} disabled{/ifloggedin} value="{email}">
        </div>
        <div class="form-group">
            <label for="subject" id="subjectlabel" class="d-block">Subject <strong class="required">(required)</strong></label>
            <select id="subject" name="subject" required="required">
                <option label="Choose a subject"></option>
                <option>I can\'t change my password</option>
                <option>I can\'t login</option>
                <option value="Suggestion">I have a suggestion</option>
                <option value="Error message">I am getting an error message</option>
                <option value="System error">Something is not working the way it is supposed to</option>
                <option value="Course">I am having difficulty accessing a course or some course content</option>
                <option value="Other reason">Other (please specify)</option>
            </select>
        </div>
        <div class="form-group">
            <label for="specific_subject" id="specifylabel" class="d-block">Specific subject or the name of the course&nbsp;<strong class="required">(required)</strong></label>
            <input type="text" id="specific_subject" name="specific_subject" size="57" maxlength="80" required="required">
        </div>
        <div class="form-group">
            <label for="url" id="urllabel" class="d-block">Specify the URL address</label>
            <input type="url" id="url" name="url" size="57" maxlength="80" value="{referer}">
        </div>
        <div class="form-group">
            <label for="description" id="descriptionlabel" class="d-block">Description and step-by-step details on how to reproduce the issue&nbsp;<strong class="required">(required)</strong></label>
            <textarea id="description" name="description" rows="5" cols="58" minlength="5"
                    title="Minimum 5 characters." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Submit request for help">
    </div>
</form>';
$string['globaltagcontentdesc'] = 'Hau zure etiketa globalak ordezkatuko duen edukia da. Adibidez: Zure etiketak "{global_helbidea}" izena badu, etiketa hori izen hori duen eremuaren edukiarekin ordezkatuko da.';
$string['globaltagcontenttitle'] = 'Edukia';
$string['globaltagcount'] = 'Etiketa global kopurua.';
$string['globaltagcountdesc'] = 'Aukeratu ezazu definitu nahi duzun etiketa kopurua. Errendimendua egokia izan dadin, aukeratu ezazu soilik beharko duzun kopurua.';
$string['globaltagheadingdesc'] = 'Zehaztu itzazu zure etiketa globalak, batzuetan bloke globalak ere deitu izan direnak.';
$string['globaltagheadingtitle'] = 'Etiketa global pertsonalizatuak';
$string['globaltagnamedesc'] = 'Hau zure etiketaren izenaren parte izango da, "global_" aurrizkiarekin. Adibidez: hemen zuk "helbidea" idazten baduzu, zure etiketak {global_helbidea} izena izango du. Soilik letraz osatutako kate bakarra izan behar da. Ezin da erabili hutsunerik, zenbakirik edo karaktere berezirik.';
$string['globaltagnametitle'] = 'Etiketa: global_';
$string['hidecompletedcourses'] = 'Ezkutatu osatutako ikastaroak';
$string['hidecompletedcourses_desc'] = 'Gaituz gero {mycoursesmenu} etiketa zerrendan osatutako ikastaroak iragaziko dira.';
$string['ifprofilefiedonlyvisible'] = '{ifprofile_field_} soilik ikusgai.';
$string['ifprofilefiedonlyvisible_desc'] = 'Markatuta badago, {ifprofile_field_...} etiketan soilik ikusgai dauden profil-eremuak ikusi ahalko dira. Ezkutatutako eremuak hutsik baleude bezala portatuko dira. Desmarkatuz gero, etiketa honek ezkutuko erabiltzaile-profilak ere egiaztatu ahalko ditu.';
$string['narrowpage'] = 'Orri estua';
$string['narrowpage_desc'] = 'Aukera hau gaitu ezazu Moodlek orriaren zabalera mugatua erabiltzen duen itxura duenean itxura optimizatzeko (esaterako Moodle 4.0 bertsioko Boost itxurarekin).';
$string['pagebuilder'] = 'Orri-eraikitzailea';
$string['pagebuilderlink'] = 'https://www.layoutit.com/build';
$string['photoeditor'] = 'Argazki-editorea';
$string['photoeditorlink'] = 'https://pixlr.com/editor/';
$string['pluginname'] = 'Kode-iragazkiak';
$string['privacy:metadata'] = 'Kode-iragazkiak pluginak ez du inolako datu pertsonalik biltzen.';
$string['screenrec'] = 'Pantaila grabagailua';
$string['screenreclink'] = 'https://screenapp.io/#/recording';
$string['showhiddenprofilefields'] = 'Erakutsi ezkutatutako profil-eremuak';
$string['showhiddenprofilefields_desc'] = 'Gaitu {profile_field_...} etiketa erabiltzailearen profil-eremu guztiak prozesatzeko, baita ezkutuan daudenak ere.';
$string['sizeb'] = 'B';
$string['sizeeb'] = 'EB';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizetb'] = 'TB';
$string['sizeyb'] = 'YB';
$string['sizezb'] = 'ZB';
$string['teamcardsformat'] = 'Talde txartelen formatua';
$string['teamcardsformat_desc'] = 'Aukeratu ezazu taldeetako kideak {teamcards} etiketan nola erakutsiko diren.<br>
<ul>
<li>Bat ere ez: Erabiltzailearen irudia eta izena txartel gisa erakusten dira, erabiltzailearen deskribapenik gabe.</li>
<li>Ikonoa: \'Bat ere ez\' bezala baina erabiltzailearen informazioa zabaltzen den burbuila batean erakusten da.</li>
<li>Laburra: \'Bat ere ez\' bezala baina erabiltzailearen irudiaren azpian deskribapena erakusten da.</li>
<li>Osoa: Zerrenda formatua. Gomendatua zure taldeetako kideak erabiltzaile deskribapen luzeak izan ohi badituzte.</li>
</ul>';
$string['teamcardslinktype'] = 'Taldeen esteka mota';
$string['teamcardslinktype_desc'] = 'Aukeratu ezazu {teamcards} etiketan taldeko kideen estekak nola erakutsiko diren. Oharra: Zuk hemen edozer aukeratuta ere, erabiltzaileak saioa hasita badauka irudia erabiltzaile-profilera automatikoki estekatuko da.';
$string['verbose'] = 'Osoa';
