<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'cs', version '4.0'.
 *
 * @package     reservation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Přidat požadavek';
$string['after10min'] = 'Po 10 minutách od zahájení akce';
$string['after12h'] = 'Po 12 hodinách od zahájení akce';
$string['after1d'] = 'Po 1 dni od zahájení akce';
$string['after1h'] = 'Po 1 hodině od zahájení akce';
$string['after1w'] = 'Po 1 týdnu od zahájení akce';
$string['after2d'] = 'Po 2 dnech od zahájení akce';
$string['after2h'] = 'Po 2 hodinách od zahájení akce';
$string['after2w'] = 'Po 2 týdnech od zahájení akce';
$string['after30min'] = 'Po 30 minutách od zahájení akce';
$string['after3w'] = 'Po 3 týdnech od zahájení akce';
$string['after4h'] = 'Po 4 hodinách od zahájení akce';
$string['after4w'] = 'Po 4 týdnech od zahájení akce';
$string['after5min'] = 'Po 5 minutách od zahájení akce';
$string['after6h'] = 'Po 6 hodinách od zahájení akce';
$string['alreadybooked'] = 'Již máte zarezervováno';
$string['alreadyoverbooked'] = 'Již jste v pořadníku';
$string['atstart'] = 'Na zahájení akce';
$string['autohide'] = 'Seznam rezervací se automaticky skryje';
$string['availablerequests'] = 'Dostupná místa';
$string['badcourse'] = 'Kurz neexistuje';
$string['badparent'] = 'Tato rezervace byla propojena s jinou rezervací, která nyní není obnovena. Spojení bylo odstraněno. V případě potřeby je znovu připojte ručně';
$string['by'] = 'podle';
$string['bydate'] = 'Datum konání';
$string['byname'] = 'Jméno';
$string['bysection'] = 'Téma/týden';
$string['cancelledon'] = 'Zrušeno';
$string['cancellersmail'] = '';
$string['cancellersmailhtml'] = '';
$string['checkclashes'] = 'Zkontrolovat kolize míst a času';
$string['clashesfound'] = 'Nalezeny kolize v místě nebo času';
$string['clashesreport'] = 'Přehled kolizí';
$string['cleanview'] = 'Zobrazit pouze aktuální rezervované';
$string['close'] = 'zavřít';
$string['closed'] = 'Zavřeno';
$string['completionreserved'] = 'Student musí provést rezervaci pro dokončení aktivity';
$string['config'] = 'Nastavení rezervace';
$string['configautohide'] = '';
$string['configcheckclashes'] = 'Povolit kontrolu kolizí míst a času v editaci rezervace';
$string['configlocations'] = 'Spravovat výchozí místa rezervací na těchto stránkách';
$string['configmanualusers'] = '';
$string['configmaxoverbook'] = '';
$string['configmaxrequests'] = '';
$string['confignotifies'] = 'Toto nastavení určuje, která upozornění musí být odeslána';
$string['configoverbookstep'] = '';
$string['configpubliclists'] = '';
$string['configsortby'] = 'Určuje způsob řazení rezervací';
$string['configsublimits'] = '';
$string['configupload'] = 'Vytvořit rezervace nahráním textového souboru';
$string['connectedto'] = 'Rezervace připojena k';
$string['connectto'] = 'Připojená rezervace od';
$string['description'] = 'Popis';
$string['downloadas'] = 'Výchozí formát pro stažení';
$string['duration10h'] = '10 hodin';
$string['duration10min'] = '10 minut';
$string['duration11h'] = '11 hodin';
$string['duration12h'] = '12 hodin';
$string['duration15min'] = '15 minut';
$string['duration20min'] = '20 minut';
$string['duration2h'] = '2 hodiny';
$string['duration30min'] = '30 minut';
$string['duration3h'] = '3 hodiny';
$string['duration45min'] = '45 minut';
$string['duration4h'] = '4 hodiny';
$string['duration5h'] = '5 hodin';
$string['duration5min'] = '5 minut';
$string['duration60min'] = '60 minut';
$string['duration6h'] = '6 hodin';
$string['duration7h'] = '7 hodin';
$string['duration8h'] = '8 hodin';
$string['duration90min'] = '90 minut';
$string['duration9h'] = '9 hodin';
$string['enablenote'] = 'Povolit uživateli poznámku';
$string['equal'] = 'rovná se';
$string['err_notimestart'] = 'Datum zahájení akce není nastaven';
$string['err_sublimitsgreater'] = 'Součet sublimitů je větší než maximální povolený požadavek';
$string['err_timeendlower'] = 'Datum ukončení akce předchází datum zahájení';
$string['err_timeopengreater'] = 'Datum zahájení rezervace je nastaveno po datu ukončení';
$string['eventevent'] = 'Vytvořit událost kurzu dle začátku a konce akce';
$string['eventrequestadded'] = 'Přidána žádost o rezervaci';
$string['eventrequestcancelled'] = 'Žádost o rezervaci zrušena';
$string['eventrequestdeleted'] = 'Žádost o rezervaci odstraněna';
$string['events'] = 'Události kalendáře';
$string['eventsettings'] = 'Nastavení události';
$string['explainconfig'] = 'Správci zde mohou definovat globální nastavení modulu Rezervace';
$string['fields'] = 'Zobrazená pole';
$string['fullview'] = 'Zobrazit také odstraněné rezervace';
$string['grade'] = 'Známka';
$string['gradedmail'] = '{$a->teacher} zveřejnil(a) zpětnou vazbu k vaší
rezervaci \'{$a->reservation}\'

Můžete ji vidět zde:

    {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} zveřejnil(a) zpětnou vazbu k vaší
rezervaci \'<i>{$a->reservation}</i>\'<br /><br />
Můžete ji vidět <a href=\\"{$a->url}\\">here</a>.';
$string['importreservations'] = 'Importovat rezervace';
$string['invalidreservationid'] = 'Neplatné ID rezervace';
$string['justbooked'] = '';
$string['justoverbooked'] = '';
$string['linenumber'] = '#';
$string['listafterclose'] = 'seznam žádostí o rezervaci po ukončení zápisu';
$string['listalways'] = 'seznam žádostí o rezervaci kdykoliv';
$string['location'] = 'Místo';
$string['locations'] = 'Správa míst';
$string['locationslist'] = 'Seznam míst';
$string['mail'] = 'Zápis na rezervaci \'{$a->reservation}\' byl ukončen.

Seznam rezervací si můžete stáhnout z:

    {$a->url}';
$string['mailhtml'] = 'Zápis na rezervaci <em>{$a->reservation}</em>byl ukončen.<br /><br />
Můžete si stáhnout seznam zápisů <a href="{$a->url}">zde</a>.';
$string['manage'] = 'Spravovat';
$string['manualusers'] = '';
$string['maxoverbook'] = '';
$string['maxrequest'] = 'Max. počet rezervací';
$string['message'] = 'Zpráva účastníkům';
$string['minduration'] = 'Minimální doba trvání akce';
$string['modulename'] = 'Rezervace';
$string['modulenameplural'] = 'Rezervace';
$string['newlocation'] = 'Nové místo';
$string['noclashcheck'] = 'Není povolena kontrola kolizí míst a času. Prosím, kontaktujte administrátora stránek.';
$string['noclashes'] = 'Nebyly nalezeny žádné kolize míst a času.';
$string['nolimit'] = 'Žádný limit rezervace';
$string['nomorerequest'] = 'Byla vyčerpána kapacita této rezervace';
$string['nooverbook'] = '';
$string['noparent'] = 'Žádný';
$string['noreservations'] = 'Žádná rezervace k zobrazení';
$string['note'] = 'Poznámka';
$string['noteachers'] = 'Žádní dostupní učitelé';
$string['notequal'] = 'nerovná se';
$string['noterequired'] = '';
$string['notgraded'] = 'Bez známky';
$string['notopened'] = 'Není otevřeno';
$string['notreserved'] = '';
$string['novalues'] = 'Pro toto pole nejsou k dispozici žádné hodnoty';
$string['number'] = 'Číslo rezervace';
$string['optional'] = 'Volitelný';
$string['otherlocation'] = 'Zadat jiné umístění';
$string['overbook'] = '';
$string['overbookonly'] = '';
$string['overbookstep'] = '';
$string['overview'] = 'Přehled';
$string['parent'] = 'Propojit tuto rezervaci s';
$string['pluginadministration'] = 'Správa rezervací';
$string['pluginname'] = 'Rezervace';
$string['privacy:metadata:reservation_request:reservationid'] = 'ID rezervace';
$string['privacy:metadata:reservation_request:userid'] = 'ID uživatele';
$string['requestoverview'] = 'Přehled požadavků';
$string['requests'] = 'Požadavky';
$string['required'] = 'Vyžadováno';
$string['reservation:addinstance'] = 'Přidat novou rezervaci';
$string['reservation:downloadrequests'] = 'Lze stáhnout seznam požadavků';
$string['reservation:grade'] = 'Může přiřadit známku';
$string['reservation:manage'] = 'Může spravovat rezervaci';
$string['reservation:manualdelete'] = 'Může mazat požadavky ostatních uživatelů';
$string['reservation:manualreserve'] = 'Může odeslat požadavek pro ostatní uživatele';
$string['reservation:reserve'] = 'Může podávat vlastní žádosti';
$string['reservation:uploadreservations'] = 'Může nahrávat rezervace';
$string['reservation:view'] = 'Může zobrazit rezervaci';
$string['reservation:viewnote'] = 'Může zobrazit poznámku s požadavky';
$string['reservation:viewrequest'] = 'Může zobrazit seznam požadavků';
$string['reservationcancelled'] = 'Rezervace zrušena';
$string['reservationclosed'] = 'Rezervace uzavřena';
$string['reservationdenied'] = 'Rezervace není povolena';
$string['reservationnotopened'] = 'Rezervace dosud nebyla otevřena';
$string['reservations'] = 'Rezervace';
$string['reservationsettings'] = 'Nastavení rezervace';
$string['reserve'] = 'Rezervovat';
$string['reservecancel'] = 'Zrušit rezervaci';
$string['reserved'] = 'Rezervováno';
$string['reservedon'] = 'Rezervováno dne';
$string['reservedonconnected'] = 'Již jste rezervováni pro připojenou rezervaci: {$a}';
$string['reserversmail'] = 'Jste vyhrazeni pro \'{$a->reservation}\' rezervaci.';
$string['reserversmailhtml'] = 'Jste vyhrazeni pro <em>{$a->reservation}</em> rezervace.';
$string['resetreservation'] = 'Odeberte všechny rezervace';
$string['save'] = 'Uložit známku';
$string['search:activity'] = 'Rezervace - informace o činnosti';
$string['selectvalue'] = 'Vyberte jednu z dostupných hodnot';
$string['showrequest'] = 'Uživatelé mohou zobrazit seznam požadavků';
$string['showuserrequest'] = 'Uživatelé mohou prohlížet';
$string['sortby'] = 'Seznamy rezervací seřazené podle';
$string['status'] = 'Stav rezervace';
$string['sublimit'] = 'Částečný limit {$a}';
$string['sublimitrules'] = 'Pravidla pro dílčí limity';
$string['sublimits'] = '';
$string['timeclose'] = 'Ukončení zápisu';
$string['timeend'] = 'Ukončení akce';
$string['timeopen'] = 'Zahájení zápisu';
$string['timestart'] = 'Zahájení akce';
$string['tools'] = 'Nástroje rezervace';
$string['upload'] = 'Nahrání rezervace';
$string['uploadreservations'] = 'Nahrát rezervace';
$string['uploadreservationspreview'] = '';
$string['useralreadybooked'] = 'Uživatel již provedl zápis na rezervaci';
$string['with'] = 's';
$string['withselected'] = 'S vybranými...';
$string['yourgrade'] = 'Vaše hodnocení této rezervace je: {$a->grade}/{$a->maxgrade}';
$string['yournote'] = 'Vaše poznámka:';
$string['yourscale'] = 'Vaše hodnocení této rezervace je: {$a}';
