<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'de', version '4.0'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresse';
$string['advanced:anchor_delta_height'] = '0';
$string['advanced:anchor_delta_width'] = '0';
$string['advanced:anchor_desc'] = 'Anker einfügen/bearbeiten';
$string['advanced:backcolor_desc'] = 'Hintergrundfarbe';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Zitatblock';
$string['advanced:blockquote_desc'] = 'Zitatblock';
$string['advanced:bold_desc'] = 'Fett';
$string['advanced:bullist_desc'] = 'Aufzählliste einfügen / entfernen';
$string['advanced:charmap_delta_height'] = '0';
$string['advanced:charmap_delta_width'] = '0';
$string['advanced:charmap_desc'] = 'Sonderzeichen einfügen';
$string['advanced:cleanup_desc'] = 'Quellcode bereinigen';
$string['advanced:clipboard_msg'] = 'Kopieren, Ausschneiden und Einfügen sind im Mozilla Firefox nicht möglich. Möchten Sie mehr über dieses Problem erfahren?';
$string['advanced:code'] = 'Code';
$string['advanced:code_desc'] = 'HTML-Code bearbeiten';
$string['advanced:colorpicker_delta_height'] = '0';
$string['advanced:colorpicker_delta_width'] = '0';
$string['advanced:copy_desc'] = 'Kopieren';
$string['advanced:custom1_desc'] = 'Eigene Beschreibung';
$string['advanced:cut_desc'] = 'Ausschneiden';
$string['advanced:dd'] = 'Definitionsbeschreibung';
$string['advanced:div'] = 'div';
$string['advanced:dt'] = 'Definitionsbegriff';
$string['advanced:font_size'] = 'Schriftgröße';
$string['advanced:fontdefault'] = 'Schriftart';
$string['advanced:forecolor_desc'] = 'Textfarbe';
$string['advanced:h1'] = 'Überschrift 1';
$string['advanced:h2'] = 'Überschrift 2';
$string['advanced:h3'] = 'Überschrift 3';
$string['advanced:h4'] = 'Überschrift 4';
$string['advanced:h5'] = 'Überschrift 5';
$string['advanced:h6'] = 'Überschrift 6';
$string['advanced:help_desc'] = 'Hilfe';
$string['advanced:help_shortcut'] = 'Alt+F10 öffnet die Werkzeugleiste, Alt-0 die Hilfe';
$string['advanced:hr_desc'] = 'Horizontale Linie einfügen';
$string['advanced:image_delta_height'] = '0';
$string['advanced:image_delta_width'] = '0';
$string['advanced:image_desc'] = 'Bild einfügen/bearbeiten';
$string['advanced:image_props_desc'] = 'Bildeigenschaften';
$string['advanced:indent_desc'] = 'Einrücken vergrößern';
$string['advanced:italic_desc'] = 'Kursiv';
$string['advanced:justifycenter_desc'] = 'Zentriert';
$string['advanced:justifyfull_desc'] = 'Blocksatz';
$string['advanced:justifyleft_desc'] = 'Linksbündig';
$string['advanced:justifyright_desc'] = 'Rechtsbündig';
$string['advanced:link_delta_height'] = '0';
$string['advanced:link_delta_width'] = '0';
$string['advanced:link_desc'] = 'Link einfügen / bearbeiten';
$string['advanced:more_colors'] = 'Weitere Farben';
$string['advanced:newdocument'] = 'Möchten Sie wirklich den gesamten Inhalt löschen?';
$string['advanced:newdocument_desc'] = 'Neues Dokument';
$string['advanced:numlist_desc'] = 'Geordnete Liste einfügen / entfernen';
$string['advanced:outdent_desc'] = 'Einrücken verringern';
$string['advanced:paragraph'] = 'Absatz';
$string['advanced:paste_desc'] = 'Einfügen';
$string['advanced:path'] = 'Format';
$string['advanced:pre'] = 'Vorformatiert';
$string['advanced:redo_desc'] = 'Wiederholen';
$string['advanced:removeformat_desc'] = 'Formatierungen entfernen';
$string['advanced:rich_text_area'] = 'Textbereich (Rich Text)';
$string['advanced:samp'] = 'Beispiel';
$string['advanced:shortcuts_desc'] = 'Hilfe zur Barrierefreiheit';
$string['advanced:striketrough_desc'] = 'Durchgestrichen';
$string['advanced:style_select'] = 'Format';
$string['advanced:sub_desc'] = 'Tiefgestellt';
$string['advanced:sup_desc'] = 'Hochgestellt';
$string['advanced:toolbar'] = 'Werkzeugleiste';
$string['advanced:toolbar_focus'] = 'Zur Werkzeugleiste springen: Alt+Q; zum Editor springen: Alt-Z; zum Elementpfad springen: Alt-X';
$string['advanced:underline_desc'] = 'Unterstrichen';
$string['advanced:undo_desc'] = 'Rückgängig';
$string['advanced:unlink_desc'] = 'Link entfernen';
$string['advanced:visualaid_desc'] = 'Hilfslinien und unsichtbare Elemente anzeigen / verbergen';
$string['advanced_dlg:'] = ' ';
$string['advanced_dlg:about_author'] = 'Autor/in';
$string['advanced_dlg:about_general'] = 'Über ...';
$string['advanced_dlg:about_help'] = 'Hilfe';
$string['advanced_dlg:about_license'] = 'Lizenz';
$string['advanced_dlg:about_loaded'] = 'Geladene Plugins';
$string['advanced_dlg:about_plugin'] = 'Plugin';
$string['advanced_dlg:about_plugins'] = 'Plugins';
$string['advanced_dlg:about_title'] = 'Über TinyMCE';
$string['advanced_dlg:about_version'] = 'Version';
$string['advanced_dlg:accessibility_help'] = 'Hilfe zur Barrierefreiheit';
$string['advanced_dlg:accessibility_usage_title'] = 'Allgemeine Nutzung';
$string['advanced_dlg:anchor_invalid'] = 'Geben Sie einen gültigen Anker-Namen ein.';
$string['advanced_dlg:anchor_name'] = 'Name des Ankers';
$string['advanced_dlg:anchor_title'] = 'Anker einfügen / bearbeiten';
$string['advanced_dlg:charmap_title'] = 'Sonderzeichen auswählen';
$string['advanced_dlg:charmap_usage'] = 'Verwenden Sie zur Navigation die Pfeiltasten nach rechts und links.';
$string['advanced_dlg:code_title'] = 'HTML-Quellcode bearbeiten';
$string['advanced_dlg:code_wordwrap'] = 'Automatischer Zeilenumbruch';
$string['advanced_dlg:colorpicker_color'] = 'Farbe:';
$string['advanced_dlg:colorpicker_name'] = 'Name:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Benannte Farben';
$string['advanced_dlg:colorpicker_named_title'] = 'Benannte Farben';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palette';
$string['advanced_dlg:colorpicker_palette_title'] = 'Farbpalette';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Farbwahl';
$string['advanced_dlg:colorpicker_picker_title'] = 'Farbwahl';
$string['advanced_dlg:colorpicker_title'] = 'Farbe';
$string['advanced_dlg:image_align'] = 'Ausrichtung';
$string['advanced_dlg:image_align_baseline'] = 'Zeile';
$string['advanced_dlg:image_align_bottom'] = 'Unten';
$string['advanced_dlg:image_align_left'] = 'Links';
$string['advanced_dlg:image_align_middle'] = 'Mittig';
$string['advanced_dlg:image_align_right'] = 'Rechts';
$string['advanced_dlg:image_align_textbottom'] = 'Unten im Text';
$string['advanced_dlg:image_align_texttop'] = 'Oben im Text';
$string['advanced_dlg:image_align_top'] = 'Oben';
$string['advanced_dlg:image_alt'] = 'Bildbeschreibung';
$string['advanced_dlg:image_border'] = 'Rahmen';
$string['advanced_dlg:image_dimensions'] = 'Größe';
$string['advanced_dlg:image_hspace'] = 'Horizontaler Abstand';
$string['advanced_dlg:image_list'] = 'Bilderliste';
$string['advanced_dlg:image_src'] = 'Adresse';
$string['advanced_dlg:image_title'] = 'Bild einfügen / bearbeiten';
$string['advanced_dlg:image_vspace'] = 'Vertikaler Abstand';
$string['advanced_dlg:invalid_color_value'] = 'Ungültiger Farbwert';
$string['advanced_dlg:link_is_email'] = 'Diese URL scheint eine E-Mail-Adresse zu sein. Möchten Sie das notwendige \'mailto:\' voranstellen?';
$string['advanced_dlg:link_is_external'] = 'Diese URL scheint ein externer Link zu sein. Möchten Sie das notwendige \'https://\' voranstellen?';
$string['advanced_dlg:link_list'] = 'Linkliste';
$string['advanced_dlg:link_target'] = 'Ziel';
$string['advanced_dlg:link_target_blank'] = 'In neuem Fenster öffnen';
$string['advanced_dlg:link_target_same'] = 'Im selben Fenster öffnen';
$string['advanced_dlg:link_title'] = 'Link einfügen/bearbeiten';
$string['advanced_dlg:link_titlefield'] = 'Titel';
$string['advanced_dlg:link_url'] = 'Adresse';
$string['advhr:advhr_desc'] = 'Horizontale Trennlinie';
$string['advhr:delta_height'] = '0';
$string['advhr:delta_width'] = '0';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Ohne Schatten';
$string['advhr_dlg:size'] = 'Höhe';
$string['advhr_dlg:width'] = 'Breite';
$string['advhr_dlg:widthunits'] = 'Einheiten';
$string['advimage:delta_height'] = '0';
$string['advimage:delta_width'] = '0';
$string['advimage:image_desc'] = 'Bild einfügen/bearbeiten';
$string['advimage_dlg:align'] = 'Ausrichtung';
$string['advimage_dlg:align_baseline'] = 'Grundlinie';
$string['advimage_dlg:align_bottom'] = 'Unten';
$string['advimage_dlg:align_left'] = 'Links';
$string['advimage_dlg:align_middle'] = 'Mittig';
$string['advimage_dlg:align_right'] = 'Rechts';
$string['advimage_dlg:align_textbottom'] = 'Text unten';
$string['advimage_dlg:align_texttop'] = 'Text oben';
$string['advimage_dlg:align_top'] = 'Oben';
$string['advimage_dlg:alt'] = 'Beschreibung';
$string['advimage_dlg:alt_image'] = 'Bild alternative';
$string['advimage_dlg:border'] = 'Rahmen';
$string['advimage_dlg:classes'] = 'Klassen';
$string['advimage_dlg:constrain_proportions'] = 'proportional';
$string['advimage_dlg:dialog_title'] = 'Bild einfügen/bearbeiten';
$string['advimage_dlg:dimensions'] = 'Größe';
$string['advimage_dlg:example_img'] = 'Vorschau';
$string['advimage_dlg:general'] = 'Allgemeines';
$string['advimage_dlg:height'] = 'Höhe';
$string['advimage_dlg:hspace'] = 'Horizontaler Abstand';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Bilderliste';
$string['advimage_dlg:langcode'] = 'Sprachcode';
$string['advimage_dlg:langdir'] = 'Schriftrichtung';
$string['advimage_dlg:list'] = 'Bilderliste';
$string['advimage_dlg:long_desc'] = 'Ausführliche Beschreibung';
$string['advimage_dlg:ltr'] = 'Links nach rechts';
$string['advimage_dlg:map'] = 'ImageMap';
$string['advimage_dlg:misc'] = 'Verschiedenes';
$string['advimage_dlg:missing_alt'] = 'Möchten Sie wirklich keine Bildbeschreibung eingeben? Ohne Beschreibung können Nutzer/innen mit Einschränkungen oder Nutzer/innen ohne Bildanzeige im Browser die Bildinhalte nicht erfassen.';
$string['advimage_dlg:mouseout'] = 'ohne Mauskontakt';
$string['advimage_dlg:mouseover'] = 'bei Mauskontakt';
$string['advimage_dlg:preview'] = 'Vorschau';
$string['advimage_dlg:rtl'] = 'Rechts nach links';
$string['advimage_dlg:src'] = 'Bild-Adresse';
$string['advimage_dlg:style'] = 'Format';
$string['advimage_dlg:swap_image'] = 'Bild austauschen';
$string['advimage_dlg:tab_advanced'] = 'Erweitert';
$string['advimage_dlg:tab_appearance'] = 'Darstellung';
$string['advimage_dlg:tab_general'] = 'Allgemeines';
$string['advimage_dlg:title'] = 'Titel';
$string['advimage_dlg:vspace'] = 'Vertikaler Abstand';
$string['advimage_dlg:width'] = 'Breite';
$string['advlink:delta_height'] = '0';
$string['advlink:delta_width'] = '0';
$string['advlink:link_desc'] = 'Link einfügen/bearbeiten';
$string['advlink_dlg:accesskey'] = 'Tastaturkürzel';
$string['advlink_dlg:advanced_props'] = 'Erweiterte Eigenschaften';
$string['advlink_dlg:advanced_tab'] = 'Erweitert';
$string['advlink_dlg:anchor_names'] = 'Anker';
$string['advlink_dlg:classes'] = 'Klassen';
$string['advlink_dlg:encoding'] = 'Zeichenkodierung';
$string['advlink_dlg:event_props'] = 'Ereignisse';
$string['advlink_dlg:events_tab'] = 'Ereignisse';
$string['advlink_dlg:general_props'] = 'Allgemeines';
$string['advlink_dlg:general_tab'] = 'Allgemeines';
$string['advlink_dlg:height'] = 'Höhe';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Diese URL scheint eine E-Mail-Adresse zu sein. Möchten Sie das notwendige \'mailto:\' voranstellen?';
$string['advlink_dlg:is_external'] = 'Diese URL scheint ein externer Link zu sein. Möchten Sie das notwendige \'https://\' voranstellen?';
$string['advlink_dlg:langcode'] = 'Sprachcode';
$string['advlink_dlg:langdir'] = 'Schriftrichtung';
$string['advlink_dlg:link_list'] = 'Linkliste';
$string['advlink_dlg:list'] = 'Linkliste';
$string['advlink_dlg:ltr'] = 'Links nach rechts';
$string['advlink_dlg:mime'] = 'MIME-Type';
$string['advlink_dlg:popup'] = 'JavaScript-Popup';
$string['advlink_dlg:popup_dependent'] = 'Browserabhängig <br /> (nur Firefox)';
$string['advlink_dlg:popup_location'] = 'Adressleiste anzeigen';
$string['advlink_dlg:popup_menubar'] = 'Browsermenü anzeigen';
$string['advlink_dlg:popup_name'] = 'Name des Fensters';
$string['advlink_dlg:popup_opts'] = 'Optionen';
$string['advlink_dlg:popup_position'] = 'Position (X/Y)';
$string['advlink_dlg:popup_props'] = 'Popup-Eigenschaften';
$string['advlink_dlg:popup_resizable'] = 'Größe des Fenster änderbar';
$string['advlink_dlg:popup_return'] = 'Link trotz Popup folgen';
$string['advlink_dlg:popup_scrollbars'] = 'Scrollbalken anzeigen';
$string['advlink_dlg:popup_size'] = 'Größe';
$string['advlink_dlg:popup_statusbar'] = 'Statusleiste anzeigen';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Werkzeugleisten anzeigen';
$string['advlink_dlg:popup_url'] = 'Popup-Adresse';
$string['advlink_dlg:rel'] = 'Beziehung der Seite zum Linkziel';
$string['advlink_dlg:rev'] = 'Beziehung des Linkziels zur Seite';
$string['advlink_dlg:rtl'] = 'Rechts nach links';
$string['advlink_dlg:style'] = 'Format';
$string['advlink_dlg:tabindex'] = 'Tabindex';
$string['advlink_dlg:target'] = 'Fenster';
$string['advlink_dlg:target_blank'] = 'In neuem Fenster öffnen';
$string['advlink_dlg:target_langcode'] = 'Sprache';
$string['advlink_dlg:target_name'] = 'Name des Ziels';
$string['advlink_dlg:target_parent'] = 'In übergeordnetem Fenster/Frame öffnen';
$string['advlink_dlg:target_same'] = 'In selbem Fenster/Frame öffnen';
$string['advlink_dlg:target_top'] = 'In oberstem Frame öffnen (ersetzt Frameset)';
$string['advlink_dlg:title'] = 'Link einfügen/bearbeiten';
$string['advlink_dlg:titlefield'] = 'Titel';
$string['advlink_dlg:url'] = 'Adresse';
$string['advlink_dlg:width'] = 'Breite';
$string['advlist:circle'] = 'Kreis';
$string['advlist:def'] = 'Standard';
$string['advlist:disc'] = 'Punkt';
$string['advlist:lower_alpha'] = 'a. b. c.';
$string['advlist:lower_greek'] = '1. 2. 3.';
$string['advlist:lower_roman'] = 'i. ii. iii.';
$string['advlist:square'] = 'Quadrat';
$string['advlist:types'] = 'Varianten';
$string['advlist:upper_alpha'] = 'A. B. C.';
$string['advlist:upper_roman'] = 'I. II. III.';
$string['aria:rich_text_area'] = 'Textbereich (Rich Text)';
$string['autosave:restore_content'] = 'Automatisch gespeicherten Inhalt wiederherstellen';
$string['autosave:unload_msg'] = 'Ihre Änderungen gehen verloren, wenn Sie die Seite verlassen.';
$string['autosave:warning_message'] = 'Wenn Sie den automatisch gesicherten Inhalt wiederherstellen, gehen die aktuellen Inhalte im Editor verloren. Möchten Sie wirklich den Inhalt wiederherstellen?';
$string['availablebuttons'] = 'Verfügbare Tasten';
$string['colors:000000'] = 'Schwarz';
$string['colors:000080'] = 'Marineblau';
$string['colors:0000FF'] = 'Blau';
$string['colors:003300'] = 'Dunkelgrün';
$string['colors:003366'] = 'Azur (dunkel)';
$string['colors:008000'] = 'Grün';
$string['colors:008080'] = 'Blaugrün';
$string['colors:00CCFF'] = 'Himmelblau';
$string['colors:00FF00'] = 'Limone';
$string['colors:00FFFF'] = 'Wasserblau';
$string['colors:333300'] = 'Oliv (dunkel)';
$string['colors:333333'] = 'Sehr dunkles Grau';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Königsblau';
$string['colors:339966'] = 'Seegrün';
$string['colors:33CCCC'] = 'Türkis';
$string['colors:666699'] = 'Graublau';
$string['colors:800000'] = 'Kastanienbraun';
$string['colors:800080'] = 'Violett';
$string['colors:808000'] = 'Oliv';
$string['colors:808080'] = 'Grau';
$string['colors:993300'] = 'Braunorange';
$string['colors:993366'] = 'Braun';
$string['colors:999999'] = 'Mittleres Grau';
$string['colors:99CC00'] = 'Gelbgrün';
$string['colors:99CCFF'] = 'Himmelblau';
$string['colors:C0C0C0'] = 'Silber';
$string['colors:CC99FF'] = 'Pflaume';
$string['colors:CCFFCC'] = 'Blassgrün';
$string['colors:CCFFFF'] = 'Blasscyan';
$string['colors:FF0000'] = 'Rot';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Orange';
$string['colors:FF9900'] = 'Bernstein';
$string['colors:FF99CC'] = 'Pink';
$string['colors:FFCC00'] = 'Gold';
$string['colors:FFCC99'] = 'Pfirsich';
$string['colors:FFFF00'] = 'Gelb';
$string['colors:FFFF99'] = 'Hellgelb';
$string['colors:FFFFFF'] = 'Weiß';
$string['common:apply'] = 'Übernehmen';
$string['common:browse'] = 'Durchsuchen';
$string['common:cancel'] = 'Abbrechen';
$string['common:class_name'] = 'CSS-Klasse';
$string['common:clipboard_msg'] = 'Kopieren, Ausschneiden und Einfügen sind im Mozilla Firefox nicht möglich. Möchten Sie mehr über dieses Problem erfahren?';
$string['common:clipboard_no_support'] = 'Dies wird von Ihrem Browser nicht unterstützt. Benutzen Sie stattdessen die Tastenkürzel.';
$string['common:close'] = 'Schließen';
$string['common:edit_confirm'] = 'Möchten Sie den formatierten Text in diesem Textbereich anzeigen?';
$string['common:insert'] = 'Einfügen';
$string['common:invalid_data'] = 'Fehler: Ungültige Werte eingegeben (rot markiert).';
$string['common:invalid_data_min'] = '{#field} muss größer sein als {#min}';
$string['common:invalid_data_number'] = '{#field} muss eine Zahl sein';
$string['common:invalid_data_size'] = '{#field} muss eine Zahl oder ein Prozentwert sein';
$string['common:more_colors'] = 'Weitere Farben';
$string['common:not_set'] = '- nicht festgelegt -';
$string['common:popup_blocked'] = 'Leider hat der Popup-Blocker ein Fenster unterdrückt, das für die Funktionalität nötig ist. Deaktivieren Sie bitte den Popup-Blocker für diese Website.';
$string['common:update'] = 'Aktualisieren';
$string['common:value'] = '(Wert)';
$string['contextmenu:align'] = 'Ausrichtung';
$string['contextmenu:center'] = 'Zentriert';
$string['contextmenu:full'] = 'Blocksatz';
$string['contextmenu:left'] = 'Linksbündig';
$string['contextmenu:right'] = 'Rechtsbündig';
$string['customconfig'] = 'Erweiterte Einstellungen';
$string['customconfig_desc'] = 'Die erweiterten Einstellungen des HTML-Editors TinyMCE werden im in JSON Format angegeben, d.h. in der folgenden Form: {"option1" : "value1", "option2" : "value2"}. Alle hier gesetzten Optionen überschreiben die Standard- und Plugineinstellungen.';
$string['customtoolbar'] = 'Werkzeugleiste';
$string['customtoolbar_desc'] = 'Jede Zeile enthält eine kommagetrennte Liste von Werkzeugsymbolen. \'wrap\' dient als Gruppentrenner. Leerzeilen werden ignoriert. <a href="{$a}" target="_blank">{$a}</a>Standardmäßige Werkzeugsymbole des HTML-Editors TinyMCE.<br />Die erste Zeile wird immer angezeigt, die beiden weiteren Zeilen können ein- und ausgeblendet werden.';
$string['directionality:ltr_desc'] = 'Schrift von links nach rechts';
$string['directionality:rtl_desc'] = 'Schrift von rechts nach links';
$string['emotions:delta_height'] = '0';
$string['emotions:delta_width'] = '0';
$string['emotions:emotions_desc'] = 'Smilies';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Weinend';
$string['emotions_dlg:desc'] = 'Smilies';
$string['emotions_dlg:embarassed'] = 'Verlegen';
$string['emotions_dlg:foot_in_mouth'] = 'Reingefallen';
$string['emotions_dlg:frown'] = 'Stirnrunzelnd';
$string['emotions_dlg:innocent'] = 'Unschuldig';
$string['emotions_dlg:kiss'] = 'Küssend';
$string['emotions_dlg:laughing'] = 'Lachend';
$string['emotions_dlg:money_mouth'] = 'Geld';
$string['emotions_dlg:sealed'] = 'Verschlossen';
$string['emotions_dlg:smile'] = 'Lächelnd';
$string['emotions_dlg:surprised'] = 'Überrascht';
$string['emotions_dlg:title'] = 'Smiley einfügen';
$string['emotions_dlg:tongue_out'] = 'Zunge raus';
$string['emotions_dlg:undecided'] = 'Unentschlossen';
$string['emotions_dlg:usage'] = 'Verwenden Sie die \'nach links\' und \'nach rechts\' Pfeile zur Navigation';
$string['emotions_dlg:wink'] = 'Zwinkernd';
$string['emotions_dlg:yell'] = 'Brüllend';
$string['fontselectlist'] = 'Verfügbare Zeichensätze';
$string['fullpage:delta_height'] = '0';
$string['fullpage:delta_width'] = '0';
$string['fullpage:desc'] = 'Dokument-Eigenschaften';
$string['fullpage_dlg:active_color'] = 'Active-Farbe';
$string['fullpage_dlg:add'] = 'Neues Element hinzufügen';
$string['fullpage_dlg:add_base'] = 'Base-Element';
$string['fullpage_dlg:add_comment'] = 'HTML-Kommentar';
$string['fullpage_dlg:add_link'] = 'Link-Element';
$string['fullpage_dlg:add_meta'] = 'Meta-Element';
$string['fullpage_dlg:add_script'] = 'Script-Element';
$string['fullpage_dlg:add_style'] = 'Style-Element';
$string['fullpage_dlg:add_title'] = 'Titel-Element';
$string['fullpage_dlg:advanced_props'] = 'Erweitert';
$string['fullpage_dlg:advanced_tab'] = 'Erweitert';
$string['fullpage_dlg:appearance_bgprops'] = 'Hintergrund-Eigenschaften';
$string['fullpage_dlg:appearance_linkprops'] = 'Linkfarben';
$string['fullpage_dlg:appearance_marginprops'] = 'Abstände des Body';
$string['fullpage_dlg:appearance_style'] = 'CSS-Stylesheet und Stileigenschaften';
$string['fullpage_dlg:appearance_tab'] = 'Darstellung';
$string['fullpage_dlg:appearance_textprops'] = 'Text-Eigenschaften';
$string['fullpage_dlg:author'] = 'Autor/in';
$string['fullpage_dlg:base_element'] = 'Base-Element';
$string['fullpage_dlg:bgcolor'] = 'Hintergrundfarbe';
$string['fullpage_dlg:bgimage'] = 'Hintergrundbild';
$string['fullpage_dlg:bottom_margin'] = 'Unterer Abstand';
$string['fullpage_dlg:charset'] = 'Zeichensatz';
$string['fullpage_dlg:comment_element'] = 'Kommentar';
$string['fullpage_dlg:content'] = 'Inhalt';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'DocType';
$string['fullpage_dlg:encoding'] = 'Zeichencodierung';
$string['fullpage_dlg:font_face'] = 'Schriftart';
$string['fullpage_dlg:font_size'] = 'Schriftgröße';
$string['fullpage_dlg:fontface'] = 'Schriftart';
$string['fullpage_dlg:fontsize'] = 'Schriftgröße';
$string['fullpage_dlg:general_props'] = 'Allgemeines';
$string['fullpage_dlg:head_elements'] = 'Überschriftenelemente';
$string['fullpage_dlg:hover_color'] = 'Hover-Farbe';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = 'Sprachcode';
$string['fullpage_dlg:langdir'] = 'Sprachrichtung';
$string['fullpage_dlg:langprops'] = 'Sprache und Codierung';
$string['fullpage_dlg:language'] = 'Sprache';
$string['fullpage_dlg:left_margin'] = 'Linker Abstand';
$string['fullpage_dlg:link_color'] = 'Linkfarbe';
$string['fullpage_dlg:link_element'] = 'Link-Element';
$string['fullpage_dlg:ltr'] = 'Links nach Rechts';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Beschreibung';
$string['fullpage_dlg:meta_element'] = 'Meta-Element';
$string['fullpage_dlg:meta_index_follow'] = 'Indizieren und den Links folgen';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indizieren, aber den Links nicht folgen';
$string['fullpage_dlg:meta_keywords'] = 'Schlagwörter';
$string['fullpage_dlg:meta_noindex_follow'] = 'Nicht indizieren, aber den Links folgen';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Nicht indizieren und nicht den Links folgen';
$string['fullpage_dlg:meta_props'] = 'Meta-Information';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'Allgemeines';
$string['fullpage_dlg:meta_title'] = 'Titel';
$string['fullpage_dlg:movedown'] = 'Ausgewähltes Element nach unten bewegen';
$string['fullpage_dlg:moveup'] = 'Ausgewähltes Element nach oben bewegen';
$string['fullpage_dlg:name'] = 'Name';
$string['fullpage_dlg:properties'] = 'Eigenschaften';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Ausgewähltes Element entfernen';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Rechter Abstand';
$string['fullpage_dlg:rtl'] = 'Rechts nach Links';
$string['fullpage_dlg:script_element'] = 'Script-Element';
$string['fullpage_dlg:src'] = 'Quelle (Source)';
$string['fullpage_dlg:style'] = 'CSS-Style';
$string['fullpage_dlg:style_element'] = 'Style-Element';
$string['fullpage_dlg:stylesheet'] = 'CSS-Stylesheet';
$string['fullpage_dlg:target'] = 'Ziel';
$string['fullpage_dlg:text_color'] = 'Textfarbe';
$string['fullpage_dlg:textcolor'] = 'Farbe';
$string['fullpage_dlg:title'] = 'Dokument-Eigenschaften';
$string['fullpage_dlg:title_element'] = 'Titel-Element';
$string['fullpage_dlg:top_margin'] = 'Oberer Abstand';
$string['fullpage_dlg:type'] = 'Typ';
$string['fullpage_dlg:value'] = 'Wert';
$string['fullpage_dlg:visited_color'] = 'Visited-Farbe';
$string['fullpage_dlg:xml_pi'] = 'XML Deklaration';
$string['fullscreen:desc'] = 'Vollbildschirm';
$string['iespell:download'] = 'ieSpell konnte nicht gefunden werden. Möchten Sie es installieren?';
$string['iespell:iespell_desc'] = 'Rechtschreibprüfung';
$string['insertdatetime:date_fmt'] = '%d.%m.%Y';
$string['insertdatetime:day_long'] = 'Sonntag,Montag,Dienstag,Mittwoch,Donnerstag,Freitag,Samstag,Sonntag';
$string['insertdatetime:day_short'] = 'So,Mo,Di,Mi,Do,Fr,Sa,So';
$string['insertdatetime:insertdate_desc'] = 'Datum einfügen';
$string['insertdatetime:inserttime_desc'] = 'Zeit einfügen';
$string['insertdatetime:months_long'] = 'Januar,Februar,März,April,Mai,Juni,Juli,August,September,Oktober,November,Dezember';
$string['insertdatetime:months_short'] = 'Jan,Feb,März,Apr,Mai,Juni,Juli,Aug,Sept,Okt,Nov,Dez';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Absolute Positionierung';
$string['layer:backward_desc'] = 'Nach hinten legen';
$string['layer:content'] = 'Neue Ebene...';
$string['layer:forward_desc'] = 'Nach vorne holen';
$string['layer:insertlayer_desc'] = 'Neue Ebene einfügen';
$string['media:delta_height'] = '0';
$string['media:delta_width'] = '0';
$string['media:desc'] = 'Multimedia einfügen/bearbeiten';
$string['media:edit'] = 'Multimediaeinbettung bearbeiten';
$string['media_dlg:advanced'] = 'Erweitert';
$string['media_dlg:align'] = 'Ausrichtung';
$string['media_dlg:align_bottom'] = 'Unten';
$string['media_dlg:align_bottom_left'] = 'Unten Links';
$string['media_dlg:align_bottom_right'] = 'Unten Rechts';
$string['media_dlg:align_center'] = 'Zentriert';
$string['media_dlg:align_left'] = 'Links';
$string['media_dlg:align_right'] = 'Rechts';
$string['media_dlg:align_top'] = 'Oben';
$string['media_dlg:align_top_left'] = 'Oben Links';
$string['media_dlg:align_top_right'] = 'Oben Rechts';
$string['media_dlg:altsource1'] = 'Alternative Quelle 1';
$string['media_dlg:altsource2'] = 'Alternative Quelle 2';
$string['media_dlg:audio'] = 'HTML5-Audio';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Autostart';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'Hintergrund';
$string['media_dlg:cache'] = 'Zwischenspeicher';
$string['media_dlg:captioningid'] = 'Captioning ID';
$string['media_dlg:center'] = 'Zentriert';
$string['media_dlg:class_name'] = 'CSS-Klasse';
$string['media_dlg:console'] = 'Konsole';
$string['media_dlg:constrain_proportions'] = 'Proportionen erhalten';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Steuerung';
$string['media_dlg:correction'] = 'Ohne Korrektur';
$string['media_dlg:currentmarker'] = 'Aktueller Marker';
$string['media_dlg:currentposition'] = 'Aktuelle Position';
$string['media_dlg:defaultframe'] = 'Frame-Voreinstellung';
$string['media_dlg:embedded_audio_options'] = 'Optionen zum Einbetten von Audio';
$string['media_dlg:embeddedaudio'] = 'Audio eingebettet';
$string['media_dlg:enabled'] = 'Aktiviert';
$string['media_dlg:enablejavascript'] = 'JavaScript aktivieren';
$string['media_dlg:endtime'] = 'Endzeitpunkt';
$string['media_dlg:file'] = 'Datei/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash-Optionen';
$string['media_dlg:flashvars'] = 'Flash-Variablen';
$string['media_dlg:fullscreen'] = 'Vollbild';
$string['media_dlg:general'] = 'Allgemeines';
$string['media_dlg:hidden'] = 'Versteckt';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Horizontaler Abstand';
$string['media_dlg:html5_audio_options'] = 'Audio-Optionen';
$string['media_dlg:html5_video_options'] = 'HTML5-Video-Optionen';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Bildstatus';
$string['media_dlg:invokeurls'] = 'Invoke URLs';
$string['media_dlg:kioskmode'] = 'Kioskmodus';
$string['media_dlg:list'] = 'Liste';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Wiederholung';
$string['media_dlg:maintainaspect'] = 'Bildverhältnis beibehalten';
$string['media_dlg:menu'] = 'Menü anzeigen';
$string['media_dlg:mute'] = 'Stumm';
$string['media_dlg:name'] = 'Name';
$string['media_dlg:nojava'] = 'Kein Java';
$string['media_dlg:numloop'] = 'Anzahl Wiederholungen';
$string['media_dlg:play'] = 'Automatisches Abspielen';
$string['media_dlg:playcount'] = 'Zähler';
$string['media_dlg:playeveryframe'] = 'Jeden Frame abspielen';
$string['media_dlg:poster'] = 'Vorschau';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = 'Vorab laden';
$string['media_dlg:preload_auto'] = 'Nutzer entscheiden selber';
$string['media_dlg:preload_metadata'] = 'Video-Metadaten  vorab laden';
$string['media_dlg:preload_none'] = 'Nicht zuvor laden';
$string['media_dlg:preview'] = 'Vorschau';
$string['media_dlg:progress'] = 'Fortschritt';
$string['media_dlg:qt_options'] = 'QuickTime-Optionen';
$string['media_dlg:qt_stream_warn'] = 'Gestreamte RTSP Medien sollten im Feld \'Quicktime-Quelle\'  eingefügt werden. Zusätzlich sollten Sie auch eine nicht-gestreamte Version im Feld Source angeben.';
$string['media_dlg:qtsrc'] = 'Quicktime-Quelle';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:quality'] = 'Qualität';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Optionen für Real Media Player';
$string['media_dlg:salign'] = 'S-Ausrichtung';
$string['media_dlg:scale'] = 'Skalierung';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave-Optionen';
$string['media_dlg:shuffle'] = 'Zufällige Wiedergabe';
$string['media_dlg:size'] = 'Abmessungen';
$string['media_dlg:sound'] = 'Ton';
$string['media_dlg:source'] = 'Quelle';
$string['media_dlg:starttime'] = 'Startzeitpunkt';
$string['media_dlg:stretchtofit'] = 'Größe an verfügbaren Platz anpassen';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Ausrichtung';
$string['media_dlg:swstretchstyle'] = 'Stretch style';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Ausrichtung';
$string['media_dlg:target'] = 'Ziel';
$string['media_dlg:targetcache'] = 'Ziel zwischenspeichern';
$string['media_dlg:title'] = 'Multimedia einfügen/bearbeiten';
$string['media_dlg:type'] = 'Typ';
$string['media_dlg:uimode'] = 'UI Modus';
$string['media_dlg:video'] = 'HTML5-Video';
$string['media_dlg:volume'] = 'Lautstärke';
$string['media_dlg:vspace'] = 'Vertikaler Abstand';
$string['media_dlg:windowlessvideo'] = 'Fensterloses Video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Optionen für Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Geschütztes Leerzeichen einfügen';
$string['pagebreak:desc'] = 'Seitenumbruch für Druck einfügen';
$string['paste:paste_text_desc'] = 'Als einfachen Text einfügen';
$string['paste:paste_word_desc'] = 'Als formatierten Text einfügen';
$string['paste:plaintext_mode'] = 'Der Einfügemodus ist nun \'Einfacher Text\'. Wenn Sie noch einmal klicken, stellen Sie wieder den Normalmodus ein. Nachdem Sie etwas eingefügt haben, wird der Normalmodus automatisch eingestellt.';
$string['paste:plaintext_mode_stick'] = 'Der Einfügemodus ist nun \'Einfacher Text\'. Wenn Sie noch einmal klicken, stellen Sie wieder den Normalmodus ein.';
$string['paste:selectall_desc'] = 'Alles auswählen';
$string['paste_dlg:text_linebreaks'] = 'Zeilenumbrüche beibehalten';
$string['paste_dlg:text_title'] = 'Drücken Sie Strg+V bzw. Cmd+V, um den Text einzufügen.';
$string['paste_dlg:word_title'] = 'Drücken Sie Strg+V bzw. Cmd+V, um den Text einzufügen.';
$string['pluginname'] = 'HTML-Editor TinyMCE';
$string['preview:preview_desc'] = 'Vorschau';
$string['print:print_desc'] = 'Drucken';
$string['privacy:metadata'] = 'Das Plugin "HTML-Editor TinyMCE" speichert keine personenbezogenen Daten';
$string['save:cancel_desc'] = 'Alle Änderungen verwerfen';
$string['save:save_desc'] = 'Speichern';
$string['searchreplace:delta_height'] = '0';
$string['searchreplace:delta_width'] = '0';
$string['searchreplace:replace_desc'] = 'Suchen/Ersetzen';
$string['searchreplace:search_desc'] = 'Suchen';
$string['searchreplace_dlg:allreplaced'] = 'Alle Fundstellen der Zeichenkette wurden ersetzt.';
$string['searchreplace_dlg:direction'] = 'Suchrichtung';
$string['searchreplace_dlg:down'] = 'Abwärts';
$string['searchreplace_dlg:findnext'] = 'Weitersuchen';
$string['searchreplace_dlg:findwhat'] = 'Zu suchender Text';
$string['searchreplace_dlg:mcase'] = 'Groß-/Kleinschreibung';
$string['searchreplace_dlg:notfound'] = 'Die Suche ist am Ende angelangt. Die Zeichenkette konnte nicht gefunden werden.';
$string['searchreplace_dlg:replace'] = 'Ersetzen';
$string['searchreplace_dlg:replace_title'] = 'Suchen/Ersetzen';
$string['searchreplace_dlg:replaceall'] = 'Alle ersetzen';
$string['searchreplace_dlg:replacewith'] = 'Ersetzen durch';
$string['searchreplace_dlg:search_title'] = 'Suchen';
$string['searchreplace_dlg:searchnext_desc'] = 'Weitersuchen';
$string['searchreplace_dlg:up'] = 'Aufwärts';
$string['settings'] = 'Allgemeines';
$string['simple:bold_desc'] = 'Fett';
$string['simple:bullist_desc'] = 'Aufzählung einfügen/entfernen';
$string['simple:cleanup_desc'] = 'Quellcode bereinigen';
$string['simple:italic_desc'] = 'Kursiv';
$string['simple:numlist_desc'] = 'Nummerierung einfügen/entfernen';
$string['simple:redo_desc'] = 'Wiederholen';
$string['simple:striketrough_desc'] = 'Durchgestrichen';
$string['simple:underline_desc'] = 'Unterstrichen';
$string['simple:undo_desc'] = 'Rückgängig';
$string['spellchecker:desc'] = 'Rechtschreibprüfung an/aus';
$string['spellchecker:ignore_word'] = 'Wort ignorieren';
$string['spellchecker:ignore_words'] = 'Alle ignorieren';
$string['spellchecker:langs'] = 'Sprachen';
$string['spellchecker:learn_word'] = 'Wort lernen';
$string['spellchecker:menu'] = 'Einstellungen der Rechtschreibprüfung';
$string['spellchecker:no_mpell'] = 'Keine Rechtschreibfehler gefunden';
$string['spellchecker:no_sug'] = 'Keine Vorschläge';
$string['spellchecker:sug'] = 'Vorschläge';
$string['spellchecker:wait'] = 'Bitte warten...';
$string['style:delta_height'] = '0';
$string['style:delta_width'] = '0';
$string['style:desc'] = 'CSS-Style bearbeiten';
$string['style_dlg:apply'] = 'Übernehmen';
$string['style_dlg:background'] = 'Hintergrund';
$string['style_dlg:background_attachment'] = 'Wasserzeichen';
$string['style_dlg:background_color'] = 'Hintergrundfarbe';
$string['style_dlg:background_hpos'] = 'Position X';
$string['style_dlg:background_image'] = 'Hintergrundbild';
$string['style_dlg:background_repeat'] = 'Wiederholung';
$string['style_dlg:background_tab'] = 'Hintergrund';
$string['style_dlg:background_vpos'] = 'Position Y';
$string['style_dlg:block'] = 'Block';
$string['style_dlg:block_display'] = 'Umbruchverhalten';
$string['style_dlg:block_letterspacing'] = 'Buchstabenabstand';
$string['style_dlg:block_tab'] = 'Block';
$string['style_dlg:block_text_align'] = 'Ausrichtung';
$string['style_dlg:block_text_indent'] = 'Einrücken';
$string['style_dlg:block_vertical_alignment'] = 'Vertikale Ausrichtung';
$string['style_dlg:block_whitespace'] = 'Automatischer Umbruch';
$string['style_dlg:block_wordspacing'] = 'Wortabstand';
$string['style_dlg:border'] = 'Rahmen';
$string['style_dlg:border_tab'] = 'Rahmen';
$string['style_dlg:bottom'] = 'Unten';
$string['style_dlg:box'] = 'Box';
$string['style_dlg:box_clear'] = 'Umfließung verhindern';
$string['style_dlg:box_float'] = 'Umfließung';
$string['style_dlg:box_height'] = 'Höhe';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Breite';
$string['style_dlg:bullet_image'] = 'Listenpunkt-Grafik';
$string['style_dlg:clip'] = 'Ausschnitt';
$string['style_dlg:color'] = 'Textfarbe';
$string['style_dlg:height'] = 'Höhe';
$string['style_dlg:left'] = 'Links';
$string['style_dlg:list'] = 'Liste';
$string['style_dlg:list_tab'] = 'Liste';
$string['style_dlg:list_type'] = 'Listenpunkt';
$string['style_dlg:margin'] = 'Äußerer Abstand';
$string['style_dlg:overflow'] = 'Verhalten bei Übergröße';
$string['style_dlg:padding'] = 'Innerer Abstand';
$string['style_dlg:placement'] = 'Platzierung';
$string['style_dlg:position'] = 'Positionierung';
$string['style_dlg:positioning_tab'] = 'Positionierung';
$string['style_dlg:positioning_type'] = 'Art der Positionierung';
$string['style_dlg:right'] = 'Rechts';
$string['style_dlg:same'] = 'Alle gleich';
$string['style_dlg:style'] = 'Format';
$string['style_dlg:text'] = 'Text';
$string['style_dlg:text_blink'] = 'Blinkend';
$string['style_dlg:text_case'] = 'Schreibung';
$string['style_dlg:text_color'] = 'Farbe';
$string['style_dlg:text_decoration'] = 'Gestaltung';
$string['style_dlg:text_font'] = 'Schriftart';
$string['style_dlg:text_lineheight'] = 'Zeilenhöhe';
$string['style_dlg:text_none'] = 'Keine';
$string['style_dlg:text_overline'] = 'Überstrichen';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'Größe';
$string['style_dlg:text_striketrough'] = 'Durchgestrichen';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'Unterstrichen
';
$string['style_dlg:text_variant'] = 'Variante';
$string['style_dlg:text_weight'] = 'Dicke';
$string['style_dlg:title'] = 'CSS-Style bearbeiten';
$string['style_dlg:toggle_insert_span'] = 'Span für Auswahl hnzufügen';
$string['style_dlg:top'] = 'Oben';
$string['style_dlg:visibility'] = 'Sichtbar';
$string['style_dlg:width'] = 'Breite';
$string['style_dlg:zindex'] = 'Z-Wert';
$string['subplugintype_tinymce'] = 'Plugin';
$string['subplugintype_tinymce_plural'] = 'Plugins';
$string['table:cell'] = 'Zelle';
$string['table:cell_desc'] = 'Eigenschaften der Zelle';
$string['table:cellprops_delta_height'] = '0';
$string['table:cellprops_delta_width'] = '150';
$string['table:col'] = 'Spalte';
$string['table:col_after_desc'] = 'Spalte rechts einfügen';
$string['table:col_before_desc'] = 'Spalte links einfügen';
$string['table:copy_row_desc'] = 'Zeile kopieren';
$string['table:cut_row_desc'] = 'Zeile ausschneiden';
$string['table:del'] = 'Tabelle löschen';
$string['table:delete_col_desc'] = 'Spalte löschen';
$string['table:delete_row_desc'] = 'Zeile löschen';
$string['table:desc'] = 'Tabelle einfügen/bearbeiten';
$string['table:merge_cells_delta_height'] = '0';
$string['table:merge_cells_delta_width'] = '0';
$string['table:merge_cells_desc'] = 'Zellen verbinden';
$string['table:paste_row_after_desc'] = 'Zeile aus der Zwischenablage unterhalb einfügen';
$string['table:paste_row_before_desc'] = 'Zeile aus der Zwischenablage oberhalb einfügen';
$string['table:props_desc'] = 'Eigenschaften der Tabelle';
$string['table:row'] = 'Zeile';
$string['table:row_after_desc'] = 'Zeile unterhalb einfügen';
$string['table:row_before_desc'] = 'Zeile oberhalb einfügen';
$string['table:row_desc'] = 'Eigenschaften der Zeile';
$string['table:rowprops_delta_height'] = '0';
$string['table:rowprops_delta_width'] = '0';
$string['table:split_cells_desc'] = 'Verbundene Zellen trennen';
$string['table:table_delta_height'] = '0';
$string['table:table_delta_width'] = '0';
$string['table_dlg:advanced_props'] = 'Erweiterte Einstellungen';
$string['table_dlg:advanced_tab'] = 'Erweitert';
$string['table_dlg:align'] = 'Ausrichtung';
$string['table_dlg:align_bottom'] = 'Unten';
$string['table_dlg:align_default'] = 'Standard';
$string['table_dlg:align_left'] = 'Links';
$string['table_dlg:align_middle'] = 'Mittig';
$string['table_dlg:align_right'] = 'Rechts';
$string['table_dlg:align_top'] = 'Oben';
$string['table_dlg:bgcolor'] = 'Hintergrundfarbe';
$string['table_dlg:bgimage'] = 'Hintergrundbild';
$string['table_dlg:border'] = 'Rahmen';
$string['table_dlg:bordercolor'] = 'Rahmenfarbe';
$string['table_dlg:caption'] = 'Beschriftung der Tabelle';
$string['table_dlg:cell_all'] = 'Alle Zellen der Tabelle verändern';
$string['table_dlg:cell_cell'] = 'Diese Zelle verändern';
$string['table_dlg:cell_col'] = 'Alle Zellen in Spalten aktualisieren';
$string['table_dlg:cell_limit'] = 'Sie haben die maximale Zellenzahl von {$cells} überschritten.';
$string['table_dlg:cell_row'] = 'Alle Zellen in dieser Zeile verändern';
$string['table_dlg:cell_title'] = 'Eigenschaften der Zelle';
$string['table_dlg:cell_type'] = 'Zellentyp';
$string['table_dlg:cellpadding'] = 'Abstand innerhalb der Zellen';
$string['table_dlg:cellspacing'] = 'Zellenabstand';
$string['table_dlg:col_limit'] = 'Sie haben die maximale Spaltenzahl von {$cols} überschritten.';
$string['table_dlg:colgroup'] = 'Spalten gruppieren';
$string['table_dlg:cols'] = 'Spalten';
$string['table_dlg:frame'] = 'Rahmen';
$string['table_dlg:frame_all'] = 'zwischen allen Zellen';
$string['table_dlg:frame_cols'] = 'zwischen Spalten';
$string['table_dlg:frame_groups'] = 'zwischen Gruppen';
$string['table_dlg:frame_none'] = 'keine';
$string['table_dlg:frame_rows'] = 'zwischen Zeilen';
$string['table_dlg:general_props'] = 'Allgemeines';
$string['table_dlg:general_tab'] = 'Allgemeines';
$string['table_dlg:height'] = 'Höhe';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Sprachcode';
$string['table_dlg:langdir'] = 'Schriftrichtung';
$string['table_dlg:ltr'] = 'Links nach rechts';
$string['table_dlg:merge_cells_title'] = 'Zellen vereinen';
$string['table_dlg:mime'] = 'MIME-Type';
$string['table_dlg:missing_scope'] = 'Möchten Sie wirklich keine Beschreibung für die Tabellenüberschrift angeben? Ohne Beschreibung könnte es für Nutzer/innen mit Einschränkungen schwierig sein, die Tabelleninhalte zu erfassen.';
$string['table_dlg:row_all'] = 'Alle Zeilen verändern';
$string['table_dlg:row_even'] = 'Gerade Zeilen verändern';
$string['table_dlg:row_limit'] = 'Sie haben die maximale Zeilenzahl von {$rows} überschritten.';
$string['table_dlg:row_odd'] = 'Ungerade Zeilen verändern';
$string['table_dlg:row_row'] = 'Diese Zeile verändern';
$string['table_dlg:row_title'] = 'Eigenschaften der Zeile';
$string['table_dlg:rowgroup'] = 'Zeilen gruppieren';
$string['table_dlg:rows'] = 'Zeilen';
$string['table_dlg:rowtype'] = 'Zeilentyp';
$string['table_dlg:rtl'] = 'Rechts nach links';
$string['table_dlg:rules'] = 'Gitter';
$string['table_dlg:rules_above'] = 'nur oben';
$string['table_dlg:rules_below'] = 'nur unten';
$string['table_dlg:rules_border'] = 'alle 4 Seiten (Border)';
$string['table_dlg:rules_box'] = 'alle 4 Seiten (Box)';
$string['table_dlg:rules_hsides'] = 'oben und unten';
$string['table_dlg:rules_lhs'] = 'nur links';
$string['table_dlg:rules_rhs'] = 'nur rechts';
$string['table_dlg:rules_void'] = 'keins';
$string['table_dlg:rules_vsides'] = 'links und rechts';
$string['table_dlg:scope'] = 'Bezug';
$string['table_dlg:style'] = 'Format';
$string['table_dlg:summary'] = 'Zusammenfassung';
$string['table_dlg:tbody'] = 'Tabelleninhalt';
$string['table_dlg:td'] = 'Textzelle';
$string['table_dlg:tfoot'] = 'Tabellenfuß';
$string['table_dlg:th'] = 'Überschrift';
$string['table_dlg:thead'] = 'Tabellenkopf';
$string['table_dlg:title'] = 'Tabelle einfügen/bearbeiten';
$string['table_dlg:valign'] = 'Vertikale Ausrichtung';
$string['table_dlg:width'] = 'Breite';
$string['template:desc'] = 'Inhalt aus Vorlage einfügen';
$string['template_dlg:cdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'Sonntag,Montag,Dienstag,Mittwoch,Donnerstag,Freitag,Samstag,Sonntag';
$string['template_dlg:day_short'] = 'So,Mo,Di,Mi,Do,Fr,Sa,So';
$string['template_dlg:desc'] = 'Inhalt aus Vorlage einfügen';
$string['template_dlg:desc_label'] = 'Beschreibung';
$string['template_dlg:label'] = 'Vorlage';
$string['template_dlg:mdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Januar,Februar,März,April,Mai,Juni,Juli,August,September,Oktober,November,Dezember';
$string['template_dlg:months_short'] = 'Jan,Feb,März,Apr,Mai,Juni,Juli,Aug,Sept,Okt,Nov,Dez';
$string['template_dlg:preview'] = 'Vorschau';
$string['template_dlg:select'] = 'Vorlage auswählen';
$string['template_dlg:title'] = 'Vorlagen';
$string['template_dlg:warning'] = 'Warnung: Eine Vorlage mit einer anderen zu aktualisieren kann zu Datenverlust führen!';
$string['visualblocks:desc'] = 'Blockelemente anzeigen/verbergen';
$string['visualchars:desc'] = 'Steuerzeichen anzeigen/verbergen';
$string['wordcount:words'] = 'Wörter:';
$string['xhtmlxtras:abbr_delta_height'] = '0';
$string['xhtmlxtras:abbr_delta_width'] = '0';
$string['xhtmlxtras:abbr_desc'] = 'Abkürzung';
$string['xhtmlxtras:acronym_delta_height'] = '0';
$string['xhtmlxtras:acronym_delta_width'] = '0';
$string['xhtmlxtras:acronym_desc'] = 'Akronym';
$string['xhtmlxtras:attribs_delta_height'] = '0';
$string['xhtmlxtras:attribs_delta_width'] = '0';
$string['xhtmlxtras:attribs_desc'] = 'Attribute einfügen/bearbeiten';
$string['xhtmlxtras:cite_delta_height'] = '0';
$string['xhtmlxtras:cite_delta_width'] = '0';
$string['xhtmlxtras:cite_desc'] = 'Quellenangabe';
$string['xhtmlxtras:del_delta_height'] = '0';
$string['xhtmlxtras:del_delta_width'] = '0';
$string['xhtmlxtras:del_desc'] = 'Entfernter Text';
$string['xhtmlxtras:ins_delta_height'] = '0';
$string['xhtmlxtras:ins_delta_width'] = '0';
$string['xhtmlxtras:ins_desc'] = 'Eingefügter Text';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attribute';
$string['xhtmlxtras_dlg:attribs_title'] = 'Attribute einfügen/bearbeiten';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attribute';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Ereignisse';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Tastenkürzel';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Quellenangabe';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasse';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/Zeit';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Sprache';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Schriftrichtung';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Format';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tabindex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titel';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Links nach rechts';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Rechts nach links';
$string['xhtmlxtras_dlg:events_tab'] = 'Ereignisse';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Attribute';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Ereignisse';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Allgemeines';
$string['xhtmlxtras_dlg:general_tab'] = 'Allgemeines';
$string['xhtmlxtras_dlg:insert_date'] = 'Aktuelle Zeit/Datum einfügen';
$string['xhtmlxtras_dlg:option_ltr'] = 'Links nach rechts';
$string['xhtmlxtras_dlg:option_rtl'] = 'Rechts nach links';
$string['xhtmlxtras_dlg:remove'] = 'Entfernen';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Abkürzung';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronym';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Quellenangabe';
$string['xhtmlxtras_dlg:title_del_element'] = 'Entfernter Text';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Eingefügter Text';
