<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'pt_br', version '4.0'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Adicionar bloco';
$string['admintools'] = 'Ferramentas de administração';
$string['all'] = 'Todos';
$string['allcomplete'] = 'Tudo concluído';
$string['allcoursescomplypalette'] = 'Todos os cursos permitem blocos coloridos. Nada para reconfigurar. Certifique-se de salvar as alterações das cores permitidas antes de reconfigurar.';
$string['allowphototiles'] = 'Permitir blocos com imagens';
$string['allowphototiles_desc'] = 'Se ativar esta opção, os professores poderão carregar uma imagem para servir de fundo do bloco. Poderão continuar a usar ícones no mesmo curso. (Se desativada, apenas os ícones de blocos serão permitidos e as configurações das imagens dos blocos que estão abaixo serão ignoradas.)';
$string['allowsubtilesview'] = 'Permitir visualização de sub-blocos';
$string['allowsubtilesview_desc'] = 'Permitir o uso de uma configuração de curso que, se selecionada, dentro de um bloco mostra atividades (exceto rótulos) como sub-blocos, em vez de lista padrão';
$string['alternativelink'] = 'link alternativo';
$string['areyousure'] = 'Tem certeza?';
$string['asfraction'] = 'Mostrar como fração';
$string['aspectratiotootallorwide'] = 'A imagem enviada foi salva, mas verifique, pois pode ser {$a->tallorwide}. Se não lhe parecer correto, ajuste a imagem para as dimensões de paisagem e envie novamente. Por exemplo, 200 largura x 300 altura é suficiente.';
$string['aspercentagedial'] = 'Mostrar como porcentagem (%) em um círculo';
$string['assumedatastoreconsent'] = 'Aceitar e permitir o uso do armazenamento local do navegador';
$string['assumedatastoreconsent_desc'] = 'Se selecionado, <b>não</b> será mostrado uma caixa de diálogo solicitando consentimento do usuário para armazenar dados no armazenamento local do navegador';
$string['backupfailed'] = 'Falha no backup';
$string['basecolour'] = 'Cor dos blocos';
$string['basecolour_help'] = 'A cor definida aqui será aplicada a todas os blocos do curso. (As cores disponíveis são definidas pelo administrador do seu site através da página de configurações do plugin Tiles).';
$string['brandcolour'] = 'Cor da marca';
$string['canceltask'] = 'Cancelar tarefa';
$string['changedcolour'] = 'A cor do bloco foi redefinida para a padrão do curso {$a}';
$string['checkforproblemcourses'] = 'Verificar e corrigir cursos com problemas';
$string['clickiffailstoload'] = 'Clique se a página não carregar';
$string['close'] = 'Fechar';
$string['collapse'] = 'Recolher seção';
$string['collapsesections'] = 'Contrair tudo';
$string['colourblue'] = 'Azul';
$string['colourdarkgreen'] = 'Verde escuro';
$string['colourgreen'] = 'Verde';
$string['colourlightblue'] = 'Azul claro';
$string['colourname_descr'] = 'Nome de exibição para a cor (o nome geralmente não é visto pelos usuários - eles veem uma amostra colorida)';
$string['colournamegeneral'] = 'Nome de exibição da cor acima';
$string['colourpurple'] = 'Roxo';
$string['colourred'] = 'Vermelho';
$string['colours'] = 'Cores';
$string['complete'] = 'Concluído';
$string['complete-n-auto'] = 'Item não concluído. Ele será marcado como concluído quando você cumprir todos os critérios de conclusão. Você não pode mudar isso manualmente.';
$string['complete-y-auto'] = 'Item concluído. Ele foi marcado como concluído quando você cumpriu os critérios de conclusão. Você não pode mudar isso manualmente.';
$string['completion_help'] = 'Um sinal à direita de uma atividade pode ser usado para indicar quando a atividade está completa (caso contrário, um círculo vazio será mostrado).<br><br>
Dependendo da configuração, um sinal pode aparecer automaticamente quando você completar a atividade de acordo com as condições estabelecidas pelo professor.<br><br>
Em outros casos, você pode clicar no círculo vazio quando achar que completou a atividade e ela se transformará em uma marca verde assinalada. (Clicando novamente, remove se você mudar de idéia).';
$string['completionswitchhelp'] = '<p>Você optou por visualizar o acompanhamento de conclusão em cada bloco. Por isso, definimos "Acompanhamento de Conclusão > Habilitado" mais abaixo nesta página para "Sim".</p>
<p>Além disso, você precisa ativar o acompanhamento de conclusão para <b>cada item</b> que você está acompanhando. Por exemplo: para um PDF, clique em "Editar configurações", procure abaixo de "Conclusão da Atividade" e escolha a configuração desejada.</p>
<p>Você também pode fazer isso em <b>massa</b>, conforme explicado na <a href="https://docs.moodle.org/36/en/Activity_completion_settings" target="_blank">explicação detalhada de acompanhamento de conclusão no moodle.org</a></p>';
$string['completionwarning'] = 'Você tem o acompanhamento de conclusão ativado no nível do curso, mas no nível de atividade individual, nenhum item tem o rastreamento ativado, por isso não há nada para rastrear.';
$string['completionwarning_changeinbulk'] = 'Mudança em massa';
$string['completionwarning_help'] = 'Você precisa tornar os itens individuais rastreáveis para editá-los (em Conclusão da Atividade > Acompanhamento de Conclusão) ou você pode fazer isso em massa em Administração do Curso > Conclusão do Curso > Edição em lote de conclusão de atividade';
$string['contact'] = 'Entrar em contato';
$string['contactdeveloper'] = 'Contato do desenvolvedor';
$string['contents'] = 'Conteúdo';
$string['courseshowtileprogress'] = 'Progresso em cada bloco';
$string['courseshowtileprogress_error'] = 'Você tem "Rastreamento de conclusão > Ativar rastreamento de conclusão" definido como "Não" (veja mais abaixo nesta página) que está em conflito com essa configuração. Se você deseja exibir o progresso nos blocos, defina "Rastreamento de conclusão > Ativar rastreamento de conclusão" como "Sim". Caso contrário, defina esta configuração como \'Não\'.';
$string['courseshowtileprogress_help'] = '<p>Quando selecionado, o progresso do usuário com as atividades será mostrado em cada bloco, como uma <em>fração</em> (por exemplo: \'Progresso 2/10\' que significa que 2 de 10 atividades serão concluídas) ou como uma <em> porcentagem</em> em um círculo.</p>
<p>Isso só pode ser usado se "Conclusão > Ativar acompanhamento de conclusão" tiver sido ativado.</p>
<p>Se não houverem atividades à acompanhar dentro de um determinado bloco, o indicador não será exibido para esse bloco.</p>';
$string['coursetoomanysections'] = 'Aviso aos editores: este curso tem mais blocos do que o máximo permitido. Será mostrado aos estudantes o número máximo de {$a->max} blocos, ou seja, (até "{$a->tilename}") (os editores podem ver mais).';
$string['courseusebarforheadings'] = 'Enfatizar títulos com aba colorida';
$string['courseusebarforheadings_help'] = 'Exibe uma aba colorida à esquerda do cabeçalho do curso sempre que um estilo de título é selecionado no editor de texto';
$string['courseusesubtiles'] = 'Utilizar sub-blocos para atividades';
$string['courseusesubtiles_help'] = 'Em cada bloco, mostre todas as atividades como um sub-bloco, em vez de uma lista de atividades ao longo da página. Isso não se aplica a rótulos que não serão mostrados como sub-blocos, portanto, podem ser usados como títulos entre blocos.';
$string['currentsection'] = 'Este bloco';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'CSS personalizado para aplicar ao conteúdo da seção do curso enquanto este formato de curso é usado. Isso não será validado, portanto, tome cuidado para inserir um código válido. Por exemplo:
<p>.section {color: red; }</p>
<p>li.activity.subtile.resource.pdf {background-color: orange! important; }</p>';
$string['datapref'] = 'Preferência dos dados';
$string['datapreferror'] = 'O recurso de preferência dos dados só estará disponível se você tiver o JavaScript disponível e ativado no seu navegador. Caso contrário, o armazenamento de dados não poderá ser habilitado.';
$string['dataprefquestion'] = '<p>Para tornar este site mais fácil de usar, armazenamos informações funcionais em seu navegador, como o conteúdo do último bloco que você abriu. Isso permanecerá em seu dispositivo por um breve período, caso você visite essa página novamente. Não usamos isso para monitoramento. Tudo bem?</p><p>Lembraremos sua escolha até que você limpe seu histórico de navegação. Para cancelar, clique em "Cancelar" (isso pode resultar em um carregamento mais lento da página).</p>';
$string['defaultthiscourse'] = 'Padrão para este curso';
$string['defaulttilecolour'] = 'Cor padrão do bloco';
$string['defaulttileicon'] = 'Ícone do bloco';
$string['defaulttileicon_help'] = 'O ícone selecionado aqui aparecerá em <em>todos os</em> blocos neste curso. Os blocos individuais podem ter um ícone diferente selecionado, usando uma configuração específica a nível de bloco.';
$string['deleteemptytiles'] = 'Excluir blocos vazios';
$string['deleteimage'] = 'Excluir imagem';
$string['deletesection'] = 'Excluir bloco';
$string['deletetile'] = 'Excluir bloco';
$string['developedby'] = '"Tiles" desenvolvido por {$a}';
$string['developer'] = 'Desenvolvedor';
$string['disabledbyadmin'] = 'Desativado pelo administrador do site';
$string['displayfilterbar'] = 'Barra de filtro';
$string['displayfilterbar_error'] = 'A menos que tenha configurado os resultados para este curso, você só pode exibir a barra de filtro com base nos números de blocos e não com base nos resultados. Crie alguns resultados primeiro e depois volte aqui. Veja';
$string['displayfilterbar_help'] = '<p>Quando selecionado, exibirá automaticamente uma matriz de botões antes da tela lado a lado de um curso, na qual os usuários podem clicar para filtrar blocos para determinados intervalos.</p><p>Quando \'com base nos números de blocos\' for selecionado, série de botões será exibida por exemplo um botão para telhas 1-4, um botão para fichas 5-8 etc.</p><p>Quando \'com base nos resultados do curso\' for selecionado, haverá um botão por resultado do curso. Cada bloco pode ser atribuído a um determinado resultado (e, portanto, a um determinado botão) da página de configurações do bloco.</p>';
$string['displaytitle_mod_doc'] = 'Documento do Word';
$string['displaytitle_mod_html'] = 'Página da WEB';
$string['displaytitle_mod_jpeg'] = 'Imagem';
$string['displaytitle_mod_mp3'] = 'Áudio';
$string['displaytitle_mod_mp4'] = 'Vídeo';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Apresentação em Powerpoint';
$string['displaytitle_mod_txt'] = 'Texto plano';
$string['displaytitle_mod_xls'] = 'Planilha';
$string['displaytitle_mod_zip'] = 'Zip';
$string['documentation'] = 'Documentação';
$string['documentationurl'] = 'URL da documentação';
$string['documentationurl_descr'] = 'URL da documentação sobre o formato Blocos.';
$string['download'] = 'Download';
$string['editoradvicesubtiles'] = 'Nesta versão do plugin Tiles, as atividades só aparecerão como sub-blocos se o modo de edição estiver desativado';
$string['editsection'] = 'Editar bloco';
$string['editsectionname'] = 'Editar nome do bloco';
$string['embeddedurlerror'] = 'Se o site externo se recusar a conexão na janela acima, use isto:';
$string['enablelinebreakfilter'] = 'Habilitar filtro de quebra de linha';
$string['enablelinebreakfilter_desc'] = 'Filtrar os títulos dos blocos para que se o caractere de junção de palavras invisível &#8288; estiver presente e o título do título for longo, substituir por - (hífen) para permitir a quebra de linha. Caso contrário, não substituir (ou seja, sem quebra de linha).';
$string['entersection'] = 'Entrar na seção';
$string['existingimage'] = 'Imagem deste bloco';
$string['expand'] = 'Expandir seção';
$string['expandall'] = 'Expandir tudo';
$string['expandsections'] = 'Expandir todas as atividades (todas as seções)';
$string['experimentalfeature'] = 'Funcionalidade experimental';
$string['experimentalsetting'] = '(configuração experimental)';
$string['fileaddedtobottom'] = 'Arquivo adicionado ao final da seção';
$string['filenoshowtext'] = 'Se o arquivo não aparecer aqui, por favor use os botões à direita para baixar ou visualizar em uma nova janela';
$string['filterboth'] = 'Mostrar botões com base nos números de blocos e nos resultados do curso';
$string['filternumbers'] = 'Mostrar botões baseado nos números dos blocos';
$string['filteroutcomes'] = 'Mostrar botões baseado nos resultados do curso';
$string['filteroutcomesrestore'] = 'O curso original utilizava os resultados na barra de filtros, que ainda não são suportados durante o processo de restauração. Por isso, a configuração da barra de filtro foi alterada no curso restaurado. Se você quer utilizar os resultados para filtrar blocos no curso restaurado, configure novamente os resultados da aprendizagem. O curso original não foi alterado.';
$string['fittilestowidth'] = 'Ajustar blocos à largura da tela';
$string['fittilestowidth_desc'] = 'Se ativar esta opção, quando um utilizador acessa um curso através de um dispositivo não móvel, o carregamento dos blocos é atrasado em meio segundo, enquanto é calculada a melhor estrutura. Por exemplo. evitar um bloco por linha, blocos centrados no ecrã. Isto só acontecerá no primeiro acesso ao curso numa determinada sessão e será lembrado durante toda a sessão ou até que o utilizador ajuste o tamanho do ecrã.';
$string['fixproblems'] = 'Problemas corrigidos';
$string['folderdisplayerror'] = 'As pastas configuradas para mostrar o conteúdo online não são compatíveis com o formato de sub-blocos. Por isso, a <a href="{$a}">pasta</a> foi alterada para permitir a exibição numa página separada';
$string['followthemecolour'] = 'Forçar o uso da cor do tema';
$string['followthemecolour_desc'] = 'Se ativar esta opção, os professores não poderão escolher as cores, através desta configuração do plugin, e todas as cores dos blocos configuradas abaixo serão ignoradas. Em vez disso, será feita uma tentativa de obter a cor principal personalizada do tema e utilizá-la';
$string['guidance'] = 'Instruções';
$string['height'] = 'altura';
$string['hidden'] = 'Oculto';
$string['hide'] = 'Ocultar';
$string['hidefromothers'] = 'Ocultar bloco';
$string['highestsectionnum'] = 'Número maior de seção encontrado';
$string['home'] = 'Página inicial do curso';
$string['hovercolour'] = 'Cor do bloco ao passar o mouse';
$string['hovercolour_descr'] = 'Cor dos blocos ao passar o mouse por cima';
$string['icontitle-address-book-o'] = 'Lista de contatos';
$string['icontitle-assessment_graded'] = 'Avaliação A+';
$string['icontitle-assessment_timer'] = 'Temporizador da avaliação';
$string['icontitle-asterisk'] = 'Asterisco';
$string['icontitle-award-solid'] = 'Recompensa';
$string['icontitle-balance-scale'] = 'Escalas equilibradas';
$string['icontitle-bar-chart'] = 'Gráfico de Barras';
$string['icontitle-bell-o'] = 'Sino';
$string['icontitle-binoculars'] = 'Binóculos';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Livro';
$string['icontitle-bookmark-o'] = 'Favoritos';
$string['icontitle-briefcase'] = 'Pasta de documentos';
$string['icontitle-building'] = 'Edifício';
$string['icontitle-bullhorn'] = 'Megafone';
$string['icontitle-bullseye'] = 'Alvo';
$string['icontitle-calculator'] = 'Calculadora';
$string['icontitle-calendar'] = 'Calendário';
$string['icontitle-calendar-check-o'] = 'Marcações no calendário';
$string['icontitle-check'] = 'Verificado';
$string['icontitle-child'] = 'Criança';
$string['icontitle-clock-o'] = 'Relógio';
$string['icontitle-clone'] = 'Clone';
$string['icontitle-cloud-download'] = 'Nuvem (baixar)';
$string['icontitle-cloud-upload'] = 'Nuvem (subir)';
$string['icontitle-comment-o'] = 'Comentário';
$string['icontitle-comments-o'] = 'Comentários';
$string['icontitle-compass'] = 'Bússola';
$string['icontitle-diamond'] = 'Diamante';
$string['icontitle-dollar'] = 'Dólar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Triângulo com exclamação';
$string['icontitle-feed'] = 'Feed';
$string['icontitle-file-text-o'] = 'Arquivo de texto';
$string['icontitle-film'] = 'Filme';
$string['icontitle-flag-checkered'] = 'Bandeira (quadriculada)';
$string['icontitle-flag-o'] = 'Bandeira';
$string['icontitle-flash'] = 'Flash';
$string['icontitle-flask'] = 'Balão de vidro';
$string['icontitle-flipchart'] = 'Tela de apresentação';
$string['icontitle-frown-o'] = 'Triste';
$string['icontitle-gavel'] = 'Martelo do juiz';
$string['icontitle-gbp'] = 'Libra esterlina';
$string['icontitle-globe'] = 'Globo';
$string['icontitle-handshake-o'] = 'Aperto de mãos';
$string['icontitle-headphones'] = 'Fones de ouvido';
$string['icontitle-heartbeat'] = 'Batimento cardiaco';
$string['icontitle-history'] = 'Histórico';
$string['icontitle-home'] = 'Casa';
$string['icontitle-id-card-o'] = 'Cartão de identificação';
$string['icontitle-info'] = 'Informação';
$string['icontitle-jigsaw'] = 'Quebra cabeça';
$string['icontitle-key'] = 'Chave';
$string['icontitle-laptop'] = 'Notebook';
$string['icontitle-life-buoy'] = 'Bóia salva-vida';
$string['icontitle-lightbulb-o'] = 'Lâmpada';
$string['icontitle-line-chart'] = 'Gráfico de linha';
$string['icontitle-list'] = 'Lista (pontos)';
$string['icontitle-list-ol'] = 'Lista (números)';
$string['icontitle-location-arrow'] = 'Seta de localização';
$string['icontitle-map-marker'] = 'Marcador de mapa';
$string['icontitle-map-o'] = 'Mapa';
$string['icontitle-map-signs'] = 'Placas de direção';
$string['icontitle-microphone'] = 'Microfone';
$string['icontitle-mobile-phone'] = 'Celular';
$string['icontitle-mortar-board'] = 'Chapéu de formatura';
$string['icontitle-music'] = 'Música';
$string['icontitle-newspaper-o'] = 'Jornal';
$string['icontitle-number_1'] = 'Número 1';
$string['icontitle-number_10'] = 'Número 10';
$string['icontitle-number_2'] = 'Número 2';
$string['icontitle-number_3'] = 'Número 3';
$string['icontitle-number_4'] = 'Número 4';
$string['icontitle-number_5'] = 'Número 5';
$string['icontitle-number_6'] = 'Número 6';
$string['icontitle-number_7'] = 'Número 7';
$string['icontitle-number_8'] = 'Número 8';
$string['icontitle-number_9'] = 'Número 9';
$string['icontitle-pencil-square-o'] = 'Lápis num quadro';
$string['icontitle-person'] = 'Pessoa';
$string['icontitle-pie-chart'] = 'Gráfico circular';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'Peça de quebra cabeça';
$string['icontitle-question-circle'] = 'Interrogação em círculo';
$string['icontitle-random'] = 'Aleatório';
$string['icontitle-refresh'] = 'Atualizar';
$string['icontitle-road'] = 'Estrada';
$string['icontitle-search'] = 'Lupa';
$string['icontitle-sliders'] = 'Slides';
$string['icontitle-smile-o'] = 'Sorriso';
$string['icontitle-star'] = 'Estrela (preenchida)';
$string['icontitle-star-half-o'] = 'Estrela (semi-preenchida)';
$string['icontitle-star-o'] = 'Estrela (sem sombra)';
$string['icontitle-survey'] = 'Pesquisa';
$string['icontitle-tags'] = 'Tags';
$string['icontitle-tasks'] = 'Tarefas';
$string['icontitle-television'] = 'Televisão';
$string['icontitle-thinking-person'] = 'Pessoa com lâmpada';
$string['icontitle-thumbs-o-down'] = 'Polegar para baixo';
$string['icontitle-thumbs-o-up'] = 'Polegar para cima';
$string['icontitle-trophy'] = 'Troféu';
$string['icontitle-umbrella'] = 'Guarda-chuva';
$string['icontitle-university'] = 'Universidade';
$string['icontitle-user-o'] = 'Usuário';
$string['icontitle-users'] = 'Pessoas';
$string['icontitle-volume-up'] = 'Altofalante';
$string['icontitle-wrench'] = 'Chave inglesa';
$string['imagecannotbeused'] = 'A imagem não pode ser usada';
$string['imagedeletedfrom'] = 'A imagem de "{$a}" foi apagada';
$string['imagesavedfor'] = 'Imagem guardada para o bloco {$a}';
$string['imagesize'] = 'Tamanho da imagem';
$string['items'] = 'itens';
$string['jsactivate'] = 'Ativar navegação animada';
$string['jsdeactivate'] = 'Desativar navegação animada';
$string['jsdeactivated'] = 'Você desativou a navegação animada na sua conta';
$string['jsnavsettings'] = 'Navegação com JavaScript';
$string['jsreactivated'] = 'Você ativou a navegação animada na sua conta. Esta funcionalidade pode resultar numa navegação mais rápida. Requer o JavaScript ativado.';
$string['links'] = 'Hiperligações';
$string['loading'] = 'Carregando';
$string['maxcoursesectionsallowed'] = 'O número máximo de seções do curso permitidas neste ambiente é {$a}.';
$string['modalmodules'] = 'Módulos modais';
$string['modalmodules_desc'] = 'Iniciar esses módulos do curso em uma janela modal. (Outros módulos podem ser adicionados em uma versão posterior.)';
$string['modalresources'] = 'Recursos modais';
$string['modalresources_desc'] = 'Iniciar esses recursos na janela modal. Observação: se permitido aqui, as atividades de URL só serão abertas em uma janela modal se estiverem definidas como {$a->displayembed} no nível de atividade (por exemplo, vídeos do YouTube ou Vimeo). Mesmo assim, eles podem ser impedidos pelo proprietário do site de serem mostrados como incorporados - veja {$a->link}';
$string['modalwindows'] = 'Janelas modais';
$string['newsectionname'] = 'Novo nome para o tópico {$a}';
$string['nexttopic'] = 'Próximo tópico';
$string['noconnectionerror'] = 'Erro ao carregar o conteúdo. Verifique a sua conexão à internet';
$string['nojswarning'] = 'O seu navegador parece não suportar JavaScript ou está desabilitado. Uma interface melhor fica disponível se você ativar o JavaScript';
$string['none'] = 'Nenhum';
$string['noproblemsfound'] = 'Nenhum problema encontrado';
$string['notcomplete'] = 'Não concluído';
$string['notrecommended'] = 'Não recomendado';
$string['notregistered'] = 'Seu plugin Tiles ainda não está registado no site do desenvolvedor do plugin.';
$string['novaliddefaultcolour'] = 'Nenhuma cor válida foi definida para cor predefinida do bloco';
$string['numberofsections'] = 'Número de seções no curso';
$string['ok'] = 'OK';
$string['other'] = 'Outros';
$string['outcomes'] = 'Resultados da aprendizagem';
$string['outcomesunavailable'] = 'Resultados da aprendizagem não disponíveis';
$string['overall'] = 'Global';
$string['overallprogress'] = 'Conclusão da atividade - progresso global';
$string['overallprogressshort'] = 'Progresso global';
$string['photoguidance_desc'] = 'Carregue uma imagem no formato paisagem. A largura deve ser cerca de 1,35 vezes a altura. Por exemplo, 270 de largura x 200 de altura é um bom tamanho. Não é necessário ser exato. (As imagens no formato retrato não coincidirão com a forma do bloco). Imagens grandes serão escaladas e compactadas, se necessário, após o carregamento.';
$string['photolibrary'] = 'Galeria de imagens';
$string['photolibrary_desc'] = 'Imagens carregadas ou usadas recentemente. Para usar uma imagem como fundo de um bloco, clique na imagem pretendida. Para fazer o carregamento de uma nova, use o separador de carregamento acima.';
$string['phototilesaltstyle'] = 'Estilo alternativo da imagem do bloco';
$string['phototilesaltstyle_desc'] = 'Se não ativar esta opção (valor predefinido), os blocos com imagens exibirão o título na parte superior do bloco. O estilo alternativo mostra o título na parte inferior';
$string['phototilesettings'] = 'Imagem do bloco';
$string['phototiletitletransarency'] = 'Transparência do título no bloco com imagem';
$string['phototiletitletransarency_desc'] = 'A sobreposição do título num bloco com imagem pode ter um fundo ligeiramente transparente (30% é o valor predefinido) ou uma cor de fundo sólida (0%)';
$string['phototitletitlelineheight'] = 'Altura da linha do título';
$string['phototitletitlepadding'] = 'Preenchimento da linha vertical do título';
$string['picknewicon'] = 'Escolher novo ícone';
$string['picknewiconphoto'] = 'Escolher novo ícone ou imagem de fundo';
$string['pluginname'] = 'Formato Tiles';
$string['previoustopic'] = 'Tópico anterior';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Se o usuráio desativou a navegação animada com JavaScript.';
$string['privacypolicy'] = 'Politica de privacidade';
$string['problemcourses'] = 'Curso com problemas';
$string['problemcoursesintro'] = 'Os seguintes cursos têm números de seção acima do esperado. Por favor, use os botões abaixo para resolver os problemas.';
$string['progress'] = 'Progresso';
$string['reactivate'] = 'reativar';
$string['register'] = 'Registar';
$string['registeragreeprivacy'] = 'Concordo com a {$a->privacypolicylink} do desenvolvedor do plugin';
$string['registerclicktocomplete'] = 'Clique em OK para concluir o processo';
$string['registeredthanks'] = 'O plugin está registado. Obrigado.';
$string['registeremailno'] = 'Não, eu não pretendo receber qualquer e-mail';
$string['registeremailyes'] = 'Sim, pretendo receber notificações ocasionais de atualizações e outras informações sobre o plugin Tiles';
$string['registerintro1'] = 'Gostaríamos de manter contato! Quando você registra';
$string['registerintro2'] = 'você apoia o futuro desenvolvimento deste plugin';
$string['registerintro3'] = 'você pode receber notificações de atualizações importantes e planos futuros';
$string['registerintro4'] = 'Nós podemos descobrir mais sobre o que você gostaria que este plugin fizesse.';
$string['registerintro5'] = 'Os seus dados serão mantidos em sigilo pelo desenvolvedor, conforme estabelecido na política de privacidade. Obrigado pelo seu apoio!';
$string['registermissingemail'] = 'Por favor, preencha o seu endereço de e-mail (selecionou abaixo a opção "Sim" para receber e-mails)';
$string['registerpickemailpref'] = 'Por favor, selecione a sua preferência de e-mail';
$string['registerpolicyagreedlinktext'] = 'Política de privacidade e contrato de processamento de dados';
$string['registrationdeferred'] = 'Obrigado. Estamos tentando registar o plugin (processo de registo ainda está incompleto).';
$string['reopenlastsection'] = 'Reabrir o último bloco visitado';
$string['reopenlastsection_desc'] = 'Quando ativar esta opção, se um usuário voltar ao curso mais tarde, a última seção que estava aberta será reaberta ao iniciar';
$string['resetallcoursecolours'] = 'Reconfigurar todas as cores';
$string['resetcolours'] = 'Reconfigurar cores';
$string['resetcolours_desc'] = 'Clique no botão acima para reconfigurar a cor dos blocos para todas os cursos que não tenham uma das cores abaixo. Os cursos serão alterados para a cor predefinida do bloco definido abaixo. Pode utilizar esta ferramenta depois de ter alterado a paleta de cores abaixo, mas certifique-se de salvar as alterações das cores abaixo antes de reconfigurar. Tenha cuidado, uma vez que esta ação pode mudar a cor de muitos cursos!';
$string['restorefailed'] = 'Falha na restauração';
$string['restoreincorrectsections'] = 'Erro: não é possível concluir porque o curso de origem contém seções numeradas incorretamente (por exemplo, o número da seção ({$a->sectionnum}) é maior que o máximo permitido ({$a->maxallowed}). Tente excluir seções com números altos.';
$string['restoretoomanysections'] = 'Erro: Não é possível fazer backup ou restaurar porque o número de seções do curso ({$a->numsections}) é maior que o permitido ({$a->maxallowed}). Tente excluir algumas seções.';
$string['revealcontents'] = 'Mostrar conteúdo';
$string['scheduleddeleteemptysections'] = 'A tarefa para excluir seções vazias do curso foi agendada. Por favor, volte mais tarde.';
$string['section0name'] = 'Geral';
$string['sectionerrorstring'] = 'A sua sessão pode ter expirado. Tente atualizar esta página.';
$string['sectionerrortitle'] = 'Erro ao carregar conteúdo';
$string['sectionname'] = 'Bloco';
$string['sectionnumber'] = 'Seção/Número do bloco';
$string['selected'] = 'Selecionado';
$string['setavailabletilecolours'] = 'Cores permitidas para blocos (todo o site)';
$string['settings'] = 'Configurações do formato Tiles';
$string['show'] = 'Mostrar';
$string['showalltiles'] = 'Mostrar todos os blocos';
$string['showfromothers'] = 'Mostrar bloco';
$string['showoverallprogress'] = 'Mostrar indicador de progresso geral';
$string['showoverallprogress_desc'] = 'Mostre o indicador "% de progresso geral" no canto superior direito do curso (o valor mostrado representa a agregação da % concluída de cada bloco, com base na conclusão da atividade e não na conclusão do curso';
$string['showprogresssphototiles_desc'] = 'Se selecionado, o progresso do estudante (por exemplo, Progresso 2/5) será mostrado nos blocos de fotos';
$string['showseczerocoursewide'] = 'Mostrar a seção zero acima de todas as seções';
$string['showseczerocoursewide_desc'] = 'Se ativado, a seção zero (a seção do topo) será mostrada na página inicial do curso e no topo de <b>todas as páginas das seções do curso</b> (ou seja, no topo do conteúdo de cada bloco). Se desativada (recomendado), será mostrada apenas na página inicial do curso';
$string['showseparatewin'] = 'Mostrar arquivo numa janela separada';
$string['sitename'] = 'Nome do site';
$string['snapwarning'] = 'É possível editar o curso no formato blocos utilizando outro tema e, em seguida, mudar para o tema Snap assim que terminar a edição.';
$string['snapwarning_help'] = 'Configurações_Tema#Permitir_temas_usuarios';
$string['subtileszeczerotoggled'] = 'Seção de topo alterna entre o formato de lista e o formato de sub-blocos';
$string['sureresetcolours'] = 'Tem a certeza de que pretende reconfigurar as cores do bloco do curso para os valores do padrão? Isto afetará {$a} cursos';
$string['tilecolourgeneral'] = 'Paleta de cores - cor opcional';
$string['tilecolourgeneral_descr'] = 'Estas configurações permitem que o administrador defina as cores que estarão disponíveis para os professores aplicarem nos cursos. Defina a cor para preto (#000000) para desativar a cor existente. Se alterar as cores aqui, nenhuma alteração será feita nos cursos existentes, até à próxima vez que o professor tente alterar a cor do bloco. Até lá, apenas as cores definidas aqui estarão disponíveis para os professores.';
$string['tilecolourschanged'] = 'As cores dos blocos foram redefinidas. Todos os blocos têm cores em conformidade com as cores abaixo.';
$string['tileicon'] = 'Ícone a mostrar (apenas este bloco)';
$string['tileicon_help'] = 'O item aqui selecionado substituirá, apenas neste bloco, o ícone do bloco definido ao nível de curso';
$string['tileicons'] = 'Ícones dos blocos';
$string['tileoutcome'] = 'Resultados da aprendizagem para este bloco';
$string['tileoutcome_help'] = 'Se selecionar um resultado da aprendizagem para este bloco, poderá mostrar, nas configurações do curso, um conjunto de <em>botões de filtro</em>, um para cada resultado da aprendizagem, que filtram os blocos a mostrar de acordo com o resultado que lhes foi atribuído';
$string['tileselecttip'] = 'Aqui está uma maneira mais fácil de alterar um ícone de bloco ou imagem: no curso, com o modo de edição ativado, basta clicar no ícone ou imagem que deseja alterar. A janela do seletor de ícones irá aparecer.';
$string['tilesformatregistration'] = 'Registo do módulo';
$string['tip'] = 'Ajuda';
$string['togglecompletion'] = 'Clique para alternar o estado da conclusão';
$string['togglecompletioncomplete'] = 'Clique para alternar o status de conclusão (concluído)';
$string['togglecompletionincomplete'] = 'Clique para alternar o status de conclusão (não concluído)';
$string['tootall'] = 'muito alta para o bloco';
$string['toowide'] = 'muito larga para o bloco';
$string['transparenttitleadjustments'] = 'Ajustes da transparência dos títulos';
$string['transparenttitleadjustments_desc'] = 'Em blocos com imagens o fundo do título transparente, dependendo do seu tema, pode ser ajustado para garantir que as linhas transparentes do título não se sobreponham quando se encaixam. Note que estes valores também variam um pouco entre navegadores. Valores sugeridos para o Chrome: temas baseados em Boost e Clean: 30.5 e 4 | Adaptável: 32 e 4 | Moove: 32 e 2 | Remui: 32 e 2,5';
$string['uploadnewphoto'] = 'Carregar nova imagem';
$string['uploadnewphoto_help'] = 'Carregar uma imagem para ser usada neste bloco';
$string['usejavascriptnav'] = 'Usar navegação com JavaScript na página principal do curso';
$string['usejavascriptnav_desc'] = 'Se ativar esta opção, o usuário ao clicar num bloco da página principal da visão global do curso e o Javascript estiver ativo, o JS será usado para fazer a transição para o conteúdo do bloco. O conteúdo do bloco será armazenado localmente no navegador de acordo com as outras configurações abaixo. Se desativada, o JS não será usado e será utilizada a navegação normal. As configurações do JS abaixo serão ignoradas.';
$string['usejseditingexpandcollapse'] = 'Modo de edição - usar JavaScript para expandir/contrair blocos';
$string['usejseditingexpandcollapse_desc'] = 'Se ativar esta opção, no modo de edição, um professor pode expandir e contrair a edição dos blocos com transições animadas. O conteúdo do bloco será carregado como expandido, sem recarregar a página.';
$string['usejsnavforsinglesection'] = 'Usar navegação JS na página de seção única';
$string['usejsnavforsinglesection_desc'] = 'Se ativar esta opção, qualquer chamada para uma página de seção única (&seção=xx) será manipulada com Javascript, iniciando a página principal do curso animada para abrir na seção solicitada via JS, em vez de chamar a página de seção única do PHP no estilo antigo';
$string['usesubtilesseczero'] = 'Usar sub-blocos na seção de topo';
$string['usesubtilesseczero_help'] = 'Se ativar esta opção, os sub-blocos serão usados na seção de topo do curso, bem como em todos os blocos. Uma vez que os sub-blocos ocupam muito espaço no topo do curso, talvez seja melhor não ativar para que todos os itens da seção de topo possam ser mostrados no formato de lista normal.';
$string['usetooltips'] = 'Usar tooltips JavaScript';
$string['usetooltips_desc'] = 'Usar tooltips JavaScript quando o usuário passar o mouse sobre determinados itens, por exemplo, caixas de conclusão, conteúdo de blocos';
$string['version'] = 'Versão {$a}';
$string['width'] = 'largura';
