<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grouptool', language 'lo', version '4.0'.
 *
 * @package     grouptool
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activated_group'] = 'ກຸ່ມທີ່ເປີດໃຊ້ແລ້ວ';
$string['activated_groups'] = 'ກຸ່ມທີ່ເປີດໃຊ້ແລ້ວ!';
$string['active'] = 'ເຄື່ອນໄຫວ';
$string['activegroups'] = 'ກຸ່ມເຄື່ອນໄຫວ';
$string['add_member'] = 'ເພີ່ມ <strong>{$a->username}</strong> ໄປຫາກຸ່ມ <strong>{$a->groupname}</strong>';
$string['added_member'] = 'ໄດ້ເພີ່ມ <strong>{$a->username}</strong> ໄປຫາກຸ່ມ <strong>{$a->groupname}</strong>';
$string['administration'] = 'ການບໍລິຫານ';
$string['administration_alt'] = 'ການສ້າງການຈັດກຸ່ມ ແລະ ການຕັ້ງຄ່າຂອງກຸ່ມທີ່ເຄືອນໄຫວຂອງຕົວຢ່າງນີ້';
$string['agroups'] = 'ກຸ່ມເຄື່ອນໄຫວ';
$string['ajax_edit_size_help'] = 'ບັນທຶກຂະໜາດໃໝ່ກັບ &lt;Enter&gt;, ນຳໃຊ້ &lt;ESC&gt; ເພື່ອຍົກເລີກ, ໃຫ້ຫວ່າງເປົ່າເພື່ອລຶບຂະໜາດແຕ່ລະອັນ';
$string['all_groups_full'] = '<strong>{$a}</strong> ບໍ່ສາມາດລົງທະບຽນໃນກຸ່ມໃດໄດ້ ເພາະວ່າກຸ່ມທັງໝົດເຕັມແລ້ວ!';
$string['allow_multiple'] = 'ການລົງທະບຽນຫຼາຍຄັ້ງ';
$string['allow_multiple_help'] = 'ອະນຸຍາດໃຫ້ນັກຮຽນລົງທະບຽນໃນຫຼາຍກວ່າ 1 ກຸ່ມໃນເວລາດຽວກັນ. ທ່ານຕ້ອງກໍານົດຈໍານວນກຸ່ມທີ່ເຂົາເຈົ້າຕ້ອງເລືອກຢ່າງໜ້ອຍ (= ກຸ່ມຕໍາ່ສຸດທີ່ຕ້ອງເລືອກ) ແລະ ຈໍານວນກຸ່ມທີ່ເຂົາເຈົ້າໄດ້ຖືກອະນຸຍາດໃຫ້ເລືອກສູງສຸດ (= ກຸ່ມສູງສຸດທີ່ຈະເລືອກ).';
$string['allow_reg'] = 'ເປີດໃຊ້ງານການລົງທະບຽນດ້ວຍຕົວເອງ';
$string['allow_reg_help'] = 'ເປີດໃຊ້ການລົງທະບຽນດ້ວຍຕົນເອງສໍາລັບນັກຮຽນ ເພື່ອໃຫ້ພວກເຂົາສາມາດລົງທະບຽນດ້ວຍຕົນເອງໃນກຸ່ມທີ່ມີການເຄື່ອນໄຫວ, ເຊິ່ງຖືກເລືອກຂ້າງລຸ່ມນີ້.';
$string['allow_unreg'] = 'ອະນຸຍາດໃຫ້ຍົກເລີກການລົງທະບຽນ';
$string['allow_unreg_help'] = 'ເປີດໃຊ້ນັກຮຽນເພື່ອຍົກເລີກການລົງທະບຽນ ຫຼືປ່ຽນເປັນກຸ່ມອື່ນກ່ອນ (ທາງເລືອກ) ວັນຄົບກຳນົດ.';
$string['allowed'] = 'ອະນຸຍາດແລ້ວ';
$string['already_marked'] = 'ກຸ່ມນີ້ຖືກໝາຍໃຫ້ລົງທະບຽນແລ້ວ!';
$string['already_member'] = '<strong>{$a->username}</strong> ແມ່ນເປັນສະມາຊິກຢູ້ແລ້ວຂອງກຸ່ມ <strong>{$a->groupname}</strong>';
$string['already_occupied'] = 'ສະຖານທີ່ຢູ່ໃນກຸ່ມ <strong>{$a->grpname}</strong> ຖືກຄອບຄອງຢູ່ກ່ອນແລ້ວ ເພາະວ່າຜູ້ໃຊ້ອື່ນສຳເລັດການລົງທະບຽນໄວຂຶ້ນ. ກະລຸນາຊອກຫາກຸ່ມອື່ນ!';
$string['already_queued'] = '<strong>{$a->username}</strong> ແມ່ນເຂົ້າຄິວຢູ້ແລ້ວໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['already_registered'] = '<strong>{$a->username}</strong> ແມ່ນໄດ້ລົງທະບຽນຢູ່ແລ້ວໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['alwaysshowdescription'] = 'ສະແດງຄຳອະທິບາຍສະເໝີ';
$string['alwaysshowdescription_help'] = 'ຖ້າປິດໃຊ້ງານ, ລາຍລະອຽດເຄື່ອງມືກຸ່ມ (grouptool) ຂ້າງເທິງຈະເຫັນໄດ້ສະເພາະກັບນັກຮຽນໃນວັນທີ "ເລີ່ມຕົ້ນການລົງທະບຽນ" ເທົ່ານັ້ນ.';
$string['asterisk_marks_moodle_registrations'] = 'ຜູ້ໃຊ້ທີ່ມີເຄື່ອງໝາຍດາວນຳໜ້າ (*) ແມ່ນໄດ້ລົງທະບຽນຢູ່ໃນກຸ່ມ Moodle-Group ແລ້ວ';
$string['availabledate'] = 'ເລີ່ມການລົງທະບຽນ';
$string['availabledate_help'] = 'ເລີ່ມຕົ້ນໄລຍະເວລາລົງທະບຽນ. ຫຼັງຈາກວັນທີນີ້ ນັກຮຽນສາມາດລົງທະບຽນດ້ວຍຕົນເອງໃນກຸ່ມທີ່ເລືອກ (ຖ້າເປີດໃຊ້).';
$string['availabledateno'] = 'ມີໃຫ້ສະເໝີ';
$string['cant_enrol'] = 'ບໍ່ສາມາດລົງທະບຽນເຂົ້າຮຽນຜູ້ໃຊ້ອັດຕະໂນມັດໃນລາຍວິຊາ.';
$string['cfg_addinstanceset_head'] = 'ການຕັ້ງຄ່າຕົວຢ່າງເພີ່ມເຕີມ';
$string['cfg_addinstanceset_head_info'] = 'ການຕັ້ງຄ່າເພີ່ມເຕີມສຳລັບເຄື່ອງມືກຸ່ມ (grouptool).';
$string['cfg_admin_head'] = 'ການຕັ້ງຄ່າມາດຕະຖານໃນການບໍລິຫານມຸມມອງ';
$string['cfg_admin_head_info'] = 'ການຕັ້ງຄ່າມາດຕະຖານສໍາລັບແຖບການບໍລິຫານໃນການເບິ່ງເຄື່ອງມືກຸ່ມ (grouptool-view).';
$string['cfg_allow_multiple'] = 'ການລົງທະບຽນຫຼາຍຄັ້ງ';
$string['cfg_allow_multiple_desc'] = 'ອະນຸຍາດໃຫ້ນັກຮຽນລົງທະບຽນຢູ່ໃນຫຼາຍກວ່າ 1 ກຸ່ມໃນເວລາດຽວກັນໂດຍຄ່າເລີ່ມຕົ້ນ.';
$string['cfg_allow_reg'] = 'ອະນຸຍາດການລົງທະບຽນດ້ວຍຕົວເອງ';
$string['cfg_allow_reg_desc'] = 'ເຮັດໃຫ້ນັກຮຽນລົງທະບຽນດ້ວຍຕົນເອງຕາມຄ່າເລີ່ມຕົ້ນ';
$string['cfg_allow_unreg'] = 'ອະນຸຍາດໃຫ້ຍົກເລີກການລົງທະບຽນ';
$string['cfg_allow_unreg_desc'] = 'ຜູ້ໃຊ້ສາມາດຍົກເລີກການລົງທະບຽນຕົນເອງ ແລະ ປ່ຽນກຸ່ມໄດ້ຫຼືບໍ?';
$string['cfg_choose_max'] = 'ເລືອກສູງສຸດ';
$string['cfg_choose_max_desc'] = 'ຜູ້ໃຊ້ຄວນມີຈັກກຸ່ມທີ່ສາມາດລົງທະບຽນໃນເວລາດຽວກັນໂດຍຄ່າເລີ່ມຕົ້ນ?';
$string['cfg_choose_min'] = 'ເລືອກຕ່ຳສຸດ';
$string['cfg_choose_min_desc'] = 'ຜູ້ໃຊ້ມີຈັກກຸ່ມທີ່ຈະເລືອກຂັ້ນຕໍ່າຕາມຄ່າເລີ່ມຕົ້ນ?';
$string['cfg_force_dereg'] = 'ບັງຄັບໃຫ້ຍົກເລີກການລົງທະບຽນໃນເຄື່ອງມືກຸ່ມ (grouptool)';
$string['cfg_force_dereg_desc'] = 'ບັງຄັບໃຫ້ຍົກເລີກການລົງທະບຽນບໍ່ພຽງແຕ່ຈາກເຄື່ອງມືກຸ່ມ (grouptool) ແຕ່ຍັງມາຈາກກຸ່ມ moodle-group.';
$string['cfg_force_importreg'] = 'ບັງຄັບໃຫ້ຍົກເລີກການລົງທະບຽນໃນເຄື່ອງມືກຸ່ມ (grouptool)';
$string['cfg_force_importreg_desc'] = 'ບັງຄັບຜ່ານເຄື່ອງມືກຸ່ມ (grouptool) ໃນກຸ່ມ moodle-group ຜູ້ໃຊ້ທີ່ນໍາເຂົ້າໃຫ້ຖືກບັງຄັບໃຫ້ລົງທະບຽນຢູ່ໃນຕົວຢ່າງຂອງ grouptool ນັ້ນ.';
$string['cfg_groups_queues_limit'] = 'ຄິວສະຖານທີ່ຕໍ່ກຸ່ມ';
$string['cfg_groups_queues_limit_desc'] = 'ກຳນົດຈຳນວນນັກຮຽນທີ່ແຕກຕ່າງກັນສາມາດເຂົ້າຄິວໃນກຸ່ມໃນເວລາດຽວກັນໂດຍຄ່າເລີ່ມຕົ້ນ.';
$string['cfg_grpsize'] = 'ຂະໜາດກຸ່ມມາດຕະຖານທົ່ວໂລກ';
$string['cfg_grpsize_desc'] = 'ຂະໜາດກຸ່ມມາດຕະຖານທີ່ໃຊ້ຢູ່ທົ່ວທຸກແຫ່ງໃນເຄື່ອງມືກຸ່ມ (grouptool)';
$string['cfg_ifgroupdeleted'] = 'ຖ້າກຸ່ມຖືກລຶບ';
$string['cfg_ifgroupdeleted_desc'] = 'ກຸ່ມທີ່ຖືກລຶບຄວນຈະຖືກສ້າງຄືນໃໝ່ສໍາລັບຕົວຢ່າງເຄື່ອງມືກຸ່ມ (grouptool-instance) ຫຼື ຄວນການອ້າງອີງໃນເຄື່ອງມືກຸ່ມ (grouptool) (ລວມທັງຂໍ້ມູນກຸ່ມ, ການລົງທະບຽນ ແລະ ຄິວ) ຈະຖືກລຶບບໍ? ໝາຍເຫດ: ຖ້າຫາກວ່າທ່ານເລືອກ "ສ້າງກຸ່ມຄືນໃໝ່", ຫຼັງຈາກນັ້ນກຸ່ມຈະໄດ້ຮັບການ ສ້າງຄືນໃໝ່ອັດຕະໂນມັດຫຼັງຈາກການລົບພາຍໃຕ້ "ການບໍລິຫານວິຊາ / ຜູ້ໃຊ້ / ກຸ່ມ".';
$string['cfg_ifmemberadded'] = 'ຖ້າສະມາຊິກກຸ່ມປືກເພີ່ມ';
$string['cfg_ifmemberadded_desc'] = 'ສະມາຊິກກຸ່ມໃຫມ່ທີ່ເພີ່ມຜ່ານ moodle ຄວນລົງທະບຽນຢູ່ໃນເຄື່ອງມືກຸ່ມ (grouptool) ຫຼື ຖືກລະເລີຍບໍ?';
$string['cfg_ifmemberremoved'] = 'ຖ້າສະມາຊິກກຸ່ມຖືກລຶບ';
$string['cfg_ifmemberremoved_desc'] = 'ການລົງທະບຽນເຄື່ອງມືກຸ່ມ (grouptool) ຄວນຖືກລຶບຖ້າຜູ້ໃຊ້ຖືກລຶບອອກຈາກກຸ່ມ moodle ທີ່ສອດຄ້ອງກັນບໍ?';
$string['cfg_immediate_reg'] = 'ການລົງທະບຽນທັນທີ';
$string['cfg_immediate_reg_desc'] = 'ທຸກໆການລົງທະບຽນຄວນຈະຜ່ານໄປຫາກຸ່ມ moodle ບໍ?';
$string['cfg_importfields'] = 'ສົມທຽບຊ່ອງຂໍ້ມູນສຳລັບນຳເຂົ້າ/ ຍົກເລີກການລົງທະບຽນ';
$string['cfg_importfields_desc'] = 'ກຳນົດຊ່ອງຂໍ້ມູນໃດໜຶ່ງໃນຕາຕະລາງຜູ້ໃຊ້ທີ່ຈະຖືກປຽບທຽບກັບຂໍ້ມູນໃນເວລານຳເຂົ້າ/ຍົກເລີກການລົງທະບຽນຜູ້ໃຊ້. ຊ່ອງຂໍ້ມູນຖືກຄົ້ນຫາເທື່ອລະອັນຈົນກວ່າຈະພົບເຫັນການຈັບຄູ່ທີ່ເປັນເອກະລັກ. ຄ່າທີ່ເປັນໄປໄດ້/ທີ່ເປັນປະໂຫຍດແມ່ນຕົວຢ່າງ: ຊື່ຜູ້ໃຊ້, ໝາຍເລກປະຈໍາຕົວ, ອີເມລ. ເຊີນຊາບ: ບໍ່ມີການກວດສອບຊື່ຊ່ອງທີ່ຖືກຕ້ອງ. ຕົວອັກສອນທີ່ອະນຸຍາດ: a-z, A-Z ແລະ \',\'';
$string['cfg_instance_head'] = 'ການຕັ້ງຄ່າຕົວຢ່າງມາດຕະຖານ';
$string['cfg_instance_head_info'] = 'ການຕັ້ງຄ່າເລີ່ມຕົ້ນສໍາລັບຕົວຢ່າງເຄື່ອງມືກຸ່ມ (grouptool) ໃໝ່.';
$string['cfg_max_queues'] = 'ສູງສຸດ. ສະຖານທີ່ຄິວພ້ອມໆກັນຕໍ່ຜູ້ເຂົ້າຮ່ວມ';
$string['cfg_max_queues_desc'] = 'ກໍານົດໃນຈໍານວນກຸ່ມທີ່ແຕກຕ່າງກັນທີ່ຜູ້ໃຊ້ສາມາດຖືກຈັດຄິວໃນເວລາດຽວກັນໂດຍຄ່າເລີ່ມຕົ້ນ.';
$string['cfg_moodlesync_head'] = 'ພຶດຕິກຳການເຊື່ອມປະສານ';
$string['cfg_moodlesync_head_info'] = 'ເຄື່ອງມືກຸ່ມ (grouptools) ຄວນປະຕິບັດແນວໃດຖ້າສະມາຊິກກຸ່ມ moodle ຖືກເພີ່ມ/ລຶບ ຫຼື ກຸ່ມດຽວຖືກລຶບ';
$string['cfg_name_scheme'] = 'ໂຄງການຊື່ມາດຕະຖານ';
$string['cfg_name_scheme_desc'] = 'ໂຄງການຊື່ມາດຕະຖານທີ່ໃຊ້ສໍາລັບການສ້າງກຸ່ມ';
$string['cfg_show_members'] = 'ສະແດງສະມາຊິກກຸ່ມ';
$string['cfg_show_members_desc'] = 'ກໍານົດວ່າສະມາຊິກກຸ່ມຄວນຈະເຫັນໄດ້ໂດຍຄ່າເລີ່ມຕົ້ນ';
$string['cfg_use_individual'] = 'ນຳໃຊ້ຂະໜາດສ່ວນຕົວ';
$string['cfg_use_individual_desc'] = 'ຖ້າຫາກວ່າຂະຫນາດກຸ່ມແຕ່ລະຄົນສໍາລັບແຕ່ລະກຸ່ມຄວນຈະໄດ້ຮັບການນໍາໃຊ້ເປັນຄ່າເລີ່ມຕົ້ນ';
$string['cfg_use_queue'] = 'ນຳໃຊ້ການຈັດຄິວ';
$string['cfg_use_queue_desc'] = 'ຖ້າການລົງທະບຽນຈັດຄິວຢູ່ໃນກຸ່ມເຕັມຄວນຈະຖືກນໍາໃຊ້ໂດຍຄ່າເລີ່ມຕົ້ນ.';
$string['cfg_use_size'] = 'ນຳໃຊ້ຂະໜາດກຸ່ມ';
$string['cfg_use_size_desc'] = 'ຖ້າຂະໜາດກຸ່ມຄວາມຖືກຈຳກັດໂດຍຄ່າມາດຕະຖານ';
$string['cfg_users_queues_limit'] = 'ສະຖານທີ່ຄິວຕໍ່ຜູ້ໃຊ້';
$string['cfg_users_queues_limit_desc'] = 'ກໍານົດໃນຈໍານວນກຸ່ມທີ່ແຕກຕ່າງກັນທີ່ຜູ້ໃຊ້ສາມາດຖືກຈັດຄິວໃນເວລາດຽວກັນໂດຍຄ່າເລີ່ມຕົ້ນ.';
$string['change_group'] = 'ປ່ຽນແປງກຸ່ມ';
$string['change_group_to'] = 'ສືບຕໍ່ກັບການປ່ຽນແປງກຸ່ມໄປຫາ <strong>{$a->groupname}</strong>ບໍ?';
$string['change_group_to_success'] = 'ປ່ຽນແປງກຸ່ມຢ່າງສຳເລັດ! <strong>{$a->username}</strong> ແມ່ນດຽວນີ້ໄດ້ລົງທະບຽນໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['changes_saved'] = 'ບັນທຶກການປ່ຽນແປງແລ້ວ';
$string['checkbox_control_header'] = 'ບໍ່ເລືອກ/ເລືອກກຸ່ມ ແລະ ການຈັດກຸ່ມ';
$string['checkbox_control_header_help'] = '<p>ໂດຍການນໍາໃຊ້ໜ້າທີ່ນີ້ທ່ານສາມາດເປີດ/ປິດໃຊ້ງານ ກຸ່ມຂອງໜຶ່ງ ຫຼື ຫຼາຍກຸ່ມພາຍໃນ ເຄື່ອງມືກຸ່ມ (grouptool) ຂອງທ່ານ:
     <ol>
         <li>ເລືອກໃນຊ່ອງເລືອກຫຼາຍອັນ "ທັງໝົດ" (ກຸ່ມທີ່ມີຢູ່ທັງໝົດຈະຖືກເປີດໃຊ້/ປິດໃຊ້ງານ), ການຈັດກຸ່ມດຽວ ຫຼື ຫຼາຍກຸ່ມ (ໂດຍການສະຫຼັບໄປເລືອກຫຼາຍອັນໂດຍໃຊ້ສັນຍາລັກນ້ອຍໆທີ່ຢູ່ຂ້າງມັນ ແລະ ໃຊ້ Ctrl + Click).</ li>
         <li>ໃຊ້ໜຶ່ງໃນຕົວເລືອກຕໍ່ໄປນີ້ "ເລືອກ/ບໍ່ເລືອກ/ປ່ຽນ":
             <ul>
                 <li><b>ເລືອກ:</b> ກຸ່ມຂອງກຸ່ມທີ່ເລືອກຈະຖືກເປີດໃຊ້ງານ.</li>
                 <li><b>ບໍ່ເລືອກ:</b> ກຸ່ມຂອງກຸ່ມທີ່ເລືອກຈະຖືກປິດໃຊ້ງານ </li>
                 <li><b>ປີ້ນ:</b> ກຸ່ມທັງໝົດຂອງກຸ່ມທີ່ບໍ່ເລືອກຈະຖືກເປີດໃຊ້ງານ. </li>
             </ul>
         </li>
         <li>ສົມມຸດການເລືອກຂອງທ່ານໂດຍການຄລິກໃສ່ປຸ່ມ "ໄປ".</li>
     </ol>
</p>';
$string['choose'] = 'ເລືອກ...';
$string['choose_group'] = 'ທ່ານຕ້ອງເລືອກກຸ່ມເປົ້າໝາຍ!';
$string['choose_max'] = 'ກຸ່ມສູງສຸດເພື່ອເລືອກ';
$string['choose_max_text'] = 'ທ່ານບໍ່ອະນຸຍາດໃຫ້ເລືອກກຸ່ມ <strong>{$a}</strong> ເປັນສ່ວນໃຫຍ່!';
$string['choose_min'] = 'ກຸ່ມນ້ອຍສຸດທີ່ຈະເລືອກ';
$string['choose_min_max_text'] = 'ທ່ານຕ້ອງເລືອກລະຫວ່າງ <strong>{$a->min}</strong> ແລະ <strong>{$a->max}</strong> ກຸ່ມ!';
$string['choose_min_text'] = 'ທ່ານຕ້ອງເລືອກຢ່າງໜ້ອຍ <strong>{$a}</strong> group(s)!';
$string['choose_minmax_title'] = 'ກຸ່ມທີ່ຈະເລືອກ';
$string['choose_targetgroup_import'] = 'ນຳເຂົ້າເຂົ້າໃນກຸ່ມ';
$string['choose_targetgroup_unregister'] = 'ຍົກເລີກລົງທະບຽນຈາກກຸ່ມ';
$string['chooseactivity'] = 'ທ່ານຕ້ອງເລືອກກິດຈະກຳກ່ອນຂໍ້ມູນຈະຖືກສະແດງ!';
$string['condition_prevent_access'] = 'ເງື່ອນໄຂໃນປະຈຸບັນປ້ອງກັນບໍ່ໃຫ້ທ່ານເຂົ້າເຖິງຕົວຢ່າງເຄື່ອງມືກຸ່ມ (grouptool)!';
$string['confirm_delete'] = 'ທ່ານກຳລັງຈະລຶບກຸ່ມທັງໝົດ. ສິ່ງນີ້ຈະເປັນການລຶບສະມາຊິກທັງໝົດອອກຈາກກຸ່ມນີ້ທີ່ບໍ່ສາມາດກູ້ຄືນໄດ້. ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການສືບຕໍ່?';
$string['confirm_delete_title'] = 'ທ່ານຕ້ອງການທີ່ຈະລຶບອົງປະກອບນີ້ແທ້ບໍ?';
$string['copied_grade_feedback'] = 'ການໃຫ້ຄະແນນກຸ່ມ<br />
+ການສົ່ງຈາກ: <strong>{$a->student}</strong><br />
+ໃຫ້ຄະແນນໂດຍ: <strong>{$a->teacher}</strong><br />
+ວັນທີ/ເວລາເດີມ: <strong>{$a->date}</strong><br />
+ຄຳຕິຊົມ: <strong>{$a->feedback}</strong>';
$string['copy'] = 'ສຳເນົາ';
$string['copy_chosen'] = 'ສຳເນົາທີ່ເລືອກ';
$string['copy_grade_confirm'] = 'ສືບຕໍ່ການສຳເນົາຄະແນນນີ້ຫຼືບໍ?';
$string['copy_grade_overwrite_confirm'] = 'ສືບຕໍ່ການສຳເນົາຄະແນນນີ້ຫຼືບໍ? ຄະແນນກ່ອນໜ້າທີ່ມີຢູ່ຈະຖືກຂຽນທັບ!';
$string['copy_grades_confirm'] = 'ສືບຕໍ່ການສຳເນົາຄະແນນເຫຼົ່ານີ້ຫຼືບໍ?';
$string['copy_grades_errors'] = 'ຢ່າງໜ້ອຍເກີດມີຂໍ້ຜິດພາດໃນລະຫວ່າງການສຳເນົາຄະແນນ:';
$string['copy_grades_overwrite_confirm'] = 'ສືບຕໍ່ສຳເນົາຄະແນນເຫຼົ່ານີ້ບໍ? ຄະແນນກ່ອນໜ້າທີ່ມີຢູ່ຈະຖືກຂຽນທັບ!';
$string['copy_grades_success'] = 'ຄະແນນຕໍ່ໄປນີ້ທີ່ສໍາເລັດການປັບປຸງ:';
$string['copy_refgrades_feedback'] = 'ສຳເນົາຄະແນນອ້າງອີງ ແລະ ຄຳຕິຊົມສຳລັບກຸ່ມທີ່ເລືອກສະມາຊິກກຸ່ມອື່ນ';
$string['copygrade'] = 'ສຳເນົາຄະແນນ';
$string['could_not_add'] = 'ບໍ່ສາມາດເພີ່ມ <strong>{$a->username}</strong> ໄປຫາກຸ່ມ <strong>{$a->groupname}</strong>';
$string['couldnt_move_down'] = 'ບໍ່ສາມາດຍ້າຍກຸ່ມລົງ!';
$string['couldnt_move_up'] = 'ບໍ່ສາມາດຍ້າຍກຸ່ມຂື້ນ!';
$string['createGroups'] = 'ສ້າງກຸ່ມ';
$string['create_1_person_groups'] = 'ສ້າງກຸ່ມ 1 ຄົນ';
$string['create_1_person_groups_help'] = 'ສ້າງກຸ່ມ 1 ຄົນ - ທີ່ນີ້ກຸ່ມສໍາລັບຜູ້ໃຊ້ທີ່ເລືອກແຕ່ລະຄົນຖືກສ້າງຂື້ນ. ນອກຈາກ # ແລະ @ ທ່ານສາມາດນໍາໃຊ້ແທັກຕໍ່ໄປນີ້ ເຊິ່ງຈະຖືກແທນທີ່ດ້ວຍຂໍ້ມູນຜູ້ໃຊ້:
<ul>
<li>[username] - ຊື່ຜູ້ໃຊ້ຂອງຜູ້ໃຊ້</li>
<li>[firstname] - ຊື່ຜູ້ໃຊ້</li>
<li>[lastname] - ນາມສະກຸນຂອງຜູ້ໃຊ້</li>
<li>[idnumber] - ໝາຍເລກປະຈຳຕົວຂອງຜູ້ໃຊ້</li>
</ul>
ຖ້າຂໍ້ມູນບາງຢ່າງຂາດຫາຍໄປ, ແທັກຈະຖືກແທນທີ່ດ້ວຍ tagnameXX ທີ່ XX ຫຍໍ້ມາຈາກຕົວເລກຂອງກຸ່ມ.';
$string['create_assign_groupings'] = 'ສ້າງ/ມອບໝາຍການຈັດກຸ່ມ';
$string['create_fromto_groups'] = 'ສ້າງກຸ່ມທີ່ມີຕົວເລກຈາກໄລຍະຫ່າງ (ເຊັ່ນ: ຈາກ 34 ຫາ 89), <strong>ໂດຍບໍ່ມີການຈັດສັນອັດຕະໂນມັດ</strong> ຂອງສະມາຊິກກຸ່ມ';
$string['create_fromto_groups_help'] = 'ສ້າງກຸ່ມທີ່ມີຕົວເລກຈາກໄລຍະຫ່າງ (ເຊັ່ນ: ຈາກ 34 ຫາ 89) - ໃຊ້ໂໝດນີ້ເພື່ອສ້າງ (ຂາດ) ກຸ່ມ (ເຊັ່ນ: ກຸ່ມ 4, ກຸ່ມ 5, ກຸ່ມ 6). ພຽງແຕ່ໃສ່ຂໍ້ຈໍາກັດ ແລະ ຈໍານວນຕົວເລກທີ່ທ່ານຕ້ອງການໃຊ້ຢ່າງໜ້ອຍສໍາລັບຊື່ (ເຊັ່ນ: 1, 01, 001, 0001...). ມັນເປັນໄປໄດ້ທີ່ຈະກໍານົດຂະໜາດກຸ່ມທີ່ແນ່ນອນດ້ວຍ "ຈໍານວນສະມາຊິກກຸ່ມ M". ຈະ <strong>ບໍ່ມີການຈັດສັນອັດຕະໂນມັດ</strong> ຂອງສະມາຊິກກຸ່ມ.';
$string['create_groupings_confirm'] = 'ສືບຕໍ່ການຈັດກຸ່ມເປັນຕົວຢ່າງແລ້ວຂ້າງເທິງຫຼືບໍ?';
$string['create_groupings_confirm_problem'] = 'ຢ່າງໜ້ອຍເກີດມີ 1 ຂໍ້ຜິດພາດ (ໃຫ້ເບິ່ງຕົວຢ່າງຂ້າງເທິງ)!';
$string['create_groups_confirm'] = 'ສືບຕໍ່ສ້າງກຸ່ມຕາມທີ່ສະແດງຢູ່ຂ້າງເທິງບໍ?';
$string['create_groups_confirm_problem'] = 'ເມື່ອພະຍາຍາມສ້າງກຸ່ມໃໝ່ໂດຍອີງໃສ່ຂໍ້ຂັດແຍ່ງຂອງ schema ຊື່ທີ່ໃຫ້ມາແມ່ນພົບ - ເບິ່ງຕົວຢ່າງ - ກຸ່ມ Moodle ຕ້ອງມີຊື່ທີ່ເປັນເອກະລັກ. ຂໍ້ຂັດແຍ່ງສາມາດເປັນຍ້ອນກຸ່ມທີ່ມີຢູ່ແລ້ວ ທີ່ມີຊື່ດຽວກັນ ຫຼື ວະກະຍາສໍາພັນຜິດພາດໃນລະບົບການຕັ້ງຊື່ (... ຕົວຢ່າງ: ຫວ່າງເປົ່າ, ຂາດ # ສັນຍາລັກ).';
$string['create_n_m_groups'] = 'ສ້າງກຸ່ມ N ສໍາລັບສະມາຊິກ M, <strong>ໂດຍບໍ່ມີການຈັດສັນອັດຕະໂນມັດ</strong> ຂອງສະມາຊິກກຸ່ມ';
$string['create_n_m_groups_help'] = 'ສ້າງກຸ່ມ N ສໍາລັບສະມາຊິກ M - ສ້າງດ້ວຍໂມດູນນີ້ ຈໍານວນກຸ່ມສະເພາະ (ກຸ່ມ N) ທີ່ມີກຸ່ມຂະໜາດສະເພາະ (ສະມາຊິກ M), ຕົວຢ່າງ: ເຈັດກຸ່ມທີ່ມີພື້ນທີ່ສໍາລັບສາມສະມາຊິກແຕ່ລະຄົນ. ຈະ<strong>ບໍ່ມີການຈັດສັນອັດຕະໂນມັດ</strong> ຂອງສະມາຊິກກຸ່ມ.';
$string['createinsertgrouping'] = 'ເພີ່ມໃສ່ການຈັດກຸ່ມ';
$string['deactivated_group'] = 'ປິດໃຊ້ງານກຸ່ມແລ້ວ';
$string['deactivated_groups'] = 'ປິດໃຊ້ງານກຸ່ມແລ້ວ!';
$string['define_amount_groups'] = 'ກຳນົດຈຳນວນຂອງກຸ່ມ N';
$string['define_amount_groups_help'] = 'ກໍານົດຈໍານວນຂອງກຸ່ມ N - ທ່ານເລືອກເອົາຜູ້ໃຊ້ຈາກບົດບາດທີ່ຈະນໍາໃຊ້ສໍາລັບການສ້າງກຸ່ມ ແລະ ໃສ່ຈໍານວນທີ່ຕ້ອງການຂອງກຸ່ມໃນພາກສະໜາມຂໍ້ຄວາມກຸ່ມ / ສະມາຊິກນັບ. ໃນລະບົບຊື່ທ່ານສາມາດໃສ່ໂຄງການຊື່ສໍາລັບກຸ່ມທີ່ໃຊ້
<ul>
<li># (ຈະຖືກແທນທີ່ດ້ວຍໝາຍເລກກຸ່ມ) ແລະ</li>
<li>@ (ຈະຖືກແທນທີ່ດ້ວຍຕົວອັກສອນທີ່ເປັນຕົວແທນຂອງໝາຍເລກກຸ່ມ)</li>
</ul>
ຫຼັງຈາກນັ້ນ, ຜູ້ໃຊ້ທີ່ເລືອກໄດ້ຮັບການແຜ່ຂະຫຍາຍໃນຈໍານວນທີ່ຕ້ອງການຂອງກຸ່ມ.';
$string['define_amount_members'] = 'ກຳນົດຈຳນວນຂອງສະມາຊິກກຸ່ມ N';
$string['define_amount_members_help'] = 'ກໍານົດຈໍານວນຂອງສະມາຊິກກຸ່ມ M - ໃນທີ່ນີ້ທ່ານບອກເຄື່ອງມືກຸ່ມ (grouptool) ຈໍານວນຂອງສະມາຊິກແຕ່ລະກຸ່ມທີ່ເໝາະສົມຄວນຈະມີ. ຈໍານວນທີ່ຕ້ອງການຂອງກຸ່ມ ຈະຖືກຄິດໄລ່ໂດຍອັດຕະໂນມັດ. ຖ້າທ່ານກວດສອບການປ້ອງກັນບໍ່ໃຫ້ກຸ່ມນ້ອຍສຸດທ້າຍ, ຜູ້ໃຊ້ໃນກຸ່ມນີ້ໄດ້ຮັບການແຜ່ຂະຫຍາຍໄປຫາຄົນອື່ນຖ້າອັດຕາສ່ວນການຕື່ມຂໍ້ມູນຂອງກຸ່ມສຸດທ້າຍແມ່ນຕໍ່າກວ່າ 70%.';
$string['delete_reference'] = 'ລຶບຈາກເຄື່ອງມືກຸ່ມ (grouptool)';
$string['description'] = 'ຄຳອະທິບາຍ';
$string['deselect'] = 'ຍົກເລີກການເລືອກ';
$string['determinismerror'] = 'ສິ້ນສຸດການລົງທະບຽນບໍ່ສາມາດຢູ່ກ່ອນການລົງທະບຽນເລີ່ມຕົ້ນ ຫຼື ໃນອະດີດ.';
$string['digits'] = 'ຕົວເລກຕ່ຳສຸດທີ່';
$string['disabled'] = 'ປິດໃຊ້ງານແລ້ວ';
$string['drag'] = 'ຍ້າຍ';
$string['due'] = 'ເຄື່ອງມືກຸ່ມ (grouptool) ຄົບກຳນົດ';
$string['duedate'] = 'ສິ້ນສຸດການລົງທະບຽນ';
$string['duedate_help'] = 'ສິ້ນສຸດໄລຍະເວລາລົງທະບຽນ. ຫຼັງຈາກວັນທີນີ້ ນັກຮຽນບໍ່ສາມາດລົງທະບຽນຕົນເອງໄດ້ອີກຕໍ່ໄປ ແລະ ຄູສອນຈະເຂົ້າເຖິງການແກ້ໄຂ-ການຈັດຄິວ-ການໃຊ້ງານ, ແລະອື່ນໆ.';
$string['duedateno'] = 'ບໍມີວັນຄົບກຳນົດ';
$string['early'] = '{$a} ກ່ອນໜ້າ';
$string['error_activating_group'] = 'ຜິດພາດໃນຂະນະທີ່ເປີດໃຊ້ກຸ່ມ <strong>{$a->groupid}</strong> ໃນກຸ່ມເຄື່ອງມື (grouptool) <strong>{$a->grouptoolid}</strong>!';
$string['error_at'] = 'ຂໍ້ຜິດພາດທີ່';
$string['error_deactivating_group'] = 'ຜິດພາດໃນຂະນະທີ່ປິດການນຳໃຊ້ກຸ່ມ <strong>{$a->groupid}</strong> ໃນເຄື່ອງມືກຸ່ມ (grouptool) <strong>{$a->grouptoolid}</strong>!';
$string['error_getting_data'] = 'ເກີດຄວາມຜິດພາດໃນການຮັບຂໍ້ມູນກຸ່ມ! ບໍ່ມີ ຫຼື ຫຼາຍກ່ວາ 1 ກຸ່ມທີ່ກັບຄືນມາ!';
$string['error_saving_new_order'] = 'ເກີດຄວາມຜິດພາດໃນຂະນະທີ່ບັນທຶກຄຳສັ່ງໃໝ່ສຳລັບກຸ່ມ: <strong>{$a}</strong>';
$string['eventagrpcreated'] = 'ສ້າງກຸ່ມເຄື່ອນໄຫວແລ້ວ';
$string['eventagrpdeleted'] = 'ລຶບກຸ່ມເຄື່ອນໄຫວແລ້ວ';
$string['eventagrpsupdated'] = 'ປັບປຸງກຸ່ມເຄື່ອນໄຫວແລ້ວ';
$string['eventdequeuingstarted'] = 'ເລີ່ມຕົ້ນຍົກເລີກການຈັດຄິວແລ້ວ';
$string['eventgroupcreationstarted'] = 'ເລີ່ມການສ້າງກຸ່ມແລ້ວ';
$string['eventgroupgraded'] = 'ໃຫ້ຄະແນນກຸ່ມແລ້ວ';
$string['eventgroupingscreated'] = 'ສ້າງການຈັດກຸ່ມແລ້ວ';
$string['eventgrouprecreated'] = 'ສ້າງການຈັດກຸ່ມຄືນໃໝ່ແລ້ວ';
$string['eventoverviewexported'] = 'ພາບລວມທີ່ໄດ້ສົ່ງອອກ';
$string['eventqueueentrycreated'] = 'ສ້າງລາຍການຄິວແລ້ວ';
$string['eventqueueentrydeleted'] = 'ລຶບລາຍການຄິວແລ້ວ';
$string['eventregistrationcreated'] = 'ສ້າງການລົງທະບຽນແລ້ວ';
$string['eventregistrationdeleted'] = 'ລຶບການລົງທະບຽນແລ້ວ';
$string['eventregistrationpushstarted'] = 'ເລີ່ມຕົ້ນຍູ້ການລົງທະບຽນ';
$string['eventuserimported'] = 'ນຳເຂົ້າຜູ້ໃຊ້ແລ້ວ';
$string['eventuserlistexported'] = 'ລາຍຊື່ຜູ້ໃຊ້ທີ່ໄດ້ສົ່ງອອກ';
$string['eventusermoved'] = 'ຍ້າຍຜູ້ໃຊ້ແລ້ວ';
$string['exceedgroupqueuelimit'] = 'ເກີນການຂີດຈຳກັດຂອງກຸ່ມ!';
$string['exceedgroupsize'] = 'ເກີນຂະໜາດຂອງກຸ່ມ!';
$string['exceeduserqueuelimit'] = 'ເກີນຂີດຈຳກັດຂອງຄິວ!';
$string['exceeduserreglimit'] = 'ເກີນຂີດຈຳກັດການລົງທະບຽນຂອງຜູ້ໃຊ້!';
$string['feedbackplural'] = 'ຄຳຕິຊົມ';
$string['filters_legend'] = 'ຂໍ້ມູນຕົວກັ່ນຕອງ';
$string['filterunoccupied'] = 'ສະແດງກຸ່ມກັບພື້ນທີ່ຫວ່າງເທົ່ານັ້ນ';
$string['followchanges'] = 'ຕິດຕາມການປ່ຽນແປງ';
$string['forceregistration'] = 'ບັງຄັບເຄື່ອງມືກຸ່ມໃນການລົງທະບຽນ';
$string['forceregistration_help'] = 'ໃຫ້ສັງເກດວ່າ ກຸ່ມຂອງເຄື່ອງມືກຸ່ມ (grouptool) ໂດຍພື້ນຖານແລ້ວແຕກຕ່າງຈາກກຸ່ມມາດຕະຖານ moodle ຂອງລາຍວິຊາ. ໝາຍຕິກໃສ່ປ່ອງໝາຍຖືກ ຫາກທ່ານຕ້ອງການນຳເຂົ້າຜູ້ໃຊ້ເຂົ້າໃນເຄື່ອງມືກຸ່ມ (grouptool) ເຊັ່ນດຽວກັບເຂົ້າໃນກຸ່ມມາດຕະຖານ moodle.';
$string['found_multiple'] = 'ບໍ່ສາມາດລະບຸຕົວຕົນໄດ້, ພົບຜູ້ໃຊ້ຫຼາຍຄົນ:';
$string['free'] = 'ຫວ່າງ';
$string['fromgttoerror'] = 'ເພື່ອ-ໃຫ້ຄ່າ ຕ້ອງໃຫຍ່ກວ່າ ຫຼື ເທົ່າກັບຈາກມູນຄ່າ';
$string['fullgroup'] = 'ກຸ່ມເຕັມ';
$string['general_information'] = 'ຂໍ້ມູນທົ່ວໄປ';
$string['general_registration_exception'] = 'ມີຂໍ້ຍົກເວັ້ນການລົງທະບຽນທົ່ວໄປເກີດຂຶ້ນ ແລະ ພວກເຮົາບໍ່ສາມາດກໍານົດວ່າເປັນຫຍັງໂດຍອັດຕະໂນມັດ!';
$string['global_userstats'] = '<strong>{$a->reg_users}</strong> ຂອງ <strong>{$a->users}</strong> ຜູ້ໃຊ້ທີ່ໄດ້ລົງທະບຽນແລ້ວ. <strong>{$a->notreg_users}</strong> ຍັງບໍ່ມີການລົງທະບຽນ.';
$string['grading'] = 'ການໃຫ້ຄະແນນ';
$string['grading_activity_title'] = 'ກິດຈະກຳ';
$string['grading_alt'] = 'ເຄື່ອງມືສໍາລັບການສໍາເນົາຄະແນນຈາກ 1 ສະມາຊິກໃນກຸ່ມກັບຄົນອື່ນທັງໝົດໃນກຸ່ມ, ບໍ່ວ່າຈະສໍາລັບ 1 ກຸ່ມ ຫຼື ສໍາລັບຊຸດຂອງກຸ່ມ.';
$string['grading_filter_select_title'] = 'ກຸ່ມ ຫຼື ກຸ່ມຕ່າງໆ';
$string['grading_filter_select_title_help'] = 'ເລືອກກຸ່ມ ຫຼື ກຸ່ມໃດທີ່ຈະໃຊ້:<ul><li>ໂດຍບໍ່ມີການຂັດແຍ້ງ - ກຸ່ມທັງໝົດ, ເຊິ່ງມີພຽງແຕ່ 1 ສະມາຊິກກຸ່ມທີ່ໄດ້ຮັບຄະແນນສໍາລັບກິດຈະກໍາທີ່ເລືອກ</li><li>ທັງໝົດ - ກຸ່ມທັງໝົດ</li><li>"ຊື່-ກຸ່ມ" - ພຽງແຕ່ກຸ່ມທີ່ເລືອກໂດຍສະເພາະ</li></ul>';
$string['grading_grouping_select_title'] = 'ຕົວກັ່ນຕອງການຈັດກຸ່ມ';
$string['group_administration'] = 'ກຸ່ມບໍລິຫານ';
$string['group_administration_alt'] = 'ບໍລິຫານກຸ່ມ (ການເຄື່ອນໄຫວ) ແລະ ການຈັດກຸ່ມ';
$string['group_assign_error'] = 'ບໍ່ສາມາດມອບໝາຍກຸ່ມ!';
$string['group_assign_error_prev'] = 'ບໍ່ສາມາດມອບໝາຍກຸ່ມ!';
$string['group_creation'] = 'ສ້າງກຸ່ມ';
$string['group_creation_alt'] = 'ສ້າງກຸ່ມ';
$string['group_creation_failed'] = 'ລົ້ມເຫຼວໃນການສ້າງກຸ່ມ!';
$string['group_creation_success'] = 'ສ້າງກຸ່ມສຳເລັດແລ້ວ!';
$string['group_not_found'] = 'ບໍ່ພົບກຸ່ມ <strong>{$a->groupid}</strong> ໃນເຄື່ອງມືກຸ່ມ (grouptool) <strong>{$a->grouptoolid}</strong>!';
$string['group_not_in_grouping'] = 'ກຸ່ມທີ່ເລືອກບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມທີ່ເລືອກ!';
$string['group_or_member_count'] = 'ຈຳນວນກຸ່ມ/ສະມາຊິກ';
$string['group_places'] = 'ສະຖານທີ່ກຸ່ມ';
$string['group_places_help'] = 'ພາກສະຫນາມ \'ສະຖານທີ່ກຸ່ມ\' ແຈ້ງໃຫ້ (ແຍກອອກໂດຍໝາຍຂີດທັບ) ທໍາອິດກ່ຽວກັບຈໍານວນສະຖານທີ່ກຸ່ມທັງໝົດ, ອັນທີສອງກ່ຽວກັບຈໍານວນສະຖານທີ່ທີ່ບໍ່ເສຍຄ່າ ແລະ ທີສາມກ່ຽວກັບຈໍານວນສະຖານທີ່ກຸ່ມທີ່ຖືກຄອບຄອງແລ້ວ.';
$string['groupchange_from_non_unique_reg'] = 'ບໍ່ສາມາດປ່ຽນກຸ່ມໄດ້ເນື່ອງຈາກກຸ່ມເກົ່າບໍ່ຊໍ້າກັນ!';
$string['groupcreation'] = 'ການສ້າງກຸ່ມ';
$string['groupcreationmode'] = 'ໂໝດ';
$string['groupfromtodigits'] = 'ຈາກ, ໄປຫາ &amp; ຕົວເລກໃນຊື່ກຸ່ມ:';
$string['groupinfo'] = 'ຂໍ້ມູນກຸ່ມ';
$string['grouping_assign_error'] = 'ບໍ່ສາມາດຖືກມອບໝາຍໃຫ້ສໍາເລັດການຈັດກຸ່ມ:';
$string['grouping_assign_error_prev'] = 'ບໍ່ສາມາດຖືກມອບໝາຍໃຫ້ສໍາເລັດການຈັດກຸ່ມ:';
$string['grouping_assign_success'] = 'ໄດ້ມອບໝາຍສຳເລັດແລ້ວ:';
$string['grouping_assign_success_prev'] = 'ສາມາດມອບໝາຍໄດ້ສຳເລັດ:';
$string['grouping_creation_error'] = 'ບໍ່ສາມາດສ້າງການຈັດກຸ່ມ!';
$string['grouping_creation_error_prev'] = 'ບໍ່ສາມາດສ້າງການຈັດກຸ່ມ!';
$string['grouping_creation_only_success'] = 'ສ້າງການຈັດກຸ່ມຢ່າງສຳເລັດ!';
$string['grouping_creation_only_success_prev'] = 'ສາມາດສ້າງກຸ່ມໄດ້ສຳເລັດ!';
$string['grouping_creation_success'] = 'ສາມາດສ້າງກຸ່ມ ແລະ ມອບໝາຍກຸ່ມ <strong>{$a}</strong> ໃຫ້ສຳເລັດໄດ້!';
$string['grouping_creation_success_prev'] = 'ສາມາດສ້າງກຸ່ມ ແລະ ມອບໝາຍກຸ່ມ <strong>{$a}</strong> ໃຫ້ສຳເລັດໄດ້!';
$string['grouping_exists_error'] = 'ບໍ່ສາມາດສ້າງກຸ່ມໄດ້ເນື່ອງຈາກວ່າມີການຈັດກຸ່ມທີ່ມີຊື່ນີ້ຢູ່ແລ້ວ!';
$string['grouping_exists_error_prev'] = 'ບໍ່ສາມາດສ້າງກຸ່ມໄດ້ເນື່ອງຈາກວ່າ ມີການຈັດກຸ່ມທີ່ມີຊື່ນີ້ຢູ່ແລ້ວ!';
$string['groupings_created_and_groups_added'] = 'ສ້າງກຸ່ມ ແລະ/ຫຼື ເພີ່ມກຸ່ມແລ້ວ!';
$string['groupingscreation'] = 'ສ້າງ ແລະ ມອບໝາຍການຈັດກຸ່ມ';
$string['groupingselect'] = 'ການຈັດກຸ່ມສຳລັບກຸ່ມທີ່ໄດ້ເລືອກ';
$string['groupingselect_help'] = 'ສ້າງການຈັດກຸ່ມສໍາລັບ ກຸ່ມທີ່ເລືອກ: <ul>
<li>ສ້າງການຈັດກຸ່ມໜຶ່ງສຳລັບ ກຸ່ມທີ່ເລືອກທັງໝົດ. ສາມາດເລືອກຊື່ຂອງກຸ່ມໄດ້ຢ່າງເສລີ.</li>
<li>ສ້າງກຸ່ມສໍາລັບແຕ່ລະກຸ່ມທີ່ເລືອກ. ການຈັດກຸ່ມແມ່ນຕັ້ງຊື່ຕາມກຸ່ມທີ່ກ່ຽວຂ້ອງ.</li>
<li>ເພີ່ມກຸ່ມທີ່ເລືອກໃສ່ກຸ່ມທີ່ມີຢູ່ແລ້ວ</li></ul>';
$string['groupoverview'] = 'ພາບລວມກຸ່ມ';
$string['groups_created'] = 'ສ້າງການຈັດກຸ່ມຢ່າງສຳເລັດ!';
$string['groups_queues_limit'] = 'ສະຖານທີ່ຄິວຕໍ່ກຸ່ມ';
$string['groups_queues_limit_help'] = 'ຈໍາກັດສະຖານທີ່ຄິວທີ່ມີຕໍ່ກຸ່ມຖ້າເປີດໃຊ້';
$string['groupselection'] = 'ການເລືອກກຸ່ມ';
$string['groupselection_help'] = 'ເລືອກກຸ່ມ/ຄົນທີ່ທ່ານຕ້ອງການຄັດລອກຄະແນນການອ້າງອີງທີ່ເລືອກ ແລະ -ຄຳຕິຊົມໂດຍການເປີດໃຊ້ກ່ອງໝາຍທີ່ສອດຄ້ອງກັນ. ຖ້າພຽງແຕ່ 1 ກຸ່ມຖືກສະແດງ, ທ່ານເລືອກແຫຼ່ງສໍາລັບການຄັດລອກຄະແນນທີ່ເລືອກໂດຍໃຊ້ປຸ່ມທີ່ສອດຄ້ອງກັນທາງດ້ານຂວາຂອງລາຍການ.';
$string['groupsize'] = 'ຂະໜາດກຸ່ມ';
$string['groupsize_gets_enabled'] = 'ຖ້າທ່ານສືບຕໍ່ການຈັດກຸ່ມຈະຖືກເປີດໃຊ້ໂດຍອັດຕະໂນມັດ. ປ້ອງກັນພຶດຕິກຳນີ້ໂດຍການໃຊ້ 0 ເປັນ <strong>{$a->field</strong>';
$string['groupsize_individual_gets_enabled'] = 'ຖ້າເຈົ້າສືບຕໍ່ການແບ່ງກຸ່ມຈະຖືກເປີດໃຊ້ໂດຍອັດຕະໂນມັດ. ປ້ອງກັນພຶດຕິກຳນີ້ໂດຍການໃຊ້ 0 ເປັນ <strong>{$a->field}</strong> ເພື່ອບໍ່ໃຊ້ຂະໜາດກຸ່ມທັງໝົດ ຫຼື ໃຊ້ <strong>{$a->globalsize}</strong> ເພື່ອເປີດໃຊ້ຂະໜາດກຸ່ມທົ່ວໂລກເທົ່ານັ້ນ !';
$string['groupstatus'] = 'ສະຖານະ';
$string['groupstatus_help'] = 'ສະຖານະປັດຈຸບັນຂອງກຸ່ມແມ່ນສະແດງດ້ວຍສີ:<ul><li>ສີຂຽວ - ກຸ່ມທີ່ເຄື່ອນໄຫວ. ກຸ່ມໄດ້ຖືກມອບຫມາຍໃຫ້ເຄື່ອງມືກຸ່ມນີ້. ຖ້າການລົງທະບຽນຕົນເອງມີການເຄື່ອນໄຫວ, ນັກຮຽນອາດຈະລົງທະບຽນກັບກຸ່ມນີ້.</li><li>ສີຂີ້ເຖົ່າ - ກຸ່ມທີ່ບໍ່ເຄື່ອນໄຫວ. ກຸ່ມບໍ່ສາມາດໃຊ້ໄດ້ໃນເຄື່ອງມືກຸ່ມນີ້.</li></ul>ໂດຍການຄລິກທີ່ສັນຍາລັກ ສະຖານະສາມາດປ່ຽນແປງໄດ້.';
$string['grouptool'] = 'ເຄື່ອງມືກຸ່ມ';
$string['grouptool:addinstance'] = 'ເພີ່ມຕົວຢ່າງເຄື່ອງມືກຸ່ມໄປຫາລາຍວິຊາ';
$string['grouptool:administrate_groups'] = 'ບໍລິຫານກຸ່ມ ແລະ ການຈັດກຸ່ມ.';
$string['grouptool:create_groupings'] = 'ສ້າງການຈັດກຸ່ມໂດຍການນຳໃຊ້ເຄື່ອງມືກຸ່ມ.';
$string['grouptool:create_groups'] = 'ສ້າງກຸ່ມໂດຍການນຳໃຊ້ເຄື່ອງມືກຸ່ມ';
$string['grouptool:export'] = 'ສົ່ງອອກກຸ່ມ ແລະ ຂໍ້ມູນການລົງທະບຽນເປັນຮູບແບບທີ່ແຕກຕ່າງກັນ';
$string['grouptool:grade'] = 'ສຳເນົາຄະແນນຈາກສະມາຊິກກຸ່ມໄປຫາຜູ້ອື່ນ';
$string['grouptool:grade_own_group'] = 'ສຳເນົາຄະແນນຈາກສະມາຊິກກຸ່ມໄປໃຫ້ຜູ້ອື່ນ ຖ້າຂ້ອຍໃຫ້ຄະແນນຕົ້ນສະບັບ';
$string['grouptool:move_students'] = 'ຍ້າຍນັກຮຽນໄປກຸ່ມອື່ນ.';
$string['grouptool:register'] = 'ລົງທະບຽນດ້ວຍຕົວເອງໃນກຸ່ມເຄື່ອນໄຫວ';
$string['grouptool:register_students'] = 'ລົງທະບຽນນັກຮຽນຢູ່ໃນກຸ່ມທີ່ເຄື່ອນໄຫວໂດຍໃຊ້ເຄື່ອງມືກຸ່ມ. (ຍັງໃຊ້ເພື່ອແກ້ໄຂຄິວ)';
$string['grouptool:unregister_students'] = 'ຍົກເລີກການລົງທະບຽນຈາກກຸ່ມໂດຍການນຳໃຊ້ເຄື່ອງມືກຸ່ມ.';
$string['grouptool:view_description'] = 'ເບິ່ງຄຳອະທິບາຍເຄື່ອງມືກຸ່ມ';
$string['grouptool:view_groups'] = 'ເບິ່ງກຸ່ມເຄື່ອນໄຫວ';
$string['grouptool:view_own_registration'] = 'ເບິ່ງການລົງທະບຽນຂອງຕົວເອງ.';
$string['grouptool:view_registrations'] = 'ເບິ່ງວ່າໃຜລົງທະບຽນ/ຈັດຄິວຢູ່ໃນກຸ່ມທີ່ເຄື່ອນໄຫວໂດຍໃຊ້ເຄື່ອງມືກຸ່ມ.';
$string['grouptool:view_regs_course_overview'] = 'ເບິ່ງລາຍຊື່ຜູ້ໃຊ້ທີ່ມີຜູ້ທີ່ລົງທະບຽນ/ເຂົ້າຄິວຢູ່ໃນກຸ່ມທີ່ເຄື່ອນໄຫວໂດຍໃຊ້ເຄື່ອງມືກຸ່ມ.';
$string['grouptool:view_regs_course_view'] = 'ເບິ່ງລາຍຊື່ຜູ້ໃຊ້ທີ່ມີຜູ້ທີ່ລົງທະບຽນ/ເຂົ້າຄິວຢູ່ໃນກຸ່ມທີ່ເຄື່ອນໄຫວໂດຍໃຊ້ເຄື່ອງມືກຸ່ມ.';
$string['grouptool:view_regs_group_overview'] = 'ເບິ່ງລາຍຊື່ກຸ່ມທີ່ປະກອບດ້ວຍຜູ້ທີ່ລົງທະບຽນ/ເຂົ້າຄິວຢູ່ໃນກຸ່ມທີ່ເຄື່ອນໄຫວໂດຍໃຊ້ເຄື່ອງມືກຸ່ມ.';
$string['grouptool:view_regs_group_view'] = 'ເບິ່ງລາຍຊື່ກຸ່ມທີ່ປະກອບດ້ວຍຜູ້ທີ່ລົງທະບຽນ/ເຂົ້າຄິວຢູ່ໃນກຸ່ມທີ່ເຄື່ອນໄຫວໂດຍໃຊ້ເຄື່ອງມືກຸ່ມ.';
$string['grouptoolfieldset'] = 'ການຕັ້ງຄ່າຕົວຢ່າງ';
$string['grouptoolname'] = 'ຊື່ເຄື່ອງມືກຸ່ມ';
$string['grouptoolname_help'] = 'ຊື່ຂອງຕົວຢ່າງເຄື່ອງມືກຸ່ມ';
$string['groupuser_import'] = 'ນຳເຂົ້າຜູ້ໃຊ້ກຸ່ມ';
$string['groupuser_unregister'] = 'ຍົກເລີກລົງທະບຽນຜູ້ໃຊ້ກຸ່ມ';
$string['grp_marked'] = 'ໝາຍໄວ້ສຳລັບການລົງທະບຽນ';
$string['grpsizezeroerror'] = 'ຂະໜາດຂອງກຸ່ມຕ້ອງໃຫຍ່ກວ່າ ຫຼື ເທົ່າກັບ 1. ບໍ່ອະນຸຍາດໃຫ້ມີຕົວອັກສອນ ຫຼືເຄື່ອງໝາຍອື່ນໆ.';
$string['ifgroupdeleted'] = 'ຖ້າຫາກກຸ່ມຖືກລຶບ';
$string['ifgroupdeleted_help'] = 'ກຸ່ມທີ່ຖືກລຶບຄວນຈະຖືກສ້າງຄືນໃໝ່ສໍາລັບຕົວຢ່າງເຄື່ອງມືກຸ່ມ (grouptool-instance) ຫຼື ຄວນການອ້າງອີງໃນເຄື່ອງມືກຸ່ມ (ຂໍ້ມູນກຸ່ມເພີ່ມເຕີມ, ການລົງທະບຽນ ແລະ ຄິວ) ຈະຖືກລຶບຫຼືບໍ? ໝາຍເຫດ: ຖ້າຫາກວ່າ ທ່ານເລືອກ "ສ້າງກຸ່ມຄືນໃໝ່", ຫຼັງຈາກນັ້ນກຸ່ມຈະໄດ້ຮັບການສ້າງຄືນໃໝ່ອັດຕະໂນມັດຫຼັງຈາກການລົບພາຍໃຕ້ "ການບໍລິຫານວິຊາ / ຜູ້ໃຊ້ / ກຸ່ມ".';
$string['ifmemberadded'] = 'ຖ້າຫາກສະມາຊິກກຸ່ມຖືກເພີ່ມ';
$string['ifmemberadded_help'] = 'ສະມາຊິກກຸ່ມໃໝ່ທີ່ເພີ່ມຜ່ານ moodle ຄວນລົງທະບຽນຢູ່ໃນເຄື່ອມືກຸ່ມ ຫຼື ຖືກລະເລີຍບໍ?';
$string['ifmemberremoved'] = 'ຖ້າຫາກສະມາຊິກກຸ່ມຖືກຍ້າຍອອກ';
$string['ifmemberremoved_help'] = 'ການລົງທະບຽນເຄື່ອງມືກຸ່ມຄວນຈະຖືກລຶບ ຖ້າຜູ້ໃຊ້ຖືກລຶບອອກຈາກ moodle-group ທີ່ສອດຄ້ອງກັນ';
$string['ignorechanges'] = 'ບໍ່ສົນໃຈການປ່ຽນແປງ';
$string['ignored_not_found_users'] = 'ຢ່າງໜ້ອຍໜຶ່ງຜູ້ໃຊ້ບໍ່ສາມາດຖືກເພີ່ມເຂົ້າໃນກຸ່ມໄດ້!';
$string['ignored_not_found_users_unregister'] = 'ບໍ່ພົບຜູ້ໃຊ້ຢ່າງໜ້ອຍໜຶ່ງຄົນ!';
$string['ignoring_not_found_users'] = 'ຢ່າງໜ້ອຍໜຶ່ງຜູ້ໃຊ້ບໍ່ໄດ້ພົບເຫັນຢູ່ໃນຖານຂໍ້ມູນ. ຜູ້ໃຊ້ທັງໝົດເຫຼົ່ານັ້ນຈະຖືກລະເລີຍ!';
$string['immediate_reg'] = 'ການລົງທະບຽນທັນທີ';
$string['immediate_reg_help'] = 'ຖ້າເປີດໃຊ້ (ຍົກເລີກລົງ) ການທະບຽນຈະຖືກສົ່ງຕໍ່ໃຫ້ລະບົບ Moodle. ຖ້າບໍ່ໄດ້ເປີດໃຊ້ການລົງທະບຽນຈະຖືກແຄດ ເຄື່ອງໝາຍກຸ່ມ ແລະ ສາມາດຍູ້ກັບໄປລະບົບ moodle ໂດຍຄູສອນ.';
$string['import'] = 'ນຳເຂົ້າ';
$string['import_conflict_user_queued'] = 'ຜູ້ໃຊ້ <strong>{$a->fullname}</strong> ຖືກຈັດຄິວເປັນກຸ່ມແລ້ວ <strong>{$a->groupname}</strong>!';
$string['import_desc'] = 'ນໍາເຂົ້າຜູ້ໃຊ້ຜ່ານບັນຊີລາຍຊື່ຂອງໝາຍເລກປະຈຳຕົວເຂົ້າໄປໃນກຸ່ມສະເພາະໃດຫນຶ່ງ';
$string['import_in_inactive_group_rejected'] = 'ການລົງທະບຽນໃນ ກຸ່ມເຄື່ອງມືກຸ່ມ <strong>{$a}</strong> ໄດ້ຖືກປະຕິເສດ ເນື່ອງຈາກມັນບໍ່ມີການເຄື່ອນໄຫວ. ເປີດໃຊ້ກຸ່ມໃນເຄື່ອງມືກຸ່ມນີ້ ເພື່ອເປີດໃຊ້ການລົງທະບຽນ.';
$string['import_in_inactive_group_warning'] = 'ໝາຍເຫດ: ກຸ່ມ <strong>{$a}</strong> ປະຈຸບັນບໍ່ມີການເຄື່ອນໄຫວຢູ່ໃນບໍລິບົດຂອງ ເຄື່ອງໝາຍກຸ່ມ ແລະ ດັ່ງນັ້ນຈຶ່ງຈະບໍ່ຖືກສະແດງ.';
$string['import_progress_completed'] = 'ນຳເຂົ້າສຳເລັດແລ້ວ';
$string['import_progress_import'] = 'ນຳເຂົ້າຜູ້ໃຊ້';
$string['import_progress_preview_completed'] = 'ນຳເຂົ້າການເບິ່ງຕົວຢ່າງສຳເລັດແລ້ວ';
$string['import_progress_search'] = 'ຄົ້ນຫາຜູ້ໃຊ້';
$string['import_progress_start'] = 'ເລີ່ມນຳເຂົ້າ';
$string['import_skipped'] = 'ຂ້າມຜູໃຊ້ <strong>{$a->fullname}</strong> ສຳລັບກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['import_user'] = 'ນຳເຂົ້າ <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) ໃນກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດ.';
$string['import_user_prev'] = 'ນຳເຂົ້າ (<strong>{$a->idnumber}</strong>) ໃນກຸ່ມ <strong>{$a->groupname}</strong>.';
$string['import_user_problem'] = 'ບັນຫາໃນລະຫວ່າງການນໍາເຂົ້າ <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong> - <strong>{$a->id}</strong>) ໃນກຸ່ມ <strong>{$a->groupname}</strong>.';
$string['importbutton'] = 'ນຳເຂົ້າຜູ້ໃຊ້';
$string['inactive'] = 'ບໍ່ເຄື່ອນໄຫວ';
$string['inactivegroups'] = 'ກຸ່ມບໍ່ເຄື່ອນໄຫວ';
$string['inactivegroups_hide'] = 'ເຊື່ອງກຸ່ມບໍ່ເຄື່ອນໄຫວ';
$string['inactivegroups_show'] = 'ສະແດງກຸ່ມບໍ່ເຄື່ອນໄຫວ';
$string['includedeleted'] = 'ລວມທັງຜູ້ໃຊ້ທີ່ຖືກລຶບ';
$string['includedeleted_help'] = 'ຖ້າໝາຍຖືກແລ້ວ, ຜູ້ໃຊ້ທີ່ຖືກລຶບໄປແລ້ວຈະບໍ່ຖືກກັ່ນຕອງອອກຈາກລາຍຊື່. ບັນຊີຜູ້ໃຊ້ທີ່ຖືກລົບແລ້ວບໍ່ສາມາດໄດ້ຮັບການລົງທະບຽນໃນວິຊາໃນລະຫວ່າງຂະບວນການນໍາເຂົ້າ.';
$string['incomplete_only_label'] = 'ສະແດງພຽງແຕ່ກຸ່ມທີ່ມີຄະແນນຂາດຫາຍໄປ';
$string['incorrect_tab'] = 'ແຖບບໍ່ຖືກຕ້ອງ, ແຖບນີ້ບໍ່ມີໃຫ້!';
$string['individual_size_info'] = 'ຂະໜາດກຸ່ມຂອງການຕັ້ງຄ່າເຄື່ອງມືກຸ່ມ';
$string['intro'] = 'ຄຳອະທິບາຍ';
$string['invert'] = 'ປິ້ນກັບ';
$string['landscape'] = 'ພູມສັນຖານ';
$string['late'] = '{$a} ຊັກຊ້າ';
$string['limit'] = 'ຈຳກັດ';
$string['loading'] = 'ກຳລັງໂຫຼດ';
$string['max_queues_reached'] = 'ຮອດຄິວສູງສຸດແລ້ວ!';
$string['max_regs_reached'] = 'ຮອດການລົງທະບຽນສູງສຸດແລ້ວ!';
$string['maxmembers'] = 'ຂະໜາດກຸ່ມທົ່ວໂລກ';
$string['messageprovider:grouptool_moveupreg'] = 'ການລົງທະບຽນໂດຍການຍ້າຍຄິວຂື້ນ';
$string['missing_source_selection'] = 'ບໍ່ໄດ້ເລືອກແຫຼ່ງຂໍ້ມູນ';
$string['modulename'] = 'ເຄື່ອງມືກຸ່ມ';
$string['modulename_help'] = 'ຊຸດເຄື່ອງມືກຸ່ມ (grouptool-module) ໃຫ້ບໍລິການປະເພດຕ່າງໆຂອງວຽກງານທີ່ກ່ຽວຂ້ອງກັບກຸ່ມ:<ul><li>ມັນອະນຸຍາດໃຫ້ສ້າງກຸ່ມໃນໂໝດຕ່າງໆ (ຈໍານວນກຸ່ມ/ສະມາຊິກກຸ່ມ, ກຸ່ມຄົນດຽວ, ຊ່ວງເວລາຂອງກຸ່ມ) ເຊັ່ນດຽວກັນກັບການຈັດກຸ່ມສໍາລັບແຕ່ລະກຸ່ມ.</li><li>ນອກຈາກນັ້ນ, ມັນສາມາດຖືກນໍາໃຊ້ ເພື່ອໃຫ້ນັກຮຽນມີຄວາມເປັນໄປໄດ້ໃນການລົງທະບຽນຕົນເອງກັບບາງກຸ່ມໃນລະຫວ່າງໄລຍະເວລາທີ່ກໍານົດໄວ້.</li><li>ຊຸດຍັງມີຄວາມສາມາດໃນການໃຫ້ຄະແນນກຸ່ມ - ເຊັ່ນ: ສຳເນົາຄະແນນການເຄື່ອນໄຫວຈາກສະມາຊິກກຸ່ມ 1 ຄົນໄປຫາສະມາຊິກກຸ່ມອື່ນ.</li><li>ການນຳເຂົ້າຜູ້ໃຊ້ເຂົ້າໃນກຸ່ມຜ່ານລາຍການໝາຍເລກປະຈຳຕົວ</li><li>ພາບລວມຂອງທຸກໆກຸ່ມວິຊາລວມທັງການລົງທະບຽນທັງໝົດ, ສະມາຊິກ, ຄິວ, ແລະອື່ນໆ ແລະ ຄວາມສາມາດທີ່ຈະສົ່ງອອກຂໍ້ມູນນີ້ອອກເປັນຮູບແບບໄຟລ໌ທີ່ແຕກຕ່າງກັນ (PDF/XLSX/ODS/TXT).</li><li>ລາຍຊື່ຜູ້ໃຊ້ລາຍການທີ່ສາມາດສົ່ງອອກໄດ້ທັງໝົດລວມທັງການລົງທະບຽນ, ຄິວ, ແລະອື່ນໆ.</li> </ul><p>(!) ໃຫ້ສັງເກດວ່າ ກຸ່ມຂອງ ເຄື່ອງມືກຸ່ມ ໂດຍພື້ນຖານແລ້ວແຕກຕ່າງຈາກກຸ່ມມາດຕະຖານຂອງລາຍວິຊາ. ເພື່ອຮັບປະກັນຄວາມສອດຄ່ອງຂອງປະເພດກຸ່ມໄດ້ກໍານົດພາລາມິເຕີຂອງພາກສ່ວນ "ພຶດຕິກໍາການປ່ຽນແປງໃນອາລົມ" ເປັນ "ປະຕິບັດຕາມການປ່ຽນແປງ".</p>';
$string['modulenameplural'] = 'ເຄື່ອງມືກຸ່ມ';
$string['moodlesync'] = 'ພຶດຕິກໍາການປ່ຽນແປງໃນ Moodle';
$string['moodlesync_help'] = 'ເຄື່ອງມືກຸ່ມ ຄວນປະຕິບັດແນວໃດຖ້າສະມາຊິກກຸ່ມ moodle ຖືກເພີ່ມ/ລຶບ ຫຼື ກຸ່ມດຽວຖືກລຶບ';
$string['move_user'] = 'ຍ້າຍຈາກຄິວໄປຫາກຸ່ມ';
$string['movedown'] = 'ຍ້າຍ 1 ລົງ';
$string['moveup'] = 'ຍ້າຍ 1 ຂື້ນ';
$string['multiple'] = 'ບໍລິຫານກຸ່ມຜູ້ໃຊ້';
$string['multiple_desc'] = 'ການລົງທະບຽນ/ຍົກເລີກການລົງທະບຽນຫຼາຍຄັ້ງ';
$string['must_specify_groupingname'] = 'ທ່ານຕ້ອງສະໜອງຊື່ສໍາລັບການຈັດກຸ່ມ!';
$string['mustbegt0'] = 'ກຸ່ມຕ່ຳສຸດທີ່ເລືອກຈະຕ້ອງໃຫຍ່ກວ່າ ຫຼື ເທົ່າກັບ 0. ບໍ່ອະນຸຍາດໃຫ້ມີຕົວອັກສອນ ຫຼື ເຄື່ອງໝາຍອື່ນໆ.';
$string['mustbegtoeqmin'] = 'ຕ້ອງມີຈໍານວນທີ່ໃຫຍ່ກວ່າ ຫຼື ເທົ່າກັບຈໍານວນໜ້ອຍສຸດ';
$string['mustbeposint'] = 'ກຸ່ມສູງສຸດທີ່ຈະເລືອກຈະຕ້ອງໃຫຍ່ກວ່າ ຫຼື ເທົ່າກັບ 1. ຕົວອັກສອນ ຫຼື ເຄື່ອງໝາຍອື່ນໆແມ່ນບໍ່ອະນຸຍາດໃຫ້ມີ.';
$string['mygroups_only_label'] = 'ສະແດງລາຍການແຫຼ່ງຂໍ້ມູນເທົ່ານັ້ນທີ່ຂ້ອຍໄດ້ຄະແນນ';
$string['myoverview_registrations_missing'] = 'ການລົງທະບຽນຂາດຫາຍ';
$string['name_scheme_tags'] = '<span class="tag firstname">[firstname]</span>
<span class="tag lastname">[lastname]</span>
<span class="tag idnumber">[idnumber]</span>
<span class="tag username">[username]</span>
<span class="tag alpha">@</span>
<span class="tag number">#</span>';
$string['nameschemenotunique'] = 'ຊື່ກຸ່ມຈາກລະບົບຊື່ນີ້ບໍ່ຊໍ້າກັນ (<strong>{$a}</strong>). ກະລຸນາເລືອກອັນອື່ນ ຫຼື ໃຊ້ # (ດັດຊະນີຕົວເລກ) ຫຼື @ (ດັດຊະນີຕົວໜັງສື) ເພື່ອສ້າງຊື່ກຸ່ມທີ່ເປັນເອກະລັກ.';
$string['namingscheme'] = 'ໂຄງການຊື່';
$string['namingscheme_help'] = '<p>ໂຄງການຊື່ຈະກຳນົດວ່າ ກຸ່ມຈະຖືກຕັ້ງຊື່ອັດຕະໂນມັດແນວໃດ ເມື່ອທ່ານເພີ່ມກຸ່ມໃໝ່.</p>
<p>ກະລຸນາຮັບຊາບວ່າ:<br />
<ol><li>ຊື່ຂອງກຸ່ມຕ້ອງເປັນເອກະລັກສະເພາະໃນວິຊາການໂປຼໄຟລ໌ຂອງທ່ານ. </li>
<li>ຖ້າທ່ານຕ້ອງການສ້າງຫຼາຍກວ່າໜຶ່ງກຸ່ມໃນເວລາດຽວກັນ, ທ່ານຕ້ອງໃຊ້ແທັກເພື່ອສ້າງຊື່ທີ່ເປັນເອກະລັກ. </li></ol></p>
<p>ແຕ່ລະແທັກນີ້ ຈະຖືກແທນທີ່ຊື່ກຸ່ມສຸດທ້າຍ. ແທັກໃນ [] ແມ່ນກ່ຽວຂ້ອງກັບຂໍ້ມູນຜູ້ໃຊ້ ແລະສັນຍາລັກ # ແລະ @ ຈະຖືກແທນທີ່ຜ່ານໝາຍເລກປະຈຳກຸ່ມ. ຖ້າ JavaScript ຖືກເປີດໃຊ້, ທ່ານພຽງແຕ່ສາມາດຄລິກໃສ່ ແທັກ ເພື່ອຕື່ມຂໍ້ມູນໃສ່ກັບໂຄງການຊື່. ກະລຸນາພິຈາລະນາວ່າ ຊື່ກຸ່ມຕ້ອງເປັນເອກະລັກໃນແຕ່ລະວິຊາ ແລະ ດັ່ງນັ້ນທ່ານອາດຈະມີການປ່ຽນແປງໂຄງການຊື່ຈົນກ່ວາມັນບໍ່ມີຂໍ້ຂັດແຍ່ງ.</p>';
$string['no_conflictfree_to_display'] = 'ບໍ່ມີກຸ່ມທີ່ບໍ່ມີຂໍ້ຂັດແຍ່ງທີ່ຈະສະແດງ. ດັ່ງນັ້ນ ພວກເຮົາພະຍາຍາມສະແດງທັງໝົດແທນ!';
$string['no_data_to_display'] = 'ບໍ່ມີຂໍ້ມູນກຸ່ມທີ່ຈະສະແດງ!';
$string['no_grades_present'] = 'ບໍ່ມີຄະແນນໃຫ້ສະແດງ';
$string['no_groupmembers_to_display'] = 'ບໍ່ມີສະມາຊິກກຸ່ມທີ່ຈະສະແດງ. ດັ່ງນັ້ນ ພວກເຮົາພະຍາຍາມສະແດງທຸກກຸ່ມແທນ!';
$string['no_groups_to_display'] = 'ບໍ່ມີກຸ່ມໃຫ້ສະແດງ';
$string['no_queues_to_resolve'] = 'ບໍ່ມີຄິວປາກົດເພື່ອແກ້ບັນຫາ!';
$string['no_registrations'] = 'ບໍ່ມີການລົງທະບຽນ';
$string['no_target_selected'] = 'ບໍ່ມີຈຸດໝາຍປາຍທາງສຳລັບການດຳເນີນການສຳເນົາທີ່ເລືອກ. ທ່ານຕ້ອງເລືອກຢ່າງໜ້ອຍ 1 ຈຸດໝາຍປາຍທາງ!';
$string['no_users_to_display'] = 'ບໍ່ມີຜູ້ໃຊ້ເພື່ອສະແດງ';
$string['noaccess'] = 'ທ່ານບໍ່ມີການເຂົ້າເຖິງຊຸດນີ້ (ບາງທີທ່ານບໍ່ໄດ້ຢູ່ໃນກຸ່ມທີ່ຖືກຕ້ອງ?)!';
$string['nobody_queued'] = 'ບໍ່ມີໃຜເຂົ້າຄິວ';
$string['nodeletion'] = 'ການລຶບກຸ່ມນີ້ແມ່ນຖືກປິດການນຳໃຊ້, ເນື່ອງຈາກຢ່າງໜ້ອຍໜຶ່ງຕົວຢ່າງ ເຄື່ອງມືກຸ່ມ ໃນຫຼັກສູດນີ້ຖືກຕັ້ງໃຫ້ສ້າງກຸ່ມຄືນໃໝ່ໃນເວລາລຶບ!';
$string['nogroupingselected'] = 'ບໍ່ມີການຈັດກຸ່ມໄດ້ຖືກເລືອກ!';
$string['nogroups'] = 'ບໍ່ມີກຸ່ມໃນລາຍວິຊານີ້';
$string['nogroupsactive'] = 'ບໍ່ມີກຸ່ມເຄື່ອນໄຫວໃນເຄື່ອງມືກຸ່ມນີ້.';
$string['nogroupschoose'] = 'ເລືອກກຸ່ມ';
$string['nogroupscreate'] = 'ສ້າງກຸ່ມ';
$string['nogroupsinactive'] = 'ບໍ່ມີກຸ່ມທີ່ບໍ່ເຄື່ອນໄຫວໃນເຄື່ອງມືກຸ່ມນີ້.';
$string['nogrouptools'] = 'ບໍ່ມີເຄື່ອງມືກຸ່ມ!';
$string['nonconflicting'] = 'ປາສະຈາກຂໍ້ຂັດແຍ້ງ';
$string['noregistrationdue'] = 'ບໍ່ຈຳກັດ';
$string['nosmallgroups'] = 'ປ້ອງກັນຈາກກຸ່ມນ້ອຍ';
$string['nosmallgroups_help'] = 'ຖ້າເປີດໃຊ້ງານ ໃຫ້ແນ່ໃຈວ່າ ແຕ່ລະກຸ່ມຖືກຕື່ມຢ່າງໜ້ອຍ 70% ຂອງຂະໜາດຂອງມັນ! ຖ້າກຸ່ມ (ຫຼື ຊັດເຈນກວ່າ) ສຸດທ້າຍຈະເຕັມໄປໜ້ອຍກວ່າ 70% ຜູ້ໃຊ້ສໍາລັບກຸ່ມນີ້ໄດ້ຮັບການແຜ່ຂະຫຍາຍໄປສູ່ກຸ່ມອື່ນໆ, ເຊິ່ງເຮັດໃຫ້ພວກເຂົາມີສະມາຊິກຫຼາຍກວ່າທີ່ກໍານົດ!';
$string['not_allowed_to_show_members'] = 'ທ່ານບໍ່ມີການອະນຸຍາດເພື່ອເບິ່ງຂໍ້ມູນນີ້!';
$string['not_graded_by_me'] = 'ໄດ້ຄະແນນໂດຍຜູ້ໃຊ້ອື່ນ';
$string['not_in_queue_or_registered'] = '<strong>{$a->username}</strong> ບໍ່ໄດ້ລົງທະບຽນ ຫຼື ຈັດຄິວຢູ່ໃນກຸ່ມ <strong>{$a->groupname}</strong>';
$string['not_permitted'] = 'ບໍ່ໄດ້ຮັບອະນຸຍາດ';
$string['not_registered'] = 'ທ່ານຍັງບໍ່ໄດ້ລົງທະບຽນເທື່ອ';
$string['not_synced_reg_present'] = 'ການລົງທະບຽນບໍ່ໄດ້ເຊື່ອມປະສານໃນປະຈຸບັນ';
$string['notenoughregs'] = 'ຜູ້ໃຊ້ຕ້ອງການລົງທະບຽນເພີ່ມເຕີມ!';
$string['nothing_to_push'] = 'ບໍ່ມີຫຍັງປາກົດ!';
$string['notification:group_recreated'] = 'ກຸ່ມ <a href="{$a->groupurl}" title="{$a->groupname}">{$a->groupname}</a> ຖືກສ້າງຄືນເນື່ອງຈາກເຄື່ອງມືກຸ່ມ <a href="{$a->grouptoolurl}" title="{$a->grouptoolname}">{$a->grouptoolname}</a> ຖືກຕັ້ງໃຫ້ສ້າງກຸ່ມທີ່ຖືກລົບຄືນ.';
$string['notification:registrations_recreated'] = 'ສະມາຊິກ <a href="{$a->groupurl}" title="{$a->groupname}">{$a->groupname}</a> ຂອງກຸ່ມໄດ້ຖືກເພີ່ມເຂົ້າອີກຄັ້ງເນື່ອງຈາກເຄື່ອງມືກຸ່ມ <a href="{$a->grouptoolurl}" title="{$a->grouptoolname}">$a->grouptoolname}</a> ຖືກຕັ້ງໃຫ້ສ້າງກຸ່ມທີ່ຖືກລົບຄືນ. ກຸ່ມຕົວມັນເອງໄດ້ຖືກສ້າງໃໝ່ໂດຍຕົວຢ່າງເຄື່ອງມືກຸ່ມອື່ນ.';
$string['nowhere_queued'] = 'ບໍ່ໄດ້ເຂົ້າຄິວ';
$string['number_of_groups'] = 'ຈຳນວນກຸ່ມ N';
$string['number_of_members'] = 'ຈຳນວນສະມາຊິກກຸ່ມ N';
$string['number_of_students'] = 'ຈຳນວນນັກຮຽນ';
$string['occupied'] = 'ຄອບຄອງແລ້ວ';
$string['onenewgrouping'] = 'ໃນໜຶ່ງການຈັດກຸ່ມໃໝ່';
$string['onenewgroupingpergroup'] = 'ໜຶ່ງການຈັດກຸ່ມ ຕໍ່ ກຸ່ມ';
$string['orientation'] = 'PDF-ປະຖົມນິເທດ';
$string['outdated'] = 'ບິດເບືອນ';
$string['overflowwarning'] = 'ຖ້າຫາກວ່າ ທ່ານສືບຕໍ່ນໍາເຂົ້າຂະໜາດກຸ່ມໃນຕົວຢ່າງ <strong>{$a->instancename}</strong> ແມ່ນຈະເກີນ!';
$string['overview'] = 'ພາບລວມ';
$string['overview_alt'] = 'ພາບລວມຂອງກຸ່ມ ແລະ ສະມາຊິກກຸ່ມ';
$string['overview_tab'] = 'ເບິ່ງກຸ່ມ';
$string['overview_tab_alt'] = 'ເບິ່ງກຸ່ມເປີດ';
$string['overwrite_label'] = 'ຂຽນທັບຄະແນນທີ່ມີຢູ່';
$string['place_allocated_in_group_success'] = 'ກຸ່ມ <strong>{$a->groupname}</strong> ຖືກໝາຍໃຫ້ລົງທະບຽນສຳເລັດແລ້ວ';
$string['pluginadministration'] = 'ການບໍລິຫານເຄື່ອງມືກຸ່ມ';
$string['pluginname'] = 'ເຄື່ອງມືກຸ່ມ';
$string['portrait'] = 'ຮູບຖ່າຍ';
$string['preview'] = 'ເບິ່ງຕົວຢ່າງ';
$string['privacy:metadata:agrpid'] = 'ຕົວລະບຸການເປັນຕົວແທນຂອງກຸ່ມ Moodle ໃນເຄື່ອງມືກຸ່ມ.';
$string['privacy:metadata:enrolexplanation'] = 'ເຄື່ອງມືກຸ່ມ ລົງທະບຽນເຂົ້າຮຽນຍັງບໍ່ຜູ້ໃຊ້ທີ່ລົງທະບຽນ ໃນລາຍວິຊາໃນລະຫວ່າງການນໍາເຂົ້າເພື່ອໃຫ້ສາມາດເພີ່ມເຂົາເຈົ້າເຂົ້າໃນກຸ່ມທີ່ຈະນໍາເຂົ້າ.';
$string['privacy:metadata:gradesexplanation'] = 'ເຄື່ອງມືກຸ່ມ ສາມາດສຳເນົາຄະແນນຈາກຜູ້ໃຊ້ຄົນໜຶ່ງໄປຫາສະມາຊິກອື່ນໆຂອງກຸ່ມດຽວກັນ.';
$string['privacy:metadata:groupexplanation'] = 'ເຄື່ອງມືກຸ່ມ ແມ່ນການຄຸ້ມຄອງສະມາຊິກຂອງກຸ່ມ Moodle.';
$string['privacy:metadata:messageexplanation'] = 'ເຄື່ອງມືກຸ່ມ ສົ່ງຂໍ້ຄວາມໄປຫາຜູ້ໃຊ້ທີ່ຖືກສົ່ງເສີມຈາກແຖວທີ່ຈະລົງທະບຽນ.';
$string['privacy:metadata:mod_grouptool_group_filter'] = 'ກຸ່ມໃດທີ່ຈະກັ່ນຕອງ?';
$string['privacy:metadata:mod_grouptool_mygroups_only'] = 'ຄວນພິຈາລະນາ/ສະແດງກຸ່ມຂອງຕົນເອງເທົ່ານັ້ນ.';
$string['privacy:metadata:modified_by'] = 'ຕົວລະບຸຕົວຕົນຂອງຜູ້ໃຊ້ຖ້າຖືກດັດແປງໂດຍຄົນອື່ນ.';
$string['privacy:metadata:queued'] = 'ປະກອບມີຜູ້ໃຊ້ທີ່ເຂົ້າຄິວທັງໝົດ.';
$string['privacy:metadata:registered'] = 'ປະກອບດ້ວຍຜູ້ໃຊ້ທີ່ລົງທະບຽນ ແລະ ຜູ້ໃຊ້ທີ່ຖືກໝາຍສໍາລັບການລົງທະບຽນ.';
$string['privacy:metadata:timestamp'] = 'ວັນທີທີ່ບັນທຶກໄດ້ຖືກດັດແກ້ຫຼ້າສຸດ.';
$string['privacy:metadata:userid'] = 'ຕົວລະບຸຂອງຜູ້ໃຊ້.';
$string['queue'] = 'ຄິວ';
$string['queue_and_multiple_reg_title'] = 'ຄິວ ແລະ ຫຼາຍການລົງທະບຽນ';
$string['queue_in_group'] = 'ດຳເນີນການເຂົ້າຄິວ <strong>{$a->username}</strong> ໃນກຸ່ມ <strong>{$a->groupname}</strong>?';
$string['queue_in_group_success'] = 'ເຂົ້າຄິວສຳເລັດແລ້ວ <strong>{$a->username}</strong> ໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['queue_you_in_group'] = 'ດຳເນີນການຈັດຄິວທ່ານເປັນກຸ່ມ <strong>{$a->groupname}</strong>?';
$string['queue_you_in_group_success'] = 'ຈັດຄິວທ່ານເປັນກຸ່ມສຳເລັດແລ້ວ <strong>{$a->groupname}</strong>!';
$string['queued'] = 'ເຂົ້າຄິວແລ້ວ';
$string['queued_in_group_info'] = '<strong>{$a->username}</strong> ເຂົ້າຄິວໃນກຸ່ມ <strong>{$a->groupname}</strong>';
$string['queued_on_rank'] = 'ເຂົ້າຄິວຢູ່ໃນອັນດັບ #{$a}';
$string['queueing_is'] = 'ການຈັດຄິວແມ່ນ';
$string['queues'] = 'ຄິວ';
$string['queues_max'] = 'ສະຖານທີ່ຄິວພ້ອມໆກັນສູງສຸດຕໍ່ຜູ້ເຂົ້າຮ່ວມ';
$string['queuesgrp'] = 'ຄິວ ແລະ ສະຖານທີ່ຄິວສູງສຸດ';
$string['queuesgrp_help'] = 'ຖ້າຄິວຖືກເປີດໃຊ້, ນັກຮຽນທີ່ພະຍາຍາມລົງທະບຽນໃນກຸ່ມເຕັມ, ໄດ້ຮັບການຈັດຄິວຈົນກ່ວາຜູ້ໃດຜູ້ໜຶ່ງຍົກເລີກການລົງທະບຽນຈາກກຸ່ມດຽວກັນ. ຫຼັງຈາກເສັ້ນຕາຍແລ້ວ, ຄູສອນມີຄວາມສາມາດທີ່ຈະຍ້າຍນັກຮຽນໄປຫາກຸ່ມອື່ນ ຖ້າພວກເຂົາຍັງຢູ່ໃນຄິວ, ບ່ອນທີ່ມີກຸ່ມເຕັມໄປໂດຍໃຊ້ຄໍາສັ່ງຈັດລຽງໃນປະຈຸບັນຂອງບັນຊີລາຍຊື່ກຸ່ມ. ທ່ານຄວນຈະກໍານົດຈໍານວນສູງສຸດຂອງກຸ່ມທີ່ຜູ້ໃຊ້ສາມາດເຂົ້າຄິວໄດ້.<br />ຈໍາກັດການເຂົ້າຄິວພ້ອມກັນສູງສຸດສໍາລັບແຕ່ລະຄົນໃນເຄື່ອງມືກຸ່ມນີ້.';
$string['queuesizeerror'] = 'ສະຖານທີ່ຄິວຕ້ອງໃຫຍ່ກວ່າ ຫຼື ເທົ່າກັບ 0. ບໍ່ອະນຸຍາດໃຫ້ມີຕົວອັກສອນ ຫຼື ເຄື່ອງໝາຍອື່ນໆ.';
$string['queuespresent'] = 'ມີຄິວແລ້ວ! ສິ່ງເຫຼົ່ານີ້ຈະຖືກລຶບຖ້າທ່ານສືບຕໍ່. ເພື່ອສືບຕໍ່ກົດປຸ່ມບັນທຶກອີກຄັ້ງ!';
$string['queuespresenterror'] = 'ມີລາຍຊື່ຜູ້ໃຊ້ຢູ່ໃນຄິວ. ທ່ານບໍ່ສາມາດປິດການເປີດຄິວໄດ້ຈົນກ່ວາການແກ້ໄຂເຫຼົ່ານີ້.';
$string['rank'] = 'ອັນດັບ';
$string['recreate_group'] = 'ສ້າງກຸ່ມຄືນໃໝ່';
$string['reference_grade_feedback'] = 'ຄະແນນອ້າງອີງ / ຄຳຕິຊົມ';
$string['refresh_table_button'] = 'ໂຫຼດການເບິ່ງຕົວຢ່າງຄືນໃໝ່';
$string['reg_in_full_group'] = 'ການລົງທະບຽນຂອງ <strong>{$a->username}</strong> ໃນກຸ່ມ <strong>{$a->groupname}</strong> ເປັນໄປບໍ່ໄດ້, ຍ້ອນກຸ່ມເຕັມ!';
$string['reg_not_open'] = 'ການລົງທະບຽນແມ່ນເປັນໄປບໍ່ໄດ້ໃນເວລານີ້. ບາງທີເສັ້ນຕາຍແມ່ນໝົດ ຫຼື ມັນບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ທັງໝົດ.';
$string['reg_you_in_full_group'] = 'ການລົງທະບຽນໃນກຸ່ມ <strong>{$a->groupname}</strong> ເປັນໄປບໍ່ໄດ້, ຍ້ອນກຸ່ມເຕັມ!';
$string['register'] = 'ລົງທະບຽນ';
$string['register_in_group'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລົງທະບຽນ <strong>{$a->username}</strong> ໃນກຸ່ມ <strong>{$a->groupname}</strong>?';
$string['register_in_group_success'] = 'ລົງທະບຽນ <strong>{$a->username}</strong> ໃນກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດແລ້ວ!';
$string['register_you_in_group'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລົງທະບຽນໃນກຸ່ມ <strong>{$a->groupname}</strong>?';
$string['register_you_in_group_success'] = 'ທ່ານໄດ້ລົງທະບຽນໃນກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດແລ້ວ!';
$string['register_you_in_group_successmail'] = 'ທ່ານໄດ້ລົງທະບຽນໃນກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດແລ້ວ!';
$string['register_you_in_group_successmailhtml'] = 'ທ່ານໄດ້ລົງທະບຽນໃນກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດແລ້ວ!';
$string['registered'] = 'ລົງທະບຽນແລ້ວ';
$string['registered_in_group_info'] = '{$a->username} ລົງທະບຽນແລ້ວໃນກຸ່ມ <strong>{$a->groupname}</strong>';
$string['registered_on_rank'] = 'ລົງທະບຽນແລ້ວໃນອັນດັບ #{$a}';
$string['registration_missing'] = 'ການລົງທະບຽນ 1 ສູນຫາຍ';
$string['registration_period_end'] = 'ສິ້ນສຸດການລົງທະບຽນສຳລັບ';
$string['registration_period_start'] = 'ເລີ່ມຕົ້ນການລົງທະບຽນສຳລັບ';
$string['registrationdue'] = 'ສິ້ນສຸດການລົງທະບຽນ';
$string['registrationnotification'] = '{$a->course->shortname} -> {$a->modulenameplural} -> {$a->grouptoolname}
----------------------------------------------------------
{$a->message}
----------------------------------------------------------';
$string['registrations'] = 'ການລົງທະບຽນກຸ່ມ';
$string['registrations_missing'] = 'ການລົງທະບຽນ {$a} ສູນຫາຍ';
$string['regpresent'] = 'ຜູ້ໃຊ້ແມ່ນ {$a} ແລ້ວ';
$string['rename_failed'] = 'ປ່ຽນຊື່ລົ້ມເຫຼວ!';
$string['renamed_group'] = 'ປ່ຽນຊື່ກຸ່ມ!';
$string['reset_agrps'] = 'ຕັ້ງຄ່າກຸ່ມເຄື່ອນໄຫວໃໝ່';
$string['reset_agrps_help'] = 'ຕັ້ງກຸ່ມຫຼັກສູດທັງໝົດຄືນໃໝ່ ໃຫ້ບໍ່ເຄື່ອນໄຫວສຳລັບເຄື່ອງມືກຸ່ມ. ນີ້ຈະເປັນການລຶບທຸກການລົງທະບຽນ ແລະ ຄິວໃນເຄື່ອງມືກຸ່ມຂອງລາຍວິຊານີ້!';
$string['reset_queues'] = 'ຕັ້ງຄ່າຄິວໃໝ່';
$string['reset_queues_help'] = 'ຄິວຈະຖືກລຶບໂດຍອັດຕະໂນມັດຖ້າກຸ່ມທີ່ເຄື່ອນໄຫວຖືກຕັ້ງຄືນໃໝ່.';
$string['reset_registrations'] = 'ຕັ້ງຄ່າການລົງທະບຽນໃໝ່';
$string['reset_registrations_help'] = 'ການລົງທະບຽນຈະຖືກລຶບໂດຍອັດຕະໂນມັດຖ້າກຸ່ມທີ່ເຄື່ອນໄຫວຖືກຕັ້ງຄືນໃໝ່.';
$string['reset_transparent_unreg'] = 'ຍົກເລີກການລົງທະບຽນສະມາຊິກກຸ່ມທີ່ຖືກກົດດັນທັງໝົດ';
$string['reset_transparent_unreg_help'] = 'ເອົາຜູ້ໃຊ້ທັງໝົດອອກຈາກກຸ່ມເຫຼົ່ານັ້ນ ທີ່ເປັນຕົວແທນໂດຍກຸ່ມເຄື່ອງມືກຸ່ມ (grouptool-groups) ທີ່ໃຊ້ວຽກ';
$string['resize'] = 'ປຽນຂະໜາດ';
$string['resized_group'] = 'ປ່ຽນຂະໜາດກຸ່ມ!';
$string['resolve_queue'] = 'ແກ້ໄຂຄິວ';
$string['resolve_queue_legend'] = 'ແກ້ໄຂຄິວ';
$string['resolve_queue_title'] = 'ແກ້ໄຂຄິວທີ່ຍັງຄ້າງ';
$string['search:activity'] = 'ເຄື່ອງມືກຸ່ມ - ຂໍ້ມູນກິດຈະກຳ';
$string['select'] = 'ເລືອກ';
$string['selected'] = 'ໄດ້ເລືອກ';
$string['selectfromcohort'] = 'ເລືອກສະມາຊິກຈາກກຸ່ມ';
$string['selectmultiple'] = 'ເລືອກຫຼາຍອັນ';
$string['selectsingle'] = 'ເລືອກອັນດຽວ';
$string['selfregistration'] = 'ການລົງທະບຽນ';
$string['selfregistration_alt'] = 'ລົງທະບຽນຫາໜຶ່ງ ຫຼື ສອງກຸ່ມ (ຂື້ນກັບການຕັ້ງຄ່າ)';
$string['setactive'] = 'ເຄື່ອນໄຫວ';
$string['setinactive'] = 'ຍົກເລີກການເຄື່ອນໄຫວ';
$string['show_members'] = 'ສະແດງສະມາຊິກກຸ່ມ';
$string['show_members_help'] = 'ເປີດໃຊ້ນັກຮຽນ (ໃນບາງກໍລະນີ) ເພື່ອເບິ່ງວ່າ ໃຜລົງທະບຽນຢູ່ໃນກຸ່ມແລ້ວ.<br />
<ul>
     <li><strong>ບໍ່:</strong> ຢ່າສະແດງສະມາຊິກຂອງກຸ່ມເລີຍ</li>
     <li><strong>ທັງໝົດ - ຫຼັງຈາກມື້ຄົບກຳນົດ:</strong> ສະແດງສະມາຊິກກຸ່ມສຳລັບທຸກກຸ່ມຫຼັງຈາກມື້ຄົບກຳນົດ</li>
     <li><strong>ເປັນເຈົ້າຂອງ - ຫຼັງຈາກຄົບກຳນົດ:</strong> ສະແດງສະມາຊິກກຸ່ມຂອງຜູ້ໃຊ້ເອງຫຼັງຈາກມື້ຄົບກຳນົດ</li>
     <li><strong>ເປັນເຈົ້າຂອງ - ຫຼັງຈາກການລົງທະບຽນ:</strong> ສະແດງສະມາຊິກກຸ່ມຂອງຜູ້ໃຊ້ເອງຫຼັງຈາກລົງທະບຽນຕົນເອງ ຫຼື ໄດ້ລົງທະບຽນໂດຍຜູ້ອື່ນ</li>
     <li><strong>ແມ່ນ:</strong> ສະແດງສະມາຊິກຂອງກຸ່ມ</li>
</ul>';
$string['showafterdue'] = 'ທັງໝົດ - ຫຼັງຈາກວັນຄົບກຳນົດ';
$string['showownafterdue'] = 'ເປັນເຈົ້າຂອງ - ຫຼັງຈາກວັນຄົບກຳນົດ';
$string['showownafterreg'] = 'ເປັນເຈົ້າຂອງ - ຫຼັງຈາກການລົງທະບຽນ';
$string['size'] = 'ຂະໜາດກຸ່ມ';
$string['size_grp'] = 'ການຕັ້ງຄ່າຂະໜາດກຸ່ມ';
$string['size_grp_help'] = 'ຖ້າຂະໜາດກຸ່ມຖືກເປີດໃຊ້ງານ, ສະມາຊິກສູງສຸດຂອງແຕ່ລະກຸ່ມຈະຖືກຈໍາກັດ (ກໍານົດສໍາລັບຕົວຢ່າງທັງໝົດຜ່ານຊ່ອງຂໍ້ຄວາມ). ຖ້ານອກຈາກນັ້ນ "ຂະໜາດສ່ວນບຸກຄົນ" ຖືກເປີດໃຊ້, ຂະໜາດກຸ່ມສໍາລັບແຕ່ລະກຸ່ມສາມາດຖືກກໍານົດໄວ້ໃນບັນຊີລາຍຊື່ຕໍ່ໄປນີ້.';
$string['skip_user_import'] = 'ຂ້າມເພື່ອນຳເຂົ້າ';
$string['skipped'] = 'ຂ້າມແລ້ວ';
$string['sortlist_no_data'] = 'ບໍ່ມີກຸ່ມທີ່ມີຢູ່ໃນປັດຈຸບັນ!';
$string['source'] = 'ແຫຼ່ງຂໍ້ມູນ';
$string['source_missing'] = 'ບໍ່ມີແຫຼ່ງຂໍ້ມູນໃຫ້ສຳເນົາຈາກ!';
$string['sources_missing'] = 'ມີຢ່າງໜ້ອຍກຸ່ມ 1 ທີ່ປາສະຈາກການເລືອກແຫຼ່ງຂໍ້ມູນເພື່ອສຳເນົາຈາກ!';
$string['start'] = 'ເລີ່ມ';
$string['status'] = 'ສະຖານະ';
$string['status_help'] = '<ul>
<li><strong>✔</strong> ລົງທະບຽນຢູ່ໃນກຸ່ມ Moodle-group ແລະ ເຄື່ອງມືກຸ່ມ (grouptool)</li>
<li><strong>?</strong> ລົງທະບຽນຢູ່ໃນກຸ່ມ Moodle-group ແຕ່ບໍ່ຢູ່ໃນເຄື່ອງມືກຸ່ມ (grouptool)</li>
<li><strong>+</strong> ລົງທະບຽນຢູ່ໃນ ເຄື່ອງມືກຸ່ມ ແຕ່ບໍ່ແມ່ນຢູ່ໃນກຸ່ມ Moodle</li>
<li><strong>1, 2, 3...</strong> ເຂົ້າຄິວໃນ grouptool</li>
</ul>';
$string['successfully_deleted_groups'] = 'ລຶບກຸ່ມສຳເລັດແລ້ວ!';
$string['swapped_groups'] = 'ແລກປ່ຽນກຸ່ມ <strong>{$a->a}</strong> (ຄຳສັ່ງ <strong>{$a->aorder}</strong>) ແລະ <strong>{$a->b}</strong> (ຄຳສັ່ງ <strong>{$a->border}</strong>)!';
$string['switched_to_all_groups'] = 'ປ່ຽນແປງຕົວກັ່ນຕອງກຸ່ມໄປຫາກຸ່ມທັງໝົດ!';
$string['target'] = 'ເປົ້າໝາຍ';
$string['too_many_queue_places'] = 'ບໍ່ສາມາດຕໍ່ຄິວ <strong>{$a->username}</strong> ໃນກຸ່ມ <strong>{$a->groupname}</strong> ເພາະວ່າ <strong>{$a->username}</strong> ແມ່ນ ເຂົ້າຄິວຫຼາຍກຸ່ມແລ້ວ!';
$string['too_many_regs'] = 'ຜູ້ໃຊ້ໄດ້ລົງທະບຽນ/ຄິວໃນກຸ່ມຫຼາຍເກີນໄປແລ້ວ!';
$string['toolessregspresent'] = 'ຢ່າງໜ້ອຍມີຜູ້ໃຊ້ 1 ຄົນລົງທະບຽນຢູ່ໃນກຸ່ມໜ້ອຍເກີນໄປ, ດັ່ງນັ້ນ ກຸ່ມຂັ້ນຕ່ຳທີ່ຈະເລືອກຈະຕ້ອງມີຢູ່ຫຼາຍສຸດ {$a}.';
$string['toomanyregs'] = 'ເອົາໃຈໃສ່: ໃນຢ່າງໜ້ອຍໜຶ່ງກຸ່ມມີສະມາຊິກກຸ່ມຫຼາຍກ່ວາລະບຸໄວ້ໂດຍຂະຫນາດກຸ່ມໃໝ່ທີ່ຕ້ອງການ.<br />ຫຼຸດຜ່ອນສະມາຊິກໃນກຸ່ມກ່ອນທີ່ຈະປ່ຽນຂະໜາດຂອງກຸ່ມ.';
$string['toomanyregspresent'] = 'ຢ່າງໜ້ອຍ 1 ຜູ້ໃຊ້ລົງທະບຽນຢູ່ໃນກຸ່ມຫຼາຍເກີນໄປ, ດັ່ງນັ້ນ ກຸ່ມສູງສຸດທີ່ຈະເລືອກຕ້ອງມີຢ່າງໜ້ອຍ {$a}.';
$string['total'] = 'ລວມທັງໝົດ';
$string['unqueue'] = 'ລຶບອອກຈາກຄິວ';
$string['unqueue_from_group'] = 'ສືບຕໍ່ລຶບ <strong>{$a->ຊື່ຜູ້ໃຊ້</strong> ອອກຈາກຄິວຂອງກຸ່ມ <strong>{$a->groupname}</strong> ບໍ?';
$string['unqueue_from_group_success'] = 'ລຶບ <strong>{$a->ຊື່ຜູ້ໃຊ້</strong> ອອກຈາກຄິວຂອງກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດແລ້ວ!';
$string['unqueue_you_from_group'] = 'ສືບຕໍ່ລຶບທ່ານອອກຈາກຄິວຂອງກຸ່ມ <strong>{$a->groupname}</strong> ບໍ?';
$string['unqueue_you_from_group_success'] = 'ລຶບທ່ານອອກຈາກຄິວຂອງກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດແລ້ວ!';
$string['unreg'] = 'ຍົກເລີກລົງທະບຽນ';
$string['unreg_from_group'] = 'ສືບຕໍ່ການຍົກເລີກລົງທະບຽນ <strong>{$a->username}</strong> ຈາກກຸ່ມ <strong>{$a->groupname}</strong> ບໍ?';
$string['unreg_from_group_success'] = 'ຍົກເລີກລົງທະບຽນ <strong>{$a->username}</strong> ຈາກກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດແລ້ວ!';
$string['unreg_is'] = 'ການຍົກເລີກການລົງທະບຽນ';
$string['unreg_not_allowed'] = 'ບໍ່ອະນຸຍາດການຍົກເລີກການລົງທະບຽນ';
$string['unreg_you_from_group'] = 'ສືບຕໍ່ຍົກເລີກການລົງທະບຽນສຳເລັດແລ້ວຈາກກຸ່ມ <strong>{$a->groupname}</strong>?';
$string['unreg_you_from_group_success'] = 'ຍົກເລີກການລົງທະບຽນຈາກກຸ່ມ <strong>{$a->groupname}</strong> ສຳເລັດແລ້ວ!!';
$string['unregfrommgroups'] = 'ບັງຄັບຍົກເລີກການລົງທະບຽນຈາກເຄື່ອງມືກຸ່ມ';
$string['unregfrommgroups_help'] = 'ຜູ້ໃຊ້ຍົກເລີກການລົງທະບຽນບໍ່ພຽງແຕ່ຈາກເຄື່ອງມືກຸ່ມເທົ່ານັ້ນ, ແຕ່ຍັງມາຈາກກຸ່ມ moodle-group.';
$string['unregister'] = 'ການຍົກເລີກການລົງທະບຽນ';
$string['unregister_conflict_user_not_in_group'] = 'ຜູ້ໃຊ້ <strong>{$a->fullname}</strong> ບໍ່ຢູ້ໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['unregister_desc'] = 'ຍົກເລີກລົງທະບຽນຜູ້ໃຊ້ຫຼາຍຄົນ';
$string['unregister_from_inactive_group_warning'] = 'ໝາຍເຫດ: ກຸ່ມ <strong>{$a}</strong> ປະຈຸບັນບໍ່ເຄື່ອນໄຫວໃນບໍລິບົດເຄື່ອງມືກຸ່ມ ແລະ ດັ່ງນັ້ນຈະບໍ່ຖືກສະແດງ.';
$string['unregister_in_inactive_group_warning'] = 'ໝາຍເຫດ: ກຸ່ມ <strong>{$a}</strong> ປະຈຸບັນບໍ່ເຄື່ອນໄຫວໃນບໍລິບົດເຄື່ອງມືກຸ່ມ ແລະ ດັ່ງນັ້ນຈະບໍ່ຖືກສະແດງ.';
$string['unregister_progress_completed'] = 'ສຳເລັດການຍົກເລີກການລົງທະບຽນແລ້ວ';
$string['unregister_progress_preview_completed'] = 'ສຳເລັດເບິ່ງຕົວຢ່າງການຍົກເລີກການລົງທະບຽນແລ້ວ';
$string['unregister_progress_start'] = 'ເລີ່ມການຍົກເລີກການລົງທະບຽນ';
$string['unregister_progress_unregister'] = 'ຜູ້ໃຊ້ຍົກເລີກການລົງທະບຽນ';
$string['unregister_skipped'] = 'ຂ້າມຜູ້ໃຊ້ <strong>{$a->fullname}</strong> ສຳລັບກຸ່ມ <strong>{$a->groupname}</strong> ແລ້ວ!';
$string['unregister_user'] = 'ສຳເລັດການຍົກເລີກການລົງທະບຽນຂອງ <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) ຈາກກຸ່ມ <strong>{$a->groupname}</strong> ແລ້ວ.';
$string['unregister_user_from_moodle_group'] = 'ສຳເລັດການຍົກເລີກການລົງທະບຽນຂອງ <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) ຈາກກຸ່ມ moodle <strong>{$a->groupname}</strong> ແລ້ວ.';
$string['unregister_user_not_in_group'] = 'ຜູ້ໃຊ້ <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) ບໍ່ຢູ່ໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['unregister_user_only_in_moodle_group'] = 'ຜູ້ໃຊ້ <strong>{$a->fullname}</strong> ແມ່ນຢູ່ໃນກຸ່ມ moodle <strong>{$a->groupname}</strong> ເທົ່ານັ້ນແຕ່ບໍ່ຢູ່ໃນກຸ່ມເຄື່ອງມືກຸ່ມ!';
$string['unregister_user_prev'] = 'ກຳລັງຍົກເລີກລົງທະບຽນ <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) ຈາກກຸ່ມ <strong>{$a->groupname}</strong>.';
$string['unregisterbutton'] = 'ຜູ້ໃຊ້ຍົກເລີກການລົງທະບຽນ';
$string['update_grouplist_success'] = 'ປັບປຸງກຸ່ມເຄື່ອນໄຫວສຳເລັດແລ້ວ!';
$string['updatemdlgrps'] = 'ລົງທະບຽນໃນກຸ່ມ moodle';
$string['uptodate'] = 'ຫຼ້າສຸດ';
$string['use_all_or_chosen'] = 'ຜູ້ໃຊ້ທັງໝົດ ຫຼື ເລືອກເອົາ';
$string['use_all_or_chosen_help'] = 'ເລືອກ "ທັງໝົດ" ເພື່ອສ້າງການຈັດກຸ່ມສຳລັບທຸກກຸ່ມລາຍວິຊາ. ນຳໃຊ້ "ທີ່ໄດ້ເລືອກ" ເພື່ອສ້າງການຈັດກຸ່ມສຳລັບກຸ່ມທີ່ໄດ້ກວດກາເທົ່ານັ້ນ.';
$string['use_individual'] = 'ໃຊ້ຂະໜາດສ່ວນບຸກຄົນຕໍ່ກຸ່ມ';
$string['use_individual_help'] = 'ລົບລ້າງຂະໜາດກຸ່ມທົ່ວໂລກດ້ວຍຄ່າສ່ວນບຸກຄົນສຳລັບແຕ່ລະກຸ່ມ. ສິ່ງເຫຼົ່ານີ້ໄດ້ຮັບການກໍານົດໂດຍຜ່ານບັນຊີລາຍຊື່ກຸ່ມຈັດລຽງຢູ່ທາງລຸ່ມ.';
$string['use_queue'] = 'ນຳໃຊ້ຄິວ';
$string['use_queue_help'] = 'ນັກຮຽນສາມາດເຂົ້າຄິວສໍາລັບກຸ່ມເຕັມແລ້ວ. ການຕັ້ງຄ່ານີ້ສາມາດຖືກນໍາໃຊ້ພຽງແຕ່ຖ້າການລົງທະບຽນດ້ວຍຕົນເອງຖືກເປີດໃຊ້ງານ ແລະ ກໍານົດຂອບເຂດຈໍາກັດຂະໜາດກຸ່ມ.';
$string['use_size'] = 'ເປີດໃຊ້';
$string['user_has_too_less_regs'] = 'ການຍົກເລີກການລົງທະບຽນ/ຍົກເລີກເຂົ້າຄິວເປັນໄປບໍ່ໄດ້ຍ້ອນວ່າ <strong>{$a->username}</strong> ໄດ້ລົງທະບຽນ/ເຂົ້າຄິວໃນກຸ່ມທີ່ນ້ອຍເກີນໄປ!';
$string['user_is_deleted'] = 'ພົບບັນຊີຜູ້ໃຊ້ (ລະຫັດປະຈຳຕົວ <strong>{$a->id}</strong>, ຊື່ <strong>{$a->fullname}</strong>) ແມ່ນໄດ້ລຶບແລ້ວ. ດັ່ງນັ້ນ ການລົງທະບຽນໃນລາຍວິຊານີ້ ແມ່ນເປັນໄປບໍ່ໄດ້.';
$string['user_move_prev'] = '<strong>{$a->user}</strong> ຈະຖືກຍ້າຍຈາກຄິວຂອງກຸ່ມ <strong>{$a->from_group}</strong> ໄປຫາກຸ່ມ <strong>{$a->to_group}</strong>!';
$string['user_moved'] = '<strong>{$a->user}</strong> ຖືກຍ້າຍຈາກຄິວຂອງກຸ່ມ <strong>{$a->from_group}</strong> ໄປຫາກຸ່ມ <strong>{$a->to_group}</strong>!';
$string['user_not_found'] = 'ບໍ່ສາມາດພົບຜູ້ໃຊ້ <strong>{$a}</strong>!';
$string['userlist'] = 'ລາຍການຜູ້ໃຊ້';
$string['userlist_alt'] = 'ເບິ່ງລາຍຊື່ຜູ້ໃຊ້ ແລະ ການລົງທະບຽນຂອງພວກເຂົາ. ສົ່ງອອກຂໍ້ມູນກ່ຽວກັບຜູ້ໃຊ້ ແລະ ກຸ່ມຂອງພວກເຂົາໃນຮູບແບບຕ່າງໆ (PDF, ຂໍ້ຄວາມທໍາມະດາ, Excel, ແລະອື່ນໆ).';
$string['userlist_help'] = 'ບັນຊີລາຍຊື່ຂອງຕົວເລກປະຈໍາຕົວທີ່ແຍກອອກໂດຍໜຶ່ງ ຫຼື ຫຼາຍຕົວອັກສອນຕໍ່ໄປນີ້ <ul><li>[,] ໝາຍຈຸດ</li><li>[;] ຈ້ຳຈຸດ</li><li>[ ] ຍະຫວ່າງ</li><li>[\\n] ລົງເແຖວ</li><li>[\\r] ສົ່ງກັບ</li><li>[\\t] ຕາຕະລາງ</li></ul>';
$string['userlist_tab'] = 'ເບິ່ງລາຍວິຊາ';
$string['userlist_tab_alt'] = 'ເປີດເບິ່ງລາຍວິຊາ';
$string['users_queues_limit'] = 'ສະຖານທີ່ຄິວຕໍ່ຜູ້ໃຊ້';
$string['users_queues_limit_help'] = 'ຈໍາກັດສະຖານທີ່ຄິວທີ່ມີໃຫ້ຕໍ່ຜູ້ໃຊ້ຖ້າເປີດໃຊ້';
$string['users_tab'] = 'ຜູ້ເຂົ້າຮ່ວມ';
$string['users_tab_alt'] = 'ສະແດງຜູ້ເຂົ້າຮ່ວມ';
$string['view_registrations'] = 'ເບິ່ງການລົງທະບຽນ';
$string['viewmoodlegroups'] = 'ໄປຫາກຸ່ມ Moodle';
$string['with_selection'] = 'ດ້ວຍການເລືອກ...';
$string['you_are_already_marked'] = 'ທ່ານໄດ້ໝາຍກຸ່ມ <strong>{$a->groupname}</strong> ແລ້ວສຳລັບການລົງທະບຽນ!';
$string['you_are_already_queued'] = 'ທ່ານໄດ້ເຂົ້າຄິວແລ້ວໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['you_are_already_registered'] = 'ທ່ານໄດ້ລົງທະບຽນແລ້ວໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['you_are_not_in_queue_or_registered'] = 'ທ່ານບໍ່ໄດ້ລົງທະບຽນ ຫຼື ຈັດຄິວຢູ່ໃນກຸ່ມ <strong>{$a->groupname}</strong>';
$string['you_change_group_to_success'] = 'ການປ່ຽນແປງກຸ່ມສຳເລັດແລ້ວ! ດຽວນີ້ທ່ານໄດ້ລົງທະບຽນຢູ່ໃນກຸ່ມ <strong>{$a->groupname}</strong>!';
$string['you_have_too_less_regs'] = 'ບໍ່ສາມາດຍົກເລີກການລົງທະບຽນ/ຈັດຄິວໄດ້ ເພາະວ່າ ທ່ານລົງທະບຽນ/ຈັດຄິວຢູ່ໃນກຸ່ມໜ້ອຍເກີນໄປ!';
$string['you_have_too_many_queue_places'] = 'ບໍ່ສາມາດຈັດຄິວທ່ານຢູ່ໃນກຸ່ມ <strong>{$a->groupname}</strong> ໄດ້ເພາະວ່າ ທ່ານໄດ້ເຂົ້າຄິວຢູ່ໃນກຸ່ມຫຼາຍເກີນໄປ!';
$string['your_place_allocated_in_group_success'] = 'ທ່ານໄດ້ສຳເລັດການໝາຍກຸ່ມ <strong>{$a->groupname}</strong> ສຳລັບການລົງທະບຽນ';
